import { Construct } from '@aws-cdk/core';
/**
 * This obtains the PrefixLisId for the AWS-Managed prefix list of the S3
 * service in the stack's current region.
 */
export declare class S3PrefixList extends Construct {
    /**
     * The ID of the AWS-managed Prefix List for AWS S3 in the current region.
     */
    readonly prefixListId: string;
    /**
     * The name of the AWS-managed Prefix List for AWS S3 in the current region.
     */
    readonly prefixListName: string;
    constructor(scope: Construct, id: string);
}
