/// <reference types="node" />
/**
 * Executes the specified command in a sub-shell, and asserts success.
 */
export declare function shellOut(cmd: string, ...args: readonly string[]): Promise<void>;
/**
 * Executes the specified command in a sub-shell. Instead of asserting success,
 * this captures all data sent to `STDOUT` and returns that, with the command's
 * exit code or signal.
 */
export declare function shellOutWithOutput(cmd: string, ...args: readonly string[]): Promise<ShellOutResult>;
export interface ShellOutResult {
    readonly exitCode: number | null;
    readonly signal: NodeJS.Signals | null;
    readonly stdout: Buffer;
}
