"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.integrity = void 0;
const crypto_1 = require("crypto");
/**
 * Computes an integrity checksum for the provided `IngestionInput`.
 *
 * @param input   the `IngestionInput` for which to make a checksum.
 * @param tarball the content of the `.tgz` npm package
 * @param alg     the hash algorithm to use (e.g: 'sha384')
 *
 * @returns the computed checksum.
 */
function integrity(input, tarball, alg) {
    var _a, _b, _c;
    if (alg === void 0) { alg = (_b = (_a = input.integrity) === null || _a === void 0 ? void 0 : _a.split('-')[0]) !== null && _b !== void 0 ? _b : 'sha384'; }
    const hash = crypto_1.createHash(alg);
    const addField = (name, data) => 
    //           <SOH>        $name          <STX>        $data          <ETX>
    hash.update('\x01').update(name).update('\x02').update(data).update('\x03');
    for (const [name, value] of Object.entries((_c = input.metadata) !== null && _c !== void 0 ? _c : {}).sort(([l], [r]) => l.localeCompare(r))) {
        addField(`metadata/${name}`, value);
    }
    addField('tarball', tarball);
    addField('time', input.time);
    return {
        ...input,
        integrity: `${alg}-${hash.digest('base64')}`,
    };
}
exports.integrity = integrity;
//# sourceMappingURL=data:application/json;base64,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