import click
import prismacloud.api as pc_lib
from prismacloud.cli import pass_environment, cli_output
import logging

@click.group("policies", short_help="[CWPP] Retrieve policies for the resources protected by Prisma Cloud")

@pass_environment
def cli(ctx):
    pass

@click.command()
@click.option('--field', default='')
def runtimecontainer(field=''):
    result = pc_lib.get_endpoint("policies/runtime/container")

    if field == '':
        cli_output(result)
    else:
        # We have field as input to select a deeper level of data. 
        # Our main result returns data on the query and the results are in one of the main field.
        # This option gives the ability to retrieve that data.
        field_path = field.split(".")
        for field in field_path:
            result = result[field]

        cli_output(result)

cli.add_command(runtimecontainer)
