"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const vm = require("vm");
const inventory_1 = require("./inventory");
const render_options_1 = require("./javascript/render-options");
const option_hints_1 = require("./option-hints");
/**
 * Programmatic API for projen.
 */
class Projects {
    constructor() { }
    /**
     * Creates a new project with defaults.
     *
     * This function creates the project type in-process (with in VM) and calls
     * `.synth()` on it (if `options.synth` is not `false`).
     *
     * At the moment, it also generates a `.projenrc.js` file with the same code
     * that was just executed. In the future, this will also be done by the project
     * type, so we can easily support multiple languages of projenrc.
     *
     * An environment variable (PROJEN_CREATE_PROJECT=true) is set within the VM
     * so that custom project types can detect whether the current synthesis is the
     * result of a new project creation (and take additional steps accordingly)
     */
    static createProject(options) {
        createProject(options);
    }
}
exports.Projects = Projects;
_a = JSII_RTTI_SYMBOL_1;
Projects[_a] = { fqn: "projen.Projects", version: "0.67.0" };
function createProject(opts) {
    const projectType = inventory_1.resolveProjectType(opts.projectFqn);
    // Default project resolution location
    let mod = "./index";
    // External projects need to load the module from the modules directory
    if (projectType.moduleName !== "projen") {
        try {
            mod = path.dirname(require.resolve(path.join(projectType.moduleName, "package.json"), {
                paths: [process.cwd()],
            }));
        }
        catch (err) {
            throw new Error(`External project module '${projectType.moduleName}' could not be resolved.`);
        }
    }
    // "dir" is exposed as a top-level option to require users to specify a value for it
    opts.projectOptions.outdir = opts.dir;
    // pass the FQN of the project type to the project initializer so it can
    // generate the projenrc file.
    const { renderedOptions } = render_options_1.renderJavaScriptOptions({
        bootstrap: true,
        comments: opts.optionHints ?? option_hints_1.InitProjectOptionHints.FEATURED,
        type: projectType,
        args: opts.projectOptions,
        omitFromBootstrap: ["outdir"],
    });
    // generate a random variable name because jest tests appear to share
    // VM contexts, causing
    //
    // > SyntaxError: Identifier 'project' has already been declared
    //
    // errors if this isn't unique
    const varName = "project" + Math.random().toString(36).slice(2);
    const initProjectCode = `const ${varName} = new ${projectType.typename}(${renderedOptions});`;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const module = require(mod);
    const ctx = vm.createContext(module);
    const synth = opts.synth ?? true;
    const postSynth = opts.post ?? true;
    process.env.PROJEN_DISABLE_POST = (!postSynth).toString();
    process.env.PROJEN_CREATE_PROJECT = "true";
    vm.runInContext([initProjectCode, synth ? `${varName}.synth();` : ""].join("\n"), ctx);
}
//# sourceMappingURL=data:application/json;base64,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