import { NodePackageManager } from "./node-package";
export declare function renderBundleName(entrypoint: string): string;
/**
 * Regex for AWS CodeArtifact registry
 */
export declare const codeArtifactRegex: RegExp;
/**
 * gets AWS details from the Code Artifact registry URL
 * throws exception if not matching expected pattern
 * @param registryUrl Code Artifact registry URL
 * @returns object containing the (domain, accountId, region, repository)
 */
export declare function extractCodeArtifactDetails(registryUrl: string): {
    domain: string;
    accountId: string;
    region: string;
    repository: string;
    registry: string;
};
export declare function minVersion(version: string): string | undefined;
export declare function packageResolutionsFieldName(packageManager?: NodePackageManager): "overrides" | "pnpm.overrides" | "resolutions";
