"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
/**
 * Auto approve pull requests that meet a criteria
 */
class AutoApprove extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.label = options.label ?? "auto-approve";
        const usernames = options.allowedUsernames ?? ["github-actions[bot]"];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += " && (";
            condition += usernames
                .map((u) => `github.event.pull_request.user.login == '${u}'`)
                .join(" || ");
            condition += ")";
        }
        const secret = options.secret ?? "GITHUB_TOKEN";
        const approveJob = {
            runsOn: options.runsOn ?? ["ubuntu-latest"],
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [
                {
                    uses: "hmarr/auto-approve-action@v2.2.1",
                    with: {
                        "github-token": `\${{ secrets.${secret} }}`,
                    },
                },
            ],
        };
        const workflow = github.addWorkflow("auto-approve");
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: [
                    "labeled",
                    "opened",
                    "synchronize",
                    "reopened",
                    "ready_for_review",
                ],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.67.0" };
//# sourceMappingURL=data:application/json;base64,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