"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_js_1 = require("./awscdk-deps-js");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * AWS CDK construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    constructor(options) {
        const cdkMajorVersion = semver.parse(options.cdkVersion)?.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1
                ? {
                    pinnedDevDependency: false,
                }
                : undefined,
            workflowContainerImage: determineWorkflowContainerImage(options, cdkMajorVersion),
            ...options,
        });
        this.cdkDeps = new awscdk_deps_js_1.AwsCdkDepsJs(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        new auto_discover_1.AutoDiscover(this, {
            srcdir: this.srcdir,
            testdir: this.testdir,
            lambdaOptions: options.lambdaOptions,
            tsconfigPath: this.tsconfigDev.fileName,
            cdkDeps: this.cdkDeps,
            lambdaAutoDiscover: options.lambdaAutoDiscover ?? true,
            edgeLambdaAutoDiscover: options.edgeLambdaAutoDiscover ?? true,
            lambdaExtensionAutoDiscover: options.lambdaExtensionAutoDiscover ?? true,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
    }
    /**
     * The target CDK version for this library.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.67.0" };
function determineWorkflowContainerImage(options, cdkMajorVersion) {
    // if the user specifies the workflow container image explicitly, use that
    if (options.workflowContainerImage) {
        return options.workflowContainerImage;
    }
    // if the user specifies minimum node version, then JsiiProject will take care of
    // determining the workflow container image from that, so we return "undefined"
    if (options.minNodeVersion) {
        return undefined;
    }
    // otherwise, choose a workflow container image based on the CDK version
    if (cdkMajorVersion === 1) {
        return "jsii/superchain:1-buster-slim";
    }
    if (cdkMajorVersion === 2) {
        return "jsii/superchain:1-buster-slim-node14";
    }
    return undefined;
}
/** @deprecated use `AwsCdkConstructLibrary` */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.67.0" };
//# sourceMappingURL=data:application/json;base64,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