"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkJavaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const awscdk_deps_java_1 = require("./awscdk-deps-java");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
const __1 = require("..");
const java_1 = require("../java");
/**
 * AWS CDK app in Java.
 *
 * @pjid awscdk-app-java
 */
class AwsCdkJavaApp extends java_1.JavaProject {
    constructor(options) {
        const mainClassComponents = options.mainClass.split(".");
        const mainPackage = mainClassComponents.slice(0, -1);
        const mainClassName = mainClassComponents[mainClassComponents.length - 1];
        super({
            ...options,
            sample: false,
            sampleJavaPackage: mainPackage.join("."),
        });
        this.mainClass = options.mainClass;
        this.mainPackage = mainPackage.join(".");
        this.mainClassName = mainClassName;
        this.cdkDeps = new awscdk_deps_java_1.AwsCdkDepsJava(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `mvn exec:java --quiet -Dexec.mainClass=${this.mainClass}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            ...options,
        });
        if (options.sample ?? true) {
            this.addSample();
        }
    }
    /**
     * Adds an AWS CDK module dependencies
     *
     * @param modules The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc)
     * @deprecated In CDK 2.x all modules are available by default. Alpha modules should be added using the standard 'deps'
     */
    addCdkDependency(...modules) {
        for (const m of modules) {
            this.cdkDeps.addV1Dependencies(m);
        }
    }
    addSample() {
        const pkg = this.mainPackage.split(".");
        const javaFile = `${this.mainClassName}.java`;
        new __1.SampleDir(this, path_1.join("src", "main", "java", ...pkg), {
            files: {
                [javaFile]: [
                    `package ${pkg.join(".")};`,
                    "",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.App;"
                        : "import software.amazon.awscdk.App;",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.Stack;"
                        : "import software.amazon.awscdk.Stack;",
                    "",
                    `public class ${this.mainClassName} {`,
                    "  public static void main(final String[] args) {",
                    "    App app = new App();",
                    `    new Stack(app, "${this.name}");`,
                    "    app.synth();",
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.AwsCdkJavaApp = AwsCdkJavaApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkJavaApp[_a] = { fqn: "projen.awscdk.AwsCdkJavaApp", version: "0.67.0" };
//# sourceMappingURL=data:application/json;base64,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