import { ConcreteWidget } from '@aws-cdk/aws-cloudwatch';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
export interface PackageVersionsTableWidgetProps {
    readonly bucket: IBucket;
    readonly key: string;
    readonly description?: string;
    readonly title?: string;
    readonly width?: number;
    readonly height?: number;
}
export declare class PackageVersionsTableWidget extends ConcreteWidget {
    private readonly handler;
    private readonly key;
    private readonly description?;
    private readonly title?;
    constructor(scope: Construct, id: string, props: PackageVersionsTableWidgetProps);
    toJson(): {
        type: string;
        width: number;
        height: number;
        x: number | undefined;
        y: number | undefined;
        properties: {
            endpoint: string;
            params: {
                key: string;
                description: string;
            };
            title: string | undefined;
            updateOn: {
                refresh: boolean;
                resize: boolean;
                timeRange: boolean;
            };
        };
    }[];
}
