import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as cdk from '@aws-cdk/core';
/**
 * The interface for all wordpress.
 *
 * @stability stable
 */
export interface WordPressProps {
    /**
     * The WordPress VPC.
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The WordPress RDS.
     *
     * @stability stable
     */
    readonly rdsInstance?: rds.DatabaseInstance;
    /**
     * The WordPress cluster.
     *
     * @stability stable
     */
    readonly cluster?: ecs.Cluster;
}
/**
 * @stability stable
 */
export declare class WordPress extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly endpoint: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: WordPressProps);
}
