# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['scimap',
 'scimap.plotting',
 'scimap.preprocessing',
 'scimap.tests',
 'scimap.tools']

package_data = \
{'': ['*'], 'scimap.tests': ['_data/*']}

install_requires = \
['anndata>=0.7.3,<0.8.0',
 'matplotlib>=3.2.1,<4.0.0',
 'napari>=0.3.4,<0.4.0',
 'numpy>=1.18.5,<2.0.0',
 'pandas>=1.0.4,<2.0.0',
 'pytest>=5.4.3,<6.0.0',
 'scipy>=1.4.1,<2.0.0',
 'seaborn>=0.10.1,<0.11.0',
 'sklearn>=0.0,<0.1',
 'tifffile>=2020.6.3,<2021.0.0']

entry_points = \
{'console_scripts': ['scimap = scimap.cli:main']}

setup_kwargs = {
    'name': 'scimap',
    'version': '0.0.9',
    'description': 'Single-Cell Image Analysis Package',
    'long_description': '# Single-Cell Image Analysis Package\n\nScimap is a scalable toolkit for analyzing single-cell imaging data using anndata data structuring framework. \nIt includes preprocessing, visualization, clustering, spatial analysis and differential expression testing. \nThe Python-based implementation efficiently deals with datasets of more than one million cells.\n\n\n[![Unix Build Status](https://img.shields.io/travis/ajitjohnson/scimap/master.svg?label=unix)](https://travis-ci.org/ajitjohnson/scimap)\n[![Windows Build Status](https://img.shields.io/appveyor/ci/ajitjohnson/scimap/master.svg?label=windows)](https://ci.appveyor.com/project/ajitjohnson/scimap)\n[![Coverage Status](https://img.shields.io/coveralls/ajitjohnson/scimap/master.svg)](https://coveralls.io/r/ajitjohnson/scimap)\n[![Documentation Status](https://readthedocs.org/projects/scimap-doc/badge/?version=latest)](https://scimap-doc.readthedocs.io/en/latest/?badge=latest)\n[![Scrutinizer Code Quality](https://img.shields.io/scrutinizer/g/ajitjohnson/scimap.svg)](https://scrutinizer-ci.com/g/ajitjohnson/scimap/?branch=master)\n[![PyPI Version](https://img.shields.io/pypi/v/scimap.svg)](https://pypi.org/project/scimap)\n[![PyPI License](https://img.shields.io/pypi/l/scimap.svg)](https://pypi.org/project/scimap)\n\n# Setup\n\n## Requirements\n\n* Python 3.7+\n\n## Installation\n\nInstall it directly into an activated virtual environment:\n\n```text\n$ pip install scimap\n```\n\n# Usage\n\nAfter installation, the package can imported:\n\n```text\n$ python\n>>> import scimap\n>>> scimap.__version__\n```',
    'author': 'Ajit Johnson Nirmal',
    'author_email': 'ajitjohnson.n@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pypi.org/project/scimap',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
