# Single-Cell Image Analysis Package

Scimap is a scalable toolkit for analyzing single-cell imaging data using anndata data structuring framework. 
It includes preprocessing, visualization, clustering, spatial analysis and differential expression testing. 
The Python-based implementation efficiently deals with datasets of more than one million cells.


[![Unix Build Status](https://img.shields.io/travis/ajitjohnson/scimap/master.svg?label=unix)](https://travis-ci.org/ajitjohnson/scimap)
[![Windows Build Status](https://img.shields.io/appveyor/ci/ajitjohnson/scimap/master.svg?label=windows)](https://ci.appveyor.com/project/ajitjohnson/scimap)
[![Coverage Status](https://img.shields.io/coveralls/ajitjohnson/scimap/master.svg)](https://coveralls.io/r/ajitjohnson/scimap)
[![Documentation Status](https://readthedocs.org/projects/scimap-doc/badge/?version=latest)](https://scimap-doc.readthedocs.io/en/latest/?badge=latest)
[![Scrutinizer Code Quality](https://img.shields.io/scrutinizer/g/ajitjohnson/scimap.svg)](https://scrutinizer-ci.com/g/ajitjohnson/scimap/?branch=master)
[![PyPI Version](https://img.shields.io/pypi/v/scimap.svg)](https://pypi.org/project/scimap)
[![PyPI License](https://img.shields.io/pypi/l/scimap.svg)](https://pypi.org/project/scimap)

# Setup

## Requirements

* Python 3.7+

## Installation

Install it directly into an activated virtual environment:

```text
$ pip install scimap
```

# Usage

After installation, the package can imported:

```text
$ python
>>> import scimap
>>> scimap.__version__
```