# -*- coding: utf-8 -*-
"""
    proxy.py
    ~~~~~~~~
    ⚡⚡⚡ Fast, Lightweight, Pluggable, TLS interception capable proxy server focused on
    Network monitoring, controls & Application development, testing, debugging.

    :copyright: (c) 2013-present by Abhinav Singh and contributors.
    :license: BSD, see LICENSE for more details.

    .. spelling::

       http
       Submodules
"""
from .base import HttpProtocolException
from .http_request_rejected import HttpRequestRejected
from .proxy_auth_failed import ProxyAuthenticationFailed
from .proxy_conn_failed import ProxyConnectionFailed

__all__ = [
    'HttpProtocolException',
    'HttpRequestRejected',
    'ProxyAuthenticationFailed',
    'ProxyConnectionFailed',
]
