#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""Constants for config commands"""

AUTHENTICATION_LIST = [
    {
        "name": "refresh_token",
        "desc": "Provide a refresh token that is used to get an access token",
    },
    {"name": "msal_interactive", "desc": "Azure interactive authentication."},
]

MSG_INTRO = (
    "\nWelcome to the OSDU CLI! This command will guide you through "
    "setting some default values.\n"
)
MSG_CLOSING = (
    "\nYou're all set! Here are some commands to try:\n $ osdu status\n $ osdu list records\n"
)

MSG_GLOBAL_SETTINGS_LOCATION = "Your settings can be found at {}"

MSG_HEADING_CURRENT_CONFIG_INFO = "Your current configuration is as follows:"
MSG_HEADING_ENV_VARS = "\nEnvironment variables:"

MSG_PROMPT_CONFIG = "\nWhat config file do you want to use as the default?"
MSG_PROMPT_MANAGE_GLOBAL = "\nDo you wish to change your settings?"
MSG_PROMPT_SERVER = "\nOSDU API Server []: "
MSG_PROMPT_CONFIG_ENTITLEMENTS_URL = "\nEntitlements API path []: "
MSG_PROMPT_FILE_URL = "\nFile API path []: "
MSG_PROMPT_LEGAL_URL = "\nLegal API path []: "
MSG_PROMPT_SCHEMA_URL = "\nSchema API path []: "
MSG_PROMPT_SEARCH_URL = "\nSearch API path []: "
MSG_PROMPT_STORAGE_URL = "\nStorage API path []: "
MSG_PROMPT_UNIT_URL = "\nUnit API path []: "
MSG_PROMPT_WORKFLOW_URL = "\nWorkflow API path []: "

MSG_PROMPT_DATA_PARTITION = "\nData partition name []: "
MSG_PROMPT_LEGAL_TAG = "\nManifest legal tag []: "
MSG_PROMPT_ACL_VIEWER = "\nacl viewer []: "
MSG_PROMPT_ACL_OWNER = "\nacl owner []: "

MSG_PROMPT_AUTHENTICATION_MODE = "\nHow will you authenticate?"
MSG_PROMPT_AUTHORITY = "\nAuthority []: "
MSG_PROMPT_SCOPES = "\nScopes []: "
MSG_PROMPT_TOKEN_ENDPOINT_URL = "\nAuthentication token endpoint url []: "
MSG_PROMPT_REFRESH_TOKEN = "\nRefresh token []: "
MSG_PROMPT_CLIENT_ID = "\nClient id []: "
MSG_PROMPT_CLIENT_SECRET = "\nClient secret []: "
