/**
 * An entry in the construct metadata table.
 *
 * @stability stable
 */
export interface MetadataEntry {
    /**
     * The metadata entry type.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * The data.
     *
     * @stability stable
     */
    readonly data: any;
    /**
     * Stack trace at the point of adding the metadata.
     *
     * Only available if `addMetadata()` is called with `stackTrace: true`.
     *
     * @default - no trace information
     * @stability stable
     */
    readonly trace?: string[];
}
