<h1 align="center">
	<img width="300" src="https://uploads-ssl.webflow.com/5dff758010bfa7f94c98e37e/5e9b0ff61b847f206e4c8da8_askdata-logo-black-p-500.png" alt="Askdata">
	<br>
	<br>
</h1>
 
# Askdata Examples
[![Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github//AskdataHQ/askdata-docs/blob/gh-pages/notebooks/Askdata%20-%20Quickstart.ipynb)
This repository contains examples of [Askdata](https://www.askdata.com/) usage in serving different types of data.
## Installation
``
 pip install askdata 
``
or
``
pip install -r requirements.txt
``
## Authentication
Lets handle our authenticaton
```python
from askdata import Askdata
askdata = Askdata()
```
Once your insert your account and password you're all set
## Query your data
```python
#get one agent
df = askdata.get("sales by countries", workspace="sales_demo")
df
```
## Creating a new dataset starting from a Dataframe in an existing Workspace
```python
# Load the list of the agents connected to your account as a pandas dataframe
askdata.save(df, dataset_name='My Dataset Name',workspace="my_workspace")
```
## Askdata Demo
Check the following tutorial, to learn more about Askdata end-to-end. 
[![Askdata Tutorial](https://img.youtube.com/vi/uEc9ogi2-10/0.jpg)](https://youtu.be/uEc9ogi2-10) 
