"""
    Sample metadata API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.6.8
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sample_metadata.api_client import ApiClient, Endpoint as _Endpoint
from sample_metadata.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
    async_wrap
)
from sample_metadata.model.http_validation_error import HTTPValidationError


class ImportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.import_airtable_manifest_async = async_wrap(self.import_airtable_manifest)
        self.import_airtable_manifest_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/import/{project}/airtable-manifest',
                'operation_id': 'import_airtable_manifest',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'file',
                ],
                'required': [
                    'project',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'file':
                        (file_type,),
                },
                'attribute_map': {
                    'project': 'project',
                    'file': 'file',
                },
                'location_map': {
                    'project': 'path',
                    'file': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

        self.import_individual_metadata_manifest_async = async_wrap(self.import_individual_metadata_manifest)
        self.import_individual_metadata_manifest_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/import/{project}/individual-metadata-manifest',
                'operation_id': 'import_individual_metadata_manifest',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'file',
                    'delimiter',
                    'extra_participants_method',
                ],
                'required': [
                    'project',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'file':
                        (file_type,),
                    'delimiter':
                        (str,),
                    'extra_participants_method':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'project': 'project',
                    'file': 'file',
                    'delimiter': 'delimiter',
                    'extra_participants_method': 'extra_participants_method',
                },
                'location_map': {
                    'project': 'path',
                    'file': 'form',
                    'delimiter': 'query',
                    'extra_participants_method': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def import_airtable_manifest(
        self,
        project,
        file,
        **kwargs
    ):
        """Import Airtable Manifest  # noqa: E501

        Import CSV from airtable  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_airtable_manifest(project, file, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            file (file_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['file'] = \
            file
        return self.import_airtable_manifest_endpoint.call_with_http_info(**kwargs)

    def import_individual_metadata_manifest(
        self,
        project,
        file,
        **kwargs
    ):
        """Import Individual Metadata Manifest  # noqa: E501

        Import individual metadata manifest  :param extra_participants_method: If extra participants are in the uploaded file,     add a PARTICIPANT entry for them  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_individual_metadata_manifest(project, file, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            file (file_type):

        Keyword Args:
            delimiter (str): [optional]
            extra_participants_method (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['file'] = \
            file
        return self.import_individual_metadata_manifest_endpoint.call_with_http_info(**kwargs)

