"""Create Schedule Table [d7b3acf9aa46].

Revision ID: d7b3acf9aa46
Revises: 3c5a367730c2
Create Date: 2022-11-17 22:44:16.301910

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "d7b3acf9aa46"
down_revision = "3c5a367730c2"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "schedule",
        sa.Column("project_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("pipeline_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column(
            "orchestrator_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=False),
        sa.Column(
            "cron_expression",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=True,
        ),
        sa.Column("start_time", sa.DateTime(), nullable=True),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column("interval_second", sa.Float(), nullable=True),
        sa.Column("catchup", sa.Boolean(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pipeline_id"],
            ["pipeline.id"],
            name="fk_schedule_pipeline_id_pipeline",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["orchestrator_id"],
            ["stack_component.id"],
            name="fk_schedule_orchestrator_id_stack_component",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["workspace.id"],
            name="fk_schedule_project_id_workspace",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_schedule_user_id_user",
            ondelete="SET NULL",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "schedule_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
            )
        )
        batch_op.create_foreign_key(
            "fk_pipeline_run_schedule_id_schedule",
            "schedule",
            ["schedule_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_pipeline_run_schedule_id_schedule", type_="foreignkey"
        )
        batch_op.drop_column("schedule_id")

    op.drop_table("schedule")
    # ### end Alembic commands ###
