"""Add Caching Info [6a28c4fd0ef2].

Revision ID: 6a28c4fd0ef2
Revises: 26b776ad583e
Create Date: 2022-11-22 12:59:26.081411

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "6a28c4fd0ef2"
down_revision = "26b776ad583e"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("enable_cache", sa.Boolean(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("start_time", sa.DateTime(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("end_time", sa.DateTime(), nullable=True)
        )

    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("caching_parameters", sa.TEXT(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("enable_cache", sa.Boolean(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "code_hash", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "cache_key", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column("start_time", sa.DateTime(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("end_time", sa.DateTime(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "original_step_run_id",
                sqlmodel.sql.sqltypes.GUID(),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            "fk_step_run_original_step_run_id_step_run",
            "step_run",
            ["original_step_run_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision.

    Raises:
        NotImplementedError: Downgrade is not supported for this migration.
    """
    raise NotImplementedError("Downgrade not supported.")
