"""Add build and deployment tables [19f27d5b234e].

Revision ID: 19f27d5b234e
Revises: e65aa6708ff7
Create Date: 2023-02-08 11:00:37.080746

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "19f27d5b234e"
down_revision = "e65aa6708ff7"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pipeline_build",
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("stack_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("pipeline_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("images", sa.TEXT(), nullable=False),
        sa.Column("is_local", sa.Boolean(), nullable=False),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pipeline_id"],
            ["pipeline.id"],
            name="fk_pipeline_build_pipeline_id_pipeline",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["stack_id"],
            ["stack.id"],
            name="fk_pipeline_build_stack_id_stack",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_pipeline_build_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_pipeline_build_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "pipeline_deployment",
        sa.Column("stack_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("pipeline_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("build_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("schedule_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("pipeline_configuration", sa.TEXT(), nullable=False),
        sa.Column("step_configurations", sa.TEXT(), nullable=False),
        sa.Column("client_environment", sa.TEXT(), nullable=False),
        sa.Column(
            "run_name_template",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["build_id"],
            ["pipeline_build.id"],
            name="fk_pipeline_deployment_build_id_pipeline_build",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["schedule_id"],
            ["schedule.id"],
            name="fk_pipeline_deployment_schedule_id_schedule",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["pipeline_id"],
            ["pipeline.id"],
            name="fk_pipeline_deployment_pipeline_id_pipeline",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["stack_id"],
            ["stack.id"],
            name="fk_pipeline_deployment_stack_id_stack",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_pipeline_deployment_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_pipeline_deployment_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )

    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("build_id", sqlmodel.sql.sqltypes.GUID(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "deployment_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
            )
        )
        batch_op.create_foreign_key(
            "fk_pipeline_run_build_id_pipeline_build",
            "pipeline_build",
            ["build_id"],
            ["id"],
            ondelete="SET NULL",
        )
        batch_op.create_foreign_key(
            "fk_pipeline_run_deployment_id_pipeline_deployment",
            "pipeline_deployment",
            ["deployment_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_pipeline_run_deployment_id_pipeline_deployment",
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            "fk_pipeline_run_build_id_pipeline_build", type_="foreignkey"
        )
        batch_op.drop_column("deployment_id")
        batch_op.drop_column("build_id")

    op.drop_table("pipeline_deployment")
    op.drop_table("pipeline_build")
    # ### end Alembic commands ###
