from .fangraphs_stats_base import FangraphsStatsBase


class FangraphsPitchingStats(FangraphsStatsBase):
    COMMON                                 = 'c'
    LINE_BREAK                             = '-1'
    NAME                                   = '0'
    TEAM                                   = '1'
    SEASON                                 = '2'
    AGE                                    = '3'
    W                                      = '4'
    WINS                                   = W
    L                                      = '5'
    LOSSES                                 = L
    ERA                                    = '6'
    G                                      = '7'
    GAMES                                  = G
    GS                                     = '8'
    GAMES_SAVED                            = GS
    CG                                     = '9'
    COMPLETE_GAMES                         = CG
    SHO                                    = '10'
    SHUT_OUTS                              = SHO
    SV                                     = '11'
    SAVES                                  = SV
    BS                                     = '12' # ?
    IP                                     = '13'
    INNINGS_PITCHED                        = IP
    TBF                                    = '14' # ?
    H                                      = '15'
    HITS                                   = H
    R                                      = '16'
    RUNS                                   = R
    ER                                     = '17'
    EARNED_RUNS                            = ER
    HR                                     = '18'
    HOME_RUNS                              = HR
    BB                                     = '19'
    WALKS                                  = BB
    IBB                                    = '20'
    INTENTIONAL_WALKS                      = IBB
    HBP                                    = '21'
    HIT_BY_PITCH                           = HBP
    WP                                     = '22'
    WILD_PITCHES                           = WP
    BK                                     = '23'
    BALKS                                  = BK
    SO                                     = '24'
    STRIKE_OUTS                            = SO
    GB                                     = '25'
    GROUND_BALLS                           = GB
    FB                                     = '26'
    FLY_BALLS                              = FB
    LD                                     = '27' # ?
    IFFB                                   = '28' # ?
    BALLS                                  = '29'
    STRIKES                                = '30'
    PITCHES                                = '31'
    RS                                     = '32' # ?
    IFH                                    = '33' # ? INFIELD_HITS?
    BU                                     = '34' # ?
    BUH                                    = '35' # ?
    K_9                                    = '36' # K/9
    STRIKE_OUTS_PER_9_INNINGS              = K_9
    BB_9                                   = '37' # BB/9
    WALKS_PER_9_INNINGS                    = BB_9
    K_BB                                   = '38' # K/BB
    STRIKE_OUTS_PER_WALK                   = K_BB
    H_9                                    = '39' # H/9
    HITS_PER_9_INNINDS                     = H_9
    HR_9                                   = '40' # HR/9
    HOME_RUNS_PER_9_INNINGS                = HR_9
    AVG                                    = '41'
    BATTING_AVERAGE                        = AVG
    WHIP                                   = '42'
    WALKS_AND_HITS_PER_INNING_PITCHED      = WHIP
    BABIP                                  = '43'
    BATTING_AVERAGE_FOR_BALLS_IN_PLAY      = BABIP
    LOB_PCT                                = '44' # LOB%
    LEFT_ON_BASE_PERCENTAGE                = LOB_PCT
    FIP                                    = '45'
    FIELDING_INDEPENDENT_PITCHING          = FIP
    GB_FB                                  = '46' #GB/FB
    GROUND_BALLS_PER_FLY_BALL              = GB_FB
    LD_PCT                                 = '47' # LD% ?
    GB_PCT                                 = '48' # GB%
    GROUND_BALL_PERCENTAGE                 = GB_PCT
    FB_PCT                                 = '49' # FB%
    FLY_BALL_PERCENTAGE                    = FB_PCT
    IFFB_PCT                               = '50' # IFFB% ?
    HR_FB                                  = '51' # HR/FB
    HOME_RUNS_PER_FLY_BALL                 = HR_FB
    IFH_PCT                                = '52' # IFH%
    INFIELD_HIT_PERCENTAGE                 = IFH_PCT
    BUH_PCT                                = '53' # BUH% ?
    STARTING                               = '54'
    START_IP                               = '55' # Start-IP
    STARTING_INNINGS_PITCHED               = START_IP
    RELIEVING                              = '56'
    RELIEF_IP                              = '57'
    RELIEVING_INNINGS_PITCHED              = RELIEF_IP
    RAR                                    = '58'
    RUNS_ABOVE_REPLACEMENT                 = RAR
    WAR                                    = '59'
    WINS_ABOVE_REPLACEMENT                 = WAR
    DOLLARS                                = '60'
    DOLLARS_VALUE                          = DOLLARS
    TERA                                   = '61' # ?
    XFIP                                   = '62'
    EXPECTED_FIELDING_INDEPENDENT_PITCHING = XFIP
    WPA                                    = '63' #
    WIN_PROBABILITY_ADDED                  = WPA
    NEGATIVE_WPA                           = '64' # -WPA
    NEGATIVE_WIN_PROBABILITY_ADDED         = NEGATIVE_WPA
    POSITIVE_WPA                           = '65' # +WPA
    POSITIVE_WIN_PROBABILITY_ADDED         = POSITIVE_WPA
    RE24                                   = '66' # ?
    REW                                    = '67' # ?
    PLI                                    = '68' # ?
    INLI                                   = '69' # ?
    GMLI                                   = '70' # ?
    EXLI                                   = '71' # ?
    PULLS                                  = '72'
    WPA_LI                                 = '73' # WPA/LI ?
    CLUTCH                                 = '74'
    FB_PCT_2                               = '75' # FB% ? Not sure the difference between this and the one in position 45
    FBV                                    = '76' # ?
    SL_PCT                                 = '77' # SL% ?
    SLV                                    = '78' # ?
    CT_PCT                                 = '79' # CT% ?
    CTV                                    = '80'
    CB_PCT                                 = '81' # CB% ?
    CBV                                    = '82' # ?
    CH_PCT                                 = '83' # CH% ?
    CHV                                    = '84' # ?
    SF_PCT                                 = '85' # SF% ?
    SFV                                    = '86' # ?
    KN_PCT                                 = '87' # KN% ?
    KNV                                    = '88' # ?
    XX_PCT                                 = '89' # XX% ?
    PO_PCT                                 = '90' # PO% ?
    WFB                                    = '91' # ?
    WSL                                    = '92' # ?
    WCT                                    = '93' # ?
    WCB                                    = '94' # ?
    WCH                                    = '95' # ?
    WSF                                    = '96' # ?
    WKN                                    = '97' # ?
    WFB_C                                  = '98' # wFB/C ?
    WSL_C                                  = '99' # wSL/C ?
    WCT_C                                  = '100' # wCT/C ?
    WCB_C                                  = '101' # wCB/C ?
    WCH_C                                  = '102' # wCH/C ?
    WSF_C                                  = '103' # wSF/C ?
    WKN_C                                  = '104' # wKN/C ?
    OSWING_PCT                             = '105' # O-Swing% ?
    ZSWING_PCT                             = '106' # Z-Swing% ?
    SWING_PCT                              = '107' # Swing% ?
    OCONTACT_PCT                           = '108' # O-Contact% ?
    ZCONTACT_PCT                           = '109' # Z-Contact% ?
    CONTACT_PCT                            = '110' # Contact% ?
    ZONE_PCT                               = '111' # Zone% ?
    FSTRIKE_PCT                            = '112' # F-Strike% ?
    SWSTR_PCT                              = '113' # SwStr% SWINGING_STRIKE_PERCENTAGE?
    HLD                                    = '114' # HOLDS?
    SD                                     = '115' # ?
    MD                                     = '116' # ?
    ERA_MINUS                              = '117' # ERA- ?
    FIP_MINUS                              = '118' # FIP- ?
    XFIP_MINUS                             = '119' # xFIP- ?
    K_PCT                                  = '120' # K%
    STRIKE_OUT_PERCENTAGE                  = K_PCT
    BB_PCT                                 = '121' # BB%
    WALK_PERCENTAGE                        = BB_PCT
    SIERA                                  = '122' # ?
    RS_9                                   = '123'
    RUNS_SCORED_PER_9_INNINGS              = RS_9
    E_F                                    = '124' # E-F ?
    FA_PCT_PFX                             = '125' # 'FA% (pfx)' ?
    FT_PCT_PFX                             = '126' # 'FT% (pfx)' ?
    FC_PCT_PFX                             = '127' # 'FC% (pfx)' ?
    FS_PCT_PFX                             = '128' # 'FS% (pfx)' ?
    FO_PCT_PFX                             = '129' # 'FO% (pfx)' ?
    SI_PCT_PFX                             = '130' # 'SI% (pfx)' ?
    SL_PCT_PFX                             = '131' # 'SL% (pfx)' ?
    CU_PCT_PFX                             = '132' # 'CU% (pfx)' ?
    KC_PCT_PFX                             = '133' # 'KC% (pfx)' ?
    EP_PCT_PFX                             = '134' # 'EP% (pfx)' ?
    CH_PCT_PFX                             = '135' # 'CH% (pfx)' ?
    SC_PCT_PFX                             = '136' # 'SC% (pfx)' ?
    KN_PCT_PFX                             = '137' # 'KN% (pfx)' ?
    UN_PCT_PFX                             = '138' # 'UN% (pfx)' ?
    VFA_PFX                                = '139' # 'vFA (pfx)' ?
    VFT_PFX                                = '140' # 'vFT (pfx)' ?
    VFC_PFX                                = '141' # 'vFC (pfx)' ?
    VFS_PFX                                = '142' # 'vFS (pfx)' ?
    VFO_PFX                                = '143' # 'vFO (pfx)' ?
    VSI_PFX                                = '144' # 'vSI (pfx)' ?
    VSL_PFX                                = '145' # 'vSL (pfx)' ?
    VCU_PFX                                = '146' # 'vCU (pfx)' ?
    VKC_PFX                                = '147' # 'vKC (pfx)' ?
    VEP_PFX                                = '148' # 'vEP (pfx)' ?
    VCH_PFX                                = '149' # 'vCH (pfx)' ?
    VSC_PFX                                = '150' # 'vSC (pfx)' ?
    VKN_PFX                                = '151' # 'vKN (pfx)' ?
    FA_X_PFX                               = '152' # 'FA-X (pfx)' ?
    FT_X_PFX                               = '153' # 'FT-X (pfx)' ?
    FC_X_PFX                               = '154' # 'FC-X (pfx)' ?
    FS_X_PFX                               = '155' # 'FS-X (pfx)' ?
    FO_X_PFX                               = '156' # 'FO-X (pfx)' ?
    SI_X_PFX                               = '157' # 'SI-X (pfx)' ?
    SL_X_PFX                               = '158' # 'SL-X (pfx)' ?
    CU_X_PFX                               = '159' # 'CU-X (pfx)' ?
    KC_X_PFX                               = '160' # 'KC-X (pfx)' ?
    EP_X_PFX                               = '161' # 'EP-X (pfx)' ?
    CH_X_PFX                               = '162' # 'CG-X (pfx)' ?
    SC_X_PFX                               = '163' # 'SC-X (pfx)' ?
    KN_X_PFX                               = '164' # 'KN-X (pfx)' ?
    FA_Z_PFX                               = '165' # 'FA-Z (pfx)' ?
    FT_Z_PFX                               = '166' # 'FT-Z (pfx)' ?
    FC_Z_PFX                               = '167' # 'FC-Z (pfx)' ?
    FS_Z_PFX                               = '168' # 'FS-Z (pfx)' ?
    FO_Z_PFX                               = '169' # 'FO-Z (pfx)' ?
    SI_Z_PFX                               = '170' # 'SI-Z (pfx)' ?
    SL_Z_PFX                               = '171' # 'SL-Z (pfx)' ?
    CU_Z_PFX                               = '172' # 'CU-Z (pfx)' ?
    KC_Z_PFX                               = '173' # 'KC-Z (pfx)' ?
    EP_Z_PFX                               = '174' # 'EP-Z (pfx)' ?
    CH_Z_PFX                               = '175' # 'CH-Z (pfx)' ?
    SC_Z_PFX                               = '176' # 'SC-Z (pfx)' ?
    KN_Z_PFX                               = '177' # 'KN-Z (pfx)' ?
    WFA_PFX                                = '178' # 'wFA (pfx)' ?
    WFT_PFX                                = '179' # 'wFT (pfx)' ?
    WFC_PFX                                = '180' # 'wFC (pfx)' ?
    WFS_PFX                                = '181' # 'wFS (pfx)' ?
    WFO_PFX                                = '182' # 'wFO (pfx)' ?
    WSI_PFX                                = '183' # 'wSI (pfx)' ?
    WSL_PFX                                = '184' # 'wSL (pfx)' ?
    WCU_PFX                                = '185' # 'wCU (pfx)' ?
    WKC_PFX                                = '186' # 'wKC (pfx)' ?
    WEP_PFX                                = '187' # 'wEP (pfx)' ?
    WCH_PFX                                = '188' # 'wCH (pfx)' ?
    WSC_PFX                                = '189' # 'wSC (pfx)' ?
    WKN_PFX                                = '190' # 'wKN (pfx)' ?
    WFA_C_PFX                              = '191' # 'wFA/C (pfx)' ?
    WFT_C_PFX                              = '192' # 'wFT/C (pfx)' ?
    WFC_C_PFX                              = '193' # 'wFC/C (pfx)' ?
    WFS_C_PFX                              = '194' # 'wFS/C (pfx)' ?
    WFO_C_PFX                              = '195' # 'wFO/C (pfx)' ?
    WSI_C_PFX                              = '196' # 'wSI/C (pfx)' ?
    WSL_C_PFX                              = '197' # 'wSL/C (pfx)' ?
    WCU_C_PFX                              = '198' # 'wCU/C (pfx)' ?
    WKC_C_PFX                              = '199' # 'wKC/C (pfx)' ?
    WEP_C_PFX                              = '200' # 'wEP/C (pfx)' ?
    WCH_C_PFX                              = '201' # 'wCH/C (pfx)' ?
    WSC_C_PFX                              = '202' # 'wSC/C (pfx)' ?
    WKN_C_PFX                              = '203' # 'wKN/C (pfx)' ?
    OSWING_PCT_PFX                         = '204' # 'O-Swing% (pfx)' ?
    ZSWING_PCT_PFX                         = '205' # 'Z-Swing% (pfx)' ?
    SWING_PCT_PFX                          = '206' # 'Swing% (pfx)' ?
    OCONTACT_PCT_PFX                       = '207' # 'O-Contact% (pfx)' ?
    ZCONTACT_PCT_PFX                       = '208' # 'Z-Contact% (pfx)' ?
    CONTACT_PCT_PFX                        = '209' # 'Contact% (pfx)' ?
    ZONE_PCT_PFX                           = '210' # 'Zone% (pfx)' ?
    PACE                                   = '211'
    RA9_WAR                                = '212' # RA9-WAT ?
    BIP_WINS                               = '213' # BIP-Wins ?
    LOB_WINS                               = '214' # LOB-Wins ?
    FDP_WINS                               = '215' # FDP-Wins ?
    AGE_RNG                                = '216' # ?
    K_BB_PCT                               = '217' # ?
    PULL_PCT                               = '218' # ?
    CENT_PCT                               = '219' # ?
    OPPO_PCT                               = '220' # ?
    SOFT_PCT                               = '221' # ?
    MED_PCT                                = '222' # ?
    HARD_PCT                               = '223' # ?
    KWERA                                  = '224' # kwERA ?
    TTO_PCT                                = '225' # TTO% ?
    CH_PCT_PI                              = '226' # 'CH% (pi)' ?
    CS_PCT_PI                              = '227' # 'CS% (pi)' ?
    CU_PCT_PI                              = '228' # 'CU% (pi)' ?
    FA_PCT_PI                              = '229' # 'FA% (pi)' ?
    FC_PCT_PI                              = '230' # 'FC% (pi)' ?
    FS_PCT_PI                              = '231' # 'FS% (pi)' ?
    KN_PCT_PI                              = '232' # 'KN% (pi)' ?
    SB_PCT_PI                              = '233' # 'SB% (pi)' ?
    SI_PCT_PI                              = '234' # 'SI% (pi)' ?
    SL_PCT_PI                              = '235' # 'SL% (pi)' ?
    XX_PCT_PI                              = '236' # 'XX% (pi)' ?
    VCH_PI                                 = '237' # 'vCH (pi)' ?
    VCS_PI                                 = '238' # 'vCS (pi)' ?
    VCU_PI                                 = '239' # 'vCU (pi)' ?
    VFA_PI                                 = '240' # 'vFA (pi)' ?
    VFC_PI                                 = '241' # 'vFC (pi)' ?
    VFS_PI                                 = '242' # 'vFS (pi)' ?
    VKN_PI                                 = '243' # 'vKN (pi)' ?
    VSB_PI                                 = '244' # 'vSB (pi)' ?
    VSI_PI                                 = '245' # 'vSI (pi)' ?
    VSL_PI                                 = '246' # 'vSL (pi)' ?
    VXX_PI                                 = '247' # 'vXX (pi)' ?
    CH_X_PI                                = '248' # 'CH-X (pi)' ?
    CS_X_PI                                = '249' # 'CS-X (pi)' ?
    CU_X_PI                                = '250' # 'CU-X (pi)' ?
    FA_X_PI                                = '251' # 'FA-X (pi)' ?
    FC_X_PI                                = '252' # 'FC-X (pi)' ?
    FS_X_PI                                = '253' # 'FS-X (pi)' ?
    KN_X_PI                                = '254' # 'KN-X (pi)' ?
    SB_X_PI                                = '255' # 'SB-X (pi)' ?
    SI_X_PI                                = '256' # 'SI-X (pi)' ?
    SL_X_PI                                = '257' # 'SL-X (pi)' ?
    XX_X_PI                                = '258' # 'XX-X (pi)' ?
    CH_Z_PI                                = '259' # 'CH-Z (pi)' ?
    CS_Z_PI                                = '260' # 'CS-Z (pi)' ?
    CU_Z_PI                                = '261' # 'CU-Z (pi)' ?
    FA_Z_PI                                = '262' # 'FA-Z (pi)' ?
    FC_Z_PI                                = '263' # 'FC-Z (pi)' ?
    FS_Z_PI                                = '264' # 'FS-Z (pi)' ?
    KN_Z_PI                                = '265' # 'KN-Z (pi)' ?
    SB_Z_PI                                = '266' # 'SB-Z (pi)' ?
    SI_Z_PI                                = '267' # 'SI-Z (pi)' ?
    SL_Z_PI                                = '268' # 'SL-Z (pi)' ?
    XX_Z_PI                                = '269' # 'XX-Z (pi)' ?
    WCH_PI                                 = '270' # 'wCH (pi)' ?
    WCS_PI                                 = '271' # 'wCS (pi)' ?
    WCU_PI                                 = '272' # 'wCU (pi)' ?
    WFA_PI                                 = '273' # 'wFA (pi)' ?
    WFC_PI                                 = '274' # 'wFC (pi)' ?
    WFS_PI                                 = '275' # 'wFS (pi)' ?
    WKN_PI                                 = '276' # 'wKN (pi)' ?
    WSB_PI                                 = '277' # 'wSB (pi)' ?
    WSI_PI                                 = '278' # 'wSI (pi)' ?
    WSL_PI                                 = '279' # 'wSL (pi)' ?
    WXX_PI                                 = '280' # 'wXX (pi)' ?
    WCH_C_PI                               = '281' # 'wCH/C (pi)' ?
    WCS_C_PI                               = '282' # 'wCS/C (pi)' ?
    WCU_C_PI                               = '283' # 'wCU/C (pi)' ?
    WFA_C_PI                               = '284' # 'wFA/C (pi)' ?
    WFC_C_PI                               = '285' # 'wFC/C (pi)' ?
    WFS_C_PI                               = '286' # 'wFS/C (pi)' ?
    WKN_C_PI                               = '287' # 'wKN/C (pi)' ?
    WSB_C_PI                               = '288' # 'wSB/C (pi)' ?
    WSI_C_PI                               = '289' # 'wSI/C (pi)' ?
    WSL_C_PI                               = '290' # 'wSL/C (pi)' ?
    WXX_C_PI                               = '291' # 'wXX/C (pi)' ?
    OSWING_PCT_PI                          = '292' # 'O-Swing% (pfx)' ?
    ZSWING_PCT_PI                          = '293' # 'Z-Swing% (pfx)' ?
    SWING_PCT_PI                           = '294' # 'Swing% (pfx)' ?
    OCONTACT_PCT_PI                        = '295' # 'O-Contact% (pfx)' ?
    ZCONTACT_PCT_PI                        = '296' # 'Z-Contact% (pfx)' ?
    CONTACT_PCT_PI                         = '297' # 'Contact% (pfx)' ?
    ZONE_PCT_PI                            = '298' # 'Zone% (pfx)' ?
    PACE_PI                                = '299' # 'Pace (pi)'?
    FRM                                    = '300' # ?
    K_9_PLUS                               = '301' # K/9+ ?
    BB_9_PLUS                              = '302' # BB/9+ ?
    K_BB_PLUS                              = '305' # K/BB+ ?
    H_9_PLUS                               = '304' # H/9+ ?
    HR_9_PLUS                              = '305' # HR/9+ ?
    AVG_PLUS                               = '306' # AVG+ ?
    WHIP_PLUS                              = '307' # WHIP+ ?
    BABIP_PLUS                             = '308' # BABIP+ ?
    LOB_PCT_PLUS                           = '309' # LOB%+ ?
    K_PCT_PLUS                             = '310' # K%+ ?
    BB_PCT_PLUS                            = '311' # BB%+ ?
    LD_PCT_PLUS                            = '312' # LD%+ ?
    GB_PCT_PLUS                            = '313' # GB%+ ?
    FB_PCT_PLUS                            = '314' # FB%+ ?
    HR_FB_PCT_PLUS                         = '315' # HR/FB%+ ?
    PULL_PCT_PLUS                          = '316' # Pull%+ ?
    CENT_PCT_PLUS                          = '317' # Cent%+ ?
    OPPO_PCT_PLUS                          = '318' # Oppo%+ ?
    SOFT_PCT_PLUS                          = '319' # Soft%+ ?
    MED_PCT_PLUS                           = '320' # Med %+ ?
    HARD_PCT_PLUS                          = '321' # Hard%+ ?
    EV                                     = '322' # ?
    LA                                     = '323' # ?
    BARRELS                                = '324' # ?
    BARREL_PCT                             = '325' # Barrel% ?
    MAXEV                                  = '326' # maxEV ?
    HARDHIT                                = '327' # ?
    HARDHIT_PCT                            = '328' # HardHit% ?
    EVENTS                                 = '329' # ?
