from typing import Any, cast, Dict, List, Optional, Type, TypeVar

import attr

from ..extensions import NotPresentError
from ..models.app_config_item_float_update_type import AppConfigItemFloatUpdateType
from ..types import UNSET, Unset

T = TypeVar("T", bound="AppConfigItemFloatUpdate")


@attr.s(auto_attribs=True, repr=False)
class AppConfigItemFloatUpdate:
    """  """

    _type: AppConfigItemFloatUpdateType
    _value: float
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def __repr__(self):
        fields = []
        fields.append("type={}".format(repr(self._type)))
        fields.append("value={}".format(repr(self._value)))
        fields.append("additional_properties={}".format(repr(self.additional_properties)))
        return "AppConfigItemFloatUpdate({})".format(", ".join(fields))

    def to_dict(self) -> Dict[str, Any]:
        type = self._type.value

        value = self._value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        # Allow the model to serialize even if it was created outside of the constructor, circumventing validation
        if type is not UNSET:
            field_dict["type"] = type
        if value is not UNSET:
            field_dict["value"] = value

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()

        def get_type() -> AppConfigItemFloatUpdateType:
            _type = d.pop("type")
            try:
                type = AppConfigItemFloatUpdateType(_type)
            except ValueError:
                type = AppConfigItemFloatUpdateType.of_unknown(_type)

            return type

        type = get_type() if "type" in d else cast(AppConfigItemFloatUpdateType, UNSET)

        def get_value() -> float:
            value = d.pop("value")
            return value

        value = get_value() if "value" in d else cast(float, UNSET)

        app_config_item_float_update = cls(
            type=type,
            value=value,
        )

        app_config_item_float_update.additional_properties = d
        return app_config_item_float_update

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties

    def get(self, key, default=None) -> Optional[Any]:
        return self.additional_properties.get(key, default)

    @property
    def type(self) -> AppConfigItemFloatUpdateType:
        if isinstance(self._type, Unset):
            raise NotPresentError(self, "type")
        return self._type

    @type.setter
    def type(self, value: AppConfigItemFloatUpdateType) -> None:
        self._type = value

    @property
    def value(self) -> float:
        if isinstance(self._value, Unset):
            raise NotPresentError(self, "value")
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        self._value = value
