import datetime
from typing import Any, cast, Dict, List, Optional, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..extensions import NotPresentError
from ..models.archive_record import ArchiveRecord
from ..models.checkout_record import CheckoutRecord
from ..models.container_content import ContainerContent
from ..models.container_quantity import ContainerQuantity
from ..models.deprecated_container_volume_for_response import DeprecatedContainerVolumeForResponse
from ..models.fields import Fields
from ..models.schema_summary import SchemaSummary
from ..models.user_summary import UserSummary
from ..types import UNSET, Unset

T = TypeVar("T", bound="ContainerWithCoordinates")


@attr.s(auto_attribs=True, repr=False)
class ContainerWithCoordinates:
    """  """

    _grid_number: Union[Unset, float] = UNSET
    _grid_position: Union[Unset, str] = UNSET
    _archive_record: Union[Unset, None, ArchiveRecord] = UNSET
    _barcode: Union[Unset, None, str] = UNSET
    _checkout_record: Union[Unset, CheckoutRecord] = UNSET
    _contents: Union[Unset, List[ContainerContent]] = UNSET
    _created_at: Union[Unset, datetime.datetime] = UNSET
    _creator: Union[Unset, UserSummary] = UNSET
    _fields: Union[Unset, Fields] = UNSET
    _id: Union[Unset, str] = UNSET
    _modified_at: Union[Unset, datetime.datetime] = UNSET
    _name: Union[Unset, str] = UNSET
    _parent_storage_id: Union[Unset, None, str] = UNSET
    _parent_storage_schema: Union[Unset, None, SchemaSummary] = UNSET
    _project_id: Union[Unset, None, str] = UNSET
    _quantity: Union[Unset, ContainerQuantity] = UNSET
    _schema: Union[Unset, None, SchemaSummary] = UNSET
    _volume: Union[Unset, DeprecatedContainerVolumeForResponse] = UNSET
    _web_url: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def __repr__(self):
        fields = []
        fields.append("grid_number={}".format(repr(self._grid_number)))
        fields.append("grid_position={}".format(repr(self._grid_position)))
        fields.append("archive_record={}".format(repr(self._archive_record)))
        fields.append("barcode={}".format(repr(self._barcode)))
        fields.append("checkout_record={}".format(repr(self._checkout_record)))
        fields.append("contents={}".format(repr(self._contents)))
        fields.append("created_at={}".format(repr(self._created_at)))
        fields.append("creator={}".format(repr(self._creator)))
        fields.append("fields={}".format(repr(self._fields)))
        fields.append("id={}".format(repr(self._id)))
        fields.append("modified_at={}".format(repr(self._modified_at)))
        fields.append("name={}".format(repr(self._name)))
        fields.append("parent_storage_id={}".format(repr(self._parent_storage_id)))
        fields.append("parent_storage_schema={}".format(repr(self._parent_storage_schema)))
        fields.append("project_id={}".format(repr(self._project_id)))
        fields.append("quantity={}".format(repr(self._quantity)))
        fields.append("schema={}".format(repr(self._schema)))
        fields.append("volume={}".format(repr(self._volume)))
        fields.append("web_url={}".format(repr(self._web_url)))
        fields.append("additional_properties={}".format(repr(self.additional_properties)))
        return "ContainerWithCoordinates({})".format(", ".join(fields))

    def to_dict(self) -> Dict[str, Any]:
        grid_number = self._grid_number
        grid_position = self._grid_position
        archive_record: Union[Unset, None, Dict[str, Any]] = UNSET
        if not isinstance(self._archive_record, Unset):
            archive_record = self._archive_record.to_dict() if self._archive_record else None

        barcode = self._barcode
        checkout_record: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self._checkout_record, Unset):
            checkout_record = self._checkout_record.to_dict()

        contents: Union[Unset, List[Any]] = UNSET
        if not isinstance(self._contents, Unset):
            contents = []
            for contents_item_data in self._contents:
                contents_item = contents_item_data.to_dict()

                contents.append(contents_item)

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self._created_at, Unset):
            created_at = self._created_at.isoformat()

        creator: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self._creator, Unset):
            creator = self._creator.to_dict()

        fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self._fields, Unset):
            fields = self._fields.to_dict()

        id = self._id
        modified_at: Union[Unset, str] = UNSET
        if not isinstance(self._modified_at, Unset):
            modified_at = self._modified_at.isoformat()

        name = self._name
        parent_storage_id = self._parent_storage_id
        parent_storage_schema: Union[Unset, None, Dict[str, Any]] = UNSET
        if not isinstance(self._parent_storage_schema, Unset):
            parent_storage_schema = (
                self._parent_storage_schema.to_dict() if self._parent_storage_schema else None
            )

        project_id = self._project_id
        quantity: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self._quantity, Unset):
            quantity = self._quantity.to_dict()

        schema: Union[Unset, None, Dict[str, Any]] = UNSET
        if not isinstance(self._schema, Unset):
            schema = self._schema.to_dict() if self._schema else None

        volume: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self._volume, Unset):
            volume = self._volume.to_dict()

        web_url = self._web_url

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        # Allow the model to serialize even if it was created outside of the constructor, circumventing validation
        if grid_number is not UNSET:
            field_dict["gridNumber"] = grid_number
        if grid_position is not UNSET:
            field_dict["gridPosition"] = grid_position
        if archive_record is not UNSET:
            field_dict["archiveRecord"] = archive_record
        if barcode is not UNSET:
            field_dict["barcode"] = barcode
        if checkout_record is not UNSET:
            field_dict["checkoutRecord"] = checkout_record
        if contents is not UNSET:
            field_dict["contents"] = contents
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if creator is not UNSET:
            field_dict["creator"] = creator
        if fields is not UNSET:
            field_dict["fields"] = fields
        if id is not UNSET:
            field_dict["id"] = id
        if modified_at is not UNSET:
            field_dict["modifiedAt"] = modified_at
        if name is not UNSET:
            field_dict["name"] = name
        if parent_storage_id is not UNSET:
            field_dict["parentStorageId"] = parent_storage_id
        if parent_storage_schema is not UNSET:
            field_dict["parentStorageSchema"] = parent_storage_schema
        if project_id is not UNSET:
            field_dict["projectId"] = project_id
        if quantity is not UNSET:
            field_dict["quantity"] = quantity
        if schema is not UNSET:
            field_dict["schema"] = schema
        if volume is not UNSET:
            field_dict["volume"] = volume
        if web_url is not UNSET:
            field_dict["webURL"] = web_url

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()

        def get_grid_number() -> Union[Unset, float]:
            grid_number = d.pop("gridNumber")
            return grid_number

        grid_number = get_grid_number() if "gridNumber" in d else cast(Union[Unset, float], UNSET)

        def get_grid_position() -> Union[Unset, str]:
            grid_position = d.pop("gridPosition")
            return grid_position

        grid_position = get_grid_position() if "gridPosition" in d else cast(Union[Unset, str], UNSET)

        def get_archive_record() -> Union[Unset, None, ArchiveRecord]:
            archive_record = None
            _archive_record = d.pop("archiveRecord")
            if _archive_record is not None and not isinstance(_archive_record, Unset):
                archive_record = ArchiveRecord.from_dict(_archive_record)

            return archive_record

        archive_record = (
            get_archive_record() if "archiveRecord" in d else cast(Union[Unset, None, ArchiveRecord], UNSET)
        )

        def get_barcode() -> Union[Unset, None, str]:
            barcode = d.pop("barcode")
            return barcode

        barcode = get_barcode() if "barcode" in d else cast(Union[Unset, None, str], UNSET)

        def get_checkout_record() -> Union[Unset, CheckoutRecord]:
            checkout_record: Union[Unset, CheckoutRecord] = UNSET
            _checkout_record = d.pop("checkoutRecord")
            if not isinstance(_checkout_record, Unset):
                checkout_record = CheckoutRecord.from_dict(_checkout_record)

            return checkout_record

        checkout_record = (
            get_checkout_record() if "checkoutRecord" in d else cast(Union[Unset, CheckoutRecord], UNSET)
        )

        def get_contents() -> Union[Unset, List[ContainerContent]]:
            contents = []
            _contents = d.pop("contents")
            for contents_item_data in _contents or []:
                contents_item = ContainerContent.from_dict(contents_item_data)

                contents.append(contents_item)

            return contents

        contents = get_contents() if "contents" in d else cast(Union[Unset, List[ContainerContent]], UNSET)

        def get_created_at() -> Union[Unset, datetime.datetime]:
            created_at: Union[Unset, datetime.datetime] = UNSET
            _created_at = d.pop("createdAt")
            if _created_at is not None and not isinstance(_created_at, Unset):
                created_at = isoparse(cast(str, _created_at))

            return created_at

        created_at = get_created_at() if "createdAt" in d else cast(Union[Unset, datetime.datetime], UNSET)

        def get_creator() -> Union[Unset, UserSummary]:
            creator: Union[Unset, UserSummary] = UNSET
            _creator = d.pop("creator")
            if not isinstance(_creator, Unset):
                creator = UserSummary.from_dict(_creator)

            return creator

        creator = get_creator() if "creator" in d else cast(Union[Unset, UserSummary], UNSET)

        def get_fields() -> Union[Unset, Fields]:
            fields: Union[Unset, Fields] = UNSET
            _fields = d.pop("fields")
            if not isinstance(_fields, Unset):
                fields = Fields.from_dict(_fields)

            return fields

        fields = get_fields() if "fields" in d else cast(Union[Unset, Fields], UNSET)

        def get_id() -> Union[Unset, str]:
            id = d.pop("id")
            return id

        id = get_id() if "id" in d else cast(Union[Unset, str], UNSET)

        def get_modified_at() -> Union[Unset, datetime.datetime]:
            modified_at: Union[Unset, datetime.datetime] = UNSET
            _modified_at = d.pop("modifiedAt")
            if _modified_at is not None and not isinstance(_modified_at, Unset):
                modified_at = isoparse(cast(str, _modified_at))

            return modified_at

        modified_at = get_modified_at() if "modifiedAt" in d else cast(Union[Unset, datetime.datetime], UNSET)

        def get_name() -> Union[Unset, str]:
            name = d.pop("name")
            return name

        name = get_name() if "name" in d else cast(Union[Unset, str], UNSET)

        def get_parent_storage_id() -> Union[Unset, None, str]:
            parent_storage_id = d.pop("parentStorageId")
            return parent_storage_id

        parent_storage_id = (
            get_parent_storage_id() if "parentStorageId" in d else cast(Union[Unset, None, str], UNSET)
        )

        def get_parent_storage_schema() -> Union[Unset, None, SchemaSummary]:
            parent_storage_schema = None
            _parent_storage_schema = d.pop("parentStorageSchema")
            if _parent_storage_schema is not None and not isinstance(_parent_storage_schema, Unset):
                parent_storage_schema = SchemaSummary.from_dict(_parent_storage_schema)

            return parent_storage_schema

        parent_storage_schema = (
            get_parent_storage_schema()
            if "parentStorageSchema" in d
            else cast(Union[Unset, None, SchemaSummary], UNSET)
        )

        def get_project_id() -> Union[Unset, None, str]:
            project_id = d.pop("projectId")
            return project_id

        project_id = get_project_id() if "projectId" in d else cast(Union[Unset, None, str], UNSET)

        def get_quantity() -> Union[Unset, ContainerQuantity]:
            quantity: Union[Unset, ContainerQuantity] = UNSET
            _quantity = d.pop("quantity")
            if not isinstance(_quantity, Unset):
                quantity = ContainerQuantity.from_dict(_quantity)

            return quantity

        quantity = get_quantity() if "quantity" in d else cast(Union[Unset, ContainerQuantity], UNSET)

        def get_schema() -> Union[Unset, None, SchemaSummary]:
            schema = None
            _schema = d.pop("schema")
            if _schema is not None and not isinstance(_schema, Unset):
                schema = SchemaSummary.from_dict(_schema)

            return schema

        schema = get_schema() if "schema" in d else cast(Union[Unset, None, SchemaSummary], UNSET)

        def get_volume() -> Union[Unset, DeprecatedContainerVolumeForResponse]:
            volume: Union[Unset, DeprecatedContainerVolumeForResponse] = UNSET
            _volume = d.pop("volume")
            if not isinstance(_volume, Unset):
                volume = DeprecatedContainerVolumeForResponse.from_dict(_volume)

            return volume

        volume = (
            get_volume() if "volume" in d else cast(Union[Unset, DeprecatedContainerVolumeForResponse], UNSET)
        )

        def get_web_url() -> Union[Unset, str]:
            web_url = d.pop("webURL")
            return web_url

        web_url = get_web_url() if "webURL" in d else cast(Union[Unset, str], UNSET)

        container_with_coordinates = cls(
            grid_number=grid_number,
            grid_position=grid_position,
            archive_record=archive_record,
            barcode=barcode,
            checkout_record=checkout_record,
            contents=contents,
            created_at=created_at,
            creator=creator,
            fields=fields,
            id=id,
            modified_at=modified_at,
            name=name,
            parent_storage_id=parent_storage_id,
            parent_storage_schema=parent_storage_schema,
            project_id=project_id,
            quantity=quantity,
            schema=schema,
            volume=volume,
            web_url=web_url,
        )

        container_with_coordinates.additional_properties = d
        return container_with_coordinates

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties

    def get(self, key, default=None) -> Optional[Any]:
        return self.additional_properties.get(key, default)

    @property
    def grid_number(self) -> float:
        if isinstance(self._grid_number, Unset):
            raise NotPresentError(self, "grid_number")
        return self._grid_number

    @grid_number.setter
    def grid_number(self, value: float) -> None:
        self._grid_number = value

    @grid_number.deleter
    def grid_number(self) -> None:
        self._grid_number = UNSET

    @property
    def grid_position(self) -> str:
        if isinstance(self._grid_position, Unset):
            raise NotPresentError(self, "grid_position")
        return self._grid_position

    @grid_position.setter
    def grid_position(self, value: str) -> None:
        self._grid_position = value

    @grid_position.deleter
    def grid_position(self) -> None:
        self._grid_position = UNSET

    @property
    def archive_record(self) -> Optional[ArchiveRecord]:
        if isinstance(self._archive_record, Unset):
            raise NotPresentError(self, "archive_record")
        return self._archive_record

    @archive_record.setter
    def archive_record(self, value: Optional[ArchiveRecord]) -> None:
        self._archive_record = value

    @archive_record.deleter
    def archive_record(self) -> None:
        self._archive_record = UNSET

    @property
    def barcode(self) -> Optional[str]:
        if isinstance(self._barcode, Unset):
            raise NotPresentError(self, "barcode")
        return self._barcode

    @barcode.setter
    def barcode(self, value: Optional[str]) -> None:
        self._barcode = value

    @barcode.deleter
    def barcode(self) -> None:
        self._barcode = UNSET

    @property
    def checkout_record(self) -> CheckoutRecord:
        """
        *assignee field* is set if status is "RESERVED" or "CHECKED_OUT", or null if status is "AVAILABLE".

        *comment field* is set when container was last reserved, checked out, or checked into.

        *modifiedAt field* is the date and time when container was last checked out, checked in, or reserved
        """
        if isinstance(self._checkout_record, Unset):
            raise NotPresentError(self, "checkout_record")
        return self._checkout_record

    @checkout_record.setter
    def checkout_record(self, value: CheckoutRecord) -> None:
        self._checkout_record = value

    @checkout_record.deleter
    def checkout_record(self) -> None:
        self._checkout_record = UNSET

    @property
    def contents(self) -> List[ContainerContent]:
        if isinstance(self._contents, Unset):
            raise NotPresentError(self, "contents")
        return self._contents

    @contents.setter
    def contents(self, value: List[ContainerContent]) -> None:
        self._contents = value

    @contents.deleter
    def contents(self) -> None:
        self._contents = UNSET

    @property
    def created_at(self) -> datetime.datetime:
        if isinstance(self._created_at, Unset):
            raise NotPresentError(self, "created_at")
        return self._created_at

    @created_at.setter
    def created_at(self, value: datetime.datetime) -> None:
        self._created_at = value

    @created_at.deleter
    def created_at(self) -> None:
        self._created_at = UNSET

    @property
    def creator(self) -> UserSummary:
        if isinstance(self._creator, Unset):
            raise NotPresentError(self, "creator")
        return self._creator

    @creator.setter
    def creator(self, value: UserSummary) -> None:
        self._creator = value

    @creator.deleter
    def creator(self) -> None:
        self._creator = UNSET

    @property
    def fields(self) -> Fields:
        if isinstance(self._fields, Unset):
            raise NotPresentError(self, "fields")
        return self._fields

    @fields.setter
    def fields(self, value: Fields) -> None:
        self._fields = value

    @fields.deleter
    def fields(self) -> None:
        self._fields = UNSET

    @property
    def id(self) -> str:
        if isinstance(self._id, Unset):
            raise NotPresentError(self, "id")
        return self._id

    @id.setter
    def id(self, value: str) -> None:
        self._id = value

    @id.deleter
    def id(self) -> None:
        self._id = UNSET

    @property
    def modified_at(self) -> datetime.datetime:
        if isinstance(self._modified_at, Unset):
            raise NotPresentError(self, "modified_at")
        return self._modified_at

    @modified_at.setter
    def modified_at(self, value: datetime.datetime) -> None:
        self._modified_at = value

    @modified_at.deleter
    def modified_at(self) -> None:
        self._modified_at = UNSET

    @property
    def name(self) -> str:
        if isinstance(self._name, Unset):
            raise NotPresentError(self, "name")
        return self._name

    @name.setter
    def name(self, value: str) -> None:
        self._name = value

    @name.deleter
    def name(self) -> None:
        self._name = UNSET

    @property
    def parent_storage_id(self) -> Optional[str]:
        if isinstance(self._parent_storage_id, Unset):
            raise NotPresentError(self, "parent_storage_id")
        return self._parent_storage_id

    @parent_storage_id.setter
    def parent_storage_id(self, value: Optional[str]) -> None:
        self._parent_storage_id = value

    @parent_storage_id.deleter
    def parent_storage_id(self) -> None:
        self._parent_storage_id = UNSET

    @property
    def parent_storage_schema(self) -> Optional[SchemaSummary]:
        if isinstance(self._parent_storage_schema, Unset):
            raise NotPresentError(self, "parent_storage_schema")
        return self._parent_storage_schema

    @parent_storage_schema.setter
    def parent_storage_schema(self, value: Optional[SchemaSummary]) -> None:
        self._parent_storage_schema = value

    @parent_storage_schema.deleter
    def parent_storage_schema(self) -> None:
        self._parent_storage_schema = UNSET

    @property
    def project_id(self) -> Optional[str]:
        if isinstance(self._project_id, Unset):
            raise NotPresentError(self, "project_id")
        return self._project_id

    @project_id.setter
    def project_id(self, value: Optional[str]) -> None:
        self._project_id = value

    @project_id.deleter
    def project_id(self) -> None:
        self._project_id = UNSET

    @property
    def quantity(self) -> ContainerQuantity:
        """ Quantity of a container, well, or transfer. Supports mass, volume, and other quantities. """
        if isinstance(self._quantity, Unset):
            raise NotPresentError(self, "quantity")
        return self._quantity

    @quantity.setter
    def quantity(self, value: ContainerQuantity) -> None:
        self._quantity = value

    @quantity.deleter
    def quantity(self) -> None:
        self._quantity = UNSET

    @property
    def schema(self) -> Optional[SchemaSummary]:
        if isinstance(self._schema, Unset):
            raise NotPresentError(self, "schema")
        return self._schema

    @schema.setter
    def schema(self, value: Optional[SchemaSummary]) -> None:
        self._schema = value

    @schema.deleter
    def schema(self) -> None:
        self._schema = UNSET

    @property
    def volume(self) -> DeprecatedContainerVolumeForResponse:
        if isinstance(self._volume, Unset):
            raise NotPresentError(self, "volume")
        return self._volume

    @volume.setter
    def volume(self, value: DeprecatedContainerVolumeForResponse) -> None:
        self._volume = value

    @volume.deleter
    def volume(self) -> None:
        self._volume = UNSET

    @property
    def web_url(self) -> str:
        if isinstance(self._web_url, Unset):
            raise NotPresentError(self, "web_url")
        return self._web_url

    @web_url.setter
    def web_url(self, value: str) -> None:
        self._web_url = value

    @web_url.deleter
    def web_url(self) -> None:
        self._web_url = UNSET
