from setuptools import setup, find_packages


setup(
    name='collabutils',
    version='0.1.0',
    license='Apache 2.0',
    description='Utilities for collaborative data curation',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
    ],
    author='Robert Forkel',
    author_email='robert_forkel@eva.mpg.de',
    url='',
    keywords='data',
    packages=find_packages(where='src'),
    package_dir={'': 'src'},
    include_package_data=True,
    zip_safe=False,
    platforms='any',
    python_requires='>=3.6',
    install_requires=[
        'attrs>=19.3',
        'clldutils>=3.5',
        'csvw',
        'pycldf',
    ],
    extras_require={
        'googlesheets': ['gspread>=3.7'],
        'owncloud': ['pyocclient', 'openpyxl'],
        'zotero': ['pyzotero', 'pybtex'],
        'dev': ['flake8', 'wheel', 'twine'],
        'test': [
            'pytest>=4.3',
            'pytest-mock',
            'pytest-cov',
            'coverage>=4.2',
            'gspread',
            'pyocclient',
            'openpyxl',
            'pybtex',
            'pyzotero',
        ],
    },
)
