# dmss-api
API for basic data modelling interaction

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.3.4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dmss_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dmss_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import dmss_api
from pprint import pprint
from dmss_api.api import default_api
from dmss_api.model.add_to_parent_request import AddToParentRequest
from dmss_api.model.data_source_request import DataSourceRequest
from dmss_api.model.entity_name import EntityName
from dmss_api.model.get_document_response import GetDocumentResponse
from dmss_api.model.http_validation_error import HTTPValidationError
from dmss_api.model.move_request import MoveRequest
from dmss_api.model.remove_by_path_request import RemoveByPathRequest
from dmss_api.model.remove_request import RemoveRequest
from dmss_api.model.rename_request import RenameRequest
from dmss_api.model.search_data_request import SearchDataRequest
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = dmss_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with dmss_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    data_source_id = "data_source_id_example" # str | 
blob_id = "blob_id_example" # str | 

    try:
        # Get By Id
        api_response = api_instance.blob_get_by_id(data_source_id, blob_id)
        pprint(api_response)
    except dmss_api.ApiException as e:
        print("Exception when calling DefaultApi->blob_get_by_id: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**blob_get_by_id**](docs/DefaultApi.md#blob_get_by_id) | **GET** /api/v1/blobs/{data_source_id}/{blob_id} | Get By Id
*DefaultApi* | [**blueprint_get**](docs/DefaultApi.md#blueprint_get) | **GET** /api/v1/blueprint/{type_ref} | Get Blueprint
*DefaultApi* | [**data_source_get**](docs/DefaultApi.md#data_source_get) | **GET** /api/v1/data-sources/{data_source_id} | Get
*DefaultApi* | [**data_source_get_all**](docs/DefaultApi.md#data_source_get_all) | **GET** /api/v1/data-sources | Get All
*DefaultApi* | [**data_source_save**](docs/DefaultApi.md#data_source_save) | **POST** /api/v1/data-sources/{data_source_id} | Save
*DefaultApi* | [**document_get_by_id**](docs/DefaultApi.md#document_get_by_id) | **GET** /api/v1/documents/{data_source_id}/{document_id} | Get By Id
*DefaultApi* | [**document_get_by_path**](docs/DefaultApi.md#document_get_by_path) | **GET** /api/v1/documents-by-path/{data_source_id} | Get By Path
*DefaultApi* | [**document_update**](docs/DefaultApi.md#document_update) | **PUT** /api/v1/documents/{data_source_id}/{document_id} | Update
*DefaultApi* | [**explorer_add_document**](docs/DefaultApi.md#explorer_add_document) | **POST** /api/v1/explorer/{data_source_id}/add-document | Add Document
*DefaultApi* | [**explorer_add_package**](docs/DefaultApi.md#explorer_add_package) | **POST** /api/v1/explorer/{data_source_id}/add-package | Add Package
*DefaultApi* | [**explorer_add_raw**](docs/DefaultApi.md#explorer_add_raw) | **POST** /api/v1/explorer/{data_source_id}/add-raw | Add Raw
*DefaultApi* | [**explorer_add_to_parent**](docs/DefaultApi.md#explorer_add_to_parent) | **POST** /api/v1/explorer/{data_source_id}/add-to-parent | Add To Parent
*DefaultApi* | [**explorer_add_to_path**](docs/DefaultApi.md#explorer_add_to_path) | **POST** /api/v1/explorer/{data_source_id}/add-to-path | Add To Path
*DefaultApi* | [**explorer_move**](docs/DefaultApi.md#explorer_move) | **POST** /api/v1/explorer/{data_source_id}/move | Move
*DefaultApi* | [**explorer_remove**](docs/DefaultApi.md#explorer_remove) | **POST** /api/v1/explorer/{data_source_id}/remove | Remove
*DefaultApi* | [**explorer_remove_by_path**](docs/DefaultApi.md#explorer_remove_by_path) | **POST** /api/v1/explorer/{data_source_id}/remove-by-path | Remove By Path
*DefaultApi* | [**explorer_rename**](docs/DefaultApi.md#explorer_rename) | **PUT** /api/v1/explorer/{data_source_id}/rename | Rename
*DefaultApi* | [**package_find_by_name**](docs/DefaultApi.md#package_find_by_name) | **GET** /api/v1/packages/{data_source_id}/findByName/{name} | Find By Name
*DefaultApi* | [**package_get**](docs/DefaultApi.md#package_get) | **GET** /api/v1/packages/{data_source_id} | Get
*DefaultApi* | [**search**](docs/DefaultApi.md#search) | **POST** /api/v1/search/{data_source_id} | Search


## Documentation For Models

 - [AddToParentRequest](docs/AddToParentRequest.md)
 - [DataSourceRequest](docs/DataSourceRequest.md)
 - [DataSourceType](docs/DataSourceType.md)
 - [EntityName](docs/EntityName.md)
 - [GetDocumentResponse](docs/GetDocumentResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [MoveRequest](docs/MoveRequest.md)
 - [RemoveByPathRequest](docs/RemoveByPathRequest.md)
 - [RemoveRequest](docs/RemoveRequest.md)
 - [RenameRequest](docs/RenameRequest.md)
 - [Repository](docs/Repository.md)
 - [SearchDataRequest](docs/SearchDataRequest.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in dmss_api.apis and dmss_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from dmss_api.api.default_api import DefaultApi`
- `from dmss_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import dmss_api
from dmss_api.apis import *
from dmss_api.models import *
```

