"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Polycons = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const internal_1 = require("./internal");
/**
 * Functions for resolving polycons (polymorphic constructs) into
 * specific constructs.
 */
class Polycons {
    constructor() { }
    /**
     * Adds a factory at given scope. This factory will be used for resolving
     * polycons under this scope into constructs.
     */
    static register(scope, factory) {
        const existing = scope[internal_1.FACTORY_SYMBOL];
        if (existing !== undefined) {
            throw new Error("There is already a polycon factory registered in this scope.");
        }
        Object.defineProperty(scope, internal_1.FACTORY_SYMBOL, {
            value: factory,
            enumerable: false,
            writable: false,
        });
    }
    /**
     * Creates a new instance of a polycon. The polycon is resolved using the
     * polycon factory that is registered nearest to it in the tree.
     *
     * For example, if a construct tree has Root -> Parent -> MyPoly, and FactoryA
     * is registered to Root while FactoryB is registered to Parent, then
     * FactoryB will be used to resolve MyPoly.
     *
     * @param type The type identifier
     * @param scope The construct scope
     * @param id The construct identifier
     * @param args The rest of the construct's arguments
     * @returns The resolved construct
     */
    static newInstance(type, scope, id, ...args) {
        if (!scope) {
            throw new Error(`Cannot construct a polycon with a scope of "${scope}". Check that the correct arguments were passed to the constructor.`);
        }
        const factory = internal_1.polyconFactoryOf(scope);
        if (!factory) {
            throw new Error(`Cannot find a Polycon factory registered to the scope "${scope.node.path}" or its parent scopes.`);
        }
        return factory.resolve(type, scope, id, ...args);
    }
}
exports.Polycons = Polycons;
_a = JSII_RTTI_SYMBOL_1;
Polycons[_a] = { fqn: "polycons.Polycons", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9seWNvbi1mYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3BvbHljb24tZmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHlDQUE4RDtBQUU5RDs7O0dBR0c7QUFDSCxNQUFhLFFBQVE7SUF3RG5CLGdCQUF1QixDQUFDO0lBdkR4Qjs7O09BR0c7SUFDSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQWlCLEVBQUUsT0FBd0I7UUFDaEUsTUFBTSxRQUFRLEdBQUksS0FBYSxDQUFDLHlCQUFjLENBQUMsQ0FBQztRQUNoRCxJQUFJLFFBQVEsS0FBSyxTQUFTLEVBQUU7WUFDMUIsTUFBTSxJQUFJLEtBQUssQ0FDYiw4REFBOEQsQ0FDL0QsQ0FBQztTQUNIO1FBRUQsTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUseUJBQWMsRUFBRTtZQUMzQyxLQUFLLEVBQUUsT0FBTztZQUNkLFVBQVUsRUFBRSxLQUFLO1lBQ2pCLFFBQVEsRUFBRSxLQUFLO1NBQ2hCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksTUFBTSxDQUFDLFdBQVcsQ0FDdkIsSUFBWSxFQUNaLEtBQWlCLEVBQ2pCLEVBQVUsRUFDVixHQUFHLElBQVc7UUFFZCxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ1YsTUFBTSxJQUFJLEtBQUssQ0FDYiwrQ0FBK0MsS0FBSyxxRUFBcUUsQ0FDMUgsQ0FBQztTQUNIO1FBRUQsTUFBTSxPQUFPLEdBQUcsMkJBQWdCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDeEMsSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNaLE1BQU0sSUFBSSxLQUFLLENBQ2IsMERBQTBELEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSx5QkFBeUIsQ0FDbkcsQ0FBQztTQUNIO1FBRUQsT0FBTyxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFLEdBQUcsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQzs7QUF0REgsNEJBeURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBGQUNUT1JZX1NZTUJPTCwgcG9seWNvbkZhY3RvcnlPZiB9IGZyb20gXCIuL2ludGVybmFsXCI7XG5cbi8qKlxuICogRnVuY3Rpb25zIGZvciByZXNvbHZpbmcgcG9seWNvbnMgKHBvbHltb3JwaGljIGNvbnN0cnVjdHMpIGludG9cbiAqIHNwZWNpZmljIGNvbnN0cnVjdHMuXG4gKi9cbmV4cG9ydCBjbGFzcyBQb2x5Y29ucyB7XG4gIC8qKlxuICAgKiBBZGRzIGEgZmFjdG9yeSBhdCBnaXZlbiBzY29wZS4gVGhpcyBmYWN0b3J5IHdpbGwgYmUgdXNlZCBmb3IgcmVzb2x2aW5nXG4gICAqIHBvbHljb25zIHVuZGVyIHRoaXMgc2NvcGUgaW50byBjb25zdHJ1Y3RzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWdpc3RlcihzY29wZTogSUNvbnN0cnVjdCwgZmFjdG9yeTogSVBvbHljb25GYWN0b3J5KSB7XG4gICAgY29uc3QgZXhpc3RpbmcgPSAoc2NvcGUgYXMgYW55KVtGQUNUT1JZX1NZTUJPTF07XG4gICAgaWYgKGV4aXN0aW5nICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgXCJUaGVyZSBpcyBhbHJlYWR5IGEgcG9seWNvbiBmYWN0b3J5IHJlZ2lzdGVyZWQgaW4gdGhpcyBzY29wZS5cIlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoc2NvcGUsIEZBQ1RPUllfU1lNQk9MLCB7XG4gICAgICB2YWx1ZTogZmFjdG9yeSxcbiAgICAgIGVudW1lcmFibGU6IGZhbHNlLFxuICAgICAgd3JpdGFibGU6IGZhbHNlLFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgYSBwb2x5Y29uLiBUaGUgcG9seWNvbiBpcyByZXNvbHZlZCB1c2luZyB0aGVcbiAgICogcG9seWNvbiBmYWN0b3J5IHRoYXQgaXMgcmVnaXN0ZXJlZCBuZWFyZXN0IHRvIGl0IGluIHRoZSB0cmVlLlxuICAgKlxuICAgKiBGb3IgZXhhbXBsZSwgaWYgYSBjb25zdHJ1Y3QgdHJlZSBoYXMgUm9vdCAtPiBQYXJlbnQgLT4gTXlQb2x5LCBhbmQgRmFjdG9yeUFcbiAgICogaXMgcmVnaXN0ZXJlZCB0byBSb290IHdoaWxlIEZhY3RvcnlCIGlzIHJlZ2lzdGVyZWQgdG8gUGFyZW50LCB0aGVuXG4gICAqIEZhY3RvcnlCIHdpbGwgYmUgdXNlZCB0byByZXNvbHZlIE15UG9seS5cbiAgICpcbiAgICogQHBhcmFtIHR5cGUgVGhlIHR5cGUgaWRlbnRpZmllclxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIGNvbnN0cnVjdCBzY29wZVxuICAgKiBAcGFyYW0gaWQgVGhlIGNvbnN0cnVjdCBpZGVudGlmaWVyXG4gICAqIEBwYXJhbSBhcmdzIFRoZSByZXN0IG9mIHRoZSBjb25zdHJ1Y3QncyBhcmd1bWVudHNcbiAgICogQHJldHVybnMgVGhlIHJlc29sdmVkIGNvbnN0cnVjdFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBuZXdJbnN0YW5jZShcbiAgICB0eXBlOiBzdHJpbmcsXG4gICAgc2NvcGU6IElDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICAuLi5hcmdzOiBhbnlbXVxuICApIHtcbiAgICBpZiAoIXNjb3BlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBDYW5ub3QgY29uc3RydWN0IGEgcG9seWNvbiB3aXRoIGEgc2NvcGUgb2YgXCIke3Njb3BlfVwiLiBDaGVjayB0aGF0IHRoZSBjb3JyZWN0IGFyZ3VtZW50cyB3ZXJlIHBhc3NlZCB0byB0aGUgY29uc3RydWN0b3IuYFxuICAgICAgKTtcbiAgICB9XG5cbiAgICBjb25zdCBmYWN0b3J5ID0gcG9seWNvbkZhY3RvcnlPZihzY29wZSk7XG4gICAgaWYgKCFmYWN0b3J5KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBDYW5ub3QgZmluZCBhIFBvbHljb24gZmFjdG9yeSByZWdpc3RlcmVkIHRvIHRoZSBzY29wZSBcIiR7c2NvcGUubm9kZS5wYXRofVwiIG9yIGl0cyBwYXJlbnQgc2NvcGVzLmBcbiAgICAgICk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGZhY3RvcnkucmVzb2x2ZSh0eXBlLCBzY29wZSwgaWQsIC4uLmFyZ3MpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHt9XG59XG5cbi8qKlxuICogQSBmYWN0b3J5IHRoYXQgZGV0ZXJtaW5lcyBob3cgdG8gdHVybiBwb2x5Y29ucyBpbnRvIGNvbmNyZXRlIGNvbnN0cnVjdHMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVBvbHljb25GYWN0b3J5IHtcbiAgLyoqXG4gICAqIFJlc29sdmUgdGhlIHBhcmFtZXRlcnMgbmVlZGVkIGZvciBjcmVhdGluZyBhIHNwZWNpZmljIHBvbHljb24gaW50byBhXG4gICAqIGNvbmNyZXRlIGNvbnN0cnVjdC5cbiAgICpcbiAgICogQHBhcmFtIHR5cGUgVGhlIHR5cGUgaWRlbnRpZmllclxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIGNvbnN0cnVjdCBzY29wZVxuICAgKiBAcGFyYW0gaWQgVGhlIGNvbnN0cnVjdCBpZGVudGlmaWVyXG4gICAqIEBwYXJhbSBhcmdzIFRoZSByZXN0IG9mIHRoZSBjb25zdHJ1Y3QncyBhcmd1bWVudHNcbiAgICogQHJldHVybnMgVGhlIHJlc29sdmVkIGNvbnN0cnVjdFxuICAgKi9cbiAgcmVzb2x2ZShcbiAgICB0eXBlOiBzdHJpbmcsXG4gICAgc2NvcGU6IElDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICAuLi5hcmdzOiBhbnlbXVxuICApOiBJQ29uc3RydWN0O1xufVxuIl19