"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.polyconFactoryOf = exports.FACTORY_SYMBOL = void 0;
exports.FACTORY_SYMBOL = Symbol.for("polycons.PolyconFactory");
/**
 * Returns the nearest polycon factory registered in a given scope.
 */
function polyconFactoryOf(scope) {
    const factory = scope[exports.FACTORY_SYMBOL];
    if (factory) {
        return factory;
    }
    const parent = scope.node.scope;
    if (!parent) {
        return undefined;
    }
    return polyconFactoryOf(parent);
}
exports.polyconFactoryOf = polyconFactoryOf;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZXJuYWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW50ZXJuYWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR2EsUUFBQSxjQUFjLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0FBRXBFOztHQUVHO0FBQ0gsU0FBZ0IsZ0JBQWdCLENBQzlCLEtBQWlCO0lBRWpCLE1BQU0sT0FBTyxHQUFJLEtBQWEsQ0FBQyxzQkFBYyxDQUFvQixDQUFDO0lBRWxFLElBQUksT0FBTyxFQUFFO1FBQ1gsT0FBTyxPQUFPLENBQUM7S0FDaEI7SUFFRCxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNoQyxJQUFJLENBQUMsTUFBTSxFQUFFO1FBQ1gsT0FBTyxTQUFTLENBQUM7S0FDbEI7SUFFRCxPQUFPLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBQ2xDLENBQUM7QUFmRCw0Q0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgSVBvbHljb25GYWN0b3J5IH0gZnJvbSBcIi4vcG9seWNvbi1mYWN0b3J5XCI7XG5cbmV4cG9ydCBjb25zdCBGQUNUT1JZX1NZTUJPTCA9IFN5bWJvbC5mb3IoXCJwb2x5Y29ucy5Qb2x5Y29uRmFjdG9yeVwiKTtcblxuLyoqXG4gKiBSZXR1cm5zIHRoZSBuZWFyZXN0IHBvbHljb24gZmFjdG9yeSByZWdpc3RlcmVkIGluIGEgZ2l2ZW4gc2NvcGUuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBwb2x5Y29uRmFjdG9yeU9mKFxuICBzY29wZTogSUNvbnN0cnVjdFxuKTogSVBvbHljb25GYWN0b3J5IHwgdW5kZWZpbmVkIHtcbiAgY29uc3QgZmFjdG9yeSA9IChzY29wZSBhcyBhbnkpW0ZBQ1RPUllfU1lNQk9MXSBhcyBJUG9seWNvbkZhY3Rvcnk7XG5cbiAgaWYgKGZhY3RvcnkpIHtcbiAgICByZXR1cm4gZmFjdG9yeTtcbiAgfVxuXG4gIGNvbnN0IHBhcmVudCA9IHNjb3BlLm5vZGUuc2NvcGU7XG4gIGlmICghcGFyZW50KSB7XG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuXG4gIHJldHVybiBwb2x5Y29uRmFjdG9yeU9mKHBhcmVudCk7XG59XG4iXX0=