import os
import logging

from thug.ThugAPI.ThugAPI import ThugAPI

log = logging.getLogger("Thug")


class TestExploitSamples(object):
    cwd_path      = os.path.dirname(os.path.realpath(__file__))
    exploits_path = os.path.join(cwd_path, os.pardir, "samples/exploits")

    def do_perform_test(self, caplog, sample, expected):
        thug = ThugAPI()

        thug.set_useragent('win7ie90')
        thug.set_events('click,storage')
        thug.set_json_logging()
        thug.set_features_logging()
        thug.set_ssl_verify()
        thug.set_connect_timeout(2)
        thug.log_init(sample)
        thug.run_local(sample)

        records = [r.message for r in caplog.records]

        matches = 0

        for e in expected:
            for record in records:
                if e in record:
                    matches += 1

        assert matches >= len(expected)

    def test_22196(self, caplog):
        sample   = os.path.join(self.exploits_path, "22196.html")
        expected = ["[NCTAudioFile2 ActiveX] Overflow in SetFormatLikeSample",
                    "WinExec",
                    "ExitThread",
                    "calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_22811_Elazar(self, caplog):
        sample   = os.path.join(self.exploits_path, "22811_Elazar.html")
        expected = ["RealMedia RealPlayer Ierpplug.DLL ActiveX",
                    "Overflow in Import",
                    "Overflow in PlayerProperty"]

        self.do_perform_test(caplog, sample, expected)

    def test_2448(self, caplog):
        sample   = os.path.join(self.exploits_path, "2448.html")
        expected = ["[WebViewFolderIcon ActiveX] setSlice attack",
                    "webviewfoldericon.webviewfoldericon.1"]

        self.do_perform_test(caplog, sample, expected)

    def test_2mix(self, caplog):
        sample   = os.path.join(self.exploits_path, "2mix.html")
        expected = ["[Microsoft Access Snapshot Viewer ActiveX] SnapshotPath : http://paksusic.cn/nuc/exe.php",
                    "CompressedPath: C:/Program Files/Outlook Express/wab.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_33243_excel(self, caplog):
        sample   = os.path.join(self.exploits_path, "33243-excel.html")
        expected = ["[Office OCX Exploit redirection] about:blank -> http://192.168.1.100/putty.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_33243_office(self, caplog):
        sample   = os.path.join(self.exploits_path, "33243-office.html")
        expected = ["[Office OCX Exploit redirection] about:blank -> http://www.example.com/file.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_33243_powerpoint(self, caplog):
        sample   = os.path.join(self.exploits_path, "33243-powerpoint.html")
        expected = ["[Office OCX Exploit redirection] about:blank -> http://www.example.com/file.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_33243_word(self, caplog):
        sample   = os.path.join(self.exploits_path, "33243-word.html")
        expected = ["[Office OCX Exploit redirection] about:blank -> http://www.example.com/calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_4042(self, caplog):
        sample   = os.path.join(self.exploits_path, "4042.html")
        expected = ["[Yahoo! Messenger 8.x Ywcvwr ActiveX] Server Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_4043(self, caplog):
        sample   = os.path.join(self.exploits_path, "4043.html")
        expected = ["[Yahoo! Messenger 8.x Ywcvwr ActiveX] Server Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_4148(self, caplog):
        sample   = os.path.join(self.exploits_path, "4148.html")
        expected = ["[EnjoySAP ActiveX] PrepareToPostHTML overflow in arg"]

        self.do_perform_test(caplog, sample, expected)

    def test_4149(self, caplog):
        sample   = os.path.join(self.exploits_path, "4149.html")
        expected = ["[EnjoySAP ActiveX] LaunchGUI overflow in arg0"]

        self.do_perform_test(caplog, sample, expected)

    def test_4150(self, caplog):
        sample   = os.path.join(self.exploits_path, "4150.html")
        expected = ["[EnjoySAP ActiveX] Fetching from URL http://192.168.1.100/putty.exe", ]

        self.do_perform_test(caplog, sample, expected)

    def test_4158(self, caplog):
        sample   = os.path.join(self.exploits_path, "4158.html")
        expected = ["[NeoTraceExplorer.NeoTraceLoader ActiveX] Overflow in arg0"]

        self.do_perform_test(caplog, sample, expected)

    def test_4230(self, caplog):
        sample   = os.path.join(self.exploits_path, "4230.html")
        expected = ["[Nessus Vunlnerability Scanner ScanCtrl ActiveX] deleteReport(../../../../../../../test.txt)"]

        self.do_perform_test(caplog, sample, expected)

    def test_4237(self, caplog):
        sample   = os.path.join(self.exploits_path, "4237.html")
        expected = ["[Nessus Vunlnerability Scanner ScanCtrl ActiveX] saveNessusRC(../../../../../../Documents and Settings/All Users/Menu Start/Programy/Autostart/exec.bat)"]

        self.do_perform_test(caplog, sample, expected)

    def test_4250(self, caplog):
        sample   = os.path.join(self.exploits_path, "4250.html")
        expected = ["[Yahoo! Messenger 8.x Ywcvwr ActiveX] GetComponentVersion Overflow",
                    "LoadLibraryA",
                    "port = 4444",
                    "CreateProcess",
                    "cmd"]

        self.do_perform_test(caplog, sample, expected)

    def test_4351(self, caplog):
        sample   = os.path.join(self.exploits_path, "4351.html")
        expected = ["[Yahoo! Messenger 8.x YVerInfo.dll ActiveX Control] Overflow in fvCom arg0",
                    "WinExec",
                    "calc"]

        self.do_perform_test(caplog, sample, expected)

    def test_4427(self, caplog):
        sample   = os.path.join(self.exploits_path, "4427.html")
        expected = [r"[JetAudio ActiveX] Downloading from URL http://192.168.0.1/evil.mp3 (saving locally as ..\..\..\..\..\..\..\..\Program Files\JetAudio\JetAudio.exe)"]

        self.do_perform_test(caplog, sample, expected)

    def test_4594(self, caplog):
        sample   = os.path.join(self.exploits_path, "4594.html")
        expected = ["[SonicWall SSL-VPN NetExtender NELaunchCtrl ActiveX] Overflow in AddRouteEntry",
                    "WinExec",
                    "calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_4613(self, caplog):
        sample   = os.path.join(self.exploits_path, "4613.html")
        expected = ["[Shockwave] ShockwaveVersion Stack Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_4663(self, caplog):
        sample   = os.path.join(self.exploits_path, "4663.html")
        expected = ["[BitDefender Online Scanner ActiveX] InitX overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_4829(self, caplog):
        sample   = os.path.join(self.exploits_path, "4829.html")
        expected = ["[DivX Player ActiveX] Overflow in SetPassword"]

        self.do_perform_test(caplog, sample, expected)

    def test_4869(self, caplog):
        sample   = os.path.join(self.exploits_path, "4869.html")
        expected = [r"[Gateway Weblaunch ActiveX] Trying to execute ..\..\..\..\windows\system32\calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_4894(self, caplog):
        sample   = os.path.join(self.exploits_path, "4894.html")
        expected = ["[StreamAudio ChainCast VMR Client Proxy ActiveX] Buffer overflow in arg0"]

        self.do_perform_test(caplog, sample, expected)

    def test_4903(self, caplog):
        sample   = os.path.join(self.exploits_path, "4903.html")
        expected = ["[DVRHOST Web CMS OCX ActiveX] Overflow in TimeSpanFormat",
                    "WinExec",
                    "cmd.exe /c net user sun tzu /ADD && net localgroup Administrators sun /ADD"]

        self.do_perform_test(caplog, sample, expected)

    def test_4909(self, caplog):
        sample   = os.path.join(self.exploits_path, "4909.html")
        expected = ["[Macrovision Exploit 2 redirection] about:blank -> http://www.evilsite/evil.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_4918(self, caplog):
        sample   = os.path.join(self.exploits_path, "4918.html")
        expected = ["[PTZCamPanel ActiveX] Overflow in ConnectServer user arg"]

        self.do_perform_test(caplog, sample, expected)

    def test_4932(self, caplog):
        sample   = os.path.join(self.exploits_path, "4932.html")
        expected = ["[RTSP MPEG4 SP Control ActiveX] Overflow in MP4Prefix property"]

        self.do_perform_test(caplog, sample, expected)

    def test_4967(self, caplog):
        sample   = os.path.join(self.exploits_path, "4967.html")
        expected = ["[Lycos FileUploader ActiveX] Overflow in HandwriterFilename property"]

        self.do_perform_test(caplog, sample, expected)

    def test_4974(self, caplog):
        sample   = os.path.join(self.exploits_path, "4974.html")
        expected = ['[Comodo AntiVirus ActiveX] Trying to execute: cmd.exe /C echo "hello world" && pause']

        self.do_perform_test(caplog, sample, expected)

    def test_4979(self, caplog):
        sample   = os.path.join(self.exploits_path, "4979.html")
        expected = ["[Move Networks Upgrade Manager ActiveX] Overflow in Upgrade"]

        self.do_perform_test(caplog, sample, expected)

    def test_4982(self, caplog):
        sample   = os.path.join(self.exploits_path, "4982.html")
        expected = ["[Gateway Weblaunch ActiveX] Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_4986(self, caplog):
        sample   = os.path.join(self.exploits_path, "4986.html")
        expected = ["[NamoInstaller ActiveX] Insecure download from URL http://ATTACKER.COM/HACK.EXE"]

        self.do_perform_test(caplog, sample, expected)

    def test_4987(self, caplog):
        sample   = os.path.join(self.exploits_path, "4987.html")
        expected = ["[XUpload ActiveX] Overflow in AddFile method"]

        self.do_perform_test(caplog, sample, expected)

    def test_5025(self, caplog):
        sample   = os.path.join(self.exploits_path, "5025.html")
        expected = ["[Myspace UPloader ActiveX] Overflow in Action property"]

        self.do_perform_test(caplog, sample, expected)

    def test_5043(self, caplog):
        sample   = os.path.join(self.exploits_path, "5043.html")
        expected = ["[Yahoo! Music Jukebox ActiveX] Overflow in AddImage"]

        self.do_perform_test(caplog, sample, expected)

    def test_5045(self, caplog):
        sample   = os.path.join(self.exploits_path, "5045.html")
        expected = ["[NamoInstaller ActiveX] Overflow in Install method",
                    "WinExec",
                    "calc"]

        self.do_perform_test(caplog, sample, expected)

    def test_5049(self, caplog):
        sample   = os.path.join(self.exploits_path, "5049.html")
        expected = ["[FaceBook Photo Uploader ActiveX] Overflow in ExtractIptc property"]

        self.do_perform_test(caplog, sample, expected)

    def test_5051(self, caplog):
        sample   = os.path.join(self.exploits_path, "5051.html")
        expected = ["[Yahoo! Music Jukebox ActiveX] Overflow in AddButton"]

        self.do_perform_test(caplog, sample, expected)

    def test_5052(self, caplog):
        sample   = os.path.join(self.exploits_path, "5052.html")
        expected = ["[Yahoo! Music Jukebox ActiveX] Overflow in AddBitmap"]

        self.do_perform_test(caplog, sample, expected)

    def test_5153(self, caplog):
        sample   = os.path.join(self.exploits_path, "5153.html")
        expected = ["[Ourgame GLWorld ActiveX] Overflow in hgs_startNotify",
                    "WinExec",
                    "calc"]

        self.do_perform_test(caplog, sample, expected)

    def test_5188(self, caplog):
        sample   = os.path.join(self.exploits_path, "5188.html")
        expected = ["[Rising Online Virus Scanner Web Scan ActiveX] UpdateEngine Method vulnerability"]

        self.do_perform_test(caplog, sample, expected)

    def test_5190(self, caplog):
        sample   = os.path.join(self.exploits_path, "5190.html")
        expected = ["[Move Networks Quantum Streaming Player Control ActiveX] Overflow in UploadLogs method"]

        self.do_perform_test(caplog, sample, expected)

    def test_5193(self, caplog):
        sample   = os.path.join(self.exploits_path, "5193.html")
        expected = ["[D-Link MPEG4 SHM Audio Control ActiveX] Overflow in Url property"]

        self.do_perform_test(caplog, sample, expected)

    def test_5205(self, caplog):
        sample   = os.path.join(self.exploits_path, "5205.html")
        expected = ["[Symantec BackupExec ActiveX] Overflow in property _DOWText0"]

        self.do_perform_test(caplog, sample, expected)

    def test_5217(self, caplog):
        sample   = os.path.join(self.exploits_path, "5217.html")
        expected = ["[ICQ Toolbar ActiveX] Buffer overflow in GetPropertyById"]

        self.do_perform_test(caplog, sample, expected)

    def test_5225(self, caplog):
        sample   = os.path.join(self.exploits_path, "5225.html")
        expected = ["[Kingsoft AntiVirus ActiveX] SetUninstallName Heap Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_5264(self, caplog):
        sample   = os.path.join(self.exploits_path, "5264.html")
        expected = ["[CA BrightStor ActiveX] Overflow in AddColumn"]

        self.do_perform_test(caplog, sample, expected)

    def test_5271(self, caplog):
        sample   = os.path.join(self.exploits_path, "5271.html")
        expected = ["[RegistryPro ActiveX] About called",
                    "[RegistryPro ActiveX] Deleting [HKEY_LOCAL_MACHINE/Software/key]"]

        self.do_perform_test(caplog, sample, expected)

    def test_5272(self, caplog):
        sample   = os.path.join(self.exploits_path, "5272.html")
        expected = ["[Universal HTTP File Upload ActiveX] Deleting C:/tmp.txt"]

        self.do_perform_test(caplog, sample, expected)

    def test_55875(self, caplog):
        sample   = os.path.join(self.exploits_path, "55875.html")
        expected = ["[iframe redirection] about:blank -> http://81.95.149.27/go.php?sid=1"]

        self.do_perform_test(caplog, sample, expected)

    def test_ARCserve_AddColumn_BoF(self, caplog):
        sample   = os.path.join(self.exploits_path, "ARCserve_AddColumn_BoF.html")
        expected = ["[CA BrightStor ActiveX] Overflow in AddColumn"]

        self.do_perform_test(caplog, sample, expected)

    def test_AnswerWorks(self, caplog):
        sample   = os.path.join(self.exploits_path, "AnswerWorks.htm")
        expected = ["[AnswerWorks ActiveX] Overflow in GetHistory" , ]

        self.do_perform_test(caplog, sample, expected)

    def test_AnswerWorks2(self, caplog):
        sample   = os.path.join(self.exploits_path, "AnswerWorks2.htm")
        expected = ["[AnswerWorks ActiveX] Overflow in GetSeedQuery" , ]

        self.do_perform_test(caplog, sample, expected)

    def test_AnswerWorks3(self, caplog):
        sample   = os.path.join(self.exploits_path, "AnswerWorks3.htm")
        expected = ["[AnswerWorks ActiveX] Overflow in SetSeedQuery" , ]

        self.do_perform_test(caplog, sample, expected)

    def test_AolICQ(self, caplog):
        sample   = os.path.join(self.exploits_path, "AolICQ.htm")
        expected = ['[AOL ICQ ActiveX] Arbitrary File Download and Execute', ]

        self.do_perform_test(caplog, sample, expected)

    def test_BaiduBar(self, caplog):
        sample   = os.path.join(self.exploits_path, "BaiduBar.htm")
        expected = ["[BaiduBar.dll ActiveX] DloadDS function trying to download http://ruder.cdut.net/attach/calc.cab"]

        self.do_perform_test(caplog, sample, expected)

    def test_BitDefender(self, caplog):
        sample   = os.path.join(self.exploits_path, "BitDefender.htm")
        expected = ["[BitDefender Online Scanner ActiveX] InitX overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_CABrightStor(self, caplog):
        sample   = os.path.join(self.exploits_path, "CABrightStor.htm")
        expected = ["[CA BrightStor ActiveX] Overflow in AddColumn"]

        self.do_perform_test(caplog, sample, expected)

    def test_Comodo(self, caplog):
        sample   = os.path.join(self.exploits_path, "Comodo.htm")
        expected = ['[Comodo AntiVirus ActiveX] Trying to execute: cmd.exe /C echo "hello world" && pause']

        self.do_perform_test(caplog, sample, expected)

    def test_ConnectAndEnterRoom(self, caplog):
        sample   = os.path.join(self.exploits_path, "ConnectAndEnterRoom.htm")
        expected = ["[GlobalLink ConnectAndEnterRoom ActiveX] ConnectAndEnterRoom Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_CreativeSoftAttack(self, caplog):
        sample   = os.path.join(self.exploits_path, "CreativeSoftAttack.htm")
        expected = ["[CreativeSoft ActiveX] Overflow in cachefolder property"]

        self.do_perform_test(caplog, sample, expected)

    def test_DLinkMPEG(self, caplog):
        sample   = os.path.join(self.exploits_path, "DLinkMPEG.htm")
        expected = ["[D-Link MPEG4 SHM Audio Control ActiveX] Overflow in Url property"]

        self.do_perform_test(caplog, sample, expected)

    def test_DPClient(self, caplog):
        sample   = os.path.join(self.exploits_path, "DPClient.htm")
        expected = ["[Xunlei DPClient.Vod.1 ActiveX] DownURL2 Method Buffer Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_DVRHOSTWeb(self, caplog):
        sample   = os.path.join(self.exploits_path, "DVRHOSTWeb.htm")
        expected = ["[DVRHOST Web CMS OCX ActiveX] Overflow in TimeSpanFormat",
                    "WinExec",
                    "cmd.exe /c net user sun tzu /ADD && net localgroup Administrators sun /ADD"]

        self.do_perform_test(caplog, sample, expected)

    def test_DirectShow(self, caplog):
        sample   = os.path.join(self.exploits_path, "DirectShow.htm")
        expected = ["[Microsoft DirectShow MPEG2TuneRequest ActiveX] Stack Overflow in data property"]

        self.do_perform_test(caplog, sample, expected)

    def test_DivX(self, caplog):
        sample   = os.path.join(self.exploits_path, "DivX.htm")
        expected = ["[DivX Player ActiveX] Overflow in SetPassword"]

        self.do_perform_test(caplog, sample, expected)

    def test_Domino(self, caplog):
        sample   = os.path.join(self.exploits_path, "Domino.htm")
        expected = ["[IBM Lotus Domino Web Access Control ActiveX] Overflow in General_ServerName property"]

        self.do_perform_test(caplog, sample, expected)

    def test_Domino2(self, caplog):
        sample   = os.path.join(self.exploits_path, "Domino2.htm")
        expected = ["[IBM Lotus Domino Web Access Control ActiveX] Overflow in General_JunctionName property"]

        self.do_perform_test(caplog, sample, expected)

    def test_Domino3(self, caplog):
        sample   = os.path.join(self.exploits_path, "Domino3.htm")
        expected = ["[IBM Lotus Domino Web Access Control ActiveX] Overflow in Mail_MailDbPath property"]

        self.do_perform_test(caplog, sample, expected)

    def test_FileUploader(self, caplog):
        sample   = os.path.join(self.exploits_path, "FileUploader.htm")
        expected = ["[Lycos FileUploader ActiveX] Overflow in HandwriterFilename property"]

        self.do_perform_test(caplog, sample, expected)

    def test_GatewayWeblaunch(self, caplog):
        sample   = os.path.join(self.exploits_path, "GatewayWeblaunch.htm")
        expected = [r"[Gateway Weblaunch ActiveX] Trying to execute ..\..\..\..\windows\system32\calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_GLIEDown2(self, caplog):
        sample   = os.path.join(self.exploits_path, "GLIEDown2.htm")
        expected = ["LoadLibraryA",
                    "URLDownloadToFile",
                    "http://www.baiduuo.cn/123/ok.exe",
                    "WinExec"]

        self.do_perform_test(caplog, sample, expected)

    def test_Gogago(self, caplog):
        sample   = os.path.join(self.exploits_path, "Gogago.html")
        expected = ["[Gogago YouTube Video Converter ActiveX] Buffer Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_Gogago2(self, caplog):
        sample   = os.path.join(self.exploits_path, "Gogago2.html")
        expected = ["WinExec",
                    "192.168.0.1",
                    "GetVersion",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_GomWeb(self, caplog):
        sample   = os.path.join(self.exploits_path, "GomWeb.htm")
        expected = ["[GOM Player Manager ActiveX] Overflow in OpenURL"]

        self.do_perform_test(caplog, sample, expected)

    def test_HPInfo_GetRegValue(self, caplog):
        sample   = os.path.join(self.exploits_path, "HPInfo_GetRegValue.htm")
        expected = ["[HP Info Center ActiveX] GetRegValue, reading: //"]

        self.do_perform_test(caplog, sample, expected)

    def test_HPInfo_LaunchApp(self, caplog):
        sample   = os.path.join(self.exploits_path, "HPInfo_LaunchApp.htm")
        expected = ["[HP Info Center ActiveX] LaunchApp called to run: c:\\windows\\system32\\cmd.exe /C c:\\ftpd.bat&del c:\\ftpd.bat&del c:\\ftpd&del c:\\malware.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_HPInfo_SetRegValue(self, caplog):
        sample   = os.path.join(self.exploits_path, "HPInfo_SetRegValue.htm")
        expected = ["[HP Info Center ActiveX] SetRegValue: None/None/None set to None"]

        self.do_perform_test(caplog, sample, expected)

    def test_IMWebControl(self, caplog):
        sample   = os.path.join(self.exploits_path, "IMWebControl.htm")
        expected = ["[iMesh IMWebControl ActiveX] NULL value in ProcessRequestEx",
                    "cmd.exe /c net user sun tzu /ADD && net localgroup Administrators sun /ADD"]

        self.do_perform_test(caplog, sample, expected)

    def test_InternetCleverSuite(self, caplog):
        sample   = os.path.join(self.exploits_path, "InternetCleverSuite.html")
        expected = ["[Clever Internet ActiveX Suite 6.2 (CLINETSUITEX6.OCX)] Arbitrary File Download/Overwrite Exploit", ]

        self.do_perform_test(caplog, sample, expected)

    def test_JavaActiveXMemoryCorruption(self, caplog):
        sample   = os.path.join(self.exploits_path, "JavaActiveXMemoryCorruption.html")
        expected = ["[Java Deployment Toolkit ActiveX] Java ActiveX component memory corruption (CVE-2013-2416)"]

        self.do_perform_test(caplog, sample, expected)

    def test_JetAudioDownloadFromMusicStore(self, caplog):
        sample   = os.path.join(self.exploits_path, "JetAudioDownloadFromMusicStore.htm")
        expected = [r"[JetAudio ActiveX] Downloading from URL http://192.168.0.1/evil.mp3 (saving locally as ..\..\..\..\..\..\..\..\Program Files\JetAudio\JetAudio.exe)"]

        self.do_perform_test(caplog, sample, expected)

    def test_Kingsoft(self, caplog):
        sample   = os.path.join(self.exploits_path, "Kingsoft.htm")
        expected = ["[Kingsoft AntiVirus ActiveX] SetUninstallName Heap Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_MacrovisionFlexNet(self, caplog):
        sample   = os.path.join(self.exploits_path, "MacrovisionFlexNet.htm")
        expected = ['[Macrovision ActiveX] AddFile("http://www.evilsite/evil.exe"',
                    r'"C:\Documents and Settings\All Users\Start Menu\Programs\Startup\harmless.exe")']

        self.do_perform_test(caplog, sample, expected)

    def test_MicrosoftWorks7Attack(self, caplog):
        sample   = os.path.join(self.exploits_path, "MicrosoftWorks7Attack.htm")
        expected = ["[MicrosoftWorks7 ActiveX] Overflow in WksPictureInterface property",
                    "WinExec",
                    "calc"]

        self.do_perform_test(caplog, sample, expected)

    def test_Move(self, caplog):
        sample   = os.path.join(self.exploits_path, "Move.htm")
        expected = ["[Move Networks Upgrade Manager ActiveX] Overflow in Upgrade"]

        self.do_perform_test(caplog, sample, expected)

    def test_MSVFP(self, caplog):
        sample   = os.path.join(self.exploits_path, "MSVFP.html")
        expected = ["[Microsoft VFP_OLE_Server ActiveX] Trying to run: calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_MyspaceUploader(self, caplog):
        sample   = os.path.join(self.exploits_path, "MyspaceUploader.htm")
        expected = ["[Myspace UPloader ActiveX] Overflow in Action property"]

        self.do_perform_test(caplog, sample, expected)

    def test_msrichtxt(self, caplog):
        sample   = os.path.join(self.exploits_path, "msrichtxt.html")
        expected = [r"[Microsoft Rich Textbox Control ActiveX] Writing to file C:\shinnai.bat",
                    "cmd.exe /c notepad.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_NCTAudioFile2(self, caplog):
        sample   = os.path.join(self.exploits_path, "NCTAudioFile2.htm")
        expected = ["[NCTAudioFile2 ActiveX] Overflow in SetFormatLikeSample"]

        self.do_perform_test(caplog, sample, expected)

    def test_NamoInstaller(self, caplog):
        sample   = os.path.join(self.exploits_path, "NamoInstaller.htm")
        expected = ["[NamoInstaller ActiveX] Insecure download from URL http://192.168.1.100/putty.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_NessusScanCtrl(self, caplog):
        sample   = os.path.join(self.exploits_path, "NessusScanCtrl.htm")
        expected = ["[Nessus Vunlnerability Scanner ScanCtrl ActiveX] saveNessusRC(../../../../../../Documents and Settings/All Users/Menu Start/Programy/Autostart/exec.bat)"]

        self.do_perform_test(caplog, sample, expected)

    def test_OurgameGLWorld(self, caplog):
        sample   = os.path.join(self.exploits_path, "OurgameGLWorld.html")
        expected = ["[Ourgame GLWorld ActiveX] Overflow in hgs_startNotify"]

        self.do_perform_test(caplog, sample, expected)

    def test_OurgameGLWorld2(self, caplog):
        sample   = os.path.join(self.exploits_path, "OurgameGLWorld2.htm")
        expected = ["[Ourgame GLWorld ActiveX] Overflow in hgs_startGame"]

        self.do_perform_test(caplog, sample, expected)

    def test_PPlayer(self, caplog):
        sample   = os.path.join(self.exploits_path, "PPlayer.htm")
        expected = ["[Xunlei Thunder PPlayer ActiveX] FlvPlayerUrl Property Handling Buffer Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_Pps2(self, caplog):
        sample   = os.path.join(self.exploits_path, "Pps2.html")
        expected = ["[Xunlei Thunder PPlayer ActiveX] Remote Overflow Exploit in Logo property"]

        self.do_perform_test(caplog, sample, expected)

    def test_Pps3(self, caplog):
        sample   = os.path.join(self.exploits_path, "Pps3.html")
        expected = ["[Xunlei Thunder PPlayer ActiveX] DownURL2 Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_PTZCamPanel(self, caplog):
        sample   = os.path.join(self.exploits_path, "PTZCamPanel.htm")
        expected = ["[PTZCamPanel ActiveX] Overflow in ConnectServer user arg"]

        self.do_perform_test(caplog, sample, expected)

    def test_QuantumStreaming(self, caplog):
        sample   = os.path.join(self.exploits_path, "QuantumStreaming.htm")
        expected = ["[Move Networks Quantum Streaming Player Control ActiveX] Overflow in UploadLogs method"]

        self.do_perform_test(caplog, sample, expected)

    def test_RediffBolDownloaderAttack(self, caplog):
        sample   = os.path.join(self.exploits_path, "RediffBolDownloaderAttack.htm")
        expected = ["[RediffBolDownloader ActiveX] Overflow in url property"]

        self.do_perform_test(caplog, sample, expected)

    def test_RegistryPro(self, caplog):
        sample   = os.path.join(self.exploits_path, "RegistryPro.htm")
        expected = ["[RegistryPro ActiveX] Deleting [HKEY_LOCAL_MACHINE/Software/key]"]

        self.do_perform_test(caplog, sample, expected)

    def test_RtspVaPgCtrl(self, caplog):
        sample   = os.path.join(self.exploits_path, "RtspVaPgCtrl.htm")
        expected = ["[RTSP MPEG4 SP Control ActiveX] Overflow in MP4Prefix property"]

        self.do_perform_test(caplog, sample, expected)

    def test_SSReaderPdg2_LoadPage(self, caplog):
        sample   = os.path.join(self.exploits_path, "SSReaderPdg2_LoadPage.htm")
        expected = ["LoadLibraryA",
                    "system32",
                    "URLDownloadToFile",
                    "WinExec",
                    "ExitThread"]

        self.do_perform_test(caplog, sample, expected)

    def test_SSReaderPdg2_Register(self, caplog):
        sample   = os.path.join(self.exploits_path, "SSReaderPdg2_Register.htm")
        expected = ["[SSReader Pdg2 ActiveX] Register Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_SinaDLoader(self, caplog):
        sample   = os.path.join(self.exploits_path, "SinaDLoader.htm")
        expected = ["[SinaDLoader Downloader ActiveX] Fetching from URL hxxp://dddd.nihao69.cn/down/ko.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_SonicWallNetExtenderAddRouteEntry(self, caplog):
        sample   = os.path.join(self.exploits_path, "SonicWallNetExtenderAddRouteEntry.htm")
        expected = ["[SonicWall SSL-VPN NetExtender NELaunchCtrl ActiveX] Overflow in AddRouteEntry",
                    "WinExec",
                    "calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_StormConfig(self, caplog):
        sample   = os.path.join(self.exploits_path, "StormConfig.htm")
        expected = ["[BaoFeng Storm ActiveX Control] SetAttributeValue Buffer Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_StreamAudioChainCast(self, caplog):
        sample   = os.path.join(self.exploits_path, "StreamAudioChainCast.htm")
        expected = ["[StreamAudio ChainCast VMR Client Proxy ActiveX] Buffer overflow in arg0"]

        self.do_perform_test(caplog, sample, expected)

    def test_SymantecAppStream(self, caplog):
        sample   = os.path.join(self.exploits_path, "SymantecAppStream.html")
        expected = ["[Symantec AppStream LaunchObj ActiveX] Arbitrary File Download and Execute"]

        self.do_perform_test(caplog, sample, expected)

    def test_SymantecBackupExec(self, caplog):
        sample   = os.path.join(self.exploits_path, "SymantecBackupExec.htm")
        expected = ["[Symantec BackupExec ActiveX] Overflow in property _DOWText0"]

        self.do_perform_test(caplog, sample, expected)

    def test_SymantecBackupExec2(self, caplog):
        sample   = os.path.join(self.exploits_path, "SymantecBackupExec2.htm")
        expected = ["[Symantec BackupExec ActiveX] Overflow in property _DOWText6"]

        self.do_perform_test(caplog, sample, expected)

    def test_SymantecBackupExec3(self, caplog):
        sample   = os.path.join(self.exploits_path, "SymantecBackupExec3.htm")
        expected = ["[Symantec BackupExec ActiveX] Overflow in property _MonthText0"]

        self.do_perform_test(caplog, sample, expected)

    def test_SymantecBackupExec4(self, caplog):
        sample   = os.path.join(self.exploits_path, "SymantecBackupExec4.htm")
        expected = ["[Symantec BackupExec ActiveX] Overflow in property _MonthText11"]

        self.do_perform_test(caplog, sample, expected)

    def test_Toshiba(self, caplog):
        sample   = os.path.join(self.exploits_path, "Toshiba.htm")
        expected = ["[Toshiba Surveillance RecordSend Class ActiveX] Overflow in SetPort"]

        self.do_perform_test(caplog, sample, expected)

    def test_UUSeeUpdate(self, caplog):
        sample   = os.path.join(self.exploits_path, "UUSeeUpdate.htm")
        expected = ["[UUsee UUPgrade ActiveX] Attack in Update Method"]

        self.do_perform_test(caplog, sample, expected)

    def test_UniversalUpload(self, caplog):
        sample   = os.path.join(self.exploits_path, "UniversalUpload.htm")
        expected = ["[Universal HTTP File Upload ActiveX] Deleting C:/tmp.txt"]

        self.do_perform_test(caplog, sample, expected)

    def test_VisualStudioDTE80(self, caplog):
        sample   = os.path.join(self.exploits_path, "VisualStudioDTE80.html")
        expected = ["[VisualStudio.DTE.8.0 ActiveX] CreateObject (Shell.Application)", ]

        self.do_perform_test(caplog, sample, expected)

    def test_VLC(self, caplog):
        sample   = os.path.join(self.exploits_path, "VLC.htm")
        expected = ["[VLC ActiveX] getVariable Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_VLC2(self, caplog):
        sample   = os.path.join(self.exploits_path, "VLC2.htm")
        expected = ["[VLC ActiveX] setVariable Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_VLC3(self, caplog):
        sample   = os.path.join(self.exploits_path, "VLC3.htm")
        expected = ["[VLC ActiveX] addTarget Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_WinZip(self, caplog):
        sample   = os.path.join(self.exploits_path, "WinZip.htm")
        expected = ["[WinZip ActiveX] CreateNewFolderFromName Overflow",
                    "WinExec",
                    "calc",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_WMEncProfileManager(self, caplog):
        sample   = os.path.join(self.exploits_path, "WMEncProfileManager.htm")
        expected = ["[Microsoft Windows Media Encoder WMEX.DLL ActiveX] GetDetailsString Method Buffer Overflow",
                    "CVE-2008-3008",
                    "calc.exe", ]

        self.do_perform_test(caplog, sample, expected)

    def test_WMP(self, caplog):
        sample   = os.path.join(self.exploits_path, "WMP.html")
        expected = ["http://192.168.1.100/putty.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_XMLDOM_evasion(self, caplog):
        sample   = os.path.join(self.exploits_path, "XMLDOM-evasion.html")
        expected = [r"[Microsoft XMLDOM ActiveX] Attempting to load res://c:\Windows\System32\drivers\kl1.sys"]

        self.do_perform_test(caplog, sample, expected)

    def test_Xupload(self, caplog):
        sample   = os.path.join(self.exploits_path, "Xupload.htm")
        expected = ["[XUpload ActiveX] Overflow in AddFolder method"]

        self.do_perform_test(caplog, sample, expected)

    def test_YahooJukebox(self, caplog):
        sample   = os.path.join(self.exploits_path, "YahooJukebox.htm")
        expected = ["[Yahoo! Music Jukebox ActiveX] Overflow in AddBitmap"]

        self.do_perform_test(caplog, sample, expected)

    def test_YahooMessengerYVerInfo(self, caplog):
        sample   = os.path.join(self.exploits_path, "YahooMessengerYVerInfo.htm")
        expected = ["[Yahoo! Messenger 8.x YVerInfo.dll ActiveX Control] Overflow in fvCom arg0",
                    "WinExec",
                    "calc",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_YahooMessengerCyft(self, caplog):
        sample   = os.path.join(self.exploits_path, "YahooMessengerCyft.html")
        expected = ["[Yahoo! Messenger 8.x CYTF] Downloading http://192.168.1.100/putty.exe", ]

        self.do_perform_test(caplog, sample, expected)

    def test_YahooMessengerYwcvwr_GetComponentVersion(self, caplog):
        sample   = os.path.join(self.exploits_path, "YahooMessengerYwcvwr_GetComponentVersion.htm")
        expected = ["[Yahoo! Messenger 8.x Ywcvwr ActiveX] GetComponentVersion Overflow",
                    "LoadLibraryA",
                    "port = 4444",
                    "bind",
                    "listen",
                    "accept",
                    "CreateProcess",
                    "cmd"]

        self.do_perform_test(caplog, sample, expected)

    def test_YahooMessengerYwcvwr_server(self, caplog):
        sample   = os.path.join(self.exploits_path, "YahooMessengerYwcvwr_server.htm")
        expected = ["[Yahoo! Messenger 8.x Ywcvwr ActiveX] Server Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_ZenturiProgramCheckerAttack(self, caplog):
        sample   = os.path.join(self.exploits_path, "ZenturiProgramCheckerAttack.htm")
        expected = ["[ZenturiProgramChecker ActiveX] Attack in DebugMsgLog function",
                    "WinExec",
                    "calc.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_ZenturiProgramCheckerAttack2(self, caplog):
        sample   = os.path.join(self.exploits_path, "ZenturiProgramCheckerAttack2.htm")
        expected = ["[ZenturiProgramChecker ActiveX] Attack in DownloadFile function", ]

        self.do_perform_test(caplog, sample, expected)

    def test_ZenturiProgramCheckerAttack3(self, caplog):
        sample   = os.path.join(self.exploits_path, "ZenturiProgramCheckerAttack3.htm")
        expected = ["[ZenturiProgramChecker ActiveX] Attack in NavigateUrl function", ]

        self.do_perform_test(caplog, sample, expected)

    def test_aol_ampx(self, caplog):
        sample   = os.path.join(self.exploits_path, "aol_ampx.html")
        expected = ["[AOL Radio AOLMediaPlaybackControl ActiveX] Overflow in AppendFileToPlayList"]

        self.do_perform_test(caplog, sample, expected)

    def test_blackhole(self, caplog):
        sample   = os.path.join(self.exploits_path, "blackhole.html")
        expected = ["CVE-2006-0003",
                    "adobeupdate.exe",
                    "Microsoft Internet Explorer HCP Scheme Detected"
                    "Microsoft Windows Help Center Malformed Escape Sequences Incorrect Handling",
                    "[doRun redirection]"]

        self.do_perform_test(caplog, sample, expected)

    def test_domino(self, caplog):
        sample   = os.path.join(self.exploits_path, "domino.html")
        expected = ["[IBM Lotus Domino Web Access Control ActiveX] Overflow in General_ServerName property"]

        self.do_perform_test(caplog, sample, expected)

    def test_hpinfo(self, caplog):
        sample   = os.path.join(self.exploits_path, "hpinfo.html")
        expected = [r"[HP Info Center ActiveX] LaunchApp called to run: c:\windows\system32\cmd.exe /C c:\ftpd.bat&del c:\ftpd.bat&del c:\ftpd&del c:\malware.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_hpinfo2(self, caplog):
        sample   = os.path.join(self.exploits_path, "hpinfo2.html")
        expected = ["[HP Info Center ActiveX] GetRegValue, reading: //"]

        self.do_perform_test(caplog, sample, expected)

    def test_hpinfo3(self, caplog):
        sample   = os.path.join(self.exploits_path, "hpinfo3.html")
        expected = [r"[HP Info Center ActiveX] SetRegValue: HKEY_LOCAL_MACHINE/SOFTWARE\Classes\CLSID\{62DDEB79-15B2-41E3-8834-D3B80493887A}\InprocServer32/ set to"]

        self.do_perform_test(caplog, sample, expected)

    def test_hpupdate1(self, caplog):
        sample   = os.path.join(self.exploits_path, "hpupdate1.html")
        expected = ["[HP Info Center ActiveX] SaveToFile()",
                    "writes to c:\\temp\\testfile.txt"]

        self.do_perform_test(caplog, sample, expected)

    def test_hpupdate2(self, caplog):
        sample   = os.path.join(self.exploits_path, "hpupdate2.html")
        expected = ["[HP Info Center ActiveX] SaveToFile()",
                    r"writes to c:\WINDOWS\system32\dllcache\ntoskrnl.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_intuit(self, caplog):
        sample   = os.path.join(self.exploits_path, "intuit.html")
        expected = ["[AnswerWorks ActiveX] Overflow in GetHistory"]

        self.do_perform_test(caplog, sample, expected)

    def test_qvod(self, caplog):
        sample   = os.path.join(self.exploits_path, "qvod.html")
        expected = ["LoadLibraryA",
                    "URLDownloadToFile",
                    "http://www.360.cn.sxxsnp2.cn/d5.css",
                    "WinExec",
                    "U.exe",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_qvod_js(self, caplog):
        sample   = os.path.join(self.exploits_path, "qvod.js")
        expected = ["LoadLibraryA",
                    "URLDownloadToFile",
                    "http://www.360.cn.sxxsnp2.cn/d5.css",
                    "WinExec",
                    "U.exe",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_qvodctl(self, caplog):
        sample   = os.path.join(self.exploits_path, "qvodctl.html")
        expected = ["[Qvod Player QvodCtrl Class ActiveX] Overflow in URL property"]

        self.do_perform_test(caplog, sample, expected)

    def test_qvodsrc2(self, caplog):
        sample   = os.path.join(self.exploits_path, "qvodsrc2.html")
        expected = ["LoadLibraryA",
                    "URLDownloadToFile",
                    "http://www.360.cn.sxxsnp2.cn/d5.css",
                    "WinExec",
                    "U.exe",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_realplayer_mod(self, caplog):
        sample   = os.path.join(self.exploits_path, "realplayer-mod.html")
        expected = ["[RealMedia RealPlayer rmoc3260.DLL ActiveX] Overflow in Console property"]

        self.do_perform_test(caplog, sample, expected)

    def test_realplayer_mod_2(self, caplog):
        sample   = os.path.join(self.exploits_path, "realplayer-mod-2.html")
        expected = ["[RealMedia RealPlayer Ierpplug.DLL ActiveX] Overflow in DoAutoUpdateRequest"]

        self.do_perform_test(caplog, sample, expected)

    def test_rgod_imesh(self, caplog):
        sample   = os.path.join(self.exploits_path, "rgod_imesh.html")
        expected = ["[iMesh IMWebControl ActiveX] NULL value in ProcessRequestEx",
                    "cmd.exe /c net user sun tzu /ADD && net localgroup Administrators sun /ADD"]

        self.do_perform_test(caplog, sample, expected)

    def test_show_283_1(self, caplog):
        sample   = os.path.join(self.exploits_path, "show-283-1.html")
        expected = ["[Xunlei DPClient.Vod.1 ActiveX] DownURL2 Method Buffer Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_ssreader2(self, caplog):
        sample   = os.path.join(self.exploits_path, "ssreader2.html")
        expected = ["[SSReader Pdg2 ActiveX] Register Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_ssreader_0day(self, caplog):
        sample   = os.path.join(self.exploits_path, "ssreader_0day.html")
        expected = ["[SSReader Pdg2 ActiveX] Register Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_ssreader_noplus(self, caplog):
        sample   = os.path.join(self.exploits_path, "ssreader_noplus.html")
        expected = ["[SSReader Pdg2 ActiveX] Register Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_URL(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_URL.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] URL Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_advancedOpen(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_advancedOpen.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] advanceOpen Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_backImage(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_backImage.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] backImage Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_isDVDPath(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_isDVDPath.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] isDVDPath Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_rawParse(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_rawParse.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] rawParse Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_titleImage(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_titleImage.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] titleImage Console Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_storm_onBeforeVideoDownload(self, caplog):
        sample   = os.path.join(self.exploits_path, "storm_onBeforeVideoDownload.htm")
        expected = ["[MPS.StormPlayer.1 ActiveX] OnBeforeVideoDownload Method Overflow"]

        self.do_perform_test(caplog, sample, expected)

    def test_stormplayer(self, caplog):
        sample   = os.path.join(self.exploits_path, "stormplayer.html")
        expected = ["[MPS.StormPlayer.1 ActiveX] rawParse Method Overflow",
                    "GetProcAddress",
                    "GetSystemDirectoryA",
                    "WinExec",
                    "ExitThread",
                    "http://w.qqnetcn.cn/d2.exe",
                    "a.exe"]

        self.do_perform_test(caplog, sample, expected)

    def test_toshiba(self, caplog):
        sample   = os.path.join(self.exploits_path, "toshiba.html")
        expected = ["[Toshiba Surveillance RecordSend Class ActiveX] Overflow in SetPort"]

        self.do_perform_test(caplog, sample, expected)

    def test_xupload(self, caplog):
        sample   = os.path.join(self.exploits_path, "xupload.html")
        expected = ["[XUpload ActiveX] Overflow in AddFolder method"]

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2012_4792(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2012-4792.html")
        expected = ["[Microsoft Internet Explorer] Microsoft Internet Explorer CButton Object Use-After-Free Vulnerability (CVE-2012-4792)",
                    "LoadLibraryA",
                    "user32"]

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2012_4792_2(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2012-4792-2.html")
        expected = ["[Microsoft Internet Explorer] Microsoft Internet Explorer CButton Object Use-After-Free Vulnerability (CVE-2012-4792)",
                    "LoadLibraryA",
                    "URLDownloadToFileA"]

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2012_4792_3(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2012-4792-3.html")
        expected = ["[Microsoft Internet Explorer] Microsoft Internet Explorer CButton Object Use-After-Free Vulnerability (CVE-2012-4792)",
                    "WinExec",
                    "ExitProcess"]

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2010_1885(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2010-1885.html")
        expected = ['Microsoft Internet Explorer HCP Scheme Detected',
                    'Microsoft Windows Help Center Malformed Escape Sequences Incorrect Handling',
                    '[WScript.Shell ActiveX] Executing: Run("calc.exe")']

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2010_1885_2(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2010-1885-2.html")
        expected = ['Microsoft Internet Explorer HCP Scheme Detected',
                    'Microsoft Windows Help Center Malformed Escape Sequences Incorrect Handling',
                    '[WScript.Shell ActiveX] Executing: Run("calc.exe")']

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2010_1885_3(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2010-1885-3.html")
        expected = ['Microsoft Internet Explorer HCP Scheme Detected',
                    'Microsoft Windows Help Center Malformed Escape Sequences Incorrect Handling',
                    '[WScript.Shell ActiveX] Run (Stage 1) Saving file 52bfb8491cbf6c39d44d37d3c59ef406']

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2017_0022(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2017-0022.html")
        expected = ['Microsoft Internet Explorer RES Scheme Detected']

        self.do_perform_test(caplog, sample, expected)

    def test_RDSDataSpace2(self, caplog):
        sample   = os.path.join(self.exploits_path, "RDSDataSpace2.htm")
        expected = ['[Microsoft MDAC RDS.Dataspace ActiveX] CreateObject (Microsoft.XMLHTTP)',
                    '[Microsoft MDAC RDS.Dataspace ActiveX] CreateObject (Adodb.Stream)',
                    '[Microsoft MDAC RDS.Dataspace ActiveX] CreateObject (Scripting.FileSystemObject)',
                    '[Scripting.FileSystemObject ActiveX] GetSpecialFolder("2")',
                    '[WScript.Shell ActiveX] Expanding environment string "%TEMP%"',
                    '[Adodb.Stream ActiveX] open',
                    '[Scripting.FileSystemObject ActiveX] BuildPath',
                    '[Adodb.Stream ActiveX] Write',
                    '[Adodb.Stream ActiveX] SaveToFile',
                    '[Adodb.Stream ActiveX] Close',
                    '[Microsoft MDAC RDS.Dataspace ActiveX] CreateObject (Shell.Application)',
                    '[Shell.Application ActiveX] ShellExecute']

        self.do_perform_test(caplog, sample, expected)

    def test_testVsaIDEDTE(self, caplog):
        sample   = os.path.join(self.exploits_path, "testVsaIDEDTE.html")
        expected = ['[VsaIDE.DTE ActiveX] CreateObject (WScript.Network)']

        self.do_perform_test(caplog, sample, expected)

    def test_testVsmIDEDTE(self, caplog):
        sample   = os.path.join(self.exploits_path, "testVsmIDEDTE.html")
        expected = ['[VsmIDE.DTE ActiveX] CreateObject (WScript.Network)']

        self.do_perform_test(caplog, sample, expected)

    def test_AolAttack(self, caplog):
        sample   = os.path.join(self.exploits_path, "AolAttack.html")
        expected = ['[AOL ActiveX] Attack in LinkSBIcons function',
                    'CVE-2006-5820']

        self.do_perform_test(caplog, sample, expected)

    def test_ChinaGames(self, caplog):
        sample   = os.path.join(self.exploits_path, "ChinaGames.html")
        expected = ['[CGAgent ActiveX] CreateChinagames Method Buffer Overflow',
                    'CVE-2009-1800']

        self.do_perform_test(caplog, sample, expected)

    def test_OWCSpreadsheet(self, caplog):
        sample   = os.path.join(self.exploits_path, "OWCSpreadsheet.html")
        expected = ['[OWC 10/11.Spreadsheet ActiveX] Attack in Evaluate function',
                    '[OWC 10/11.Spreadsheet ActiveX] Attack in _Evaluate function']

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2013_2423(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2013-2423.html")
        expected = ['[JNLP Detected]',
                    '[Java WebStart] Java Security Warning Bypass (CVE-2013-2423)']

        self.do_perform_test(caplog, sample, expected)

    def test_JavaDeploymentToolkit(self, caplog):
        sample   = os.path.join(self.exploits_path, "JavaDeploymentToolkit.html")
        expected = ['Launching: http: -J-jar http://192.168.1.100/exploit.jar none']

        self.do_perform_test(caplog, sample, expected)

    def test_CVE_2021_40444(self, caplog):
        sample   = os.path.join(self.exploits_path, "test-CVE-2021-40444.html")
        expected = ["[Microsoft XMLHTTP ActiveX] open('GET', 'http://127.0.0.1/calc.cab', False)",
                    "[Microsoft XMLHTTP ActiveX] Fetching from URL http://127.0.0.1/calc.cab (method: GET)"]

        self.do_perform_test(caplog, sample, expected)
