# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['miteclock']

package_data = \
{'': ['*'], 'miteclock': ['completions/*']}

install_requires = \
['backoff>=1.11.1',
 'click-aliases>=1.0.1',
 'click>=7.1.1',
 'pydantic>=1.8.2',
 'requests>=2.23.0',
 'toml>=0.10.0']

entry_points = \
{'console_scripts': ['m = miteclock.cli:main']}

setup_kwargs = {
    'name': 'miteclock',
    'version': '1.0',
    'description': 'Clock in and out of mite.yo.lk quickly.',
    'long_description': '# miteclock\n\nClock in and out of [mite](https://mite.yo.lk/) within seconds!\n\nDo you like tracking time in mite, but find it more convenient to grab any terminal (or\npop a new one) and type in a few characters rather than rummage through your browser\ntabs and click on the same 2 drop-down boxes every time you switch activities throughout\nthe day? `miteclock` is here to help!\n\n## Installation and Setup\n\nThis package should work with Python version 3.6 and higher. It doesn\'t have many\ndependencies so it should not be a huge deal to install directly in your global\nenvironment. Still, it\'s probably a better idea to create a dedicated virtualenv for it\nand then symlink the executable somewhere in your `PATH`. You could also use the\n[pipx](https://github.com/pipxproject/pipx) wrapper which automatically takes care of\nvirtualenv creation.\n\nWhether inside a virtualenv or not, install with a standard pip command:\n\n```sh\npip install miteclock\n```\n\nAfter installing (and symlinking) you should be able to run the following command in\nyour terminal:\n\n```sh\nm\n```\n\nThe first time you run it, it will prompt you for your account information and create a\n[TOML](https://github.com/toml-lang/toml) configuration file in your home directory\nnamed `~/.config/miteclock/config.toml`. Invoking `m` after that will show you the help\nmessage for the program.\n\n### Shell Auto-completion\n\nIf you\'d like to enable auto-completion for your shell, run this command:\n\n```sh\nm completion\n```\n\nBy default this sets up `bash` completion, but `zsh` is can also be specified. Pass the\n`--help` flag to learn more about the command.\n\n## Usage\n\nThere are only two core commands: `m start` starts a clock, `m stop` stops it. That\'s\nit, _that simple_. The help message for `m stop` contains all you need to know about\nthat command, so here we focus on `m start`.\n\n### Tracking a New Entry\n\nLet\'s say your mite account has the following projects:\n\n- ACME &#x2013; Self-healing container deployments\n- OCP: ED-209\n- CHAZ 2020\n\nIn these projects you perform the following services (Dienstleistungen):\n\n- Development\n- Regular Maintenance\n- Irregular Maintenance\n- QA\n\n  From your experience with the mite webapp, you know that in order to add an entry and\n  start the clock for it you need to specify the following three fields:\n\n  - project\n  - service\n  - note\n\nHowever, what if instead of selecting the project and the service from a drop-down you\ndid so by pressing just one key? This is much faster, especially if you have more\nrealistic (i.e. larger) sets of projects and services that you\'d have to sift through\nwith the drop-down.\n\nThese keys are known as shortcuts and you can define them in your configuration file.\nFor our example here, let\'s create a few mappings from keys to project/service names. We\nopen our `~/.config/miteclock/config.toml` in a text editor and add the following in the\n`[shortcuts]` table:\n\n```toml\n[shortcuts]\n# Shortcuts for projects.\na = "ACME -- Self-healing container deployments"\no = "OCP: ED-209"\nh = "CHAZ 2020"\nt = "Team-Internal"\n#  Shortcuts for services.\nd = "Development"\nr = "Regular Maintenance"\ni = "Irregular Maintenance"\nq = "QA"\nc = "Communication/Coordination"\n```\n\nNow we can add an activity and start the clock for it with this one command:\n\n```sh\nm start a d \'writing some code\'\n```\n\nThe first two arguments to `start` are expanded into "ACME &#x2013; Self-healing\ncontainer deployments" and "Development" respectively. The last argument is the note and\nshould be quoted to ensure it is interpreted together. Note that the order of the\narguments is currently fixed to keep things simple.\n\nWhile most activities will likely require you to enter a unique note to describe them,\nthere are also some recurring appointments and tasks for which the notes don\'t need to\nvary either. Wouldn\'t it be nice to have shortcuts for those too? Let\'s add some\nshortcuts that describe recurring activities of many programmers:\n\n```toml\ndaily = ["t", "c", "daily stand-up"]\nretro = ["t", "c", "retrospective"]\nserver = [\'a\', \'r\', "regular server maintenance"]\n```\n\nNotice how we used the shortcuts we had already defined to create new shortcuts? Like\nthey say, _it\'s shortcuts all the way down_!\n\nThese nested shortcuts can span any **consecutive** part of an activity definition. This\nis valid&#x2026;\n\n```toml\nkickoff = ["c", "kickoff meeting for project"]\n```\n\n&#x2026; and can be used with all your projects, for example:\n\n```sh\nm start h kickoff  # Tracks kickoff meeting for CHAZ 2020\nm start o kickoff  # Tracks kickoff meeting for OCP: ED-209\n```\n\nThis is also valid (though not so useful):\n\n```toml\nacmedev = ["a", "d"]\n```\n\nThis, however, is invalid:\n\n```toml\ninvalid = ["a", "something ACME-related  ¯\\_(ツ)_/¯"]\n```\n\n### Resume Tracking an Existing Entry\n\nOften you might have to stop the clock for some activity and then start it back up it\nlater.\n\nIf you have clocked in some entries for the day and run `m start` without any arguments,\nyou will be presented with a list of the activities you recorded for the day paired with\nkeys you can press to select one of the entries. Note that unlike in the mite webapp,\ntime entries are sorted by the time they were updated last not by the time when they\nwere created.\n\nYou can skip this menu by passing the `-l` flag (or `--last` if you like typing) which\nautomatically starts the last entry for which you had a clock running.\n\n### Helper Commands\n\n#### resume\n\n`m resume` is just an alias for `m start -l`.\n\n#### show/list\n\n`m show` and `m list` show you a list of shortcuts. You can also request a list of\n`projects` or `services` by providing these as arguments to the command. Note that\nespecially the list of projects has known to be long enough that you may want to pipe it\nto a file or filter it with `grep`.\n\n## Contributing\n\nVery simple in terms of git: fork this repo, create a branch in your fork that contains\nyour work, open a pull request against the `master` branch in this repo.\n\nFor local development, install the dependencies using\n[poetry](https://github.com/python-poetry/poetry).\n\n```sh\npoetry install\npoetry shell\npre-commit install\n```\n\nPlease make sure to add tests for any code changes.\n\n## Why yet another mite CLI?\n\nThere are almost half a dozen command-line interfaces already in several languages\n([Ruby](https://github.com/Overbryd/mite.cmd),\n[JavaScript](https://github.com/Ephigenia/mite-cli),\n[Go](https://github.com/leanovate/mite-go),\n[Python](https://github.com/port-zero/mite-cli)). There\'s even a\n[PHP wrapper library](https://github.com/derpaschi/Mitey). What is the need for yet\nanother cli?\n\nIn my opinion all the existing interfaces provide both too much functionality and too\nlittle. They try to cover the complete range of tasks that **can** be performed with\nmite and expose all the gory details of the data, like the IDs of the objects involved.\nIndeed if you regularly have to import and export time records, or if your workflow\nincludes managing projects and services for an account, these tools can arguably help\nyou with your work.\n\nHowever the way I see mite used most often involves starting and stopping the clock for\nactivities "on the go" throughout the day. Quite a few of these activities are\nrecurring, like check-in meetings with clients or team members. Moreover, most\nactivities that a particular person specifies on a given day tend to revolve around just\na handful of projects and services. Lastly, the active mite users I know seem to clock\nin and out throughout their day rather than enter all their time entries already with\ntimes attached, thus taking advantage of mite\'s built-in tracking capabilities.\n\nThis program aims to reduce the book-keeping cost of specifying activities and let the\nuser focus on their work while instructing mite to do what it does best: track time. It\ndeliberately exposes a very simple interface and deals in abstractions relevant\nprimarily to someone only using mite to track their time.\n\n## Acknowledgements\n\nThis project would not have been possible at all without the folks\n[who run mite](https://mite.yo.lk/) making their API accessible. Many thanks to them for\nthat. I am also grateful to the many people who wrote client libraries and cli tools\nbased on the API. This provided context to my efforts and thus helped me define what I\nwanted to focus them on.\n\n## Licence\n\nMIT\n',
    'author': 'Ilia Kurenkov',
    'author_email': 'ilia.kurenkov@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/iliakur/miteclock',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
