"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("./component");
class Version extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.changelogFileName = "changelog.md";
        this.versionFileName = "version.txt";
        this.releaseTagFileName = "releasetag.txt";
        const versionInputFile = options.versionInputFile;
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const changelogFile = path_1.posix.join(options.artifactsDirectory, this.changelogFileName);
        const bumpFile = path_1.posix.join(options.artifactsDirectory, this.versionFileName);
        const releaseTagFile = path_1.posix.join(options.artifactsDirectory, this.releaseTagFileName);
        const env = {
            OUTFILE: versionInputFile,
            CHANGELOG: changelogFile,
            BUMPFILE: bumpFile,
            RELEASETAG: releaseTagFile,
            RELEASE_TAG_PREFIX: options.tagPrefix ?? "",
            // doesn't work if custom configuration is long
            VERSIONRCOPTIONS: JSON.stringify(options.versionrcOptions),
        };
        this.bumpTask = project.addTask("bump", {
            description: "Bumps version based on latest git tag and generates a changelog entry",
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin("release/bump-version");
        this.unbumpTask = project.addTask("unbump", {
            description: "Restores version to 0.0.0",
            env: env,
        });
        this.unbumpTask.builtin("release/reset-version");
        project.addGitIgnore(`/${changelogFile}`);
        project.addGitIgnore(`/${bumpFile}`);
        project.addPackageIgnore(`/${changelogFile}`);
        project.addPackageIgnore(`/${bumpFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.63.29" };
Version.STANDARD_VERSION = "standard-version@^9";
//# sourceMappingURL=data:application/json;base64,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