import { Project } from "../project";
/**
 * Options for the Snapshot synthesis
 */
export interface SnapshotOptions {
    /**
     * Parse .json files as a JS object for improved inspection.
     * This will fail if the contents are invalid JSON.
     *
     * @default true parse .json files into an object
     */
    readonly parseJson?: boolean;
}
export interface SynthOutput {
    [filePath: string]: any;
}
/**
 * Creates a snapshot of the files generated by a project. Ignores any non-text
 * files so that the snapshots are human readable.
 */
export declare function synthSnapshot(project: Project, options?: SnapshotOptions): SynthOutput;
export interface DirectorySnapshotOptions extends SnapshotOptions {
    /**
     * Globs of files to exclude.
     * @default [] include all files
     */
    readonly excludeGlobs?: string[];
    /**
     * Only snapshot the names of files and not their contents.
     * The value for a path will be `true` if it exists.
     *
     * @default false include file content
     */
    readonly onlyFileNames?: boolean;
}
export declare function directorySnapshot(root: string, options?: DirectorySnapshotOptions): SynthOutput;
