"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Renovatebot = exports.RenovatebotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const dependencies_1 = require("./dependencies");
const json_1 = require("./json");
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 *
 * @see https://docs.renovatebot.com/presets-schedule/
 */
var RenovatebotScheduleInterval;
(function (RenovatebotScheduleInterval) {
    /**
     * Run at any time
     */
    RenovatebotScheduleInterval["ANY_TIME"] = "at any time";
    /**
     * Weekly schedule on early monday mornings
     */
    RenovatebotScheduleInterval["EARLY_MONDAYS"] = "before 3am on Monday";
    /**
     * Schedule daily
     */
    RenovatebotScheduleInterval["DAILY"] = "before 2am";
    /**
     * Schedule weekly
     */
    RenovatebotScheduleInterval["WEEKLY"] = "before 3am on Monday";
    /**
     * Schedule monthly
     */
    RenovatebotScheduleInterval["MONTHLY"] = "before 3am on the first day of the month";
    /**
     * Schedule quarterly
     */
    RenovatebotScheduleInterval["QUARTERLY"] = "every 3 months on the first day of the month";
    /**
     * Schedule for weekends
     */
    RenovatebotScheduleInterval["WEEKENDS"] = "every weekend";
    /**
     * Schedule for weekdays
     */
    RenovatebotScheduleInterval["WEEKDAYS"] = "every weekday";
})(RenovatebotScheduleInterval = exports.RenovatebotScheduleInterval || (exports.RenovatebotScheduleInterval = {}));
/**
 * Defines renovatebot configuration for projen project.
 *
 * Ignores the versions controlled by Projen.
 */
class Renovatebot extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this._project = project;
        this.explicitIgnores = options.ignore ?? [];
        this.labels = options.labels;
        this.scheduleInterval = options.scheduleInterval ?? [
            RenovatebotScheduleInterval.ANY_TIME,
        ];
        (options.ignoreProjen ?? true) && this.explicitIgnores.push("projen");
    }
    // create actual file only here, so we know that all dependencies are added to the project
    preSynthesize() {
        this.createRenovateConfiguration();
    }
    createRenovateConfiguration() {
        const renovateIgnore = [
            ...new Set(this._project.deps.all
                .filter((dep) => dep.version || dep.type === dependencies_1.DependencyType.OVERRIDE)
                .map((dep) => dep.name)
                .concat(this.explicitIgnores)),
        ];
        const config = {
            labels: this.labels,
            schedule: this.scheduleInterval,
            extends: [
                ":preserveSemverRanges",
                "config:base",
                "group:allNonMajor",
                "group:recommended",
                "group:monorepos",
            ],
            packageRules: [
                {
                    matchDepTypes: ["devDependencies"],
                    matchUpdateTypes: ["patch", "minor"],
                    groupName: "devDependencies (non-major)",
                },
            ],
            ignoreDeps: renovateIgnore,
        };
        new json_1.JsonFile(this._project, "renovate.json5", {
            obj: config,
            committed: true,
        });
    }
}
exports.Renovatebot = Renovatebot;
_a = JSII_RTTI_SYMBOL_1;
Renovatebot[_a] = { fqn: "projen.Renovatebot", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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