"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Venv = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const util_1 = require("../util");
/**
 * Manages a virtual environment through the Python venv module.
 */
class Venv extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.envdir = options.envdir ?? ".env";
        this.project.addGitIgnore(`/${this.envdir}`);
        this.project.tasks.addEnvironment("VIRTUAL_ENV", `$(echo $PWD/${this.envdir})`);
        this.project.tasks.addEnvironment("PATH", `$(echo $PWD/${this.envdir}/bin:$PATH)`);
    }
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment() {
        const absoluteEnvdir = path.join(this.project.outdir, this.envdir);
        if (!fs.pathExistsSync(absoluteEnvdir)) {
            this.project.logger.info("Setting up a virtual environment...");
            util_1.exec(`python -m venv ${this.envdir}`, { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ./${this.envdir}).`);
        }
    }
}
exports.Venv = Venv;
_a = JSII_RTTI_SYMBOL_1;
Venv[_a] = { fqn: "projen.python.Venv", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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