import { Component } from "../component";
import { Project } from "../project";
import { IPythonEnv } from "./python-env";
/**
 * Options for venv.
 */
export interface VenvOptions {
    /**
     * Name of directory to store the environment in
     *
     * @default ".env"
     */
    readonly envdir?: string;
}
/**
 * Manages a virtual environment through the Python venv module.
 */
export declare class Venv extends Component implements IPythonEnv {
    /**
     * Name of directory to store the environment in
     */
    private readonly envdir;
    constructor(project: Project, options?: VenvOptions);
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment(): void;
}
