"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * Python packaging script where package metadata can be placed.
 */
class SetupPy extends file_1.FileBase {
    constructor(project, options) {
        super(project, "setup.py");
        this.setupConfig = {
            name: project.name,
            packages: options.packages,
            python_requires: ">=3.6",
            classifiers: [
                "Intended Audience :: Developers",
                "Programming Language :: Python :: 3 :: Only",
                "Programming Language :: Python :: 3.6",
                "Programming Language :: Python :: 3.7",
                "Programming Language :: Python :: 3.8",
                "Programming Language :: Python :: 3.9",
            ],
            ...(options ? this.renameFields(options) : []),
        };
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            "import json",
            "from setuptools import setup",
            "",
            "kwargs = json.loads(",
            '    """',
            JSON.stringify(this.setupConfig, null, 4),
            '"""',
            ")",
            "",
            "setup(**kwargs)",
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
    // modify some key names since JSII interfaces require fields to be camelCase
    renameFields(options) {
        const obj = {};
        for (const [key, value] of Object.entries(options)) {
            if (key === "authorName") {
                obj.author = value;
            }
            else if (key === "authorEmail") {
                obj.author_email = value;
            }
            else if (key === "homepage") {
                obj.url = value;
            }
            else {
                obj[key] = value;
            }
        }
        return obj;
    }
}
exports.SetupPy = SetupPy;
_a = JSII_RTTI_SYMBOL_1;
SetupPy[_a] = { fqn: "projen.python.SetupPy", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0dXBweS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9weXRob24vc2V0dXBweS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGtDQUE4QztBQThEOUM7O0dBRUc7QUFDSCxNQUFhLE9BQVEsU0FBUSxlQUFRO0lBR25DLFlBQVksT0FBZ0IsRUFBRSxPQUF1QjtRQUNuRCxLQUFLLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBRTNCLElBQUksQ0FBQyxXQUFXLEdBQUc7WUFDakIsSUFBSSxFQUFFLE9BQU8sQ0FBQyxJQUFJO1lBQ2xCLFFBQVEsRUFBRSxPQUFPLENBQUMsUUFBUTtZQUMxQixlQUFlLEVBQUUsT0FBTztZQUN4QixXQUFXLEVBQUU7Z0JBQ1gsaUNBQWlDO2dCQUNqQyw2Q0FBNkM7Z0JBQzdDLHVDQUF1QztnQkFDdkMsdUNBQXVDO2dCQUN2Qyx1Q0FBdUM7Z0JBQ3ZDLHVDQUF1QzthQUN4QztZQUNELEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztTQUMvQyxDQUFDO0lBQ0osQ0FBQztJQUVTLGlCQUFpQixDQUFDLFFBQW1CO1FBQzdDLE1BQU0sS0FBSyxHQUFHO1lBQ1osR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQzVDLEVBQUU7WUFDRixhQUFhO1lBQ2IsOEJBQThCO1lBQzlCLEVBQUU7WUFDRixzQkFBc0I7WUFDdEIsU0FBUztZQUNULElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1lBQ3pDLEtBQUs7WUFDTCxHQUFHO1lBQ0gsRUFBRTtZQUNGLGlCQUFpQjtTQUNsQixDQUFDO1FBRUYsT0FBTyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkQsQ0FBQztJQUVELDZFQUE2RTtJQUNyRSxZQUFZLENBQUMsT0FBdUI7UUFDMUMsTUFBTSxHQUFHLEdBQTJCLEVBQUUsQ0FBQztRQUN2QyxLQUFLLE1BQU0sQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFBRTtZQUNsRCxJQUFJLEdBQUcsS0FBSyxZQUFZLEVBQUU7Z0JBQ3hCLEdBQUcsQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO2FBQ3BCO2lCQUFNLElBQUksR0FBRyxLQUFLLGFBQWEsRUFBRTtnQkFDaEMsR0FBRyxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7YUFDMUI7aUJBQU0sSUFBSSxHQUFHLEtBQUssVUFBVSxFQUFFO2dCQUM3QixHQUFHLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQzthQUNqQjtpQkFBTTtnQkFDTCxHQUFHLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFDO2FBQ2xCO1NBQ0Y7UUFDRCxPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7O0FBeERILDBCQXlEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZpbGVCYXNlLCBJUmVzb2x2ZXIgfSBmcm9tIFwiLi4vZmlsZVwiO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gXCIuLi9wcm9qZWN0XCI7XG5cbi8qKlxuICogRmllbGRzIHRvIHBhc3MgaW4gdGhlIHNldHVwKCkgZnVuY3Rpb24gb2Ygc2V0dXAucHlcbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5weXRob24ub3JnLzMvZGlzdHV0aWxzL3NldHVwc2NyaXB0Lmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZXR1cFB5T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBOYW1lIG9mIHRoZSBwYWNrYWdlXG4gICAqL1xuICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBMaXN0IG9mIHN1Ym1vZHVsZXMgdG8gYmUgcGFja2FnZWRcbiAgICovXG4gIHJlYWRvbmx5IHBhY2thZ2VzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEF1dGhvcidzIG5hbWVcbiAgICovXG4gIHJlYWRvbmx5IGF1dGhvck5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEF1dGhvcidzIGUtbWFpbFxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aG9yRW1haWw/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE1hbnVhbGx5IHNwZWNpZnkgcGFja2FnZSB2ZXJzaW9uXG4gICAqL1xuICByZWFkb25seSB2ZXJzaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIHNob3J0IHByb2plY3QgZGVzY3JpcHRpb25cbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcHJvamVjdCBsaWNlbnNlXG4gICAqL1xuICByZWFkb25seSBsaWNlbnNlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBQYWNrYWdlJ3MgSG9tZXBhZ2UgLyBXZWJzaXRlXG4gICAqL1xuICByZWFkb25seSBob21lcGFnZT86IHN0cmluZztcblxuICAvKipcbiAgICogQSBsaXN0IG9mIFB5UEkgdHJvdmUgY2xhc3NpZmllcnMgdGhhdCBkZXNjcmliZSB0aGUgcHJvamVjdC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL3B5cGkub3JnL2NsYXNzaWZpZXJzL1xuICAgKi9cbiAgcmVhZG9ubHkgY2xhc3NpZmllcnM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogRXNjYXBlIGhhdGNoIHRvIGFsbG93IGFueSB2YWx1ZVxuICAgKi9cbiAgcmVhZG9ubHkgW25hbWU6IHN0cmluZ106IGFueTtcbn1cblxuLyoqXG4gKiBQeXRob24gcGFja2FnaW5nIHNjcmlwdCB3aGVyZSBwYWNrYWdlIG1ldGFkYXRhIGNhbiBiZSBwbGFjZWQuXG4gKi9cbmV4cG9ydCBjbGFzcyBTZXR1cFB5IGV4dGVuZHMgRmlsZUJhc2Uge1xuICBwcml2YXRlIHJlYWRvbmx5IHNldHVwQ29uZmlnOiBhbnk7XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCwgb3B0aW9uczogU2V0dXBQeU9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0LCBcInNldHVwLnB5XCIpO1xuXG4gICAgdGhpcy5zZXR1cENvbmZpZyA9IHtcbiAgICAgIG5hbWU6IHByb2plY3QubmFtZSxcbiAgICAgIHBhY2thZ2VzOiBvcHRpb25zLnBhY2thZ2VzLFxuICAgICAgcHl0aG9uX3JlcXVpcmVzOiBcIj49My42XCIsXG4gICAgICBjbGFzc2lmaWVyczogW1xuICAgICAgICBcIkludGVuZGVkIEF1ZGllbmNlIDo6IERldmVsb3BlcnNcIixcbiAgICAgICAgXCJQcm9ncmFtbWluZyBMYW5ndWFnZSA6OiBQeXRob24gOjogMyA6OiBPbmx5XCIsXG4gICAgICAgIFwiUHJvZ3JhbW1pbmcgTGFuZ3VhZ2UgOjogUHl0aG9uIDo6IDMuNlwiLFxuICAgICAgICBcIlByb2dyYW1taW5nIExhbmd1YWdlIDo6IFB5dGhvbiA6OiAzLjdcIixcbiAgICAgICAgXCJQcm9ncmFtbWluZyBMYW5ndWFnZSA6OiBQeXRob24gOjogMy44XCIsXG4gICAgICAgIFwiUHJvZ3JhbW1pbmcgTGFuZ3VhZ2UgOjogUHl0aG9uIDo6IDMuOVwiLFxuICAgICAgXSxcbiAgICAgIC4uLihvcHRpb25zID8gdGhpcy5yZW5hbWVGaWVsZHMob3B0aW9ucykgOiBbXSksXG4gICAgfTtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQ29udGVudChyZXNvbHZlcjogSVJlc29sdmVyKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICBjb25zdCBsaW5lcyA9IFtcbiAgICAgIC4uLih0aGlzLm1hcmtlciA/IFtgIyAke3RoaXMubWFya2VyfWBdIDogW10pLFxuICAgICAgXCJcIixcbiAgICAgIFwiaW1wb3J0IGpzb25cIixcbiAgICAgIFwiZnJvbSBzZXR1cHRvb2xzIGltcG9ydCBzZXR1cFwiLFxuICAgICAgXCJcIixcbiAgICAgIFwia3dhcmdzID0ganNvbi5sb2FkcyhcIixcbiAgICAgICcgICAgXCJcIlwiJyxcbiAgICAgIEpTT04uc3RyaW5naWZ5KHRoaXMuc2V0dXBDb25maWcsIG51bGwsIDQpLFxuICAgICAgJ1wiXCJcIicsXG4gICAgICBcIilcIixcbiAgICAgIFwiXCIsXG4gICAgICBcInNldHVwKCoqa3dhcmdzKVwiLFxuICAgIF07XG5cbiAgICByZXR1cm4gYCR7cmVzb2x2ZXIucmVzb2x2ZShsaW5lcykuam9pbihcIlxcblwiKX1cXG5gO1xuICB9XG5cbiAgLy8gbW9kaWZ5IHNvbWUga2V5IG5hbWVzIHNpbmNlIEpTSUkgaW50ZXJmYWNlcyByZXF1aXJlIGZpZWxkcyB0byBiZSBjYW1lbENhc2VcbiAgcHJpdmF0ZSByZW5hbWVGaWVsZHMob3B0aW9uczogU2V0dXBQeU9wdGlvbnMpOiBhbnkge1xuICAgIGNvbnN0IG9iajogeyBba2V5OiBzdHJpbmddOiBhbnkgfSA9IHt9O1xuICAgIGZvciAoY29uc3QgW2tleSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKG9wdGlvbnMpKSB7XG4gICAgICBpZiAoa2V5ID09PSBcImF1dGhvck5hbWVcIikge1xuICAgICAgICBvYmouYXV0aG9yID0gdmFsdWU7XG4gICAgICB9IGVsc2UgaWYgKGtleSA9PT0gXCJhdXRob3JFbWFpbFwiKSB7XG4gICAgICAgIG9iai5hdXRob3JfZW1haWwgPSB2YWx1ZTtcbiAgICAgIH0gZWxzZSBpZiAoa2V5ID09PSBcImhvbWVwYWdlXCIpIHtcbiAgICAgICAgb2JqLnVybCA9IHZhbHVlO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgb2JqW2tleV0gPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG9iajtcbiAgfVxufVxuIl19