"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs-extra");
const file_1 = require("./file");
class License extends file_1.FileBase {
    constructor(project, options) {
        super(project, "LICENSE", {
            marker: false,
            // Allow the license to be displayed in the repositories.
            committed: true,
        });
        const spdx = options.spdx;
        const textFile = `${__dirname}/../license-text/${spdx}.txt`;
        if (!fs.existsSync(textFile)) {
            throw new Error(`unsupported license ${spdx}`);
        }
        const years = options.copyrightPeriod ?? new Date().getFullYear().toString();
        const owner = options.copyrightOwner;
        let text = fs.readFileSync(textFile, "utf-8");
        text = text.replace("$copyright_period", years);
        // if the license text includes $copyright_owner, then `copyrightOwner` is required.
        if (text.indexOf("$copyright_owner") !== -1) {
            if (!owner) {
                throw new Error(`The ${spdx} license requires "copyrightOwner" to be specified`);
            }
            text = text.replace("$copyright_owner", owner);
        }
        this.text = text;
    }
    synthesizeContent(_) {
        return this.text;
    }
}
exports.License = License;
_a = JSII_RTTI_SYMBOL_1;
License[_a] = { fqn: "projen.License", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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