"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options) {
        super(project, filePath, options);
        this.newline = options.newline ?? true;
        this.supportsComments =
            options.allowComments ??
                (filePath.toLowerCase().endsWith("json5") ||
                    filePath.toLowerCase().endsWith("jsonc"));
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker && !this.supportsComments) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.marker && this.supportsComments) {
            content = content.slice(0, -1) + `// ${this.marker}\n}`;
        }
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoianNvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9qc29uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsK0NBQThEO0FBb0I5RDs7R0FFRztBQUNILE1BQWEsUUFBUyxTQUFRLHdCQUFVO0lBSXRDLFlBQVksT0FBZ0IsRUFBRSxRQUFnQixFQUFFLE9BQXdCO1FBQ3RFLEtBQUssQ0FBQyxPQUFPLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRWxDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUM7UUFDdkMsSUFBSSxDQUFDLGdCQUFnQjtZQUNuQixPQUFPLENBQUMsYUFBYTtnQkFDckIsQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQztvQkFDdkMsUUFBUSxDQUFDLFdBQVcsRUFBRSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBRTlDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFO1lBQ2hCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkJBQTJCLENBQUMsQ0FBQztTQUM5QztJQUNILENBQUM7SUFFUyxpQkFBaUIsQ0FBQyxRQUFtQjtRQUM3QyxNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNULE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBRUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVuQyxJQUFJLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7WUFDekMsU0FBUyxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDL0I7UUFFRCxJQUFJLE9BQU8sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsRUFBRTtZQUN4QyxPQUFPLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLElBQUksQ0FBQyxNQUFNLEtBQUssQ0FBQztTQUN6RDtRQUVELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixPQUFPLElBQUksSUFBSSxDQUFDO1NBQ2pCO1FBRUQsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQzs7QUF4Q0gsNEJBeUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVJlc29sdmVyIH0gZnJvbSBcIi4vZmlsZVwiO1xuaW1wb3J0IHsgT2JqZWN0RmlsZSwgT2JqZWN0RmlsZU9wdGlvbnMgfSBmcm9tIFwiLi9vYmplY3QtZmlsZVwiO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gXCIuL3Byb2plY3RcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciBgSnNvbkZpbGVgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEpzb25GaWxlT3B0aW9ucyBleHRlbmRzIE9iamVjdEZpbGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIEFkZHMgYSBuZXdsaW5lIGF0IHRoZSBlbmQgb2YgdGhlIGZpbGUuXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IG5ld2xpbmU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBbGxvdyB0aGUgdXNlIG9mIGNvbW1lbnRzIGluIHRoaXMgZmlsZS5cbiAgICogQGRlZmF1bHQgLSBmYWxzZSBmb3IgLmpzb24gZmlsZXMsIHRydWUgZm9yIC5qc29uNSBhbmQgLmpzb25jIGZpbGVzXG4gICAqL1xuICByZWFkb25seSBhbGxvd0NvbW1lbnRzPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgSlNPTiBmaWxlLlxuICovXG5leHBvcnQgY2xhc3MgSnNvbkZpbGUgZXh0ZW5kcyBPYmplY3RGaWxlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBuZXdsaW5lOiBib29sZWFuO1xuICBwcml2YXRlIHJlYWRvbmx5IHN1cHBvcnRzQ29tbWVudHM6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCwgZmlsZVBhdGg6IHN0cmluZywgb3B0aW9uczogSnNvbkZpbGVPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCwgZmlsZVBhdGgsIG9wdGlvbnMpO1xuXG4gICAgdGhpcy5uZXdsaW5lID0gb3B0aW9ucy5uZXdsaW5lID8/IHRydWU7XG4gICAgdGhpcy5zdXBwb3J0c0NvbW1lbnRzID1cbiAgICAgIG9wdGlvbnMuYWxsb3dDb21tZW50cyA/P1xuICAgICAgKGZpbGVQYXRoLnRvTG93ZXJDYXNlKCkuZW5kc1dpdGgoXCJqc29uNVwiKSB8fFxuICAgICAgICBmaWxlUGF0aC50b0xvd2VyQ2FzZSgpLmVuZHNXaXRoKFwianNvbmNcIikpO1xuXG4gICAgaWYgKCFvcHRpb25zLm9iaikge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdcIm9ialwiIGNhbm5vdCBiZSB1bmRlZmluZWQnKTtcbiAgICB9XG4gIH1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUNvbnRlbnQocmVzb2x2ZXI6IElSZXNvbHZlcik6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgY29uc3QganNvbiA9IHN1cGVyLnN5bnRoZXNpemVDb250ZW50KHJlc29sdmVyKTtcbiAgICBpZiAoIWpzb24pIHtcbiAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfVxuXG4gICAgY29uc3Qgc2FuaXRpemVkID0gSlNPTi5wYXJzZShqc29uKTtcblxuICAgIGlmICh0aGlzLm1hcmtlciAmJiAhdGhpcy5zdXBwb3J0c0NvbW1lbnRzKSB7XG4gICAgICBzYW5pdGl6ZWRbXCIvL1wiXSA9IHRoaXMubWFya2VyO1xuICAgIH1cblxuICAgIGxldCBjb250ZW50ID0gSlNPTi5zdHJpbmdpZnkoc2FuaXRpemVkLCB1bmRlZmluZWQsIDIpO1xuICAgIGlmICh0aGlzLm1hcmtlciAmJiB0aGlzLnN1cHBvcnRzQ29tbWVudHMpIHtcbiAgICAgIGNvbnRlbnQgPSBjb250ZW50LnNsaWNlKDAsIC0xKSArIGAvLyAke3RoaXMubWFya2VyfVxcbn1gO1xuICAgIH1cblxuICAgIGlmICh0aGlzLm5ld2xpbmUpIHtcbiAgICAgIGNvbnRlbnQgKz0gXCJcXG5cIjtcbiAgICB9XG5cbiAgICByZXR1cm4gY29udGVudDtcbiAgfVxufVxuIl19