import { IResolver } from "./file";
import { ObjectFile, ObjectFileOptions } from "./object-file";
import { Project } from "./project";
/**
 * Options for `JsonFile`.
 */
export interface JsonFileOptions extends ObjectFileOptions {
    /**
     * Adds a newline at the end of the file.
     * @default true
     */
    readonly newline?: boolean;
    /**
     * Allow the use of comments in this file.
     * @default - false for .json files, true for .json5 and .jsonc files
     */
    readonly allowComments?: boolean;
}
/**
 * Represents a JSON file.
 */
export declare class JsonFile extends ObjectFile {
    private readonly newline;
    private readonly supportsComments;
    constructor(project: Project, filePath: string, options: JsonFileOptions);
    protected synthesizeContent(resolver: IResolver): string | undefined;
}
