"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenSample = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * Java code sample.
 */
class MavenSample extends component_1.Component {
    constructor(project, options) {
        super(project);
        const pkg = options.package.split(".");
        new sample_file_1.SampleDir(project, path_1.join("src", "main", "java", ...pkg), {
            files: {
                "Main.java": [
                    ...(options.package ? [`package ${options.package};`] : []),
                    "",
                    "public class Main {",
                    "  public static void main(final String[] args) {",
                    '    System.out.println("Hello, world!");',
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.MavenSample = MavenSample;
_a = JSII_RTTI_SYMBOL_1;
MavenSample[_a] = { fqn: "projen.java.MavenSample", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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