"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflow_actions_1 = require("./workflow-actions");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = "build";
/**
 * A GitHub workflow for common build tasks within a project.
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    constructor(github, options) {
        super(github, options.name);
        this.jobId = options.jobId ?? DEFAULT_JOB_ID;
        this.github = github;
        this.artifactsDirectory = options.artifactsDirectory;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {},
        });
        const preCheckoutSteps = options.preCheckoutSteps ?? [];
        const checkoutWith = options.checkoutWith
            ? { with: options.checkoutWith }
            : {};
        const preBuildSteps = options.preBuildSteps ?? [];
        const postBuildSteps = options.postBuildSteps ?? [];
        const gitIdentity = options.gitIdentity ?? constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (this.artifactsDirectory) {
            postBuildSteps.push({
                name: "Upload artifact",
                uses: "actions/upload-artifact@v2.1.1",
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: "always()",
                with: {
                    name: this.artifactsDirectory,
                    path: this.artifactsDirectory,
                },
            });
        }
        const job = {
            runsOn: options.runsOn ?? ["ubuntu-latest"],
            container: options.container,
            env: options.env,
            permissions: options.permissions,
            if: options.condition,
            outputs: options.outputs,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: "Checkout",
                    uses: "actions/checkout@v3",
                    ...checkoutWith,
                },
                // sets git identity so we can push later
                ...workflow_actions_1.WorkflowActions.setGitIdentity(gitIdentity),
                ...preBuildSteps,
                // run the main build task
                {
                    name: options.task.name,
                    run: this.github.project.runTaskCommand(options.task),
                },
                ...postBuildSteps,
            ],
        };
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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