"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const python_project_1 = require("../python/python-project");
const cdk8s_deps_py_1 = require("./cdk8s-deps-py");
/**
 * CDK8s app in Python
 *
 *
 * @pjid cdk8s-app-py
 */
class Cdk8sPythonApp extends python_project_1.PythonProject {
    constructor(options) {
        super({ ...options, pytest: false, sample: false });
        this.cdk8sDeps = new cdk8s_deps_py_1.Cdk8sDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            cdk8sCliDependency: false,
            ...options,
        });
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        this.appEntrypoint = options.appEntrypoint ?? "app.py";
        const synth = this.addTask("synth", {
            description: "Synthesizes your cdk8s app into dist",
            exec: "cdk8s synth",
        });
        // add synth to the build
        this.postCompileTask.spawn(synth);
        const cdk8sImports = options.cdk8sImports ?? [];
        const k8sSpec = options.k8sSpecVersion
            ? `k8s@${options.k8sSpecVersion}`
            : "k8s";
        new __1.YamlFile(this, "cdk8s.yaml", {
            committed: true,
            editGitignore: true,
            obj: {
                language: "python",
                app: `python ${this.appEntrypoint}`,
                imports: [k8sSpec, ...cdk8sImports],
            },
        });
        if (options.sample ?? true) {
            new AppCode(this, this.appEntrypoint);
        }
    }
}
exports.Cdk8sPythonApp = Cdk8sPythonApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sPythonApp[_a] = { fqn: "projen.cdk8s.Cdk8sPythonApp", version: "0.63.29" };
class AppCode extends __1.Component {
    constructor(project, filename) {
        super(project);
        new __1.SampleFile(project, filename, {
            contents: [
                "from constructs import Construct",
                "from cdk8s import App, Chart",
                "",
                "",
                "class MyChart(Chart):",
                "  def __init__(self, scope: Construct, id:str):",
                "    super().__init__(scope, id)",
                "",
                "",
                "app = App()",
                'MyChart(app, "${project.name}")',
                "",
                "app.synth()",
            ].join("\n"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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