"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const internal_1 = require("./internal");
class IntegrationTestBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const entry = options.entrypoint;
        const name = options.name ?? path_1.basename(entry, internal_1.TYPESCRIPT_INTEG_EXT);
        this.name = name;
        const dir = path_1.dirname(entry);
        const tmpRoot = path_1.join(dir, ".tmp");
        project.addGitIgnore(tmpRoot);
        project.addPackageIgnore(tmpRoot);
        this.tmpDir = path_1.join(tmpRoot, `${name}.integ`);
        this.snapshotDir = path_1.join(dir, `${name}.integ.snapshot`);
        project.addPackageIgnore(this.snapshotDir);
        this.deployTask = project.addTask(`integ:${name}:deploy`, {
            description: `deploy integration test '${name}' and capture snapshot`,
        });
        this.snapshotTask = project.addTask(`integ:${name}:snapshot`, {
            description: `update snapshot for integration test "${name}"`,
        });
        this.assertTask = project.addTask(`integ:${name}:assert`, {
            description: `assert the snapshot of integration test '${name}'`,
            exec: `[ -d "${this.snapshotDir}" ] || (echo "No snapshot available for integration test '${name}'. Run 'projen ${this.deployTask.name}' to capture." && exit 1)`,
        });
        // synth as part of our tests, which means that if outdir changes, anti-tamper will fail
        project.testTask.spawn(this.assertTask);
        let snapshotAllTask = project.tasks.tryFind("integ:snapshot-all");
        if (!snapshotAllTask) {
            snapshotAllTask = project.addTask("integ:snapshot-all", {
                description: "update snapshot for all integration tests",
            });
        }
        // integ:snapshot-all should snapshot all integration tests, including
        // this one.
        snapshotAllTask.spawn(this.snapshotTask);
    }
}
exports.IntegrationTestBase = IntegrationTestBase;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestBase[_a] = { fqn: "projen.cdk.IntegrationTestBase", version: "0.63.29" };
//# sourceMappingURL=data:application/json;base64,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