"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertToPosixPath = exports.TYPESCRIPT_LAMBDA_EXTENSION_EXT = exports.TYPESCRIPT_EDGE_LAMBDA_EXT = exports.TYPESCRIPT_LAMBDA_EXT = exports.FEATURE_FLAGS = void 0;
const path_1 = require("path");
/**
 * Feature flags as of v1.130.0
 */
exports.FEATURE_FLAGS = [
    "aws-cdk:enableDiffNoFail",
    "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId",
    "@aws-cdk/core:enableStackNameDuplicates",
    "@aws-cdk/core:stackRelativeExports",
    "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport",
    "@aws-cdk/aws-secretsmanager:parseOwnedSecretName",
    "@aws-cdk/aws-kms:defaultKeyPolicies",
    "@aws-cdk/aws-s3:grantWriteWithoutAcl",
    "@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount",
    "@aws-cdk/aws-rds:lowercaseDbIdentifier",
    "@aws-cdk/aws-efs:defaultEncryptionAtRest",
    "@aws-cdk/aws-lambda:recognizeVersionProps",
    "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021",
];
/**
 * Suffix for AWS Lambda handlers.
 */
exports.TYPESCRIPT_LAMBDA_EXT = ".lambda.ts";
/**
 * Suffix for AWS Edge Lambda handlers.
 */
exports.TYPESCRIPT_EDGE_LAMBDA_EXT = ".edge-lambda.ts";
/**
 * Suffix for AWS Lambda Extensions.
 */
exports.TYPESCRIPT_LAMBDA_EXTENSION_EXT = ".lambda-extension.ts";
/**
 * Converts the given path string to posix if it wasn't already.
 */
function convertToPosixPath(p) {
    return p.split(path_1.sep).join(path_1.posix.sep);
}
exports.convertToPosixPath = convertToPosixPath;
//# sourceMappingURL=data:application/json;base64,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