from typing import Optional, Any, Dict

from checkov.common.graph.checks_infra.enums import Operators
from .greater_than_or_equal_attribute_solver import GreaterThanOrEqualAttributeSolver


class LessThanAttributeSolver(GreaterThanOrEqualAttributeSolver):
    operator = Operators.LESS_THAN  # noqa: CCE003  # a static attribute

    def _get_operation(self, vertex: Dict[str, Any], attribute: Optional[str]) -> bool:
        if vertex.get(attribute) is None:  # type:ignore[arg-type]  # due to attribute can be None
            return False

        attr_val = vertex.get(attribute)  # type:ignore[arg-type]  # due to attribute can be None
        # if this value contains an underendered variable, then we cannot evaluate the check,
        # so return True (since we cannot return UNKNOWN)
        if self._is_variable_dependant(attr_val, vertex['source_']):
            return True

        return not super()._get_operation(vertex, attribute)
