# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/bilstm-based-search-on-netflix-data.ipynb (unless otherwise specified).

__all__ = ['split_df', 'Vocab', 'seqData', 'arrData', 'fuse']

# Cell
import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)
import os
from pathlib import Path
# Any results you write to the current directory are saved as output.

# Cell
def split_df(df, valid=0.2, ensure_factor=2):
    """
    df: dataframe
    valid: valid ratio, default 0.1
    ensure_factor, ensuring the row number to be the multiplication of this factor, default 2
    return train_df, valid_df
    """
    split_ = (np.random.rand(len(df)) > valid)
    train_df = df[split_].sample(frac=1.).reset_index().drop("index", axis=1)
    valid_df = df[~split_].sample(frac=1.).reset_index().drop("index", axis=1)

    if ensure_factor:
        train_mod = len(train_df) % ensure_factor
        valid_mod = len(valid_df) % ensure_factor
        if train_mod: train_df = train_df[:-train_mod]
        if valid_mod: valid_df = valid_df[:-valid_mod]
    return train_df, valid_df

# Cell
from itertools import chain
from multiprocessing import Pool
from collections import Counter
from torch.utils.data.dataset import Dataset

class Vocab(object):
    def __init__(self, iterative, tokenize, max_vocab = 20000,nproc=10):
        """
        Count the most frequent words
        Make the word<=>index mapping
        """
        self.l = list(iterative)
        self.nproc = nproc
        self.max_vocab = max_vocab
        self.tokenize = tokenize
        self.word_beads = self.word_beads_()
        self.counter()

    def __len__(self):
        return len(self.words)

    def __repr__(self):
        return f"vocab {self.max_vocab}"

    def word_beads_(self):
        self.p = Pool(self.nproc)
        return list(chain(*list(self.p.map(self.tokenize,self.l))))

    def counter(self):
        vals = np.array(list((k,v) for k,v in dict(Counter(self.word_beads)).items()))
        self.words = pd.DataFrame({"tok":vals[:,0],"ct":vals[:,1]})
        self.words["ct"] = self.words["ct"].apply(int)
        self.words = self.words.sort_values(by= "ct",ascending=False)\
        .reset_index().drop("index",axis=1).head(self.max_vocab-2)
        self.words["idx"] = (np.arange(len(self.words))+2)
        self.words=pd.concat([self.words,pd.DataFrame({"tok":["<eos>","<mtk>"],"ct":[-1,-1],"idx":[0,1]})])
        return self.words

    def to_i(self):
        self.t2i = dict(zip(self.words["tok"],self.words["idx"]))
        def to_index(t):
            i = self.t2i.get(t)
            if i==None:
                return 1
            else:
                return i
        return to_index

    def to_t(self):
        return np.roll(self.words["tok"],2)


# Cell

import torch
from torch.utils.data.dataloader import DataLoader
from torch.utils.data._utils.collate import default_collate

class seqData(Dataset):
    def __init__(self,lines,vocab,max_len=-1):
        """
        lines: iterative of text, eg. each element a sentence
        vocab:forge.data.nlp.Vocab
        max_len: max length
        """
        self.lines = list(lines)
        self.vocab = vocab
        self.to_i = np.vectorize(vocab.to_i())
        self.to_t = vocab.to_t()
        self.bs=1
        self.max_len=max_len

    def __len__(self):
        return len(self.lines)

    def __getitem__(self,idx):
        """
        Translate words to indices
        """
        line = self.lines[idx]
        words = self.vocab.tokenize(line)
        if self.max_len>2:
            words = words[:self.max_len-2]
        words = ["<eos>",]+words+["<eos>"]
        return self.to_i(np.array(words))

    def backward(self,seq):
        """
        This backward has nothing to do with gradrient
        Just to error proof the tokenized line
        """
        return " ".join(self.to_t[seq])

    def collate(self,rows):
        """
        this collate will pad any sentence that is less then the max length
        """
        line_len = torch.LongTensor(list(len(row) for row in rows));
        max_len = line_len.max()
        ones = torch.ones(max_len.item()).long()
        line_pad = max_len-line_len
        return torch.stack(list(torch.cat([torch.LongTensor(row),ones[:pad.item()]]) for row,pad in zip(rows,line_pad[:,None])))

class arrData(Dataset):
    def __init__(self, *arrs):
        self.arr = np.concatenate(arrs,axis=1)

    def __len__(self):
        return self.arr.shape[0]

    def __getitem__(self,idx):
        return self.arr[idx]

    def collate(self,rows):
        return default_collate(rows)

# Cell
class fuse(Dataset):
    def __init__(self, *datasets):
        """
        A pytorch dataset combining the dataset
        :param datasets:
        """
        self.datasets = datasets
        length_s = set(list(len(d) for d in self.datasets))
        assert len(length_s) == 1, "dataset lenth not matched"
        self.length = list(length_s)[0]
        self.collates = list(i.collate if hasattr(i,"collate") else default_collate for i in datasets)

    def __len__(self):
        return self.length

    def __getitem__(self, idx):
        return tuple(d.__getitem__(idx) for d in self.datasets)

    def collate(self,rows):
        xs = list(zip(*rows))
        return tuple(func(x) for func, x in zip(self.collates,xs))