"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.dir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'chwebapp'));
        this.path = path_1.join(this.dir, 'config.json');
        fs_1.writeFileSync(this.path, JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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