interface PackageTagPresentationBase {
    /**
     * (experimental) The label for the tag being applied.
     *
     * @experimental
     */
    readonly label: string;
    /**
     * (experimental) The hex value string for the color of the tag when displayed.
     *
     * @experimental
     */
    readonly color?: string;
}
/**
 * @experimental
 */
export interface Keyword extends PackageTagPresentationBase {
}
/**
 * @experimental
 */
export interface Highlight extends PackageTagPresentationBase {
    /**
     * (experimental) Icon displayed next to highlight on package card.
     *
     * @experimental
     */
    readonly icon?: string;
}
/**
 * @experimental
 */
export interface SearchFilter {
    /**
     * (experimental) Display name for filter.
     *
     * @experimental
     */
    readonly display: string;
    /**
     * (experimental) Name of group to include filter in.
     *
     * @experimental
     */
    readonly groupBy: string;
}
/**
 * @experimental
 */
export interface PackageTagBase {
    /**
     * (experimental) Identifier for tag, used for search.
     *
     * Must be unique amongst tags.
     *
     * @experimental
     */
    readonly id: string;
    /**
     * (experimental) Configuration for higlighting tag on package card.
     *
     * @default don't highlight tag
     * @experimental
     */
    readonly highlight?: Highlight;
    /**
     * (experimental) Configuration for showing tag as keyword.
     *
     * @default don't show tag in keyword list
     * @experimental
     */
    readonly keyword?: Keyword;
    /**
     * (experimental) Configuration for showing tag as search filter.
     *
     * @default don't show tag in search filters
     * @experimental
     */
    readonly searchFilter?: SearchFilter;
}
/**
 * (experimental) Configuration for applying custom tags to relevant packages.
 *
 * Custom tags are
 * displayed on the package details page, and can be used for searching.
 *
 * @experimental
 */
export interface PackageTag extends PackageTagBase {
    /**
     * (experimental) The description of the logic that dictates whether the package has the tag applied.
     *
     * @experimental
     */
    readonly condition: TagCondition;
}
/**
 * (experimental) Serialized config for a tag condition.
 *
 * @experimental
 */
export interface TagConditionConfig {
    /**
     * @experimental
     */
    readonly type: TagConditionLogicType;
    /**
     * @experimental
     */
    readonly key?: string[];
    /**
     * @experimental
     */
    readonly value?: string;
    /**
     * @experimental
     */
    readonly children?: TagConditionConfig[];
}
/**
 * (experimental) Serialized tag declaration to be passed to lambdas via environment variables.
 *
 * @experimental
 */
export interface PackageTagConfig extends PackageTagBase {
    /**
     * @experimental
     */
    readonly condition: TagConditionConfig;
}
/**
 * (experimental) Condition for applying a custom tag to a package.
 *
 * @experimental
 */
export declare abstract class TagCondition {
    /**
     * (experimental) Create an && condition which applies only when all condition arguments are true.
     *
     * @experimental
     */
    static and(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Create an || condition which applies if any of the condition arguments are true.
     *
     * @experimental
     */
    static or(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Create a !
     *
     * condition which applies if the condition argument is false
     *
     * @experimental
     */
    static not(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Target a field within the `package.json` to assert against. Nested fields can be accessed by passing multiple keys. `TagCondition.field('key1', 'key2')` will access `packageJson?.key1?.key2`.
     *
     * @experimental
     */
    static field(...keys: string[]): TagConditionField;
    /**
     * @experimental
     */
    abstract bind(): TagConditionConfig;
}
/**
 * (experimental) Logic operators for performing specific conditional logic.
 *
 * @experimental
 */
export declare enum TagConditionLogicType {
    /**
     * @experimental
     */
    AND = "AND",
    /**
     * @experimental
     */
    OR = "OR",
    /**
     * @experimental
     */
    NOT = "NOT",
    /**
     * @experimental
     */
    EQUALS = "EQUALS",
    /**
     * @experimental
     */
    INCLUDES = "INCLUDES",
    /**
     * @experimental
     */
    STARTS_WITH = "STARTS_WITH"
}
/**
 * (experimental) Target a field to use in logic to dictate whether a tag is relevant.
 *
 * @experimental
 */
export declare class TagConditionField {
    private readonly field;
    /**
     * @experimental
     */
    constructor(field: string[]);
    /**
     * (experimental) Create a === condition which applies if the specified field within the package's package.json is equal to the passed value.
     *
     * @experimental
     */
    eq(value: any): TagCondition;
    /**
     * (experimental) Create a `field.includes(value)` condition which applies if the specified field within the package's package.json includes the value. This works for arrays or strings.
     *
     * @experimental
     */
    includes(value: any): TagCondition;
    /**
     * (experimental) Create a `field.startsWith(value)` condition which applies if the specified field within the package's package.json begins with the value. This works only for string values.
     *
     * @experimental
     */
    startsWith(value: string): TagCondition;
}
export {};
