(function () {

	var
		define  = X3D .define,
		require = X3D .require;

/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ('x_ite/Components/RigidBodyPhysics/X3DRigidJointNode',[
	"x_ite/Fields",
	"x_ite/Components/Core/X3DNode",
	"x_ite/Bits/X3DConstants",
	"x_ite/Bits/X3DCast",
	"standard/Math/Numbers/Matrix4",
],
function (Fields,
          X3DNode, 
          X3DConstants,
          X3DCast,
          Matrix4)
{
"use strict";

	function X3DRigidJointNode (executionContext)
	{
		X3DNode .call (this, executionContext);

		this .addType (X3DConstants .X3DRigidJointNode);

		this .addChildObjects ("collection", new Fields .SFNode ());

		this .bodyNode1             = null;
		this .bodyNode2             = null;
		this .initialInverseMatrix1 = new Matrix4 ();
		this .initialInverseMatrix2 = new Matrix4 ();
		this .output                = false;
	}

	X3DRigidJointNode .prototype = Object .assign (Object .create (X3DNode .prototype),
	{
		constructor: X3DRigidJointNode,
		initialize: function ()
		{
			X3DNode .prototype .initialize .call (this);

			this .forceOutput_ .addInterest ("set_forceOutput__", this);
			this .body1_       .addInterest ("set_body1__",       this);
			this .body2_       .addInterest ("set_body2__",       this);
		
			this .set_forceOutput__ ();
			this .set_body1__ ();
			this .set_body2__ ();
		},
		setCollection: function (value)
		{
			this .removeJoint ();

			this .collection_ = value;

			this .addJoint ();
		},
		getCollection: function ()
		{
			return this .collection_ .getValue ();
		},
		getBody1: function ()
		{
			return this .bodyNode1;
		},
		getBody2: function ()
		{
			return this .bodyNode2;
		},
		getInitialInverseMatrix1: function ()
		{
			return this .initialInverseMatrix1;
		},
		getInitialInverseMatrix2: function ()
		{
			return this .initialInverseMatrix2;
		},
		setOutput: function (value)
		{
			this .output = value;

			if (value)
			{
				if (this .bodyNode1)
					this .bodyNode1 .addInterest ("update1", this);

				if (this .bodyNode2)
					this .bodyNode2 .addInterest ("update2", this);
			}
			else
			{
				if (this .bodyNode1)
					this .bodyNode1 .removeInterest ("update1", this);

				if (this .bodyNode2)
					this .bodyNode2 .removeInterest ("update2", this);
			}
		},
		addJoint: function ()
		{ },
		removeJoint: function ()
		{ },
		set_forceOutput__: function ()
		{ },
		set_joint__: function ()
		{
			this .removeJoint ();
			this .addJoint ();
		},
		set_body1__: function ()
		{
			this .removeJoint ();
		
			if (this .bodyNode1)
			{
				this .bodyNode1 .removeInterest ("update1", this);
				this .bodyNode1 .collection_ .removeInterest ("set_joint__", this);
			}
		
			this .bodyNode1 = X3DCast (X3DConstants .RigidBody, this .body1_);
		
			if (this .bodyNode1)
			{
				this .bodyNode1 .collection_ .addInterest ("set_joint__", this);

				this .initialize1 ();
				this .addJoint ();
				this .setOutput (this .output);
			}
		},
		set_body2__: function ()
		{
			this .removeJoint ();
		
			if (this .bodyNode2)
			{
				this .bodyNode2 .removeInterest ("update2", this);
				this .bodyNode2 .collection_ .removeInterest ("set_joint__", this);
			}
		
			this .bodyNode2 = X3DCast (X3DConstants .RigidBody, this .body2_);
		
			if (this .bodyNode2)
			{
				this .bodyNode2 .collection_ .addInterest ("set_joint__", this);

				this .initialize2 ();
				this .addJoint ();
				this .setOutput (this .output);
			}
		},
		initialize1: function ()
		{
			this .initialInverseMatrix1 .set (this .bodyNode1 .position_ .getValue (), this .bodyNode1 .orientation_ .getValue ());
			this .initialInverseMatrix1 .inverse ();
		},
		initialize2: function ()
		{
			this .initialInverseMatrix2 .set (this .bodyNode2 .position_ .getValue (), this .bodyNode2 .orientation_ .getValue ());
			this .initialInverseMatrix2 .inverse ();
		},
		update1: function ()
		{ },
		update2: function ()
		{ },
		dispose: function ()
		{
			this .removeJoint ();

			X3DNode .prototype .dispose .call (this);
		},
	});

	return X3DRigidJointNode;
});




  // This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
  var Ammo = function(Ammo) {
  Ammo = Ammo || {};

var Module=typeof Ammo!=="undefined"?Ammo:{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}Module["arguments"]=[];Module["thisProgram"]="./this.program";Module["quit"]=(function(status,toThrow){throw toThrow});Module["preRun"]=[];Module["postRun"]=[];var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("Module['ENVIRONMENT'] value is not valid. must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){var ret;ret=tryParseAsDataURI(filename);if(!ret){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);ret=nodeFS["readFileSync"](filename)}return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}Module["arguments"]=process["argv"].slice(2);process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));process["on"]("unhandledRejection",(function(reason,p){process["exit"](1)}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(typeof read!="undefined"){Module["read"]=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}Module["readBinary"]=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status,toThrow){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)};Module["setWindowTitle"]=(function(title){document.title=title})}Module["print"]=typeof console!=="undefined"?console.log.bind(console):typeof print!=="undefined"?print:null;Module["printErr"]=typeof printErr!=="undefined"?printErr:typeof console!=="undefined"&&console.warn.bind(console)||Module["print"];Module.print=Module["print"];Module.printErr=Module["printErr"];for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var STACK_ALIGN=16;function staticAlloc(size){assert(!staticSealed);var ret=STATICTOP;STATICTOP=STATICTOP+size+15&-16;return ret}function dynamicAlloc(size){assert(DYNAMICTOP_PTR);var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=ret+size+15&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}function alignMemory(size,factor){if(!factor)factor=STACK_ALIGN;var ret=size=Math.ceil(size/factor)*factor;return ret}function getNativeTypeSize(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return 4}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}function warnOnce(text){if(!warnOnce.shown)warnOnce.shown={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;Module.printErr(text)}}var jsCallStartIndex=1;var functionPointers=new Array(0);var funcWrappers={};function dynCall(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}var GLOBAL_BASE=8;var ABORT=0;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}var JSfuncs={"stackSave":(function(){stackSave()}),"stackRestore":(function(){stackRestore()}),"arrayToC":(function(arr){var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};function ccall(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);else if(returnType==="boolean")ret=Boolean(ret);if(stack!==0){stackRestore(stack)}return ret}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}var ALLOC_STATIC=2;var ALLOC_NONE=4;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:staticAlloc,stackAlloc,staticAlloc,dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return UTF8ToString(ptr)}var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function demangle(func){return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}var WASM_PAGE_SIZE=65536;var ASMJS_PAGE_SIZE=16777216;var MIN_TOTAL_MEMORY=16777216;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}if(!Module["reallocBuffer"])Module["reallocBuffer"]=(function(size){var ret;try{if(ArrayBuffer.transfer){ret=ArrayBuffer.transfer(buffer,size)}else{var oldHEAP8=HEAP8;ret=new ArrayBuffer(size);var temp=new Int8Array(ret);temp.set(oldHEAP8)}}catch(e){return false}var success=_emscripten_replace_memory(ret);if(!success)return false;return ret});function enlargeMemory(){var PAGE_MULTIPLE=Module["usingWasm"]?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE;var LIMIT=2147483648-PAGE_MULTIPLE;if(HEAP32[DYNAMICTOP_PTR>>2]>LIMIT){return false}var OLD_TOTAL_MEMORY=TOTAL_MEMORY;TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);while(TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2]){if(TOTAL_MEMORY<=536870912){TOTAL_MEMORY=alignUp(2*TOTAL_MEMORY,PAGE_MULTIPLE)}else{TOTAL_MEMORY=Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=Module["reallocBuffer"](TOTAL_MEMORY);if(!replacement||replacement.byteLength!=TOTAL_MEMORY){TOTAL_MEMORY=OLD_TOTAL_MEMORY;return false}updateGlobalBuffer(replacement);updateGlobalBufferViews();return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;if(TOTAL_MEMORY<TOTAL_STACK)Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}Module["buffer"]=buffer}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}HEAP32[0]=1668509029;HEAP16[1]=25459;if(HEAPU8[2]!==115||HEAPU8[3]!==99)throw"Runtime error: expected the system to be little-endian!";function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPreMain(cb){__ATMAIN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_round=Math.round;var Math_min=Math.min;var Math_max=Math.max;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var dataURIPrefix="data:application/octet-stream;base64,";function isDataURI(filename){return String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0}var ASM_CONSTS=[(function($0,$1,$2,$3,$4,$5,$6,$7){var self=Module["getCache"](Module["ConcreteContactResultCallback"])[$0];if(!self.hasOwnProperty("addSingleResult"))throw"a JSImplementation must implement all functions, you forgot ConcreteContactResultCallback::addSingleResult.";return self["addSingleResult"]($1,$2,$3,$4,$5,$6,$7)})];function _emscripten_asm_const_diiiiiiii(code,a0,a1,a2,a3,a4,a5,a6,a7){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6,a7)}STATIC_BASE=GLOBAL_BASE;STATICTOP=STATIC_BASE+26496;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});memoryInitializer="data:application/octet-stream;base64,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";var tempDoublePtr=STATICTOP;STATICTOP+=16;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var key in EXCEPTIONS.infos){var ptr=+key;var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0&&!info.rethrown){if(info.destructor){Module["dynCall_vi"](info.destructor,ptr)}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___cxa_begin_catch(ptr){var info=EXCEPTIONS.infos[ptr];if(info&&!info.caught){info.caught=true;__ZSt18uncaught_exceptionv.uncaught_exception--}if(info)info.rethrown=false;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(setTempRet0(0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(setTempRet0(0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(setTempRet0(typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(setTempRet0(throwntype),thrown)|0}function ___gxx_personality_v0(){}var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function flush_NO_FILESYSTEM(){var fflush=Module["_fflush"];if(fflush)fflush(0);var printChar=___syscall146.printChar;if(!printChar)return;var buffers=___syscall146.buffers;if(buffers[1].length)printChar(1,10);if(buffers[2].length)printChar(2,10)}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffers){___syscall146.buffers=[null,[],[]];___syscall146.printChar=(function(stream,curr){var buffer=___syscall146.buffers[stream];assert(buffer);if(curr===0||curr===10){(stream===1?Module["print"]:Module["printErr"])(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}})}for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){___syscall146.printChar(stream,HEAPU8[ptr+j])}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_STATIC);function _abort(){Module["abort"]()}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}var _llvm_fabs_f32=Math_abs;var _llvm_pow_f32=Math_pow;function _llvm_trap(){abort("trap!")}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}var PTHREAD_SPECIFIC_NEXT_KEY=1;var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Module["dynCall_v"](func);_pthread_once.seen[ptr]=1}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}DYNAMICTOP_PTR=staticAlloc(4);STACK_BASE=STACKTOP=alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}var decodeBase64=typeof atob==="function"?atob:(function(input){var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output});function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vidd(index,a1,a2,a3){try{Module["dynCall_vidd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"byteLength":byteLength};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"invoke_di":invoke_di,"invoke_did":invoke_did,"invoke_diidii":invoke_diidii,"invoke_diii":invoke_diii,"invoke_diiidii":invoke_diiidii,"invoke_diiii":invoke_diiii,"invoke_diiiii":invoke_diiiii,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_ii":invoke_ii,"invoke_iidid":invoke_iidid,"invoke_iii":invoke_iii,"invoke_iiid":invoke_iiid,"invoke_iiii":invoke_iiii,"invoke_iiiii":invoke_iiiii,"invoke_iiiiiii":invoke_iiiiiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_v":invoke_v,"invoke_vi":invoke_vi,"invoke_vid":invoke_vid,"invoke_vidd":invoke_vidd,"invoke_viddiii":invoke_viddiii,"invoke_vidi":invoke_vidi,"invoke_vidii":invoke_vidii,"invoke_vii":invoke_vii,"invoke_viid":invoke_viid,"invoke_viidi":invoke_viidi,"invoke_viidii":invoke_viidii,"invoke_viii":invoke_viii,"invoke_viiid":invoke_viiid,"invoke_viiidii":invoke_viiidii,"invoke_viiii":invoke_viiii,"invoke_viiiid":invoke_viiiid,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_viiiii":invoke_viiiii,"invoke_viiiiid":invoke_viiiiid,"invoke_viiiiii":invoke_viiiiii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___cxa_begin_catch":___cxa_begin_catch,"___cxa_find_matching_catch":___cxa_find_matching_catch,"___cxa_pure_virtual":___cxa_pure_virtual,"___gxx_personality_v0":___gxx_personality_v0,"___resumeException":___resumeException,"___setErrNo":___setErrNo,"___syscall140":___syscall140,"___syscall146":___syscall146,"___syscall6":___syscall6,"_abort":_abort,"_emscripten_asm_const_diiiiiiii":_emscripten_asm_const_diiiiiiii,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_gettimeofday":_gettimeofday,"_llvm_fabs_f32":_llvm_fabs_f32,"_llvm_pow_f32":_llvm_pow_f32,"_llvm_trap":_llvm_trap,"_pthread_getspecific":_pthread_getspecific,"_pthread_key_create":_pthread_key_create,"_pthread_once":_pthread_once,"_pthread_setspecific":_pthread_setspecific,"flush_NO_FILESYSTEM":flush_NO_FILESYSTEM,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"almost asm";var a=global.Int8Array;var b=new a(buffer);var c=global.Int16Array;var d=new c(buffer);var e=global.Int32Array;var f=new e(buffer);var g=global.Uint8Array;var h=new g(buffer);var i=global.Uint16Array;var j=new i(buffer);var k=global.Uint32Array;var l=new k(buffer);var m=global.Float32Array;var n=new m(buffer);var o=global.Float64Array;var p=new o(buffer);var q=global.byteLength;var r=env.DYNAMICTOP_PTR|0;var s=env.tempDoublePtr|0;var t=env.ABORT|0;var u=env.STACKTOP|0;var v=env.STACK_MAX|0;var w=env.cttz_i8|0;var x=0;var y=0;var z=0;var A=0;var B=global.NaN,C=global.Infinity;var D=0,E=0,F=0,G=0,H=0.0;var I=0;var J=global.Math.floor;var K=global.Math.abs;var L=global.Math.sqrt;var M=global.Math.pow;var N=global.Math.cos;var O=global.Math.sin;var P=global.Math.tan;var Q=global.Math.acos;var R=global.Math.asin;var S=global.Math.atan;var T=global.Math.atan2;var U=global.Math.exp;var V=global.Math.log;var W=global.Math.ceil;var X=global.Math.imul;var Y=global.Math.min;var Z=global.Math.max;var _=global.Math.clz32;var $=env.abort;var aa=env.assert;var ba=env.enlargeMemory;var ca=env.getTotalMemory;var da=env.abortOnCannotGrowMemory;var ea=env.invoke_di;var fa=env.invoke_did;var ga=env.invoke_diidii;var ha=env.invoke_diii;var ia=env.invoke_diiidii;var ja=env.invoke_diiii;var ka=env.invoke_diiiii;var la=env.invoke_diiiiiiii;var ma=env.invoke_diiiiiiiii;var na=env.invoke_diiiiiiiiii;var oa=env.invoke_ii;var pa=env.invoke_iidid;var qa=env.invoke_iii;var ra=env.invoke_iiid;var sa=env.invoke_iiii;var ta=env.invoke_iiiii;var ua=env.invoke_iiiiiii;var va=env.invoke_iiiiiiiiii;var wa=env.invoke_iiiiiiiiiii;var xa=env.invoke_v;var ya=env.invoke_vi;var za=env.invoke_vid;var Aa=env.invoke_vidd;var Ba=env.invoke_viddiii;var Ca=env.invoke_vidi;var Da=env.invoke_vidii;var Ea=env.invoke_vii;var Fa=env.invoke_viid;var Ga=env.invoke_viidi;var Ha=env.invoke_viidii;var Ia=env.invoke_viii;var Ja=env.invoke_viiid;var Ka=env.invoke_viiidii;var La=env.invoke_viiii;var Ma=env.invoke_viiiid;var Na=env.invoke_viiiidddddidi;var Oa=env.invoke_viiiiddddiid;var Pa=env.invoke_viiiii;var Qa=env.invoke_viiiiid;var Ra=env.invoke_viiiiii;var Sa=env.invoke_viiiiiii;var Ta=env.invoke_viiiiiiiii;var Ua=env.invoke_viiiiiiiiii;var Va=env.__ZSt18uncaught_exceptionv;var Wa=env.___cxa_begin_catch;var Xa=env.___cxa_find_matching_catch;var Ya=env.___cxa_pure_virtual;var Za=env.___gxx_personality_v0;var _a=env.___resumeException;var $a=env.___setErrNo;var ab=env.___syscall140;var bb=env.___syscall146;var cb=env.___syscall6;var db=env._abort;var eb=env._emscripten_asm_const_diiiiiiii;var fb=env._emscripten_memcpy_big;var gb=env._gettimeofday;var hb=env._llvm_fabs_f32;var ib=env._llvm_pow_f32;var jb=env._llvm_trap;var kb=env._pthread_getspecific;var lb=env._pthread_key_create;var mb=env._pthread_once;var nb=env._pthread_setspecific;var ob=env.flush_NO_FILESYSTEM;var pb=0.0;function qb(newBuffer){if(q(newBuffer)&16777215||q(newBuffer)<=16777215||q(newBuffer)>2147483648)return false;b=new a(newBuffer);d=new c(newBuffer);f=new e(newBuffer);h=new g(newBuffer);j=new i(newBuffer);l=new k(newBuffer);n=new m(newBuffer);p=new o(newBuffer);buffer=newBuffer;return true}
// EMSCRIPTEN_START_FUNCS
function uf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;B=(b[a+28>>0]|0)!=0;C=B?d:c;B=B?c:d;z=f[a+12>>2]|0;if((z|0)<=0){x=1.0;return +x}A=(f[C+192>>2]|0)+24|0;i=+n[C+4>>2];u=+n[C+8>>2];v=+n[C+12>>2];w=f[C+16>>2]|0;x=+n[C+20>>2];j=+n[C+24>>2];k=+n[C+28>>2];d=f[C+32>>2]|0;l=+n[C+36>>2];m=+n[C+40>>2];o=+n[C+44>>2];p=f[C+48>>2]|0;q=+n[C+52>>2];r=+n[C+56>>2];s=+n[C+60>>2];t=f[C+64>>2]|0;h=1.0;c=0;y=f[C+260>>2]|0;do{E=f[A>>2]|0;P=+n[E+(c*80|0)>>2];O=+n[E+(c*80|0)+16>>2];N=+n[E+(c*80|0)+32>>2];M=+n[E+(c*80|0)+4>>2];L=+n[E+(c*80|0)+20>>2];K=+n[E+(c*80|0)+36>>2];J=+n[E+(c*80|0)+8>>2];I=+n[E+(c*80|0)+24>>2];H=+n[E+(c*80|0)+40>>2];G=+n[E+(c*80|0)+48>>2];F=+n[E+(c*80|0)+52>>2];D=+n[E+(c*80|0)+56>>2];f[C+260>>2]=y+1;n[C+4>>2]=i*P+u*O+v*N;n[C+8>>2]=i*M+u*L+v*K;n[C+12>>2]=i*J+u*I+v*H;n[C+16>>2]=0.0;n[C+20>>2]=x*P+j*O+k*N;n[C+24>>2]=x*M+j*L+k*K;n[C+28>>2]=x*J+j*I+k*H;n[C+32>>2]=0.0;n[C+36>>2]=l*P+m*O+o*N;n[C+40>>2]=l*M+m*L+o*K;n[C+44>>2]=l*J+m*I+o*H;n[C+48>>2]=0.0;n[C+52>>2]=q+(i*G+u*F+v*D);n[C+56>>2]=r+(x*G+j*F+k*D);n[C+60>>2]=s+(l*G+m*F+o*D);n[C+64>>2]=0.0;E=f[(f[a+20>>2]|0)+(c<<2)>>2]|0;D=+xb[f[(f[E>>2]|0)+12>>2]&15](E,C,B,e,g);h=D<h?D:h;y=(f[C+260>>2]|0)+1|0;f[C+260>>2]=y;n[C+4>>2]=i;n[C+8>>2]=u;n[C+12>>2]=v;f[C+16>>2]=w;n[C+20>>2]=x;n[C+24>>2]=j;n[C+28>>2]=k;f[C+32>>2]=d;n[C+36>>2]=l;n[C+40>>2]=m;n[C+44>>2]=o;f[C+48>>2]=p;n[C+52>>2]=q;n[C+56>>2]=r;n[C+60>>2]=s;f[C+64>>2]=t;c=c+1|0}while((c|0)!=(z|0));return +h}function vf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;h=Qs()|0;f[h+4>>2]=7;f[h+8>>2]=-1;f[h+12>>2]=-1;n[h+16>>2]=3402823466385288598117041.0e14;b[h+20>>0]=1;b[h+21>>0]=0;f[h+24>>2]=-1;f[h+28>>2]=a;f[h+32>>2]=c;n[h+36>>2]=0.0;n[h+40>>2]=.30000001192092896;f[h+44>>2]=0;f[h>>2]=4792;b[h+48>>0]=0;f[h+52>>2]=f[d>>2];f[h+52+4>>2]=f[d+4>>2];f[h+52+8>>2]=f[d+8>>2];f[h+52+12>>2]=f[d+12>>2];f[h+68>>2]=f[d+16>>2];f[h+68+4>>2]=f[d+16+4>>2];f[h+68+8>>2]=f[d+16+8>>2];f[h+68+12>>2]=f[d+16+12>>2];f[h+84>>2]=f[d+32>>2];f[h+84+4>>2]=f[d+32+4>>2];f[h+84+8>>2]=f[d+32+8>>2];f[h+84+12>>2]=f[d+32+12>>2];f[h+100>>2]=f[d+48>>2];f[h+100+4>>2]=f[d+48+4>>2];f[h+100+8>>2]=f[d+48+8>>2];f[h+100+12>>2]=f[d+48+12>>2];f[h+116>>2]=f[e>>2];f[h+116+4>>2]=f[e+4>>2];f[h+116+8>>2]=f[e+8>>2];f[h+116+12>>2]=f[e+12>>2];f[h+132>>2]=f[e+16>>2];f[h+132+4>>2]=f[e+16+4>>2];f[h+132+8>>2]=f[e+16+8>>2];f[h+132+12>>2]=f[e+16+12>>2];f[h+148>>2]=f[e+32>>2];f[h+148+4>>2]=f[e+32+4>>2];f[h+148+8>>2]=f[e+32+8>>2];f[h+148+12>>2]=f[e+32+12>>2];f[h+164>>2]=f[e+48>>2];f[h+164+4>>2]=f[e+48+4>>2];f[h+164+8>>2]=f[e+48+8>>2];f[h+164+12>>2]=f[e+48+12>>2];b[h+180>>0]=g&1;n[h+184>>2]=1.0;n[h+188>>2]=-1.0;n[h+192>>2]=0.0;n[h+196>>2]=0.0;n[h+200>>2]=1.0;n[h+204>>2]=.699999988079071;n[h+208>>2]=0.0;n[h+212>>2]=0.0;n[h+216>>2]=1.0;n[h+220>>2]=.699999988079071;n[h+224>>2]=0.0;n[h+228>>2]=0.0;n[h+264>>2]=1.0;n[h+268>>2]=.699999988079071;n[h+272>>2]=1.0;n[h+276>>2]=0.0;n[h+280>>2]=1.0;n[h+284>>2]=.699999988079071;n[h+288>>2]=1.0;n[h+292>>2]=0.0;n[h+232>>2]=1.0;n[h+236>>2]=.699999988079071;n[h+240>>2]=1.0;n[h+244>>2]=0.0;n[h+248>>2]=1.0;n[h+252>>2]=.699999988079071;n[h+256>>2]=1.0;n[h+260>>2]=0.0;b[h+1096>>0]=0;n[h+1116>>2]=0.0;n[h+1120>>2]=0.0;n[h+1124>>2]=0.0;f[h+300>>2]=0;f[h+1100>>2]=0;f[h+1100+4>>2]=0;f[h+1100+8>>2]=0;b[h+1100+12>>0]=0;b[h+49>>0]=1;bd(h,(f[h+28>>2]|0)+4|0,(f[h+32>>2]|0)+4|0);return h|0}function wf(a,c){a=a|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0;i=u;u=u+64|0;Sg(f[a+116>>2]|0,c,0);d=+n[c+204>>2]+ +n[c+212>>2];g=d*+n[c+56>>2]+ +n[c+40>>2];h=d*+n[c+60>>2]+ +n[c+44>>2];n[c+16>>2]=+n[c+52>>2]*d+ +n[c+36>>2];n[c+20>>2]=g;n[c+24>>2]=h;n[c+28>>2]=0.0;n[i+32>>2]=-1.0;j=f[a+100>>2]|0;j=Gb[f[(f[j>>2]|0)+8>>2]&31](j,c+36|0,c+16|0,i)|0;f[c+88>>2]=0;if(!j){f[c+32>>2]=f[c+204>>2];n[c+272>>2]=0.0;g=-+n[c+56>>2];h=-+n[c+60>>2];n[c>>2]=-+n[c+52>>2];n[c+4>>2]=g;n[c+8>>2]=h;n[c+12>>2]=0.0;h=-1.0;g=1.0;j=c+268|0;n[j>>2]=g;u=i;return +h}d=d*+n[i+32>>2];f[c>>2]=f[i+16>>2];f[c+4>>2]=f[i+16+4>>2];f[c+8>>2]=f[i+16+8>>2];f[c+12>>2]=f[i+16+12>>2];b[c+84>>0]=1;if((b[22760]|0)==0?fz(22760)|0:0){f[i+40>>2]=0;f[i+40+4>>2]=0;f[i+40+8>>2]=0;f[i+40+12>>2]=0;qg(24036,0.0,0,0,i+40|0)}f[6060]=f[6060]|1;n[6095]=0.0;k=+n[6105]*0.0;e=+n[6106]*0.0;n[6100]=+n[6104]*0.0;n[6101]=k;n[6102]=e;n[6103]=0.0;f[6108]=0;f[6109]=0;f[6110]=0;f[6111]=0;e=+n[6097]*0.0;k=+n[6098]*0.0;n[6149]=+n[6096]*0.0;n[6150]=e;n[6151]=k;n[6152]=0.0;f[c+88>>2]=24036;k=d-+n[c+212>>2];n[c+32>>2]=k;e=+n[c+204>>2];g=+n[c+208>>2]*.009999999776482582;h=k<e-g?e-g:k;if(k<e-g|h>e+g)n[c+32>>2]=h>e+g?e+g:h;f[c+16>>2]=f[i>>2];f[c+16+4>>2]=f[i+4>>2];f[c+16+8>>2]=f[i+8>>2];f[c+16+12>>2]=f[i+12>>2];r=+n[c>>2];q=+n[c+4>>2];m=+n[c+8>>2];h=r*+n[c+52>>2]+q*+n[c+56>>2]+m*+n[c+60>>2];j=f[a+116>>2]|0;g=+n[c+16>>2]-+n[j+52>>2];l=+n[c+20>>2]-+n[j+56>>2];o=+n[c+24>>2]-+n[j+60>>2];k=+n[j+332>>2];p=+n[j+336>>2];e=+n[j+328>>2];n[c+272>>2]=!(h>=-.10000000149011612)?-1.0/h*(r*(k*o-l*p+ +n[j+312>>2])+q*(+n[j+316>>2]+(g*p-o*e))+m*(l*e-g*k+ +n[j+320>>2])):0.0;k=d;h=!(h>=-.10000000149011612)?-1.0/h:10.0;j=c+268|0;n[j>>2]=h;u=i;return +k}function xf(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;m=u;u=u+64|0;d=f[c+192>>2]|0;Yb[f[(f[d>>2]|0)+8>>2]&127](d,c+4|0,m+48|0,m+32|0);e=+n[m+48>>2]+-.019999999552965164;n[m+48>>2]=e;h=+n[m+48+4>>2]+-.019999999552965164;n[m+48+4>>2]=h;i=+n[m+48+8>>2]+-.019999999552965164;n[m+48+8>>2]=i;g=+n[m+32>>2]+.019999999552965164;n[m+32>>2]=g;j=+n[m+32+4>>2]+.019999999552965164;n[m+32+4>>2]=j;k=+n[m+32+8>>2]+.019999999552965164;n[m+32+8>>2]=k;if(((b[a+44>>0]|0)!=0?(f[c+236>>2]|0)==2:0)?(f[c+204>>2]&3|0)==0:0){d=f[c+192>>2]|0;Yb[f[(f[d>>2]|0)+8>>2]&127](d,c+68|0,m+16|0,m);e=+n[m+16>>2]+-.019999999552965164;n[m+16>>2]=e;i=+n[m+16+4>>2]+-.019999999552965164;n[m+16+4>>2]=i;j=+n[m+16+8>>2]+-.019999999552965164;n[m+16+8>>2]=j;g=+n[m>>2]+.019999999552965164;n[m>>2]=g;k=+n[m+4>>2]+.019999999552965164;n[m+4>>2]=k;l=+n[m+8>>2]+.019999999552965164;n[m+8>>2]=l;h=+n[m+48>>2];if(e<h)n[m+48>>2]=e;else e=h;h=+n[m+48+4>>2];if(i<h){n[m+48+4>>2]=i;h=i}i=+n[m+48+8>>2];if(j<i){n[m+48+8>>2]=j;i=j}j=+n[m+16+12>>2];if(j<+n[m+48+12>>2])n[m+48+12>>2]=j;j=+n[m+32>>2];if(j<g)n[m+32>>2]=g;else g=j;j=+n[m+32+4>>2];if(j<k){n[m+32+4>>2]=k;j=k}k=+n[m+32+8>>2];if(k<l){n[m+32+8>>2]=l;k=l}l=+n[m+12>>2];if(+n[m+32+12>>2]<l)n[m+32+12>>2]=l}d=f[a+68>>2]|0;if((f[c+204>>2]&1|0)==0?(g=g-e,j=j-h,l=k-i,!(g*g+j*j+l*l<999999995904.0)):0){if((f[c+216>>2]&-2|0)!=4)f[c+216>>2]=5;if(!(b[15175]|0)){u=m;return}d=f[a+72>>2]|0;if(!d){u=m;return}b[15175]=0;Rb[f[(f[d>>2]|0)+36>>2]&127](d,15176);c=f[a+72>>2]|0;Rb[f[(f[c>>2]|0)+36>>2]&127](c,15225);c=f[a+72>>2]|0;Rb[f[(f[c>>2]|0)+36>>2]&127](c,15293);a=f[a+72>>2]|0;Rb[f[(f[a>>2]|0)+36>>2]&127](a,15358);u=m;return}ac[f[(f[d>>2]|0)+16>>2]&31](d,f[c+188>>2]|0,m+48|0,m+32|0,f[a+24>>2]|0);u=m;return}function yf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0.0,j=0,k=0,l=0.0;f[6175]=(f[6175]|0)+1;if(!(f[a+4>>2]&2))i=.019999999552965164;else{j=f[c+192>>2]|0;h=+sb[f[(f[j>>2]|0)+20>>2]&1](j,.019999999552965164);j=f[d+192>>2]|0;i=+sb[f[(f[j>>2]|0)+20>>2]&1](j,.019999999552965164);i=h<i?h:i}l=+n[c+184>>2];h=+n[d+184>>2];h=l<h?l:h;e=f[a+68>>2]|0;g=f[e+8>>2]|0;if(!g){if(f[a+4>>2]&4|0){a=0;return a|0}f[6472]=(f[6472]|0)+1;e=sc(791)|0;if(!e)j=0;else{f[(e+4+15&-16)+-4>>2]=e;j=e+4+15&-16}}else{j=f[e+12>>2]|0;f[e+12>>2]=f[j>>2];f[e+8>>2]=g+-1}f[j>>2]=1025;f[j+116>>2]=0;b[j+120>>0]=0;e=j+124|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;f[e+24>>2]=0;f[e+28>>2]=0;f[j+300>>2]=0;b[j+304>>0]=0;e=j+308|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;f[e+24>>2]=0;f[e+28>>2]=0;f[j+484>>2]=0;b[j+488>>0]=0;e=j+492|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;f[e+24>>2]=0;f[e+28>>2]=0;f[j+668>>2]=0;b[j+672>>0]=0;e=j+676|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;f[e+24>>2]=0;f[e+28>>2]=0;f[j+740>>2]=c;f[j+744>>2]=d;f[j+748>>2]=0;n[j+752>>2]=i;n[j+756>>2]=h;d=j;e=f[a+12>>2]|0;f[j+768>>2]=e;if((e|0)==(f[a+16>>2]|0)?(k=e|0?e<<1:1,(e|0)<(k|0)):0){if(!k)c=0;else{f[6472]=(f[6472]|0)+1;e=sc((k<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c=e;e=f[a+12>>2]|0}if((e|0)>0){g=0;do{f[c+(g<<2)>>2]=f[(f[a+20>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[a+20>>2]|0;if(g){if(b[a+24>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[a+12>>2]|0}f[a+20>>2]=0}b[a+24>>0]=1;f[a+20>>2]=c;f[a+16>>2]=k}f[(f[a+20>>2]|0)+(e<<2)>>2]=d;f[a+12>>2]=e+1;a=j;return a|0}function zf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;h=xs(460)|0;_d(h,a,c,d);f[h>>2]=4016;b[h+340>>0]=1;f[h+336>>2]=0;f[h+328>>2]=0;f[h+332>>2]=0;n[h+352>>2]=1.2000000476837158;n[h+356>>2]=0.0;n[h+360>>2]=0.0;n[h+364>>2]=1.0e3;f[h+368>>2]=0;f[h+368+4>>2]=0;f[h+368+8>>2]=0;f[h+368+12>>2]=0;f[h+368+16>>2]=0;f[h+368+20>>2]=0;f[h+368+24>>2]=0;f[h+396>>2]=-1054867456;f[h+400>>2]=0;n[h+404>>2]=0.0;b[h+424>>0]=1;f[h+420>>2]=0;f[h+412>>2]=0;f[h+416>>2]=0;f[h+452>>2]=g;b[h+456>>0]=0;if(!g){f[6472]=(f[6472]|0)+1;e=sc(59)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}n[e+12>>2]=1.0;f[e+8>>2]=0;f[e+4>>2]=5;f[e>>2]=3140;b[e+36>>0]=1;f[e+32>>2]=0;f[e+24>>2]=0;f[e+28>>2]=0;b[e+16>>0]=1;f[h+452>>2]=e;b[h+456>>0]=1}f[h+344>>2]=4302;b[h+348>>0]=1;b[h+349>>0]=0;b[h+350>>0]=0;f[h+384>>2]=c;f[h+388>>2]=a;xi(h+408|0);g=f[h+412>>2]|0;if((g|0)>0)d=0;else{c=h+428|0;n[c>>2]=.25;c=h+432|0;f[c>>2]=0;c=h+436|0;f[c>>2]=0;c=h+444|0;f[c>>2]=1;c=h+448|0;f[c>>2]=1;n[h+352>>2]=1.2000000476837158;n[h+356>>2]=0.0;n[h+360>>2]=0.0;c=h+392|0;f[c>>2]=0;f[h+368>>2]=0;f[h+368+4>>2]=0;f[h+368+8>>2]=0;f[h+368+12>>2]=0;f[h+396>>2]=-1054867456;f[h+400>>2]=0;n[h+404>>2]=0.0;xi(h+408|0);return h|0}do{c=(f[h+420>>2]|0)+(d<<2)|0;e=f[c>>2]|0;f[c>>2]=0;if(e|0)do{c=e;e=f[e+280>>2]|0;cI(c)}while((e|0)!=0);d=d+1|0}while((d|0)!=(g|0));c=h+428|0;n[c>>2]=.25;c=h+432|0;f[c>>2]=0;c=h+436|0;f[c>>2]=0;c=h+444|0;f[c>>2]=1;c=h+448|0;f[c>>2]=1;n[h+352>>2]=1.2000000476837158;n[h+356>>2]=0.0;n[h+360>>2]=0.0;c=h+392|0;f[c>>2]=0;f[h+368>>2]=0;f[h+368+4>>2]=0;f[h+368+8>>2]=0;f[h+368+12>>2]=0;f[h+396>>2]=-1054867456;f[h+400>>2]=0;n[h+404>>2]=0.0;xi(h+408|0);return h|0}function Af(a,b,c){a=a|0;b=b|0;c=c|0;gi(a,b,c)|0;f[b+52>>2]=f[a+48>>2];f[b+56>>2]=f[a+52>>2];f[b+60>>2]=f[a+56>>2];f[b+64>>2]=f[a+60>>2];f[b+68>>2]=f[a+64>>2];f[b+72>>2]=f[a+68>>2];f[b+76>>2]=f[a+72>>2];f[b+80>>2]=f[a+76>>2];f[b+84>>2]=f[a+80>>2];f[b+88>>2]=f[a+84>>2];f[b+92>>2]=f[a+88>>2];f[b+96>>2]=f[a+92>>2];f[b+100>>2]=f[a+96>>2];f[b+104>>2]=f[a+100>>2];f[b+108>>2]=f[a+104>>2];f[b+112>>2]=f[a+108>>2];f[b+116>>2]=f[a+112>>2];f[b+120>>2]=f[a+116>>2];f[b+124>>2]=f[a+120>>2];f[b+128>>2]=f[a+124>>2];f[b+132>>2]=f[a+128>>2];f[b+136>>2]=f[a+132>>2];f[b+140>>2]=f[a+136>>2];f[b+144>>2]=f[a+140>>2];f[b+148>>2]=f[a+144>>2];f[b+152>>2]=f[a+148>>2];f[b+156>>2]=f[a+152>>2];f[b+160>>2]=f[a+156>>2];f[b+164>>2]=f[a+160>>2];f[b+168>>2]=f[a+164>>2];f[b+172>>2]=f[a+168>>2];f[b+176>>2]=f[a+172>>2];f[b+228>>2]=f[a+868>>2];f[b+212>>2]=f[a+872>>2];f[b+196>>2]=f[a+680>>2];f[b+180>>2]=f[a+696>>2];f[b+232>>2]=f[a+932>>2];f[b+216>>2]=f[a+936>>2];f[b+200>>2]=f[a+684>>2];f[b+184>>2]=f[a+700>>2];f[b+236>>2]=f[a+996>>2];f[b+220>>2]=f[a+1e3>>2];f[b+204>>2]=f[a+688>>2];f[b+188>>2]=f[a+704>>2];f[b+244>>2]=h[a+1300>>0];f[b+248>>2]=h[a+1301>>0];f[b+276>>2]=f[a+1316>>2];f[b+324>>2]=f[a+1364>>2];f[b+252>>2]=h[a+1309>>0];f[b+300>>2]=f[a+1340>>2];f[b+280>>2]=f[a+1320>>2];f[b+328>>2]=f[a+1368>>2];f[b+256>>2]=h[a+1310>>0];f[b+304>>2]=f[a+1344>>2];f[b+284>>2]=f[a+1324>>2];f[b+332>>2]=f[a+1372>>2];f[b+260>>2]=h[a+1311>>0];f[b+308>>2]=f[a+1348>>2];f[b+288>>2]=f[a+1328>>2];f[b+336>>2]=f[a+1376>>2];f[b+264>>2]=h[a+1312>>0];f[b+312>>2]=f[a+1352>>2];f[b+292>>2]=f[a+1332>>2];f[b+340>>2]=f[a+1380>>2];f[b+268>>2]=h[a+1313>>0];f[b+316>>2]=f[a+1356>>2];f[b+296>>2]=f[a+1336>>2];f[b+344>>2]=f[a+1384>>2];f[b+272>>2]=h[a+1314>>0];f[b+320>>2]=f[a+1360>>2];return 12711}function Bf(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=f[a+4>>2]|0;if((i|0)==(f[a+8>>2]|0)?(h=i|0?i<<1:1,(i|0)<(h|0)):0){if(!h){d=0;g=i}else{f[6472]=(f[6472]|0)+1;d=sc((h*244|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}g=f[a+4>>2]|0}if((g|0)>0){e=0;do{k=d+(e*244|0)|0;j=f[a+12>>2]|0;l=j+(e*244|0)|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];k=j+(e*244|0)+16|0;l=d+(e*244|0)+16|0;f[l>>2]=f[k>>2];f[l+4>>2]=f[k+4>>2];f[l+8>>2]=f[k+8>>2];f[l+12>>2]=f[k+12>>2];l=j+(e*244|0)+32|0;k=d+(e*244|0)+32|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];k=d+(e*244|0)+48|0;l=j+(e*244|0)+48|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];ki(d+(e*244|0)+64|0,j+(e*244|0)+64|0,180)|0;e=e+1|0}while((e|0)!=(g|0))}e=f[a+12>>2]|0;if(e|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=d;f[a+8>>2]=h;d=f[a+4>>2]|0}else d=i;f[a+4>>2]=d+1;l=f[a+12>>2]|0;f[l+(i*244|0)>>2]=f[c>>2];f[l+(i*244|0)+4>>2]=f[c+4>>2];f[l+(i*244|0)+8>>2]=f[c+8>>2];f[l+(i*244|0)+12>>2]=f[c+12>>2];f[l+(i*244|0)+16>>2]=f[c+16>>2];f[l+(i*244|0)+16+4>>2]=f[c+16+4>>2];f[l+(i*244|0)+16+8>>2]=f[c+16+8>>2];f[l+(i*244|0)+16+12>>2]=f[c+16+12>>2];f[l+(i*244|0)+32>>2]=f[c+32>>2];f[l+(i*244|0)+32+4>>2]=f[c+32+4>>2];f[l+(i*244|0)+32+8>>2]=f[c+32+8>>2];f[l+(i*244|0)+32+12>>2]=f[c+32+12>>2];f[l+(i*244|0)+48>>2]=f[c+48>>2];f[l+(i*244|0)+48+4>>2]=f[c+48+4>>2];f[l+(i*244|0)+48+8>>2]=f[c+48+8>>2];f[l+(i*244|0)+48+12>>2]=f[c+48+12>>2];ki(l+(i*244|0)+64|0,c+64|0,180)|0;return (f[a+12>>2]|0)+(i*244|0)|0}function Cf(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,g=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;h=u;u=u+32|0;k=+n[a+56>>2];p=+n[a+72>>2]-k;j=+n[a+60>>2];m=+n[a+76>>2]-j;i=+n[a+64>>2];q=+n[a+80>>2]-i;l=+n[a+88>>2]-k;o=+n[a+92>>2]-j;e=+n[a+96>>2]-i;g=1.0/+L(+((p*o-m*l)*(p*o-m*l)+((m*e-q*o)*(m*e-q*o)+(q*l-p*e)*(q*l-p*e))));d=g*(m*e-q*o);e=g*(q*l-p*e);g=(p*o-m*l)*g;i=g*+n[b+8>>2]+(+n[b>>2]*d+ +n[b+4>>2]*e)-(d*k+e*j+g*i);if(!(i>=-c)|!(i<=c)){b=0;u=h;return b|0}Yb[f[(f[a>>2]|0)+104>>2]&127](a,0,h+16|0,h);k=+n[h+16>>2];q=+n[h>>2]-k;m=+n[h+16+4>>2];l=+n[h+4>>2]-m;j=+n[h+16+8>>2];p=+n[h+8>>2]-j;o=1.0/+L(+((e*q-d*l)*(e*q-d*l)+((g*l-e*p)*(g*l-e*p)+(d*p-g*q)*(d*p-g*q))));if((e*q-d*l)*o*+n[b+8>>2]+(+n[b>>2]*o*(g*l-e*p)+ +n[b+4>>2]*o*(d*p-g*q))-(j*(e*q-d*l)*o+(k*o*(g*l-e*p)+m*o*(d*p-g*q)))<-c){b=0;u=h;return b|0}Yb[f[(f[a>>2]|0)+104>>2]&127](a,1,h+16|0,h);k=+n[h+16>>2];q=+n[h>>2]-k;m=+n[h+16+4>>2];l=+n[h+4>>2]-m;j=+n[h+16+8>>2];p=+n[h+8>>2]-j;o=1.0/+L(+((e*q-d*l)*(e*q-d*l)+((g*l-e*p)*(g*l-e*p)+(d*p-g*q)*(d*p-g*q))));if((e*q-d*l)*o*+n[b+8>>2]+(+n[b>>2]*o*(g*l-e*p)+ +n[b+4>>2]*o*(d*p-g*q))-(j*(e*q-d*l)*o+(k*o*(g*l-e*p)+m*o*(d*p-g*q)))<-c){b=0;u=h;return b|0}Yb[f[(f[a>>2]|0)+104>>2]&127](a,2,h+16|0,h);k=+n[h+16>>2];q=+n[h>>2]-k;m=+n[h+16+4>>2];l=+n[h+4>>2]-m;j=+n[h+16+8>>2];p=+n[h+8>>2]-j;o=1.0/+L(+((e*q-d*l)*(e*q-d*l)+((g*l-e*p)*(g*l-e*p)+(d*p-g*q)*(d*p-g*q))));if((e*q-d*l)*o*+n[b+8>>2]+(+n[b>>2]*o*(g*l-e*p)+ +n[b+4>>2]*o*(d*p-g*q))-(j*(e*q-d*l)*o+(k*o*(g*l-e*p)+m*o*(d*p-g*q)))<-c){b=0;u=h;return b|0}b=1;u=h;return b|0}function Df(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,i=0;gi(a,b,c)|0;f[b+52>>2]=f[a+552>>2];f[b+56>>2]=f[a+556>>2];f[b+60>>2]=f[a+560>>2];f[b+64>>2]=f[a+564>>2];f[b+68>>2]=f[a+568>>2];f[b+72>>2]=f[a+572>>2];f[b+76>>2]=f[a+576>>2];f[b+80>>2]=f[a+580>>2];f[b+84>>2]=f[a+584>>2];f[b+88>>2]=f[a+588>>2];f[b+92>>2]=f[a+592>>2];f[b+96>>2]=f[a+596>>2];f[b+100>>2]=f[a+600>>2];f[b+104>>2]=f[a+604>>2];f[b+108>>2]=f[a+608>>2];f[b+112>>2]=f[a+612>>2];f[b+116>>2]=f[a+616>>2];f[b+120>>2]=f[a+620>>2];f[b+124>>2]=f[a+624>>2];f[b+128>>2]=f[a+628>>2];f[b+132>>2]=f[a+632>>2];f[b+136>>2]=f[a+636>>2];f[b+140>>2]=f[a+640>>2];f[b+144>>2]=f[a+644>>2];f[b+148>>2]=f[a+648>>2];f[b+152>>2]=f[a+652>>2];f[b+156>>2]=f[a+656>>2];f[b+160>>2]=f[a+660>>2];f[b+164>>2]=f[a+664>>2];f[b+168>>2]=f[a+668>>2];f[b+172>>2]=f[a+672>>2];f[b+176>>2]=f[a+676>>2];f[b+184>>2]=h[a+736>>0];f[b+188>>2]=h[a+737>>0];f[b+196>>2]=f[a+684>>2];f[b+192>>2]=f[a+680>>2];f[b+180>>2]=h[a+740>>0];e=+n[a+688>>2];g=+n[a+692>>2];d=+lh(e-g,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;n[b+200>>2]=d;d=+lh(e+g,6.2831854820251465);if(d<-3.1415927410125732){g=d+6.2831854820251465;c=b+204|0;n[c>>2]=g;c=a+696|0;c=f[c>>2]|0;i=b+208|0;f[i>>2]=c;i=a+700|0;i=f[i>>2]|0;c=b+212|0;f[c>>2]=i;a=a+704|0;a=f[a>>2]|0;b=b+216|0;f[b>>2]=a;return 12957}if(!(d>3.1415927410125732)){g=d;i=b+204|0;n[i>>2]=g;i=a+696|0;i=f[i>>2]|0;c=b+208|0;f[c>>2]=i;c=a+700|0;c=f[c>>2]|0;i=b+212|0;f[i>>2]=c;a=a+704|0;a=f[a>>2]|0;i=b+216|0;f[i>>2]=a;return 12957}g=d+-6.2831854820251465;i=b+204|0;n[i>>2]=g;i=a+696|0;i=f[i>>2]|0;c=b+208|0;f[c>>2]=i;c=a+700|0;c=f[c>>2]|0;i=b+212|0;f[i>>2]=c;a=a+704|0;a=f[a>>2]|0;i=b+216|0;f[i>>2]=a;return 12957}function Ef(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;j=u;u=u+64|0;l=+n[a+20>>2];t=+n[a+40>>2];o=+n[a+24>>2];r=+n[a+36>>2];s=+n[a+32>>2];k=+n[a+16>>2];i=+n[a>>2];h=+n[a+4>>2];p=+n[a+8>>2];g=1.0/((l*t-o*r)*i+h*(o*s-t*k)+(r*k-l*s)*p);z=+n[b>>2];y=+n[b+4>>2];A=+n[b+8>>2];x=+n[b+16>>2];w=+n[b+20>>2];v=+n[b+24>>2];q=+n[b+32>>2];m=+n[b+36>>2];e=+n[b+40>>2];n[j+16>>2]=A*(r*k-l*s)*g+(z*(l*t-o*r)*g+y*(o*s-t*k)*g);n[j+16+4>>2]=A*(s*h-r*i)*g+(z*(r*p-t*h)*g+y*(t*i-s*p)*g);n[j+16+8>>2]=A*(l*i-k*h)*g+(z*(o*h-l*p)*g+y*(k*p-o*i)*g);n[j+16+12>>2]=0.0;n[j+16+16>>2]=(l*t-o*r)*g*x+(o*s-t*k)*g*w+(r*k-l*s)*g*v;n[j+16+20>>2]=(r*p-t*h)*g*x+(t*i-s*p)*g*w+(s*h-r*i)*g*v;n[j+16+24>>2]=(o*h-l*p)*g*x+(k*p-o*i)*g*w+(l*i-k*h)*g*v;n[j+16+28>>2]=0.0;n[j+16+32>>2]=(l*t-o*r)*g*q+(o*s-t*k)*g*m+(r*k-l*s)*g*e;n[j+16+36>>2]=(r*p-t*h)*g*q+(t*i-s*p)*g*m+(s*h-r*i)*g*e;n[j+16+40>>2]=(o*h-l*p)*g*q+(k*p-o*i)*g*m+(l*i-k*h)*g*e;n[j+16+44>>2]=0.0;mh(j+16|0,j);e=+n[j>>2];g=+n[j+4>>2];h=+n[j+8>>2];k=+n[j+12>>2];i=1.0/+L(+(e*e+g*g+h*h+k*k));n[j>>2]=e*i;n[j+4>>2]=g*i;n[j+8>>2]=h*i;n[j+12>>2]=k*i;k=k*i<-1.0?-1.0:k*i;k=+Q(+(k>1.0?1.0:k))*2.0;n[d>>2]=k;n[c>>2]=e*i;n[c+4>>2]=g*i;n[c+8>>2]=h*i;n[c+12>>2]=0.0;if(e*i*e*i+g*i*g*i+h*i*h*i<1.4210854715202004e-14){f[c>>2]=1065353216;f[c+4>>2]=0;f[c+8>>2]=0;n[c+12>>2]=0.0;u=j;return}else{A=1.0/+L(+(e*i*e*i+g*i*g*i+h*i*h*i));n[c>>2]=e*i*A;n[c+4>>2]=A*g*i;n[c+8>>2]=A*h*i;u=j;return}}function Ff(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f[6201]=(f[6201]|0)+1;l=(f[b+12>>2]|0)>(f[c+12>>2]|0);n=l?c:b;h=f[n+12>>2]|0;l=l?b:c;e=f[l+12>>2]|0;i=((e<<16|h)+~((e<<16|h)<<15)>>10^(e<<16|h)+~((e<<16|h)<<15))*9|0;i=((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(f[a+12>>2]|0)+-1;b=f[(f[a+44>>2]|0)+(i<<2)>>2]|0;if((b|0)==-1){a=0;return a|0}g=f[a+16>>2]|0;c=b;while(1){if((f[(f[g+(c<<4)>>2]|0)+12>>2]|0)==(h|0)?(f[(f[g+(c<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;b=f[(f[a+64>>2]|0)+(c<<2)>>2]|0;if((b|0)==-1){b=0;j=18;break}else c=b}if((j|0)==18)return b|0;b=g+(c<<4)|0;if(!b){a=0;return a|0}Vb[f[(f[a>>2]|0)+32>>2]&127](a,b,d);o=f[g+(c<<4)+12>>2]|0;m=b-(f[a+16>>2]|0)>>4;b=(f[a+44>>2]|0)+(i<<2)|0;c=f[b>>2]|0;h=f[a+64>>2]|0;if((c|0)!=(m|0)){while(1){g=h+(c<<2)|0;e=f[g>>2]|0;if((e|0)==(m|0))break;else c=e}b=(c|0)==-1?b:g}f[b>>2]=f[h+(m<<2)>>2];k=(f[a+8>>2]|0)+-1|0;b=f[a+72>>2]|0;if(b|0)Gb[f[(f[b>>2]|0)+12>>2]&31](b,n,l,d)|0;if((k|0)==(m|0)){f[a+8>>2]=(f[a+8>>2]|0)+-1;a=o;return a|0}j=f[a+16>>2]|0;i=f[(f[j+(k<<4)+4>>2]|0)+12>>2]<<16|f[(f[j+(k<<4)>>2]|0)+12>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(f[a+12>>2]|0)+-1;b=(f[a+44>>2]|0)+(i<<2)|0;c=f[b>>2]|0;h=f[a+64>>2]|0;if((c|0)!=(k|0)){while(1){g=h+(c<<2)|0;e=f[g>>2]|0;if((e|0)==(k|0))break;else c=e}b=(c|0)==-1?b:g}f[b>>2]=f[h+(k<<2)>>2];f[j+(m<<4)>>2]=f[j+(k<<4)>>2];f[j+(m<<4)+4>>2]=f[j+(k<<4)+4>>2];f[j+(m<<4)+8>>2]=f[j+(k<<4)+8>>2];f[j+(m<<4)+12>>2]=f[j+(k<<4)+12>>2];d=(f[a+44>>2]|0)+(i<<2)|0;f[(f[a+64>>2]|0)+(m<<2)>>2]=f[d>>2];f[d>>2]=m;f[a+8>>2]=(f[a+8>>2]|0)+-1;a=o;return a|0}function Gf(a,b,c){a=a|0;b=+b;c=+c;var d=0.0,e=0,g=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0.0;v=f[a+832>>2]|0;if((v|0)<=0)return;q=f[a+840>>2]|0;a=0;do{u=f[q+(a*56|0)>>2]|0;i=f[q+(a*56|0)+4>>2]|0;y=f[i+8>>2]|0;x=f[i+12>>2]|0;w=f[i+16>>2]|0;e=q+(a*56|0)+8|0;s=+n[e>>2];g=q+(a*56|0)+12|0;r=+n[g>>2];h=q+(a*56|0)+16|0;p=+n[h>>2];b=+n[y+8>>2]*s+ +n[x+8>>2]*r+ +n[w+8>>2]*p;c=+n[y+12>>2]*s+ +n[x+12>>2]*r+ +n[w+12>>2]*p;d=+n[y+16>>2]*s+ +n[x+16>>2]*r+ +n[w+16>>2]*p;j=+n[u+8>>2];k=+n[u+12>>2];l=+n[u+16>>2];m=j-+n[u+24>>2]-(b-(s*+n[y+24>>2]+r*+n[x+24>>2]+p*+n[w+24>>2]));o=k-+n[u+28>>2]-(c-(s*+n[y+28>>2]+r*+n[x+28>>2]+p*+n[w+28>>2]));p=l-+n[u+32>>2]-(d-(s*+n[y+32>>2]+r*+n[x+32>>2]+p*+n[w+32>>2]));r=+n[q+(a*56|0)+24>>2];s=+n[q+(a*56|0)+28>>2];t=+n[q+(a*56|0)+32>>2];if(m*r+o*s+p*t<0.0){d=+n[q+(a*56|0)+40>>2]-(j*r+k*s+l*t-(b*r+c*s+d*t));b=r*d+0.0;c=s*d+0.0;d=t*d+0.0}else{b=0.0;c=0.0;d=0.0}z=+n[q+(a*56|0)+44>>2];b=b-z*(m-r*(m*r+o*s+p*t));c=c-z*(o-s*(m*r+o*s+p*t));s=d-z*(p-t*(m*r+o*s+p*t));t=+n[q+(a*56|0)+48>>2];n[u+8>>2]=j+t*b;n[u+12>>2]=k+t*c;n[u+16>>2]=t*s+l;y=q+(a*56|0)+52|0;t=+n[y>>2]*+n[e>>2];x=f[i+8>>2]|0;n[x+8>>2]=+n[x+8>>2]-b*t;n[x+12>>2]=+n[x+12>>2]-c*t;n[x+16>>2]=+n[x+16>>2]-s*t;t=+n[y>>2]*+n[g>>2];x=f[i+12>>2]|0;n[x+8>>2]=+n[x+8>>2]-b*t;n[x+12>>2]=+n[x+12>>2]-c*t;n[x+16>>2]=+n[x+16>>2]-s*t;t=+n[y>>2]*+n[h>>2];y=f[i+16>>2]|0;n[y+8>>2]=+n[y+8>>2]-b*t;n[y+12>>2]=+n[y+12>>2]-c*t;n[y+16>>2]=+n[y+16>>2]-s*t;a=a+1|0}while((a|0)!=(v|0));return}function Hf(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;i=e+36|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(i|0));f[g>>2]=a;f[g+4>>2]=c;q=+n[d>>2];z=+n[b>>2];r=+n[d+16>>2];A=+n[b+16>>2];s=+n[d+32>>2];B=+n[b+32>>2];C=+n[b+4>>2];t=+n[b+20>>2];D=+n[b+36>>2];u=+n[b+8>>2];v=+n[b+24>>2];m=+n[b+40>>2];w=+n[d+4>>2];x=+n[d+20>>2];y=+n[d+36>>2];E=+n[d+8>>2];k=+n[d+24>>2];p=+n[d+40>>2];n[g+8>>2]=q*z+r*A+s*B;n[g+12>>2]=q*C+r*t+s*D;n[g+16>>2]=q*u+r*v+s*m;n[g+20>>2]=0.0;n[g+24>>2]=z*w+A*x+B*y;n[g+28>>2]=C*w+t*x+D*y;n[g+32>>2]=u*w+v*x+m*y;n[g+36>>2]=0.0;n[g+40>>2]=z*E+A*k+B*p;n[g+44>>2]=C*E+t*k+D*p;n[g+48>>2]=u*E+v*k+m*p;n[g+52>>2]=0.0;p=+n[d+48>>2]-+n[b+48>>2];m=+n[d+52>>2]-+n[b+52>>2];k=+n[d+56>>2]-+n[b+56>>2];v=+n[b>>2];E=+n[d>>2];u=+n[b+16>>2];D=+n[d+16>>2];t=+n[b+32>>2];C=+n[d+32>>2];B=+n[d+4>>2];A=+n[d+20>>2];z=+n[d+36>>2];y=+n[d+8>>2];x=+n[d+24>>2];w=+n[d+40>>2];s=+n[b+4>>2];r=+n[b+20>>2];q=+n[b+36>>2];o=+n[b+8>>2];l=+n[b+24>>2];j=+n[b+40>>2];n[g+56>>2]=v*E+u*D+t*C;n[g+60>>2]=v*B+u*A+t*z;n[g+64>>2]=v*y+u*x+t*w;n[g+68>>2]=0.0;n[g+72>>2]=E*s+D*r+C*q;n[g+76>>2]=B*s+A*r+z*q;n[g+80>>2]=y*s+x*r+w*q;n[g+84>>2]=0.0;n[g+88>>2]=E*o+D*l+C*j;n[g+92>>2]=B*o+A*l+z*j;n[g+96>>2]=y*o+x*l+w*j;n[g+100>>2]=0.0;n[g+104>>2]=p*v+m*u+k*t;n[g+108>>2]=p*s+m*r+k*q;n[g+112>>2]=p*o+m*l+k*j;n[g+116>>2]=0.0;f[g+120>>2]=h?81:80;f[g+124>>2]=h?0:0;return}function If(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=f[a+12>>2]|0;l=f[a+36>>2]|0;if((l|0)>=(k|0))return;if((f[a+40>>2]|0)<(k|0)){if(!k){c=0;e=l}else{f[6472]=(f[6472]|0)+1;c=sc((k<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=f[a+36>>2]|0}g=f[a+44>>2]|0;if((e|0)<=0)if(!g)d=a+48|0;else j=12;else{d=0;do{f[c+(d<<2)>>2]=f[g+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0));j=12}if((j|0)==12)if(!(b[a+48>>0]|0))d=a+48|0;else{f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);d=a+48|0}b[d>>0]=1;f[a+44>>2]=c;f[a+40>>2]=k;i=a+44|0}else{i=a+44|0;c=f[a+44>>2]|0}bl(c+(l<<2)|0,0,(k<<2)-(l<<2)|0)|0;f[a+36>>2]=k;h=f[a+56>>2]|0;if((h|0)<(k|0)){if((f[a+60>>2]|0)<(k|0)){if(!k){c=0;e=h}else{f[6472]=(f[6472]|0)+1;c=sc((k<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=f[a+56>>2]|0}g=f[a+64>>2]|0;if((e|0)<=0)if(!g)d=a+68|0;else j=26;else{d=0;do{f[c+(d<<2)>>2]=f[g+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0));j=26}if((j|0)==26)if(!(b[a+68>>0]|0))d=a+68|0;else{f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);d=a+68|0}b[d>>0]=1;f[a+64>>2]=c;f[a+60>>2]=k}else c=f[a+64>>2]|0;bl(c+(h<<2)|0,0,(k<<2)-(h<<2)|0)|0}f[a+56>>2]=k;if((k|0)>0){bl(f[i>>2]|0,-1,k<<2|0)|0;bl(f[a+64>>2]|0,-1,k<<2|0)|0}if((l|0)<=0)return;g=f[a+16>>2]|0;d=f[i>>2]|0;e=f[a+64>>2]|0;c=0;do{k=f[(f[g+(c<<4)+4>>2]|0)+12>>2]<<16|f[(f[g+(c<<4)>>2]|0)+12>>2];k=(k+~(k<<15)>>10^k+~(k<<15))*9|0;k=d+((((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11))&(f[a+12>>2]|0)+-1)<<2)|0;f[e+(c<<2)>>2]=f[k>>2];f[k>>2]=c;c=c+1|0}while((c|0)!=(l|0));return}function Jf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;d=Db[f[(f[c>>2]|0)+40>>2]&31](c,a)|0;g=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b>>2]=g;if(g|0)Rb[f[(f[c>>2]|0)+48>>2]&127](c,d);f[b+4>>2]=f[a+4>>2];f[b+20>>2]=f[a+72>>2];d=f[a+16>>2]|0;f[b+16>>2]=d;f[b+12>>2]=0;if(!d)return 16564;g=Fb[f[(f[c>>2]|0)+16>>2]&63](c,76,d)|0;d=f[g+8>>2]|0;e=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b+12>>2]=e;if((f[b+16>>2]|0)>0){e=0;while(1){h=f[a+24>>2]|0;f[d+72>>2]=f[h+(e*80|0)+72>>2];h=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[h+(e*80|0)+64>>2]|0)|0;f[d+64>>2]=h;if(!(Db[f[(f[c>>2]|0)+24>>2]&31](c,f[(f[a+24>>2]|0)+(e*80|0)+64>>2]|0)|0)){h=f[(f[c>>2]|0)+16>>2]|0;i=f[(f[a+24>>2]|0)+(e*80|0)+64>>2]|0;i=Bb[f[(f[i>>2]|0)+52>>2]&127](i)|0;i=Fb[h&63](c,i,1)|0;h=f[(f[a+24>>2]|0)+(e*80|0)+64>>2]|0;h=Fb[f[(f[h>>2]|0)+56>>2]&63](h,f[i+8>>2]|0,c)|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,i,h,1346455635,f[(f[a+24>>2]|0)+(e*80|0)+64>>2]|0)}i=f[a+24>>2]|0;f[d+68>>2]=f[i+(e*80|0)+68>>2];f[d>>2]=f[i+(e*80|0)>>2];f[d+4>>2]=f[i+(e*80|0)+4>>2];f[d+8>>2]=f[i+(e*80|0)+8>>2];f[d+12>>2]=f[i+(e*80|0)+12>>2];f[d+16>>2]=f[i+(e*80|0)+16>>2];f[d+20>>2]=f[i+(e*80|0)+20>>2];f[d+24>>2]=f[i+(e*80|0)+24>>2];f[d+28>>2]=f[i+(e*80|0)+28>>2];f[d+32>>2]=f[i+(e*80|0)+32>>2];f[d+36>>2]=f[i+(e*80|0)+36>>2];f[d+40>>2]=f[i+(e*80|0)+40>>2];f[d+44>>2]=f[i+(e*80|0)+44>>2];f[d+48>>2]=f[i+(e*80|0)+48>>2];f[d+52>>2]=f[i+(e*80|0)+52>>2];f[d+56>>2]=f[i+(e*80|0)+56>>2];f[d+60>>2]=f[i+(e*80|0)+60>>2];e=e+1|0;if((e|0)>=(f[b+16>>2]|0)){d=c;break}else d=d+76|0}}else d=c;ac[f[(f[d>>2]|0)+20>>2]&31](c,g,16539,1497453121,f[g+8>>2]|0);return 16564}function Kf(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;if((f[a+8>>2]|0)>=(c|0))return;if((c|0)!=0?(f[6472]=(f[6472]|0)+1,d=sc((c*36|3)+16|0)|0,(d|0)!=0):0){f[(d+4+15&-16)+-4>>2]=d;r=d+4+15&-16}else r=0;n=f[a+4>>2]|0;if((n|0)>0){m=0;do{o=f[a+12>>2]|0;i=r+(m*36|0)+16|0;b[i>>0]=1;j=r+(m*36|0)+12|0;f[j>>2]=0;l=r+(m*36|0)+4|0;f[l>>2]=0;k=r+(m*36|0)+8|0;f[k>>2]=0;p=f[o+(m*36|0)+4>>2]|0;if((p|0)>0){f[6472]=(f[6472]|0)+1;d=sc((p<<2|3)+16|0)|0;if(!d)e=0;else{f[(d+4+15&-16)+-4>>2]=d;e=d+4+15&-16}g=f[l>>2]|0;h=f[j>>2]|0;if((g|0)<=0){if(h|0)q=13}else{d=0;do{f[e+(d<<2)>>2]=f[h+(d<<2)>>2];d=d+1|0}while((d|0)!=(g|0));q=13}if((q|0)==13?(q=0,b[i>>0]|0):0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}b[i>>0]=1;f[j>>2]=e;f[k>>2]=p;bl(e|0,0,p<<2|0)|0;g=f[j>>2]|0;f[l>>2]=p;e=f[o+(m*36|0)+12>>2]|0;d=0;do{f[g+(d<<2)>>2]=f[e+(d<<2)>>2];d=d+1|0}while((d|0)!=(p|0))}else f[l>>2]=p;p=r+(m*36|0)+20|0;o=o+(m*36|0)+20|0;f[p>>2]=f[o>>2];f[p+4>>2]=f[o+4>>2];f[p+8>>2]=f[o+8>>2];f[p+12>>2]=f[o+12>>2];m=m+1|0}while((m|0)!=(n|0));e=f[a+4>>2]|0;if((e|0)>0){d=0;do{h=f[a+12>>2]|0;i=h+(d*36|0)+4|0;j=h+(d*36|0)+12|0;k=f[j>>2]|0;g=h+(d*36|0)+16|0;if(k|0){if(b[g>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0)}f[j>>2]=0}b[g>>0]=1;f[j>>2]=0;f[i>>2]=0;f[h+(d*36|0)+8>>2]=0;d=d+1|0}while((d|0)!=(e|0))}}d=f[a+12>>2]|0;if(d|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=r;f[a+8>>2]=c;return}function Lf(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=f[a+12>>2]|0;l=f[a+32>>2]|0;if((l|0)>=(k|0))return;if((f[a+36>>2]|0)<(k|0)){if(!k){c=0;e=l}else{f[6472]=(f[6472]|0)+1;c=sc((k<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=f[a+32>>2]|0}g=f[a+40>>2]|0;if((e|0)<=0)if(!g)d=a+44|0;else j=12;else{d=0;do{f[c+(d<<2)>>2]=f[g+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0));j=12}if((j|0)==12)if(!(b[a+44>>0]|0))d=a+44|0;else{f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);d=a+44|0}b[d>>0]=1;f[a+40>>2]=c;f[a+36>>2]=k;i=a+40|0}else{i=a+40|0;c=f[a+40>>2]|0}bl(c+(l<<2)|0,0,(k<<2)-(l<<2)|0)|0;f[a+32>>2]=k;h=f[a+52>>2]|0;if((h|0)<(k|0)){if((f[a+56>>2]|0)<(k|0)){if(!k){c=0;e=h}else{f[6472]=(f[6472]|0)+1;c=sc((k<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=f[a+52>>2]|0}g=f[a+60>>2]|0;if((e|0)<=0)if(!g)d=a+64|0;else j=26;else{d=0;do{f[c+(d<<2)>>2]=f[g+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0));j=26}if((j|0)==26)if(!(b[a+64>>0]|0))d=a+64|0;else{f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);d=a+64|0}b[d>>0]=1;f[a+60>>2]=c;f[a+56>>2]=k}else c=f[a+60>>2]|0;bl(c+(h<<2)|0,0,(k<<2)-(h<<2)|0)|0}f[a+52>>2]=k;if((k|0)>0){bl(f[i>>2]|0,-1,k<<2|0)|0;bl(f[a+60>>2]|0,-1,k<<2|0)|0}if((l|0)<=0)return;g=f[a+16>>2]|0;d=f[i>>2]|0;e=f[a+60>>2]|0;c=0;do{k=f[g+(c*12|0)+4>>2]<<16|f[g+(c*12|0)>>2];k=(k+~(k<<15)>>10^k+~(k<<15))*9|0;k=d+((((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11))&(f[a+12>>2]|0)+-1)<<2)|0;f[e+(c<<2)>>2]=f[k>>2];f[k>>2]=c;c=c+1|0}while((c|0)!=(l|0));return}function Mf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0;e=u;u=u+256|0;f[e+32>>2]=5884;j=e+32+36|0;f[j>>2]=f[b>>2];f[j+4>>2]=f[b+4>>2];f[j+8>>2]=f[b+8>>2];f[j+12>>2]=f[b+12>>2];k=e+32+52|0;f[k>>2]=f[c>>2];f[k+4>>2]=f[c+4>>2];f[k+8>>2]=f[c+8>>2];f[k+12>>2]=f[c+12>>2];f[e+32+212>>2]=a;f[e+32+216>>2]=d;f[e+32+68>>2]=1065353216;f[e+32+72>>2]=0;f[e+32+72+4>>2]=0;f[e+32+72+8>>2]=0;f[e+32+72+12>>2]=0;f[e+32+88>>2]=1065353216;f[e+32+92>>2]=0;f[e+32+92+4>>2]=0;f[e+32+92+8>>2]=0;f[e+32+92+12>>2]=0;f[e+32+108>>2]=1065353216;f[e+32+112>>2]=0;f[e+32+116>>2]=f[j>>2];f[e+32+116+4>>2]=f[j+4>>2];f[e+32+116+8>>2]=f[j+8>>2];f[e+32+116+12>>2]=f[j+12>>2];f[e+32+132>>2]=1065353216;f[e+32+136>>2]=0;f[e+32+136+4>>2]=0;f[e+32+136+8>>2]=0;f[e+32+136+12>>2]=0;f[e+32+152>>2]=1065353216;f[e+32+156>>2]=0;f[e+32+156+4>>2]=0;f[e+32+156+8>>2]=0;f[e+32+156+12>>2]=0;f[e+32+172>>2]=1065353216;f[e+32+176>>2]=0;f[e+32+180>>2]=f[c>>2];f[e+32+180+4>>2]=f[c+4>>2];f[e+32+180+8>>2]=f[c+8>>2];f[e+32+180+12>>2]=f[c+12>>2];l=+n[c>>2]-+n[b>>2];i=+n[c+4>>2]-+n[b+4>>2];h=+n[c+8>>2]-+n[b+8>>2];g=1.0/+L(+(l*l+i*i+h*h));p=l*g==0.0?999999984306749440.0:1.0/(l*g);n[e+32+4>>2]=p;o=i*g==0.0?999999984306749440.0:1.0/(i*g);n[e+32+8>>2]=o;m=h*g==0.0?999999984306749440.0:1.0/(h*g);n[e+32+12>>2]=m;f[e+32+20>>2]=p<0.0&1;f[e+32+24>>2]=o<0.0&1;f[e+32+28>>2]=m<0.0&1;n[e+32+32>>2]=l*g*(+n[k>>2]-+n[j>>2])+i*g*(+n[e+32+56>>2]-+n[e+32+40>>2])+h*g*(+n[e+32+60>>2]-+n[e+32+44>>2]);d=f[a+68>>2]|0;a=f[(f[d>>2]|0)+24>>2]|0;f[e+16>>2]=0;f[e+16+4>>2]=0;f[e+16+8>>2]=0;f[e+16+12>>2]=0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;cc[a&7](d,b,c,e+32|0,e+16|0,e);u=e;return}function Nf(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;g=u;u=u+128|0;if(!b){u=g;return}if(f[b+40>>2]|0){Nf(a,f[b+36>>2]|0,c+1|0,d,e);Nf(a,f[b+40>>2]|0,c+1|0,d,e)}if((c|0)<0){u=g;return}k=+n[b>>2];q=+n[b+16>>2];i=+n[b+4>>2];p=+n[b+20>>2];h=+n[b+8>>2];o=+n[b+24>>2];j=(k+q)*.5-(q-k)*.5;l=(i+p)*.5-(p-i)*.5;m=(h+o)*.5-(o-h)*.5;k=(k+q)*.5+(q-k)*.5;i=(i+p)*.5+(p-i)*.5;h=(h+o)*.5+(o-h)*.5;e=(f[b+40>>2]|0)==0?e:d;n[g>>2]=j;n[g+4>>2]=l;n[g+8>>2]=m;n[g+12>>2]=0.0;n[g+16>>2]=k;n[g+20>>2]=l;n[g+24>>2]=m;n[g+28>>2]=0.0;n[g+32>>2]=k;n[g+36>>2]=i;n[g+40>>2]=m;n[g+44>>2]=0.0;n[g+48>>2]=j;n[g+52>>2]=i;n[g+56>>2]=m;n[g+60>>2]=0.0;n[g+64>>2]=j;n[g+68>>2]=l;n[g+72>>2]=h;n[g+76>>2]=0.0;n[g+80>>2]=k;n[g+84>>2]=l;n[g+88>>2]=h;n[g+92>>2]=0.0;n[g+96>>2]=k;n[g+100>>2]=i;n[g+104>>2]=h;n[g+108>>2]=0.0;n[g+112>>2]=j;n[g+116>>2]=i;n[g+120>>2]=h;n[g+124>>2]=0.0;Yb[f[(f[a>>2]|0)+8>>2]&127](a,g,g+16|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+16|0,g+32|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+32|0,g+48|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+48|0,g,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+64|0,g+80|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+80|0,g+96|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+96|0,g+112|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+112|0,g+64|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g,g+64|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+16|0,g+80|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+32|0,g+96|0,e);Yb[f[(f[a>>2]|0)+8>>2]&127](a,g+48|0,g+112|0,e);u=g;return}function Of(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;q=u;u=u+96|0;k=q;l=k+96|0;do{f[k>>2]=0;k=k+4|0}while((k|0)<(l|0));if(!h)o=f[f[a+880>>2]>>2]|0;else o=h;h=f[a+772>>2]|0;if((h|0)==(f[a+776>>2]|0)?(p=h|0?h<<1:1,(h|0)<(p|0)):0){if(!p)m=0;else{f[6472]=(f[6472]|0)+1;h=sc((p*104|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}m=h;h=f[a+772>>2]|0}if((h|0)>0){i=0;do{k=m+(i*104|0)|0;j=(f[a+780>>2]|0)+(i*104|0)|0;l=k+104|0;do{f[k>>2]=f[j>>2];k=k+4|0;j=j+4|0}while((k|0)<(l|0));i=i+1|0}while((i|0)!=(h|0))}h=f[a+780>>2]|0;if(h|0){if(b[a+784>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+780>>2]=0}b[a+784>>0]=1;f[a+780>>2]=m;f[a+776>>2]=p;h=f[a+772>>2]|0}k=f[a+780>>2]|0;f[k+(h*104|0)>>2]=0;f[k+(h*104|0)+4>>2]=o;k=k+(h*104|0)+8|0;j=q;l=k+96|0;do{f[k>>2]=f[j>>2];k=k+4|0;j=j+4|0}while((k|0)<(l|0));p=f[a+772>>2]|0;f[a+772>>2]=p+1;o=f[a+780>>2]|0;j=f[a+720>>2]|0;f[o+(p*104|0)+8>>2]=j+(c*104|0);m=f[a+720>>2]|0;f[o+(p*104|0)+12>>2]=m+(d*104|0);k=f[a+720>>2]|0;f[o+(p*104|0)+16>>2]=k+(e*104|0);l=f[a+720>>2]|0;f[o+(p*104|0)+20>>2]=l+(g*104|0);z=+n[j+(c*104|0)+8>>2];w=+n[j+(c*104|0)+12>>2];A=+n[j+(c*104|0)+16>>2];s=+n[k+(e*104|0)+8>>2]-z;y=+n[k+(e*104|0)+12>>2]-w;v=+n[k+(e*104|0)+16>>2]-A;t=+n[l+(g*104|0)+8>>2]-z;x=+n[l+(g*104|0)+12>>2]-w;r=+n[l+(g*104|0)+16>>2]-A;n[o+(p*104|0)+24>>2]=(+n[m+(d*104|0)+16>>2]-A)*(s*x-y*t)+((+n[m+(d*104|0)+8>>2]-z)*(y*r-v*x)+(+n[m+(d*104|0)+12>>2]-w)*(v*t-s*r));b[a+924>>0]=1;u=q;return}function Pf(a,b,c,d,e,f,g,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;g=+g;h=+h;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;y=+n[e>>2];x=+n[e+16>>2];w=+n[e+32>>2];v=+n[e+4>>2];u=+n[e+20>>2];t=+n[e+36>>2];s=+n[e+8>>2];r=+n[e+24>>2];q=+n[e+40>>2];i=d-((y*0.0+x*-h+w*g)*0.0+(v*0.0+u*-h+t*g)*h+(s*0.0+r*-h+q*g)*-g)+c;o=0.0-((y*0.0+x*-h+w*g)*-h+(v*0.0+u*-h+t*g)*0.0+(s*0.0+r*-h+q*g)*f)+0.0;k=0.0-((y*0.0+x*-h+w*g)*g+(v*0.0+u*-h+t*g)*-f+(s*0.0+r*-h+q*g)*0.0)+0.0;l=0.0-((y*h+x*0.0+w*-f)*0.0+(v*h+u*0.0+t*-f)*h+(s*h+r*0.0+q*-f)*-g)+0.0;m=d-((y*h+x*0.0+w*-f)*-h+(v*h+u*0.0+t*-f)*0.0+(s*h+r*0.0+q*-f)*f)+c;j=0.0-((y*h+x*0.0+w*-f)*g+(v*h+u*0.0+t*-f)*-f+(s*h+r*0.0+q*-f)*0.0)+0.0;p=0.0-((y*-g+x*f+w*0.0)*0.0+(v*-g+u*f+t*0.0)*h+(s*-g+r*f+q*0.0)*-g)+0.0;h=0.0-((y*-g+x*f+w*0.0)*-h+(v*-g+u*f+t*0.0)*0.0+(s*-g+r*f+q*0.0)*f)+0.0;c=d-((y*-g+x*f+w*0.0)*g+(v*-g+u*f+t*0.0)*-f+(s*-g+r*f+q*0.0)*0.0)+c;d=1.0/(k*(h*l-m*p)+(i*(m*c-j*h)+o*(j*p-c*l)));n[a>>2]=(h*l-m*p)*d*0.0+(1.0/b*(m*c-j*h)*d+(j*p-c*l)*d*0.0);n[a+4>>2]=(p*o-h*i)*d*0.0+(1.0/b*(h*k-c*o)*d+(c*i-p*k)*d*0.0);n[a+8>>2]=(m*i-l*o)*d*0.0+(1.0/b*(j*o-m*k)*d+(l*k-j*i)*d*0.0);n[a+12>>2]=0.0;n[a+16>>2]=(h*l-m*p)*d*0.0+((m*c-j*h)*d*0.0+1.0/b*(j*p-c*l)*d);n[a+20>>2]=(p*o-h*i)*d*0.0+((h*k-c*o)*d*0.0+1.0/b*(c*i-p*k)*d);n[a+24>>2]=(m*i-l*o)*d*0.0+((j*o-m*k)*d*0.0+1.0/b*(l*k-j*i)*d);n[a+28>>2]=0.0;n[a+32>>2]=1.0/b*(h*l-m*p)*d+((m*c-j*h)*d*0.0+(j*p-c*l)*d*0.0);n[a+36>>2]=1.0/b*(p*o-h*i)*d+((h*k-c*o)*d*0.0+(c*i-p*k)*d*0.0);n[a+40>>2]=1.0/b*(m*i-l*o)*d+((j*o-m*k)*d*0.0+(l*k-j*i)*d*0.0);n[a+44>>2]=0.0;return}function Qf(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0.0;e=u;u=u+784|0;f[e+712>>2]=1065353216;f[e+712+4>>2]=0;f[e+712+4+4>>2]=0;f[e+712+4+8>>2]=0;f[e+712+4+12>>2]=0;f[e+712+20>>2]=1065353216;f[e+712+24>>2]=0;f[e+712+24+4>>2]=0;f[e+712+24+8>>2]=0;f[e+712+24+12>>2]=0;f[e+712+40>>2]=1065353216;d=e+712+44|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;f[d+16>>2]=0;f[e+536>>2]=3832;f[e+536+168>>2]=0;n[e+536+172>>2]=0.0;f[e+536+164>>2]=f[a+200>>2];d=f[a+196>>2]|0;f[e+480+8>>2]=0;f[e+480+12>>2]=1065353216;f[e+480+16>>2]=1065353216;f[e+480+20>>2]=1065353216;n[e+480+24>>2]=0.0;f[e+480>>2]=6864;f[e+480+4>>2]=8;f[e+480+28>>2]=d;f[e+480+44>>2]=d;f[e+376+8>>2]=0;f[e+376+12>>2]=1065353216;f[e+376+16>>2]=1065353216;f[e+376+20>>2]=1065353216;n[e+376+24>>2]=0.0;n[e+376+44>>2]=.03999999910593033;f[e+376+52>>2]=0;f[e+376>>2]=3860;f[e+376+4>>2]=1;f[e+376+56>>2]=f[c>>2];f[e+376+56+4>>2]=f[c+4>>2];f[e+376+56+8>>2]=f[c+8>>2];f[e+376+56+12>>2]=f[c+12>>2];f[e+376+72>>2]=f[c+16>>2];f[e+376+72+4>>2]=f[c+16+4>>2];f[e+376+72+8>>2]=f[c+16+8>>2];f[e+376+72+12>>2]=f[c+16+12>>2];f[e+376+88>>2]=f[c+32>>2];f[e+376+88+4>>2]=f[c+32+4>>2];f[e+376+88+8>>2]=f[c+32+8>>2];f[e+376+88+12>>2]=f[c+32+12>>2];n[e+16+308>>2]=9.999999747378752e-05;b[e+16+332>>0]=0;f[e>>2]=5156;f[e+4>>2]=e+16;f[e+8>>2]=e+480;f[e+12>>2]=e+376;if(md(e,a+4|0,a+68|0,e+712|0,e+712|0,e+536|0)|0?(g=+n[e+536+164>>2],+n[a+200>>2]>g):0)n[a+200>>2]=g;f[e+376>>2]=7316;d=f[e+376+52>>2]|0;if(!d){u=e;return}Lb[f[f[d>>2]>>2]&511](d);d=f[e+376+52>>2]|0;if(!d){u=e;return}f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);u=e;return}function Rf(a,c,e,g,h,i,j,k,l){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0;n=u;u=u+48|0;f[6472]=(f[6472]|0)+1;g=sc(83)|0;if(!g)m=0;else{f[(g+4+15&-16)+-4>>2]=g;m=g+4+15&-16}f[m>>2]=h;d[m+4>>1]=i;d[m+6>>1]=j;h=m+16|0;f[h>>2]=f[c>>2];f[h+4>>2]=f[c+4>>2];f[h+8>>2]=f[c+8>>2];f[h+12>>2]=f[c+12>>2];h=m+32|0;f[h>>2]=f[e>>2];f[h+4>>2]=f[e+4>>2];f[h+8>>2]=f[e+8>>2];f[h+12>>2]=f[e+12>>2];f[m+8>>2]=0;h=m+56|0;f[h>>2]=0;i=m+52|0;f[i>>2]=0;f[n+16>>2]=f[c>>2];f[n+16+4>>2]=f[c+4>>2];f[n+16+8>>2]=f[c+8>>2];f[n+16+12>>2]=f[c+12>>2];f[n+16+16>>2]=f[e>>2];f[n+16+16+4>>2]=f[e+4>>2];f[n+16+16+8>>2]=f[e+8>>2];f[n+16+16+12>>2]=f[e+12>>2];f[m+60>>2]=f[a+144>>2];g=(f[a+188>>2]|0)+1|0;f[a+188>>2]=g;f[m+12>>2]=g;g=f[a+8>>2]|0;if(!g){f[6472]=(f[6472]|0)+1;g=sc(63)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}k=g;l=k+44|0;do{f[k>>2]=0;k=k+4|0}while((k|0)<(l|0))}else f[a+8>>2]=0;f[g+32>>2]=0;f[g+36>>2]=m;f[g+40>>2]=0;f[g>>2]=f[n+16>>2];f[g+4>>2]=f[n+16+4>>2];f[g+8>>2]=f[n+16+8>>2];f[g+12>>2]=f[n+16+12>>2];f[g+16>>2]=f[n+16+16>>2];f[g+20>>2]=f[n+16+20>>2];f[g+24>>2]=f[n+16+24>>2];f[g+28>>2]=f[n+16+28>>2];ff(a+4|0,f[a+4>>2]|0,g);f[a+16>>2]=(f[a+16>>2]|0)+1;f[m+48>>2]=g;k=a+124+(f[a+144>>2]<<2)|0;f[i>>2]=0;f[h>>2]=f[k>>2];g=f[k>>2]|0;if(g|0)f[g+52>>2]=m;f[k>>2]=m;if(b[a+193>>0]|0){u=n;return m|0}f[n>>2]=9096;f[n+4>>2]=a;f[n+8>>2]=m;jf(f[a+4>>2]|0,n+16|0,n);jf(f[a+64>>2]|0,n+16|0,n);u=n;return m|0}function Sf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0;c=f[a+752>>2]|0;if((c|0)>0){d=f[a+760>>2]|0;b=0;do{e=f[d+(b*44|0)+8>>2]|0;g=f[d+(b*44|0)+12>>2]|0;h=f[d+(b*44|0)+16>>2]|0;k=+n[e+8>>2];m=+n[e+12>>2];i=+n[e+16>>2];j=+n[g+8>>2]-k;o=+n[g+12>>2]-m;l=+n[g+16>>2]-i;k=+n[h+8>>2]-k;m=+n[h+12>>2]-m;i=+n[h+16>>2]-i;i=+L(+((j*m-o*k)*(j*m-o*k)+((o*i-l*m)*(o*i-l*m)+(l*k-j*i)*(l*k-j*i))));n[d+(b*44|0)+36>>2]=i;b=b+1|0}while((b|0)!=(c|0))}c=f[a+712>>2]|0;if((c|0)>0){f[6472]=(f[6472]|0)+1;b=sc((c<<2|3)+16|0)|0;if(!b)d=0;else{f[(b+4+15&-16)+-4>>2]=b;d=b+4+15&-16}bl(d|0,0,c<<2|0)|0;e=f[a+712>>2]|0;if((e|0)>0){c=f[a+720>>2]|0;b=0;do{n[c+(b*104|0)+92>>2]=0.0;b=b+1|0}while((b|0)!=(e|0));h=d;g=d;b=e}else{h=d;g=d;b=e}}else{h=0;g=0;b=c}e=f[a+752>>2]|0;if((e|0)>0){c=f[a+760>>2]|0;d=f[a+720>>2]|0;b=0;do{o=+K(+(+n[c+(b*44|0)+36>>2]));p=f[c+(b*44|0)+8>>2]|0;q=h+(((p-d|0)/104|0)<<2)|0;f[q>>2]=(f[q>>2]|0)+1;n[p+92>>2]=o+ +n[p+92>>2];p=f[c+(b*44|0)+12>>2]|0;q=h+(((p-d|0)/104|0)<<2)|0;f[q>>2]=(f[q>>2]|0)+1;n[p+92>>2]=o+ +n[p+92>>2];p=f[c+(b*44|0)+16>>2]|0;q=h+(((p-d|0)/104|0)<<2)|0;f[q>>2]=(f[q>>2]|0)+1;n[p+92>>2]=o+ +n[p+92>>2];b=b+1|0}while((b|0)!=(e|0));b=f[a+712>>2]|0}if((b|0)>0){c=0;do{d=f[h+(c<<2)>>2]|0;if((d|0)>0){q=(f[a+720>>2]|0)+(c*104|0)+92|0;n[q>>2]=+n[q>>2]/+(d|0)}else n[(f[a+720>>2]|0)+(c*104|0)+92>>2]=0.0;c=c+1|0}while((c|0)!=(b|0));if(!g)return}else if((h|0)==0|(g|0)==0)return;f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);return}function Tf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;j=u;u=u+160|0;h=f[a+12>>2]|0;if(!h){u=j;return}k=(b[a+16>>0]|0)!=0;l=k?d:c;d=k?c:d;m=f[l+4>>2]|0;c=f[d+4>>2]|0;f[g+4>>2]=h;h=f[h+752>>2]|0;f[j+136>>2]=9496;f[j+136+4>>2]=m;f[j+136+8>>2]=c;f[j+136+12>>2]=h;n[j+128>>2]=999999984306749440.0;h=f[l+12>>2]|0;f[j>>2]=f[h>>2];f[j+4>>2]=f[h+4>>2];f[j+8>>2]=f[h+8>>2];f[j+12>>2]=f[h+12>>2];f[j+16>>2]=f[h+16>>2];f[j+16+4>>2]=f[h+16+4>>2];f[j+16+8>>2]=f[h+16+8>>2];f[j+16+12>>2]=f[h+16+12>>2];f[j+32>>2]=f[h+32>>2];f[j+32+4>>2]=f[h+32+4>>2];f[j+32+8>>2]=f[h+32+8>>2];f[j+32+12>>2]=f[h+32+12>>2];f[j+48>>2]=f[h+48>>2];f[j+48+4>>2]=f[h+48+4>>2];f[j+48+8>>2]=f[h+48+8>>2];f[j+48+12>>2]=f[h+48+12>>2];h=f[d+12>>2]|0;f[j+64>>2]=f[h>>2];f[j+64+4>>2]=f[h+4>>2];f[j+64+8>>2]=f[h+8>>2];f[j+64+12>>2]=f[h+12>>2];f[j+80>>2]=f[h+16>>2];f[j+80+4>>2]=f[h+16+4>>2];f[j+80+8>>2]=f[h+16+8>>2];f[j+80+12>>2]=f[h+16+12>>2];f[j+96>>2]=f[h+32>>2];f[j+96+4>>2]=f[h+32+4>>2];f[j+96+8>>2]=f[h+32+8>>2];f[j+96+12>>2]=f[h+32+12>>2];f[j+112>>2]=f[h+48>>2];f[j+112+4>>2]=f[h+48+4>>2];f[j+112+8>>2]=f[h+48+8>>2];f[j+112+12>>2]=f[h+48+12>>2];Vd(j+136|0,j,g,f[e+20>>2]|0,k);do if(b[a+8>>0]|0?(i=f[g+4>>2]|0,f[i+748>>2]|0):0){a=f[i+740>>2]|0;c=f[(f[g+8>>2]|0)+8>>2]|0;if((a|0)==(c|0)){df(i,a+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);break}else{df(i,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,c+4|0);break}}while(0);u=j;return}function Uf(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;c=u;u=u+128|0;G=f[(f[a+8>>2]|0)+24>>2]|0;g=f[G+(b*80|0)+64>>2]|0;e=f[a+12>>2]|0;x=+n[G+(b*80|0)>>2];D=+n[e>>2];w=+n[G+(b*80|0)+16>>2];C=+n[e+4>>2];v=+n[G+(b*80|0)+32>>2];B=+n[e+8>>2];t=+n[G+(b*80|0)+4>>2];s=+n[G+(b*80|0)+20>>2];r=+n[G+(b*80|0)+36>>2];q=+n[G+(b*80|0)+8>>2];o=+n[G+(b*80|0)+24>>2];l=+n[G+(b*80|0)+40>>2];A=+n[e+16>>2];z=+n[e+20>>2];y=+n[e+24>>2];p=+n[e+32>>2];m=+n[e+36>>2];k=+n[e+40>>2];F=+n[G+(b*80|0)+48>>2];E=+n[G+(b*80|0)+52>>2];h=+n[G+(b*80|0)+56>>2];j=+n[e+48>>2]+(D*F+C*E+B*h);i=A*F+z*E+y*h+ +n[e+52>>2];h=p*F+m*E+k*h+ +n[e+56>>2];n[c+56>>2]=x*D+w*C+v*B;n[c+56+4>>2]=D*t+C*s+B*r;n[c+56+8>>2]=D*q+C*o+B*l;n[c+56+12>>2]=0.0;n[c+56+16>>2]=x*A+w*z+v*y;n[c+56+20>>2]=t*A+s*z+r*y;n[c+56+24>>2]=q*A+o*z+l*y;n[c+56+28>>2]=0.0;n[c+56+32>>2]=x*p+w*m+v*k;n[c+56+36>>2]=t*p+s*m+r*k;n[c+56+40>>2]=q*p+o*m+l*k;n[c+56+44>>2]=0.0;n[c+56+48>>2]=j;n[c+56+52>>2]=i;n[c+56+56>>2]=h;n[c+56+60>>2]=0.0;e=f[a+4>>2]|0;f[c+32>>2]=0;f[c+32+4>>2]=g;f[c+32+8>>2]=e;f[c+32+12>>2]=c+56;f[c+32+16>>2]=-1;f[c+32+20>>2]=b;e=f[a+24>>2]|0;n[c+4>>2]=1.0;f[c+8>>2]=0;d[c+12>>1]=1;d[c+14>>1]=-1;f[c+16>>2]=0;f[c>>2]=5988;f[c+20>>2]=e;f[c+24>>2]=b;f[c+4>>2]=f[e+4>>2];f[c+16>>2]=f[e+16>>2];Vc(f[a+16>>2]|0,f[a+20>>2]|0,c+32|0,c);u=c;return}function Vf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0;h=u;u=u+80|0;g=+rb[f[(f[a>>2]|0)+48>>2]&15](a);e=0;do{p=h+64+(e<<2)|0;f[h+64>>2]=0;f[h+64+4>>2]=0;f[h+64+8>>2]=0;f[h+64+12>>2]=0;n[p>>2]=1.0;i=f[(f[a>>2]|0)+64>>2]|0;j=+n[h+64>>2];k=+n[h+64+4>>2];l=+n[h+64+8>>2];m=j*+n[b+4>>2]+k*+n[b+20>>2]+l*+n[b+36>>2];o=j*+n[b+8>>2]+k*+n[b+24>>2]+l*+n[b+40>>2];n[h+32>>2]=+n[b>>2]*j+ +n[b+16>>2]*k+ +n[b+32>>2]*l;n[h+32+4>>2]=m;n[h+32+8>>2]=o;n[h+32+12>>2]=0.0;Vb[i&127](h+48|0,a,h+32|0);o=+n[h+48>>2];m=+n[h+48+4>>2];l=+n[h+48+8>>2];k=o*+n[b+16>>2]+m*+n[b+20>>2]+l*+n[b+24>>2]+ +n[b+52>>2];j=o*+n[b+32>>2]+m*+n[b+36>>2]+l*+n[b+40>>2]+ +n[b+56>>2];n[h+32>>2]=o*+n[b>>2]+m*+n[b+4>>2]+l*+n[b+8>>2]+ +n[b+48>>2];n[h+32+4>>2]=k;n[h+32+8>>2]=j;n[h+32+12>>2]=0.0;i=h+32+(e<<2)|0;n[d+(e<<2)>>2]=g+ +n[i>>2];n[p>>2]=-1.0;p=f[(f[a>>2]|0)+64>>2]|0;j=+n[h+64>>2];k=+n[h+64+4>>2];l=+n[h+64+8>>2];m=j*+n[b+4>>2]+k*+n[b+20>>2]+l*+n[b+36>>2];o=j*+n[b+8>>2]+k*+n[b+24>>2]+l*+n[b+40>>2];n[h>>2]=+n[b>>2]*j+ +n[b+16>>2]*k+ +n[b+32>>2]*l;n[h+4>>2]=m;n[h+8>>2]=o;n[h+12>>2]=0.0;Vb[p&127](h+16|0,a,h);o=+n[h+16>>2];m=+n[h+16+4>>2];l=+n[h+16+8>>2];k=o*+n[b+16>>2]+m*+n[b+20>>2]+l*+n[b+24>>2]+ +n[b+52>>2];j=o*+n[b+32>>2]+m*+n[b+36>>2]+l*+n[b+40>>2]+ +n[b+56>>2];n[h+32>>2]=o*+n[b>>2]+m*+n[b+4>>2]+l*+n[b+8>>2]+ +n[b+48>>2];n[h+32+4>>2]=k;n[h+32+8>>2]=j;n[h+32+12>>2]=0.0;n[c+(e<<2)>>2]=+n[i>>2]-g;e=e+1|0}while((e|0)!=3);u=h;return}function Wf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;j=u;u=u+144|0;h=f[a+12>>2]|0;if(!h){u=j;return}l=f[c+4>>2]|0;k=f[d+4>>2]|0;f[g+4>>2]=h;n[j+12+128>>2]=999999984306749440.0;h=f[c+12>>2]|0;f[j+12>>2]=f[h>>2];f[j+12+4>>2]=f[h+4>>2];f[j+12+8>>2]=f[h+8>>2];f[j+12+12>>2]=f[h+12>>2];f[j+12+16>>2]=f[h+16>>2];f[j+12+16+4>>2]=f[h+16+4>>2];f[j+12+16+8>>2]=f[h+16+8>>2];f[j+12+16+12>>2]=f[h+16+12>>2];f[j+12+32>>2]=f[h+32>>2];f[j+12+32+4>>2]=f[h+32+4>>2];f[j+12+32+8>>2]=f[h+32+8>>2];f[j+12+32+12>>2]=f[h+32+12>>2];f[j+12+48>>2]=f[h+48>>2];f[j+12+48+4>>2]=f[h+48+4>>2];f[j+12+48+8>>2]=f[h+48+8>>2];f[j+12+48+12>>2]=f[h+48+12>>2];h=f[d+12>>2]|0;f[j+12+64>>2]=f[h>>2];f[j+12+64+4>>2]=f[h+4>>2];f[j+12+64+8>>2]=f[h+8>>2];f[j+12+64+12>>2]=f[h+12>>2];f[j+12+80>>2]=f[h+16>>2];f[j+12+80+4>>2]=f[h+16+4>>2];f[j+12+80+8>>2]=f[h+16+8>>2];f[j+12+80+12>>2]=f[h+16+12>>2];f[j+12+96>>2]=f[h+32>>2];f[j+12+96+4>>2]=f[h+32+4>>2];f[j+12+96+8>>2]=f[h+32+8>>2];f[j+12+96+12>>2]=f[h+32+12>>2];f[j+12+112>>2]=f[h+48>>2];f[j+12+112+4>>2]=f[h+48+4>>2];f[j+12+112+8>>2]=f[h+48+8>>2];f[j+12+112+12>>2]=f[h+48+12>>2];f[j>>2]=9476;f[j+4>>2]=l;f[j+8>>2]=k;qc(j,j+12|0,g,f[e+20>>2]|0,0);do if(b[a+8>>0]|0?(i=f[g+4>>2]|0,f[i+748>>2]|0):0){a=f[i+740>>2]|0;c=f[(f[g+8>>2]|0)+8>>2]|0;if((a|0)==(c|0)){df(i,a+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);break}else{df(i,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,c+4|0);break}}while(0);u=j;return}function Xf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;d=f[a+56>>2]|0;if(!d){d=f[a+52>>2]|0;if(!d){f[6472]=(f[6472]|0)+1;d=sc(31)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[a+60>>2]|0;f[d+4>>2]=e;g=d+8|0;f[g>>2]=0;f[6472]=(f[6472]|0)+1;e=sc((e*24|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f[d>>2]=e;f[g>>2]=f[a+48>>2];f[a+48>>2]=d}else f[a+52>>2]=f[d+8>>2];h=f[d+4>>2]|0;g=f[d>>2]|0;if((h|0)>0?(f[g>>2]=(h|0)!=1?g+24|0:0,(h|0)!=1):0){d=1;e=g+24|0;do{d=d+1|0;i=(d|0)<(h|0);j=e;e=e+24|0;f[j>>2]=i?e:0}while(i)}}else g=d;f[a+56>>2]=f[g>>2];f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[g+16>>2]=0;f[g+20>>2]=0;d=f[a+56>>2]|0;if(!d){d=f[a+52>>2]|0;if(!d){f[6472]=(f[6472]|0)+1;d=sc(31)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[a+60>>2]|0;f[d+4>>2]=e;h=d+8|0;f[h>>2]=0;f[6472]=(f[6472]|0)+1;e=sc((e*24|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f[d>>2]=e;f[h>>2]=f[a+48>>2];f[a+48>>2]=d}else f[a+52>>2]=f[d+8>>2];i=f[d+4>>2]|0;d=f[d>>2]|0;if((i|0)>0?(f[d>>2]=(i|0)!=1?d+24|0:0,(i|0)!=1):0){e=1;h=d+24|0;do{e=e+1|0;j=(e|0)<(i|0);k=h;h=h+24|0;f[k>>2]=j?h:0}while(j)}}f[a+56>>2]=f[d>>2];k=d;f[k>>2]=0;f[k+4>>2]=0;f[g+8>>2]=d;f[d+8>>2]=g;k=f[a+100>>2]|0;f[g+20>>2]=k;f[d+20>>2]=k;f[g+12>>2]=c;f[d+12>>2]=b;f[g+16>>2]=0;f[d+16>>2]=0;d=f[a+116>>2]|0;f[a+116>>2]=d+1;if((d|0)<(f[a+120>>2]|0))return g|0;f[a+120>>2]=d+1;return g|0}function Yf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0;H=u;u=u+32|0;i=+n[b+16>>2];e=+n[b>>2];j=+n[b+20>>2];g=+n[b+4>>2];l=+n[b+24>>2];h=+n[b+8>>2];q=+n[b+32>>2];v=+n[b+36>>2];w=+n[b+40>>2];B=(j-g)*(w-h)-(l-h)*(v-g);C=(l-h)*(q-e)-(i-e)*(w-h);D=(i-e)*(v-g)-(j-g)*(q-e);n[H+16>>2]=B;n[H+16+4>>2]=C;n[H+16+8>>2]=D;n[H+16+12>>2]=0.0;m=+n[a+4>>2];r=+n[a+8>>2];x=+n[a+12>>2];E=B*m+C*r+D*x-(e*B+g*C+h*D);o=+n[a+20>>2];s=+n[a+24>>2];y=+n[a+28>>2];if(E*(B*o+C*s+D*y-(e*B+g*C+h*D))>=0.0){u=H;return}F=f[a+36>>2]|0;if(E<=0.0&(F&1|0)!=0){u=H;return}G=E/(E-(B*o+C*s+D*y-(e*B+g*C+h*D)));if(!(G<+n[a+40>>2])){u=H;return}A=(B*B+C*C+D*D)*-9.999999747378752e-05;z=e-(o*G+m*(1.0-G));t=g-(s*G+r*(1.0-G));p=h-(y*G+x*(1.0-G));k=i-(o*G+m*(1.0-G));j=j-(s*G+r*(1.0-G));i=l-(y*G+x*(1.0-G));if(!(D*(z*j-t*k)+(B*(t*i-p*j)+C*(p*k-z*i))>=A)){u=H;return}h=q-(o*G+m*(1.0-G));g=v-(s*G+r*(1.0-G));e=w-(y*G+x*(1.0-G));if(!(D*(k*g-j*h)+(B*(j*e-i*g)+C*(i*h-k*e))>=A)){u=H;return}if(!(D*(t*h-z*g)+(B*(p*g-t*e)+C*(z*e-p*h))>=A)){u=H;return}e=1.0/+L(+(B*B+C*C+D*D));n[H+16>>2]=B*e;n[H+16+4>>2]=C*e;n[H+16+8>>2]=D*e;b=f[(f[a>>2]|0)+12>>2]|0;if(E<=0.0&(F&2|0)==0){n[H>>2]=-(B*e);n[H+4>>2]=-(C*e);n[H+8>>2]=-(D*e);n[H+12>>2]=0.0;G=+tb[b&3](a,H,G,c,d);n[a+40>>2]=G;u=H;return}else{G=+tb[b&3](a,H+16|0,G,c,d);n[a+40>>2]=G;u=H;return}}function Zf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0;a=u;u=u+608|0;o=+n[c+116>>2]-+n[c+52>>2];m=+n[c+120>>2]-+n[c+56>>2];l=+n[c+124>>2]-+n[c+60>>2];h=+n[d+116>>2]-+n[d+52>>2];i=+n[d+120>>2]-+n[d+56>>2];j=+n[d+124>>2]-+n[d+60>>2];k=+n[c+252>>2];if(o*o+m*m+l*l<k*k?(o=+n[d+252>>2],h*h+i*i+j*j<o*o):0){o=1.0;u=a;return +o}g=f[c+192>>2]|0;e=f[d+248>>2]|0;f[a+552+8>>2]=0;f[a+552+12>>2]=1065353216;f[a+552+16>>2]=1065353216;f[a+552+20>>2]=1065353216;n[a+552+24>>2]=0.0;f[a+552>>2]=6864;f[a+552+4>>2]=8;f[a+552+28>>2]=e;f[a+552+44>>2]=e;f[a+376>>2]=3832;n[a+376+164>>2]=999999984306749440.0;f[a+376+168>>2]=0;n[a+376+172>>2]=0.0;n[a+16+308>>2]=9.999999747378752e-05;b[a+16+332>>0]=0;f[a>>2]=9332;f[a+4>>2]=a+16;f[a+8>>2]=g;f[a+12>>2]=a+552;if(Bd(a,c+4|0,c+68|0,d+4|0,d+68|0,a+376|0)|0){h=+n[a+376+164>>2];if(+n[c+244>>2]>h)n[c+244>>2]=h;if(+n[d+244>>2]>h)n[d+244>>2]=h;if(!(h<1.0))h=1.0}else h=1.0;g=f[d+192>>2]|0;e=f[c+248>>2]|0;f[a+552+8>>2]=0;f[a+552+12>>2]=1065353216;f[a+552+16>>2]=1065353216;f[a+552+20>>2]=1065353216;n[a+552+24>>2]=0.0;f[a+552>>2]=6864;f[a+552+4>>2]=8;f[a+552+28>>2]=e;f[a+552+44>>2]=e;f[a+376>>2]=3832;n[a+376+164>>2]=999999984306749440.0;f[a+376+168>>2]=0;n[a+376+172>>2]=0.0;n[a+16+308>>2]=9.999999747378752e-05;b[a+16+332>>0]=0;f[a>>2]=9332;f[a+4>>2]=a+16;f[a+8>>2]=a+552;f[a+12>>2]=g;if(Bd(a,c+4|0,c+68|0,d+4|0,d+68|0,a+376|0)|0){i=+n[a+376+164>>2];if(+n[c+244>>2]>i)n[c+244>>2]=i;if(+n[d+244>>2]>i)n[d+244>>2]=i;if(h>i)h=i}o=h;u=a;return +o}function _f(a,c){a=a|0;c=+c;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0;k=u;u=u+16|0;uj(12232);d=f[a+232>>2]|0;if((d|0)>0){j=(b[26472]|0)==0;i=0;do{h=f[(f[a+240>>2]|0)+(i<<2)>>2]|0;a:do if(h){e=f[h+216>>2]|0;b:do switch(e|0){case 4:case 2:{if((e|0)==4)break a;break}default:{p=+n[h+312>>2];o=+n[h+316>>2];m=+n[h+320>>2];l=+n[h+472>>2];if(p*p+o*o+m*m<l*l?(l=+n[h+328>>2],m=+n[h+332>>2],o=+n[h+336>>2],p=+n[h+476>>2],l*l+m*m+o*o<p*p):0){n[h+220>>2]=+n[h+220>>2]+c;break b}n[h+220>>2]=0.0;if((e&-2|0)!=4){f[h+216>>2]=0;e=0}}}while(0);g=e&-2;do if(j){if((g|0)!=2?!(+n[h+220>>2]>2.0):0)break;if(f[h+204>>2]&3|0){if((g|0)==4)break a;f[h+216>>2]=2;break a}if((e|0)==1){if((g|0)==4)break a;f[h+216>>2]=3;break a}else{if((e|0)!=2)break a;d=(f[h+260>>2]|0)+2|0;f[h+328>>2]=0;f[h+328+4>>2]=0;f[h+328+8>>2]=0;f[h+328+12>>2]=0;f[h+260>>2]=d;f[h+312>>2]=0;f[h+312+4>>2]=0;f[h+312+8>>2]=0;f[h+312+12>>2]=0;d=f[a+232>>2]|0;break a}}while(0);if((g|0)!=4)f[h+216>>2]=1}while(0);i=i+1|0}while((i|0)<(d|0))}d=f[2405]|0;j=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=j;if(j|0){u=k;return}do if(f[d+4>>2]|0){gb(k|0,0)|0;j=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[k+4>>2]|0)-(f[j+4>>2]|0)+(((f[k>>2]|0)-(f[j>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[d+16>>2]|0)){d=f[2405]|0;break}else{u=k;return}}while(0);f[2405]=f[d+20>>2];u=k;return}function $f(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0;p=u;u=u+48|0;if((e|0)==(c|0)|((c|0)==(d|0)|(d|0)==(e|0))){u=p;return}j=p;k=j+36|0;do{f[j>>2]=0;j=j+4|0}while((j|0)<(k|0));if(!g)m=f[f[a+880>>2]>>2]|0;else m=g;g=f[a+752>>2]|0;if((g|0)==(f[a+756>>2]|0)?(o=g|0?g<<1:1,(g|0)<(o|0)):0){if(!o)l=0;else{f[6472]=(f[6472]|0)+1;g=sc((o*44|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=g;g=f[a+752>>2]|0}if((g|0)>0){h=0;do{j=l+(h*44|0)|0;i=(f[a+760>>2]|0)+(h*44|0)|0;k=j+44|0;do{f[j>>2]=f[i>>2];j=j+4|0;i=i+4|0}while((j|0)<(k|0));h=h+1|0}while((h|0)!=(g|0))}g=f[a+760>>2]|0;if(g|0){if(b[a+764>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+760>>2]=0}b[a+764>>0]=1;f[a+760>>2]=l;f[a+756>>2]=o;g=f[a+752>>2]|0}j=f[a+760>>2]|0;f[j+(g*44|0)>>2]=0;f[j+(g*44|0)+4>>2]=m;j=j+(g*44|0)+8|0;i=p;k=j+36|0;do{f[j>>2]=f[i>>2];j=j+4|0;i=i+4|0}while((j|0)<(k|0));o=f[a+752>>2]|0;f[a+752>>2]=o+1;m=f[a+760>>2]|0;j=f[a+720>>2]|0;f[m+(o*44|0)+8>>2]=j+(c*104|0);k=f[a+720>>2]|0;f[m+(o*44|0)+12>>2]=k+(d*104|0);l=f[a+720>>2]|0;f[m+(o*44|0)+16>>2]=l+(e*104|0);s=+n[j+(c*104|0)+8>>2];v=+n[j+(c*104|0)+12>>2];q=+n[j+(c*104|0)+16>>2];r=+n[k+(d*104|0)+8>>2]-s;w=+n[k+(d*104|0)+12>>2]-v;t=+n[k+(d*104|0)+16>>2]-q;s=+n[l+(e*104|0)+8>>2]-s;v=+n[l+(e*104|0)+12>>2]-v;q=+n[l+(e*104|0)+16>>2]-q;q=+L(+((r*v-w*s)*(r*v-w*s)+((w*q-t*v)*(w*q-t*v)+(t*s-r*q)*(t*s-r*q))));n[m+(o*44|0)+36>>2]=q;b[a+924>>0]=1;u=p;return}function ag(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=+g;var h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0;C=u;u=u+96|0;l=+n[d+4>>2];m=+n[d+20>>2];o=+n[d+36>>2];p=+n[d+8>>2];q=+n[d+24>>2];r=+n[d+40>>2];s=+n[d+12>>2];t=+n[d+28>>2];v=+n[d+44>>2];w=-+n[d+52>>2];x=-+n[d+56>>2];y=-+n[d+60>>2];j=f[a+720>>2]|0;z=+n[j+(c*104|0)+8>>2];A=+n[j+(c*104|0)+12>>2];B=+n[j+(c*104|0)+16>>2];a:do if(e){e=f[a+268>>2]|0;b:do if((e|0)>0){i=f[a+276>>2]|0;h=0;while(1){if((f[i+(h<<2)>>2]|0)==(d|0))break;h=h+1|0;if((h|0)>=(e|0))break b}if((h|0)!=(e|0)){e=j;break a}}while(0);if((e|0)==(f[a+272>>2]|0)?(k=e|0?e<<1:1,(e|0)<(k|0)):0){if(!k)i=0;else{f[6472]=(f[6472]|0)+1;e=sc((k<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}i=e;e=f[a+268>>2]|0}if((e|0)>0){h=0;do{f[i+(h<<2)>>2]=f[(f[a+276>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}h=f[a+276>>2]|0;if(h){if(b[a+280>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);e=f[a+268>>2]|0}f[a+276>>2]=0}b[a+280>>0]=1;f[a+276>>2]=i;f[a+272>>2]=k}f[(f[a+276>>2]|0)+(e<<2)>>2]=d;f[a+268>>2]=e+1;e=f[a+720>>2]|0}else e=j;while(0);f[C>>2]=e+(c*104|0);f[C+20>>2]=d;n[C+4>>2]=l*w+m*x+o*y+(l*z+m*A+o*B);n[C+8>>2]=p*w+q*x+r*y+(p*z+q*A+r*B);n[C+12>>2]=s*w+t*x+v*y+(s*z+t*A+v*B);n[C+16>>2]=0.0;d=e+(c*104|0)+100|0;b[d>>0]=b[d>>0]|1;n[C+24>>2]=g;pn(a+788|0,C);u=C;return}function bg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=u;u=u+64|0;h=f[a+24>>2]|0;f[h+(b*80|0)>>2]=f[c>>2];f[h+(b*80|0)+4>>2]=f[c+4>>2];f[h+(b*80|0)+8>>2]=f[c+8>>2];f[h+(b*80|0)+12>>2]=f[c+12>>2];f[h+(b*80|0)+16>>2]=f[c+16>>2];f[h+(b*80|0)+16+4>>2]=f[c+16+4>>2];f[h+(b*80|0)+16+8>>2]=f[c+16+8>>2];f[h+(b*80|0)+16+12>>2]=f[c+16+12>>2];f[h+(b*80|0)+32>>2]=f[c+32>>2];f[h+(b*80|0)+32+4>>2]=f[c+32+4>>2];f[h+(b*80|0)+32+8>>2]=f[c+32+8>>2];f[h+(b*80|0)+32+12>>2]=f[c+32+12>>2];f[h+(b*80|0)+48>>2]=f[c+48>>2];f[h+(b*80|0)+48+4>>2]=f[c+48+4>>2];f[h+(b*80|0)+48+8>>2]=f[c+48+8>>2];f[h+(b*80|0)+48+12>>2]=f[c+48+12>>2];if(!(f[a+64>>2]|0)){h=f[a>>2]|0;h=h+68|0;h=f[h>>2]|0;Lb[h&511](a);u=i;return}h=f[(f[a+24>>2]|0)+(b*80|0)+64>>2]|0;Yb[f[(f[h>>2]|0)+8>>2]&127](h,c,i+48|0,i+32|0);f[i>>2]=f[i+48>>2];f[i+4>>2]=f[i+48+4>>2];f[i+8>>2]=f[i+48+8>>2];f[i+12>>2]=f[i+48+12>>2];f[i+16>>2]=f[i+32>>2];f[i+16+4>>2]=f[i+32+4>>2];f[i+16+8>>2]=f[i+32+8>>2];f[i+16+12>>2]=f[i+32+12>>2];h=f[a+64>>2]|0;g=f[(f[a+24>>2]|0)+(b*80|0)+76>>2]|0;c=zg(h,g)|0;a:do if(c){e=f[h+8>>2]|0;if((e|0)<=-1){c=f[h>>2]|0;break}if(e){b=0;while(1){d=f[c+32>>2]|0;b=b+1|0;if(!d)break a;if((b|0)>=(e|0)){c=d;break}else c=d}}}else c=0;while(0);f[g>>2]=f[i>>2];f[g+4>>2]=f[i+4>>2];f[g+8>>2]=f[i+8>>2];f[g+12>>2]=f[i+12>>2];f[g+16>>2]=f[i+16>>2];f[g+20>>2]=f[i+20>>2];f[g+24>>2]=f[i+24>>2];f[g+28>>2]=f[i+28>>2];ff(h,c,g);h=f[a>>2]|0;h=h+68|0;h=f[h>>2]|0;Lb[h&511](a);u=i;return}function cg(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,o=0,p=0,q=0;q=u;u=u+80|0;n[q+16+60>>2]=0.0;n[q+16+8>>2]=0.0;n[q+16+12>>2]=.10000000149011612;n[q+16+16>>2]=300.0;n[q+16>>2]=1.0;n[q+16+4>>2]=-1.0;n[q+16+28>>2]=0.0;n[q+16+32>>2]=.20000000298023224;n[q+16+36>>2]=0.0;n[q+16+40>>2]=0.0;n[q+16+20>>2]=1.0;n[q+16+24>>2]=.5;f[q+16+56>>2]=0;n[q+16+48>>2]=0.0;b[q+16+44>>0]=0;o=0;do{m=f[a+856+(o<<2)>>2]|0;l=b[a+788+o>>0]|0;if(!m){if(l<<24>>24){l=1;p=5}}else p=5;if((p|0)==5){p=0;n[q+16+40>>2]=0.0;f[q+16+56>>2]=m;f[q+16+52>>2]=f[a+840+(o<<2)>>2];f[q+16+48>>2]=f[a+824+(o<<2)>>2];f[q+16+20>>2]=f[a+732>>2];b[q+16+44>>0]=l;f[q+16+4>>2]=f[a+696+(o<<2)>>2];f[q+16+24>>2]=f[a+728>>2];f[q+16>>2]=f[a+680+(o<<2)>>2];n[q+16+16>>2]=0.0;f[q+16+12>>2]=f[a+808+(o<<2)>>2];f[q+16+8>>2]=f[a+792+(o<<2)>>2];f[q>>2]=f[a+1064+(o<<2)>>2];f[q+4>>2]=f[a+1080+(o<<2)>>2];f[q+8>>2]=f[a+1096+(o<<2)>>2];n[q+12>>2]=0.0;m=f[a+1304>>2]>>o*3;if(!(m&1))l=f[c+32>>2]|0;else l=a+740+(o<<2)|0;f[q+16+28>>2]=f[l>>2];if(!(m&2))l=f[c+32>>2]|0;else l=a+772+(o<<2)|0;f[q+16+36>>2]=f[l>>2];f[q+16+32>>2]=f[((m&4|0)==0?c+4|0:a+756+(o<<2)|0)>>2];if(b[a+1301>>0]|0){m=o+1|0;if(!(f[a+868+(((m|0)==3?0:m)<<6)+56>>2]|0))l=1;else l=(f[a+868+(((o+2|0)%3|0)<<6)+56>>2]|0)==0&1}else l=0;d=(Fd(a,q+16|0,e,g,h,i,j,k,c,d,q,0,l)|0)+d|0}o=o+1|0}while((o|0)!=3);u=q;return d|0}function dg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=u;u=u+64|0;i=f[a+24>>2]|0;f[i+(b*80|0)>>2]=f[c>>2];f[i+(b*80|0)+4>>2]=f[c+4>>2];f[i+(b*80|0)+8>>2]=f[c+8>>2];f[i+(b*80|0)+12>>2]=f[c+12>>2];f[i+(b*80|0)+16>>2]=f[c+16>>2];f[i+(b*80|0)+16+4>>2]=f[c+16+4>>2];f[i+(b*80|0)+16+8>>2]=f[c+16+8>>2];f[i+(b*80|0)+16+12>>2]=f[c+16+12>>2];f[i+(b*80|0)+32>>2]=f[c+32>>2];f[i+(b*80|0)+32+4>>2]=f[c+32+4>>2];f[i+(b*80|0)+32+8>>2]=f[c+32+8>>2];f[i+(b*80|0)+32+12>>2]=f[c+32+12>>2];f[i+(b*80|0)+48>>2]=f[c+48>>2];f[i+(b*80|0)+48+4>>2]=f[c+48+4>>2];f[i+(b*80|0)+48+8>>2]=f[c+48+8>>2];f[i+(b*80|0)+48+12>>2]=f[c+48+12>>2];if(f[a+64>>2]|0){i=f[(f[a+24>>2]|0)+(b*80|0)+64>>2]|0;Yb[f[(f[i>>2]|0)+8>>2]&127](i,c,j+48|0,j+32|0);f[j>>2]=f[j+48>>2];f[j+4>>2]=f[j+48+4>>2];f[j+8>>2]=f[j+48+8>>2];f[j+12>>2]=f[j+48+12>>2];f[j+16>>2]=f[j+32>>2];f[j+16+4>>2]=f[j+32+4>>2];f[j+16+8>>2]=f[j+32+8>>2];f[j+16+12>>2]=f[j+32+12>>2];i=f[a+64>>2]|0;h=f[(f[a+24>>2]|0)+(b*80|0)+76>>2]|0;c=zg(i,h)|0;a:do if(c){g=f[i+8>>2]|0;if((g|0)<=-1){c=f[i>>2]|0;break}if(g){b=0;while(1){e=f[c+32>>2]|0;b=b+1|0;if(!e)break a;if((b|0)>=(g|0)){c=e;break}else c=e}}}else c=0;while(0);f[h>>2]=f[j>>2];f[h+4>>2]=f[j+4>>2];f[h+8>>2]=f[j+8>>2];f[h+12>>2]=f[j+12>>2];f[h+16>>2]=f[j+16>>2];f[h+20>>2]=f[j+20>>2];f[h+24>>2]=f[j+24>>2];f[h+28>>2]=f[j+28>>2];ff(i,c,h)}if(!d){u=j;return}Lb[f[(f[a>>2]|0)+68>>2]&511](a);u=j;return}function eg(a,b,c){a=a|0;b=+b;c=+c;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;v=u;u=u+16|0;p=+n[a+452>>2];m=f[a+192>>2]|0;l=+rb[f[(f[m>>2]|0)+48>>2]&15](m);m=f[a+812>>2]|0;if((m|0)<=0){u=v;return}k=0;do{o=f[a+820>>2]|0;j=f[o+(k*104|0)>>2]|0;j=(f[j+236>>2]&2|0)==0?0:j;if(j|0){t=+n[j+332>>2];d=+n[o+(k*104|0)+84>>2];i=+n[j+336>>2];r=+n[o+(k*104|0)+80>>2];e=+n[o+(k*104|0)+76>>2];s=+n[j+328>>2];c=p*(t*d-i*r+ +n[j+312>>2]);d=p*(+n[j+316>>2]+(i*e-d*s));e=p*(r*s-t*e+ +n[j+320>>2])}else{c=0.0;d=0.0;e=0.0}q=f[o+(k*104|0)+24>>2]|0;r=+n[q+8>>2];s=+n[q+12>>2];t=+n[q+16>>2];i=r-+n[q+24>>2]-c;h=s-+n[q+28>>2]-d;c=t-+n[q+32>>2]-e;d=+n[o+(k*104|0)+4>>2];e=+n[o+(k*104|0)+8>>2];g=+n[o+(k*104|0)+12>>2];if(i*d+h*e+c*g<=1.1920928955078125e-07?(y=r*d+s*e+t*g+ +n[o+(k*104|0)+20>>2],z=+n[o+(k*104|0)+96>>2],y=(y<l?y:l)*+n[o+(k*104|0)+100>>2],x=(i-(i-d*(i*d+h*e+c*g))*z+d*y)*b,w=(h-(h-e*(i*d+h*e+c*g))*z+y*e)*b,i=(c-(c-g*(i*d+h*e+c*g))*z+y*g)*b,e=+n[o+(k*104|0)+28>>2]*x+ +n[o+(k*104|0)+32>>2]*w+ +n[o+(k*104|0)+36>>2]*i,g=x*+n[o+(k*104|0)+44>>2]+w*+n[o+(k*104|0)+48>>2]+i*+n[o+(k*104|0)+52>>2],i=x*+n[o+(k*104|0)+60>>2]+w*+n[o+(k*104|0)+64>>2]+i*+n[o+(k*104|0)+68>>2],n[v>>2]=e,n[v+4>>2]=g,n[v+8>>2]=i,n[v+12>>2]=0.0,h=+n[o+(k*104|0)+92>>2],n[q+8>>2]=r-e*h,n[q+12>>2]=s-h*g,n[q+16>>2]=t-h*i,j|0):0)ll(j,v,o+(k*104|0)+76|0);k=k+1|0}while((k|0)!=(m|0));u=v;return}function fg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;f[a+4>>2]=1065353216;f[a+8>>2]=1065353216;f[a+12>>2]=1065353216;n[a+16>>2]=0.0;b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;f[a+48>>2]=0;f[a>>2]=8644;b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;b[a+140>>0]=1;f[a+136>>2]=0;f[a+128>>2]=0;f[a+132>>2]=0;b[a+160>>0]=1;f[a+156>>2]=0;f[a+148>>2]=0;f[a+152>>2]=0;b[a+164>>0]=c&1;b[a+165>>0]=d&1;n[a+168>>2]=0.0;f[6472]=(f[6472]|0)+1;c=sc(51)|0;if(!c)e=0;else{f[(c+4+15&-16)+-4>>2]=c;e=c+4+15&-16}d=f[a+24>>2]|0;if((d|0)>0){c=0;do{g=e+(c<<5)|0;h=(f[a+32>>2]|0)+(c<<5)|0;f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];f[g+12>>2]=f[h+12>>2];f[g+16>>2]=f[h+16>>2];f[g+20>>2]=f[h+20>>2];f[g+24>>2]=f[h+24>>2];f[g+28>>2]=f[h+28>>2];c=c+1|0}while((c|0)!=(d|0))}c=f[a+32>>2]|0;if(c|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=e;f[a+28>>2]=1;h=f[a+24>>2]|0;f[e+(h<<5)>>2]=0;f[e+(h<<5)+4>>2]=0;f[e+(h<<5)+8>>2]=12;f[e+(h<<5)+12>>2]=0;f[e+(h<<5)+16>>2]=0;f[e+(h<<5)+20>>2]=16;f[e+(h<<5)+24>>2]=2;f[e+(h<<5)+28>>2]=0;f[a+24>>2]=(f[a+24>>2]|0)+1;h=(b[a+164>>0]|0)==0;c=f[a+32>>2]|0;f[c>>2]=(f[(h?a+148|0:a+128|0)>>2]|0)/3|0;f[c+4>>2]=0;f[c+24>>2]=h?3:2;f[c+8>>2]=h?6:12;if(!(b[a+165>>0]|0)){g=12;a=(f[a+108>>2]|0)/3|0;h=c+12|0;f[h>>2]=a;h=c+16|0;f[h>>2]=0;h=c+20|0;f[h>>2]=g;return}else{g=16;a=f[a+88>>2]|0;h=c+12|0;f[h>>2]=a;h=c+16|0;f[h>>2]=0;h=c+20|0;f[h>>2]=g;return}}function gg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=Vs()|0;Kj(e,4,a);f[e>>2]=4900;f[e+552>>2]=f[c>>2];f[e+552+4>>2]=f[c+4>>2];f[e+552+8>>2]=f[c+8>>2];f[e+552+12>>2]=f[c+12>>2];f[e+568>>2]=f[c+16>>2];f[e+568+4>>2]=f[c+16+4>>2];f[e+568+8>>2]=f[c+16+8>>2];f[e+568+12>>2]=f[c+16+12>>2];f[e+584>>2]=f[c+32>>2];f[e+584+4>>2]=f[c+32+4>>2];f[e+584+8>>2]=f[c+32+8>>2];f[e+584+12>>2]=f[c+32+12>>2];f[e+600>>2]=f[c+48>>2];f[e+600+4>>2]=f[c+48+4>>2];f[e+600+8>>2]=f[c+48+8>>2];f[e+600+12>>2]=f[c+48+12>>2];f[e+616>>2]=f[c>>2];f[e+616+4>>2]=f[c+4>>2];f[e+616+8>>2]=f[c+8>>2];f[e+616+12>>2]=f[c+12>>2];f[e+632>>2]=f[c+16>>2];f[e+632+4>>2]=f[c+16+4>>2];f[e+632+8>>2]=f[c+16+8>>2];f[e+632+12>>2]=f[c+16+12>>2];f[e+648>>2]=f[c+32>>2];f[e+648+4>>2]=f[c+32+4>>2];f[e+648+8>>2]=f[c+32+8>>2];f[e+648+12>>2]=f[c+32+12>>2];f[e+664>>2]=f[c+48>>2];f[e+664+4>>2]=f[c+48+4>>2];f[e+664+8>>2]=f[c+48+8>>2];f[e+664+12>>2]=f[c+48+12>>2];n[e+688>>2]=0.0;n[e+692>>2]=-1.0;n[e+696>>2]=.8999999761581421;n[e+700>>2]=.30000001192092896;n[e+704>>2]=1.0;n[e+708>>2]=0.0;n[e+712>>2]=0.0;b[e+716>>0]=0;b[e+736>>0]=0;b[e+737>>0]=0;b[e+738>>0]=0;b[e+739>>0]=1;b[e+740>>0]=d&1;f[e+748>>2]=0;c=f[e+28>>2]|0;k=+n[e+600>>2];j=+n[e+604>>2];i=+n[e+608>>2];h=k*+n[c+20>>2]+j*+n[c+24>>2]+i*+n[c+28>>2]+ +n[c+56>>2];g=k*+n[c+36>>2]+j*+n[c+40>>2]+i*+n[c+44>>2]+ +n[c+60>>2];n[e+664>>2]=k*+n[c+4>>2]+j*+n[c+8>>2]+i*+n[c+12>>2]+ +n[c+52>>2];n[e+668>>2]=h;n[e+672>>2]=g;n[e+676>>2]=0.0;n[e+732>>2]=d?-1.0:1.0;return e|0}function hg(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0;d=Vs()|0;Kj(d,4,a);f[d>>2]=4900;f[d+552>>2]=f[c>>2];f[d+552+4>>2]=f[c+4>>2];f[d+552+8>>2]=f[c+8>>2];f[d+552+12>>2]=f[c+12>>2];f[d+568>>2]=f[c+16>>2];f[d+568+4>>2]=f[c+16+4>>2];f[d+568+8>>2]=f[c+16+8>>2];f[d+568+12>>2]=f[c+16+12>>2];f[d+584>>2]=f[c+32>>2];f[d+584+4>>2]=f[c+32+4>>2];f[d+584+8>>2]=f[c+32+8>>2];f[d+584+12>>2]=f[c+32+12>>2];f[d+600>>2]=f[c+48>>2];f[d+600+4>>2]=f[c+48+4>>2];f[d+600+8>>2]=f[c+48+8>>2];f[d+600+12>>2]=f[c+48+12>>2];f[d+616>>2]=f[c>>2];f[d+616+4>>2]=f[c+4>>2];f[d+616+8>>2]=f[c+8>>2];f[d+616+12>>2]=f[c+12>>2];f[d+632>>2]=f[c+16>>2];f[d+632+4>>2]=f[c+16+4>>2];f[d+632+8>>2]=f[c+16+8>>2];f[d+632+12>>2]=f[c+16+12>>2];f[d+648>>2]=f[c+32>>2];f[d+648+4>>2]=f[c+32+4>>2];f[d+648+8>>2]=f[c+32+8>>2];f[d+648+12>>2]=f[c+32+12>>2];f[d+664>>2]=f[c+48>>2];f[d+664+4>>2]=f[c+48+4>>2];f[d+664+8>>2]=f[c+48+8>>2];f[d+664+12>>2]=f[c+48+12>>2];n[d+688>>2]=0.0;n[d+692>>2]=-1.0;n[d+696>>2]=.8999999761581421;n[d+700>>2]=.30000001192092896;n[d+704>>2]=1.0;n[d+708>>2]=0.0;n[d+712>>2]=0.0;b[d+716>>0]=0;b[d+736>>0]=0;b[d+737>>0]=0;b[d+738>>0]=0;b[d+739>>0]=1;b[d+740>>0]=0;f[d+748>>2]=0;c=f[d+28>>2]|0;j=+n[d+600>>2];i=+n[d+604>>2];h=+n[d+608>>2];g=j*+n[c+20>>2]+i*+n[c+24>>2]+h*+n[c+28>>2]+ +n[c+56>>2];e=j*+n[c+36>>2]+i*+n[c+40>>2]+h*+n[c+44>>2]+ +n[c+60>>2];n[d+664>>2]=j*+n[c+4>>2]+i*+n[c+8>>2]+h*+n[c+12>>2]+ +n[c+52>>2];n[d+668>>2]=g;n[d+672>>2]=e;n[d+676>>2]=0.0;n[d+732>>2]=1.0;return d|0}function ig(a){a=a|0;var c=0,d=0.0,e=0,g=0,h=0.0,i=0.0,j=0;j=u;u=u+64|0;uj(12402);a:do if(!(b[a+274>>0]|0)){c=f[a+232>>2]|0;if((c|0)>0){g=0;while(1){e=f[(f[a+240>>2]|0)+(g<<2)>>2]|0;switch(f[e+216>>2]|0){case 2:case 5:break;default:if((f[e+480>>2]|0)!=0?(f[e+204>>2]&3|0)==0:0){if((b[a+300>>0]|0)!=0?(i=+n[a+268>>2],i!=0.0):0)d=+n[a+264>>2]-i;else d=+n[a+264>>2]*+n[e+244>>2];Yg(e+68|0,+n[e+132>>2],+n[e+136>>2],+n[e+140>>2],e+148|0,d,j);c=f[e+480>>2]|0;Rb[f[(f[c>>2]|0)+12>>2]&127](c,j);c=f[a+232>>2]|0}}g=g+1|0;if((g|0)>=(c|0))break a}}}else{c=f[a+8>>2]|0;if((c|0)>0){g=0;do{e=f[(f[a+16>>2]|0)+(g<<2)>>2]|0;if((!((e|0)==0?1:(f[e+236>>2]&2|0)==0)?(f[e+480>>2]|0)!=0:0)?(f[e+204>>2]&3|0)==0:0){if((b[a+300>>0]|0)!=0?(h=+n[a+268>>2],h!=0.0):0)d=+n[a+264>>2]-h;else d=+n[a+264>>2]*+n[e+244>>2];Yg(e+68|0,+n[e+132>>2],+n[e+136>>2],+n[e+140>>2],e+148|0,d,j);c=f[e+480>>2]|0;Rb[f[(f[c>>2]|0)+12>>2]&127](c,j);c=f[a+8>>2]|0}g=g+1|0}while((g|0)<(c|0))}}while(0);c=f[2405]|0;a=(f[c+16>>2]|0)+-1|0;f[c+16>>2]=a;if(a|0){u=j;return}do if(f[c+4>>2]|0){gb(j|0,0)|0;a=f[6471]|0;n[c+8>>2]=+n[c+8>>2]+ +(((f[j+4>>2]|0)-(f[a+4>>2]|0)+(((f[j>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[c+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[c+16>>2]|0)){c=f[2405]|0;break}else{u=j;return}}while(0);f[2405]=f[c+20>>2];u=j;return}function jg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=u;u=u+32|0;if((b|0)<0)b=f[a+12>>2]|0;c=f[a>>2]|0;if(!((b|0)>0&(c|0)!=0)){u=m;return}while(1){d=c+40|0;if(f[d>>2]|0){l=0;while(1){g=c+32|0;h=f[g>>2]|0;if(h>>>0>c>>>0){i=(f[h+40>>2]|0)==(c|0)&1;j=f[h+36+((i^1)<<2)>>2]|0;k=f[h+32>>2]|0;if(!k)e=a;else e=k+36+(((f[k+40>>2]|0)==(h|0)&1)<<2)|0;f[e>>2]=c;f[j+32>>2]=c;f[h+32>>2]=c;f[g>>2]=k;k=c+36|0;f[h+36>>2]=f[k>>2];f[h+40>>2]=f[d>>2];f[(f[k>>2]|0)+32>>2]=h;f[(f[d>>2]|0)+32>>2]=h;f[c+36+(i<<2)>>2]=h;f[c+36+((i^1)<<2)>>2]=j;f[m>>2]=f[h>>2];f[m+4>>2]=f[h+4>>2];f[m+8>>2]=f[h+8>>2];f[m+12>>2]=f[h+12>>2];f[m+16>>2]=f[h+16>>2];f[m+20>>2]=f[h+20>>2];f[m+24>>2]=f[h+24>>2];f[m+28>>2]=f[h+28>>2];f[h>>2]=f[c>>2];f[h+4>>2]=f[c+4>>2];f[h+8>>2]=f[c+8>>2];f[h+12>>2]=f[c+12>>2];f[h+16>>2]=f[c+16>>2];f[h+20>>2]=f[c+20>>2];f[h+24>>2]=f[c+24>>2];f[h+28>>2]=f[c+28>>2];f[c>>2]=f[m>>2];f[c+4>>2]=f[m+4>>2];f[c+8>>2]=f[m+8>>2];f[c+12>>2]=f[m+12>>2];f[c+16>>2]=f[m+16>>2];f[c+20>>2]=f[m+20>>2];f[c+24>>2]=f[m+24>>2];f[c+28>>2]=f[m+28>>2];c=h}c=f[c+36+(((f[a+16>>2]|0)>>>l&1)<<2)>>2]|0;d=c+40|0;if(!(f[d>>2]|0))break;else l=l+1&31}}if(!(zg(a,c)|0))d=0;else d=f[a>>2]|0;ff(a,d,c);f[a+16>>2]=(f[a+16>>2]|0)+1;b=b+-1|0;if(!b)break;c=f[a>>2]|0}u=m;return}function kg(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;h=u;u=u+32|0;c=b[a+8>>0]|0?c:d;if(((f[(f[c+4>>2]|0)+4>>2]|0)+-21|0)>>>0>=9){u=h;return}d=f[(f[c+8>>2]|0)+192>>2]|0;w=+rb[f[(f[d>>2]|0)+48>>2]&15](d);f[a+64>>2]=e;n[a+68>>2]=w+.05999999865889549;f[a+56>>2]=g;g=f[a+16>>2]|0;Vb[f[(f[g>>2]|0)+28>>2]&127](g,h+16|0,h);w=+n[h>>2];v=+n[h+16>>2];q=+n[h+4>>2];p=+n[h+16+4>>2];y=+n[h+8>>2];x=+n[h+16+8>>2];g=f[c+12>>2]|0;C=+n[g>>2];B=+n[g+16>>2];m=+n[g+32>>2];A=+n[g+4>>2];z=+n[g+20>>2];k=+n[g+36>>2];t=+n[g+8>>2];s=+n[g+24>>2];r=+n[g+40>>2];D=-+n[g+48>>2];i=-+n[g+52>>2];j=-+n[g+56>>2];o=(w+v)*.5*C+(q+p)*.5*B+(y+x)*.5*m+(C*D+B*i+m*j);l=(w+v)*.5*A+(q+p)*.5*z+(y+x)*.5*k+(A*D+z*i+k*j);j=(w+v)*.5*t+(q+p)*.5*s+(y+x)*.5*r+(t*D+s*i+r*j);i=+n[a+68>>2];m=+K(+(m+(C*0.0+B*0.0)))*((y-x)*.5+i)+(+K(+(C+B*0.0+m*0.0))*((w-v)*.5+i)+ +K(+(C*0.0+B+m*0.0))*((q-p)*.5+i));k=+K(+(k+(A*0.0+z*0.0)))*((y-x)*.5+i)+(+K(+(A+z*0.0+k*0.0))*((w-v)*.5+i)+ +K(+(A*0.0+z+k*0.0))*((q-p)*.5+i));i=+K(+(r+(t*0.0+s*0.0)))*((y-x)*.5+i)+(+K(+(t+s*0.0+r*0.0))*((w-v)*.5+i)+ +K(+(t*0.0+s+r*0.0))*((q-p)*.5+i));n[a+24>>2]=o-m;n[a+28>>2]=l-k;n[a+32>>2]=j-i;n[a+36>>2]=0.0;n[a+40>>2]=o+m;n[a+44>>2]=l+k;n[a+48>>2]=j+i;n[a+52>>2]=0.0;Yb[f[(f[d>>2]|0)+64>>2]&127](d,a+12|0,a+24|0,a+40|0);u=h;return}function lg(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;if(!(b[a+164>>0]|0)){e=f[a+148>>2]|0;if((e|0)==(f[a+152>>2]|0)?(k=e|0?e<<1:1,(e|0)<(k|0)):0){if(!k)i=0;else{f[6472]=(f[6472]|0)+1;e=sc((k<<1)+19|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}i=e;e=f[a+148>>2]|0}h=f[a+156>>2]|0;if((e|0)<=0)if(!h)g=a+160|0;else l=27;else{g=0;do{d[i+(g<<1)>>1]=d[h+(g<<1)>>1]|0;g=g+1|0}while((g|0)!=(e|0));l=27}if((l|0)==27){if(b[a+160>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);e=f[a+148>>2]|0}f[a+156>>2]=0;g=a+160|0}b[g>>0]=1;f[a+156>>2]=i;f[a+152>>2]=k}d[(f[a+156>>2]|0)+(e<<1)>>1]=c;f[a+148>>2]=e+1;l=a+156|0;l=f[l>>2]|0;c=a+32|0;c=f[c>>2]|0;c=c+4|0;f[c>>2]=l;return}else{e=f[a+128>>2]|0;if((e|0)==(f[a+132>>2]|0)?(j=e|0?e<<1:1,(e|0)<(j|0)):0){if(!j)i=0;else{f[6472]=(f[6472]|0)+1;e=sc((j<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}i=e;e=f[a+128>>2]|0}h=f[a+136>>2]|0;if((e|0)<=0)if(!h)g=a+140|0;else l=12;else{g=0;do{f[i+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));l=12}if((l|0)==12){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+136>>2]=0;g=a+140|0;e=f[a+128>>2]|0}b[g>>0]=1;f[a+136>>2]=i;f[a+132>>2]=j}f[(f[a+136>>2]|0)+(e<<2)>>2]=c;f[a+128>>2]=(f[a+128>>2]|0)+1;l=a+136|0;l=f[l>>2]|0;c=a+32|0;c=f[c>>2]|0;c=c+4|0;f[c>>2]=l;return}}function mg(a){a=a|0;var c=0;f[a>>2]=4952;c=f[a+176>>2]|0;if(c|0){if(b[a+180>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+176>>2]=0}b[a+180>>0]=1;f[a+176>>2]=0;f[a+168>>2]=0;f[a+172>>2]=0;c=f[a+156>>2]|0;if(c|0){if(b[a+160>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+156>>2]=0}b[a+160>>0]=1;f[a+156>>2]=0;f[a+148>>2]=0;f[a+152>>2]=0;c=f[a+136>>2]|0;if(c|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=0;f[a+128>>2]=0;f[a+132>>2]=0;c=f[a+116>>2]|0;if(c|0){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+116>>2]=0}b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;c=f[a+96>>2]|0;if(c|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;c=f[a+76>>2]|0;if(c|0){if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+76>>2]=0}b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;f[a+72>>2]=0;c=f[a+56>>2]|0;if(c|0){if(b[a+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+56>>2]=0}b[a+60>>0]=1;f[a+56>>2]=0;f[a+48>>2]=0;f[a+52>>2]=0;c=f[a+36>>2]|0;if(c|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=0;f[a+28>>2]=0;f[a+32>>2]=0;c=f[a+16>>2]|0;if(!c){b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0;b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}function ng(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;j=u;u=u+16|0;f[a+8>>2]=0;f[a+12>>2]=1065353216;f[a+16>>2]=1065353216;f[a+20>>2]=1065353216;n[a+24>>2]=0.0;n[a+44>>2]=.03999999910593033;f[a+52>>2]=0;f[a+56>>2]=1065353216;f[a+60>>2]=1065353216;f[a+64>>2]=1065353216;n[a+68>>2]=0.0;f[a+72>>2]=-1082130432;f[a+76>>2]=-1082130432;f[a+80>>2]=-1082130432;n[a+84>>2]=0.0;b[a+88>>0]=0;f[a>>2]=7448;b[a+108>>0]=1;f[a+104>>2]=0;f[a+96>>2]=0;f[a+100>>2]=0;f[a+4>>2]=4;if((d|0)<=0){f[a+96>>2]=d;yj(a);u=j;return}f[6472]=(f[6472]|0)+1;g=sc((d<<4|3)+16|0)|0;if(!g)i=0;else{f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}h=f[a+96>>2]|0;if((h|0)>0){g=0;do{k=i+(g<<4)|0;l=(f[a+104>>2]|0)+(g<<4)|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+104>>2]|0;if(g|0){if(b[a+108>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+104>>2]=0}b[a+108>>0]=1;f[a+104>>2]=i;f[a+100>>2]=d;f[i>>2]=f[j>>2];f[i+4>>2]=f[j+4>>2];f[i+8>>2]=f[j+8>>2];f[i+12>>2]=f[j+12>>2];if((d|0)!=1){g=1;do{l=(f[a+104>>2]|0)+(g<<4)|0;f[l>>2]=f[j>>2];f[l+4>>2]=f[j+4>>2];f[l+8>>2]=f[j+8>>2];f[l+12>>2]=f[j+12>>2];g=g+1|0}while((g|0)!=(d|0))}f[a+96>>2]=d;g=0;while(1){i=f[c+4>>2]|0;k=f[c+8>>2]|0;l=f[a+104>>2]|0;f[l+(g<<4)>>2]=f[c>>2];f[l+(g<<4)+4>>2]=i;f[l+(g<<4)+8>>2]=k;n[l+(g<<4)+12>>2]=0.0;g=g+1|0;if((g|0)==(d|0))break;else c=c+e|0}yj(a);u=j;return}function og(a,b,c){a=a|0;b=b|0;c=c|0;lf(a,b,c)|0;f[b+256>>2]=f[a+264>>2];f[b+260>>2]=f[a+268>>2];f[b+264>>2]=f[a+272>>2];f[b+268>>2]=f[a+276>>2];f[b+272>>2]=f[a+280>>2];f[b+276>>2]=f[a+284>>2];f[b+280>>2]=f[a+288>>2];f[b+284>>2]=f[a+292>>2];f[b+288>>2]=f[a+296>>2];f[b+292>>2]=f[a+300>>2];f[b+296>>2]=f[a+304>>2];f[b+300>>2]=f[a+308>>2];f[b+304>>2]=f[a+312>>2];f[b+308>>2]=f[a+316>>2];f[b+312>>2]=f[a+320>>2];f[b+316>>2]=f[a+324>>2];f[b+320>>2]=f[a+328>>2];f[b+324>>2]=f[a+332>>2];f[b+328>>2]=f[a+336>>2];f[b+332>>2]=f[a+340>>2];f[b+448>>2]=f[a+344>>2];f[b+336>>2]=f[a+544>>2];f[b+340>>2]=f[a+548>>2];f[b+344>>2]=f[a+552>>2];f[b+348>>2]=f[a+556>>2];f[b+352>>2]=f[a+348>>2];f[b+356>>2]=f[a+352>>2];f[b+360>>2]=f[a+356>>2];f[b+364>>2]=f[a+360>>2];f[b+368>>2]=f[a+364>>2];f[b+372>>2]=f[a+368>>2];f[b+376>>2]=f[a+372>>2];f[b+380>>2]=f[a+376>>2];f[b+384>>2]=f[a+380>>2];f[b+388>>2]=f[a+384>>2];f[b+392>>2]=f[a+388>>2];f[b+396>>2]=f[a+392>>2];f[b+400>>2]=f[a+396>>2];f[b+404>>2]=f[a+400>>2];f[b+408>>2]=f[a+404>>2];f[b+412>>2]=f[a+408>>2];f[b+416>>2]=f[a+412>>2];f[b+420>>2]=f[a+416>>2];f[b+424>>2]=f[a+420>>2];f[b+428>>2]=f[a+424>>2];f[b+432>>2]=f[a+428>>2];f[b+436>>2]=f[a+432>>2];f[b+440>>2]=f[a+436>>2];f[b+444>>2]=f[a+440>>2];f[b+452>>2]=f[a+444>>2];f[b+456>>2]=f[a+448>>2];f[b+484>>2]=h[a+452>>0];f[b+460>>2]=f[a+456>>2];f[b+464>>2]=f[a+460>>2];f[b+468>>2]=f[a+464>>2];f[b+472>>2]=f[a+468>>2];f[b+476>>2]=f[a+472>>2];f[b+480>>2]=f[a+476>>2];return 12028}function pg(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0;m=u;u=u+16|0;if(!((f[a+924>>2]|0)==0?(b[a+912>>0]|0)==0:0)){f[m>>2]=f[a+1208>>2];f[m+4>>2]=f[a+1208+4>>2];f[m+8>>2]=f[a+1208+8>>2];f[m+12>>2]=f[a+1208+12>>2];l=f[a+1304>>2]>>9;if(!(l&1))f[a+896>>2]=f[f[c+32>>2]>>2];if(!(l&2))f[a+904>>2]=f[f[c+32>>2]>>2];if(!(l&4))f[a+900>>2]=f[c+4>>2];d=(Fd(a,a+868|0,e,g,h,i,j,k,c,d,m,1,0)|0)+d|0}if(!((f[a+988>>2]|0)==0?(b[a+976>>0]|0)==0:0)){f[m>>2]=f[a+1224>>2];f[m+4>>2]=f[a+1224+4>>2];f[m+8>>2]=f[a+1224+8>>2];f[m+12>>2]=f[a+1224+12>>2];l=f[a+1304>>2]>>12;if(!(l&1))f[a+960>>2]=f[f[c+32>>2]>>2];if(!(l&2))f[a+968>>2]=f[f[c+32>>2]>>2];if(!(l&4))f[a+964>>2]=f[c+4>>2];d=(Fd(a,a+932|0,e,g,h,i,j,k,c,d,m,1,0)|0)+d|0}if((f[a+1052>>2]|0)==0?(b[a+1040>>0]|0)==0:0){k=d;u=m;return k|0}f[m>>2]=f[a+1240>>2];f[m+4>>2]=f[a+1240+4>>2];f[m+8>>2]=f[a+1240+8>>2];f[m+12>>2]=f[a+1240+12>>2];l=f[a+1304>>2]>>15;if(!(l&1))f[a+1024>>2]=f[f[c+32>>2]>>2];if(!(l&2))f[a+1032>>2]=f[f[c+32>>2]>>2];if(!(l&4))f[a+1028>>2]=f[c+4>>2];k=(Fd(a,a+996|0,e,g,h,i,j,k,c,d,m,1,0)|0)+d|0;u=m;return k|0}function qg(a,c,d,e,g){a=a|0;c=+c;d=d|0;e=e|0;g=g|0;var h=0;h=u;u=u+144|0;f[a+164>>2]=1065353216;f[a+168>>2]=1065353216;f[a+172>>2]=1065353216;n[a+176>>2]=0.0;f[a+180>>2]=0;n[a+184>>2]=999999984306749440.0;f[a+188>>2]=0;f[a+188+4>>2]=0;f[a+188+8>>2]=0;f[a+188+12>>2]=0;f[a+204>>2]=1;f[a+208>>2]=-1;f[a+212>>2]=-1;f[a+216>>2]=1;n[a+220>>2]=0.0;n[a+224>>2]=.5;n[a+228>>2]=0.0;n[a+232>>2]=0.0;f[a+236>>2]=1;f[a+240>>2]=0;n[a+244>>2]=1.0;f[a+248>>2]=0;f[a+248+4>>2]=0;f[a+248+8>>2]=0;f[a+248+12>>2]=0;f[a+4>>2]=1065353216;f[a+8>>2]=0;f[a+8+4>>2]=0;f[a+8+8>>2]=0;f[a+8+12>>2]=0;f[a+24>>2]=1065353216;f[a+28>>2]=0;f[a+28+4>>2]=0;f[a+28+8>>2]=0;f[a+28+12>>2]=0;f[a+44>>2]=1065353216;f[a+48>>2]=0;f[a+48+4>>2]=0;f[a+48+8>>2]=0;f[a+48+12>>2]=0;f[a+48+16>>2]=0;f[a>>2]=4252;b[a+500>>0]=1;f[a+496>>2]=0;f[a+488>>2]=0;f[a+492>>2]=0;n[h>>2]=c;f[h+4>>2]=d;f[h+72>>2]=e;f[h+76>>2]=f[g>>2];f[h+76+4>>2]=f[g+4>>2];f[h+76+8>>2]=f[g+8>>2];f[h+76+12>>2]=f[g+12>>2];n[h+92>>2]=0.0;n[h+96>>2]=0.0;n[h+100>>2]=.5;n[h+104>>2]=0.0;n[h+108>>2]=0.0;n[h+112>>2]=.800000011920929;n[h+116>>2]=1.0;b[h+120>>0]=0;n[h+124>>2]=.004999999888241291;n[h+128>>2]=.009999999776482582;n[h+132>>2]=.009999999776482582;n[h+136>>2]=.009999999776482582;f[h+8>>2]=1065353216;f[h+12>>2]=0;f[h+12+4>>2]=0;f[h+12+8>>2]=0;f[h+12+12>>2]=0;f[h+28>>2]=1065353216;f[h+32>>2]=0;f[h+32+4>>2]=0;f[h+32+8>>2]=0;f[h+32+12>>2]=0;f[h+48>>2]=1065353216;f[h+52>>2]=0;f[h+52+4>>2]=0;f[h+52+8>>2]=0;f[h+52+12>>2]=0;f[h+52+16>>2]=0;Jd(a,h);u=h;return}function rg(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;Wd(a,c);f[a>>2]=3212;f[6472]=(f[6472]|0)+1;d=sc(27)|0;i=d+4+15&-16;f[i+-4>>2]=d;b[i+4>>0]=0;f[(d+4+15&-16)>>2]=3244;f[a+92>>2]=i;f[6472]=(f[6472]|0)+1;i=sc(27)|0;d=i+4+15&-16;f[d+-4>>2]=i;b[d+4>>0]=0;f[(i+4+15&-16)>>2]=3264;f[a+96>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=3264;f[a+100>>2]=d;b[d+4>>0]=1;f[6472]=(f[6472]|0)+1;i=sc(27)|0;d=i+4+15&-16;f[d+-4>>2]=i;b[d+4>>0]=0;f[(i+4+15&-16)>>2]=3284;f[a+104>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=3304;f[a+108>>2]=d;b[d+4>>0]=1;if(!(b[a+20>>0]|0))return;d=f[a+16>>2]|0;if(!d)return;if((f[d>>2]|0)>=156)return;e=f[d+16>>2]|0;if(e){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);d=f[a+16>>2]|0;if(!d)i=a+16|0;else{e=a+16|0;g=11}}else{e=a+16|0;g=11}if((g|0)==11){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);i=e}f[6472]=(f[6472]|0)+1;d=sc(39)|0;if(!d)h=0;else{f[(d+4+15&-16)+-4>>2]=d;h=d+4+15&-16}d=f[c+12>>2]|0;f[h>>2]=156;e=h+4|0;f[e>>2]=d;f[6472]=(f[6472]|0)+1;d=sc((d*156|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[h+16>>2]=d;f[h+12>>2]=d;a=f[e>>2]|0;f[h+8>>2]=a;if(a+-1|0){g=f[h>>2]|0;e=d;c=a+-1|0;do{j=e;e=e+g|0;f[j>>2]=e;c=c+-1|0}while((c|0)!=0);d=d+(X(g,a+-1|0)|0)|0}f[d>>2]=0;f[i>>2]=h;return}function sg(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=+e;g=+g;h=+h;i=i|0;j=j|0;k=k|0;var l=0,m=0.0,o=0.0,p=0.0,q=0.0;l=Es()|0;f[l+8>>2]=0;n[l+12>>2]=0.0;f[l>>2]=8252;f[l+4>>2]=24;f[l+64>>2]=a;f[l+68>>2]=c;n[l+72>>2]=g;n[l+76>>2]=h;n[l+80>>2]=+(a+-1|0);n[l+84>>2]=+(c+-1|0);n[l+88>>2]=e;f[l+92>>2]=d;f[l+96>>2]=j;b[l+100>>0]=k&1;b[l+101>>0]=0;b[l+102>>0]=0;f[l+104>>2]=i;f[l+108>>2]=1065353216;f[l+112>>2]=1065353216;f[l+116>>2]=1065353216;n[l+120>>2]=0.0;switch(i|0){case 0:{n[l+16>>2]=g;f[l+20>>2]=0;a=l+84|0;c=l+80|0;d=l+76|0;e=0.0;h=0.0;break}case 1:{f[l+16>>2]=0;n[l+20>>2]=g;a=l+84|0;c=l+76|0;d=l+80|0;e=0.0;h=g;g=0.0;break}case 2:{f[l+16>>2]=0;f[l+20>>2]=0;a=l+76|0;c=l+84|0;d=l+80|0;e=g;h=0.0;g=0.0;break}default:{g=+n[l+16>>2];p=+n[l+32>>2];e=+n[l+20>>2];o=+n[l+36>>2];h=+n[l+24>>2];m=+n[l+40>>2];g=p+g;e=o+e;h=m+h;g=g*.5;e=e*.5;h=h*.5;k=l+48|0;n[k>>2]=g;k=l+52|0;n[k>>2]=e;k=l+56|0;n[k>>2]=h;k=l+60|0;n[k>>2]=0.0;return l|0}}n[l+24>>2]=e;n[l+28>>2]=0.0;i=f[d>>2]|0;f[l+32>>2]=i;j=f[c>>2]|0;f[l+36>>2]=j;k=f[a>>2]|0;f[l+40>>2]=k;n[l+44>>2]=0.0;q=(f[s>>2]=i,+n[s>>2]);p=(f[s>>2]=j,+n[s>>2]);m=g;o=h;g=p;p=e;h=(f[s>>2]=k,+n[s>>2]);m=q+m;o=g+o;p=h+p;m=m*.5;o=o*.5;p=p*.5;k=l+48|0;n[k>>2]=m;k=l+52|0;n[k>>2]=o;k=l+56|0;n[k>>2]=p;k=l+60|0;n[k>>2]=0.0;return l|0}function tg(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=f[c>>2]|0;l=Db[f[(f[l>>2]|0)+56>>2]&31](l,48)|0;f[l+4>>2]=f[c>>2];f[l>>2]=6420;b[l+28>>0]=1;f[l+24>>2]=0;f[l+16>>2]=0;f[l+20>>2]=0;f[l+32>>2]=f[c+4>>2];b[l+36>>0]=0;f[6472]=(f[6472]|0)+1;a=sc(87)|0;if(!a)h=0;else{f[(a+4+15&-16)+-4>>2]=a;h=a+4+15&-16}f[h>>2]=9516;i=h+20|0;b[i>>0]=1;j=h+16|0;f[j>>2]=0;c=h+8|0;f[c>>2]=0;k=h+12|0;f[k>>2]=0;b[h+24>>0]=0;b[h+44>>0]=1;f[h+40>>2]=0;f[h+32>>2]=0;f[h+36>>2]=0;b[h+64>>0]=1;f[h+60>>2]=0;f[h+52>>2]=0;f[h+56>>2]=0;f[6472]=(f[6472]|0)+1;a=sc(43)|0;if(!a)g=0;else{f[(a+4+15&-16)+-4>>2]=a;g=a+4+15&-16}c=f[c>>2]|0;if((c|0)>0){a=0;do{m=g+(a*12|0)|0;n=(f[j>>2]|0)+(a*12|0)|0;f[m>>2]=f[n>>2];f[m+4>>2]=f[n+4>>2];f[m+8>>2]=f[n+8>>2];a=a+1|0}while((a|0)!=(c|0))}a=f[j>>2]|0;if(!a){b[i>>0]=1;f[j>>2]=g;f[k>>2]=2;Lf(h);n=l+8|0;f[n>>2]=h;n=d+4|0;n=f[n>>2]|0;n=n+68|0;n=f[n>>2]|0;m=l+40|0;f[m>>2]=n;m=e+4|0;m=f[m>>2]|0;m=m+68|0;m=f[m>>2]|0;n=l+44|0;f[n>>2]=m;return l|0}if(b[i>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[a+-4>>2]|0)}f[j>>2]=0;b[i>>0]=1;f[j>>2]=g;f[k>>2]=2;Lf(h);n=l+8|0;f[n>>2]=h;n=d+4|0;n=f[n>>2]|0;n=n+68|0;n=f[n>>2]|0;m=l+40|0;f[m>>2]=n;m=e+4|0;m=f[m>>2]|0;m=m+68|0;m=f[m>>2]|0;n=l+44|0;f[n>>2]=m;return l|0}function ug(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;Lb[f[(f[b>>2]|0)+32>>2]&511](b);d=Fb[f[(f[b>>2]|0)+16>>2]&63](b,104,1)|0;c=f[d+8>>2]|0;e=c;g=e+104|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(g|0));f[c+88>>2]=f[a+248>>2];f[c+92>>2]=f[a+252>>2];f[c+96>>2]=f[a+256>>2];f[c+100>>2]=f[a+260>>2];f[c>>2]=f[a+92>>2];f[c+4>>2]=f[a+96>>2];f[c+8>>2]=f[a+100>>2];f[c+12>>2]=f[a+104>>2];f[c+16>>2]=f[a+108>>2];f[c+20>>2]=f[a+116>>2];f[c+24>>2]=f[a+120>>2];f[c+28>>2]=f[a+124>>2];f[c+32>>2]=f[a+128>>2];f[c+36>>2]=f[a+132>>2];f[c+40>>2]=f[a+140>>2];f[c+44>>2]=f[a+144>>2];f[c+48>>2]=f[a+148>>2];f[c+52>>2]=f[a+152>>2];f[c+56>>2]=f[a+168>>2];f[c+60>>2]=f[a+172>>2];f[c+64>>2]=f[a+112>>2];f[c+68>>2]=f[a+156>>2];f[c+72>>2]=f[a+160>>2];f[c+76>>2]=f[a+164>>2];f[c+80>>2]=f[a+136>>2];ac[f[(f[b>>2]|0)+20>>2]&31](b,d,12441,1145853764,c);c=f[a+8>>2]|0;if((c|0)<=0){hj(a,b);ud(a,b);a=f[b>>2]|0;a=a+36|0;a=f[a>>2]|0;Lb[a&511](b);return}e=0;do{d=f[(f[a+16>>2]|0)+(e<<2)>>2]|0;if(f[d+236>>2]&8){g=Bb[f[(f[d>>2]|0)+16>>2]&127](d)|0;g=Fb[f[(f[b>>2]|0)+16>>2]&63](b,g,1)|0;c=Fb[f[(f[d>>2]|0)+20>>2]&63](d,f[g+8>>2]|0,b)|0;ac[f[(f[b>>2]|0)+20>>2]&31](b,g,c,1497645651,d);c=f[a+8>>2]|0}e=e+1|0}while((e|0)<(c|0));hj(a,b);ud(a,b);a=f[b>>2]|0;a=a+36|0;a=f[a>>2]|0;Lb[a&511](b);return}function vg(a,b){a=a|0;b=+b;var c=0,d=0,e=0,g=0,h=0.0,i=0.0,j=0.0;g=u;u=u+32|0;c=f[a+8>>2]|0;if((c|0)<=0){u=g;return}e=0;do{d=f[(f[a+16>>2]|0)+(e<<2)>>2]|0;if((!((d|0)==0?1:(f[d+236>>2]&2|0)==0)?(f[d+216>>2]|0)!=2:0)?!(b==0.0?1:(f[d+204>>2]&2|0)==0):0){c=f[d+480>>2]|0;if(!c)c=d+4|0;else{Rb[f[(f[c>>2]|0)+8>>2]&127](c,d+4|0);c=d+4|0}i=1.0/b*(+n[d+56>>2]-+n[d+120>>2]);j=1.0/b*(+n[d+60>>2]-+n[d+124>>2]);n[d+312>>2]=1.0/b*(+n[d+52>>2]-+n[d+116>>2]);n[d+316>>2]=i;n[d+320>>2]=j;n[d+324>>2]=0.0;Ef(d+68|0,c,g+8|0,g);j=+n[g>>2];i=1.0/b*j*+n[g+8+4>>2];h=1.0/b*j*+n[g+8+8>>2];n[d+328>>2]=1.0/b*+n[g+8>>2]*j;n[d+332>>2]=i;n[d+336>>2]=h;n[d+340>>2]=0.0;f[d+132>>2]=f[d+312>>2];f[d+132+4>>2]=f[d+312+4>>2];f[d+132+8>>2]=f[d+312+8>>2];f[d+132+12>>2]=f[d+312+12>>2];f[d+148>>2]=f[d+328>>2];f[d+148+4>>2]=f[d+328+4>>2];f[d+148+8>>2]=f[d+328+8>>2];f[d+148+12>>2]=f[d+328+12>>2];f[d+68>>2]=f[c>>2];f[d+68+4>>2]=f[c+4>>2];f[d+68+8>>2]=f[c+8>>2];f[d+68+12>>2]=f[c+12>>2];f[d+84>>2]=f[d+20>>2];f[d+84+4>>2]=f[d+20+4>>2];f[d+84+8>>2]=f[d+20+8>>2];f[d+84+12>>2]=f[d+20+12>>2];f[d+100>>2]=f[d+36>>2];f[d+100+4>>2]=f[d+36+4>>2];f[d+100+8>>2]=f[d+36+8>>2];f[d+100+12>>2]=f[d+36+12>>2];f[d+116>>2]=f[d+52>>2];f[d+116+4>>2]=f[d+52+4>>2];f[d+116+8>>2]=f[d+52+8>>2];f[d+116+12>>2]=f[d+52+12>>2];c=f[a+8>>2]|0}e=e+1|0}while((e|0)<(c|0));u=g;return}function wg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0;s=u;u=u+32|0;r=f[a+12>>2]|0;if(!r){u=s;return}f[e+4>>2]=r;a=f[b+4>>2]|0;d=f[c+4>>2]|0;b=f[b+12>>2]|0;c=f[c+12>>2]|0;k=+n[c+48>>2];g=+n[b+48>>2]-k;l=+n[c+52>>2];h=+n[b+52>>2]-l;m=+n[c+56>>2];j=+n[b+56>>2]-m;o=+L(+(g*g+h*h+j*j));p=+n[d+28>>2]*+n[d+12>>2];q=+n[a+28>>2]*+n[a+12>>2]+p;if(o>q){if(!(f[r+748>>2]|0)){u=s;return}d=f[r+740>>2]|0;a=f[(f[e+8>>2]|0)+8>>2]|0;if((d|0)==(a|0)){df(r,d+4|0,(f[(f[e+12>>2]|0)+8>>2]|0)+4|0);u=s;return}else{df(r,(f[(f[e+12>>2]|0)+8>>2]|0)+4|0,a+4|0);u=s;return}}f[s+16>>2]=1065353216;f[s+16+4>>2]=0;f[s+16+8>>2]=0;n[s+16+12>>2]=0.0;if(o>1.1920928955078125e-07){n[s+16>>2]=g*(1.0/o);n[s+16+4>>2]=h*(1.0/o);n[s+16+8>>2]=j*(1.0/o);n[s+16+12>>2]=0.0;i=g*(1.0/o);h=h*(1.0/o);g=j*(1.0/o)}else{i=1.0;h=0.0;g=0.0}n[s>>2]=p*i+k;n[s+4>>2]=p*h+l;n[s+8>>2]=p*g+m;n[s+12>>2]=0.0;Wb[f[(f[e>>2]|0)+16>>2]&15](e,s+16|0,s,o-q);b=f[e+4>>2]|0;do if(f[b+748>>2]|0){d=f[b+740>>2]|0;a=f[(f[e+8>>2]|0)+8>>2]|0;if((d|0)==(a|0)){df(b,d+4|0,(f[(f[e+12>>2]|0)+8>>2]|0)+4|0);break}else{df(b,(f[(f[e+12>>2]|0)+8>>2]|0)+4|0,a+4|0);break}}while(0);u=s;return}function xg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;c=f[b+236>>2]|0;if((b|0)==0|(c|0)!=8){if(!((b|0)==0|(c&2|0)==0)){Rb[f[(f[a>>2]|0)+92>>2]&127](a,b);return}c=f[b+188>>2]|0;if(c|0){h=f[a+68>>2]|0;h=Bb[f[(f[h>>2]|0)+36>>2]&127](h)|0;Vb[f[(f[h>>2]|0)+40>>2]&127](h,c,f[a+24>>2]|0);h=f[a+68>>2]|0;Vb[f[(f[h>>2]|0)+12>>2]&127](h,c,f[a+24>>2]|0);f[b+188>>2]=0}d=f[a+8>>2]|0;if((d|0)<=0)return;e=f[a+16>>2]|0;c=0;while(1){g=e+(c<<2)|0;if((f[g>>2]|0)==(b|0))break;h=c+1|0;if((h|0)<(d|0))c=h;else{i=26;break}}if((i|0)==26)return;if((c|0)>=(d|0))return;f[g>>2]=f[e+(d+-1<<2)>>2];f[(f[a+16>>2]|0)+(d+-1<<2)>>2]=b;f[a+8>>2]=d+-1;return}g=f[a+328>>2]|0;a:do if((g|0)>0){e=f[a+336>>2]|0;c=0;while(1){d=e+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(g|0))break a}if((c|0)<(g|0)){f[d>>2]=f[e+(g+-1<<2)>>2];f[(f[a+336>>2]|0)+(g+-1<<2)>>2]=b;f[a+328>>2]=g+-1}}while(0);c=f[b+188>>2]|0;if(c|0){h=f[a+68>>2]|0;h=Bb[f[(f[h>>2]|0)+36>>2]&127](h)|0;Vb[f[(f[h>>2]|0)+40>>2]&127](h,c,f[a+24>>2]|0);h=f[a+68>>2]|0;Vb[f[(f[h>>2]|0)+12>>2]&127](h,c,f[a+24>>2]|0);f[b+188>>2]=0}d=f[a+8>>2]|0;if((d|0)<=0)return;e=f[a+16>>2]|0;c=0;while(1){g=e+(c<<2)|0;if((f[g>>2]|0)==(b|0))break;h=c+1|0;if((h|0)<(d|0))c=h;else{i=26;break}}if((i|0)==26)return;if((c|0)>=(d|0))return;f[g>>2]=f[e+(d+-1<<2)>>2];f[(f[a+16>>2]|0)+(d+-1<<2)>>2]=b;f[a+8>>2]=d+-1;return}function yg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0,y=0.0;x=u;u=u+48|0;t=+n[d>>2];v=+n[c>>2];w=+n[d+4>>2];s=+n[c+4>>2];r=+n[d+8>>2];l=+n[c+8>>2];m=+L(+((t-v)*.5*(t-v)*.5+(w-s)*.5*(w-s)*.5+(r-l)*.5*(r-l)*.5));o=+n[a+56>>2];if(+K(+o)>.7071067690849304){q=+n[a+52>>2];k=1.0/+L(+(o*o+q*q));p=+n[a+48>>2];e=p*-(o*k);g=(o*o+q*q)*k;h=0.0;i=-(p*q*k);j=-(o*k);k=q*k}else{p=+n[a+48>>2];q=+n[a+52>>2];j=1.0/+L(+(p*p+q*q));e=(p*p+q*q)*j;g=-(o*p*j);h=-(q*j);i=o*-(q*j);j=p*j;k=0.0}y=(t+v)*.5*p+(w+s)*.5*q+(r+l)*.5*o-+n[a+64>>2];s=(w+s)*.5-q*y;p=(t+v)*.5-p*y;h=m*h;t=m*j;w=m*k;k=m*g;q=m*i;v=m*e;n[x>>2]=k+(h+p);n[x+4>>2]=q+(t+s);n[x+8>>2]=v+(w+((r+l)*.5-o*y));n[x+12>>2]=0.0;n[x+16>>2]=h+p-k;n[x+20>>2]=t+s-q;n[x+24>>2]=w+((r+l)*.5-o*y)-v;n[x+28>>2]=0.0;n[x+32>>2]=p-h-k;n[x+36>>2]=s-t-q;n[x+40>>2]=(r+l)*.5-o*y-w-v;n[x+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,x,0,0);n[x>>2]=p-h-k;n[x+4>>2]=s-t-q;n[x+8>>2]=(r+l)*.5-o*y-w-v;n[x+12>>2]=0.0;n[x+16>>2]=k+(p-h);n[x+20>>2]=q+(s-t);n[x+24>>2]=v+((r+l)*.5-o*y-w);n[x+28>>2]=0.0;n[x+32>>2]=k+(h+p);n[x+36>>2]=q+(t+s);n[x+40>>2]=v+(w+((r+l)*.5-o*y));n[x+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,x,0,1);u=x;return}function zg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0,t=0,u=0,v=0,w=0;if((f[a>>2]|0)==(b|0)){f[a>>2]=0;a=0;return a|0}d=f[b+32>>2]|0;c=f[d+32>>2]|0;b=f[d+36+(((f[d+40>>2]|0)!=(b|0)&1)<<2)>>2]|0;a:do if(!c){f[a>>2]=b;f[b+32>>2]=0;c=f[a+4>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+4>>2]=d}else{f[c+36+(((f[c+40>>2]|0)==(d|0)&1)<<2)>>2]=b;f[b+32>>2]=c;b=f[a+4>>2]|0;if(b|0){f[6473]=(f[6473]|0)+1;Cd(f[b+-4>>2]|0)}f[a+4>>2]=d;while(1){l=+n[c>>2];q=c+4|0;o=+n[q>>2];w=c+8|0;m=+n[w>>2];d=c+16|0;k=+n[d>>2];t=c+20|0;i=+n[t>>2];u=c+24|0;g=+n[u>>2];v=f[c+36>>2]|0;p=f[c+40>>2]|0;b=f[(+n[v>>2]<+n[p>>2]?v:p)>>2]|0;f[c>>2]=b;r=f[(+n[v+16>>2]>+n[p+16>>2]?v+16|0:p+16|0)>>2]|0;f[d>>2]=r;d=f[(+n[v+4>>2]<+n[p+4>>2]?v:p)+4>>2]|0;f[q>>2]=d;q=f[(+n[v+20>>2]>+n[p+20>>2]?v+16|0:p+16|0)+4>>2]|0;f[t>>2]=q;t=f[(+n[v+8>>2]<+n[p+8>>2]?v:p)+8>>2]|0;f[w>>2]=t;p=f[(+n[v+24>>2]>+n[p+24>>2]?v+16|0:p+16|0)+8>>2]|0;f[u>>2]=p;b=l!=(f[s>>2]=b,+n[s>>2]);l=(f[s>>2]=t,+n[s>>2]);j=(f[s>>2]=r,+n[s>>2]);h=(f[s>>2]=q,+n[s>>2]);e=(f[s>>2]=p,+n[s>>2]);if(!(b|o!=(f[s>>2]=d,+n[s>>2])|m!=l|k!=j|i!=h|g!=e))break;c=f[c+32>>2]|0;if(!c)break a}return c|0}while(0);w=f[a>>2]|0;return w|0}function Ag(a,b,c){a=a|0;b=+b;c=+c;var d=0,e=0,g=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;g=u;u=u+16|0;c=+n[a+336>>2]*b;b=+n[a+452>>2];e=f[a+792>>2]|0;if((e|0)<=0){u=g;return}d=0;do{s=f[a+800>>2]|0;i=s+(d*96|0)+20|0;w=f[i>>2]|0;m=f[s+(d*96|0)>>2]|0;z=+n[s+(d*96|0)+4>>2];y=+n[s+(d*96|0)+8>>2];x=+n[s+(d*96|0)+12>>2];h=s+(d*96|0)+76|0;v=+n[w+332>>2];p=+n[s+(d*96|0)+84>>2];A=+n[w+336>>2];k=+n[s+(d*96|0)+80>>2];j=+n[h>>2];l=+n[w+328>>2];r=+n[m+8>>2];q=+n[m+12>>2];o=+n[m+16>>2];t=c*(z*+n[w+4>>2]+y*+n[w+8>>2]+x*+n[w+12>>2]+ +n[w+52>>2]-r)+(b*(v*p-A*k+ +n[w+312>>2])-(r-+n[m+24>>2]));p=c*(z*+n[w+20>>2]+y*+n[w+24>>2]+x*+n[w+28>>2]+ +n[w+56>>2]-q)+(b*(+n[w+316>>2]+(A*j-p*l))-(q-+n[m+28>>2]));j=c*(z*+n[w+36>>2]+y*+n[w+40>>2]+x*+n[w+44>>2]+ +n[w+60>>2]-o)+(b*(k*l-v*j+ +n[w+320>>2])-(o-+n[m+32>>2]));v=+n[s+(d*96|0)+24>>2];l=(t*+n[s+(d*96|0)+28>>2]+p*+n[s+(d*96|0)+32>>2]+ +n[s+(d*96|0)+36>>2]*j)*v;k=(t*+n[s+(d*96|0)+44>>2]+p*+n[s+(d*96|0)+48>>2]+j*+n[s+(d*96|0)+52>>2])*v;j=v*(t*+n[s+(d*96|0)+60>>2]+p*+n[s+(d*96|0)+64>>2]+j*+n[s+(d*96|0)+68>>2]);p=+n[s+(d*96|0)+92>>2];n[m+8>>2]=r+l*p;n[m+12>>2]=p*k+q;n[m+16>>2]=p*j+o;i=f[i>>2]|0;n[g>>2]=-l;n[g+4>>2]=-k;n[g+8>>2]=-j;n[g+12>>2]=0.0;ll(i,g,h);d=d+1|0}while((d|0)!=(e|0));u=g;return}function Bg(a,c,d,e){a=a|0;c=+c;d=d|0;e=+e;var g=0,h=0.0,i=0,j=0;j=u;u=u+16|0;gb(f[6471]|0,0)|0;Cr(25844);f[6462]=(f[6462]|0)+1;i=f[6465]|0;f[6465]=i+1;if(!i){gb(j|0,0)|0;i=f[6471]|0;f[6464]=(f[j+4>>2]|0)-(f[i+4>>2]|0)+(((f[j>>2]|0)-(f[i>>2]|0)|0)*1e6|0)}f[6470]=0;gb(j|0,0)|0;uj(12426);if(d){n[a+268>>2]=e;h=+n[a+264>>2]+c;n[a+264>>2]=h;if(!(h>=e)){c=e;i=0}else{n[a+264>>2]=h-+(~~(h/e)|0)*e;c=e;i=~~(h/e)}}else{n[a+264>>2]=b[a+300>>0]|0?0.0:c;n[a+268>>2]=0.0;i=!(+K(+c)<1.1920928955078125e-07)&1;d=i}if(Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0){g=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;g=(Bb[f[(f[g>>2]|0)+48>>2]&127](g)|0)>>>4&1;b[26472]=g}if(i){g=(i|0)>(d|0)?d:i;Mb[f[(f[a>>2]|0)+164>>2]&31](a,c*+(g|0));Lb[f[(f[a>>2]|0)+168>>2]&511](a);if((g|0)>0){d=0;do{Mb[f[(f[a>>2]|0)+160>>2]&31](a,c);Lb[f[(f[a>>2]|0)+80>>2]&511](a);d=d+1|0}while((d|0)<(g|0));d=a}else d=a}else{Lb[f[(f[a>>2]|0)+80>>2]&511](a);d=a}Lb[f[(f[d>>2]|0)+120>>2]&511](a);f[6470]=(f[6470]|0)+1;d=f[2405]|0;a=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=a;if(a|0){u=j;return i|0}do if(f[d+4>>2]|0){gb(j|0,0)|0;a=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[j+4>>2]|0)-(f[a+4>>2]|0)+(((f[j>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[d+16>>2]|0)){d=f[2405]|0;break}else{u=j;return i|0}}while(0);f[2405]=f[d+20>>2];u=j;return i|0}function Cg(a){a=a|0;var b=0,c=0,d=0.0,e=0.0,g=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,o=0,p=0.0;c=f[a+712>>2]|0;if((c|0)>0){b=0;do{k=(f[a+720>>2]|0)+(b*104|0)+72|0;b=b+1|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0}while((b|0)!=(c|0))}c=f[a+752>>2]|0;if((c|0)>0){b=0;do{o=f[a+760>>2]|0;i=f[o+(b*44|0)+12>>2]|0;g=f[o+(b*44|0)+8>>2]|0;j=+n[g+8>>2];d=+n[i+8>>2]-j;e=+n[g+12>>2];h=+n[i+12>>2]-e;l=+n[g+16>>2];m=+n[i+16>>2]-l;k=f[o+(b*44|0)+16>>2]|0;j=+n[k+8>>2]-j;e=+n[k+12>>2]-e;l=+n[k+16>>2]-l;p=1.0/+L(+((d*e-h*j)*(d*e-h*j)+((h*l-m*e)*(h*l-m*e)+(m*j-d*l)*(m*j-d*l))));n[o+(b*44|0)+20>>2]=p*(h*l-m*e);n[o+(b*44|0)+24>>2]=p*(m*j-d*l);n[o+(b*44|0)+28>>2]=(d*e-h*j)*p;f[o+(b*44|0)+32>>2]=0;n[g+72>>2]=h*l-m*e+ +n[g+72>>2];n[g+76>>2]=m*j-d*l+ +n[g+76>>2];n[g+80>>2]=d*e-h*j+ +n[g+80>>2];n[i+72>>2]=h*l-m*e+ +n[i+72>>2];n[i+76>>2]=m*j-d*l+ +n[i+76>>2];n[i+80>>2]=d*e-h*j+ +n[i+80>>2];n[k+72>>2]=h*l-m*e+ +n[k+72>>2];n[k+76>>2]=m*j-d*l+ +n[k+76>>2];n[k+80>>2]=d*e-h*j+ +n[k+80>>2];b=b+1|0}while((b|0)!=(c|0))}k=f[a+712>>2]|0;if((k|0)<=0)return;a=f[a+720>>2]|0;b=0;do{g=a+(b*104|0)+72|0;h=+n[g>>2];i=a+(b*104|0)+76|0;j=+n[i>>2];c=a+(b*104|0)+80|0;d=+n[c>>2];e=+L(+(h*h+j*j+d*d));if(e>1.1920928955078125e-07){n[g>>2]=h*(1.0/e);n[i>>2]=1.0/e*j;n[c>>2]=1.0/e*d}b=b+1|0}while((b|0)!=(k|0));return}function Dg(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;g=Ms()|0;f[g+4>>2]=5;f[g+8>>2]=-1;f[g+12>>2]=-1;n[g+16>>2]=3402823466385288598117041.0e14;b[g+20>>0]=1;b[g+21>>0]=0;f[g+24>>2]=-1;f[g+28>>2]=a;f[g+32>>2]=c;n[g+36>>2]=0.0;n[g+40>>2]=.30000001192092896;f[g+44>>2]=0;f[g>>2]=4844;f[g+300>>2]=f[d>>2];f[g+300+4>>2]=f[d+4>>2];f[g+300+8>>2]=f[d+8>>2];f[g+300+12>>2]=f[d+12>>2];f[g+316>>2]=f[d+16>>2];f[g+316+4>>2]=f[d+16+4>>2];f[g+316+8>>2]=f[d+16+8>>2];f[g+316+12>>2]=f[d+16+12>>2];f[g+332>>2]=f[d+32>>2];f[g+332+4>>2]=f[d+32+4>>2];f[g+332+8>>2]=f[d+32+8>>2];f[g+332+12>>2]=f[d+32+12>>2];f[g+348>>2]=f[d+48>>2];f[g+348+4>>2]=f[d+48+4>>2];f[g+348+8>>2]=f[d+48+8>>2];f[g+348+12>>2]=f[d+48+12>>2];f[g+364>>2]=f[e>>2];f[g+364+4>>2]=f[e+4>>2];f[g+364+8>>2]=f[e+8>>2];f[g+364+12>>2]=f[e+12>>2];f[g+380>>2]=f[e+16>>2];f[g+380+4>>2]=f[e+16+4>>2];f[g+380+8>>2]=f[e+16+8>>2];f[g+380+12>>2]=f[e+16+12>>2];f[g+396>>2]=f[e+32>>2];f[g+396+4>>2]=f[e+32+4>>2];f[g+396+8>>2]=f[e+32+8>>2];f[g+396+12>>2]=f[e+32+12>>2];f[g+412>>2]=f[e+48>>2];f[g+412+4>>2]=f[e+48+4>>2];f[g+412+8>>2]=f[e+48+8>>2];f[g+412+12>>2]=f[e+48+12>>2];b[g+552>>0]=0;f[g+524>>2]=0;n[g+572>>2]=-1.0;n[g+444>>2]=999999984306749440.0;n[g+448>>2]=999999984306749440.0;n[g+452>>2]=999999984306749440.0;n[g+428>>2]=1.0;n[g+432>>2]=.30000001192092896;n[g+436>>2]=1.0;n[g+440>>2]=.009999999776482582;n[g+456>>2]=.05000000074505806;f[g+592>>2]=0;n[g+596>>2]=0.0;n[g+600>>2]=.699999988079071;n[g+604>>2]=0.0;return g|0}function Eg(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0.0,j=0.0,k=0,l=0.0;k=u;u=u+672|0;f[k+568+8>>2]=0;f[k+568+12>>2]=1065353216;f[k+568+16>>2]=1065353216;f[k+568+20>>2]=1065353216;n[k+568+24>>2]=0.0;f[k+568+52>>2]=0;f[k+568>>2]=3860;f[k+568+4>>2]=1;f[k+568+56>>2]=f[c>>2];f[k+568+56+4>>2]=f[c+4>>2];f[k+568+56+8>>2]=f[c+8>>2];f[k+568+56+12>>2]=f[c+12>>2];f[k+568+72>>2]=f[c+16>>2];f[k+568+72+4>>2]=f[c+16+4>>2];f[k+568+72+8>>2]=f[c+16+8>>2];f[k+568+72+12>>2]=f[c+16+12>>2];f[k+568+88>>2]=f[c+32>>2];f[k+568+88+4>>2]=f[c+32+4>>2];f[k+568+88+8>>2]=f[c+32+8>>2];f[k+568+88+12>>2]=f[c+32+12>>2];f[k+568+44>>2]=f[a+204>>2];n[k+208+308>>2]=9.999999747378752e-05;b[k+208+332>>0]=0;f[k+200>>2]=9312;c=f[a+4>>2]|0;f[k+176>>2]=9380;f[k+176+4>>2]=k+208;f[k+176+8>>2]=k+200;f[k+176+12>>2]=c;f[k+176+16>>2]=k+568;f[k+176+20>>2]=0;f[k>>2]=3832;f[k+168>>2]=0;n[k+164>>2]=1.0;f[k+172>>2]=f[a+208>>2];if((Ud(k+176|0,a+8|0,a+72|0,a+136|0,a+136|0,k)|0?(g=+n[k+132>>2],h=+n[k+136>>2],i=+n[k+140>>2],g*g+h*h+i*i>9.999999747378752e-05):0)?(j=+n[k+164>>2],j<+n[a+200>>2]):0){l=1.0/+L(+(g*g+h*h+i*i));n[k+132>>2]=g*l;n[k+136>>2]=h*l;n[k+140>>2]=i*l;+vb[f[(f[a>>2]|0)+12>>2]&3](a,k+132|0,k+148|0,j,d,e)}f[k+568>>2]=7316;a=f[k+568+52>>2]|0;if(!a){u=k;return}Lb[f[f[a>>2]>>2]&511](a);a=f[k+568+52>>2]|0;if(!a){u=k;return}f[6473]=(f[6473]|0)+1;Cd(f[a+-4>>2]|0);u=k;return}function Fg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+n[c+128>>2];if(!(d!=0.0))return;f[6008]=(f[6008]|0)+1;j=+n[c+96>>2];e=+n[c+16>>2];g=+n[c+20>>2];h=+n[c+24>>2];i=+n[c+108>>2];i=d-j*+n[c+116>>2]-(e*+n[a+144>>2]+g*+n[a+148>>2]+h*+n[a+152>>2]+(+n[c>>2]*+n[a+160>>2]+ +n[c+4>>2]*+n[a+164>>2]+ +n[c+8>>2]*+n[a+168>>2]))*i-i*(+n[c+48>>2]*+n[b+144>>2]+ +n[c+52>>2]*+n[b+148>>2]+ +n[c+56>>2]*+n[b+152>>2]+(+n[c+32>>2]*+n[b+160>>2]+ +n[c+36>>2]*+n[b+164>>2]+ +n[c+40>>2]*+n[b+168>>2]));k=+n[c+120>>2];d=j+i<k?k-j:i;n[c+96>>2]=j+i<k?k:j+i;if(f[a+240>>2]|0){k=d*g*+n[a+132>>2]*+n[a+116>>2];j=d*h*+n[a+136>>2]*+n[a+120>>2];n[a+144>>2]=+n[a+112>>2]*d*e*+n[a+128>>2]+ +n[a+144>>2];n[a+148>>2]=k+ +n[a+148>>2];n[a+152>>2]=j+ +n[a+152>>2];j=d*+n[a+100>>2]*+n[c+68>>2];k=d*+n[a+104>>2]*+n[c+72>>2];n[a+160>>2]=d*+n[a+96>>2]*+n[c+64>>2]+ +n[a+160>>2];n[a+164>>2]=j+ +n[a+164>>2];n[a+168>>2]=k+ +n[a+168>>2]}if(!(f[b+240>>2]|0))return;k=d*+n[c+52>>2]*+n[b+132>>2]*+n[b+116>>2];j=d*+n[c+56>>2]*+n[b+136>>2]*+n[b+120>>2];n[b+144>>2]=+n[b+112>>2]*d*+n[c+48>>2]*+n[b+128>>2]+ +n[b+144>>2];n[b+148>>2]=k+ +n[b+148>>2];n[b+152>>2]=j+ +n[b+152>>2];j=d*+n[b+100>>2]*+n[c+84>>2];k=d*+n[b+104>>2]*+n[c+88>>2];n[b+160>>2]=d*+n[b+96>>2]*+n[c+80>>2]+ +n[b+160>>2];n[b+164>>2]=j+ +n[b+164>>2];n[b+168>>2]=k+ +n[b+168>>2];return}function Gg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=+n[c+100>>2];i=+n[c+16>>2];j=+n[c+20>>2];k=+n[c+24>>2];g=+n[c+108>>2];g=+n[c+112>>2]-e*+n[c+116>>2]-(i*+n[a+64>>2]+j*+n[a+68>>2]+k*+n[a+72>>2]+(+n[c>>2]*+n[a+80>>2]+ +n[c+4>>2]*+n[a+84>>2]+ +n[c+8>>2]*+n[a+88>>2]))*g-g*(+n[c+48>>2]*+n[b+64>>2]+ +n[c+52>>2]*+n[b+68>>2]+ +n[c+56>>2]*+n[b+72>>2]+(+n[c+32>>2]*+n[b+80>>2]+ +n[c+36>>2]*+n[b+84>>2]+ +n[c+40>>2]*+n[b+88>>2]));d=+n[c+120>>2];if(!(e+g<d)){d=+n[c+124>>2];if(e+g>d)h=d-e;else{h=g;d=e+g}}else h=d-e;n[c+100>>2]=d;if(f[a+240>>2]|0){g=h*j*+n[a+132>>2]*+n[a+116>>2];j=h*k*+n[a+136>>2]*+n[a+120>>2];n[a+64>>2]=+n[a+112>>2]*h*i*+n[a+128>>2]+ +n[a+64>>2];n[a+68>>2]=g+ +n[a+68>>2];n[a+72>>2]=j+ +n[a+72>>2];j=h*+n[a+100>>2]*+n[c+68>>2];k=h*+n[a+104>>2]*+n[c+72>>2];n[a+80>>2]=h*+n[a+96>>2]*+n[c+64>>2]+ +n[a+80>>2];n[a+84>>2]=j+ +n[a+84>>2];n[a+88>>2]=k+ +n[a+88>>2]}if(!(f[b+240>>2]|0))return;k=h*+n[c+52>>2]*+n[b+132>>2]*+n[b+116>>2];j=h*+n[c+56>>2]*+n[b+136>>2]*+n[b+120>>2];n[b+64>>2]=+n[b+112>>2]*h*+n[c+48>>2]*+n[b+128>>2]+ +n[b+64>>2];n[b+68>>2]=k+ +n[b+68>>2];n[b+72>>2]=j+ +n[b+72>>2];j=h*+n[b+100>>2]*+n[c+84>>2];k=h*+n[b+104>>2]*+n[c+88>>2];n[b+80>>2]=h*+n[b+96>>2]*+n[c+80>>2]+ +n[b+80>>2];n[b+84>>2]=j+ +n[b+84>>2];n[b+88>>2]=k+ +n[b+88>>2];return}function Hg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=Db[f[(f[c>>2]|0)+40>>2]&31](c,a)|0;g=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b>>2]=g;if(g|0)Rb[f[(f[c>>2]|0)+48>>2]&127](c,d);f[b+4>>2]=f[a+4>>2];g=f[a+48>>2]|0;Fb[f[(f[g>>2]|0)+56>>2]&63](g,b+12|0,c)|0;f[b+52>>2]=f[a+12>>2];do if((f[a+52>>2]|0)!=0?((Bb[f[(f[c>>2]|0)+52>>2]&127](c)|0)&1|0)==0:0){d=Db[f[(f[c>>2]|0)+24>>2]&31](c,f[a+52>>2]|0)|0;if(!d){d=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+52>>2]|0)|0;f[b+40>>2]=d;f[b+44>>2]=0;d=f[a+52>>2]|0;d=Bb[f[(f[d>>2]|0)+12>>2]&127](d)|0;d=Fb[f[(f[c>>2]|0)+16>>2]&63](c,d,1)|0;g=f[a+52>>2]|0;g=Fb[f[(f[g>>2]|0)+16>>2]&63](g,f[d+8>>2]|0,c)|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,d,g,1213612625,f[a+52>>2]|0);break}else{f[b+40>>2]=d;f[b+44>>2]=0;break}}else e=8;while(0);if((e|0)==8){f[b+40>>2]=0;f[b+44>>2]=0}if(f[a+56>>2]|0?((Bb[f[(f[c>>2]|0)+52>>2]&127](c)|0)&2|0)==0:0){d=Db[f[(f[c>>2]|0)+24>>2]&31](c,f[a+56>>2]|0)|0;if(!d){g=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+56>>2]|0)|0;f[b+48>>2]=g;b=f[a+56>>2]|0;b=Bb[f[(f[b>>2]|0)+8>>2]&127](b)|0;b=Fb[f[(f[c>>2]|0)+16>>2]&63](c,b,1)|0;g=f[a+56>>2]|0;g=Fb[f[(f[g>>2]|0)+12>>2]&63](g,f[b+8>>2]|0,c)|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,b,g,1346456916,f[a+56>>2]|0);return 16845}else{f[b+48>>2]=d;return 16845}}f[b+48>>2]=0;return 16845}function Ig(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;h=Vs()|0;f[h+4>>2]=4;f[h+8>>2]=-1;f[h+12>>2]=-1;n[h+16>>2]=3402823466385288598117041.0e14;b[h+20>>0]=1;b[h+21>>0]=0;f[h+24>>2]=-1;f[h+28>>2]=a;f[h+32>>2]=c;n[h+36>>2]=0.0;n[h+40>>2]=.30000001192092896;f[h+44>>2]=0;f[h>>2]=4900;f[h+552>>2]=f[d>>2];f[h+552+4>>2]=f[d+4>>2];f[h+552+8>>2]=f[d+8>>2];f[h+552+12>>2]=f[d+12>>2];f[h+568>>2]=f[d+16>>2];f[h+568+4>>2]=f[d+16+4>>2];f[h+568+8>>2]=f[d+16+8>>2];f[h+568+12>>2]=f[d+16+12>>2];f[h+584>>2]=f[d+32>>2];f[h+584+4>>2]=f[d+32+4>>2];f[h+584+8>>2]=f[d+32+8>>2];f[h+584+12>>2]=f[d+32+12>>2];f[h+600>>2]=f[d+48>>2];f[h+600+4>>2]=f[d+48+4>>2];f[h+600+8>>2]=f[d+48+8>>2];f[h+600+12>>2]=f[d+48+12>>2];f[h+616>>2]=f[e>>2];f[h+616+4>>2]=f[e+4>>2];f[h+616+8>>2]=f[e+8>>2];f[h+616+12>>2]=f[e+12>>2];f[h+632>>2]=f[e+16>>2];f[h+632+4>>2]=f[e+16+4>>2];f[h+632+8>>2]=f[e+16+8>>2];f[h+632+12>>2]=f[e+16+12>>2];f[h+648>>2]=f[e+32>>2];f[h+648+4>>2]=f[e+32+4>>2];f[h+648+8>>2]=f[e+32+8>>2];f[h+648+12>>2]=f[e+32+12>>2];f[h+664>>2]=f[e+48>>2];f[h+664+4>>2]=f[e+48+4>>2];f[h+664+8>>2]=f[e+48+8>>2];f[h+664+12>>2]=f[e+48+12>>2];n[h+688>>2]=0.0;n[h+692>>2]=-1.0;n[h+696>>2]=.8999999761581421;n[h+700>>2]=.30000001192092896;n[h+704>>2]=1.0;n[h+708>>2]=0.0;n[h+712>>2]=0.0;b[h+716>>0]=0;b[h+736>>0]=0;b[h+737>>0]=0;b[h+738>>0]=0;b[h+739>>0]=1;b[h+740>>0]=g&1;f[h+748>>2]=0;n[h+732>>2]=g?-1.0:1.0;return h|0}function Jg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f[6459]=(f[6459]|0)+1;k=((d<<16|c)+~((d<<16|c)<<15)>>10^(d<<16|c)+~((d<<16|c)<<15))*9|0;k=(k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11);l=f[a+12>>2]|0;e=f[(f[a+40>>2]|0)+((l+-1&k)<<2)>>2]|0;a:do if((e|0)!=-1){h=f[a+16>>2]|0;while(1){g=h+(e*12|0)|0;if((f[g>>2]|0)==(c|0)?(f[h+(e*12|0)+4>>2]|0)==(d|0):0)break;e=f[(f[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1)break a}if(g|0){d=g;return d|0}}while(0);j=f[a+8>>2]|0;if((j|0)==(l|0)){h=l|0?l<<1:1;if((l|0)<(h|0)){if(!h){e=0;i=l}else{f[6472]=(f[6472]|0)+1;e=sc((h*12|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}i=f[a+8>>2]|0}if((i|0)>0){g=0;do{m=e+(g*12|0)|0;n=(f[a+16>>2]|0)+(g*12|0)|0;f[m>>2]=f[n>>2];f[m+4>>2]=f[n+4>>2];f[m+8>>2]=f[n+8>>2];g=g+1|0}while((g|0)!=(i|0))}g=f[a+16>>2]|0;if(g|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=e;f[a+12>>2]=h;e=f[a+8>>2]|0}else{e=l;h=l}}else{e=j;h=l}f[a+8>>2]=e+1;g=f[a+16>>2]|0;if((l|0)<(h|0)){Lf(a);e=(f[a+12>>2]|0)+-1&k}else e=l+-1&k;f[g+(j*12|0)>>2]=c;f[g+(j*12|0)+4>>2]=d;f[g+(j*12|0)+8>>2]=0;n=(f[a+40>>2]|0)+(e<<2)|0;f[(f[a+60>>2]|0)+(j<<2)>>2]=f[n>>2];f[n>>2]=j;n=g+(j*12|0)|0;return n|0}function Kg(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;g=Vs()|0;f[g+4>>2]=4;f[g+8>>2]=-1;f[g+12>>2]=-1;n[g+16>>2]=3402823466385288598117041.0e14;b[g+20>>0]=1;b[g+21>>0]=0;f[g+24>>2]=-1;f[g+28>>2]=a;f[g+32>>2]=c;n[g+36>>2]=0.0;n[g+40>>2]=.30000001192092896;f[g+44>>2]=0;f[g>>2]=4900;f[g+552>>2]=f[d>>2];f[g+552+4>>2]=f[d+4>>2];f[g+552+8>>2]=f[d+8>>2];f[g+552+12>>2]=f[d+12>>2];f[g+568>>2]=f[d+16>>2];f[g+568+4>>2]=f[d+16+4>>2];f[g+568+8>>2]=f[d+16+8>>2];f[g+568+12>>2]=f[d+16+12>>2];f[g+584>>2]=f[d+32>>2];f[g+584+4>>2]=f[d+32+4>>2];f[g+584+8>>2]=f[d+32+8>>2];f[g+584+12>>2]=f[d+32+12>>2];f[g+600>>2]=f[d+48>>2];f[g+600+4>>2]=f[d+48+4>>2];f[g+600+8>>2]=f[d+48+8>>2];f[g+600+12>>2]=f[d+48+12>>2];f[g+616>>2]=f[e>>2];f[g+616+4>>2]=f[e+4>>2];f[g+616+8>>2]=f[e+8>>2];f[g+616+12>>2]=f[e+12>>2];f[g+632>>2]=f[e+16>>2];f[g+632+4>>2]=f[e+16+4>>2];f[g+632+8>>2]=f[e+16+8>>2];f[g+632+12>>2]=f[e+16+12>>2];f[g+648>>2]=f[e+32>>2];f[g+648+4>>2]=f[e+32+4>>2];f[g+648+8>>2]=f[e+32+8>>2];f[g+648+12>>2]=f[e+32+12>>2];f[g+664>>2]=f[e+48>>2];f[g+664+4>>2]=f[e+48+4>>2];f[g+664+8>>2]=f[e+48+8>>2];f[g+664+12>>2]=f[e+48+12>>2];n[g+688>>2]=0.0;n[g+692>>2]=-1.0;n[g+696>>2]=.8999999761581421;n[g+700>>2]=.30000001192092896;n[g+704>>2]=1.0;n[g+708>>2]=0.0;n[g+712>>2]=0.0;b[g+716>>0]=0;b[g+736>>0]=0;b[g+737>>0]=0;b[g+738>>0]=0;b[g+739>>0]=1;b[g+740>>0]=0;f[g+748>>2]=0;n[g+732>>2]=1.0;return g|0}function Lg(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0,r=0;f[6472]=(f[6472]|0)+1;a=sc((g+2|0)>>>0>268435455?18:(g+2<<4|3)+16|0)|0;if(!a)i=0;else{f[(a+4+15&-16)+-4>>2]=a;i=a+4+15&-16}j=$H((g+2|0)>>>0>1073741823?-1:g+2<<2)|0;if((g|0)>-2){a=0;do{p=+(a|0)/+(g+1|0);o=+n[d>>2];m=+n[d+4>>2];m=m+p*(+n[e+4>>2]-m);l=+n[d+8>>2];l=l+p*(+n[e+8>>2]-l);n[i+(a<<4)>>2]=o+p*(+n[e>>2]-o);n[i+(a<<4)+4>>2]=m;n[i+(a<<4)+8>>2]=l;n[i+(a<<4)+12>>2]=0.0;n[j+(a<<2)>>2]=1.0;a=a+1|0}while((a|0)<(g+2|0))}f[6472]=(f[6472]|0)+1;a=sc(1271)|0;if(!a)k=0;else{f[(a+4+15&-16)+-4>>2]=a;k=a+4+15&-16}Bc(k,c,g+2|0,i,j);if(h&1|0){n[(f[k+720>>2]|0)+88>>2]=0.0;b[k+924>>0]=1}if(h&2|0){n[(f[k+720>>2]|0)+((g+1|0)*104|0)+88>>2]=0.0;b[k+924>>0]=1}if(i|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}aI(j);if((g|0)<=-1)return k|0;i=k+720|0;j=k+732|0;d=k+740|0;e=k+924|0;a=1;do{r=a+-1|0;q=f[i>>2]|0;_h(k,0);h=(f[j>>2]|0)+-1|0;c=f[d>>2]|0;f[c+(h*52|0)+8>>2]=q+(r*104|0);f[c+(h*52|0)+12>>2]=q+(a*104|0);m=+n[q+(r*104|0)+8>>2]-+n[q+(a*104|0)+8>>2];o=+n[q+(r*104|0)+12>>2]-+n[q+(a*104|0)+12>>2];p=+n[q+(r*104|0)+16>>2]-+n[q+(a*104|0)+16>>2];p=+L(+(m*m+o*o+p*p));n[c+(h*52|0)+16>>2]=p;b[e>>0]=1;a=a+1|0}while((a|0)<(g+2|0));return k|0}function Mg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+n[c+100>>2];e=+n[c+16>>2];g=+n[c+20>>2];h=+n[c+24>>2];i=+n[c+108>>2];i=+n[c+112>>2]-j*+n[c+116>>2]-(e*+n[a+64>>2]+g*+n[a+68>>2]+h*+n[a+72>>2]+(+n[c>>2]*+n[a+80>>2]+ +n[c+4>>2]*+n[a+84>>2]+ +n[c+8>>2]*+n[a+88>>2]))*i-i*(+n[c+48>>2]*+n[b+64>>2]+ +n[c+52>>2]*+n[b+68>>2]+ +n[c+56>>2]*+n[b+72>>2]+(+n[c+32>>2]*+n[b+80>>2]+ +n[c+36>>2]*+n[b+84>>2]+ +n[c+40>>2]*+n[b+88>>2]));k=+n[c+120>>2];d=j+i<k?k-j:i;n[c+100>>2]=j+i<k?k:j+i;if(f[a+240>>2]|0){k=d*g*+n[a+132>>2]*+n[a+116>>2];j=d*h*+n[a+136>>2]*+n[a+120>>2];n[a+64>>2]=+n[a+112>>2]*d*e*+n[a+128>>2]+ +n[a+64>>2];n[a+68>>2]=k+ +n[a+68>>2];n[a+72>>2]=j+ +n[a+72>>2];j=d*+n[a+100>>2]*+n[c+68>>2];k=d*+n[a+104>>2]*+n[c+72>>2];n[a+80>>2]=d*+n[a+96>>2]*+n[c+64>>2]+ +n[a+80>>2];n[a+84>>2]=j+ +n[a+84>>2];n[a+88>>2]=k+ +n[a+88>>2]}if(!(f[b+240>>2]|0))return;k=d*+n[c+52>>2]*+n[b+132>>2]*+n[b+116>>2];j=d*+n[c+56>>2]*+n[b+136>>2]*+n[b+120>>2];n[b+64>>2]=+n[b+112>>2]*d*+n[c+48>>2]*+n[b+128>>2]+ +n[b+64>>2];n[b+68>>2]=k+ +n[b+68>>2];n[b+72>>2]=j+ +n[b+72>>2];j=d*+n[b+100>>2]*+n[c+84>>2];k=d*+n[b+104>>2]*+n[c+88>>2];n[b+80>>2]=d*+n[b+96>>2]*+n[c+80>>2]+ +n[b+80>>2];n[b+84>>2]=j+ +n[b+84>>2];n[b+88>>2]=k+ +n[b+88>>2];return}function Ng(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=u;u=u+96|0;g=f[a+8>>2]|0;if((g|0)==(f[a+12>>2]|0)?(j=g|0?g<<1:1,(g|0)<(j|0)):0){if(!j)i=0;else{f[6472]=(f[6472]|0)+1;g=sc((j<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=g;g=f[a+8>>2]|0}if((g|0)>0){h=0;do{f[i+(h<<2)>>2]=f[(f[a+16>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=f[a+16>>2]|0;if(h){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);g=f[a+8>>2]|0}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=i;f[a+12>>2]=j}f[(f[a+16>>2]|0)+(g<<2)>>2]=c;f[a+8>>2]=g+1;f[k+32>>2]=f[c+4>>2];f[k+32+4>>2]=f[c+4+4>>2];f[k+32+8>>2]=f[c+4+8>>2];f[k+32+12>>2]=f[c+4+12>>2];f[k+32+16>>2]=f[c+20>>2];f[k+32+16+4>>2]=f[c+20+4>>2];f[k+32+16+8>>2]=f[c+20+8>>2];f[k+32+16+12>>2]=f[c+20+12>>2];f[k+32+32>>2]=f[c+36>>2];f[k+32+32+4>>2]=f[c+36+4>>2];f[k+32+32+8>>2]=f[c+36+8>>2];f[k+32+32+12>>2]=f[c+36+12>>2];f[k+32+48>>2]=f[c+52>>2];f[k+32+48+4>>2]=f[c+52+4>>2];f[k+32+48+8>>2]=f[c+52+8>>2];f[k+32+48+12>>2]=f[c+52+12>>2];j=f[c+192>>2]|0;Yb[f[(f[j>>2]|0)+8>>2]&127](j,k+32|0,k+16|0,k);j=f[a+68>>2]|0;e=Ib[f[(f[j>>2]|0)+8>>2]&3](j,k+16|0,k,f[(f[c+192>>2]|0)+4>>2]|0,c,d,e,f[a+24>>2]|0,0)|0;f[c+188>>2]=e;u=k;return}function Og(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;J=+n[a+4>>2];I=+n[a+20>>2];H=+n[a+36>>2];F=+n[a+8>>2];E=+n[a+24>>2];D=+n[a+40>>2];B=+n[a+12>>2];z=+n[a+28>>2];x=+n[a+44>>2];u=+n[b+4>>2];t=+n[b+20>>2];s=+n[b+36>>2];q=+n[b+8>>2];p=+n[b+24>>2];o=+n[b+40>>2];l=+n[b+12>>2];j=+n[b+28>>2];h=+n[b+44>>2];f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;A=+n[d>>2];y=+n[d+4>>2];w=+n[d+8>>2];n[c+16>>2]=J*A+I*y+H*w;n[c+20>>2]=F*A+E*y+D*w;n[c+24>>2]=B*A+z*y+x*w;n[c+28>>2]=0.0;k=-+n[d>>2];i=-+n[d+4>>2];g=-+n[d+8>>2];n[c+32>>2]=u*k+t*i+s*g;n[c+36>>2]=q*k+p*i+o*g;n[c+40>>2]=l*k+j*i+h*g;n[c+44>>2]=0.0;G=(J*A+I*y+H*w)*+n[a+396>>2];C=(F*A+E*y+D*w)*+n[a+400>>2];v=(B*A+z*y+x*w)*+n[a+404>>2];n[c+48>>2]=G;n[c+52>>2]=C;n[c+56>>2]=v;n[c+60>>2]=0.0;r=(u*k+t*i+s*g)*+n[b+396>>2];m=(q*k+p*i+o*g)*+n[b+400>>2];e=(l*k+j*i+h*g)*+n[b+404>>2];n[c+64>>2]=r;n[c+68>>2]=m;n[c+72>>2]=e;n[c+76>>2]=0.0;n[c+80>>2]=(J*A+I*y+H*w)*G+(F*A+E*y+D*w)*C+(B*A+z*y+x*w)*v+((u*k+t*i+s*g)*r+(q*k+p*i+o*g)*m+(l*k+j*i+h*g)*e);return}function Pg(a){a=a|0;var c=0,d=0,e=0;f[a>>2]=4288;if(b[a+272>>0]|0?(c=f[a+204>>2]|0,Lb[f[f[c>>2]>>2]&511](c),c=f[a+204>>2]|0,c|0):0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+196>>2]|0;if(c|0?(Lb[f[f[c>>2]>>2]&511](c),d=f[a+196>>2]|0,d|0):0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}if(b[a+273>>0]|0?(e=f[a+200>>2]|0,Lb[f[f[e>>2]>>2]&511](e),e=f[a+200>>2]|0,e|0):0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}c=f[a+316>>2]|0;if(c|0){if(b[a+320>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+316>>2]=0}b[a+320>>0]=1;f[a+316>>2]=0;f[a+308>>2]=0;f[a+312>>2]=0;c=f[a+288>>2]|0;if(c|0){if(b[a+292>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+288>>2]=0}b[a+292>>0]=1;f[a+288>>2]=0;f[a+280>>2]=0;f[a+284>>2]=0;c=f[a+240>>2]|0;if(c|0){if(b[a+244>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+240>>2]=0}b[a+244>>0]=1;f[a+240>>2]=0;f[a+232>>2]=0;f[a+236>>2]=0;c=f[a+220>>2]|0;if(c|0){if(b[a+224>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+220>>2]=0}b[a+224>>0]=1;f[a+220>>2]=0;f[a+212>>2]=0;f[a+216>>2]=0;c=f[a+188>>2]|0;if(!c){b[a+192>>0]=1;f[a+188>>2]=0;f[a+180>>2]=0;e=a+184|0;f[e>>2]=0;Pj(a);return}if(b[a+192>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+188>>2]=0;b[a+192>>0]=1;f[a+188>>2]=0;f[a+180>>2]=0;e=a+184|0;f[e>>2]=0;Pj(a);return}function Qg(a,b,c,d,e,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=+i;j=j|0;k=+k;var l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f[a>>2]=f[g>>2];f[a+4>>2]=f[g+4>>2];f[a+8>>2]=f[g+8>>2];f[a+12>>2]=f[g+12>>2];s=+n[d+4>>2];v=+n[a+8>>2];w=+n[d+8>>2];p=+n[a+4>>2];l=+n[a>>2];r=+n[d>>2];u=(s*v-w*p)*+n[b>>2]+ +n[b+4>>2]*(w*l-v*r)+(p*r-s*l)*+n[b+8>>2];t=(s*v-w*p)*+n[b+16>>2]+(w*l-v*r)*+n[b+20>>2]+(p*r-s*l)*+n[b+24>>2];s=(s*v-w*p)*+n[b+32>>2]+(w*l-v*r)*+n[b+36>>2]+(p*r-s*l)*+n[b+40>>2];n[a+16>>2]=u;n[a+20>>2]=t;n[a+24>>2]=s;n[a+28>>2]=0.0;r=+n[e+4>>2];w=+n[e+8>>2];m=+n[e>>2];q=+n[c>>2]*(r*-v-w*-p)+ +n[c+4>>2]*(w*-l-m*-v)+(m*-p-r*-l)*+n[c+8>>2];o=(r*-v-w*-p)*+n[c+16>>2]+(w*-l-m*-v)*+n[c+20>>2]+(m*-p-r*-l)*+n[c+24>>2];l=(r*-v-w*-p)*+n[c+32>>2]+(w*-l-m*-v)*+n[c+36>>2]+(m*-p-r*-l)*+n[c+40>>2];n[a+32>>2]=q;n[a+36>>2]=o;n[a+40>>2]=l;n[a+44>>2]=0.0;u=+n[h>>2]*u;t=+n[h+4>>2]*t;s=+n[h+8>>2]*s;n[a+48>>2]=u;n[a+52>>2]=t;n[a+56>>2]=s;n[a+60>>2]=0.0;r=+n[j>>2]*q;p=+n[j+4>>2]*o;m=+n[j+8>>2]*l;n[a+64>>2]=r;n[a+68>>2]=p;n[a+72>>2]=m;n[a+76>>2]=0.0;n[a+80>>2]=u*+n[a+16>>2]+t*+n[a+20>>2]+s*+n[a+24>>2]+i+k+(r*q+p*o+m*l);return}function Rg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f[6458]=(f[6458]|0)+1;d=((c<<16|b)+~((c<<16|b)<<15)>>10^(c<<16|b)+~((c<<16|b)<<15))*9|0;k=f[a+40>>2]|0;d=k+(((f[a+12>>2]|0)+-1&((d>>6^d)+~((d>>6^d)<<11)>>16^(d>>6^d)+~((d>>6^d)<<11)))<<2)|0;g=f[d>>2]|0;if((g|0)==-1){m=0;return m|0}m=f[a+16>>2]|0;e=g;while(1){l=m+(e*12|0)|0;if((f[l>>2]|0)==(b|0)?(f[m+(e*12|0)+4>>2]|0)==(c|0):0)break;e=f[(f[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){d=0;h=15;break}}if((h|0)==15)return d|0;if(!l){m=0;return m|0}j=f[m+(e*12|0)+8>>2]|0;i=(e*12|0)/12|0;h=f[a+60>>2]|0;if((g|0)!=(i|0)){while(1){b=h+(g<<2)|0;e=f[b>>2]|0;if((e|0)==(i|0))break;else g=e}d=(g|0)==-1?d:b}f[d>>2]=f[h+(i<<2)>>2];b=(f[a+8>>2]|0)+-1|0;if((b|0)==(i|0)){f[a+8>>2]=i;m=j;return m|0}c=f[m+(b*12|0)+4>>2]<<16|f[m+(b*12|0)>>2];c=(c+~(c<<15)>>10^c+~(c<<15))*9|0;c=((c>>6^c)+~((c>>6^c)<<11)>>16^(c>>6^c)+~((c>>6^c)<<11))&(f[a+12>>2]|0)+-1;d=f[k+(c<<2)>>2]|0;if((d|0)==(b|0))d=k+(c<<2)|0;else{while(1){g=h+(d<<2)|0;e=f[g>>2]|0;if((e|0)==(b|0))break;else d=e}d=(d|0)==-1?k+(c<<2)|0:g}f[d>>2]=f[h+(b<<2)>>2];f[l>>2]=f[m+(b*12|0)>>2];f[l+4>>2]=f[m+(b*12|0)+4>>2];f[l+8>>2]=f[m+(b*12|0)+8>>2];m=(f[a+40>>2]|0)+(c<<2)|0;f[(f[a+60>>2]|0)+(i<<2)>>2]=f[m>>2];f[m>>2]=i;f[a+8>>2]=(f[a+8>>2]|0)+-1;m=j;return m|0}function Sg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0;g=u;u=u+64|0;b[c+84>>0]=0;f[g>>2]=f[a+4>>2];f[g+4>>2]=f[a+4+4>>2];f[g+8>>2]=f[a+4+8>>2];f[g+12>>2]=f[a+4+12>>2];f[g+16>>2]=f[a+20>>2];f[g+16+4>>2]=f[a+20+4>>2];f[g+16+8>>2]=f[a+20+8>>2];f[g+16+12>>2]=f[a+20+12>>2];f[g+32>>2]=f[a+36>>2];f[g+32+4>>2]=f[a+36+4>>2];f[g+32+8>>2]=f[a+36+8>>2];f[g+32+12>>2]=f[a+36+12>>2];f[g+48>>2]=f[a+52>>2];f[g+48+4>>2]=f[a+52+4>>2];f[g+48+8>>2]=f[a+52+8>>2];f[g+48+12>>2]=f[a+52+12>>2];if(d?(e=f[a+480>>2]|0,e|0):0)Rb[f[(f[e>>2]|0)+8>>2]&127](e,g);w=+n[c+156>>2];t=+n[g>>2];v=+n[c+160>>2];s=+n[g+4>>2];m=+n[c+164>>2];r=+n[g+8>>2];q=+n[g+16>>2];p=+n[g+20>>2];o=+n[g+24>>2];l=+n[g+32>>2];j=+n[g+36>>2];h=+n[g+40>>2];k=w*q+v*p+m*o+ +n[g+52>>2];i=w*l+v*j+m*h+ +n[g+56>>2];n[c+36>>2]=w*t+v*s+m*r+ +n[g+48>>2];n[c+40>>2]=k;n[c+44>>2]=i;n[c+48>>2]=0.0;i=+n[c+172>>2];k=+n[c+176>>2];m=+n[c+180>>2];n[c+52>>2]=t*i+s*k+r*m;n[c+56>>2]=i*q+k*p+m*o;n[c+60>>2]=i*l+k*j+m*h;n[c+64>>2]=0.0;m=+n[c+188>>2];k=+n[c+192>>2];i=+n[c+196>>2];n[c+68>>2]=t*m+s*k+r*i;n[c+72>>2]=m*q+k*p+i*o;n[c+76>>2]=m*l+k*j+i*h;n[c+80>>2]=0.0;u=g;return}function Tg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{d=(f[c>>2]|0)+(4-1)&~(4-1);b=f[d>>2]|0;f[c>>2]=d+4;f[a>>2]=b;break a}case 10:{b=(f[c>>2]|0)+(4-1)&~(4-1);d=f[b>>2]|0;f[c>>2]=b+4;f[a>>2]=d;f[a+4>>2]=((d|0)<0)<<31>>31;break a}case 11:{b=(f[c>>2]|0)+(4-1)&~(4-1);d=f[b>>2]|0;f[c>>2]=b+4;f[a>>2]=d;f[a+4>>2]=0;break a}case 12:{e=(f[c>>2]|0)+(8-1)&~(8-1);b=f[e>>2]|0;d=f[e+4>>2]|0;f[c>>2]=e+8;f[a>>2]=b;f[a+4>>2]=d;break a}case 13:{d=(f[c>>2]|0)+(4-1)&~(4-1);e=f[d>>2]|0;f[c>>2]=d+4;f[a>>2]=(e&65535)<<16>>16;f[a+4>>2]=(((e&65535)<<16>>16|0)<0)<<31>>31;break a}case 14:{d=(f[c>>2]|0)+(4-1)&~(4-1);e=f[d>>2]|0;f[c>>2]=d+4;f[a>>2]=e&65535;f[a+4>>2]=0;break a}case 15:{d=(f[c>>2]|0)+(4-1)&~(4-1);e=f[d>>2]|0;f[c>>2]=d+4;f[a>>2]=(e&255)<<24>>24;f[a+4>>2]=(((e&255)<<24>>24|0)<0)<<31>>31;break a}case 16:{d=(f[c>>2]|0)+(4-1)&~(4-1);e=f[d>>2]|0;f[c>>2]=d+4;f[a>>2]=e&255;f[a+4>>2]=0;break a}case 17:{e=(f[c>>2]|0)+(8-1)&~(8-1);g=+p[e>>3];f[c>>2]=e+8;p[a>>3]=g;break a}case 18:{e=(f[c>>2]|0)+(8-1)&~(8-1);g=+p[e>>3];f[c>>2]=e+8;p[a>>3]=g;break a}default:break a}while(0);while(0);return}function Ug(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0.0,y=0;w=u;u=u+2048|0;if((d|0)>0)e=0;else{u=w;return}do{n[c+(e<<4)+12>>2]=-999999984306749440.0;e=e+1|0}while((e|0)!=(d|0));o=0;do{if((Bb[f[(f[a>>2]|0)+96>>2]&127](a)|0)>0){p=b+(o<<4)|0;q=b+(o<<4)+4|0;r=b+(o<<4)+8|0;s=c+(o<<4)+12|0;t=c+(o<<4)|0;m=0;do{if(((Bb[f[(f[a>>2]|0)+96>>2]&127](a)|0)-m|0)<128){e=(Bb[f[(f[a>>2]|0)+96>>2]&127](a)|0)-m|0;if((e|0)>0)v=10;else{h=-3402823466385288598117041.0e14;e=-1}}else{e=128;v=10}if((v|0)==10){v=0;g=0;do{Vb[f[(f[a>>2]|0)+108>>2]&127](a,g,w+(g<<4)|0);g=g+1|0}while((g|0)!=(e|0));j=+n[p>>2];k=+n[q>>2];l=+n[r>>2];g=-1;i=0;h=-3402823466385288598117041.0e14;do{x=j*+n[w+(i<<4)>>2]+k*+n[w+(i<<4)+4>>2]+l*+n[w+(i<<4)+8>>2];y=x>h;g=y?i:g;h=y?x:h;i=i+1|0}while((i|0)!=(e|0));e=g}if(h>+n[s>>2]){y=w+(e<<4)|0;f[t>>2]=f[y>>2];f[t+4>>2]=f[y+4>>2];f[t+8>>2]=f[y+8>>2];f[t+12>>2]=f[y+12>>2];n[s>>2]=h}m=m+128|0}while((m|0)<(Bb[f[(f[a>>2]|0)+96>>2]&127](a)|0))}o=o+1|0}while((o|0)!=(d|0));u=w;return}function Vg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0,v=0;t=u;u=u+16|0;g=f[a+52>>2]|0;s=+n[a+28+(((g+2|0)%3|0)<<2)>>2];if((d|0)<=0){u=t;return}e=0;while(1){f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;f[t+(g<<2)>>2]=f[a+28+(g<<2)>>2];g=b+(e<<4)|0;q=b+(e<<4)+4|0;r=b+(e<<4)+8|0;k=s*+n[g>>2]+ +n[t>>2];l=s*+n[q>>2]+ +n[t+4>>2];m=s*+n[r>>2]+ +n[t+8>>2];o=+rb[f[(f[a>>2]|0)+48>>2]&15](a);h=+n[g>>2];i=+n[q>>2];j=+n[r>>2];if(h*(k-o*h)+i*(l-o*i)+j*(m-o*j)>-999999984306749440.0){n[c+(e<<4)>>2]=k-o*h;n[c+(e<<4)+4>>2]=l-o*i;n[c+(e<<4)+8>>2]=m-o*j;n[c+(e<<4)+12>>2]=0.0;p=h*(k-o*h)+i*(l-o*i)+j*(m-o*j);h=+n[g>>2];i=+n[q>>2];j=+n[r>>2]}else p=-999999984306749440.0;f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;v=f[a+52>>2]|0;n[t+(v<<2)>>2]=-+n[a+28+(v<<2)>>2];o=s*h+ +n[t>>2];m=s*i+ +n[t+4>>2];k=s*j+ +n[t+8>>2];l=+rb[f[(f[a>>2]|0)+48>>2]&15](a);j=+n[g>>2];i=+n[q>>2];h=+n[r>>2];if(j*(o-l*j)+i*(m-l*i)+h*(k-l*h)>p){n[c+(e<<4)>>2]=o-l*j;n[c+(e<<4)+4>>2]=m-l*i;n[c+(e<<4)+8>>2]=k-l*h;n[c+(e<<4)+12>>2]=0.0}e=e+1|0;if((e|0)==(d|0))break;g=f[a+52>>2]|0}u=t;return}function Wg(a,c){a=a|0;c=c|0;var d=0;d=Ms()|0;Kj(d,5,a);f[d>>2]=4844;f[d+300>>2]=f[c>>2];f[d+300+4>>2]=f[c+4>>2];f[d+300+8>>2]=f[c+8>>2];f[d+300+12>>2]=f[c+12>>2];f[d+316>>2]=f[c+16>>2];f[d+316+4>>2]=f[c+16+4>>2];f[d+316+8>>2]=f[c+16+8>>2];f[d+316+12>>2]=f[c+16+12>>2];f[d+332>>2]=f[c+32>>2];f[d+332+4>>2]=f[c+32+4>>2];f[d+332+8>>2]=f[c+32+8>>2];f[d+332+12>>2]=f[c+32+12>>2];f[d+348>>2]=f[c+48>>2];f[d+348+4>>2]=f[c+48+4>>2];f[d+348+8>>2]=f[c+48+8>>2];f[d+348+12>>2]=f[c+48+12>>2];b[d+527>>0]=0;f[d+364>>2]=f[d+300>>2];f[d+364+4>>2]=f[d+300+4>>2];f[d+364+8>>2]=f[d+300+8>>2];f[d+364+12>>2]=f[d+300+12>>2];f[d+380>>2]=f[d+316>>2];f[d+380+4>>2]=f[d+316+4>>2];f[d+380+8>>2]=f[d+316+8>>2];f[d+380+12>>2]=f[d+316+12>>2];f[d+396>>2]=f[d+332>>2];f[d+396+4>>2]=f[d+332+4>>2];f[d+396+8>>2]=f[d+332+8>>2];f[d+396+12>>2]=f[d+332+12>>2];b[d+524>>0]=0;b[d+525>>0]=0;b[d+526>>0]=0;b[d+552>>0]=0;f[d+412>>2]=0;f[d+412+4>>2]=0;f[d+412+8>>2]=0;f[d+412+12>>2]=0;n[d+572>>2]=-1.0;n[d+444>>2]=999999984306749440.0;n[d+448>>2]=999999984306749440.0;n[d+452>>2]=999999984306749440.0;n[d+428>>2]=1.0;n[d+432>>2]=.30000001192092896;n[d+436>>2]=1.0;n[d+440>>2]=.009999999776482582;n[d+456>>2]=.05000000074505806;f[d+592>>2]=0;n[d+596>>2]=0.0;n[d+600>>2]=.699999988079071;n[d+604>>2]=0.0;return d|0}function Xg(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0.0,j=0.0,k=0,l=0.0,m=0,o=0.0,p=0,q=0.0,r=0;p=u;u=u+16|0;n[d>>2]=3402823466385288598117041.0e14;n[e>>2]=-3402823466385288598117041.0e14;m=f[a+96>>2]|0;if((m|0)>0){k=0;do{r=f[a+104>>2]|0;q=+n[r+(k<<4)>>2]*+n[a+12>>2];o=+n[r+(k<<4)+4>>2]*+n[a+16>>2];l=+n[r+(k<<4)+8>>2]*+n[a+20>>2];i=q*+n[b>>2]+o*+n[b+4>>2]+l*+n[b+8>>2]+ +n[b+48>>2];j=q*+n[b+16>>2]+o*+n[b+20>>2]+l*+n[b+24>>2]+ +n[b+52>>2];l=q*+n[b+32>>2]+o*+n[b+36>>2]+l*+n[b+40>>2]+ +n[b+56>>2];o=i*+n[c>>2]+j*+n[c+4>>2]+l*+n[c+8>>2];if(o<+n[d>>2]){n[d>>2]=o;n[g>>2]=i;n[g+4>>2]=j;n[g+8>>2]=l;n[g+12>>2]=0.0}if(o>+n[e>>2]){n[e>>2]=o;n[h>>2]=i;n[h+4>>2]=j;n[h+8>>2]=l;n[h+12>>2]=0.0}k=k+1|0}while((k|0)!=(m|0));q=+n[e>>2];j=q;k=(n[s>>2]=q,f[s>>2]|0)}else{j=-3402823466385288598117041.0e14;k=-8388609}i=+n[d>>2];if(!(i>j)){u=p;return}f[d>>2]=k;n[e>>2]=i;f[p>>2]=f[g>>2];f[p+4>>2]=f[g+4>>2];f[p+8>>2]=f[g+8>>2];f[p+12>>2]=f[g+12>>2];f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];f[g+12>>2]=f[h+12>>2];f[h>>2]=f[p>>2];f[h+4>>2]=f[p+4>>2];f[h+8>>2]=f[p+8>>2];f[h+12>>2]=f[p+12>>2];u=p;return}function Yg(a,b,c,d,e,f,g){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;g=g|0;var h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;j=u;u=u+16|0;i=c*f+ +n[a+52>>2];h=d*f+ +n[a+56>>2];n[g+48>>2]=b*f+ +n[a+48>>2];n[g+52>>2]=i;n[g+56>>2]=h;n[g+60>>2]=0.0;h=+n[e>>2];i=+n[e+4>>2];d=+n[e+8>>2];b=+L(+(h*h+i*i+d*d));b=b*f>.7853981852531433?.7853981852531433/f:b;if(b<1.0000000474974513e-03)c=f*.5-b*f*f*f*.02083333395421505*b;else c=+O(+(b*.5*f))/b;m=h*c;l=i*c;h=d*c;p=+N(+(b*f*.5));mh(a,j);b=+n[j>>2];o=+n[j+12>>2];c=+n[j+8>>2];f=+n[j+4>>2];q=1.0/+L(+((p*o-m*b-l*f-h*c)*(p*o-m*b-l*f-h*c)+((h*o+p*c+m*f-l*b)*(h*o+p*c+m*f-l*b)+((p*b+m*o+l*c-h*f)*(p*b+m*o+l*c-h*f)+(h*b+(l*o+p*f)-m*c)*(h*b+(l*o+p*f)-m*c)))));d=(p*b+m*o+l*c-h*f)*q;i=q*(h*b+(l*o+p*f)-m*c);k=q*(h*o+p*c+m*f-l*b);c=q*(p*o-m*b-l*f-h*c);h=d*(2.0/(c*c+(k*k+(d*d+i*i))));f=i*(2.0/(c*c+(k*k+(d*d+i*i))));b=k*(2.0/(c*c+(k*k+(d*d+i*i))));n[g>>2]=1.0-(i*f+k*b);n[g+4>>2]=d*f-c*b;n[g+8>>2]=d*b+c*f;n[g+12>>2]=0.0;n[g+16>>2]=d*f+c*b;n[g+20>>2]=1.0-(d*h+k*b);n[g+24>>2]=i*b-c*h;n[g+28>>2]=0.0;n[g+32>>2]=d*b-c*f;n[g+36>>2]=i*b+c*h;n[g+40>>2]=1.0-(d*h+i*f);n[g+44>>2]=0.0;u=j;return}function Zg(a,b){a=a|0;b=b|0;var c=0,d=0;c=u;u=u+48|0;d=(f[a+48>>2]|0)+4|0;f[d>>2]=f[b>>2];f[d+4>>2]=f[b+4>>2];f[d+8>>2]=f[b+8>>2];f[d+12>>2]=f[b+12>>2];b=c+32+4|0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;n[c+32>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c+16|0,a,c+32|0);n[a+32>>2]=+n[c+16>>2]+ +n[a+12>>2];n[c+32>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c,a,c+32|0);f[c+16>>2]=f[c>>2];f[c+16+4>>2]=f[c+4>>2];f[c+16+8>>2]=f[c+8>>2];f[c+16+12>>2]=f[c+12>>2];n[a+16>>2]=+n[c+16>>2]-+n[a+12>>2];f[c+32>>2]=0;f[c+32+4>>2]=0;f[c+32+8>>2]=0;f[c+32+12>>2]=0;n[b>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c+16|0,a,c+32|0);n[a+36>>2]=+n[c+16+4>>2]+ +n[a+12>>2];n[b>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c,a,c+32|0);f[c+16>>2]=f[c>>2];f[c+16+4>>2]=f[c+4>>2];f[c+16+8>>2]=f[c+8>>2];f[c+16+12>>2]=f[c+12>>2];n[a+20>>2]=+n[c+16+4>>2]-+n[a+12>>2];f[c+32>>2]=0;f[c+32+4>>2]=0;f[c+32+8>>2]=0;f[c+32+12>>2]=0;n[c+32+8>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c+16|0,a,c+32|0);n[a+40>>2]=+n[c+16+8>>2]+ +n[a+12>>2];n[c+32+8>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](c,a,c+32|0);f[c+16>>2]=f[c>>2];f[c+16+4>>2]=f[c+4>>2];f[c+16+8>>2]=f[c+8>>2];f[c+16+12>>2]=f[c+12>>2];n[a+24>>2]=+n[c+16+8>>2]-+n[a+12>>2];u=c;return}function _g(a,c,d){a=a|0;c=+c;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=f[a+8>>2]|0;if(e|0?(f[e+204>>2]&3|0)==0:0){if((f[e+216>>2]&-2|0)!=4)f[e+216>>2]=1;n[e+220>>2]=0.0}e=f[a+12>>2]|0;if(e|0?(f[e+204>>2]&3|0)==0:0){if((f[e+216>>2]&-2|0)!=4)f[e+216>>2]=1;n[e+220>>2]=0.0}e=f[a+20>>2]|0;if(e|0?(f[e+204>>2]&3|0)==0:0){if((f[e+216>>2]&-2|0)!=4)f[e+216>>2]=1;n[e+220>>2]=0.0}e=f[a+24>>2]|0;if(e|0?(f[e+204>>2]&3|0)==0:0){if((f[e+216>>2]&-2|0)!=4)f[e+216>>2]=1;n[e+220>>2]=0.0}e=f[a+156>>2]|0;f[a+156>>2]=e+1;b[a+152>>0]=(e|0)>=(f[a+160>>2]|0)&1;if(e|0){f[a+72>>2]=0;f[a+72+4>>2]=0;f[a+72+8>>2]=0;f[a+72+12>>2]=0;f[a+72+16>>2]=0;f[a+72+20>>2]=0;f[a+72+24>>2]=0;f[a+72+28>>2]=0;return}i=+n[a+64>>2];h=1.0/c*+n[a+72>>2]*i;g=1.0/c*i*+n[a+76>>2];c=1.0/c*i*+n[a+80>>2];n[a+72>>2]=h;n[a+76>>2]=g;n[a+80>>2]=c;n[a+84>>2]=0.0;i=+n[a+68>>2];if(i>0.0){k=i*h*+n[a+120>>2]+i*g*+n[a+124>>2]+i*c*+n[a+128>>2];j=i*h*+n[a+136>>2]+i*g*+n[a+140>>2]+i*c*+n[a+144>>2];n[a+88>>2]=i*h*+n[a+104>>2]+i*g*+n[a+108>>2]+i*c*+n[a+112>>2];n[a+92>>2]=k;n[a+96>>2]=j;n[a+100>>2]=0.0;n[a+72>>2]=(1.0-i)*h;n[a+76>>2]=(1.0-i)*g;n[a+80>>2]=(1.0-i)*c;h=(1.0-i)*h;g=(1.0-i)*g;c=(1.0-i)*c}n[a+72>>2]=1.0/+(d|0)*h;n[a+76>>2]=1.0/+(d|0)*g;n[a+80>>2]=1.0/+(d|0)*c;return}function $g(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0;i=u;u=u+48|0;l=+n[c>>2];m=+n[c+4>>2];k=+n[c+8>>2];o=l*+n[b+4>>2]+m*+n[b+20>>2]+k*+n[b+36>>2];p=l*+n[b+8>>2]+m*+n[b+24>>2]+k*+n[b+40>>2];n[i+32>>2]=+n[b>>2]*l+ +n[b+16>>2]*m+ +n[b+32>>2]*k;n[i+32+4>>2]=o;n[i+32+8>>2]=p;n[i+32+12>>2]=0.0;Vb[f[(f[a>>2]|0)+64>>2]&127](i+16|0,a,i+32|0);p=+n[i+16>>2];o=+n[i+16+4>>2];k=+n[i+16+8>>2];m=p*+n[b>>2]+o*+n[b+4>>2]+k*+n[b+8>>2]+ +n[b+48>>2];l=p*+n[b+16>>2]+o*+n[b+20>>2]+k*+n[b+24>>2]+ +n[b+52>>2];k=p*+n[b+32>>2]+o*+n[b+36>>2]+k*+n[b+40>>2]+ +n[b+56>>2];q=f[(f[a>>2]|0)+64>>2]|0;o=-+n[i+32+4>>2];p=-+n[i+32+8>>2];n[i>>2]=-+n[i+32>>2];n[i+4>>2]=o;n[i+8>>2]=p;n[i+12>>2]=0.0;Vb[q&127](i+16|0,a,i);p=+n[i+16>>2];o=+n[i+16+4>>2];g=+n[i+16+8>>2];j=p*+n[b>>2]+o*+n[b+4>>2]+g*+n[b+8>>2]+ +n[b+48>>2];h=p*+n[b+16>>2]+o*+n[b+20>>2]+g*+n[b+24>>2]+ +n[b+52>>2];g=p*+n[b+32>>2]+o*+n[b+36>>2]+g*+n[b+40>>2]+ +n[b+56>>2];n[d>>2]=m*+n[c>>2]+l*+n[c+4>>2]+k*+n[c+8>>2];g=j*+n[c>>2]+h*+n[c+4>>2]+g*+n[c+8>>2];n[e>>2]=g;h=+n[d>>2];if(!(h>g)){u=i;return}n[d>>2]=g;n[e>>2]=h;u=i;return}function ah(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;u=u+16|0;h=f[a+12>>2]|0;i=f[h+(((c+b|0)/2|0)<<4)>>2]|0;j=f[h+(((c+b|0)/2|0)<<4)+4>>2]|0;k=f[h+(((c+b|0)/2|0)<<4)+8>>2]|0;e=c;d=b;while(1){while(1){g=f[h+(d<<4)+4>>2]|0;if((g|0)>=(j|0)){if((g|0)!=(j|0))break;g=f[h+(d<<4)>>2]|0;if((g|0)>=(i|0)){if((g|0)!=(i|0))break;if((f[h+(d<<4)+8>>2]|0)>=(k|0))break}}d=d+1|0}while(1){g=f[h+(e<<4)+4>>2]|0;if((j|0)>=(g|0)){if((j|0)!=(g|0))break;g=f[h+(e<<4)>>2]|0;if((i|0)>=(g|0)){if((i|0)!=(g|0))break;if((k|0)>=(f[h+(e<<4)+8>>2]|0))break}}e=e+-1|0}if((d|0)<=(e|0)){g=h+(d<<4)|0;f[l>>2]=f[g>>2];f[l+4>>2]=f[g+4>>2];f[l+8>>2]=f[g+8>>2];f[l+12>>2]=f[g+12>>2];h=h+(e<<4)|0;f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];f[g+12>>2]=f[h+12>>2];h=(f[a+12>>2]|0)+(e<<4)|0;f[h>>2]=f[l>>2];f[h+4>>2]=f[l+4>>2];f[h+8>>2]=f[l+8>>2];f[h+12>>2]=f[l+12>>2];e=e+-1|0;d=d+1|0}if((d|0)>(e|0))break;h=f[a+12>>2]|0}if((e|0)>(b|0))ah(a,b,e);if((d|0)>=(c|0)){u=l;return}ah(a,d,c);u=l;return}function bh(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0.0,j=0.0,k=0,l=0.0,m=0.0,o=0,p=0,q=0.0,r=0;p=u;u=u+16|0;n[d>>2]=3402823466385288598117041.0e14;n[e>>2]=-3402823466385288598117041.0e14;o=f[a+8>>2]|0;if((o|0)>0){k=0;do{r=f[a+16>>2]|0;q=+n[r+(k<<4)>>2];m=+n[r+(k<<4)+4>>2];l=+n[r+(k<<4)+8>>2];i=q*+n[b>>2]+m*+n[b+4>>2]+l*+n[b+8>>2]+ +n[b+48>>2];j=q*+n[b+16>>2]+m*+n[b+20>>2]+l*+n[b+24>>2]+ +n[b+52>>2];l=q*+n[b+32>>2]+m*+n[b+36>>2]+l*+n[b+40>>2]+ +n[b+56>>2];m=i*+n[c>>2]+j*+n[c+4>>2]+l*+n[c+8>>2];if(m<+n[d>>2]){n[d>>2]=m;n[g>>2]=i;n[g+4>>2]=j;n[g+8>>2]=l;n[g+12>>2]=0.0}if(m>+n[e>>2]){n[e>>2]=m;n[h>>2]=i;n[h+4>>2]=j;n[h+8>>2]=l;n[h+12>>2]=0.0}k=k+1|0}while((k|0)!=(o|0));q=+n[e>>2];j=q;k=(n[s>>2]=q,f[s>>2]|0)}else{j=-3402823466385288598117041.0e14;k=-8388609}i=+n[d>>2];if(!(i>j)){u=p;return}f[d>>2]=k;n[e>>2]=i;f[p>>2]=f[g>>2];f[p+4>>2]=f[g+4>>2];f[p+8>>2]=f[g+8>>2];f[p+12>>2]=f[g+12>>2];f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];f[g+12>>2]=f[h+12>>2];f[h>>2]=f[p>>2];f[h+4>>2]=f[p+4>>2];f[h+8>>2]=f[p+8>>2];f[h+12>>2]=f[p+12>>2];u=p;return}function ch(a){a=a|0;var b=0,c=0,d=0.0,e=0.0,g=0.0,h=0,i=0;i=f[a+28>>2]|0;h=0;d=0.0;e=0.0;g=0.0;a:while(1){switch(h|0){case 0:{d=+n[a+80>>2]+ +n[a+64>>2];e=+n[a+84>>2]+ +n[a+68>>2];g=+n[a+88>>2]+ +n[a+72>>2];break}case 1:{d=+n[a+80>>2]+ +n[a+64>>2];e=+n[a+84>>2]+ +n[a+68>>2];g=+n[a+72>>2]-+n[a+88>>2];break}case 2:{d=+n[a+80>>2]+ +n[a+64>>2];e=+n[a+68>>2]-+n[a+84>>2];g=+n[a+88>>2]+ +n[a+72>>2];break}case 3:{d=+n[a+80>>2]+ +n[a+64>>2];e=+n[a+68>>2]-+n[a+84>>2];g=+n[a+72>>2]-+n[a+88>>2];break}case 4:{d=+n[a+64>>2]-+n[a+80>>2];e=+n[a+84>>2]+ +n[a+68>>2];g=+n[a+88>>2]+ +n[a+72>>2];break}case 5:{d=+n[a+64>>2]-+n[a+80>>2];e=+n[a+84>>2]+ +n[a+68>>2];g=+n[a+72>>2]-+n[a+88>>2];break}case 6:{d=+n[a+64>>2]-+n[a+80>>2];e=+n[a+68>>2]-+n[a+84>>2];g=+n[a+88>>2]+ +n[a+72>>2];break}case 7:{d=+n[a+64>>2]-+n[a+80>>2];e=+n[a+68>>2]-+n[a+84>>2];g=+n[a+72>>2]-+n[a+88>>2];break}default:{}}if((i|0)>0){c=f[a+36>>2]|0;b=0;do{if(+n[c+(b*36|0)+32>>2]+(d*+n[c+(b*36|0)+20>>2]+e*+n[c+(b*36|0)+24>>2]+g*+n[c+(b*36|0)+28>>2])>0.0){b=0;c=16;break a}b=b+1|0}while((b|0)<(i|0))}if((h|0)<7)h=h+1|0;else{b=1;c=16;break}}if((c|0)==16)return b|0;return 0}function dh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0.0,j=0.0,k=0,l=0,m=0.0,o=0.0,p=0;l=u;u=u+16|0;if((e|0)>-3){f[6472]=(f[6472]|0)+1;a=sc((e+3<<4|3)+16|0)|0;if(!a)k=0;else{f[(a+4+15&-16)+-4>>2]=a;k=a+4+15&-16}a=0;do{h=k+(a<<4)|0;f[h>>2]=f[l>>2];f[h+4>>2]=f[l+4>>2];f[h+8>>2]=f[l+8>>2];f[h+12>>2]=f[l+12>>2];a=a+1|0}while((a|0)!=(e+3|0));g=0;h=k;while(1){if(!g)i=0.0;else{a=g;i=0.0;j=.5;while(1){i=(a&1|0)==0?i:i+j;a=a>>1;if(!a)break;else j=j*.5}}j=i*2.0+-1.0;i=(+(g<<1|0)*3.1415927410125732+3.1415927410125732)/+(e+3|0);o=+L(+(1.0-j*j));m=o*+N(+i);i=o*+O(+i);n[h>>2]=m;n[h+4>>2]=i;n[h+8>>2]=j;n[h+12>>2]=0.0;g=g+1|0;if((g|0)==(e+3|0))break;else h=h+16|0}a=0;do{p=k+(a<<4)|0;g=k+(a<<4)+4|0;h=k+(a<<4)+8|0;m=+n[g>>2]*+n[d+4>>2]+ +n[c+4>>2];o=+n[h>>2]*+n[d+8>>2]+ +n[c+8>>2];n[p>>2]=+n[p>>2]*+n[d>>2]+ +n[c>>2];n[g>>2]=m;n[h>>2]=o;n[k+(a<<4)+12>>2]=0.0;a=a+1|0}while((a|0)<(e+3|0));h=k;g=k}else{h=0;g=0}a=kc(b,h,e+3|0,1)|0;if((h|0)==0|(g|0)==0){u=l;return a|0}f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);u=l;return a|0}function eh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;u=u+32|0;j=(b[a+28>>0]|0)!=0;k=j?d:c;j=j?c:d;h=f[k+4>>2]|0;i=f[h+16>>2]|0;g=f[a+12>>2]|0;if((g|0)<(i|0)){if((f[a+16>>2]|0)<(i|0)){if(!i){c=0;e=g}else{f[6472]=(f[6472]|0)+1;c=sc((i<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=f[a+12>>2]|0}if((e|0)>0){d=0;do{f[c+(d<<2)>>2]=f[(f[a+20>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0))}d=f[a+20>>2]|0;if(d|0){if(b[a+24>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+20>>2]=0}b[a+24>>0]=1;f[a+20>>2]=c;f[a+16>>2]=i;d=a+20|0}else d=a+20|0;c=g;do{f[(f[d>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=(i|0))}f[a+12>>2]=i;if((i|0)<=0){u=l;return}c=0;do{if(!(f[h+64>>2]|0)){d=f[(f[h+24>>2]|0)+(c*80|0)+64>>2]|0;e=f[k+8>>2]|0;g=f[k+12>>2]|0;f[l>>2]=k;f[l+4>>2]=d;f[l+8>>2]=e;f[l+12>>2]=g;f[l+16>>2]=-1;f[l+20>>2]=c;g=f[a+4>>2]|0;g=Gb[f[(f[g>>2]|0)+8>>2]&31](g,l,j,f[a+32>>2]|0)|0;f[(f[a+20>>2]|0)+(c<<2)>>2]=g}else f[(f[a+20>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=(i|0));u=l;return}function fh(a,b,c){a=a|0;b=b|0;c=c|0;gi(a,b,c)|0;f[b+52>>2]=f[a+48>>2];f[b+56>>2]=f[a+52>>2];f[b+60>>2]=f[a+56>>2];f[b+64>>2]=f[a+60>>2];f[b+68>>2]=f[a+64>>2];f[b+72>>2]=f[a+68>>2];f[b+76>>2]=f[a+72>>2];f[b+80>>2]=f[a+76>>2];f[b+84>>2]=f[a+80>>2];f[b+88>>2]=f[a+84>>2];f[b+92>>2]=f[a+88>>2];f[b+96>>2]=f[a+92>>2];f[b+100>>2]=f[a+96>>2];f[b+104>>2]=f[a+100>>2];f[b+108>>2]=f[a+104>>2];f[b+112>>2]=f[a+108>>2];f[b+116>>2]=f[a+112>>2];f[b+120>>2]=f[a+116>>2];f[b+124>>2]=f[a+120>>2];f[b+128>>2]=f[a+124>>2];f[b+132>>2]=f[a+128>>2];f[b+136>>2]=f[a+132>>2];f[b+140>>2]=f[a+136>>2];f[b+144>>2]=f[a+140>>2];f[b+148>>2]=f[a+144>>2];f[b+152>>2]=f[a+148>>2];f[b+156>>2]=f[a+152>>2];f[b+160>>2]=f[a+156>>2];f[b+164>>2]=f[a+160>>2];f[b+168>>2]=f[a+164>>2];f[b+172>>2]=f[a+168>>2];f[b+176>>2]=f[a+172>>2];f[b+228>>2]=f[a+868>>2];f[b+212>>2]=f[a+872>>2];f[b+196>>2]=f[a+680>>2];f[b+180>>2]=f[a+696>>2];f[b+232>>2]=f[a+932>>2];f[b+216>>2]=f[a+936>>2];f[b+200>>2]=f[a+684>>2];f[b+184>>2]=f[a+700>>2];f[b+236>>2]=f[a+996>>2];f[b+220>>2]=f[a+1e3>>2];f[b+204>>2]=f[a+688>>2];f[b+188>>2]=f[a+704>>2];f[b+244>>2]=h[a+1300>>0];f[b+248>>2]=h[a+1301>>0];return 12657}function gh(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;d=f[a+32>>2]|0;if(!d)e=0;else e=f[a+40>>2]|0;i=f[a+52>>2]|0;if(!i)g=0;else g=f[a+60>>2]|0;c=f[a+72>>2]|0;if(!c)h=0;else h=f[a+80>>2]|0;j=f[a+8>>2]|0;+Ab[f[(f[j>>2]|0)+12>>2]&3](j,e,d,g,i,h,c,f[a+4>>2]|0,f[a+20>>2]|0,f[a+24>>2]|0);c=f[a+32>>2]|0;if((c|0)<0){if((f[a+36>>2]|0)<0){d=f[a+40>>2]|0;if(d|0){if(b[a+44>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+40>>2]=0}b[a+44>>0]=1;f[a+40>>2]=0;f[a+36>>2]=0}do{f[(f[a+40>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=0)}f[a+32>>2]=0;c=f[a+52>>2]|0;if((c|0)<0){if((f[a+56>>2]|0)<0){d=f[a+60>>2]|0;if(d|0){if(b[a+64>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+60>>2]=0}b[a+64>>0]=1;f[a+60>>2]=0;f[a+56>>2]=0}do{f[(f[a+60>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=0)}f[a+52>>2]=0;c=f[a+72>>2]|0;if((c|0)>=0){f[a+72>>2]=0;return}if((f[a+76>>2]|0)<0){d=f[a+80>>2]|0;if(d|0){if(b[a+84>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+80>>2]=0}b[a+84>>0]=1;f[a+80>>2]=0;f[a+76>>2]=0}do{f[(f[a+80>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=0);f[a+72>>2]=0;return}function hh(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[6472]=(f[6472]|0)+1;c=sc(39)|0;if(!c)g=0;else{f[(c+4+15&-16)+-4>>2]=c;g=c+4+15&-16}h=g;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[g+16>>2]=0;if((f[a+872>>2]|0)>0){i=f[f[a+880>>2]>>2]|0;f[g>>2]=f[i>>2];f[g+4>>2]=f[i+4>>2];f[g+8>>2]=f[i+8>>2];f[g+12>>2]=f[i+12>>2];f[g+16>>2]=f[i+16>>2]}else{f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[g+16>>2]=0}d=f[a+872>>2]|0;if((d|0)!=(f[a+876>>2]|0)){i=d;e=a+880|0;e=f[e>>2]|0;e=e+(i<<2)|0;f[e>>2]=h;i=i+1|0;f[a+872>>2]=i;return g|0}i=d|0?d<<1:1;if((d|0)>=(i|0)){i=d;e=a+880|0;e=f[e>>2]|0;e=e+(i<<2)|0;f[e>>2]=h;i=i+1|0;f[a+872>>2]=i;return g|0}if(!i)c=0;else{f[6472]=(f[6472]|0)+1;c=sc((i<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}d=f[a+872>>2]|0}if((d|0)>0){e=0;do{f[c+(e<<2)>>2]=f[(f[a+880>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=f[a+880>>2]|0;if(e){if(b[a+884>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);d=f[a+872>>2]|0}f[a+880>>2]=0}b[a+884>>0]=1;f[a+880>>2]=c;f[a+876>>2]=i;i=d;e=a+880|0;e=f[e>>2]|0;e=e+(i<<2)|0;f[e>>2]=h;i=i+1|0;f[a+872>>2]=i;return g|0}function ih(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=f[a+4>>2]|0;if((d|0)==(f[a+8>>2]|0)){Kf(a,d|0?d<<1:1);d=f[a+4>>2]|0}o=f[a+12>>2]|0;j=o+(d*36|0)+16|0;b[j>>0]=1;k=o+(d*36|0)+12|0;f[k>>2]=0;n=o+(d*36|0)+4|0;f[n>>2]=0;l=o+(d*36|0)+8|0;f[l>>2]=0;p=f[c+4>>2]|0;if((p|0)<=0){f[n>>2]=p;p=o+(d*36|0)+20|0;c=c+20|0;f[p>>2]=f[c>>2];f[p+4>>2]=f[c+4>>2];f[p+8>>2]=f[c+8>>2];f[p+12>>2]=f[c+12>>2];c=f[a+4>>2]|0;c=c+1|0;f[a+4>>2]=c;return}f[6472]=(f[6472]|0)+1;e=sc((p<<2|3)+16|0)|0;if(!e)g=0;else{f[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}h=f[n>>2]|0;i=f[k>>2]|0;if((h|0)<=0){if(i|0)m=10}else{e=0;do{f[g+(e<<2)>>2]=f[i+(e<<2)>>2];e=e+1|0}while((e|0)!=(h|0));m=10}if((m|0)==10?b[j>>0]|0:0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}b[j>>0]=1;f[k>>2]=g;f[l>>2]=p;bl(g|0,0,p<<2|0)|0;h=f[k>>2]|0;f[n>>2]=p;g=f[c+12>>2]|0;e=0;do{f[h+(e<<2)>>2]=f[g+(e<<2)>>2];e=e+1|0}while((e|0)!=(p|0));p=o+(d*36|0)+20|0;c=c+20|0;f[p>>2]=f[c>>2];f[p+4>>2]=f[c+4>>2];f[p+8>>2]=f[c+8>>2];f[p+12>>2]=f[c+12>>2];c=f[a+4>>2]|0;c=c+1|0;f[a+4>>2]=c;return}function jh(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0.0,l=0,m=0,o=0.0,p=0.0;Yb[f[(f[a>>2]|0)+8>>2]&127](a,b,e,g);l=f[g>>2]|0;i=f[g+4>>2]|0;b=f[g+8>>2]|0;j=f[e>>2]|0;m=f[e+4>>2]|0;h=f[e+8>>2]|0;k=+n[c>>2];o=+n[c+4>>2];p=+n[c+8>>2];if(k>0.0)l=(n[s>>2]=k+(f[s>>2]=l,+n[s>>2]),f[s>>2]|0);else j=(n[s>>2]=k+(f[s>>2]=j,+n[s>>2]),f[s>>2]|0);if(o>0.0){c=m;i=(n[s>>2]=o+(f[s>>2]=i,+n[s>>2]),f[s>>2]|0)}else c=(n[s>>2]=o+(f[s>>2]=m,+n[s>>2]),f[s>>2]|0);if(p>0.0)b=(n[s>>2]=p+(f[s>>2]=b,+n[s>>2]),f[s>>2]|0);else h=(n[s>>2]=p+(f[s>>2]=h,+n[s>>2]),f[s>>2]|0);k=+n[d>>2];o=+n[d+4>>2];p=+n[d+8>>2];p=+L(+(k*k+o*o+p*p));p=p*+rb[f[(f[a>>2]|0)+16>>2]&15](a);f[e>>2]=j;f[e+4>>2]=c;f[e+8>>2]=h;n[e+12>>2]=0.0;f[g>>2]=l;f[g+4>>2]=i;f[g+8>>2]=b;n[g+12>>2]=0.0;n[e>>2]=+n[e>>2]-p;n[e+4>>2]=+n[e+4>>2]-p;n[e+8>>2]=+n[e+8>>2]-p;n[g>>2]=p+ +n[g>>2];n[g+4>>2]=p+ +n[g+4>>2];n[g+8>>2]=p+ +n[g+8>>2];return}function kh(a,c,d){a=a|0;c=+c;d=d|0;var e=0,g=0.0,h=0,i=0,j=0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0;i=f[a+712>>2]|0;if(d){if((i|0)>0){e=f[a+720>>2]|0;d=0;do{n[e+(d*104|0)+88>>2]=0.0;d=d+1|0}while((d|0)!=(i|0))}h=f[a+752>>2]|0;if((h|0)>0){e=f[a+760>>2]|0;d=0;do{l=f[e+(d*44|0)+8>>2]|0;k=f[e+(d*44|0)+12>>2]|0;j=f[e+(d*44|0)+16>>2]|0;o=+n[l+8>>2];q=+n[l+12>>2];g=+n[l+16>>2];m=+n[k+8>>2]-o;r=+n[k+12>>2]-q;p=+n[k+16>>2]-g;o=+n[j+8>>2]-o;q=+n[j+12>>2]-q;g=+n[j+16>>2]-g;g=+L(+((m*q-r*o)*(m*q-r*o)+((r*g-p*q)*(r*g-p*q)+(p*o-m*g)*(p*o-m*g))));n[l+88>>2]=g+ +n[l+88>>2];n[k+88>>2]=g+ +n[k+88>>2];n[j+88>>2]=g+ +n[j+88>>2];d=d+1|0}while((d|0)!=(h|0))}if((i|0)<=0){l=a+924|0;b[l>>0]=1;return}e=f[a+720>>2]|0;d=0;do{l=e+(d*104|0)+88|0;n[l>>2]=1.0/+n[l>>2];d=d+1|0}while((d|0)!=(i|0))}if((i|0)<=0){l=a+924|0;b[l>>0]=1;return}e=f[a+720>>2]|0;d=0;g=0.0;do{r=+n[e+(d*104|0)+88>>2];g=g+(r>0.0?1.0/r:0.0);d=d+1|0}while((d|0)!=(i|0));g=1.0/g*c;d=0;do{l=e+(d*104|0)+88|0;n[l>>2]=+n[l>>2]/g;d=d+1|0}while((d|0)!=(i|0));l=a+924|0;b[l>>0]=1;return}function lh(a,b){a=+a;b=+b;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;j=(n[s>>2]=a,f[s>>2]|0);h=(n[s>>2]=b,f[s>>2]|0);a:do if((h<<1|0)!=0?!((j>>>23&255|0)==255|((bD(b)|0)&2147483647)>>>0>2139095040):0){if(j<<1>>>0<=h<<1>>>0)return +((j<<1|0)==(h<<1|0)?a*0.0:a);if(!(j>>>23&255)){if((j<<9|0)>-1){d=j<<9;c=0;do{c=c+-1|0;d=d<<1}while((d|0)>-1)}else c=0;d=j<<1-c}else{d=j&8388607|8388608;c=j>>>23&255}if(!(h>>>23&255)){if((h<<9|0)>-1){e=0;g=h<<9;do{e=e+-1|0;g=g<<1}while((g|0)>-1)}else e=0;i=e;h=h<<1-e}else{i=h>>>23&255;h=h&8388607|8388608}e=d-h|0;b:do if((c|0)>(i|0)){g=e;e=(e|0)>-1;while(1){if(e)if(!g)break;else d=g;d=d<<1;c=c+-1|0;e=d-h|0;if((c|0)>(i|0)){g=e;e=(e|0)>-1}else{g=(e|0)>-1;break b}}b=a*0.0;break a}else g=(e|0)>-1;while(0);if(g)if(!e){b=a*0.0;break}else d=e;if(d>>>0<8388608)do{d=d<<1;c=c+-1|0}while(d>>>0<8388608);if((c|0)>0)c=d+-8388608|c<<23;else c=d>>>(1-c|0);b=(f[s>>2]=c|j&-2147483648,+n[s>>2])}else k=3;while(0);if((k|0)==3)b=a*b/(a*b);return +b}function mh(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0,g=0,h=0,i=0,j=0;f=u;u=u+16|0;g=fI(a)|0;d=+n[g>>2];g=NH(a+16|0)|0;e=+n[g>>2];g=MH(a+32|0)|0;c=+n[g>>2];if(d+e+c>0.0){e=+VH(d+e+c+1.0);n[f+12>>2]=e*.5;h=NH(a+32|0)|0;d=+n[h>>2];h=MH(a+16|0)|0;n[f>>2]=(d-+n[h>>2])*(.5/e);h=MH(a)|0;d=+n[h>>2];h=fI(a+32|0)|0;n[f+4>>2]=(d-+n[h>>2])*(.5/e);h=fI(a+16|0)|0;d=+n[h>>2];h=NH(a)|0;n[f+8>>2]=(d-+n[h>>2])*(.5/e);h=f+4|0;a=f+8|0;g=f+12|0;i=f;Nr(b,i,h,a,g);u=f;return}else{g=(d<e?e:d)<c?2:d<e&1;h=fI(a+(g<<4)|0)|0;e=+n[h+(g<<2)>>2];j=fI(a+((((g+1|0)>>>0)%3|0)<<4)|0)|0;e=e-+n[j+((((g+1|0)>>>0)%3|0)<<2)>>2];i=fI(a+((((g+2|0)>>>0)%3|0)<<4)|0)|0;e=+VH(e-+n[i+((((g+2|0)>>>0)%3|0)<<2)>>2]+1.0);n[f+(g<<2)>>2]=e*.5;n[f+12>>2]=(+n[i+((((g+1|0)>>>0)%3|0)<<2)>>2]-+n[j+((((g+2|0)>>>0)%3|0)<<2)>>2])*(.5/e);n[f+((((g+1|0)>>>0)%3|0)<<2)>>2]=(+n[j+(g<<2)>>2]+ +n[h+((((g+1|0)>>>0)%3|0)<<2)>>2])*(.5/e);n[f+((((g+2|0)>>>0)%3|0)<<2)>>2]=(+n[i+(g<<2)>>2]+ +n[h+((((g+2|0)>>>0)%3|0)<<2)>>2])*(.5/e);g=f+4|0;h=f+8|0;i=f+12|0;a=f;Nr(b,a,g,h,i);u=f;return}}function nh(a,b,c,d,e,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0;a=u;u=u+80|0;m=+n[g+52>>2]-+n[e+52>>2];l=+n[g+56>>2]-+n[e+56>>2];n[a+56>>2]=+n[g+48>>2]-+n[e+48>>2];n[a+56+4>>2]=m;n[a+56+8>>2]=l;n[a+56+12>>2]=0.0;if(Pc(c,e,d,g,a+56|0,a,1)|0){f[i>>2]=f[a+4>>2];f[i+4>>2]=f[a+4+4>>2];f[i+8>>2]=f[a+4+8>>2];f[i+12>>2]=f[a+4+12>>2];f[j>>2]=f[a+20>>2];f[j+4>>2]=f[a+20+4>>2];f[j+8>>2]=f[a+20+8>>2];f[j+12>>2]=f[a+20+12>>2];f[h>>2]=f[a+36>>2];f[h+4>>2]=f[a+36+4>>2];f[h+8>>2]=f[a+36+8>>2];f[h+12>>2]=f[a+36+12>>2];j=1;u=a;return j|0}if(!(Ne(c,e,d,g,a+56|0,a)|0)){j=0;u=a;return j|0}f[i>>2]=f[a+4>>2];f[i+4>>2]=f[a+4+4>>2];f[i+8>>2]=f[a+4+8>>2];f[i+12>>2]=f[a+4+12>>2];f[j>>2]=f[a+20>>2];f[j+4>>2]=f[a+20+4>>2];f[j+8>>2]=f[a+20+8>>2];f[j+12>>2]=f[a+20+12>>2];f[h>>2]=f[a+36>>2];f[h+4>>2]=f[a+36+4>>2];f[h+8>>2]=f[a+36+8>>2];f[h+12>>2]=f[a+36+12>>2];j=0;u=a;return j|0}function oh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0,i=0,j=0,k=0.0,l=0.0,m=0,o=0,p=0.0,q=0;o=u;u=u+2048|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;d=+n[c>>2];g=+n[c+4>>2];e=+n[c+8>>2];if(d*d+g*g+e*e<9.999999747378752e-05){l=1.0;k=0.0;g=0.0}else{p=1.0/+L(+(d*d+g*g+e*e));l=d*p;k=g*p;g=e*p}if((Bb[f[(f[b>>2]|0)+96>>2]&127](b)|0)<=0){u=o;return}j=0;e=-999999984306749440.0;while(1){if(((Bb[f[(f[b>>2]|0)+96>>2]&127](b)|0)-j|0)<128){c=(Bb[f[(f[b>>2]|0)+96>>2]&127](b)|0)-j|0;if((c|0)>0)m=8;else{d=-3402823466385288598117041.0e14;c=-1}}else{c=128;m=8}if((m|0)==8){m=0;h=0;do{Vb[f[(f[b>>2]|0)+108>>2]&127](b,h,o+(h<<4)|0);h=h+1|0}while((h|0)!=(c|0));h=-1;i=0;d=-3402823466385288598117041.0e14;do{p=l*+n[o+(i<<4)>>2]+k*+n[o+(i<<4)+4>>2]+g*+n[o+(i<<4)+8>>2];q=p>d;h=q?i:h;d=q?p:d;i=i+1|0}while((i|0)!=(c|0));c=h}if(d>e){q=o+(c<<4)|0;f[a>>2]=f[q>>2];f[a+4>>2]=f[q+4>>2];f[a+8>>2]=f[q+8>>2];f[a+12>>2]=f[q+12>>2]}else d=e;j=j+128|0;if((j|0)>=(Bb[f[(f[b>>2]|0)+96>>2]&127](b)|0))break;else e=d}u=o;return}function ph(a,c,d,e,g,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;var j=0;if((h[e+55>>0]|0|0)==(c|0)){e=0;return e|0}j=f[5168+(g<<2)>>2]|0;if(+n[e>>2]*+n[d+16>>2]+ +n[e+4>>2]*+n[d+20>>2]+ +n[e+8>>2]*+n[d+24>>2]-+n[e+16>>2]<-9.999999747378752e-06){c=of(a,f[e+20+(j<<2)>>2]|0,f[e+20+(g<<2)>>2]|0,d,0)|0;if(!c){e=0;return e|0}b[c+52>>0]=g;f[c+32>>2]=e;b[e+52+g>>0]=0;f[e+32+(g<<2)>>2]=c;g=f[i>>2]|0;if(!g)f[i+4>>2]=c;else{b[g+53>>0]=2;f[g+36>>2]=c;b[c+54>>0]=1;f[c+40>>2]=g}f[i>>2]=c;f[i+8>>2]=(f[i+8>>2]|0)+1;e=1;return e|0}g=f[5180+(g<<2)>>2]|0;b[e+55>>0]=c;if(!(ph(a,c,d,f[e+32+(j<<2)>>2]|0,h[e+52+j>>0]|0,i)|0)){e=0;return e|0}if(!(ph(a,c,d,f[e+32+(g<<2)>>2]|0,h[e+52+g>>0]|0,i)|0)){e=0;return e|0}g=f[e+48>>2]|0;if(g|0)f[g+44>>2]=f[e+44>>2];g=f[e+44>>2]|0;if(g|0)f[g+48>>2]=f[e+48>>2];if((f[a+9280>>2]|0)==(e|0))f[a+9280>>2]=f[e+48>>2];f[a+9284>>2]=(f[a+9284>>2]|0)+-1;f[e+44>>2]=0;f[e+48>>2]=f[a+9288>>2];g=f[a+9288>>2]|0;if(g|0)f[g+44>>2]=e;f[a+9288>>2]=e;f[a+9292>>2]=(f[a+9292>>2]|0)+1;e=1;return e|0}function qh(a,c){a=a|0;c=c|0;var d=0,e=0,g=0.0,h=0,i=0,j=0.0,k=0.0;d=f[c+204>>2]|0;if((d&3|0)==0?(f[c+504>>2]&1|0)==0:0){g=+n[c+344>>2];if(g!=0.0){k=1.0/g*+n[a+252>>2];j=1.0/g*+n[a+256>>2];n[c+364>>2]=1.0/g*+n[a+248>>2];n[c+368>>2]=k;n[c+372>>2]=j;n[c+376>>2]=0.0}f[c+380>>2]=f[a+248>>2];f[c+380+4>>2]=f[a+248+4>>2];f[c+380+8>>2]=f[a+248+8>>2];f[c+380+12>>2]=f[a+248+12>>2]}if(!(f[c+192>>2]|0))return;if(d&1){if((f[c+216>>2]&-2|0)!=4)f[c+216>>2]=2}else{e=f[a+232>>2]|0;if((e|0)==(f[a+236>>2]|0)?(i=e|0?e<<1:1,(e|0)<(i|0)):0){if(!i)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((i<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[a+232>>2]|0}if((e|0)>0){h=0;do{f[d+(h<<2)>>2]=f[(f[a+240>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}h=f[a+240>>2]|0;if(h){if(b[a+244>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);e=f[a+232>>2]|0}f[a+240>>2]=0}b[a+244>>0]=1;f[a+240>>2]=d;f[a+236>>2]=i;d=f[c+204>>2]|0}f[(f[a+240>>2]|0)+(e<<2)>>2]=c;f[a+232>>2]=e+1}i=(d&3|0)==0;Yb[f[(f[a>>2]|0)+36>>2]&127](a,c,i?1:2,i?-1:-3);return}function rh(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0;h=f[a+68+(b<<2)>>2]|0;i=d[h+((c&65535)<<2)+-4>>1]|0;if((j[h+((c&65535)<<2)>>1]|0)>=(i&65535))return;k=f[a+60>>2]|0;m=k+((j[h+((c&65535)<<2)+2>>1]|0)<<6)+54+(b<<1)|0;g=h+((c&65535)<<2)+-4|0;l=h+((c&65535)<<2)|0;while(1){h=j[l+-2>>1]|0;if(!(i&1)){c=j[l+2>>1]|0;if(((((j[k+(c<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[k+(h<<6)+48+((1<<b&3)<<1)>>1]|0)?(j[k+(h<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[k+(c<<6)+48+((1<<b&3)<<1)>>1]|0):0)?(j[k+(c<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[k+(h<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(j[k+(h<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[k+(c<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(p=f[a+92>>2]|0,n=k+(c<<6)|0,o=k+(h<<6)|0,Gb[f[(f[p>>2]|0)+12>>2]&31](p,n,o,e)|0,p=f[a+96>>2]|0,p|0):0)Gb[f[(f[p>>2]|0)+12>>2]&31](p,n,o,e)|0;c=k+(h<<6)+48+(b<<1)|0}else c=k+(h<<6)+54+(b<<1)|0;d[c>>1]=(d[c>>1]|0)+1<<16>>16;d[m>>1]=(d[m>>1]|0)+-1<<16>>16;c=j[l>>1]|j[l+2>>1]<<16;i=j[g>>1]|j[g+2>>1]<<16;d[l>>1]=i;d[l+2>>1]=i>>>16;d[g>>1]=c;d[g+2>>1]=c>>>16;c=l+-4|0;g=g+-4|0;i=d[g>>1]|0;if((j[c>>1]|0)>=(i&65535))break;l=c;k=f[a+60>>2]|0}return}function sh(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0;e=f[a+68+(b<<2)>>2]|0;l=f[a+60>>2]|0;m=j[e+((c&65535)<<2)+2>>1]|0;g=d[e+((c&65535)<<2)+6>>1]|0;if(!(g<<16>>16))return;k=e+((c&65535)<<2)|0;while(1){i=k;k=k+4|0;e=d[k>>1]|0;if((j[i>>1]|0)<(e&65535)){c=14;break}h=f[a+60>>2]|0;c=g&65535;if(!(e&1)){if(((((j[l+(m<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[h+(c<<6)+48+((1<<b&3)<<1)>>1]|0)?(j[h+(c<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[l+(m<<6)+48+((1<<b&3)<<1)>>1]|0):0)?(j[l+(m<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[h+(c<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(j[h+(c<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[l+(m<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(o=f[a+92>>2]|0,n=h+((j[i+2>>1]|0)<<6)|0,Fb[f[(f[o>>2]|0)+8>>2]&63](o,n,h+(c<<6)|0)|0,o=f[a+96>>2]|0,o|0):0)Fb[f[(f[o>>2]|0)+8>>2]&63](o,n,h+(c<<6)|0)|0;c=h+(c<<6)+48+(b<<1)|0}else c=h+(c<<6)+54+(b<<1)|0;d[c>>1]=(d[c>>1]|0)+-1<<16>>16;d[l+(m<<6)+54+(b<<1)>>1]=(d[l+(m<<6)+54+(b<<1)>>1]|0)+1<<16>>16;g=j[i>>1]|j[i+2>>1]<<16;h=j[k>>1]|j[k+2>>1]<<16;d[i>>1]=h;d[i+2>>1]=h>>>16;d[k>>1]=g;d[k+2>>1]=g>>>16;g=d[i+10>>1]|0;if(!(g<<16>>16)){c=14;break}}if((c|0)==14)return}function th(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0.0,i=0,j=0,k=0,l=0.0,m=0.0;g=f[c+204>>2]|0;if((g&3|0)==0?(f[c+504>>2]&1|0)==0:0){h=+n[c+344>>2];if(h!=0.0){m=1.0/h*+n[a+252>>2];l=1.0/h*+n[a+256>>2];n[c+364>>2]=1.0/h*+n[a+248>>2];n[c+368>>2]=m;n[c+372>>2]=l;n[c+376>>2]=0.0}f[c+380>>2]=f[a+248>>2];f[c+380+4>>2]=f[a+248+4>>2];f[c+380+8>>2]=f[a+248+8>>2];f[c+380+12>>2]=f[a+248+12>>2]}if(!(f[c+192>>2]|0))return;if(g&1){if((f[c+216>>2]&-2|0)!=4)f[c+216>>2]=2}else{g=f[a+232>>2]|0;if((g|0)==(f[a+236>>2]|0)?(k=g|0?g<<1:1,(g|0)<(k|0)):0){if(!k)j=0;else{f[6472]=(f[6472]|0)+1;g=sc((k<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}j=g;g=f[a+232>>2]|0}if((g|0)>0){i=0;do{f[j+(i<<2)>>2]=f[(f[a+240>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(g|0))}i=f[a+240>>2]|0;if(i){if(b[a+244>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);g=f[a+232>>2]|0}f[a+240>>2]=0}b[a+244>>0]=1;f[a+240>>2]=j;f[a+236>>2]=k}f[(f[a+240>>2]|0)+(g<<2)>>2]=c;f[a+232>>2]=g+1}Yb[f[(f[a>>2]|0)+36>>2]&127](a,c,d,e);return}function uh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0.0,j=0,k=0.0;k=+n[c>>2];if(+n[b>>2]<=k){i=+n[c+4>>2];if((((+n[b+4>>2]<=i?+n[b+8>>2]<=+n[c+8>>2]:0)?+n[b+16>>2]>=+n[c+16>>2]:0)?+n[b+20>>2]>=+n[c+20>>2]:0)?+n[b+24>>2]>=+n[c+24>>2]:0){c=0;return c|0}else g=c+4|0}else{g=c+4|0;i=+n[c+4>>2]}n[c>>2]=k-e;n[g>>2]=i-e;n[c+8>>2]=+n[c+8>>2]-e;n[c+16>>2]=+n[c+16>>2]+e;n[c+20>>2]=+n[c+20>>2]+e;n[c+24>>2]=+n[c+24>>2]+e;k=+n[d>>2];j=k>0.0?c+16|0:c;n[j>>2]=k+ +n[j>>2];k=+n[d+4>>2];g=k>0.0?c+20|0:g;n[g>>2]=k+ +n[g>>2];k=+n[d+8>>2];g=k>0.0?c+24|0:c+8|0;n[g>>2]=k+ +n[g>>2];g=zg(a,b)|0;a:do if(g){j=f[a+8>>2]|0;if((j|0)<=-1){g=f[a>>2]|0;break}if(j){d=0;while(1){h=f[g+32>>2]|0;d=d+1|0;if(!h)break a;if((d|0)>=(j|0)){g=h;break}else g=h}}}else g=0;while(0);f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];f[b+12>>2]=f[c+12>>2];f[b+16>>2]=f[c+16>>2];f[b+20>>2]=f[c+20>>2];f[b+24>>2]=f[c+24>>2];f[b+28>>2]=f[c+28>>2];ff(a,g,b);c=1;return c|0}function vh(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,k=0,l=0,m=0,n=0;g=f[a+68+(b<<2)>>2]|0;h=d[g+((c&65535)<<2)+6>>1]|0;if(!(h<<16>>16))return;m=(f[a+60>>2]|0)+((j[g+((c&65535)<<2)+2>>1]|0)<<6)+48+(b<<1)|0;l=g+((c&65535)<<2)|0;while(1){k=l;l=l+4|0;c=d[l>>1]|0;if((j[k>>1]|0)<(c&65535)){c=14;break}i=f[a+60>>2]|0;g=h&65535;if(!(c&1))c=i+(g<<6)+48+(b<<1)|0;else{c=j[k+2>>1]|0;if(((((j[i+(c<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[i+(g<<6)+48+((1<<b&3)<<1)>>1]|0)?(j[i+(g<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[i+(c<<6)+48+((1<<b&3)<<1)>>1]|0):0)?(j[i+(c<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[i+(g<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(j[i+(g<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[i+(c<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(n=f[a+92>>2]|0,Gb[f[(f[n>>2]|0)+12>>2]&31](n,i+(c<<6)|0,i+(g<<6)|0,e)|0,n=f[a+96>>2]|0,n|0):0)Gb[f[(f[n>>2]|0)+12>>2]&31](n,i+(c<<6)|0,i+(g<<6)|0,e)|0;c=i+(g<<6)+54+(b<<1)|0}d[c>>1]=(d[c>>1]|0)+-1<<16>>16;d[m>>1]=(d[m>>1]|0)+1<<16>>16;h=j[k>>1]|j[k+2>>1]<<16;i=j[l>>1]|j[l+2>>1]<<16;d[k>>1]=i;d[k+2>>1]=i>>>16;d[l>>1]=h;d[l+2>>1]=h>>>16;h=d[k+10>>1]|0;if(!(h<<16>>16)){c=14;break}}if((c|0)==14)return}function wh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;o=(+n[a+32>>2]-+n[a+16>>2])*.5;k=(+n[a+36>>2]-+n[a+20>>2])*.5;h=(+n[a+40>>2]-+n[a+24>>2])*.5;m=+rb[f[(f[a>>2]|0)+48>>2]&15](a);j=+rb[f[(f[a>>2]|0)+48>>2]&15](a);h=h+ +rb[f[(f[a>>2]|0)+48>>2]&15](a);B=(+n[a+32>>2]+ +n[a+16>>2])*.5;z=(+n[a+36>>2]+ +n[a+20>>2])*.5;x=(+n[a+40>>2]+ +n[a+24>>2])*.5;F=+n[b>>2];w=+K(+F);E=+n[b+4>>2];v=+K(+E);t=+n[b+8>>2];u=+K(+t);D=+n[b+16>>2];s=+K(+D);C=+n[b+20>>2];r=+K(+C);p=+n[b+24>>2];q=+K(+p);A=+n[b+32>>2];l=+K(+A);y=+n[b+36>>2];i=+K(+y);e=+n[b+40>>2];g=+K(+e);t=B*F+z*E+x*t+ +n[b+48>>2];p=B*D+z*C+x*p+ +n[b+52>>2];e=B*A+z*y+x*e+ +n[b+56>>2];n[c>>2]=t-((o+m)*w+(k+j)*v+h*u);n[c+4>>2]=p-((o+m)*s+(k+j)*r+h*q);n[c+8>>2]=e-((o+m)*l+(k+j)*i+h*g);n[c+12>>2]=0.0;n[d>>2]=(o+m)*w+(k+j)*v+h*u+t;n[d+4>>2]=(o+m)*s+(k+j)*r+h*q+p;n[d+8>>2]=(o+m)*l+(k+j)*i+h*g+e;n[d+12>>2]=0.0;return}function xh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;H=+n[a+48>>2];z=+n[a+32>>2];G=+n[a+52>>2];x=+n[a+36>>2];E=+n[a+56>>2];v=+n[a+40>>2];F=(f[a+16>>2]|0)==0;l=+rb[f[(f[a>>2]|0)+48>>2]&15](a);j=+rb[f[(f[a>>2]|0)+48>>2]&15](a);h=+rb[f[(f[a>>2]|0)+48>>2]&15](a);l=(F?0.0:(H-z)*.5)+l;j=(F?0.0:(G-x)*.5)+j;h=(F?0.0:(E-v)*.5)+h;D=+n[b>>2];u=+K(+D);C=+n[b+4>>2];t=+K(+C);r=+n[b+8>>2];s=+K(+r);B=+n[b+16>>2];q=+K(+B);A=+n[b+20>>2];p=+K(+A);m=+n[b+24>>2];o=+K(+m);y=+n[b+32>>2];k=+K(+y);w=+n[b+36>>2];i=+K(+w);e=+n[b+40>>2];g=+K(+e);z=F?0.0:(H+z)*.5;x=F?0.0:(G+x)*.5;v=F?0.0:(E+v)*.5;r=z*D+x*C+v*r+ +n[b+48>>2];m=z*B+x*A+v*m+ +n[b+52>>2];e=z*y+x*w+v*e+ +n[b+56>>2];n[c>>2]=r-(l*u+j*t+h*s);n[c+4>>2]=m-(l*q+j*p+h*o);n[c+8>>2]=e-(l*k+j*i+h*g);n[c+12>>2]=0.0;n[d>>2]=l*u+j*t+h*s+r;n[d+4>>2]=l*q+j*p+h*o+m;n[d+8>>2]=l*k+j*i+h*g+e;n[d+12>>2]=0.0;return}function yh(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0;g=f[a+68+(b<<2)>>2]|0;k=f[a+60>>2]|0;l=j[g+((c&65535)<<2)+2>>1]|0;h=d[g+((c&65535)<<2)+-4>>1]|0;if((j[g+((c&65535)<<2)>>1]|0)>=(h&65535))return;e=g+((c&65535)<<2)+-4|0;i=g+((c&65535)<<2)|0;g=k;while(1){c=j[i+-2>>1]|0;if(!(h&1))c=g+(c<<6)+48+(b<<1)|0;else{if(((((j[k+(l<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[g+(c<<6)+48+((1<<b&3)<<1)>>1]|0)?(j[g+(c<<6)+54+((1<<b&3)<<1)>>1]|0)>=(j[k+(l<<6)+48+((1<<b&3)<<1)>>1]|0):0)?(j[k+(l<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[g+(c<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(j[g+(c<<6)+54+((1<<(1<<b&3)&3)<<1)>>1]|0)>=(j[k+(l<<6)+48+((1<<(1<<b&3)&3)<<1)>>1]|0):0)?(n=f[a+92>>2]|0,m=g+(c<<6)|0,Fb[f[(f[n>>2]|0)+8>>2]&63](n,k+(l<<6)|0,m)|0,n=f[a+96>>2]|0,n|0):0)Fb[f[(f[n>>2]|0)+8>>2]&63](n,k+(l<<6)|0,m)|0;c=g+(c<<6)+54+(b<<1)|0}d[c>>1]=(d[c>>1]|0)+1<<16>>16;d[k+(l<<6)+48+(b<<1)>>1]=(d[k+(l<<6)+48+(b<<1)>>1]|0)+-1<<16>>16;c=j[i>>1]|j[i+2>>1]<<16;h=j[e>>1]|j[e+2>>1]<<16;d[i>>1]=h;d[i+2>>1]=h>>>16;d[e>>1]=c;d[e+2>>1]=c>>>16;c=i+-4|0;e=e+-4|0;h=d[e>>1]|0;if((j[c>>1]|0)>=(h&65535))break;i=c;g=f[a+60>>2]|0}return}function zh(a,c){a=a|0;c=c|0;var d=0.0,e=0.0;if(b[a+1309>>0]|0){d=(+n[a+1256>>2]-+n[a+1316>>2])*+n[a+1340>>2];n[a+792>>2]=d*(+n[c>>2]*+n[a+1364>>2]/+(f[c+48>>2]|0));d=+K(+d);n[a+808>>2]=d/+n[c>>2]}if(b[a+1310>>0]|0){d=(+n[a+1260>>2]-+n[a+1320>>2])*+n[a+1344>>2];n[a+796>>2]=d*(+n[c>>2]*+n[a+1368>>2]/+(f[c+48>>2]|0));d=+K(+d);n[a+812>>2]=d/+n[c>>2]}if(b[a+1311>>0]|0){d=(+n[a+1264>>2]-+n[a+1324>>2])*+n[a+1348>>2];n[a+800>>2]=d*(+n[c>>2]*+n[a+1372>>2]/+(f[c+48>>2]|0));d=+K(+d);n[a+816>>2]=d/+n[c>>2]}if(b[a+1312>>0]|0){e=-((+n[a+1192>>2]-+n[a+1328>>2])*+n[a+1352>>2]);d=+n[c>>2];n[a+876>>2]=d*+n[a+1376>>2]/+(f[c+48>>2]|0)*e;d=+K(+e)/d;n[a+880>>2]=d}if(b[a+1313>>0]|0){d=-((+n[a+1196>>2]-+n[a+1332>>2])*+n[a+1356>>2]);e=+n[c>>2];n[a+940>>2]=e*+n[a+1380>>2]/+(f[c+48>>2]|0)*d;e=+K(+d)/e;n[a+944>>2]=e}if(!(b[a+1314>>0]|0)){lk(a,c);return}d=-((+n[a+1200>>2]-+n[a+1336>>2])*+n[a+1360>>2]);e=+n[c>>2];n[a+1004>>2]=e*+n[a+1384>>2]/+(f[c+48>>2]|0)*d;e=+K(+d)/e;n[a+1008>>2]=e;lk(a,c);return}function Ah(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;e=f[a+212>>2]|0;a:do if((e|0)>0){g=f[a+220>>2]|0;c=0;while(1){d=g+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(e|0))break a}if((c|0)<(e|0)){f[d>>2]=f[g+(e+-1<<2)>>2];f[(f[a+220>>2]|0)+(e+-1<<2)>>2]=b;f[a+212>>2]=e+-1}}while(0);g=f[b+28>>2]|0;c=f[g+488>>2]|0;b:do if((c|0)>0){e=f[g+496>>2]|0;d=0;while(1){a=e+(d<<2)|0;if((f[a>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(c|0))break b}if((d|0)<(c|0)){f[a>>2]=f[e+(c+-1<<2)>>2];f[(f[g+496>>2]|0)+(c+-1<<2)>>2]=b;f[g+488>>2]=c+-1;c=c+-1|0}}while(0);f[g+256>>2]=(c|0)>0&1;g=f[b+32>>2]|0;c=f[g+488>>2]|0;if((c|0)<=0){b=c;b=(b|0)>0;b=b&1;h=g+256|0;f[h>>2]=b;return}e=f[g+496>>2]|0;d=0;while(1){a=e+(d<<2)|0;if((f[a>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(c|0)){h=19;break}}if((h|0)==19){b=(c|0)>0;b=b&1;h=g+256|0;f[h>>2]=b;return}if((d|0)>=(c|0)){b=c;b=(b|0)>0;b=b&1;h=g+256|0;f[h>>2]=b;return}f[a>>2]=f[e+(c+-1<<2)>>2];f[(f[g+496>>2]|0)+(c+-1<<2)>>2]=b;f[g+488>>2]=c+-1;b=c+-1|0;b=(b|0)>0;b=b&1;h=g+256|0;f[h>>2]=b;return}function Bh(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0;i=Bb[f[(f[a>>2]|0)+28>>2]&127](a)|0;h=+n[i>>2]-+n[c>>2];g=+n[i+4>>2]-+n[c+4>>2];e=+n[i+8>>2]-+n[c+8>>2];if(!(h*h+g*g+e*e>1.1920928955078125e-07))return;Zg(a,c);if((b[a+61>>0]|0)!=0?(d=f[a+52>>2]|0,Lb[f[f[d>>2]>>2]&511](d),d=f[a+52>>2]|0,(d|0)!=0):0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);d=a+52|0}else d=a+52|0;f[6472]=(f[6472]|0)+1;c=sc(191)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}f[c+52>>2]=282;b[c+60>>0]=0;b[c+80>>0]=1;f[c+76>>2]=0;f[c+68>>2]=0;f[c+72>>2]=0;b[c+100>>0]=1;f[c+96>>2]=0;f[c+88>>2]=0;f[c+92>>2]=0;b[c+120>>0]=1;f[c+116>>2]=0;f[c+108>>2]=0;f[c+112>>2]=0;b[c+140>>0]=1;f[c+136>>2]=0;f[c+128>>2]=0;f[c+132>>2]=0;f[c+144>>2]=0;b[c+164>>0]=1;f[c+160>>2]=0;f[c+152>>2]=0;f[c+156>>2]=0;f[c+168>>2]=0;f[c+4>>2]=-8388609;f[c+8>>2]=-8388609;f[c+12>>2]=-8388609;n[c+16>>2]=0.0;f[c+20>>2]=2139095039;f[c+24>>2]=2139095039;f[c+28>>2]=2139095039;n[c+32>>2]=0.0;f[c>>2]=8172;f[d>>2]=c;jd(c,f[a+48>>2]|0,(b[a+60>>0]|0)!=0,a+16|0,a+32|0);b[a+61>>0]=1;return}function Ch(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0.0,h=0.0,i=0.0;d=u;u=u+160|0;f[d+136>>2]=0;f[d+136+4>>2]=0;f[d+136+8>>2]=0;f[d+136+12>>2]=0;f[d+136+16>>2]=0;f[d+32>>2]=7200;e=d+32+4|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[d+32+20>>2]=1065353216;f[d+32+24>>2]=0;f[d+32+24+4>>2]=0;f[d+32+24+8>>2]=0;f[d+32+24+12>>2]=0;f[d+32+40>>2]=1065353216;f[d+32+44>>2]=0;f[d+32+44+4>>2]=0;f[d+32+44+8>>2]=0;f[d+32+44+12>>2]=0;f[d+32+60>>2]=1065353216;f[d+32+64>>2]=0;f[d+32+68>>2]=f[d+136+4>>2];f[d+32+68+4>>2]=f[d+136+4+4>>2];f[d+32+68+8>>2]=f[d+136+4+8>>2];f[d+32+68+12>>2]=f[d+136+4+12>>2];n[d+32+84>>2]=-999999984306749440.0;i=+n[c>>2];h=+n[c+4>>2];g=+n[c+8>>2];n[d+32+88>>2]=i+h*0.0+g*0.0;n[d+32+92>>2]=i*0.0+h+g*0.0;n[d+32+96>>2]=i*0.0+h*0.0+g;n[d+32+100>>2]=0.0;f[d+16>>2]=1566444395;f[d+16+4>>2]=1566444395;f[d+16+8>>2]=1566444395;n[d+16+12>>2]=0.0;c=f[(f[b>>2]|0)+64>>2]|0;n[d>>2]=-999999984306749440.0;n[d+4>>2]=-999999984306749440.0;n[d+8>>2]=-999999984306749440.0;n[d+12>>2]=0.0;Yb[c&127](b,d+32|0,d,d+16|0);f[a>>2]=f[e>>2];f[a+4>>2]=f[e+4>>2];f[a+8>>2]=f[e+8>>2];f[a+12>>2]=f[e+12>>2];u=d;return}function Dh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0;p=u;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;d=+n[c>>2];e=+n[c+4>>2];g=+n[c+8>>2];if(d*d+e*e+g*g<9.999999747378752e-05){o=1.0;m=0.0;l=0.0}else{l=1.0/+L(+(d*d+e*e+g*g));o=d*l;m=e*l;l=g*l}c=f[b+52>>2]|0;k=+n[b+28+(((c+2|0)%3|0)<<2)>>2];f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[p+(c<<2)>>2]=f[b+28+(c<<2)>>2];i=o*k;j=m*k;k=l*k;d=i+ +n[p>>2];e=j+ +n[p+4>>2];h=k+ +n[p+8>>2];g=+rb[f[(f[b>>2]|0)+48>>2]&15](b);d=d-o*g;e=e-m*g;g=h-l*g;h=l*g+(o*d+m*e);if(h>-999999984306749440.0){n[a>>2]=d;n[a+4>>2]=e;n[a+8>>2]=g;n[a+12>>2]=0.0}else h=-999999984306749440.0;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;c=f[b+52>>2]|0;n[p+(c<<2)>>2]=-+n[b+28+(c<<2)>>2];d=i+ +n[p>>2];e=j+ +n[p+4>>2];k=k+ +n[p+8>>2];g=+rb[f[(f[b>>2]|0)+48>>2]&15](b);d=d-o*g;e=e-m*g;g=k-l*g;if(!(l*g+(o*d+m*e)>h)){u=p;return}n[a>>2]=d;n[a+4>>2]=e;n[a+8>>2]=g;n[a+12>>2]=0.0;u=p;return}function Eh(a,b,c,d,e,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;g=+g;h=+h;i=+i;j=+j;k=+k;var l=0;l=u;u=u+128|0;f[l+80>>2]=f[a+4>>2];f[l+80+4>>2]=f[a+20>>2];f[l+80+8>>2]=f[a+36>>2];n[l+80+12>>2]=0.0;f[l+80+16>>2]=f[a+8>>2];f[l+80+20>>2]=f[a+24>>2];f[l+80+24>>2]=f[a+40>>2];n[l+80+28>>2]=0.0;f[l+80+32>>2]=f[a+12>>2];f[l+80+36>>2]=f[a+28>>2];f[l+80+40>>2]=f[a+44>>2];n[l+80+44>>2]=0.0;f[l+32>>2]=f[b+4>>2];f[l+32+4>>2]=f[b+20>>2];f[l+32+8>>2]=f[b+36>>2];n[l+32+12>>2]=0.0;f[l+32+16>>2]=f[b+8>>2];f[l+32+20>>2]=f[b+24>>2];f[l+32+24>>2]=f[b+40>>2];n[l+32+28>>2]=0.0;f[l+32+32>>2]=f[b+12>>2];f[l+32+36>>2]=f[b+28>>2];f[l+32+40>>2]=f[b+44>>2];n[l+32+44>>2]=0.0;g=g-+n[a+56>>2];h=h-+n[a+60>>2];n[l+16>>2]=e-+n[a+52>>2];n[l+16+4>>2]=g;n[l+16+8>>2]=h;n[l+16+12>>2]=0.0;h=j-+n[b+56>>2];k=k-+n[b+60>>2];n[l>>2]=i-+n[b+52>>2];n[l+4>>2]=h;n[l+8>>2]=k;n[l+12>>2]=0.0;Qg(c,l+80|0,l+32|0,l+16|0,l,d,a+396|0,+n[a+344>>2],b+396|0,+n[b+344>>2]);u=l;return}function Fh(a,c){a=a|0;c=c|0;var d=0.0,e=0,g=0.0,h=0.0,i=0,j=0.0,k=0.0;if(b[a+48>>0]|0){f[c>>2]=0;f[c+4>>2]=0;return}f[c>>2]=4;f[c+4>>2]=2;bd(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);n[a+1088>>2]=0.0;b[a+297>>0]=0;d=+n[a+192>>2];g=+n[a+196>>2];do if(!(d<=g))i=0;else{k=+n[a+892>>2];j=+n[a+908>>2];h=+n[a+924>>2];h=+ak(+T(+(+n[a+832>>2]*k+ +n[a+848>>2]*j+ +n[a+864>>2]*h),+(+n[a+828>>2]*k+ +n[a+844>>2]*j+ +n[a+860>>2]*h)),d,g);n[a+1084>>2]=h;if(!(h<d))if(h>g)d=g;else{i=0;break}n[a+1088>>2]=h-d;b[a+297>>0]=1;i=1}while(0);b[a+296>>0]=0;e=f[a+1032>>2]|0;f[a+1080>>2]=e;d=+n[a+184>>2];g=+n[a+188>>2];h=(f[s>>2]=e,+n[s>>2]);do if(!(d<=g))e=10;else{if(!(g<h)){if(!(d>h)){e=10;break}}else d=g;n[a+1032>>2]=h-d;b[a+296>>0]=1;e=12}while(0);if((e|0)==10?(n[a+1032>>2]=0.0,b[a+1096>>0]|0):0)e=12;if((e|0)==12){f[c>>2]=(f[c>>2]|0)+1;f[c+4>>2]=(f[c+4>>2]|0)+-1}if(i<<24>>24==0?(b[a+1112>>0]|0)==0:0)return;f[c>>2]=(f[c>>2]|0)+1;f[c+4>>2]=(f[c+4>>2]|0)+-1;return}function Gh(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=e|0;var g=0,h=0,i=0,j=0,k=0.0,l=0.0;i=u;u=u+48|0;k=1.0/+L(+(b*b+c*c+d*d));n[e>>2]=k*b;n[e+4>>2]=k*c;n[e+8>>2]=k*d;n[e+12>>2]=0.0;g=f[a+120>>2]|0;j=f[a+124>>2]|0;h=(f[a>>2]|0)+(j>>1)|0;if(j&1)g=f[(f[h>>2]|0)+g>>2]|0;Vb[g&127](i,h,e);b=-+n[e>>2];c=-+n[e+4>>2];d=-+n[e+8>>2];g=f[a+120>>2]|0;j=f[a+124>>2]|0;h=(f[a+4>>2]|0)+(j>>1)|0;if(j&1)g=f[(f[h>>2]|0)+g>>2]|0;k=+n[a+24>>2]*b+ +n[a+28>>2]*c+ +n[a+32>>2]*d;l=+n[a+40>>2]*b+ +n[a+44>>2]*c+ +n[a+48>>2]*d;n[i+16>>2]=+n[a+8>>2]*b+ +n[a+12>>2]*c+ +n[a+16>>2]*d;n[i+16+4>>2]=k;n[i+16+8>>2]=l;n[i+16+12>>2]=0.0;Vb[g&127](i+32|0,h,i+16|0);l=+n[i+32>>2];b=+n[i+32+4>>2];c=+n[i+32+8>>2];d=+n[i+4>>2]-(l*+n[a+72>>2]+b*+n[a+76>>2]+c*+n[a+80>>2]+ +n[a+108>>2]);k=+n[i+8>>2]-(l*+n[a+88>>2]+b*+n[a+92>>2]+c*+n[a+96>>2]+ +n[a+112>>2]);n[e+16>>2]=+n[i>>2]-(l*+n[a+56>>2]+b*+n[a+60>>2]+c*+n[a+64>>2]+ +n[a+104>>2]);n[e+20>>2]=d;n[e+24>>2]=k;n[e+28>>2]=0.0;u=i;return}function Hh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0,i=0.0,j=0.0;h=f[b>>2]|0;if((h|0)==(f[a+80>>2]|0)){g=1.0;return +g}if(f[h+204>>2]&4|0){g=1.0;return +g}if(c){d=+n[b+8>>2];e=+n[b+12>>2];g=+n[b+16>>2]}else{j=+n[b+8>>2];i=+n[b+12>>2];g=+n[b+16>>2];d=+n[h+4>>2]*j+ +n[h+8>>2]*i+ +n[h+12>>2]*g;e=j*+n[h+20>>2]+i*+n[h+24>>2]+g*+n[h+28>>2];g=j*+n[h+36>>2]+i*+n[h+40>>2]+g*+n[h+44>>2]}if(d*+n[a+84>>2]+e*+n[a+88>>2]+g*+n[a+92>>2]<+n[a+100>>2]){j=1.0;return +j}f[a+4>>2]=f[b+40>>2];f[a+76>>2]=h;if(c){f[a+44>>2]=f[b+8>>2];f[a+44+4>>2]=f[b+8+4>>2];f[a+44+8>>2]=f[b+8+8>>2];f[a+44+12>>2]=f[b+8+12>>2]}else{d=+n[b+8>>2];e=+n[b+12>>2];g=+n[b+16>>2];i=d*+n[h+20>>2]+e*+n[h+24>>2]+g*+n[h+28>>2];j=d*+n[h+36>>2]+e*+n[h+40>>2]+g*+n[h+44>>2];n[a+44>>2]=+n[h+4>>2]*d+ +n[h+8>>2]*e+ +n[h+12>>2]*g;n[a+48>>2]=i;n[a+52>>2]=j;n[a+56>>2]=0.0}f[a+60>>2]=f[b+24>>2];f[a+60+4>>2]=f[b+24+4>>2];f[a+60+8>>2]=f[b+24+8>>2];f[a+60+12>>2]=f[b+24+12>>2];j=+n[b+40>>2];return +j}function Ih(a,b,c,d,e,f,g,h,i,j,k,l,m,o){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g=+g;h=+h;i=+i;j=+j;k=+k;l=+l;m=+m;o=+o;var p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;q=(i-f)*(m-g)-(j-g)*(l-f);r=(j-g)*(k-e)-(h-e)*(m-g);s=(h-e)*(l-f)-(i-f)*(k-e);if(+K(+(s*d+(q*b+r*c)))<1.1920928955078125e-07){s=-1.0;return +s}t=+n[a>>2];v=+n[a+4>>2];u=+n[a+8>>2];p=-(q*t+r*v+s*u-(s*g+(q*e+r*f)))/(s*d+(q*b+r*c));if(((p>1.1920928955078125e-06&p<o?s*((i-(v+p*c))*(e-(t+p*b))-(f-(v+p*c))*(h-(t+p*b)))+(q*((f-(v+p*c))*(j-(u+p*d))-(g-(u+p*d))*(i-(v+p*c)))+r*((g-(u+p*d))*(h-(t+p*b))-(j-(u+p*d))*(e-(t+p*b))))>-1.1920928955078125e-06:0)?s*((l-(v+p*c))*(h-(t+p*b))-(i-(v+p*c))*(k-(t+p*b)))+(q*((i-(v+p*c))*(m-(u+p*d))-(j-(u+p*d))*(l-(v+p*c)))+r*((j-(u+p*d))*(k-(t+p*b))-(m-(u+p*d))*(h-(t+p*b))))>-1.1920928955078125e-06:0)?s*((f-(v+p*c))*(k-(t+p*b))-(l-(v+p*c))*(e-(t+p*b)))+(q*((l-(v+p*c))*(g-(u+p*d))-(m-(u+p*d))*(f-(v+p*c)))+r*((m-(u+p*d))*(e-(t+p*b))-(g-(u+p*d))*(k-(t+p*b))))>-1.1920928955078125e-06:0){v=p;return +v}v=-1.0;return +v}function Jh(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;if(b[a+165>>0]|0){if((f[a+92>>2]|0)>=(c|0))return;if((c|0)!=0?(f[6472]=(f[6472]|0)+1,d=sc((c<<4|3)+16|0)|0,(d|0)!=0):0){f[(d+4+15&-16)+-4>>2]=d;g=d+4+15&-16}else g=0;e=f[a+88>>2]|0;if((e|0)>0){d=0;do{i=g+(d<<4)|0;h=(f[a+96>>2]|0)+(d<<4)|0;f[i>>2]=f[h>>2];f[i+4>>2]=f[h+4>>2];f[i+8>>2]=f[h+8>>2];f[i+12>>2]=f[h+12>>2];d=d+1|0}while((d|0)!=(e|0))}d=f[a+96>>2]|0;if(d|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=g;f[a+92>>2]=c;return}if((f[a+112>>2]|0)>=(c|0))return;if((c|0)!=0?(f[6472]=(f[6472]|0)+1,e=sc((c<<2|3)+16|0)|0,(e|0)!=0):0){f[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}else h=0;e=f[a+108>>2]|0;g=f[a+116>>2]|0;if((e|0)<=0)if(!g)d=a+120|0;else i=21;else{d=0;do{f[h+(d<<2)>>2]=f[g+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0));i=21}if((i|0)==21){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+116>>2]=0;d=a+120|0}b[d>>0]=1;f[a+116>>2]=h;f[a+112>>2]=c;return}function Kh(a,b,c,d,e,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;if(!(f[i+44>>2]|0))return;b=f[i+20>>2]|0;if(!(f[i+64>>2]&256)){if((b|0)<=0)return;d=0;do{c=f[a+28>>2]|0;if((c|0)>0){b=0;do{j=f[(f[a+116>>2]|0)+(b<<2)>>2]|0;h=f[a+36>>2]|0;g=f[a+16>>2]|0;Fg(g+((f[h+(j*152|0)+144>>2]|0)*244|0)|0,g+((f[h+(j*152|0)+148>>2]|0)*244|0)|0,h+(j*152|0)|0);b=b+1|0}while((b|0)!=(c|0));b=f[i+20>>2]|0}d=d+1|0}while((d|0)<(b|0));return}else{if((b|0)<=0)return;d=0;do{c=f[a+28>>2]|0;if((c|0)>0){b=0;do{j=f[(f[a+116>>2]|0)+(b<<2)>>2]|0;h=f[a+36>>2]|0;g=f[a+16>>2]|0;Fg(g+((f[h+(j*152|0)+144>>2]|0)*244|0)|0,g+((f[h+(j*152|0)+148>>2]|0)*244|0)|0,h+(j*152|0)|0);b=b+1|0}while((b|0)!=(c|0));b=f[i+20>>2]|0}d=d+1|0}while((d|0)<(b|0));return}}function Lh(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0;if(!(b[a+164>>0]|0)){if((f[a+152>>2]|0)>=(c|0))return;if((c|0)!=0?(f[6472]=(f[6472]|0)+1,g=sc((c<<1)+19|0)|0,(g|0)!=0):0){f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}else i=0;g=f[a+148>>2]|0;h=f[a+156>>2]|0;if((g|0)<=0)if(!h)e=a+160|0;else j=22;else{e=0;do{d[i+(e<<1)>>1]=d[h+(e<<1)>>1]|0;e=e+1|0}while((e|0)!=(g|0));j=22}if((j|0)==22){if(b[a+160>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+156>>2]=0;e=a+160|0}b[e>>0]=1;f[a+156>>2]=i;f[a+152>>2]=c;return}else{if((f[a+132>>2]|0)>=(c|0))return;if((c|0)!=0?(f[6472]=(f[6472]|0)+1,e=sc((c<<2|3)+16|0)|0,(e|0)!=0):0){f[(e+4+15&-16)+-4>>2]=e;i=e+4+15&-16}else i=0;g=f[a+128>>2]|0;h=f[a+136>>2]|0;if((g|0)<=0)if(!h)e=a+140|0;else j=10;else{e=0;do{f[i+(e<<2)>>2]=f[h+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));j=10}if((j|0)==10){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+136>>2]=0;e=a+140|0}b[e>>0]=1;f[a+136>>2]=i;f[a+132>>2]=c;return}}function Mh(a,b,c){a=a|0;b=b|0;c=c|0;gi(a,b,c)|0;f[b+52>>2]=f[a+300>>2];f[b+56>>2]=f[a+304>>2];f[b+60>>2]=f[a+308>>2];f[b+64>>2]=f[a+312>>2];f[b+68>>2]=f[a+316>>2];f[b+72>>2]=f[a+320>>2];f[b+76>>2]=f[a+324>>2];f[b+80>>2]=f[a+328>>2];f[b+84>>2]=f[a+332>>2];f[b+88>>2]=f[a+336>>2];f[b+92>>2]=f[a+340>>2];f[b+96>>2]=f[a+344>>2];f[b+100>>2]=f[a+348>>2];f[b+104>>2]=f[a+352>>2];f[b+108>>2]=f[a+356>>2];f[b+112>>2]=f[a+360>>2];f[b+116>>2]=f[a+364>>2];f[b+120>>2]=f[a+368>>2];f[b+124>>2]=f[a+372>>2];f[b+128>>2]=f[a+376>>2];f[b+132>>2]=f[a+380>>2];f[b+136>>2]=f[a+384>>2];f[b+140>>2]=f[a+388>>2];f[b+144>>2]=f[a+392>>2];f[b+148>>2]=f[a+396>>2];f[b+152>>2]=f[a+400>>2];f[b+156>>2]=f[a+404>>2];f[b+160>>2]=f[a+408>>2];f[b+164>>2]=f[a+412>>2];f[b+168>>2]=f[a+416>>2];f[b+172>>2]=f[a+420>>2];f[b+176>>2]=f[a+424>>2];f[b+180>>2]=f[a+444>>2];f[b+184>>2]=f[a+448>>2];f[b+188>>2]=f[a+452>>2];f[b+192>>2]=f[a+428>>2];f[b+196>>2]=f[a+432>>2];f[b+200>>2]=f[a+436>>2];f[b+204>>2]=f[a+440>>2];return 12907}function Nh(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;f[6472]=(f[6472]|0)+1;g=sc(55)|0;if(!g)i=0;else{f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}f[i>>2]=c;f[i+4>>2]=d;f[i+8>>2]=e;f[i+12>>2]=-1;f[i+16>>2]=-1;f[i+20>>2]=-1;f[i+28>>2]=-1;n[i+32>>2]=0.0;e=i;c=f[a+4>>2]|0;f[i+24>>2]=c;if((c|0)!=(f[a+8>>2]|0)){h=c;d=a+12|0;d=f[d>>2]|0;d=d+(h<<2)|0;f[d>>2]=e;h=h+1|0;f[a+4>>2]=h;return i|0}h=c|0?c<<1:1;if((c|0)>=(h|0)){h=c;d=a+12|0;d=f[d>>2]|0;d=d+(h<<2)|0;f[d>>2]=e;h=h+1|0;f[a+4>>2]=h;return i|0}if(!h)g=0;else{f[6472]=(f[6472]|0)+1;g=sc((h<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}c=f[a+4>>2]|0}if((c|0)>0){d=0;do{f[g+(d<<2)>>2]=f[(f[a+12>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(c|0))}d=f[a+12>>2]|0;if(d){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+4>>2]|0}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=g;f[a+8>>2]=h;h=c;d=a+12|0;d=f[d>>2]|0;d=d+(h<<2)|0;f[d>>2]=e;h=h+1|0;f[a+4>>2]=h;return i|0}function Oh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;o=+rb[f[(f[a>>2]|0)+48>>2]&15](a);u=+n[a+72>>2];t=+n[a+56>>2];r=+n[a+76>>2];q=+n[a+60>>2];m=+n[a+80>>2];l=+n[a+64>>2];E=+n[b>>2];y=+K(+E);D=+n[b+4>>2];x=+K(+D);j=+n[b+8>>2];k=+K(+j);C=+n[b+16>>2];w=+K(+C);B=+n[b+20>>2];v=+K(+B);h=+n[b+24>>2];i=+K(+h);A=+n[b+32>>2];s=+K(+A);z=+n[b+36>>2];p=+K(+z);e=+n[b+40>>2];g=+K(+e);j=(u+t)*.5*E+(r+q)*.5*D+(m+l)*.5*j+ +n[b+48>>2];h=(u+t)*.5*C+(r+q)*.5*B+(m+l)*.5*h+ +n[b+52>>2];e=(u+t)*.5*A+(r+q)*.5*z+(m+l)*.5*e+ +n[b+56>>2];k=(o+(u-t)*.5)*y+(o+(r-q)*.5)*x+(o+(m-l)*.5)*k;i=(o+(u-t)*.5)*w+(o+(r-q)*.5)*v+(o+(m-l)*.5)*i;g=(o+(u-t)*.5)*s+(o+(r-q)*.5)*p+(o+(m-l)*.5)*g;n[c>>2]=j-k;n[c+4>>2]=h-i;n[c+8>>2]=e-g;n[c+12>>2]=0.0;n[d>>2]=k+j;n[d+4>>2]=i+h;n[d+8>>2]=g+e;n[d+12>>2]=0.0;return}function Ph(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0;e=u;u=u+16|0;y=f[a+52>>2]|0;z=f[a+28+(((y+2|0)%3|0)<<2)>>2]|0;f[e>>2]=z;f[e+4>>2]=z;f[e+8>>2]=z;n[e+12>>2]=0.0;n[e+(y<<2)>>2]=+n[a+28+(y<<2)>>2]+(f[s>>2]=z,+n[s>>2]);i=+rb[f[(f[a>>2]|0)+48>>2]&15](a);g=+rb[f[(f[a>>2]|0)+48>>2]&15](a);l=+rb[f[(f[a>>2]|0)+48>>2]&15](a);i=i+ +n[e>>2];n[e>>2]=i;g=g+ +n[e+4>>2];n[e+4>>2]=g;l=l+ +n[e+8>>2];v=+K(+(+n[b>>2]));t=+K(+(+n[b+4>>2]));w=+K(+(+n[b+8>>2]));p=+K(+(+n[b+16>>2]));o=+K(+(+n[b+20>>2]));q=+K(+(+n[b+24>>2]));j=+K(+(+n[b+32>>2]));h=+K(+(+n[b+36>>2]));k=+K(+(+n[b+40>>2]));x=+n[b+48>>2];r=+n[b+52>>2];m=+n[b+56>>2];n[c>>2]=x-(l*w+(v*i+t*g));n[c+4>>2]=r-(l*q+(p*i+o*g));n[c+8>>2]=m-(l*k+(j*i+h*g));n[c+12>>2]=0.0;n[d>>2]=x+(l*w+(v*i+t*g));n[d+4>>2]=r+(l*q+(p*i+o*g));n[d+8>>2]=m+(l*k+(j*i+h*g));n[d+12>>2]=0.0;u=e;return}function Qh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0;if(b[c+32>>0]&1){e=f[a+4>>2]|0;if(e|0)ll(e,c,d);e=f[a>>2]|0;if(e|0){m=+n[c>>2];k=+n[e+128>>2];l=+n[c+4>>2];j=+n[c+8>>2];g=+n[d+4>>2];p=+n[d+8>>2];o=+n[d>>2];i=+n[e+180>>2]*(j*g-l*p)+ +n[e+184>>2]*(m*p-j*o)+(l*o-m*g)*+n[e+188>>2];h=(j*g-l*p)*+n[e+196>>2]+(m*p-j*o)*+n[e+200>>2]+(l*o-m*g)*+n[e+204>>2];g=(j*g-l*p)*+n[e+212>>2]+(m*p-j*o)*+n[e+216>>2]+(l*o-m*g)*+n[e+220>>2];n[e+244>>2]=m*k+ +n[e+244>>2];n[e+248>>2]=k*l+ +n[e+248>>2];n[e+252>>2]=k*j+ +n[e+252>>2];n[e+316>>2]=m*k+ +n[e+316>>2];n[e+320>>2]=k*l+ +n[e+320>>2];n[e+324>>2]=k*j+ +n[e+324>>2];n[e+260>>2]=i+ +n[e+260>>2];n[e+264>>2]=h+ +n[e+264>>2];n[e+268>>2]=g+ +n[e+268>>2];n[e+332>>2]=i+ +n[e+332>>2];n[e+336>>2]=h+ +n[e+336>>2];n[e+340>>2]=g+ +n[e+340>>2];f[e+308>>2]=(f[e+308>>2]|0)+1}}if(!(b[c+32>>0]&2))return;dj(a,c+16|0,d);return}function Rh(a){a=a|0;var b=0,c=0,d=0,e=0;c=u;u=u+16|0;uj(14480);Lb[f[(f[a>>2]|0)+8>>2]&511](a);Lb[f[(f[a>>2]|0)+12>>2]&511](a);b=f[a+24>>2]|0;uj(14514);if(b|0){e=f[(f[b>>2]|0)+32>>2]|0;d=f[a+68>>2]|0;d=Bb[f[(f[d>>2]|0)+36>>2]&127](d)|0;Yb[e&127](b,d,a+28|0,f[a+24>>2]|0)}b=f[2405]|0;e=(f[b+16>>2]|0)+-1|0;f[b+16>>2]=e;do if(!e){if(f[b+4>>2]|0){gb(c|0,0)|0;a=f[6471]|0;n[b+8>>2]=+n[b+8>>2]+ +(((f[c+4>>2]|0)-(f[a+4>>2]|0)+(((f[c>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[b+12>>2]|0)|0)>>>0)/1.0e3;a=f[2405]|0;if(f[b+16>>2]|0)break}else a=b;a=f[a+20>>2]|0;f[2405]=a}else a=b;while(0);b=a+16|0;e=(f[b>>2]|0)+-1|0;f[b>>2]=e;if(e|0){u=c;return}do if(f[a+4>>2]|0){gb(c|0,0)|0;d=f[6471]|0;e=a+8|0;n[e>>2]=+n[e>>2]+ +(((f[c+4>>2]|0)-(f[d+4>>2]|0)+(((f[c>>2]|0)-(f[d>>2]|0)|0)*1e6|0)-(f[a+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[b>>2]|0)){a=f[2405]|0;break}else{u=c;return}}while(0);f[2405]=f[a+20>>2];u=c;return}function Sh(a,c){a=a|0;c=c|0;var d=0;f[a>>2]=9032;b[a+40>>0]=1;f[a+36>>2]=0;f[a+28>>2]=0;f[a+32>>2]=0;b[a+60>>0]=1;f[a+56>>2]=0;f[a+48>>2]=0;f[a+52>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=-1;f[a+16>>2]=0;f[a+20>>2]=0;b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;f[a+64>>2]=0;f[a+68>>2]=0;f[a+72>>2]=-1;f[a+76>>2]=0;f[a+80>>2]=0;b[a+193>>0]=0;b[a+194>>0]=1;b[a+192>>0]=((c|0)!=0^1)&1;n[a+140>>2]=0.0;f[a+144>>2]=0;f[a+164>>2]=0;f[a+148>>2]=1;f[a+152>>2]=0;f[a+156>>2]=10;f[a+160>>2]=1;f[a+168>>2]=0;f[a+172>>2]=0;n[a+176>>2]=0.0;if(c|0){d=c;c=a+136|0;f[c>>2]=d;c=a+188|0;f[c>>2]=0;c=a+180|0;f[c>>2]=0;c=a+184|0;f[c>>2]=0;a=a+124|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}f[6472]=(f[6472]|0)+1;c=sc(95)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}Ci(c);d=a+136|0;f[d>>2]=c;d=a+188|0;f[d>>2]=0;d=a+180|0;f[d>>2]=0;d=a+184|0;f[d>>2]=0;d=a+124|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;return}function Th(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;c=f[a+16>>2]|0;if(c|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;c=f[a+40>>2]|0;if(c|0){if(b[a+44>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+40>>2]=0}b[a+44>>0]=1;f[a+40>>2]=0;f[a+32>>2]=0;f[a+36>>2]=0;c=f[a+60>>2]|0;if(c|0){if(b[a+64>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+60>>2]=0}b[a+64>>0]=1;f[a+60>>2]=0;f[a+52>>2]=0;f[a+56>>2]=0;if((f[a+12>>2]|0)>=2){Lf(a);return}f[6472]=(f[6472]|0)+1;c=sc(43)|0;if(!c)e=0;else{f[(c+4+15&-16)+-4>>2]=c;e=c+4+15&-16}d=f[a+8>>2]|0;if((d|0)>0){c=0;do{g=e+(c*12|0)|0;h=(f[a+16>>2]|0)+(c*12|0)|0;f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];c=c+1|0}while((c|0)!=(d|0))}c=f[a+16>>2]|0;if(c|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=e;f[a+12>>2]=2;Lf(a);return}function Uh(a,b,c){a=a|0;b=b|0;c=c|0;gi(a,b,c)|0;f[b+52>>2]=f[a+52>>2];f[b+56>>2]=f[a+56>>2];f[b+60>>2]=f[a+60>>2];f[b+64>>2]=f[a+64>>2];f[b+68>>2]=f[a+68>>2];f[b+72>>2]=f[a+72>>2];f[b+76>>2]=f[a+76>>2];f[b+80>>2]=f[a+80>>2];f[b+84>>2]=f[a+84>>2];f[b+88>>2]=f[a+88>>2];f[b+92>>2]=f[a+92>>2];f[b+96>>2]=f[a+96>>2];f[b+100>>2]=f[a+100>>2];f[b+104>>2]=f[a+104>>2];f[b+108>>2]=f[a+108>>2];f[b+112>>2]=f[a+112>>2];f[b+116>>2]=f[a+116>>2];f[b+120>>2]=f[a+120>>2];f[b+124>>2]=f[a+124>>2];f[b+128>>2]=f[a+128>>2];f[b+132>>2]=f[a+132>>2];f[b+136>>2]=f[a+136>>2];f[b+140>>2]=f[a+140>>2];f[b+144>>2]=f[a+144>>2];f[b+148>>2]=f[a+148>>2];f[b+152>>2]=f[a+152>>2];f[b+156>>2]=f[a+156>>2];f[b+160>>2]=f[a+160>>2];f[b+164>>2]=f[a+164>>2];f[b+168>>2]=f[a+168>>2];f[b+172>>2]=f[a+172>>2];f[b+176>>2]=f[a+176>>2];f[b+180>>2]=f[a+188>>2];f[b+184>>2]=f[a+184>>2];f[b+188>>2]=f[a+196>>2];f[b+192>>2]=f[a+192>>2];f[b+196>>2]=h[a+180>>0];f[b+200>>2]=h[a+49>>0];return 12863}function Vh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0;d=u;u=u+32|0;c=f[b+388>>2]|0;switch(f[a+388>>2]&48&c&63){case 32:{if((a|0)==(b|0)&(c&64|0)==0){u=d;return}n[d+4>>2]=1.0;f[d+8+4>>2]=0;f[d+8+4+4>>2]=0;f[d+8+4+8>>2]=0;f[d>>2]=3684;f[d+8>>2]=f[a+456>>2];c=f[a+192>>2]|0;e=+rb[f[(f[c>>2]|0)+48>>2]&15](c);c=f[b+192>>2]|0;e=e+ +rb[f[(f[c>>2]|0)+48>>2]&15](c);n[d+12>>2]=e;f[d+16>>2]=f[(+n[a+316>>2]<+n[b+316>>2]?a+316|0:b+316|0)>>2];f[d+24>>2]=a;f[d+28>>2]=b;Ee(f[a+1048>>2]|0,f[b+1048>>2]|0,d);u=d;return}case 16:{if((a|0)==(b|0)){u=d;return}f[d>>2]=3720;c=f[a+192>>2]|0;e=+rb[f[(f[c>>2]|0)+48>>2]&15](c);c=f[b+192>>2]|0;e=e+ +rb[f[(f[c>>2]|0)+48>>2]&15](c);n[d+12>>2]=e;f[d+4>>2]=a;f[d+8>>2]=b;Ee(f[a+928>>2]|0,f[b+988>>2]|0,d);f[d+4>>2]=b;f[d+8>>2]=a;Ee(f[b+928>>2]|0,f[a+988>>2]|0,d);u=d;return}default:{u=d;return}}}function Wh(){var a=0,c=0,d=0;a=xs(288)|0;f[a+164>>2]=1065353216;f[a+168>>2]=1065353216;f[a+172>>2]=1065353216;n[a+176>>2]=0.0;f[a+180>>2]=0;n[a+184>>2]=999999984306749440.0;f[a+188>>2]=0;f[a+188+4>>2]=0;f[a+188+8>>2]=0;f[a+188+12>>2]=0;f[a+204>>2]=1;f[a+208>>2]=-1;f[a+212>>2]=-1;f[a+216>>2]=1;n[a+220>>2]=0.0;n[a+224>>2]=.5;n[a+228>>2]=0.0;n[a+232>>2]=0.0;f[a+240>>2]=0;n[a+244>>2]=1.0;f[a+248>>2]=0;f[a+248+4>>2]=0;f[a+248+8>>2]=0;f[a+248+12>>2]=0;f[a+4>>2]=1065353216;f[a+8>>2]=0;f[a+8+4>>2]=0;f[a+8+8>>2]=0;f[a+8+12>>2]=0;f[a+24>>2]=1065353216;f[a+28>>2]=0;f[a+28+4>>2]=0;f[a+28+8>>2]=0;f[a+28+12>>2]=0;f[a+44>>2]=1065353216;f[a+48>>2]=0;f[a+48+4>>2]=0;f[a+48+8>>2]=0;f[a+48+12>>2]=0;f[a+48+16>>2]=0;b[a+280>>0]=1;f[a+276>>2]=0;f[a+268>>2]=0;f[a+272>>2]=0;f[a+236>>2]=4;f[a>>2]=5280;f[6472]=(f[6472]|0)+1;c=sc(95)|0;if(!c){d=0;Ci(d);c=a+284|0;f[c>>2]=d;return a|0}f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16;Ci(c);d=a+284|0;f[d>>2]=c;return a|0}function Xh(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0.0,i=0.0,j=0.0,k=0.0;g=u;u=u+96|0;n[g+4>>2]=1.0;f[g+8>>2]=0;d[g+12>>1]=1;d[g+14>>1]=-1;f[g+16>>2]=0;f[g>>2]=2920;f[g+20>>2]=f[b>>2];f[g+20+4>>2]=f[b+4>>2];f[g+20+8>>2]=f[b+8>>2];f[g+20+12>>2]=f[b+12>>2];f[g+36>>2]=f[c>>2];f[g+36+4>>2]=f[c+4>>2];f[g+36+8>>2]=f[c+8>>2];f[g+36+12>>2]=f[c+12>>2];a=f[a+4>>2]|0;Yb[f[(f[a>>2]|0)+32>>2]&127](a,b,c,g);a=f[g+8>>2]|0;if(!a){e=0;u=g;return e|0}if(!(f[a+236>>2]&2)){e=0;u=g;return e|0}if(f[a+204>>2]&4|0){e=0;u=g;return e|0}f[e>>2]=f[g+68>>2];f[e+4>>2]=f[g+68+4>>2];f[e+8>>2]=f[g+68+8>>2];f[e+12>>2]=f[g+68+12>>2];f[e+16>>2]=f[g+52>>2];f[e+16+4>>2]=f[g+52+4>>2];f[e+16+8>>2]=f[g+52+8>>2];f[e+16+12>>2]=f[g+52+12>>2];k=+n[e+16>>2];j=+n[e+20>>2];i=+n[e+24>>2];h=1.0/+L(+(k*k+j*j+i*i));n[e+16>>2]=k*h;n[e+20>>2]=j*h;n[e+24>>2]=i*h;f[e+32>>2]=f[g+4>>2];e=a;u=g;return e|0}function Yh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;Lb[f[(f[b>>2]|0)+32>>2]&511](b);d=Fb[f[(f[b>>2]|0)+16>>2]&63](b,104,1)|0;c=f[d+8>>2]|0;e=c;g=e+104|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(g|0));f[c+88>>2]=f[a+248>>2];f[c+92>>2]=f[a+252>>2];f[c+96>>2]=f[a+256>>2];f[c+100>>2]=f[a+260>>2];f[c>>2]=f[a+92>>2];f[c+4>>2]=f[a+96>>2];f[c+8>>2]=f[a+100>>2];f[c+12>>2]=f[a+104>>2];f[c+16>>2]=f[a+108>>2];f[c+20>>2]=f[a+116>>2];f[c+24>>2]=f[a+120>>2];f[c+28>>2]=f[a+124>>2];f[c+32>>2]=f[a+128>>2];f[c+36>>2]=f[a+132>>2];f[c+40>>2]=f[a+140>>2];f[c+44>>2]=f[a+144>>2];f[c+48>>2]=f[a+148>>2];f[c+52>>2]=f[a+152>>2];f[c+56>>2]=f[a+168>>2];f[c+60>>2]=f[a+172>>2];f[c+64>>2]=f[a+112>>2];f[c+68>>2]=f[a+156>>2];f[c+72>>2]=f[a+160>>2];f[c+76>>2]=f[a+164>>2];f[c+80>>2]=f[a+136>>2];ac[f[(f[b>>2]|0)+20>>2]&31](b,d,12441,1145853764,c);hj(a,b);ud(a,b);Lb[f[(f[b>>2]|0)+36>>2]&511](b);return}function Zh(a,c){a=a|0;c=c|0;if((f[a+16>>2]|0)!=(0-(f[a+76>>2]|0)|0))return;c=f[a+4>>2]|0;if(c|0)qn(a+4|0,c);c=f[a+8>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+8>>2]=0;f[a+12>>2]=-1;c=f[a+36>>2]|0;if(c|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=0;f[a+28>>2]=0;f[a+32>>2]=0;f[a+20>>2]=0;c=f[a+64>>2]|0;if(c|0)qn(a+64|0,c);c=f[a+68>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+68>>2]=0;f[a+72>>2]=-1;c=f[a+96>>2]|0;if(c|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;f[a+80>>2]=0;b[a+193>>0]=0;b[a+194>>0]=1;f[a+144>>2]=0;f[a+164>>2]=0;f[a+148>>2]=1;f[a+152>>2]=0;f[a+156>>2]=10;f[a+160>>2]=1;f[a+124>>2]=0;f[a+124+4>>2]=0;f[a+124+8>>2]=0;f[a+168>>2]=0;f[a+168+4>>2]=0;f[a+168+8>>2]=0;f[a+168+12>>2]=0;f[a+168+16>>2]=0;f[a+168+20>>2]=0;return}function _h(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;u=u+48|0;g=l;h=g+44|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(h|0));if(!c)j=f[f[a+880>>2]>>2]|0;else j=c;c=f[a+732>>2]|0;if((c|0)==(f[a+736>>2]|0)?(k=c|0?c<<1:1,(c|0)<(k|0)):0){if(!k)i=0;else{f[6472]=(f[6472]|0)+1;c=sc((k*52|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}i=c;c=f[a+732>>2]|0}if((c|0)>0){d=0;do{g=i+(d*52|0)|0;e=(f[a+740>>2]|0)+(d*52|0)|0;h=g+52|0;do{f[g>>2]=f[e>>2];g=g+4|0;e=e+4|0}while((g|0)<(h|0));d=d+1|0}while((d|0)!=(c|0))}c=f[a+740>>2]|0;if(c|0){if(b[a+744>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+740>>2]=0}b[a+744>>0]=1;f[a+740>>2]=i;f[a+736>>2]=k;c=f[a+732>>2]|0}g=f[a+740>>2]|0;f[g+(c*52|0)>>2]=0;f[g+(c*52|0)+4>>2]=j;g=g+(c*52|0)+8|0;e=l;h=g+44|0;do{f[g>>2]=f[e>>2];g=g+4|0;e=e+4|0}while((g|0)<(h|0));f[a+732>>2]=(f[a+732>>2]|0)+1;u=l;return}function $h(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0,i=0.0;h=u;u=u+32|0;f[h+16>>2]=f[c>>2];f[h+16+4>>2]=f[c+4>>2];f[h+16+8>>2]=f[c+8>>2];f[h+16+12>>2]=f[c+12>>2];e=+n[h+16>>2];g=+n[h+16+4>>2];d=+n[h+16+8>>2];if(e*e+g*g+d*d<1.4210854715202004e-14){f[h+16>>2]=-1082130432;f[h+16+4>>2]=-1082130432;f[h+16+8>>2]=-1082130432;n[h+16+12>>2]=0.0;e=-1.0;g=-1.0;d=-1.0}i=1.0/+L(+(e*e+g*g+d*d));n[h+16>>2]=e*i;n[h+16+4>>2]=g*i;n[h+16+8>>2]=d*i;Gd(h,b,h+16|0);switch(f[b+4>>2]|0){case 8:{d=+n[b+28>>2]*+n[b+12>>2];break}case 0:{d=+n[b+44>>2];break}case 1:{d=+n[b+44>>2];break}case 13:{d=+n[b+44>>2];break}case 11:{d=+n[b+44>>2];break}case 10:{d=+n[b+44>>2];break}case 4:case 5:{d=+n[b+44>>2];break}default:d=+rb[f[(f[b>>2]|0)+48>>2]&15](b)}g=d*+n[h+16+4>>2]+ +n[h+4>>2];i=d*+n[h+16+8>>2]+ +n[h+8>>2];n[a>>2]=d*+n[h+16>>2]+ +n[h>>2];n[a+4>>2]=g;n[a+8>>2]=i;n[a+12>>2]=0.0;u=h;return}function ai(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0,h=0.0,i=0,j=0,k=0,l=0.0;j=u;u=u+80|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;d=+n[c>>2];e=+n[c+4>>2];h=+n[c+8>>2];if(d*d+e*e+h*h<9.999999747378752e-05){i=1065353216;g=0;d=0.0;c=0}else{l=1.0/+L(+(d*d+e*e+h*h));i=(n[s>>2]=d*l,f[s>>2]|0);k=(n[s>>2]=e*l,f[s>>2]|0);g=(n[s>>2]=h*l,f[s>>2]|0);d=+n[c+12>>2];c=k}f[j+32>>2]=8016;k=j+32+4|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;n[j+32+20>>2]=-999999984306749440.0;f[j+32+24>>2]=i;f[j+32+28>>2]=c;f[j+32+32>>2]=g;n[j+32+36>>2]=d;f[j+16>>2]=1566444395;f[j+16+4>>2]=1566444395;f[j+16+8>>2]=1566444395;n[j+16+12>>2]=0.0;b=f[b+92>>2]|0;i=f[(f[b>>2]|0)+8>>2]|0;n[j>>2]=-999999984306749440.0;n[j+4>>2]=-999999984306749440.0;n[j+8>>2]=-999999984306749440.0;n[j+12>>2]=0.0;Yb[i&127](b,j+32|0,j,j+16|0);f[a>>2]=f[k>>2];f[a+4>>2]=f[k+4>>2];f[a+8>>2]=f[k+8>>2];f[a+12>>2]=f[k+12>>2];u=j;return}function bi(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=Db[f[(f[c>>2]|0)+40>>2]&31](c,a)|0;g=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b>>2]=g;if(g|0)Rb[f[(f[c>>2]|0)+48>>2]&127](c,d);f[b+4>>2]=f[a+4>>2];f[b+28>>2]=f[a+28>>2];f[b+32>>2]=f[a+32>>2];f[b+36>>2]=f[a+36>>2];f[b+40>>2]=f[a+40>>2];f[b+12>>2]=f[a+12>>2];f[b+16>>2]=f[a+16>>2];f[b+20>>2]=f[a+20>>2];f[b+24>>2]=f[a+24>>2];f[b+44>>2]=f[a+44>>2];e=f[a+96>>2]|0;f[b+60>>2]=e;if(!e){f[b+52>>2]=0;f[b+56>>2]=0;return 17487}g=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+104>>2]|0)|0;f[b+52>>2]=g;f[b+56>>2]=0;g=Fb[f[(f[c>>2]|0)+16>>2]&63](c,16,e)|0;if((e|0)>0){d=f[a+104>>2]|0;b=f[g+8>>2]|0;a=0;while(1){f[b>>2]=f[d+(a<<4)>>2];f[b+4>>2]=f[d+(a<<4)+4>>2];f[b+8>>2]=f[d+(a<<4)+8>>2];f[b+12>>2]=f[d+(a<<4)+12>>2];a=a+1|0;if((a|0)==(e|0))break;else b=b+16|0}}else d=f[a+104>>2]|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,g,19486,1497453121,d);return 17487}function ci(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0,h=0,i=0,j=0.0,k=0,l=0;l=f[a+4>>2]|0;a=f[a+64>>2]|0;do if(!l)if(!a){d=0;e=0.0;g=0;h=0;i=0;j=0.0;k=0;a=0}else{d=f[a>>2]|0;e=+n[a+12>>2];g=f[a+16>>2]|0;h=f[a+20>>2]|0;i=f[a+24>>2]|0;j=+n[a+28>>2];k=f[a+4>>2]|0;a=f[a+8>>2]|0}else if(!a){d=f[l>>2]|0;e=+n[l+12>>2];g=f[l+16>>2]|0;h=f[l+20>>2]|0;i=f[l+24>>2]|0;j=+n[l+28>>2];k=f[l+4>>2]|0;a=f[l+8>>2]|0;break}else{d=f[(+n[l>>2]<+n[a>>2]?l:a)>>2]|0;e=0.0;g=f[(+n[l+16>>2]>+n[a+16>>2]?l+16|0:a+16|0)>>2]|0;h=f[(+n[l+20>>2]>+n[a+20>>2]?l+16|0:a+16|0)+4>>2]|0;i=f[(+n[l+24>>2]>+n[a+24>>2]?l+16|0:a+16|0)+8>>2]|0;j=0.0;k=f[(+n[l+4>>2]<+n[a+4>>2]?l:a)+4>>2]|0;a=f[(+n[l+8>>2]<+n[a+8>>2]?l:a)+8>>2]|0;break}while(0);f[b>>2]=d;f[b+4>>2]=k;f[b+8>>2]=a;n[b+12>>2]=e;f[c>>2]=g;f[c+4>>2]=h;f[c+8>>2]=i;n[c+12>>2]=j;return}function di(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0,h=0.0,i=0.0,j=0.0,k=0,l=0.0;j=+n[b+60>>2]*.5;k=f[b+68>>2]|0;e=+n[c>>2];h=+n[c+4>>2];i=+n[c+8>>2];i=+L(+(e*e+h*h+i*i));g=f[b+64>>2]|0;do if(!(+n[c+(k<<2)>>2]>i*+n[b+52>>2])){e=+n[c+(g<<2)>>2];d=f[b+72>>2]|0;h=+n[c+(d<<2)>>2];i=+L(+(e*e+h*h));if(i>1.1920928955078125e-07){i=+n[b+56>>2]/i;n[a+(g<<2)>>2]=e*i;n[a+(k<<2)>>2]=-j;e=h*i;break}else{n[a+(g<<2)>>2]=0.0;n[a+(k<<2)>>2]=-j;e=0.0;break}}else{n[a+(g<<2)>>2]=0.0;n[a+(k<<2)>>2]=j;e=0.0;d=f[b+72>>2]|0}while(0);n[a+(d<<2)>>2]=e;if(!(+rb[f[(f[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+n[c>>2];i=+n[c+4>>2];j=+n[c+8>>2];l=h*h+i*i+j*j<1.4210854715202004e-14?-1.0:h;e=h*h+i*i+j*j<1.4210854715202004e-14?-1.0:i;j=h*h+i*i+j*j<1.4210854715202004e-14?-1.0:j;i=1.0/+L(+(j*j+(l*l+e*e)));h=+rb[f[(f[b>>2]|0)+48>>2]&15](b);n[a>>2]=+n[a>>2]+h*i*l;n[a+4>>2]=h*i*e+ +n[a+4>>2];n[a+8>>2]=h*i*j+ +n[a+8>>2];return}function ei(a,b,c){a=a|0;b=b|0;c=c|0;f[a+300>>2]=f[b>>2];f[a+300+4>>2]=f[b+4>>2];f[a+300+8>>2]=f[b+8>>2];f[a+300+12>>2]=f[b+12>>2];f[a+316>>2]=f[b+16>>2];f[a+316+4>>2]=f[b+16+4>>2];f[a+316+8>>2]=f[b+16+8>>2];f[a+316+12>>2]=f[b+16+12>>2];f[a+332>>2]=f[b+32>>2];f[a+332+4>>2]=f[b+32+4>>2];f[a+332+8>>2]=f[b+32+8>>2];f[a+332+12>>2]=f[b+32+12>>2];f[a+348>>2]=f[b+48>>2];f[a+348+4>>2]=f[b+48+4>>2];f[a+348+8>>2]=f[b+48+8>>2];f[a+348+12>>2]=f[b+48+12>>2];f[a+364>>2]=f[c>>2];f[a+364+4>>2]=f[c+4>>2];f[a+364+8>>2]=f[c+8>>2];f[a+364+12>>2]=f[c+12>>2];f[a+380>>2]=f[c+16>>2];f[a+380+4>>2]=f[c+16+4>>2];f[a+380+8>>2]=f[c+16+8>>2];f[a+380+12>>2]=f[c+16+12>>2];f[a+396>>2]=f[c+32>>2];f[a+396+4>>2]=f[c+32+4>>2];f[a+396+8>>2]=f[c+32+8>>2];f[a+396+12>>2]=f[c+32+12>>2];f[a+412>>2]=f[c+48>>2];f[a+412+4>>2]=f[c+48+4>>2];f[a+412+8>>2]=f[c+48+8>>2];f[a+412+12>>2]=f[c+48+12>>2];Lb[f[(f[a>>2]|0)+8>>2]&511](a);return}function fi(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0;c=u;u=u+48|0;mh(a+364|0,c+16|0);g=-+n[c+16>>2];e=-+n[c+16+4>>2];k=-+n[c+16+8>>2];j=+n[c+16+12>>2];f=+n[b>>2];l=+n[b+12>>2];i=+n[b+8>>2];h=+n[b+4>>2];mh(a+300|0,c);o=+n[c>>2];p=+n[c+12>>2];d=+n[c+8>>2];m=+n[c+4>>2];n[c+32>>2]=(j*l-f*g-h*e-i*k)*o+(j*f+l*g+i*e-h*k)*p+(f*k+(l*e+j*h)-i*g)*d-(l*k+j*i+h*g-f*e)*m;n[c+32+4>>2]=o*(l*k+j*i+h*g-f*e)+(p*(f*k+(l*e+j*h)-i*g)+(j*l-f*g-h*e-i*k)*m)-(j*f+l*g+i*e-h*k)*d;n[c+32+8>>2]=(l*k+j*i+h*g-f*e)*p+(j*l-f*g-h*e-i*k)*d+(j*f+l*g+i*e-h*k)*m-o*(f*k+(l*e+j*h)-i*g);n[c+32+12>>2]=(j*l-f*g-h*e-i*k)*p-(j*f+l*g+i*e-h*k)*o-(f*k+(l*e+j*h)-i*g)*m-(l*k+j*i+h*g-f*e)*d;Xe(a,c+32|0);u=c;return}function gi(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+28>>2]|0)|0;f[b>>2]=d;d=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+32>>2]|0)|0;f[b+4>>2]=d;d=Db[f[(f[c>>2]|0)+40>>2]&31](c,a)|0;e=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b+8>>2]=e;if(e|0)Rb[f[(f[c>>2]|0)+48>>2]&127](c,d);f[b+12>>2]=f[a+4>>2];f[b+24>>2]=h[a+21>>0];f[b+40>>2]=f[a+24>>2];f[b+44>>2]=f[a+16>>2];f[b+48>>2]=h[a+20>>0];f[b+20>>2]=f[a+12>>2];f[b+16>>2]=f[a+8>>2];f[b+28>>2]=f[a+36>>2];f[b+32>>2]=f[a+40>>2];f[b+36>>2]=0;d=f[a+28>>2]|0;if((f[d+488>>2]|0)>0){c=0;do{if((f[(f[d+496>>2]|0)+(c<<2)>>2]|0)==(a|0)){f[b+36>>2]=1;d=f[a+28>>2]|0}c=c+1|0}while((c|0)<(f[d+488>>2]|0))}d=f[a+32>>2]|0;if((f[d+488>>2]|0)>0)c=0;else return 12836;do{if((f[(f[d+496>>2]|0)+(c<<2)>>2]|0)==(a|0)){f[b+36>>2]=1;d=f[a+32>>2]|0}c=c+1|0}while((c|0)<(f[d+488>>2]|0));return 12836}function hi(a){a=a|0;var c=0;c=f[a>>2]|0;if(c|0)qn(a,c);c=f[a+4>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+4>>2]=0;f[a+8>>2]=-1;c=f[a+32>>2]|0;if(c|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;f[a+16>>2]=0;c=f[a+52>>2]|0;if(!c){b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}if(!(b[a+56>>0]|0)){b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);c=f[a+32>>2]|0;b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;if(!c){b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0;b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}function ii(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;h=u;u=u+32|0;g=Us()|0;f[g+4>>2]=11;f[g+8>>2]=-1;f[g+12>>2]=-1;n[g+16>>2]=3402823466385288598117041.0e14;b[g+20>>0]=1;b[g+21>>0]=0;f[g+24>>2]=-1;f[g+28>>2]=a;f[g+32>>2]=c;n[g+36>>2]=0.0;n[g+40>>2]=.30000001192092896;f[g+44>>2]=0;f[g>>2]=4520;f[g+48>>2]=f[d+48>>2];f[g+48+4>>2]=f[d+48+4>>2];f[g+48+8>>2]=f[d+48+8>>2];f[g+48+12>>2]=f[d+48+12>>2];f[g+64>>2]=f[e+48>>2];f[g+64+4>>2]=f[e+48+4>>2];f[g+64+8>>2]=f[e+48+8>>2];f[g+64+12>>2]=f[e+48+12>>2];mh(d,h+16|0);mh(e,h);m=-+n[h>>2];k=-+n[h+4>>2];i=-+n[h+8>>2];q=+n[h+12>>2];p=+n[h+16+12>>2];o=+n[h+16>>2];l=+n[h+16+4>>2];j=+n[h+16+8>>2];n[g+80>>2]=p*m+q*o+l*i-j*k;n[g+84>>2]=j*m+(p*k+q*l)-o*i;n[g+88>>2]=o*k+(p*i+q*j)-l*m;n[g+92>>2]=q*p-o*m-l*k-j*i;u=h;return g|0}function ji(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;if(!d)d=f[a+188>>2]|0;j=f[c>>2]|0;e=f[a+268>>2]|0;a:do if((e|0)>0){h=f[a+276>>2]|0;g=0;while(1){if((f[h+(g<<2)>>2]|0)==(j|0))break;g=g+1|0;if((g|0)>=(e|0))break a}if((g|0)!=(e|0))return}while(0);if((e|0)==(f[a+272>>2]|0)?(i=e|0?e<<1:1,(e|0)<(i|0)):0){if(!i)h=0;else{f[6472]=(f[6472]|0)+1;e=sc((i<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=e;e=f[a+268>>2]|0}if((e|0)>0){g=0;do{f[h+(g<<2)>>2]=f[(f[a+276>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[a+276>>2]|0;if(g){if(b[a+280>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[a+268>>2]|0}f[a+276>>2]=0}b[a+280>>0]=1;f[a+276>>2]=h;f[a+272>>2]=i}f[(f[a+276>>2]|0)+(e<<2)>>2]=j;f[a+268>>2]=e+1;a=f[a+284>>2]|0;Fb[f[(f[a>>2]|0)+8>>2]&63](a,d,c)|0;return}function ki(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;if((d|0)>=8192)return fb(a|0,c|0,d|0)|0;h=a|0;g=a+d|0;if((a&3)==(c&3)){while(a&3){if(!d)return h|0;b[a>>0]=b[c>>0]|0;a=a+1|0;c=c+1|0;d=d-1|0}d=g&-4|0;e=d-64|0;while((a|0)<=(e|0)){f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];f[a+12>>2]=f[c+12>>2];f[a+16>>2]=f[c+16>>2];f[a+20>>2]=f[c+20>>2];f[a+24>>2]=f[c+24>>2];f[a+28>>2]=f[c+28>>2];f[a+32>>2]=f[c+32>>2];f[a+36>>2]=f[c+36>>2];f[a+40>>2]=f[c+40>>2];f[a+44>>2]=f[c+44>>2];f[a+48>>2]=f[c+48>>2];f[a+52>>2]=f[c+52>>2];f[a+56>>2]=f[c+56>>2];f[a+60>>2]=f[c+60>>2];a=a+64|0;c=c+64|0}while((a|0)<(d|0)){f[a>>2]=f[c>>2];a=a+4|0;c=c+4|0}}else{d=g-4|0;while((a|0)<(d|0)){b[a>>0]=b[c>>0]|0;b[a+1>>0]=b[c+1>>0]|0;b[a+2>>0]=b[c+2>>0]|0;b[a+3>>0]=b[c+3>>0]|0;a=a+4|0;c=c+4|0}}while((a|0)<(g|0)){b[a>>0]=b[c>>0]|0;a=a+1|0;c=c+1|0}return h|0}function li(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;if(Bb[f[(f[c>>2]|0)+16>>2]&127](c)|0)return;i=f[b+712>>2]|0;h=Bb[f[(f[c>>2]|0)+36>>2]&127](c)|0;if(Bb[f[(f[c>>2]|0)+8>>2]&127](c)|0?(d=Bb[f[(f[c>>2]|0)+20>>2]&127](c)|0,g=Bb[f[(f[c>>2]|0)+24>>2]&127](c)|0,(i|0)>0):0){e=f[b+720>>2]|0;a=h+(d<<2)|0;d=0;while(1){k=f[e+(d*104|0)+12>>2]|0;j=f[e+(d*104|0)+16>>2]|0;f[a>>2]=f[e+(d*104|0)+8>>2];f[a+4>>2]=k;f[a+8>>2]=j;d=d+1|0;if((d|0)==(i|0))break;else a=a+(g<<2)|0}}if(!(Bb[f[(f[c>>2]|0)+12>>2]&127](c)|0))return;a=Bb[f[(f[c>>2]|0)+28>>2]&127](c)|0;g=Bb[f[(f[c>>2]|0)+32>>2]&127](c)|0;if((i|0)<=0)return;e=f[b+720>>2]|0;a=h+(a<<2)|0;d=0;while(1){j=f[e+(d*104|0)+76>>2]|0;k=f[e+(d*104|0)+80>>2]|0;f[a>>2]=f[e+(d*104|0)+72>>2];f[a+4>>2]=j;f[a+8>>2]=k;d=d+1|0;if((d|0)==(i|0))break;else a=a+(g<<2)|0}return}function mi(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;f[a>>2]=9544;c=f[a+56>>2]|0;if(c|0){if(b[a+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+56>>2]=0}b[a+60>>0]=1;f[a+56>>2]=0;f[a+48>>2]=0;f[a+52>>2]=0;e=f[a+28>>2]|0;if((e|0)>0){c=0;do{g=f[a+36>>2]|0;h=g+(c*36|0)+4|0;i=g+(c*36|0)+12|0;j=f[i>>2]|0;d=g+(c*36|0)+16|0;if(j|0){if(b[d>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0)}f[i>>2]=0}b[d>>0]=1;f[i>>2]=0;f[h>>2]=0;f[g+(c*36|0)+8>>2]=0;c=c+1|0}while((c|0)!=(e|0))}c=f[a+36>>2]|0;if(c|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=0;f[a+28>>2]=0;f[a+32>>2]=0;c=f[a+16>>2]|0;if(!c){b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0;b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}function ni(a){a=a|0;var c=0;f[a>>2]=8644;c=f[a+156>>2]|0;if(c|0){if(b[a+160>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+156>>2]=0}b[a+160>>0]=1;f[a+156>>2]=0;f[a+148>>2]=0;f[a+152>>2]=0;c=f[a+136>>2]|0;if(c|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=0;f[a+128>>2]=0;f[a+132>>2]=0;c=f[a+116>>2]|0;if(c|0){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+116>>2]=0}b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;c=f[a+96>>2]|0;if(c|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;f[a>>2]=9560;c=f[a+32>>2]|0;if(!c){b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;a=a+28|0;f[a>>2]=0;return}if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0;b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;a=a+28|0;f[a>>2]=0;return}function oi(a){a=a|0;var c=0;f[a>>2]=9204;c=f[a+160>>2]|0;if(c|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=0;f[a+152>>2]=0;f[a+156>>2]=0;c=f[a+136>>2]|0;if(c|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=0;f[a+128>>2]=0;f[a+132>>2]=0;c=f[a+116>>2]|0;if(c|0){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+116>>2]=0}b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;c=f[a+96>>2]|0;if(c|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=0;f[a+88>>2]=0;f[a+92>>2]=0;c=f[a+76>>2]|0;if(!c){b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;a=a+72|0;f[a>>2]=0;return}if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+76>>2]=0;b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;a=a+72|0;f[a>>2]=0;return}function pi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,o=0;o=u;u=u+16|0;if((d|0)<=0){u=o;return}m=0;do{g=+n[a+60>>2]*.5;h=f[a+68>>2]|0;j=+n[b+(m<<4)>>2];k=+n[b+(m<<4)+4>>2];l=+n[b+(m<<4)+8>>2];l=+L(+(j*j+k*k+l*l));i=f[a+64>>2]|0;do if(!(+n[b+(m<<4)+(h<<2)>>2]>l*+n[a+52>>2])){j=+n[b+(m<<4)+(i<<2)>>2];e=f[a+72>>2]|0;k=+n[b+(m<<4)+(e<<2)>>2];l=+L(+(j*j+k*k));if(l>1.1920928955078125e-07){l=+n[a+56>>2]/l;n[o+(i<<2)>>2]=j*l;n[o+(h<<2)>>2]=-g;g=k*l;break}else{n[o+(i<<2)>>2]=0.0;n[o+(h<<2)>>2]=-g;g=0.0;break}}else{n[o+(i<<2)>>2]=0.0;n[o+(h<<2)>>2]=g;g=0.0;e=f[a+72>>2]|0}while(0);n[o+(e<<2)>>2]=g;i=c+(m<<4)|0;f[i>>2]=f[o>>2];f[i+4>>2]=f[o+4>>2];f[i+8>>2]=f[o+8>>2];f[i+12>>2]=f[o+12>>2];m=m+1|0}while((m|0)!=(d|0));u=o;return}function qi(a){a=a|0;var c=0;f[a>>2]=5012;c=f[a+144>>2]|0;if(c|0){if(b[a+148>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+144>>2]=0}b[a+148>>0]=1;f[a+144>>2]=0;f[a+136>>2]=0;f[a+140>>2]=0;c=f[a+76>>2]|0;if(c|0){if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+76>>2]=0}b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;f[a+72>>2]=0;c=f[a+56>>2]|0;if(c|0){if(b[a+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+56>>2]=0}b[a+60>>0]=1;f[a+56>>2]=0;f[a+48>>2]=0;f[a+52>>2]=0;c=f[a+36>>2]|0;if(c|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=0;f[a+28>>2]=0;f[a+32>>2]=0;c=f[a+16>>2]|0;if(!c){b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0;b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;a=a+12|0;f[a>>2]=0;return}function ri(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;o=(+n[a+32>>2]-+n[a+16>>2])*+n[a+108>>2]*.5;l=(+n[a+36>>2]-+n[a+20>>2])*+n[a+112>>2]*.5;j=(+n[a+40>>2]-+n[a+24>>2])*+n[a+116>>2]*.5;t=+K(+(+n[b>>2]));s=+K(+(+n[b+4>>2]));r=+K(+(+n[b+8>>2]));m=+K(+(+n[b+16>>2]));k=+K(+(+n[b+20>>2]));i=+K(+(+n[b+24>>2]));w=+K(+(+n[b+32>>2]));v=+K(+(+n[b+36>>2]));e=+K(+(+n[b+40>>2]));u=+n[b+48>>2];p=+n[b+52>>2];g=+n[b+56>>2];q=+rb[f[(f[a>>2]|0)+48>>2]&15](a);h=+rb[f[(f[a>>2]|0)+48>>2]&15](a);e=o*w+l*v+j*e+ +rb[f[(f[a>>2]|0)+48>>2]&15](a);n[c>>2]=u-(o*t+l*s+j*r+q);n[c+4>>2]=p-(o*m+l*k+j*i+h);n[c+8>>2]=g-e;n[c+12>>2]=0.0;n[d>>2]=u+(o*t+l*s+j*r+q);n[d+4>>2]=p+(o*m+l*k+j*i+h);n[d+8>>2]=g+e;n[d+12>>2]=0.0;return}function si(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=u;u=u+48|0;d=f[a+28>>2]|0;f[i+32>>2]=d;d=(f[a+20>>2]|0)-d|0;f[i+32+4>>2]=d;f[i+32+8>>2]=b;f[i+32+12>>2]=c;f[i>>2]=f[a+60>>2];f[i+4>>2]=i+32;f[i+8>>2]=2;e=dC(bb(146,i|0)|0)|0;a:do if((d+c|0)!=(e|0)){b=2;g=d+c|0;d=i+32|0;while(1){if((e|0)<0)break;g=g-e|0;j=f[d+4>>2]|0;k=e>>>0>j>>>0;d=k?d+8|0:d;b=b+(k<<31>>31)|0;j=e-(k?j:0)|0;f[d>>2]=(f[d>>2]|0)+j;f[d+4>>2]=(f[d+4>>2]|0)-j;f[i+16>>2]=f[a+60>>2];f[i+16+4>>2]=d;f[i+16+8>>2]=b;e=dC(bb(146,i+16|0)|0)|0;if((g|0)==(e|0)){h=3;break a}}f[a+16>>2]=0;f[a+28>>2]=0;f[a+20>>2]=0;f[a>>2]=f[a>>2]|32;if((b|0)==2)c=0;else c=c-(f[d+4>>2]|0)|0}else h=3;while(0);if((h|0)==3){k=f[a+44>>2]|0;f[a+16>>2]=k+(f[a+48>>2]|0);f[a+28>>2]=k;f[a+20>>2]=k}u=i;return c|0}function ti(a){a=a|0;var c=0;if((b[22712]|0)==0?fz(22712)|0:0){if((b[22664]|0)==0?fz(22664)|0:0){if((b[22672]|0)==0?fz(22672)|0:0){f[5768]=1065353216;f[5769]=0;f[5770]=0;f[5771]=0;f[5772]=0;f[5773]=1065353216;f[5774]=0;f[5775]=0;f[5776]=0;f[5777]=0;f[5778]=1065353216;n[5779]=0.0}f[5752]=f[5768];f[5753]=f[5769];f[5754]=f[5770];f[5755]=f[5771];f[5756]=f[5772];f[5757]=f[5773];f[5758]=f[5774];f[5759]=f[5775];f[5760]=f[5776];f[5761]=f[5777];f[5762]=f[5778];f[5763]=f[5779];f[5764]=0;f[5765]=0;f[5766]=0;f[5767]=0}f[5804]=f[5752];f[5805]=f[5753];f[5806]=f[5754];f[5807]=f[5755];f[5808]=f[5756];f[5809]=f[5757];f[5810]=f[5758];f[5811]=f[5759];f[5812]=f[5760];f[5813]=f[5761];f[5814]=f[5762];f[5815]=f[5763];f[5816]=f[5764];f[5817]=f[5765];f[5818]=f[5766];f[5819]=f[5767]}c=f[a+8>>2]|0;if(!c){c=f[a>>2]|0;return ((c|0)==0?23216:c+60|0)|0}else return c+4|0;return 0}function ui(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0;d=f[b>>2]|0;if((d|0)==(f[a+80>>2]|0)){e=1.0;return +e}if(f[d+204>>2]&4|0){e=1.0;return +e}if((+n[a+28>>2]-+n[a+12>>2])*+n[b+8>>2]+(+n[a+32>>2]-+n[a+16>>2])*+n[b+12>>2]+(+n[a+36>>2]-+n[a+20>>2])*+n[b+16>>2]>=-+n[a+84>>2]){e=1.0;return +e}f[a+4>>2]=f[b+40>>2];f[a+76>>2]=d;if(c){f[a+44>>2]=f[b+8>>2];f[a+44+4>>2]=f[b+8+4>>2];f[a+44+8>>2]=f[b+8+8>>2];f[a+44+12>>2]=f[b+8+12>>2]}else{j=+n[b+8>>2];i=+n[b+12>>2];h=+n[b+16>>2];g=j*+n[d+20>>2]+i*+n[d+24>>2]+h*+n[d+28>>2];e=j*+n[d+36>>2]+i*+n[d+40>>2]+h*+n[d+44>>2];n[a+44>>2]=+n[d+4>>2]*j+ +n[d+8>>2]*i+ +n[d+12>>2]*h;n[a+48>>2]=g;n[a+52>>2]=e;n[a+56>>2]=0.0}f[a+60>>2]=f[b+24>>2];f[a+60+4>>2]=f[b+24+4>>2];f[a+60+8>>2]=f[b+24+8>>2];f[a+60+12>>2]=f[b+24+12>>2];j=+n[b+40>>2];return +j}function vi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;h=u;u=u+80|0;if((d|0)>0)e=0;else{u=h;return}do{n[c+(e<<4)+12>>2]=-999999984306749440.0;e=e+1|0}while((e|0)!=(d|0));g=h+32+4|0;e=0;do{i=b+(e<<4)|0;f[h+32>>2]=8016;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;n[h+32+20>>2]=-999999984306749440.0;f[h+32+24>>2]=f[i>>2];f[h+32+24+4>>2]=f[i+4>>2];f[h+32+24+8>>2]=f[i+8>>2];f[h+32+24+12>>2]=f[i+12>>2];f[h+16>>2]=1566444395;f[h+16+4>>2]=1566444395;f[h+16+8>>2]=1566444395;n[h+16+12>>2]=0.0;i=f[a+92>>2]|0;j=f[(f[i>>2]|0)+8>>2]|0;n[h>>2]=-999999984306749440.0;n[h+4>>2]=-999999984306749440.0;n[h+8>>2]=-999999984306749440.0;n[h+12>>2]=0.0;Yb[j&127](i,h+32|0,h,h+16|0);i=c+(e<<4)|0;f[i>>2]=f[g>>2];f[i+4>>2]=f[g+4>>2];f[i+8>>2]=f[g+8>>2];f[i+12>>2]=f[g+12>>2];e=e+1|0}while((e|0)<(d|0));u=h;return}function wi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;e=f[a+96>>2]|0;if((e|0)==(f[a+100>>2]|0)?(i=e|0?e<<1:1,(e|0)<(i|0)):0){if(!i)h=0;else{f[6472]=(f[6472]|0)+1;e=sc((i<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=e;e=f[a+96>>2]|0}if((e|0)>0){g=0;do{j=h+(g<<4)|0;k=(f[a+104>>2]|0)+(g<<4)|0;f[j>>2]=f[k>>2];f[j+4>>2]=f[k+4>>2];f[j+8>>2]=f[k+8>>2];f[j+12>>2]=f[k+12>>2];g=g+1|0}while((g|0)!=(e|0))}e=f[a+104>>2]|0;if(e|0){if(b[a+108>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+104>>2]=0}b[a+108>>0]=1;f[a+104>>2]=h;f[a+100>>2]=i;e=f[a+96>>2]|0}k=(f[a+104>>2]|0)+(e<<4)|0;f[k>>2]=f[c>>2];f[k+4>>2]=f[c+4>>2];f[k+8>>2]=f[c+8>>2];f[k+12>>2]=f[c+12>>2];f[a+96>>2]=(f[a+96>>2]|0)+1;if(!d)return;yj(a);return}function xi(a){a=a|0;var c=0,d=0,e=0,g=0;f[a+32>>2]=262144;c=f[a+4>>2]|0;if((c|0)<2383){if((f[a+8>>2]|0)<2383){f[6472]=(f[6472]|0)+1;d=sc(9551)|0;if(!d)g=0;else{f[(d+4+15&-16)+-4>>2]=d;g=d+4+15&-16}e=f[a+4>>2]|0;if((e|0)>0){d=0;do{f[g+(d<<2)>>2]=f[(f[a+12>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0))}d=f[a+12>>2]|0;if(d|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=g;f[a+8>>2]=2383;d=a+12|0}else d=a+12|0;do{f[(f[d>>2]|0)+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=2383)}f[a+4>>2]=2383;d=0;do{g=(f[a+12>>2]|0)+(d<<2)|0;c=f[g>>2]|0;f[g>>2]=0;if(c|0)do{g=c;c=f[c+280>>2]|0;cI(g)}while((c|0)!=0);d=d+1|0}while((d|0)!=2383);n[a+20>>2]=.25;f[a+24>>2]=0;f[a+28>>2]=0;f[a+36>>2]=1;f[a+40>>2]=1;return}function yi(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=u;u=u+96|0;b=f[b>>2]|0;if((b|0)==(f[a+4>>2]|0)){u=c;return 1}d=f[a+12>>2]|0;if(!(Db[f[(f[d>>2]|0)+8>>2]&31](d,f[b+188>>2]|0)|0)){u=c;return 1}d=f[a+4>>2]|0;e=f[d+192>>2]|0;f[c+64>>2]=0;f[c+64+4>>2]=e;f[c+64+8>>2]=d;f[c+64+12>>2]=d+4;f[c+64+16>>2]=-1;f[c+64+20>>2]=-1;d=f[b+192>>2]|0;f[c+40>>2]=0;f[c+40+4>>2]=d;f[c+40+8>>2]=b;f[c+40+12>>2]=b+4;f[c+40+16>>2]=-1;f[c+40+20>>2]=-1;b=f[(f[a+8>>2]|0)+24>>2]|0;b=Gb[f[(f[b>>2]|0)+8>>2]&31](b,c+64|0,c+40|0,0)|0;if(b|0){e=f[a+12>>2]|0;f[c+4>>2]=0;f[c+8>>2]=c+64;f[c+12>>2]=c+40;f[c>>2]=6168;f[c+32>>2]=e;ac[f[(f[b>>2]|0)+8>>2]&31](b,c+64|0,c+40|0,(f[a+8>>2]|0)+28|0,c);Lb[f[f[b>>2]>>2]&511](b);e=f[(f[a+8>>2]|0)+24>>2]|0;Rb[f[(f[e>>2]|0)+60>>2]&127](e,b)}u=c;return 1}function zi(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,g=0,h=0,i=0,j=0;j=u;u=u+80|0;h=f[f[a>>2]>>2]|0;g=f[f[a+4>>2]>>2]|0;if(!(Fb[f[(f[b>>2]|0)+24>>2]&63](b,h,g)|0)){u=j;return}e=f[h+192>>2]|0;f[j+56>>2]=0;f[j+56+4>>2]=e;f[j+56+8>>2]=h;f[j+56+12>>2]=h+4;f[j+56+16>>2]=-1;f[j+56+20>>2]=-1;e=f[g+192>>2]|0;f[j+32>>2]=0;f[j+32+4>>2]=e;f[j+32+8>>2]=g;f[j+32+12>>2]=g+4;f[j+32+16>>2]=-1;f[j+32+20>>2]=-1;e=f[a+8>>2]|0;if(!e){e=Gb[f[(f[b>>2]|0)+8>>2]&31](b,j+56|0,j+32|0,0)|0;f[a+8>>2]=e;if(e|0)i=4}else i=4;if((i|0)==4){f[j>>2]=5796;f[j+4>>2]=0;f[j+8>>2]=j+56;f[j+12>>2]=j+32;if((f[c+8>>2]|0)!=1){d=+xb[f[(f[e>>2]|0)+12>>2]&15](e,h,g,c,j);if(+n[c+12>>2]>d)n[c+12>>2]=d}else ac[f[(f[e>>2]|0)+8>>2]&31](e,j+56|0,j+32|0,c,j)}u=j;return}function Ai(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=f[c+4>>2]|0;e=f[a+24>>2]|0;if((e|0)<(i|0)){if((f[a+28>>2]|0)<(i|0)){if(!i){d=0;h=e}else{f[6472]=(f[6472]|0)+1;d=sc((i<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}h=f[a+24>>2]|0}if((h|0)>0){g=0;do{f[d+(g<<2)>>2]=f[(f[a+32>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+32>>2]|0;if(g|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=d;f[a+28>>2]=i;d=a+32|0}else d=a+32|0;do{f[(f[d>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(i|0))}else d=a+32|0;f[a+24>>2]=i;e=f[d>>2]|0;if((i|0)<=0)return;d=0;do{f[e+(d<<2)>>2]=f[(f[c+12>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(i|0));return}function Bi(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;d=f[a+488>>2]|0;a:do if((d|0)>0){g=f[a+496>>2]|0;e=0;while(1){if((f[g+(e<<2)>>2]|0)==(c|0))break;e=e+1|0;if((e|0)>=(d|0))break a}if((e|0)!=(d|0)){c=a+256|0;f[c>>2]=1;return}}while(0);if((d|0)==(f[a+492>>2]|0)?(h=d|0?d<<1:1,(d|0)<(h|0)):0){if(!h)g=0;else{f[6472]=(f[6472]|0)+1;d=sc((h<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}g=d;d=f[a+488>>2]|0}if((d|0)>0){e=0;do{f[g+(e<<2)>>2]=f[(f[a+496>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=f[a+496>>2]|0;if(e){if(b[a+500>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);d=f[a+488>>2]|0}f[a+496>>2]=0}b[a+500>>0]=1;f[a+496>>2]=g;f[a+492>>2]=h}f[(f[a+496>>2]|0)+(d<<2)>>2]=c;f[a+488>>2]=d+1;c=a+256|0;f[c>>2]=1;return}function Ci(a){a=a|0;var c=0,d=0,e=0,g=0;f[a>>2]=8916;b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+24>>2]=0;b[a+28>>0]=0;b[a+48>>0]=1;f[a+44>>2]=0;f[a+36>>2]=0;f[a+40>>2]=0;b[a+68>>0]=1;f[a+64>>2]=0;f[a+56>>2]=0;f[a+60>>2]=0;f[a+72>>2]=0;f[6472]=(f[6472]|0)+1;c=sc(51)|0;if(!c)e=0;else{f[(c+4+15&-16)+-4>>2]=c;e=c+4+15&-16}d=f[a+8>>2]|0;if((d|0)>0){c=0;do{g=f[a+16>>2]|0;f[e+(c<<4)>>2]=f[g+(c<<4)>>2];f[e+(c<<4)+4>>2]=f[g+(c<<4)+4>>2];f[e+(c<<4)+8>>2]=f[g+(c<<4)+8>>2];f[e+(c<<4)+12>>2]=f[g+(c<<4)+12>>2];c=c+1|0}while((c|0)!=(d|0))}c=f[a+16>>2]|0;if(!c){b[a+20>>0]=1;f[a+16>>2]=e;f[a+12>>2]=2;If(a);return}if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0;b[a+20>>0]=1;f[a+16>>2]=e;f[a+12>>2]=2;If(a);return}function Di(a,b,c){a=a|0;b=b|0;c=c|0;do if(!((b|0)==32&(c|0)==32)){if((b|0)==32){if((c|0)<20){a=a+96|0;break}if((c+-21|0)>>>0<9){a=a+104|0;break}}else{if((b|0)<20&(c|0)==32){a=a+100|0;break}if((b+-21|0)>>>0<9&(c|0)==32){a=a+108|0;break}if((b|0)==8&(c|0)==8){a=a+60|0;break}if((b|0)==8&(c|0)==1){a=a+76|0;break}if((b|0)==1&(c|0)==8){a=a+80|0;break}}if(!(c|b)){a=a+72|0;break}if((b|0)<20&(c|0)==28){a=a+88|0;break}if((b|0)==28&(c|0)<20){a=a+84|0;break}if((b|0)<20){if((c|0)<20){a=a+32|0;break}if((c+-21|0)>>>0<9){a=a+36|0;break}}else{if((c|0)<20&(b+-21|0)>>>0<9){a=a+40|0;break}if((b|0)==31)if((c|0)==31){a=a+48|0;break}else{a=a+44|0;break}}if((c|0)==31){a=a+52|0;break}else{a=a+56|0;break}}else a=a+92|0;while(0);return f[a>>2]|0}function Ei(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;g=+g;h=+h;i=i|0;j=j|0;k=+k;var l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;x=+n[a>>2]*f+ +n[a+16>>2]*g+ +n[a+32>>2]*h;v=+n[a+4>>2]*f+ +n[a+20>>2]*g+ +n[a+36>>2]*h;t=+n[a+8>>2]*f+ +n[a+24>>2]*g+ +n[a+40>>2]*h;s=+n[b>>2]*f+ +n[b+16>>2]*g+ +n[b+32>>2]*h;q=+n[b+4>>2]*f+ +n[b+20>>2]*g+ +n[b+36>>2]*h;o=+n[b+8>>2]*f+ +n[b+24>>2]*g+ +n[b+40>>2]*h;w=+n[i+80>>2];u=+n[i+84>>2];p=+n[i+88>>2];r=+n[j+80>>2];l=+n[j+84>>2];m=+n[j+88>>2];p=x*(x<0.0?-w:w)+v*(v<0.0?-u:u)+t*(t<0.0?-p:p);m=s*(s<0.0?-r:r)+q*(q<0.0?-l:l)+o*(o<0.0?-m:m);o=+n[i+96>>2];l=+n[j+96>>2];l=(p>o?p:o)+(m>l?m:l);return !((c*f+d*g+e*h+l<l-(c*f+d*g+e*h)?c*f+d*g+e*h+l:l-(c*f+d*g+e*h))>k)|0}function Fi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0;if((d|0)>0)e=0;else return;do{n[c+(e<<4)+12>>2]=-999999984306749440.0;e=e+1|0}while((e|0)!=(d|0));r=0;do{i=+n[a+12>>2];j=+n[b+(r<<4)>>2]*i;k=+n[a+16>>2];l=+n[b+(r<<4)+4>>2]*k;m=+n[a+20>>2];o=+n[b+(r<<4)+8>>2]*m;p=f[a+96>>2]|0;if((p|0)>0){q=f[a+104>>2]|0;e=-1;h=0;g=-3402823466385288598117041.0e14;do{s=j*+n[q+(h<<4)>>2]+l*+n[q+(h<<4)+4>>2]+o*+n[q+(h<<4)+8>>2];t=s>g;e=t?h:e;g=t?s:g;h=h+1|0}while((h|0)!=(p|0));o=+n[q+(e<<4)+4>>2]*k;s=+n[q+(e<<4)+8>>2]*m;n[c+(r<<4)>>2]=+n[q+(e<<4)>>2]*i;n[c+(r<<4)+4>>2]=o;n[c+(r<<4)+8>>2]=s}else g=-999999984306749440.0;n[c+(r<<4)+12>>2]=g;r=r+1|0}while((r|0)!=(d|0));return}function Gi(a){a=a|0;var c=0;c=xs(616)|0;f[c+164>>2]=1065353216;f[c+168>>2]=1065353216;f[c+172>>2]=1065353216;n[c+176>>2]=0.0;f[c+180>>2]=0;n[c+184>>2]=999999984306749440.0;f[c+188>>2]=0;f[c+188+4>>2]=0;f[c+188+8>>2]=0;f[c+188+12>>2]=0;f[c+204>>2]=1;f[c+208>>2]=-1;f[c+212>>2]=-1;f[c+216>>2]=1;n[c+220>>2]=0.0;n[c+224>>2]=.5;n[c+228>>2]=0.0;n[c+232>>2]=0.0;f[c+236>>2]=1;f[c+240>>2]=0;n[c+244>>2]=1.0;f[c+248>>2]=0;f[c+248+4>>2]=0;f[c+248+8>>2]=0;f[c+248+12>>2]=0;f[c+4>>2]=1065353216;f[c+8>>2]=0;f[c+8+4>>2]=0;f[c+8+8>>2]=0;f[c+8+12>>2]=0;f[c+24>>2]=1065353216;f[c+28>>2]=0;f[c+28+4>>2]=0;f[c+28+8>>2]=0;f[c+28+12>>2]=0;f[c+44>>2]=1065353216;f[c+48>>2]=0;f[c+48+4>>2]=0;f[c+48+8>>2]=0;f[c+48+12>>2]=0;f[c+48+16>>2]=0;f[c>>2]=4252;b[c+500>>0]=1;f[c+496>>2]=0;f[c+488>>2]=0;f[c+492>>2]=0;Jd(c,a);return c|0}function Hi(a,b,c,d,e,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;m=u;u=u+16|0;uj(13004);ec[f[(f[a>>2]|0)+32>>2]&1](a,b,c,d,e,g,h,i,j);k=f[a+184>>2]|0;l=f[i+20>>2]|0;l=(k|0)>(l|0)?k:l;if((l|0)>0){k=0;do{+Ab[f[(f[a>>2]|0)+40>>2]&3](a,k,b,c,d,e,g,h,i,j);k=k+1|0}while((k|0)<(l|0))}k=f[2405]|0;j=(f[k+16>>2]|0)+-1|0;f[k+16>>2]=j;if(j|0){u=m;return 0.0}do if(f[k+4>>2]|0){gb(m|0,0)|0;j=f[6471]|0;n[k+8>>2]=+n[k+8>>2]+ +(((f[m+4>>2]|0)-(f[j+4>>2]|0)+(((f[m>>2]|0)-(f[j>>2]|0)|0)*1e6|0)-(f[k+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[k+16>>2]|0)){k=f[2405]|0;break}else{u=m;return 0.0}}while(0);f[2405]=f[k+20>>2];u=m;return 0.0}function Ii(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;while(1){m=f[a+12>>2]|0;n=f[m+(((b+c|0)/2|0)<<2)>>2]|0;e=b;d=c;while(1){l=f[n+740>>2]|0;l=f[((f[l+208>>2]|0)>-1?l:f[n+744>>2]|0)+208>>2]|0;while(1){h=m+(e<<2)|0;i=f[h>>2]|0;k=f[i+740>>2]|0;j=e+1|0;if((f[((f[k+208>>2]|0)>-1?k:f[i+744>>2]|0)+208>>2]|0)<(l|0))e=j;else break}while(1){g=f[m+(d<<2)>>2]|0;o=f[g+740>>2]|0;k=d+-1|0;if((l|0)<(f[((f[o+208>>2]|0)>-1?o:f[g+744>>2]|0)+208>>2]|0))d=k;else break}if((e|0)<=(d|0)){f[h>>2]=g;f[(f[a+12>>2]|0)+(d<<2)>>2]=i;e=j;d=k}if((e|0)>(d|0))break;m=f[a+12>>2]|0}if((d|0)>(b|0))Ii(a,b,d);if((e|0)<(c|0))b=e;else break}return}function Ji(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;f[a>>2]=3996;if((f[a+104>>2]|0)<=0){a=a+60|0;kj(a);lj(a);return}k=0;do{j=f[(f[a+4>>2]|0)+684>>2]|0;h=(f[a+112>>2]|0)+(k<<3)+4|0;b=f[h>>2]|0;if((f[j+60>>2]|0)>0){g=0;do{i=(f[j+68>>2]|0)+(g<<2)|0;c=f[i>>2]|0;a:do if(c|0){d=0;do{e=d|0?d+280|0:i;d=c;while(1){c=f[d+280>>2]|0;if((f[d+276>>2]|0)!=(b|0))break;f[e>>2]=c;cI(d);if(!c)break a;else d=c}}while((c|0)!=0)}while(0);g=g+1|0}while((g|0)<(f[j+60>>2]|0));b=f[h>>2]|0}if(b|0)Lb[f[(f[b>>2]|0)+4>>2]&511](b);k=k+1|0}while((k|0)<(f[a+104>>2]|0));a=a+60|0;kj(a);lj(a);return}function Ki(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=f[c>>2]|0;c=f[a+268>>2]|0;a:do if((c|0)>0){e=f[a+276>>2]|0;d=0;while(1){if((f[e+(d<<2)>>2]|0)==(g|0))break;d=d+1|0;if((d|0)>=(c|0))break a}if((d|0)!=(c|0))return}while(0);if((c|0)==(f[a+272>>2]|0)?(h=c|0?c<<1:1,(c|0)<(h|0)):0){if(!h)e=0;else{f[6472]=(f[6472]|0)+1;c=sc((h<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=c;c=f[a+268>>2]|0}if((c|0)>0){d=0;do{f[e+(d<<2)>>2]=f[(f[a+276>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(c|0))}d=f[a+276>>2]|0;if(d){if(b[a+280>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+268>>2]|0}f[a+276>>2]=0}b[a+280>>0]=1;f[a+276>>2]=e;f[a+272>>2]=h}f[(f[a+276>>2]|0)+(c<<2)>>2]=g;f[a+268>>2]=c+1;return}function Li(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;e=f[a+232>>2]|0;a:do if((e|0)>0){g=f[a+240>>2]|0;c=0;while(1){d=g+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(e|0))break a}if((c|0)<(e|0)){f[d>>2]=f[g+(e+-1<<2)>>2];f[(f[a+240>>2]|0)+(e+-1<<2)>>2]=b;f[a+232>>2]=e+-1}}while(0);c=f[b+188>>2]|0;if(c|0){g=f[a+68>>2]|0;g=Bb[f[(f[g>>2]|0)+36>>2]&127](g)|0;Vb[f[(f[g>>2]|0)+40>>2]&127](g,c,f[a+24>>2]|0);g=f[a+68>>2]|0;Vb[f[(f[g>>2]|0)+12>>2]&127](g,c,f[a+24>>2]|0);f[b+188>>2]=0}e=f[a+8>>2]|0;if((e|0)<=0)return;g=f[a+16>>2]|0;c=0;while(1){d=g+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(e|0)){h=15;break}}if((h|0)==15)return;if((c|0)>=(e|0))return;f[d>>2]=f[g+(e+-1<<2)>>2];f[(f[a+16>>2]|0)+(e+-1<<2)>>2]=b;f[a+8>>2]=e+-1;return}function Mi(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;while(1){m=f[a+12>>2]|0;n=f[m+(((b+c|0)/2|0)<<2)>>2]|0;e=b;d=c;while(1){l=f[n+28>>2]|0;l=f[((f[l+208>>2]|0)>-1?l:f[n+32>>2]|0)+208>>2]|0;while(1){h=m+(e<<2)|0;i=f[h>>2]|0;k=f[i+28>>2]|0;j=e+1|0;if((f[((f[k+208>>2]|0)>-1?k:f[i+32>>2]|0)+208>>2]|0)<(l|0))e=j;else break}while(1){g=f[m+(d<<2)>>2]|0;o=f[g+28>>2]|0;k=d+-1|0;if((l|0)<(f[((f[o+208>>2]|0)>-1?o:f[g+32>>2]|0)+208>>2]|0))d=k;else break}if((e|0)<=(d|0)){f[h>>2]=g;f[(f[a+12>>2]|0)+(d<<2)>>2]=i;e=j;d=k}if((e|0)>(d|0))break;m=f[a+12>>2]|0}if((d|0)>(b|0))Mi(a,b,d);if((e|0)<(c|0))b=e;else break}return}function Ni(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;e=f[a+328>>2]|0;a:do if((e|0)>0){g=f[a+336>>2]|0;c=0;while(1){d=g+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(e|0))break a}if((c|0)<(e|0)){f[d>>2]=f[g+(e+-1<<2)>>2];f[(f[a+336>>2]|0)+(e+-1<<2)>>2]=b;f[a+328>>2]=e+-1}}while(0);c=f[b+188>>2]|0;if(c|0){g=f[a+68>>2]|0;g=Bb[f[(f[g>>2]|0)+36>>2]&127](g)|0;Vb[f[(f[g>>2]|0)+40>>2]&127](g,c,f[a+24>>2]|0);g=f[a+68>>2]|0;Vb[f[(f[g>>2]|0)+12>>2]&127](g,c,f[a+24>>2]|0);f[b+188>>2]=0}e=f[a+8>>2]|0;if((e|0)<=0)return;g=f[a+16>>2]|0;c=0;while(1){d=g+(c<<2)|0;if((f[d>>2]|0)==(b|0))break;c=c+1|0;if((c|0)>=(e|0)){h=15;break}}if((h|0)==15)return;if((c|0)>=(e|0))return;f[d>>2]=f[g+(e+-1<<2)>>2];f[(f[a+16>>2]|0)+(e+-1<<2)>>2]=b;f[a+8>>2]=e+-1;return}function Oi(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;do if(!(IC(a,f[c+8>>2]|0)|0)){if(!(IC(a,f[c>>2]|0)|0)){h=f[a+8>>2]|0;ac[f[(f[h>>2]|0)+24>>2]&31](h,c,d,e,g);break}if((f[c+16>>2]|0)!=(d|0)?(f[c+20>>2]|0)!=(d|0):0){f[c+32>>2]=e;if((f[c+44>>2]|0)==4)break;b[c+52>>0]=0;b[c+53>>0]=0;e=f[a+8>>2]|0;cc[f[(f[e>>2]|0)+20>>2]&7](e,c,d,d,1,g);if(b[c+53>>0]|0)if(!(b[c+52>>0]|0)){a=3;h=11}else a=3;else{a=4;h=11}if((h|0)==11){f[c+20>>2]=d;f[c+40>>2]=(f[c+40>>2]|0)+1;if((f[c+36>>2]|0)==1?(f[c+24>>2]|0)==2:0)b[c+54>>0]=1}f[c+44>>2]=a;break}if((e|0)==1)f[c+32>>2]=1}else Xr(c,d,e);while(0);return}function Pi(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;i=f[c>>2]|0;i=Db[f[(f[i>>2]|0)+56>>2]&31](i,28)|0;j=(b[a+4>>0]|0)==0;h=f[a+8>>2]|0;g=f[a+12>>2]|0;a=f[c>>2]|0;f[i+4>>2]=a;f[i>>2]=5672;b[i+8>>0]=0;f[i+12>>2]=0;if(j){b[i+16>>0]=0;f[i+20>>2]=h;f[i+24>>2]=g;if(!(Fb[f[(f[a>>2]|0)+24>>2]&63](a,f[d+8>>2]|0,f[e+8>>2]|0)|0))return i|0;j=f[i+4>>2]|0;j=Fb[f[(f[j>>2]|0)+12>>2]&63](j,f[d+8>>2]|0,f[e+8>>2]|0)|0;f[i+12>>2]=j;b[i+8>>0]=1;return i|0}else{b[i+16>>0]=1;f[i+20>>2]=h;f[i+24>>2]=g;if(!(Fb[f[(f[a>>2]|0)+24>>2]&63](a,f[e+8>>2]|0,f[d+8>>2]|0)|0))return i|0;j=f[i+4>>2]|0;j=Fb[f[(f[j>>2]|0)+12>>2]&63](j,f[e+8>>2]|0,f[d+8>>2]|0)|0;f[i+12>>2]=j;b[i+8>>0]=1;return i|0}return 0}function Qi(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0,i=0.0,j=0.0,k=0.0;h=u;u=u+16|0;f[h>>2]=f[a+28>>2];f[h+4>>2]=f[a+28+4>>2];f[h+8>>2]=f[a+28+8>>2];f[h+12>>2]=f[a+28+12>>2];k=+rb[f[(f[a>>2]|0)+48>>2]&15](a);j=+rb[f[(f[a>>2]|0)+48>>2]&15](a);i=+rb[f[(f[a>>2]|0)+48>>2]&15](a);n[h>>2]=k+ +n[h>>2];n[h+4>>2]=j+ +n[h+4>>2];n[h+8>>2]=i+ +n[h+8>>2];e=f[a+52>>2]|0;switch(e|0){case 0:{a=0;d=1;break}case 2:{a=2;d=0;break}default:{a=1;d=0}}k=+n[h+(d<<2)>>2];j=+n[h+(a<<2)>>2];g=(n[s>>2]=b*.25*k*k+b/12.0*j*j*4.0,f[s>>2]|0);a=(n[s>>2]=b*.5*k*k,f[s>>2]|0);switch(e|0){case 0:{d=g;e=g;break}case 2:{d=a;e=g;a=g;break}default:{d=g;e=a;a=g}}f[c>>2]=a;f[c+4>>2]=e;f[c+8>>2]=d;n[c+12>>2]=0.0;u=h;return}function Ri(a){a=a|0;var b=0,c=0.0,d=0.0,e=0.0,g=0.0,h=0.0;b=nt()|0;f[b+8>>2]=0;f[b+12>>2]=1065353216;f[b+16>>2]=1065353216;f[b+20>>2]=1065353216;n[b+24>>2]=0.0;n[b+44>>2]=.03999999910593033;f[b+52>>2]=0;f[b>>2]=8036;f[b+4>>2]=0;d=+n[a>>2];c=+n[a+4>>2];c=+n[a+(((d<c?d:c)<+n[a+8>>2]?(d<c^1)&1:2)<<2)>>2]*.10000000149011612;if(c<.03999999910593033){h=+EF(b);e=+EF(b);d=+EF(b);h=h+ +n[b+28>>2];e=e+ +n[b+32>>2];d=d+ +n[b+36>>2];n[b+44>>2]=c;g=+EF(b);c=+EF(b);d=d-+EF(b);n[b+28>>2]=h-g;n[b+32>>2]=e-c;n[b+36>>2]=d;n[b+40>>2]=0.0}e=+EF(b);g=+EF(b);h=+EF(b);g=+n[a+4>>2]-g;h=+n[a+8>>2]-h;n[b+28>>2]=+n[a>>2]-e;n[b+32>>2]=g;n[b+36>>2]=h;n[b+40>>2]=0.0;return b|0}function Si(a){a=a|0;var c=0,d=0;c=f[a+92>>2]|0;if(c|0){if(b[a+96>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+92>>2]=0}b[a+96>>0]=1;f[a+92>>2]=0;f[a+84>>2]=0;f[a+88>>2]=0;c=f[a+64>>2]|0;if(c|0)do{f[a+64>>2]=f[c+8>>2];d=f[c>>2]|0;if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);c=f[a+64>>2]|0}while((c|0)!=0);c=f[a+48>>2]|0;if(c|0)do{f[a+48>>2]=f[c+8>>2];d=f[c>>2]|0;if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);c=f[a+48>>2]|0}while((c|0)!=0);c=f[a+32>>2]|0;if(!c)return;do{f[a+32>>2]=f[c+8>>2];d=f[c>>2]|0;if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);c=f[a+32>>2]|0}while((c|0)!=0);return}function Ti(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,g=0.0,h=0.0;f[a+4>>2]=35;f[a+8>>2]=0;f[a+12>>2]=1065353216;f[a+16>>2]=1065353216;f[a+20>>2]=1065353216;n[a+24>>2]=0.0;n[a+44>>2]=.03999999910593033;f[a>>2]=8332;f[a+52>>2]=1;d=+n[b>>2];c=+n[b+4>>2];c=+n[b+(((d<c?d:c)<+n[b+8>>2]?(d<c^1)&1:2)<<2)>>2]*.10000000149011612;if(c<.03999999910593033){h=+EF(a);e=+EF(a);d=+EF(a);h=h+ +n[a+28>>2];e=e+ +n[a+32>>2];d=d+ +n[a+36>>2];n[a+44>>2]=c;g=+EF(a);c=+EF(a);d=d-+EF(a);n[a+28>>2]=h-g;n[a+32>>2]=e-c;n[a+36>>2]=d;n[a+40>>2]=0.0}e=+EF(a);g=+EF(a);h=+EF(a);g=+n[b+4>>2]-g;h=+n[b+8>>2]-h;n[a+28>>2]=+n[b>>2]-e;n[a+32>>2]=g;n[a+36>>2]=h;n[a+40>>2]=0.0;f[a+4>>2]=13;return}function Ui(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;if(IC(a,f[c+8>>2]|0)|0)pl(c,d,e,g);else{j=b[c+52>>0]|0;k=b[c+53>>0]|0;l=f[a+12>>2]|0;b[c+52>>0]=0;b[c+53>>0]=0;Qn(a+16|0,c,d,e,g,h);a:do if((l|0)>1){i=a+24|0;do{if(b[c+54>>0]|0)break a;if(!(b[c+52>>0]|0)){if(b[c+53>>0]|0?(f[a+8>>2]&1|0)==0:0)break a}else{if((f[c+24>>2]|0)==1)break a;if(!(f[a+8>>2]&2))break a}b[c+52>>0]=0;b[c+53>>0]=0;Qn(i,c,d,e,g,h);i=i+8|0}while(i>>>0<(a+16+(l<<3)|0)>>>0)}while(0);b[c+52>>0]=j;b[c+53>>0]=k}return}function Vi(){var a=0;a=xs(284)|0;f[a+164>>2]=1065353216;f[a+168>>2]=1065353216;f[a+172>>2]=1065353216;n[a+176>>2]=0.0;f[a+180>>2]=0;n[a+184>>2]=999999984306749440.0;f[a+188>>2]=0;f[a+188+4>>2]=0;f[a+188+8>>2]=0;f[a+188+12>>2]=0;f[a+204>>2]=1;f[a+208>>2]=-1;f[a+212>>2]=-1;f[a+216>>2]=1;n[a+220>>2]=0.0;n[a+224>>2]=.5;n[a+228>>2]=0.0;n[a+232>>2]=0.0;f[a+240>>2]=0;n[a+244>>2]=1.0;f[a+248>>2]=0;f[a+248+4>>2]=0;f[a+248+8>>2]=0;f[a+248+12>>2]=0;f[a+4>>2]=1065353216;f[a+8>>2]=0;f[a+8+4>>2]=0;f[a+8+8>>2]=0;f[a+8+12>>2]=0;f[a+24>>2]=1065353216;f[a+28>>2]=0;f[a+28+4>>2]=0;f[a+28+8>>2]=0;f[a+28+12>>2]=0;f[a+44>>2]=1065353216;f[a+48>>2]=0;f[a+48+4>>2]=0;f[a+48+8>>2]=0;f[a+48+12>>2]=0;f[a+48+16>>2]=0;f[a>>2]=5236;b[a+280>>0]=1;f[a+276>>2]=0;f[a+268>>2]=0;f[a+272>>2]=0;f[a+236>>2]=4;return a|0}function Wi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=(f[a>>2]|0)+1794895138|0;e=zA(f[a+8>>2]|0,n)|0;k=zA(f[a+12>>2]|0,n)|0;m=zA(f[a+16>>2]|0,n)|0;a:do if((e>>>0<c>>>2>>>0?k>>>0<(c-(e<<2)|0)>>>0&m>>>0<(c-(e<<2)|0)>>>0:0)?((m|k)&3|0)==0:0){j=0;while(1){i=e>>>1;l=j+i|0;g=zA(f[a+((l<<1)+(k>>>2)<<2)>>2]|0,n)|0;h=zA(f[a+((l<<1)+(k>>>2)+1<<2)>>2]|0,n)|0;if(!(h>>>0<c>>>0&g>>>0<(c-h|0)>>>0)){e=0;break a}if(b[a+(h+g)>>0]|0){e=0;break a}g=Fo(d,a+h|0)|0;if(!g)break;if((e|0)==1){e=0;break a}else{j=(g|0)<0?j:l;e=(g|0)<0?i:e-i|0}}g=zA(f[a+((l<<1)+(m>>>2)<<2)>>2]|0,n)|0;e=zA(f[a+((l<<1)+(m>>>2)+1<<2)>>2]|0,n)|0;if(e>>>0<c>>>0&g>>>0<(c-e|0)>>>0)e=(b[a+(e+g)>>0]|0)==0?a+e|0:0;else e=0}else e=0;while(0);return e|0}function Xi(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0;k=f[a+720>>2]|0;a:do if(g?(j=f[a+732>>2]|0,(j|0)>0):0){h=f[a+740>>2]|0;g=0;while(1){i=f[h+(g*52|0)+8>>2]|0;if((i|0)==(k+(c*104|0)|0)?(f[h+(g*52|0)+12>>2]|0)==(k+(d*104|0)|0):0){g=10;break}if((i|0)==(k+(d*104|0)|0)?(f[h+(g*52|0)+12>>2]|0)==(k+(c*104|0)|0):0){g=10;break}g=g+1|0;if((g|0)>=(j|0))break a}if((g|0)==10)return}while(0);_h(a,e);e=(f[a+732>>2]|0)+-1|0;j=f[a+740>>2]|0;f[j+(e*52|0)+8>>2]=k+(c*104|0);f[j+(e*52|0)+12>>2]=k+(d*104|0);o=+n[k+(c*104|0)+8>>2]-+n[k+(d*104|0)+8>>2];m=+n[k+(c*104|0)+12>>2]-+n[k+(d*104|0)+12>>2];l=+n[k+(c*104|0)+16>>2]-+n[k+(d*104|0)+16>>2];l=+L(+(o*o+m*m+l*l));n[j+(e*52|0)+16>>2]=l;b[a+924>>0]=1;return}function Yi(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0.0,i=0.0,j=0,k=0;e=u;u=u+48|0;if((f[a+136>>2]|0)<=0){u=e;return}d=0;do{k=f[a+144>>2]|0;f[e+32>>2]=(b[k+(d*284|0)+84>>0]|0)==0?1065353216:0;f[e+32+4>>2]=0;f[e+32+8>>2]=1065353216;n[e+32+12>>2]=0.0;j=k+(d*284|0)+140|0;f[e+16>>2]=f[j>>2];f[e+16+4>>2]=f[j+4>>2];f[e+16+8>>2]=f[j+8>>2];f[e+16+12>>2]=f[j+12>>2];j=f[a+120>>2]|0;g=f[(f[c>>2]|0)+8>>2]|0;i=+n[k+(d*284|0)+108+(j<<2)>>2]+ +n[e+16+4>>2];h=+n[k+(d*284|0)+124+(j<<2)>>2]+ +n[e+16+8>>2];n[e>>2]=+n[k+(d*284|0)+92+(j<<2)>>2]+ +n[e+16>>2];n[e+4>>2]=i;n[e+8>>2]=h;n[e+12>>2]=0.0;Yb[g&127](c,e+16|0,e,e+32|0);Yb[f[(f[c>>2]|0)+8>>2]&127](c,e+16|0,(f[a+144>>2]|0)+(d*284|0)+16|0,e+32|0);d=d+1|0}while((d|0)<(f[a+136>>2]|0));u=e;return}function Zi(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;switch(b|0){case 2:{if((d|0)<1){n[a+232>>2]=c;f[a+300>>2]=f[a+300>>2]|512;return}if((d|0)<3){n[a+264>>2]=c;f[a+300>>2]=f[a+300>>2]|32;return}if((d|0)==3){n[a+248>>2]=c;f[a+300>>2]=f[a+300>>2]|2048;return}if((d|0)>=6)return;n[a+280>>2]=c;f[a+300>>2]=f[a+300>>2]|128;return}case 3:{if((d|0)<1){n[a+212>>2]=c;f[a+300>>2]=f[a+300>>2]|1;return}if((d|0)!=3)return;n[a+228>>2]=c;f[a+300>>2]=f[a+300>>2]|4;return}case 4:{if((d|0)<1){n[a+244>>2]=c;f[a+300>>2]=f[a+300>>2]|256;return}if((d|0)<3){n[a+276>>2]=c;f[a+300>>2]=f[a+300>>2]|16;return}if((d|0)==3){n[a+260>>2]=c;f[a+300>>2]=f[a+300>>2]|1024;return}if((d|0)>=6)return;n[a+292>>2]=c;f[a+300>>2]=f[a+300>>2]|64;return}default:return}}function _i(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0;d=u;u=u+96|0;f[d+32>>2]=1065353216;f[d+32+4>>2]=0;f[d+32+4+4>>2]=0;f[d+32+4+8>>2]=0;f[d+32+4+12>>2]=0;f[d+32+20>>2]=1065353216;f[d+32+24>>2]=0;f[d+32+24+4>>2]=0;f[d+32+24+8>>2]=0;f[d+32+24+12>>2]=0;f[d+32+40>>2]=1065353216;j=d+32+44|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[j+16>>2]=0;Yb[f[(f[a>>2]|0)+8>>2]&127](a,d+32|0,d+16|0,d);h=(+n[d>>2]-+n[d+16>>2])*.5;g=(+n[d+4>>2]-+n[d+16+4>>2])*.5;i=(+n[d+8>>2]-+n[d+16+8>>2])*.5;e=+rb[f[(f[a>>2]|0)+48>>2]&15](a);n[c>>2]=b*.0833333283662796*((g+e)*2.0*(g+e)*2.0+(i+e)*2.0*(i+e)*2.0);n[c+4>>2]=b*.0833333283662796*((h+e)*2.0*(h+e)*2.0+(i+e)*2.0*(i+e)*2.0);n[c+8>>2]=b*.0833333283662796*((h+e)*2.0*(h+e)*2.0+(g+e)*2.0*(g+e)*2.0);n[c+12>>2]=0.0;u=d;return}function $i(){var a=0;a=Os()|0;f[a>>2]=1025;f[a+116>>2]=0;b[a+120>>0]=0;f[a+124>>2]=0;f[a+124+4>>2]=0;f[a+124+8>>2]=0;f[a+124+12>>2]=0;f[a+124+16>>2]=0;f[a+124+20>>2]=0;f[a+124+24>>2]=0;f[a+124+28>>2]=0;f[a+300>>2]=0;b[a+304>>0]=0;f[a+308>>2]=0;f[a+308+4>>2]=0;f[a+308+8>>2]=0;f[a+308+12>>2]=0;f[a+308+16>>2]=0;f[a+308+20>>2]=0;f[a+308+24>>2]=0;f[a+308+28>>2]=0;f[a+484>>2]=0;b[a+488>>0]=0;f[a+492>>2]=0;f[a+492+4>>2]=0;f[a+492+8>>2]=0;f[a+492+12>>2]=0;f[a+492+16>>2]=0;f[a+492+20>>2]=0;f[a+492+24>>2]=0;f[a+492+28>>2]=0;f[a+668>>2]=0;b[a+672>>0]=0;f[a+676>>2]=0;f[a+676+4>>2]=0;f[a+676+8>>2]=0;f[a+676+12>>2]=0;f[a+676+16>>2]=0;f[a+676+20>>2]=0;f[a+676+24>>2]=0;f[a+676+28>>2]=0;f[a+740>>2]=0;f[a+744>>2]=0;f[a+748>>2]=0;f[a+768>>2]=0;return a|0}function aj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=u;u=u+96|0;i=+n[c>>2];j=+n[c+4>>2];k=+n[c+8>>2];zq(e+80|0,i,j,k,+Wx(i,j,k,+n[b>>2],+n[b+4>>2],+n[b+8>>2]));k=+n[e+80>>2];j=+n[e+80+4>>2];i=+n[e+80+8>>2];Vp(e+64|0,+n[b>>2],+n[b+4>>2],+n[b+8>>2],k,j,i);jp(e+48|0,+n[c>>2],+n[c+4>>2],+n[c+8>>2],+n[b>>2],+n[b+4>>2],+n[b+8>>2]);h=+n[e+48>>2];g=+n[e+48+4>>2];f=+n[e+48+8>>2];l=+XH(d);zq(e+16|0,+n[e+64>>2],+n[e+64+4>>2],+n[e+64+8>>2],l);Tp(e+32|0,k,j,i,+n[e+16>>2],+n[e+16+4>>2],+n[e+16+8>>2]);zq(e,h,g,f,+WH(d));Tp(a,+n[e+32>>2],+n[e+32+4>>2],+n[e+32+8>>2],+n[e>>2],+n[e+4>>2],+n[e+8>>2]);u=e;return}function bj(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;e=f[a+212>>2]|0;if((e|0)==(f[a+216>>2]|0)?(i=e|0?e<<1:1,(e|0)<(i|0)):0){if(!i)h=0;else{f[6472]=(f[6472]|0)+1;e=sc((i<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=e;e=f[a+212>>2]|0}if((e|0)>0){g=0;do{f[h+(g<<2)>>2]=f[(f[a+220>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[a+220>>2]|0;if(g){if(b[a+224>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[a+212>>2]|0}f[a+220>>2]=0}b[a+224>>0]=1;f[a+220>>2]=h;f[a+216>>2]=i}f[(f[a+220>>2]|0)+(e<<2)>>2]=c;f[a+212>>2]=e+1;if(!d)return;Bi(f[c+28>>2]|0,c);Bi(f[c+32>>2]|0,c);return}function cj(a,b,c,d,e,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0;l=u;u=u+16|0;uj(13067);+zb[f[(f[a>>2]|0)+44>>2]&3](a,b,c,d,e,g,h,i,j);+zb[f[(f[a>>2]|0)+48>>2]&3](a,b,c,d,e,g,h,i,j);+wb[f[(f[a>>2]|0)+36>>2]&1](a,b,c,i);k=f[2405]|0;j=(f[k+16>>2]|0)+-1|0;f[k+16>>2]=j;if(j|0){u=l;return 0.0}do if(f[k+4>>2]|0){gb(l|0,0)|0;j=f[6471]|0;n[k+8>>2]=+n[k+8>>2]+ +(((f[l+4>>2]|0)-(f[j+4>>2]|0)+(((f[l>>2]|0)-(f[j>>2]|0)|0)*1e6|0)-(f[k+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[k+16>>2]|0)){k=f[2405]|0;break}else{u=l;return 0.0}}while(0);f[2405]=f[k+20>>2];u=l;return 0.0}function dj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0;d=f[a+4>>2]|0;if(d|0)ll(d,b,c);a=f[a>>2]|0;if(!a)return;l=+n[b>>2];j=+n[a+128>>2];k=+n[b+4>>2];i=+n[b+8>>2];e=+n[c+4>>2];o=+n[c+8>>2];m=+n[c>>2];h=+n[a+180>>2]*(i*e-k*o)+ +n[a+184>>2]*(l*o-i*m)+(k*m-l*e)*+n[a+188>>2];g=(i*e-k*o)*+n[a+196>>2]+(l*o-i*m)*+n[a+200>>2]+(k*m-l*e)*+n[a+204>>2];e=(i*e-k*o)*+n[a+212>>2]+(l*o-i*m)*+n[a+216>>2]+(k*m-l*e)*+n[a+220>>2];n[a+276>>2]=l*j+ +n[a+276>>2];n[a+280>>2]=j*k+ +n[a+280>>2];n[a+284>>2]=j*i+ +n[a+284>>2];n[a+292>>2]=h+ +n[a+292>>2];n[a+296>>2]=g+ +n[a+296>>2];n[a+300>>2]=e+ +n[a+300>>2];f[a+312>>2]=(f[a+312>>2]|0)+1;return}function ej(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;v=+n[a+552>>2];u=+n[a+568>>2];t=+n[a+584>>2];s=+n[b>>2];r=+n[b+4>>2];q=+n[b+8>>2];o=+n[b+16>>2];m=+n[b+20>>2];l=+n[b+24>>2];j=+n[b+32>>2];h=+n[b+36>>2];f=+n[b+40>>2];i=+n[a+556>>2];g=+n[a+572>>2];e=+n[a+588>>2];x=+n[a+620>>2];w=+n[a+636>>2];d=+n[a+652>>2];p=x*+n[c>>2]+w*+n[c+4>>2]+d*+n[c+8>>2];k=x*+n[c+16>>2]+w*+n[c+20>>2]+d*+n[c+24>>2];d=x*+n[c+32>>2]+w*+n[c+36>>2]+d*+n[c+40>>2];d=+T(+((v*s+u*r+t*q)*p+(v*o+u*m+t*l)*k+(v*j+u*h+t*f)*d),+((s*i+r*g+q*e)*p+(o*i+m*g+l*e)*k+(j*i+h*g+f*e)*d));return +(d*+n[a+732>>2])}function fj(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;h=u;u=u+16|0;uj(15163);c=f[a+8>>2]|0;if((c|0)>0){e=0;do{d=f[(f[a+16>>2]|0)+(e<<2)>>2]|0;if(!(b[a+76>>0]|0))switch(f[d+216>>2]|0){case 2:case 5:break;default:g=11}else g=11;if((g|0)==11){g=0;xf(a,d);c=f[a+8>>2]|0}e=e+1|0}while((e|0)<(c|0))}c=f[2405]|0;g=(f[c+16>>2]|0)+-1|0;f[c+16>>2]=g;if(g|0){u=h;return}do if(f[c+4>>2]|0){gb(h|0,0)|0;g=f[6471]|0;n[c+8>>2]=+n[c+8>>2]+ +(((f[h+4>>2]|0)-(f[g+4>>2]|0)+(((f[h>>2]|0)-(f[g>>2]|0)|0)*1e6|0)-(f[c+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[c+16>>2]|0)){c=f[2405]|0;break}else{u=h;return}}while(0);f[2405]=f[c+20>>2];u=h;return}function gj(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0;if(!(b[a+84>>0]|0)){f[a+32>>2]=f[a+204>>2];e=-+n[a+56>>2];g=-+n[a+60>>2];n[a>>2]=-+n[a+52>>2];n[a+4>>2]=e;n[a+8>>2]=g;n[a+12>>2]=0.0;g=0.0;e=1.0;d=a+272|0;n[d>>2]=g;d=a+268|0;n[d>>2]=e;return}else{p=+n[a>>2];o=+n[a+4>>2];k=+n[a+8>>2];g=p*+n[a+52>>2]+o*+n[a+56>>2]+k*+n[a+60>>2];h=+n[a+16>>2]-+n[c+52>>2];j=+n[a+20>>2]-+n[c+56>>2];l=+n[a+24>>2]-+n[c+60>>2];e=+n[c+332>>2];m=+n[c+336>>2];i=+n[c+328>>2];e=!(g>=-.10000000149011612)?-1.0/g*(p*(e*l-j*m+ +n[c+312>>2])+o*(+n[c+316>>2]+(h*m-l*i))+k*(j*i-h*e+ +n[c+320>>2])):0.0;g=!(g>=-.10000000149011612)?-1.0/g:10.0;d=a+272|0;n[d>>2]=e;d=a+268|0;n[d>>2]=g;return}}function hj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;c=f[a+8>>2]|0;if((c|0)>0){e=0;do{d=f[(f[a+16>>2]|0)+(e<<2)>>2]|0;if(f[d+236>>2]&2){g=Bb[f[(f[d>>2]|0)+16>>2]&127](d)|0;g=Fb[f[(f[b>>2]|0)+16>>2]&63](b,g,1)|0;c=Fb[f[(f[d>>2]|0)+20>>2]&63](d,f[g+8>>2]|0,b)|0;ac[f[(f[b>>2]|0)+20>>2]&31](b,g,c,1497645650,d);c=f[a+8>>2]|0}e=e+1|0}while((e|0)<(c|0))}if((f[a+212>>2]|0)<=0)return;c=0;do{g=f[(f[a+220>>2]|0)+(c<<2)>>2]|0;d=Bb[f[(f[g>>2]|0)+36>>2]&127](g)|0;d=Fb[f[(f[b>>2]|0)+16>>2]&63](b,d,1)|0;e=Fb[f[(f[g>>2]|0)+40>>2]&63](g,f[d+8>>2]|0,b)|0;ac[f[(f[b>>2]|0)+20>>2]&31](b,d,e,1397641027,g);c=c+1|0}while((c|0)<(f[a+212>>2]|0));return}function ij(a){a=a|0;var b=0.0,c=0,d=0,e=0,g=0;d=u;u=u+32|0;f[a+32>>2]=1566444395;f[a+36>>2]=1566444395;f[a+40>>2]=1566444395;n[a+44>>2]=0.0;f[a+48>>2]=-581039253;f[a+52>>2]=-581039253;f[a+56>>2]=-581039253;n[a+60>>2]=0.0;if((f[a+16>>2]|0)<=0){u=d;return}c=0;do{e=f[a+24>>2]|0;g=f[e+(c*80|0)+64>>2]|0;Yb[f[(f[g>>2]|0)+8>>2]&127](g,e+(c*80|0)|0,d+16|0,d);b=+n[d+16>>2];if(+n[a+32>>2]>b)n[a+32>>2]=b;b=+n[d>>2];if(+n[a+48>>2]<b)n[a+48>>2]=b;b=+n[d+16+4>>2];if(+n[a+36>>2]>b)n[a+36>>2]=b;b=+n[d+4>>2];if(+n[a+52>>2]<b)n[a+52>>2]=b;b=+n[d+16+8>>2];if(+n[a+40>>2]>b)n[a+40>>2]=b;b=+n[d+8>>2];if(+n[a+56>>2]<b)n[a+56>>2]=b;c=c+1|0}while((c|0)<(f[a+16>>2]|0));u=d;return}function jj(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0;i=u;u=u+64|0;h=f[a>>2]|0;g=a+(f[h+-8>>2]|0)|0;h=f[h+-4>>2]|0;f[i>>2]=c;f[i+4>>2]=a;f[i+8>>2]=2776;a=IC(h,c)|0;c=i+12|0;e=c+40|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(e|0));d[i+12+40>>1]=0;b[i+12+42>>0]=0;a:do if(a){f[i+48>>2]=1;cc[f[(f[h>>2]|0)+20>>2]&7](h,i,g,g,1,0);a=(f[i+24>>2]|0)==1?g:0}else{ac[f[(f[h>>2]|0)+24>>2]&31](h,i,g,1,0);switch(f[i+36>>2]|0){case 0:{a=((f[i+40>>2]|0)==1?(f[i+28>>2]|0)==1:0)&(f[i+32>>2]|0)==1?f[i+20>>2]|0:0;break a}case 1:break;default:{a=0;break a}}if((f[i+24>>2]|0)!=1?!(((f[i+40>>2]|0)==0?(f[i+28>>2]|0)==1:0)&(f[i+32>>2]|0)==1):0){a=0;break}a=f[i+16>>2]|0}while(0);u=i;return a|0}function kj(a){a=a|0;var c=0;c=f[a+12>>2]|0;if(c|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=f[a+32>>2]|0;if(c|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;c=f[a+52>>2]|0;if(c|0){if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+52>>2]=0}b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;c=f[a+72>>2]|0;if(!c){b[a+76>>0]=1;f[a+72>>2]=0;f[a+64>>2]=0;a=a+68|0;f[a>>2]=0;return}if(b[a+76>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+72>>2]=0;b[a+76>>0]=1;f[a+72>>2]=0;f[a+64>>2]=0;a=a+68|0;f[a>>2]=0;return}function lj(a){a=a|0;var c=0;c=f[a+72>>2]|0;if(c|0){if(b[a+76>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+72>>2]=0}b[a+76>>0]=1;f[a+72>>2]=0;f[a+64>>2]=0;f[a+68>>2]=0;c=f[a+52>>2]|0;if(c|0){if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+52>>2]=0}b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;c=f[a+32>>2]|0;if(c|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;c=f[a+12>>2]|0;if(!c){b[a+16>>0]=1;f[a+12>>2]=0;f[a+4>>2]=0;a=a+8|0;f[a>>2]=0;return}if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+12>>2]=0;b[a+16>>0]=1;f[a+12>>2]=0;f[a+4>>2]=0;a=a+8|0;f[a>>2]=0;return}function mj(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0;d=u;u=u+96|0;h=+rb[f[(f[a>>2]|0)+48>>2]&15](a);f[d+32>>2]=1065353216;f[d+32+4>>2]=0;f[d+32+4+4>>2]=0;f[d+32+4+8>>2]=0;f[d+32+4+12>>2]=0;f[d+32+20>>2]=1065353216;f[d+32+24>>2]=0;f[d+32+24+4>>2]=0;f[d+32+24+8>>2]=0;f[d+32+24+12>>2]=0;f[d+32+40>>2]=1065353216;i=d+32+44|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[i+16>>2]=0;Yb[f[(f[a>>2]|0)+8>>2]&127](a,d+32|0,d+16|0,d);g=(h+(+n[d>>2]-+n[d+16>>2])*.5)*2.0;e=(h+(+n[d+4>>2]-+n[d+16+4>>2])*.5)*2.0;h=(h+(+n[d+8>>2]-+n[d+16+8>>2])*.5)*2.0;n[c>>2]=b*.0833333283662796*(e*e+h*h);n[c+4>>2]=b*.0833333283662796*(g*g+h*h);n[c+8>>2]=b*.0833333283662796*(g*g+e*e);n[c+12>>2]=0.0;u=d;return}function nj(a,b){a=a|0;b=+b;var c=0,d=0,e=0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;d=f[a+732>>2]|0;if((d|0)<=0)return;c=f[a+740>>2]|0;a=0;do{m=f[c+(a*52|0)+8>>2]|0;e=f[c+(a*52|0)+12>>2]|0;s=+n[m+40>>2];q=+n[m+44>>2];h=+n[m+48>>2];j=c+(a*52|0)+36|0;r=+n[j>>2];l=c+(a*52|0)+40|0;p=+n[l>>2];k=c+(a*52|0)+44|0;o=+n[k>>2];i=-(+n[c+(a*52|0)+32>>2]*((s-+n[e+40>>2])*r+(q-+n[e+44>>2])*p+(h-+n[e+48>>2])*o)*b);g=+n[m+88>>2]*i;n[m+40>>2]=s+r*g;n[m+44>>2]=q+p*g;n[m+48>>2]=o*g+h;i=+n[e+88>>2]*i;h=i*+n[l>>2];g=i*+n[k>>2];n[e+40>>2]=+n[e+40>>2]-+n[j>>2]*i;n[e+44>>2]=+n[e+44>>2]-h;n[e+48>>2]=+n[e+48>>2]-g;a=a+1|0}while((a|0)!=(d|0));return}function oj(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;d=f[a+12>>2]|0;if(!d)return;if(!(b[a+8>>0]|0))return;e=f[c+4>>2]|0;if((e|0)==(f[c+8>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((h<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[c+4>>2]|0}if((e|0)>0){g=0;do{f[d+(g<<2)>>2]=f[(f[c+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[c+12>>2]|0;if(g){if(b[c+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[c+4>>2]|0}f[c+12>>2]=0}b[c+16>>0]=1;f[c+12>>2]=d;f[c+8>>2]=h;d=f[a+12>>2]|0}f[(f[c+12>>2]|0)+(e<<2)>>2]=d;f[c+4>>2]=e+1;return}function pj(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;g=f[a+328>>2]|0;if((g|0)==(f[a+332>>2]|0)?(j=g|0?g<<1:1,(g|0)<(j|0)):0){if(!j)i=0;else{f[6472]=(f[6472]|0)+1;g=sc((j<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=g;g=f[a+328>>2]|0}if((g|0)>0){h=0;do{f[i+(h<<2)>>2]=f[(f[a+336>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=f[a+336>>2]|0;if(h){if(b[a+340>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);g=f[a+328>>2]|0}f[a+336>>2]=0}b[a+340>>0]=1;f[a+336>>2]=i;f[a+332>>2]=j}f[(f[a+336>>2]|0)+(g<<2)>>2]=c;f[a+328>>2]=g+1;f[c+284>>2]=f[a+452>>2];Ng(a,c,d,e);return}function qj(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;d=f[a+20>>2]|0;if(!d)return;if(!(b[a+16>>0]|0))return;e=f[c+4>>2]|0;if((e|0)==(f[c+8>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((h<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[c+4>>2]|0}if((e|0)>0){g=0;do{f[d+(g<<2)>>2]=f[(f[c+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[c+12>>2]|0;if(g){if(b[c+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[c+4>>2]|0}f[c+12>>2]=0}b[c+16>>0]=1;f[c+12>>2]=d;f[c+8>>2]=h;d=f[a+20>>2]|0}f[(f[c+12>>2]|0)+(e<<2)>>2]=d;f[c+4>>2]=e+1;return}function rj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0;j=+n[a+24>>2];h=+n[a+28>>2];i=+n[a+32>>2];e=j*+n[b>>2]+h*+n[b+4>>2]+i*+n[b+8>>2];g=+n[a+20>>2];if(e>g){n[a+20>>2]=e;f[a+4>>2]=f[b>>2];f[a+4+4>>2]=f[b+4>>2];f[a+4+8>>2]=f[b+8>>2];f[a+4+12>>2]=f[b+12>>2]}else e=g;g=j*+n[b+16>>2]+h*+n[b+20>>2]+i*+n[b+24>>2];if(g>e){n[a+20>>2]=g;f[a+4>>2]=f[b+16>>2];f[a+4+4>>2]=f[b+16+4>>2];f[a+4+8>>2]=f[b+16+8>>2];f[a+4+12>>2]=f[b+16+12>>2]}else g=e;e=j*+n[b+32>>2]+h*+n[b+36>>2]+i*+n[b+40>>2];if(!(e>g))return;n[a+20>>2]=e;f[a+4>>2]=f[b+32>>2];f[a+4+4>>2]=f[b+32+4>>2];f[a+4+8>>2]=f[b+32+8>>2];f[a+4+12>>2]=f[b+32+12>>2];return}function sj(a){a=a|0;var c=0;c=Zs()|0;f[c+8>>2]=0;f[c>>2]=6484;b[c+28>>0]=1;f[c+24>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[c+32>>2]=1566444395;f[c+36>>2]=1566444395;f[c+40>>2]=1566444395;n[c+44>>2]=0.0;f[c+48>>2]=-581039253;f[c+52>>2]=-581039253;f[c+56>>2]=-581039253;n[c+60>>2]=0.0;f[c+64>>2]=0;f[c+68>>2]=1;n[c+72>>2]=0.0;f[c+76>>2]=1065353216;f[c+80>>2]=1065353216;f[c+84>>2]=1065353216;n[c+88>>2]=0.0;f[c+4>>2]=31;if(!a)return c|0;f[6472]=(f[6472]|0)+1;a=sc(79)|0;if(!a)a=0;else{f[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=-1;f[a+12>>2]=0;f[a+16>>2]=0;f[c+64>>2]=a;return c|0}function tj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0;j=+n[a+88>>2];h=+n[a+92>>2];i=+n[a+96>>2];e=j*+n[b>>2]+h*+n[b+4>>2]+i*+n[b+8>>2];g=+n[a+84>>2];if(e>g){n[a+84>>2]=e;f[a+4>>2]=f[b>>2];f[a+4+4>>2]=f[b+4>>2];f[a+4+8>>2]=f[b+8>>2];f[a+4+12>>2]=f[b+12>>2]}else e=g;g=j*+n[b+16>>2]+h*+n[b+20>>2]+i*+n[b+24>>2];if(g>e){n[a+84>>2]=g;f[a+4>>2]=f[b+16>>2];f[a+4+4>>2]=f[b+16+4>>2];f[a+4+8>>2]=f[b+16+8>>2];f[a+4+12>>2]=f[b+16+12>>2]}else g=e;e=j*+n[b+32>>2]+h*+n[b+36>>2]+i*+n[b+40>>2];if(!(e>g))return;n[a+84>>2]=e;f[a+4>>2]=f[b+32>>2];f[a+4+4>>2]=f[b+32+4>>2];f[a+4+8>>2]=f[b+32+8>>2];f[a+4+12>>2]=f[b+32+12>>2];return}function uj(a){a=a|0;var b=0,c=0,d=0,e=0;e=u;u=u+16|0;c=f[2405]|0;if((f[c>>2]|0)==(a|0))b=c;else{b=f[c+24>>2]|0;a:do if(!b)d=5;else while(1){if((f[b>>2]|0)==(a|0))break a;b=f[b+28>>2]|0;if(!b){d=5;break}}while(0);if((d|0)==5){b=gs(36)|0;f[b>>2]=a;f[b+4>>2]=0;f[b+4+4>>2]=0;f[b+4+8>>2]=0;f[b+4+12>>2]=0;f[b+20>>2]=c;f[b+24>>2]=0;f[b+28>>2]=0;f[b+32>>2]=0;Cr(b);f[b+28>>2]=f[c+24>>2];f[c+24>>2]=b}f[2405]=b}c=b+4|0;f[c>>2]=(f[c>>2]|0)+1;c=b+16|0;d=f[c>>2]|0;f[c>>2]=d+1;if(d|0){u=e;return}gb(e|0,0)|0;d=f[6471]|0;f[b+12>>2]=(f[e+4>>2]|0)-(f[d+4>>2]|0)+(((f[e>>2]|0)-(f[d>>2]|0)|0)*1e6|0);u=e;return}function vj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;g=+rb[f[(f[a>>2]|0)+48>>2]&15](a);k=g+ +n[a+28>>2];i=g+ +n[a+32>>2];g=g+ +n[a+36>>2];u=+K(+(+n[b>>2]));t=+K(+(+n[b+4>>2]));s=+K(+(+n[b+8>>2]));q=+K(+(+n[b+16>>2]));p=+K(+(+n[b+20>>2]));o=+K(+(+n[b+24>>2]));j=+K(+(+n[b+32>>2]));h=+K(+(+n[b+36>>2]));e=+K(+(+n[b+40>>2]));r=+n[b+48>>2];m=+n[b+52>>2];l=+n[b+56>>2];n[c>>2]=r-(k*u+i*t+g*s);n[c+4>>2]=m-(k*q+i*p+g*o);n[c+8>>2]=l-(k*j+i*h+g*e);n[c+12>>2]=0.0;n[d>>2]=k*u+i*t+g*s+r;n[d+4>>2]=k*q+i*p+g*o+m;n[d+8>>2]=l+(k*j+i*h+g*e);n[d+12>>2]=0.0;return}function wj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;d=u;u=u+96|0;f[d+32>>2]=1065353216;f[d+32+4>>2]=0;f[d+32+4+4>>2]=0;f[d+32+4+8>>2]=0;f[d+32+4+12>>2]=0;f[d+32+20>>2]=1065353216;f[d+32+24>>2]=0;f[d+32+24+4>>2]=0;f[d+32+24+8>>2]=0;f[d+32+24+12>>2]=0;f[d+32+40>>2]=1065353216;m=d+32+44|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[m+16>>2]=0;Yb[f[(f[a>>2]|0)+8>>2]&127](a,d+32|0,d+16|0,d);j=+n[d>>2];k=+n[d+16>>2];h=+n[d+4>>2];i=+n[d+16+4>>2];e=+n[d+8>>2];g=+n[d+16+8>>2];l=+L(+((j-k)*(j-k)+(h-i)*(h-i)+(e-g)*(e-g)))*.5;n[c>>2]=l;n[b>>2]=(k+j)*.5;n[b+4>>2]=(i+h)*.5;n[b+8>>2]=(g+e)*.5;n[b+12>>2]=0.0;u=d;return}function xj(a){a=a|0;var c=0;f[a>>2]=8776;if(f[a+108>>2]|0){c=f[a+112>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+112>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+108>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+108>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}}c=f[a+88>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+84>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+80>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+60>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}if(!(b[a+100>>0]|0))return;c=f[a+92>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+92>>2]|0;if(!c)return;f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);return}function yj(a){a=a|0;var c=0,d=0,e=0,g=0.0;d=u;u=u+96|0;b[a+88>>0]=1;if((b[22776]|0)==0?fz(22776)|0:0){f[6176]=1065353216;f[6177]=0;f[6178]=0;f[6179]=0;f[6180]=0;f[6181]=1065353216;f[6182]=0;f[6183]=0;f[6184]=0;f[6185]=0;f[6186]=1065353216;n[6187]=0.0;f[6188]=-1082130432;f[6189]=0;f[6190]=0;f[6191]=0;f[6192]=0;f[6193]=-1082130432;f[6194]=0;f[6195]=0;f[6196]=0;f[6197]=0;f[6198]=-1082130432;n[6199]=0.0}c=d;e=c+96|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(e|0));Yb[f[(f[a>>2]|0)+76>>2]&127](a,24704,d,6);g=+n[a+44>>2];n[a+72>>2]=+n[d>>2]+g;n[a+56>>2]=+n[d+48>>2]-g;n[a+76>>2]=+n[d+20>>2]+g;n[a+60>>2]=+n[d+68>>2]-g;n[a+80>>2]=+n[d+40>>2]+g;n[a+64>>2]=+n[d+88>>2]-g;u=d;return}function zj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){i=f[a+12>>2]|0;k=f[i+(((b+c|0)/2|0)<<3)>>2]|0;e=c;d=b;while(1){while(1){j=d+1|0;if((f[i+(d<<3)>>2]|0)<(k|0))d=j;else break}while(1){g=i+(e<<3)|0;h=e+-1|0;if((f[g>>2]|0)>(k|0))e=h;else break}if((d|0)<=(e|0)){l=i+(d<<3)|0;i=f[l>>2]|0;d=f[l+4>>2]|0;m=f[g+4>>2]|0;f[l>>2]=f[g>>2];f[l+4>>2]=m;e=(f[a+12>>2]|0)+(e<<3)|0;f[e>>2]=i;f[e+4>>2]=d;e=h;d=j}if((d|0)>(e|0))break;i=f[a+12>>2]|0}if((e|0)>(b|0))zj(a,b,e);if((d|0)<(c|0))b=d;else break}return}function Aj(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;d=f[a+76>>2]|0;if(!d)return;e=f[c+4>>2]|0;if((e|0)==(f[c+8>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((h<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[c+4>>2]|0}if((e|0)>0){g=0;do{f[d+(g<<2)>>2]=f[(f[c+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[c+12>>2]|0;if(g){if(b[c+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[c+4>>2]|0}f[c+12>>2]=0}b[c+16>>0]=1;f[c+12>>2]=d;f[c+8>>2]=h;d=f[a+76>>2]|0}f[(f[c+12>>2]|0)+(e<<2)>>2]=d;f[c+4>>2]=e+1;return}function Bj(a,b,c){a=a|0;b=+b;c=+c;var d=0,e=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;e=f[a+732>>2]|0;if((e|0)<=0)return;d=f[a+740>>2]|0;a=0;do{c=+n[d+(a*52|0)+24>>2];if(c>0.0?(g=f[d+(a*52|0)+8>>2]|0,h=f[d+(a*52|0)+12>>2]|0,i=+n[g+8>>2],j=+n[h+8>>2]-i,k=+n[g+12>>2],l=+n[h+12>>2]-k,m=+n[g+16>>2],o=+n[h+16>>2]-m,p=+n[d+(a*52|0)+28>>2],p+(j*j+l*l+o*o)>1.1920928955078125e-07):0){c=(p-(j*j+l*l+o*o))/(c*(p+(j*j+l*l+o*o)))*b;q=c*+n[g+88>>2];n[g+8>>2]=i-j*q;n[g+12>>2]=k-l*q;n[g+16>>2]=m-o*q;c=c*+n[h+88>>2];n[h+8>>2]=+n[h+8>>2]+j*c;n[h+12>>2]=l*c+ +n[h+12>>2];n[h+16>>2]=o*c+ +n[h+16>>2]}a=a+1|0}while((a|0)!=(e|0));return}function Cj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0.0,h=0;e=u;u=u+16|0;f[a+4>>2]=f[b+24>>2];d=f[b>>2]|0;f[a+8>>2]=d;if(c){f[a+52>>2]=f[b+8>>2];f[a+52+4>>2]=f[b+8+4>>2];f[a+52+8>>2]=f[b+8+8>>2];f[a+52+12>>2]=f[b+8+12>>2];h=a+68|0;c=a+20|0;d=a+36|0;g=+n[b+24>>2];Sp(h,c,d,g);g=+n[b+24>>2];u=e;return +g}else{c=fI(NH(d)|0)|0;Ul(e,c,+n[b+8>>2],+n[b+12>>2],+n[b+16>>2]);f[a+52>>2]=f[e>>2];f[a+52+4>>2]=f[e+4>>2];f[a+52+8>>2]=f[e+8>>2];f[a+52+12>>2]=f[e+12>>2];c=a+68|0;d=a+20|0;h=a+36|0;g=+n[b+24>>2];Sp(c,d,h,g);g=+n[b+24>>2];u=e;return +g}return 0.0}function Dj(){var a=0,c=0;c=Zs()|0;f[c+8>>2]=0;f[c>>2]=6484;b[c+28>>0]=1;f[c+24>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[c+32>>2]=1566444395;f[c+36>>2]=1566444395;f[c+40>>2]=1566444395;n[c+44>>2]=0.0;f[c+48>>2]=-581039253;f[c+52>>2]=-581039253;f[c+56>>2]=-581039253;n[c+60>>2]=0.0;f[c+64>>2]=0;f[c+68>>2]=1;n[c+72>>2]=0.0;f[c+76>>2]=1065353216;f[c+80>>2]=1065353216;f[c+84>>2]=1065353216;n[c+88>>2]=0.0;f[c+4>>2]=31;f[6472]=(f[6472]|0)+1;a=sc(79)|0;if(!a)a=0;else{f[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=-1;f[a+12>>2]=0;f[a+16>>2]=0;f[c+64>>2]=a;return c|0}function Ej(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,k=0,l=0;g=f[a+108>>2]|0;if(g|0){Yb[f[(f[g>>2]|0)+28>>2]&127](g,b,c,e);return}g=d[a+56>>1]|0;if(!(g<<16>>16))return;l=1;i=1;do{h=f[a+68>>2]|0;if(d[h+(i<<2)>>1]&1){k=f[a+60>>2]|0;i=j[h+(i<<2)+2>>1]|0;if(!(+n[b>>2]>+n[k+(i<<6)+32>>2])?!(+n[c>>2]<+n[k+(i<<6)+16>>2]):0)h=1;else h=0;if(!(!(+n[b+8>>2]>+n[k+(i<<6)+40>>2])?!(+n[c+8>>2]<+n[k+(i<<6)+24>>2]):0))h=0;if(!(+n[b+4>>2]>+n[k+(i<<6)+36>>2])?!(+n[c+4>>2]<+n[k+(i<<6)+20>>2]|h^1):0){Db[f[(f[e>>2]|0)+8>>2]&31](e,k+(i<<6)|0)|0;g=d[a+56>>1]|0}}l=l+1<<16>>16;i=l&65535}while(((g&65535)<<1|1)>>>0>i>>>0);return}
function Fd(a,c,d,e,g,h,i,j,k,l,m,o,p){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;B=X(f[k+24>>2]|0,l)|0;y=b[c+44>>0]|0;A=f[c+56>>2]|0;if(!(y<<24>>24!=0|(A|0)!=0)){k=0;return k|0}C=f[(o|0?k+12|0:k+8|0)>>2]|0;l=f[(o|0?k+20|0:k+16|0)>>2]|0;f[C+(B<<2)>>2]=f[m>>2];f[C+(B+1<<2)>>2]=f[m+4>>2];f[C+(B+2<<2)>>2]=f[m+8>>2];n[l+(B<<2)>>2]=-+n[m>>2];n[l+(B+1<<2)>>2]=-+n[m+4>>2];n[l+(B+2<<2)>>2]=-+n[m+8>>2];if(!o){q=+n[a+1176>>2];if(!(b[a+1301>>0]|0)){q=q-+n[d+48>>2];r=+n[a+1180>>2]-+n[d+52>>2];w=+n[a+1184>>2]-+n[d+56>>2];u=+n[m+8>>2];v=+n[m+4>>2];x=+n[m>>2];l=f[k+12>>2]|0;n[l+(B<<2)>>2]=r*u-w*v;n[l+(B+1<<2)>>2]=w*x-q*u;n[l+(B+2<<2)>>2]=q*v-r*x;x=+n[a+1176>>2]-+n[e+48>>2];r=+n[a+1180>>2]-+n[e+52>>2];v=+n[a+1184>>2]-+n[e+56>>2];q=+n[m+8>>2];u=+n[m+4>>2];w=+n[m>>2];l=f[k+20>>2]|0;n[l+(B<<2)>>2]=-(r*q-v*u);r=x*u-r*w;d=l;q=-(v*w-x*q)}else{I=q-+n[e+48>>2];H=+n[a+1180>>2]-+n[e+52>>2];F=+n[a+1184>>2]-+n[e+56>>2];r=+n[m>>2];G=+n[m+4>>2];E=+n[m+8>>2];K=+n[a+1112>>2]-+n[d+48>>2];q=+n[a+1116>>2]-+n[d+52>>2];s=+n[a+1120>>2]-+n[d+56>>2];u=+n[c+52>>2]-+n[c+48>>2];J=r*(r*K+G*q+E*s)+r*u-r*(I*r+H*G+F*E);D=G*(r*K+G*q+E*s)+G*u-G*(I*r+H*G+F*E);u=E*(r*K+G*q+E*s)+E*u-E*(I*r+H*G+F*E);w=+n[a+1272>>2];x=+n[a+1276>>2];t=E*(q-G*(r*K+G*q+E*s)+w*D)-G*(s-E*(r*K+G*q+E*s)+w*u);v=r*(s-E*(r*K+G*q+E*s)+w*u)-E*(K-r*(r*K+G*q+E*s)+w*J);s=G*(K-r*(r*K+G*q+E*s)+w*J)-r*(q-G*(r*K+G*q+E*s)+w*D);q=(H-G*(I*r+H*G+F*E)-x*D)*E-(F-E*(I*r+H*G+F*E)-x*u)*G;u=(F-E*(I*r+H*G+F*E)-x*u)*r-(I-r*(I*r+H*G+F*E)-x*J)*E;r=(I-r*(I*r+H*G+F*E)-x*J)*G-(H-G*(I*r+H*G+F*E)-x*D)*r;if(!((p|0)!=0|(b[a+1280>>0]|0)==0)){t=w*t;v=w*v;s=w*s;q=x*q;u=x*u;r=x*r}l=(f[k+12>>2]|0)+(B<<2)|0;n[l>>2]=t;n[l+4>>2]=v;n[l+8>>2]=s;l=f[k+20>>2]|0;n[l+(B<<2)>>2]=-q;d=l;q=-u}n[l+(B+1<<2)>>2]=q;n[d+(B+2<<2)>>2]=-r}if(A|0?+n[c>>2]==+n[c+4>>2]:0){l=f[k+28>>2]|0;n[l+(B<<2)>>2]=0.0;q=0.0}else z=12;do if((z|0)==12){d=f[k+28>>2]|0;n[d+(B<<2)>>2]=0.0;if(!(y<<24>>24)){if(A|0){l=d;q=0.0;break}else l=1;return l|0}f[(f[k+32>>2]|0)+(B<<2)>>2]=f[c+28>>2];if(A|0){l=d;q=+n[d+(B<<2)>>2];break}v=+n[c+8>>2];q=o|0?v:-v;r=+n[c+52>>2];s=+n[c>>2];t=+n[c+4>>2];u=+n[k>>2]*+n[c+32>>2];do if(!(s>t))if(!(s==t)){if(q/u<0.0)if(r>=s?s-q/u>r:0){q=(s-r)/(q/u);break}else{q=r<s?0.0:1.0;break}if(q/u>0.0)if(r<=t?t-q/u<r:0){q=(t-r)/(q/u);break}else{q=r>t?0.0:1.0;break}else q=0.0}else q=0.0;else q=1.0;while(0);n[d+(B<<2)>>2]=q*v+ +n[d+(B<<2)>>2];n[(f[k+36>>2]|0)+(B<<2)>>2]=-+n[c+12>>2];f[(f[k+40>>2]|0)+(B<<2)>>2]=f[c+12>>2];C=1;return C|0}while(0);K=+n[k>>2]*+n[c+32>>2]*+n[c+48>>2];l=l+(B<<2)|0;n[l>>2]=q+(o|0?-K:K);f[(f[k+32>>2]|0)+(B<<2)>>2]=f[c+36>>2];if(+n[c>>2]==+n[c+4>>2]){n[(f[k+36>>2]|0)+(B<<2)>>2]=-3402823466385288598117041.0e14;n[(f[k+40>>2]|0)+(B<<2)>>2]=3402823466385288598117041.0e14;C=1;return C|0}n[(f[k+36>>2]|0)+(B<<2)>>2]=(A|0)==1?0.0:-3402823466385288598117041.0e14;n[(f[k+40>>2]|0)+(B<<2)>>2]=(A|0)==1?3402823466385288598117041.0e14:0.0;r=+n[c+40>>2];if(!(r>0.0)){C=1;return C|0}k=o|0?i:g;C=o|0?j:h;J=+n[m>>2];K=+n[m+4>>2];q=+n[m+8>>2];q=+n[k>>2]*J+ +n[k+4>>2]*K+ +n[k+8>>2]*q-(J*+n[C>>2]+K*+n[C+4>>2]+q*+n[C+8>>2]);if((A|0)==1){if(!(q<0.0)){C=1;return C|0}if(!(+n[l>>2]<-(r*q))){C=1;return C|0}n[l>>2]=-(r*q);C=1;return C|0}else{if(!(q>0.0)){C=1;return C|0}if(!(+n[l>>2]>-(r*q))){C=1;return C|0}n[l>>2]=-(r*q);C=1;return C|0}return 0}function Gd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0,o=0.0,p=0.0,q=0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=u;u=u+48|0;switch(f[b+4>>2]|0){case 8:{f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;u=z;return}case 0:{w=+n[b+28>>2];x=+n[b+28+4>>2];x=+n[c+4>>2]>=0.0?x:-x;y=+n[b+28+8>>2];y=+n[c+8>>2]>=0.0?y:-y;n[a>>2]=+n[c>>2]>=0.0?w:-w;n[a+4>>2]=x;n[a+8>>2]=y;n[a+12>>2]=0.0;u=z;return}case 1:{t=+n[c>>2];v=+n[c+4>>2];w=+n[c+8>>2];x=t*+n[b+56>>2]+v*+n[b+56+4>>2]+w*+n[b+56+8>>2];y=t*+n[b+56+16>>2]+v*+n[b+56+20>>2]+w*+n[b+56+24>>2];l=(x<y?y:x)<t*+n[b+56+32>>2]+v*+n[b+56+36>>2]+w*+n[b+56+40>>2]?2:x<y&1;m=f[b+56+(l<<4)+4>>2]|0;q=f[b+56+(l<<4)+8>>2]|0;f[a>>2]=f[b+56+(l<<4)>>2];f[a+4>>2]=m;f[a+8>>2]=q;n[a+12>>2]=0.0;u=z;return}case 13:{f[z+32>>2]=f[b+28>>2];f[z+32+4>>2]=f[b+28+4>>2];f[z+32+8>>2]=f[b+28+8>>2];f[z+32+12>>2]=f[b+28+12>>2];f[z+16>>2]=f[c>>2];d=f[c+4>>2]|0;f[z+16+4>>2]=d;q=f[c+8>>2]|0;f[z+16+8>>2]=q;n[z+16+12>>2]=0.0;c=f[b+52>>2]|0;e=(f[s>>2]=q,+n[s>>2]);switch(c|0){case 2:{b=0;l=2;m=1;e=(f[s>>2]=d,+n[s>>2]);break}case 1:{b=0;l=1;m=2;break}default:{b=1;l=0;m=2}}k=+n[z+32+(b<<2)>>2];g=+n[z+32+(c<<2)>>2];i=+n[z+16+(b<<2)>>2];j=+L(+(i*i+e*e));if(j!=0.0){h=k/j*e;d=z;g=+n[z+16+(l<<2)>>2]<0.0?-g:g;e=i*(k/j)}else{h=0.0;d=z;g=+n[z+16+(l<<2)>>2]<0.0?-g:g;e=k}n[z+(b<<2)>>2]=e;n[z+(l<<2)>>2]=g;n[z+(m<<2)>>2]=h;f[a>>2]=f[d>>2];f[a+4>>2]=f[z+4>>2];f[a+8>>2]=f[z+8>>2];n[a+12>>2]=0.0;u=z;return}case 10:{e=+n[c>>2];g=+n[c+4>>2];h=+n[c+8>>2];d=f[b+52>>2]|0;x=+n[b+28+(d<<2)>>2];i=+n[b+28+(((d+2|0)%3|0)<<2)>>2];if(e*e+g*g+h*h<9.999999747378752e-05){y=1.0;w=0.0;v=0.0}else{v=1.0/+L(+(e*e+g*g+h*h));y=e*v;w=g*v;v=h*v}f[z+32>>2]=0;f[z+32+4>>2]=0;f[z+32+8>>2]=0;f[z+32+12>>2]=0;n[z+32+(d<<2)>>2]=x;r=i*y;t=i*w;p=i*v;o=+n[b+44>>2];j=y*o;k=w*o;o=v*o;i=r+ +n[z+32>>2]-j;e=t+ +n[z+32+4>>2]-k;g=p+ +n[z+32+8>>2]-o;h=v*g+(y*i+w*e);if(h>-999999984306749440.0){m=(n[s>>2]=g,f[s>>2]|0);q=(n[s>>2]=e,f[s>>2]|0);l=(n[s>>2]=i,f[s>>2]|0)}else{h=-999999984306749440.0;l=0;m=0;q=0}f[z+32>>2]=0;f[z+32+4>>2]=0;f[z+32+8>>2]=0;f[z+32+12>>2]=0;n[z+32+(d<<2)>>2]=-x;r=r+ +n[z+32>>2]-j;x=t+ +n[z+32+4>>2]-k;e=p+ +n[z+32+8>>2]-o;d=v*e+(y*r+w*x)>h;c=(n[s>>2]=r,f[s>>2]|0);b=(n[s>>2]=x,f[s>>2]|0);m=d?(n[s>>2]=e,f[s>>2]|0):m;f[a>>2]=d?c:l;f[a+4>>2]=d?b:q;f[a+8>>2]=m;n[a+12>>2]=0.0;u=z;return}case 5:{m=f[b+92>>2]|0;l=f[b+96>>2]|0;o=+n[b+12>>2];p=+n[b+16>>2];k=+n[b+20>>2];i=+n[c>>2]*o;j=+n[c+4>>2]*p;g=+n[c+8>>2]*k;if((l|0)>0){d=-1;c=0;e=-3402823466385288598117041.0e14;while(1){h=i*+n[m+(c<<4)>>2]+j*+n[m+(c<<4)+4>>2]+g*+n[m+(c<<4)+8>>2];b=h>e;d=b?c:d;c=c+1|0;if((c|0)==(l|0))break;else e=b?h:e}}else d=-1;x=p*+n[m+(d<<4)+4>>2];y=k*+n[m+(d<<4)+8>>2];n[a>>2]=o*+n[m+(d<<4)>>2];n[a+4>>2]=x;n[a+8>>2]=y;n[a+12>>2]=0.0;u=z;return}case 4:{m=f[b+104>>2]|0;l=f[b+96>>2]|0;o=+n[b+12>>2];p=+n[b+16>>2];k=+n[b+20>>2];i=+n[c>>2]*o;j=+n[c+4>>2]*p;g=+n[c+8>>2]*k;if((l|0)>0){d=-1;c=0;e=-3402823466385288598117041.0e14;while(1){h=i*+n[m+(c<<4)>>2]+j*+n[m+(c<<4)+4>>2]+g*+n[m+(c<<4)+8>>2];b=h>e;d=b?c:d;c=c+1|0;if((c|0)==(l|0))break;else e=b?h:e}}else d=-1;x=p*+n[m+(d<<4)+4>>2];y=k*+n[m+(d<<4)+8>>2];n[a>>2]=o*+n[m+(d<<4)>>2];n[a+4>>2]=x;n[a+8>>2]=y;n[a+12>>2]=0.0;u=z;return}default:{Vb[f[(f[b>>2]|0)+68>>2]&127](a,b,c);u=z;return}}}function Hd(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0;s=u;u=u+32|0;g=Bb[f[(f[a>>2]|0)+28>>2]&127](a)|0;f[c+20>>2]=g;f[c>>2]=0;if(!g){r=a+4|0;e=c+4|0;r=f[r>>2]|0;f[e>>2]=r;e=a+8|0;e=f[e>>2]|0;r=c+8|0;f[r>>2]=e;r=a+12|0;r=f[r>>2]|0;e=c+12|0;f[e>>2]=r;a=a+16|0;a=f[a>>2]|0;e=c+16|0;f[e>>2]=a;u=s;return 19540}r=Fb[f[(f[e>>2]|0)+16>>2]&63](e,32,g)|0;g=f[r+8>>2]|0;q=Db[f[(f[e>>2]|0)+28>>2]&31](e,g)|0;f[c>>2]=q;q=Bb[f[(f[a>>2]|0)+28>>2]&127](a)|0;a:do if((q|0)>0){o=0;while(1){fc[f[(f[a>>2]|0)+16>>2]&3](a,s+28|0,s+4|0,s+16|0,s+8|0,s+24|0,s+20|0,s,s+12|0,o);h=f[s>>2]|0;f[g+24>>2]=h;f[g+28>>2]=f[s+4>>2];i=g+12|0;k=g+16|0;n=g+4|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[g+16>>2]=0;f[g+20>>2]=0;switch(f[s+12>>2]|0){case 2:{if(h|0){i=Fb[f[(f[e>>2]|0)+16>>2]&63](e,4,h*3|0)|0;j=f[i+8>>2]|0;m=Db[f[(f[e>>2]|0)+28>>2]&31](e,j)|0;f[g+8>>2]=m;if((f[s>>2]|0)>0){k=f[s+24>>2]|0;h=0;do{l=k+(X(f[s+20>>2]|0,h)|0)|0;m=h*3|0;f[j+(m<<2)>>2]=f[l>>2];f[j+(m+1<<2)>>2]=f[l+4>>2];f[j+(m+2<<2)>>2]=f[l+8>>2];h=h+1|0}while((h|0)<(f[s>>2]|0))}ac[f[(f[e>>2]|0)+20>>2]&31](e,i,19421,1497453121,f[i+8>>2]|0)}break}case 3:{if(h|0){l=Fb[f[(f[e>>2]|0)+16>>2]&63](e,8,h)|0;m=f[l+8>>2]|0;k=Db[f[(f[e>>2]|0)+28>>2]&31](e,m)|0;f[i>>2]=k;i=f[s>>2]|0;if((i|0)>0){j=f[s+24>>2]|0;k=f[s+20>>2]|0;h=0;do{t=j+(X(k,h)|0)|0;d[m+(h<<3)>>1]=d[t>>1]|0;d[m+(h<<3)+2>>1]=d[t+2>>1]|0;d[m+(h<<3)+4>>1]=d[t+4>>1]|0;h=h+1|0}while((h|0)!=(i|0))}ac[f[(f[e>>2]|0)+20>>2]&31](e,l,19436,1497453121,f[l+8>>2]|0)}break}case 5:{if(h|0){i=Fb[f[(f[e>>2]|0)+16>>2]&63](e,4,h)|0;j=f[i+8>>2]|0;t=Db[f[(f[e>>2]|0)+28>>2]&31](e,j)|0;f[k>>2]=t;if((f[s>>2]|0)>0){h=0;do{t=(f[s+24>>2]|0)+(X(f[s+20>>2]|0,h)|0)|0;b[j+(h<<2)>>0]=b[t>>0]|0;b[j+(h<<2)+1>>0]=b[t+1>>0]|0;b[j+(h<<2)+2>>0]=b[t+2>>0]|0;h=h+1|0}while((h|0)<(f[s>>2]|0))}ac[f[(f[e>>2]|0)+20>>2]&31](e,i,19463,1497453121,f[i+8>>2]|0)}break}default:{}}switch(f[s+16>>2]|0){case 0:{h=f[s+4>>2]|0;if(h|0){i=Fb[f[(f[e>>2]|0)+16>>2]&63](e,16,h)|0;j=f[i+8>>2]|0;k=Db[f[(f[e>>2]|0)+28>>2]&31](e,j)|0;f[g>>2]=k;k=f[s+4>>2]|0;if((k|0)>0){l=f[s+28>>2]|0;m=f[s+8>>2]|0;h=0;do{t=l+(X(m,h)|0)|0;f[j+(h<<4)>>2]=f[t>>2];f[j+(h<<4)+4>>2]=f[t+4>>2];f[j+(h<<4)+8>>2]=f[t+8>>2];h=h+1|0}while((h|0)!=(k|0))}ac[f[(f[e>>2]|0)+20>>2]&31](e,i,19486,1497453121,f[i+8>>2]|0)}break}case 1:{h=f[s+4>>2]|0;if(h|0){l=Fb[f[(f[e>>2]|0)+16>>2]&63](e,32,h)|0;m=f[l+8>>2]|0;i=Db[f[(f[e>>2]|0)+28>>2]&31](e,m)|0;f[n>>2]=i;i=f[s+4>>2]|0;if((i|0)>0){j=f[s+28>>2]|0;k=f[s+8>>2]|0;h=0;do{t=j+(X(k,h)|0)|0;p[m+(h<<5)>>3]=+p[t>>3];p[m+(h<<5)+8>>3]=+p[t+8>>3];p[m+(h<<5)+16>>3]=+p[t+16>>3];h=h+1|0}while((h|0)!=(i|0))}ac[f[(f[e>>2]|0)+20>>2]&31](e,l,19505,1497453121,f[l+8>>2]|0)}break}default:{}}Rb[f[(f[a>>2]|0)+24>>2]&127](a,o);o=o+1|0;if((o|0)==(q|0)){g=e;break a}else g=g+32|0}}else g=e;while(0);ac[f[(f[g>>2]|0)+20>>2]&31](e,r,19525,1497453121,f[r+8>>2]|0);t=a+4|0;e=c+4|0;t=f[t>>2]|0;f[e>>2]=t;e=a+8|0;e=f[e>>2]|0;t=c+8|0;f[t>>2]=e;t=a+12|0;t=f[t>>2]|0;e=c+12|0;f[e>>2]=t;e=a+16|0;e=f[e>>2]|0;t=c+16|0;f[t>>2]=e;u=s;return 19540}function Id(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0;D=f[a+88>>2]|0;if((D|0)==(f[a+92>>2]|0)?(m=D|0?D<<1:1,(D|0)<(m|0)):0){if(!m){i=0;k=D}else{f[6472]=(f[6472]|0)+1;i=sc((m*152|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}k=f[a+88>>2]|0}if((k|0)>0){j=0;do{ki(i+(j*152|0)|0,(f[a+96>>2]|0)+(j*152|0)|0,152)|0;j=j+1|0}while((j|0)!=(k|0))}j=f[a+96>>2]|0;if(j|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=i;f[a+92>>2]=m;i=f[a+88>>2]|0}else i=D;f[a+88>>2]=i+1;C=f[a+96>>2]|0;f[C+(D*152|0)+140>>2]=g;f[C+(D*152|0)+16>>2]=0;f[C+(D*152|0)+16+4>>2]=0;f[C+(D*152|0)+16+8>>2]=0;f[C+(D*152|0)+16+12>>2]=0;n[C+(D*152|0)+48>>2]=-0.0;n[C+(D*152|0)+52>>2]=-0.0;n[C+(D*152|0)+56>>2]=-0.0;n[C+(D*152|0)+60>>2]=0.0;g=f[a+16>>2]|0;m=f[g+(d*244|0)+240>>2]|0;B=f[g+(e*244|0)+240>>2]|0;f[C+(D*152|0)+144>>2]=d;f[C+(D*152|0)+148>>2]=e;a=f[h+88>>2]|0;f[C+(D*152|0)+104>>2]=a;f[C+(D*152|0)+132>>2]=0;n[C+(D*152|0)+100>>2]=0.0;n[C+(D*152|0)+96>>2]=0.0;x=-+n[c>>2];y=-+n[c+4>>2];z=-+n[c+8>>2];n[C+(D*152|0)>>2]=x;n[C+(D*152|0)+4>>2]=y;n[C+(D*152|0)+8>>2]=z;n[C+(D*152|0)+12>>2]=0.0;A=(f[s>>2]=a,+n[s>>2]);if(m|0){i=(n[s>>2]=(+n[m+264>>2]*x+ +n[m+268>>2]*y+ +n[m+272>>2]*z)*+n[m+544>>2],f[s>>2]|0);j=(n[s>>2]=(+n[m+280>>2]*x+ +n[m+284>>2]*y+ +n[m+288>>2]*z)*+n[m+548>>2],f[s>>2]|0);k=(n[s>>2]=(+n[m+296>>2]*x+ +n[m+300>>2]*y+ +n[m+304>>2]*z)*+n[m+552>>2],f[s>>2]|0)}else{i=0;j=0;k=0}f[C+(D*152|0)+64>>2]=i;f[C+(D*152|0)+68>>2]=j;f[C+(D*152|0)+72>>2]=k;n[C+(D*152|0)+76>>2]=0.0;u=+n[c>>2];v=+n[c+4>>2];w=+n[c+8>>2];c=f[c+12>>2]|0;n[C+(D*152|0)+32>>2]=u;n[C+(D*152|0)+36>>2]=v;n[C+(D*152|0)+40>>2]=w;f[C+(D*152|0)+44>>2]=c;if(B|0){i=(n[s>>2]=(u*+n[B+264>>2]+v*+n[B+268>>2]+w*+n[B+272>>2])*+n[B+544>>2],f[s>>2]|0);j=(n[s>>2]=(u*+n[B+280>>2]+v*+n[B+284>>2]+w*+n[B+288>>2])*+n[B+548>>2],f[s>>2]|0);k=(n[s>>2]=(u*+n[B+296>>2]+v*+n[B+300>>2]+w*+n[B+304>>2])*+n[B+552>>2],f[s>>2]|0)}else{i=0;j=0;k=0}f[C+(D*152|0)+80>>2]=i;f[C+(D*152|0)+84>>2]=j;f[C+(D*152|0)+88>>2]=k;n[C+(D*152|0)+92>>2]=0.0;if(m|0){l=+n[m+264>>2]*x+ +n[m+268>>2]*y+ +n[m+272>>2]*z;o=+n[m+280>>2]*x+ +n[m+284>>2]*y+ +n[m+288>>2]*z;p=+n[m+296>>2]*x+ +n[m+300>>2]*y+ +n[m+304>>2]*z}else{l=0.0;o=0.0;p=0.0}if(B|0){q=+n[B+264>>2]*u+ +n[B+268>>2]*v+ +n[B+272>>2]*w;r=u*+n[B+280>>2]+v*+n[B+284>>2]+w*+n[B+288>>2];t=u*+n[B+296>>2]+v*+n[B+300>>2]+w*+n[B+304>>2]}else{q=0.0;r=0.0;t=0.0}r=1.0/(l*x+o*y+p*z+0.0+(q*u+r*v+t*w));n[C+(D*152|0)+108>>2]=r;if(m|0){o=+n[g+(d*244|0)+192>>2];p=+n[g+(d*244|0)+196>>2];q=+n[g+(d*244|0)+200>>2];l=(+n[g+(d*244|0)+176>>2]+ +n[g+(d*244|0)+208>>2])*0.0+(+n[g+(d*244|0)+180>>2]+ +n[g+(d*244|0)+212>>2])*0.0+(+n[g+(d*244|0)+184>>2]+ +n[g+(d*244|0)+216>>2])*0.0}else{o=0.0;p=0.0;q=0.0;l=0.0}l=l+(o*x+p*y+q*z);if(!B){t=0.0;x=0.0;z=0.0;y=-0.0;u=t*u;x=x*v;x=u+x;z=z*w;z=x+z;z=y+z;z=l+z;z=0.0-z;z=r*z;e=C+(D*152|0)+112|0;n[e>>2]=z;e=C+(D*152|0)+116|0;n[e>>2]=0.0;A=-A;e=C+(D*152|0)+120|0;n[e>>2]=A;D=C+(D*152|0)+124|0;f[D>>2]=a;return}t=+n[g+(e*244|0)+192>>2];x=+n[g+(e*244|0)+196>>2];z=+n[g+(e*244|0)+200>>2];y=(+n[g+(e*244|0)+176>>2]+ +n[g+(e*244|0)+208>>2])*-0.0+(+n[g+(e*244|0)+180>>2]+ +n[g+(e*244|0)+212>>2])*-0.0+(+n[g+(e*244|0)+184>>2]+ +n[g+(e*244|0)+216>>2])*-0.0;u=t*u;x=x*v;x=u+x;z=z*w;z=x+z;z=y+z;z=l+z;z=0.0-z;z=r*z;e=C+(D*152|0)+112|0;n[e>>2]=z;e=C+(D*152|0)+116|0;n[e>>2]=0.0;A=-A;e=C+(D*152|0)+120|0;n[e>>2]=A;D=C+(D*152|0)+124|0;f[D>>2]=a;return}function Jd(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0,h=0,i=0,j=0.0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0;k=u;u=u+16|0;f[a+236>>2]=2;f[a+312>>2]=0;f[a+312+4>>2]=0;f[a+312+8>>2]=0;f[a+312+12>>2]=0;f[a+312+16>>2]=0;f[a+312+20>>2]=0;f[a+312+24>>2]=0;f[a+312+28>>2]=0;f[a+544>>2]=1065353216;f[a+548>>2]=1065353216;f[a+552>>2]=1065353216;n[a+556>>2]=0.0;f[a+348>>2]=1065353216;f[a+352>>2]=1065353216;f[a+356>>2]=1065353216;d=a+360|0;g=d+36|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(g|0));f[a+412>>2]=0;f[a+412+4>>2]=0;f[a+412+8>>2]=0;f[a+412+12>>2]=0;f[a+412+16>>2]=0;f[a+412+20>>2]=0;f[a+412+24>>2]=0;f[a+412+28>>2]=0;e=+n[c+92>>2];j=+n[c+96>>2];n[k+12>>2]=e;n[k+8>>2]=j;n[k+4>>2]=0.0;n[k>>2]=1.0;f[a+444>>2]=f[(e<0.0?k+4|0:e>1.0?k:k+12|0)>>2];n[k+4>>2]=0.0;n[k>>2]=1.0;f[a+448>>2]=f[(j<0.0?k+4|0:j>1.0?k:k+8|0)>>2];f[a+472>>2]=f[c+112>>2];f[a+476>>2]=f[c+116>>2];d=f[c+4>>2]|0;f[a+480>>2]=d;f[a+608>>2]=0;f[a+612>>2]=0;b[a+452>>0]=b[c+120>>0]|0;f[a+456>>2]=f[c+124>>2];f[a+460>>2]=f[c+128>>2];f[a+464>>2]=f[c+132>>2];f[a+468>>2]=f[c+136>>2];if(!d){f[a+4>>2]=f[c+8>>2];f[a+4+4>>2]=f[c+8+4>>2];f[a+4+8>>2]=f[c+8+8>>2];f[a+4+12>>2]=f[c+8+12>>2];f[a+20>>2]=f[c+24>>2];f[a+20+4>>2]=f[c+24+4>>2];f[a+20+8>>2]=f[c+24+8>>2];f[a+20+12>>2]=f[c+24+12>>2];f[a+36>>2]=f[c+40>>2];f[a+36+4>>2]=f[c+40+4>>2];f[a+36+8>>2]=f[c+40+8>>2];f[a+36+12>>2]=f[c+40+12>>2];f[a+52>>2]=f[c+56>>2];f[a+52+4>>2]=f[c+56+4>>2];f[a+52+8>>2]=f[c+56+8>>2];f[a+52+12>>2]=f[c+56+12>>2];d=a+20|0;g=a+36|0;h=a+52|0;i=a+4|0}else{Rb[f[(f[d>>2]|0)+8>>2]&127](d,a+4|0);d=a+20|0;g=a+36|0;h=a+52|0;i=a+4|0}f[a+68>>2]=f[i>>2];f[a+68+4>>2]=f[i+4>>2];f[a+68+8>>2]=f[i+8>>2];f[a+68+12>>2]=f[i+12>>2];f[a+84>>2]=f[d>>2];f[a+84+4>>2]=f[d+4>>2];f[a+84+8>>2]=f[d+8>>2];f[a+84+12>>2]=f[d+12>>2];f[a+100>>2]=f[g>>2];f[a+100+4>>2]=f[g+4>>2];f[a+100+8>>2]=f[g+8>>2];f[a+100+12>>2]=f[g+12>>2];f[a+116>>2]=f[h>>2];f[a+116+4>>2]=f[h+4>>2];f[a+116+8>>2]=f[h+8>>2];f[a+116+12>>2]=f[h+12>>2];f[a+132>>2]=0;f[a+132+4>>2]=0;f[a+132+8>>2]=0;f[a+132+12>>2]=0;f[a+132+16>>2]=0;f[a+132+20>>2]=0;f[a+132+24>>2]=0;f[a+132+28>>2]=0;f[a+224>>2]=f[c+100>>2];f[a+232>>2]=f[c+104>>2];f[a+228>>2]=f[c+108>>2];Rb[f[(f[a>>2]|0)+12>>2]&127](a,f[c+72>>2]|0);d=f[5852]|0;f[5852]=d+1;f[a+508>>2]=d;e=+n[c>>2];d=f[a+204>>2]|0;if(e==0.0){f[a+204>>2]=d|1;j=0.0}else{f[a+204>>2]=d&-2;j=1.0/e}n[a+344>>2]=j;m=e*+n[a+384>>2];l=e*+n[a+388>>2];n[a+364>>2]=e*+n[a+380>>2];n[a+368>>2]=m;n[a+372>>2]=l;n[a+376>>2]=0.0;e=+n[c+76>>2];g=e!=0.0?(n[s>>2]=1.0/e,f[s>>2]|0):0;e=+n[c+80>>2];d=e!=0.0?(n[s>>2]=1.0/e,f[s>>2]|0):0;e=+n[c+84>>2];c=e!=0.0?(n[s>>2]=1.0/e,f[s>>2]|0):0;f[a+396>>2]=g;f[a+400>>2]=d;f[a+404>>2]=c;n[a+408>>2]=0.0;o=j*+n[a+352>>2];x=j*+n[a+356>>2];n[a+560>>2]=j*+n[a+348>>2];n[a+564>>2]=o;n[a+568>>2]=x;n[a+572>>2]=0.0;x=+n[a+4>>2];o=(f[s>>2]=g,+n[s>>2]);w=+n[a+8>>2];m=(f[s>>2]=d,+n[s>>2]);v=+n[a+12>>2];j=(f[s>>2]=c,+n[s>>2]);t=+n[a+20>>2];r=+n[a+24>>2];q=+n[a+28>>2];p=+n[a+36>>2];e=+n[a+40>>2];l=+n[a+44>>2];n[a+264>>2]=x*x*o+w*w*m+v*v*j;n[a+268>>2]=x*o*t+w*m*r+v*j*q;n[a+272>>2]=x*o*p+w*m*e+v*j*l;n[a+276>>2]=0.0;n[a+280>>2]=x*t*o+w*r*m+v*q*j;n[a+284>>2]=t*t*o+r*r*m+q*q*j;n[a+288>>2]=t*o*p+r*m*e+q*j*l;n[a+292>>2]=0.0;n[a+296>>2]=x*p*o+w*e*m+v*l*j;n[a+300>>2]=t*p*o+r*e*m+q*l*j;n[a+304>>2]=p*p*o+e*e*m+l*l*j;n[a+308>>2]=0.0;f[a+504>>2]=0;f[a+512>>2]=0;f[a+512+4>>2]=0;f[a+512+8>>2]=0;f[a+512+12>>2]=0;f[a+512+16>>2]=0;f[a+512+20>>2]=0;f[a+512+24>>2]=0;f[a+512+28>>2]=0;j=+n[a+344>>2];l=j*+n[a+352>>2];m=j*+n[a+356>>2];n[a+560>>2]=+n[a+348>>2]*j;n[a+564>>2]=l;n[a+568>>2]=m;d=a+572|0;g=d+36|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(g|0));u=k;return}function Kd(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;g=u;u=u+240|0;if(!(f[a+16>>2]|0)){K=f[a+12>>2]|0;a=f[a+20>>2]|0;x=+n[c>>2];p=+n[c+4>>2];t=+n[c+8>>2];i=+n[c+16>>2];q=+n[c+20>>2];h=+n[c+24>>2];k=+n[c+32>>2];r=+n[c+36>>2];l=+n[c+40>>2];F=+n[c+48>>2];E=+n[c+52>>2];D=+n[c+56>>2];J=+n[d>>2];I=+n[d+16>>2];z=+n[d+32>>2];H=+n[d+4>>2];G=+n[d+20>>2];y=+n[d+36>>2];v=+n[d+8>>2];j=+n[d+24>>2];o=+n[d+40>>2];C=-+n[d+48>>2];B=-+n[d+52>>2];w=-+n[d+56>>2];c=f[(f[K>>2]|0)+64>>2]|0;A=-+n[a+48>>2];s=-+n[a+52>>2];m=-+n[a+56>>2];n[g+16>>2]=(x*J+i*I+k*z)*A+(x*H+i*G+k*y)*s+(x*v+i*j+k*o)*m;n[g+16+4>>2]=(p*J+q*I+r*z)*A+(p*H+q*G+r*y)*s+(p*v+q*j+r*o)*m;n[g+16+8>>2]=(t*J+h*I+l*z)*A+(t*H+h*G+l*y)*s+(t*v+h*j+l*o)*m;n[g+16+12>>2]=0.0;Vb[c&127](g+152|0,K,g+16|0);m=+n[g+152>>2];s=+n[g+152+4>>2];A=+n[g+152+8>>2];z=F*J+E*I+D*z+(J*C+I*B+z*w)+((x*J+i*I+k*z)*m+(p*J+q*I+r*z)*s+(t*J+h*I+l*z)*A);y=F*H+E*G+D*y+(H*C+G*B+y*w)+((x*H+i*G+k*y)*m+(p*H+q*G+r*y)*s+(t*H+h*G+l*y)*A);A=F*v+E*j+D*o+(v*C+j*B+o*w)+((x*v+i*j+k*o)*m+(p*v+q*j+r*o)*s+(t*v+h*j+l*o)*A);o=+n[a+48>>2];l=+n[a+52>>2];j=+n[a+56>>2];h=j*A+(o*z+l*y)-+n[a+64>>2];v=+n[d>>2];t=+n[d+4>>2];s=+n[d+8>>2];r=+n[d+16>>2];q=+n[d+20>>2];p=+n[d+24>>2];m=+n[d+32>>2];k=+n[d+36>>2];i=+n[d+40>>2];x=(z-o*h)*r+(y-l*h)*q+(A-j*h)*p+ +n[d+52>>2];w=(z-o*h)*m+(y-l*h)*k+(A-j*h)*i+ +n[d+56>>2];n[g+16>>2]=s*(A-j*h)+(v*(z-o*h)+t*(y-l*h))+ +n[d+48>>2];n[g+16+4>>2]=x;n[g+16+8>>2]=w;n[g+16+12>>2]=0.0;n[g>>2]=v*o+t*l+s*j;n[g+4>>2]=o*r+l*q+j*p;n[g+8>>2]=o*m+l*k+j*i;n[g+12>>2]=0.0;Wb[f[(f[e>>2]|0)+16>>2]&15](e,g,g+16|0,h);u=g;return}else{N=f[a+4>>2]|0;b[N+312>>0]=0;f[N>>2]=0;b[N+356>>0]=1;f[N+292>>2]=1566444395;f[N+296>>2]=1566444395;f[N+300>>2]=1566444395;n[N+304>>2]=0.0;f[N+336>>2]=0;f[N+336+4>>2]=0;f[N+336+8>>2]=0;f[N+336+12>>2]=0;b[N+336+16>>0]=0;b[N+332>>0]=b[N+332>>0]&-16;N=f[a+12>>2]|0;M=f[a+16>>2]|0;L=f[N+4>>2]|0;K=f[M+4>>2]|0;I=+rb[f[(f[N>>2]|0)+48>>2]&15](N);O=f[a+16>>2]|0;J=+rb[f[(f[O>>2]|0)+48>>2]&15](O);O=f[a+4>>2]|0;a=f[a+8>>2]|0;f[g+152>>2]=9400;f[g+152+4>>2]=0;f[g+152+8>>2]=1065353216;f[g+152+12>>2]=0;n[g+152+16>>2]=0.0;f[g+152+20>>2]=a;f[g+152+24>>2]=O;f[g+152+28>>2]=N;f[g+152+32>>2]=M;f[g+152+36>>2]=L;f[g+152+40>>2]=K;n[g+152+44>>2]=I;n[g+152+48>>2]=J;b[g+152+52>>0]=0;f[g+152+60>>2]=-1;f[g+152+72>>2]=1;f[g+152+76>>2]=1;n[g+16+128>>2]=999999984306749440.0;f[g+16>>2]=f[c>>2];f[g+16+4>>2]=f[c+4>>2];f[g+16+8>>2]=f[c+8>>2];f[g+16+12>>2]=f[c+12>>2];f[g+16+16>>2]=f[c+16>>2];f[g+16+16+4>>2]=f[c+16+4>>2];f[g+16+16+8>>2]=f[c+16+8>>2];f[g+16+16+12>>2]=f[c+16+12>>2];f[g+16+32>>2]=f[c+32>>2];f[g+16+32+4>>2]=f[c+32+4>>2];f[g+16+32+8>>2]=f[c+32+8>>2];f[g+16+32+12>>2]=f[c+32+12>>2];f[g+16+48>>2]=f[c+48>>2];f[g+16+48+4>>2]=f[c+48+4>>2];f[g+16+48+8>>2]=f[c+48+8>>2];f[g+16+48+12>>2]=f[c+48+12>>2];f[g+16+64>>2]=f[d>>2];f[g+16+64+4>>2]=f[d+4>>2];f[g+16+64+8>>2]=f[d+8>>2];f[g+16+64+12>>2]=f[d+12>>2];f[g+16+80>>2]=f[d+16>>2];f[g+16+80+4>>2]=f[d+16+4>>2];f[g+16+80+8>>2]=f[d+16+8>>2];f[g+16+80+12>>2]=f[d+16+12>>2];f[g+16+96>>2]=f[d+32>>2];f[g+16+96+4>>2]=f[d+32+4>>2];f[g+16+96+8>>2]=f[d+32+8>>2];f[g+16+96+12>>2]=f[d+32+12>>2];f[g+16+112>>2]=f[d+48>>2];f[g+16+112+4>>2]=f[d+48+4>>2];f[g+16+112+8>>2]=f[d+48+8>>2];f[g+16+112+12>>2]=f[d+48+12>>2];Nc(g+152|0,g+16|0,e,0,0);u=g;return}}function Ld(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=+g;var h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0;h=u;u=u+464|0;uj(15915);f[h+128>>2]=f[c>>2];f[h+128+4>>2]=f[c+4>>2];f[h+128+8>>2]=f[c+8>>2];f[h+128+12>>2]=f[c+12>>2];f[h+128+16>>2]=f[c+16>>2];f[h+128+16+4>>2]=f[c+16+4>>2];f[h+128+16+8>>2]=f[c+16+8>>2];f[h+128+16+12>>2]=f[c+16+12>>2];f[h+128+32>>2]=f[c+32>>2];f[h+128+32+4>>2]=f[c+32+4>>2];f[h+128+32+8>>2]=f[c+32+8>>2];f[h+128+32+12>>2]=f[c+32+12>>2];j=h+128+48|0;f[j>>2]=f[c+48>>2];f[j+4>>2]=f[c+48+4>>2];f[j+8>>2]=f[c+48+8>>2];f[j+12>>2]=f[c+48+12>>2];f[h+64>>2]=f[d>>2];f[h+64+4>>2]=f[d+4>>2];f[h+64+8>>2]=f[d+8>>2];f[h+64+12>>2]=f[d+12>>2];f[h+64+16>>2]=f[d+16>>2];f[h+64+16+4>>2]=f[d+16+4>>2];f[h+64+16+8>>2]=f[d+16+8>>2];f[h+64+16+12>>2]=f[d+16+12>>2];f[h+64+32>>2]=f[d+32>>2];f[h+64+32+4>>2]=f[d+32+4>>2];f[h+64+32+8>>2]=f[d+32+8>>2];f[h+64+32+12>>2]=f[d+32+12>>2];i=h+64+48|0;f[i>>2]=f[d+48>>2];f[i+4>>2]=f[d+48+4>>2];f[i+8>>2]=f[d+48+8>>2];f[i+12>>2]=f[d+48+12>>2];Ef(h+128|0,h+64|0,h+256|0,h+192|0);s=+n[h+192>>2];k=s*+n[h+256+4>>2];q=s*+n[h+256+8>>2];n[h+16>>2]=+n[h+256>>2]*s;n[h+16+4>>2]=k;n[h+16+8>>2]=q;n[h+16+12>>2]=0.0;f[h+256>>2]=0;f[h+256+4>>2]=0;f[h+256+8>>2]=0;f[h+256+12>>2]=0;f[h+192+48>>2]=0;f[h+192+48+4>>2]=0;f[h+192+48+8>>2]=0;f[h+192+48+12>>2]=0;mh(h+128|0,h);q=+n[h>>2];k=+n[h+4>>2];s=+n[h+8>>2];p=+n[h+12>>2];m=q*(2.0/(q*q+k*k+s*s+p*p));l=k*(2.0/(q*q+k*k+s*s+p*p));o=s*(2.0/(q*q+k*k+s*s+p*p));n[h+192>>2]=1.0-(k*l+s*o);n[h+192+4>>2]=q*l-p*o;n[h+192+8>>2]=q*o+p*l;n[h+192+12>>2]=0.0;n[h+192+16>>2]=q*l+p*o;n[h+192+20>>2]=1.0-(q*m+s*o);n[h+192+24>>2]=k*o-p*m;n[h+192+28>>2]=0.0;n[h+192+32>>2]=q*o-p*l;n[h+192+36>>2]=k*o+p*m;n[h+192+40>>2]=1.0-(q*m+k*l);n[h+192+44>>2]=0.0;jh(b,h+192|0,h+256|0,h+16|0,h+48|0,h+32|0);f[h+256>>2]=6128;f[h+256+36>>2]=f[c>>2];f[h+256+36+4>>2]=f[c+4>>2];f[h+256+36+8>>2]=f[c+8>>2];f[h+256+36+12>>2]=f[c+12>>2];f[h+256+52>>2]=f[c+16>>2];f[h+256+52+4>>2]=f[c+16+4>>2];f[h+256+52+8>>2]=f[c+16+8>>2];f[h+256+52+12>>2]=f[c+16+12>>2];f[h+256+68>>2]=f[c+32>>2];f[h+256+68+4>>2]=f[c+32+4>>2];f[h+256+68+8>>2]=f[c+32+8>>2];f[h+256+68+12>>2]=f[c+32+12>>2];r=h+256+84|0;f[r>>2]=f[c+48>>2];f[r+4>>2]=f[c+48+4>>2];f[r+8>>2]=f[c+48+8>>2];f[r+12>>2]=f[c+48+12>>2];f[h+256+100>>2]=f[d>>2];f[h+256+100+4>>2]=f[d+4>>2];f[h+256+100+8>>2]=f[d+8>>2];f[h+256+100+12>>2]=f[d+12>>2];f[h+256+116>>2]=f[d+16>>2];f[h+256+116+4>>2]=f[d+16+4>>2];f[h+256+116+8>>2]=f[d+16+8>>2];f[h+256+116+12>>2]=f[d+16+12>>2];f[h+256+132>>2]=f[d+32>>2];f[h+256+132+4>>2]=f[d+32+4>>2];f[h+256+132+8>>2]=f[d+32+8>>2];f[h+256+132+12>>2]=f[d+32+12>>2];c=h+256+148|0;f[c>>2]=f[d+48>>2];f[c+4>>2]=f[d+48+4>>2];f[c+8>>2]=f[d+48+8>>2];f[c+12>>2]=f[d+48+12>>2];f[h+256+180>>2]=a;f[h+256+184>>2]=e;n[h+256+188>>2]=g;f[h+256+192>>2]=b;l=+n[c>>2]-+n[r>>2];k=+n[h+256+152>>2]-+n[h+256+88>>2];m=+n[h+256+156>>2]-+n[h+256+92>>2];g=1.0/+L(+(l*l+k*k+m*m));q=l*g==0.0?999999984306749440.0:1.0/(l*g);n[h+256+4>>2]=q;p=k*g==0.0?999999984306749440.0:1.0/(k*g);n[h+256+8>>2]=p;o=m*g==0.0?999999984306749440.0:1.0/(m*g);n[h+256+12>>2]=o;f[h+256+20>>2]=q<0.0&1;f[h+256+24>>2]=p<0.0&1;f[h+256+28>>2]=o<0.0&1;n[h+256+32>>2]=m*m*g+(l*l*g+k*k*g);a=f[a+68>>2]|0;cc[f[(f[a>>2]|0)+24>>2]&7](a,j,i,h+256|0,h+48|0,h+32|0);a=f[2405]|0;e=(f[a+16>>2]|0)+-1|0;f[a+16>>2]=e;if(e|0){u=h;return}do if(f[a+4>>2]|0){gb(h+256|0,0)|0;r=f[6471]|0;n[a+8>>2]=+n[a+8>>2]+ +(((f[h+256+4>>2]|0)-(f[r+4>>2]|0)+(((f[h+256>>2]|0)-(f[r>>2]|0)|0)*1e6|0)-(f[a+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[a+16>>2]|0)){a=f[2405]|0;break}else{u=h;return}}while(0);f[2405]=f[a+20>>2];u=h;return}function Md(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;o=f[a+192>>2]|0;m=+rb[f[(f[o>>2]|0)+48>>2]&15](o);o=f[a+712>>2]|0;if((o|0)>0){h=0;do{l=f[a+720>>2]|0;e=l+(h*104|0)+8|0;q=+n[e>>2];g=l+(h*104|0)+12|0;p=+n[g>>2];c=l+(h*104|0)+16|0;k=+n[c>>2];i=q*+n[b>>2]+p*+n[b+4>>2]+k*+n[b+8>>2]+ +n[b+48>>2];j=q*+n[b+16>>2]+p*+n[b+20>>2]+k*+n[b+24>>2]+ +n[b+52>>2];k=q*+n[b+32>>2]+p*+n[b+36>>2]+k*+n[b+40>>2]+ +n[b+56>>2];n[e>>2]=i;n[g>>2]=j;n[c>>2]=k;n[l+(h*104|0)+20>>2]=0.0;c=l+(h*104|0)+24|0;p=+n[c>>2];g=l+(h*104|0)+28|0;q=+n[g>>2];e=l+(h*104|0)+32|0;r=+n[e>>2];s=p*+n[b+16>>2]+q*+n[b+20>>2]+r*+n[b+24>>2]+ +n[b+52>>2];t=p*+n[b+32>>2]+q*+n[b+36>>2]+r*+n[b+40>>2]+ +n[b+56>>2];n[c>>2]=p*+n[b>>2]+q*+n[b+4>>2]+r*+n[b+8>>2]+ +n[b+48>>2];n[g>>2]=s;n[e>>2]=t;n[l+(h*104|0)+36>>2]=0.0;e=l+(h*104|0)+72|0;t=+n[e>>2];g=l+(h*104|0)+76|0;s=+n[g>>2];c=l+(h*104|0)+80|0;r=+n[c>>2];q=t*+n[b+16>>2]+s*+n[b+20>>2]+r*+n[b+24>>2];p=t*+n[b+32>>2]+s*+n[b+36>>2]+r*+n[b+40>>2];n[e>>2]=+n[b>>2]*t+ +n[b+4>>2]*s+ +n[b+8>>2]*r;n[g>>2]=q;n[c>>2]=p;n[l+(h*104|0)+84>>2]=0.0;l=f[l+(h*104|0)+96>>2]|0;c=zg(a+928|0,l)|0;a:do if(c){g=f[a+936>>2]|0;if((g|0)<=-1){c=f[a+928>>2]|0;break}if(g){d=0;while(1){e=f[c+32>>2]|0;d=d+1|0;if(!e)break a;if((d|0)>=(g|0)){c=e;break}else c=e}}}else c=0;while(0);n[l>>2]=i-m;n[l+4>>2]=j-m;n[l+8>>2]=k-m;n[l+12>>2]=0.0;n[l+16>>2]=m+i;n[l+20>>2]=m+j;n[l+24>>2]=m+k;n[l+28>>2]=0.0;ff(a+928|0,c,l);h=h+1|0}while((h|0)!=(o|0))}Cg(a);c=f[a+928>>2]|0;if(c){o=f[a+192>>2]|0;r=+rb[f[(f[o>>2]|0)+48>>2]&15](o);t=+n[c+4>>2]-r;s=+n[c+8>>2]-r;n[a+892>>2]=+n[c>>2]-r;n[a+896>>2]=t;n[a+900>>2]=s;n[a+904>>2]=0.0;s=r+ +n[c+20>>2];t=r+ +n[c+24>>2];n[a+908>>2]=r+ +n[c+16>>2];n[a+912>>2]=s;n[a+916>>2]=t;n[a+920>>2]=0.0;c=f[a+188>>2]|0;if(c|0){o=f[a+684>>2]|0;l=f[o+32>>2]|0;ac[f[(f[l>>2]|0)+16>>2]&31](l,c,a+892|0,a+908|0,f[o+36>>2]|0)}}else{f[a+892>>2]=0;f[a+892+4>>2]=0;f[a+892+8>>2]=0;f[a+892+12>>2]=0;f[a+892+16>>2]=0;f[a+892+20>>2]=0;f[a+892+24>>2]=0;f[a+892+28>>2]=0}d=f[a+732>>2]|0;if((d|0)<=0){Sf(a);o=a+1148|0;f[o>>2]=f[b>>2];f[o+4>>2]=f[b+4>>2];f[o+8>>2]=f[b+8>>2];f[o+12>>2]=f[b+12>>2];o=b+16|0;l=a+1164|0;f[l>>2]=f[o>>2];f[l+4>>2]=f[o+4>>2];f[l+8>>2]=f[o+8>>2];f[l+12>>2]=f[o+12>>2];l=b+32|0;o=a+1180|0;f[o>>2]=f[l>>2];f[o+4>>2]=f[l+4>>2];f[o+8>>2]=f[l+8>>2];f[o+12>>2]=f[l+12>>2];o=b+48|0;b=a+1196|0;f[b>>2]=f[o>>2];f[b+4>>2]=f[o+4>>2];f[b+8>>2]=f[o+8>>2];f[b+12>>2]=f[o+12>>2];return}e=f[a+740>>2]|0;c=0;do{l=f[e+(c*52|0)+8>>2]|0;o=f[e+(c*52|0)+12>>2]|0;r=+n[l+8>>2]-+n[o+8>>2];s=+n[l+12>>2]-+n[o+12>>2];t=+n[l+16>>2]-+n[o+16>>2];t=+L(+(r*r+s*s+t*t));n[e+(c*52|0)+16>>2]=t;n[e+(c*52|0)+28>>2]=t*t;c=c+1|0}while((c|0)!=(d|0));c=0;do{n[e+(c*52|0)+24>>2]=(+n[(f[e+(c*52|0)+8>>2]|0)+88>>2]+ +n[(f[e+(c*52|0)+12>>2]|0)+88>>2])/+n[(f[e+(c*52|0)+4>>2]|0)+4>>2];c=c+1|0}while((c|0)!=(d|0));Sf(a);o=a+1148|0;f[o>>2]=f[b>>2];f[o+4>>2]=f[b+4>>2];f[o+8>>2]=f[b+8>>2];f[o+12>>2]=f[b+12>>2];o=b+16|0;l=a+1164|0;f[l>>2]=f[o>>2];f[l+4>>2]=f[o+4>>2];f[l+8>>2]=f[o+8>>2];f[l+12>>2]=f[o+12>>2];l=b+32|0;o=a+1180|0;f[o>>2]=f[l>>2];f[o+4>>2]=f[l+4>>2];f[o+8>>2]=f[l+8>>2];f[o+12>>2]=f[l+12>>2];o=b+48|0;b=a+1196|0;f[b>>2]=f[o>>2];f[b+4>>2]=f[o+4>>2];f[b+8>>2]=f[o+8>>2];f[b+12>>2]=f[o+12>>2];return}function Nd(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0;x=u;u=u+64|0;if((g|0)>0){a=0;i=0;do{w=f[e+(i<<2)>>2]|0;a=(w|0)>(a|0)?w:a;i=i+1|0}while((i|0)<(g*3|0))}else a=0;s=a+1|0;j=X(s,s)|0;if(!j)i=0;else{f[6472]=(f[6472]|0)+1;i=sc(j+19|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}bl(i|0,0,j|0)|0}if((a|0)>-1){f[6472]=(f[6472]|0)+1;a=sc((s<<4|3)+16|0)|0;if(!a)k=0;else{f[(a+4+15&-16)+-4>>2]=a;k=a+4+15&-16}a=0;do{w=k+(a<<4)|0;f[w>>2]=f[x>>2];f[w+4>>2]=f[x+4>>2];f[w+8>>2]=f[x+8>>2];f[w+12>>2]=f[x+12>>2];a=a+1|0}while((a|0)!=(s|0));a=0;j=0;while(1){v=f[d+(j+1<<2)>>2]|0;w=f[d+(j+2<<2)>>2]|0;f[k+(a<<4)>>2]=f[d+(j<<2)>>2];f[k+(a<<4)+4>>2]=v;f[k+(a<<4)+8>>2]=w;n[k+(a<<4)+12>>2]=0.0;j=j+3|0;if((j|0)>=(s*3|0)){w=k;v=k;break}else a=a+1|0}}else{w=0;v=0}f[6472]=(f[6472]|0)+1;a=sc(1271)|0;if(!a)t=0;else{f[(a+4+15&-16)+-4>>2]=a;t=a+4+15&-16}Bc(t,c,s,w,0);if((g|0)>0){c=t+720|0;l=t+732|0;m=t+740|0;o=t+924|0;d=0;do{p=f[e+(d<<2)>>2]|0;q=f[e+(d+1<<2)>>2]|0;r=f[e+(d+2<<2)>>2]|0;k=X(p,s)|0;a=i+(k+r)|0;if(!(b[a>>0]|0)){b[a>>0]=1;B=i+(p+(X(r,s)|0))|0;b[B>>0]=1;B=f[c>>2]|0;_h(t,0);j=(f[l>>2]|0)+-1|0;a=f[m>>2]|0;f[a+(j*52|0)+8>>2]=B+(r*104|0);f[a+(j*52|0)+12>>2]=B+(p*104|0);A=+n[B+(r*104|0)+8>>2]-+n[B+(p*104|0)+8>>2];z=+n[B+(r*104|0)+12>>2]-+n[B+(p*104|0)+12>>2];y=+n[B+(r*104|0)+16>>2]-+n[B+(p*104|0)+16>>2];y=+L(+(A*A+z*z+y*y));n[a+(j*52|0)+16>>2]=y;b[o>>0]=1}j=X(q,s)|0;a=i+(j+p)|0;if(!(b[a>>0]|0)){b[a>>0]=1;b[i+(q+k)>>0]=1;a=f[c>>2]|0;_h(t,0);B=(f[l>>2]|0)+-1|0;k=f[m>>2]|0;f[k+(B*52|0)+8>>2]=a+(p*104|0);f[k+(B*52|0)+12>>2]=a+(q*104|0);y=+n[a+(p*104|0)+8>>2]-+n[a+(q*104|0)+8>>2];z=+n[a+(p*104|0)+12>>2]-+n[a+(q*104|0)+12>>2];A=+n[a+(p*104|0)+16>>2]-+n[a+(q*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[k+(B*52|0)+16>>2]=A;b[o>>0]=1}a=i+((X(r,s)|0)+q)|0;if(!(b[a>>0]|0)){b[a>>0]=1;b[i+(r+j)>>0]=1;j=f[c>>2]|0;_h(t,0);B=(f[l>>2]|0)+-1|0;k=f[m>>2]|0;f[k+(B*52|0)+8>>2]=j+(q*104|0);f[k+(B*52|0)+12>>2]=j+(r*104|0);y=+n[j+(q*104|0)+8>>2]-+n[j+(r*104|0)+8>>2];z=+n[j+(q*104|0)+12>>2]-+n[j+(r*104|0)+12>>2];A=+n[j+(q*104|0)+16>>2]-+n[j+(r*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[k+(B*52|0)+16>>2]=A;b[o>>0]=1}$f(t,p,q,r,0);d=d+3|0}while((d|0)<(g*3|0))}if(h){k=f[t+732>>2]|0;if((k|0)>0){d=t+740|0;a=243703;j=0;do{c=f[d>>2]|0;l=c+(j*52|0)|0;a=(X(a,1664525)|0)+1013904223|0;m=x;o=l;p=m+52|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));m=l;o=c+(((a>>>0)%(k>>>0)|0)*52|0)|0;p=m+52|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));m=c+(((a>>>0)%(k>>>0)|0)*52|0)|0;o=x;p=m+52|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));j=j+1|0}while((j|0)!=(k|0))}else a=243703;c=f[t+752>>2]|0;if((c|0)>0){l=t+760|0;j=0;do{d=f[l>>2]|0;k=d+(j*44|0)|0;a=(X(a,1664525)|0)+1013904223|0;d=d+(((a>>>0)%(c>>>0)|0)*44|0)|0;m=x;o=k;p=m+44|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));m=k;o=d;p=m+44|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));m=d;o=x;p=m+44|0;do{f[m>>2]=f[o>>2];m=m+4|0;o=o+4|0}while((m|0)<(p|0));j=j+1|0}while((j|0)!=(c|0))}}if(!((w|0)==0|(v|0)==0)){f[6473]=(f[6473]|0)+1;Cd(f[v+-4>>2]|0)}if(!i){u=x;return t|0}f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);u=x;return t|0}function Od(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0;if(b[a+165>>0]|0){g=f[a+88>>2]|0;a:do if((g|0)>0&d){e=f[a+96>>2]|0;j=+n[c>>2];k=+n[c+4>>2];l=+n[c+8>>2];m=+n[a+168>>2];d=0;while(1){s=+n[e+(d<<4)>>2]-j;r=+n[e+(d<<4)+4>>2]-k;q=+n[e+(d<<4)+8>>2]-l;if(s*s+r*r+q*q<=m)break;d=d+1|0;if((d|0)>=(g|0))break a}return d|0}while(0);p=(f[a+32>>2]|0)+12|0;f[p>>2]=(f[p>>2]|0)+1;if((g|0)==(f[a+92>>2]|0)?(h=g|0?g<<1:1,(g|0)<(h|0)):0){if(!h)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((h<<4|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}g=f[a+88>>2]|0}if((g|0)>0){e=0;do{p=d+(e<<4)|0;o=(f[a+96>>2]|0)+(e<<4)|0;f[p>>2]=f[o>>2];f[p+4>>2]=f[o+4>>2];f[p+8>>2]=f[o+8>>2];f[p+12>>2]=f[o+12>>2];e=e+1|0}while((e|0)!=(g|0))}e=f[a+96>>2]|0;if(e|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=d;f[a+92>>2]=h;d=f[a+88>>2]|0}else d=g;p=(f[a+96>>2]|0)+(d<<4)|0;f[p>>2]=f[c>>2];f[p+4>>2]=f[c+4>>2];f[p+8>>2]=f[c+8>>2];f[p+12>>2]=f[c+12>>2];c=f[a+88>>2]|0;f[a+88>>2]=c+1;f[(f[a+32>>2]|0)+16>>2]=f[a+96>>2];return c|0}i=f[a+108>>2]|0;b:do if((i|0)>0&d){e=f[a+116>>2]|0;j=+n[c>>2];k=+n[c+4>>2];l=+n[c+8>>2];m=+n[a+168>>2];d=0;while(1){q=+n[e+(d<<2)>>2]-j;r=+n[e+(d+1<<2)>>2]-k;s=+n[e+(d+2<<2)>>2]-l;g=d+3|0;if(q*q+r*r+s*s<=m)break;if((g|0)<(i|0))d=g;else break b}c=(d|0)/3|0;return c|0}while(0);e=f[a+112>>2]|0;if((i|0)==(e|0)){e=i|0?i<<1:1;if((i|0)<(e|0)){if(!e)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((e<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}i=f[a+108>>2]|0}h=f[a+116>>2]|0;if((i|0)<=0)if(!h){h=a+120|0;g=i}else p=34;else{g=0;do{f[d+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(i|0));p=34}if((p|0)==34){if(!(b[a+120>>0]|0))g=i;else{f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);g=f[a+108>>2]|0}f[a+116>>2]=0;h=a+120|0}b[h>>0]=1;f[a+116>>2]=d;f[a+112>>2]=e}else{g=i;e=i}}else g=i;h=f[a+116>>2]|0;f[h+(g<<2)>>2]=f[c>>2];d=g+1|0;f[a+108>>2]=d;if((d|0)==(e|0)){i=e|0?e<<1:1;if((e|0)<(i|0)){if(!i)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((i<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[a+108>>2]|0;h=f[a+116>>2]|0}if((e|0)<=0)if(!h)g=a+120|0;else p=48;else{g=0;do{f[d+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));p=48}if((p|0)==48){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);e=f[a+108>>2]|0}f[a+116>>2]=0;g=a+120|0}b[g>>0]=1;f[a+116>>2]=d;f[a+112>>2]=i;o=d;g=e;e=i}else{o=h;g=e;d=h}}else{o=h;g=d;d=h}f[o+(g<<2)>>2]=f[c+4>>2];g=g+1|0;f[a+108>>2]=g;if((g|0)==(e|0)){i=e|0?e<<1:1;if((e|0)<(i|0)){if(!i){d=0;h=o}else{f[6472]=(f[6472]|0)+1;d=sc((i<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[a+108>>2]|0;h=f[a+116>>2]|0}if((e|0)<=0)if(!h)g=a+120|0;else p=62;else{g=0;do{f[d+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));p=62}if((p|0)==62){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);e=f[a+108>>2]|0}f[a+116>>2]=0;g=a+120|0}b[g>>0]=1;f[a+116>>2]=d;f[a+112>>2]=i;h=d}else h=o}else{h=o;e=g}f[h+(e<<2)>>2]=f[c+8>>2];c=e+1|0;f[a+108>>2]=c;a=f[a+32>>2]|0;f[a+12>>2]=(f[a+12>>2]|0)+1;f[a+16>>2]=d;c=((c|0)/3|0)+-1|0;return c|0}function Pd(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0,g=0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;w=u;u=u+64|0;j=f[a+28>>2]|0;k=f[a+32>>2]|0;d=f[b+8>>2]|0;n[d>>2]=1.0;e=f[b+24>>2]|0;n[d+(e+1<<2)>>2]=1.0;n[d+((e<<1)+2<<2)>>2]=1.0;t=+n[a+48>>2];v=+n[a+52>>2];h=+n[a+56>>2];i=+n[j+4>>2]*t+ +n[j+8>>2]*v+ +n[j+12>>2]*h;c=t*+n[j+20>>2]+v*+n[j+24>>2]+h*+n[j+28>>2];h=t*+n[j+36>>2]+v*+n[j+40>>2]+h*+n[j+44>>2];d=f[b+12>>2]|0;f[d>>2]=0;n[d+4>>2]=h;n[d+8>>2]=-c;n[d+12>>2]=0.0;n[d+(e<<2)>>2]=-h;f[d+(e<<2)+4>>2]=0;n[d+(e<<2)+8>>2]=i;n[d+(e<<2)+12>>2]=0.0;n[d+(e<<1<<2)>>2]=c;n[d+(e<<1<<2)+4>>2]=-i;f[d+(e<<1<<2)+8>>2]=0;n[d+(e<<1<<2)+12>>2]=0.0;d=f[b+16>>2]|0;if(d|0){n[d>>2]=-1.0;n[d+(e+1<<2)>>2]=-1.0;n[d+((e<<1)+2<<2)>>2]=-1.0}q=+n[a+64>>2];v=+n[a+68>>2];t=+n[a+72>>2];r=+n[k+4>>2]*q+ +n[k+8>>2]*v+ +n[k+12>>2]*t;s=q*+n[k+20>>2]+v*+n[k+24>>2]+t*+n[k+28>>2];t=q*+n[k+36>>2]+v*+n[k+40>>2]+t*+n[k+44>>2];g=f[b+20>>2]|0;f[g>>2]=0;n[g+4>>2]=-t;n[g+8>>2]=s;n[g+12>>2]=0.0;n[g+(e<<2)>>2]=t;f[g+(e<<2)+4>>2]=0;n[g+(e<<2)+8>>2]=-r;n[g+(e<<2)+12>>2]=0.0;n[g+(e<<1<<2)>>2]=-s;n[g+(e<<1<<2)+4>>2]=r;f[g+(e<<1<<2)+8>>2]=0;n[g+(e<<1<<2)+12>>2]=0.0;v=+n[b>>2]*+n[b+4>>2];s=v*(s+ +n[k+56>>2]-c-+n[j+56>>2]);t=v*(t+ +n[k+60>>2]-h-+n[j+60>>2]);e=f[b+28>>2]|0;d=f[b+24>>2]|0;n[e>>2]=v*(r+ +n[k+52>>2]-i-+n[j+52>>2]);n[e+(d<<2)>>2]=s;n[e+(d<<1<<2)>>2]=t;e=f[b+12>>2]|0;n[e+(d*3<<2)>>2]=1.0;n[e+((d<<2|1)<<2)>>2]=1.0;n[e+((d*5|0)+2<<2)>>2]=1.0;if(g|0){n[g+(d*3<<2)>>2]=-1.0;n[g+((d<<2|1)<<2)>>2]=-1.0;n[g+((d*5|0)+2<<2)>>2]=-1.0}l=+n[k+24>>2];y=+n[k+44>>2];i=+n[k+28>>2];m=+n[k+40>>2];x=+n[k+36>>2];h=+n[k+20>>2];t=+n[k+4>>2];s=+n[k+8>>2];p=+n[k+12>>2];c=1.0/((l*y-i*m)*t+s*(i*x-y*h)+(m*h-l*x)*p);D=+n[j+4>>2];C=+n[j+8>>2];E=+n[j+12>>2];B=+n[j+20>>2];A=+n[j+24>>2];z=+n[j+28>>2];o=+n[j+36>>2];q=+n[j+40>>2];r=+n[j+44>>2];n[w+16>>2]=E*(m*h-l*x)*c+(D*(l*y-i*m)*c+C*(i*x-y*h)*c);n[w+16+4>>2]=E*(x*s-m*t)*c+(D*(m*p-y*s)*c+C*(y*t-x*p)*c);n[w+16+8>>2]=E*(l*t-h*s)*c+(D*(i*s-l*p)*c+C*(h*p-i*t)*c);n[w+16+12>>2]=0.0;n[w+16+16>>2]=(l*y-i*m)*c*B+(i*x-y*h)*c*A+(m*h-l*x)*c*z;n[w+16+20>>2]=(m*p-y*s)*c*B+(y*t-x*p)*c*A+(x*s-m*t)*c*z;n[w+16+24>>2]=(i*s-l*p)*c*B+(h*p-i*t)*c*A+(l*t-h*s)*c*z;n[w+16+28>>2]=0.0;n[w+16+32>>2]=(l*y-i*m)*c*o+(i*x-y*h)*c*q+(m*h-l*x)*c*r;n[w+16+36>>2]=(m*p-y*s)*c*o+(y*t-x*p)*c*q+(x*s-m*t)*c*r;n[w+16+40>>2]=(i*s-l*p)*c*o+(h*p-i*t)*c*q+(l*t-h*s)*c*r;n[w+16+44>>2]=0.0;mh(w+16|0,w);r=+n[a+80>>2];c=+n[w>>2];s=+n[a+84>>2];h=+n[w+4>>2];t=+n[a+88>>2];l=+n[w+8>>2];q=+n[a+92>>2];i=+n[w+12>>2];if(!((r-c)*(r-c)+(s-h)*(s-h)+(t-l)*(t-l)+(q-i)*(q-i)<(r+c)*(r+c)+(s+h)*(s+h)+(t+l)*(t+l)+(q+i)*(q+i))){c=-c;h=-h;l=-l;i=-i}m=h*-t+(i*-r+c*q)-l*-s;o=l*-r+(i*-s+h*q)-c*-t;p=c*-s+(i*-t+l*q)-h*-r;c=i*q-c*-r-h*-s-l*-t;c=c<-1.0?-1.0:c;c=+Q(+(c>1.0?1.0:c))*2.0;if(m*m+o*o+p*p<1.4210854715202004e-14){C=1.0;D=0.0;B=0.0;E=-c;C=C*E;D=D*E;E=B*E;a=f[b+28>>2]|0;b=f[b+24>>2]|0;C=v*C;k=b*3|0;k=a+(k<<2)|0;n[k>>2]=C;D=v*D;k=b<<2;k=a+(k<<2)|0;n[k>>2]=D;E=v*E;b=b*5|0;b=a+(b<<2)|0;n[b>>2]=E;u=w;return}B=1.0/+L(+(m*m+o*o+p*p));C=m*B;D=B*o;B=B*p;E=-c;C=C*E;D=D*E;E=B*E;a=f[b+28>>2]|0;b=f[b+24>>2]|0;C=v*C;k=b*3|0;k=a+(k<<2)|0;n[k>>2]=C;D=v*D;k=b<<2;k=a+(k<<2)|0;n[k>>2]=D;E=v*E;b=b*5|0;b=a+(b<<2)|0;n[b>>2]=E;u=w;return}function Qd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0,h=0,i=0,j=0,k=0,l=0,m=0.0,o=0,p=0,q=0,r=0;o=u;u=u+128|0;f[a+68>>2]=(f[a+68>>2]|0)+1;f[o>>2]=f[c>>2];f[o+4>>2]=f[c+4>>2];f[o+8>>2]=f[c+8>>2];f[o+12>>2]=f[c+12>>2];f[o+16>>2]=f[c+16>>2];f[o+16+4>>2]=f[c+16+4>>2];f[o+16+8>>2]=f[c+16+8>>2];f[o+16+12>>2]=f[c+16+12>>2];f[o+32>>2]=f[c+32>>2];f[o+32+4>>2]=f[c+32+4>>2];f[o+32+8>>2]=f[c+32+8>>2];f[o+32+12>>2]=f[c+32+12>>2];f[o+48>>2]=f[c+48>>2];f[o+48+4>>2]=f[c+48+4>>2];f[o+48+8>>2]=f[c+48+8>>2];f[o+48+12>>2]=f[c+48+12>>2];l=f[d+4>>2]|0;m=+rb[f[(f[d>>2]|0)+48>>2]&15](d);Yb[f[(f[d>>2]|0)+8>>2]&127](d,c,o+112|0,o+96|0);e=+n[o+112>>2];if(+n[a+32>>2]>e)n[a+32>>2]=e;e=+n[o+96>>2];if(+n[a+48>>2]<e)n[a+48>>2]=e;e=+n[o+112+4>>2];if(+n[a+36>>2]>e)n[a+36>>2]=e;e=+n[o+96+4>>2];if(+n[a+52>>2]<e)n[a+52>>2]=e;e=+n[o+112+8>>2];if(+n[a+40>>2]>e)n[a+40>>2]=e;e=+n[o+96+8>>2];if(+n[a+56>>2]<e)n[a+56>>2]=e;j=f[a+64>>2]|0;if(!j){j=a+16|0;i=0}else{f[o+64>>2]=f[o+112>>2];f[o+64+4>>2]=f[o+112+4>>2];f[o+64+8>>2]=f[o+112+8>>2];f[o+64+12>>2]=f[o+112+12>>2];f[o+64+16>>2]=f[o+96>>2];f[o+64+16+4>>2]=f[o+96+4>>2];f[o+64+16+8>>2]=f[o+96+8>>2];f[o+64+16+12>>2]=f[o+96+12>>2];i=f[a+16>>2]|0;c=f[j+4>>2]|0;if(!c){f[6472]=(f[6472]|0)+1;c=sc(63)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}g=c;h=g+44|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(h|0))}else f[j+4>>2]=0;f[c+32>>2]=0;f[c+36>>2]=i;f[c+40>>2]=0;f[c>>2]=f[o+64>>2];f[c+4>>2]=f[o+64+4>>2];f[c+8>>2]=f[o+64+8>>2];f[c+12>>2]=f[o+64+12>>2];f[c+16>>2]=f[o+64+16>>2];f[c+20>>2]=f[o+64+20>>2];f[c+24>>2]=f[o+64+24>>2];f[c+28>>2]=f[o+64+28>>2];ff(j,f[j>>2]|0,c);f[j+12>>2]=(f[j+12>>2]|0)+1;j=a+16|0;i=c}c=f[j>>2]|0;if((c|0)==(f[a+20>>2]|0)?(k=c|0?c<<1:1,(c|0)<(k|0)):0){if(!k)h=0;else{f[6472]=(f[6472]|0)+1;c=sc((k*80|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=c;c=f[j>>2]|0}if((c|0)>0){g=0;do{p=h+(g*80|0)|0;q=f[a+24>>2]|0;r=q+(g*80|0)|0;f[p>>2]=f[r>>2];f[p+4>>2]=f[r+4>>2];f[p+8>>2]=f[r+8>>2];f[p+12>>2]=f[r+12>>2];p=q+(g*80|0)+16|0;r=h+(g*80|0)+16|0;f[r>>2]=f[p>>2];f[r+4>>2]=f[p+4>>2];f[r+8>>2]=f[p+8>>2];f[r+12>>2]=f[p+12>>2];r=q+(g*80|0)+32|0;p=h+(g*80|0)+32|0;f[p>>2]=f[r>>2];f[p+4>>2]=f[r+4>>2];f[p+8>>2]=f[r+8>>2];f[p+12>>2]=f[r+12>>2];p=h+(g*80|0)+48|0;r=q+(g*80|0)+48|0;f[p>>2]=f[r>>2];f[p+4>>2]=f[r+4>>2];f[p+8>>2]=f[r+8>>2];f[p+12>>2]=f[r+12>>2];p=h+(g*80|0)+64|0;q=q+(g*80|0)+64|0;f[p>>2]=f[q>>2];f[p+4>>2]=f[q+4>>2];f[p+8>>2]=f[q+8>>2];f[p+12>>2]=f[q+12>>2];g=g+1|0}while((g|0)!=(c|0))}c=f[a+24>>2]|0;if(c|0){if(b[a+28>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+24>>2]=0}b[a+28>>0]=1;f[a+24>>2]=h;f[a+20>>2]=k;c=f[j>>2]|0}r=f[a+24>>2]|0;q=r+(c*80|0)|0;f[q>>2]=f[o>>2];f[q+4>>2]=f[o+4>>2];f[q+8>>2]=f[o+8>>2];f[q+12>>2]=f[o+12>>2];q=r+(c*80|0)+16|0;f[q>>2]=f[o+16>>2];f[q+4>>2]=f[o+16+4>>2];f[q+8>>2]=f[o+16+8>>2];f[q+12>>2]=f[o+16+12>>2];q=r+(c*80|0)+32|0;f[q>>2]=f[o+32>>2];f[q+4>>2]=f[o+32+4>>2];f[q+8>>2]=f[o+32+8>>2];f[q+12>>2]=f[o+32+12>>2];q=r+(c*80|0)+48|0;f[q>>2]=f[o+48>>2];f[q+4>>2]=f[o+48+4>>2];f[q+8>>2]=f[o+48+8>>2];f[q+12>>2]=f[o+48+12>>2];r=r+(c*80|0)+64|0;f[r>>2]=d;f[r+4>>2]=l;n[r+8>>2]=m;f[r+12>>2]=i;f[j>>2]=(f[j>>2]|0)+1;u=o;return}function Rd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0;k=u;u=u+384|0;e=f[c+36>>2]|0;c=f[d+36>>2]|0;d=f[a+24>>2]|0;if(((d|0)==(f[a+28>>2]|0)?f[d+1132>>2]|0:0)?(i=(X(f[c+380>>2]|0,f[d+1112>>2]|0)|0)+(f[e+380>>2]|0)|0,b[(f[d+1140>>2]|0)+i>>0]|0):0){f[5839]=(f[5839]|0)+1;u=k;return}f[k+328+4>>2]=35;f[k+328+8>>2]=0;f[k+328+12>>2]=1065353216;f[k+328+16>>2]=1065353216;f[k+328+20>>2]=1065353216;n[k+328+24>>2]=0.0;f[k+328>>2]=3580;f[k+328+52>>2]=e;n[k+328+44>>2]=0.0;f[k+272+4>>2]=35;f[k+272+8>>2]=0;f[k+272+12>>2]=1065353216;f[k+272+16>>2]=1065353216;f[k+272+20>>2]=1065353216;n[k+272+24>>2]=0.0;f[k+272>>2]=3580;f[k+272+52>>2]=c;n[k+272+44>>2]=0.0;if((b[22664]|0)==0?fz(22664)|0:0){if((b[22672]|0)==0?fz(22672)|0:0){f[5768]=1065353216;f[5769]=0;f[5770]=0;f[5771]=0;f[5772]=0;f[5773]=1065353216;f[5774]=0;f[5775]=0;f[5776]=0;f[5777]=0;f[5778]=1065353216;n[5779]=0.0}f[5752]=f[5768];f[5753]=f[5769];f[5754]=f[5770];f[5755]=f[5771];f[5756]=f[5772];f[5757]=f[5773];f[5758]=f[5774];f[5759]=f[5775];f[5760]=f[5776];f[5761]=f[5777];f[5762]=f[5778];f[5763]=f[5779];f[5764]=0;f[5765]=0;f[5766]=0;f[5767]=0}if((b[22664]|0)==0?fz(22664)|0:0){if((b[22672]|0)==0?fz(22672)|0:0){f[5768]=1065353216;f[5769]=0;f[5770]=0;f[5771]=0;f[5772]=0;f[5773]=1065353216;f[5774]=0;f[5775]=0;f[5776]=0;f[5777]=0;f[5778]=1065353216;n[5779]=0.0}f[5752]=f[5768];f[5753]=f[5769];f[5754]=f[5770];f[5755]=f[5771];f[5756]=f[5772];f[5757]=f[5773];f[5758]=f[5774];f[5759]=f[5775];f[5760]=f[5776];f[5761]=f[5777];f[5762]=f[5778];f[5763]=f[5779];f[5764]=0;f[5765]=0;f[5766]=0;f[5767]=0}m=+n[e+232>>2]-+n[c+232>>2];l=+n[e+236>>2]-+n[c+236>>2];n[k>>2]=+n[e+228>>2]-+n[c+228>>2];n[k+4>>2]=m;n[k+8>>2]=l;n[k+12>>2]=0.0;if(!(!(Ne(k+328|0,23008,k+272|0,23008,k,k+216|0)|0)?!(Pc(k+328|0,23008,k+272|0,23008,k,k+216|0,0)|0):0))g=19;if((g|0)==19?(f[k+4>>2]=0,f[k+4+4>>2]=0,f[k+4+8>>2]=0,f[k+4+12>>2]=0,f[k+4+16>>2]=0,f[k+4+20>>2]=0,b[k+152>>0]=0,f[k>>2]=3400,fd(a,k+216|0,e,0,0,c,0,0,k)|0):0){f[6472]=(f[6472]|0)+1;c=sc(235)|0;if(!c)i=0;else{f[(c+4+15&-16)+-4>>2]=c;i=c+4+15&-16}d=i+4|0;c=i+152|0;bl(d|0,0,212)|0;f[i>>2]=3400;e=k+4|0;g=d+100|0;do{f[d>>2]=f[e>>2];d=d+4|0;e=e+4|0}while((d|0)<(g|0));d=i+104|0;f[d>>2]=f[k+104>>2];f[d+4>>2]=f[k+104+4>>2];f[d+8>>2]=f[k+104+8>>2];f[d+12>>2]=f[k+104+12>>2];d=i+120|0;f[d>>2]=f[k+120>>2];f[d+4>>2]=f[k+120+4>>2];f[d+8>>2]=f[k+120+8>>2];f[d+12>>2]=f[k+120+12>>2];d=i+136|0;f[d>>2]=f[k+136>>2];f[d+4>>2]=f[k+136+4>>2];f[d+8>>2]=f[k+136+8>>2];f[d+12>>2]=f[k+136+12>>2];b[c>>0]=b[k+152>>0]|0;d=i+156|0;e=k+156|0;g=d+60|0;do{f[d>>2]=f[e>>2];d=d+4|0;e=e+4|0}while((d|0)<(g|0));g=f[a+24>>2]|0;h=i;c=f[g+852>>2]|0;if((c|0)==(f[g+856>>2]|0)?(j=c|0?c<<1:1,(c|0)<(j|0)):0){if(!j)e=0;else{f[6472]=(f[6472]|0)+1;c=sc((j<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=c;c=f[g+852>>2]|0}if((c|0)>0){d=0;do{f[e+(d<<2)>>2]=f[(f[g+860>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(c|0))}d=f[g+860>>2]|0;if(d){if(b[g+864>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[g+852>>2]|0}f[g+860>>2]=0}b[g+864>>0]=1;f[g+860>>2]=e;f[g+856>>2]=j}f[(f[g+860>>2]|0)+(c<<2)>>2]=h;f[g+852>>2]=c+1;h=f[a+24>>2]|0;j=f[a+28>>2]|0;l=+n[h+348>>2];m=+n[j+348>>2];a=i+64|0;n[a>>2]=+n[a>>2]*(l>m?l:m);a=i+68|0;n[a>>2]=+n[a>>2]*(+n[h+360>>2]+ +n[j+360>>2])*.5}u=k;return}function Sd(a){a=a|0;var c=0,d=0.0,e=0.0,g=0.0,h=0,i=0.0,j=0,k=0;j=u;u=u+16|0;if(!(b[a+1308>>0]|0)){u=j;return}n[a+928>>2]=0.0;n[a+992>>2]=0.0;n[a+1056>>2]=0.0;f[a+712>>2]=0;f[a+712+4>>2]=0;f[a+712+8>>2]=0;f[a+712+12>>2]=0;od(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);Lb[f[(f[a>>2]|0)+44>>2]&511](a);d=+n[a+1284>>2];e=+n[a+1288>>2];g=+n[a+1292>>2];if(+n[a+696>>2]>=+n[a+680>>2]){k=(b[a+1300>>0]|0)==0?a+1128|0:a+1064|0;c=f[k+16>>2]|0;h=f[k+32>>2]|0;f[j>>2]=f[k>>2];f[j+4>>2]=c;f[j+8>>2]=h;n[j+12>>2]=0.0;Eh(f[a+28>>2]|0,f[a+32>>2]|0,a+176|0,j,d,e,g,d,e,g)}if(+n[a+700>>2]>=+n[a+684>>2]){c=(b[a+1300>>0]|0)==0?a+1128|0:a+1064|0;h=f[c+20>>2]|0;k=f[c+36>>2]|0;f[j>>2]=f[c+4>>2];f[j+4>>2]=h;f[j+8>>2]=k;n[j+12>>2]=0.0;Eh(f[a+28>>2]|0,f[a+32>>2]|0,a+260|0,j,d,e,g,d,e,g)}if(+n[a+704>>2]>=+n[a+688>>2]){c=(b[a+1300>>0]|0)==0?a+1128|0:a+1064|0;h=f[c+24>>2]|0;k=f[c+40>>2]|0;f[j>>2]=f[c+8>>2];f[j+4>>2]=h;f[j+8>>2]=k;n[j+12>>2]=0.0;Eh(f[a+28>>2]|0,f[a+32>>2]|0,a+344|0,j,d,e,g,d,e,g)}e=+n[a+868>>2];g=+n[a+872>>2];i=+ak(+n[a+1192>>2],e,g);n[a+920>>2]=i;do if(!(e>g)){if(e>i){f[a+924>>2]=1;n[a+916>>2]=i-e;if(!(i-e>3.1415927410125732))if(i-e<-3.1415927410125732)d=6.2831854820251465;else{h=15;break}else d=-6.2831854820251465;n[a+916>>2]=i-e+d;h=15;break}if(g<i){f[a+924>>2]=2;n[a+916>>2]=i-g;if(!(i-g>3.1415927410125732))if(i-g<-3.1415927410125732)d=6.2831854820251465;else{h=15;break}else d=-6.2831854820251465;n[a+916>>2]=i-g+d;h=15}else{c=a+924|0;h=14}}else{c=a+924|0;h=14}while(0);if((h|0)==14?(f[c>>2]=0,b[a+912>>0]|0):0)h=15;if((h|0)==15){f[j>>2]=f[a+1208>>2];f[j+4>>2]=f[a+1208+4>>2];f[j+8>>2]=f[a+1208+8>>2];f[j+12>>2]=f[a+1208+12>>2];Og(f[a+28>>2]|0,f[a+32>>2]|0,a+428|0,j)}e=+n[a+932>>2];g=+n[a+936>>2];i=+ak(+n[a+1196>>2],e,g);n[a+984>>2]=i;do if(!(e>g)){if(e>i){f[a+988>>2]=1;n[a+980>>2]=i-e;if(!(i-e>3.1415927410125732))if(i-e<-3.1415927410125732)d=6.2831854820251465;else{h=28;break}else d=-6.2831854820251465;n[a+980>>2]=i-e+d;h=28;break}if(g<i){f[a+988>>2]=2;n[a+980>>2]=i-g;if(!(i-g>3.1415927410125732))if(i-g<-3.1415927410125732)d=6.2831854820251465;else{h=28;break}else d=-6.2831854820251465;n[a+980>>2]=i-g+d;h=28}else{c=a+988|0;h=27}}else{c=a+988|0;h=27}while(0);if((h|0)==27?(f[c>>2]=0,b[a+976>>0]|0):0)h=28;if((h|0)==28){f[j>>2]=f[a+1224>>2];f[j+4>>2]=f[a+1224+4>>2];f[j+8>>2]=f[a+1224+8>>2];f[j+12>>2]=f[a+1224+12>>2];Og(f[a+28>>2]|0,f[a+32>>2]|0,a+512|0,j)}e=+n[a+996>>2];g=+n[a+1e3>>2];i=+ak(+n[a+1200>>2],e,g);n[a+1048>>2]=i;do if(!(e>g)){if(e>i){f[a+1052>>2]=1;n[a+1044>>2]=i-e;if(!(i-e>3.1415927410125732))if(i-e<-3.1415927410125732)d=6.2831854820251465;else{h=40;break}else d=-6.2831854820251465;n[a+1044>>2]=i-e+d;h=40;break}if(g<i){f[a+1052>>2]=2;n[a+1044>>2]=i-g;if(!(i-g>3.1415927410125732))if(i-g<-3.1415927410125732)d=6.2831854820251465;else{h=40;break}else d=-6.2831854820251465;n[a+1044>>2]=i-g+d;h=40}else{c=a+1052|0;h=39}}else{c=a+1052|0;h=39}while(0);if((h|0)==39?(f[c>>2]=0,b[a+1040>>0]|0):0)h=40;if((h|0)==40){f[j>>2]=f[a+1240>>2];f[j+4>>2]=f[a+1240+4>>2];f[j+8>>2]=f[a+1240+8>>2];f[j+12>>2]=f[a+1240+12>>2];Og(f[a+28>>2]|0,f[a+32>>2]|0,a+596|0,j)}u=j;return}function Td(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0,g=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;G=u;u=u+16|0;uj(11238);F=f[a+712>>2]|0;if((F|0)>0){f[6472]=(f[6472]|0)+1;c=sc((F<<4|3)+16|0)|0;if(!c)g=0;else{f[(c+4+15&-16)+-4>>2]=c;g=c+4+15&-16}bl(g|0,0,F<<4|0)|0;e=f[a+712>>2]|0;if((e|0)>0){f[6472]=(f[6472]|0)+1;c=sc((e<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}bl(c|0,0,e<<2|0)|0;D=c;E=g;B=c;A=g}else{D=0;E=g;B=0;A=g}}else{D=0;E=0;B=0;A=0}z=f[a+1112>>2]|0;if(b){if((z|0)>0){h=f[a+1120>>2]|0;c=0;do{e=f[h+(c<<2)>>2]|0;g=f[e+312>>2]|0;if(g|0){n[e+276>>2]=1.0/+(g|0)*+n[e+276>>2];n[e+280>>2]=1.0/+(g|0)*+n[e+280>>2];n[e+284>>2]=1.0/+(g|0)*+n[e+284>>2];n[e+292>>2]=+n[e+292>>2]*(1.0/+(g|0));n[e+296>>2]=1.0/+(g|0)*+n[e+296>>2];n[e+300>>2]=1.0/+(g|0)*+n[e+300>>2]}c=c+1|0}while((c|0)!=(z|0));C=11}}else C=11;if((C|0)==11?(z|0)>0:0){j=f[a+1120>>2]|0;if(b){e=0;do{g=f[j+(e<<2)>>2]|0;if((f[g+312>>2]|0)>0?(x=+n[a+452>>2],r=+n[g+276>>2]*x,s=x*+n[g+280>>2],t=x*+n[g+284>>2],v=x*+n[g+292>>2],w=x*+n[g+296>>2],x=x*+n[g+300>>2],y=f[g+24>>2]|0,(y|0)>0):0){h=f[g+32>>2]|0;b=f[a+720>>2]|0;i=f[g+12>>2]|0;c=0;do{q=f[h+(c<<2)>>2]|0;p=+n[i+(c<<2)>>2];o=+n[q+8>>2]-+n[g+228>>2];m=+n[q+12>>2]-+n[g+232>>2];l=+n[q+16>>2]-+n[g+236>>2];H=E+(((q-b|0)/104|0)<<4)|0;n[H>>2]=+n[H>>2]+p*(r+(w*l-x*m));H=E+(((q-b|0)/104|0)<<4)+4|0;n[H>>2]=+n[H>>2]+p*(s+(x*o-v*l));H=E+(((q-b|0)/104|0)<<4)+8|0;n[H>>2]=p*(t+(v*m-w*o))+ +n[H>>2];q=D+(((q-b|0)/104|0)<<2)|0;n[q>>2]=p+ +n[q>>2];c=c+1|0}while((c|0)!=(y|0))}e=e+1|0}while((e|0)!=(z|0))}else{e=0;do{g=f[j+(e<<2)>>2]|0;if((f[g+308>>2]|0)>0?(p=+n[a+452>>2],d=+n[g+244>>2]*p,k=p*+n[g+248>>2],l=p*+n[g+252>>2],m=p*+n[g+260>>2],o=p*+n[g+264>>2],p=p*+n[g+268>>2],q=f[g+24>>2]|0,(q|0)>0):0){h=f[g+32>>2]|0;b=f[a+720>>2]|0;i=f[g+12>>2]|0;c=0;do{H=f[h+(c<<2)>>2]|0;x=+n[i+(c<<2)>>2];w=+n[H+8>>2]-+n[g+228>>2];v=+n[H+12>>2]-+n[g+232>>2];t=+n[H+16>>2]-+n[g+236>>2];y=E+(((H-b|0)/104|0)<<4)|0;n[y>>2]=+n[y>>2]+x*(d+(o*t-p*v));y=E+(((H-b|0)/104|0)<<4)+4|0;n[y>>2]=+n[y>>2]+x*(k+(p*w-m*t));y=E+(((H-b|0)/104|0)<<4)+8|0;n[y>>2]=x*(l+(m*v-o*w))+ +n[y>>2];H=D+(((H-b|0)/104|0)<<2)|0;n[H>>2]=x+ +n[H>>2];c=c+1|0}while((c|0)!=(q|0))}e=e+1|0}while((e|0)!=(z|0))}}if((F|0)>0){c=0;do{d=+n[D+(c<<2)>>2];if(d>0.0){w=1.0/d*+n[E+(c<<4)+4>>2];x=1.0/d*+n[E+(c<<4)+8>>2];H=f[a+720>>2]|0;z=H+(c*104|0)+8|0;n[z>>2]=1.0/d*+n[E+(c<<4)>>2]+ +n[z>>2];z=H+(c*104|0)+12|0;n[z>>2]=w+ +n[z>>2];H=H+(c*104|0)+16|0;n[H>>2]=x+ +n[H>>2]}c=c+1|0}while((c|0)!=(F|0));if(B|0)C=33}else if(!((D|0)==0|(B|0)==0))C=33;if((C|0)==33){f[6473]=(f[6473]|0)+1;Cd(f[B+-4>>2]|0)}if(!((E|0)==0|(A|0)==0)){f[6473]=(f[6473]|0)+1;Cd(f[A+-4>>2]|0)}c=f[2405]|0;H=(f[c+16>>2]|0)+-1|0;f[c+16>>2]=H;if(H|0){u=G;return}do if(f[c+4>>2]|0){gb(G|0,0)|0;H=f[6471]|0;n[c+8>>2]=+n[c+8>>2]+ +(((f[G+4>>2]|0)-(f[H+4>>2]|0)+(((f[G>>2]|0)-(f[H>>2]|0)|0)*1e6|0)-(f[c+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[c+16>>2]|0)){c=f[2405]|0;break}else{u=G;return}}while(0);f[2405]=f[c+20>>2];u=G;return}function Ud(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0.0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0;C=u;u=u+272|0;z=+n[d+48>>2]-+n[c+48>>2];A=+n[d+52>>2]-+n[c+52>>2];B=+n[d+56>>2]-+n[c+56>>2];Ef(c,d,C+256|0,C+208|0);v=+n[C+208>>2];r=+n[C+256>>2]*v;t=v*+n[C+256+4>>2];v=v*+n[C+256+8>>2];n[C+192>>2]=r;n[C+192+4>>2]=t;n[C+192+8>>2]=v;n[C+192+12>>2]=0.0;w=+n[g+48>>2]-+n[e+48>>2];x=+n[g+52>>2]-+n[e+52>>2];y=+n[g+56>>2]-+n[e+56>>2];Ef(e,g,C+256|0,C+208|0);p=+n[C+208>>2];m=+n[C+256>>2]*p;o=p*+n[C+256+4>>2];p=p*+n[C+256+8>>2];n[C+176>>2]=m;n[C+176+4>>2]=o;n[C+176+8>>2]=p;n[C+176+12>>2]=0.0;d=f[a+12>>2]|0;q=+rb[f[(f[d>>2]|0)+16>>2]&15](d);d=f[a+16>>2]|0;if(!d)j=0.0;else j=+rb[f[(f[d>>2]|0)+16>>2]&15](d);q=q*+L(+(r*r+t*t+v*v))+j*+L(+(m*m+o*o+p*p));if(q+ +L(+((w-z)*(w-z)+(x-A)*(x-A)+(y-B)*(y-B)))==0.0){h=0;u=C;return h|0}f[C+208>>2]=9352;n[C+208+36>>2]=999999984306749440.0;b[C+208+40>>0]=0;Kd(a,c,e,C+208|0);g=(b[C+208+40>>0]|0)==0;f[C+256>>2]=f[C+208+20>>2];f[C+256+4>>2]=f[C+208+20+4>>2];f[C+256+8>>2]=f[C+208+20+8>>2];f[C+256+12>>2]=f[C+208+20+12>>2];a:do if(!g?(l=f[C+208+4>>2]|0,i=f[C+208+8>>2]|0,k=f[C+208+12>>2]|0,v=(w-z)*(f[s>>2]=l,+n[s>>2]),v=v+(x-A)*(f[s>>2]=i,+n[s>>2]),!(q+(v+(y-B)*(f[s>>2]=k,+n[s>>2]))<=1.1920928955078125e-07)):0){j=+n[C+208+16>>2];m=+n[C+208+36>>2]+ +n[h+172>>2];b:do if(m>1.0000000474974513e-03){g=0;o=0.0;p=m;while(1){d=f[h+168>>2]|0;if(d|0){D=f[(f[d>>2]|0)+20>>2]|0;f[C+112>>2]=1065353216;f[C+112+4>>2]=1065353216;f[C+112+8>>2]=1065353216;n[C+112+12>>2]=0.0;Tb[D&7](d,C+256|0,.20000000298023224,C+112|0)}j=(w-z)*(f[s>>2]=l,+n[s>>2]);j=j+(x-A)*(f[s>>2]=i,+n[s>>2]);j=q+(j+(y-B)*(f[s>>2]=k,+n[s>>2]));if(j<=1.1920928955078125e-07){i=0;break a}m=o+p/j;if(!(!(m<=o)&(!(m<0.0)&!(m>1.0)))){i=0;break a}Yg(c,z,A,B,C+192|0,m,C+112|0);Yg(e,w,x,y,C+176|0,m,C+48|0);i=f[h+168>>2]|0;if(i|0){D=f[(f[i>>2]|0)+20>>2]|0;f[C>>2]=1065353216;f[C+4>>2]=0;f[C+8>>2]=0;n[C+12>>2]=0.0;Tb[D&7](i,C+112+48|0,.20000000298023224,C)}Mb[f[f[h>>2]>>2]&31](h,m);f[C>>2]=9352;n[C+36>>2]=999999984306749440.0;b[C+40>>0]=0;Kd(a,C+112|0,C+48|0,C);if(!(b[C+40>>0]|0)){i=15;break}j=+n[C+36>>2];o=+n[h+172>>2];f[C+256>>2]=f[C+20>>2];f[C+256+4>>2]=f[C+20+4>>2];f[C+256+8>>2]=f[C+20+8>>2];f[C+256+12>>2]=f[C+20+12>>2];d=g+1|0;if((g|0)>63){i=16;break}k=f[C+12>>2]|0;i=f[C+8>>2]|0;l=f[C+4>>2]|0;p=j+o;if(!(p>1.0000000474974513e-03)){j=+n[C+16>>2];break b}else{g=d;o=m}}if((i|0)==15)Vb[f[(f[h>>2]|0)+8>>2]&127](h,-1,g);else if((i|0)==16)Vb[f[(f[h>>2]|0)+8>>2]&127](h,-2,d);i=0;break a}else m=0.0;while(0);n[h+164>>2]=m;f[h+132>>2]=l;f[h+136>>2]=i;f[h+140>>2]=k;n[h+144>>2]=j;f[h+148>>2]=f[C+256>>2];f[h+148+4>>2]=f[C+256+4>>2];f[h+148+8>>2]=f[C+256+8>>2];f[h+148+12>>2]=f[C+256+12>>2];i=1}else i=0;while(0);D=i;u=C;return D|0}function Vd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;E=u;u=u+32|0;A=+n[b+48>>2]-+n[b+112>>2];g=+n[b+52>>2]-+n[b+116>>2];D=+n[b+56>>2]-+n[b+120>>2];B=A*+n[b+64>>2]+g*+n[b+80>>2]+D*+n[b+96>>2];C=A*+n[b+68>>2]+g*+n[b+84>>2]+D*+n[b+100>>2];D=A*+n[b+72>>2]+g*+n[b+88>>2]+D*+n[b+104>>2];d=f[a+8>>2]|0;z=f[a+4>>2]|0;g=+n[z+28>>2]*+n[z+12>>2];A=g+ +n[a+12>>2];o=+n[d+72>>2];p=+n[d+56>>2];q=+n[d+76>>2];r=+n[d+60>>2];s=+n[d+80>>2];t=+n[d+64>>2];v=+n[d+88>>2];w=+n[d+92>>2];x=+n[d+96>>2];i=(q-r)*(x-t)-(s-t)*(w-r);k=(s-t)*(v-p)-(o-p)*(x-t);m=(o-p)*(w-r)-(q-r)*(v-p);l=1.0/+L(+(m*m+(i*i+k*k)));h=(B-p)*l*i+(C-r)*l*k+l*m*(D-t);if(h<0.0){y=-h;j=-(l*i);h=-(l*k);i=-(l*m)}else{y=h;j=l*i;h=l*k;i=l*m}if(!(y<A)){u=E;return}m=(D-t)*(h*(o-p)-j*(q-r))+((B-p)*(i*(q-r)-h*(s-t))+(C-r)*(j*(s-t)-i*(o-p)));s=(D-s)*(h*(v-o)-j*(w-q))+((B-o)*(i*(w-q)-h*(x-s))+(C-q)*(j*(x-s)-i*(v-o)));x=(D-x)*(h*(p-v)-j*(r-w))+((B-v)*(i*(r-w)-h*(t-x))+(C-w)*(j*(t-x)-i*(p-v)));if(!(x>0.0&(m>0.0&s>0.0)|x<=0.0&(m<=0.0&s<=0.0))){if((Bb[f[(f[d>>2]|0)+100>>2]&127](d)|0)<=0){u=E;return}d=0;z=0;r=0.0;q=0.0;p=0.0;do{F=f[a+8>>2]|0;Yb[f[(f[F>>2]|0)+104>>2]&127](F,z,E+16|0,E);o=+n[E+16>>2];x=+n[E+16+4>>2];t=+n[E+16+8>>2];s=+n[E>>2]-o;y=+n[E+4>>2]-x;v=+n[E+8>>2]-t;do if((B-o)*s+(C-x)*y+(D-t)*v>0.0)if((B-o)*s+(C-x)*y+(D-t)*v<s*s+y*y+v*v){m=((B-o)*s+(C-x)*y+(D-t)*v)/(s*s+y*y+v*v);w=m;k=B-o-s*m;l=C-x-y*m;m=D-t-v*m;break}else{w=1.0;k=B-o-s;l=C-x-y;m=D-t-v;break}else{w=0.0;k=B-o;l=C-x;m=D-t}while(0);if(k*k+l*l+m*m<A*A){d=1;r=o+s*w;q=t+v*w;p=x+y*w}z=z+1|0;F=f[a+8>>2]|0}while((z|0)<(Bb[f[(f[F>>2]|0)+100>>2]&127](F)|0));if(!(d&1)){u=E;return}else o=A*A}else{o=A*A;r=B-y*j;q=D-y*i;p=C-y*h}l=B-r;m=C-p;k=D-q;if(!(l*l+m*m+k*k<o)){u=E;return}if(l*l+m*m+k*k>1.1920928955078125e-07){h=+L(+(l*l+m*m+k*k));g=g-h;j=l*(1.0/h);i=k*(1.0/h);h=m*(1.0/h)}g=-g;if(e){x=+n[b+64>>2];y=+n[b+68>>2];A=+n[b+72>>2];B=x*j+y*h+A*i;m=+n[b+80>>2];o=+n[b+84>>2];s=+n[b+88>>2];C=j*m+h*o+i*s;t=+n[b+96>>2];v=+n[b+100>>2];w=+n[b+104>>2];D=j*t+h*v+i*w;n[E+16>>2]=-B;n[E+16+4>>2]=-C;n[E+16+8>>2]=-D;n[E+16+12>>2]=0.0;C=r*m+p*o+q*s+ +n[b+116>>2]+C*g;D=r*t+p*v+q*w+ +n[b+120>>2]+D*g;n[E>>2]=r*x+p*y+q*A+ +n[b+112>>2]+B*g;n[E+4>>2]=C;n[E+8>>2]=D;n[E+12>>2]=0.0;Wb[f[(f[c>>2]|0)+16>>2]&15](c,E+16|0,E,g);u=E;return}else{F=f[(f[c>>2]|0)+16>>2]|0;y=+n[b+64>>2];A=+n[b+68>>2];B=+n[b+72>>2];t=+n[b+80>>2];v=+n[b+84>>2];C=+n[b+88>>2];w=+n[b+96>>2];x=+n[b+100>>2];D=+n[b+104>>2];n[E+16>>2]=y*j+A*h+B*i;n[E+16+4>>2]=j*t+h*v+i*C;n[E+16+8>>2]=j*w+h*x+i*D;n[E+16+12>>2]=0.0;C=r*t+p*v+q*C+ +n[b+116>>2];D=r*w+p*x+q*D+ +n[b+120>>2];n[E>>2]=r*y+p*A+q*B+ +n[b+112>>2];n[E+4>>2]=C;n[E+8>>2]=D;n[E+12>>2]=0.0;Wb[F&15](c,E+16|0,E,g);u=E;return}}function Wd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;f[a>>2]=5416;f[6472]=(f[6472]|0)+1;d=sc(379)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}n[d+308>>2]=9.999999747378752e-05;k=d+332|0;b[k>>0]=b[k>>0]&-16;f[a+24>>2]=d;k=(f[c+20>>2]|0)==0?9264:9312;f[6472]=(f[6472]|0)+1;d=sc(23)|0;f[(d+4+15&-16)+-4>>2]=d;f[(d+4+15&-16)>>2]=k;f[a+28>>2]=d+4+15&-16;f[6472]=(f[6472]|0)+1;d=sc(43)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=f[a+24>>2]|0;k=f[a+28>>2]|0;b[d+4>>0]=0;f[d>>2]=6224;f[d+16>>2]=0;f[d+20>>2]=3;f[d+12>>2]=j;f[d+8>>2]=k;f[a+32>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5448;f[a+36>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5468;f[a+40>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5488;f[a+44>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5508;f[a+48>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5528;f[a+52>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5548;f[a+56>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5568;f[a+60>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5588;f[a+76>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=5588;f[a+80>>2]=d;b[d+4>>0]=1;f[6472]=(f[6472]|0)+1;d=sc(27)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5608;f[a+72>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(35)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}b[d+4>>0]=0;f[d>>2]=5628;f[d+8>>2]=1;f[d+12>>2]=0;f[a+88>>2]=d;f[6472]=(f[6472]|0)+1;d=sc(35)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=5628;f[d+8>>2]=1;f[d+12>>2]=0;f[a+84>>2]=d;b[d+4>>0]=1;k=f[c+16>>2]|0;k=(k|0)>80?k:80;d=f[c>>2]|0;if(!d){b[a+12>>0]=1;f[6472]=(f[6472]|0)+1;d=sc(39)|0;if(!d)j=0;else{f[(d+4+15&-16)+-4>>2]=d;j=d+4+15&-16}d=f[c+8>>2]|0;f[j>>2]=772;e=j+4|0;f[e>>2]=d;f[6472]=(f[6472]|0)+1;d=sc((d*772|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[j+16>>2]=d;f[j+12>>2]=d;g=f[e>>2]|0;f[j+8>>2]=g;if(g+-1|0){h=f[j>>2]|0;e=d;i=g+-1|0;do{l=e;e=e+h|0;f[l>>2]=e;i=i+-1|0}while((i|0)!=0);d=d+(X(h,g+-1|0)|0)|0}f[d>>2]=0;f[a+8>>2]=j}else{b[a+12>>0]=0;f[a+8>>2]=d}d=f[c+4>>2]|0;if(d|0){b[a+20>>0]=0;f[a+16>>2]=d;return}b[a+20>>0]=1;f[6472]=(f[6472]|0)+1;d=sc(39)|0;if(!d)j=0;else{f[(d+4+15&-16)+-4>>2]=d;j=d+4+15&-16}d=f[c+12>>2]|0;f[j>>2]=k;e=j+4|0;f[e>>2]=d;d=X(d,k)|0;f[6472]=(f[6472]|0)+1;d=sc(d+19|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[j+16>>2]=d;f[j+12>>2]=d;g=f[e>>2]|0;f[j+8>>2]=g;if(g+-1|0){h=f[j>>2]|0;e=d;i=g+-1|0;do{l=e;e=e+h|0;f[l>>2]=e;i=i+-1|0}while((i|0)!=0);d=d+(X(h,g+-1|0)|0)|0}f[d>>2]=0;f[a+16>>2]=j;return}function Xd(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;h=u;u=u+16|0;if((b[22752]|0)==0?fz(22752)|0:0){f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;qg(23416,0.0,0,0,h)}f[5905]=f[5905]|1;n[5940]=0.0;i=+n[5950]*0.0;j=+n[5951]*0.0;n[5945]=+n[5949]*0.0;n[5946]=i;n[5947]=j;n[5948]=0.0;f[5953]=0;f[5954]=0;f[5955]=0;f[5956]=0;j=+n[5942]*0.0;i=+n[5943]*0.0;n[5994]=+n[5941]*0.0;n[5995]=j;n[5996]=i;n[5997]=0.0;f[a+4>>2]=6;f[a+8>>2]=-1;f[a+12>>2]=-1;n[a+16>>2]=3402823466385288598117041.0e14;b[a+20>>0]=1;b[a+21>>0]=0;f[a+24>>2]=-1;f[a+28>>2]=23416;f[a+32>>2]=c;n[a+36>>2]=0.0;n[a+40>>2]=.30000001192092896;f[a+44>>2]=0;f[a>>2]=4624;f[a+112>>2]=f[d>>2];f[a+112+4>>2]=f[d+4>>2];f[a+112+8>>2]=f[d+8>>2];f[a+112+12>>2]=f[d+12>>2];f[a+128>>2]=f[d+16>>2];f[a+128+4>>2]=f[d+16+4>>2];f[a+128+8>>2]=f[d+16+8>>2];f[a+128+12>>2]=f[d+16+12>>2];f[a+144>>2]=f[d+32>>2];f[a+144+4>>2]=f[d+32+4>>2];f[a+144+8>>2]=f[d+32+8>>2];f[a+144+12>>2]=f[d+32+12>>2];f[a+160>>2]=f[d+48>>2];f[a+160+4>>2]=f[d+48+4>>2];f[a+160+8>>2]=f[d+48+8>>2];f[a+160+12>>2]=f[d+48+12>>2];d=a+680|0;g=d+48|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(g|0));f[a+740>>2]=0;f[a+740+4>>2]=0;f[a+740+8>>2]=0;f[a+740+12>>2]=0;f[a+756>>2]=1045220557;f[a+760>>2]=1045220557;f[a+764>>2]=1045220557;f[a+768>>2]=0;f[a+768+4>>2]=0;f[a+768+8>>2]=0;f[a+768+12>>2]=0;f[a+768+16>>2]=0;n[a+728>>2]=.699999988079071;n[a+732>>2]=1.0;n[a+736>>2]=.5;b[a+788>>0]=0;n[a+792>>2]=0.0;n[a+808>>2]=0.0;b[a+789>>0]=0;n[a+796>>2]=0.0;n[a+812>>2]=0.0;b[a+790>>0]=0;n[a+800>>2]=0.0;n[a+816>>2]=0.0;n[a+928>>2]=0.0;n[a+876>>2]=0.0;n[a+880>>2]=.10000000149011612;n[a+884>>2]=300.0;n[a+868>>2]=1.0;n[a+872>>2]=-1.0;n[a+896>>2]=0.0;n[a+900>>2]=.20000000298023224;n[a+904>>2]=0.0;n[a+908>>2]=0.0;n[a+888>>2]=1.0;n[a+892>>2]=.5;f[a+924>>2]=0;n[a+916>>2]=0.0;b[a+912>>0]=0;n[a+992>>2]=0.0;n[a+940>>2]=0.0;n[a+944>>2]=.10000000149011612;n[a+948>>2]=300.0;n[a+932>>2]=1.0;n[a+936>>2]=-1.0;n[a+960>>2]=0.0;n[a+964>>2]=.20000000298023224;n[a+968>>2]=0.0;n[a+972>>2]=0.0;n[a+952>>2]=1.0;n[a+956>>2]=.5;f[a+988>>2]=0;n[a+980>>2]=0.0;b[a+976>>0]=0;n[a+1056>>2]=0.0;n[a+1004>>2]=0.0;n[a+1008>>2]=.10000000149011612;n[a+1012>>2]=300.0;n[a+996>>2]=1.0;n[a+1e3>>2]=-1.0;n[a+1024>>2]=0.0;n[a+1028>>2]=.20000000298023224;n[a+1032>>2]=0.0;n[a+1036>>2]=0.0;n[a+1016>>2]=1.0;n[a+1020>>2]=.5;f[a+1052>>2]=0;n[a+1044>>2]=0.0;b[a+1040>>0]=0;b[a+1300>>0]=e&1;b[a+1301>>0]=1;f[a+1304>>2]=0;b[a+1308>>0]=0;y=+n[a+112>>2];E=+n[c+4>>2];x=+n[a+128>>2];D=+n[c+8>>2];w=+n[a+144>>2];C=+n[c+12>>2];v=+n[a+116>>2];t=+n[a+132>>2];s=+n[a+148>>2];r=+n[a+120>>2];p=+n[a+136>>2];m=+n[a+152>>2];B=+n[c+20>>2];A=+n[c+24>>2];z=+n[c+28>>2];q=+n[c+36>>2];o=+n[c+40>>2];l=+n[c+44>>2];G=+n[a+160>>2];F=+n[a+164>>2];j=+n[a+168>>2];k=+n[c+52>>2]+(E*G+D*F+C*j);i=B*G+A*F+z*j+ +n[c+56>>2];j=q*G+o*F+l*j+ +n[c+60>>2];n[a+48>>2]=y*E+x*D+w*C;n[a+52>>2]=E*v+D*t+C*s;n[a+56>>2]=E*r+D*p+C*m;n[a+60>>2]=0.0;n[a+64>>2]=y*B+x*A+w*z;n[a+68>>2]=v*B+t*A+s*z;n[a+72>>2]=r*B+p*A+m*z;n[a+76>>2]=0.0;n[a+80>>2]=y*q+x*o+w*l;n[a+84>>2]=v*q+t*o+s*l;n[a+88>>2]=r*q+p*o+m*l;n[a+92>>2]=0.0;n[a+96>>2]=k;n[a+100>>2]=i;n[a+104>>2]=j;n[a+108>>2]=0.0;od(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);u=h;return}function Yd(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=+g;h=+h;i=i|0;j=j|0;var k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;w=u;u=u+288|0;f[w+208>>2]=f[c>>2];f[w+208+4>>2]=f[c+4>>2];f[w+208+8>>2]=f[c+8>>2];f[w+208+12>>2]=f[c+12>>2];m=w+208+16|0;f[m>>2]=f[d>>2];f[m+4>>2]=f[d+4>>2];f[m+8>>2]=f[d+8>>2];f[m+12>>2]=f[d+12>>2];d=w+208+32|0;f[d>>2]=f[e>>2];f[d+4>>2]=f[e+4>>2];f[d+8>>2]=f[e+8>>2];f[d+12>>2]=f[e+12>>2];v=f[i>>2]|0;p=f[i+4>>2]|0;q=f[i+8>>2]|0;r=f[i+16>>2]|0;s=f[i+12>>2]|0;o=f[i+20>>2]|0;f[w+156>>2]=f[w+208>>2];f[w+156+4>>2]=f[w+208+4>>2];f[w+156+8>>2]=f[w+208+8>>2];f[w+156+12>>2]=f[w+208+12>>2];f[w+172>>2]=f[m>>2];f[w+172+4>>2]=f[m+4>>2];f[w+172+8>>2]=f[m+8>>2];f[w+172+12>>2]=f[m+12>>2];f[w+188>>2]=f[d>>2];f[w+188+4>>2]=f[d+4>>2];f[w+188+8>>2]=f[d+8>>2];f[w+188+12>>2]=f[d+12>>2];d=f[a+136>>2]|0;if((d|0)==(f[a+140>>2]|0)?(t=d|0?d<<1:1,(d|0)<(t|0)):0){if(!t)c=0;else{f[6472]=(f[6472]|0)+1;c=sc((t*284|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}d=f[a+136>>2]|0}if((d|0)>0){e=0;do{i=f[a+144>>2]|0;k=c+(e*284|0)|0;l=i+(e*284|0)|0;m=k+92|0;do{f[k>>2]=f[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));k=c+(e*284|0)+92|0;l=i+(e*284|0)+92|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];k=i+(e*284|0)+108|0;l=c+(e*284|0)+108|0;f[l>>2]=f[k>>2];f[l+4>>2]=f[k+4>>2];f[l+8>>2]=f[k+8>>2];f[l+12>>2]=f[k+12>>2];l=i+(e*284|0)+124|0;k=c+(e*284|0)+124|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];k=c+(e*284|0)+140|0;l=i+(e*284|0)+140|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];k=c+(e*284|0)+156|0;l=i+(e*284|0)+156|0;m=k+128|0;do{f[k>>2]=f[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));e=e+1|0}while((e|0)!=(d|0))}d=f[a+144>>2]|0;if(d|0){if(b[a+148>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+144>>2]=0}b[a+148>>0]=1;f[a+144>>2]=c;f[a+140>>2]=t;d=f[a+136>>2]|0}c=f[a+144>>2]|0;k=c+(d*284|0)|0;l=w;m=k+92|0;do{f[k>>2]=f[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));k=c+(d*284|0)+92|0;f[k>>2]=f[w+92>>2];f[k+4>>2]=f[w+92+4>>2];f[k+8>>2]=f[w+92+8>>2];f[k+12>>2]=f[w+92+12>>2];k=c+(d*284|0)+108|0;f[k>>2]=f[w+108>>2];f[k+4>>2]=f[w+108+4>>2];f[k+8>>2]=f[w+108+8>>2];f[k+12>>2]=f[w+108+12>>2];k=c+(d*284|0)+124|0;f[k>>2]=f[w+124>>2];f[k+4>>2]=f[w+124+4>>2];f[k+8>>2]=f[w+124+8>>2];f[k+12>>2]=f[w+124+12>>2];k=c+(d*284|0)+140|0;f[k>>2]=f[w+140>>2];f[k+4>>2]=f[w+140+4>>2];f[k+8>>2]=f[w+140+8>>2];f[k+12>>2]=f[w+140+12>>2];c=c+(d*284|0)+156|0;k=c;l=w+156|0;m=k+48|0;do{f[k>>2]=f[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));n[c+48>>2]=g;f[c+52>>2]=s;n[c+56>>2]=h;f[c+60>>2]=v;f[c+64>>2]=p;f[c+68>>2]=q;f[c+72>>2]=r;n[c+76>>2]=0.0;n[c+80>>2]=0.0;n[c+84>>2]=0.0;n[c+88>>2]=.10000000149011612;f[c+92>>2]=o;n[c+96>>2]=0.0;n[c+100>>2]=0.0;b[c+104>>0]=j&1;k=c+105|0;l=w+256|0;m=k+23|0;do{b[k>>0]=b[l>>0]|0;k=k+1|0;l=l+1|0}while((k|0)<(m|0));j=f[a+136>>2]|0;f[a+136>>2]=j+1;j=(f[a+144>>2]|0)+(j*284|0)|0;Sg(f[a+116>>2]|0,j,0);ze(f[a+116>>2]|0,f[a+144>>2]|0,(f[a+136>>2]|0)+-1|0,0);u=w;return j|0}function Zd(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((h|0)<0){o=f[a+8>>2]|0;+Ab[f[(f[o>>2]|0)+12>>2]&3](o,c,d,e,g,f[a+12>>2]|0,f[a+16>>2]|0,f[a+4>>2]|0,f[a+20>>2]|0,f[a+24>>2]|0);return}l=f[a+16>>2]|0;a:do if((l|0)>0){j=f[a+12>>2]|0;i=0;while(1){k=j+(i<<2)|0;o=f[k>>2]|0;n=f[o+28>>2]|0;if((f[((f[n+208>>2]|0)>-1?n:f[o+32>>2]|0)+208>>2]|0)==(h|0)){o=k;break a}i=i+1|0;if((i|0)>=(l|0)){o=0;break}}}else{i=0;o=0}while(0);if((i|0)<(l|0)){k=f[a+12>>2]|0;j=0;do{n=f[k+(i<<2)>>2]|0;m=f[n+28>>2]|0;j=j+((f[((f[m+208>>2]|0)>-1?m:f[n+32>>2]|0)+208>>2]|0)==(h|0)&1)|0;i=i+1|0}while((i|0)!=(l|0));n=j}else n=0;i=f[a+4>>2]|0;if((f[i+72>>2]|0)<2){m=f[a+8>>2]|0;+Ab[f[(f[m>>2]|0)+12>>2]&3](m,c,d,e,g,o,n,i,f[a+20>>2]|0,f[a+24>>2]|0);return}if((d|0)>0){l=0;i=f[a+32>>2]|0;j=f[a+36>>2]|0;do{m=c+(l<<2)|0;if((i|0)==(j|0)){h=j|0?j<<1:1;if((j|0)<(h|0)){if(!h)i=0;else{f[6472]=(f[6472]|0)+1;i=sc((h<<2|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=f[a+32>>2]|0}if((j|0)>0){k=0;do{f[i+(k<<2)>>2]=f[(f[a+40>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=f[a+40>>2]|0;if(k){if(b[a+44>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);j=f[a+32>>2]|0}f[a+40>>2]=0}b[a+44>>0]=1;f[a+40>>2]=i;f[a+36>>2]=h;i=j;j=h}else i=j}f[(f[a+40>>2]|0)+(i<<2)>>2]=f[m>>2];i=i+1|0;f[a+32>>2]=i;l=l+1|0}while((l|0)!=(d|0))}if((g|0)>0){l=0;i=f[a+52>>2]|0;j=f[a+56>>2]|0;do{m=e+(l<<2)|0;if((i|0)==(j|0)){h=j|0?j<<1:1;if((j|0)<(h|0)){if(!h)i=0;else{f[6472]=(f[6472]|0)+1;i=sc((h<<2|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=f[a+52>>2]|0}if((j|0)>0){k=0;do{f[i+(k<<2)>>2]=f[(f[a+60>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=f[a+60>>2]|0;if(k){if(b[a+64>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);j=f[a+52>>2]|0}f[a+60>>2]=0}b[a+64>>0]=1;f[a+60>>2]=i;f[a+56>>2]=h;i=j;j=h}else i=j}f[(f[a+60>>2]|0)+(i<<2)>>2]=f[m>>2];i=i+1|0;f[a+52>>2]=i;l=l+1|0}while((l|0)!=(g|0))}if((n|0)>0){m=0;i=f[a+72>>2]|0;j=f[a+76>>2]|0;do{l=o+(m<<2)|0;if((i|0)==(j|0)){h=j|0?j<<1:1;if((j|0)<(h|0)){if(!h){k=0;i=j}else{f[6472]=(f[6472]|0)+1;i=sc((h<<2|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}k=i;i=f[a+72>>2]|0}if((i|0)>0){j=0;do{f[k+(j<<2)>>2]=f[(f[a+80>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(i|0))}j=f[a+80>>2]|0;if(j){if(b[a+84>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);i=f[a+72>>2]|0}f[a+80>>2]=0}b[a+84>>0]=1;f[a+80>>2]=k;f[a+76>>2]=h;j=h}else i=j}f[(f[a+80>>2]|0)+(i<<2)>>2]=f[l>>2];i=i+1|0;f[a+72>>2]=i;m=m+1|0}while((m|0)!=(n|0))}else i=f[a+72>>2]|0;if(((f[a+52>>2]|0)+i|0)<=(f[(f[a+4>>2]|0)+72>>2]|0))return;gh(a);return}function _d(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;b[a+20>>0]=1;f[a+16>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+24>>2]=c;n[a+28>>2]=0.0;f[a+32>>2]=0;f[a+36>>2]=1;n[a+40>>2]=1.0;b[a+44>>0]=1;f[a+48>>2]=0;b[a+52>>0]=0;b[a+53>>0]=1;b[a+54>>0]=1;n[a+56>>2]=.03999999910593033;b[a+60>>0]=0;n[a+64>>2]=0.0;f[a+68>>2]=d;f[a+72>>2]=0;b[a+76>>0]=1;f[a+80>>2]=0;f[a+84>>2]=0;f[a+88>>2]=0;n[a+92>>2]=.6000000238418579;n[a+96>>2]=1.0;n[a+100>>2]=.30000001192092896;n[a+104>>2]=.01666666753590107;n[a+108>>2]=0.0;n[a+116>>2]=20.0;f[a+112>>2]=10;n[a+124>>2]=.20000000298023224;n[a+128>>2]=.800000011920929;n[a+132>>2]=0.0;n[a+120>>2]=1.0;f[a+136>>2]=1;n[a+140>>2]=-.03999999910593033;n[a+144>>2]=.10000000149011612;n[a+148>>2]=0.0;n[a+152>>2]=.8500000238418579;f[a+156>>2]=260;f[a+160>>2]=2;f[a+164>>2]=128;n[a+168>>2]=100.0;n[a+172>>2]=1000000015047466219876688.0e6;f[a>>2]=4288;b[a+192>>0]=1;f[a+188>>2]=0;f[a+180>>2]=0;f[a+184>>2]=0;f[a+196>>2]=0;f[a+200>>2]=e;b[a+224>>0]=1;f[a+220>>2]=0;f[a+212>>2]=0;f[a+216>>2]=0;b[a+244>>0]=1;f[a+240>>2]=0;f[a+232>>2]=0;f[a+236>>2]=0;f[a+248>>2]=0;f[a+252>>2]=-1054867456;b[a+274>>0]=0;b[a+275>>0]=0;f[a+256>>2]=0;f[a+256+4>>2]=0;f[a+256+8>>2]=0;f[a+256+12>>2]=0;b[a+292>>0]=1;f[a+288>>2]=0;f[a+280>>2]=0;f[a+284>>2]=0;f[a+296>>2]=0;b[a+300>>0]=1;b[a+320>>0]=1;f[a+316>>2]=0;f[a+308>>2]=0;f[a+312>>2]=0;if(!e){f[6472]=(f[6472]|0)+1;d=sc(215)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=4952;b[d+20>>0]=1;f[d+16>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;b[d+40>>0]=1;f[d+36>>2]=0;f[d+28>>2]=0;f[d+32>>2]=0;b[d+60>>0]=1;f[d+56>>2]=0;f[d+48>>2]=0;f[d+52>>2]=0;b[d+80>>0]=1;f[d+76>>2]=0;f[d+68>>2]=0;f[d+72>>2]=0;b[d+100>>0]=1;f[d+96>>2]=0;f[d+88>>2]=0;f[d+92>>2]=0;b[d+120>>0]=1;f[d+116>>2]=0;f[d+108>>2]=0;f[d+112>>2]=0;b[d+140>>0]=1;f[d+136>>2]=0;f[d+128>>2]=0;f[d+132>>2]=0;b[d+160>>0]=1;f[d+156>>2]=0;f[d+148>>2]=0;f[d+152>>2]=0;b[d+180>>0]=1;f[d+176>>2]=0;f[d+168>>2]=0;f[d+172>>2]=0;f[d+192>>2]=0;f[a+200>>2]=d;d=1}else d=0;b[a+273>>0]=d;f[6472]=(f[6472]|0)+1;d=sc(87)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f[d>>2]=5648;b[d+20>>0]=1;f[d+16>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;b[d+40>>0]=1;f[d+36>>2]=0;f[d+28>>2]=0;f[d+32>>2]=0;b[d+60>>0]=1;f[d+56>>2]=0;f[d+48>>2]=0;f[d+52>>2]=0;b[d+64>>0]=1;f[a+204>>2]=d;b[a+272>>0]=1;f[6472]=(f[6472]|0)+1;d=sc(107)|0;if(!d){e=0;g=f[a+200>>2]|0;f[e>>2]=4500;d=e+4|0;f[d>>2]=0;d=e+8|0;f[d>>2]=g;d=e+12|0;f[d>>2]=0;d=e+16|0;f[d>>2]=0;d=e+20|0;f[d>>2]=0;d=e+24|0;f[d>>2]=c;c=e+44|0;b[c>>0]=1;c=e+40|0;f[c>>2]=0;c=e+32|0;f[c>>2]=0;c=e+36|0;f[c>>2]=0;c=e+64|0;b[c>>0]=1;c=e+60|0;f[c>>2]=0;c=e+52|0;f[c>>2]=0;c=e+56|0;f[c>>2]=0;c=e+84|0;b[c>>0]=1;c=e+80|0;f[c>>2]=0;c=e+72|0;f[c>>2]=0;c=e+76|0;f[c>>2]=0;f[a+196>>2]=e;return}f[(d+4+15&-16)+-4>>2]=d;g=d+4+15&-16;d=f[a+200>>2]|0;f[g>>2]=4500;e=g+4|0;f[e>>2]=0;e=g+8|0;f[e>>2]=d;e=g+12|0;f[e>>2]=0;e=g+16|0;f[e>>2]=0;e=g+20|0;f[e>>2]=0;e=g+24|0;f[e>>2]=c;c=g+44|0;b[c>>0]=1;c=g+40|0;f[c>>2]=0;c=g+32|0;f[c>>2]=0;c=g+36|0;f[c>>2]=0;c=g+64|0;b[c>>0]=1;c=g+60|0;f[c>>2]=0;c=g+52|0;f[c>>2]=0;c=g+56|0;f[c>>2]=0;c=g+84|0;b[c>>0]=1;c=g+80|0;f[c>>2]=0;c=g+72|0;f[c>>2]=0;c=g+76|0;f[c>>2]=0;f[a+196>>2]=g;return}function $d(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0,h=0,i=0.0,j=0,k=0,l=0.0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0.0,w=0.0;t=u;u=u+96|0;r=f[a+12>>2]|0;Yb[f[(f[r>>2]|0)+8>>2]&127](r,(f[a+8>>2]|0)+4|0,t+80|0,t+64|0);r=f[c+68>>2]|0;ac[f[(f[r>>2]|0)+16>>2]&31](r,f[(f[a+8>>2]|0)+188>>2]|0,t+80|0,t+64|0,f[c+24>>2]|0);r=f[c+24>>2]|0;Yb[f[(f[r>>2]|0)+32>>2]&127](r,f[(f[a+8>>2]|0)+284>>2]|0,c+28|0,r);r=f[a+8>>2]|0;f[a+92>>2]=f[r+52>>2];f[a+92+4>>2]=f[r+52+4>>2];f[a+92+8>>2]=f[r+52+8>>2];f[a+92+12>>2]=f[r+52+12>>2];r=f[r+284>>2]|0;if((Bb[f[(f[r>>2]|0)+36>>2]&127](r)|0)>0){c=0;e=0.0;r=0;do{d=f[a+132>>2]|0;if((d|0)<0){if((f[a+136>>2]|0)<0){g=f[a+140>>2]|0;if(g|0){if(b[a+144>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+140>>2]=0}b[a+144>>0]=1;f[a+140>>2]=0;f[a+136>>2]=0}do{f[(f[a+140>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[a+132>>2]=0;d=f[(f[a+8>>2]|0)+284>>2]|0;d=(Bb[f[(f[d>>2]|0)+28>>2]&127](d)|0)+12|0;d=f[d>>2]|0;q=f[f[d+(r<<4)>>2]>>2]|0;g=f[f[d+(r<<4)+4>>2]>>2]|0;if(!((q|0)!=0?(f[q+204>>2]&4|0)!=0:0))s=14;do if((s|0)==14){s=0;if(g|0?f[g+204>>2]&4|0:0)break;d=f[d+(r<<4)+8>>2]|0;if(d|0)Rb[f[(f[d>>2]|0)+16>>2]&127](d,a+128|0);q=f[a+132>>2]|0;if((q|0)>0){o=f[a+140>>2]|0;p=f[a+8>>2]|0;m=0;do{k=f[o+(m<<2)>>2]|0;l=(f[k+740>>2]|0)==(p|0)?-1.0:1.0;d=f[k+748>>2]|0;if((d|0)>0){j=0;do{i=+n[k+4+(j*184|0)+80>>2];if(i<0.0){h=k+4+(j*184|0)+64|0;if(i<e){c=k+4+(j*184|0)+68|0;v=l*+n[c>>2];g=k+4+(j*184|0)+72|0;e=l*+n[g>>2];n[a+152>>2]=l*+n[h>>2];n[a+156>>2]=v;n[a+160>>2]=e;n[a+164>>2]=0.0;e=i;d=f[k+748>>2]|0}else{c=k+4+(j*184|0)+68|0;g=k+4+(j*184|0)+72|0}w=i*l*+n[c>>2]*.20000000298023224;v=i*l*+n[g>>2]*.20000000298023224;n[a+92>>2]=i*l*+n[h>>2]*.20000000298023224+ +n[a+92>>2];n[a+96>>2]=w+ +n[a+96>>2];n[a+100>>2]=v+ +n[a+100>>2];c=1}j=j+1|0}while((j|0)<(d|0))}m=m+1|0}while((m|0)!=(q|0))}}while(0);r=r+1|0;q=f[(f[a+8>>2]|0)+284>>2]|0}while((r|0)<(Bb[f[(f[q>>2]|0)+36>>2]&127](q)|0))}else c=0;s=f[a+8>>2]|0;f[t>>2]=f[s+4>>2];f[t+4>>2]=f[s+4+4>>2];f[t+8>>2]=f[s+4+8>>2];f[t+12>>2]=f[s+4+12>>2];f[t+16>>2]=f[s+20>>2];f[t+16+4>>2]=f[s+20+4>>2];f[t+16+8>>2]=f[s+20+8>>2];f[t+16+12>>2]=f[s+20+12>>2];f[t+32>>2]=f[s+36>>2];f[t+32+4>>2]=f[s+36+4>>2];f[t+32+8>>2]=f[s+36+8>>2];f[t+32+12>>2]=f[s+36+12>>2];f[t+48>>2]=f[a+92>>2];f[t+48+4>>2]=f[a+92+4>>2];f[t+48+8>>2]=f[a+92+8>>2];f[t+48+12>>2]=f[a+92+12>>2];f[s+260>>2]=(f[s+260>>2]|0)+1;f[s+4>>2]=f[t>>2];f[s+4+4>>2]=f[t+4>>2];f[s+4+8>>2]=f[t+8>>2];f[s+4+12>>2]=f[t+12>>2];f[s+20>>2]=f[t+16>>2];f[s+20+4>>2]=f[t+16+4>>2];f[s+20+8>>2]=f[t+16+8>>2];f[s+20+12>>2]=f[t+16+12>>2];f[s+36>>2]=f[t+32>>2];f[s+36+4>>2]=f[t+32+4>>2];f[s+36+8>>2]=f[t+32+8>>2];f[s+36+12>>2]=f[t+32+12>>2];f[s+52>>2]=f[t+48>>2];f[s+52+4>>2]=f[t+48+4>>2];f[s+52+8>>2]=f[t+48+8>>2];f[s+52+12>>2]=f[t+48+12>>2];u=t;return c|0}function ae(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;w=u;u=u+80|0;v=f[a+48>>2]|0;f[w>>2]=7056;f[w+4>>2]=v;f[w+8>>2]=c;v=f[a+52>>2]|0;if(!(b[v+60>>0]|0)){c=f[v+56>>2]|0;if((c|0)>0){o=0;a=0;m=f[v+96>>2]|0;while(1){a=a+1|0;if(!(+n[e>>2]>+n[m+16>>2])?!(+n[g>>2]<+n[m>>2]):0)h=1;else h=0;if(!(!(+n[e+8>>2]>+n[m+24>>2])?!(+n[g+8>>2]<+n[m+8>>2]):0))h=0;if(!(+n[e+4>>2]>+n[m+20>>2])?!(+n[g+4>>2]<+n[m+4>>2]):0){i=f[m+32>>2]|0;if(h&(i|0)==-1){Vb[f[(f[w>>2]|0)+8>>2]&127](w,f[m+36>>2]|0,f[m+40>>2]|0);c=f[v+56>>2]|0;l=43}else{k=(i|0)==-1;l=42}}else{i=f[m+32>>2]|0;h=0;k=(i|0)==-1;l=42}if((l|0)==42){l=0;if(k|h)l=43;else{k=m+(i<<6)|0;h=i+o|0}}if((l|0)==43){k=m+64|0;h=o+1|0}if((h|0)<(c|0)){o=h;m=k}else break}}else a=0;if((f[6204]|0)>=(a|0)){u=w;return}f[6204]=a;u=w;return}z=+n[e>>2];D=+n[e+4>>2];H=+n[e+8>>2];G=+n[v+4>>2];z=z<G?G:z;C=+n[v+8>>2];D=D<C?C:D;y=+n[v+12>>2];H=H<y?y:H;I=+n[v+20>>2];E=+n[v+24>>2];A=+n[v+28>>2];F=+n[v+36>>2];B=+n[v+40>>2];x=+n[v+44>>2];r=~~(((I<z?I:z)-G)*F)&65535&-2;d[w+66>>1]=r;s=~~(((E<D?E:D)-C)*B)&65535&-2;t=~~(((A<H?A:H)-y)*x)&65535&-2;d[w+66+2>>1]=s;d[w+66+4>>1]=t;H=+n[g>>2];D=+n[g+4>>2];z=+n[g+8>>2];H=H<G?G:H;D=D<C?C:D;z=z<y?y:z;g=~~(((I<H?I:H)-G)*F+1.0)&65535|1;d[w+60>>1]=g;p=~~(((E<D?E:D)-C)*B+1.0)&65535|1;q=~~(((A<z?A:z)-y)*x+1.0)&65535|1;d[w+60+2>>1]=p;d[w+60+4>>1]=q;switch(f[v+144>>2]|0){case 0:{m=f[v+56>>2]|0;if((m|0)>0){a=0;c=f[v+136>>2]|0;h=0;do{a=a+1|0;i=((g&65535)>=(j[c>>1]|0)?(r&65535)<=(j[c+6>>1]|0):0)&(t&65535)<=(j[c+10>>1]|0)&(q&65535)>=(j[c+4>>1]|0)&(s&65535)<=(j[c+8>>1]|0)&(p&65535)>=(j[c+2>>1]|0);k=c+12|0;l=f[k>>2]|0;if((l|0)>-1&i)Vb[f[(f[w>>2]|0)+8>>2]&127](w,l>>>21,l&2097151);if(i|(l|0)>-1){h=h+1|0;c=c+16|0}else{v=f[k>>2]|0;h=h-v|0;c=c+(0-v<<4)|0}}while((h|0)<(m|0))}else a=0;if((f[6204]|0)<(a|0))f[6204]=a;break}case 1:{if((f[v+152>>2]|0)>0){e=0;do{a=f[v+160>>2]|0;if(((g&65535)>=(j[a+(e<<5)>>1]|0)?(r&65535)<=(j[a+(e<<5)+6>>1]|0):0)&(t&65535)<=(j[a+(e<<5)+10>>1]|0)&(q&65535)>=(j[a+(e<<5)+4>>1]|0)&(s&65535)<=(j[a+(e<<5)+8>>1]|0)&(p&65535)>=(j[a+(e<<5)+2>>1]|0)){o=f[a+(e<<5)+12>>2]|0;m=f[a+(e<<5)+16>>2]|0;if((m|0)>0){a=0;c=(f[v+136>>2]|0)+(o<<4)|0;h=o;do{a=a+1|0;i=((g&65535)>=(j[c>>1]|0)?(r&65535)<=(j[c+6>>1]|0):0)&(t&65535)<=(j[c+10>>1]|0)&(q&65535)>=(j[c+4>>1]|0)&(s&65535)<=(j[c+8>>1]|0)&(p&65535)>=(j[c+2>>1]|0);k=c+12|0;l=f[k>>2]|0;if((l|0)>-1&i)Vb[f[(f[w>>2]|0)+8>>2]&127](w,l>>>21,l&2097151);if(i|(l|0)>-1){h=h+1|0;c=c+16|0}else{l=f[k>>2]|0;h=h-l|0;c=c+(0-l<<4)|0}}while((h|0)<(m+o|0))}else a=0;if((f[6204]|0)<(a|0))f[6204]=a}e=e+1|0}while((e|0)<(f[v+152>>2]|0))}break}case 2:{Jk(f[v+136>>2]|0,w,w+66|0,w+60|0);break}default:{}}u=w;return}function be(a,c,d){a=a|0;c=+c;d=+d;var e=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,v=0.0,w=0.0;r=u;u=u+80|0;e=f[a+8>>2]|0;if(!e){e=f[a+4>>2]|0;if(!e){j=0.0;m=0.0;k=0.0;c=0.0;i=0.0;l=0.0}else{q=+n[e+336>>2];i=+n[a+172>>2];s=+n[e+340>>2];o=+n[a+168>>2];l=+n[a+164>>2];p=+n[e+332>>2];j=+n[e+316>>2];m=+n[e+320>>2];k=+n[e+324>>2];c=q*i-s*o;i=s*l-i*p;l=o*p-q*l}}else{s=+n[e+332>>2];i=+n[a+172>>2];o=+n[e+336>>2];p=+n[a+168>>2];l=+n[a+164>>2];q=+n[e+328>>2];j=+n[e+312>>2];m=+n[e+316>>2];k=+n[e+320>>2];c=s*i-o*p;i=o*l-i*q;l=p*q-s*l}o=j+c;q=m+i;p=k+l;e=f[a+20>>2]|0;if(!e){e=f[a+16>>2]|0;if(!e){j=0.0;l=0.0;k=0.0;c=0.0;i=0.0;m=0.0}else{s=+n[e+336>>2];i=+n[a+188>>2];w=+n[e+340>>2];v=+n[a+184>>2];m=+n[a+180>>2];t=+n[e+332>>2];j=+n[e+316>>2];l=+n[e+320>>2];k=+n[e+324>>2];c=s*i-w*v;i=w*m-i*t;m=v*t-s*m}}else{w=+n[e+332>>2];i=+n[a+188>>2];s=+n[e+336>>2];t=+n[a+184>>2];m=+n[a+180>>2];v=+n[e+328>>2];j=+n[e+312>>2];l=+n[e+316>>2];k=+n[e+320>>2];c=w*i-s*t;i=s*m-i*v;m=t*v-w*m}o=o-(j+c);l=q-(l+i);c=p-(k+m);i=+n[a+196>>2];j=+n[a+200>>2];k=+n[a+204>>2];b[r+36+32>>0]=1;f[r+36+16>>2]=0;f[r+36+16+4>>2]=0;f[r+36+16+8>>2]=0;f[r+36+16+12>>2]=0;f[r+36>>2]=f[a+72>>2];f[r+36+4>>2]=f[a+72+4>>2];f[r+36+8>>2]=f[a+72+8>>2];f[r+36+12>>2]=f[a+72+12>>2];if(i*o+l*j+c*k<0.0){t=+n[a+212>>2];v=+n[r+36>>2]+((i*o+l*j+c*k)*i+(o-(i*o+l*j+c*k)*i)*t);n[r+36>>2]=v;w=(i*o+l*j+c*k)*j+t*(l-(i*o+l*j+c*k)*j)+ +n[r+36+4>>2];n[r+36+4>>2]=w;j=(i*o+l*j+c*k)*k+t*(c-(i*o+l*j+c*k)*k)+ +n[r+36+8>>2];n[r+36+8>>2]=j;e=r+36+4|0;g=r+36+8|0;h=r+36|0;c=v;i=w}else{e=r+36+4|0;g=r+36+8|0;h=r+36|0;c=+n[r+36>>2];i=+n[r+36+4>>2];j=+n[r+36+8>>2]}k=(+n[a+104>>2]*c+ +n[a+108>>2]*i+ +n[a+112>>2]*j)*d;l=(c*+n[a+120>>2]+i*+n[a+124>>2]+j*+n[a+128>>2])*d;c=(c*+n[a+136>>2]+i*+n[a+140>>2]+j*+n[a+144>>2])*d;n[h>>2]=k;n[e>>2]=l;n[g>>2]=c;n[r+36+12>>2]=0.0;e=f[a+4>>2]|0;if((e|0)!=(f[a+16>>2]|0)){e=r;g=r+36|0;h=e+36|0;do{f[e>>2]=f[g>>2];e=e+4|0;g=g+4|0}while((e|0)<(h|0));w=-+n[r+4>>2];v=-+n[r+8>>2];n[r>>2]=-+n[r>>2];n[r+4>>2]=w;n[r+8>>2]=v;n[r+12>>2]=0.0;v=-+n[r+20>>2];w=-+n[r+24>>2];n[r+16>>2]=-+n[r+16>>2];n[r+20>>2]=v;n[r+24>>2]=w;n[r+28>>2]=0.0;Qh(a+4|0,r,a+164|0);Qh(a+16|0,r+36|0,a+180|0);u=r;return}if(!(k==k&l==l&(c==c&0.0==0.0))){u=r;return}w=+L(+(k*k+l*l+c*c));if(w<+n[e+368>>2]){u=r;return}g=f[r+36+32>>2]|0;w=+n[e+372>>2];n[r+12>>2]=0.0;n[r+28>>2]=0.0;f[r+32>>2]=g;n[r>>2]=-(k*w);n[r+4>>2]=-(l*w);n[r+8>>2]=-(c*w);n[r+16>>2]=w*-0.0;n[r+20>>2]=w*-0.0;n[r+24>>2]=w*-0.0;Qh(a+4|0,r,a+164|0);c=+n[(f[a+4>>2]|0)+372>>2];e=r;g=r+36|0;h=e+36|0;do{f[e>>2]=f[g>>2];e=e+4|0;g=g+4|0}while((e|0)<(h|0));n[r>>2]=c*+n[r>>2];n[r+4>>2]=c*+n[r+4>>2];n[r+8>>2]=c*+n[r+8>>2];n[r+16>>2]=c*+n[r+16>>2];n[r+20>>2]=c*+n[r+20>>2];n[r+24>>2]=c*+n[r+24>>2];Qh(a+16|0,r,a+180|0);u=r;return}function ce(a,c,e,g,h){a=a|0;c=c|0;e=+e;g=+g;h=+h;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0;p=u;u=u+240|0;m=+n[a+96>>2]+g;o=+n[a+100>>2]+h;n[a+112>>2]=+n[a+92>>2]+e;n[a+116>>2]=m;n[a+120>>2]=o;n[a+124>>2]=0.0;f[p+168>>2]=1065353216;f[p+168+4>>2]=0;f[p+168+4+4>>2]=0;f[p+168+4+8>>2]=0;f[p+168+4+12>>2]=0;f[p+168+20>>2]=1065353216;f[p+168+24>>2]=0;f[p+168+24+4>>2]=0;f[p+168+24+8>>2]=0;f[p+168+24+12>>2]=0;f[p+168+40>>2]=1065353216;i=p+168+44|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[i+16>>2]=0;f[p+104>>2]=1065353216;f[p+104+4>>2]=0;f[p+104+4+4>>2]=0;f[p+104+4+8>>2]=0;f[p+104+4+12>>2]=0;f[p+104+20>>2]=1065353216;f[p+104+24>>2]=0;f[p+104+24+4>>2]=0;f[p+104+24+8>>2]=0;f[p+104+24+12>>2]=0;f[p+104+40>>2]=1065353216;i=p+104+44|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[i+16>>2]=0;o=1.0;i=10;while(1){if((i|0)<=0){i=14;break}i=i+-1|0;f[p+168+48>>2]=f[a+92>>2];f[p+168+48+4>>2]=f[a+92+4>>2];f[p+168+48+8>>2]=f[a+92+8>>2];f[p+168+48+12>>2]=f[a+92+12>>2];f[p+104+48>>2]=f[a+112>>2];f[p+104+48+4>>2]=f[a+112+4>>2];f[p+104+48+8>>2]=f[a+112+8>>2];f[p+104+48+12>>2]=f[a+112+12>>2];l=+n[a+92>>2]-+n[a+112>>2];m=+n[a+96>>2]-+n[a+116>>2];e=+n[a+100>>2]-+n[a+120>>2];q=f[a+8>>2]|0;n[p+4>>2]=1.0;f[p+76>>2]=0;f[p+12>>2]=0;f[p+12+4>>2]=0;f[p+12+8>>2]=0;f[p+12+12>>2]=0;f[p+12+16>>2]=0;f[p+12+20>>2]=0;f[p+12+24>>2]=0;f[p+12+28>>2]=0;f[p>>2]=5132;f[p+80>>2]=q;n[p+84>>2]=l;n[p+88>>2]=m;n[p+92>>2]=e;n[p+96>>2]=0.0;n[p+100>>2]=0.0;q=f[q+188>>2]|0;d[p+8>>1]=d[q+4>>1]|0;d[p+10>>1]=d[q+6>>1]|0;q=f[a+12>>2]|0;e=+rb[f[(f[q>>2]|0)+48>>2]&15](q);q=f[a+12>>2]|0;Mb[f[(f[q>>2]|0)+44>>2]&31](q,e+ +n[a+56>>2]);if(!(b[a+170>>0]|0))Ld(c,f[a+12>>2]|0,p+168|0,p+104|0,p,+n[c+56>>2]);else sd(f[a+8>>2]|0,f[a+12>>2]|0,p+168|0,p+104|0,p,+n[c+56>>2]);q=f[a+12>>2]|0;Mb[f[(f[q>>2]|0)+44>>2]&31](q,e);m=+n[p+4>>2];o=o-m;if(m<1.0){g=+n[a+112>>2];k=+n[a+92>>2];h=+n[a+116>>2];l=+n[a+96>>2];j=+n[a+120>>2];m=+n[a+100>>2];e=+L(+((g-k)*(g-k)+(h-l)*(h-l)+(j-m)*(j-m)));if(e>1.1920928955078125e-07){v=+n[p+44>>2];s=+n[p+48>>2];x=+n[p+52>>2];w=((g-k)*(1.0/e)*v+(h-l)*(1.0/e)*s+(j-m)*(1.0/e)*x)*2.0;t=(g-k)*(1.0/e)-v*w;r=(h-l)*(1.0/e)-s*w;w=(j-m)*(1.0/e)-x*w;j=1.0/+L(+(w*w+(t*t+r*r)));f[a+112>>2]=f[a+92>>2];f[a+112+4>>2]=f[a+92+4>>2];f[a+112+8>>2]=f[a+92+8>>2];f[a+112+12>>2]=f[a+92+12>>2];g=e*(j*t-v*(x*j*w+(v*j*t+s*j*r)))+ +n[a+112>>2];n[a+112>>2]=g;h=e*(j*r-s*(x*j*w+(v*j*t+s*j*r)))+ +n[a+116>>2];n[a+116>>2]=h;j=e*(j*w-x*(x*j*w+(v*j*t+s*j*r)))+ +n[a+120>>2];n[a+120>>2]=j;e=h}else e=h;h=g-k;g=e-l;e=j-m;if(!(h*h+g*g+e*e>1.1920928955078125e-07)){i=11;break}x=1.0/+L(+(h*h+g*g+e*e));if(+n[a+76>>2]*h*x+g*x*+n[a+80>>2]+e*x*+n[a+84>>2]<=0.0){i=11;break}}else{f[a+92>>2]=f[a+112>>2];f[a+92+4>>2]=f[a+112+4>>2];f[a+92+8>>2]=f[a+112+8>>2];f[a+92+12>>2]=f[a+112+12>>2]}if(!(o>.009999999776482582)){i=14;break}}if((i|0)==11){u=p;return}else if((i|0)==14){u=p;return}}function de(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;F=+n[a>>2];G=+n[b>>2];H=+n[a+4>>2];w=+n[b+4>>2];x=+n[a+8>>2];y=+n[b+8>>2];z=+n[c>>2];A=+n[c+4>>2];B=+n[c+8>>2];C=(H-w)*(y-B)-(x-y)*(w-A);D=(x-y)*(G-z)-(y-B)*(F-G);E=(w-A)*(F-G)-(H-w)*(G-z);if(!(E*E+(C*C+D*D)>0.0)){H=-1.0;return +H}if(F*(E*(H-w)-D*(x-y))+H*(C*(x-y)-E*(F-G))+(D*(F-G)-C*(H-w))*x>0.0){do if((G-F)*(G-F)+(w-H)*(w-H)+(y-x)*(y-x)>0.0){g=-(F*(G-F)+H*(w-H)+x*(y-x))/((G-F)*(G-F)+(w-H)*(w-H)+(y-x)*(y-x));if(g>=1.0){j=2;h=G*G+w*w+y*y;k=0;i=1065353216;break}if(!(g<=0.0)){i=(n[s>>2]=g,f[s>>2]|0);j=3;h=(x+(y-x)*g)*(x+(y-x)*g)+((F+(G-F)*g)*(F+(G-F)*g)+(H+(w-H)*g)*(H+(w-H)*g));k=(n[s>>2]=1.0-g,f[s>>2]|0);break}else{j=1;h=F*F+H*H+x*x;k=1065353216;i=0;break}}else{j=0;h=-1.0;k=0;i=0}while(0);f[e>>2]=j;f[d>>2]=k;f[d+4>>2]=i;n[d+8>>2]=0.0;p=+n[b>>2];q=+n[b+4>>2];r=+n[b+8>>2]}else{h=-1.0;j=0;k=0;i=0;p=G;q=w;r=y}if(p*(E*(w-A)-D*(y-B))+q*(C*(y-B)-E*(G-z))+(D*(G-z)-C*(w-A))*r>0.0){t=+n[c>>2];g=t-p;u=+n[c+4>>2];m=u-q;v=+n[c+8>>2];o=v-r;do if(g*g+m*m+o*o>0.0){l=-(p*g+q*m+r*o)/(g*g+m*m+o*o);if(l>=1.0){j=2;g=t*t+u*u+v*v;k=0;i=1065353216;break}if(!(l<=0.0)){i=(n[s>>2]=l,f[s>>2]|0);v=p+g*l;g=q+m*l;u=r+o*l;j=3;g=u*u+(v*v+g*g);k=(n[s>>2]=1.0-l,f[s>>2]|0);break}else{j=1;g=p*p+q*q+r*r;k=1065353216;i=0;break}}else g=-1.0;while(0);if(h<0.0|g<h){f[e>>2]=j<<1&6;f[d+4>>2]=k;f[d+8>>2]=i;n[d>>2]=0.0;h=g}}g=+n[c>>2];m=+n[c+4>>2];o=+n[c+8>>2];if(g*(E*(A-H)-D*(B-x))+m*(C*(B-x)-E*(z-F))+(D*(z-F)-C*(A-H))*o>0.0){p=+n[a>>2];q=+n[a+4>>2];r=+n[a+8>>2];do if((p-g)*(p-g)+(q-m)*(q-m)+(r-o)*(r-o)>0.0){l=-(g*(p-g)+m*(q-m)+o*(r-o))/((p-g)*(p-g)+(q-m)*(q-m)+(r-o)*(r-o));if(l>=1.0){j=2;g=p*p+q*q+r*r;k=0;i=1065353216;break}if(!(l<=0.0)){i=(n[s>>2]=l,f[s>>2]|0);j=3;g=(o+(r-o)*l)*(o+(r-o)*l)+((g+(p-g)*l)*(g+(p-g)*l)+(m+(q-m)*l)*(m+(q-m)*l));k=(n[s>>2]=1.0-l,f[s>>2]|0);break}else{j=1;g=g*g+m*m+o*o;k=1065353216;i=0;break}}else g=-1.0;while(0);if(h<0.0|g<h){f[e>>2]=j<<2&4|j>>>1&1;f[d+8>>2]=k;f[d>>2]=i;n[d+4>>2]=0.0}else g=h}else g=h;if(!(g<0.0)){H=g;return +H}u=+L(+(E*E+(C*C+D*D)));v=(C*+n[a>>2]+D*+n[a+4>>2]+E*+n[a+8>>2])/(E*E+(C*C+D*D));f[e>>2]=7;r=+n[b>>2]-C*v;q=+n[b+4>>2]-D*v;t=+n[b+8>>2]-E*v;G=+L(+((q*(G-z)-r*(w-A))*(q*(G-z)-r*(w-A))+(((w-A)*t-q*(y-B))*((w-A)*t-q*(y-B))+(r*(y-B)-t*(G-z))*(r*(y-B)-t*(G-z)))))/u;n[d>>2]=G;w=+n[c>>2]-C*v;t=+n[c+4>>2]-D*v;y=+n[c+8>>2]-E*v;H=+L(+((t*(z-F)-w*(A-H))*(t*(z-F)-w*(A-H))+(((A-H)*y-t*(B-x))*((A-H)*y-t*(B-x))+(w*(B-x)-y*(z-F))*(w*(B-x)-y*(z-F)))))/u;n[d+4>>2]=H;n[d+8>>2]=1.0-(H+G);H=E*v*E*v+(C*v*C*v+D*v*D*v);return +H}function ee(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0;r=u;u=u+48|0;f[r+16>>2]=f[d>>2];f[r+16+4>>2]=f[d+4>>2];f[r+16+8>>2]=f[d+8>>2];f[r+16+12>>2]=f[d+12>>2];f[r+16+16>>2]=f[e>>2];f[r+16+16+4>>2]=f[e+4>>2];f[r+16+16+8>>2]=f[e+8>>2];f[r+16+16+12>>2]=f[e+12>>2];do if((f[c+60>>2]|0)==2){g=f[c+48>>2]|0;zg(a+64|0,g)|0;h=f[a+68>>2]|0;if(h|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+68>>2]=g;f[a+76>>2]=(f[a+76>>2]|0)+-1;g=f[a+8>>2]|0;if(!g){f[6472]=(f[6472]|0)+1;g=sc(63)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}h=g;i=h+44|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0))}else f[a+8>>2]=0;f[g+32>>2]=0;f[g+36>>2]=c;f[g+40>>2]=0;f[g>>2]=f[r+16>>2];f[g+4>>2]=f[r+16+4>>2];f[g+8>>2]=f[r+16+8>>2];f[g+12>>2]=f[r+16+12>>2];f[g+16>>2]=f[r+16+16>>2];f[g+20>>2]=f[r+16+20>>2];f[g+24>>2]=f[r+16+24>>2];f[g+28>>2]=f[r+16+28>>2];ff(a+4|0,f[a+4>>2]|0,g);f[a+16>>2]=(f[a+16>>2]|0)+1;f[c+48>>2]=g;g=1}else{f[a+168>>2]=(f[a+168>>2]|0)+1;q=f[c+48>>2]|0;if(((((+n[q>>2]<=+n[r+16+16>>2]?+n[q+16>>2]>=+n[r+16>>2]:0)?+n[q+4>>2]<=+n[r+16+20>>2]:0)?+n[q+20>>2]>=+n[r+16+4>>2]:0)?+n[q+8>>2]<=+n[r+16+24>>2]:0)?+n[q+24>>2]>=+n[r+16+8>>2]:0){j=+n[c+16>>2];s=+n[d>>2]-j;k=+n[c+20>>2];o=+n[d+4>>2]-k;l=+n[c+24>>2];p=+n[d+8>>2]-l;t=+n[a+140>>2];j=(+n[c+32>>2]-j)*.5*t;k=(+n[c+36>>2]-k)*.5*t;l=t*(+n[c+40>>2]-l)*.5;n[r>>2]=j;n[r+4>>2]=k;n[r+8>>2]=l;n[r+12>>2]=0.0;if(s<0.0)n[r>>2]=-j;if(o<0.0)n[r+4>>2]=-k;if(p<0.0)n[r+8>>2]=-l;if(uh(a+4|0,q,r+16|0,r,.05000000074505806)|0){f[a+172>>2]=(f[a+172>>2]|0)+1;g=1}else g=0;break}g=zg(a+4|0,q)|0;a:do if(g){m=f[a+12>>2]|0;if((m|0)<=-1){g=f[a+4>>2]|0;break}if(m){h=0;while(1){i=f[g+32>>2]|0;h=h+1|0;if(!i)break a;if((h|0)>=(m|0)){g=i;break}else g=i}}}else g=0;while(0);f[q>>2]=f[r+16>>2];f[q+4>>2]=f[r+16+4>>2];f[q+8>>2]=f[r+16+8>>2];f[q+12>>2]=f[r+16+12>>2];f[q+16>>2]=f[r+16+16>>2];f[q+20>>2]=f[r+16+20>>2];f[q+24>>2]=f[r+16+24>>2];f[q+28>>2]=f[r+16+28>>2];ff(a+4|0,g,q);f[a+172>>2]=(f[a+172>>2]|0)+1;g=1}while(0);h=f[c+52>>2]|0;f[((h|0)==0?a+124+(f[c+60>>2]<<2)|0:h+56|0)>>2]=f[c+56>>2];h=f[c+56>>2]|0;if(h|0)f[h+52>>2]=f[c+52>>2];f[c+16>>2]=f[d>>2];f[c+16+4>>2]=f[d+4>>2];f[c+16+8>>2]=f[d+8>>2];f[c+16+12>>2]=f[d+12>>2];f[c+32>>2]=f[e>>2];f[c+32+4>>2]=f[e+4>>2];f[c+32+8>>2]=f[e+8>>2];f[c+32+12>>2]=f[e+12>>2];h=f[a+144>>2]|0;f[c+60>>2]=h;f[c+52>>2]=0;f[c+56>>2]=f[a+124+(h<<2)>>2];i=f[a+124+(h<<2)>>2]|0;if(i|0)f[i+52>>2]=c;f[a+124+(h<<2)>>2]=c;if(!g){u=r;return}b[a+194>>0]=1;if(b[a+193>>0]|0){u=r;return}f[r>>2]=9096;f[r+4>>2]=a;pe(a+64|0,f[a+64>>2]|0,f[c+48>>2]|0,r);pe(a+4|0,f[a+4>>2]|0,f[c+48>>2]|0,r);u=r;return}function fe(a,c,d,e){a=a|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0,C=0,D=0;y=u;u=u+192|0;o=f[a+4>>2]|0;q=+n[o+752>>2];if(q<e){u=y;return}w=f[o+740>>2]|0;x=f[(f[a+8>>2]|0)+8>>2]|0;i=+n[d>>2];j=+n[c>>2]*e+i;k=+n[d+4>>2];l=+n[c+4>>2]*e+k;m=+n[d+8>>2];p=+n[c+8>>2]*e+m;if((w|0)!=(x|0)){h=f[(f[a+12>>2]|0)+8>>2]|0;A=j-+n[h+52>>2];z=l-+n[h+56>>2];t=p-+n[h+60>>2];v=a+12|0;g=x;r=A*+n[h+4>>2]+z*+n[h+20>>2]+t*+n[h+36>>2];s=A*+n[h+8>>2]+z*+n[h+24>>2]+t*+n[h+40>>2];t=A*+n[h+12>>2]+z*+n[h+28>>2]+t*+n[h+44>>2]}else{z=j-+n[w+52>>2];A=l-+n[w+56>>2];t=p-+n[w+60>>2];v=a+12|0;g=f[(f[a+12>>2]|0)+8>>2]|0;r=z*+n[w+4>>2]+A*+n[w+20>>2]+t*+n[w+36>>2];s=z*+n[w+8>>2]+A*+n[w+24>>2]+t*+n[w+40>>2];t=z*+n[w+12>>2]+A*+n[w+28>>2]+t*+n[w+44>>2]}i=i-+n[g+52>>2];k=k-+n[g+56>>2];A=m-+n[g+60>>2];m=i*+n[g+4>>2]+k*+n[g+20>>2]+A*+n[g+36>>2];z=i*+n[g+8>>2]+k*+n[g+24>>2]+A*+n[g+40>>2];A=i*+n[g+12>>2]+k*+n[g+28>>2]+A*+n[g+44>>2];n[y>>2]=r;n[y+4>>2]=s;n[y+8>>2]=t;n[y+12>>2]=0.0;n[y+16>>2]=m;n[y+20>>2]=z;n[y+24>>2]=A;n[y+28>>2]=0.0;f[y+64>>2]=f[c>>2];f[y+64+4>>2]=f[c+4>>2];f[y+64+8>>2]=f[c+8>>2];f[y+64+12>>2]=f[c+12>>2];n[y+80>>2]=e;n[y+84>>2]=0.0;n[y+88>>2]=0.0;n[y+92>>2]=0.0;f[y+112>>2]=0;b[y+116>>0]=0;f[y+120>>2]=0;f[y+120+4>>2]=0;f[y+120+8>>2]=0;f[y+120+12>>2]=0;f[y+120+16>>2]=0;f[y+120+20>>2]=0;f[y+120+24>>2]=0;f[y+120+28>>2]=0;n[y+48>>2]=j;n[y+52>>2]=l;n[y+56>>2]=p;n[y+60>>2]=0.0;f[y+32>>2]=f[d>>2];f[y+32+4>>2]=f[d+4>>2];f[y+32+8>>2]=f[d+8>>2];f[y+32+12>>2]=f[d+12>>2];h=f[o+748>>2]|0;if((h|0)>0){g=-1;d=0;i=q*q;while(1){j=+n[o+4+(d*184|0)>>2]-r;k=+n[o+4+(d*184|0)+4>>2]-s;l=+n[o+4+(d*184|0)+8>>2]-t;c=j*j+k*k+l*l<i;g=c?d:g;d=d+1|0;if((d|0)==(h|0)){o=g;break}else i=c?j*j+k*k+l*l:i}}else o=-1;h=f[(f[a+8>>2]|0)+8>>2]|0;v=f[(f[v>>2]|0)+8>>2]|0;i=+n[h+224>>2]*+n[v+224>>2];i=i<-10.0?-10.0:i;n[y+84>>2]=i>10.0?10.0:i;n[y+92>>2]=+n[h+228>>2]*+n[v+228>>2];i=+n[h+232>>2]*+n[v+232>>2];i=i<-10.0?-10.0:i;n[y+88>>2]=i>10.0?10.0:i;i=+n[y+72>>2];if(+K(+i)>.7071067690849304){j=+n[y+68>>2];k=1.0/+L(+(i*i+j*j));m=+n[y+64>>2];l=-(k*i);e=m*-(k*i);m=-(k*j*m);i=(i*i+j*j)*k;j=k*j;k=0.0}else{j=+n[y+64>>2];A=+n[y+68>>2];k=1.0/+L(+(j*j+A*A));l=k*j;e=(j*j+A*A)*k;m=i*-(A*k);i=-(k*j*i);j=0.0;k=-(A*k)}n[y+152>>2]=k;n[y+156>>2]=l;n[y+160>>2]=j;n[y+168>>2]=i;n[y+172>>2]=m;n[y+176>>2]=e;if((w|0)!=(x|0)){g=a+28|0;c=a+16|0;d=a+20|0;h=a+24|0}else{g=a+24|0;c=a+20|0;d=a+16|0;h=a+28|0}g=f[g>>2]|0;x=f[c>>2]|0;f[y+96>>2]=f[d>>2];f[y+100>>2]=x;f[y+104>>2]=g;f[y+108>>2]=f[h>>2];g=f[a+4>>2]|0;if((o|0)>-1){a=g+4+(o*184|0)+148|0;x=f[a>>2]|0;c=g+4+(o*184|0)+120|0;B=f[c>>2]|0;h=g+4+(o*184|0)+124|0;d=f[h>>2]|0;w=g+4+(o*184|0)+128|0;v=f[w>>2]|0;C=g+4+(o*184|0)+112|0;D=f[C>>2]|0;ki(g+4+(o*184|0)|0,y|0,184)|0;f[C>>2]=D;f[c>>2]=B;f[h>>2]=d;f[w>>2]=v;f[a>>2]=x}else mf(g,y)|0;u=y;return}function ge(a){a=a|0;var c=0.0,d=0,e=0,g=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0;p=u;u=u+80|0;if((Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0?(i=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0,(Bb[f[(f[i>>2]|0)+48>>2]&127](i)|0)&8|0):0)?(g=f[a+24>>2]|0,g=Bb[f[(f[g>>2]|0)+36>>2]&127](g)|0,f[p+64>>2]=1065353216,f[p+64+4>>2]=1065353216,f[p+64+8>>2]=0,n[p+64+12>>2]=0.0,(g|0)>0):0){d=0;do{h=f[a+24>>2]|0;h=Db[f[(f[h>>2]|0)+40>>2]&31](h,d)|0;i=f[h+748>>2]|0;if((i|0)>0){e=0;do{q=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Xb[f[(f[q>>2]|0)+32>>2]&0](q,h+4+(e*184|0)+32|0,h+4+(e*184|0)+64|0,+n[h+4+(e*184|0)+80>>2],f[h+4+(e*184|0)+148>>2]|0,p+64|0);e=e+1|0}while((e|0)!=(i|0))}d=d+1|0}while((d|0)!=(g|0))}if(!(Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0)){u=p;return}q=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;if(!((Bb[f[(f[q>>2]|0)+48>>2]&127](q)|0)&3)){u=p;return}if((f[a+8>>2]|0)<=0){u=p;return}i=0;do{h=f[(f[a+16>>2]|0)+(i<<2)>>2]|0;if(!(f[h+204>>2]&32)){if(Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0?(q=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0,(Bb[f[(f[q>>2]|0)+48>>2]&127](q)|0)&1|0):0){f[p+64>>2]=1065353216;f[p+64+4>>2]=1065353216;f[p+64+8>>2]=1065353216;n[p+64+12>>2]=0.0;switch(f[h+216>>2]|0){case 1:{d=1065353216;e=1065353216;g=1065353216;break}case 2:{d=0;e=1065353216;g=0;break}case 3:{d=1065353216;e=1065353216;g=0;break}case 4:{d=0;e=0;g=1065353216;break}case 5:{d=0;e=1065353216;g=1065353216;break}default:{d=0;e=0;g=1065353216}}f[p+64>>2]=g;f[p+64+4>>2]=e;f[p+64+8>>2]=d;n[p+64+12>>2]=0.0;Yb[f[(f[a>>2]|0)+28>>2]&127](a,h+4|0,f[h+192>>2]|0,p+64|0)}d=f[a+72>>2]|0;if(d|0?(Bb[f[(f[d>>2]|0)+48>>2]&127](d)|0)&2|0:0){f[p+32>>2]=1065353216;f[p+32+4>>2]=0;f[p+32+8>>2]=0;n[p+32+12>>2]=0.0;q=f[h+192>>2]|0;Yb[f[(f[q>>2]|0)+8>>2]&127](q,h+4|0,p+64|0,p+48|0);n[p+64>>2]=+n[p+64>>2]+-.019999999552965164;n[p+64+4>>2]=+n[p+64+4>>2]+-.019999999552965164;n[p+64+8>>2]=+n[p+64+8>>2]+-.019999999552965164;n[p+48>>2]=+n[p+48>>2]+.019999999552965164;n[p+48+4>>2]=+n[p+48+4>>2]+.019999999552965164;n[p+48+8>>2]=+n[p+48+8>>2]+.019999999552965164;do if((b[a+44>>0]|0?(f[h+236>>2]|0)==2:0)?(f[h+204>>2]&3|0)==0:0){q=f[h+192>>2]|0;Yb[f[(f[q>>2]|0)+8>>2]&127](q,h+68|0,p+16|0,p);c=+n[p+16>>2]+-.019999999552965164;n[p+16>>2]=c;j=+n[p+16+4>>2]+-.019999999552965164;n[p+16+4>>2]=j;k=+n[p+16+8>>2]+-.019999999552965164;n[p+16+8>>2]=k;l=+n[p>>2]+.019999999552965164;n[p>>2]=l;m=+n[p+4>>2]+.019999999552965164;n[p+4>>2]=m;o=+n[p+8>>2]+.019999999552965164;n[p+8>>2]=o;if(c<+n[p+64>>2])n[p+64>>2]=c;if(j<+n[p+64+4>>2])n[p+64+4>>2]=j;if(k<+n[p+64+8>>2])n[p+64+8>>2]=k;c=+n[p+16+12>>2];if(c<+n[p+64+12>>2])n[p+64+12>>2]=c;if(+n[p+48>>2]<l)n[p+48>>2]=l;if(+n[p+48+4>>2]<m)n[p+48+4>>2]=m;if(+n[p+48+8>>2]<o)n[p+48+8>>2]=o;c=+n[p+12>>2];if(!(+n[p+48+12>>2]<c))break;n[p+48+12>>2]=c}while(0);q=f[a+72>>2]|0;Yb[f[(f[q>>2]|0)+52>>2]&127](q,p+64|0,p+48|0,p+32|0)}}i=i+1|0}while((i|0)<(f[a+8>>2]|0));u=p;return}function he(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0,i=0,k=0,l=0,m=0,o=0,q=0,r=0,s=0.0;r=u;u=u+80|0;l=f[a+4>>2]|0;fc[f[(f[l>>2]|0)+16>>2]&3](l,r+28|0,r+24|0,r+20|0,r+16|0,r+12|0,r+8|0,r+4|0,r,b);l=(f[r+12>>2]|0)+(X(f[r+8>>2]|0,c)|0)|0;q=f[a+4>>2]|0;o=(f[r+20>>2]|0)==0;m=f[r+28>>2]|0;if((f[r>>2]|0)!=3){h=f[r+16>>2]|0;i=m+(X(h,f[l+8>>2]|0)|0)|0;if(o){s=+n[i+4>>2]*+n[q+8>>2];e=+n[q+12>>2]*+n[i+8>>2];n[r+32+32>>2]=+n[i>>2]*+n[q+4>>2];n[r+32+36>>2]=s;n[r+32+40>>2]=e;n[r+32+44>>2]=0.0;o=m+(X(h,f[l+4>>2]|0)|0)|0;e=+n[o+4>>2]*+n[q+8>>2];s=+n[q+12>>2]*+n[o+8>>2];n[r+32+16>>2]=+n[o>>2]*+n[q+4>>2];n[r+32+20>>2]=e;n[r+32+24>>2]=s;n[r+32+28>>2]=0.0;o=m+(X(h,f[l>>2]|0)|0)|0;s=+n[q+12>>2];e=+n[o+4>>2]*+n[q+8>>2];d=+n[o>>2]*+n[q+4>>2];g=+n[o+8>>2];g=s*g;n[r+32>>2]=d;q=r+32+4|0;n[q>>2]=e;q=r+32+8|0;n[q>>2]=g;q=r+32+12|0;n[q>>2]=0.0;q=a+8|0;q=f[q>>2]|0;o=f[q>>2]|0;o=o+8|0;o=f[o>>2]|0;Yb[o&127](q,r+32|0,b,c);c=f[a+4>>2]|0;a=f[c>>2]|0;a=a+24|0;a=f[a>>2]|0;Rb[a&127](c,b);u=r;return}else{d=+n[q+8>>2]*+p[i+8>>3];g=+n[q+12>>2]*+p[i+16>>3];n[r+32+32>>2]=+n[q+4>>2]*+p[i>>3];n[r+32+36>>2]=d;n[r+32+40>>2]=g;n[r+32+44>>2]=0.0;o=m+(X(h,f[l+4>>2]|0)|0)|0;g=+n[q+8>>2]*+p[o+8>>3];d=+n[q+12>>2]*+p[o+16>>3];n[r+32+16>>2]=+n[q+4>>2]*+p[o>>3];n[r+32+20>>2]=g;n[r+32+24>>2]=d;n[r+32+28>>2]=0.0;o=m+(X(h,f[l>>2]|0)|0)|0;d=+n[q+12>>2];g=+n[q+8>>2]*+p[o+8>>3];e=+n[q+4>>2]*+p[o>>3];s=+p[o+16>>3];s=d*s;n[r+32>>2]=e;q=r+32+4|0;n[q>>2]=g;q=r+32+8|0;n[q>>2]=s;q=r+32+12|0;n[q>>2]=0.0;q=a+8|0;q=f[q>>2]|0;o=f[q>>2]|0;o=o+8|0;o=f[o>>2]|0;Yb[o&127](q,r+32|0,b,c);c=f[a+4>>2]|0;a=f[c>>2]|0;a=a+24|0;a=f[a>>2]|0;Rb[a&127](c,b);u=r;return}}k=f[r+16>>2]|0;h=m+(X(k,j[l+4>>1]|0)|0)|0;if(o){e=+n[h+4>>2]*+n[q+8>>2];g=+n[h>>2]*+n[q+4>>2];i=h+8|0;d=+n[q+12>>2]}else{e=+n[q+8>>2]*+p[h+8>>3];g=+n[q+4>>2]*+p[h>>3];i=q+12|0;d=+p[h+16>>3]}s=d*+n[i>>2];n[r+32+32>>2]=g;n[r+32+36>>2]=e;n[r+32+40>>2]=s;n[r+32+44>>2]=0.0;h=m+(X(k,j[l+2>>1]|0)|0)|0;if(o){e=+n[h+4>>2]*+n[q+8>>2];g=+n[h>>2]*+n[q+4>>2];i=h+8|0;d=+n[q+12>>2]}else{e=+n[q+8>>2]*+p[h+8>>3];g=+n[q+4>>2]*+p[h>>3];i=q+12|0;d=+p[h+16>>3]}s=d*+n[i>>2];n[r+32+16>>2]=g;n[r+32+20>>2]=e;n[r+32+24>>2]=s;n[r+32+28>>2]=0.0;i=m+(X(k,j[l>>1]|0)|0)|0;if(o){e=+n[i+4>>2]*+n[q+8>>2];g=+n[i>>2]*+n[q+4>>2];h=i+8|0;d=+n[q+12>>2]}else{e=+n[q+8>>2]*+p[i+8>>3];g=+n[q+4>>2]*+p[i>>3];h=q+12|0;d=+p[i+16>>3]}s=+n[h>>2];s=d*s;n[r+32>>2]=g;q=r+32+4|0;n[q>>2]=e;q=r+32+8|0;n[q>>2]=s;q=r+32+12|0;n[q>>2]=0.0;q=a+8|0;q=f[q>>2]|0;o=f[q>>2]|0;o=o+8|0;o=f[o>>2]|0;Yb[o&127](q,r+32|0,b,c);c=f[a+4>>2]|0;a=f[c>>2]|0;a=a+24|0;a=f[a>>2]|0;Rb[a&127](c,b);u=r;return}function ie(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0.0,q=0.0;o=u;u=u+144|0;if((f[a+16>>2]|0)<=0){m=a+76|0;f[m>>2]=f[b>>2];f[m+4>>2]=f[b+4>>2];f[m+8>>2]=f[b+8>>2];f[m+12>>2]=f[b+12>>2];m=f[a>>2]|0;m=m+68|0;m=f[m>>2]|0;Lb[m&511](a);u=o;return}i=o+16+16|0;j=o+16+32|0;k=o+16+48|0;h=0;do{m=f[a+24>>2]|0;l=m+(h*80|0)|0;f[o+16>>2]=f[l>>2];f[o+16+4>>2]=f[l+4>>2];f[o+16+8>>2]=f[l+8>>2];f[o+16+12>>2]=f[l+12>>2];l=m+(h*80|0)+16|0;f[i>>2]=f[l>>2];f[i+4>>2]=f[l+4>>2];f[i+8>>2]=f[l+8>>2];f[i+12>>2]=f[l+12>>2];l=m+(h*80|0)+32|0;f[j>>2]=f[l>>2];f[j+4>>2]=f[l+4>>2];f[j+8>>2]=f[l+8>>2];f[j+12>>2]=f[l+12>>2];l=m+(h*80|0)+48|0;f[k>>2]=f[l>>2];f[k+4>>2]=f[l+4>>2];f[k+8>>2]=f[l+8>>2];f[k+12>>2]=f[l+12>>2];m=f[m+(h*80|0)+64>>2]|0;m=Bb[f[(f[m>>2]|0)+28>>2]&127](m)|0;f[o>>2]=f[m>>2];f[o+4>>2]=f[m+4>>2];f[o+8>>2]=f[m+8>>2];p=+n[o+4>>2]*+n[b+4>>2]/+n[a+80>>2];q=+n[o+8>>2]*+n[b+8>>2]/+n[a+84>>2];n[o>>2]=+n[o>>2]*+n[b>>2]/+n[a+76>>2];n[o+4>>2]=p;n[o+8>>2]=q;n[o+12>>2]=0.0;m=f[(f[a+24>>2]|0)+(h*80|0)+64>>2]|0;Rb[f[(f[m>>2]|0)+24>>2]&127](m,o);q=+n[o+16+52>>2]*+n[b+4>>2]/+n[a+80>>2];p=+n[o+16+56>>2]*+n[b+8>>2]/+n[a+84>>2];n[o+16+48>>2]=+n[k>>2]*+n[b>>2]/+n[a+76>>2];n[o+16+52>>2]=q;n[o+16+56>>2]=p;n[o+16+60>>2]=0.0;m=f[a+24>>2]|0;l=m+(h*80|0)|0;f[l>>2]=f[o+16>>2];f[l+4>>2]=f[o+16+4>>2];f[l+8>>2]=f[o+16+8>>2];f[l+12>>2]=f[o+16+12>>2];l=m+(h*80|0)+16|0;f[l>>2]=f[i>>2];f[l+4>>2]=f[i+4>>2];f[l+8>>2]=f[i+8>>2];f[l+12>>2]=f[i+12>>2];l=m+(h*80|0)+32|0;f[l>>2]=f[j>>2];f[l+4>>2]=f[j+4>>2];f[l+8>>2]=f[j+8>>2];f[l+12>>2]=f[j+12>>2];m=m+(h*80|0)+48|0;f[m>>2]=f[k>>2];f[m+4>>2]=f[k+4>>2];f[m+8>>2]=f[k+8>>2];f[m+12>>2]=f[k+12>>2];if(f[a+64>>2]|0){l=f[(f[a+24>>2]|0)+(h*80|0)+64>>2]|0;Yb[f[(f[l>>2]|0)+8>>2]&127](l,o+16|0,o+128|0,o+112|0);f[o+80>>2]=f[o+128>>2];f[o+80+4>>2]=f[o+128+4>>2];f[o+80+8>>2]=f[o+128+8>>2];f[o+80+12>>2]=f[o+128+12>>2];f[o+80+16>>2]=f[o+112>>2];f[o+80+16+4>>2]=f[o+112+4>>2];f[o+80+16+8>>2]=f[o+112+8>>2];f[o+80+16+12>>2]=f[o+112+12>>2];l=f[a+64>>2]|0;m=f[(f[a+24>>2]|0)+(h*80|0)+76>>2]|0;c=zg(l,m)|0;a:do if(c){g=f[l+8>>2]|0;if((g|0)<=-1){c=f[l>>2]|0;break}if(g){d=0;while(1){e=f[c+32>>2]|0;d=d+1|0;if(!e)break a;if((d|0)>=(g|0)){c=e;break}else c=e}}}else c=0;while(0);f[m>>2]=f[o+80>>2];f[m+4>>2]=f[o+80+4>>2];f[m+8>>2]=f[o+80+8>>2];f[m+12>>2]=f[o+80+12>>2];f[m+16>>2]=f[o+80+16>>2];f[m+20>>2]=f[o+80+20>>2];f[m+24>>2]=f[o+80+24>>2];f[m+28>>2]=f[o+80+28>>2];ff(l,c,m)}h=h+1|0}while((h|0)<(f[a+16>>2]|0));m=a+76|0;f[m>>2]=f[b>>2];f[m+4>>2]=f[b+4>>2];f[m+8>>2]=f[b+8>>2];f[m+12>>2]=f[b+12>>2];m=f[a>>2]|0;m=m+68|0;m=f[m>>2]|0;Lb[m&511](a);u=o;return}function je(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=f[b>>2]|0;m=f[b+4>>2]|0;i=f[b+8>>2]|0;n=f[a+4>>2]|0;p=Nh(a,c,m,i)|0;f[p+12>>2]=f[b+12>>2];f[p+16>>2]=n+1;f[p+20>>2]=n+2;h=f[(f[a+12>>2]|0)+(f[b+12>>2]<<2)>>2]|0;d=f[h>>2]|0;e=f[h+4>>2]|0;do if(!((d|0)==(m|0)&(e|0)==(i|0))){if((d|0)==(i|0)?(e|0)==(m|0):0){d=h+12+8|0;break}g=f[h+8>>2]|0;if(!((e|0)==(m|0)&(g|0)==(i|0)))if(!((e|0)==(i|0)&(g|0)==(m|0)))if((g|0)!=(m|0)|(d|0)==(i|0)^1){if((g|0)==(i|0)?(d|0)==(m|0):0){d=h+12+4|0;break}d=9624}else{d=1;o=2}else d=h+12|0;else{d=0;o=2}}else{d=2;o=2}while(0);if((o|0)==2)d=h+12+(d<<2)|0;f[d>>2]=n;k=Nh(a,c,i,l)|0;f[k+12>>2]=f[b+12+4>>2];f[k+16>>2]=n+2;f[k+20>>2]=n;h=f[(f[a+12>>2]|0)+(f[b+12+4>>2]<<2)>>2]|0;d=f[h>>2]|0;e=f[h+4>>2]|0;do if(!((d|0)==(i|0)&(e|0)==(l|0))){if((d|0)==(l|0)?(e|0)==(i|0):0){d=h+12+8|0;break}g=f[h+8>>2]|0;if(!((e|0)==(i|0)&(g|0)==(l|0)))if(!((e|0)==(l|0)&(g|0)==(i|0)))if((g|0)!=(i|0)|(d|0)==(l|0)^1){if((g|0)==(l|0)?(d|0)==(i|0):0){d=h+12+4|0;break}d=9624}else{d=1;o=12}else d=h+12|0;else{d=0;o=12}}else{d=2;o=12}while(0);if((o|0)==12)d=h+12+(d<<2)|0;f[d>>2]=n+1;j=Nh(a,c,l,m)|0;f[j+12>>2]=f[b+12+8>>2];f[j+16>>2]=n;f[j+20>>2]=n+1;d=f[a+12>>2]|0;i=f[d+(f[b+12+8>>2]<<2)>>2]|0;e=f[i>>2]|0;g=f[i+4>>2]|0;do if(!((e|0)==(l|0)&(g|0)==(m|0))){if((e|0)==(m|0)?(g|0)==(l|0):0){e=i+12+8|0;break}h=f[i+8>>2]|0;if(!((g|0)==(l|0)&(h|0)==(m|0)))if(!((g|0)==(m|0)&(h|0)==(l|0)))if((h|0)!=(l|0)|(e|0)==(m|0)^1){if((h|0)==(m|0)?(e|0)==(l|0):0){e=i+12+4|0;break}e=9624}else{e=1;o=22}else e=i+12|0;else{e=0;o=22}}else{e=2;o=22}while(0);if((o|0)==22)e=i+12+(e<<2)|0;f[e>>2]=n+2;e=f[d+(f[p+12>>2]<<2)>>2]|0;if(!(((f[e>>2]|0)!=(c|0)?(f[e+4>>2]|0)!=(c|0):0)?(f[e+8>>2]|0)!=(c|0):0)){re(d,p,e);f[(f[a+12>>2]|0)+(f[p+24>>2]<<2)>>2]=0;f[6473]=(f[6473]|0)+1;Cd(f[p+-4>>2]|0);f[(f[a+12>>2]|0)+(f[e+24>>2]<<2)>>2]=0;if(e|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}d=f[a+12>>2]|0}e=f[d+(f[k+12>>2]<<2)>>2]|0;if(!(((f[e>>2]|0)!=(c|0)?(f[e+4>>2]|0)!=(c|0):0)?(f[e+8>>2]|0)!=(c|0):0)){re(d,k,e);f[(f[a+12>>2]|0)+(f[k+24>>2]<<2)>>2]=0;f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);f[(f[a+12>>2]|0)+(f[e+24>>2]<<2)>>2]=0;if(e|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}d=f[a+12>>2]|0}e=f[d+(f[j+12>>2]<<2)>>2]|0;if(((f[e>>2]|0)!=(c|0)?(f[e+4>>2]|0)!=(c|0):0)?(f[e+8>>2]|0)!=(c|0):0){a=d;c=b+24|0;c=f[c>>2]|0;c=a+(c<<2)|0;f[c>>2]=0;c=f[6473]|0;c=c+1|0;f[6473]=c;c=b+-4|0;c=f[c>>2]|0;Cd(c);return}re(d,j,e);f[(f[a+12>>2]|0)+(f[j+24>>2]<<2)>>2]=0;f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);f[(f[a+12>>2]|0)+(f[e+24>>2]<<2)>>2]=0;if(e|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}a=f[a+12>>2]|0;c=b+24|0;c=f[c>>2]|0;c=a+(c<<2)|0;f[c>>2]=0;c=f[6473]|0;c=c+1|0;f[6473]=c;c=b+-4|0;c=f[c>>2]|0;Cd(c);return}function ke(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;var k=0.0,l=0.0,m=0.0;f[a>>2]=8776;d[a+4>>1]=-2;d[a+6>>1]=-1;f[a+92>>2]=h;f[a+96>>2]=0;b[a+100>>0]=0;f[a+104>>2]=0;f[a+108>>2]=0;if(!h){f[6472]=(f[6472]|0)+1;h=sc(95)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}Ci(h);f[a+92>>2]=h;b[a+100>>0]=1}if(!i){f[6472]=(f[6472]|0)+1;h=sc(43)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}i=h+4|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[i+16>>2]=0;f[h>>2]=8840;b[h+20>>0]=1;f[h+16>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[a+112>>2]=h;f[6472]=(f[6472]|0)+1;h=sc(215)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}Sh(h,f[a+112>>2]|0);f[a+108>>2]=h;b[h+193>>0]=1}f[a+8>>2]=f[c>>2];f[a+8+4>>2]=f[c+4>>2];f[a+8+8>>2]=f[c+8>>2];f[a+8+12>>2]=f[c+12>>2];f[a+24>>2]=f[e>>2];f[a+24+4>>2]=f[e+4>>2];f[a+24+8>>2]=f[e+8>>2];f[a+24+12>>2]=f[e+12>>2];m=+(j[a+6>>1]|0);l=m/(+n[a+28>>2]-+n[a+12>>2]);k=m/(+n[a+32>>2]-+n[a+16>>2]);n[a+40>>2]=m/(+n[a+24>>2]-+n[a+8>>2]);n[a+44>>2]=l;n[a+48>>2]=k;n[a+52>>2]=0.0;e=g+1&65535;f[6472]=(f[6472]|0)+1;h=sc(e<<6|19)|0;if(!h)c=0;else{f[(h+4+15&-16)+-4>>2]=h;c=h+4+15&-16}if(g+1<<16>>16<<16>>16){h=c+(e<<6)|0;i=c;do{f[i>>2]=0;f[i+8>>2]=0;i=i+64|0}while((i|0)!=(h|0))}f[a+60>>2]=c;d[a+58>>1]=(g&65535)+1;d[a+56>>1]=0;d[a+64>>1]=1;if((g+1&65535)>1?(d[c+112>>1]=2,g+1<<16>>16<<16>>16!=2):0){h=2;do{g=h;h=h+1|0;d[c+(g<<6)+48>>1]=h}while((h|0)!=(e|0))}d[c+(e+-1<<6)+48>>1]=0;f[6472]=(f[6472]|0)+1;h=sc((e<<3|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}f[a+80>>2]=h;f[a+68>>2]=h;f[6472]=(f[6472]|0)+1;h=sc((e<<3|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}f[a+84>>2]=h;f[a+72>>2]=h;f[6472]=(f[6472]|0)+1;h=sc((e<<3|3)+16|0)|0;if(!h){c=0;g=a+88|0;f[g>>2]=c;g=a+76|0;f[g>>2]=c;c=f[a+60>>2]|0;f[c>>2]=0;e=c+48|0;d[e>>1]=0;e=c+54|0;d[e>>1]=1;e=f[a+68>>2]|0;d[e>>1]=0;i=e+2|0;d[i>>1]=0;i=d[a+6>>1]|0;h=e+4|0;d[h>>1]=i;e=e+6|0;d[e>>1]=0;e=c+50|0;d[e>>1]=0;e=c+56|0;d[e>>1]=1;e=f[a+72>>2]|0;d[e>>1]=0;h=e+2|0;d[h>>1]=0;h=d[a+6>>1]|0;i=e+4|0;d[i>>1]=h;e=e+6|0;d[e>>1]=0;e=c+52|0;d[e>>1]=0;c=c+58|0;d[c>>1]=1;g=f[g>>2]|0;d[g>>1]=0;c=g+2|0;d[c>>1]=0;c=d[a+6>>1]|0;e=g+4|0;d[e>>1]=c;g=g+6|0;d[g>>1]=0;f[a>>2]=8712;return}f[(h+4+15&-16)+-4>>2]=h;c=h+4+15&-16;g=a+88|0;f[g>>2]=c;g=a+76|0;f[g>>2]=c;c=f[a+60>>2]|0;f[c>>2]=0;e=c+48|0;d[e>>1]=0;e=c+54|0;d[e>>1]=1;e=f[a+68>>2]|0;d[e>>1]=0;i=e+2|0;d[i>>1]=0;i=d[a+6>>1]|0;h=e+4|0;d[h>>1]=i;e=e+6|0;d[e>>1]=0;e=c+50|0;d[e>>1]=0;e=c+56|0;d[e>>1]=1;e=f[a+72>>2]|0;d[e>>1]=0;h=e+2|0;d[h>>1]=0;h=d[a+6>>1]|0;i=e+4|0;d[i>>1]=h;e=e+6|0;d[e>>1]=0;e=c+52|0;d[e>>1]=0;c=c+58|0;d[c>>1]=1;g=f[g>>2]|0;d[g>>1]=0;c=g+2|0;d[c>>1]=0;c=d[a+6>>1]|0;e=g+4|0;d[e>>1]=c;g=g+6|0;d[g>>1]=0;f[a>>2]=8712;return}function le(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Y=0.0;W=u;u=u+240|0;e=(b[a+8>>0]|0)!=0;g=e?d:c;e=e?c:d;S=+n[g+116>>2]-+n[g+52>>2];T=+n[g+120>>2]-+n[g+56>>2];U=+n[g+124>>2]-+n[g+60>>2];V=+n[g+252>>2];if(S*S+T*T+U*U<V*V){X=1.0;u=W;return +X}H=+n[e+4>>2];I=+n[e+20>>2];J=+n[e+36>>2];K=+n[e+8>>2];L=+n[e+24>>2];M=+n[e+40>>2];N=+n[e+12>>2];O=+n[e+28>>2];P=+n[e+44>>2];i=-+n[e+52>>2];j=-+n[e+56>>2];k=-+n[e+60>>2];Q=+n[g+4>>2];R=+n[g+20>>2];S=+n[g+36>>2];T=+n[g+8>>2];U=+n[g+24>>2];V=+n[g+40>>2];o=+n[g+12>>2];p=+n[g+28>>2];q=+n[g+44>>2];w=+n[g+52>>2];v=+n[g+56>>2];t=+n[g+60>>2];r=H*i+I*j+J*k+(H*w+I*v+J*t);s=K*i+L*j+M*k+(K*w+L*v+M*t);t=N*i+O*j+P*k+(N*w+O*v+P*t);v=+n[g+68>>2];w=+n[g+84>>2];x=+n[g+100>>2];y=+n[g+72>>2];z=+n[g+88>>2];A=+n[g+104>>2];B=+n[g+76>>2];C=+n[g+92>>2];D=+n[g+108>>2];l=+n[g+116>>2];m=+n[g+120>>2];G=+n[g+124>>2];E=H*i+I*j+J*k+(H*l+I*m+J*G);F=K*i+L*j+M*k+(K*l+L*m+M*G);G=N*i+O*j+P*k+(N*l+O*m+P*G);e=f[e+192>>2]|0;if(((f[e+4>>2]|0)+-21|0)>>>0>=9){X=1.0;u=W;return +X}n[W+224>>2]=r;n[W+224+4>>2]=s;n[W+224+8>>2]=t;n[W+224+12>>2]=0.0;if(E<r){n[W+224>>2]=E;h=E}else h=r;if(F<s){n[W+224+4>>2]=F;i=F}else i=s;if(G<t){n[W+224+8>>2]=G;j=G}else j=t;n[W+208>>2]=r;n[W+208+4>>2]=s;n[W+208+8>>2]=t;n[W+208+12>>2]=0.0;if(r<E){n[W+208>>2]=E;k=E}else k=r;if(s<F){n[W+208+4>>2]=F;l=F}else l=s;if(t<G){n[W+208+8>>2]=G;m=G}else m=t;Y=+n[g+248>>2];n[W+224>>2]=h-Y;n[W+224+4>>2]=i-Y;n[W+224+8>>2]=j-Y;n[W+208>>2]=Y+k;n[W+208+4>>2]=Y+l;n[W+208+8>>2]=Y+m;f[W>>2]=3812;n[W+4>>2]=H*Q+I*R+J*S;n[W+8>>2]=H*T+I*U+J*V;n[W+12>>2]=H*o+I*p+J*q;n[W+16>>2]=0.0;n[W+20>>2]=K*Q+L*R+M*S;n[W+24>>2]=K*T+L*U+M*V;n[W+28>>2]=K*o+L*p+M*q;n[W+32>>2]=0.0;n[W+36>>2]=N*Q+O*R+P*S;n[W+40>>2]=N*T+O*U+P*V;n[W+44>>2]=N*o+O*p+P*q;n[W+48>>2]=0.0;n[W+52>>2]=r;n[W+56>>2]=s;n[W+60>>2]=t;n[W+64>>2]=0.0;n[W+68>>2]=H*v+I*w+J*x;n[W+72>>2]=H*y+I*z+J*A;n[W+76>>2]=H*B+I*C+J*D;n[W+80>>2]=0.0;n[W+84>>2]=K*v+L*w+M*x;n[W+88>>2]=K*y+L*z+M*A;n[W+92>>2]=K*B+L*C+M*D;n[W+96>>2]=0.0;n[W+100>>2]=N*v+O*w+P*x;n[W+104>>2]=N*y+O*z+P*A;n[W+108>>2]=N*B+O*C+P*D;n[W+112>>2]=0.0;n[W+116>>2]=E;n[W+120>>2]=F;n[W+124>>2]=G;n[W+128>>2]=0.0;n[W+196>>2]=Y;f[W+200>>2]=f[g+244>>2];if(e|0?(Yb[f[(f[e>>2]|0)+64>>2]&127](e,W,W+224|0,W+208|0),X=+n[W+200>>2],X<+n[g+244>>2]):0){n[g+244>>2]=X;Y=X;u=W;return +Y}Y=1.0;u=W;return +Y}function me(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Y=0.0;W=u;u=u+240|0;e=(b[a+8>>0]|0)!=0;g=e?d:c;e=e?c:d;S=+n[g+116>>2]-+n[g+52>>2];T=+n[g+120>>2]-+n[g+56>>2];U=+n[g+124>>2]-+n[g+60>>2];V=+n[g+252>>2];if(S*S+T*T+U*U<V*V){X=1.0;u=W;return +X}H=+n[e+4>>2];I=+n[e+20>>2];J=+n[e+36>>2];K=+n[e+8>>2];L=+n[e+24>>2];M=+n[e+40>>2];N=+n[e+12>>2];O=+n[e+28>>2];P=+n[e+44>>2];i=-+n[e+52>>2];j=-+n[e+56>>2];k=-+n[e+60>>2];Q=+n[g+4>>2];R=+n[g+20>>2];S=+n[g+36>>2];T=+n[g+8>>2];U=+n[g+24>>2];V=+n[g+40>>2];o=+n[g+12>>2];p=+n[g+28>>2];q=+n[g+44>>2];w=+n[g+52>>2];v=+n[g+56>>2];t=+n[g+60>>2];r=H*i+I*j+J*k+(H*w+I*v+J*t);s=K*i+L*j+M*k+(K*w+L*v+M*t);t=N*i+O*j+P*k+(N*w+O*v+P*t);v=+n[g+68>>2];w=+n[g+84>>2];x=+n[g+100>>2];y=+n[g+72>>2];z=+n[g+88>>2];A=+n[g+104>>2];B=+n[g+76>>2];C=+n[g+92>>2];D=+n[g+108>>2];l=+n[g+116>>2];m=+n[g+120>>2];G=+n[g+124>>2];E=H*i+I*j+J*k+(H*l+I*m+J*G);F=K*i+L*j+M*k+(K*l+L*m+M*G);G=N*i+O*j+P*k+(N*l+O*m+P*G);e=f[e+192>>2]|0;if(((f[e+4>>2]|0)+-21|0)>>>0>=9){X=1.0;u=W;return +X}n[W+224>>2]=r;n[W+224+4>>2]=s;n[W+224+8>>2]=t;n[W+224+12>>2]=0.0;if(E<r){n[W+224>>2]=E;h=E}else h=r;if(F<s){n[W+224+4>>2]=F;i=F}else i=s;if(G<t){n[W+224+8>>2]=G;j=G}else j=t;n[W+208>>2]=r;n[W+208+4>>2]=s;n[W+208+8>>2]=t;n[W+208+12>>2]=0.0;if(r<E){n[W+208>>2]=E;k=E}else k=r;if(s<F){n[W+208+4>>2]=F;l=F}else l=s;if(t<G){n[W+208+8>>2]=G;m=G}else m=t;Y=+n[g+248>>2];n[W+224>>2]=h-Y;n[W+224+4>>2]=i-Y;n[W+224+8>>2]=j-Y;n[W+208>>2]=Y+k;n[W+208+4>>2]=Y+l;n[W+208+8>>2]=Y+m;f[W>>2]=5728;n[W+4>>2]=H*Q+I*R+J*S;n[W+8>>2]=H*T+I*U+J*V;n[W+12>>2]=H*o+I*p+J*q;n[W+16>>2]=0.0;n[W+20>>2]=K*Q+L*R+M*S;n[W+24>>2]=K*T+L*U+M*V;n[W+28>>2]=K*o+L*p+M*q;n[W+32>>2]=0.0;n[W+36>>2]=N*Q+O*R+P*S;n[W+40>>2]=N*T+O*U+P*V;n[W+44>>2]=N*o+O*p+P*q;n[W+48>>2]=0.0;n[W+52>>2]=r;n[W+56>>2]=s;n[W+60>>2]=t;n[W+64>>2]=0.0;n[W+68>>2]=H*v+I*w+J*x;n[W+72>>2]=H*y+I*z+J*A;n[W+76>>2]=H*B+I*C+J*D;n[W+80>>2]=0.0;n[W+84>>2]=K*v+L*w+M*x;n[W+88>>2]=K*y+L*z+M*A;n[W+92>>2]=K*B+L*C+M*D;n[W+96>>2]=0.0;n[W+100>>2]=N*v+O*w+P*x;n[W+104>>2]=N*y+O*z+P*A;n[W+108>>2]=N*B+O*C+P*D;n[W+112>>2]=0.0;n[W+116>>2]=E;n[W+120>>2]=F;n[W+124>>2]=G;n[W+128>>2]=0.0;n[W+196>>2]=Y;f[W+200>>2]=f[g+244>>2];if(e|0?(Yb[f[(f[e>>2]|0)+64>>2]&127](e,W,W+224|0,W+208|0),X=+n[W+200>>2],X<+n[g+244>>2]):0){n[g+244>>2]=X;Y=X;u=W;return +Y}Y=1.0;u=W;return +Y}function ne(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0.0,l=0,m=0,o=0.0,p=0,q=0,r=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;o=+n[c>>2];h=(n[s>>2]=o,f[s>>2]|0);u=o<999999984306749440.0?h:1566444395;k=+n[c+4>>2];j=(n[s>>2]=k,f[s>>2]|0);v=k<999999984306749440.0?j:1566444395;y=+n[c+8>>2];m=(n[s>>2]=y,f[s>>2]|0);w=y<999999984306749440.0?m:1566444395;h=o>-999999984306749440.0?h:-581039253;j=k>-999999984306749440.0?j:-581039253;m=y>-999999984306749440.0?m:-581039253;y=+n[c+16>>2];t=y<(f[s>>2]=u,+n[s>>2]);i=(n[s>>2]=y,f[s>>2]|0);u=t?i:u;k=+n[c+20>>2];t=k<(f[s>>2]=v,+n[s>>2]);l=(n[s>>2]=k,f[s>>2]|0);v=t?l:v;o=+n[c+24>>2];t=o<(f[s>>2]=w,+n[s>>2]);p=(n[s>>2]=o,f[s>>2]|0);w=t?p:w;i=y>(f[s>>2]=h,+n[s>>2])?i:h;h=k>(f[s>>2]=j,+n[s>>2])?l:j;m=o>(f[s>>2]=m,+n[s>>2])?p:m;y=+n[c+32>>2];p=y<(f[s>>2]=u,+n[s>>2]);q=(n[s>>2]=y,f[s>>2]|0);k=+n[c+36>>2];r=k<(f[s>>2]=v,+n[s>>2]);t=(n[s>>2]=k,f[s>>2]|0);o=+n[c+40>>2];j=o<(f[s>>2]=w,+n[s>>2]);l=(n[s>>2]=o,f[s>>2]|0);i=y>(f[s>>2]=i,+n[s>>2])?q:i;h=k>(f[s>>2]=h,+n[s>>2])?t:h;m=o>(f[s>>2]=m,+n[s>>2])?l:m;G=(f[s>>2]=i,+n[s>>2]);H=(f[s>>2]=p?q:u,+n[s>>2]);C=(f[s>>2]=h,+n[s>>2]);D=(f[s>>2]=r?t:v,+n[s>>2]);k=(f[s>>2]=m,+n[s>>2]);z=(f[s>>2]=j?l:w,+n[s>>2]);m=f[a+8>>2]|0;F=+n[m+4>>2];B=+n[m+8>>2];o=+n[m+12>>2];E=+n[m+36>>2];A=+n[m+40>>2];y=+n[m+44>>2];m=~~(((G-H<2.0000000949949026e-03?H+-1.0000000474974513e-03:H)-F)*E)&65535&-2;p=~~(((C-D<2.0000000949949026e-03?D+-1.0000000474974513e-03:D)-B)*A)&65535&-2;q=~~(((k-z<2.0000000949949026e-03?z+-1.0000000474974513e-03:z)-o)*y)&65535&-2;r=~~(((G-H<2.0000000949949026e-03?G+1.0000000474974513e-03:G)-F)*E+1.0)&65535|1;t=~~(((C-D<2.0000000949949026e-03?C+1.0000000474974513e-03:C)-B)*A+1.0)&65535|1;c=~~(((k-z<2.0000000949949026e-03?k+1.0000000474974513e-03:k)-o)*y+1.0)&65535|1;l=f[a+4>>2]|0;h=f[l+4>>2]|0;if((h|0)==(f[l+8>>2]|0)?(x=h|0?h<<1:1,(h|0)<(x|0)):0){if(!x)j=0;else{f[6472]=(f[6472]|0)+1;h=sc((x<<4|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=h;h=f[l+4>>2]|0}if((h|0)>0){i=0;do{a=j+(i<<4)|0;w=(f[l+12>>2]|0)+(i<<4)|0;f[a>>2]=f[w>>2];f[a+4>>2]=f[w+4>>2];f[a+8>>2]=f[w+8>>2];f[a+12>>2]=f[w+12>>2];i=i+1|0}while((i|0)!=(h|0))}h=f[l+12>>2]|0;if(h|0){if(b[l+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[l+12>>2]=0}b[l+16>>0]=1;f[l+12>>2]=j;f[l+8>>2]=x;h=f[l+4>>2]|0}x=f[l+12>>2]|0;d[x+(h<<4)>>1]=m;d[x+(h<<4)+2>>1]=p;d[x+(h<<4)+4>>1]=q;d[x+(h<<4)+6>>1]=r;d[x+(h<<4)+8>>1]=t;d[x+(h<<4)+10>>1]=c;f[x+(h<<4)+12>>2]=e<<21|g;f[l+4>>2]=(f[l+4>>2]|0)+1;return}function oe(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=u;u=u+336|0;e=f[c+36>>2]|0;f[k+272+4>>2]=35;f[k+272+8>>2]=0;f[k+272+12>>2]=1065353216;f[k+272+16>>2]=1065353216;f[k+272+20>>2]=1065353216;n[k+272+24>>2]=0.0;f[k+272>>2]=3580;f[k+272+52>>2]=e;n[k+272+44>>2]=0.0;i=f[a+28>>2]|0;c=f[i+4>>2]|0;if(f[(f[i+8>>2]|0)+204>>2]&3|0?b[e+376>>0]|0:0){u=k;return}if((b[22664]|0)==0?fz(22664)|0:0){if((b[22672]|0)==0?fz(22672)|0:0){f[5768]=1065353216;f[5769]=0;f[5770]=0;f[5771]=0;f[5772]=0;f[5773]=1065353216;f[5774]=0;f[5775]=0;f[5776]=0;f[5777]=0;f[5778]=1065353216;n[5779]=0.0}f[5752]=f[5768];f[5753]=f[5769];f[5754]=f[5770];f[5755]=f[5771];f[5756]=f[5772];f[5757]=f[5773];f[5758]=f[5774];f[5759]=f[5775];f[5760]=f[5776];f[5761]=f[5777];f[5762]=f[5778];f[5763]=f[5779];f[5764]=0;f[5765]=0;f[5766]=0;f[5767]=0}d=f[(f[a+28>>2]|0)+12>>2]|0;f[k>>2]=1065353216;f[k+4>>2]=0;f[k+8>>2]=0;n[k+12>>2]=0.0;if(!(!(Ne(k+272|0,23008,c,d,k,k+216|0)|0)?!(Pc(k+272|0,23008,c,d,k,k+216|0,0)|0):0))g=12;if((g|0)==12?(f[k+4>>2]=0,f[k+4+4>>2]=0,f[k+4+8>>2]=0,f[k+4+12>>2]=0,f[k+4+16>>2]=0,f[k+4+20>>2]=0,b[k+152>>0]=0,f[k>>2]=3400,i=f[(f[a+28>>2]|0)+8>>2]|0,fd(a,k+216|0,e,0,0,0,(f[i+236>>2]&2|0)==0?0:i,i,k)|0):0){f[6472]=(f[6472]|0)+1;c=sc(235)|0;if(!c)i=0;else{f[(c+4+15&-16)+-4>>2]=c;i=c+4+15&-16}d=i+4|0;c=i+152|0;bl(d|0,0,212)|0;f[i>>2]=3400;e=k+4|0;g=d+100|0;do{f[d>>2]=f[e>>2];d=d+4|0;e=e+4|0}while((d|0)<(g|0));d=i+104|0;f[d>>2]=f[k+104>>2];f[d+4>>2]=f[k+104+4>>2];f[d+8>>2]=f[k+104+8>>2];f[d+12>>2]=f[k+104+12>>2];d=i+120|0;f[d>>2]=f[k+120>>2];f[d+4>>2]=f[k+120+4>>2];f[d+8>>2]=f[k+120+8>>2];f[d+12>>2]=f[k+120+12>>2];d=i+136|0;f[d>>2]=f[k+136>>2];f[d+4>>2]=f[k+136+4>>2];f[d+8>>2]=f[k+136+8>>2];f[d+12>>2]=f[k+136+12>>2];b[c>>0]=b[k+152>>0]|0;d=i+156|0;e=k+156|0;g=d+60|0;do{f[d>>2]=f[e>>2];d=d+4|0;e=e+4|0}while((d|0)<(g|0));g=f[a+24>>2]|0;h=i;c=f[g+852>>2]|0;if((c|0)==(f[g+856>>2]|0)?(j=c|0?c<<1:1,(c|0)<(j|0)):0){if(!j)e=0;else{f[6472]=(f[6472]|0)+1;c=sc((j<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=c;c=f[g+852>>2]|0}if((c|0)>0){d=0;do{f[e+(d<<2)>>2]=f[(f[g+860>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(c|0))}d=f[g+860>>2]|0;if(d){if(b[g+864>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[g+852>>2]|0}f[g+860>>2]=0}b[g+864>>0]=1;f[g+860>>2]=e;f[g+856>>2]=j}f[(f[g+860>>2]|0)+(c<<2)>>2]=h;f[g+852>>2]=c+1;c=f[a+24>>2]|0;if(!(f[(f[(f[a+28>>2]|0)+8>>2]|0)+204>>2]&3)){a=i+64|0;n[a>>2]=+n[c+340>>2]*+n[a>>2];c=c+352|0}else{a=i+64|0;n[a>>2]=+n[c+344>>2]*+n[a>>2];c=c+356|0}a=i+68|0;n[a>>2]=+n[c>>2]*+n[a>>2]}u=k;return}function pe(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0;if(!((c|0)!=0&(d|0)!=0))return;if((f[a+24>>2]|0)<128?(f[a+28>>2]|0)<128:0){f[6472]=(f[6472]|0)+1;g=sc(1043)|0;if(!g)i=0;else{f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}h=f[a+24>>2]|0;if((h|0)>0){g=0;do{k=(f[a+32>>2]|0)+(g<<3)|0;l=f[k+4>>2]|0;m=i+(g<<3)|0;f[m>>2]=f[k>>2];f[m+4>>2]=l;g=g+1|0}while((g|0)!=(h|0))}g=f[a+32>>2]|0;if(g|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=i;f[a+28>>2]=128}f[a+24>>2]=128;g=f[a+32>>2]|0;f[g>>2]=c;f[g+4>>2]=d;g=1;h=124;do{m=g+-1|0;i=f[a+32>>2]|0;k=f[i+(m<<3)>>2]|0;l=f[i+(m<<3)+4>>2]|0;if((m|0)>(h|0)){j=f[a+24>>2]|0;if((j|0)<(j<<1|0)?(f[a+28>>2]|0)<(j<<1|0):0){if(j){f[6472]=(f[6472]|0)+1;h=sc((j<<4|3)+16|0)|0;if(!h)d=0;else{f[(h+4+15&-16)+-4>>2]=h;d=h+4+15&-16}i=f[a+24>>2]|0;if((i|0)>0){h=0;do{p=(f[a+32>>2]|0)+(h<<3)|0;o=f[p+4>>2]|0;c=d+(h<<3)|0;f[c>>2]=f[p>>2];f[c+4>>2]=o;h=h+1|0}while((h|0)!=(i|0));c=d;i=d}else{c=d;i=d}}else{c=0;i=0}h=f[a+32>>2]|0;if(h|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=c;f[a+28>>2]=j<<1}f[a+24>>2]=j<<1;h=(j<<1)+-4|0}do if((k|0)==(l|0))if(!(f[k+40>>2]|0))g=m;else{o=f[k+36>>2]|0;f[i+(m<<3)>>2]=o;f[i+(m<<3)+4>>2]=o;o=f[k+40>>2]|0;p=g+1|0;m=f[a+32>>2]|0;f[m+(g<<3)>>2]=o;f[m+(g<<3)+4>>2]=o;m=f[k+40>>2]|0;o=f[a+32>>2]|0;f[o+(p<<3)>>2]=f[k+36>>2];f[o+(p<<3)+4>>2]=m;g=g+2|0}else if(((((+n[k>>2]<=+n[l+16>>2]?+n[k+16>>2]>=+n[l>>2]:0)?+n[k+4>>2]<=+n[l+20>>2]:0)?+n[k+20>>2]>=+n[l+4>>2]:0)?+n[k+8>>2]<=+n[l+24>>2]:0)?+n[k+24>>2]>=+n[l+8>>2]:0){c=(f[l+40>>2]|0)!=0;if(!(f[k+40>>2]|0))if(c){o=f[l+36>>2]|0;f[i+(m<<3)>>2]=k;f[i+(m<<3)+4>>2]=o;o=f[l+40>>2]|0;p=f[a+32>>2]|0;f[p+(g<<3)>>2]=k;f[p+(g<<3)+4>>2]=o;g=g+1|0;break}else{Vb[f[(f[e>>2]|0)+8>>2]&127](e,k,l);g=m;break}else{d=f[k+36>>2]|0;if(c){p=f[l+36>>2]|0;f[i+(m<<3)>>2]=d;f[i+(m<<3)+4>>2]=p;p=f[l+36>>2]|0;m=g+1|0;j=f[a+32>>2]|0;f[j+(g<<3)>>2]=f[k+40>>2];f[j+(g<<3)+4>>2]=p;j=f[l+40>>2]|0;p=g+2|0;o=f[a+32>>2]|0;f[o+(m<<3)>>2]=f[k+36>>2];f[o+(m<<3)+4>>2]=j;m=f[l+40>>2]|0;o=f[a+32>>2]|0;f[o+(p<<3)>>2]=f[k+40>>2];f[o+(p<<3)+4>>2]=m;g=g+3|0;break}else{f[i+(m<<3)>>2]=d;f[i+(m<<3)+4>>2]=l;p=f[a+32>>2]|0;f[p+(g<<3)>>2]=f[k+40>>2];f[p+(g<<3)+4>>2]=l;g=g+1|0;break}}}else g=m;while(0)}while((g|0)!=0);return}function qe(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;g=u;u=u+16|0;e=Qs()|0;if((b[22752]|0)==0?fz(22752)|0:0){f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;qg(23416,0.0,0,0,g)}f[5905]=f[5905]|1;n[5940]=0.0;x=+n[5950]*0.0;D=+n[5951]*0.0;n[5945]=+n[5949]*0.0;n[5946]=x;n[5947]=D;n[5948]=0.0;f[5953]=0;f[5954]=0;f[5955]=0;f[5956]=0;D=+n[5942]*0.0;x=+n[5943]*0.0;n[5994]=+n[5941]*0.0;n[5995]=D;n[5996]=x;n[5997]=0.0;f[e+4>>2]=7;f[e+8>>2]=-1;f[e+12>>2]=-1;n[e+16>>2]=3402823466385288598117041.0e14;b[e+20>>0]=1;b[e+21>>0]=0;f[e+24>>2]=-1;f[e+28>>2]=23416;f[e+32>>2]=a;n[e+36>>2]=0.0;n[e+40>>2]=.30000001192092896;f[e+44>>2]=0;f[e>>2]=4792;b[e+48>>0]=0;f[e+116>>2]=f[c>>2];f[e+116+4>>2]=f[c+4>>2];f[e+116+8>>2]=f[c+8>>2];f[e+116+12>>2]=f[c+12>>2];f[e+132>>2]=f[c+16>>2];f[e+132+4>>2]=f[c+16+4>>2];f[e+132+8>>2]=f[c+16+8>>2];f[e+132+12>>2]=f[c+16+12>>2];f[e+148>>2]=f[c+32>>2];f[e+148+4>>2]=f[c+32+4>>2];f[e+148+8>>2]=f[c+32+8>>2];f[e+148+12>>2]=f[c+32+12>>2];f[e+164>>2]=f[c+48>>2];f[e+164+4>>2]=f[c+48+4>>2];f[e+164+8>>2]=f[c+48+8>>2];f[e+164+12>>2]=f[c+48+12>>2];b[e+180>>0]=d&1;x=+n[e+116>>2];D=+n[a+4>>2];w=+n[e+132>>2];C=+n[a+8>>2];v=+n[e+148>>2];B=+n[a+12>>2];t=+n[e+120>>2];s=+n[e+136>>2];r=+n[e+152>>2];q=+n[e+124>>2];o=+n[e+140>>2];l=+n[e+156>>2];A=+n[a+20>>2];z=+n[a+24>>2];y=+n[a+28>>2];p=+n[a+36>>2];m=+n[a+40>>2];k=+n[a+44>>2];F=+n[e+164>>2];E=+n[e+168>>2];h=+n[e+172>>2];j=+n[a+52>>2]+(D*F+C*E+B*h);i=A*F+z*E+y*h+ +n[a+56>>2];h=p*F+m*E+k*h+ +n[a+60>>2];n[e+52>>2]=x*D+w*C+v*B;n[e+56>>2]=D*t+C*s+B*r;n[e+60>>2]=D*q+C*o+B*l;n[e+64>>2]=0.0;n[e+68>>2]=x*A+w*z+v*y;n[e+72>>2]=t*A+s*z+r*y;n[e+76>>2]=q*A+o*z+l*y;n[e+80>>2]=0.0;n[e+84>>2]=x*p+w*m+v*k;n[e+88>>2]=t*p+s*m+r*k;n[e+92>>2]=q*p+o*m+l*k;n[e+96>>2]=0.0;n[e+100>>2]=j;n[e+104>>2]=i;n[e+108>>2]=h;n[e+112>>2]=0.0;n[e+184>>2]=1.0;n[e+188>>2]=-1.0;n[e+192>>2]=0.0;n[e+196>>2]=0.0;n[e+200>>2]=1.0;n[e+204>>2]=.699999988079071;n[e+208>>2]=0.0;n[e+212>>2]=0.0;n[e+216>>2]=1.0;n[e+220>>2]=.699999988079071;n[e+224>>2]=0.0;n[e+228>>2]=0.0;n[e+264>>2]=1.0;n[e+268>>2]=.699999988079071;n[e+272>>2]=1.0;n[e+276>>2]=0.0;n[e+280>>2]=1.0;n[e+284>>2]=.699999988079071;n[e+288>>2]=1.0;n[e+292>>2]=0.0;n[e+232>>2]=1.0;n[e+236>>2]=.699999988079071;n[e+240>>2]=1.0;n[e+244>>2]=0.0;n[e+248>>2]=1.0;n[e+252>>2]=.699999988079071;n[e+256>>2]=1.0;n[e+260>>2]=0.0;b[e+1096>>0]=0;n[e+1116>>2]=0.0;n[e+1120>>2]=0.0;n[e+1124>>2]=0.0;f[e+300>>2]=0;f[e+1100>>2]=0;f[e+1100+4>>2]=0;f[e+1100+8>>2]=0;b[e+1100+12>>0]=0;b[e+49>>0]=1;bd(e,(f[e+28>>2]|0)+4|0,(f[e+32>>2]|0)+4|0);u=g;return e|0}function re(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=0;do{k=l;l=l+1|0;m=(l|0)==3;j=f[b+((m?0:l)<<2)>>2]|0;k=f[b+(((k+2|0)%3|0)<<2)>>2]|0;d=f[c>>2]|0;e=f[c+4>>2]|0;if(!((d|0)==(k|0)&(e|0)==(j|0)))if(!((d|0)==(j|0)&(e|0)==(k|0))){g=f[c+8>>2]|0;if(!((e|0)==(k|0)&(g|0)==(j|0)))if(!((e|0)==(j|0)&(g|0)==(k|0)))if((g|0)!=(k|0)|(d|0)==(j|0)^1)d=(g|0)!=(j|0)|(d|0)==(k|0)^1?9624:c+12+4|0;else{d=1;n=3}else d=c+12|0;else{d=0;n=3}}else d=c+12+8|0;else{d=2;n=3}if((n|0)==3){n=0;d=c+12+(d<<2)|0}i=f[d>>2]|0;d=f[b>>2]|0;e=f[b+4>>2]|0;if(!((d|0)==(j|0)&(e|0)==(k|0)))if(!((d|0)==(k|0)&(e|0)==(j|0))){g=f[b+8>>2]|0;if(!((e|0)==(j|0)&(g|0)==(k|0)))if(!((e|0)==(k|0)&(g|0)==(j|0)))if((g|0)!=(j|0)|(d|0)==(k|0)^1)d=(g|0)!=(k|0)|(d|0)==(j|0)^1?9624:b+12+4|0;else{d=1;n=10}else d=b+12|0;else{d=0;n=10}}else d=b+12+8|0;else{d=2;n=10}if((n|0)==10){n=0;d=b+12+(d<<2)|0}h=f[a+(f[d>>2]<<2)>>2]|0;d=f[h>>2]|0;e=f[h+4>>2]|0;do if(!((d|0)==(k|0)&(e|0)==(j|0))){if((d|0)==(j|0)?(e|0)==(k|0):0){d=h+12+8|0;break}g=f[h+8>>2]|0;if(!((e|0)==(k|0)&(g|0)==(j|0)))if(!((e|0)==(j|0)&(g|0)==(k|0)))if((g|0)!=(k|0)|(d|0)==(j|0)^1){if((g|0)==(j|0)?(d|0)==(k|0):0){d=h+12+4|0;break}d=9624}else{d=1;n=17}else d=h+12|0;else{d=0;n=17}}else{d=2;n=17}while(0);if((n|0)==17){n=0;d=h+12+(d<<2)|0}f[d>>2]=i;d=f[b>>2]|0;e=f[b+4>>2]|0;if(!((d|0)==(j|0)&(e|0)==(k|0)))if(!((d|0)==(k|0)&(e|0)==(j|0))){g=f[b+8>>2]|0;if(!((e|0)==(j|0)&(g|0)==(k|0)))if(!((e|0)==(k|0)&(g|0)==(j|0)))if((g|0)!=(j|0)|(d|0)==(k|0)^1)d=(g|0)!=(k|0)|(d|0)==(j|0)^1?9624:b+12+4|0;else{d=1;n=27}else d=b+12|0;else{d=0;n=27}}else d=b+12+8|0;else{d=2;n=27}if((n|0)==27){n=0;d=b+12+(d<<2)|0}i=f[d>>2]|0;d=f[c>>2]|0;e=f[c+4>>2]|0;if(!((d|0)==(k|0)&(e|0)==(j|0)))if(!((d|0)==(j|0)&(e|0)==(k|0))){g=f[c+8>>2]|0;if(!((e|0)==(k|0)&(g|0)==(j|0)))if(!((e|0)==(j|0)&(g|0)==(k|0)))if((g|0)!=(k|0)|(d|0)==(j|0)^1)d=(g|0)!=(j|0)|(d|0)==(k|0)^1?9624:c+12+4|0;else{d=1;n=34}else d=c+12|0;else{d=0;n=34}}else d=c+12+8|0;else{d=2;n=34}if((n|0)==34){n=0;d=c+12+(d<<2)|0}h=f[a+(f[d>>2]<<2)>>2]|0;e=f[h>>2]|0;g=f[h+4>>2]|0;do if(!((e|0)==(j|0)&(g|0)==(k|0))){if((e|0)==(k|0)?(g|0)==(j|0):0){d=h+12+8|0;break}d=f[h+8>>2]|0;if(!((g|0)==(j|0)&(d|0)==(k|0)))if(!((g|0)==(k|0)&(d|0)==(j|0)))if((d|0)!=(j|0)|(e|0)==(k|0)^1){if((d|0)==(k|0)?(e|0)==(j|0):0){d=h+12+4|0;break}d=9624}else{d=1;n=41}else d=h+12|0;else{d=0;n=41}}else{d=2;n=41}while(0);if((n|0)==41){n=0;d=h+12+(d<<2)|0}f[d>>2]=i}while(!m);return}function se(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0;o=f[a+92>>2]|0;if(!(Bb[f[(f[o>>2]|0)+56>>2]&127](o)|0))return;o=f[a+92>>2]|0;o=Bb[f[(f[o>>2]|0)+28>>2]&127](o)|0;d=f[o+4>>2]|0;if((d|0)>1){ue(o,0,d+-1|0);i=f[o+4>>2]|0}else i=d;m=f[a+104>>2]|0;d=i-m|0;if((m|0)<0){if((f[o+8>>2]|0)<(d|0)){if(!d){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc((d<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[o+4>>2]|0}if((h|0)>0){g=0;do{m=f[o+12>>2]|0;f[e+(g<<4)>>2]=f[m+(g<<4)>>2];f[e+(g<<4)+4>>2]=f[m+(g<<4)+4>>2];f[e+(g<<4)+8>>2]=f[m+(g<<4)+8>>2];f[e+(g<<4)+12>>2]=f[m+(g<<4)+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[o+12>>2]|0;if(g|0){if(b[o+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[o+12>>2]=0}b[o+16>>0]=1;f[o+12>>2]=e;f[o+8>>2]=d;g=o+12|0}else g=o+12|0;e=i;do{m=(f[g>>2]|0)+(e<<4)|0;e=e+1|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0}while((e|0)!=(d|0))}f[o+4>>2]=d;f[a+104>>2]=0;if((d|0)>0){l=0;m=0;e=0;g=0;do{k=f[o+12>>2]|0;i=k+(l<<4)|0;p=m;m=f[i>>2]|0;k=k+(l<<4)+4|0;h=f[k>>2]|0;if(!((m|0)==(p|0)&(h|0)==(e|0))){p=m+54|0;e=m+48|0;if((((((j[p>>1]|0)>=(j[h+48>>1]|0)?(j[h+54>>1]|0)>=(j[e>>1]|0):0)?(j[p+2>>1]|0)>=(j[h+48+2>>1]|0):0)?(j[h+54+2>>1]|0)>=(j[e+2>>1]|0):0)?(j[p+4>>1]|0)>=(j[h+52>>1]|0):0)?(j[h+54+4>>1]|0)>=(j[m+52>>1]|0):0)e=h;else{d=h;n=29}}else{d=e;n=29}if((n|0)==29){n=0;g=f[a+92>>2]|0;Vb[f[(f[g>>2]|0)+32>>2]&127](g,i,c);f[i>>2]=0;f[k>>2]=0;g=(f[a+104>>2]|0)+1|0;f[a+104>>2]=g;f[6200]=(f[6200]|0)+-1;e=d;d=f[o+4>>2]|0}l=l+1|0}while((l|0)<(d|0));if((d|0)>1){ue(o,0,d+-1|0);g=f[a+104>>2]|0;e=f[o+4>>2]|0}else e=d;d=e-g|0;if((g|0)<0){if((f[o+8>>2]|0)<(d|0)){if(!d){g=0;i=e}else{f[6472]=(f[6472]|0)+1;g=sc((d<<4|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=f[o+4>>2]|0}if((i|0)>0){h=0;do{p=f[o+12>>2]|0;f[g+(h<<4)>>2]=f[p+(h<<4)>>2];f[g+(h<<4)+4>>2]=f[p+(h<<4)+4>>2];f[g+(h<<4)+8>>2]=f[p+(h<<4)+8>>2];f[g+(h<<4)+12>>2]=f[p+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(i|0))}h=f[o+12>>2]|0;if(h|0){if(b[o+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[o+12>>2]=0}b[o+16>>0]=1;f[o+12>>2]=g;f[o+8>>2]=d}do{p=(f[o+12>>2]|0)+(e<<4)|0;e=e+1|0;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0}while((e|0)!=(d|0))}}f[o+4>>2]=d;f[a+104>>2]=0;return}function te(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=u;u=u+80|0;f[a+68>>2]=(f[a+68>>2]|0)+1;e=f[a+64>>2]|0;if(e|0){c=f[(f[a+24>>2]|0)+(b*80|0)+76>>2]|0;zg(e,c)|0;d=f[e+4>>2]|0;if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[e+4>>2]=c;f[e+12>>2]=(f[e+12>>2]|0)+-1}e=(f[a+16>>2]|0)+-1|0;d=f[a+24>>2]|0;f[g>>2]=f[d+(b*80|0)>>2];f[g+4>>2]=f[d+(b*80|0)+4>>2];f[g+8>>2]=f[d+(b*80|0)+8>>2];f[g+12>>2]=f[d+(b*80|0)+12>>2];f[g+16>>2]=f[d+(b*80|0)+16>>2];f[g+16+4>>2]=f[d+(b*80|0)+16+4>>2];f[g+16+8>>2]=f[d+(b*80|0)+16+8>>2];f[g+16+12>>2]=f[d+(b*80|0)+16+12>>2];f[g+32>>2]=f[d+(b*80|0)+32>>2];f[g+32+4>>2]=f[d+(b*80|0)+32+4>>2];f[g+32+8>>2]=f[d+(b*80|0)+32+8>>2];f[g+32+12>>2]=f[d+(b*80|0)+32+12>>2];f[g+48>>2]=f[d+(b*80|0)+48>>2];f[g+48+4>>2]=f[d+(b*80|0)+48+4>>2];f[g+48+8>>2]=f[d+(b*80|0)+48+8>>2];f[g+48+12>>2]=f[d+(b*80|0)+48+12>>2];f[g+64>>2]=f[d+(b*80|0)+64>>2];f[g+64+4>>2]=f[d+(b*80|0)+64+4>>2];f[g+64+8>>2]=f[d+(b*80|0)+64+8>>2];f[g+64+12>>2]=f[d+(b*80|0)+64+12>>2];f[d+(b*80|0)>>2]=f[d+(e*80|0)>>2];f[d+(b*80|0)+4>>2]=f[d+(e*80|0)+4>>2];f[d+(b*80|0)+8>>2]=f[d+(e*80|0)+8>>2];f[d+(b*80|0)+12>>2]=f[d+(e*80|0)+12>>2];f[d+(b*80|0)+16>>2]=f[d+(e*80|0)+16>>2];f[d+(b*80|0)+16+4>>2]=f[d+(e*80|0)+16+4>>2];f[d+(b*80|0)+16+8>>2]=f[d+(e*80|0)+16+8>>2];f[d+(b*80|0)+16+12>>2]=f[d+(e*80|0)+16+12>>2];f[d+(b*80|0)+32>>2]=f[d+(e*80|0)+32>>2];f[d+(b*80|0)+32+4>>2]=f[d+(e*80|0)+32+4>>2];f[d+(b*80|0)+32+8>>2]=f[d+(e*80|0)+32+8>>2];f[d+(b*80|0)+32+12>>2]=f[d+(e*80|0)+32+12>>2];f[d+(b*80|0)+48>>2]=f[d+(e*80|0)+48>>2];f[d+(b*80|0)+48+4>>2]=f[d+(e*80|0)+48+4>>2];f[d+(b*80|0)+48+8>>2]=f[d+(e*80|0)+48+8>>2];f[d+(b*80|0)+48+12>>2]=f[d+(e*80|0)+48+12>>2];f[d+(b*80|0)+64>>2]=f[d+(e*80|0)+64>>2];f[d+(b*80|0)+64+4>>2]=f[d+(e*80|0)+64+4>>2];f[d+(b*80|0)+64+8>>2]=f[d+(e*80|0)+64+8>>2];f[d+(b*80|0)+64+12>>2]=f[d+(e*80|0)+64+12>>2];d=f[a+24>>2]|0;f[d+(e*80|0)>>2]=f[g>>2];f[d+(e*80|0)+4>>2]=f[g+4>>2];f[d+(e*80|0)+8>>2]=f[g+8>>2];f[d+(e*80|0)+12>>2]=f[g+12>>2];f[d+(e*80|0)+16>>2]=f[g+16>>2];f[d+(e*80|0)+16+4>>2]=f[g+16+4>>2];f[d+(e*80|0)+16+8>>2]=f[g+16+8>>2];f[d+(e*80|0)+16+12>>2]=f[g+16+12>>2];f[d+(e*80|0)+32>>2]=f[g+32>>2];f[d+(e*80|0)+32+4>>2]=f[g+32+4>>2];f[d+(e*80|0)+32+8>>2]=f[g+32+8>>2];f[d+(e*80|0)+32+12>>2]=f[g+32+12>>2];f[d+(e*80|0)+48>>2]=f[g+48>>2];f[d+(e*80|0)+48+4>>2]=f[g+48+4>>2];f[d+(e*80|0)+48+8>>2]=f[g+48+8>>2];f[d+(e*80|0)+48+12>>2]=f[g+48+12>>2];f[d+(e*80|0)+64>>2]=f[g+64>>2];f[d+(e*80|0)+64+4>>2]=f[g+64+4>>2];f[d+(e*80|0)+64+8>>2]=f[g+64+8>>2];f[d+(e*80|0)+64+12>>2]=f[g+64+12>>2];if(!(f[a+64>>2]|0)){e=f[a+16>>2]|0;e=e+-1|0;f[a+16>>2]=e;u=g;return}f[(f[(f[a+24>>2]|0)+(b*80|0)+76>>2]|0)+36>>2]=b;e=f[a+16>>2]|0;e=e+-1|0;f[a+16>>2]=e;u=g;return}function ue(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;while(1){m=f[a+12>>2]|0;o=(b+c|0)/2|0;p=f[m+(o<<4)>>2]|0;n=f[m+(o<<4)+4>>2]|0;o=f[m+(o<<4)+8>>2]|0;d=c;e=b;while(1){a:do if(!p)while(1){j=f[m+(e<<4)>>2]|0;if(!j)g=-1;else g=f[j+12>>2]|0;k=f[m+(e<<4)+4>>2]|0;if(!k)h=-1;else h=f[k+12>>2]|0;if(!n)i=-1;else i=f[n+12>>2]|0;do if((g|0)<=-1){g=(h|0)>(i|0);if(g|(j|0)==0^1)if((j|0)==0&g)break;else break a;if((k|0)!=(n|0))break a;if((f[m+(e<<4)+8>>2]|0)>>>0<=o>>>0)break a}while(0);e=e+1|0}else{l=f[p+12>>2]|0;while(1){j=f[m+(e<<4)>>2]|0;if(!j)g=-1;else g=f[j+12>>2]|0;k=f[m+(e<<4)+4>>2]|0;if(!k)h=-1;else h=f[k+12>>2]|0;if(!n)i=-1;else i=f[n+12>>2]|0;do if((g|0)<=(l|0)){g=(h|0)>(i|0);if(g|(j|0)==(p|0)^1)if((j|0)==(p|0)&g)break;else break a;if((k|0)!=(n|0))break a;if((f[m+(e<<4)+8>>2]|0)>>>0<=o>>>0)break a}while(0);e=e+1|0}}while(0);b:do if(!p)while(1){j=f[m+(d<<4)>>2]|0;if(!j)g=-1;else g=f[j+12>>2]|0;if(!n)h=-1;else h=f[n+12>>2]|0;k=f[m+(d<<4)+4>>2]|0;if(!k)i=-1;else i=f[k+12>>2]|0;do if((g|0)>=-1){g=(h|0)>(i|0);if(g|(j|0)==0^1)if((j|0)==0&g)break;else break b;if((n|0)!=(k|0))break b;if((f[m+(d<<4)+8>>2]|0)>>>0>=o>>>0)break b}while(0);d=d+-1|0}else{l=f[p+12>>2]|0;while(1){j=f[m+(d<<4)>>2]|0;if(!j)h=-1;else h=f[j+12>>2]|0;if(!n)i=-1;else i=f[n+12>>2]|0;k=f[m+(d<<4)+4>>2]|0;if(!k)g=-1;else g=f[k+12>>2]|0;do if((l|0)<=(h|0)){g=(i|0)>(g|0);if(g|(p|0)==(j|0)^1)if((p|0)==(j|0)&g)break;else break b;if((n|0)!=(k|0))break b;if((f[m+(d<<4)+8>>2]|0)>>>0>=o>>>0)break b}while(0);d=d+-1|0}}while(0);if((e|0)<=(d|0)){h=m+(e<<4)|0;i=f[h>>2]|0;j=f[m+(e<<4)+4>>2]|0;k=f[m+(e<<4)+8>>2]|0;l=f[m+(e<<4)+12>>2]|0;m=m+(d<<4)|0;f[h>>2]=f[m>>2];f[h+4>>2]=f[m+4>>2];f[h+8>>2]=f[m+8>>2];f[h+12>>2]=f[m+12>>2];m=f[a+12>>2]|0;f[m+(d<<4)>>2]=i;f[m+(d<<4)+4>>2]=j;f[m+(d<<4)+8>>2]=k;f[m+(d<<4)+12>>2]=l;d=d+-1|0;e=e+1|0}if((e|0)>(d|0))break;m=f[a+12>>2]|0}if((d|0)>(b|0))ue(a,b,d);if((e|0)<(c|0))b=e;else break}return}function ve(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;f[b+16>>2]=f[c>>2];f[b+16+4>>2]=f[c+4>>2];f[b+16+8>>2]=f[c+8>>2];f[b+16+12>>2]=f[c+12>>2];f[b+32>>2]=f[e>>2];f[b+32+4>>2]=f[e+4>>2];f[b+32+8>>2]=f[e+8>>2];f[b+32+12>>2]=f[e+12>>2];D=f[a+60>>2]|0;E=f[b+12>>2]&65535;t=+n[a+8>>2];v=+n[a+12>>2];x=+n[a+16>>2];u=+n[a+40>>2];m=(+n[c>>2]-t)*u;w=+n[a+44>>2];o=(+n[c+4>>2]-v)*w;y=+n[a+48>>2];p=(+n[c+8>>2]-x)*y;if(!(m<=0.0)){h=d[a+6>>1]|0;if(!(m>=+(h&65535))){i=d[a+4>>1]|0;h=~~m&65535}else{i=h;h=d[a+4>>1]|0}z=i&h&65535}else z=0;C=z&65535;if(!(o<=0.0)){h=d[a+6>>1]|0;if(!(o>=+(h&65535))){i=d[a+4>>1]|0;h=~~o&65535}else{i=h;h=d[a+4>>1]|0}A=i&h}else A=0;if(!(p<=0.0)){h=d[a+6>>1]|0;if(!(p>=+(h&65535))){i=d[a+4>>1]|0;h=~~p&65535}else{i=h;h=d[a+4>>1]|0}B=i&h}else B=0;m=(+n[e>>2]-t)*u;o=(+n[e+4>>2]-v)*w;p=(+n[e+8>>2]-x)*y;if(!(m<=0.0)){h=d[a+6>>1]|0;if(!(m>=+(h&65535))){i=d[a+4>>1]|0;h=~~m&65535}else{i=h;h=d[a+4>>1]|0}q=i&h|1}else q=1;if(!(o<=0.0)){h=d[a+6>>1]|0;if(!(o>=+(h&65535))){i=d[a+4>>1]|0;h=~~o&65535}else{i=h;h=d[a+4>>1]|0}r=i&h|1}else r=1;if(!(p<=0.0)){h=d[a+6>>1]|0;if(!(p>=+(h&65535))){i=d[a+4>>1]|0;h=~~p&65535}else{i=h;h=d[a+4>>1]|0}s=i&h|1}else s=1;k=d[D+(E<<6)+48>>1]|0;l=d[D+(E<<6)+54>>1]|0;F=f[a+68>>2]|0;h=z-(j[F+((k&65535)<<2)>>1]|0)|0;i=(q&65535)-(j[F+((l&65535)<<2)>>1]|0)|0;d[F+((k&65535)<<2)>>1]=C;d[F+((l&65535)<<2)>>1]=q;if((h|0)<0)yh(a,0,k);if((i|0)>0)sh(a,0,l);if((h|0)>0)vh(a,0,k,g);if((i|0)<0)rh(a,0,l,g);h=d[D+(E<<6)+50>>1]|0;i=d[D+(E<<6)+56>>1]|0;F=f[a+72>>2]|0;k=(A&65535)-(j[F+((h&65535)<<2)>>1]|0)|0;l=(r&65535)-(j[F+((i&65535)<<2)>>1]|0)|0;d[F+((h&65535)<<2)>>1]=A;d[F+((i&65535)<<2)>>1]=r;if((k|0)<0)yh(a,1,h);if((l|0)>0)sh(a,1,i);if((k|0)>0)vh(a,1,h,g);if((l|0)<0)rh(a,1,i,g);l=d[D+(E<<6)+52>>1]|0;h=d[D+(E<<6)+58>>1]|0;F=f[a+76>>2]|0;i=(B&65535)-(j[F+((l&65535)<<2)>>1]|0)|0;k=(s&65535)-(j[F+((h&65535)<<2)>>1]|0)|0;d[F+((l&65535)<<2)>>1]=B;d[F+((h&65535)<<2)>>1]=s;if((i|0)<0)yh(a,2,l);if((k|0)>0)sh(a,2,h);if((i|0)>0)vh(a,2,l,g);if((k|0)<0)rh(a,2,h,g);h=f[a+108>>2]|0;if(!h)return;ac[f[(f[h>>2]|0)+16>>2]&31](h,f[b+60>>2]|0,c,e,g);return}function we(a,b,c,e,g,h,i,k,l){a=a|0;b=b|0;c=c|0;e=+e;g=+g;h=+h;i=i|0;k=k|0;l=l|0;var m=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0,V=0,W=0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0;W=u;u=u+32|0;T=+n[c>>2];E=+n[c+4>>2];K=+n[c+8>>2];M=1.0/+L(+((e-T)*(e-T)+(g-E)*(g-E)+(h-K)*(h-K)));Q=(e-T)*M==0.0?999999984306749440.0:1.0/((e-T)*M);R=(g-E)*M==0.0?999999984306749440.0:1.0/((g-E)*M);S=(h-K)*M==0.0?999999984306749440.0:1.0/((h-K)*M);fa=(T>e?e:T)+ +n[i>>2];ea=(E>g?g:E)+ +n[i+4>>2];da=(K>h?h:K)+ +n[i+8>>2];ba=(T<e?e:T)+ +n[k>>2];Z=(E<g?g:E)+ +n[k+4>>2];q=(K<h?h:K)+ +n[k+8>>2];aa=+n[a+4>>2];fa=fa<aa?aa:fa;Y=+n[a+8>>2];ea=ea<Y?Y:ea;r=+n[a+12>>2];da=da<r?r:da;ca=+n[a+20>>2];_=+n[a+24>>2];p=+n[a+28>>2];$=+n[a+36>>2];X=+n[a+40>>2];s=+n[a+44>>2];U=~~(((ca<fa?ca:fa)-aa)*$)&65535&-2;F=~~(((_<ea?_:ea)-Y)*X)&65535&-2;G=~~(((p<da?p:da)-r)*s)&65535&-2;ba=ba<aa?aa:ba;Z=Z<Y?Y:Z;q=q<r?r:q;H=~~(((ca<ba?ca:ba)-aa)*$+1.0)&65535|1;I=~~(((_<Z?_:Z)-Y)*X+1.0)&65535|1;J=~~(((p<q?p:q)-r)*s+1.0)&65535|1;if((l|0)>0){B=0;m=0;D=f[a+136>>2]|0;while(1){m=m+1|0;o=D+6|0;t=d[D>>1]|0;v=D+10|0;w=d[D+4>>1]|0;x=D+8|0;y=d[D+2>>1]|0;z=D+12|0;A=(f[z>>2]|0)>-1;do if(((H&65535)>=(t&65535)?(U&65535)<=(j[o>>1]|0):0)&(G&65535)<=(j[v>>1]|0)&(J&65535)>=(w&65535)&(F&65535)<=(j[x>>1]|0)&(I&65535)>=(y&65535)){ba=+n[a+36>>2];da=+n[a+40>>2];fa=+n[a+44>>2];ca=+n[a+4>>2];ea=+n[a+8>>2];r=+n[a+12>>2];n[W+12>>2]=0.0;s=+(j[o>>1]|0)/ba+ca;p=+(j[x>>1]|0)/da+ea;q=+(j[v>>1]|0)/fa+r;n[W+28>>2]=0.0;n[W>>2]=+(t&65535)/ba+ca-+n[k>>2];n[W+4>>2]=+(y&65535)/da+ea-+n[k+4>>2];n[W+8>>2]=+(w&65535)/fa+r-+n[k+8>>2];n[W+16>>2]=s-+n[i>>2];n[W+20>>2]=p-+n[i+4>>2];n[W+24>>2]=q-+n[i+8>>2];q=+n[c>>2];p=Q*(+n[W+((Q<0.0&1)<<4)>>2]-q);q=Q*(+n[W+((Q<0.0^1)<<4)>>2]-q);s=+n[c+4>>2];r=R*(+n[W+((R<0.0&1)<<4)+4>>2]-s);s=R*(+n[W+((R<0.0^1)<<4)+4>>2]-s);if(!(r>q|p>s)?(N=r>p?r:p,C=s<q?s:q,P=+n[c+8>>2],O=S*(+n[W+((S<0.0&1)<<4)+8>>2]-P),P=S*(+n[W+((S<0.0^1)<<4)+8>>2]-P),!(O>C|N>P)):0){o=(P<C?P:C)>0.0?(O>N?O:N)<(h-K)*(h-K)*M+((e-T)*(e-T)*M+(g-E)*(g-E)*M):0;if(!(A&o)){V=9;break}o=f[z>>2]|0;Vb[f[(f[b>>2]|0)+8>>2]&127](b,o>>21,o&2097151);o=1;break}o=0;V=9}else{o=0;V=9}while(0);if((V|0)==9){V=0;if(A|o)o=1;else o=0-(f[z>>2]|0)|0}B=o+B|0;if((B|0)>=(l|0))break;else D=D+(o<<4)|0}}else m=0;if((f[6204]|0)>=(m|0)){u=W;return}f[6204]=m;u=W;return}function xe(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=+h;i=i|0;j=j|0;k=k|0;var l=0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0;E=u;u=u+32|0;if(!c){u=E;return}l=f[a+44>>2]|0;if((l|0)<128){if((f[a+48>>2]|0)<128){f[6472]=(f[6472]|0)+1;m=sc(531)|0;if(!m)p=0;else{f[(m+4+15&-16)+-4>>2]=m;p=m+4+15&-16}o=f[a+44>>2]|0;if((o|0)>0){m=0;do{f[p+(m<<2)>>2]=f[(f[a+52>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(o|0))}m=f[a+52>>2]|0;if(m|0){if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[m+-4>>2]|0)}f[a+52>>2]=0}b[a+56>>0]=1;f[a+52>>2]=p;f[a+48>>2]=128;m=a+52|0}else m=a+52|0;do{f[(f[m>>2]|0)+(l<<2)>>2]=0;l=l+1|0}while((l|0)!=128);z=a+48|0}else{m=a+52|0;z=a+48|0}f[a+44>>2]=128;f[f[m>>2]>>2]=c;o=1;l=126;do{x=o+-1|0;p=f[m>>2]|0;y=f[p+(x<<2)>>2]|0;v=+n[y+4>>2]-+n[j+4>>2];s=+n[y+8>>2]-+n[j+8>>2];n[E>>2]=+n[y>>2]-+n[j>>2];n[E+4>>2]=v;n[E+8>>2]=s;n[E+12>>2]=0.0;s=+n[y+20>>2]-+n[i+4>>2];v=+n[y+24>>2]-+n[i+8>>2];n[E+16>>2]=+n[y+16>>2]-+n[i>>2];n[E+20>>2]=s;n[E+24>>2]=v;n[E+28>>2]=0.0;w=f[g>>2]|0;v=+n[d>>2];s=+n[e>>2];t=(+n[E+(w<<4)>>2]-v)*s;v=s*(+n[E+(1-w<<4)>>2]-v);w=f[g+4>>2]|0;s=+n[d+4>>2];F=+n[e+4>>2];r=(+n[E+(w<<4)+4>>2]-s)*F;s=F*(+n[E+(1-w<<4)+4>>2]-s);do if((!(r>v|t>s)?(B=r>t?r:t,A=s<v?s:v,w=f[g+8>>2]|0,D=+n[d+8>>2],F=+n[e+8>>2],C=(+n[E+(w<<4)+8>>2]-D)*F,D=F*(+n[E+(1-w<<4)+8>>2]-D),!(C>A|B>D)):0)?((D<A?D:A)>0.0?(C>B?C:B)<h:0):0){if(!(f[y+40>>2]|0)){Rb[f[(f[k>>2]|0)+12>>2]&127](k,y);o=x;break}if((x|0)>(l|0)){w=f[a+44>>2]|0;if((w|0)<(w<<1|0)){if((f[z>>2]|0)<(w<<1|0)){if(w){f[6472]=(f[6472]|0)+1;l=sc((w<<3|3)+16|0)|0;if(!l)q=0;else{f[(l+4+15&-16)+-4>>2]=l;q=l+4+15&-16}p=f[a+44>>2]|0;if((p|0)>0){l=0;do{f[q+(l<<2)>>2]=f[(f[m>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(p|0));c=q;p=q}else{c=q;p=q}}else{c=0;p=0}l=f[m>>2]|0;if(l|0){if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}f[m>>2]=0}b[a+56>>0]=1;f[m>>2]=c;f[z>>2]=w<<1;l=w}else l=w;do{f[p+(l<<2)>>2]=0;l=l+1|0;p=f[m>>2]|0}while((l|0)!=(w<<1|0))}f[a+44>>2]=w<<1;l=(w<<1)+-2|0}f[p+(x<<2)>>2]=f[y+36>>2];f[(f[m>>2]|0)+(o<<2)>>2]=f[y+40>>2];o=o+1|0}else o=x;while(0)}while((o|0)!=0);u=E;return}function ye(a,c){a=a|0;c=+c;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0;o=u;u=u+16|0;m=f[a+452>>2]|0;Vb[f[(f[m>>2]|0)+16>>2]&127](m,a+324|0,0);m=f[a+452>>2]|0;Bb[f[(f[m>>2]|0)+12>>2]&127](m)|0;Tc(a,c);uj(11828);m=f[a+328>>2]|0;if((m|0)>0){e=f[a+336>>2]|0;d=0;j=0;do{l=f[(f[e+(d<<2)>>2]|0)+384>>2]|0;j=(j|0)>(l|0)?j:l;d=d+1|0}while((d|0)!=(m|0));d=0;while(1){g=f[e+(d<<2)>>2]|0;if((f[g+852>>2]|0)>0){e=0;do{l=f[(f[g+860>>2]|0)+(e<<2)>>2]|0;Pb[f[(f[l>>2]|0)+8>>2]&15](l,+n[g+452>>2],j);e=e+1|0}while((e|0)<(f[g+852>>2]|0))}d=d+1|0;if((d|0)==(m|0))break;e=f[a+336>>2]|0}if((j|0)>0){g=0;do{d=0;do{h=f[(f[a+336>>2]|0)+(d<<2)>>2]|0;i=f[h+852>>2]|0;if((i|0)>0){e=0;do{l=f[(f[h+860>>2]|0)+(e<<2)>>2]|0;Nb[f[(f[l>>2]|0)+12>>2]&7](l,+n[h+452>>2],1.0);e=e+1|0}while((e|0)!=(i|0))}d=d+1|0}while((d|0)!=(m|0));g=g+1|0}while((g|0)!=(j|0));k=0}else k=0;do{l=f[(f[a+336>>2]|0)+(k<<2)>>2]|0;if((f[l+852>>2]|0)>0){d=0;do{e=f[(f[l+860>>2]|0)+(d<<2)>>2]|0;Mb[f[(f[e>>2]|0)+16>>2]&31](e,+n[l+452>>2]);e=f[l+860>>2]|0;g=f[e+(d<<2)>>2]|0;a:do if(b[g+152>>0]|0){if(!g)j=e;else{f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);j=f[l+860>>2]|0}i=d+-1|0;e=f[l+852>>2]|0;if((e|0)>0){h=f[j+(d<<2)>>2]|0;d=0;while(1){g=j+(d<<2)|0;if((f[g>>2]|0)==(h|0))break;d=d+1|0;if((d|0)>=(e|0)){d=i;break a}}if((d|0)<(e|0)){f[g>>2]=f[j+(e+-1<<2)>>2];f[(f[l+860>>2]|0)+(e+-1<<2)>>2]=h;f[l+852>>2]=e+-1;d=i;e=e+-1|0}else d=i}else d=i}else e=f[l+852>>2]|0;while(0);d=d+1|0}while((d|0)<(e|0))}k=k+1|0}while((k|0)!=(m|0))}d=f[a+452>>2]|0;Mb[f[(f[d>>2]|0)+28>>2]&31](d,+n[d+12>>2]*c);d=f[2405]|0;m=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=m;do if(!m){if(f[d+4>>2]|0){gb(o|0,0)|0;m=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[o+4>>2]|0)-(f[m+4>>2]|0)+(((f[o>>2]|0)-(f[m>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(f[d+16>>2]|0)break;d=f[2405]|0}f[2405]=f[d+20>>2]}while(0);if((f[a+328>>2]|0)<=0){a=f[a+452>>2]|0;m=f[a>>2]|0;m=m+32|0;m=f[m>>2]|0;Lb[m&511](a);u=o;return}d=0;do{m=f[(f[a+336>>2]|0)+(d<<2)>>2]|0;Vh(m,m);d=d+1|0}while((d|0)<(f[a+328>>2]|0));a=f[a+452>>2]|0;m=f[a>>2]|0;m=m+32|0;m=f[m>>2]|0;Lb[m&511](a);u=o;return}function ze(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;Sg(a,b+(c*284|0)|0,d);l=+n[b+(c*284|0)+52>>2];g=+n[b+(c*284|0)+56>>2];q=+n[b+(c*284|0)+60>>2];G=+n[b+(c*284|0)+76>>2];x=+n[b+(c*284|0)+72>>2];z=+n[b+(c*284|0)+68>>2];w=1.0/+L(+((x*-l-z*-g)*(x*-l-z*-g)+((G*-g-x*-q)*(G*-g-x*-q)+(z*-q-G*-l)*(z*-q-G*-l))));v=(G*-g-x*-q)*w;u=w*(z*-q-G*-l);w=w*(x*-l-z*-g);e=+n[b+(c*284|0)+232>>2]*.5;j=+O(+e)/+L(+(l*l+g*g+q*q));e=+N(+e);k=2.0/(e*e+(j*-q*j*-q+(j*-l*j*-l+j*-g*j*-g)));E=1.0-(j*-g*j*-g*k+j*-q*j*-q*k);D=j*-l*j*-g*k-e*j*-q*k;F=j*-l*j*-q*k+e*j*-g*k;B=j*-l*j*-g*k+e*j*-q*k;A=1.0-(j*-l*j*-l*k+j*-q*j*-q*k);C=j*-g*j*-q*k-e*j*-l*k;i=j*-l*j*-q*k-e*j*-g*k;e=j*-g*j*-q*k+e*j*-l*k;k=1.0-(j*-l*j*-l*k+j*-g*j*-g*k);j=+n[b+(c*284|0)+236>>2]*-.5;y=+O(+j)/+L(+(G*G+(x*x+z*z)));j=+N(+j);r=2.0/(j*j+(G*y*G*y+(z*y*z*y+x*y*x*y)));m=1.0-(x*y*x*y*r+G*y*G*y*r);h=z*y*x*y*r-j*G*y*r;t=z*y*G*y*r+j*x*y*r;o=z*y*x*y*r+j*G*y*r;f=1.0-(z*y*z*y*r+G*y*G*y*r);s=x*y*G*y*r-j*z*y*r;p=z*y*G*y*r-j*x*y*r;j=x*y*G*y*r+j*z*y*r;r=1.0-(z*y*z*y*r+x*y*x*y*r);y=+n[b+(c*284|0)+68>>2];x=+n[b+(c*284|0)+72>>2];z=+n[b+(c*284|0)+76>>2];n[b+(c*284|0)+92>>2]=z*(E*t+D*s+F*r)+(y*(F*p+(D*o+E*m))+x*(F*j+(E*h+D*f)));n[b+(c*284|0)+96>>2]=w*(E*t+D*s+F*r)+(v*(F*p+(D*o+E*m))+u*(F*j+(E*h+D*f)));n[b+(c*284|0)+100>>2]=(E*t+D*s+F*r)*-q+((F*p+(D*o+E*m))*-l+(F*j+(E*h+D*f))*-g);n[b+(c*284|0)+104>>2]=0.0;n[b+(c*284|0)+108>>2]=z*(B*t+A*s+C*r)+(y*(C*p+(A*o+B*m))+x*(C*j+(B*h+A*f)));n[b+(c*284|0)+112>>2]=w*(B*t+A*s+C*r)+(v*(C*p+(A*o+B*m))+u*(C*j+(B*h+A*f)));n[b+(c*284|0)+116>>2]=(B*t+A*s+C*r)*-q+((C*p+(A*o+B*m))*-l+(C*j+(B*h+A*f))*-g);n[b+(c*284|0)+120>>2]=0.0;n[b+(c*284|0)+124>>2]=z*(i*t+e*s+k*r)+(y*(k*p+(e*o+i*m))+x*(k*j+(i*h+e*f)));n[b+(c*284|0)+128>>2]=w*(i*t+e*s+k*r)+(v*(k*p+(e*o+i*m))+u*(k*j+(i*h+e*f)));n[b+(c*284|0)+132>>2]=(i*t+e*s+k*r)*-q+((k*p+(e*o+i*m))*-l+(k*j+(i*h+e*f))*-g);n[b+(c*284|0)+136>>2]=0.0;g=+n[b+(c*284|0)+32>>2];f=g*+n[b+(c*284|0)+56>>2]+ +n[b+(c*284|0)+40>>2];e=g*+n[b+(c*284|0)+60>>2]+ +n[b+(c*284|0)+44>>2];n[b+(c*284|0)+140>>2]=+n[b+(c*284|0)+52>>2]*g+ +n[b+(c*284|0)+36>>2];n[b+(c*284|0)+144>>2]=f;n[b+(c*284|0)+148>>2]=e;n[b+(c*284|0)+152>>2]=0.0;return}function Ae(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,t=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0.0;D=u;u=u+32|0;o=+n[c>>2];g=(n[s>>2]=o,f[s>>2]|0);r=o<999999984306749440.0?g:1566444395;m=+n[c+4>>2];i=(n[s>>2]=m,f[s>>2]|0);t=m<999999984306749440.0?i:1566444395;E=+n[c+8>>2];k=(n[s>>2]=E,f[s>>2]|0);w=E<999999984306749440.0?k:1566444395;p=+n[c+12>>2];y=p<0.0?p:0.0;g=o>-999999984306749440.0?g:-581039253;i=m>-999999984306749440.0?i:-581039253;k=E>-999999984306749440.0?k:-581039253;p=p>0.0?p:0.0;E=+n[c+16>>2];B=E<(f[s>>2]=r,+n[s>>2]);h=(n[s>>2]=E,f[s>>2]|0);r=B?h:r;m=+n[c+20>>2];B=m<(f[s>>2]=t,+n[s>>2]);j=(n[s>>2]=m,f[s>>2]|0);t=B?j:t;o=+n[c+24>>2];B=o<(f[s>>2]=w,+n[s>>2]);l=(n[s>>2]=o,f[s>>2]|0);w=B?l:w;q=+n[c+28>>2];y=q<y?q:y;x=E>(f[s>>2]=g,+n[s>>2])?h:g;v=m>(f[s>>2]=i,+n[s>>2])?j:i;j=o>(f[s>>2]=k,+n[s>>2])?l:k;q=p<q?q:p;E=+n[c+32>>2];B=E<(f[s>>2]=r,+n[s>>2]);g=(n[s>>2]=E,f[s>>2]|0);B=B?g:r;o=+n[c+36>>2];A=o<(f[s>>2]=t,+n[s>>2]);h=(n[s>>2]=o,f[s>>2]|0);A=A?h:t;p=+n[c+40>>2];z=p<(f[s>>2]=w,+n[s>>2]);i=(n[s>>2]=p,f[s>>2]|0);z=z?i:w;m=+n[c+44>>2];y=m<y?m:y;w=E>(f[s>>2]=x,+n[s>>2])?g:x;v=o>(f[s>>2]=v,+n[s>>2])?h:v;t=p>(f[s>>2]=j,+n[s>>2])?i:j;m=q<m?m:q;r=f[a+4>>2]|0;g=f[r+4>>2]|0;if((g|0)==(f[r+8>>2]|0)?(C=g|0?g<<1:1,(g|0)<(C|0)):0){if(!C)l=0;else{f[6472]=(f[6472]|0)+1;g=sc(C<<6|19)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=g;g=f[r+4>>2]|0}if((g|0)>0){h=0;do{i=l+(h<<6)|0;j=(f[r+12>>2]|0)+(h<<6)|0;k=i+64|0;do{f[i>>2]=f[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));h=h+1|0}while((h|0)!=(g|0))}g=f[r+12>>2]|0;if(g|0){if(b[r+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[r+12>>2]=0}b[r+16>>0]=1;f[r+12>>2]=l;f[r+8>>2]=C;g=f[r+4>>2]|0}C=f[r+12>>2]|0;f[C+(g<<6)>>2]=B;f[C+(g<<6)+4>>2]=A;f[C+(g<<6)+8>>2]=z;n[C+(g<<6)+12>>2]=y;f[C+(g<<6)+16>>2]=w;f[C+(g<<6)+20>>2]=v;f[C+(g<<6)+24>>2]=t;n[C+(g<<6)+28>>2]=m;f[C+(g<<6)+32>>2]=-1;f[C+(g<<6)+36>>2]=d;f[C+(g<<6)+40>>2]=e;e=C+(g<<6)+44|0;f[e>>2]=f[D>>2];f[e+4>>2]=f[D+4>>2];f[e+8>>2]=f[D+8>>2];f[e+12>>2]=f[D+12>>2];f[e+16>>2]=f[D+16>>2];f[r+4>>2]=(f[r+4>>2]|0)+1;u=D;return}function Be(a,c,d,e){a=a|0;c=c|0;d=d|0;e=+e;var g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;m=u;u=u+16|0;l=+n[c>>2];h=+n[c+4>>2];i=+n[c+8>>2];j=+n[d>>2];k=+n[d+4>>2];g=+n[d+8>>2];if(!(b[a+228>>0]|0)){z=+n[a+100>>2];w=+n[a+116>>2];C=+n[a+132>>2];y=+n[a+104>>2];t=+n[a+120>>2];B=+n[a+136>>2];x=+n[a+108>>2];r=+n[a+124>>2];A=+n[a+140>>2];F=-+n[a+148>>2];E=-+n[a+152>>2];D=-+n[a+156>>2];J=+n[a+164>>2];I=+n[a+168>>2];q=+n[a+172>>2];H=+n[a+180>>2];G=+n[a+184>>2];p=+n[a+188>>2];v=+n[a+196>>2];s=+n[a+200>>2];o=+n[a+204>>2];q=g*(C*J+B*I+A*q)+(j*(z*J+y*I+x*q)+k*(w*J+t*I+r*q))+(J*(z*F+w*E+C*D)+(y*F+t*E+B*D)*I+(x*F+r*E+A*D)*q+ +n[a+212>>2]);p=g*(C*H+B*G+A*p)+(j*(z*H+y*G+x*p)+k*(w*H+t*G+r*p))+((z*F+w*E+C*D)*H+(y*F+t*E+B*D)*G+(x*F+r*E+A*D)*p+ +n[a+216>>2]);o=(z*F+w*E+C*D)*v+(y*F+t*E+B*D)*s+(x*F+r*E+A*D)*o+ +n[a+220>>2]+(g*(C*v+B*s+A*o)+(j*(z*v+y*s+x*o)+k*(w*v+t*s+r*o)));n[m>>2]=q;n[m+4>>2]=p;n[m+8>>2]=o;l=(l*e+j-q)*+n[c>>2]+(h*e+k-p)*+n[c+4>>2]+(i*e+g-o)*+n[c+8>>2];d=m+12|0;n[d>>2]=0.0;a=a+32|0;a=f[a>>2]|0;d=f[a>>2]|0;d=d+16|0;d=f[d>>2]|0;Wb[d&15](a,c,m,l);u=m;return}else{z=+n[a+36>>2];C=+n[a+52>>2];w=+n[a+68>>2];A=+n[a+40>>2];E=+n[a+56>>2];x=+n[a+72>>2];B=+n[a+44>>2];G=+n[a+60>>2];y=+n[a+76>>2];s=-+n[a+84>>2];t=-+n[a+88>>2];v=-+n[a+92>>2];o=+n[a+164>>2];p=+n[a+168>>2];H=+n[a+172>>2];q=+n[a+180>>2];r=+n[a+184>>2];I=+n[a+188>>2];D=+n[a+196>>2];F=+n[a+200>>2];J=+n[a+204>>2];H=(i*e+g)*(w*o+x*p+y*H)+((l*e+j)*(z*o+A*p+B*H)+(h*e+k)*(C*o+E*p+G*H))+(o*(z*s+C*t+w*v)+(A*s+E*t+x*v)*p+(B*s+G*t+y*v)*H+ +n[a+212>>2]);I=(i*e+g)*(w*q+x*r+y*I)+((l*e+j)*(z*q+A*r+B*I)+(h*e+k)*(C*q+E*r+G*I))+((z*s+C*t+w*v)*q+(A*s+E*t+x*v)*r+(B*s+G*t+y*v)*I+ +n[a+216>>2]);J=(z*s+C*t+w*v)*D+(A*s+E*t+x*v)*F+(B*s+G*t+y*v)*J+ +n[a+220>>2]+((i*e+g)*(w*D+x*F+y*J)+((l*e+j)*(z*D+A*F+B*J)+(h*e+k)*(C*D+E*F+G*J)));n[m>>2]=H+l*(l*(H-j)+h*(I-k)+i*(J-g));n[m+4>>2]=I+h*(l*(H-j)+h*(I-k)+i*(J-g));n[m+8>>2]=J+i*(l*(H-j)+h*(I-k)+i*(J-g));J=l*(H-j)+h*(I-k)+i*(J-g);d=m+12|0;n[d>>2]=0.0;a=a+32|0;a=f[a>>2]|0;d=f[a>>2]|0;d=d+16|0;d=f[d>>2]|0;Wb[d&15](a,c,m,J);u=m;return}}function Ce(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;f[a+4>>2]=4;f[a+8>>2]=-1;f[a+12>>2]=-1;n[a+16>>2]=3402823466385288598117041.0e14;b[a+20>>0]=1;b[a+21>>0]=0;f[a+24>>2]=-1;f[a+28>>2]=c;f[a+32>>2]=d;n[a+36>>2]=0.0;n[a+40>>2]=.30000001192092896;f[a+44>>2]=0;f[a>>2]=4900;n[a+688>>2]=0.0;n[a+692>>2]=-1.0;n[a+696>>2]=.8999999761581421;n[a+700>>2]=.30000001192092896;n[a+704>>2]=1.0;n[a+708>>2]=0.0;n[a+712>>2]=0.0;b[a+716>>0]=0;b[a+736>>0]=0;b[a+737>>0]=0;b[a+738>>0]=0;b[a+739>>0]=1;b[a+740>>0]=j&1;f[a+748>>2]=0;f[a+600>>2]=f[e>>2];f[a+600+4>>2]=f[e+4>>2];f[a+600+8>>2]=f[e+8>>2];f[a+600+12>>2]=f[e+12>>2];k=+n[c+4>>2];l=+n[c+20>>2];m=+n[c+36>>2];o=+n[h>>2];p=+n[h+4>>2];q=+n[h+8>>2];do if(!(k*o+l*p+m*q>=.9999998807907104))if(!(k*o+l*p+m*q<=-.9999998807907104)){d=(n[s>>2]=m*p-l*q,f[s>>2]|0);r=(n[s>>2]=k*q-m*o,f[s>>2]|0);e=(n[s>>2]=l*o-k*p,f[s>>2]|0);x=q*(k*q-m*o)-p*(l*o-k*p);y=o*(l*o-k*p)-q*(m*p-l*q);w=p*(m*p-l*q)-o*(k*q-m*o);break}else{d=f[c+8>>2]|0;e=f[c+40>>2]|0;r=f[c+24>>2]|0;x=+n[c+12>>2];y=+n[c+28>>2];w=+n[c+44>>2];break}else{d=f[c+8>>2]|0;e=f[c+40>>2]|0;r=f[c+24>>2]|0;x=-+n[c+12>>2];y=-+n[c+28>>2];w=-+n[c+44>>2]}while(0);n[a+552>>2]=x;f[a+556>>2]=d;f[a+560>>2]=f[h>>2];n[a+564>>2]=0.0;n[a+568>>2]=y;f[a+572>>2]=r;f[a+576>>2]=f[h+4>>2];n[a+580>>2]=0.0;n[a+584>>2]=w;f[a+588>>2]=e;f[a+592>>2]=f[h+8>>2];n[a+596>>2]=0.0;o=+n[h+4>>2];t=+n[i+8>>2];p=+n[h+8>>2];u=+n[i+4>>2];v=+n[i>>2];k=+n[h>>2];do if(t*p+(o*u+v*k)<-.9999998807907104)if(+K(+p)>.7071067690849304){l=1.0/+L(+(o*o+p*p));m=-(p*l);q=0.0;l=o*l;k=0.0;break}else{p=1.0/+L(+(o*o+k*k));m=k*p;q=0.0;l=0.0;k=-(o*p);break}else{z=+L(+((t*p+(o*u+v*k)+1.0)*2.0));m=(p*v-t*k)*(1.0/z);q=z*.5;l=(u*k-o*v)*(1.0/z);k=(o*t-p*u)*(1.0/z)}while(0);B=w*m+x*q-y*l;p=x*l+y*q-w*k;o=y*k+w*q-x*m;A=-(x*k)-y*m-w*l;x=-k;m=-m;w=-l;z=p*w+(A*x+q*B)-o*m;y=o*x+(A*m+q*p)-B*w;x=B*m+(A*w+q*o)-p*x;f[a+664>>2]=f[g>>2];f[a+664+4>>2]=f[g+4>>2];f[a+664+8>>2]=f[g+8>>2];f[a+664+12>>2]=f[g+12>>2];n[a+616>>2]=z;n[a+620>>2]=u*x-t*y;f[a+624>>2]=f[i>>2];n[a+628>>2]=0.0;n[a+632>>2]=y;n[a+636>>2]=t*z-v*x;f[a+640>>2]=f[i+4>>2];n[a+644>>2]=0.0;n[a+648>>2]=x;n[a+652>>2]=v*y-u*z;f[a+656>>2]=f[i+8>>2];n[a+660>>2]=0.0;n[a+732>>2]=j?-1.0:1.0;return}function De(a,c){a=a|0;c=+c;var d=0,e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0;q=u;u=u+32|0;d=f[a+136>>2]|0;if((d|0)>0){e=0;do{ze(f[a+116>>2]|0,f[a+144>>2]|0,e,0);e=e+1|0;d=f[a+136>>2]|0}while((e|0)<(d|0))}p=f[a+116>>2]|0;k=+n[p+312>>2];l=+n[p+316>>2];g=+n[p+320>>2];g=+L(+(k*k+l*l+g*g))*3.5999999046325684;n[a+112>>2]=g;o=f[a+128>>2]|0;if(+n[p+4+(o<<2)>>2]*+n[p+312>>2]+ +n[p+20+(o<<2)>>2]*+n[p+316>>2]+ +n[p+36+(o<<2)>>2]*+n[p+320>>2]<0.0)n[a+112>>2]=-g;if((d|0)>0){d=0;do{+wf(a,(f[a+144>>2]|0)+(d*284|0)|0);d=d+1|0;e=f[a+136>>2]|0}while((d|0)<(e|0));h=1.0/+n[(f[a+116>>2]|0)+344>>2];if((e|0)>0){e=0;do{d=f[a+144>>2]|0;if(!(b[d+(e*284|0)+84>>0]|0))g=0.0;else{g=+n[d+(e*284|0)+272>>2];g=h*(+n[d+(e*284|0)+216>>2]*(+n[d+(e*284|0)+204>>2]-+n[d+(e*284|0)+32>>2])*+n[d+(e*284|0)+268>>2]-g*+n[(g<0.0?d+(e*284|0)+220|0:d+(e*284|0)+224|0)>>2]);g=g<0.0?0.0:g}n[d+(e*284|0)+276>>2]=g;e=e+1|0;d=f[a+136>>2]|0}while((e|0)<(d|0));if((d|0)>0){d=0;do{o=f[a+144>>2]|0;j=+n[o+(d*284|0)+276>>2];l=+n[o+(d*284|0)+248>>2];j=j>l?l:j;l=j*+n[o+(d*284|0)+4>>2]*c;k=j*+n[o+(d*284|0)+8>>2]*c;n[q+16>>2]=+n[o+(d*284|0)>>2]*j*c;n[q+16+4>>2]=l;n[q+16+8>>2]=k;n[q+16+12>>2]=0.0;p=f[a+116>>2]|0;k=+n[o+(d*284|0)+20>>2]-+n[p+56>>2];l=+n[o+(d*284|0)+24>>2]-+n[p+60>>2];n[q>>2]=+n[o+(d*284|0)+16>>2]-+n[p+52>>2];n[q+4>>2]=k;n[q+8>>2]=l;n[q+12>>2]=0.0;ll(p,q+16|0,q);d=d+1|0}while((d|0)<(f[a+136>>2]|0))}}}Mb[f[(f[a>>2]|0)+20>>2]&31](a,c);m=f[a+136>>2]|0;if((m|0)<=0){u=q;return}o=f[a+144>>2]|0;p=f[a+116>>2]|0;e=0;do{g=+n[o+(e*284|0)+36>>2]-+n[p+52>>2];h=+n[o+(e*284|0)+40>>2]-+n[p+56>>2];i=+n[o+(e*284|0)+44>>2]-+n[p+60>>2];j=+n[p+332>>2];k=+n[p+336>>2];l=+n[p+328>>2];if(!(b[o+(e*284|0)+84>>0]|0)){r=o+(e*284|0)+240|0;d=r;g=+n[r>>2]}else{d=f[a+128>>2]|0;y=+n[p+4+(d<<2)>>2];w=+n[p+20+(d<<2)>>2];t=+n[p+36+(d<<2)>>2];x=+n[o+(e*284|0)>>2];v=+n[o+(e*284|0)+4>>2];s=+n[o+(e*284|0)+8>>2];g=((h*l-g*j+ +n[p+320>>2])*(t-s*(y*x+w*v+t*s))+((j*i-h*k+ +n[p+312>>2])*(y-x*(y*x+w*v+t*s))+(g*k-i*l+ +n[p+316>>2])*(w-v*(y*x+w*v+t*s))))*c/+n[o+(e*284|0)+212>>2];d=o+(e*284|0)+240|0;n[d>>2]=g}r=o+(e*284|0)+236|0;n[r>>2]=g+ +n[r>>2];n[d>>2]=g*.9900000095367432;e=e+1|0}while((e|0)!=(m|0));u=q;return}function Ee(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0;if(!((a|0)!=0&(b|0)!=0))return;f[6472]=(f[6472]|0)+1;d=sc(1043)|0;if(!d)e=0;else{f[(d+4+15&-16)+-4>>2]=d;e=d+4+15&-16}f[e>>2]=a;f[e+4>>2]=b;d=1;b=124;g=128;a=e;k=128;j=e;h=e;o=e;while(1){r=d+-1|0;p=f[a+(r<<3)>>2]|0;q=f[a+(r<<3)+4>>2]|0;if((r|0)>(b|0)){m=k<<1;do if((k|0)<(m|0)&(g|0)<(m|0)){if(k){f[6472]=(f[6472]|0)+1;b=sc((k<<4|3)+16|0)|0;if(!b)e=0;else{f[(b+4+15&-16)+-4>>2]=b;e=b+4+15&-16}if((k|0)>0){b=0;do{i=a+(b<<3)|0;j=f[i+4>>2]|0;l=e+(b<<3)|0;f[l>>2]=f[i>>2];f[l+4>>2]=j;b=b+1|0}while((b|0)!=(k|0));g=e;a=e}else{g=e;b=e;s=12}}else{g=0;b=0;s=12}if((s|0)==12){s=0;if(!a){i=m;a=b;e=g;h=g;b=g;break}else a=b}if(!o){i=m;e=g;h=g;b=g}else{f[6473]=(f[6473]|0)+1;Cd(f[o+-4>>2]|0);i=m;e=g;h=g;b=g}}else{i=g;e=j;b=o}while(0);l=m+-4|0;g=i;k=m;j=e;i=b}else{l=b;i=o}do if((p|0)==(q|0))if(!(f[p+40>>2]|0))d=r;else{q=f[p+36>>2]|0;f[a+(r<<3)>>2]=q;f[a+(r<<3)+4>>2]=q;q=f[p+40>>2]|0;r=d+1|0;f[a+(d<<3)>>2]=q;f[a+(d<<3)+4>>2]=q;q=f[p+40>>2]|0;f[a+(r<<3)>>2]=f[p+36>>2];f[a+(r<<3)+4>>2]=q;d=d+2|0}else if(((((+n[p>>2]<=+n[q+16>>2]?+n[p+16>>2]>=+n[q>>2]:0)?+n[p+4>>2]<=+n[q+20>>2]:0)?+n[p+20>>2]>=+n[q+4>>2]:0)?+n[p+8>>2]<=+n[q+24>>2]:0)?+n[p+24>>2]>=+n[q+8>>2]:0){b=(f[q+40>>2]|0)!=0;if(!(f[p+40>>2]|0))if(b){o=f[q+36>>2]|0;f[a+(r<<3)>>2]=p;f[a+(r<<3)+4>>2]=o;r=f[q+40>>2]|0;f[a+(d<<3)>>2]=p;f[a+(d<<3)+4>>2]=r;d=d+1|0;break}else{Vb[f[(f[c>>2]|0)+8>>2]&127](c,p,q);d=r;break}else{e=f[p+36>>2]|0;if(b){m=f[q+36>>2]|0;f[a+(r<<3)>>2]=e;f[a+(r<<3)+4>>2]=m;m=f[q+36>>2]|0;o=d+1|0;f[a+(d<<3)>>2]=f[p+40>>2];f[a+(d<<3)+4>>2]=m;m=f[q+40>>2]|0;r=d+2|0;f[a+(o<<3)>>2]=f[p+36>>2];f[a+(o<<3)+4>>2]=m;q=f[q+40>>2]|0;f[a+(r<<3)>>2]=f[p+40>>2];f[a+(r<<3)+4>>2]=q;d=d+3|0;break}else{f[a+(r<<3)>>2]=e;f[a+(r<<3)+4>>2]=q;f[a+(d<<3)>>2]=f[p+40>>2];f[a+(d<<3)+4>>2]=q;d=d+1|0;break}}}else d=r;while(0);if(!d)break;else{b=l;o=i}}if((a|0)==0|(j|0)==0)return;f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);return}function Fe(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0;o=u;u=u+16|0;uj(12271);j=f[a+204>>2]|0;Vb[f[(f[j>>2]|0)+8>>2]&127](j,a,f[a+24>>2]|0);j=f[a+308>>2]|0;if((j|0)>0){k=f[a+316>>2]|0;i=0;do{d=f[k+(i<<2)>>2]|0;c=f[d+740>>2]|0;d=f[d+744>>2]|0;if((c|0?(d|0?(f[c+204>>2]&3|0)==0:0):0)?(f[d+204>>2]&3|0)==0:0){e=f[c+208>>2]|0;c=f[d+208>>2]|0;h=f[(f[a+204>>2]|0)+16>>2]|0;d=f[h+(e<<3)>>2]|0;if((d|0)!=(e|0)){f[h+(e<<3)>>2]=f[h+(d<<3)>>2];e=f[h+(d<<3)>>2]|0;d=f[h+(e<<3)>>2]|0;if((e|0)!=(d|0)){g=h+(e<<3)|0;do{e=h+(d<<3)|0;f[g>>2]=f[e>>2];e=f[e>>2]|0;g=h+(e<<3)|0;d=f[g>>2]|0}while((e|0)!=(d|0))}}d=f[h+(c<<3)>>2]|0;if((d|0)!=(c|0)){f[h+(c<<3)>>2]=f[h+(d<<3)>>2];c=f[h+(d<<3)>>2]|0;d=f[h+(c<<3)>>2]|0;if((c|0)!=(d|0)){g=h+(c<<3)|0;do{c=h+(d<<3)|0;f[g>>2]=f[c>>2];c=f[c>>2]|0;g=h+(c<<3)|0;d=f[g>>2]|0}while((c|0)!=(d|0))}}if((e|0)!=(c|0)){f[h+(e<<3)>>2]=c;g=h+(c<<3)+4|0;f[g>>2]=(f[g>>2]|0)+(f[h+(e<<3)+4>>2]|0)}}i=i+1|0}while((i|0)!=(j|0))}k=f[a+212>>2]|0;if((k|0)>0){j=f[a+220>>2]|0;i=0;do{c=f[j+(i<<2)>>2]|0;if((b[c+20>>0]|0?(l=f[c+28>>2]|0,(f[l+204>>2]&3|0)==0):0)?(m=f[c+32>>2]|0,(f[m+204>>2]&3|0)==0):0){d=f[l+208>>2]|0;c=f[m+208>>2]|0;h=f[(f[a+204>>2]|0)+16>>2]|0;e=f[h+(d<<3)>>2]|0;if((e|0)!=(d|0)){f[h+(d<<3)>>2]=f[h+(e<<3)>>2];d=f[h+(e<<3)>>2]|0;e=f[h+(d<<3)>>2]|0;if((d|0)!=(e|0)){g=h+(d<<3)|0;do{d=h+(e<<3)|0;f[g>>2]=f[d>>2];d=f[d>>2]|0;g=h+(d<<3)|0;e=f[g>>2]|0}while((d|0)!=(e|0))}}e=f[h+(c<<3)>>2]|0;if((e|0)!=(c|0)){f[h+(c<<3)>>2]=f[h+(e<<3)>>2];c=f[h+(e<<3)>>2]|0;e=f[h+(c<<3)>>2]|0;if((c|0)!=(e|0)){g=h+(c<<3)|0;do{c=h+(e<<3)|0;f[g>>2]=f[c>>2];c=f[c>>2]|0;g=h+(c<<3)|0;e=f[g>>2]|0}while((c|0)!=(e|0))}}if((d|0)!=(c|0)){f[h+(d<<3)>>2]=c;g=h+(c<<3)+4|0;f[g>>2]=(f[g>>2]|0)+(f[h+(d<<3)+4>>2]|0)}}i=i+1|0}while((i|0)!=(k|0))}c=f[a+204>>2]|0;Rb[f[(f[c>>2]|0)+12>>2]&127](c,a);c=f[2405]|0;m=(f[c+16>>2]|0)+-1|0;f[c+16>>2]=m;if(m|0){u=o;return}do if(f[c+4>>2]|0){gb(o|0,0)|0;m=f[6471]|0;n[c+8>>2]=+n[c+8>>2]+ +(((f[o+4>>2]|0)-(f[m+4>>2]|0)+(((f[o>>2]|0)-(f[m>>2]|0)|0)*1e6|0)-(f[c+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[c+16>>2]|0)){c=f[2405]|0;break}else{u=o;return}}while(0);f[2405]=f[c+20>>2];u=o;return}function Ge(a,c,d,e){a=a|0;c=c|0;d=d|0;e=+e;var g=0,h=0.0,i=0.0,j=0.0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,v=0,w=0.0,x=0.0,y=0,z=0;t=u;u=u+192|0;s=f[(f[a+4>>2]|0)+740>>2]|0;k=f[(f[a+8>>2]|0)+8>>2]|0;l=+n[d>>2];m=+n[c>>2]*e+l;o=+n[d+4>>2];p=+n[c+4>>2]*e+o;q=+n[d+8>>2];r=+n[c+8>>2]*e+q;if((s|0)!=(k|0)){v=f[(f[a+12>>2]|0)+8>>2]|0;x=m-+n[v+52>>2];w=p-+n[v+56>>2];j=r-+n[v+60>>2];g=k;h=x*+n[v+4>>2]+w*+n[v+20>>2]+j*+n[v+36>>2];i=x*+n[v+8>>2]+w*+n[v+24>>2]+j*+n[v+40>>2];j=x*+n[v+12>>2]+w*+n[v+28>>2]+j*+n[v+44>>2]}else{w=m-+n[s+52>>2];x=p-+n[s+56>>2];j=r-+n[s+60>>2];g=f[(f[a+12>>2]|0)+8>>2]|0;h=w*+n[s+4>>2]+x*+n[s+20>>2]+j*+n[s+36>>2];i=w*+n[s+8>>2]+x*+n[s+24>>2]+j*+n[s+40>>2];j=w*+n[s+12>>2]+x*+n[s+28>>2]+j*+n[s+44>>2]}l=l-+n[g+52>>2];o=o-+n[g+56>>2];x=q-+n[g+60>>2];q=l*+n[g+4>>2]+o*+n[g+20>>2]+x*+n[g+36>>2];w=l*+n[g+8>>2]+o*+n[g+24>>2]+x*+n[g+40>>2];x=l*+n[g+12>>2]+o*+n[g+28>>2]+x*+n[g+44>>2];n[t>>2]=h;n[t+4>>2]=i;n[t+8>>2]=j;n[t+12>>2]=0.0;n[t+16>>2]=q;n[t+20>>2]=w;n[t+24>>2]=x;n[t+28>>2]=0.0;f[t+64>>2]=f[c>>2];f[t+64+4>>2]=f[c+4>>2];f[t+64+8>>2]=f[c+8>>2];f[t+64+12>>2]=f[c+12>>2];n[t+80>>2]=e;n[t+84>>2]=0.0;n[t+88>>2]=0.0;n[t+92>>2]=0.0;f[t+112>>2]=0;b[t+116>>0]=0;f[t+120>>2]=0;f[t+120+4>>2]=0;f[t+120+8>>2]=0;f[t+120+12>>2]=0;f[t+120+16>>2]=0;f[t+120+20>>2]=0;f[t+120+24>>2]=0;f[t+120+28>>2]=0;n[t+48>>2]=m;n[t+52>>2]=p;n[t+56>>2]=r;n[t+60>>2]=0.0;f[t+32>>2]=f[d>>2];f[t+32+4>>2]=f[d+4>>2];f[t+32+8>>2]=f[d+8>>2];f[t+32+12>>2]=f[d+12>>2];if((s|0)!=(k|0)){c=a+28|0;d=a+16|0;g=a+20|0;v=a+24|0;c=f[c>>2]|0;d=f[d>>2]|0;g=f[g>>2]|0;z=t+96|0;f[z>>2]=g;z=t+100|0;f[z>>2]=d;z=t+104|0;f[z>>2]=c;v=f[v>>2]|0;z=t+108|0;f[z>>2]=v;z=a+12|0;y=(s|0)!=(k|0)?z:a+8|0;y=f[y>>2]|0;s=(s|0)!=(k|0)?a+8|0:z;s=f[s>>2]|0;k=a+32|0;k=f[k>>2]|0;a=f[k>>2]|0;a=a+12|0;a=f[a>>2]|0;+yb[a&1](k,t,y,g,c,s,d,v);u=t;return}else{d=a+24|0;y=a+20|0;c=a+16|0;z=a+28|0;d=f[d>>2]|0;y=f[y>>2]|0;c=f[c>>2]|0;v=t+96|0;f[v>>2]=c;v=t+100|0;f[v>>2]=y;v=t+104|0;f[v>>2]=d;z=f[z>>2]|0;v=t+108|0;f[v>>2]=z;v=a+12|0;g=(s|0)!=(k|0)?v:a+8|0;g=f[g>>2]|0;v=(s|0)!=(k|0)?a+8|0:v;v=f[v>>2]|0;s=a+32|0;s=f[s>>2]|0;k=f[s>>2]|0;k=k+12|0;k=f[k>>2]|0;+yb[k&1](s,t,g,c,d,v,y,z);u=t;return}}function He(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0;c=u;u=u+96|0;j=+n[b>>2];k=+n[a+28>>2];l=+n[b+4>>2];m=+n[a+32>>2];o=+n[b+8>>2];p=+n[a+36>>2];q=+n[a+44>>2];r=+n[a+48>>2];s=+n[a+52>>2];t=+n[a+60>>2];v=+n[a+64>>2];w=+n[a+68>>2];x=+n[a+76>>2];y=+n[a+80>>2];z=+n[a+84>>2];n[c+80>>2]=j*k+l*m+o*p+x;n[c+80+4>>2]=j*q+l*r+o*s+y;n[c+80+8>>2]=j*t+l*v+o*w+z;n[c+80+12>>2]=0.0;A=+n[b+16>>2];B=+n[b+20>>2];C=+n[b+24>>2];n[c+64>>2]=A*k+B*m+C*p+x;n[c+64+4>>2]=A*q+B*r+C*s+y;n[c+64+8>>2]=A*t+B*v+C*w+z;n[c+64+12>>2]=0.0;D=+n[b+32>>2];E=+n[b+36>>2];i=+n[b+40>>2];n[c+48>>2]=D*k+E*m+i*p+x;n[c+48+4>>2]=D*q+E*r+i*s+y;n[c+48+8>>2]=D*t+E*v+i*w+z;n[c+48+12>>2]=0.0;e=(j*k+l*m+o*p+x+(A*k+B*m+C*p+x)+(D*k+E*m+i*p+x))*.3333333432674408;g=(j*q+l*r+o*s+y+(A*q+B*r+C*s+y)+(D*q+E*r+i*s+y))*.3333333432674408;h=(j*t+l*v+o*w+z+(A*t+B*v+C*w+z)+(D*t+E*v+i*w+z))*.3333333432674408;n[c+32>>2]=e;n[c+32+4>>2]=g;n[c+32+8>>2]=h;n[c+32+12>>2]=0.0;b=f[a+8>>2]|0;if(!((Bb[f[(f[b>>2]|0)+48>>2]&127](b)|0)&16384)){d=f[a+8>>2]|0;F=f[d>>2]|0;F=F+8|0;F=f[F>>2]|0;b=a+12|0;Yb[F&127](d,c+80|0,c+64|0,b);d=f[a+8>>2]|0;F=f[d>>2]|0;F=F+8|0;F=f[F>>2]|0;Yb[F&127](d,c+64|0,c+48|0,b);a=f[a+8>>2]|0;d=f[a>>2]|0;d=d+8|0;d=f[d>>2]|0;Yb[d&127](a,c+48|0,c+80|0,b);u=c;return}I=+n[c+80>>2];H=A*q+B*r+C*s+y-(j*q+l*r+o*s+y);G=A*t+B*v+C*w+z-(j*t+l*v+o*w+z);y=D*q+E*r+i*s+y-(j*q+l*r+o*s+y);w=D*t+E*v+i*w+z-(j*t+l*v+o*w+z);z=G*(D*k+E*m+i*p+x-I)-(A*k+B*m+C*p+x-I)*w;E=(A*k+B*m+C*p+x-I)*y-H*(D*k+E*m+i*p+x-I);D=1.0/+L(+(E*E+((H*w-G*y)*(H*w-G*y)+z*z)));f[c+16>>2]=1065353216;f[c+16+4>>2]=1065353216;f[c+16+8>>2]=0;n[c+16+12>>2]=0.0;b=f[a+8>>2]|0;d=f[(f[b>>2]|0)+8>>2]|0;n[c>>2]=D*(H*w-G*y)+e;n[c+4>>2]=D*z+g;n[c+8>>2]=D*E+h;n[c+12>>2]=0.0;Yb[d&127](b,c+32|0,c,c+16|0);b=f[a+8>>2]|0;d=f[b>>2]|0;d=d+8|0;d=f[d>>2]|0;F=a+12|0;Yb[d&127](b,c+80|0,c+64|0,F);b=f[a+8>>2]|0;d=f[b>>2]|0;d=d+8|0;d=f[d>>2]|0;Yb[d&127](b,c+64|0,c+48|0,F);a=f[a+8>>2]|0;b=f[a>>2]|0;b=b+8|0;b=f[b>>2]|0;Yb[b&127](a,c+48|0,c+80|0,F);u=c;return}function Ie(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0;J=u;u=u+32|0;if(!a){u=J;return}E=+n[c>>2]-+n[b>>2];D=+n[c+4>>2]-+n[b+4>>2];x=+n[c+8>>2]-+n[b+8>>2];y=1.0/+L(+(E*E+D*D+x*x));z=E*y==0.0?999999984306749440.0:1.0/(E*y);A=D*y==0.0?999999984306749440.0:1.0/(D*y);B=x*y==0.0?999999984306749440.0:1.0/(x*y);f[6472]=(f[6472]|0)+1;c=sc(531)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}bl(c+4|0,0,508)|0;f[c>>2]=a;p=1;o=126;m=128;r=c;s=128;w=c;k=c;e=c;while(1){t=p+-1|0;v=f[r+(t<<2)>>2]|0;f[J>>2]=f[v>>2];f[J+4>>2]=f[v+4>>2];f[J+8>>2]=f[v+8>>2];f[J+12>>2]=f[v+12>>2];f[J+16>>2]=f[v+16>>2];f[J+16+4>>2]=f[v+16+4>>2];f[J+16+8>>2]=f[v+16+8>>2];f[J+16+12>>2]=f[v+16+12>>2];h=+n[b>>2];g=z*(+n[J+((z<0.0&1)<<4)>>2]-h);h=z*(+n[J+((z<0.0^1)<<4)>>2]-h);j=+n[b+4>>2];i=A*(+n[J+((A<0.0&1)<<4)+4>>2]-j);j=A*(+n[J+((A<0.0^1)<<4)+4>>2]-j);do if((!(i>h|g>j)?(F=i>g?i:g,C=j<h?j:h,H=+n[b+8>>2],G=B*(+n[J+((B<0.0&1)<<4)+8>>2]-H),H=B*(+n[J+((B<0.0^1)<<4)+8>>2]-H),!(G>C|F>H)):0)?((H<C?H:C)>0.0?(G>F?G:F)<E*y*E+D*y*D+x*y*x:0):0){if(!(f[v+40>>2]|0)){Rb[f[(f[d>>2]|0)+12>>2]&127](d,v);p=t;c=r;l=s;a=w;break}if((t|0)>(o|0)){q=s<<1;if((s|0)<(q|0)){do if((m|0)<(q|0)){if(s){f[6472]=(f[6472]|0)+1;c=sc((s<<3|3)+16|0)|0;if(!c)a=0;else{f[(c+4+15&-16)+-4>>2]=c;a=c+4+15&-16}if((s|0)>0){c=0;do{f[a+(c<<2)>>2]=f[r+(c<<2)>>2];c=c+1|0}while((c|0)!=(s|0));e=a;c=a}else{e=a;c=a;I=17}}else{e=0;c=0;I=17}if((I|0)==17){I=0;if(!r){m=q;k=e;l=e;a=e;break}}if(!w){m=q;k=e;l=e;a=e}else{f[6473]=(f[6473]|0)+1;Cd(f[w+-4>>2]|0);m=q;k=e;l=e;a=e}}else{c=r;l=e;a=w}while(0);bl(c+(s<<2)|0,0,s<<2|0)|0;e=l}else{c=r;a=w}o=q+-2|0;l=q}else{c=r;l=s;a=w}f[c+(t<<2)>>2]=f[v+36>>2];f[c+(p<<2)>>2]=f[v+40>>2];p=p+1|0}else{p=t;c=r;l=s;a=w}while(0);if(!p)break;else{r=c;s=l;w=a}}if((c|0)==0|(k|0)==0){u=J;return}f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);u=J;return}function Je(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0,h=0,i=0.0;a=u;u=u+144|0;switch(f[b+388>>2]&15){case 1:{f[a+112>>2]=3508;g=f[c+8>>2]|0;g=(f[g+236>>2]&2|0)==0?0:g;h=f[c+12>>2]|0;i=+n[h+48>>2];d=+n[h+52>>2];e=+n[h+56>>2];e=+L(+((i-i)*(i-i)+(d-d)*(d-d)+(e-e)*(e-e)));h=f[b+192>>2]|0;d=+rb[f[(f[h>>2]|0)+48>>2]&15](h);h=f[c+4>>2]|0;Yb[f[(f[h>>2]|0)+8>>2]&127](h,f[c+12>>2]|0,a+96|0,a+64|0);f[a>>2]=f[a+96>>2];f[a+4>>2]=f[a+96+4>>2];f[a+8>>2]=f[a+96+8>>2];f[a+12>>2]=f[a+96+12>>2];f[a+16>>2]=f[a+64>>2];f[a+16+4>>2]=f[a+64+4>>2];f[a+16+8>>2]=f[a+64+8>>2];f[a+16+12>>2]=f[a+64+12>>2];f[a+32>>2]=f[a>>2];f[a+32+4>>2]=f[a+4>>2];f[a+32+8>>2]=f[a+8>>2];f[a+32+12>>2]=f[a+12>>2];f[a+32+16>>2]=f[a+16>>2];f[a+32+20>>2]=f[a+20>>2];f[a+32+24>>2]=f[a+24>>2];f[a+32+28>>2]=f[a+28>>2];n[a+32>>2]=+n[a+32>>2]-d;n[a+32+4>>2]=+n[a+32+4>>2]-d;n[a+32+8>>2]=+n[a+32+8>>2]-d;n[a+32+16>>2]=d+ +n[a+32+16>>2];n[a+32+20>>2]=d+ +n[a+32+20>>2];n[a+32+24>>2]=d+ +n[a+32+24>>2];f[a+112+4>>2]=b;f[a+112+8>>2]=c;f[a+112+12>>2]=g;n[a+112+16>>2]=e+d;n[a+112+20>>2]=d;jf(f[b+928>>2]|0,a+32|0,a+112|0);u=a;return}case 2:{n[a+4>>2]=1.0;f[a+8+4>>2]=0;f[a+8+4+4>>2]=0;f[a+8+4+8>>2]=0;f[a>>2]=3544;f[a+24>>2]=b;f[a+28>>2]=c;f[a+8>>2]=f[b+456>>2];h=f[c+4>>2]|0;i=+rb[f[(f[h>>2]|0)+48>>2]&15](h);h=f[b+192>>2]|0;i=i+ +rb[f[(f[h>>2]|0)+48>>2]&15](h);n[a+12>>2]=i;e=+n[(f[c+8>>2]|0)+224>>2];n[a+112>>2]=e;f[a+16>>2]=f[(+n[b+316>>2]<e?b+316|0:a+112|0)>>2];h=f[c+4>>2]|0;Yb[f[(f[h>>2]|0)+8>>2]&127](h,f[c+12>>2]|0,a+112|0,a+96|0);f[a+32>>2]=f[a+112>>2];f[a+32+4>>2]=f[a+112+4>>2];f[a+32+8>>2]=f[a+112+8>>2];f[a+32+12>>2]=f[a+112+12>>2];f[a+32+16>>2]=f[a+96>>2];f[a+32+16+4>>2]=f[a+96+4>>2];f[a+32+16+8>>2]=f[a+96+8>>2];f[a+32+16+12>>2]=f[a+96+12>>2];f[a+64>>2]=f[a+32>>2];f[a+64+4>>2]=f[a+32+4>>2];f[a+64+8>>2]=f[a+32+8>>2];f[a+64+12>>2]=f[a+32+12>>2];f[a+64+16>>2]=f[a+32+16>>2];f[a+64+20>>2]=f[a+32+20>>2];f[a+64+24>>2]=f[a+32+24>>2];f[a+64+28>>2]=f[a+32+28>>2];n[a+64>>2]=+n[a+64>>2]-i;n[a+64+4>>2]=+n[a+64+4>>2]-i;n[a+64+8>>2]=+n[a+64+8>>2]-i;n[a+64+16>>2]=i+ +n[a+64+16>>2];n[a+64+20>>2]=i+ +n[a+64+20>>2];n[a+64+24>>2]=i+ +n[a+64+24>>2];jf(f[b+1048>>2]|0,a+64|0,a);u=a;return}default:{u=a;return}}}function Ke(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;f[a+4>>2]=6;f[a+8>>2]=-1;f[a+12>>2]=-1;n[a+16>>2]=3402823466385288598117041.0e14;b[a+20>>0]=1;b[a+21>>0]=0;f[a+24>>2]=-1;f[a+28>>2]=c;f[a+32>>2]=d;n[a+36>>2]=0.0;n[a+40>>2]=.30000001192092896;f[a+44>>2]=0;f[a>>2]=4624;f[a+48>>2]=f[e>>2];f[a+48+4>>2]=f[e+4>>2];f[a+48+8>>2]=f[e+8>>2];f[a+48+12>>2]=f[e+12>>2];f[a+64>>2]=f[e+16>>2];f[a+64+4>>2]=f[e+16+4>>2];f[a+64+8>>2]=f[e+16+8>>2];f[a+64+12>>2]=f[e+16+12>>2];f[a+80>>2]=f[e+32>>2];f[a+80+4>>2]=f[e+32+4>>2];f[a+80+8>>2]=f[e+32+8>>2];f[a+80+12>>2]=f[e+32+12>>2];f[a+96>>2]=f[e+48>>2];f[a+96+4>>2]=f[e+48+4>>2];f[a+96+8>>2]=f[e+48+8>>2];f[a+96+12>>2]=f[e+48+12>>2];f[a+112>>2]=f[g>>2];f[a+112+4>>2]=f[g+4>>2];f[a+112+8>>2]=f[g+8>>2];f[a+112+12>>2]=f[g+12>>2];f[a+128>>2]=f[g+16>>2];f[a+128+4>>2]=f[g+16+4>>2];f[a+128+8>>2]=f[g+16+8>>2];f[a+128+12>>2]=f[g+16+12>>2];f[a+144>>2]=f[g+32>>2];f[a+144+4>>2]=f[g+32+4>>2];f[a+144+8>>2]=f[g+32+8>>2];f[a+144+12>>2]=f[g+32+12>>2];f[a+160>>2]=f[g+48>>2];f[a+160+4>>2]=f[g+48+4>>2];f[a+160+8>>2]=f[g+48+8>>2];f[a+160+12>>2]=f[g+48+12>>2];c=a+680|0;d=c+48|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(d|0));f[a+740>>2]=0;f[a+740+4>>2]=0;f[a+740+8>>2]=0;f[a+740+12>>2]=0;f[a+756>>2]=1045220557;f[a+760>>2]=1045220557;f[a+764>>2]=1045220557;f[a+768>>2]=0;f[a+768+4>>2]=0;f[a+768+8>>2]=0;f[a+768+12>>2]=0;f[a+768+16>>2]=0;n[a+728>>2]=.699999988079071;n[a+732>>2]=1.0;n[a+736>>2]=.5;b[a+788>>0]=0;n[a+792>>2]=0.0;n[a+808>>2]=0.0;b[a+789>>0]=0;n[a+796>>2]=0.0;n[a+812>>2]=0.0;b[a+790>>0]=0;n[a+800>>2]=0.0;n[a+816>>2]=0.0;n[a+928>>2]=0.0;n[a+876>>2]=0.0;n[a+880>>2]=.10000000149011612;n[a+884>>2]=300.0;n[a+868>>2]=1.0;n[a+872>>2]=-1.0;n[a+896>>2]=0.0;n[a+900>>2]=.20000000298023224;n[a+904>>2]=0.0;n[a+908>>2]=0.0;n[a+888>>2]=1.0;n[a+892>>2]=.5;f[a+924>>2]=0;n[a+916>>2]=0.0;b[a+912>>0]=0;n[a+992>>2]=0.0;n[a+940>>2]=0.0;n[a+944>>2]=.10000000149011612;n[a+948>>2]=300.0;n[a+932>>2]=1.0;n[a+936>>2]=-1.0;n[a+960>>2]=0.0;n[a+964>>2]=.20000000298023224;n[a+968>>2]=0.0;n[a+972>>2]=0.0;n[a+952>>2]=1.0;n[a+956>>2]=.5;f[a+988>>2]=0;n[a+980>>2]=0.0;b[a+976>>0]=0;n[a+1056>>2]=0.0;n[a+1004>>2]=0.0;n[a+1008>>2]=.10000000149011612;n[a+1012>>2]=300.0;n[a+996>>2]=1.0;n[a+1e3>>2]=-1.0;n[a+1024>>2]=0.0;n[a+1028>>2]=.20000000298023224;n[a+1032>>2]=0.0;n[a+1036>>2]=0.0;n[a+1016>>2]=1.0;n[a+1020>>2]=.5;f[a+1052>>2]=0;n[a+1044>>2]=0.0;b[a+1040>>0]=0;b[a+1300>>0]=h&1;b[a+1301>>0]=1;f[a+1304>>2]=0;b[a+1308>>0]=0;od(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);return}function Le(a,b,c){a=a|0;b=b|0;c=+c;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0,l=0;if(!b)b=0;else b=(f[b+236>>2]&2|0)==0?0:b;f[a+64>>2]=0;f[a+64+4>>2]=0;f[a+64+8>>2]=0;f[a+64+12>>2]=0;f[a+64+16>>2]=0;f[a+64+20>>2]=0;f[a+64+24>>2]=0;f[a+64+28>>2]=0;f[a+144>>2]=0;f[a+144+4>>2]=0;f[a+144+8>>2]=0;f[a+144+12>>2]=0;f[a+144+16>>2]=0;f[a+144+20>>2]=0;f[a+144+24>>2]=0;f[a+144+28>>2]=0;if(!b){f[a>>2]=1065353216;f[a+4>>2]=0;f[a+4+4>>2]=0;f[a+4+8>>2]=0;f[a+4+12>>2]=0;f[a+20>>2]=1065353216;f[a+24>>2]=0;f[a+24+4>>2]=0;f[a+24+8>>2]=0;f[a+24+12>>2]=0;f[a+40>>2]=1065353216;f[a+44>>2]=0;f[a+44+4>>2]=0;f[a+44+8>>2]=0;f[a+44+12>>2]=0;f[a+44+16>>2]=0;f[a+240>>2]=0;f[a+128>>2]=0;f[a+128+4>>2]=0;f[a+128+8>>2]=0;f[a+128+12>>2]=0;f[a+96>>2]=1065353216;f[a+100>>2]=1065353216;f[a+104>>2]=1065353216;n[a+108>>2]=0.0;f[a+112>>2]=1065353216;f[a+116>>2]=1065353216;f[a+120>>2]=1065353216;n[a+124>>2]=0.0;b=a+176|0;d=b+60|0;do{f[b>>2]=0;b=b+4|0}while((b|0)<(d|0));a=a+236|0;n[a>>2]=0.0;return}else{d=b+4|0;f[a>>2]=f[d>>2];f[a+4>>2]=f[d+4>>2];f[a+8>>2]=f[d+8>>2];f[a+12>>2]=f[d+12>>2];d=b+20|0;f[a+16>>2]=f[d>>2];f[a+16+4>>2]=f[d+4>>2];f[a+16+8>>2]=f[d+8>>2];f[a+16+12>>2]=f[d+12>>2];d=b+36|0;f[a+32>>2]=f[d>>2];f[a+32+4>>2]=f[d+4>>2];f[a+32+8>>2]=f[d+8>>2];f[a+32+12>>2]=f[d+12>>2];d=b+52|0;f[a+48>>2]=f[d>>2];f[a+48+4>>2]=f[d+4>>2];f[a+48+8>>2]=f[d+8>>2];f[a+48+12>>2]=f[d+12>>2];d=b+344|0;j=+n[d>>2];k=b+348|0;i=j*+n[b+352>>2];h=j*+n[b+356>>2];n[a+128>>2]=j*+n[k>>2];n[a+132>>2]=i;n[a+136>>2]=h;n[a+140>>2]=0.0;f[a+240>>2]=b;l=b+544|0;f[a+96>>2]=f[l>>2];f[a+96+4>>2]=f[l+4>>2];f[a+96+8>>2]=f[l+8>>2];f[a+96+12>>2]=f[l+12>>2];f[a+112>>2]=f[k>>2];f[a+112+4>>2]=f[k+4>>2];f[a+112+8>>2]=f[k+8>>2];f[a+112+12>>2]=f[k+12>>2];k=b+312|0;f[a+176>>2]=f[k>>2];f[a+176+4>>2]=f[k+4>>2];f[a+176+8>>2]=f[k+8>>2];f[a+176+12>>2]=f[k+12>>2];k=b+328|0;f[a+192>>2]=f[k>>2];f[a+192+4>>2]=f[k+4>>2];f[a+192+8>>2]=f[k+8>>2];f[a+192+12>>2]=f[k+12>>2];h=+n[d>>2];i=h*+n[b+416>>2]*c;j=h*+n[b+420>>2]*c;n[a+208>>2]=h*+n[b+412>>2]*c;n[a+212>>2]=i;n[a+216>>2]=j;n[a+220>>2]=0.0;j=+n[b+428>>2];i=+n[b+432>>2];h=+n[b+436>>2];g=(j*+n[b+268>>2]+i*+n[b+284>>2]+h*+n[b+300>>2])*c;e=(j*+n[b+272>>2]+i*+n[b+288>>2]+h*+n[b+304>>2])*c;n[a+224>>2]=(+n[b+264>>2]*j+ +n[b+280>>2]*i+ +n[b+296>>2]*h)*c;n[a+228>>2]=g;n[a+232>>2]=e;a=a+236|0;n[a>>2]=0.0;return}}function Me(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,i=0,j=0,k=0;f[b+16>>2]=f[a+20>>2];f[b+20>>2]=f[a+24>>2];f[b+24>>2]=f[a+28>>2];f[b+28>>2]=f[a+32>>2];f[b>>2]=f[a+4>>2];f[b+4>>2]=f[a+8>>2];f[b+8>>2]=f[a+12>>2];f[b+12>>2]=f[a+16>>2];f[b+32>>2]=f[a+36>>2];f[b+36>>2]=f[a+40>>2];f[b+40>>2]=f[a+44>>2];f[b+44>>2]=f[a+48>>2];f[b+48>>2]=f[a+56>>2];f[b+52>>2]=h[a+60>>0];k=f[a+88>>2]|0;f[b+56>>2]=k;if(k){k=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+96>>2]|0)|0;f[b+64>>2]=k;if(k|0){j=f[a+88>>2]|0;k=Fb[f[(f[c>>2]|0)+16>>2]&63](c,48,j)|0;if((j|0)>0){e=f[a+96>>2]|0;g=f[k+8>>2]|0;i=0;while(1){f[g+16>>2]=f[e+(i<<6)+16>>2];f[g+20>>2]=f[e+(i<<6)+20>>2];f[g+24>>2]=f[e+(i<<6)+24>>2];f[g+28>>2]=f[e+(i<<6)+28>>2];f[g>>2]=f[e+(i<<6)>>2];f[g+4>>2]=f[e+(i<<6)+4>>2];f[g+8>>2]=f[e+(i<<6)+8>>2];f[g+12>>2]=f[e+(i<<6)+12>>2];f[g+32>>2]=f[e+(i<<6)+32>>2];f[g+36>>2]=f[e+(i<<6)+36>>2];f[g+40>>2]=f[e+(i<<6)+40>>2];i=i+1|0;if((i|0)==(j|0))break;else g=g+48|0}}else e=f[a+96>>2]|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,k,18648,1497453121,e)}}else f[b+64>>2]=0;k=f[a+128>>2]|0;f[b+60>>2]=k;if(k){k=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+136>>2]|0)|0;f[b+68>>2]=k;if(k|0){j=f[a+128>>2]|0;k=Fb[f[(f[c>>2]|0)+16>>2]&63](c,16,j)|0;if((j|0)>0){e=f[a+136>>2]|0;g=f[k+8>>2]|0;i=0;while(1){f[g+12>>2]=f[e+(i<<4)+12>>2];d[g+6>>1]=d[e+(i<<4)+6>>1]|0;d[g+8>>1]=d[e+(i<<4)+8>>1]|0;d[g+10>>1]=d[e+(i<<4)+10>>1]|0;d[g>>1]=d[e+(i<<4)>>1]|0;d[g+2>>1]=d[e+(i<<4)+2>>1]|0;d[g+4>>1]=d[e+(i<<4)+4>>1]|0;i=i+1|0;if((i|0)==(j|0))break;else g=g+16|0}}else e=f[a+136>>2]|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,k,18671,1497453121,e)}}else f[b+68>>2]=0;f[b+76>>2]=f[a+144>>2];k=f[a+152>>2]|0;f[b+80>>2]=k;if(!k){f[b+72>>2]=0;return 18715}k=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+160>>2]|0)|0;f[b+72>>2]=k;if(!k)return 18715;j=f[a+152>>2]|0;k=Fb[f[(f[c>>2]|0)+16>>2]&63](c,20,j)|0;if((j|0)>0){e=f[a+160>>2]|0;g=f[k+8>>2]|0;i=0;while(1){d[g+14>>1]=d[e+(i<<5)+6>>1]|0;d[g+16>>1]=d[e+(i<<5)+8>>1]|0;d[g+18>>1]=d[e+(i<<5)+10>>1]|0;d[g+8>>1]=d[e+(i<<5)>>1]|0;d[g+10>>1]=d[e+(i<<5)+2>>1]|0;d[g+12>>1]=d[e+(i<<5)+4>>1]|0;f[g>>2]=f[e+(i<<5)+12>>2];f[g+4>>2]=f[e+(i<<5)+16>>2];i=i+1|0;if((i|0)==(j|0))break;else g=g+20|0}}else e=f[a+160>>2]|0;ac[f[(f[c>>2]|0)+20>>2]&31](c,k,18694,1497453121,e);return 18715}function Ne(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,v=0.0,w=0.0;s=u;u=u+544|0;Hf(a,b,c,d,g,s+384|0,0);f[s+364>>2]=0;f[s+128>>2]=0;f[s+128+4>>2]=0;f[s+128+8>>2]=0;f[s+128+12>>2]=0;f[s+376>>2]=2;f[s+368>>2]=0;n[s+144>>2]=0.0;a=Jc(s,s+384|0,e)|0;if(a|0){f[g>>2]=(a|0)==1?1:2;g=0;u=s;return g|0}a=f[s+372>>2]|0;if(!(f[a+32>>2]|0)){m=0.0;l=0.0;k=0.0;j=0.0;i=0.0;h=0.0}else{e=0;k=0.0;l=0.0;m=0.0;h=0.0;i=0.0;j=0.0;do{r=+n[a+16+(e<<2)>>2];c=f[s+384+120>>2]|0;t=f[s+384+124>>2]|0;d=(f[s+384>>2]|0)+(t>>1)|0;if(t&1)c=f[(f[d>>2]|0)+c>>2]|0;Vb[c&127](s+528|0,d,f[a+(e<<2)>>2]|0);k=k+r*+n[s+528>>2];l=l+r*+n[s+528+4>>2];m=m+r*+n[s+528+8>>2];a=f[(f[s+372>>2]|0)+(e<<2)>>2]|0;o=-+n[a>>2];p=-+n[a+4>>2];q=-+n[a+8>>2];a=f[s+384+120>>2]|0;t=f[s+384+124>>2]|0;c=(f[s+384+4>>2]|0)+(t>>1)|0;if(t&1)a=f[(f[c>>2]|0)+a>>2]|0;w=+n[s+384+24>>2]*o+ +n[s+384+28>>2]*p+ +n[s+384+32>>2]*q;v=+n[s+384+40>>2]*o+ +n[s+384+44>>2]*p+ +n[s+384+48>>2]*q;n[s+512>>2]=+n[s+384+8>>2]*o+ +n[s+384+12>>2]*p+ +n[s+384+16>>2]*q;n[s+512+4>>2]=w;n[s+512+8>>2]=v;n[s+512+12>>2]=0.0;Vb[a&127](s+528|0,c,s+512|0);o=+n[s+528>>2];p=+n[s+528+4>>2];q=+n[s+528+8>>2];h=h+r*(o*+n[s+384+56>>2]+p*+n[s+384+60>>2]+q*+n[s+384+64>>2]+ +n[s+384+104>>2]);i=i+r*(o*+n[s+384+72>>2]+p*+n[s+384+76>>2]+q*+n[s+384+80>>2]+ +n[s+384+108>>2]);j=j+r*(o*+n[s+384+88>>2]+p*+n[s+384+92>>2]+q*+n[s+384+96>>2]+ +n[s+384+112>>2]);e=e+1|0;a=f[s+372>>2]|0}while(e>>>0<(f[a+32>>2]|0)>>>0)}q=k*+n[b+16>>2]+l*+n[b+20>>2]+m*+n[b+24>>2]+ +n[b+52>>2];r=k*+n[b+32>>2]+l*+n[b+36>>2]+m*+n[b+40>>2]+ +n[b+56>>2];n[g+4>>2]=k*+n[b>>2]+l*+n[b+4>>2]+m*+n[b+8>>2]+ +n[b+48>>2];n[g+8>>2]=q;n[g+12>>2]=r;n[g+16>>2]=0.0;r=h*+n[b+16>>2]+i*+n[b+20>>2]+j*+n[b+24>>2]+ +n[b+52>>2];q=h*+n[b+32>>2]+i*+n[b+36>>2]+j*+n[b+40>>2]+ +n[b+56>>2];n[g+20>>2]=h*+n[b>>2]+i*+n[b+4>>2]+j*+n[b+8>>2]+ +n[b+48>>2];n[g+24>>2]=r;n[g+28>>2]=q;n[g+32>>2]=0.0;q=k-h;r=l-i;w=m-j;n[g+48>>2]=0.0;v=+L(+(q*q+r*r+w*w));n[g+52>>2]=v;v=v>9.999999747378752e-05?1.0/v:1.0;n[g+36>>2]=v*q;n[g+40>>2]=v*r;n[g+44>>2]=v*w;t=1;u=s;return t|0}function Oe(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0;if(b[a+1308>>0]|0){f[c>>2]=0;f[c+4>>2]=0;return}od(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);f[c>>2]=0;f[c+4>>2]=6;if((f[a+856>>2]|0)==0?(b[a+788>>0]|0)==0:0){d=0;e=6}else{f[c>>2]=1;f[c+4>>2]=5;d=1;e=5}if(!((f[a+860>>2]|0)==0?(b[a+789>>0]|0)==0:0)){d=d+1|0;f[c>>2]=d;e=e+-1|0;f[c+4>>2]=e}if(!((f[a+864>>2]|0)==0?(b[a+790>>0]|0)==0:0)){d=d+1|0;f[c>>2]=d;e=e+-1|0;f[c+4>>2]=e}i=+n[a+868>>2];j=+n[a+872>>2];k=+ak(+n[a+1192>>2],i,j);n[a+920>>2]=k;do if(!(i>j)){if(i>k){f[a+924>>2]=1;n[a+916>>2]=k-i;if(!(k-i>3.1415927410125732))if(k-i<-3.1415927410125732)h=6.2831854820251465;else{l=17;break}else h=-6.2831854820251465;n[a+916>>2]=k-i+h;l=17;break}if(j<k){f[a+924>>2]=2;n[a+916>>2]=k-j;if(!(k-j>3.1415927410125732))if(k-j<-3.1415927410125732)h=6.2831854820251465;else{l=17;break}else h=-6.2831854820251465;n[a+916>>2]=k-j+h;l=17}else{g=a+924|0;l=16}}else{g=a+924|0;l=16}while(0);if((l|0)==16){f[g>>2]=0;if(b[a+912>>0]|0)l=17}if((l|0)==17){d=d+1|0;f[c>>2]=d;e=e+-1|0;f[c+4>>2]=e}i=+n[a+932>>2];j=+n[a+936>>2];k=+ak(+n[a+1196>>2],i,j);n[a+984>>2]=k;do if(!(i>j)){if(i>k){f[a+988>>2]=1;n[a+980>>2]=k-i;if(!(k-i>3.1415927410125732))if(k-i<-3.1415927410125732)h=6.2831854820251465;else{l=30;break}else h=-6.2831854820251465;n[a+980>>2]=k-i+h;l=30;break}if(j<k){f[a+988>>2]=2;n[a+980>>2]=k-j;if(!(k-j>3.1415927410125732))if(k-j<-3.1415927410125732)h=6.2831854820251465;else{l=30;break}else h=-6.2831854820251465;n[a+980>>2]=k-j+h;l=30}else{g=a+988|0;l=29}}else{g=a+988|0;l=29}while(0);if((l|0)==29){f[g>>2]=0;if(b[a+976>>0]|0)l=30}if((l|0)==30){d=d+1|0;f[c>>2]=d;e=e+-1|0;f[c+4>>2]=e}i=+n[a+996>>2];j=+n[a+1e3>>2];k=+ak(+n[a+1200>>2],i,j);n[a+1048>>2]=k;do if(!(i>j)){if(i>k){f[a+1052>>2]=1;n[a+1044>>2]=k-i;if(!(k-i>3.1415927410125732))if(k-i<-3.1415927410125732)h=6.2831854820251465;else break;else h=-6.2831854820251465;n[a+1044>>2]=k-i+h;break}if(j<k){f[a+1052>>2]=2;n[a+1044>>2]=k-j;if(!(k-j>3.1415927410125732))if(k-j<-3.1415927410125732)h=6.2831854820251465;else break;else h=-6.2831854820251465;n[a+1044>>2]=k-j+h}else{m=a+1052|0;l=41}}else{m=a+1052|0;l=41}while(0);if((l|0)==41?(f[m>>2]=0,(b[a+1040>>0]|0)==0):0)return;f[c>>2]=d+1;f[c+4>>2]=e+-1;return}function Pe(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;c=u;u=u+144|0;n[a+36>>2]=0.0;f[c+128>>2]=0;f[c+128+4>>2]=0;f[c+128+8>>2]=0;f[c+128+12>>2]=0;b=0;do{d=c+128+(b<<2)|0;n[d>>2]=1.0;A=f[a+28>>2]|0;I=f[A+4>>2]|0;f[c+80>>2]=I;F=f[A+20>>2]|0;f[c+80+4>>2]=F;C=f[A+36>>2]|0;f[c+80+8>>2]=C;n[c+80+12>>2]=0.0;H=f[A+8>>2]|0;f[c+80+16>>2]=H;E=f[A+24>>2]|0;f[c+80+20>>2]=E;B=f[A+40>>2]|0;f[c+80+24>>2]=B;n[c+80+28>>2]=0.0;G=f[A+12>>2]|0;f[c+80+32>>2]=G;D=f[A+28>>2]|0;f[c+80+36>>2]=D;z=f[A+44>>2]|0;f[c+80+40>>2]=z;n[c+80+44>>2]=0.0;e=f[a+32>>2]|0;y=f[e+4>>2]|0;f[c+32>>2]=y;v=f[e+20>>2]|0;f[c+32+4>>2]=v;q=f[e+36>>2]|0;f[c+32+8>>2]=q;n[c+32+12>>2]=0.0;x=f[e+8>>2]|0;f[c+32+16>>2]=x;t=f[e+24>>2]|0;f[c+32+20>>2]=t;p=f[e+40>>2]|0;f[c+32+24>>2]=p;n[c+32+28>>2]=0.0;w=f[e+12>>2]|0;f[c+32+32>>2]=w;r=f[e+28>>2]|0;f[c+32+36>>2]=r;g=f[e+44>>2]|0;f[c+32+40>>2]=g;n[c+32+44>>2]=0.0;m=+n[a+300>>2];j=m*(f[s>>2]=I,+n[s>>2]);h=+n[a+304>>2];j=j+h*(f[s>>2]=H,+n[s>>2]);i=+n[a+308>>2];j=j+i*(f[s>>2]=G,+n[s>>2]);o=m*(f[s>>2]=F,+n[s>>2]);o=o+h*(f[s>>2]=E,+n[s>>2]);o=o+i*(f[s>>2]=D,+n[s>>2]);m=m*(f[s>>2]=C,+n[s>>2]);h=m+h*(f[s>>2]=B,+n[s>>2]);m=+n[A+52>>2];l=+n[A+56>>2];k=+n[A+60>>2];k=h+i*(f[s>>2]=z,+n[s>>2])+k-k;n[c+16>>2]=j+m-m;n[c+16+4>>2]=o+l-l;n[c+16+8>>2]=k;n[c+16+12>>2]=0.0;k=+n[a+316>>2];l=k*(f[s>>2]=y,+n[s>>2]);o=+n[a+320>>2];l=l+o*(f[s>>2]=x,+n[s>>2]);m=+n[a+324>>2];l=l+m*(f[s>>2]=w,+n[s>>2]);j=k*(f[s>>2]=v,+n[s>>2]);j=j+o*(f[s>>2]=t,+n[s>>2]);j=j+m*(f[s>>2]=r,+n[s>>2]);k=k*(f[s>>2]=q,+n[s>>2]);o=k+o*(f[s>>2]=p,+n[s>>2]);k=+n[e+52>>2];i=+n[e+56>>2];h=+n[e+60>>2];h=o+m*(f[s>>2]=g,+n[s>>2])+h-h;n[c>>2]=l+k-k;n[c+4>>2]=j+i-i;n[c+8>>2]=h;n[c+12>>2]=0.0;g=f[a+28>>2]|0;e=f[a+32>>2]|0;Qg(a+48+(b*84|0)|0,c+80|0,c+32|0,c+16|0,c,c+128|0,g+396|0,+n[g+344>>2],e+396|0,+n[e+344>>2]);n[d>>2]=0.0;b=b+1|0}while((b|0)!=3);u=c;return}function Qe(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0;C=+n[a+452>>2];v=+n[a+304>>2];r=+n[a+300>>2];if(v>0.0|r>0.0)g=(f[a+288>>2]|0)<4;else g=0;D=f[a+720>>2]|0;y=+n[D+(c*104|0)+88>>2];if(!(y>0.0))return;m=f[f[a+684>>2]>>2]|0;if(!g)return;z=+n[D+(c*104|0)+40>>2];k=z-+n[b>>2];A=+n[D+(c*104|0)+44>>2];l=A-+n[b+4>>2];B=+n[D+(c*104|0)+48>>2];i=B-+n[b+8>>2];j=+L(+(k*k+l*l+i*i));if(!(k*k+l*l+i*i>1.1920928955078125e-07))return;u=k*(1.0/j);w=l*(1.0/j);x=i*(1.0/j);p=+n[D+(c*104|0)+72>>2];q=+n[D+(c*104|0)+76>>2];t=+n[D+(c*104|0)+80>>2];switch(f[a+288>>2]|0){case 2:{o=k*p+l*q+i*t<0.0?-1.0:1.0;e=x*t*o+(u*p*o+w*q*o);h=+n[D+(c*104|0)+92>>2]*.5;d=(f[s>>2]=m,+n[s>>2]);l=e*r*.5*d*(k*k+l*l+i*i)*h;if(e>0.0&e<.9847999811172485){i=v*.5*d*j*h*+L(+(1.0-e*e));j=(x*(u*t*o-x*p*o)-w*(w*p*o-u*q*o))*i;k=(u*(w*p*o-u*q*o)-x*(x*q*o-w*t*o))*i;i=(w*(x*q*o-w*t*o)-u*(u*t*o-x*p*o))*i}else{j=0.0;k=0.0;i=0.0}d=C*y*-(x*l)*C*y*-(x*l)+(y*-(u*l)*C*y*-(u*l)*C+C*y*-(w*l)*C*y*-(w*l));if(d>0.0?d>=z*z+A*A+B*B:0){d=+L(+(z*z+A*A+B*B))/+L(+d)*.800000011920929;h=d*-(u*l);e=d*-(x*l);d=d*-(w*l)}else{h=-(u*l);e=-(x*l);d=-(w*l)}B=d+ +n[D+(c*104|0)+60>>2];C=e+ +n[D+(c*104|0)+64>>2];n[D+(c*104|0)+56>>2]=j+(h+ +n[D+(c*104|0)+56>>2]);n[D+(c*104|0)+60>>2]=k+B;n[D+(c*104|0)+64>>2]=i+C;return}case 1:case 3:case 0:{d=k*p+l*q+i*t<0.0?-1.0:1.0;if(!(i*t*d+(k*p*d+l*q*d)>0.0))return;o=-((k*k+l*l+i*i)*(i*t*d+(k*p*d+l*q*d))*+n[D+(c*104|0)+92>>2]*.5*(f[s>>2]=m,+n[s>>2]));h=u*r*o+(p*d*v*o+0.0);e=w*r*o+(q*d*v*o+0.0);d=x*r*o+(t*d*v*o+0.0);if(C*y*d*C*y*d+(C*y*h*C*y*h+C*y*e*C*y*e)>z*z+A*A+B*B){x=1.0/+L(+(d*d+(h*h+e*e)));n[D+(c*104|0)+56>>2]=+n[D+(c*104|0)+56>>2]-1.0/(C*y)*h*x*(B*d*x+(z*h*x+A*e*x));n[D+(c*104|0)+60>>2]=+n[D+(c*104|0)+60>>2]-1.0/(C*y)*e*x*(B*d*x+(z*h*x+A*e*x));n[D+(c*104|0)+64>>2]=+n[D+(c*104|0)+64>>2]-1.0/(C*y)*d*x*(B*d*x+(z*h*x+A*e*x));return}else{n[D+(c*104|0)+56>>2]=h+ +n[D+(c*104|0)+56>>2];n[D+(c*104|0)+60>>2]=e+ +n[D+(c*104|0)+60>>2];n[D+(c*104|0)+64>>2]=d+ +n[D+(c*104|0)+64>>2];return}}default:return}}function Re(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(f[a+204>>2]&2)){f[a+68>>2]=f[b>>2];f[a+68+4>>2]=f[b+4>>2];f[a+68+8>>2]=f[b+8>>2];f[a+68+12>>2]=f[b+12>>2];f[a+84>>2]=f[b+16>>2];f[a+84+4>>2]=f[b+16+4>>2];f[a+84+8>>2]=f[b+16+8>>2];f[a+84+12>>2]=f[b+16+12>>2];f[a+100>>2]=f[b+32>>2];f[a+100+4>>2]=f[b+32+4>>2];f[a+100+8>>2]=f[b+32+8>>2];f[a+100+12>>2]=f[b+32+12>>2];f[a+116>>2]=f[b+48>>2];f[a+116+4>>2]=f[b+48+4>>2];f[a+116+8>>2]=f[b+48+8>>2];f[a+116+12>>2]=f[b+48+12>>2];c=a+20|0;d=b+16|0;e=a+36|0;g=b+32|0;h=a+52|0;i=b+48|0;j=a+4|0}else{f[a+68>>2]=f[a+4>>2];f[a+68+4>>2]=f[a+4+4>>2];f[a+68+8>>2]=f[a+4+8>>2];f[a+68+12>>2]=f[a+4+12>>2];f[a+84>>2]=f[a+20>>2];f[a+84+4>>2]=f[a+20+4>>2];f[a+84+8>>2]=f[a+20+8>>2];f[a+84+12>>2]=f[a+20+12>>2];f[a+100>>2]=f[a+36>>2];f[a+100+4>>2]=f[a+36+4>>2];f[a+100+8>>2]=f[a+36+8>>2];f[a+100+12>>2]=f[a+36+12>>2];f[a+116>>2]=f[a+52>>2];f[a+116+4>>2]=f[a+52+4>>2];f[a+116+8>>2]=f[a+52+8>>2];f[a+116+12>>2]=f[a+52+12>>2];c=a+20|0;d=b+16|0;e=a+36|0;g=b+32|0;h=a+52|0;i=b+48|0;j=a+4|0}f[a+132>>2]=f[a+312>>2];f[a+132+4>>2]=f[a+312+4>>2];f[a+132+8>>2]=f[a+312+8>>2];f[a+132+12>>2]=f[a+312+12>>2];f[a+148>>2]=f[a+328>>2];f[a+148+4>>2]=f[a+328+4>>2];f[a+148+8>>2]=f[a+328+8>>2];f[a+148+12>>2]=f[a+328+12>>2];f[j>>2]=f[b>>2];f[j+4>>2]=f[b+4>>2];f[j+8>>2]=f[b+8>>2];f[j+12>>2]=f[b+12>>2];f[c>>2]=f[d>>2];f[c+4>>2]=f[d+4>>2];f[c+8>>2]=f[d+8>>2];f[c+12>>2]=f[d+12>>2];f[e>>2]=f[g>>2];f[e+4>>2]=f[g+4>>2];f[e+8>>2]=f[g+8>>2];f[e+12>>2]=f[g+12>>2];f[h>>2]=f[i>>2];f[h+4>>2]=f[i+4>>2];f[h+8>>2]=f[i+8>>2];f[h+12>>2]=f[i+12>>2];w=+n[a+4>>2];q=+n[a+396>>2];v=+n[a+8>>2];o=+n[a+400>>2];u=+n[a+12>>2];l=+n[a+404>>2];t=+n[a+20>>2];s=+n[a+24>>2];r=+n[a+28>>2];p=+n[a+36>>2];m=+n[a+40>>2];k=+n[a+44>>2];n[a+264>>2]=w*w*q+v*v*o+u*u*l;n[a+268>>2]=w*q*t+v*o*s+u*l*r;n[a+272>>2]=w*q*p+v*o*m+u*l*k;n[a+276>>2]=0.0;n[a+280>>2]=w*q*t+v*o*s+u*l*r;n[a+284>>2]=t*q*t+s*o*s+r*l*r;n[a+288>>2]=q*t*p+o*s*m+l*r*k;n[a+292>>2]=0.0;n[a+296>>2]=w*q*p+v*o*m+u*l*k;n[a+300>>2]=t*q*p+s*o*m+r*l*k;n[a+304>>2]=p*q*p+m*o*m+k*l*k;n[a+308>>2]=0.0;return}function Se(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;g=u;u=u+160|0;d=f[a+4>>2]|0;e=f[d+12>>2]|0;D=+n[e>>2];C=+n[e+4>>2];B=+n[e+8>>2];A=+n[e+16>>2];z=+n[e+20>>2];y=+n[e+24>>2];q=+n[e+32>>2];o=+n[e+36>>2];l=+n[e+40>>2];d=f[(f[d+4>>2]|0)+24>>2]|0;x=+n[d+(c*80|0)>>2];w=+n[d+(c*80|0)+16>>2];v=+n[d+(c*80|0)+32>>2];t=+n[d+(c*80|0)+4>>2];s=+n[d+(c*80|0)+20>>2];r=+n[d+(c*80|0)+36>>2];p=+n[d+(c*80|0)+8>>2];m=+n[d+(c*80|0)+24>>2];k=+n[d+(c*80|0)+40>>2];F=+n[d+(c*80|0)+48>>2];E=+n[d+(c*80|0)+52>>2];h=+n[d+(c*80|0)+56>>2];j=+n[e+48>>2]+(D*F+C*E+B*h);i=+n[e+52>>2]+(A*F+z*E+y*h);h=+n[e+56>>2]+(q*F+o*E+l*h);n[g+88>>2]=D*x+C*w+B*v;n[g+88+4>>2]=D*t+C*s+B*r;n[g+88+8>>2]=D*p+C*m+B*k;n[g+88+12>>2]=0.0;n[g+88+16>>2]=A*x+z*w+y*v;n[g+88+20>>2]=A*t+z*s+y*r;n[g+88+24>>2]=A*p+z*m+y*k;n[g+88+28>>2]=0.0;n[g+88+32>>2]=q*x+o*w+l*v;n[g+88+36>>2]=q*t+o*s+l*r;n[g+88+40>>2]=q*p+o*m+l*k;n[g+88+44>>2]=0.0;n[g+88+48>>2]=j;n[g+88+52>>2]=i;n[g+88+56>>2]=h;n[g+88+60>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,g+88|0,g+72|0,g+56|0);e=f[a+8>>2]|0;d=f[e+4>>2]|0;Yb[f[(f[d>>2]|0)+8>>2]&127](d,f[e+12>>2]|0,g+40|0,g+24|0);if(!(+n[g+72>>2]>+n[g+24>>2])?!(+n[g+56>>2]<+n[g+40>>2]):0)d=1;else d=0;if(!(!(+n[g+72+8>>2]>+n[g+24+8>>2])?!(+n[g+56+8>>2]<+n[g+40+8>>2]):0))d=0;if(+n[g+72+4>>2]>+n[g+24+4>>2]){u=g;return}if(+n[g+56+4>>2]<+n[g+40+4>>2]|d^1){u=g;return}d=f[a+4>>2]|0;e=f[d+8>>2]|0;f[g>>2]=d;f[g+4>>2]=b;f[g+8>>2]=e;f[g+12>>2]=g+88;f[g+16>>2]=-1;f[g+20>>2]=c;if(!(f[(f[a+24>>2]|0)+(c<<2)>>2]|0)){e=f[a+12>>2]|0;e=Gb[f[(f[e>>2]|0)+8>>2]&31](e,g,f[a+8>>2]|0,f[a+28>>2]|0)|0;f[(f[a+24>>2]|0)+(c<<2)>>2]=e;e=f[a+4>>2]|0}else e=d;b=f[a+20>>2]|0;d=f[b+8>>2]|0;if((f[d+8>>2]|0)==(f[e+8>>2]|0)){f[b+8>>2]=g;Vb[f[(f[b>>2]|0)+8>>2]&127](b,-1,c)}else{d=f[b+12>>2]|0;f[b+12>>2]=g;Vb[f[(f[b>>2]|0)+12>>2]&127](b,-1,c)}c=f[(f[a+24>>2]|0)+(c<<2)>>2]|0;ac[f[(f[c>>2]|0)+8>>2]&31](c,g,f[a+8>>2]|0,f[a+16>>2]|0,f[a+20>>2]|0);c=f[a+20>>2]|0;f[((f[(f[c+8>>2]|0)+8>>2]|0)==(f[(f[a+4>>2]|0)+8>>2]|0)?c+8|0:c+12|0)>>2]=d;u=g;return}function Te(){if(b[22784]|0)return;if(!(fz(22784)|0))return;f[6205]=0;f[6206]=-2147483648;f[6207]=-1082130432;n[6208]=0.0;f[6209]=1060716128;f[6210]=-1090087446;f[6211]=-1092290076;n[6212]=0.0;f[6213]=-1098022214;f[6214]=-1084636126;f[6215]=-1092290076;n[6216]=0.0;f[6217]=-1083901670;f[6218]=-2147483648;f[6219]=-1092290177;n[6220]=0.0;f[6221]=-1098022214;f[6222]=1062847522;f[6223]=-1092290043;n[6224]=0.0;f[6225]=1060716128;f[6226]=1057396202;f[6227]=-1092290076;n[6228]=0.0;f[6229]=1049461434;f[6230]=-1084636126;f[6231]=1055193605;n[6232]=0.0;f[6233]=-1086767520;f[6234]=-1090087446;f[6235]=1055193572;n[6236]=0.0;f[6237]=-1086767520;f[6238]=1057396202;f[6239]=1055193572;n[6240]=0.0;f[6241]=1049461434;f[6242]=1062847522;f[6243]=1055193572;n[6244]=0.0;f[6245]=1063581978;f[6246]=0;f[6247]=1055193471;n[6248]=0.0;f[6249]=-2147483648;f[6250]=0;f[6251]=1065353216;n[6252]=0.0;f[6253]=1054458864;f[6254]=-1096927567;f[6255]=-1084636042;n[6256]=0.0;f[6257]=-1104782626;f[6258]=-1090519208;f[6259]=-1084636042;n[6260]=0.0;f[6261]=1049007812;f[6262]=-1085334679;f[6263]=-1090087228;n[6264]=0.0;f[6265]=1054458864;f[6266]=1050556081;f[6267]=-1084636042;n[6268]=0.0;f[6269]=1062847505;f[6270]=-2147483648;f[6271]=-1090087262;n[6272]=0.0;f[6273]=-1090087362;f[6274]=-2147483648;f[6275]=-1084636076;n[6276]=0.0;f[6277]=-1087361736;f[6278]=-1090519141;f[6279]=-1090087262;n[6280]=0.0;f[6281]=-1104782626;f[6282]=1056964440;f[6283]=-1084636042;n[6284]=0.0;f[6285]=-1087361736;f[6286]=1056964507;f[6287]=-1090087262;n[6288]=0.0;f[6289]=1049007812;f[6290]=1062148969;f[6291]=-1090087228;n[6292]=0.0;f[6293]=1064532105;f[6294]=1050556148;f[6295]=0;n[6296]=0.0;f[6297]=1064532105;f[6298]=-1096927500;f[6299]=0;n[6300]=0.0;f[6301]=1058437413;f[6302]=-1085334595;f[6303]=0;n[6304]=0.0;f[6305]=0;f[6306]=-1082130432;f[6307]=0;n[6308]=0.0;f[6309]=-1089046235;f[6310]=-1085334595;f[6311]=0;n[6312]=0.0;f[6313]=-1082951543;f[6314]=-1096927500;f[6315]=-2147483648;n[6316]=0.0;f[6317]=-1082951543;f[6318]=1050556148;f[6319]=-2147483648;n[6320]=0.0;f[6321]=-1089046235;f[6322]=1062149053;f[6323]=-2147483648;n[6324]=0.0;f[6325]=-2147483648;f[6326]=1065353216;f[6327]=-2147483648;n[6328]=0.0;f[6329]=1058437413;f[6330]=1062149053;f[6331]=-2147483648;n[6332]=0.0;f[6333]=1060121912;f[6334]=-1090519141;f[6335]=1057396386;n[6336]=0.0;f[6337]=-1098475836;f[6338]=-1085334679;f[6339]=1057396420;n[6340]=0.0;f[6341]=-1084636143;f[6342]=0;f[6343]=1057396386;n[6344]=0.0;f[6345]=-1098475836;f[6346]=1062148969;f[6347]=1057396420;n[6348]=0.0;f[6349]=1060121912;f[6350]=1056964507;f[6351]=1057396386;n[6352]=0.0;f[6353]=1057396286;f[6354]=0;f[6355]=1062847572;n[6356]=0.0;f[6357]=1042701022;f[6358]=-1090519208;f[6359]=1062847606;n[6360]=0.0;f[6361]=-1093024784;f[6362]=-1096927567;f[6363]=1062847606;n[6364]=0.0;f[6365]=-1093024784;f[6366]=1050556081;f[6367]=1062847606;n[6368]=0.0;f[6369]=1042701022;f[6370]=1056964440;f[6371]=1062847606;n[6372]=0.0;return}function Ue(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=+d;e=+e;g=+g;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0,V=0;V=u;u=u+32|0;z=+n[c>>2];B=+n[c+4>>2];A=+n[c+8>>2];v=+n[h>>2];s=+n[h+4>>2];q=+n[h+8>>2];p=+n[i>>2];r=+n[i+4>>2];t=+n[i+8>>2];J=1.0/+L(+((d-z)*(d-z)+(e-B)*(e-B)+(g-A)*(g-A)));K=(d-z)*J==0.0?999999984306749440.0:1.0/((d-z)*J);M=(e-B)*J==0.0?999999984306749440.0:1.0/((e-B)*J);N=(g-A)*J==0.0?999999984306749440.0:1.0/((g-A)*J);O=(z>d?d:z)+v;P=(B>e?e:B)+s;Q=(A>g?g:A)+q;R=(z<d?d:z)+p;S=(B<e?e:B)+r;T=(A<g?g:A)+t;m=f[a+56>>2]|0;a:do if((m|0)>0){x=f[a+96>>2]|0;j=0;w=0;while(1){j=j+1|0;f[V>>2]=f[x>>2];f[V+4>>2]=f[x+4>>2];f[V+8>>2]=f[x+8>>2];f[V+12>>2]=f[x+12>>2];o=x+16|0;f[V+16>>2]=f[o>>2];f[V+16+4>>2]=f[o+4>>2];f[V+16+8>>2]=f[o+8>>2];f[V+16+12>>2]=f[o+12>>2];n[V>>2]=+n[V>>2]-p;n[V+4>>2]=+n[V+4>>2]-r;n[V+8>>2]=+n[V+8>>2]-t;n[V+16>>2]=+n[V+16>>2]-v;n[V+20>>2]=+n[V+20>>2]-s;n[V+24>>2]=+n[V+24>>2]-q;if(!(O>+n[o>>2])?!(R<+n[x>>2]):0)k=1;else k=0;if(!(!(Q>+n[x+24>>2])?!(T<+n[x+8>>2]):0))k=0;if(((!(P>+n[x+20>>2])?!(S<+n[x+4>>2]|k^1):0)?(D=+n[c>>2],C=K*(+n[V+((K<0.0&1)<<4)>>2]-D),D=K*(+n[V+((K<0.0^1)<<4)>>2]-D),F=+n[c+4>>2],E=M*(+n[V+((M<0.0&1)<<4)+4>>2]-F),F=M*(+n[V+((M<0.0^1)<<4)+4>>2]-F),!(E>D|C>F)):0)?(G=E>C?E:C,y=F<D?F:D,I=+n[c+8>>2],H=N*(+n[V+((N<0.0&1)<<4)+8>>2]-I),I=N*(+n[V+((N<0.0^1)<<4)+8>>2]-I),!(H>y|G>I)):0){k=(I<y?I:y)>0.0?(H>G?H:G)<(g-A)*(g-A)*J+((d-z)*(d-z)*J+(e-B)*(e-B)*J):0;l=f[x+32>>2]|0;if(k&(l|0)==-1){Vb[f[(f[b>>2]|0)+8>>2]&127](b,f[x+36>>2]|0,f[x+40>>2]|0);l=1;m=f[a+56>>2]|0}else{o=(l|0)==-1;U=16}}else{l=f[x+32>>2]|0;k=0;o=(l|0)==-1;U=16}if((U|0)==16){U=0;l=o|k?1:l}k=l+w|0;if((k|0)>=(m|0))break a;x=x+(l<<6)|0;w=k;p=+n[i>>2];r=+n[i+4>>2];t=+n[i+8>>2];v=+n[h>>2];s=+n[h+4>>2];q=+n[h+8>>2]}}else j=0;while(0);if((f[6204]|0)>=(j|0)){u=V;return}f[6204]=j;u=V;return}function Ve(a,b,c,d,e,g){a=a|0;b=b|0;c=+c;d=+d;e=+e;g=g|0;var h=0,i=0,j=0.0,k=0.0,l=0,m=0,o=0.0,p=0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0;a:while(1){if((b|0)>0){h=-1;i=0;do{do if(f[g+(i<<2)>>2]|0){if((h|0)!=-1?!(+n[a+(i<<4)>>2]*c+ +n[a+(i<<4)+4>>2]*d+ +n[a+(i<<4)+8>>2]*e>+n[a+(h<<4)>>2]*c+ +n[a+(h<<4)+4>>2]*d+ +n[a+(h<<4)+8>>2]*e):0)break;h=i}while(0);i=i+1|0}while((i|0)!=(b|0))}else h=-1;A=g+(h<<2)|0;if((f[A>>2]|0)==3){B=36;break}j=+L(+((d-e*0.0)*(d-e*0.0)+(e*0.0-c)*(e*0.0-c)+(c*0.0-d*0.0)*(c*0.0-d*0.0)));k=+L(+((c-d*0.0)*(c-d*0.0)+((d*0.0-e)*(d*0.0-e)+(e*0.0-c*0.0)*(e*0.0-c*0.0))));if(j>k){y=(c*0.0-d*0.0)*(1.0/j);z=(e*0.0-c)*(1.0/j);s=(d-e*0.0)*(1.0/j)}else{y=(c-d*0.0)*(1.0/k);z=(e*0.0-c*0.0)*(1.0/k);s=(d*0.0-e)*(1.0/k)}t=z*e-y*d;u=y*c-s*e;v=s*d-z*c;w=(h|0)==-1;r=0;i=-1;while(1){x=+(r|0);q=+O(+(x*.01745329238474369));o=+N(+(x*.01745329238474369));j=(s*q+t*o)*.02500000037252903+c;k=(z*q+u*o)*.02500000037252903+d;o=(y*q+v*o)*.02500000037252903+e;if((b|0)>0){l=-1;m=0;do{do if(f[g+(m<<2)>>2]|0){if((l|0)!=-1?!(j*+n[a+(m<<4)>>2]+k*+n[a+(m<<4)+4>>2]+o*+n[a+(m<<4)+8>>2]>j*+n[a+(l<<4)>>2]+k*+n[a+(l<<4)+4>>2]+o*+n[a+(l<<4)+8>>2]):0)break;l=m}while(0);m=m+1|0}while((m|0)!=(b|0))}else l=-1;if((i|0)==(h|0)&(l|0)==(h|0))break a;b:do if(!((i|0)==-1|(i|0)==(l|0))?x+-40.0<=x:0){if((b|0)>0)q=x+-40.0;else{j=x+-40.0;while(1){if((i|0)==(h|0)&w){h=-1;break a}j=j+5.0;if(!(j<=x))break b;else i=-1}}while(1){o=q*.01745329238474369;C=+O(+o);o=+N(+o);j=(s*C+t*o)*.02500000037252903+c;k=(z*C+u*o)*.02500000037252903+d;o=(y*C+v*o)*.02500000037252903+e;m=-1;p=0;do{do if(f[g+(p<<2)>>2]|0){if((m|0)!=-1?!(j*+n[a+(p<<4)>>2]+k*+n[a+(p<<4)+4>>2]+o*+n[a+(p<<4)+8>>2]>j*+n[a+(m<<4)>>2]+k*+n[a+(m<<4)+4>>2]+o*+n[a+(m<<4)+8>>2]):0)break;m=p}while(0);p=p+1|0}while((p|0)!=(b|0));if((i|0)==(h|0)&(m|0)==(h|0))break a;q=q+5.0;if(!(q<=x))break;else i=m}}while(0);if((r|0)>315)break;else{r=r+45|0;i=l}}f[A>>2]=0}if((B|0)==36)return h|0;f[g+(h<<2)>>2]=3;B=h;return B|0}function We(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,o=0;o=f[a+192>>2]|0;m=+rb[f[(f[o>>2]|0)+48>>2]&15](o);o=f[a+712>>2]|0;if((o|0)>0){h=0;do{l=f[a+720>>2]|0;c=l+(h*104|0)+8|0;i=+n[b>>2]*+n[c>>2];n[c>>2]=i;c=l+(h*104|0)+12|0;j=+n[b+4>>2]*+n[c>>2];n[c>>2]=j;c=l+(h*104|0)+16|0;k=+n[b+8>>2]*+n[c>>2];n[c>>2]=k;c=l+(h*104|0)+24|0;n[c>>2]=+n[b>>2]*+n[c>>2];c=l+(h*104|0)+28|0;n[c>>2]=+n[b+4>>2]*+n[c>>2];c=l+(h*104|0)+32|0;n[c>>2]=+n[b+8>>2]*+n[c>>2];l=f[l+(h*104|0)+96>>2]|0;c=zg(a+928|0,l)|0;a:do if(c){g=f[a+936>>2]|0;if((g|0)<=-1){c=f[a+928>>2]|0;break}if(g){d=0;while(1){e=f[c+32>>2]|0;d=d+1|0;if(!e)break a;if((d|0)>=(g|0)){c=e;break}else c=e}}}else c=0;while(0);n[l>>2]=i-m;n[l+4>>2]=j-m;n[l+8>>2]=k-m;n[l+12>>2]=0.0;n[l+16>>2]=m+i;n[l+20>>2]=m+j;n[l+24>>2]=m+k;n[l+28>>2]=0.0;ff(a+928|0,c,l);h=h+1|0}while((h|0)!=(o|0))}Cg(a);c=f[a+928>>2]|0;if(c){o=f[a+192>>2]|0;j=+rb[f[(f[o>>2]|0)+48>>2]&15](o);m=+n[c+4>>2]-j;k=+n[c+8>>2]-j;n[a+892>>2]=+n[c>>2]-j;n[a+896>>2]=m;n[a+900>>2]=k;n[a+904>>2]=0.0;k=j+ +n[c+20>>2];m=j+ +n[c+24>>2];n[a+908>>2]=j+ +n[c+16>>2];n[a+912>>2]=k;n[a+916>>2]=m;n[a+920>>2]=0.0;c=f[a+188>>2]|0;if(c|0){o=f[a+684>>2]|0;l=f[o+32>>2]|0;ac[f[(f[l>>2]|0)+16>>2]&31](l,c,a+892|0,a+908|0,f[o+36>>2]|0)}}else{f[a+892>>2]=0;f[a+892+4>>2]=0;f[a+892+8>>2]=0;f[a+892+12>>2]=0;f[a+892+16>>2]=0;f[a+892+20>>2]=0;f[a+892+24>>2]=0;f[a+892+28>>2]=0}d=f[a+732>>2]|0;if((d|0)<=0){Sf(a);return}e=f[a+740>>2]|0;c=0;do{l=f[e+(c*52|0)+8>>2]|0;o=f[e+(c*52|0)+12>>2]|0;j=+n[l+8>>2]-+n[o+8>>2];k=+n[l+12>>2]-+n[o+12>>2];m=+n[l+16>>2]-+n[o+16>>2];m=+L(+(j*j+k*k+m*m));n[e+(c*52|0)+16>>2]=m;n[e+(c*52|0)+28>>2]=m*m;c=c+1|0}while((c|0)!=(d|0));c=0;do{n[e+(c*52|0)+24>>2]=(+n[(f[e+(c*52|0)+8>>2]|0)+88>>2]+ +n[(f[e+(c*52|0)+12>>2]|0)+88>>2])/+n[(f[e+(c*52|0)+4>>2]|0)+4>>2];c=c+1|0}while((c|0)!=(d|0));Sf(a);return}function Xe(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;f[a+556>>2]=f[b>>2];f[a+556+4>>2]=f[b+4>>2];f[a+556+8>>2]=f[b+8>>2];f[a+556+12>>2]=f[b+12>>2];j=+n[a+568>>2];k=+n[a+560>>2];h=+n[a+564>>2];i=+n[a+556>>2];c=-i-k*0.0-h*0.0;d=(h+j*0.0-i*0.0)*-h+(j*(j+k*0.0-h*0.0)+c*-i)-(j*0.0+i*0.0-k)*-k;e=(j*0.0+i*0.0-k)*-i+(j*(h+j*0.0-i*0.0)+c*-k)-(j+k*0.0-h*0.0)*-h;c=(j+k*0.0-h*0.0)*-k+(c*-h+j*(j*0.0+i*0.0-k))-(h+j*0.0-i*0.0)*-i;if(c*0.0+(e*0.0+d)<-.9999998807907104){g=1.0;c=-0.0;d=0.0;e=0.0}else{s=+L(+((c*0.0+(e*0.0+d)+1.0)*2.0));g=(d*0.0-c)*(1.0/s);c=(c*0.0-e*0.0)*(1.0/s);d=(e-d*0.0)*(1.0/s);e=s*.5}l=1.0/+L(+(c*c+g*g+d*d+e*e));o=c*l;m=g*l;p=d*l;l=e*l;r=1.0/+L(+((l*j-i*-o-k*-m-h*-p)*(l*j-i*-o-k*-m-h*-p)+((j*-p+l*h+k*-o-i*-m)*(j*-p+l*h+k*-o-i*-m)+((i*l+j*-o+h*-m-k*-p)*(i*l+j*-o+h*-m-k*-p)+(i*-p+(j*-m+l*k)-h*-o)*(i*-p+(j*-m+l*k)-h*-o)))));g=(i*l+j*-o+h*-m-k*-p)*r;s=r*(i*-p+(j*-m+l*k)-h*-o);e=r*(j*-p+l*h+k*-o-i*-m);r=r*(l*j-i*-o-k*-m-h*-p);d=+n[a+444>>2];if(d>=.05000000074505806?(q=+n[a+448>>2],q>=.05000000074505806):0){c=l<-1.0?-1.0:l;c=+Q(+(c>1.0?1.0:c))*2.0;if(c>1.1920928955078125e-07){h=1.0/+L(+(p*p+(o*o+m*m)));if(+K(+(m*h))>1.1920928955078125e-07){j=o*h;i=m*h;k=p*h;d=+L(+((p*h*p*h/(m*h*m*h)+1.0)/(1.0/(q*q)+p*h*p*h/(m*h*m*h)/(d*d))))}else{j=o*h;i=m*h;k=p*h}}else{j=0.0;i=0.0;k=0.0;d=0.0}if(+K(+c)>1.1920928955078125e-07){if(!(c>d)){d=-d;if(c<d)c=d}else c=d;l=c*.5;q=+O(+l)/+L(+(j*j+i*i+k*k));m=i*q;l=+N(+l);o=j*q;k=k*q}else k=p}else k=p;j=+n[a+452>>2];if(j>=.05000000074505806){c=r<-1.0?-1.0:r;c=+Q(+(c>1.0?1.0:c))*2.0;if(c>3.1415927410125732){c=-r<-1.0?-1.0:-r;c=+Q(+(c>1.0?1.0:c))*2.0;d=-g;h=-s;i=-e}else{d=g;h=s;i=e}if(c>1.1920928955078125e-07){q=1.0/+L(+(d*d+h*h+i*i));d=d*q;h=h*q;i=i*q}if(+K(+c)>1.1920928955078125e-07){if(!(c>j)){if(c<-j)c=-j}else c=j;s=c*.5;c=+O(+s)/+L(+(i*i+(h*h+d*d)));g=d*c;e=i*c;d=+N(+s);c=h*c}else{d=r;c=s}}else{d=r;c=s}n[a+556>>2]=m*e+(l*g+o*d)-k*c;n[a+560>>2]=k*g+(l*c+m*d)-o*e;n[a+564>>2]=o*c+(l*e+k*d)-m*g;n[a+568>>2]=l*d-o*g-m*c-k*e;return}function Ye(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;g=f[c+8>>2]|0;if((g|0)>0){h=f[c+16>>2]|0;e=0;d=0;do{i=f[h+(e<<2)>>2]|0;if(!(f[i+204>>2]&3)){f[i+208>>2]=d;d=d+1|0}f[i+212>>2]=-1;n[i+244>>2]=1.0;e=e+1|0}while((e|0)!=(g|0));i=d}else i=0;h=f[a+8>>2]|0;if((h|0)<(i|0)){if((f[a+12>>2]|0)<(i|0)){if(!i){d=0;g=h}else{f[6472]=(f[6472]|0)+1;d=sc((i<<3|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}g=f[a+8>>2]|0}if((g|0)>0){e=0;do{l=(f[a+16>>2]|0)+(e<<3)|0;j=f[l+4>>2]|0;k=d+(e<<3)|0;f[k>>2]=f[l>>2];f[k+4>>2]=j;e=e+1|0}while((e|0)!=(g|0))}e=f[a+16>>2]|0;if(e|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=d;f[a+12>>2]=i;e=a+16|0}else e=a+16|0;d=h;do{l=(f[e>>2]|0)+(d<<3)|0;f[l>>2]=0;f[l+4>>2]=0;d=d+1|0}while((d|0)!=(i|0))}f[a+8>>2]=i;if((i|0)>0){e=f[a+16>>2]|0;d=0;do{f[e+(d<<3)>>2]=d;f[e+(d<<3)+4>>2]=1;d=d+1|0}while((d|0)!=(i|0))}d=f[c+68>>2]|0;d=Bb[f[(f[d>>2]|0)+36>>2]&127](d)|0;k=Bb[f[(f[d>>2]|0)+36>>2]&127](d)|0;if(!k)return;j=Bb[f[(f[d>>2]|0)+20>>2]&127](d)|0;if((k|0)<=0)return;c=0;do{d=f[f[j+(c<<4)>>2]>>2]|0;e=f[f[j+(c<<4)+4>>2]>>2]|0;if((d|0?(e|0?(f[d+204>>2]&7|0)==0:0):0)?(f[e+204>>2]&7|0)==0:0){g=f[d+208>>2]|0;d=f[e+208>>2]|0;i=f[a+16>>2]|0;e=f[i+(g<<3)>>2]|0;if((e|0)!=(g|0)){f[i+(g<<3)>>2]=f[i+(e<<3)>>2];g=f[i+(e<<3)>>2]|0;e=f[i+(g<<3)>>2]|0;if((g|0)!=(e|0)){h=i+(g<<3)|0;do{g=i+(e<<3)|0;f[h>>2]=f[g>>2];g=f[g>>2]|0;h=i+(g<<3)|0;e=f[h>>2]|0}while((g|0)!=(e|0))}}e=f[i+(d<<3)>>2]|0;if((e|0)!=(d|0)){f[i+(d<<3)>>2]=f[i+(e<<3)>>2];d=f[i+(e<<3)>>2]|0;e=f[i+(d<<3)>>2]|0;if((d|0)!=(e|0)){h=i+(d<<3)|0;do{d=i+(e<<3)|0;f[h>>2]=f[d>>2];d=f[d>>2]|0;h=i+(d<<3)|0;e=f[h>>2]|0}while((d|0)!=(e|0))}}if((g|0)!=(d|0)){f[i+(g<<3)>>2]=d;l=i+(d<<3)+4|0;f[l>>2]=(f[l>>2]|0)+(f[i+(g<<3)+4>>2]|0)}}c=c+1|0}while((c|0)!=(k|0));return}function Ze(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;g=u;u=u+48|0;f[a+8>>2]=0;n[a+12>>2]=0.0;f[a>>2]=7116;f[a+48>>2]=c;f[a+4>>2]=21;if(Bb[f[(f[c>>2]|0)+40>>2]&127](c)|0)Vb[f[(f[c>>2]|0)+48>>2]&127](c,a+16|0,a+32|0);else{c=g+32+4|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;n[g+32>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g+16|0,a,g+32|0);n[a+32>>2]=+n[g+16>>2]+ +n[a+12>>2];n[g+32>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g,a,g+32|0);f[g+16>>2]=f[g>>2];f[g+16+4>>2]=f[g+4>>2];f[g+16+8>>2]=f[g+8>>2];f[g+16+12>>2]=f[g+12>>2];n[a+16>>2]=+n[g+16>>2]-+n[a+12>>2];f[g+32>>2]=0;f[g+32+4>>2]=0;f[g+32+8>>2]=0;f[g+32+12>>2]=0;n[c>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g+16|0,a,g+32|0);n[a+36>>2]=+n[g+16+4>>2]+ +n[a+12>>2];n[c>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g,a,g+32|0);f[g+16>>2]=f[g>>2];f[g+16+4>>2]=f[g+4>>2];f[g+16+8>>2]=f[g+8>>2];f[g+16+12>>2]=f[g+12>>2];n[a+20>>2]=+n[g+16+4>>2]-+n[a+12>>2];f[g+32>>2]=0;f[g+32+4>>2]=0;f[g+32+8>>2]=0;f[g+32+12>>2]=0;n[g+32+8>>2]=1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g+16|0,a,g+32|0);n[a+40>>2]=+n[g+16+8>>2]+ +n[a+12>>2];n[g+32+8>>2]=-1.0;Vb[f[(f[a>>2]|0)+68>>2]&127](g,a,g+32|0);f[g+16>>2]=f[g>>2];f[g+16+4>>2]=f[g+4>>2];f[g+16+8>>2]=f[g+8>>2];f[g+16+12>>2]=f[g+12>>2];n[a+24>>2]=+n[g+16+8>>2]-+n[a+12>>2]}f[a>>2]=6964;f[a+52>>2]=0;f[a+56>>2]=0;b[a+60>>0]=d&1;b[a+61>>0]=0;f[a+4>>2]=21;if(!e){u=g;return}f[6472]=(f[6472]|0)+1;c=sc(191)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}f[c+52>>2]=282;b[c+60>>0]=0;b[c+80>>0]=1;f[c+76>>2]=0;f[c+68>>2]=0;f[c+72>>2]=0;b[c+100>>0]=1;f[c+96>>2]=0;f[c+88>>2]=0;f[c+92>>2]=0;b[c+120>>0]=1;f[c+116>>2]=0;f[c+108>>2]=0;f[c+112>>2]=0;b[c+140>>0]=1;f[c+136>>2]=0;f[c+128>>2]=0;f[c+132>>2]=0;f[c+144>>2]=0;b[c+164>>0]=1;f[c+160>>2]=0;f[c+152>>2]=0;f[c+156>>2]=0;f[c+168>>2]=0;f[c+4>>2]=-8388609;f[c+8>>2]=-8388609;f[c+12>>2]=-8388609;n[c+16>>2]=0.0;f[c+20>>2]=2139095039;f[c+24>>2]=2139095039;f[c+28>>2]=2139095039;n[c+32>>2]=0.0;f[c>>2]=8172;f[a+52>>2]=c;jd(c,f[a+48>>2]|0,(b[a+60>>0]|0)!=0,a+16|0,a+32|0);b[a+61>>0]=1;u=g;return}function _e(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!b)if(!d){if(e|0){f[e>>2]=(a>>>0)%(c>>>0);f[e+4>>2]=0}d=0;e=(a>>>0)/(c>>>0)>>>0;return (I=d,e)|0}else{if(!e){d=0;e=0;return (I=d,e)|0}f[e>>2]=a|0;f[e+4>>2]=b&0;d=0;e=0;return (I=d,e)|0}do if(c){if(d|0){h=(_(d|0)|0)-(_(b|0)|0)|0;if(h>>>0<=31){n=h+1|0;i=a>>>((h+1|0)>>>0)&h-31>>31|b<<31-h;m=b>>>((h+1|0)>>>0)&h-31>>31;g=0;h=a<<31-h;break}if(!e){d=0;e=0;return (I=d,e)|0}f[e>>2]=a|0;f[e+4>>2]=b|b&0;d=0;e=0;return (I=d,e)|0}if(c-1&c|0){h=(_(c|0)|0)+33-(_(b|0)|0)|0;n=h;i=32-h-1>>31&b>>>((h-32|0)>>>0)|(b<<32-h|a>>>(h>>>0))&h-32>>31;m=h-32>>31&b>>>(h>>>0);g=a<<64-h&32-h>>31;h=(b<<64-h|a>>>((h-32|0)>>>0))&32-h>>31|a<<32-h&h-33>>31;break}if(e|0){f[e>>2]=c-1&a;f[e+4>>2]=0}if((c|0)==1){d=b|b&0;e=a|0|0;return (I=d,e)|0}else{e=dq(c|0)|0;d=b>>>(e>>>0)|0;e=b<<32-e|a>>>(e>>>0)|0;return (I=d,e)|0}}else{if(!d){if(e|0){f[e>>2]=(b>>>0)%(c>>>0);f[e+4>>2]=0}d=0;e=(b>>>0)/(c>>>0)>>>0;return (I=d,e)|0}if(!a){if(e|0){f[e>>2]=0;f[e+4>>2]=(b>>>0)%(d>>>0)}c=0;e=(b>>>0)/(d>>>0)>>>0;return (I=c,e)|0}if(!(d-1&d)){if(e|0){f[e>>2]=a|0;f[e+4>>2]=d-1&b|b&0}c=0;e=b>>>((dq(d|0)|0)>>>0);return (I=c,e)|0}h=(_(d|0)|0)-(_(b|0)|0)|0;if(h>>>0<=30){n=h+1|0;i=b<<31-h|a>>>((h+1|0)>>>0);m=b>>>((h+1|0)>>>0);g=0;h=a<<31-h;break}if(!e){d=0;e=0;return (I=d,e)|0}f[e>>2]=a|0;f[e+4>>2]=b|b&0;d=0;e=0;return (I=d,e)|0}while(0);if(!n){j=h;b=m;a=0;h=0}else{k=iw(c|0|0,d|d&0|0,-1,-1)|0;l=I;j=h;b=m;a=n;h=0;do{p=j;j=g>>>31|j<<1;g=h|g<<1;p=i<<1|p>>>31|0;o=i>>>31|b<<1|0;Tv(k|0,l|0,p|0,o|0)|0;n=I;m=n>>31|((n|0)<0?-1:0)<<1;h=m&1;i=Tv(p|0,o|0,m&(c|0)|0,(((n|0)<0?-1:0)>>31|((n|0)<0?-1:0)<<1)&(d|d&0)|0)|0;b=I;a=a-1|0}while((a|0)!=0);a=0}if(e|0){f[e>>2]=i;f[e+4>>2]=b}o=(g|0)>>>31|j<<1|(0<<1|g>>>31)&0|a;p=(g<<1|0>>>31)&-2|h;return (I=o,p)|0}function $e(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;i=u;u=u+64|0;j=(b[a+8>>0]|0)!=0;h=j?d:c;c=j?c:d;d=f[c+4>>2]|0;if(((f[d+4>>2]|0)+-21|0)>>>0>=9){u=i;return}if((f[(f[h+4>>2]|0)+4>>2]|0)>=20){u=i;return}k=+rb[f[(f[d>>2]|0)+48>>2]&15](d);f[g+4>>2]=f[a+76>>2];f[a+16>>2]=h;f[a+20>>2]=c;f[a+64>>2]=e;n[a+68>>2]=k;f[a+56>>2]=g;j=f[c+12>>2]|0;B=+n[j>>2];A=+n[j+16>>2];z=+n[j+32>>2];y=+n[j+4>>2];x=+n[j+20>>2];w=+n[j+36>>2];r=+n[j+8>>2];p=+n[j+24>>2];m=+n[j+40>>2];v=-+n[j+48>>2];t=-+n[j+52>>2];s=-+n[j+56>>2];j=f[h+12>>2]|0;K=+n[j>>2];J=+n[j+16>>2];I=+n[j+32>>2];H=+n[j+4>>2];G=+n[j+20>>2];F=+n[j+36>>2];E=+n[j+8>>2];D=+n[j+24>>2];C=+n[j+40>>2];q=+n[j+48>>2];o=+n[j+52>>2];l=+n[j+56>>2];n[i>>2]=B*K+A*J+z*I;n[i+4>>2]=B*H+A*G+z*F;n[i+8>>2]=B*E+A*D+z*C;n[i+12>>2]=0.0;n[i+16>>2]=y*K+x*J+w*I;n[i+20>>2]=y*H+x*G+w*F;n[i+24>>2]=y*E+x*D+w*C;n[i+28>>2]=0.0;n[i+32>>2]=r*K+p*J+m*I;n[i+36>>2]=r*H+p*G+m*F;n[i+40>>2]=r*E+p*D+m*C;n[i+44>>2]=0.0;n[i+48>>2]=B*v+A*t+z*s+(B*q+A*o+z*l);n[i+52>>2]=y*v+x*t+w*s+(y*q+x*o+w*l);n[i+56>>2]=r*v+p*t+m*s+(r*q+p*o+m*l);n[i+60>>2]=0.0;j=f[(f[a+16>>2]|0)+4>>2]|0;Yb[f[(f[j>>2]|0)+8>>2]&127](j,i,a+24|0,a+40|0);n[a+40>>2]=+n[a+40>>2]+k;n[a+44>>2]=+n[a+44>>2]+k;n[a+48>>2]=+n[a+48>>2]+k;n[a+24>>2]=+n[a+24>>2]-k;n[a+28>>2]=+n[a+28>>2]-k;n[a+32>>2]=+n[a+32>>2]-k;j=f[a+76>>2]|0;c=f[c+8>>2]|0;f[j+740>>2]=f[h+8>>2];f[j+744>>2]=c;Yb[f[(f[d>>2]|0)+64>>2]&127](d,a+12|0,a+24|0,a+40|0);c=f[g+4>>2]|0;do if(f[c+748>>2]|0){d=f[c+740>>2]|0;e=f[(f[g+8>>2]|0)+8>>2]|0;if((d|0)==(e|0)){df(c,d+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);break}else{df(c,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,e+4|0);break}}while(0);f[a+16>>2]=0;f[a+20>>2]=0;u=i;return}function af(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;j=u;u=u+128|0;a=f[a+16>>2]|0;l=+n[a+892>>2];x=+n[a+896>>2];v=+n[a+900>>2];w=+n[a+908>>2];e=+n[a+912>>2];h=+n[a+916>>2];z=+n[b>>2];k=+n[b+4>>2];o=v*+n[b+8>>2];p=+n[b+16>>2];q=+n[b+20>>2];s=v*+n[b+24>>2];t=+n[b+32>>2];m=+n[b+36>>2];r=+n[b+40>>2];y=+n[b+48>>2];i=+n[b+52>>2];g=+n[b+56>>2];n[j>>2]=l*z+x*k+o+y;n[j+4>>2]=l*p+x*q+s+i;n[j+8>>2]=l*t+x*m+v*r+g;n[j+12>>2]=0.0;n[j+16>>2]=w*z+x*k+o+y;n[j+20>>2]=w*p+x*q+s+i;n[j+24>>2]=w*t+x*m+v*r+g;n[j+28>>2]=0.0;n[j+32>>2]=w*z+e*k+o+y;n[j+36>>2]=w*p+e*q+s+i;n[j+40>>2]=w*t+e*m+v*r+g;n[j+44>>2]=0.0;n[j+48>>2]=l*z+e*k+o+y;n[j+52>>2]=l*p+e*q+s+i;n[j+56>>2]=l*t+e*m+v*r+g;n[j+60>>2]=0.0;v=+n[b>>2];t=+n[b+4>>2];s=h*+n[b+8>>2];q=+n[b+16>>2];p=+n[b+20>>2];o=h*+n[b+24>>2];k=+n[b+32>>2];n[j+64>>2]=l*v+x*t+s+y;n[j+68>>2]=l*q+x*p+o+i;n[j+72>>2]=l*k+x*m+h*r+g;n[j+76>>2]=0.0;g=+n[b+36>>2];h=h*+n[b+40>>2];r=+n[b+48>>2];m=+n[b+52>>2];i=+n[b+56>>2];n[j+80>>2]=w*v+x*t+s+r;n[j+84>>2]=w*q+x*p+o+m;n[j+88>>2]=w*k+x*g+h+i;n[j+92>>2]=0.0;n[j+96>>2]=w*v+e*t+s+r;n[j+100>>2]=w*q+e*p+o+m;n[j+104>>2]=w*k+e*g+h+i;n[j+108>>2]=0.0;n[j+112>>2]=l*v+e*t+s+r;n[j+116>>2]=l*q+e*p+o+m;n[j+120>>2]=l*k+e*g+h+i;n[j+124>>2]=0.0;f[d>>2]=f[j>>2];f[d+4>>2]=f[j+4>>2];f[d+8>>2]=f[j+8>>2];f[d+12>>2]=f[j+12>>2];f[c>>2]=f[j>>2];f[c+4>>2]=f[j+4>>2];f[c+8>>2]=f[j+8>>2];f[c+12>>2]=f[j+12>>2];a=1;do{e=+n[j+(a<<4)>>2];if(e<+n[c>>2])n[c>>2]=e;g=+n[j+(a<<4)+4>>2];if(g<+n[c+4>>2])n[c+4>>2]=g;h=+n[j+(a<<4)+8>>2];if(h<+n[c+8>>2])n[c+8>>2]=h;i=+n[j+(a<<4)+12>>2];if(i<+n[c+12>>2])n[c+12>>2]=i;if(+n[d>>2]<e)n[d>>2]=e;if(+n[d+4>>2]<g)n[d+4>>2]=g;if(+n[d+8>>2]<h)n[d+8>>2]=h;if(+n[d+12>>2]<i)n[d+12>>2]=i;a=a+1|0}while((a|0)!=8);u=j;return}function bf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0,o=0.0,p=0;m=u;u=u+128|0;h=+n[b>>2];i=+n[b+16>>2];o=h<i?h:i;g=+n[b+32>>2];if((o<g?o:g)>+n[a+28>>2]){u=m;return}k=h>i?b:b+16|0;if(+n[(+n[k>>2]>g?k:b+32|0)>>2]<+n[a+12>>2]){u=m;return}g=+n[b+8>>2];h=+n[b+24>>2];o=g<h?g:h;i=+n[b+40>>2];if((o<i?o:i)>+n[a+36>>2]){u=m;return}k=g>h?b+8|0:b+24|0;if(+n[(+n[k>>2]>i?k:b+40|0)>>2]<+n[a+20>>2]){u=m;return}g=+n[b+4>>2];h=+n[b+20>>2];o=g<h?g:h;i=+n[b+36>>2];if((o<i?o:i)>+n[a+32>>2]){u=m;return}k=g>h?b+4|0:b+20|0;if(+n[(+n[k>>2]>i?k:b+36|0)>>2]<+n[a+16>>2]){u=m;return}e=f[a+4>>2]|0;if((f[(f[e+4>>2]|0)+4>>2]|0)>=20){u=m;return}k=f[a+48>>2]|0;f[m+24+8>>2]=0;f[m+24+12>>2]=1065353216;f[m+24+16>>2]=1065353216;f[m+24+20>>2]=1065353216;n[m+24+24>>2]=0.0;f[m+24+52>>2]=0;f[m+24>>2]=3860;f[m+24+4>>2]=1;f[m+24+56>>2]=f[b>>2];f[m+24+56+4>>2]=f[b+4>>2];f[m+24+56+8>>2]=f[b+8>>2];f[m+24+56+12>>2]=f[b+12>>2];f[m+24+72>>2]=f[b+16>>2];f[m+24+72+4>>2]=f[b+16+4>>2];f[m+24+72+8>>2]=f[b+16+8>>2];f[m+24+72+12>>2]=f[b+16+12>>2];f[m+24+88>>2]=f[b+32>>2];f[m+24+88+4>>2]=f[b+32+4>>2];f[m+24+88+8>>2]=f[b+32+8>>2];f[m+24+88+12>>2]=f[b+32+12>>2];f[m+24+44>>2]=f[a+56>>2];p=f[a+8>>2]|0;b=f[p+8>>2]|0;j=f[p+12>>2]|0;f[m>>2]=p;f[m+4>>2]=m+24;f[m+8>>2]=b;f[m+12>>2]=j;f[m+16>>2]=c;f[m+20>>2]=d;j=Gb[f[(f[k>>2]|0)+8>>2]&31](k,e,m,f[a+64>>2]|0)|0;b=f[a+44>>2]|0;e=f[b+8>>2]|0;if((f[e+8>>2]|0)==(f[(f[a+8>>2]|0)+8>>2]|0)){f[b+8>>2]=m;Vb[f[(f[b>>2]|0)+8>>2]&127](b,c,d)}else{e=f[b+12>>2]|0;f[b+12>>2]=m;Vb[f[(f[b>>2]|0)+12>>2]&127](b,c,d)}ac[f[(f[j>>2]|0)+8>>2]&31](j,f[a+4>>2]|0,m,f[a+52>>2]|0,f[a+44>>2]|0);p=f[a+44>>2]|0;f[((f[(f[p+8>>2]|0)+8>>2]|0)==(f[(f[a+8>>2]|0)+8>>2]|0)?p+8|0:p+12|0)>>2]=e;Lb[f[f[j>>2]>>2]&511](j);Rb[f[(f[k>>2]|0)+60>>2]&127](k,j);f[m+24>>2]=7316;e=f[m+24+52>>2]|0;if(e|0?(Lb[f[f[e>>2]>>2]&511](e),l=f[m+24+52>>2]|0,l|0):0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}u=m;return}function cf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;v=b[g+16>>0]&-16;b[g+16>>0]=v;w=+n[d>>2];x=+n[c>>2];m=+n[d+4>>2];o=+n[c+4>>2];p=+n[d+8>>2];q=+n[c+8>>2];r=+n[e>>2];s=+n[e+4>>2];t=+n[e+8>>2];k=+n[a>>2];l=+n[a+4>>2];h=+n[a+8>>2];y=(w-x)*(k-x)+(m-o)*(l-o)+(p-q)*(h-q);z=(r-x)*(k-x)+(s-o)*(l-o)+(t-q)*(h-q);do if(y<=0.0&z<=0.0){f[g>>2]=f[c>>2];f[g+4>>2]=f[c+4>>2];f[g+8>>2]=f[c+8>>2];f[g+12>>2]=f[c+12>>2];b[g+16>>0]=v|1;i=0.0;j=0.0;h=1.0}else{u=(w-x)*(k-w)+(m-o)*(l-m)+(p-q)*(h-p);j=(r-x)*(k-w)+(s-o)*(l-m)+(t-q)*(h-p);if(!(!(u>=0.0)|!(j<=u))){f[g>>2]=f[d>>2];f[g+4>>2]=f[d+4>>2];f[g+8>>2]=f[d+8>>2];f[g+12>>2]=f[d+12>>2];b[g+16>>0]=v|2;i=0.0;j=1.0;h=0.0;break}if(u<=0.0&(y>=0.0?y*j-u*z<=0.0:0)){n[g>>2]=x+(w-x)*(y/(y-u));n[g+4>>2]=o+(m-o)*(y/(y-u));n[g+8>>2]=q+(p-q)*(y/(y-u));n[g+12>>2]=0.0;b[g+16>>0]=v|3;i=0.0;j=y/(y-u);h=1.0-y/(y-u);break}i=(w-x)*(k-r)+(m-o)*(l-s)+(p-q)*(h-t);h=(r-x)*(k-r)+(s-o)*(l-s)+(t-q)*(h-t);if(!(!(h>=0.0)|!(i<=h))){f[g>>2]=f[e>>2];f[g+4>>2]=f[e+4>>2];f[g+8>>2]=f[e+8>>2];f[g+12>>2]=f[e+12>>2];b[g+16>>0]=v|4;i=1.0;j=0.0;h=0.0;break}if(h<=0.0&(z>=0.0?i*z-y*h<=0.0:0)){n[g>>2]=x+(r-x)*(z/(z-h));n[g+4>>2]=o+(s-o)*(z/(z-h));n[g+8>>2]=q+(t-q)*(z/(z-h));n[g+12>>2]=0.0;b[g+16>>0]=v|5;i=z/(z-h);j=0.0;h=1.0-z/(z-h);break}if((u*h-i*j<=0.0?j-u>=0.0:0)?i-h>=0.0:0){j=(j-u)/(j-u+(i-h));n[g>>2]=w+(r-w)*j;n[g+4>>2]=m+(s-m)*j;n[g+8>>2]=p+(t-p)*j;n[g+12>>2]=0.0;b[g+16>>0]=v|6;i=j;j=1.0-j;h=0.0;break}k=1.0/(y*j-u*z+(u*h-i*j+(i*z-y*h)));l=(i*z-y*h)*k;h=(y*j-u*z)*k;n[g>>2]=(r-x)*h+((w-x)*l+x);n[g+4>>2]=(s-o)*h+((m-o)*l+o);n[g+8>>2]=(t-q)*h+((p-q)*l+q);n[g+12>>2]=0.0;b[g+16>>0]=v|7;i=h;j=l;h=1.0-l-h}while(0);n[g+20>>2]=h;n[g+24>>2]=j;n[g+28>>2]=i;n[g+32>>2]=0.0;return}function df(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0;e=f[a+748>>2]|0;if((e|0)<=0)return;do{j=e;e=e+-1|0;q=+n[a+4+(e*184|0)>>2];r=+n[a+4+(e*184|0)+4>>2];g=+n[a+4+(e*184|0)+8>>2];p=q*+n[c>>2]+r*+n[c+4>>2]+g*+n[c+8>>2]+ +n[c+48>>2];m=q*+n[c+16>>2]+r*+n[c+20>>2]+g*+n[c+24>>2]+ +n[c+52>>2];g=q*+n[c+32>>2]+r*+n[c+36>>2]+g*+n[c+40>>2]+ +n[c+56>>2];n[a+4+(e*184|0)+48>>2]=p;n[a+4+(e*184|0)+52>>2]=m;n[a+4+(e*184|0)+56>>2]=g;n[a+4+(e*184|0)+60>>2]=0.0;r=+n[a+4+(e*184|0)+16>>2];q=+n[a+4+(e*184|0)+20>>2];h=+n[a+4+(e*184|0)+24>>2];o=r*+n[d>>2]+q*+n[d+4>>2]+h*+n[d+8>>2]+ +n[d+48>>2];l=r*+n[d+16>>2]+q*+n[d+20>>2]+h*+n[d+24>>2]+ +n[d+52>>2];h=r*+n[d+32>>2]+q*+n[d+36>>2]+h*+n[d+40>>2]+ +n[d+56>>2];n[a+4+(e*184|0)+32>>2]=o;n[a+4+(e*184|0)+36>>2]=l;n[a+4+(e*184|0)+40>>2]=h;n[a+4+(e*184|0)+44>>2]=0.0;n[a+4+(e*184|0)+80>>2]=(p-o)*+n[a+4+(e*184|0)+64>>2]+(m-l)*+n[a+4+(e*184|0)+68>>2]+(g-h)*+n[a+4+(e*184|0)+72>>2];i=a+4+(e*184|0)+148|0;f[i>>2]=(f[i>>2]|0)+1}while((j|0)>1);e=f[a+748>>2]|0;if((e|0)<=0)return;j=e;do{i=j;j=j+-1|0;d=a+4+(j*184|0)|0;g=+n[a+4+(j*184|0)+80>>2];h=+n[a+752>>2];if(!(g<=h)){c=e+-1|0;if((c|0)==(j|0))k=12;else{ki(d|0,a+4+(c*184|0)|0,184)|0;f[a+4+(c*184|0)+112>>2]=0;n[a+4+(c*184|0)+120>>2]=0.0;b[a+4+(c*184|0)+116>>0]=0;n[a+4+(c*184|0)+124>>2]=0.0;n[a+4+(c*184|0)+128>>2]=0.0;f[a+4+(c*184|0)+148>>2]=0;e=f[a+748>>2]|0;k=12}}else{p=+n[a+4+(j*184|0)+32>>2]-(+n[a+4+(j*184|0)+48>>2]-+n[a+4+(j*184|0)+64>>2]*g);q=+n[a+4+(j*184|0)+36>>2]-(+n[a+4+(j*184|0)+52>>2]-g*+n[a+4+(j*184|0)+68>>2]);r=+n[a+4+(j*184|0)+40>>2]-(+n[a+4+(j*184|0)+56>>2]-g*+n[a+4+(j*184|0)+72>>2]);if(p*p+q*q+r*r>h*h){c=e+-1|0;if((c|0)==(j|0))k=12;else{ki(d|0,a+4+(c*184|0)|0,184)|0;f[a+4+(c*184|0)+112>>2]=0;n[a+4+(c*184|0)+120>>2]=0.0;b[a+4+(c*184|0)+116>>0]=0;n[a+4+(c*184|0)+124>>2]=0.0;n[a+4+(c*184|0)+128>>2]=0.0;f[a+4+(c*184|0)+148>>2]=0;e=f[a+748>>2]|0;k=12}}}if((k|0)==12){k=0;e=e+-1|0;f[a+748>>2]=e}}while((i|0)>1);return}function ef(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0;e=u;u=u+256|0;uj(11883);f[e+32>>2]=4204;j=e+32+36|0;f[j>>2]=f[b>>2];f[j+4>>2]=f[b+4>>2];f[j+8>>2]=f[b+8>>2];f[j+12>>2]=f[b+12>>2];k=e+32+52|0;f[k>>2]=f[c>>2];f[k+4>>2]=f[c+4>>2];f[k+8>>2]=f[c+8>>2];f[k+12>>2]=f[c+12>>2];f[e+32+212>>2]=a;f[e+32+216>>2]=d;f[e+32+68>>2]=1065353216;f[e+32+72>>2]=0;f[e+32+72+4>>2]=0;f[e+32+72+8>>2]=0;f[e+32+72+12>>2]=0;f[e+32+88>>2]=1065353216;f[e+32+92>>2]=0;f[e+32+92+4>>2]=0;f[e+32+92+8>>2]=0;f[e+32+92+12>>2]=0;f[e+32+108>>2]=1065353216;f[e+32+112>>2]=0;f[e+32+116>>2]=f[j>>2];f[e+32+116+4>>2]=f[j+4>>2];f[e+32+116+8>>2]=f[j+8>>2];f[e+32+116+12>>2]=f[j+12>>2];f[e+32+132>>2]=1065353216;f[e+32+136>>2]=0;f[e+32+136+4>>2]=0;f[e+32+136+8>>2]=0;f[e+32+136+12>>2]=0;f[e+32+152>>2]=1065353216;f[e+32+156>>2]=0;f[e+32+156+4>>2]=0;f[e+32+156+8>>2]=0;f[e+32+156+12>>2]=0;f[e+32+172>>2]=1065353216;f[e+32+176>>2]=0;f[e+32+180>>2]=f[c>>2];f[e+32+180+4>>2]=f[c+4>>2];f[e+32+180+8>>2]=f[c+8>>2];f[e+32+180+12>>2]=f[c+12>>2];l=+n[c>>2]-+n[b>>2];i=+n[c+4>>2]-+n[b+4>>2];h=+n[c+8>>2]-+n[b+8>>2];g=1.0/+L(+(l*l+i*i+h*h));p=l*g==0.0?1000000015047466219876688.0e6:1.0/(l*g);n[e+32+4>>2]=p;o=i*g==0.0?1000000015047466219876688.0e6:1.0/(i*g);n[e+32+8>>2]=o;m=h*g==0.0?1000000015047466219876688.0e6:1.0/(h*g);n[e+32+12>>2]=m;f[e+32+20>>2]=p<0.0&1;f[e+32+24>>2]=o<0.0&1;f[e+32+28>>2]=m<0.0&1;n[e+32+32>>2]=l*g*(+n[k>>2]-+n[j>>2])+i*g*(+n[e+32+56>>2]-+n[e+32+40>>2])+h*g*(+n[e+32+60>>2]-+n[e+32+44>>2]);a=f[a+68>>2]|0;d=f[(f[a>>2]|0)+24>>2]|0;f[e+16>>2]=0;f[e+16+4>>2]=0;f[e+16+8>>2]=0;f[e+16+12>>2]=0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;cc[d&7](a,b,c,e+32|0,e+16|0,e);a=f[2405]|0;d=(f[a+16>>2]|0)+-1|0;f[a+16>>2]=d;if(d|0){u=e;return}do if(f[a+4>>2]|0){gb(e+32|0,0)|0;k=f[6471]|0;n[a+8>>2]=+n[a+8>>2]+ +(((f[e+32+4>>2]|0)-(f[k+4>>2]|0)+(((f[e+32>>2]|0)-(f[k>>2]|0)|0)*1e6|0)-(f[a+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[a+16>>2]|0)){a=f[2405]|0;break}else{u=e;return}}while(0);f[2405]=f[a+20>>2];u=e;return}function ff(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,g=0,h=0,i=0.0,j=0.0,k=0,l=0,m=0.0;if(!(f[a>>2]|0)){f[a>>2]=c;f[c+32>>2]=0;return}e=f[b+40>>2]|0;if(!e)k=b;else{d=+n[c>>2]+ +n[c+16>>2];i=+n[c+4>>2]+ +n[c+20>>2];j=+n[c+8>>2]+ +n[c+24>>2];do{l=f[b+36>>2]|0;m=+K(+(d-(+n[l>>2]+ +n[l+16>>2])))+ +K(+(i-(+n[l+4>>2]+ +n[l+20>>2])))+ +K(+(j-(+n[l+8>>2]+ +n[l+24>>2])));b=b+36+((!(m<+K(+(d-(+n[e>>2]+ +n[e+16>>2])))+ +K(+(i-(+n[e+4>>2]+ +n[e+20>>2])))+ +K(+(j-(+n[e+8>>2]+ +n[e+24>>2]))))&1)<<2)|0;b=f[b>>2]|0;e=f[b+40>>2]|0}while((e|0)!=0);k=b}l=k+32|0;g=f[l>>2]|0;b=f[a+4>>2]|0;if(!b){f[6472]=(f[6472]|0)+1;b=sc(63)|0;if(!b)b=0;else{f[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}e=b;h=e+44|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(h|0))}else f[a+4>>2]=0;f[b+32>>2]=g;f[b+36>>2]=0;e=b+40|0;f[e>>2]=0;h=k+16|0;f[b>>2]=f[(+n[c>>2]<+n[k>>2]?c:k)>>2];f[b+16>>2]=f[(+n[c+16>>2]>+n[k+16>>2]?c+16|0:h)>>2];f[b+4>>2]=f[(+n[c+4>>2]<+n[k+4>>2]?c:k)+4>>2];f[b+20>>2]=f[(+n[c+20>>2]>+n[k+20>>2]?c+16|0:h)+4>>2];f[b+8>>2]=f[(+n[c+8>>2]<+n[k+8>>2]?c:k)+8>>2];f[b+24>>2]=f[(+n[c+24>>2]>+n[k+24>>2]?c+16|0:h)+8>>2];if(!g){f[b+36>>2]=k;f[l>>2]=b;f[e>>2]=c;f[c+32>>2]=b;f[a>>2]=b;return}f[g+36+(((f[(f[l>>2]|0)+40>>2]|0)==(k|0)&1)<<2)>>2]=b;f[b+36>>2]=k;f[l>>2]=b;f[e>>2]=c;f[c+32>>2]=b;e=b;d=+n[b>>2];while(1){b=g+4|0;if(((((+n[g>>2]<=d?+n[b>>2]<=+n[e+4>>2]:0)?+n[g+8>>2]<=+n[e+8>>2]:0)?+n[g+16>>2]>=+n[e+16>>2]:0)?+n[g+20>>2]>=+n[e+20>>2]:0)?+n[g+24>>2]>=+n[e+24>>2]:0){b=21;break}a=f[g+36>>2]|0;c=f[g+40>>2]|0;e=f[(+n[a>>2]<+n[c>>2]?a:c)>>2]|0;f[g>>2]=e;f[g+16>>2]=f[(+n[a+16>>2]>+n[c+16>>2]?a+16|0:c+16|0)>>2];f[b>>2]=f[(+n[a+4>>2]<+n[c+4>>2]?a:c)+4>>2];f[g+20>>2]=f[(+n[a+20>>2]>+n[c+20>>2]?a+16|0:c+16|0)+4>>2];f[g+8>>2]=f[(+n[a+8>>2]<+n[c+8>>2]?a:c)+8>>2];f[g+24>>2]=f[(+n[a+24>>2]>+n[c+24>>2]?a+16|0:c+16|0)+8>>2];b=f[g+32>>2]|0;if(!b){b=21;break}else{c=g;g=b;d=(f[s>>2]=e,+n[s>>2]);e=c}}if((b|0)==21)return}function gf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,i=0.0,k=0,l=0,m=0,o=0,q=0,r=0,s=0,t=0,v=0.0;t=u;u=u+32|0;l=f[a+4>>2]|0;fc[f[(f[l>>2]|0)+16>>2]&3](l,t+28|0,t+24|0,t+20|0,t+16|0,t+12|0,t+8|0,t+4|0,t,b);l=(f[t+12>>2]|0)+(X(f[t+8>>2]|0,c)|0)|0;r=f[a+4>>2]|0;m=f[t>>2]|0;switch(m|0){case 3:{d=j[l+4>>1]|0;break}case 2:{d=f[l+8>>2]|0;break}default:d=h[l+2>>0]|0}s=(f[t+20>>2]|0)==0;o=f[t+28>>2]|0;q=f[t+16>>2]|0;d=o+(X(q,d)|0)|0;if(s){g=+n[d+4>>2]*+n[r+8>>2];i=+n[d>>2]*+n[r+4>>2];k=d+8|0;e=+n[r+12>>2]}else{g=+n[r+8>>2]*+p[d+8>>3];i=+n[r+4>>2]*+p[d>>3];k=r+12|0;e=+p[d+16>>3]}e=e*+n[k>>2];n[a+44>>2]=i;n[a+48>>2]=g;n[a+52>>2]=e;n[a+56>>2]=0.0;switch(m|0){case 3:{d=j[l+2>>1]|0;break}case 2:{d=f[l+4>>2]|0;break}default:d=h[l+1>>0]|0}d=o+(X(q,d)|0)|0;if(s){g=+n[d+4>>2]*+n[r+8>>2];i=+n[d>>2]*+n[r+4>>2];k=d+8|0;e=+n[r+12>>2]}else{g=+n[r+8>>2]*+p[d+8>>3];i=+n[r+4>>2]*+p[d>>3];k=r+12|0;e=+p[d+16>>3]}e=e*+n[k>>2];n[a+28>>2]=i;n[a+32>>2]=g;n[a+36>>2]=e;n[a+40>>2]=0.0;switch(m|0){case 3:{d=j[l>>1]|0;break}case 2:{d=f[l>>2]|0;break}default:d=h[l>>0]|0}d=o+(X(q,d)|0)|0;if(s){g=+n[d+4>>2]*+n[r+8>>2];e=+n[d>>2]*+n[r+4>>2];q=d+8|0;v=+n[r+12>>2];i=+n[q>>2];i=v*i;r=a+12|0;n[r>>2]=e;r=a+16|0;n[r>>2]=g;r=a+20|0;n[r>>2]=i;r=a+24|0;n[r>>2]=0.0;r=a+8|0;r=f[r>>2]|0;q=f[r>>2]|0;q=q+8|0;q=f[q>>2]|0;s=a+12|0;Yb[q&127](r,s,b,c);s=f[a+4>>2]|0;r=f[s>>2]|0;r=r+24|0;r=f[r>>2]|0;Rb[r&127](s,b);u=t;return}else{i=+n[r+8>>2]*+p[d+8>>3];g=+n[r+4>>2]*+p[d>>3];r=r+12|0;e=+p[d+16>>3];v=+n[r>>2];v=e*v;r=a+12|0;n[r>>2]=g;r=a+16|0;n[r>>2]=i;r=a+20|0;n[r>>2]=v;r=a+24|0;n[r>>2]=0.0;r=a+8|0;r=f[r>>2]|0;q=f[r>>2]|0;q=q+8|0;q=f[q>>2]|0;s=a+12|0;Yb[q&127](r,s,b,c);s=f[a+4>>2]|0;r=f[s>>2]|0;r=r+24|0;r=f[r>>2]|0;Rb[r&127](s,b);u=t;return}}function hf(a,c){a=a|0;c=+c;var d=0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0,s=0.0;r=u;u=u+16|0;uj(12376);d=f[a+232>>2]|0;if((d|0)>0){q=0;do{p=f[(f[a+240>>2]|0)+(q<<2)>>2]|0;if(!(f[p+204>>2]&3)){l=+n[p+444>>2];e=+M(+(1.0-l),+c);h=+n[p+312>>2]*e;n[p+312>>2]=h;g=e*+n[p+316>>2];n[p+316>>2]=g;e=e*+n[p+320>>2];n[p+320>>2]=e;o=+n[p+448>>2];k=+M(+(1.0-o),+c);i=+n[p+328>>2]*k;n[p+328>>2]=i;j=k*+n[p+332>>2];n[p+332>>2]=j;k=k*+n[p+336>>2];n[p+336>>2]=k;do if(b[p+452>>0]|0){if(k*k+(i*i+j*j)<+n[p+464>>2]?h*h+g*g+e*e<+n[p+460>>2]:0){s=+n[p+456>>2];n[p+328>>2]=i*s;n[p+332>>2]=s*j;n[p+336>>2]=s*k;n[p+312>>2]=s*h;n[p+316>>2]=s*g;n[p+320>>2]=s*e;g=s*g;e=s*e;m=i*s;j=s*j;k=s*k;h=s*h}else m=i;i=+L(+(h*h+g*g+e*e));do if(i<l)if(i>.004999999888241291){h=h-h*(1.0/i)*.004999999888241291;n[p+312>>2]=h;g=g-g*(1.0/i)*.004999999888241291;n[p+316>>2]=g;e=e-e*(1.0/i)*.004999999888241291;n[p+320>>2]=e;break}else{f[p+312>>2]=0;f[p+312+4>>2]=0;f[p+312+8>>2]=0;f[p+312+12>>2]=0;h=0.0;g=0.0;e=0.0;break}while(0);i=+L(+(m*m+j*j+k*k));if(i<o)if(i>.004999999888241291){n[p+328>>2]=m-m*(1.0/i)*.004999999888241291;n[p+332>>2]=j-j*(1.0/i)*.004999999888241291;n[p+336>>2]=k-k*(1.0/i)*.004999999888241291;break}else{f[p+328>>2]=0;f[p+328+4>>2]=0;f[p+328+8>>2]=0;f[p+328+12>>2]=0;break}}while(0);Yg(p+4|0,h,g,e,p+328|0,c,p+68|0);d=f[a+232>>2]|0}q=q+1|0}while((q|0)<(d|0))}d=f[2405]|0;a=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=a;if(a|0){u=r;return}do if(f[d+4>>2]|0){gb(r|0,0)|0;a=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[r+4>>2]|0)-(f[a+4>>2]|0)+(((f[r>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[d+16>>2]|0)){d=f[2405]|0;break}else{u=r;return}}while(0);f[2405]=f[d+20>>2];u=r;return}function jf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0;if(!a)return;p=+n[b>>2];q=+n[b+4>>2];r=+n[b+8>>2];s=+n[b+16>>2];t=+n[b+20>>2];o=+n[b+24>>2];f[6472]=(f[6472]|0)+1;b=sc(275)|0;if(!b)b=0;else{f[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}f[b>>2]=a;a=64;m=1;e=b;h=b;g=b;d=b;i=b;while(1){j=m+-1|0;k=f[e+(j<<2)>>2]|0;do if(((((+n[k>>2]<=s?+n[k+16>>2]>=p:0)?+n[k+4>>2]<=t:0)?+n[k+20>>2]>=q:0)?+n[k+8>>2]<=o:0)?+n[k+24>>2]>=r:0){if(!(f[k+40>>2]|0)){Rb[f[(f[c>>2]|0)+12>>2]&127](c,k);b=i;break}l=f[k+36>>2]|0;do if((j|0)==(a|0)?(u=a|0?a<<1:1,(m|0)<=(u|0)):0){if((u|0)!=0?(f[6472]=(f[6472]|0)+1,v=sc((u<<2|3)+16|0)|0,(v|0)!=0):0){f[(v+4+15&-16)+-4>>2]=v;d=v+4+15&-16}else d=0;if((m|0)>1){b=0;do{f[d+(b<<2)>>2]=f[e+(b<<2)>>2];b=b+1|0}while((b|0)!=(a|0));if(!i){a=u;e=d;h=d;g=d;b=d;i=d;break}}else if((e|0)==0|(i|0)==0){a=u;e=d;h=d;g=d;b=d;i=d;break}f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);a=u;e=d;h=d;g=d;b=d;i=d}else{b=i;i=d}while(0);f[e+(j<<2)>>2]=l;j=f[k+40>>2]|0;do if((m|0)==(a|0)){a=m|0?m<<1:1;if((m|0)<(a|0)){if((a|0)!=0?(f[6472]=(f[6472]|0)+1,w=sc((a<<2|3)+16|0)|0,(w|0)!=0):0){f[(w+4+15&-16)+-4>>2]=w;d=w+4+15&-16}else d=0;if((m|0)>0){b=0;do{f[d+(b<<2)>>2]=f[e+(b<<2)>>2];b=b+1|0}while((b|0)!=(m|0));if(!i){e=d;h=d;g=d;i=d;b=d;break}}else if((e|0)==0|(i|0)==0){e=d;h=d;g=d;i=d;b=d;break}f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);e=d;h=d;g=d;i=d;b=d}else a=m}while(0);f[e+(m<<2)>>2]=j;j=m+1|0;d=i}else b=i;while(0);if((j|0)>0){m=j;i=b}else break}if((e|0)==0|(h|0)==0)return;f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);return}function kf(a){a=a|0;var c=0,d=0;f[a>>2]=5416;if(b[a+20>>0]|0){c=f[a+16>>2]|0;d=f[c+16>>2]|0;if(d){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+16>>2]|0}if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}}if(b[a+12>>0]|0){c=f[a+8>>2]|0;d=f[c+16>>2]|0;if(d){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+8>>2]|0}if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}}c=f[a+32>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+32>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+36>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+36>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+40>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+40>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+44>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+44>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+48>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+48>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+52>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+52>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+56>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+56>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+60>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+60>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+76>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+76>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+80>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+80>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+72>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+72>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+88>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+88>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+84>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+84>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+24>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}c=f[a+28>>2]|0;Lb[f[f[c>>2]>>2]&511](c);c=f[a+28>>2]|0;if(!c)return;f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);return}function lf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;f[b+16>>2]=f[a+4>>2];f[b+20>>2]=f[a+8>>2];f[b+24>>2]=f[a+12>>2];f[b+28>>2]=f[a+16>>2];f[b+32>>2]=f[a+20>>2];f[b+36>>2]=f[a+24>>2];f[b+40>>2]=f[a+28>>2];f[b+44>>2]=f[a+32>>2];f[b+48>>2]=f[a+36>>2];f[b+52>>2]=f[a+40>>2];f[b+56>>2]=f[a+44>>2];f[b+60>>2]=f[a+48>>2];f[b+64>>2]=f[a+52>>2];f[b+68>>2]=f[a+56>>2];f[b+72>>2]=f[a+60>>2];f[b+76>>2]=f[a+64>>2];f[b+80>>2]=f[a+68>>2];f[b+84>>2]=f[a+72>>2];f[b+88>>2]=f[a+76>>2];f[b+92>>2]=f[a+80>>2];f[b+96>>2]=f[a+84>>2];f[b+100>>2]=f[a+88>>2];f[b+104>>2]=f[a+92>>2];f[b+108>>2]=f[a+96>>2];f[b+112>>2]=f[a+100>>2];f[b+116>>2]=f[a+104>>2];f[b+120>>2]=f[a+108>>2];f[b+124>>2]=f[a+112>>2];f[b+128>>2]=f[a+116>>2];f[b+132>>2]=f[a+120>>2];f[b+136>>2]=f[a+124>>2];f[b+140>>2]=f[a+128>>2];f[b+144>>2]=f[a+132>>2];f[b+148>>2]=f[a+136>>2];f[b+152>>2]=f[a+140>>2];f[b+156>>2]=f[a+144>>2];f[b+160>>2]=f[a+148>>2];f[b+164>>2]=f[a+152>>2];f[b+168>>2]=f[a+156>>2];f[b+172>>2]=f[a+160>>2];f[b+176>>2]=f[a+164>>2];f[b+180>>2]=f[a+168>>2];f[b+184>>2]=f[a+172>>2];f[b+188>>2]=f[a+176>>2];f[b+224>>2]=f[a+180>>2];f[b+192>>2]=f[a+184>>2];f[b>>2]=0;d=Db[f[(f[c>>2]|0)+28>>2]&31](c,f[a+192>>2]|0)|0;f[b+4>>2]=d;f[b+8>>2]=0;f[b+228>>2]=f[a+204>>2];f[b+232>>2]=f[a+208>>2];f[b+236>>2]=f[a+212>>2];f[b+240>>2]=f[a+216>>2];f[b+196>>2]=f[a+220>>2];f[b+200>>2]=f[a+224>>2];f[b+204>>2]=f[a+232>>2];f[b+208>>2]=f[a+228>>2];f[b+244>>2]=f[a+236>>2];d=Db[f[(f[c>>2]|0)+40>>2]&31](c,a)|0;e=Db[f[(f[c>>2]|0)+28>>2]&31](c,d)|0;f[b+12>>2]=e;if(!e){e=a+244|0;e=f[e>>2]|0;c=b+212|0;f[c>>2]=e;c=a+248|0;c=f[c>>2]|0;e=b+216|0;f[e>>2]=c;e=a+252|0;e=f[e>>2]|0;c=b+220|0;f[c>>2]=e;c=a+256|0;c=f[c>>2]|0;e=b+248|0;f[e>>2]=c;return 13356}Rb[f[(f[c>>2]|0)+48>>2]&127](c,d);e=a+244|0;e=f[e>>2]|0;c=b+212|0;f[c>>2]=e;c=a+248|0;c=f[c>>2]|0;e=b+216|0;f[e>>2]=c;e=a+252|0;e=f[e>>2]|0;c=b+220|0;f[c>>2]=e;c=a+256|0;c=f[c>>2]|0;e=b+248|0;f[e>>2]=c;return 13356}function mf(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;c=f[a+748>>2]|0;if((c|0)!=4){f[a+748>>2]=c+1;x=c;w=(x|0)>0;x=w?x:0;a=a+4+(x*184|0)|0;ki(a|0,b|0,184)|0;return x|0}y=+n[b+80>>2];v=+n[a+84>>2];u=v<y?v:y;t=+n[a+268>>2];s=t<u?t:u;r=+n[a+452>>2];w=+n[a+636>>2]<(r<s?r:s);c=w?3:r<s?2:t<u?1:(v<y^1)<<31>>31;y=+n[b>>2];if(c){d=+n[a+188>>2];e=+n[b+4>>2];g=+n[a+192>>2];j=+n[b+8>>2];l=+n[a+196>>2];k=+n[a+556>>2];t=+n[a+372>>2];r=+n[a+560>>2];o=+n[a+376>>2];s=+n[a+564>>2];i=+n[a+380>>2];h=((y-d)*(r-o)-(e-g)*(k-t))*((y-d)*(r-o)-(e-g)*(k-t))+(((e-g)*(s-i)-(j-l)*(r-o))*((e-g)*(s-i)-(j-l)*(r-o))+((j-l)*(k-t)-(y-d)*(s-i))*((j-l)*(k-t)-(y-d)*(s-i)));if((c|0)==1){m=+n[a+12>>2];u=j;v=d;q=k;p=g;g=0.0;j=+n[a+4>>2];k=+n[a+8>>2];x=7}else{p=g;u=j;q=k;x=6}}else{d=+n[a+188>>2];p=+n[a+192>>2];l=+n[a+196>>2];h=0.0;e=+n[b+4>>2];u=+n[b+8>>2];t=+n[a+372>>2];q=+n[a+556>>2];o=+n[a+376>>2];r=+n[a+560>>2];i=+n[a+380>>2];s=+n[a+564>>2];x=6}if((x|0)==6){j=+n[a+4>>2];k=+n[a+8>>2];B=e-k;m=+n[a+12>>2];z=u-m;v=q-t;A=r-o;g=s-i;g=((y-j)*A-B*v)*((y-j)*A-B*v)+((B*g-z*A)*(B*g-z*A)+(z*v-(y-j)*g)*(z*v-(y-j)*g));if((c|0)==2){r=d;q=t;d=0.0;x=8}else{v=d;x=7}}if((x|0)==7){B=y-j;C=e-k;z=u-m;A=q-v;r=r-p;d=s-l;d=(B*r-C*A)*(B*r-C*A)+((C*d-z*r)*(C*d-z*r)+(z*A-B*d)*(z*A-B*d));if(w)e=0.0;else{r=v;q=t;x=8}}if((x|0)==8){C=y-j;y=e-k;A=u-m;B=q-r;z=o-p;e=i-l;e=(C*z-y*B)*(C*z-y*B)+((y*e-A*z)*(y*e-A*z)+(A*B-C*e)*(A*B-C*e))}C=+K(+h);A=+K(+g);y=+K(+d);v=+K(+e);B=C>-999999984306749440.0?C:-999999984306749440.0;z=A>B?A:B;x=v>(y>z?y:z)?3:y>z?2:A>B?1:(C>-999999984306749440.0^1)<<31>>31;w=(x|0)>0;x=w?x:0;a=a+4+(x*184|0)|0;ki(a|0,b|0,184)|0;return x|0}function nf(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;a:do if(!(IC(a,f[c+8>>2]|0)|0)){if(!(IC(a,f[c>>2]|0)|0)){i=f[a+12>>2]|0;jo(a+16|0,c,d,e,g);if((i|0)<=1)break;h=f[a+8>>2]|0;if((h&2|0)==0?(f[c+36>>2]|0)!=1:0){if(!(h&1)){h=a+24|0;while(1){if(b[c+54>>0]|0)break a;if((f[c+36>>2]|0)==1)break a;jo(h,c,d,e,g);h=h+8|0;if(h>>>0>=(a+16+(i<<3)|0)>>>0)break a}}h=a+24|0;while(1){if(b[c+54>>0]|0)break a;if((f[c+36>>2]|0)==1?(f[c+24>>2]|0)==1:0)break a;jo(h,c,d,e,g);h=h+8|0;if(h>>>0>=(a+16+(i<<3)|0)>>>0)break a}}h=a+24|0;while(1){if(b[c+54>>0]|0)break a;jo(h,c,d,e,g);h=h+8|0;if(h>>>0>=(a+16+(i<<3)|0)>>>0)break a}}if((f[c+16>>2]|0)!=(d|0)?(f[c+20>>2]|0)!=(d|0):0){f[c+32>>2]=e;if((f[c+44>>2]|0)==4)break;j=a+16+(f[a+12>>2]<<3)|0;h=0;i=a+16|0;k=0;b:while(1){if(i>>>0>=j>>>0){e=18;break}b[c+52>>0]=0;b[c+53>>0]=0;Qn(i,c,d,d,1,g);if(b[c+54>>0]|0){e=18;break}do if(b[c+53>>0]|0){if(!(b[c+52>>0]|0))if(!(f[a+8>>2]&1)){h=1;e=18;break b}else{h=1;e=k;break}if((f[c+24>>2]|0)==1){e=23;break b}if(!(f[a+8>>2]&2)){e=23;break b}else{h=1;e=1}}else e=k;while(0);i=i+8|0;k=e}do if((e|0)==18){if((!k?(f[c+20>>2]=d,f[c+40>>2]=(f[c+40>>2]|0)+1,(f[c+36>>2]|0)==1):0)?(f[c+24>>2]|0)==2:0){b[c+54>>0]=1;if(h){e=23;break}else{h=4;break}}if(h)e=23;else h=4}while(0);if((e|0)==23)h=3;f[c+44>>2]=h;break}if((e|0)==1)f[c+32>>2]=1}else Xr(c,d,e);while(0);return}function of(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0;q=f[a+9288>>2]|0;if(!q){f[a>>2]=5;q=0;return q|0}h=f[q+48>>2]|0;if(h|0)f[h+44>>2]=f[q+44>>2];h=f[q+44>>2]|0;if(h|0)f[h+48>>2]=f[q+48>>2];if((f[a+9288>>2]|0)==(q|0))f[a+9288>>2]=f[q+48>>2];f[a+9292>>2]=(f[a+9292>>2]|0)+-1;f[q+44>>2]=0;f[q+48>>2]=f[a+9280>>2];h=f[a+9280>>2]|0;if(h|0)f[h+44>>2]=q;f[a+9280>>2]=q;f[a+9284>>2]=(f[a+9284>>2]|0)+1;b[q+55>>0]=0;f[q+20>>2]=c;f[q+24>>2]=d;f[q+28>>2]=e;l=+n[c+16>>2];i=+n[d+16>>2]-l;m=+n[c+20>>2];j=+n[d+20>>2]-m;o=+n[c+24>>2];k=+n[d+24>>2]-o;l=+n[e+16>>2]-l;m=+n[e+20>>2]-m;o=+n[e+24>>2]-o;n[q>>2]=j*o-k*m;n[q+4>>2]=k*l-i*o;n[q+8>>2]=i*m-j*l;n[q+12>>2]=0.0;p=+L(+((j*o-k*m)*(j*o-k*m)+(k*l-i*o)*(k*l-i*o)+(i*m-j*l)*(i*m-j*l)));if(p>9.999999747378752e-05){if((!(_k(j*o-k*m,k*l-i*o,i*m-j*l,+n[c+16>>2],+n[c+20>>2],+n[c+24>>2],+n[d+16>>2],+n[d+20>>2],+n[d+24>>2],q+16|0)|0)?!(_k(+n[q>>2],+n[q+4>>2],+n[q+8>>2],+n[d+16>>2],+n[d+20>>2],+n[d+24>>2],+n[e+16>>2],+n[e+20>>2],+n[e+24>>2],q+16|0)|0):0)?!(_k(+n[q>>2],+n[q+4>>2],+n[q+8>>2],+n[e+16>>2],+n[e+20>>2],+n[e+24>>2],+n[c+16>>2],+n[c+20>>2],+n[c+24>>2],q+16|0)|0):0)n[q+16>>2]=(+n[c+16>>2]*+n[q>>2]+ +n[c+20>>2]*+n[q+4>>2]+ +n[c+24>>2]*+n[q+8>>2])/p;n[q>>2]=1.0/p*+n[q>>2];n[q+4>>2]=1.0/p*+n[q+4>>2];n[q+8>>2]=1.0/p*+n[q+8>>2];if(g)return q|0;if(!(+n[q+16>>2]>=-9.999999747378752e-06))h=3;else return q|0}else h=2;f[a>>2]=h;h=f[q+48>>2]|0;if(h|0)f[h+44>>2]=f[q+44>>2];h=f[q+44>>2]|0;if(h|0)f[h+48>>2]=f[q+48>>2];if((f[a+9280>>2]|0)==(q|0))f[a+9280>>2]=f[q+48>>2];f[a+9284>>2]=(f[a+9284>>2]|0)+-1;f[q+44>>2]=0;f[q+48>>2]=f[a+9288>>2];h=f[a+9288>>2]|0;if(h|0)f[h+44>>2]=q;f[a+9288>>2]=q;f[a+9292>>2]=(f[a+9292>>2]|0)+1;q=0;return q|0}function pf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;u=+n[b>>2];t=+n[b+4>>2];s=+n[b+8>>2];r=1.0/+L(+(u*u+t*t+s*s));y=+n[c>>2];x=+n[c+4>>2];w=+n[c+8>>2];v=1.0/+L(+(y*y+x*x+w*w));B=s*r*x*v-t*r*w*v;A=u*r*w*v-s*r*y*v;z=t*r*y*v-u*r*x*v;c=f[a+28>>2]|0;d=+n[c+4>>2];g=+n[c+20>>2];i=+n[c+36>>2];e=+n[c+8>>2];h=+n[c+24>>2];j=+n[c+40>>2];k=+n[c+12>>2];m=+n[c+28>>2];p=+n[c+44>>2];l=-+n[c+52>>2];o=-+n[c+56>>2];q=-+n[c+60>>2];n[a+48>>2]=z*i+(d*B+g*A);n[a+52>>2]=d*y*v+x*v*g+w*v*i;n[a+56>>2]=u*r*d+t*r*g+s*r*i;n[a+60>>2]=0.0;n[a+64>>2]=B*e+A*h+z*j;n[a+68>>2]=y*v*e+x*v*h+w*v*j;n[a+72>>2]=u*r*e+t*r*h+s*r*j;n[a+76>>2]=0.0;n[a+80>>2]=B*k+A*m+z*p;n[a+84>>2]=y*v*k+x*v*m+w*v*p;n[a+88>>2]=u*r*k+t*r*m+s*r*p;n[a+92>>2]=0.0;n[a+96>>2]=d*0.0+g*0.0+i*0.0+(d*l+g*o+i*q);n[a+100>>2]=e*0.0+h*0.0+j*0.0+(e*l+h*o+j*q);n[a+104>>2]=k*0.0+m*0.0+p*0.0+(k*l+m*o+p*q);n[a+108>>2]=0.0;c=f[a+32>>2]|0;q=+n[c+4>>2];p=+n[c+20>>2];o=+n[c+36>>2];m=+n[c+8>>2];l=+n[c+24>>2];k=+n[c+40>>2];j=+n[c+12>>2];h=+n[c+28>>2];e=+n[c+44>>2];i=-+n[c+52>>2];g=-+n[c+56>>2];d=-+n[c+60>>2];n[a+112>>2]=B*q+A*p+z*o;n[a+116>>2]=y*v*q+x*v*p+w*v*o;n[a+120>>2]=u*r*q+t*r*p+s*r*o;n[a+124>>2]=0.0;n[a+128>>2]=B*m+A*l+z*k;n[a+132>>2]=y*v*m+x*v*l+w*v*k;n[a+136>>2]=u*r*m+t*r*l+s*r*k;n[a+140>>2]=0.0;n[a+144>>2]=B*j+A*h+z*e;n[a+148>>2]=y*v*j+x*v*h+w*v*e;n[a+152>>2]=u*r*j+t*r*h+s*r*e;n[a+156>>2]=0.0;n[a+160>>2]=q*0.0+p*0.0+o*0.0+(q*i+p*g+o*d);n[a+164>>2]=m*0.0+l*0.0+k*0.0+(m*i+l*g+k*d);n[a+168>>2]=j*0.0+h*0.0+e*0.0+(j*i+h*g+e*d);n[a+172>>2]=0.0;od(a,(f[a+28>>2]|0)+4|0,(f[a+32>>2]|0)+4|0);return}function qf(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f[6202]=(f[6202]|0)+1;g=f[a+24>>2]|0;if(!g){if(!((d[e+6>>1]&d[c+4>>1])<<16>>16)){a=0;return a|0}if(!((d[c+6>>1]&d[e+4>>1])<<16>>16)){a=0;return a|0}}else if(!(Fb[f[(f[g>>2]|0)+8>>2]&63](g,c,e)|0)){a=0;return a|0}l=(f[c+12>>2]|0)>(f[e+12>>2]|0);m=l?e:c;h=f[m+12>>2]|0;l=l?c:e;c=f[l+12>>2]|0;j=((c<<16|h)+~((c<<16|h)<<15)>>10^(c<<16|h)+~((c<<16|h)<<15))*9|0;j=(j>>6^j)+~((j>>6^j)<<11)>>16^(j>>6^j)+~((j>>6^j)<<11);k=f[a+12>>2]|0;g=f[(f[a+44>>2]|0)+((j&k+-1)<<2)>>2]|0;a:do if((g|0)!=-1){e=f[a+16>>2]|0;while(1){if((f[(f[e+(g<<4)>>2]|0)+12>>2]|0)==(h|0)?(f[(f[e+(g<<4)+4>>2]|0)+12>>2]|0)==(c|0):0)break;g=f[(f[a+64>>2]|0)+(g<<2)>>2]|0;if((g|0)==-1)break a}g=e+(g<<4)|0;if(g|0){a=g;return a|0}}while(0);i=f[a+8>>2]|0;if((i|0)==(k|0)){h=k|0?k<<1:1;if((k|0)<(h|0)){if(!h){g=0;e=k}else{f[6472]=(f[6472]|0)+1;g=sc((h<<4|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}e=f[a+8>>2]|0}if((e|0)>0){c=0;do{n=f[a+16>>2]|0;f[g+(c<<4)>>2]=f[n+(c<<4)>>2];f[g+(c<<4)+4>>2]=f[n+(c<<4)+4>>2];f[g+(c<<4)+8>>2]=f[n+(c<<4)+8>>2];f[g+(c<<4)+12>>2]=f[n+(c<<4)+12>>2];c=c+1|0}while((c|0)!=(e|0))}c=f[a+16>>2]|0;if(c|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=g;f[a+12>>2]=h;c=f[a+8>>2]|0;g=h}else{c=k;g=k}}else{c=i;g=k}f[a+8>>2]=c+1;e=f[a+16>>2]|0;c=f[a+72>>2]|0;if(c){Fb[f[(f[c>>2]|0)+8>>2]&63](c,m,l)|0;g=f[a+12>>2]|0}if((k|0)<(g|0)){If(a);g=(f[a+12>>2]|0)+-1&j}else g=j&k+-1;n=(f[m+12>>2]|0)<(f[l+12>>2]|0);f[e+(i<<4)>>2]=n?m:l;f[e+(i<<4)+4>>2]=n?l:m;f[e+(i<<4)+8>>2]=0;f[e+(i<<4)+8+4>>2]=0;n=(f[a+44>>2]|0)+(g<<2)|0;f[(f[a+64>>2]|0)+(i<<2)>>2]=f[n>>2];f[n>>2]=i;n=e+(i<<4)|0;return n|0}function rf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0,q=0.0,r=0,s=0.0,t=0.0,v=0.0,w=0,x=0;w=u;u=u+32|0;p=f[a+12>>2]|0;q=+n[p+(((d+c|0)/2|0)*24|0)>>2];s=+n[p+(((d+c|0)/2|0)*24|0)+4>>2];t=+n[p+(((d+c|0)/2|0)*24|0)+8>>2];v=+n[p+(((d+c|0)/2|0)*24|0)+16>>2];r=f[p+(((d+c|0)/2|0)*24|0)+20>>2]|0;e=d;g=c;while(1){k=+n[b>>2];l=+n[b+4>>2];m=+n[b+8>>2];o=(q-k)*(q-k)+(s-l)*(s-l)+(t-m)*(t-m);a:while(1){h=+n[p+(g*24|0)+16>>2];do if(h!=v){if(!(h<v))break a}else{h=+n[p+(g*24|0)>>2]-k;i=+n[p+(g*24|0)+4>>2]-l;j=+n[p+(g*24|0)+8>>2]-m;if(h*h+i*i+j*j!=o)if(h*h+i*i+j*j<o)break;else break a;else if((f[p+(g*24|0)+20>>2]|0)<(r|0))break;else break a}while(0);g=g+1|0}b:while(1){h=+n[p+(e*24|0)+16>>2];do if(v!=h){if(!(v<h))break b}else{h=+n[p+(e*24|0)>>2]-k;i=+n[p+(e*24|0)+4>>2]-l;j=+n[p+(e*24|0)+8>>2]-m;if(o!=h*h+i*i+j*j)if(o<h*h+i*i+j*j)break;else break b;else if((r|0)<(f[p+(e*24|0)+20>>2]|0))break;else break b}while(0);e=e+-1|0}if((g|0)<=(e|0)){x=p+(g*24|0)|0;f[w>>2]=f[x>>2];f[w+4>>2]=f[x+4>>2];f[w+8>>2]=f[x+8>>2];f[w+12>>2]=f[x+12>>2];f[w+16>>2]=f[x+16>>2];f[w+20>>2]=f[x+20>>2];p=p+(e*24|0)|0;f[x>>2]=f[p>>2];f[x+4>>2]=f[p+4>>2];f[x+8>>2]=f[p+8>>2];f[x+12>>2]=f[p+12>>2];f[x+16>>2]=f[p+16>>2];f[x+20>>2]=f[p+20>>2];p=(f[a+12>>2]|0)+(e*24|0)|0;f[p>>2]=f[w>>2];f[p+4>>2]=f[w+4>>2];f[p+8>>2]=f[w+8>>2];f[p+12>>2]=f[w+12>>2];f[p+16>>2]=f[w+16>>2];f[p+20>>2]=f[w+20>>2];e=e+-1|0;g=g+1|0}if((g|0)>(e|0))break;p=f[a+12>>2]|0}if((e|0)>(c|0))rf(a,b,c,e);if((g|0)>=(d|0)){u=w;return}rf(a,b,g,d);u=w;return}function sf(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+32|0;b[p+16>>0]=1;f[p+12>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;if((f[a+8>>2]|0)>0){l=0;g=0;d=0;h=0;e=0;while(1){m=f[a+16>>2]|0;n=m+(l<<4)|0;if((g|0)==(e|0)){i=e|0?e<<1:1;if((e|0)<(i|0)){if(i){f[6472]=(f[6472]|0)+1;d=sc((i<<4|3)+16|0)|0;if(!d){k=0;e=g}else{f[(d+4+15&-16)+-4>>2]=d;k=d+4+15&-16;e=g}}else k=0;if((e|0)>0){d=0;do{j=f[p+12>>2]|0;f[k+(d<<4)>>2]=f[j+(d<<4)>>2];f[k+(d<<4)+4>>2]=f[j+(d<<4)+4>>2];f[k+(d<<4)+8>>2]=f[j+(d<<4)+8>>2];f[k+(d<<4)+12>>2]=f[j+(d<<4)+12>>2];d=d+1|0}while((d|0)!=(e|0))}d=f[p+12>>2]|0;if(!d)g=e;else{if(!(b[p+16>>0]|0))g=e;else{f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[p+12>>2]=0}b[p+16>>0]=1;f[p+12>>2]=k;j=i;h=i;i=g;d=k}else{j=e;i=e}}else{j=e;i=g}f[d+(i<<4)>>2]=f[n>>2];f[d+(i<<4)+4>>2]=f[m+(l<<4)+4>>2];f[d+(i<<4)+8>>2]=f[m+(l<<4)+8>>2];f[d+(i<<4)+12>>2]=f[m+(l<<4)+12>>2];g=i+1|0;l=l+1|0;if((l|0)>=(f[a+8>>2]|0))break;else e=j}f[p+4>>2]=g;f[p+8>>2]=h;if((i|0)>-1){e=f[p+12>>2]|0;d=0;while(1){Gb[f[(f[a>>2]|0)+12>>2]&31](a,f[e+(d<<4)>>2]|0,f[e+(d<<4)+4>>2]|0,c)|0;if((d|0)<(i|0))d=d+1|0;else break}}}else g=0;if((f[a+56>>2]|0)>0){e=f[a+64>>2]|0;d=0;do{f[e+(d<<2)>>2]=-1;d=d+1|0}while((d|0)<(f[a+56>>2]|0))}if((g|0)<=1)if((g|0)<=0){d=f[p+12>>2]|0;if(!d){u=p;return}}else o=25;else{ue(p,0,g+-1|0);o=25}if((o|0)==25){d=f[p+12>>2]|0;e=0;do{Fb[f[(f[a>>2]|0)+8>>2]&63](a,f[d+(e<<4)>>2]|0,f[d+(e<<4)+4>>2]|0)|0;e=e+1|0}while((e|0)<(g|0))}f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);f[p+12>>2]=0;u=p;return}function tf(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0.0,g=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0;i=f[a+28>>2]|0;j=f[a+32>>2]|0;d=f[b+8>>2]|0;n[d>>2]=1.0;g=f[b+24>>2]|0;n[d+(g+1<<2)>>2]=1.0;n[d+((g<<1)+2<<2)>>2]=1.0;k=+n[a+300>>2];q=+n[a+304>>2];e=+n[a+308>>2];o=+n[i+4>>2]*k+ +n[i+8>>2]*q+ +n[i+12>>2]*e;l=k*+n[i+20>>2]+q*+n[i+24>>2]+e*+n[i+28>>2];e=k*+n[i+36>>2]+q*+n[i+40>>2]+e*+n[i+44>>2];d=f[b+12>>2]|0;f[d>>2]=0;n[d+4>>2]=e;n[d+8>>2]=-l;n[d+12>>2]=0.0;n[d+(g<<2)>>2]=-e;f[d+(g<<2)+4>>2]=0;n[d+(g<<2)+8>>2]=o;n[d+(g<<2)+12>>2]=0.0;n[d+(g<<1<<2)>>2]=l;n[d+(g<<1<<2)+4>>2]=-o;f[d+(g<<1<<2)+8>>2]=0;n[d+(g<<1<<2)+12>>2]=0.0;d=f[b+16>>2]|0;n[d>>2]=-1.0;n[d+(g+1<<2)>>2]=-1.0;n[d+((g<<1)+2<<2)>>2]=-1.0;q=+n[a+316>>2];k=+n[a+320>>2];c=+n[a+324>>2];p=+n[j+4>>2]*q+ +n[j+8>>2]*k+ +n[j+12>>2]*c;m=q*+n[j+20>>2]+k*+n[j+24>>2]+c*+n[j+28>>2];c=q*+n[j+36>>2]+k*+n[j+40>>2]+c*+n[j+44>>2];g=f[b+20>>2]|0;d=f[b+24>>2]|0;f[g>>2]=0;n[g+4>>2]=-c;n[g+8>>2]=m;n[g+12>>2]=0.0;n[g+(d<<2)>>2]=c;f[g+(d<<2)+4>>2]=0;n[g+(d<<2)+8>>2]=-p;n[g+(d<<2)+12>>2]=0.0;n[g+(d<<1<<2)>>2]=-m;n[g+(d<<1<<2)+4>>2]=p;f[g+(d<<1<<2)+8>>2]=0;n[g+(d<<1<<2)+12>>2]=0.0;g=f[a+332>>2]|0;k=+n[(g&1|0?a+336|0:b+4|0)>>2]*+n[b>>2];h=f[b+28>>2]|0;n[h>>2]=k*(p+ +n[j+52>>2]-o-+n[i+52>>2]);n[h+(d<<2)>>2]=k*(m+ +n[j+56>>2]-l-+n[i+56>>2]);n[h+(d<<1<<2)>>2]=k*(c+ +n[j+60>>2]-e-+n[i+60>>2]);if(g&2|0){j=f[b+32>>2]|0;f[j>>2]=f[a+340>>2];f[j+(d<<2)>>2]=f[a+340>>2];f[j+(d<<1<<2)>>2]=f[a+340>>2]}e=+n[a+356>>2];if(e>0.0){n[f[b+36>>2]>>2]=-e;n[f[b+40>>2]>>2]=e;c=+n[a+356>>2]}else c=e;if(c>0.0){n[(f[b+36>>2]|0)+(d<<2)>>2]=-e;n[(f[b+40>>2]|0)+(d<<2)>>2]=e;c=+n[a+356>>2]}if(!(c>0.0)){i=a+352|0;i=f[i>>2]|0;j=b+52|0;f[j>>2]=i;return}n[(f[b+36>>2]|0)+(d<<1<<2)>>2]=-e;n[(f[b+40>>2]|0)+(d<<1<<2)>>2]=e;i=a+352|0;i=f[i>>2]|0;j=b+52|0;f[j>>2]=i;return}
function qc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0.0,C=0,D=0,E=0,F=0,G=0.0,H=0,I=0,J=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0,S=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0,ya=0,za=0,Aa=0,Ba=0.0,Ca=0;Ca=u;u=u+496|0;f[Ca+56>>2]=f[b>>2];f[Ca+8>>2]=f[b+64>>2];i=Ca+56+4|0;f[i>>2]=f[b+4>>2];f[Ca+8+4>>2]=f[b+68>>2];f[Ca+56+8>>2]=f[b+8>>2];f[Ca+8+8>>2]=f[b+72>>2];f[Ca+56+16>>2]=f[b+16>>2];f[Ca+8+16>>2]=f[b+80>>2];f[Ca+56+20>>2]=f[b+20>>2];f[Ca+8+20>>2]=f[b+84>>2];f[Ca+56+24>>2]=f[b+24>>2];f[Ca+8+24>>2]=f[b+88>>2];f[Ca+56+32>>2]=f[b+32>>2];f[Ca+8+32>>2]=f[b+96>>2];f[Ca+56+36>>2]=f[b+36>>2];f[Ca+8+36>>2]=f[b+100>>2];f[Ca+56+40>>2]=f[b+40>>2];f[Ca+8+40>>2]=f[b+104>>2];Aa=f[a+4>>2]|0;da=+n[Aa+28>>2];ea=+n[Aa+32>>2];ha=+n[Aa+36>>2];fa=+rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa);ga=+rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa);ha=(ha+ +rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa))*2.0;Aa=f[a+8>>2]|0;la=+n[Aa+28>>2];ma=+n[Aa+32>>2];ra=+n[Aa+36>>2];na=+rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa);oa=+rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa);ra=(ra+ +rb[f[(f[Aa>>2]|0)+48>>2]&15](Aa))*2.0;O=+n[b+112>>2]-+n[b+48>>2];P=+n[b+116>>2]-+n[b+52>>2];Q=+n[b+120>>2]-+n[b+56>>2];aa=+n[Ca+56>>2];_=+n[Ca+56+16>>2];$=+n[Ca+56+32>>2];Z=+n[i>>2];X=+n[Ca+56+20>>2];Y=+n[Ca+56+36>>2];ba=+n[Ca+56+8>>2];ca=+n[Ca+56+24>>2];ia=+n[Ca+56+40>>2];n[Ca+380>>2]=(da+fa)*2.0*.5;n[Ca+380+4>>2]=(ea+ga)*2.0*.5;n[Ca+380+8>>2]=ha*.5;n[Ca+368>>2]=(la+na)*2.0*.5;n[Ca+368+4>>2]=(ma+oa)*2.0*.5;n[Ca+368+8>>2]=ra*.5;ua=+n[Ca+8>>2];ka=+n[Ca+8+16>>2];qa=+n[Ca+8+32>>2];ta=+n[Ca+8+4>>2];ja=+n[Ca+8+20>>2];pa=+n[Ca+8+36>>2];sa=+n[Ca+8+8>>2];va=+n[Ca+8+24>>2];wa=+n[Ca+8+40>>2];B=+K(+(aa*ua+_*ka+$*qa));J=+K(+(aa*ta+_*ja+$*pa));S=+K(+(aa*sa+_*va+$*wa));G=+K(+(ua*Z+ka*X+qa*Y));M=+K(+(ta*Z+ja*X+pa*Y));U=+K(+(sa*Z+va*X+wa*Y));V=+K(+(ua*ba+ka*ca+qa*ia));W=+K(+(ta*ba+ja*ca+pa*ia));N=+K(+(sa*ba+va*ca+wa*ia));h=+K(+(O*aa+P*_+Q*$))-(ra*.5*S+((da+fa)*2.0*.5+B*(la+na)*2.0*.5+J*(ma+oa)*2.0*.5));if(h>0.0){u=Ca;return}if(h>-3402823466385288598117041.0e14){a=Ca+56|0;d=1;e=O*aa+P*_+Q*$<0.0&1}else{a=0;d=0;e=0;h=-3402823466385288598117041.0e14}g=+K(+(O*Z+P*X+Q*Y))-((ea+ga)*2.0*.5+G*(la+na)*2.0*.5+M*(ma+oa)*2.0*.5+U*ra*.5);if(g>0.0){u=Ca;return}if(g>h){a=i;d=2;e=O*Z+P*X+Q*Y<0.0&1;h=g}g=+K(+(O*ba+P*ca+Q*ia))-(ha*.5+V*(la+na)*2.0*.5+W*(ma+oa)*2.0*.5+N*ra*.5);if(g>0.0){u=Ca;return}if(g>h){a=Ca+56+8|0;d=3;e=O*ba+P*ca+Q*ia<0.0&1;h=g}g=+K(+(O*ua+P*ka+Q*qa))-((la+na)*2.0*.5+(B*(da+fa)*2.0*.5+G*(ea+ga)*2.0*.5+V*ha*.5));if(g>0.0){u=Ca;return}if(g>h){a=Ca+8|0;d=4;e=O*ua+P*ka+Q*qa<0.0&1;h=g}g=+K(+(O*ta+P*ja+Q*pa))-((ma+oa)*2.0*.5+(J*(da+fa)*2.0*.5+M*(ea+ga)*2.0*.5+W*ha*.5));if(g>0.0){u=Ca;return}if(g>h){a=Ca+8+4|0;d=5;e=O*ta+P*ja+Q*pa<0.0&1;h=g}g=+K(+(O*sa+P*va+Q*wa))-(ra*.5+(S*(da+fa)*2.0*.5+U*(ea+ga)*2.0*.5+N*ha*.5));if(g>0.0){u=Ca;return}if(g>h){a=Ca+8+8|0;d=6;e=O*sa+P*va+Q*wa<0.0&1;h=g}g=(O*ba+P*ca+Q*ia)*(ua*Z+ka*X+qa*Y)-(O*Z+P*X+Q*Y)*(ua*ba+ka*ca+qa*ia);k=+K(+g)-((V+9.999999747378752e-06)*(ea+ga)*2.0*.5+(G+9.999999747378752e-06)*ha*.5+(S+9.999999747378752e-06)*(ma+oa)*2.0*.5+(J+9.999999747378752e-06)*ra*.5);if(k>1.1920928955078125e-07){u=Ca;return}q=(ua*ba+ka*ca+qa*ia)*(ua*ba+ka*ca+qa*ia)+0.0;x=(ua*Z+ka*X+qa*Y)*(ua*Z+ka*X+qa*Y);o=+L(+(x+q));if(o>1.1920928955078125e-07?k/o*1.0499999523162842>h:0){a=0;d=7;e=g<0.0&1;h=k/o;m=0.0/o;l=-(ua*ba+ka*ca+qa*ia)/o;g=(ua*Z+ka*X+qa*Y)/o}else{m=0.0;l=0.0;g=0.0}k=(O*ba+P*ca+Q*ia)*(ta*Z+ja*X+pa*Y)-(O*Z+P*X+Q*Y)*(ta*ba+ja*ca+pa*ia);o=+K(+k)-((W+9.999999747378752e-06)*(ea+ga)*2.0*.5+(M+9.999999747378752e-06)*ha*.5+(S+9.999999747378752e-06)*(la+na)*2.0*.5+(B+9.999999747378752e-06)*ra*.5);if(o>1.1920928955078125e-07){u=Ca;return}r=(ta*ba+ja*ca+pa*ia)*(ta*ba+ja*ca+pa*ia)+0.0;y=(ta*Z+ja*X+pa*Y)*(ta*Z+ja*X+pa*Y);p=+L(+(y+r));if(p>1.1920928955078125e-07?o/p*1.0499999523162842>h:0){a=0;d=8;e=k<0.0&1;h=o/p;m=0.0/p;l=-(ta*ba+ja*ca+pa*ia)/p;g=(ta*Z+ja*X+pa*Y)/p}k=(O*ba+P*ca+Q*ia)*(sa*Z+va*X+wa*Y)-(O*Z+P*X+Q*Y)*(sa*ba+va*ca+wa*ia);o=+K(+k)-((N+9.999999747378752e-06)*(ea+ga)*2.0*.5+(U+9.999999747378752e-06)*ha*.5+(J+9.999999747378752e-06)*(la+na)*2.0*.5+(B+9.999999747378752e-06)*(ma+oa)*2.0*.5);if(o>1.1920928955078125e-07){u=Ca;return}v=(sa*ba+va*ca+wa*ia)*(sa*ba+va*ca+wa*ia)+0.0;z=(sa*Z+va*X+wa*Y)*(sa*Z+va*X+wa*Y);p=+L(+(z+v));if(p>1.1920928955078125e-07?o/p*1.0499999523162842>h:0){a=0;d=9;e=k<0.0&1;h=o/p;m=0.0/p;l=-(sa*ba+va*ca+wa*ia)/p;g=(sa*Z+va*X+wa*Y)/p}k=(O*aa+P*_+Q*$)*(ua*ba+ka*ca+qa*ia)-(O*ba+P*ca+Q*ia)*(aa*ua+_*ka+$*qa);o=+K(+k)-((V+9.999999747378752e-06)*(da+fa)*2.0*.5+(B+9.999999747378752e-06)*ha*.5+(U+9.999999747378752e-06)*(ma+oa)*2.0*.5+(M+9.999999747378752e-06)*ra*.5);if(o>1.1920928955078125e-07){u=Ca;return}w=(aa*ua+_*ka+$*qa)*(aa*ua+_*ka+$*qa);p=+L(+(w+q));do if(p>1.1920928955078125e-07){if(!(o/p*1.0499999523162842>h))break;a=0;d=10;e=k<0.0&1;h=o/p;m=(ua*ba+ka*ca+qa*ia)/p;l=0.0/p;g=-(aa*ua+_*ka+$*qa)/p}while(0);k=(O*aa+P*_+Q*$)*(ta*ba+ja*ca+pa*ia)-(O*ba+P*ca+Q*ia)*(aa*ta+_*ja+$*pa);o=+K(+k)-((W+9.999999747378752e-06)*(da+fa)*2.0*.5+(J+9.999999747378752e-06)*ha*.5+(U+9.999999747378752e-06)*(la+na)*2.0*.5+(G+9.999999747378752e-06)*ra*.5);if(o>1.1920928955078125e-07){u=Ca;return}t=(aa*ta+_*ja+$*pa)*(aa*ta+_*ja+$*pa);p=+L(+(t+r));do if(p>1.1920928955078125e-07){if(!(o/p*1.0499999523162842>h))break;a=0;d=11;e=k<0.0&1;h=o/p;m=(ta*ba+ja*ca+pa*ia)/p;l=0.0/p;g=-(aa*ta+_*ja+$*pa)/p}while(0);k=(O*aa+P*_+Q*$)*(sa*ba+va*ca+wa*ia)-(O*ba+P*ca+Q*ia)*(aa*sa+_*va+$*wa);o=+K(+k)-((N+9.999999747378752e-06)*(da+fa)*2.0*.5+(S+9.999999747378752e-06)*ha*.5+(M+9.999999747378752e-06)*(la+na)*2.0*.5+(G+9.999999747378752e-06)*(ma+oa)*2.0*.5);if(o>1.1920928955078125e-07){u=Ca;return}q=(aa*sa+_*va+$*wa)*(aa*sa+_*va+$*wa);p=+L(+(q+v));do if(p>1.1920928955078125e-07){if(!(o/p*1.0499999523162842>h))break;a=0;d=12;e=k<0.0&1;h=o/p;m=(sa*ba+va*ca+wa*ia)/p;l=0.0/p;g=-(aa*sa+_*va+$*wa)/p}while(0);o=(O*Z+P*X+Q*Y)*(aa*ua+_*ka+$*qa)-(O*aa+P*_+Q*$)*(ua*Z+ka*X+qa*Y);k=+K(+o)-((G+9.999999747378752e-06)*(da+fa)*2.0*.5+(B+9.999999747378752e-06)*(ea+ga)*2.0*.5+(N+9.999999747378752e-06)*(ma+oa)*2.0*.5+(W+9.999999747378752e-06)*ra*.5);if(k>1.1920928955078125e-07){u=Ca;return}p=+L(+(w+x+0.0));do if(p>1.1920928955078125e-07){if(!(k/p*1.0499999523162842>h))break;a=0;d=13;e=o<0.0&1;h=k/p;m=-(ua*Z+ka*X+qa*Y)/p;l=(aa*ua+_*ka+$*qa)/p;g=0.0/p}while(0);p=(O*Z+P*X+Q*Y)*(aa*ta+_*ja+$*pa)-(O*aa+P*_+Q*$)*(ta*Z+ja*X+pa*Y);k=+K(+p)-((M+9.999999747378752e-06)*(da+fa)*2.0*.5+(J+9.999999747378752e-06)*(ea+ga)*2.0*.5+(N+9.999999747378752e-06)*(la+na)*2.0*.5+(V+9.999999747378752e-06)*ra*.5);if(k>1.1920928955078125e-07){u=Ca;return}o=+L(+(t+y+0.0));do if(o>1.1920928955078125e-07){if(!(k/o*1.0499999523162842>h))break;a=0;d=14;e=p<0.0&1;h=k/o;m=-(ta*Z+ja*X+pa*Y)/o;l=(aa*ta+_*ja+$*pa)/o;g=0.0/o}while(0);p=(O*Z+P*X+Q*Y)*(aa*sa+_*va+$*wa)-(O*aa+P*_+Q*$)*(sa*Z+va*X+wa*Y);k=+K(+p)-((U+9.999999747378752e-06)*(da+fa)*2.0*.5+(S+9.999999747378752e-06)*(ea+ga)*2.0*.5+(W+9.999999747378752e-06)*(la+na)*2.0*.5+(V+9.999999747378752e-06)*(ma+oa)*2.0*.5);if(k>1.1920928955078125e-07){u=Ca;return}o=+L(+(q+z+0.0));do if(o>1.1920928955078125e-07){if(!(k/o*1.0499999523162842>h)){xa=55;break}d=15;e=p<0.0&1;h=k/o;m=-(sa*Z+va*X+wa*Y)/o;l=(aa*sa+_*va+$*wa)/o;g=0.0/o;xa=58}else xa=55;while(0);do if((xa|0)==55){if(!d){u=Ca;return}if(!a){xa=58;break}j=f[a>>2]|0;f[Ca>>2]=j;Aa=f[a+16>>2]|0;k=(f[s>>2]=j,+n[s>>2]);j=d;B=h;d=Aa;h=(f[s>>2]=Aa,+n[s>>2]);g=+n[a+32>>2]}while(0);if((xa|0)==58){k=m*+n[Ca+56>>2]+l*+n[i>>2]+g*ba;n[Ca>>2]=k;Ba=m*+n[Ca+56+16>>2]+l*+n[Ca+56+20>>2]+g*ca;j=d;B=h;d=(n[s>>2]=Ba,f[s>>2]|0);h=Ba;g=m*+n[Ca+56+32>>2]+l*+n[Ca+56+36>>2]+g*ia}if(!e){Ba=g;Aa=d}else{k=-k;n[Ca>>2]=k;Ba=-g;Aa=(n[s>>2]=-h,f[s>>2]|0)}if((j|0)>6){z=(f[s>>2]=Aa,+n[s>>2]);h=+n[Ca+56>>2];r=+n[Ca+56+16>>2];v=+n[Ca+56+32>>2];t=(k*h+r*z+Ba*v>0.0?1.0:-1.0)*(da+fa)*2.0*.5;y=+n[i>>2];x=+n[Ca+56+20>>2];g=+n[Ca+56+36>>2];q=(k*y+x*z+Ba*g>0.0?1.0:-1.0)*(ea+ga)*2.0*.5;w=(k*ba+ca*z+Ba*ia>0.0?1.0:-1.0)*ha*.5;y=+n[b+48>>2]+t*h+q*y+w*ba;x=+n[b+52>>2]+t*r+q*x+w*ca;w=+n[b+56>>2]+t*v+q*g+w*ia;f[Ca+424>>2]=f[b+112>>2];f[Ca+424+4>>2]=f[b+112+4>>2];f[Ca+424+8>>2]=f[b+112+8>>2];g=(k*ua+ka*z+Ba*qa>0.0?-1.0:1.0)*(la+na)*2.0*.5;q=(k*ta+ja*z+Ba*pa>0.0?-1.0:1.0)*(ma+oa)*2.0*.5;v=+n[Ca+424+4>>2]+g*ka+q*ja;t=+n[Ca+424+8>>2]+g*qa+q*pa;r=(k*sa+va*z+Ba*wa>0.0?-1.0:1.0)*ra*.5;q=+n[Ca+424>>2]+g*ua+q*ta+r*sa;n[Ca+424>>2]=q;n[Ca+424+4>>2]=v+r*va;n[Ca+424+8>>2]=t+r*wa;Aa=j+-7|0;g=+n[Ca+56+(((Aa|0)/3|0)<<2)>>2];h=+n[Ca+56+(((Aa|0)/3|0)+4<<2)>>2];k=+n[Ca+56+(((Aa|0)/3|0)+8<<2)>>2];m=+n[Ca+8+(((Aa|0)%3|0)<<2)>>2];o=+n[Ca+8+(((Aa|0)%3|0)+4<<2)>>2];p=+n[Ca+8+(((Aa|0)%3|0)+8<<2)>>2];l=1.0-(g*m+h*o+k*p)*(g*m+h*o+k*p);if(!(l<=9.999999747378752e-05))g=(((q-y)*g+(v+r*va-x)*h+(t+r*wa-w)*k)*(g*m+h*o+k*p)-((q-y)*m+(v+r*va-x)*o+(t+r*wa-w)*p))*(1.0/l);else g=0.0;n[Ca+424>>2]=q+g*m;n[Ca+424+4>>2]=v+r*va+g*o;n[Ca+424+8>>2]=t+r*wa+g*p;Aa=f[(f[c>>2]|0)+16>>2]|0;n[Ca+392>>2]=-+n[Ca>>2];n[Ca+392+4>>2]=-z;n[Ca+392+8>>2]=-Ba;n[Ca+392+12>>2]=0.0;Wb[Aa&15](c,Ca+392|0,Ca+424|0,B);u=Ca;return}ya=(j|0)<4;za=ya?b+48|0:b+112|0;e=ya?b+112|0:b+48|0;a=ya?Ca+56|0:Ca+8|0;R=ya?Ca+8|0:Ca+56|0;H=ya?Ca+380|0:Ca+368|0;i=ya?Ca+368|0:Ca+380|0;if(ya){aa=Ba;_=k;$=(f[s>>2]=Aa,+n[s>>2])}else{aa=-Ba;_=-k;$=-(f[s>>2]=Aa,+n[s>>2])}v=_*+n[R>>2]+$*+n[R+16>>2]+aa*+n[R+32>>2];n[Ca+352>>2]=v;w=_*+n[R+4>>2]+$*+n[R+20>>2]+aa*+n[R+36>>2];n[Ca+352+4>>2]=w;x=_*+n[R+8>>2]+$*+n[R+24>>2]+aa*+n[R+40>>2];n[Ca+352+8>>2]=x;v=+K(+v);w=+K(+w);x=+K(+x);d=w>v?(w>x?1:2):v>x?0:2;I=(w>v?w>x:v>x)?2:1;k=+n[i+(d<<2)>>2];g=+n[e>>2]-+n[za>>2];h=k*+n[R+(d<<2)>>2];if(+n[Ca+352+(d<<2)>>2]<0.0){Z=+n[e+8>>2]-+n[za+8>>2]+k*+n[R+((d|8)<<2)>>2];Y=g+h;X=+n[e+4>>2]-+n[za+4>>2]+k*+n[R+((d|4)<<2)>>2]}else{Z=+n[e+8>>2]-+n[za+8>>2]-k*+n[R+((d|8)<<2)>>2];Y=g-h;X=+n[e+4>>2]-+n[za+4>>2]-k*+n[R+((d|4)<<2)>>2]}E=(ya?-1:-4)+j|0;switch(E|0){case 0:{e=2;d=1;break}case 1:{e=2;d=0;break}default:{e=1;d=0}}F=a+(d<<2)|0;V=+n[F>>2];S=+n[F+16>>2];U=+n[F+32>>2];W=Y*V+X*S+Z*U;F=a+(e<<2)|0;N=+n[F>>2];y=+n[F+16>>2];z=+n[F+32>>2];Q=Y*N+X*y+Z*z;F=R+((v>x&(w>v^1)&1)<<2)|0;P=+n[F>>2];J=+n[F+16>>2];M=+n[F+32>>2];O=+n[R+(I<<2)>>2];B=+n[R+(I<<2)+16>>2];G=+n[R+(I<<2)+32>>2];r=+n[i+((v>x&(w>v^1)&1)<<2)>>2];q=+n[i+(I<<2)>>2];p=(V*O+S*B+U*G)*q;q=(N*O+y*B+z*G)*q;m=W-(V*P+S*J+U*M)*r-p;o=Q-(N*P+y*J+z*M)*r-q;g=W-(V*P+S*J+U*M)*r+p;n[Ca+344>>2]=g;h=Q-(N*P+y*J+z*M)*r+q;k=W+(V*P+S*J+U*M)*r+p;l=Q+(N*P+y*J+z*M)*r+q;p=W+(V*P+S*J+U*M)*r-p;q=Q+(N*P+y*J+z*M)*r-q;C=f[H+(d<<2)>>2]|0;D=f[H+(e<<2)>>2]|0;r=(f[s>>2]=C,+n[s>>2]);do if(!(r>-m))if(r>-g){e=Ca+280|0;d=1;a=1;xa=78}else{e=Ca+280|0;d=0;xa=148}else{n[Ca+280>>2]=m;n[Ca+280+4>>2]=o;if(!(r>-g)){e=Ca+280+8|0;d=2;a=r>-g;xa=78;break}n[Ca+280+8>>2]=g;n[Ca+280+8+4>>2]=h;e=Ca+280+8|0;d=2;xa=147}while(0);do if((xa|0)==78){n[e+4>>2]=o+(-r-m)*((h-o)/(g-m));n[e>>2]=-r;e=e+8|0;if(!a){xa=148;break}n[e>>2]=g;n[e+4>>2]=h;if(!(d+1&8)){d=d+1|0;xa=147}else{d=d+1|0;xa=101}}while(0);if((xa|0)==147){e=e+8|0;g=+n[Ca+344>>2];xa=148}a:do if((xa|0)==148){if(r>-g^r>-k){n[e+4>>2]=h+(-r-g)*((l-h)/(k-g));n[e>>2]=-r;d=d+1|0;if(!(d&8))e=e+8|0;else{xa=101;break}}if(r>-k){n[e>>2]=k;n[e+4>>2]=l;d=d+1|0;if(d&8|0){xa=101;break}e=e+8|0;if(r>-k^r>-p){a=r>-p;xa=154}else{a=r>-p;xa=156}}else if(r>-k^r>-p){a=r>-p;xa=154}else{a=r>-p;xa=156}if((xa|0)==154){n[e+4>>2]=l+(-r-k)*((q-l)/(p-k));n[e>>2]=-r;d=d+1|0;if(d&8|0){xa=101;break}e=e+8|0;if(a)xa=157;else xa=158}else if((xa|0)==156)if(a)xa=157;else xa=158;do if((xa|0)==157){n[e>>2]=p;n[e+4>>2]=q;d=d+1|0;if(d&8|0){xa=101;break a}if(a^r>-m){e=e+8|0;xa=160}else{a=Ca+424|0;A=Ca+280|0;e=0;xa=80}}else if((xa|0)==158){if(r>-m){xa=160;break}if((d|0)>0){a=Ca+424|0;A=Ca+280|0;e=0;xa=80}else{d=0;xa=79}}while(0);if((xa|0)==160){n[e+4>>2]=q+(-r-p)*((o-q)/(m-p));n[e>>2]=-r;d=d+1|0;if(!(d&8)){a=Ca+424|0;A=Ca+280|0;e=0;xa=80}else{xa=101;break}}b:do if((xa|0)==80){while(1){xa=0;g=+n[A>>2];if(g<r){n[a>>2]=g;f[a+4>>2]=f[A+4>>2];e=e+1|0;if(e&8|0){d=e;xa=79;break b}a=a+8|0;g=+n[A>>2]}b=(d|0)>1;i=A;A=A+8|0;j=b?A:Ca+280|0;h=+n[j>>2];if(g<r^h<r){wa=+n[i+4>>2];n[a+4>>2]=wa+(r-g)*((+n[j+4>>2]-wa)/(h-g));f[a>>2]=C;e=e+1|0;if(!(e&8))a=a+8|0;else{d=e;xa=79;break b}}if(!b)break;else{d=d+-1|0;xa=80}}if((e|0)<=0){d=0;xa=79;break}k=(f[s>>2]=D,+n[s>>2]);a=Ca+280|0;A=Ca+424|0;d=0;while(1){i=A+4|0;g=+n[i>>2];if(k>-g){f[a>>2]=f[A>>2];f[a+4>>2]=f[i>>2];d=d+1|0;if(d&8|0)break b;a=a+8|0;g=+n[i>>2]}b=(e|0)>1;i=A;A=A+8|0;j=b?A:Ca+424|0;h=+n[j+4>>2];if(k>-g^k>-h){wa=+n[i>>2];n[a>>2]=wa+(-k-g)*((+n[j>>2]-wa)/(h-g));n[a+4>>2]=-k;d=d+1|0;if(!(d&8))a=a+8|0;else break b}if(!b)break;else e=e+-1|0}if((d|0)>0){b=d;e=Ca+424|0;A=Ca+280|0;d=0}else{d=0;xa=79;break}while(1){a=A+4|0;g=+n[a>>2];if(g<k){f[e>>2]=f[A>>2];f[e+4>>2]=f[a>>2];d=d+1|0;if(d&8|0){xa=79;break b}e=e+8|0;g=+n[a>>2]}j=(b|0)>1;a=A;A=A+8|0;i=j?A:Ca+280|0;h=+n[i+4>>2];if(g<k^h<k){wa=+n[a>>2];n[e>>2]=wa+(k-g)*((+n[i>>2]-wa)/(h-g));f[e+4>>2]=D;d=d+1|0;if(!(d&8))e=e+8|0;else{xa=79;break b}}if(!j){xa=79;break}else b=b+-1|0}}while(0);if((xa|0)==79)ki(Ca+280|0,Ca+424|0,d<<3|0)|0;if((d|0)>=1)xa=103}while(0);if((xa|0)==101)xa=103;if((xa|0)==103){t=1.0/((V*P+S*J+U*M)*(N*O+y*B+z*G)-(N*P+y*J+z*M)*(V*O+S*B+U*G));r=+n[H+(E<<2)>>2];m=+n[F>>2];o=+n[R+(I<<2)>>2];p=+n[R+((v>x&(w>v^1)&1|4)<<2)>>2];q=+n[R+((I|4)<<2)>>2];l=+n[R+((v>x&(w>v^1)&1|8)<<2)>>2];k=+n[R+((I|8)<<2)>>2];b=0;a=0;do{e=a<<1;g=+n[Ca+280+(e<<2)>>2];h=+n[Ca+280+((e|1)<<2)>>2];ta=(N*O+y*B+z*G)*t*(g-W)-(V*O+S*B+U*G)*t*(h-Q);wa=(V*P+S*J+U*M)*t*(h-Q)-(N*P+y*J+z*M)*t*(g-W);e=b*3|0;ua=Y+ta*m+wa*o;n[Ca+184+(e<<2)>>2]=ua;va=X+ta*p+wa*q;n[Ca+184+(e+1<<2)>>2]=va;wa=Z+ta*l+wa*k;n[Ca+184+(e+2<<2)>>2]=wa;wa=r-(_*ua+$*va+aa*wa);n[Ca+152+(b<<2)>>2]=wa;e=b<<1;if(wa>=0.0){n[Ca+280+(e<<2)>>2]=g;n[Ca+280+((e|1)<<2)>>2]=h;b=b+1|0}a=a+1|0}while((a|0)!=(d|0));c:do if((b|0)>=1){A=(b|0)<4?b:4;C=(A|0)>1?A:1;if((b|0)<=(C|0))if(ya){h=-(f[s>>2]=Aa,+n[s>>2]);g=-Ba;d=0;while(1){Aa=d*3|0;n[Ca+424>>2]=+n[Ca+184+(Aa<<2)>>2]+ +n[za>>2];n[Ca+424+4>>2]=+n[Ca+184+(Aa+1<<2)>>2]+ +n[za+4>>2];n[Ca+424+8>>2]=+n[Ca+184+(Aa+2<<2)>>2]+ +n[za+8>>2];Aa=f[(f[c>>2]|0)+16>>2]|0;n[Ca+392>>2]=-+n[Ca>>2];n[Ca+392+4>>2]=h;n[Ca+392+8>>2]=g;n[Ca+392+12>>2]=0.0;Wb[Aa&15](c,Ca+392|0,Ca+424|0,-+n[Ca+152+(d<<2)>>2]);d=d+1|0;if((d|0)==(b|0))break c}}else{g=(f[s>>2]=Aa,+n[s>>2]);h=-Ba;d=0;while(1){Aa=d*3|0;wa=+n[Ca+152+(d<<2)>>2];va=+n[Ca>>2];n[Ca+424>>2]=+n[Ca+184+(Aa<<2)>>2]+ +n[za>>2]-va*wa;n[Ca+424+4>>2]=+n[Ca+184+(Aa+1<<2)>>2]+ +n[za+4>>2]-wa*g;n[Ca+424+8>>2]=+n[Ca+184+(Aa+2<<2)>>2]+ +n[za+8>>2]-Ba*wa;Aa=f[(f[c>>2]|0)+16>>2]|0;n[Ca+392>>2]=-va;n[Ca+392+4>>2]=-g;n[Ca+392+8>>2]=h;n[Ca+392+12>>2]=0.0;Wb[Aa&15](c,Ca+392|0,Ca+424|0,-wa);d=d+1|0;if((d|0)==(b|0))break c}}d:do if((b|0)>1){g=+n[Ca+152>>2];d=0;e=1;while(1){h=+n[Ca+152+(e<<2)>>2];a=h>g;d=a?e:d;e=e+1|0;if((e|0)==(b|0))break;else g=a?h:g}switch(b|0){case 1:{e=1;a=Ca+120|0;i=Ca+120|0;xa=120;break d}case 2:{g=(+n[Ca+280+4>>2]+ +n[Ca+280+12>>2])*.5;h=(+n[Ca+280>>2]+ +n[Ca+280+8>>2])*.5;e=2;a=Ca+120|0;i=Ca+120|0;xa=123;break d}default:{}}a=b+-1|0;p=0.0;q=0.0;g=0.0;e=0;do{R=e<<1;ta=+n[Ca+280+(R<<2)>>2];ua=+n[Ca+280+(R+3<<2)>>2];va=+n[Ca+280+(R+2<<2)>>2];wa=+n[Ca+280+((R|1)<<2)>>2];g=g+(ta*ua-va*wa);q=q+(ta+va)*(ta*ua-va*wa);p=p+(ua+wa)*(ta*ua-va*wa);e=e+1|0}while((e|0)!=(a|0));R=b<<1;k=+n[Ca+280+(R+-2<<2)>>2];l=+n[Ca+280+4>>2];m=+n[Ca+280>>2];o=+n[Ca+280+(R+-1<<2)>>2];h=g+(k*l-m*o);R=+K(+h)>1.1920928955078125e-07;h=R?1.0/(h*3.0):999999984306749440.0;if((b|0)>0){g=h*(p+(k*l-m*o)*(o+l));h=(q+(k*l-m*o)*(k+m))*h;a=Ca+120|0;i=Ca+120|0;j=Ca+424|0;xa=126;break}j=d;d=Ca+120|0;e=0}else{d=0;e=b;a=Ca+120|0;i=Ca+120|0;xa=120}while(0);if((xa|0)==120){g=+n[Ca+280+4>>2];h=+n[Ca+280>>2];xa=123}if((xa|0)==123){b=e;j=Ca+424|0;xa=126}if((xa|0)==126){e=0;do{xa=e<<1;wa=+T(+(+n[Ca+280+((xa|1)<<2)>>2]-g),+(+n[Ca+280+(xa<<2)>>2]-h));n[Ca+424+(e<<2)>>2]=wa;e=e+1|0}while((e|0)!=(b|0));e=0;do{f[Ca+392+(e<<2)>>2]=1;e=e+1|0}while((e|0)!=(b|0));j=d;d=a;e=1}a=Ca+392+(j<<2)|0;f[a>>2]=0;f[d>>2]=j;e:do if((A|0)>1){l=+n[Ca+424+(j<<2)>>2];if(e){e=1;a=Ca+120+4|0}else{d=1;e=Ca+120+4|0;while(1){f[e>>2]=j;f[a>>2]=0;d=d+1|0;if((d|0)==(C|0))break e;else e=e+4|0}}while(1){k=6.2831854820251465/+(C|0)*+(e|0)+l;k=k>3.1415927410125732?k+-6.2831854820251465:k;f[a>>2]=j;h=1.0e9;i=0;d=j;while(1){do if(!(f[Ca+392+(i<<2)>>2]|0))g=h;else{g=+K(+(+n[Ca+424+(i<<2)>>2]-k));g=g>3.1415927410125732?6.2831854820251465-g:g;if(!(g<h)){g=h;break}f[a>>2]=i;d=i}while(0);i=i+1|0;if((i|0)==(b|0))break;else h=g}f[Ca+392+(d<<2)>>2]=0;e=e+1|0;if((e|0)==(C|0))break;else a=a+4|0}}while(0);if((C|0)>0){g=(f[s>>2]=Aa,+n[s>>2]);h=-Ba;if(ya){d=0;do{Aa=f[Ca+120+(d<<2)>>2]|0;n[Ca+424>>2]=+n[Ca+184+(Aa*3<<2)>>2]+ +n[za>>2];n[Ca+424+4>>2]=+n[Ca+184+((Aa*3|0)+1<<2)>>2]+ +n[za+4>>2];n[Ca+424+8>>2]=+n[Ca+184+((Aa*3|0)+2<<2)>>2]+ +n[za+8>>2];ya=f[(f[c>>2]|0)+16>>2]|0;n[Ca+392>>2]=-+n[Ca>>2];n[Ca+392+4>>2]=-g;n[Ca+392+8>>2]=h;n[Ca+392+12>>2]=0.0;Wb[ya&15](c,Ca+392|0,Ca+424|0,-+n[Ca+152+(Aa<<2)>>2]);d=d+1|0}while((d|0)<(C|0))}else{d=0;do{ya=f[Ca+120+(d<<2)>>2]|0;sa=+n[Ca+184+(ya*3<<2)>>2]+ +n[za>>2];n[Ca+424>>2]=sa;ua=+n[Ca+184+((ya*3|0)+1<<2)>>2]+ +n[za+4>>2];n[Ca+424+4>>2]=ua;va=+n[Ca+184+((ya*3|0)+2<<2)>>2]+ +n[za+8>>2];n[Ca+424+8>>2]=va;Aa=f[(f[c>>2]|0)+16>>2]|0;ta=+n[Ca>>2];n[Ca+392>>2]=-ta;n[Ca+392+4>>2]=-g;n[Ca+392+8>>2]=h;n[Ca+392+12>>2]=0.0;wa=+n[Ca+152+(ya<<2)>>2];n[Ca+104>>2]=sa-ta*wa;n[Ca+104+4>>2]=ua-wa*g;n[Ca+104+8>>2]=va-wa*Ba;n[Ca+104+12>>2]=0.0;Wb[Aa&15](c,Ca+392|0,Ca+104|0,-wa);d=d+1|0}while((d|0)<(C|0))}}}while(0)}u=Ca;return}function rc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=+e;var g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0,t=0,v=0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0;Q=u;u=u+448|0;if(!(b[a+527>>0]|0)){u=Q;return}P=f[a+28>>2]|0;C=+n[a+348>>2];B=+n[a+352>>2];I=+n[a+356>>2];D=+n[P+52>>2];E=C*+n[P+4>>2]+B*+n[P+8>>2]+I*+n[P+12>>2]+D;F=+n[P+56>>2];G=C*+n[P+20>>2]+B*+n[P+24>>2]+I*+n[P+28>>2]+F;H=+n[P+60>>2];I=C*+n[P+36>>2]+B*+n[P+40>>2]+I*+n[P+44>>2]+H;P=f[a+32>>2]|0;B=+n[a+412>>2];C=+n[a+416>>2];p=+n[a+420>>2];i=+n[P+52>>2];j=B*+n[P+4>>2]+C*+n[P+8>>2]+p*+n[P+12>>2]+i;k=+n[P+56>>2];l=B*+n[P+20>>2]+C*+n[P+24>>2]+p*+n[P+28>>2]+k;o=+n[P+60>>2];p=B*+n[P+36>>2]+C*+n[P+40>>2]+p*+n[P+44>>2]+o;if(!(b[a+524>>0]|0)){A=+n[c+192>>2]+ +n[c+80>>2];B=+n[c+196>>2]+ +n[c+84>>2];z=+n[c+200>>2]+ +n[c+88>>2];C=+n[d+192>>2]+ +n[d+80>>2];y=+n[d+196>>2]+ +n[d+84>>2];w=+n[d+200>>2]+ +n[d+88>>2];q=+n[c+176>>2]+ +n[c+64>>2]+((I-H)*B-(G-F)*z)-(+n[d+176>>2]+ +n[d+64>>2]+((p-o)*y-(l-k)*w));w=+n[c+180>>2]+ +n[c+68>>2]+((E-D)*z-(I-H)*A)-(+n[d+180>>2]+ +n[d+68>>2]+((j-i)*w-(p-o)*C));y=+n[c+184>>2]+ +n[c+72>>2]+((G-F)*A-(E-D)*B)-(+n[d+184>>2]+ +n[d+72>>2]+((l-k)*C-(j-i)*y));r=(f[c+240>>2]|0)==0;m=0;do{C=1.0/+n[a+48+(m*84|0)+80>>2];t=a+48+(m*84|0)|0;B=+n[t>>2];v=a+48+(m*84|0)+4|0;A=+n[v>>2];x=a+48+(m*84|0)+8|0;z=+n[x>>2];z=C*(((E-j)*B+(G-l)*A+(I-p)*z)*-.30000001192092896/e)-C*(q*B+w*A+y*z);n[a+36>>2]=+n[a+36>>2]+z;A=+n[x>>2];B=+n[v>>2];C=+n[t>>2];g=f[a+28>>2]|0;h=+n[g+344>>2];if(!r){T=((G-F)*A-(I-H)*B)*+n[g+296>>2]+((I-H)*C-(E-D)*A)*+n[g+300>>2]+((E-D)*B-(G-F)*C)*+n[g+304>>2];R=((G-F)*A-(I-H)*B)*+n[g+280>>2]+((I-H)*C-(E-D)*A)*+n[g+284>>2]+((E-D)*B-(G-F)*C)*+n[g+288>>2];S=((G-F)*A-(I-H)*B)*+n[g+264>>2]+((I-H)*C-(E-D)*A)*+n[g+268>>2]+((E-D)*B-(G-F)*C)*+n[g+272>>2];V=z*B*h*+n[c+116>>2];U=z*A*h*+n[c+120>>2];n[c+64>>2]=z*C*h*+n[c+112>>2]+ +n[c+64>>2];n[c+68>>2]=V+ +n[c+68>>2];n[c+72>>2]=U+ +n[c+72>>2];R=R*z*+n[c+100>>2];h=T*z*+n[c+104>>2];n[c+80>>2]=S*z*+n[c+96>>2]+ +n[c+80>>2];n[c+84>>2]=R+ +n[c+84>>2];n[c+88>>2]=h+ +n[c+88>>2]}g=f[a+32>>2]|0;h=+n[g+344>>2];if(f[d+240>>2]|0){V=((l-k)*A-(p-o)*B)*+n[g+296>>2]+((p-o)*C-(j-i)*A)*+n[g+300>>2]+((j-i)*B-(l-k)*C)*+n[g+304>>2];U=((l-k)*A-(p-o)*B)*+n[g+280>>2]+((p-o)*C-(j-i)*A)*+n[g+284>>2]+((j-i)*B-(l-k)*C)*+n[g+288>>2];T=((l-k)*A-(p-o)*B)*+n[g+264>>2]+((p-o)*C-(j-i)*A)*+n[g+268>>2]+((j-i)*B-(l-k)*C)*+n[g+272>>2];R=h*+n[v>>2]*-z*+n[d+116>>2];S=h*+n[x>>2]*-z*+n[d+120>>2];n[d+64>>2]=+n[d+112>>2]*h*+n[t>>2]*-z+ +n[d+64>>2];n[d+68>>2]=R+ +n[d+68>>2];n[d+72>>2]=S+ +n[d+72>>2];U=U*+n[d+100>>2]*-z;V=V*+n[d+104>>2]*-z;n[d+80>>2]=T*+n[d+96>>2]*-z+ +n[d+80>>2];n[d+84>>2]=U+ +n[d+84>>2];n[d+88>>2]=V+ +n[d+88>>2]}m=m+1|0}while((m|0)!=3)}do if(!(b[a+552>>0]|0)){h=+n[a+440>>2];if(!(h>1.1920928955078125e-07)){J=c+80|0;m=c+196|0;K=c+84|0;r=c+200|0;M=c+88|0;t=d+192|0;N=d+80|0;v=d+196|0;O=d+84|0;x=d+200|0;P=d+88|0;g=c+192|0;break}i=+n[d+192>>2]+ +n[d+80>>2]-(+n[c+192>>2]+ +n[c+80>>2]);j=+n[d+196>>2]+ +n[d+84>>2]-(+n[c+196>>2]+ +n[c+84>>2]);k=+n[d+200>>2]+ +n[d+88>>2]-(+n[c+200>>2]+ +n[c+88>>2]);if(i*i+j*j+k*k>1.1920928955078125e-07){D=1.0/+L(+(i*i+j*j+k*k));g=f[a+28>>2]|0;o=+n[g+264>>2];p=+n[g+280>>2];q=+n[g+296>>2];w=+n[g+268>>2];y=+n[g+284>>2];z=+n[g+300>>2];A=+n[g+272>>2];B=+n[g+288>>2];C=+n[g+304>>2];g=f[a+32>>2]|0;h=h*(1.0/(i*D*(o*i*D+j*D*p+k*D*q)+j*D*(i*D*w+j*D*y+k*D*z)+k*D*(i*D*A+j*D*B+k*D*C)+(i*D*(i*D*+n[g+264>>2]+j*D*+n[g+280>>2]+k*D*+n[g+296>>2])+j*D*(i*D*+n[g+268>>2]+j*D*+n[g+284>>2]+k*D*+n[g+300>>2])+k*D*(i*D*+n[g+272>>2]+j*D*+n[g+288>>2]+k*D*+n[g+304>>2]))));D=+L(+(k*h*k*h+(i*h*i*h+j*h*j*h)));l=1.0/D*i*h;i=1.0/D*j*h;h=1.0/D*k*h;if(f[c+240>>2]|0){V=D*0.0*+n[c+116>>2];U=D*0.0*+n[c+120>>2];n[c+64>>2]=D*0.0*+n[c+112>>2]+ +n[c+64>>2];n[c+68>>2]=V+ +n[c+68>>2];n[c+72>>2]=U+ +n[c+72>>2];U=(l*p+i*y+h*B)*D*+n[c+100>>2];V=(l*q+i*z+h*C)*D*+n[c+104>>2];n[c+80>>2]=(l*o+i*w+h*A)*D*+n[c+96>>2]+ +n[c+80>>2];n[c+84>>2]=U+ +n[c+84>>2];n[c+88>>2]=V+ +n[c+88>>2];g=f[a+32>>2]|0}if(f[d+240>>2]|0){V=l*+n[g+296>>2]+i*+n[g+300>>2]+h*+n[g+304>>2];U=l*+n[g+280>>2]+i*+n[g+284>>2]+h*+n[g+288>>2];T=l*+n[g+264>>2]+i*+n[g+268>>2]+h*+n[g+272>>2];R=D*-0.0*+n[d+116>>2];S=D*-0.0*+n[d+120>>2];n[d+64>>2]=D*-0.0*+n[d+112>>2]+ +n[d+64>>2];n[d+68>>2]=R+ +n[d+68>>2];n[d+72>>2]=S+ +n[d+72>>2];U=U*+n[d+100>>2]*-D;V=V*+n[d+104>>2]*-D;n[d+80>>2]=T*+n[d+96>>2]*-D+ +n[d+80>>2];n[d+84>>2]=U+ +n[d+84>>2];n[d+88>>2]=V+ +n[d+88>>2];J=c+80|0;m=c+196|0;K=c+84|0;r=c+200|0;M=c+88|0;t=d+192|0;N=d+80|0;v=d+196|0;O=d+84|0;x=d+200|0;P=d+88|0;g=c+192|0}else{J=c+80|0;m=c+196|0;K=c+84|0;r=c+200|0;M=c+88|0;t=d+192|0;N=d+80|0;v=d+196|0;O=d+84|0;x=d+200|0;P=d+88|0;g=c+192|0}}else{J=c+80|0;m=c+196|0;K=c+84|0;r=c+200|0;M=c+88|0;t=d+192|0;N=d+80|0;v=d+196|0;O=d+84|0;x=d+200|0;P=d+88|0;g=c+192|0}}else{O=f[a+28>>2]|0;f[Q+352>>2]=f[O+4>>2];f[Q+352+4>>2]=f[O+4+4>>2];f[Q+352+8>>2]=f[O+4+8>>2];f[Q+352+12>>2]=f[O+4+12>>2];f[Q+352+16>>2]=f[O+20>>2];f[Q+352+16+4>>2]=f[O+20+4>>2];f[Q+352+16+8>>2]=f[O+20+8>>2];f[Q+352+16+12>>2]=f[O+20+12>>2];f[Q+352+32>>2]=f[O+36>>2];f[Q+352+32+4>>2]=f[O+36+4>>2];f[Q+352+32+8>>2]=f[O+36+8>>2];f[Q+352+32+12>>2]=f[O+36+12>>2];f[Q+352+48>>2]=f[O+52>>2];f[Q+352+48+4>>2]=f[O+52+4>>2];f[Q+352+48+8>>2]=f[O+52+8>>2];f[Q+352+48+12>>2]=f[O+52+12>>2];O=f[a+32>>2]|0;f[Q+288>>2]=f[O+4>>2];f[Q+288+4>>2]=f[O+4+4>>2];f[Q+288+8>>2]=f[O+4+8>>2];f[Q+288+12>>2]=f[O+4+12>>2];f[Q+288+16>>2]=f[O+20>>2];f[Q+288+16+4>>2]=f[O+20+4>>2];f[Q+288+16+8>>2]=f[O+20+8>>2];f[Q+288+16+12>>2]=f[O+20+12>>2];f[Q+288+32>>2]=f[O+36>>2];f[Q+288+32+4>>2]=f[O+36+4>>2];f[Q+288+32+8>>2]=f[O+36+8>>2];f[Q+288+32+12>>2]=f[O+36+12>>2];f[Q+288+48>>2]=f[O+52>>2];f[Q+288+48+4>>2]=f[O+52+4>>2];f[Q+288+48+8>>2]=f[O+52+8>>2];f[Q+288+48+12>>2]=f[O+52+12>>2];T=+n[c+196>>2]+ +n[c+84>>2];q=+n[c+200>>2]+ +n[c+88>>2];n[Q+272>>2]=+n[c+192>>2]+ +n[c+80>>2];n[Q+272+4>>2]=T;n[Q+272+8>>2]=q;n[Q+272+12>>2]=0.0;q=+n[d+196>>2]+ +n[d+84>>2];T=+n[d+200>>2]+ +n[d+88>>2];n[Q+256>>2]=+n[d+192>>2]+ +n[d+80>>2];n[Q+256+4>>2]=q;n[Q+256+8>>2]=T;n[Q+256+12>>2]=0.0;f[Q+192>>2]=1065353216;O=Q+192+4|0;f[O>>2]=0;f[O+4>>2]=0;f[O+8>>2]=0;f[O+12>>2]=0;f[Q+192+20>>2]=1065353216;P=Q+192+24|0;f[P>>2]=0;f[P+4>>2]=0;f[P+8>>2]=0;f[P+12>>2]=0;f[Q+192+40>>2]=1065353216;M=Q+192+44|0;f[M>>2]=0;f[M+4>>2]=0;f[M+8>>2]=0;f[M+12>>2]=0;f[M+16>>2]=0;Yg(Q+352|0,0.0,0.0,0.0,Q+272|0,e,Q+192|0);f[Q+128>>2]=1065353216;M=Q+128+4|0;f[M>>2]=0;f[M+4>>2]=0;f[M+8>>2]=0;f[M+12>>2]=0;f[Q+128+20>>2]=1065353216;N=Q+128+24|0;f[N>>2]=0;f[N+4>>2]=0;f[N+8>>2]=0;f[N+12>>2]=0;f[Q+128+40>>2]=1065353216;K=Q+128+44|0;f[K>>2]=0;f[K+4>>2]=0;f[K+8>>2]=0;f[K+12>>2]=0;f[K+16>>2]=0;Yg(Q+288|0,0.0,0.0,0.0,Q+256|0,e,Q+128|0);T=+n[a+556>>2];q=+n[a+560>>2];U=+n[a+564>>2];w=+n[a+568>>2];G=T*(2.0/(T*T+q*q+U*U+w*w));B=q*(2.0/(T*T+q*q+U*U+w*w));H=U*(2.0/(T*T+q*q+U*U+w*w));X=+n[a+364>>2];W=+n[a+368>>2];_=+n[a+372>>2];i=_*(T*H-w*B)+(W*(T*B+w*H)+X*(1.0-(q*B+U*H)));j=_*(q*H+w*G)+(X*(T*B-w*H)+W*(1.0-(T*G+U*H)));k=X*(T*H+w*B)+W*(q*H-w*G)+_*(1.0-(T*G+q*B));h=+n[a+380>>2];F=+n[a+384>>2];C=+n[a+388>>2];l=(T*H-w*B)*C+(F*(T*B+w*H)+h*(1.0-(q*B+U*H)));o=(q*H+w*G)*C+(h*(T*B-w*H)+F*(1.0-(T*G+U*H)));p=h*(T*H+w*B)+F*(q*H-w*G)+C*(1.0-(T*G+q*B));R=+n[a+396>>2];D=+n[a+400>>2];A=+n[a+404>>2];S=(1.0-(q*B+U*H))*R+(T*B+w*H)*D+(T*H-w*B)*A;U=(T*B-w*H)*R+(1.0-(T*G+U*H))*D+(q*H+w*G)*A;B=(T*H+w*B)*R+(q*H-w*G)*D+(1.0-(T*G+q*B))*A;q=+n[a+300>>2];G=+n[a+316>>2];T=+n[a+332>>2];w=+n[a+304>>2];H=+n[a+320>>2];V=+n[a+336>>2];E=+n[a+308>>2];I=+n[a+324>>2];z=+n[a+340>>2];y=-+n[a+348>>2];ba=-+n[a+352>>2];Z=-+n[a+356>>2];_=X*0.0+W*0.0+_*0.0+ +n[a+412>>2]+(k*(E*y+I*ba+z*Z)+(i*(q*y+G*ba+T*Z)+j*(w*y+H*ba+V*Z)));C=h*0.0+F*0.0+C*0.0+ +n[a+416>>2]+(p*(E*y+I*ba+z*Z)+(l*(q*y+G*ba+T*Z)+o*(w*y+H*ba+V*Z)));Z=R*0.0+D*0.0+A*0.0+ +n[a+420>>2]+(B*(E*y+I*ba+z*Z)+(S*(q*y+G*ba+T*Z)+U*(w*y+H*ba+V*Z)));ba=+n[Q+128>>2];y=+n[M>>2];A=+n[Q+128+8>>2];D=+n[Q+128+16>>2];R=+n[Q+128+20>>2];F=+n[N>>2];h=+n[Q+128+32>>2];W=+n[Q+128+36>>2];X=+n[Q+128+40>>2];Y=A*Z+(ba*_+y*C)+ +n[Q+128+48>>2];$=D*_+C*R+Z*F+ +n[Q+128+52>>2];aa=_*h+C*W+Z*X+ +n[Q+128+56>>2];n[Q+64>>2]=(i*q+j*w+k*E)*ba+(l*q+o*w+p*E)*y+(S*q+U*w+B*E)*A;n[Q+64+4>>2]=(i*G+j*H+k*I)*ba+(l*G+o*H+p*I)*y+(S*G+U*H+B*I)*A;n[Q+64+8>>2]=(i*T+j*V+k*z)*ba+(l*T+o*V+p*z)*y+(S*T+U*V+B*z)*A;n[Q+64+12>>2]=0.0;n[Q+64+16>>2]=(i*q+j*w+k*E)*D+(l*q+o*w+p*E)*R+(S*q+U*w+B*E)*F;n[Q+64+20>>2]=(i*G+j*H+k*I)*D+(l*G+o*H+p*I)*R+(S*G+U*H+B*I)*F;n[Q+64+24>>2]=(i*T+j*V+k*z)*D+(l*T+o*V+p*z)*R+(S*T+U*V+B*z)*F;n[Q+64+28>>2]=0.0;n[Q+64+32>>2]=(i*q+j*w+k*E)*h+(l*q+o*w+p*E)*W+(S*q+U*w+B*E)*X;n[Q+64+36>>2]=(i*G+j*H+k*I)*h+(l*G+o*H+p*I)*W+(S*G+U*H+B*I)*X;n[Q+64+40>>2]=(i*T+j*V+k*z)*h+(l*T+o*V+p*z)*W+(S*T+U*V+B*z)*X;n[Q+64+44>>2]=0.0;n[Q+64+48>>2]=Y;n[Q+64+52>>2]=$;n[Q+64+56>>2]=aa;n[Q+64+60>>2]=0.0;aa=(S*q+U*w+B*E)*-Z+((i*q+j*w+k*E)*-_+(l*q+o*w+p*E)*-C);$=(S*G+U*H+B*I)*-Z+((i*G+j*H+k*I)*-_+(l*G+o*H+p*I)*-C);C=(S*T+U*V+B*z)*-Z+((i*T+j*V+k*z)*-_+(l*T+o*V+p*z)*-C);_=+n[Q+192>>2];Z=+n[O>>2];Y=+n[Q+192+8>>2];X=+n[Q+192+16>>2];W=+n[Q+192+20>>2];h=+n[P>>2];F=+n[Q+192+32>>2];R=+n[Q+192+36>>2];D=+n[Q+192+40>>2];A=aa*_+$*Z+C*Y+ +n[Q+192+48>>2];y=aa*X+$*W+C*h+ +n[Q+192+52>>2];C=aa*F+$*R+C*D+ +n[Q+192+56>>2];n[Q>>2]=(i*q+j*w+k*E)*_+(i*G+j*H+k*I)*Z+(i*T+j*V+k*z)*Y;n[Q+4>>2]=(l*q+o*w+p*E)*_+(l*G+o*H+p*I)*Z+(l*T+o*V+p*z)*Y;n[Q+8>>2]=(S*q+U*w+B*E)*_+(S*G+U*H+B*I)*Z+(S*T+U*V+B*z)*Y;n[Q+12>>2]=0.0;n[Q+16>>2]=(i*q+j*w+k*E)*X+(i*G+j*H+k*I)*W+(i*T+j*V+k*z)*h;n[Q+20>>2]=(l*q+o*w+p*E)*X+(l*G+o*H+p*I)*W+(l*T+o*V+p*z)*h;n[Q+24>>2]=(S*q+U*w+B*E)*X+(S*G+U*H+B*I)*W+(S*T+U*V+B*z)*h;n[Q+28>>2]=0.0;n[Q+32>>2]=(i*q+j*w+k*E)*F+(i*G+j*H+k*I)*R+(i*T+j*V+k*z)*D;n[Q+36>>2]=(l*q+o*w+p*E)*F+(l*G+o*H+p*I)*R+(l*T+o*V+p*z)*D;n[Q+40>>2]=(S*q+U*w+B*E)*F+(S*G+U*H+B*I)*R+(S*T+U*V+B*z)*D;n[Q+44>>2]=0.0;n[Q+48>>2]=A;n[Q+52>>2]=y;n[Q+56>>2]=C;n[Q+60>>2]=0.0;Ef(Q+352|0,Q+64|0,Q+424|0,Q+416|0);C=+n[Q+416>>2];y=1.0/e*+n[Q+424>>2]*C;A=1.0/e*C*+n[Q+424+4>>2];C=1.0/e*C*+n[Q+424+8>>2];Ef(Q+288|0,Q,Q+424|0,Q+416|0);D=+n[Q+416>>2];y=y-+n[Q+272>>2];A=A-+n[Q+272+4>>2];C=C-+n[Q+272+8>>2];z=1.0/e*+n[Q+424>>2]*D-+n[Q+256>>2];B=1.0/e*D*+n[Q+424+4>>2]-+n[Q+256+4>>2];D=1.0/e*D*+n[Q+424+8>>2]-+n[Q+256+8>>2];if(y*y+A*A+C*C>1.1920928955078125e-07){q=1.0/+L(+(y*y+A*A+C*C));P=f[a+28>>2]|0;l=y*q*(+n[P+264>>2]*y*q+A*q*+n[P+280>>2]+C*q*+n[P+296>>2])+A*q*(y*q*+n[P+268>>2]+A*q*+n[P+284>>2]+C*q*+n[P+300>>2])+C*q*(y*q*+n[P+272>>2]+A*q*+n[P+288>>2]+C*q*+n[P+304>>2]);i=y*q;k=A*q;q=C*q}else{l=0.0;i=0.0;k=0.0;q=0.0}if(z*z+B*B+D*D>1.1920928955078125e-07){p=1.0/+L(+(z*z+B*B+D*D));P=f[a+32>>2]|0;o=z*p*(+n[P+264>>2]*z*p+B*p*+n[P+280>>2]+D*p*+n[P+296>>2])+B*p*(z*p*+n[P+268>>2]+B*p*+n[P+284>>2]+D*p*+n[P+300>>2])+D*p*(z*p*+n[P+272>>2]+B*p*+n[P+288>>2]+D*p*+n[P+304>>2]);h=z*p;j=B*p;p=D*p}else{o=0.0;h=0.0;j=0.0;p=0.0}w=l*i+o*h;i=l*k+o*j;h=l*q+o*p;if(w*w+i*i+h*h>1.1920928955078125e-07){k=1.0/+L(+(w*w+i*i+h*h));m=f[a+28>>2]|0;j=w*k*(+n[m+264>>2]*w*k+i*k*+n[m+280>>2]+h*k*+n[m+296>>2])+i*k*(w*k*+n[m+268>>2]+i*k*+n[m+284>>2]+h*k*+n[m+300>>2])+h*k*(w*k*+n[m+272>>2]+i*k*+n[m+288>>2]+h*k*+n[m+304>>2]);g=f[a+32>>2]|0;k=w*k*(w*k*+n[g+264>>2]+i*k*+n[g+280>>2]+h*k*+n[g+296>>2])+i*k*(w*k*+n[g+268>>2]+i*k*+n[g+284>>2]+h*k*+n[g+300>>2])+h*k*(w*k*+n[g+272>>2]+i*k*+n[g+288>>2]+h*k*+n[g+304>>2]);w=(y*j-z*k)*(1.0/((j+k)*(j+k)));h=(A*j-B*k)*(1.0/((j+k)*(j+k)));k=(C*j-D*k)*(1.0/((j+k)*(j+k)));i=+n[a+572>>2];if(!(i>=0.0))i=w;else{j=(b[a+553>>0]|0)==0?i:i/j;o=+n[a+576>>2];p=+n[a+580>>2];q=+n[a+584>>2];l=+L(+((w+o)*(w+o)+(h+p)*(h+p)+(k+q)*(k+q)));if(l>j){i=j*(w+o)*(1.0/l)-o;k=j*(k+q)*(1.0/l)-q;h=j*(h+p)*(1.0/l)-p}else i=w;n[a+576>>2]=i+o;n[a+580>>2]=h+p;n[a+584>>2]=k+q}l=+L(+(i*i+h*h+k*k));j=i*(1.0/l);i=h*(1.0/l);h=k*(1.0/l);if(f[c+240>>2]|0){ba=j*+n[m+296>>2]+i*+n[m+300>>2]+h*+n[m+304>>2];aa=j*+n[m+280>>2]+i*+n[m+284>>2]+h*+n[m+288>>2];$=j*+n[m+264>>2]+i*+n[m+268>>2]+h*+n[m+272>>2];Z=l*0.0*+n[c+116>>2];_=l*0.0*+n[c+120>>2];n[c+64>>2]=l*0.0*+n[c+112>>2]+ +n[c+64>>2];n[c+68>>2]=Z+ +n[c+68>>2];n[c+72>>2]=_+ +n[c+72>>2];aa=aa*l*+n[c+100>>2];ba=ba*l*+n[c+104>>2];n[c+80>>2]=$*l*+n[c+96>>2]+ +n[c+80>>2];n[c+84>>2]=aa+ +n[c+84>>2];n[c+88>>2]=ba+ +n[c+88>>2];g=f[a+32>>2]|0}if(f[d+240>>2]|0){ba=j*+n[g+296>>2]+i*+n[g+300>>2]+h*+n[g+304>>2];aa=j*+n[g+280>>2]+i*+n[g+284>>2]+h*+n[g+288>>2];$=j*+n[g+264>>2]+i*+n[g+268>>2]+h*+n[g+272>>2];Z=l*-0.0*+n[d+116>>2];_=l*-0.0*+n[d+120>>2];n[d+64>>2]=l*-0.0*+n[d+112>>2]+ +n[d+64>>2];n[d+68>>2]=Z+ +n[d+68>>2];n[d+72>>2]=_+ +n[d+72>>2];aa=aa*+n[d+100>>2]*-l;ba=ba*+n[d+104>>2]*-l;n[d+80>>2]=$*+n[d+96>>2]*-l+ +n[d+80>>2];n[d+84>>2]=aa+ +n[d+84>>2];n[d+88>>2]=ba+ +n[d+88>>2]}}J=c+80|0;m=c+196|0;K=c+84|0;r=c+200|0;M=c+88|0;t=d+192|0;N=d+80|0;v=d+196|0;O=d+84|0;x=d+200|0;P=d+88|0;g=c+192|0}while(0);z=+n[g>>2]+ +n[J>>2];y=+n[m>>2]+ +n[K>>2];w=+n[r>>2]+ +n[M>>2];q=+n[t>>2]+ +n[N>>2];p=+n[v>>2]+ +n[O>>2];o=+n[x>>2]+ +n[P>>2];if(b[a+526>>0]|0){i=+n[a+528>>2];h=i*+n[a+504>>2]*+n[a+432>>2]/e;j=+n[a+460>>2];k=+n[a+464>>2];l=+n[a+468>>2];if((q-z)*j+(p-y)*k+(o-w)*l>0.0)h=h+i*((q-z)*j+(p-y)*k+(o-w)*l)*+n[a+436>>2];aa=+n[a+516>>2];_=aa+h*+n[a+492>>2];n[Q+424>>2]=_;n[Q+416>>2]=0.0;g=f[(_>0.0?Q+424|0:Q+416|0)>>2]|0;f[a+516>>2]=g;aa=(f[s>>2]=g,+n[s>>2])-aa;_=+n[a+536>>2];$=+n[a+540>>2];h=+n[a+544>>2];i=aa*j-_*(aa*j*_+aa*k*$+aa*l*h);ba=aa*k-$*(aa*j*_+aa*k*$+aa*l*h);k=aa*l-h*(aa*j*_+aa*k*$+aa*l*h);h=+L(+(k*k+(i*i+ba*ba)));i=1.0/h*i;j=1.0/h*ba;k=1.0/h*k;g=f[a+28>>2]|0;if(f[c+240>>2]|0){ba=i*+n[g+296>>2]+j*+n[g+300>>2]+k*+n[g+304>>2];aa=i*+n[g+280>>2]+j*+n[g+284>>2]+k*+n[g+288>>2];$=i*+n[g+264>>2]+j*+n[g+268>>2]+k*+n[g+272>>2];Z=h*0.0*+n[c+116>>2];_=h*0.0*+n[c+120>>2];n[c+64>>2]=h*0.0*+n[c+112>>2]+ +n[c+64>>2];n[c+68>>2]=Z+ +n[c+68>>2];n[c+72>>2]=_+ +n[c+72>>2];aa=aa*h*+n[c+100>>2];ba=ba*h*+n[c+104>>2];n[J>>2]=$*h*+n[c+96>>2]+ +n[J>>2];n[K>>2]=aa+ +n[K>>2];n[M>>2]=ba+ +n[M>>2]}g=f[a+32>>2]|0;if(f[d+240>>2]|0){ba=i*+n[g+296>>2]+j*+n[g+300>>2]+k*+n[g+304>>2];aa=i*+n[g+280>>2]+j*+n[g+284>>2]+k*+n[g+288>>2];$=i*+n[g+264>>2]+j*+n[g+268>>2]+k*+n[g+272>>2];Z=h*-0.0*+n[d+116>>2];_=h*-0.0*+n[d+120>>2];n[d+64>>2]=h*-0.0*+n[d+112>>2]+ +n[d+64>>2];n[d+68>>2]=Z+ +n[d+68>>2];n[d+72>>2]=_+ +n[d+72>>2];aa=aa*+n[d+100>>2]*-h;ba=ba*+n[d+104>>2]*-h;n[N>>2]=$*+n[d+96>>2]*-h+ +n[N>>2];n[O>>2]=aa+ +n[O>>2];n[P>>2]=ba+ +n[P>>2]}}if(!(b[a+525>>0]|0)){u=Q;return}l=+n[a+532>>2];k=l*+n[a+508>>2]*+n[a+432>>2]/e;j=+n[a+476>>2];i=+n[a+480>>2];h=+n[a+484>>2];if((q-z)*j+(p-y)*i+(o-w)*h>0.0)k=k+l*((q-z)*j+(p-y)*i+(o-w)*h)*+n[a+436>>2];ba=+n[a+520>>2];k=ba+k*+n[a+496>>2];n[Q+424>>2]=k;n[Q+416>>2]=0.0;g=f[(k>0.0?Q+424|0:Q+416|0)>>2]|0;f[a+520>>2]=g;k=(f[s>>2]=g,+n[s>>2])-ba;g=f[a+28>>2]|0;if(f[c+240>>2]|0){ba=j*+n[g+296>>2]+i*+n[g+300>>2]+h*+n[g+304>>2];aa=j*+n[g+280>>2]+i*+n[g+284>>2]+h*+n[g+288>>2];h=j*+n[g+264>>2]+i*+n[g+268>>2]+h*+n[g+272>>2];j=k*0.0*+n[c+116>>2];i=k*0.0*+n[c+120>>2];n[c+64>>2]=k*0.0*+n[c+112>>2]+ +n[c+64>>2];n[c+68>>2]=j+ +n[c+68>>2];n[c+72>>2]=i+ +n[c+72>>2];i=aa*k*+n[c+100>>2];j=ba*k*+n[c+104>>2];n[J>>2]=h*k*+n[c+96>>2]+ +n[J>>2];n[K>>2]=i+ +n[K>>2];n[M>>2]=j+ +n[M>>2];j=+n[a+476>>2];i=+n[a+480>>2];h=+n[a+484>>2]}g=f[a+32>>2]|0;if(!(f[d+240>>2]|0)){u=Q;return}ba=j*+n[g+296>>2]+i*+n[g+300>>2]+h*+n[g+304>>2];aa=j*+n[g+280>>2]+i*+n[g+284>>2]+h*+n[g+288>>2];$=j*+n[g+264>>2]+i*+n[g+268>>2]+h*+n[g+272>>2];Z=k*-0.0*+n[d+116>>2];_=k*-0.0*+n[d+120>>2];n[d+64>>2]=k*-0.0*+n[d+112>>2]+ +n[d+64>>2];n[d+68>>2]=Z+ +n[d+68>>2];n[d+72>>2]=_+ +n[d+72>>2];aa=aa*+n[d+100>>2]*-k;ba=ba*+n[d+104>>2]*-k;n[N>>2]=$*+n[d+96>>2]*-k+ +n[N>>2];n[O>>2]=aa+ +n[O>>2];n[P>>2]=ba+ +n[P>>2];u=Q;return}function sc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;w=u;u=u+16|0;do if(a>>>0<245){n=a>>>0<11?16:a+11&-8;l=f[6474]|0;if(l>>>(n>>>3)&3|0){a=25936+((l>>>(n>>>3)&1^1)+(n>>>3)<<1<<2)|0;b=f[a+8>>2]|0;c=f[b+8>>2]|0;if((c|0)==(a|0))f[6474]=l&~(1<<(l>>>(n>>>3)&1^1)+(n>>>3));else{f[c+12>>2]=a;f[a+8>>2]=c}v=(l>>>(n>>>3)&1^1)+(n>>>3)<<3;f[b+4>>2]=v|3;f[b+v+4>>2]=f[b+v+4>>2]|1;v=b+8|0;u=w;return v|0}m=f[6476]|0;if(n>>>0>m>>>0){if(l>>>(n>>>3)|0){a=l>>>(n>>>3)<<(n>>>3)&(2<<(n>>>3)|0-(2<<(n>>>3)));e=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);d=e>>>(e>>>5&8)>>>(e>>>(e>>>5&8)>>>2&4);d=(e>>>5&8|((a&0-a)+-1|0)>>>12&16|e>>>(e>>>5&8)>>>2&4|d>>>1&2|d>>>(d>>>1&2)>>>1&1)+(d>>>(d>>>1&2)>>>(d>>>(d>>>1&2)>>>1&1))|0;e=f[25936+(d<<1<<2)+8>>2]|0;a=f[e+8>>2]|0;if((a|0)==(25936+(d<<1<<2)|0)){f[6474]=l&~(1<<d);a=l&~(1<<d)}else{f[a+12>>2]=25936+(d<<1<<2);f[25936+(d<<1<<2)+8>>2]=a;a=l}f[e+4>>2]=n|3;f[e+n+4>>2]=(d<<3)-n|1;f[e+(d<<3)>>2]=(d<<3)-n;if(m|0){c=f[6479]|0;if(!(a&1<<(m>>>3))){f[6474]=a|1<<(m>>>3);a=25936+(m>>>3<<1<<2)|0;b=25936+(m>>>3<<1<<2)+8|0}else{a=f[25936+(m>>>3<<1<<2)+8>>2]|0;b=25936+(m>>>3<<1<<2)+8|0}f[b>>2]=c;f[a+12>>2]=c;f[c+8>>2]=a;f[c+12>>2]=25936+(m>>>3<<1<<2)}f[6476]=(d<<3)-n;f[6479]=e+n;v=e+8|0;u=w;return v|0}k=f[6475]|0;if(k){b=((k&0-k)+-1|0)>>>(((k&0-k)+-1|0)>>>12&16);a=b>>>(b>>>5&8)>>>(b>>>(b>>>5&8)>>>2&4);a=f[26200+((b>>>5&8|((k&0-k)+-1|0)>>>12&16|b>>>(b>>>5&8)>>>2&4|a>>>1&2|a>>>(a>>>1&2)>>>1&1)+(a>>>(a>>>1&2)>>>(a>>>(a>>>1&2)>>>1&1))<<2)>>2]|0;b=(f[a+4>>2]&-8)-n|0;c=f[a+16+(((f[a+16>>2]|0)==0&1)<<2)>>2]|0;if(!c){j=a;h=b}else{do{i=(f[c+4>>2]&-8)-n|0;j=i>>>0<b>>>0;b=j?i:b;a=j?c:a;c=f[c+16+(((f[c+16>>2]|0)==0&1)<<2)>>2]|0}while((c|0)!=0);j=a;h=b}i=j+n|0;if(i>>>0>j>>>0){e=f[j+24>>2]|0;a=f[j+12>>2]|0;do if((a|0)==(j|0)){b=j+20|0;a=f[b>>2]|0;if(!a){b=j+16|0;a=f[b>>2]|0;if(!a){b=0;break}}while(1){c=a+20|0;d=f[c>>2]|0;if(d|0){a=d;b=c;continue}c=a+16|0;d=f[c>>2]|0;if(!d)break;else{a=d;b=c}}f[b>>2]=0;b=a}else{b=f[j+8>>2]|0;f[b+12>>2]=a;f[a+8>>2]=b;b=a}while(0);do if(e|0){a=f[j+28>>2]|0;if((j|0)==(f[26200+(a<<2)>>2]|0)){f[26200+(a<<2)>>2]=b;if(!b){f[6475]=k&~(1<<a);break}}else{f[e+16+(((f[e+16>>2]|0)!=(j|0)&1)<<2)>>2]=b;if(!b)break}f[b+24>>2]=e;a=f[j+16>>2]|0;if(a|0){f[b+16>>2]=a;f[a+24>>2]=b}a=f[j+20>>2]|0;if(a|0){f[b+20>>2]=a;f[a+24>>2]=b}}while(0);if(h>>>0<16){v=h+n|0;f[j+4>>2]=v|3;v=j+v+4|0;f[v>>2]=f[v>>2]|1}else{f[j+4>>2]=n|3;f[i+4>>2]=h|1;f[i+h>>2]=h;if(m|0){c=f[6479]|0;if(!(l&1<<(m>>>3))){f[6474]=l|1<<(m>>>3);a=25936+(m>>>3<<1<<2)|0;b=25936+(m>>>3<<1<<2)+8|0}else{a=f[25936+(m>>>3<<1<<2)+8>>2]|0;b=25936+(m>>>3<<1<<2)+8|0}f[b>>2]=c;f[a+12>>2]=c;f[c+8>>2]=a;f[c+12>>2]=25936+(m>>>3<<1<<2)}f[6476]=h;f[6479]=i}v=j+8|0;u=w;return v|0}}}}else if(a>>>0<=4294967231){n=a+11&-8;j=f[6475]|0;if(j){if((a+11|0)>>>8)if(n>>>0>16777215)i=31;else{i=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);i=14-((i+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((i<<((i+520192|0)>>>16&4))+245760|0)>>>16&2)+(i<<((i+520192|0)>>>16&4)<<(((i<<((i+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;i=n>>>(i+7|0)&1|i<<1}else i=0;a=f[26200+(i<<2)>>2]|0;a:do if(!a){b=0;a=0;c=0-n|0;t=57}else{e=0;c=0-n|0;h=n<<((i|0)==31?0:25-(i>>>1)|0);b=0;while(1){d=(f[a+4>>2]&-8)-n|0;if(d>>>0<c>>>0)if(!d){c=0;b=a;t=61;break a}else{e=a;c=d}d=f[a+20>>2]|0;a=f[a+16+(h>>>31<<2)>>2]|0;b=(d|0)==0|(d|0)==(a|0)?b:d;d=(a|0)==0;if(d){a=e;t=57;break}else h=h<<((d^1)&1)}}while(0);if((t|0)==57){if((b|0)==0&(a|0)==0){a=2<<i;if(!(j&(a|0-a)))break;l=(j&(a|0-a)&0-(j&(a|0-a)))+-1|0;m=l>>>(l>>>12&16)>>>(l>>>(l>>>12&16)>>>5&8);b=m>>>(m>>>2&4)>>>(m>>>(m>>>2&4)>>>1&2);a=0;b=f[26200+((l>>>(l>>>12&16)>>>5&8|l>>>12&16|m>>>2&4|m>>>(m>>>2&4)>>>1&2|b>>>1&1)+(b>>>(b>>>1&1))<<2)>>2]|0}if(!b){i=a;h=c}else t=61}if((t|0)==61)while(1){t=0;l=(f[b+4>>2]&-8)-n|0;m=l>>>0<c>>>0;c=m?l:c;a=m?b:a;b=f[b+16+(((f[b+16>>2]|0)==0&1)<<2)>>2]|0;if(!b){i=a;h=c;break}else t=61}if((i|0)!=0?h>>>0<((f[6476]|0)-n|0)>>>0:0){g=i+n|0;if(g>>>0<=i>>>0){v=0;u=w;return v|0}e=f[i+24>>2]|0;a=f[i+12>>2]|0;do if((a|0)==(i|0)){b=i+20|0;a=f[b>>2]|0;if(!a){b=i+16|0;a=f[b>>2]|0;if(!a){a=0;break}}while(1){c=a+20|0;d=f[c>>2]|0;if(d|0){a=d;b=c;continue}c=a+16|0;d=f[c>>2]|0;if(!d)break;else{a=d;b=c}}f[b>>2]=0}else{v=f[i+8>>2]|0;f[v+12>>2]=a;f[a+8>>2]=v}while(0);do if(e){b=f[i+28>>2]|0;if((i|0)==(f[26200+(b<<2)>>2]|0)){f[26200+(b<<2)>>2]=a;if(!a){f[6475]=j&~(1<<b);d=j&~(1<<b);break}}else{f[e+16+(((f[e+16>>2]|0)!=(i|0)&1)<<2)>>2]=a;if(!a){d=j;break}}f[a+24>>2]=e;b=f[i+16>>2]|0;if(b|0){f[a+16>>2]=b;f[b+24>>2]=a}b=f[i+20>>2]|0;if(b){f[a+20>>2]=b;f[b+24>>2]=a;d=j}else d=j}else d=j;while(0);do if(h>>>0>=16){f[i+4>>2]=n|3;f[g+4>>2]=h|1;f[g+h>>2]=h;c=h>>>3;if(h>>>0<256){a=f[6474]|0;if(!(a&1<<c)){f[6474]=a|1<<c;a=25936+(c<<1<<2)|0;b=25936+(c<<1<<2)+8|0}else{a=f[25936+(c<<1<<2)+8>>2]|0;b=25936+(c<<1<<2)+8|0}f[b>>2]=g;f[a+12>>2]=g;f[g+8>>2]=a;f[g+12>>2]=25936+(c<<1<<2);break}a=h>>>8;if(a)if(h>>>0>16777215)a=31;else{v=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);a=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(v+245760|0)>>>16&2)+(v<<((v+245760|0)>>>16&2)>>>15)|0;a=h>>>(a+7|0)&1|a<<1}else a=0;c=26200+(a<<2)|0;f[g+28>>2]=a;f[g+16+4>>2]=0;f[g+16>>2]=0;b=1<<a;if(!(d&b)){f[6475]=d|b;f[c>>2]=g;f[g+24>>2]=c;f[g+12>>2]=g;f[g+8>>2]=g;break}b=h<<((a|0)==31?0:25-(a>>>1)|0);c=f[c>>2]|0;while(1){if((f[c+4>>2]&-8|0)==(h|0)){t=97;break}d=c+16+(b>>>31<<2)|0;a=f[d>>2]|0;if(!a){t=96;break}else{b=b<<1;c=a}}if((t|0)==96){f[d>>2]=g;f[g+24>>2]=c;f[g+12>>2]=g;f[g+8>>2]=g;break}else if((t|0)==97){t=c+8|0;v=f[t>>2]|0;f[v+12>>2]=g;f[t>>2]=g;f[g+8>>2]=v;f[g+12>>2]=c;f[g+24>>2]=0;break}}else{v=h+n|0;f[i+4>>2]=v|3;v=i+v+4|0;f[v>>2]=f[v>>2]|1}while(0);v=i+8|0;u=w;return v|0}}}else n=-1;while(0);c=f[6476]|0;if(c>>>0>=n>>>0){a=c-n|0;b=f[6479]|0;if(a>>>0>15){v=b+n|0;f[6479]=v;f[6476]=a;f[v+4>>2]=a|1;f[b+c>>2]=a;f[b+4>>2]=n|3}else{f[6476]=0;f[6479]=0;f[b+4>>2]=c|3;f[b+c+4>>2]=f[b+c+4>>2]|1}v=b+8|0;u=w;return v|0}e=f[6477]|0;if(e>>>0>n>>>0){s=e-n|0;f[6477]=s;v=f[6480]|0;t=v+n|0;f[6480]=t;f[t+4>>2]=s|1;f[v+4>>2]=n|3;v=v+8|0;u=w;return v|0}if(!(f[6592]|0)){f[6594]=4096;f[6593]=4096;f[6595]=-1;f[6596]=-1;f[6597]=0;f[6585]=0;f[6592]=w&-16^1431655768;a=4096}else a=f[6594]|0;h=n+48|0;i=n+47|0;k=a+i|0;j=0-a|0;if((k&j)>>>0<=n>>>0){v=0;u=w;return v|0}a=f[6584]|0;if(a|0?(m=f[6582]|0,(m+(k&j)|0)>>>0<=m>>>0?1:(m+(k&j)|0)>>>0>a>>>0):0){v=0;u=w;return v|0}b:do if(!(f[6585]&4)){c=f[6480]|0;c:do if(c){b=26344;while(1){a=f[b>>2]|0;if(a>>>0<=c>>>0?(o=b+4|0,(a+(f[o>>2]|0)|0)>>>0>c>>>0):0)break;a=f[b+8>>2]|0;if(!a){t=118;break c}else b=a}if((k-e&j)>>>0<2147483647){a=Wo(k-e&j|0)|0;if((a|0)==((f[b>>2]|0)+(f[o>>2]|0)|0))if((a|0)==(-1|0))a=k-e&j;else{h=k-e&j;g=a;t=135;break b}else{d=a;c=k-e&j;t=126}}else a=0}else t=118;while(0);do if((t|0)==118){b=Wo(0)|0;if((b|0)!=(-1|0)?(q=f[6593]|0,q=((q+-1&b|0)==0?0:(q+-1+b&0-q)-b|0)+(k&j)|0,p=f[6582]|0,q>>>0>n>>>0&q>>>0<2147483647):0){o=f[6584]|0;if(o|0?(q+p|0)>>>0<=p>>>0|(q+p|0)>>>0>o>>>0:0){a=0;break}a=Wo(q|0)|0;if((a|0)==(b|0)){h=q;g=b;t=135;break b}else{d=a;c=q;t=126}}else a=0}while(0);do if((t|0)==126){b=0-c|0;if(!(h>>>0>c>>>0&(c>>>0<2147483647&(d|0)!=(-1|0))))if((d|0)==(-1|0)){a=0;break}else{h=c;g=d;t=135;break b}a=f[6594]|0;a=i-c+a&0-a;if(a>>>0>=2147483647){h=c;g=d;t=135;break b}if((Wo(a|0)|0)==(-1|0)){Wo(b|0)|0;a=0;break}else{h=a+c|0;g=d;t=135;break b}}while(0);f[6585]=f[6585]|4;t=133}else{a=0;t=133}while(0);if(((t|0)==133?(k&j)>>>0<2147483647:0)?(g=Wo(k&j|0)|0,r=Wo(0)|0,s=(r-g|0)>>>0>(n+40|0)>>>0,!((g|0)==(-1|0)|s^1|g>>>0<r>>>0&((g|0)!=(-1|0)&(r|0)!=(-1|0))^1)):0){h=s?r-g|0:a;t=135}if((t|0)==135){a=(f[6582]|0)+h|0;f[6582]=a;if(a>>>0>(f[6583]|0)>>>0)f[6583]=a;j=f[6480]|0;do if(j){a=26344;while(1){b=f[a>>2]|0;c=a+4|0;d=f[c>>2]|0;if((g|0)==(b+d|0)){t=143;break}e=f[a+8>>2]|0;if(!e)break;else a=e}if(((t|0)==143?(f[a+12>>2]&8|0)==0:0)?g>>>0>j>>>0&b>>>0<=j>>>0:0){f[c>>2]=d+h;v=(f[6477]|0)+h|0;t=(j+8&7|0)==0?0:0-(j+8)&7;f[6480]=j+t;f[6477]=v-t;f[j+t+4>>2]=v-t|1;f[j+v+4>>2]=40;f[6481]=f[6596];break}if(g>>>0<(f[6478]|0)>>>0)f[6478]=g;b=g+h|0;a=26344;while(1){if((f[a>>2]|0)==(b|0)){t=151;break}a=f[a+8>>2]|0;if(!a){b=26344;break}}if((t|0)==151)if(!(f[a+12>>2]&8)){f[a>>2]=g;l=a+4|0;f[l>>2]=(f[l>>2]|0)+h;l=g+8|0;l=g+((l&7|0)==0?0:0-l&7)|0;a=b+((b+8&7|0)==0?0:0-(b+8)&7)|0;k=l+n|0;i=a-l-n|0;f[l+4>>2]=n|3;do if((j|0)!=(a|0)){if((f[6479]|0)==(a|0)){v=(f[6476]|0)+i|0;f[6476]=v;f[6479]=k;f[k+4>>2]=v|1;f[k+v>>2]=v;break}h=f[a+4>>2]|0;if((h&3|0)==1){d:do if(h>>>0<256){b=f[a+8>>2]|0;c=f[a+12>>2]|0;if((c|0)==(b|0)){f[6474]=f[6474]&~(1<<(h>>>3));break}else{f[b+12>>2]=c;f[c+8>>2]=b;break}}else{g=f[a+24>>2]|0;b=f[a+12>>2]|0;do if((b|0)==(a|0)){b=f[a+16+4>>2]|0;if(!b){b=f[a+16>>2]|0;if(!b){b=0;break}else e=a+16|0}else e=a+16+4|0;while(1){c=b+20|0;d=f[c>>2]|0;if(d|0){b=d;e=c;continue}c=b+16|0;d=f[c>>2]|0;if(!d)break;else{b=d;e=c}}f[e>>2]=0}else{v=f[a+8>>2]|0;f[v+12>>2]=b;f[b+8>>2]=v}while(0);if(!g)break;c=f[a+28>>2]|0;do if((f[26200+(c<<2)>>2]|0)!=(a|0)){f[g+16+(((f[g+16>>2]|0)!=(a|0)&1)<<2)>>2]=b;if(!b)break d}else{f[26200+(c<<2)>>2]=b;if(b|0)break;f[6475]=f[6475]&~(1<<c);break d}while(0);f[b+24>>2]=g;c=f[a+16>>2]|0;if(c|0){f[b+16>>2]=c;f[c+24>>2]=b}c=f[a+16+4>>2]|0;if(!c)break;f[b+20>>2]=c;f[c+24>>2]=b}while(0);a=a+(h&-8)|0;e=(h&-8)+i|0}else e=i;c=a+4|0;f[c>>2]=f[c>>2]&-2;f[k+4>>2]=e|1;f[k+e>>2]=e;c=e>>>3;if(e>>>0<256){a=f[6474]|0;if(!(a&1<<c)){f[6474]=a|1<<c;a=25936+(c<<1<<2)|0;b=25936+(c<<1<<2)+8|0}else{a=f[25936+(c<<1<<2)+8>>2]|0;b=25936+(c<<1<<2)+8|0}f[b>>2]=k;f[a+12>>2]=k;f[k+8>>2]=a;f[k+12>>2]=25936+(c<<1<<2);break}a=e>>>8;do if(!a)a=0;else{if(e>>>0>16777215){a=31;break}v=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);a=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(v+245760|0)>>>16&2)+(v<<((v+245760|0)>>>16&2)>>>15)|0;a=e>>>(a+7|0)&1|a<<1}while(0);d=26200+(a<<2)|0;f[k+28>>2]=a;f[k+16+4>>2]=0;f[k+16>>2]=0;b=f[6475]|0;c=1<<a;if(!(b&c)){f[6475]=b|c;f[d>>2]=k;f[k+24>>2]=d;f[k+12>>2]=k;f[k+8>>2]=k;break}b=e<<((a|0)==31?0:25-(a>>>1)|0);c=f[d>>2]|0;while(1){if((f[c+4>>2]&-8|0)==(e|0)){t=192;break}d=c+16+(b>>>31<<2)|0;a=f[d>>2]|0;if(!a){t=191;break}else{b=b<<1;c=a}}if((t|0)==191){f[d>>2]=k;f[k+24>>2]=c;f[k+12>>2]=k;f[k+8>>2]=k;break}else if((t|0)==192){t=c+8|0;v=f[t>>2]|0;f[v+12>>2]=k;f[t>>2]=k;f[k+8>>2]=v;f[k+12>>2]=c;f[k+24>>2]=0;break}}else{v=(f[6477]|0)+i|0;f[6477]=v;f[6480]=k;f[k+4>>2]=v|1}while(0);v=l+8|0;u=w;return v|0}else b=26344;while(1){a=f[b>>2]|0;if(a>>>0<=j>>>0?(v=a+(f[b+4>>2]|0)|0,v>>>0>j>>>0):0)break;b=f[b+8>>2]|0}e=v+-47+((v+-47+8&7|0)==0?0:0-(v+-47+8)&7)|0;e=e>>>0<(j+16|0)>>>0?j:e;a=h+-40|0;s=g+8|0;s=(s&7|0)==0?0:0-s&7;t=g+s|0;f[6480]=t;f[6477]=a-s;f[t+4>>2]=a-s|1;f[g+a+4>>2]=40;f[6481]=f[6596];f[e+4>>2]=27;f[e+8>>2]=f[6586];f[e+8+4>>2]=f[6587];f[e+8+8>>2]=f[6588];f[e+8+12>>2]=f[6589];f[6586]=g;f[6587]=h;f[6589]=0;f[6588]=e+8;a=e+24|0;do{t=a;a=a+4|0;f[a>>2]=7}while((t+8|0)>>>0<v>>>0);if((e|0)!=(j|0)){f[e+4>>2]=f[e+4>>2]&-2;f[j+4>>2]=e-j|1;f[e>>2]=e-j;if((e-j|0)>>>0<256){c=25936+((e-j|0)>>>3<<1<<2)|0;a=f[6474]|0;if(!(a&1<<((e-j|0)>>>3))){f[6474]=a|1<<((e-j|0)>>>3);a=c;b=c+8|0}else{a=f[c+8>>2]|0;b=c+8|0}f[b>>2]=j;f[a+12>>2]=j;f[j+8>>2]=a;f[j+12>>2]=c;break}if((e-j|0)>>>8)if((e-j|0)>>>0>16777215)a=31;else{a=(e-j|0)>>>8<<((((e-j|0)>>>8)+1048320|0)>>>16&8);a=14-((a+520192|0)>>>16&4|(((e-j|0)>>>8)+1048320|0)>>>16&8|((a<<((a+520192|0)>>>16&4))+245760|0)>>>16&2)+(a<<((a+520192|0)>>>16&4)<<(((a<<((a+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;a=(e-j|0)>>>(a+7|0)&1|a<<1}else a=0;d=26200+(a<<2)|0;f[j+28>>2]=a;f[j+20>>2]=0;f[j+16>>2]=0;b=f[6475]|0;c=1<<a;if(!(b&c)){f[6475]=b|c;f[d>>2]=j;f[j+24>>2]=d;f[j+12>>2]=j;f[j+8>>2]=j;break}b=e-j<<((a|0)==31?0:25-(a>>>1)|0);c=f[d>>2]|0;while(1){if((f[c+4>>2]&-8|0)==(e-j|0)){t=213;break}d=c+16+(b>>>31<<2)|0;a=f[d>>2]|0;if(!a){t=212;break}else{b=b<<1;c=a}}if((t|0)==212){f[d>>2]=j;f[j+24>>2]=c;f[j+12>>2]=j;f[j+8>>2]=j;break}else if((t|0)==213){t=c+8|0;v=f[t>>2]|0;f[v+12>>2]=j;f[t>>2]=j;f[j+8>>2]=v;f[j+12>>2]=c;f[j+24>>2]=0;break}}}else{v=f[6478]|0;if((v|0)==0|g>>>0<v>>>0)f[6478]=g;f[6586]=g;f[6587]=h;f[6589]=0;f[6483]=f[6592];f[6482]=-1;f[6487]=25936;f[6486]=25936;f[6489]=25944;f[6488]=25944;f[6491]=25952;f[6490]=25952;f[6493]=25960;f[6492]=25960;f[6495]=25968;f[6494]=25968;f[6497]=25976;f[6496]=25976;f[6499]=25984;f[6498]=25984;f[6501]=25992;f[6500]=25992;f[6503]=26e3;f[6502]=26e3;f[6505]=26008;f[6504]=26008;f[6507]=26016;f[6506]=26016;f[6509]=26024;f[6508]=26024;f[6511]=26032;f[6510]=26032;f[6513]=26040;f[6512]=26040;f[6515]=26048;f[6514]=26048;f[6517]=26056;f[6516]=26056;f[6519]=26064;f[6518]=26064;f[6521]=26072;f[6520]=26072;f[6523]=26080;f[6522]=26080;f[6525]=26088;f[6524]=26088;f[6527]=26096;f[6526]=26096;f[6529]=26104;f[6528]=26104;f[6531]=26112;f[6530]=26112;f[6533]=26120;f[6532]=26120;f[6535]=26128;f[6534]=26128;f[6537]=26136;f[6536]=26136;f[6539]=26144;f[6538]=26144;f[6541]=26152;f[6540]=26152;f[6543]=26160;f[6542]=26160;f[6545]=26168;f[6544]=26168;f[6547]=26176;f[6546]=26176;f[6549]=26184;f[6548]=26184;v=h+-40|0;s=g+8|0;s=(s&7|0)==0?0:0-s&7;t=g+s|0;f[6480]=t;f[6477]=v-s;f[t+4>>2]=v-s|1;f[g+v+4>>2]=40;f[6481]=f[6596]}while(0);a=f[6477]|0;if(a>>>0>n>>>0){s=a-n|0;f[6477]=s;v=f[6480]|0;t=v+n|0;f[6480]=t;f[t+4>>2]=s|1;f[v+4>>2]=n|3;v=v+8|0;u=w;return v|0}}f[6614]=12;v=0;u=w;return v|0}function tc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0;U=f[d>>2]|0;fa=f[e>>2]|0;if(U|0)g=f[U+12>>2]|0;else g=b;h=f[g+88>>2]|0;i=f[g+92>>2]|0;j=f[g+96>>2]|0;if(!fa)g=c;else g=f[fa+12>>2]|0;r=f[g+88>>2]|0;p=f[g+92>>2]|0;q=f[g+96>>2]|0;Z=f[b+88>>2]|0;da=(f[c+88>>2]|0)-Z|0;u=f[b+92>>2]|0;ea=(f[c+92>>2]|0)-u|0;l=f[b+96>>2]|0;V=(f[c+96>>2]|0)-l|0;Y=f[(U|0?U:fa)+12>>2]|0;_=(f[Y+88>>2]|0)-Z|0;T=(f[Y+92>>2]|0)-u|0;Y=(f[Y+96>>2]|0)-l|0;W=(X(T,V)|0)-(X(Y,ea)|0)|0;Y=(X(Y,da)|0)-(X(_,V)|0)|0;T=(X(_,ea)|0)-(X(T,da)|0)|0;Z=Fs(W|0,((W|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;_=I;u=Fs(Y|0,((Y|0)<0)<<31>>31|0,u|0,((u|0)<0)<<31>>31|0)|0;t=I;l=Fs(T|0,((T|0)<0)<<31>>31|0,l|0,((l|0)<0)<<31>>31|0)|0;l=iw(Z|0,_|0,l|0,I|0)|0;t=iw(l|0,I|0,u|0,t|0)|0;u=I;l=Fs(T|0,((T|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;_=I;Z=Fs(Y|0,((Y|0)<0)<<31>>31|0,V|0,((V|0)<0)<<31>>31|0)|0;Z=Tv(l|0,_|0,Z|0,I|0)|0;_=I;l=Fs(W|0,((W|0)<0)<<31>>31|0,V|0,((V|0)<0)<<31>>31|0)|0;aa=I;$=Fs(T|0,((T|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;$=Tv(l|0,aa|0,$|0,I|0)|0;aa=I;l=Fs(Y|0,((Y|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;ca=I;ba=Fs(W|0,((W|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;ba=Tv(l|0,ca|0,ba|0,I|0)|0;ca=I;l=Fs(Z|0,_|0,h|0,((h|0)<0)<<31>>31|0)|0;S=I;k=Fs($|0,aa|0,i|0,((i|0)<0)<<31>>31|0)|0;S=iw(k|0,I|0,l|0,S|0)|0;l=I;k=Fs(ba|0,ca|0,j|0,((j|0)<0)<<31>>31|0)|0;k=iw(S|0,l|0,k|0,I|0)|0;l=I;if((U|0)!=0?(f[U+12>>2]|0)!=0:0){g=h;b=i;c=j;n=U;o=l;m=k;while(1){n=f[(f[n+8>>2]|0)+4>>2]|0;l=n+12|0;j=f[l>>2]|0;h=f[j+88>>2]|0;R=Fs(h|0,((h|0)<0)<<31>>31|0,W|0,((W|0)<0)<<31>>31|0)|0;Q=I;i=f[j+92>>2]|0;S=Fs(i|0,((i|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;Q=iw(S|0,I|0,R|0,Q|0)|0;R=I;j=f[j+96>>2]|0;S=Fs(j|0,((j|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;S=iw(Q|0,R|0,S|0,I|0)|0;R=I;if((R|0)<(u|0)|(R|0)==(u|0)&S>>>0<t>>>0){k=m;j=o;break}if((f[n+20>>2]|0)==(f[a+100>>2]|0)){k=m;j=o;break}S=Fs(Z|0,_|0,h|0,((h|0)<0)<<31>>31|0)|0;R=I;k=Fs($|0,aa|0,i|0,((i|0)<0)<<31>>31|0)|0;R=iw(k|0,I|0,S|0,R|0)|0;S=I;k=Fs(ba|0,ca|0,j|0,((j|0)<0)<<31>>31|0)|0;k=iw(R|0,S|0,k|0,I|0)|0;j=I;if(!((j|0)>(o|0)|(j|0)==(o|0)&k>>>0>m>>>0)){k=m;j=o;break}f[d>>2]=n;S=f[l>>2]|0;g=f[S+88>>2]|0;b=f[S+92>>2]|0;c=f[S+96>>2]|0;if(!S)break;else{o=j;m=k}}h=g;i=f[e>>2]|0;s=j}else{b=i;c=j;i=fa;s=l}g=Fs(Z|0,_|0,r|0,((r|0)<0)<<31>>31|0)|0;S=I;j=Fs($|0,aa|0,p|0,((p|0)<0)<<31>>31|0)|0;S=iw(j|0,I|0,g|0,S|0)|0;g=I;j=Fs(ba|0,ca|0,q|0,((q|0)<0)<<31>>31|0)|0;j=iw(S|0,g|0,j|0,I|0)|0;g=I;a:do if(i)if(!(f[i+12>>2]|0))o=q;else{o=q;while(1){q=f[f[i+8>>2]>>2]|0;n=f[q+12>>2]|0;l=f[n+88>>2]|0;R=Fs(l|0,((l|0)<0)<<31>>31|0,W|0,((W|0)<0)<<31>>31|0)|0;Q=I;m=f[n+92>>2]|0;S=Fs(m|0,((m|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;Q=iw(S|0,I|0,R|0,Q|0)|0;R=I;n=f[n+96>>2]|0;S=Fs(n|0,((n|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;S=iw(Q|0,R|0,S|0,I|0)|0;R=I;if((R|0)<(u|0)|(R|0)==(u|0)&S>>>0<t>>>0)break a;if((f[q+20>>2]|0)==(f[a+100>>2]|0))break a;l=Fs(Z|0,_|0,l|0,((l|0)<0)<<31>>31|0)|0;S=I;m=Fs($|0,aa|0,m|0,((m|0)<0)<<31>>31|0)|0;S=iw(m|0,I|0,l|0,S|0)|0;m=I;l=Fs(ba|0,ca|0,n|0,((n|0)<0)<<31>>31|0)|0;l=iw(S|0,m|0,l|0,I|0)|0;m=I;if(!((m|0)>(g|0)|(m|0)==(g|0)&l>>>0>j>>>0))break a;f[e>>2]=q;S=f[q+12>>2]|0;g=f[S+88>>2]|0;i=f[S+92>>2]|0;j=f[S+96>>2]|0;if(!S){r=g;p=i;o=j;i=q;j=l;g=m;break}else{r=g;p=i;o=j;i=q;g=m;j=l}}}else{o=q;i=0}while(0);j=Tv(j|0,g|0,k|0,s|0)|0;S=I;if((S|0)>0|(S|0)==0&j>>>0>0){Q=Tv(0,0,T|0,((T|0)<0)<<31>>31|0)|0;R=I;N=r;k=h;O=p;m=b;P=o;n=c;l=i;v=j;s=S;while(1){q=(X(O-m|0,ea)|0)+(X(N-k|0,da)|0)+(X(P-n|0,V)|0)|0;g=f[d>>2]|0;if(!g){z=q;F=k;E=m;D=n;n=q;k=((q|0)<0)<<31>>31;g=s;x=v}else{t=k;l=n;u=q;n=q;M=((q|0)<0)<<31>>31;L=s;b:while(1){if(!(f[g+12>>2]|0)){g=L;k=M;break}G=f[(f[g>>2]|0)+8>>2]|0;if((f[G+20>>2]|0)<=(f[a+100>>2]|0)){g=L;k=M;break}K=f[G+12>>2]|0;H=f[K+88>>2]|0;F=H-t|0;J=f[K+92>>2]|0;E=J-m|0;K=f[K+96>>2]|0;k=K-l|0;s=Fs(Z|0,_|0,F|0,((F|0)<0)<<31>>31|0)|0;D=I;q=Fs($|0,aa|0,E|0,((E|0)<0)<<31>>31|0)|0;D=iw(q|0,I|0,s|0,D|0)|0;s=I;q=Fs(ba|0,ca|0,k|0,((k|0)<0)<<31>>31|0)|0;q=iw(D|0,s|0,q|0,I|0)|0;s=I;k=(X(E,ea)|0)+(X(F,da)|0)+(X(k,V)|0)|0;do if((q|0)==0&(s|0)==0){if((k|0)>=0){g=L;k=M;break b}}else{if((s|0)>=0){g=L;k=M;break b}if((k|0)>0){F=-1;x=k;w=((k|0)<0)<<31>>31}else{x=Tv(0,0,k|0,((k|0)<0)<<31>>31|0)|0;F=(k|0)!=0&1;x=k|0?x:0;w=k|0?I:0}B=Tv(0,0,q|0,s|0)|0;C=I;if((u|0)>0){k=1;q=-1;D=n;E=M}else{E=(u|0)!=0;D=Tv(0,0,n|0,M|0)|0;k=E<<31>>31;q=E&1;D=E?D:0;E=E?I:0}if((L|0)>0|(L|0)==0&v>>>0>0){q=v;s=L}else{s=(v|0)!=0|(L|0)!=0;A=Tv(0,0,v|0,L|0)|0;k=s?q:k;q=s?A:0;s=s?I:0}if((F|0)==(k|0)){if(!F)break;k=Fs(q|0,0,x|0,0)|0;y=I;ja=Fs(s|0,0,x|0,0)|0;ia=I;z=Fs(q|0,0,w|0,0)|0;A=I;ha=Fs(s|0,0,w|0,0)|0;x=I;z=iw(ja|0,0,z|0,0)|0;q=I;x=iw(ia|0,0,ha|0,x|0)|0;A=iw(x|0,I|0,A|0,0)|0;q=iw(A|0,I|0,q|0,0)|0;A=I;x=iw(0,z|0,k|0,y|0)|0;y=I;z=iw(q|0,A|0,(y>>>0<z>>>0|(y|0)==(z|0)&x>>>0<0)&1|0,0)|0;A=I;q=Fs(D|0,0,B|0,0)|0;k=I;ha=Fs(E|0,0,B|0,0)|0;B=I;s=Fs(D|0,0,C|0,0)|0;w=I;C=Fs(E|0,0,C|0,0)|0;D=I;s=iw(ha|0,0,s|0,0)|0;E=I;D=iw(B|0,0,C|0,D|0)|0;w=iw(D|0,I|0,w|0,0)|0;E=iw(w|0,I|0,E|0,0)|0;w=I;k=iw(0,s|0,q|0,k|0)|0;q=I;s=iw(E|0,w|0,(q>>>0<s>>>0|(q|0)==(s|0)&k>>>0<0)&1|0,0)|0;w=I;if(A>>>0<w>>>0|(A|0)==(w|0)&z>>>0<s>>>0)k=-1;else k=A>>>0>w>>>0|(A|0)==(w|0)&z>>>0>s>>>0?1:y>>>0<q>>>0|(y|0)==(q|0)&x>>>0<k>>>0?-1:(y>>>0>q>>>0|(y|0)==(q|0)&x>>>0>k>>>0)&1;k=X(k,F)|0}else k=F-k|0;if((k|0)<=-1){g=L;k=M;break b}}while(0);ja=N-H|0;ia=O-J|0;s=P-K|0;q=Fs(Z|0,_|0,ja|0,((ja|0)<0)<<31>>31|0)|0;ha=I;k=Fs($|0,aa|0,ia|0,((ia|0)<0)<<31>>31|0)|0;ha=iw(k|0,I|0,q|0,ha|0)|0;q=I;k=Fs(ba|0,ca|0,s|0,((s|0)<0)<<31>>31|0)|0;k=iw(ha|0,q|0,k|0,I|0)|0;q=I;g=(g|0)==(U|0)?0:G;f[d>>2]=g;s=(X(ia,ea)|0)+(X(ja,da)|0)+(X(s,V)|0)|0;if(!g){u=s;t=H;m=J;l=K;v=k;g=q;n=s;k=((s|0)<0)<<31>>31;break}else{t=H;m=J;l=K;u=s;n=s;M=((s|0)<0)<<31>>31;L=q;v=k}}z=u;F=t;E=m;D=l;l=f[e>>2]|0;x=v}if(!l){g=110;break}if(!(f[l+12>>2]|0)){g=110;break}C=f[f[l+8>>2]>>2]|0;if((f[C+20>>2]|0)<=(f[a+100>>2]|0)){g=110;break}s=f[C+12>>2]|0;u=f[s+88>>2]|0;q=u-N|0;t=f[s+92>>2]|0;m=t-O|0;s=f[s+96>>2]|0;l=s-P|0;ja=Fs(q|0,((q|0)<0)<<31>>31|0,W|0,((W|0)<0)<<31>>31|0)|0;ha=I;ia=Fs(m|0,((m|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=iw(ia|0,I|0,ja|0,ha|0)|0;ja=I;ia=Fs(Q|0,R|0,l|0,((l|0)<0)<<31>>31|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(I|0))){g=110;break}w=Fs(Z|0,_|0,q|0,((q|0)<0)<<31>>31|0)|0;B=I;v=Fs($|0,aa|0,m|0,((m|0)<0)<<31>>31|0)|0;B=iw(v|0,I|0,w|0,B|0)|0;w=I;v=Fs(ba|0,ca|0,l|0,((l|0)<0)<<31>>31|0)|0;v=iw(B|0,w|0,v|0,I|0)|0;w=I;l=(X(m,ea)|0)+(X(q,da)|0)+(X(l,V)|0)|0;B=u-F|0;ia=t-E|0;A=s-D|0;B=Fs(Z|0,_|0,B|0,((B|0)<0)<<31>>31|0)|0;ja=I;ia=Fs($|0,aa|0,ia|0,((ia|0)<0)<<31>>31|0)|0;ja=iw(ia|0,I|0,B|0,ja|0)|0;B=I;A=Fs(ba|0,ca|0,A|0,((A|0)<0)<<31>>31|0)|0;A=iw(ja|0,B|0,A|0,I|0)|0;B=I;if(!((B|0)>0|(B|0)==0&A>>>0>0)){g=110;break}if((v|0)==0&(w|0)==0){if((l|0)>=0){g=110;break}}else{if((w|0)>=0){g=110;break}if((l|0)>0){y=-1;s=l;q=((l|0)<0)<<31>>31}else{s=Tv(0,0,l|0,((l|0)<0)<<31>>31|0)|0;y=(l|0)!=0&1;s=l|0?s:0;q=l|0?I:0}v=Tv(0,0,v|0,w|0)|0;w=I;if((z|0)>0){m=1;l=-1}else{ja=(z|0)!=0;n=Tv(0,0,n|0,k|0)|0;m=ja<<31>>31;l=ja&1;n=ja?n:0;k=ja?I:0}if((g|0)>0|(g|0)==0&x>>>0>0)l=x;else{ja=(x|0)!=0|(g|0)!=0;g=Tv(0,0,x|0,g|0)|0;m=ja?l:m;l=ja?g:0;g=ja?I:0}if((y|0)==(m|0)){if(!y){g=110;break}P=Fs(l|0,0,s|0,0)|0;ja=I;ia=Fs(g|0,0,s|0,0)|0;m=I;t=Fs(l|0,0,q|0,0)|0;u=I;s=Fs(g|0,0,q|0,0)|0;q=I;t=iw(ia|0,0,t|0,0)|0;ia=I;q=iw(m|0,0,s|0,q|0)|0;u=iw(q|0,I|0,u|0,0)|0;ia=iw(u|0,I|0,ia|0,0)|0;u=I;q=iw(0,t|0,P|0,ja|0)|0;s=I;t=iw(ia|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&q>>>0<0)&1|0,0)|0;u=I;ia=Fs(n|0,0,v|0,0)|0;g=I;ja=Fs(k|0,0,v|0,0)|0;P=I;l=Fs(n|0,0,w|0,0)|0;m=I;ha=Fs(k|0,0,w|0,0)|0;k=I;l=iw(ja|0,0,l|0,0)|0;ja=I;k=iw(P|0,0,ha|0,k|0)|0;m=iw(k|0,I|0,m|0,0)|0;ja=iw(m|0,I|0,ja|0,0)|0;m=I;g=iw(0,l|0,ia|0,g|0)|0;k=I;l=iw(ja|0,m|0,(k>>>0<l>>>0|(k|0)==(l|0)&g>>>0<0)&1|0,0)|0;m=I;if(u>>>0<m>>>0|(u|0)==(m|0)&t>>>0<l>>>0)g=-1;else g=u>>>0>m>>>0|(u|0)==(m|0)&t>>>0>l>>>0?1:s>>>0<k>>>0|(s|0)==(k|0)&q>>>0<g>>>0?-1:(s>>>0>k>>>0|(s|0)==(k|0)&q>>>0>g>>>0)&1;g=X(g,y)|0}else g=y-m|0;if((g|0)<=0){g=110;break}}f[e>>2]=C;P=f[C+12>>2]|0;N=f[P+88>>2]|0;k=F;O=f[P+92>>2]|0;m=E;P=f[P+96>>2]|0;n=D;l=C;v=A;s=B}if((g|0)==110)return}if((S|0)>=0)return;E=Tv(0,0,T|0,((T|0)<0)<<31>>31|0)|0;F=I;g=S;c:while(1){D=g;d:while(1){C=(X(p-b|0,ea)|0)+(X(r-h|0,da)|0)+(X(o-c|0,V)|0)|0;do if((i|0?f[i+12>>2]|0:0)?(ga=f[(f[i+4>>2]|0)+8>>2]|0,(f[ga+20>>2]|0)>(f[a+100>>2]|0)):0){B=f[ga+12>>2]|0;z=f[B+88>>2]|0;ja=z-r|0;A=f[B+92>>2]|0;ia=A-p|0;B=f[B+96>>2]|0;g=B-o|0;l=Fs(Z|0,_|0,ja|0,((ja|0)<0)<<31>>31|0)|0;ha=I;k=Fs($|0,aa|0,ia|0,((ia|0)<0)<<31>>31|0)|0;ha=iw(k|0,I|0,l|0,ha|0)|0;l=I;k=Fs(ba|0,ca|0,g|0,((g|0)<0)<<31>>31|0)|0;k=iw(ha|0,l|0,k|0,I|0)|0;l=I;g=(X(ia,ea)|0)+(X(ja,da)|0)+(X(g,V)|0)|0;if((k|0)==0&(l|0)==0)if((g|0)>0)break d;else break;if((l|0)<0){if((g|0)>0){y=-1;n=g;m=((g|0)<0)<<31>>31}else{n=Tv(0,0,g|0,((g|0)<0)<<31>>31|0)|0;y=(g|0)!=0&1;n=g|0?n:0;m=g|0?I:0}u=Tv(0,0,k|0,l|0)|0;v=I;if((C|0)>0){g=1;k=-1;w=C;x=((C|0)<0)<<31>>31}else{w=Tv(0,0,C|0,((C|0)<0)<<31>>31|0)|0;g=((C|0)!=0)<<31>>31;k=(C|0)!=0&1;w=C|0?w:0;x=C|0?I:0}if((D|0)>0|(D|0)==0&j>>>0>0){k=j;l=D}else{l=(j|0)!=0|(D|0)!=0;ja=Tv(0,0,j|0,D|0)|0;g=l?k:g;k=l?ja:0;l=l?I:0}if((y|0)==(g|0)){if(!y)break d;g=Fs(k|0,0,n|0,0)|0;q=I;ha=Fs(l|0,0,n|0,0)|0;U=I;s=Fs(k|0,0,m|0,0)|0;t=I;ja=Fs(l|0,0,m|0,0)|0;n=I;s=iw(ha|0,0,s|0,0)|0;k=I;n=iw(U|0,0,ja|0,n|0)|0;t=iw(n|0,I|0,t|0,0)|0;k=iw(t|0,I|0,k|0,0)|0;t=I;n=iw(0,s|0,g|0,q|0)|0;q=I;s=iw(k|0,t|0,(q>>>0<s>>>0|(q|0)==(s|0)&n>>>0<0)&1|0,0)|0;t=I;k=Fs(w|0,0,u|0,0)|0;g=I;ja=Fs(x|0,0,u|0,0)|0;U=I;l=Fs(w|0,0,v|0,0)|0;m=I;ha=Fs(x|0,0,v|0,0)|0;ia=I;l=iw(ja|0,0,l|0,0)|0;ja=I;ia=iw(U|0,0,ha|0,ia|0)|0;m=iw(ia|0,I|0,m|0,0)|0;ja=iw(m|0,I|0,ja|0,0)|0;m=I;g=iw(0,l|0,k|0,g|0)|0;k=I;l=iw(ja|0,m|0,(k>>>0<l>>>0|(k|0)==(l|0)&g>>>0<0)&1|0,0)|0;m=I;if(t>>>0<m>>>0|(t|0)==(m|0)&s>>>0<l>>>0)g=-1;else g=t>>>0>m>>>0|(t|0)==(m|0)&s>>>0>l>>>0?1:q>>>0<k>>>0|(q|0)==(k|0)&n>>>0<g>>>0?-1:(q>>>0>k>>>0|(q|0)==(k|0)&n>>>0>g>>>0)&1;g=X(g,y)|0}else g=y-g|0;if((g|0)<1)break d}}while(0);g=f[d>>2]|0;if(!g){g=110;break c}if(!(f[g+12>>2]|0)){g=110;break c}v=f[(f[g+8>>2]|0)+4>>2]|0;if((f[v+20>>2]|0)<=(f[a+100>>2]|0)){g=110;break c}i=f[v+12>>2]|0;l=f[i+88>>2]|0;h=l-h|0;k=f[i+92>>2]|0;b=k-b|0;i=f[i+96>>2]|0;g=i-c|0;ja=Fs(h|0,((h|0)<0)<<31>>31|0,W|0,((W|0)<0)<<31>>31|0)|0;ha=I;ia=Fs(b|0,((b|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=iw(ia|0,I|0,ja|0,ha|0)|0;ja=I;ia=Fs(E|0,F|0,g|0,((g|0)<0)<<31>>31|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(I|0))){g=110;break c}m=Fs(Z|0,_|0,h|0,((h|0)<0)<<31>>31|0)|0;u=I;c=Fs($|0,aa|0,b|0,((b|0)<0)<<31>>31|0)|0;u=iw(c|0,I|0,m|0,u|0)|0;m=I;c=Fs(ba|0,ca|0,g|0,((g|0)<0)<<31>>31|0)|0;c=iw(u|0,m|0,c|0,I|0)|0;m=I;g=(X(b,ea)|0)+(X(h,da)|0)+(X(g,V)|0)|0;u=r-l|0;ia=p-k|0;t=o-i|0;u=Fs(Z|0,_|0,u|0,((u|0)<0)<<31>>31|0)|0;ja=I;ia=Fs($|0,aa|0,ia|0,((ia|0)<0)<<31>>31|0)|0;ja=iw(ia|0,I|0,u|0,ja|0)|0;u=I;t=Fs(ba|0,ca|0,t|0,((t|0)<0)<<31>>31|0)|0;t=iw(ja|0,u|0,t|0,I|0)|0;u=I;if((u|0)>=0){g=110;break c}if((c|0)==0&(m|0)==0){if((g|0)<=0){g=110;break c}}else{if((m|0)>=0){g=110;break c}if((g|0)>0){s=-1;i=g;h=((g|0)<0)<<31>>31}else{i=Tv(0,0,g|0,((g|0)<0)<<31>>31|0)|0;s=(g|0)!=0&1;i=g|0?i:0;h=g|0?I:0}n=Tv(0,0,c|0,m|0)|0;q=I;if((C|0)>0){b=1;c=C;m=((C|0)<0)<<31>>31;g=-1}else{c=Tv(0,0,C|0,((C|0)<0)<<31>>31|0)|0;b=((C|0)!=0)<<31>>31;c=C|0?c:0;m=C|0?I:0;g=(C|0)!=0&1}if((D|0)>0|(D|0)==0&j>>>0>0)g=D;else{ja=(j|0)!=0|(D|0)!=0;j=Tv(0,0,j|0,D|0)|0;b=ja?g:b;j=ja?j:0;g=ja?I:0}if((s|0)==(b|0)){if(!s){g=110;break c}U=Fs(j|0,0,i|0,0)|0;ja=I;b=Fs(g|0,0,i|0,0)|0;ha=I;k=Fs(j|0,0,h|0,0)|0;l=I;j=Fs(g|0,0,h|0,0)|0;i=I;k=iw(b|0,0,k|0,0)|0;b=I;i=iw(ha|0,0,j|0,i|0)|0;l=iw(i|0,I|0,l|0,0)|0;b=iw(l|0,I|0,b|0,0)|0;l=I;i=iw(0,k|0,U|0,ja|0)|0;j=I;k=iw(b|0,l|0,(j>>>0<k>>>0|(j|0)==(k|0)&i>>>0<0)&1|0,0)|0;l=I;b=Fs(c|0,0,n|0,0)|0;g=I;ja=Fs(m|0,0,n|0,0)|0;U=I;c=Fs(c|0,0,q|0,0)|0;h=I;ha=Fs(m|0,0,q|0,0)|0;ia=I;c=iw(ja|0,0,c|0,0)|0;ja=I;ia=iw(U|0,0,ha|0,ia|0)|0;h=iw(ia|0,I|0,h|0,0)|0;ja=iw(h|0,I|0,ja|0,0)|0;h=I;g=iw(0,c|0,b|0,g|0)|0;b=I;c=iw(ja|0,h|0,(b>>>0<c>>>0|(b|0)==(c|0)&g>>>0<0)&1|0,0)|0;h=I;if(l>>>0<h>>>0|(l|0)==(h|0)&k>>>0<c>>>0)g=-1;else g=l>>>0>h>>>0|(l|0)==(h|0)&k>>>0>c>>>0?1:j>>>0<b>>>0|(j|0)==(b|0)&i>>>0<g>>>0?-1:(j>>>0>b>>>0|(j|0)==(b|0)&i>>>0>g>>>0)&1;g=X(g,s)|0}else g=s-b|0;if((g|0)>=0){g=110;break c}}f[d>>2]=v;c=f[v+12>>2]|0;h=f[c+88>>2]|0;b=f[c+92>>2]|0;c=f[c+96>>2]|0;i=f[e>>2]|0;D=u;j=t}r=z-h|0;o=A-b|0;j=B-c|0;r=Fs(Z|0,_|0,r|0,((r|0)<0)<<31>>31|0)|0;p=I;o=Fs($|0,aa|0,o|0,((o|0)<0)<<31>>31|0)|0;p=iw(o|0,I|0,r|0,p|0)|0;r=I;j=Fs(ba|0,ca|0,j|0,((j|0)<0)<<31>>31|0)|0;j=iw(p|0,r|0,j|0,I|0)|0;i=(i|0)==(fa|0)?0:ga;f[e>>2]=i;r=z;p=A;o=B;g=I}if((g|0)==110)return}function uc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0.0,k=0,l=0.0,m=0.0,o=0,p=0,q=0.0,r=0,t=0.0,v=0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=u;u=u+176|0;if((d|0)<1){e=f[a+12>>2]|0;if(e|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=f[a+32>>2]|0;if(e|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;e=f[a+52>>2]|0;if(e|0){if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+52>>2]=0}b[a+56>>0]=1;f[a+52>>2]=0;f[a+44>>2]=0;f[a+48>>2]=0;u=J;return}f[J+32>>2]=0;f[J+36>>2]=0;f[J+40>>2]=0;f[J+44>>2]=256;f[J+48>>2]=0;f[J+52>>2]=0;f[J+56>>2]=0;f[J+60>>2]=256;f[J+64>>2]=0;f[J+68>>2]=0;f[J+72>>2]=0;f[J+76>>2]=256;b[J+96>>0]=1;f[J+92>>2]=0;f[J+84>>2]=0;f[J+88>>2]=0;e=0;g=c;h=-246811958;p=1900671690;r=-246811958;v=1900671690;x=-246811958;y=1900671690;while(1){i=f[g>>2]|0;k=f[g+4>>2]|0;o=f[g+8>>2]|0;j=(f[s>>2]=i,+n[s>>2]);p=j<(f[s>>2]=p,+n[s>>2])?i:p;l=(f[s>>2]=k,+n[s>>2]);v=l<(f[s>>2]=v,+n[s>>2])?k:v;m=(f[s>>2]=o,+n[s>>2]);y=m<(f[s>>2]=y,+n[s>>2])?o:y;h=(f[s>>2]=h,+n[s>>2])<j?i:h;r=(f[s>>2]=r,+n[s>>2])<l?k:r;x=(f[s>>2]=x,+n[s>>2])<m?o:x;e=e+1|0;if((e|0)==(d|0))break;else g=g+16|0}w=(f[s>>2]=h,+n[s>>2]);t=(f[s>>2]=p,+n[s>>2]);q=(f[s>>2]=r,+n[s>>2]);m=(f[s>>2]=v,+n[s>>2]);l=(f[s>>2]=x,+n[s>>2]);j=(f[s>>2]=y,+n[s>>2]);g=(w-t<q-m?q-m:w-t)<l-j?2:w-t<q-m&1;f[J+112>>2]=g;e=(w-t<q-m?w-t:q-m)<l-j?(w-t<q-m^1)&1:2;if((e|0)==(g|0))e=((g+1|0)>>>0)%3|0;f[J+104>>2]=e;p=(g^3)-e|0;f[J+108>>2]=p;z=((p+1|0)%3|0|0)==(g|0)?(w-t)*9.788566967472434e-05:-((w-t)*9.788566967472434e-05);A=((p+1|0)%3|0|0)==(g|0)?(q-m)*9.788566967472434e-05:-((q-m)*9.788566967472434e-05);B=((p+1|0)%3|0|0)==(g|0)?(l-j)*9.788566967472434e-05:-((l-j)*9.788566967472434e-05);n[J>>2]=z;n[J+4>>2]=A;n[J+8>>2]=B;n[J+12>>2]=0.0;z=z!=0.0?1.0/z:z;A=A!=0.0?1.0/A:A;B=B!=0.0?1.0/B:B;n[J+16>>2]=(w+t)*.5;n[J+20>>2]=(q+m)*.5;n[J+24>>2]=(l+j)*.5;n[J+28>>2]=0.0;p=J+144+16|0;b[p>>0]=1;r=J+144+12|0;f[r>>2]=0;f[J+144+4>>2]=0;f[J+144+8>>2]=0;f[6472]=(f[6472]|0)+1;e=sc((d<<4|3)+16|0)|0;if(!e)g=0;else{f[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}h=f[J+144+4>>2]|0;i=f[r>>2]|0;if((h|0)<=0){if(i|0)I=24}else{e=0;do{I=g+(e<<4)|0;G=i+(e<<4)|0;f[I>>2]=f[G>>2];f[I+4>>2]=f[G+4>>2];f[I+8>>2]=f[G+8>>2];f[I+12>>2]=f[G+12>>2];e=e+1|0}while((e|0)!=(h|0));I=24}if((I|0)==24){if(b[p>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[r>>2]=0}b[p>>0]=1;f[r>>2]=g;f[J+144+8>>2]=d;f[g>>2]=f[J+128>>2];f[g+4>>2]=f[J+128+4>>2];f[g+8>>2]=f[J+128+8>>2];f[g+12>>2]=f[J+128+12>>2];if((d|0)!=1){e=1;do{G=(f[r>>2]|0)+(e<<4)|0;f[G>>2]=f[J+128>>2];f[G+4>>2]=f[J+128+4>>2];f[G+8>>2]=f[J+128+8>>2];f[G+12>>2]=f[J+128+12>>2];e=e+1|0}while((e|0)!=(d|0))}f[J+144+4>>2]=d;h=J+128+(f[J+108>>2]<<2)|0;i=f[r>>2]|0;k=J+128+(f[J+112>>2]<<2)|0;o=J+128+(f[J+104>>2]<<2)|0;j=+n[J+16>>2];l=+n[J+20>>2];m=+n[J+24>>2];g=0;e=c;while(1){t=A*(+n[e+4>>2]-l);w=B*(+n[e+8>>2]-m);n[J+128>>2]=z*(+n[e>>2]-j);n[J+128+4>>2]=t;n[J+128+8>>2]=w;n[J+128+12>>2]=0.0;f[i+(g<<4)>>2]=~~+n[h>>2];f[i+(g<<4)+4>>2]=~~+n[k>>2];f[i+(g<<4)+8>>2]=~~+n[o>>2];f[i+(g<<4)+12>>2]=g;g=g+1|0;if((g|0)==(d|0))break;else e=e+16|0}if((d|0)>1)ah(J+144|0,0,d+-1|0);f[J+36>>2]=f[J+32>>2];f[J+40>>2]=0;f[J+44>>2]=d;e=f[J+84>>2]|0;if((e|0)<(d|0)){if((f[J+88>>2]|0)<(d|0)){if(!d){g=0;i=e}else{f[6472]=(f[6472]|0)+1;g=sc((d<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=f[J+84>>2]|0}if((i|0)>0){h=0;do{f[g+(h<<2)>>2]=f[(f[J+92>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(i|0))}h=f[J+92>>2]|0;if(h|0){if(b[J+96>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[J+92>>2]=0}b[J+96>>0]=1;f[J+92>>2]=g;f[J+88>>2]=d}do{f[(f[J+92>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(d|0))}f[J+84>>2]=d;k=0;do{e=f[J+40>>2]|0;if(!e){e=f[J+36>>2]|0;if(!e){f[6472]=(f[6472]|0)+1;e=sc(31)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=f[J+44>>2]|0;f[e+4>>2]=g;h=e+8|0;f[h>>2]=0;f[6472]=(f[6472]|0)+1;g=sc((g*112|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}f[e>>2]=g;f[h>>2]=f[J+32>>2];f[J+32>>2]=e}else f[J+36>>2]=f[e+8>>2];i=f[e+4>>2]|0;e=f[e>>2]|0;if((i|0)>0?(f[e>>2]=(i|0)!=1?e+112|0:0,(i|0)!=1):0){g=1;h=e+112|0;do{g=g+1|0;G=(g|0)<(i|0);F=h;h=h+112|0;f[F>>2]=G?h:0}while(G)}}f[J+40>>2]=f[e>>2];G=e+104|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[G>>2]=-1;f[e+8>>2]=0;E=(f[r>>2]|0)+(k<<4)|0;F=e+88|0;f[F>>2]=f[E>>2];f[F+4>>2]=f[E+4>>2];f[F+8>>2]=f[E+8>>2];f[F+12>>2]=f[E+12>>2];f[G>>2]=-1;f[(f[J+92>>2]|0)+(k<<2)>>2]=e;k=k+1|0}while((k|0)<(d|0));e=f[r>>2]|0;if(e|0){if(b[p>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[r>>2]=0}b[p>>0]=1;f[r>>2]=0;f[J+144+4>>2]=0;f[J+144+8>>2]=0;f[J+52>>2]=f[J+48>>2];f[J+56>>2]=0;f[J+60>>2]=d*6;f[J+116>>2]=0;f[J+120>>2]=0;f[J+100>>2]=-3;f[J+128>>2]=0;f[J+128+4>>2]=0;f[J+128+8>>2]=0;f[J+128+12>>2]=0;pc(J,0,d,J+128|0);f[J+124>>2]=f[J+128>>2];e=f[r>>2]|0;if(e|0){if(b[p>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[r>>2]=0}e=f[a+4>>2]|0;if((e|0)<0){if((f[a+8>>2]|0)<0){g=f[a+12>>2]|0;if(g|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=0;f[a+8>>2]=0}do{G=(f[a+12>>2]|0)+(e<<4)|0;f[G>>2]=f[J+144>>2];f[G+4>>2]=f[J+144+4>>2];f[G+8>>2]=f[J+144+8>>2];f[G+12>>2]=f[J+144+12>>2];e=e+1|0}while((e|0)!=0)}f[a+4>>2]=0;f[J+144>>2]=0;f[J+144+4>>2]=0;f[J+144+8>>2]=0;e=f[a+24>>2]|0;if((e|0)<0){if((f[a+28>>2]|0)<0){g=f[a+32>>2]|0;if(g|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=0;f[a+28>>2]=0}do{G=(f[a+32>>2]|0)+(e*12|0)|0;f[G>>2]=f[J+144>>2];f[G+4>>2]=f[J+144+4>>2];f[G+8>>2]=f[J+144+8>>2];e=e+1|0}while((e|0)!=0)}f[a+24>>2]=0;g=f[a+44>>2]|0;if((g|0)<0){e=f[a+52>>2]|0;if((f[a+48>>2]|0)<0){if(e|0?b[a+56>>0]|0:0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}b[a+56>>0]=1;f[a+52>>2]=0;f[a+48>>2]=0;e=0}bl(e+(g<<2)|0,0,X(g,-4)|0)|0}f[a+44>>2]=0;g=f[J+124>>2]|0;if((f[g+104>>2]|0)<0){f[g+104>>2]=0;f[6472]=(f[6472]|0)+1;e=sc(23)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f[e>>2]=g;G=0;o=1;p=e;r=1;h=e;x=e;while(1){if((f[g+100>>2]|0)>-1){n[J+144+(f[J+108>>2]<<2)>>2]=+(f[g+88>>2]|0);n[J+144+(f[J+112>>2]<<2)>>2]=+(f[g+92>>2]|0);j=+(f[g+96>>2]|0)}else{j=+ml(g+24|0);F=g+72|0;j=j/+ml(F);n[J+144+(f[J+108>>2]<<2)>>2]=j;j=+ml(g+40|0);j=j/+ml(F);n[J+144+(f[J+112>>2]<<2)>>2]=j;j=+ml(g+56|0);j=j/+ml(F)}n[J+144+(f[J+104>>2]<<2)>>2]=j;j=+n[J+144>>2]*+n[J>>2]+ +n[J+16>>2];l=+n[J+144+4>>2]*+n[J+4>>2]+ +n[J+20>>2];m=+n[J+144+8>>2]*+n[J+8>>2]+ +n[J+24>>2];i=f[a+4>>2]|0;if((i|0)==(f[a+8>>2]|0)?(H=i|0?i<<1:1,(i|0)<(H|0)):0){if(!H)e=0;else{f[6472]=(f[6472]|0)+1;e=sc((H<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}i=f[a+4>>2]|0}if((i|0)>0){k=0;do{F=e+(k<<4)|0;E=(f[a+12>>2]|0)+(k<<4)|0;f[F>>2]=f[E>>2];f[F+4>>2]=f[E+4>>2];f[F+8>>2]=f[E+8>>2];f[F+12>>2]=f[E+12>>2];k=k+1|0}while((k|0)!=(i|0))}i=f[a+12>>2]|0;if(i|0){if(b[a+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+12>>2]=0}b[a+16>>0]=1;f[a+12>>2]=e;f[a+8>>2]=H;e=f[a+4>>2]|0}else e=i;F=f[a+12>>2]|0;n[F+(e<<4)>>2]=j;n[F+(e<<4)+4>>2]=l;n[F+(e<<4)+8>>2]=m;n[F+(e<<4)+12>>2]=0.0;f[a+4>>2]=(f[a+4>>2]|0)+1;F=f[g+8>>2]|0;if(!F){i=o;y=p;g=r}else{D=F;E=-1;e=-1;y=o;d=p;g=r;while(1){C=D+20|0;k=f[C>>2]|0;if((k|0)<0){c=f[a+24>>2]|0;f[J+144>>2]=0;f[J+144+4>>2]=0;f[J+144+8>>2]=0;do if((c|0)==(f[a+28>>2]|0)){p=c|0?c<<1:1;if((c|0)>=(p|0)){i=c;break}if(!p){i=0;o=c}else{f[6472]=(f[6472]|0)+1;i=sc((p*12|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}o=f[a+24>>2]|0}if((o|0)>0){k=0;do{v=i+(k*12|0)|0;r=(f[a+32>>2]|0)+(k*12|0)|0;f[v>>2]=f[r>>2];f[v+4>>2]=f[r+4>>2];f[v+8>>2]=f[r+8>>2];k=k+1|0}while((k|0)!=(o|0))}k=f[a+32>>2]|0;if(k|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=i;f[a+28>>2]=p;i=f[a+24>>2]|0}else i=c;while(0);i=(f[a+32>>2]|0)+(i*12|0)|0;f[i>>2]=f[J+144>>2];f[i+4>>2]=f[J+144+4>>2];f[i+8>>2]=f[J+144+8>>2];i=(f[a+24>>2]|0)+1|0;f[a+24>>2]=i;f[J+144>>2]=0;f[J+144+4>>2]=0;f[J+144+8>>2]=0;do if((i|0)==(f[a+28>>2]|0)){p=i|0?i<<1:1;if((i|0)>=(p|0))break;if(!p)o=0;else{f[6472]=(f[6472]|0)+1;i=sc((p*12|3)+16|0)|0;if(!i)i=0;else{f[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}o=i;i=f[a+24>>2]|0}if((i|0)>0){k=0;do{v=o+(k*12|0)|0;r=(f[a+32>>2]|0)+(k*12|0)|0;f[v>>2]=f[r>>2];f[v+4>>2]=f[r+4>>2];f[v+8>>2]=f[r+8>>2];k=k+1|0}while((k|0)!=(i|0))}i=f[a+32>>2]|0;if(i|0){if(b[a+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+32>>2]=0}b[a+36>>0]=1;f[a+32>>2]=o;f[a+28>>2]=p;i=f[a+24>>2]|0}while(0);v=(f[a+32>>2]|0)+(i*12|0)|0;f[v>>2]=f[J+144>>2];f[v+4>>2]=f[J+144+4>>2];f[v+8>>2]=f[J+144+8>>2];f[a+24>>2]=(f[a+24>>2]|0)+1;v=f[a+32>>2]|0;f[C>>2]=c;f[(f[D+8>>2]|0)+20>>2]=c+1;f[v+(c*12|0)+4>>2]=1;f[v+((c+1|0)*12|0)+4>>2]=-1;r=f[D+12>>2]|0;i=f[r+104>>2]|0;if((i|0)<0){f[r+104>>2]=g;do if((g|0)==(y|0)){i=y|0?y<<1:1;if((y|0)>=(i|0)){i=y;k=d;p=x;break}do if(!i)o=0;else{f[6472]=(f[6472]|0)+1;k=sc((i<<2|3)+16|0)|0;if(!k){o=0;break}f[(k+4+15&-16)+-4>>2]=k;o=k+4+15&-16}while(0);if((y|0)>0){k=0;do{f[o+(k<<2)>>2]=f[d+(k<<2)>>2];k=k+1|0}while((k|0)!=(y|0));if(!h){k=o;p=o;h=o;break}}else if((d|0)==0|(h|0)==0){k=o;p=o;h=o;break}f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);k=o;p=o;h=o}else{i=y;k=d;p=x}while(0);f[k+(g<<2)>>2]=r;r=g;g=g+1|0;o=p}else{r=i;i=y;k=d;o=x}f[v+(c*12|0)+8>>2]=r;f[v+((c+1|0)*12|0)+8>>2]=G;p=k;k=f[C>>2]|0}else{i=y;p=d;o=x}if((E|0)>-1)f[(f[a+32>>2]|0)+(k*12|0)>>2]=E-k;else e=k;D=f[D>>2]|0;if((D|0)==(F|0))break;else{E=k;y=i;d=p;x=o}}f[(f[a+32>>2]|0)+(e*12|0)>>2]=k-e;y=p;x=o}e=G+1|0;if((e|0)>=(g|0))break;G=e;o=i;p=y;r=g;g=f[y+(e<<2)>>2]|0}if((G|0)>-1){r=0;while(1){v=f[(f[y+(r<<2)>>2]|0)+8>>2]|0;if(v|0){p=v;do{o=p+20|0;e=f[o>>2]|0;if((e|0)>-1){g=f[a+44>>2]|0;do if((g|0)==(f[a+48>>2]|0)){k=g|0?g<<1:1;if((g|0)>=(k|0))break;if(!k)e=0;else{f[6472]=(f[6472]|0)+1;e=sc((k<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=f[a+44>>2]|0}i=f[a+52>>2]|0;if((g|0)<=0){if(i)I=173}else{h=0;do{f[e+(h<<2)>>2]=f[i+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0));I=173}if((I|0)==173){I=0;if(b[a+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+52>>2]=0;g=f[a+44>>2]|0}b[a+56>>0]=1;f[a+52>>2]=e;f[a+48>>2]=k;e=f[o>>2]|0}while(0);f[(f[a+52>>2]|0)+(g<<2)>>2]=e;f[a+44>>2]=(f[a+44>>2]|0)+1;e=p;do{f[e+20>>2]=-1;e=f[(f[e+8>>2]|0)+4>>2]|0}while((e|0)!=(p|0))}p=f[p>>2]|0}while((p|0)!=(v|0))}if((r|0)==(G|0))break;else r=r+1|0}}if(!((y|0)==0|(x|0)==0)){f[6473]=(f[6473]|0)+1;Cd(f[x+-4>>2]|0)}}Si(J);u=J;return}function vc(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;Y=u;u=u+256|0;f[a+188>>2]=-1;uj(13038);f[a+184>>2]=0;if((d|0)>0){k=0;do{f[(f[c+(k<<2)>>2]|0)+212>>2]=-1;k=k+1|0}while((k|0)!=(d|0))}k=f[a+12>>2]|0;if((k|0)>(d|0)){m=a+8|0;l=k}else{if((d+1|0)!=0?(f[6472]=(f[6472]|0)+1,l=sc(((d+1|0)*244|3)+16|0)|0,(l|0)!=0):0){f[(l+4+15&-16)+-4>>2]=l;m=l+4+15&-16}else m=0;l=f[a+8>>2]|0;if((l|0)>0){k=0;do{V=m+(k*244|0)|0;W=f[a+16>>2]|0;U=W+(k*244|0)|0;f[V>>2]=f[U>>2];f[V+4>>2]=f[U+4>>2];f[V+8>>2]=f[U+8>>2];f[V+12>>2]=f[U+12>>2];V=W+(k*244|0)+16|0;U=m+(k*244|0)+16|0;f[U>>2]=f[V>>2];f[U+4>>2]=f[V+4>>2];f[U+8>>2]=f[V+8>>2];f[U+12>>2]=f[V+12>>2];U=W+(k*244|0)+32|0;V=m+(k*244|0)+32|0;f[V>>2]=f[U>>2];f[V+4>>2]=f[U+4>>2];f[V+8>>2]=f[U+8>>2];f[V+12>>2]=f[U+12>>2];V=m+(k*244|0)+48|0;U=W+(k*244|0)+48|0;f[V>>2]=f[U>>2];f[V+4>>2]=f[U+4>>2];f[V+8>>2]=f[U+8>>2];f[V+12>>2]=f[U+12>>2];ki(m+(k*244|0)+64|0,W+(k*244|0)+64|0,180)|0;k=k+1|0}while((k|0)!=(l|0))}k=f[a+16>>2]|0;if(k|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=m;f[a+12>>2]=d+1;m=a+8|0;l=d+1|0}bl(Y|0,0,244)|0;k=f[m>>2]|0;if((k|0)<0){if((l|0)<0){l=f[a+16>>2]|0;if(l|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=0;f[a+12>>2]=0}do{W=f[a+16>>2]|0;V=W+(k*244|0)|0;f[V>>2]=f[Y>>2];f[V+4>>2]=f[Y+4>>2];f[V+8>>2]=f[Y+8>>2];f[V+12>>2]=f[Y+12>>2];V=W+(k*244|0)+16|0;f[V>>2]=f[Y+16>>2];f[V+4>>2]=f[Y+16+4>>2];f[V+8>>2]=f[Y+16+8>>2];f[V+12>>2]=f[Y+16+12>>2];V=W+(k*244|0)+32|0;f[V>>2]=f[Y+32>>2];f[V+4>>2]=f[Y+32+4>>2];f[V+8>>2]=f[Y+32+8>>2];f[V+12>>2]=f[Y+32+12>>2];V=W+(k*244|0)+48|0;f[V>>2]=f[Y+48>>2];f[V+4>>2]=f[Y+48+4>>2];f[V+8>>2]=f[Y+48+8>>2];f[V+12>>2]=f[Y+48+12>>2];ki(W+(k*244|0)+64|0,Y+64|0,180)|0;k=k+1|0}while((k|0)!=0)}f[m>>2]=0;if((d|0)>0){k=0;do{m=c+(k<<2)|0;l=Vj(a,f[m>>2]|0,+n[j+12>>2])|0;m=f[m>>2]|0;if((!((m|0)==0?1:(f[m+236>>2]&2|0)==0)?+n[m+344>>2]!=0.0:0)?(p=f[a+16>>2]|0,f[m+504>>2]&2|0):0){o=+n[j+76>>2];M=1.0/+n[m+396>>2];O=1.0/+n[m+400>>2];r=1.0/+n[m+404>>2];E=+n[m+4>>2];F=+n[m+8>>2];G=+n[m+12>>2];H=+n[m+20>>2];I=+n[m+24>>2];J=+n[m+28>>2];N=+n[m+36>>2];P=+n[m+40>>2];v=+n[m+44>>2];w=+n[m+328>>2];x=+n[m+332>>2];t=+n[m+336>>2];y=(M*E*E+O*F*F+r*G*G)*w+(M*E*H+O*F*I+r*G*J)*x+(M*E*N+O*F*P+r*G*v)*t;z=(M*H*E+O*I*F+r*J*G)*w+(M*H*H+O*I*I+r*J*J)*x+(M*H*N+O*I*P+r*J*v)*t;v=(M*N*E+O*P*F+r*v*G)*w+(M*N*H+O*P*I+r*v*J)*x+(M*N*N+O*P*P+r*v*v)*t;r=(x*v-t*z)*(x*v-t*z)+(t*y-w*v)*(t*y-w*v)+(w*z-x*y)*(w*z-x*y);if(r>o*o){o=1.0/+L(+r)*o;s=(x*v-t*z)*o;r=o*(t*y-w*v);o=o*(w*z-x*y)}else{s=x*v-t*z;r=t*y-w*v;o=w*z-x*y}N=+n[j+12>>2];O=(s*+n[m+268>>2]+r*+n[m+284>>2]+o*+n[m+300>>2])*N;P=N*(s*+n[m+272>>2]+r*+n[m+288>>2]+o*+n[m+304>>2]);n[p+(l*244|0)+224>>2]=+n[p+(l*244|0)+224>>2]-(s*+n[m+264>>2]+r*+n[m+280>>2]+o*+n[m+296>>2])*N;n[p+(l*244|0)+228>>2]=+n[p+(l*244|0)+228>>2]-O;n[p+(l*244|0)+232>>2]=+n[p+(l*244|0)+232>>2]-P}k=k+1|0}while((k|0)!=(d|0))}if((i|0)>0){k=0;do{W=f[h+(k<<2)>>2]|0;Lb[f[(f[W>>2]|0)+8>>2]&511](W);n[W+36>>2]=0.0;k=k+1|0}while((k|0)<(i|0))}l=f[a+168>>2]|0;if((l|0)<(i|0)?(f[a+172>>2]|0)<(i|0):0){if(!i)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((i<<3|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+168>>2]|0}if((l|0)>0){m=0;do{U=(f[a+176>>2]|0)+(m<<3)|0;V=f[U+4>>2]|0;W=k+(m<<3)|0;f[W>>2]=f[U>>2];f[W+4>>2]=V;m=m+1|0}while((m|0)!=(l|0))}l=f[a+176>>2]|0;if(l|0){if(b[a+180>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}f[a+176>>2]=0}b[a+180>>0]=1;f[a+176>>2]=k;f[a+172>>2]=i}f[a+168>>2]=i;if((i|0)>0){k=0;q=0;do{p=f[a+176>>2]|0;d=p+(q<<3)|0;c=h+(q<<2)|0;l=f[c>>2]|0;m=f[l+44>>2]|0;if(m){l=m+64|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(l|0));l=f[c>>2]|0}if(!(b[l+20>>0]|0)){f[d>>2]=0;f[p+(q<<3)+4>>2]=0;l=0}else{Rb[f[(f[l>>2]|0)+16>>2]&127](l,d);l=f[d>>2]|0}k=l+k|0;q=q+1|0}while((q|0)<(i|0));c=k}else c=0;l=f[a+48>>2]|0;if((l|0)<(c|0)?(f[a+52>>2]|0)<(c|0):0){if(!c)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((c*152|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+48>>2]|0}if((l|0)>0){m=0;do{ki(k+(m*152|0)|0,(f[a+56>>2]|0)+(m*152|0)|0,152)|0;m=m+1|0}while((m|0)!=(l|0))}l=f[a+56>>2]|0;if(l|0){if(b[a+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}f[a+56>>2]=0}b[a+60>>0]=1;f[a+56>>2]=k;f[a+52>>2]=c}f[a+48>>2]=c;if((i|0)>0){V=0;W=0;k=f[a+176>>2]|0;while(1){U=k+(W<<3)|0;if(!(f[U>>2]|0))l=0;else{l=f[a+56>>2]|0;c=l+(V*152|0)|0;p=h+(W<<2)|0;d=f[p>>2]|0;q=f[d+28>>2]|0;Q=f[d+32>>2]|0;R=Vj(a,q,+n[j+12>>2])|0;S=Vj(a,Q,+n[j+12>>2])|0;T=f[a+16>>2]|0;m=f[d+24>>2]|0;m=(m|0)>0?m:f[j+20>>2]|0;if((m|0)>(f[a+184>>2]|0))f[a+184>>2]=m;if((f[U>>2]|0)>0){k=0;do{bl(c+(k*152|0)|0,0,152)|0;n[c+(k*152|0)+120>>2]=-3402823466385288598117041.0e14;n[c+(k*152|0)+124>>2]=3402823466385288598117041.0e14;n[c+(k*152|0)+100>>2]=0.0;n[c+(k*152|0)+96>>2]=0.0;f[c+(k*152|0)+144>>2]=R;f[c+(k*152|0)+148>>2]=S;f[c+(k*152|0)+136>>2]=m;k=k+1|0}while((k|0)<(f[U>>2]|0))}f[T+(R*244|0)+64>>2]=0;f[T+(R*244|0)+64+4>>2]=0;f[T+(R*244|0)+64+8>>2]=0;f[T+(R*244|0)+64+12>>2]=0;f[T+(R*244|0)+64+16>>2]=0;f[T+(R*244|0)+64+20>>2]=0;f[T+(R*244|0)+64+24>>2]=0;f[T+(R*244|0)+64+28>>2]=0;f[T+(R*244|0)+144>>2]=0;f[T+(R*244|0)+144+4>>2]=0;f[T+(R*244|0)+144+8>>2]=0;f[T+(R*244|0)+144+12>>2]=0;f[T+(R*244|0)+144+16>>2]=0;f[T+(R*244|0)+144+20>>2]=0;f[T+(R*244|0)+144+24>>2]=0;f[T+(R*244|0)+144+28>>2]=0;f[T+(S*244|0)+64>>2]=0;f[T+(S*244|0)+64+4>>2]=0;f[T+(S*244|0)+64+8>>2]=0;f[T+(S*244|0)+64+12>>2]=0;f[T+(S*244|0)+64+16>>2]=0;f[T+(S*244|0)+64+20>>2]=0;f[T+(S*244|0)+64+24>>2]=0;f[T+(S*244|0)+64+28>>2]=0;f[T+(S*244|0)+144>>2]=0;f[T+(S*244|0)+144+4>>2]=0;f[T+(S*244|0)+144+8>>2]=0;f[T+(S*244|0)+144+12>>2]=0;f[T+(S*244|0)+144+16>>2]=0;f[T+(S*244|0)+144+20>>2]=0;f[T+(S*244|0)+144+24>>2]=0;f[T+(S*244|0)+144+28>>2]=0;n[Y>>2]=1.0/+n[j+12>>2];f[Y+4>>2]=f[j+32>>2];f[Y+8>>2]=l+(V*152|0)+16;f[Y+12>>2]=c;f[Y+16>>2]=l+(V*152|0)+48;f[Y+20>>2]=l+(V*152|0)+32;f[Y+24>>2]=38;f[Y+28>>2]=l+(V*152|0)+112;m=l+(V*152|0)+116|0;f[m>>2]=f[j+40>>2];f[Y+52>>2]=f[j+4>>2];f[Y+32>>2]=m;f[Y+36>>2]=l+(V*152|0)+120;f[Y+40>>2]=l+(V*152|0)+124;f[Y+48>>2]=f[j+20>>2];m=f[p>>2]|0;Rb[f[(f[m>>2]|0)+20>>2]&127](m,Y);if((f[U>>2]|0)>0){l=0;do{k=c+(l*152|0)+124|0;o=+n[(f[p>>2]|0)+16>>2];if(+n[k>>2]>=o)n[k>>2]=o;k=c+(l*152|0)+120|0;if(+n[k>>2]<=-o)n[k>>2]=-o;f[c+(l*152|0)+132>>2]=d;Z=c+(l*152|0)|0;_=f[d+28>>2]|0;P=+n[Z>>2];N=+n[Z+4>>2];O=+n[Z+8>>2];o=(P*+n[_+280>>2]+N*+n[_+284>>2]+O*+n[_+288>>2])*+n[_+548>>2];r=(P*+n[_+296>>2]+N*+n[_+300>>2]+O*+n[_+304>>2])*+n[_+552>>2];m=c+(l*152|0)+64|0;n[m>>2]=(+n[_+264>>2]*P+ +n[_+268>>2]*N+ +n[_+272>>2]*O)*+n[_+544>>2];n[m+4>>2]=o;n[m+8>>2]=r;n[m+12>>2]=0.0;m=c+(l*152|0)+32|0;_=f[d+32>>2]|0;r=+n[m>>2];o=+n[m+4>>2];O=+n[m+8>>2];N=(r*+n[_+280>>2]+o*+n[_+284>>2]+O*+n[_+288>>2])*+n[_+548>>2];P=(r*+n[_+296>>2]+o*+n[_+300>>2]+O*+n[_+304>>2])*+n[_+552>>2];k=c+(l*152|0)+80|0;n[k>>2]=(+n[_+264>>2]*r+ +n[_+268>>2]*o+ +n[_+272>>2]*O)*+n[_+544>>2];n[k+4>>2]=N;n[k+8>>2]=P;n[k+12>>2]=0.0;k=c+(l*152|0)+16|0;P=+n[q+344>>2];N=+n[k>>2];O=+n[k+4>>2];o=+n[k+8>>2];r=+n[Z>>2];s=+n[Z+4>>2];t=+n[Z+8>>2];Z=c+(l*152|0)+48|0;B=+n[Q+344>>2];v=+n[Z>>2];w=+n[Z+4>>2];x=+n[Z+8>>2];y=+n[m>>2];z=+n[m+4>>2];A=+n[m+8>>2];B=N*P*N+O*P*O+o*P*o+(r*(+n[q+264>>2]*r+ +n[q+268>>2]*s+ +n[q+272>>2]*t)+s*(r*+n[q+280>>2]+s*+n[q+284>>2]+t*+n[q+288>>2])+t*(r*+n[q+296>>2]+s*+n[q+300>>2]+t*+n[q+304>>2]))+(v*B*v+w*B*w+x*B*x)+(y*(+n[Q+264>>2]*y+ +n[Q+268>>2]*z+ +n[Q+272>>2]*A)+z*(y*+n[Q+280>>2]+z*+n[Q+284>>2]+A*+n[Q+288>>2])+A*(y*+n[Q+296>>2]+z*+n[Q+300>>2]+A*+n[Q+304>>2]));m=+K(+B)>1.1920928955078125e-07;B=m?1.0/B:0.0;n[c+(l*152|0)+108>>2]=B;if(!(f[T+(R*244|0)+240>>2]|0)){C=0.0;D=0.0;E=0.0;F=0.0;G=0.0;H=0.0}else{C=+n[T+(R*244|0)+208>>2];D=+n[T+(R*244|0)+212>>2];E=+n[T+(R*244|0)+216>>2];F=+n[T+(R*244|0)+224>>2];G=+n[T+(R*244|0)+228>>2];H=+n[T+(R*244|0)+232>>2]}if(!(f[T+(S*244|0)+240>>2]|0)){I=0.0;J=0.0;M=0.0;N=0.0;O=0.0;P=0.0}else{I=+n[T+(S*244|0)+208>>2];J=+n[T+(S*244|0)+212>>2];M=+n[T+(S*244|0)+216>>2];N=+n[T+(S*244|0)+224>>2];O=+n[T+(S*244|0)+228>>2];P=+n[T+(S*244|0)+232>>2]}_=c+(l*152|0)+112|0;n[_>>2]=+n[_>>2]*B+B*(0.0-+n[Y+52>>2]*((+n[q+312>>2]+C)*+n[k>>2]+(+n[q+316>>2]+D)*+n[k+4>>2]+(+n[q+320>>2]+E)*o+((F+ +n[q+328>>2])*r+(G+ +n[q+332>>2])*s+(H+ +n[q+336>>2])*t)+((+n[Q+312>>2]+I)*v+(+n[Q+316>>2]+J)*w+(+n[Q+320>>2]+M)*x+((N+ +n[Q+328>>2])*y+(O+ +n[Q+332>>2])*z+(P+ +n[Q+336>>2])*A))));n[c+(l*152|0)+100>>2]=0.0;l=l+1|0}while((l|0)<(f[U>>2]|0))}l=f[a+176>>2]|0;k=l;l=f[l+(W<<3)>>2]|0}W=W+1|0;if((W|0)>=(i|0))break;else V=l+V|0}}Yb[f[(f[a>>2]|0)+28>>2]&127](a,e,g,j);p=f[a+48>>2]|0;d=f[a+28>>2]|0;q=f[a+68>>2]|0;l=f[a+128>>2]|0;if((l|0)<(p|0)?(f[a+132>>2]|0)<(p|0):0){if(!p)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((p<<2|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+128>>2]|0}c=f[a+136>>2]|0;if((l|0)<=0)if(!c)l=a+140|0;else X=99;else{m=0;do{f[k+(m<<2)>>2]=f[c+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0));X=99}if((X|0)==99){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+136>>2]=0;l=a+140|0}b[l>>0]=1;f[a+136>>2]=k;f[a+132>>2]=p}f[a+128>>2]=p;if(!(f[j+64>>2]&16)){l=f[a+108>>2]|0;if((l|0)<(d|0)?(f[a+112>>2]|0)<(d|0):0){if(!d)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((d<<2|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+108>>2]|0}c=f[a+116>>2]|0;if((l|0)<=0)if(!c)l=a+120|0;else X=129;else{m=0;do{f[k+(m<<2)>>2]=f[c+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0));X=129}if((X|0)==129){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+116>>2]=0;l=a+120|0}b[l>>0]=1;f[a+116>>2]=k;f[a+112>>2]=d}f[a+108>>2]=d}else{l=f[a+108>>2]|0;if((l|0)<(d<<1|0)?(f[a+112>>2]|0)<(d<<1|0):0){if(!d)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((d<<3|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+108>>2]|0}c=f[a+116>>2]|0;if((l|0)<=0)if(!c)l=a+120|0;else X=114;else{m=0;do{f[k+(m<<2)>>2]=f[c+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0));X=114}if((X|0)==114){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+116>>2]=0;l=a+120|0}b[l>>0]=1;f[a+116>>2]=k;f[a+112>>2]=d<<1}f[a+108>>2]=d<<1}l=f[a+148>>2]|0;if((l|0)<(q|0)?(f[a+152>>2]|0)<(q|0):0){if(!q)k=0;else{f[6472]=(f[6472]|0)+1;k=sc((q<<2|3)+16|0)|0;if(!k)k=0;else{f[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}l=f[a+148>>2]|0}c=f[a+156>>2]|0;if((l|0)<=0)if(!c)l=a+160|0;else X=144;else{m=0;do{f[k+(m<<2)>>2]=f[c+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0));X=144}if((X|0)==144){if(b[a+160>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+156>>2]=0;l=a+160|0}b[l>>0]=1;f[a+156>>2]=k;f[a+152>>2]=q}f[a+148>>2]=q;if((p|0)>0){l=f[a+136>>2]|0;k=0;do{f[l+(k<<2)>>2]=k;k=k+1|0}while((k|0)!=(p|0))}if((d|0)>0){l=f[a+116>>2]|0;k=0;do{f[l+(k<<2)>>2]=k;k=k+1|0}while((k|0)!=(d|0))}if((q|0)>0){l=f[a+156>>2]|0;k=0;do{f[l+(k<<2)>>2]=k;k=k+1|0}while((k|0)!=(q|0))}k=f[2405]|0;_=(f[k+16>>2]|0)+-1|0;f[k+16>>2]=_;if(_|0){u=Y;return 0.0}do if(f[k+4>>2]|0){gb(Y|0,0)|0;_=f[6471]|0;n[k+8>>2]=+n[k+8>>2]+ +(((f[Y+4>>2]|0)-(f[_+4>>2]|0)+(((f[Y>>2]|0)-(f[_>>2]|0)|0)*1e6|0)-(f[k+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[k+16>>2]|0)){k=f[2405]|0;break}else{u=Y;return 0.0}}while(0);f[2405]=f[k+20>>2];u=Y;return 0.0}function wc(a){a=a|0;var c=0,d=0,e=0.0,g=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0;J=u;u=u+64|0;if(!(b[a+356>>0]|0)){a=b[a+312>>0]|0;a=a<<24>>24!=0;u=J;return a|0}f[a+336>>2]=0;f[a+336+4>>2]=0;f[a+336+8>>2]=0;f[a+336+12>>2]=0;b[a+336+16>>0]=0;o=b[a+332>>0]|0;b[a+332>>0]=o&-16;b[a+356>>0]=0;switch(f[a>>2]|0){case 0:{b[a+312>>0]=0;a=0;a=a<<24>>24!=0;u=J;return a|0}case 1:{f[a+244>>2]=f[a+84>>2];f[a+244+4>>2]=f[a+84+4>>2];f[a+244+8>>2]=f[a+84+8>>2];f[a+244+12>>2]=f[a+84+12>>2];f[a+260>>2]=f[a+164>>2];f[a+260+4>>2]=f[a+164+4>>2];f[a+260+8>>2]=f[a+164+8>>2];f[a+260+12>>2]=f[a+164+12>>2];F=+n[a+248>>2]-+n[a+264>>2];G=+n[a+252>>2]-+n[a+268>>2];n[a+276>>2]=+n[a+244>>2]-+n[a+260>>2];n[a+280>>2]=F;n[a+284>>2]=G;n[a+288>>2]=0.0;b[a+352>>0]=0;b[a+332>>0]=o&-16;n[a+336>>2]=1.0;n[a+340>>2]=0.0;n[a+344>>2]=0.0;n[a+348>>2]=0.0;b[a+312>>0]=1;a=1;a=a<<24>>24!=0;u=J;return a|0}case 2:{e=+n[a+4>>2];h=+n[a+8>>2];i=+n[a+12>>2];j=+n[a+20>>2]-e;k=+n[a+24>>2]-h;l=+n[a+28>>2]-i;if((0.0-e)*j+(0.0-h)*k+(0.0-i)*l>0.0)if((0.0-e)*j+(0.0-h)*k+(0.0-i)*l<j*j+k*k+l*l){b[a+332>>0]=o&-16|1;d=2;c=o&-16|1;h=((0.0-e)*j+(0.0-h)*k+(0.0-i)*l)/(j*j+k*k+l*l)}else{d=2;c=o&-16;h=1.0}else{d=1;c=o&-16;h=0.0}d=c|d;b[a+332>>0]=d;e=1.0-h;n[a+336>>2]=e;n[a+340>>2]=h;n[a+344>>2]=0.0;n[a+348>>2]=0.0;B=+n[a+84>>2];D=+n[a+88>>2];F=+n[a+92>>2];B=B+h*(+n[a+100>>2]-B);D=D+h*(+n[a+104>>2]-D);F=F+h*(+n[a+108>>2]-F);n[a+244>>2]=B;n[a+248>>2]=D;n[a+252>>2]=F;n[a+256>>2]=0.0;C=+n[a+164>>2];E=+n[a+168>>2];G=+n[a+172>>2];C=C+h*(+n[a+180>>2]-C);E=E+h*(+n[a+184>>2]-E);G=G+h*(+n[a+188>>2]-G);n[a+260>>2]=C;n[a+264>>2]=E;n[a+268>>2]=G;n[a+272>>2]=0.0;n[a+276>>2]=B-C;n[a+280>>2]=D-E;n[a+284>>2]=F-G;n[a+288>>2]=0.0;if(!(d&2)){f[a>>2]=1;c=0}else c=1;if(!(d&1)){I=a+164+(c<<4)|0;H=a+84+(c<<4)|0;q=a+4+(c<<4)|0;f[a>>2]=c;f[a+4>>2]=f[q>>2];f[a+4+4>>2]=f[q+4>>2];f[a+4+8>>2]=f[q+8>>2];f[a+4+12>>2]=f[q+12>>2];f[a+84>>2]=f[H>>2];f[a+84+4>>2]=f[H+4>>2];f[a+84+8>>2]=f[H+8>>2];f[a+84+12>>2]=f[H+12>>2];f[a+164>>2]=f[I>>2];f[a+164+4>>2]=f[I+4>>2];f[a+164+8>>2]=f[I+8>>2];f[a+164+12>>2]=f[I+12>>2]}I=h>=0.0&e>=0.0&1;b[a+312>>0]=I;a=I;a=a<<24>>24!=0;u=J;return a|0}case 3:{f[J+16>>2]=0;f[J+16+4>>2]=0;f[J+16+8>>2]=0;f[J+16+12>>2]=0;cf(J+16|0,a+4|0,a+20|0,a+36|0,a+316|0);G=+n[a+336>>2];e=+n[a+340>>2];h=+n[a+344>>2];B=+n[a+84>>2]*G+ +n[a+100>>2]*e+ +n[a+116>>2]*h;D=G*+n[a+88>>2]+e*+n[a+104>>2]+h*+n[a+120>>2];F=G*+n[a+92>>2]+e*+n[a+108>>2]+h*+n[a+124>>2];n[a+244>>2]=B;n[a+248>>2]=D;n[a+252>>2]=F;n[a+256>>2]=0.0;C=+n[a+164>>2]*G+ +n[a+180>>2]*e+ +n[a+196>>2]*h;E=G*+n[a+168>>2]+e*+n[a+184>>2]+h*+n[a+200>>2];G=G*+n[a+172>>2]+e*+n[a+188>>2]+h*+n[a+204>>2];n[a+260>>2]=C;n[a+264>>2]=E;n[a+268>>2]=G;n[a+272>>2]=0.0;n[a+276>>2]=B-C;n[a+280>>2]=D-E;n[a+284>>2]=F-G;n[a+288>>2]=0.0;d=f[a>>2]|0;do if((d|0)>3){c=b[a+332>>0]|0;if(!(c&8)){g=a+164+(d+-1<<4)|0;I=a+84+(d+-1<<4)|0;H=a+4+(d+-1<<4)|0;f[a>>2]=d+-1;f[a+52>>2]=f[H>>2];f[a+52+4>>2]=f[H+4>>2];f[a+52+8>>2]=f[H+8>>2];f[a+52+12>>2]=f[H+12>>2];f[a+132>>2]=f[I>>2];f[a+132+4>>2]=f[I+4>>2];f[a+132+8>>2]=f[I+8>>2];f[a+132+12>>2]=f[I+12>>2];f[a+212>>2]=f[g>>2];f[a+212+4>>2]=f[g+4>>2];f[a+212+8>>2]=f[g+8>>2];f[a+212+12>>2]=f[g+12>>2];g=d+-1|0;I=19}else{g=d;I=19}}else{if((d|0)==3){c=b[a+332>>0]|0;g=3;I=19;break}if((d|0)>1){c=b[a+332>>0]|0;d=2;I=23;break}if((d|0)==1){m=b[a+332>>0]|0;g=1;I=27}}while(0);if((I|0)==19){d=g+-1|0;if(!(c&4)){f[a>>2]=d;f[a+36>>2]=f[a+4+(d<<4)>>2];f[a+36+4>>2]=f[a+4+(d<<4)+4>>2];f[a+36+8>>2]=f[a+4+(d<<4)+8>>2];f[a+36+12>>2]=f[a+4+(d<<4)+12>>2];f[a+116>>2]=f[a+84+(d<<4)>>2];f[a+116+4>>2]=f[a+84+(d<<4)+4>>2];f[a+116+8>>2]=f[a+84+(d<<4)+8>>2];f[a+116+12>>2]=f[a+84+(d<<4)+12>>2];f[a+196>>2]=f[a+164+(d<<4)>>2];f[a+196+4>>2]=f[a+164+(d<<4)+4>>2];f[a+196+8>>2]=f[a+164+(d<<4)+8>>2];f[a+196+12>>2]=f[a+164+(d<<4)+12>>2];I=23}else{d=g;I=23}}if((I|0)==23){g=d+-1|0;if(!(c&2)){f[a>>2]=g;f[a+20>>2]=f[a+4+(g<<4)>>2];f[a+20+4>>2]=f[a+4+(g<<4)+4>>2];f[a+20+8>>2]=f[a+4+(g<<4)+8>>2];f[a+20+12>>2]=f[a+4+(g<<4)+12>>2];f[a+100>>2]=f[a+84+(g<<4)>>2];f[a+100+4>>2]=f[a+84+(g<<4)+4>>2];f[a+100+8>>2]=f[a+84+(g<<4)+8>>2];f[a+100+12>>2]=f[a+84+(g<<4)+12>>2];f[a+180>>2]=f[a+164+(g<<4)>>2];f[a+180+4>>2]=f[a+164+(g<<4)+4>>2];f[a+180+8>>2]=f[a+164+(g<<4)+8>>2];f[a+180+12>>2]=f[a+164+(g<<4)+12>>2];m=c;I=27}else{m=c;g=d;I=27}}if((I|0)==27?(p=g+-1|0,(m&1)==0):0){f[a>>2]=p;f[a+4>>2]=f[a+4+(p<<4)>>2];f[a+4+4>>2]=f[a+4+(p<<4)+4>>2];f[a+4+8>>2]=f[a+4+(p<<4)+8>>2];f[a+4+12>>2]=f[a+4+(p<<4)+12>>2];f[a+84>>2]=f[a+84+(p<<4)>>2];f[a+84+4>>2]=f[a+84+(p<<4)+4>>2];f[a+84+8>>2]=f[a+84+(p<<4)+8>>2];f[a+84+12>>2]=f[a+84+(p<<4)+12>>2];f[a+164>>2]=f[a+164+(p<<4)>>2];f[a+164+4>>2]=f[a+164+(p<<4)+4>>2];f[a+164+8>>2]=f[a+164+(p<<4)+8>>2];f[a+164+12>>2]=f[a+164+(p<<4)+12>>2]}if((e>=0.0?!(+n[a+336>>2]>=0.0):1)|!(h>=0.0))c=0;else c=+n[a+348>>2]>=0.0&1;b[a+312>>0]=c;a=c;a=a<<24>>24!=0;u=J;return a|0}case 4:{f[J>>2]=0;f[J+4>>2]=0;f[J+8>>2]=0;f[J+12>>2]=0;q=J+16+16|0;b[q>>0]=0;f[a+316>>2]=0;f[a+316+4>>2]=0;f[a+316+8>>2]=0;f[a+316+12>>2]=0;b[a+332>>0]=o|15;L=+n[a+20>>2];U=+n[a+4>>2];R=+n[a+24>>2];K=+n[a+8>>2];N=+n[a+28>>2];V=+n[a+12>>2];Q=+n[a+36>>2];S=+n[a+40>>2];O=+n[a+44>>2];M=+n[a+52>>2];T=+n[a+56>>2];P=+n[a+60>>2];W=((R-K)*(O-V)-(N-V)*(S-K))*(M-U)+((N-V)*(Q-U)-(L-U)*(O-V))*(T-K)+((L-U)*(S-K)-(R-K)*(Q-U))*(P-V);g=W*W<9.99999905104687e-09?-1:((0.0-U)*((R-K)*(O-V)-(N-V)*(S-K))+(0.0-K)*((N-V)*(Q-U)-(L-U)*(O-V))+((L-U)*(S-K)-(R-K)*(Q-U))*(0.0-V))*W<0.0&1;W=(N-V)*((Q-U)*(T-K)-(S-K)*(M-U))+((L-U)*((S-K)*(P-V)-(O-V)*(T-K))+(R-K)*((O-V)*(M-U)-(Q-U)*(P-V)));m=W*W<9.99999905104687e-09?-1:((0.0-V)*((Q-U)*(T-K)-(S-K)*(M-U))+((0.0-U)*((S-K)*(P-V)-(O-V)*(T-K))+(0.0-K)*((O-V)*(M-U)-(Q-U)*(P-V))))*W<0.0&1;W=(O-V)*((R-K)*(M-U)-(L-U)*(T-K))+((Q-U)*((N-V)*(T-K)-(R-K)*(P-V))+(S-K)*((L-U)*(P-V)-(N-V)*(M-U)));o=W*W<9.99999905104687e-09?-1:((0.0-V)*((R-K)*(M-U)-(L-U)*(T-K))+((0.0-U)*((N-V)*(T-K)-(R-K)*(P-V))+(0.0-K)*((L-U)*(P-V)-(N-V)*(M-U))))*W<0.0&1;K=(V-N)*((S-R)*(M-L)-(Q-L)*(T-R))+((U-L)*((O-N)*(T-R)-(S-R)*(P-N))+(K-R)*((Q-L)*(P-N)-(O-N)*(M-L)));p=K*K<9.99999905104687e-09?-1:((0.0-N)*((S-R)*(M-L)-(Q-L)*(T-R))+((0.0-L)*((O-N)*(T-R)-(S-R)*(P-N))+(0.0-R)*((Q-L)*(P-N)-(O-N)*(M-L))))*K<0.0&1;do if((m|g|o|p|0)<0){b[a+352>>0]=1;c=a+312|0;I=68}else{if(!(m|g|o|p)){if(b[a+352>>0]|0){c=a+312|0;I=68;break}b[a+312>>0]=1;f[a+276>>2]=0;f[a+276+4>>2]=0;f[a+276+8>>2]=0;f[a+276+12>>2]=0;c=1;break}if((g|0)!=0?(cf(J,a+4|0,a+20|0,a+36|0,J+16|0),e=+n[J+16>>2],h=+n[J+16+4>>2],i=+n[J+16+8>>2],j=e-+n[J>>2],k=h-+n[J+4>>2],l=i-+n[J+8>>2],j*j+k*k+l*l<3402823466385288598117041.0e14):0){X=f[J+16+12>>2]|0;n[a+316>>2]=e;n[a+320>>2]=h;n[a+324>>2]=i;f[a+328>>2]=X;X=b[q>>0]|0;b[a+332>>0]=X&1|b[a+332>>0]&-16|X&2|X&4;X=f[J+16+24>>2]|0;g=f[J+16+28>>2]|0;f[a+336>>2]=f[J+16+20>>2];f[a+340>>2]=X;f[a+344>>2]=g;n[a+348>>2]=0.0;e=j*j+k*k+l*l}else e=3402823466385288598117041.0e14;if((m|0)!=0?(cf(J,a+4|0,a+36|0,a+52|0,J+16|0),r=+n[J+16>>2],s=+n[J+16+4>>2],t=+n[J+16+8>>2],v=r-+n[J>>2],w=s-+n[J+4>>2],x=t-+n[J+8>>2],v*v+w*w+x*x<e):0){m=f[J+16+12>>2]|0;n[a+316>>2]=r;n[a+320>>2]=s;n[a+324>>2]=t;f[a+328>>2]=m;m=b[q>>0]|0;b[a+332>>0]=m<<1&8|(m&1|b[a+332>>0]&-16|m<<1&4);m=f[J+16+24>>2]|0;X=f[J+16+28>>2]|0;f[a+336>>2]=f[J+16+20>>2];n[a+340>>2]=0.0;f[a+344>>2]=m;f[a+348>>2]=X;e=v*v+w*w+x*x}if((o|0)!=0?(cf(J,a+4|0,a+52|0,a+20|0,J+16|0),y=+n[J+16>>2],z=+n[J+16+4>>2],A=+n[J+16+8>>2],B=y-+n[J>>2],C=z-+n[J+4>>2],D=A-+n[J+8>>2],B*B+C*C+D*D<e):0){o=f[J+16+12>>2]|0;n[a+316>>2]=y;n[a+320>>2]=z;n[a+324>>2]=A;f[a+328>>2]=o;o=b[q>>0]|0;b[a+332>>0]=o<<2&8|(o&1|b[a+332>>0]&-16|(o&255)>>>1&2);o=f[J+16+28>>2]|0;X=f[J+16+24>>2]|0;f[a+336>>2]=f[J+16+20>>2];f[a+340>>2]=o;n[a+344>>2]=0.0;f[a+348>>2]=X;e=B*B+C*C+D*D}if(p|0?(cf(J,a+20|0,a+52|0,a+36|0,J+16|0),E=+n[J+16>>2],F=+n[J+16+4>>2],G=+n[J+16+8>>2],U=E-+n[J>>2],V=F-+n[J+4>>2],W=G-+n[J+8>>2],U*U+V*V+W*W<e):0){p=f[J+16+12>>2]|0;n[a+316>>2]=E;n[a+320>>2]=F;n[a+324>>2]=G;f[a+328>>2]=p;p=b[q>>0]|0;b[a+332>>0]=p&4|b[a+332>>0]&-16|p<<1&2|p<<2&8;p=f[J+16+20>>2]|0;q=f[J+16+28>>2]|0;X=f[J+16+24>>2]|0;n[a+336>>2]=0.0;f[a+340>>2]=p;f[a+344>>2]=q;f[a+348>>2]=X}P=+n[a+336>>2];Q=+n[a+340>>2];W=+n[a+344>>2];e=+n[a+348>>2];R=+n[a+84>>2]*P+ +n[a+100>>2]*Q+ +n[a+116>>2]*W+ +n[a+132>>2]*e;T=P*+n[a+88>>2]+Q*+n[a+104>>2]+W*+n[a+120>>2]+e*+n[a+136>>2];V=P*+n[a+92>>2]+Q*+n[a+108>>2]+W*+n[a+124>>2]+e*+n[a+140>>2];n[a+244>>2]=R;n[a+248>>2]=T;n[a+252>>2]=V;n[a+256>>2]=0.0;S=+n[a+164>>2]*P+ +n[a+180>>2]*Q+ +n[a+196>>2]*W+ +n[a+212>>2]*e;U=P*+n[a+168>>2]+Q*+n[a+184>>2]+W*+n[a+200>>2]+e*+n[a+216>>2];W=P*+n[a+172>>2]+Q*+n[a+188>>2]+W*+n[a+204>>2]+e*+n[a+220>>2];n[a+260>>2]=S;n[a+264>>2]=U;n[a+268>>2]=W;n[a+272>>2]=0.0;n[a+276>>2]=R-S;n[a+280>>2]=T-U;n[a+284>>2]=V-W;n[a+288>>2]=0.0;g=f[a>>2]|0;do if((g|0)>3){c=b[a+332>>0]|0;if(!(c&8)){I=a+164+(g+-1<<4)|0;X=a+84+(g+-1<<4)|0;q=a+4+(g+-1<<4)|0;f[a>>2]=g+-1;f[a+52>>2]=f[q>>2];f[a+52+4>>2]=f[q+4>>2];f[a+52+8>>2]=f[q+8>>2];f[a+52+12>>2]=f[q+12>>2];f[a+132>>2]=f[X>>2];f[a+132+4>>2]=f[X+4>>2];f[a+132+8>>2]=f[X+8>>2];f[a+132+12>>2]=f[X+12>>2];f[a+212>>2]=f[I>>2];f[a+212+4>>2]=f[I+4>>2];f[a+212+8>>2]=f[I+8>>2];f[a+212+12>>2]=f[I+12>>2];g=g+-1|0;I=52}else I=52}else{if((g|0)==3){c=b[a+332>>0]|0;g=3;I=52;break}if((g|0)>1){c=b[a+332>>0]|0;d=2;I=56;break}if((g|0)==1){c=b[a+332>>0]|0;d=1;I=60}}while(0);if((I|0)==52){d=g+-1|0;if(!(c&4)){f[a>>2]=d;f[a+36>>2]=f[a+4+(d<<4)>>2];f[a+36+4>>2]=f[a+4+(d<<4)+4>>2];f[a+36+8>>2]=f[a+4+(d<<4)+8>>2];f[a+36+12>>2]=f[a+4+(d<<4)+12>>2];f[a+116>>2]=f[a+84+(d<<4)>>2];f[a+116+4>>2]=f[a+84+(d<<4)+4>>2];f[a+116+8>>2]=f[a+84+(d<<4)+8>>2];f[a+116+12>>2]=f[a+84+(d<<4)+12>>2];f[a+196>>2]=f[a+164+(d<<4)>>2];f[a+196+4>>2]=f[a+164+(d<<4)+4>>2];f[a+196+8>>2]=f[a+164+(d<<4)+8>>2];f[a+196+12>>2]=f[a+164+(d<<4)+12>>2];I=56}else{d=g;I=56}}if((I|0)==56){g=d+-1|0;if(!(c&2)){f[a>>2]=g;f[a+20>>2]=f[a+4+(g<<4)>>2];f[a+20+4>>2]=f[a+4+(g<<4)+4>>2];f[a+20+8>>2]=f[a+4+(g<<4)+8>>2];f[a+20+12>>2]=f[a+4+(g<<4)+12>>2];f[a+100>>2]=f[a+84+(g<<4)>>2];f[a+100+4>>2]=f[a+84+(g<<4)+4>>2];f[a+100+8>>2]=f[a+84+(g<<4)+8>>2];f[a+100+12>>2]=f[a+84+(g<<4)+12>>2];f[a+180>>2]=f[a+164+(g<<4)>>2];f[a+180+4>>2]=f[a+164+(g<<4)+4>>2];f[a+180+8>>2]=f[a+164+(g<<4)+8>>2];f[a+180+12>>2]=f[a+164+(g<<4)+12>>2];d=g;I=60}else I=60}if((I|0)==60?(H=d+-1|0,(c&1)==0):0){f[a>>2]=H;f[a+4>>2]=f[a+4+(H<<4)>>2];f[a+4+4>>2]=f[a+4+(H<<4)+4>>2];f[a+4+8>>2]=f[a+4+(H<<4)+8>>2];f[a+4+12>>2]=f[a+4+(H<<4)+12>>2];f[a+84>>2]=f[a+84+(H<<4)>>2];f[a+84+4>>2]=f[a+84+(H<<4)+4>>2];f[a+84+8>>2]=f[a+84+(H<<4)+8>>2];f[a+84+12>>2]=f[a+84+(H<<4)+12>>2];f[a+164>>2]=f[a+164+(H<<4)>>2];f[a+164+4>>2]=f[a+164+(H<<4)+4>>2];f[a+164+8>>2]=f[a+164+(H<<4)+8>>2];f[a+164+12>>2]=f[a+164+(H<<4)+12>>2]}if((+n[a+336>>2]>=0.0?+n[a+340>>2]>=0.0:0)?+n[a+344>>2]>=0.0:0)c=e>=0.0&1;else c=0;b[a+312>>0]=c}while(0);if((I|0)==68){b[c>>0]=0;c=0}X=c;X=X<<24>>24!=0;u=J;return X|0}default:{b[a+312>>0]=0;X=0;X=X<<24>>24!=0;u=J;return X|0}}return 0}function xc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,M=0.0,P=0.0,R=0,S=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0;la=u;u=u+80|0;n[a+504>>2]=0.0;n[a+500>>2]=0.0;b[a+525>>0]=0;b[a+526>>0]=0;if(b[a+552>>0]|0?(b[a+527>>0]|0)==0:0){sa=+n[a+556>>2];qa=+n[a+560>>2];ka=+n[a+564>>2];pa=+n[a+568>>2];$=sa*(2.0/(sa*sa+qa*qa+ka*ka+pa*pa));ra=qa*(2.0/(sa*sa+qa*qa+ka*ka+pa*pa));oa=ka*(2.0/(sa*sa+qa*qa+ka*ka+pa*pa));aa=+n[a+300>>2];P=+n[c>>2];ba=+n[a+316>>2];S=+n[c+4>>2];ca=+n[a+332>>2];U=+n[c+8>>2];ea=+n[a+304>>2];ga=+n[a+320>>2];ia=+n[a+336>>2];Y=+n[a+308>>2];Z=+n[a+324>>2];_=+n[a+340>>2];V=+n[c+16>>2];W=+n[c+20>>2];X=+n[c+24>>2];fa=+n[c+32>>2];ha=+n[c+36>>2];ja=+n[c+40>>2];p=+n[a+348>>2];o=+n[a+352>>2];m=+n[a+356>>2];t=+n[a+364>>2];na=+n[d>>2];v=+n[a+380>>2];ma=+n[d+4>>2];w=+n[a+396>>2];j=+n[d+8>>2];x=+n[a+368>>2];y=+n[a+384>>2];z=+n[a+400>>2];q=+n[a+372>>2];r=+n[a+388>>2];s=+n[a+404>>2];k=+n[d+16>>2];l=+n[d+20>>2];i=+n[d+24>>2];A=+n[d+32>>2];C=+n[d+36>>2];E=+n[d+40>>2];B=+n[a+412>>2];D=+n[a+416>>2];h=+n[a+420>>2];G=(1.0-(qa*ra+ka*oa))*(t*na+v*ma+w*j)+(sa*ra+pa*oa)*(na*x+ma*y+j*z)+(sa*oa-pa*ra)*(na*q+ma*r+j*s);H=(sa*ra-pa*oa)*(t*na+v*ma+w*j)+(1.0-(sa*$+ka*oa))*(na*x+ma*y+j*z)+(qa*oa+pa*$)*(na*q+ma*r+j*s);F=(sa*oa+pa*ra)*(t*na+v*ma+w*j)+(qa*oa-pa*$)*(na*x+ma*y+j*z)+(1.0-(sa*$+qa*ra))*(na*q+ma*r+j*s);J=(sa*oa-pa*ra)*(q*k+r*l+s*i)+((1.0-(qa*ra+ka*oa))*(t*k+v*l+w*i)+(sa*ra+pa*oa)*(x*k+y*l+z*i));M=(qa*oa+pa*$)*(q*k+r*l+s*i)+((sa*ra-pa*oa)*(t*k+v*l+w*i)+(1.0-(sa*$+ka*oa))*(x*k+y*l+z*i));I=(1.0-(sa*$+qa*ra))*(q*k+r*l+s*i)+((sa*oa+pa*ra)*(t*k+v*l+w*i)+(qa*oa-pa*$)*(x*k+y*l+z*i));da=(sa*oa-pa*ra)*(q*A+r*C+s*E)+((1.0-(qa*ra+ka*oa))*(t*A+v*C+w*E)+(sa*ra+pa*oa)*(x*A+y*C+z*E));ka=(qa*oa+pa*$)*(q*A+r*C+s*E)+((sa*ra-pa*oa)*(t*A+v*C+w*E)+(1.0-(sa*$+ka*oa))*(x*A+y*C+z*E));$=(1.0-(sa*$+qa*ra))*(q*A+r*C+s*E)+((sa*oa+pa*ra)*(t*A+v*C+w*E)+(qa*oa-pa*$)*(x*A+y*C+z*E));pa=-(+n[c+48>>2]+(P*p+S*o+U*m));oa=-(V*p+W*o+X*m+ +n[c+52>>2]);m=-(fa*p+ha*o+ja*m+ +n[c+56>>2]);o=(aa*P+ba*S+ca*U)*pa+(aa*V+ba*W+ca*X)*oa+(aa*fa+ba*ha+ca*ja)*m;p=(P*ea+S*ga+U*ia)*pa+(ea*V+ga*W+ia*X)*oa+(ea*fa+ga*ha+ia*ja)*m;m=(P*Y+S*Z+U*_)*pa+(Y*V+Z*W+_*X)*oa+(Y*fa+Z*ha+_*ja)*m;j=m*F+(o*G+p*H)+((t*na+v*ma+w*j)*0.0+(na*x+ma*y+j*z)*0.0+(na*q+ma*r+j*s)*0.0+(+n[d+48>>2]+(na*B+ma*D+j*h)));i=m*I+(o*J+p*M)+((q*k+r*l+s*i)*0.0+((t*k+v*l+w*i)*0.0+(x*k+y*l+z*i)*0.0)+(k*B+l*D+i*h+ +n[d+52>>2]));h=m*$+(o*da+p*ka)+((q*A+r*C+s*E)*0.0+((t*A+v*C+w*E)*0.0+(x*A+y*C+z*E)*0.0)+(A*B+C*D+E*h+ +n[d+56>>2]));n[la+16>>2]=(P*Y+S*Z+U*_)*F+((aa*P+ba*S+ca*U)*G+(P*ea+S*ga+U*ia)*H);n[la+16+4>>2]=(Y*V+Z*W+_*X)*F+((aa*V+ba*W+ca*X)*G+(ea*V+ga*W+ia*X)*H);n[la+16+8>>2]=(Y*fa+Z*ha+_*ja)*F+((aa*fa+ba*ha+ca*ja)*G+(ea*fa+ga*ha+ia*ja)*H);n[la+16+12>>2]=0.0;n[la+16+16>>2]=(P*Y+S*Z+U*_)*I+((aa*P+ba*S+ca*U)*J+(P*ea+S*ga+U*ia)*M);n[la+16+20>>2]=(Y*V+Z*W+_*X)*I+((aa*V+ba*W+ca*X)*J+(ea*V+ga*W+ia*X)*M);n[la+16+24>>2]=(Y*fa+Z*ha+_*ja)*I+((aa*fa+ba*ha+ca*ja)*J+(ea*fa+ga*ha+ia*ja)*M);n[la+16+28>>2]=0.0;n[la+16+32>>2]=(P*Y+S*Z+U*_)*$+((aa*P+ba*S+ca*U)*da+(P*ea+S*ga+U*ia)*ka);n[la+16+36>>2]=(Y*V+Z*W+_*X)*$+((aa*V+ba*W+ca*X)*da+(ea*V+ga*W+ia*X)*ka);n[la+16+40>>2]=(Y*fa+Z*ha+_*ja)*$+((aa*fa+ba*ha+ca*ja)*da+(ea*fa+ga*ha+ia*ja)*ka);n[la+16+44>>2]=0.0;n[la+16+48>>2]=j;n[la+16+52>>2]=i;n[la+16+56>>2]=h;n[la+16+60>>2]=0.0;mh(la+16|0,la);h=+n[la>>2];i=+n[la+4>>2];j=+n[la+8>>2];if(!(+K(+(h*h+i*i+j*j))<1.1920928955078125e-07)?(n[a+472>>2]=0.0,sa=1.0/+L(+(h*h+i*i+j*j)),n[a+460>>2]=sa*h,n[a+464>>2]=sa*i,n[a+468>>2]=sa*j,sa=+n[la+12>>2],sa=sa<-1.0?-1.0:sa,sa=+Q(+(sa>1.0?1.0:sa))*2.0,n[a+504>>2]=sa,!(+K(+sa)<1.1920928955078125e-07)):0)b[a+526>>0]=1;u=la;return}mh(c,la+16|0);mh(a+300|0,la);U=+n[la+16+12>>2];V=+n[la>>2];W=+n[la+16>>2];X=+n[la+12>>2];Y=+n[la+16+4>>2];Z=+n[la+8>>2];_=+n[la+16+8>>2];$=+n[la+4>>2];mh(d,la+16|0);mh(a+364|0,la);aa=+n[la+16+12>>2];ba=+n[la>>2];ca=+n[la+16>>2];da=+n[la+12>>2];ea=+n[la+16+4>>2];fa=+n[la+8>>2];ga=+n[la+16+8>>2];ha=+n[la+4>>2];ia=-(aa*ba+ca*da+ea*fa-ga*ha);ja=-(ba*ga+(da*ea+aa*ha)-ca*fa);ka=-(aa*fa+da*ga+ca*ha-ba*ea);o=(U*X-V*W-Y*$-Z*_)*ia+(U*V+W*X+Y*Z-_*$)*(aa*da-ba*ca-ea*ha-fa*ga)+(U*Z+X*_+W*$-V*Y)*ja-(V*_+(X*Y+U*$)-W*Z)*ka;p=(U*V+W*X+Y*Z-_*$)*ka+((V*_+(X*Y+U*$)-W*Z)*(aa*da-ba*ca-ea*ha-fa*ga)+(U*X-V*W-Y*$-Z*_)*ja)-(U*Z+X*_+W*$-V*Y)*ia;q=(V*_+(X*Y+U*$)-W*Z)*ia+((U*Z+X*_+W*$-V*Y)*(aa*da-ba*ca-ea*ha-fa*ga)+(U*X-V*W-Y*$-Z*_)*ka)-(U*V+W*X+Y*Z-_*$)*ja;r=(U*X-V*W-Y*$-Z*_)*(aa*da-ba*ca-ea*ha-fa*ga)-(U*V+W*X+Y*Z-_*$)*ia-(V*_+(X*Y+U*$)-W*Z)*ja-(U*Z+X*_+W*$-V*Y)*ka;h=-o-p*0.0-q*0.0;i=(q+r*0.0-o*0.0)*-q+(r*(r+p*0.0-q*0.0)+h*-o)-(r*0.0+o*0.0-p)*-p;j=(r*0.0+o*0.0-p)*-o+(r*(q+r*0.0-o*0.0)+h*-p)-(r+p*0.0-q*0.0)*-q;h=(r+p*0.0-q*0.0)*-p+(r*(r*0.0+o*0.0-p)+h*-q)-(q+r*0.0-o*0.0)*-o;k=1.0/+L(+(h*h+(i*i+j*j)));if(k*h*0.0+(k*j*0.0+k*i)<-.9999998807907104){m=1.0;l=-0.0;h=0.0;i=0.0}else{sa=+L(+((k*h*0.0+(k*j*0.0+k*i)+1.0)*2.0));m=(k*i*0.0-k*h)*(1.0/sa);l=(k*h*0.0-k*j*0.0)*(1.0/sa);h=(k*j-k*i*0.0)*(1.0/sa);i=sa*.5}k=1.0/+L(+(l*l+m*m+h*h+i*i));s=l*k;w=m*k;v=h*k;k=i*k;S=1.0/+L(+((r*k-o*-s-p*-w-q*-v)*(r*k-o*-s-p*-w-q*-v)+((p*-s+(q*k+r*-v)-o*-w)*(p*-s+(q*k+r*-v)-o*-w)+((q*-w+(o*k+r*-s)-p*-v)*(q*-w+(o*k+r*-s)-p*-v)+(o*-v+(r*-w+p*k)-q*-s)*(o*-v+(r*-w+p*k)-q*-s)))));j=S*(q*-w+(o*k+r*-s)-p*-v);l=S*(o*-v+(r*-w+p*k)-q*-s);i=S*(p*-s+(q*k+r*-v)-o*-w);S=S*(r*k-o*-s-p*-w-q*-v);t=+n[a+444>>2];h=+n[a+456>>2];if(t>=h?(x=+n[a+448>>2],x>=h):0){r=k<-1.0?-1.0:k;r=+Q(+(r>1.0?1.0:r))*2.0;if(r>1.1920928955078125e-07){o=1.0/+L(+(v*v+(s*s+w*w)));if(+K(+(w*o))>1.1920928955078125e-07){m=s*o;k=v*o;h=w*o;p=+L(+((v*o*v*o/(w*o*w*o)+1.0)/(1.0/(x*x)+v*o*v*o/(w*o*w*o)/(t*t))))}else{m=s*o;k=v*o;h=w*o;p=t}}else{m=0.0;k=0.0;h=0.0;p=0.0}o=+n[a+428>>2];q=p*o;if(r>q){b[a+526>>0]=1;if(r<p&o<.9999998807907104)o=(r-q)/(p-q);else o=1.0;n[a+528>>2]=o;n[a+504>>2]=r-q;if(+K(+h)>1.1920928955078125e-07){sa=+K(+(h*-k/h*(x/t)));k=k<-0.0?sa:-sa;sa=1.0/+L(+(m*m+h*h+k*k));m=m*sa;k=-(sa*k);h=h*sa}ra=-m;qa=-h;oa=-k;na=(aa*da-ba*ca-ea*ha-fa*ga)*ra+(ba*ga+(da*ea+aa*ha)-ca*fa)*oa-(aa*fa+da*ga+ca*ha-ba*ea)*qa;sa=(aa*fa+da*ga+ca*ha-ba*ea)*ra+(aa*da-ba*ca-ea*ha-fa*ga)*qa-(aa*ba+ca*da+ea*fa-ga*ha)*oa;pa=(aa*ba+ca*da+ea*fa-ga*ha)*qa+(aa*da-ba*ca-ea*ha-fa*ga)*oa-(ba*ga+(da*ea+aa*ha)-ca*fa)*ra;oa=-((aa*ba+ca*da+ea*fa-ga*ha)*ra)-(ba*ga+(da*ea+aa*ha)-ca*fa)*qa-(aa*fa+da*ga+ca*ha-ba*ea)*oa;qa=sa*ka+(oa*ia+(aa*da-ba*ca-ea*ha-fa*ga)*na)-pa*ja;ra=pa*ia+((aa*da-ba*ca-ea*ha-fa*ga)*sa+oa*ja)-na*ka;sa=na*ja+(oa*ka+(aa*da-ba*ca-ea*ha-fa*ga)*pa)-sa*ia;n[a+460>>2]=qa;n[a+464>>2]=ra;n[a+468>>2]=sa;n[a+472>>2]=0.0;f[a+536>>2]=0;f[a+536+4>>2]=0;f[a+536+8>>2]=0;f[a+536+12>>2]=0;n[a+492>>2]=1.0/(qa*(+n[e>>2]*qa+ +n[e+16>>2]*ra+ +n[e+32>>2]*sa)+ra*(qa*+n[e+4>>2]+ra*+n[e+20>>2]+sa*+n[e+36>>2])+sa*(qa*+n[e+8>>2]+ra*+n[e+24>>2]+sa*+n[e+40>>2])+(qa*(qa*+n[g>>2]+ra*+n[g+16>>2]+sa*+n[g+32>>2])+ra*(qa*+n[g+4>>2]+ra*+n[g+20>>2]+sa*+n[g+36>>2])+sa*(qa*+n[g+8>>2]+ra*+n[g+24>>2]+sa*+n[g+40>>2])))}}else R=20;a:do if((R|0)==20){B=+n[a+300>>2];C=+n[a+316>>2];D=+n[a+332>>2];E=+n[c>>2];F=+n[c+4>>2];G=+n[c+8>>2];H=+n[c+16>>2];I=+n[c+20>>2];J=+n[c+24>>2];M=+n[c+32>>2];P=+n[c+36>>2];r=+n[c+40>>2];s=+n[a+304>>2];t=+n[a+320>>2];v=+n[a+336>>2];w=+n[a+308>>2];x=+n[a+324>>2];y=+n[a+340>>2];o=+n[a+364>>2];h=+n[a+380>>2];q=+n[a+396>>2];z=o*+n[d>>2]+h*+n[d+4>>2]+q*+n[d+8>>2];A=o*+n[d+16>>2]+h*+n[d+20>>2]+q*+n[d+24>>2];q=o*+n[d+32>>2]+h*+n[d+36>>2]+q*+n[d+40>>2];h=(B*E+C*F+D*G)*z+(B*H+C*I+D*J)*A+(B*M+C*P+D*r)*q;o=(E*s+F*t+G*v)*z+(H*s+I*t+J*v)*A+(M*s+P*t+r*v)*q;m=(E*w+F*x+G*y)*z+(H*w+I*x+J*y)*A+(M*w+P*x+r*y)*q;p=+n[a+444>>2];k=+n[a+456>>2];do if(p<k){p=+n[a+448>>2];if(p<k){if(+K(+o)<1.1920928955078125e-07&+K(+m)<1.1920928955078125e-07)break a;b[a+526>>0]=1;n[a+460>>2]=-((B*M+C*P+D*r)*A-(B*H+C*I+D*J)*q);n[a+464>>2]=-((B*E+C*F+D*G)*q-(B*M+C*P+D*r)*z);n[a+468>>2]=-((B*H+C*I+D*J)*z-(B*E+C*F+D*G)*A);n[a+472>>2]=0.0;break a}if(!(+K(+h)<1.1920928955078125e-07&+K(+m)<1.1920928955078125e-07)?(b[a+526>>0]=1,p>=k):0){k=+T(+m,+h);if(k>p){m=+O(+p);k=0.0;h=+N(+p);break}if(k<-p){m=-+O(+p);k=0.0;h=+N(+p)}else k=0.0}else k=o}else if(!(+K(+h)<1.1920928955078125e-07&+K(+o)<1.1920928955078125e-07)?(b[a+526>>0]=1,p>=k):0){k=+T(+o,+h);if(k>p){m=0.0;k=+O(+p);h=+N(+p);break}if(k<-p){m=0.0;k=-+O(+p);h=+N(+p)}else{m=0.0;k=o}}else k=o;while(0);ra=(E*w+F*x+G*y)*m+((E*s+F*t+G*v)*k+(B*E+C*F+D*G)*h);pa=(H*w+I*x+J*y)*m+((H*s+I*t+J*v)*k+(B*H+C*I+D*J)*h);oa=(M*w+P*x+r*y)*m+((M*s+P*t+r*v)*k+(B*M+C*P+D*r)*h);qa=1.0/+L(+(oa*oa+(ra*ra+pa*pa)));n[a+472>>2]=0.0;sa=+L(+((A*qa*oa-q*qa*pa)*(A*qa*oa-q*qa*pa)+(q*qa*ra-z*qa*oa)*(q*qa*ra-z*qa*oa)+(z*qa*pa-A*qa*ra)*(z*qa*pa-A*qa*ra)));n[a+504>>2]=sa;n[a+460>>2]=-((A*qa*oa-q*qa*pa)*(1.0/sa));n[a+464>>2]=-((q*qa*ra-z*qa*oa)*(1.0/sa));n[a+468>>2]=-((z*qa*pa-A*qa*ra)*(1.0/sa))}while(0);o=+n[a+452>>2];if(!(o>=0.0)){n[a+512>>2]=0.0;u=la;return}h=S<-1.0?-1.0:S;h=+Q(+(h>1.0?1.0:h))*2.0;if(h>3.1415927410125732){h=-S<-1.0?-1.0:-S;h=+Q(+(h>1.0?1.0:h))*2.0;j=-j;l=-l;i=-i}n[a+512>>2]=h;if(h>1.1920928955078125e-07){sa=1.0/+L(+(j*j+l*l+i*i));j=j*sa;i=i*sa;l=l*sa}k=+n[a+428>>2];if(h>o*k){b[a+525>>0]=1;m=h-o*k;if(h<o&k<.9999998807907104)h=m/(o-o*k);else h=1.0;n[a+532>>2]=h;n[a+508>>2]=m;ra=-j;qa=-l;oa=-i;na=(aa*da-ba*ca-ea*ha-fa*ga)*ra+(ba*ga+(da*ea+aa*ha)-ca*fa)*oa-(aa*fa+da*ga+ca*ha-ba*ea)*qa;sa=(aa*fa+da*ga+ca*ha-ba*ea)*ra+(aa*da-ba*ca-ea*ha-fa*ga)*qa-(aa*ba+ca*da+ea*fa-ga*ha)*oa;pa=(aa*ba+ca*da+ea*fa-ga*ha)*qa+(aa*da-ba*ca-ea*ha-fa*ga)*oa-(ba*ga+(da*ea+aa*ha)-ca*fa)*ra;oa=-((aa*ba+ca*da+ea*fa-ga*ha)*ra)-(ba*ga+(da*ea+aa*ha)-ca*fa)*qa-(aa*fa+da*ga+ca*ha-ba*ea)*oa;qa=sa*ka+(oa*ia+(aa*da-ba*ca-ea*ha-fa*ga)*na)-pa*ja;ra=pa*ia+((aa*da-ba*ca-ea*ha-fa*ga)*sa+oa*ja)-na*ka;sa=na*ja+(oa*ka+(aa*da-ba*ca-ea*ha-fa*ga)*pa)-sa*ia;n[a+476>>2]=qa;n[a+480>>2]=ra;n[a+484>>2]=sa;n[a+488>>2]=0.0;n[a+496>>2]=1.0/(qa*(+n[e>>2]*qa+ +n[e+16>>2]*ra+ +n[e+32>>2]*sa)+ra*(qa*+n[e+4>>2]+ra*+n[e+20>>2]+sa*+n[e+36>>2])+sa*(qa*+n[e+8>>2]+ra*+n[e+24>>2]+sa*+n[e+40>>2])+(qa*(qa*+n[g>>2]+ra*+n[g+16>>2]+sa*+n[g+32>>2])+ra*(qa*+n[g+4>>2]+ra*+n[g+20>>2]+sa*+n[g+36>>2])+sa*(qa*+n[g+8>>2]+ra*+n[g+24>>2]+sa*+n[g+40>>2])))}if(!(b[a+526>>0]|0)){u=la;return}na=-j;sa=-l;oa=-i;ma=(U*X-V*W-Y*$-Z*_)*na+(V*_+(X*Y+U*$)-W*Z)*oa-(U*Z+X*_+W*$-V*Y)*sa;ra=(U*Z+X*_+W*$-V*Y)*na+(U*X-V*W-Y*$-Z*_)*sa-(U*V+W*X+Y*Z-_*$)*oa;qa=(U*V+W*X+Y*Z-_*$)*sa+(U*X-V*W-Y*$-Z*_)*oa-(V*_+(X*Y+U*$)-W*Z)*na;oa=-((U*V+W*X+Y*Z-_*$)*na)-(V*_+(X*Y+U*$)-W*Z)*sa-(U*Z+X*_+W*$-V*Y)*oa;sa=-(U*V+W*X+Y*Z-_*$);na=-(V*_+(X*Y+U*$)-W*Z);pa=-(U*Z+X*_+W*$-V*Y);n[a+536>>2]=ra*pa+(oa*sa+(U*X-V*W-Y*$-Z*_)*ma)-qa*na;n[a+540>>2]=qa*sa+((U*X-V*W-Y*$-Z*_)*ra+oa*na)-ma*pa;n[a+544>>2]=ma*na+(oa*pa+(U*X-V*W-Y*$-Z*_)*qa)-ra*sa;n[a+548>>2]=0.0;u=la;return}function yc(a,c){a=a|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0,j=0.0,k=0,l=0,m=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0,qa=0;pa=f[a+28>>2]|0;qa=f[a+32>>2]|0;l=f[c+24>>2]|0;if(!(b[a+739>>0]|0)){y=+n[a+552>>2];S=+n[pa+4>>2];z=+n[a+568>>2];T=+n[pa+8>>2];A=+n[a+584>>2];U=+n[pa+12>>2];B=+n[a+556>>2];C=+n[a+572>>2];D=+n[a+588>>2];V=+n[a+560>>2];W=+n[a+576>>2];X=+n[a+592>>2];Y=+n[pa+20>>2];Z=+n[pa+24>>2];_=+n[pa+28>>2];$=+n[pa+36>>2];aa=+n[pa+40>>2];ba=+n[pa+44>>2];h=+n[a+600>>2];j=+n[a+604>>2];m=+n[a+608>>2];p=+n[pa+52>>2];t=+n[pa+56>>2];u=+n[pa+60>>2];E=+n[qa+4>>2];F=+n[qa+8>>2];G=+n[qa+12>>2];H=+n[a+624>>2];I=+n[a+640>>2];J=+n[a+656>>2];K=+n[qa+20>>2];M=+n[qa+24>>2];N=+n[qa+28>>2];O=+n[qa+36>>2];P=+n[qa+40>>2];Q=+n[qa+44>>2];na=+n[a+664>>2];oa=+n[a+668>>2];x=+n[a+672>>2];v=+n[qa+52>>2]+(E*na+F*oa+G*x);w=K*na+M*oa+N*x+ +n[qa+56>>2];x=O*na+P*oa+Q*x+ +n[qa+60>>2];k=(b[a+736>>0]|0)==0;if(k){i=f[c+8>>2]|0;n[i>>2]=1.0;n[i+(l+1<<2)>>2]=1.0;n[i+((l<<1)+2<<2)>>2]=1.0;i=f[c+16>>2]|0;n[i>>2]=-1.0;n[i+(l+1<<2)>>2]=-1.0;n[i+((l<<1)+2<<2)>>2]=-1.0;i=l<<1;d=+n[pa+52>>2];e=+n[pa+56>>2];g=+n[pa+60>>2]}else{i=l<<1;d=p;e=t;g=u}d=p+(S*h+T*j+U*m)-d;oa=Y*h+Z*j+_*m+t-e;na=$*h+aa*j+ba*m+u-g;o=f[c+12>>2]|0;s=o+(i<<2)|0;f[o>>2]=0;n[o+4>>2]=na;n[o+8>>2]=-oa;n[o+12>>2]=0.0;n[o+(l<<2)>>2]=-na;f[o+(l<<2)+4>>2]=0;n[o+(l<<2)+8>>2]=d;n[o+(l<<2)+12>>2]=0.0;n[s>>2]=oa;n[s+4>>2]=-d;f[s+8>>2]=0;n[s+12>>2]=0.0;d=v-+n[qa+52>>2];oa=w-+n[qa+56>>2];na=x-+n[qa+60>>2];s=f[c+20>>2]|0;i=s+(i<<2)|0;f[s>>2]=0;n[s+4>>2]=-na;n[s+8>>2]=oa;n[s+12>>2]=0.0;n[s+(l<<2)>>2]=na;f[s+(l<<2)+4>>2]=0;n[s+(l<<2)+8>>2]=-d;n[s+(l<<2)+12>>2]=0.0;n[i>>2]=-oa;n[i+4>>2]=d;f[i+8>>2]=0;n[i+12>>2]=0.0;d=+n[c>>2]*+n[c+4>>2];i=f[c+28>>2]|0;if(k){n[i>>2]=d*(v-(p+(S*h+T*j+U*m)));n[i+(l<<2)>>2]=d*(w-(Y*h+Z*j+_*m+t));n[i+(l<<1<<2)>>2]=d*(x-($*h+aa*j+ba*m+u))}R=f[c+24>>2]|0;n[o+(R*3<<2)>>2]=y*S+z*T+A*U;n[o+((R*3|0)+1<<2)>>2]=y*Y+z*Z+A*_;n[o+((R*3|0)+2<<2)>>2]=y*$+z*aa+A*ba;n[o+(R<<2<<2)>>2]=S*B+T*C+U*D;n[o+((R<<2|1)<<2)>>2]=B*Y+C*Z+D*_;n[o+((R<<2|2)<<2)>>2]=B*$+C*aa+D*ba;n[s+(R*3<<2)>>2]=-(y*S+z*T+A*U);n[s+((R*3|0)+1<<2)>>2]=-(y*Y+z*Z+A*_);n[s+((R*3|0)+2<<2)>>2]=-(y*$+z*aa+A*ba);n[s+(R<<2<<2)>>2]=-(S*B+T*C+U*D);n[s+((R<<2|1)<<2)>>2]=-(B*Y+C*Z+D*_);n[s+((R<<2|2)<<2)>>2]=-(B*$+C*aa+D*ba);na=(V*Y+W*Z+X*_)*(H*O+I*P+J*Q)-(V*$+W*aa+X*ba)*(H*K+I*M+J*N);oa=(V*$+W*aa+X*ba)*(E*H+F*I+G*J)-(S*V+T*W+U*X)*(H*O+I*P+J*Q);ma=(S*V+T*W+U*X)*(H*K+I*M+J*N)-(V*Y+W*Z+X*_)*(E*H+F*I+G*J);n[i+(R*3<<2)>>2]=((y*$+z*aa+A*ba)*ma+((y*S+z*T+A*U)*na+(y*Y+z*Z+A*_)*oa))*d;n[i+(R<<2<<2)>>2]=((B*$+C*aa+D*ba)*ma+((S*B+T*C+U*D)*na+(B*Y+C*Z+D*_)*oa))*d;if(!(b[a+716>>0]|0)){p=0.0;r=0}else{oa=+n[a+708>>2]*+n[a+732>>2];p=oa;r=oa>0.0?1:2}l=b[a+737>>0]|0;q=(r|0)!=0;if(!(r|l&255))return;n[o+(R*5<<2)>>2]=S*V+T*W+U*X;n[o+((R*5|0)+1<<2)>>2]=V*Y+W*Z+X*_;n[o+((R*5|0)+2<<2)>>2]=V*$+W*aa+X*ba;n[s+(R*5<<2)>>2]=-(S*V+T*W+U*X);n[s+((R*5|0)+1<<2)>>2]=-(V*Y+W*Z+X*_);n[s+((R*5|0)+2<<2)>>2]=-(V*$+W*aa+X*ba);e=+n[a+688>>2];g=+n[a+692>>2];d=+lh(e-g,6.2831854820251465);if(!(d<-3.1415927410125732))if(d>3.1415927410125732)m=d+-6.2831854820251465;else m=d;else m=d+6.2831854820251465;d=+lh(e+g,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;k=m==d;o=i+(R*5<<2)|0;n[o>>2]=0.0;i=f[a+748>>2]|0;j=+n[(i&2|0?a+760|0:c+4|0)>>2];if(!(l<<24>>24==0|q&k)){if(i&4|0)f[(f[c+32>>2]|0)+(R*5<<2)>>2]=f[a+752>>2];g=+n[a+728>>2];h=+n[a+680>>2];e=m>d?1.0:0.0;do if(!(m>=d)){e=h/(j*+n[c>>2]);if(e<0.0)if(g>=m&m-e>g){d=(m-g)/e;break}else{d=g<m?0.0:1.0;break}if(e>0.0)if(g<=d&d-e<g){d=(d-g)/e;break}else{d=g>d?0.0:1.0;break}else d=0.0}else d=e;while(0);n[o>>2]=d*h*+n[a+732>>2]+ +n[o>>2];n[(f[c+36>>2]|0)+(R*5<<2)>>2]=-+n[a+684>>2];f[(f[c+40>>2]|0)+(R*5<<2)>>2]=f[a+684>>2]}if(!q)return;n[o>>2]=+n[o>>2]+p*j*+n[c>>2];if(i&1|0)f[(f[c+32>>2]|0)+(R*5<<2)>>2]=f[a+756>>2];if(k){n[(f[c+36>>2]|0)+(R*5<<2)>>2]=-3402823466385288598117041.0e14;d=3402823466385288598117041.0e14}else{s=(r|0)==1;n[(f[c+36>>2]|0)+(R*5<<2)>>2]=s?0.0:-3402823466385288598117041.0e14;d=s?3402823466385288598117041.0e14:0.0}n[(f[c+40>>2]|0)+(R*5<<2)>>2]=d;e=+n[a+704>>2];do if(e>0.0){d=(S*V+T*W+U*X)*+n[pa+328>>2]+(V*Y+W*Z+X*_)*+n[pa+332>>2]+(V*$+W*aa+X*ba)*+n[pa+336>>2]-((S*V+T*W+U*X)*+n[qa+328>>2]+(V*Y+W*Z+X*_)*+n[qa+332>>2]+(V*$+W*aa+X*ba)*+n[qa+336>>2]);if((r|0)==1){if(!(d<0.0))break;if(!(+n[o>>2]<-(e*d)))break;n[o>>2]=-(e*d);break}else{if(!(d>0.0))break;if(!(+n[o>>2]>-(e*d)))break;n[o>>2]=-(e*d);break}}while(0);n[o>>2]=+n[a+700>>2]*+n[o>>2];return}W=+n[pa+4>>2];X=+n[pa+8>>2];Y=+n[pa+12>>2];v=+n[a+556>>2];x=+n[a+572>>2];y=+n[a+588>>2];Z=+n[a+560>>2];_=+n[a+576>>2];$=+n[a+592>>2];aa=+n[pa+20>>2];ba=+n[pa+24>>2];ca=+n[pa+28>>2];da=+n[pa+36>>2];ea=+n[pa+40>>2];fa=+n[pa+44>>2];ha=+n[a+600>>2];ga=+n[a+604>>2];m=+n[a+608>>2];e=+n[pa+52>>2]+(W*ha+X*ga+Y*m);u=aa*ha+ba*ga+ca*m+ +n[pa+56>>2];m=da*ha+ea*ga+fa*m+ +n[pa+60>>2];ga=+n[qa+4>>2];ha=+n[qa+8>>2];ia=+n[qa+12>>2];ja=+n[a+624>>2];ka=+n[a+640>>2];O=+n[a+656>>2];P=+n[qa+20>>2];Q=+n[qa+24>>2];S=+n[qa+28>>2];T=+n[qa+36>>2];U=+n[qa+40>>2];V=+n[qa+44>>2];p=+n[a+664>>2];w=+n[a+668>>2];g=+n[a+672>>2];d=+n[qa+52>>2];t=+n[qa+56>>2];j=+n[qa+60>>2];J=d+(ga*p+ha*w+ia*g)-e;K=P*p+Q*w+S*g+t-u;M=T*p+U*w+V*g+j-m;z=+n[(f[a+28>>2]|0)+344>>2];A=+n[(f[a+32>>2]|0)+344>>2];H=z+A>0.0?A/(z+A):.5;la=(W*Z+X*_+Y*$)*H+(ga*ja+ha*ka+ia*O)*(1.0-H);ma=(Z*aa+_*ba+$*ca)*H+(ja*P+ka*Q+O*S)*(1.0-H);na=(Z*da+_*ea+$*fa)*H+(ja*T+ka*U+O*V)*(1.0-H);oa=1.0/+L(+(la*la+ma*ma+na*na));E=(d+(ga*p+ha*w+ia*g)-d)*la*oa+(P*p+Q*w+S*g+t-t)*ma*oa+(T*p+U*w+V*g+j-j)*na*oa;d=d+(ga*p+ha*w+ia*g)-d-la*oa*E;t=P*p+Q*w+S*g+t-t-ma*oa*E;j=T*p+U*w+V*g+j-j-na*oa*E;e=e-+n[pa+52>>2];u=u-+n[pa+56>>2];m=m-+n[pa+60>>2];g=la*oa*(e*la*oa+u*ma*oa+m*na*oa);w=ma*oa*(e*la*oa+u*ma*oa+m*na*oa);p=na*oa*(e*la*oa+u*ma*oa+m*na*oa);C=e-g+H*(g-la*oa*E);D=u-w+H*(w-ma*oa*E);B=m-p+H*(p-na*oa*E);F=d-(1.0-H)*(g-la*oa*E);G=t-(1.0-H)*(w-ma*oa*E);E=j-(1.0-H)*(p-na*oa*E);h=(H*d+(1.0-H)*(e-g))*(H*d+(1.0-H)*(e-g))+(H*t+(1.0-H)*(u-w))*(H*t+(1.0-H)*(u-w))+(H*j+(1.0-H)*(m-p))*(H*j+(1.0-H)*(m-p));if(h>1.1920928955078125e-07){y=1.0/+L(+h);N=(H*d+(1.0-H)*(e-g))*y;I=y*(H*j+(1.0-H)*(m-p));p=y*(H*t+(1.0-H)*(u-w))}else{N=W*v+X*x+Y*y;I=v*da+x*ea+y*fa;p=v*aa+x*ba+y*ca}t=ma*oa*I-na*oa*p;u=na*oa*N-I*la*oa;v=p*la*oa-ma*oa*N;R=f[c+12>>2]|0;n[R>>2]=D*I-B*p;n[R+4>>2]=B*N-C*I;n[R+8>>2]=C*p-D*N;R=f[c+20>>2]|0;n[R>>2]=-(G*I-E*p);n[R+4>>2]=-(E*N-F*I);n[R+8>>2]=-(F*p-G*N);if(z<1.1920928955078125e-07|A<1.1920928955078125e-07?(b[a+716>>0]|0)!=0:0){d=H*(D*v-B*u);e=H*(B*t-C*v);g=H*(C*u-D*t);h=(1.0-H)*(G*v-E*u);j=(1.0-H)*(E*t-F*v);m=(1.0-H)*(F*u-G*t)}else{d=D*v-B*u;e=B*t-C*v;g=C*u-D*t;h=G*v-E*u;j=E*t-F*v;m=F*u-G*t}R=(f[c+12>>2]|0)+(l<<2)|0;n[R>>2]=d;n[R+4>>2]=e;n[R+8>>2]=g;R=f[c+20>>2]|0;n[R+(l<<2)>>2]=-h;n[R+(l+1<<2)>>2]=-j;n[R+(l+2<<2)>>2]=-m;if(z<1.1920928955078125e-07|A<1.1920928955078125e-07){m=H*(D*na*oa-B*ma*oa);j=H*(B*la*oa-C*na*oa);e=H*(C*ma*oa-D*la*oa);h=(1.0-H)*(G*na*oa-E*ma*oa);g=(1.0-H)*(E*la*oa-F*na*oa);d=(1.0-H)*(F*ma*oa-G*la*oa)}else{m=D*na*oa-B*ma*oa;j=B*la*oa-C*na*oa;e=C*ma*oa-D*la*oa;h=G*na*oa-E*ma*oa;g=E*la*oa-F*na*oa;d=F*ma*oa-G*la*oa}i=(f[c+12>>2]|0)+(l<<1<<2)|0;n[i>>2]=m;n[i+4>>2]=j;n[i+8>>2]=e;i=f[c+20>>2]|0;n[i+(l<<1<<2)>>2]=-h;n[i+((l<<1|1)<<2)>>2]=-g;n[i+((l<<1)+2<<2)>>2]=-d;d=+n[c>>2]*+n[c+4>>2];if(!(b[a+736>>0]|0)){o=f[c+8>>2]|0;n[o>>2]=N;n[o+4>>2]=p;n[o+8>>2]=I;o=(f[c+8>>2]|0)+(l<<2)|0;n[o>>2]=t;n[o+4>>2]=u;n[o+8>>2]=v;o=(f[c+8>>2]|0)+(l<<1<<2)|0;n[o>>2]=la*oa;n[o+4>>2]=ma*oa;n[o+8>>2]=na*oa;o=f[c+16>>2]|0;e=-N;n[o>>2]=e;n[o+4>>2]=-p;n[o+8>>2]=-I;n[o+(l<<2)>>2]=-t;n[o+(l+1<<2)>>2]=-u;n[o+(l+2<<2)>>2]=-v;n[o+(l<<1<<2)>>2]=-(la*oa);n[o+((l<<1|1)<<2)>>2]=-(ma*oa);n[o+((l<<1)+2<<2)>>2]=-(na*oa);o=f[c+28>>2]|0;n[o>>2]=d*(J*N+K*p+M*I);n[o+(l<<2)>>2]=d*(J*t+K*u+M*v);n[o+(l<<1<<2)>>2]=d*(J*la*oa+K*ma*oa+M*na*oa);d=e;e=-t;g=-u;h=-v;i=f[c+20>>2]|0}else{d=-N;e=-t;g=-u;h=-v;o=f[c+28>>2]|0}k=f[c+12>>2]|0;n[k+(l*3<<2)>>2]=N;n[k+((l*3|0)+1<<2)>>2]=p;n[k+((l*3|0)+2<<2)>>2]=I;n[k+(l<<2<<2)>>2]=t;n[k+((l<<2|1)<<2)>>2]=u;n[k+((l<<2|2)<<2)>>2]=v;n[i+(l*3<<2)>>2]=d;n[i+((l*3|0)+1<<2)>>2]=-p;n[i+((l*3|0)+2<<2)>>2]=-I;n[i+(l<<2<<2)>>2]=e;n[i+((l<<2|1)<<2)>>2]=g;n[i+((l<<2|2)<<2)>>2]=h;K=+n[c>>2]*+n[c+4>>2];M=(Z*aa+_*ba+$*ca)*(ja*T+ka*U+O*V)-(Z*da+_*ea+$*fa)*(ja*P+ka*Q+O*S);fa=(Z*da+_*ea+$*fa)*(ga*ja+ha*ka+ia*O)-(W*Z+X*_+Y*$)*(ja*T+ka*U+O*V);ka=(W*Z+X*_+Y*$)*(ja*P+ka*Q+O*S)-(Z*aa+_*ba+$*ca)*(ga*ja+ha*ka+ia*O);n[o+(l*3<<2)>>2]=K*(M*N+fa*p+ka*I);n[o+(l<<2<<2)>>2]=K*(M*t+fa*u+ka*v);if(!(b[a+716>>0]|0)){p=0.0;s=0}else{ka=+n[a+708>>2]*+n[a+732>>2];p=ka;s=ka>0.0?1:2}l=b[a+737>>0]|0;q=(s|0)!=0;if(!(s|l&255))return;r=(f[c+24>>2]|0)*5|0;n[k+(r<<2)>>2]=la*oa;n[k+(r+1<<2)>>2]=ma*oa;n[k+(r+2<<2)>>2]=na*oa;n[i+(r<<2)>>2]=-(la*oa);n[i+(r+1<<2)>>2]=-(ma*oa);n[i+(r+2<<2)>>2]=-(na*oa);e=+n[a+688>>2];g=+n[a+692>>2];d=+lh(e-g,6.2831854820251465);if(!(d<-3.1415927410125732))if(d>3.1415927410125732)m=d+-6.2831854820251465;else m=d;else m=d+6.2831854820251465;d=+lh(e+g,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;k=m==d;o=o+(r<<2)|0;n[o>>2]=0.0;i=f[a+748>>2]|0;j=+n[(i&2|0?a+760|0:c+4|0)>>2];if(!(l<<24>>24==0|q&k)){if(i&4|0)f[(f[c+32>>2]|0)+(r<<2)>>2]=f[a+752>>2];g=+n[a+728>>2];h=+n[a+680>>2];e=m>d?1.0:0.0;do if(!(m>=d)){e=h/(j*+n[c>>2]);if(e<0.0)if(g>=m&m-e>g){d=(m-g)/e;break}else{d=g<m?0.0:1.0;break}if(e>0.0)if(g<=d&d-e<g){d=(d-g)/e;break}else{d=g>d?0.0:1.0;break}else d=0.0}else d=e;while(0);n[o>>2]=d*h*+n[a+732>>2]+ +n[o>>2];n[(f[c+36>>2]|0)+(r<<2)>>2]=-+n[a+684>>2];f[(f[c+40>>2]|0)+(r<<2)>>2]=f[a+684>>2]}if(!q)return;n[o>>2]=+n[o>>2]+p*j*+n[c>>2];if(i&1|0)f[(f[c+32>>2]|0)+(r<<2)>>2]=f[a+756>>2];if(k){n[(f[c+36>>2]|0)+(r<<2)>>2]=-3402823466385288598117041.0e14;d=3402823466385288598117041.0e14}else{R=(s|0)==1;n[(f[c+36>>2]|0)+(r<<2)>>2]=R?0.0:-3402823466385288598117041.0e14;d=R?3402823466385288598117041.0e14:0.0}n[(f[c+40>>2]|0)+(r<<2)>>2]=d;e=+n[a+704>>2];do if(e>0.0){d=+n[pa+328>>2]*la*oa+ +n[pa+332>>2]*ma*oa+ +n[pa+336>>2]*na*oa-(+n[qa+328>>2]*la*oa+ +n[qa+332>>2]*ma*oa+ +n[qa+336>>2]*na*oa);if((s|0)==1){if(!(d<0.0))break;if(!(+n[o>>2]<-(e*d)))break;n[o>>2]=-(e*d);break}else{if(!(d>0.0))break;if(!(+n[o>>2]>-(e*d)))break;n[o>>2]=-(e*d);break}}while(0);n[o>>2]=+n[a+700>>2]*+n[o>>2];return}function zc(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=+i;var j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0;F=u;u=u+896|0;E=f[g+4>>2]|0;D=f[g+12>>2]|0;j=f[E+4>>2]|0;if((j|0)<20){f[F+712>>2]=3832;f[F+712+168>>2]=0;n[F+712+172>>2]=i;f[F+712+164>>2]=f[h+4>>2];n[F+352+308>>2]=9.999999747378752e-05;b[F+352+332>>0]=0;f[F+288>>2]=9312;f[F+64>>2]=9380;f[F+64+4>>2]=F+352;f[F+64+8>>2]=F+288;f[F+64+12>>2]=a;f[F+64+16>>2]=E;f[F+64+20>>2]=0;if((Ud(F+64|0,c,e,D,D,F+712|0)|0?(v=F+712+132|0,p=+n[v>>2],q=+n[F+712+136>>2],r=+n[F+712+140>>2],p*p+q*q+r*r>9.999999747378752e-05):0)?(s=+n[F+712+164>>2],s<+n[h+4>>2]):0){i=1.0/+L(+(p*p+q*q+r*r));n[v>>2]=p*i;n[F+712+136>>2]=q*i;n[F+712+140>>2]=r*i;f[F+16>>2]=f[g+8>>2];f[F+16+4>>2]=0;f[F+16+8>>2]=f[v>>2];f[F+16+8+4>>2]=f[v+4>>2];f[F+16+8+8>>2]=f[v+8>>2];f[F+16+8+12>>2]=f[v+12>>2];f[F+16+24>>2]=f[F+712+148>>2];f[F+16+24+4>>2]=f[F+712+148+4>>2];f[F+16+24+8>>2]=f[F+712+148+8>>2];f[F+16+24+12>>2]=f[F+712+148+12>>2];n[F+16+40>>2]=s;+ub[f[(f[h>>2]|0)+12>>2]&15](h,F+16|0,1)}u=F;return}if((j+-21|0)>>>0>=9){if((j|0)!=31){u=F;return}uj(15386);if((f[E+16>>2]|0)>0){j=0;do{t=f[E+24>>2]|0;k=+n[t+(j*80|0)>>2];o=+n[t+(j*80|0)+4>>2];r=+n[t+(j*80|0)+8>>2];l=+n[t+(j*80|0)+16>>2];p=+n[t+(j*80|0)+20>>2];w=+n[t+(j*80|0)+24>>2];m=+n[t+(j*80|0)+32>>2];q=+n[t+(j*80|0)+36>>2];y=+n[t+(j*80|0)+40>>2];O=+n[t+(j*80|0)+48>>2];N=+n[t+(j*80|0)+52>>2];C=+n[t+(j*80|0)+56>>2];t=f[t+(j*80|0)+64>>2]|0;M=+n[D>>2];K=+n[D+4>>2];J=+n[D+8>>2];I=+n[D+16>>2];H=+n[D+20>>2];G=+n[D+24>>2];s=+n[D+32>>2];x=+n[D+36>>2];z=+n[D+40>>2];A=O*M+N*K+C*J+ +n[D+48>>2];B=O*I+N*H+C*G+ +n[D+52>>2];C=O*s+N*x+C*z+ +n[D+56>>2];n[F+712>>2]=k*M+l*K+m*J;n[F+712+4>>2]=o*M+p*K+q*J;n[F+712+8>>2]=r*M+w*K+y*J;n[F+712+12>>2]=0.0;n[F+712+16>>2]=k*I+l*H+m*G;n[F+712+20>>2]=o*I+p*H+q*G;n[F+712+24>>2]=r*I+w*H+y*G;n[F+712+28>>2]=0.0;n[F+712+32>>2]=k*s+l*x+m*z;n[F+712+36>>2]=o*s+p*x+q*z;n[F+712+40>>2]=r*s+w*x+y*z;n[F+712+44>>2]=0.0;n[F+712+48>>2]=A;n[F+712+52>>2]=B;n[F+712+56>>2]=C;n[F+712+60>>2]=0.0;d[F+352+8>>1]=1;d[F+352+10>>1]=-1;f[F+352>>2]=6104;f[F+352+12>>2]=h;f[F+352+16>>2]=j;f[F+352+4>>2]=f[h+4>>2];v=f[g+8>>2]|0;f[F+288>>2]=g;f[F+288+4>>2]=t;f[F+288+8>>2]=v;f[F+288+12>>2]=F+712;f[F+288+16>>2]=-1;f[F+288+20>>2]=j;zc(a,c,e,F+288|0,F+352|0,i);j=j+1|0}while((j|0)<(f[E+16>>2]|0))}j=f[2405]|0;E=(f[j+16>>2]|0)+-1|0;f[j+16>>2]=E;if(E|0){u=F;return}do if(f[j+4>>2]|0){gb(F+712|0,0)|0;E=f[6471]|0;n[j+8>>2]=+n[j+8>>2]+ +(((f[F+712+4>>2]|0)-(f[E+4>>2]|0)+(((f[F+712>>2]|0)-(f[E>>2]|0)|0)*1e6|0)-(f[j+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[j+16>>2]|0)){j=f[2405]|0;break}else{u=F;return}}while(0);f[2405]=f[j+20>>2];u=F;return}switch(j|0){case 21:{o=+n[D>>2];p=+n[D+16>>2];q=+n[D+32>>2];r=+n[D+4>>2];s=+n[D+20>>2];w=+n[D+36>>2];x=+n[D+8>>2];y=+n[D+24>>2];z=+n[D+40>>2];A=-+n[D+48>>2];B=-+n[D+52>>2];C=-+n[D+56>>2];m=+n[c+48>>2];l=+n[c+52>>2];k=+n[c+56>>2];n[F+352>>2]=o*A+p*B+q*C+(o*m+p*l+q*k);n[F+352+4>>2]=r*A+s*B+w*C+(r*m+s*l+w*k);n[F+352+8>>2]=x*A+y*B+z*C+(x*m+y*l+z*k);n[F+352+12>>2]=0.0;k=+n[e+48>>2];l=+n[e+52>>2];m=+n[e+56>>2];P=+n[e>>2];G=+n[e+16>>2];H=+n[e+32>>2];I=+n[e+4>>2];J=+n[e+20>>2];K=+n[e+36>>2];M=+n[e+8>>2];N=+n[e+24>>2];O=+n[e+40>>2];n[F+288>>2]=o*P+p*G+q*H;n[F+288+4>>2]=o*I+p*J+q*K;n[F+288+8>>2]=o*M+p*N+q*O;n[F+288+12>>2]=0.0;n[F+288+16>>2]=r*P+s*G+w*H;n[F+288+20>>2]=r*I+s*J+w*K;n[F+288+24>>2]=r*M+s*N+w*O;n[F+288+28>>2]=0.0;n[F+288+32>>2]=x*P+y*G+z*H;n[F+288+36>>2]=x*I+y*J+z*K;n[F+288+40>>2]=x*M+y*N+z*O;j=F+288+44|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[j+16>>2]=0;j=f[g+8>>2]|0;O=+rb[f[(f[E>>2]|0)+48>>2]&15](E);f[F+64>>2]=9240;f[F+64+4>>2]=a;f[F+64+8>>2]=f[c>>2];f[F+64+8+4>>2]=f[c+4>>2];f[F+64+8+8>>2]=f[c+8>>2];f[F+64+8+12>>2]=f[c+12>>2];f[F+64+24>>2]=f[c+16>>2];f[F+64+24+4>>2]=f[c+16+4>>2];f[F+64+24+8>>2]=f[c+16+8>>2];f[F+64+24+12>>2]=f[c+16+12>>2];f[F+64+40>>2]=f[c+32>>2];f[F+64+40+4>>2]=f[c+32+4>>2];f[F+64+40+8>>2]=f[c+32+8>>2];f[F+64+40+12>>2]=f[c+32+12>>2];f[F+64+56>>2]=f[c+48>>2];f[F+64+56+4>>2]=f[c+48+4>>2];f[F+64+56+8>>2]=f[c+48+8>>2];f[F+64+56+12>>2]=f[c+48+12>>2];f[F+64+72>>2]=f[e>>2];f[F+64+72+4>>2]=f[e+4>>2];f[F+64+72+8>>2]=f[e+8>>2];f[F+64+72+12>>2]=f[e+12>>2];f[F+64+88>>2]=f[e+16>>2];f[F+64+88+4>>2]=f[e+16+4>>2];f[F+64+88+8>>2]=f[e+16+8>>2];f[F+64+88+12>>2]=f[e+16+12>>2];f[F+64+104>>2]=f[e+32>>2];f[F+64+104+4>>2]=f[e+32+4>>2];f[F+64+104+8>>2]=f[e+32+8>>2];f[F+64+104+12>>2]=f[e+32+12>>2];f[F+64+120>>2]=f[e+48>>2];f[F+64+120+4>>2]=f[e+48+4>>2];f[F+64+120+8>>2]=f[e+48+8>>2];f[F+64+120+12>>2]=f[e+48+12>>2];f[F+64+136>>2]=f[D>>2];f[F+64+136+4>>2]=f[D+4>>2];f[F+64+136+8>>2]=f[D+8>>2];f[F+64+136+12>>2]=f[D+12>>2];f[F+64+152>>2]=f[D+16>>2];f[F+64+152+4>>2]=f[D+16+4>>2];f[F+64+152+8>>2]=f[D+16+8>>2];f[F+64+152+12>>2]=f[D+16+12>>2];f[F+64+168>>2]=f[D+32>>2];f[F+64+168+4>>2]=f[D+32+4>>2];f[F+64+168+8>>2]=f[D+32+8>>2];f[F+64+168+12>>2]=f[D+32+12>>2];f[F+64+184>>2]=f[D+48>>2];f[F+64+184+4>>2]=f[D+48+4>>2];f[F+64+184+8>>2]=f[D+48+8>>2];f[F+64+184+12>>2]=f[D+48+12>>2];n[F+64+204>>2]=O;f[F+64>>2]=6056;f[F+64+212>>2]=h;f[F+64+216>>2]=j;f[F+64+220>>2]=E;f[F+64+200>>2]=f[h+4>>2];n[F+64+208>>2]=i;Yb[f[(f[a>>2]|0)+8>>2]&127](a,F+288|0,F+16|0,F);j=f[E+48>>2]|0;f[F+712>>2]=7096;f[F+712+4>>2]=j;f[F+712+8>>2]=F+64;j=f[E+52>>2]|0;if(!(b[j+60>>0]|0))Ue(j,F+712|0,F+352|0,o*A+p*B+q*C+(o*k+p*l+q*m),r*A+s*B+w*C+(r*k+s*l+w*m),x*A+y*B+z*C+(x*k+y*l+z*m),F+16|0,F);else we(j,F+712|0,F+352|0,o*A+p*B+q*C+(o*k+p*l+q*m),r*A+s*B+w*C+(r*k+s*l+w*m),x*A+y*B+z*C+(x*k+y*l+z*m),F+16|0,F,f[j+56>>2]|0);u=F;return}case 28:{f[F+712>>2]=3832;f[F+712+168>>2]=0;n[F+712+172>>2]=i;f[F+712+164>>2]=f[h+4>>2];f[F+352>>2]=9380;f[F+352+4>>2]=0;f[F+352+8>>2]=0;f[F+352+12>>2]=a;f[F+352+16>>2]=0;f[F+352+20>>2]=E;if((Ud(F+352|0,c,e,D,D,F+712|0)|0?(t=F+712+132|0,k=+n[t>>2],l=+n[F+712+136>>2],m=+n[F+712+140>>2],k*k+l*l+m*m>9.999999747378752e-05):0)?(o=+n[F+712+164>>2],o<+n[h+4>>2]):0){P=1.0/+L(+(k*k+l*l+m*m));n[t>>2]=k*P;n[F+712+136>>2]=l*P;n[F+712+140>>2]=m*P;f[F+288>>2]=f[g+8>>2];f[F+288+4>>2]=0;f[F+288+8>>2]=f[t>>2];f[F+288+8+4>>2]=f[t+4>>2];f[F+288+8+8>>2]=f[t+8>>2];f[F+288+8+12>>2]=f[t+12>>2];f[F+288+24>>2]=f[F+712+148>>2];f[F+288+24+4>>2]=f[F+712+148+4>>2];f[F+288+24+8>>2]=f[F+712+148+8>>2];f[F+288+24+12>>2]=f[F+712+148+12>>2];n[F+288+40>>2]=o;+ub[f[(f[h>>2]|0)+12>>2]&15](h,F+288|0,1)}u=F;return}default:{o=+n[D>>2];p=+n[D+16>>2];q=+n[D+32>>2];x=+n[D+4>>2];y=+n[D+20>>2];z=+n[D+36>>2];J=+n[D+8>>2];M=+n[D+24>>2];O=+n[D+40>>2];H=-+n[D+48>>2];G=-+n[D+52>>2];C=-+n[D+56>>2];A=+n[c+48>>2];B=+n[c+52>>2];k=+n[c+56>>2];m=o*H+p*G+q*C+(o*A+p*B+q*k);l=x*H+y*G+z*C+(x*A+y*B+z*k);k=J*H+M*G+O*C+(J*A+M*B+O*k);B=+n[e+48>>2];A=+n[e+52>>2];w=+n[e+56>>2];r=o*H+p*G+q*C+(o*B+p*A+q*w);s=x*H+y*G+z*C+(x*B+y*A+z*w);w=J*H+M*G+O*C+(J*B+M*A+O*w);A=+n[e>>2];B=+n[e+16>>2];C=+n[e+32>>2];G=+n[e+4>>2];H=+n[e+20>>2];I=+n[e+36>>2];K=+n[e+8>>2];N=+n[e+24>>2];P=+n[e+40>>2];n[F+712>>2]=o*A+p*B+q*C;n[F+712+4>>2]=o*G+p*H+q*I;n[F+712+8>>2]=o*K+p*N+q*P;n[F+712+12>>2]=0.0;n[F+712+16>>2]=x*A+y*B+z*C;n[F+712+20>>2]=x*G+y*H+z*I;n[F+712+24>>2]=x*K+y*N+z*P;n[F+712+28>>2]=0.0;n[F+712+32>>2]=J*A+M*B+O*C;n[F+712+36>>2]=J*G+M*H+O*I;n[F+712+40>>2]=J*K+M*N+O*P;v=F+712+44|0;f[v>>2]=0;f[v+4>>2]=0;f[v+8>>2]=0;f[v+12>>2]=0;f[v+16>>2]=0;g=f[g+8>>2]|0;P=+rb[f[(f[E>>2]|0)+48>>2]&15](E);f[F+352>>2]=9240;f[F+352+4>>2]=a;f[F+352+8>>2]=f[c>>2];f[F+352+8+4>>2]=f[c+4>>2];f[F+352+8+8>>2]=f[c+8>>2];f[F+352+8+12>>2]=f[c+12>>2];f[F+352+24>>2]=f[c+16>>2];f[F+352+24+4>>2]=f[c+16+4>>2];f[F+352+24+8>>2]=f[c+16+8>>2];f[F+352+24+12>>2]=f[c+16+12>>2];f[F+352+40>>2]=f[c+32>>2];f[F+352+40+4>>2]=f[c+32+4>>2];f[F+352+40+8>>2]=f[c+32+8>>2];f[F+352+40+12>>2]=f[c+32+12>>2];f[F+352+56>>2]=f[c+48>>2];f[F+352+56+4>>2]=f[c+48+4>>2];f[F+352+56+8>>2]=f[c+48+8>>2];f[F+352+56+12>>2]=f[c+48+12>>2];f[F+352+72>>2]=f[e>>2];f[F+352+72+4>>2]=f[e+4>>2];f[F+352+72+8>>2]=f[e+8>>2];f[F+352+72+12>>2]=f[e+12>>2];f[F+352+88>>2]=f[e+16>>2];f[F+352+88+4>>2]=f[e+16+4>>2];f[F+352+88+8>>2]=f[e+16+8>>2];f[F+352+88+12>>2]=f[e+16+12>>2];f[F+352+104>>2]=f[e+32>>2];f[F+352+104+4>>2]=f[e+32+4>>2];f[F+352+104+8>>2]=f[e+32+8>>2];f[F+352+104+12>>2]=f[e+32+12>>2];f[F+352+120>>2]=f[e+48>>2];f[F+352+120+4>>2]=f[e+48+4>>2];f[F+352+120+8>>2]=f[e+48+8>>2];f[F+352+120+12>>2]=f[e+48+12>>2];f[F+352+136>>2]=f[D>>2];f[F+352+136+4>>2]=f[D+4>>2];f[F+352+136+8>>2]=f[D+8>>2];f[F+352+136+12>>2]=f[D+12>>2];f[F+352+152>>2]=f[D+16>>2];f[F+352+152+4>>2]=f[D+16+4>>2];f[F+352+152+8>>2]=f[D+16+8>>2];f[F+352+152+12>>2]=f[D+16+12>>2];f[F+352+168>>2]=f[D+32>>2];f[F+352+168+4>>2]=f[D+32+4>>2];f[F+352+168+8>>2]=f[D+32+8>>2];f[F+352+168+12>>2]=f[D+32+12>>2];f[F+352+184>>2]=f[D+48>>2];f[F+352+184+4>>2]=f[D+48+4>>2];f[F+352+184+8>>2]=f[D+48+8>>2];f[F+352+184+12>>2]=f[D+48+12>>2];n[F+352+204>>2]=P;f[F+352>>2]=6080;f[F+352+212>>2]=h;f[F+352+216>>2]=g;f[F+352+220>>2]=E;f[F+352+200>>2]=f[h+4>>2];n[F+352+208>>2]=i;Yb[f[(f[a>>2]|0)+8>>2]&127](a,F+712|0,F+288|0,F+64|0);n[F+16>>2]=m;n[F+16+4>>2]=l;n[F+16+8>>2]=k;n[F+16+12>>2]=0.0;if(r<m){n[F+16>>2]=r;o=r}else o=m;if(s<l){n[F+16+4>>2]=s;p=s}else p=l;if(w<k){n[F+16+8>>2]=w;q=w}else q=k;n[F>>2]=m;n[F+4>>2]=l;n[F+8>>2]=k;n[F+12>>2]=0.0;if(m<r){n[F>>2]=r;m=r}if(l<s){n[F+4>>2]=s;l=s}if(k<w){n[F+8>>2]=w;k=w}n[F+16>>2]=+n[F+288>>2]+o;n[F+16+4>>2]=+n[F+288+4>>2]+p;n[F+16+8>>2]=+n[F+288+8>>2]+q;n[F>>2]=+n[F+64>>2]+m;n[F+4>>2]=+n[F+64+4>>2]+l;n[F+8>>2]=+n[F+64+8>>2]+k;Yb[f[(f[E>>2]|0)+64>>2]&127](E,F+352|0,F+16|0,F);u=F;return}}}function Ac(a,c){a=a|0;c=c|0;var d=0.0,e=0.0,g=0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0,p=0.0,q=0.0,r=0,t=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0,S=0,T=0.0,U=0.0,V=0.0,W=0.0,Y=0.0,Z=0.0,_=0,$=0,aa=0,ba=0,ca=0.0,da=0,ea=0,fa=0,ga=0;fa=u;u=u+16|0;da=f[a+28>>2]|0;ea=f[a+32>>2]|0;W=+n[da+344>>2];Y=+n[ea+344>>2];S=f[c+24>>2]|0;ca=b[a+180>>0]|0?1.0:-1.0;T=+n[a+936>>2]-+n[a+872>>2];U=+n[a+940>>2]-+n[a+876>>2];V=+n[a+944>>2]-+n[a+880>>2];Z=W+Y>0.0?Y/(W+Y):.5;G=f[a+824>>2]|0;H=f[a+840>>2]|0;I=f[a+856>>2]|0;J=f[a+888>>2]|0;M=f[a+904>>2]|0;N=f[a+920>>2]|0;R=(b[a+49>>0]|0)==0;if(R){g=f[a+828>>2]|0;v=(f[s>>2]=g,+n[s>>2]);j=f[a+844>>2]|0;y=f[a+860>>2]|0;f[fa>>2]=j;z=f[a+832>>2]|0;o=f[a+848>>2]|0;r=f[a+864>>2]|0;e=(f[s>>2]=y,+n[s>>2]);h=(f[s>>2]=z,+n[s>>2]);q=(f[s>>2]=o,+n[s>>2]);$=G;w=r;aa=H;ba=I;m=(f[s>>2]=r,+n[s>>2])}else{d=Z*(f[s>>2]=G,+n[s>>2]);i=Z*(f[s>>2]=H,+n[s>>2]);h=Z*(f[s>>2]=I,+n[s>>2]);e=(1.0-Z)*(f[s>>2]=J,+n[s>>2]);k=(1.0-Z)*(f[s>>2]=M,+n[s>>2]);h=h+(1.0-Z)*(f[s>>2]=N,+n[s>>2]);l=1.0/+L(+((d+e)*(d+e)+(i+k)*(i+k)+h*h));j=(n[s>>2]=(d+e)*l,f[s>>2]|0);o=(n[s>>2]=(i+k)*l,f[s>>2]|0);r=(n[s>>2]=h*l,f[s>>2]|0);if(+K(+(h*l))>.7071067690849304){Q=1.0/+L(+(h*l*h*l+(i+k)*l*(i+k)*l));n[fa>>2]=-(h*l*Q);m=(d+e)*l*-(h*l*Q);q=-((d+e)*l*(i+k)*l*Q);h=(h*l*h*l+(i+k)*l*(i+k)*l)*Q;e=(i+k)*l*Q;g=0;d=0.0}else{m=(d+e)*l*(d+e)*l+(i+k)*l*(i+k)*l;Q=1.0/+L(+m);g=(n[s>>2]=-((i+k)*l*Q),f[s>>2]|0);n[fa>>2]=(d+e)*l*Q;m=m*Q;q=h*l*-((i+k)*l*Q);h=-(h*l*(d+e)*l*Q);e=0.0;d=-((i+k)*l*Q)}y=(n[s>>2]=e,f[s>>2]|0);z=(n[s>>2]=h,f[s>>2]|0);ga=(n[s>>2]=q,f[s>>2]|0);$=j;w=(n[s>>2]=m,f[s>>2]|0);aa=o;ba=r;o=ga;v=d;j=f[fa>>2]|0}r=f[c+12>>2]|0;n[r>>2]=v;f[r+4>>2]=j;f[r+8>>2]=y;f[r+(S<<2)>>2]=z;f[r+(S+1<<2)>>2]=o;f[r+(S+2<<2)>>2]=w;i=-v;o=f[c+20>>2]|0;n[o>>2]=i;k=+n[fa>>2];n[o+4>>2]=-k;n[o+8>>2]=-e;n[o+(S<<2)>>2]=-h;n[o+(S+1<<2)>>2]=-q;l=-m;n[o+(S+2<<2)>>2]=l;j=f[a+300>>2]|0;d=+n[a+280>>2];if(!(j&128))d=d*+n[c+4>>2];C=d*+n[c>>2];P=(f[s>>2]=H,+n[s>>2]);E=(f[s>>2]=N,+n[s>>2]);D=(f[s>>2]=I,+n[s>>2]);O=(f[s>>2]=M,+n[s>>2]);Q=(f[s>>2]=J,+n[s>>2]);F=(f[s>>2]=G,+n[s>>2]);ga=f[c+28>>2]|0;n[ga>>2]=C*((P*E-D*O)*v+(D*Q-F*E)*k+(F*O-P*Q)*e);n[ga+(S<<2)>>2]=C*((P*E-D*O)*h+(D*Q-F*E)*q+(F*O-P*Q)*m);if(j&64|0){ga=f[c+32>>2]|0;f[ga>>2]=f[a+292>>2];f[ga+(S<<2)>>2]=f[a+292>>2]}D=+n[da+52>>2];x=+n[da+56>>2];B=+n[da+60>>2];t=+n[ea+52>>2];d=+n[ea+56>>2];p=+n[ea+60>>2];if(R){Q=(d-x)*e-(p-B)*k;P=(p-B)*v-(t-D)*e;O=(t-D)*k-(d-x)*v;n[r+(S<<1<<2)>>2]=Z*Q;n[r+((S<<1|1)<<2)>>2]=Z*P;n[r+((S<<1)+2<<2)>>2]=Z*O;n[o+(S<<1<<2)>>2]=(1.0-Z)*Q;n[o+((S<<1|1)<<2)>>2]=(1.0-Z)*P;n[o+((S<<1)+2<<2)>>2]=(1.0-Z)*O;O=(d-x)*m-(p-B)*q;P=(p-B)*h-(t-D)*m;Q=(t-D)*q-(d-x)*h;n[r+(S*3<<2)>>2]=Z*O;n[r+((S*3|0)+1<<2)>>2]=Z*P;n[r+((S*3|0)+2<<2)>>2]=Z*Q;n[o+(S*3<<2)>>2]=(1.0-Z)*O;n[o+((S*3|0)+1<<2)>>2]=(1.0-Z)*P;n[o+((S*3|0)+2<<2)>>2]=(1.0-Z)*Q;j=f[c+8>>2]|0;f[j+(S<<1<<2)>>2]=g;n[j+((S<<1|1)<<2)>>2]=k;n[j+((S<<1)+2<<2)>>2]=e;n[j+(S*3<<2)>>2]=h;n[j+((S*3|0)+1<<2)>>2]=q;n[j+((S*3|0)+2<<2)>>2]=m;H=f[c+16>>2]|0;n[H+(S<<1<<2)>>2]=i;Q=+n[fa>>2];n[H+((S<<1|1)<<2)>>2]=-Q;n[H+((S<<1)+2<<2)>>2]=-e;n[H+(S*3<<2)>>2]=-h;n[H+((S*3|0)+1<<2)>>2]=-q;o=H+((S*3|0)+2<<2)|0;P=0.0;O=0.0;F=0.0;E=0.0;C=0.0;A=0.0;v=d-x;k=p-B;i=t-D}else{t=+n[a+936>>2]-t;F=+n[a+940>>2]-d;O=+n[a+944>>2]-p;k=(f[s>>2]=$,+n[s>>2]);l=(f[s>>2]=aa,+n[s>>2]);i=(f[s>>2]=ba,+n[s>>2]);P=+n[a+872>>2]-D;Q=+n[a+876>>2]-x;d=+n[a+880>>2]-B;C=+n[a+1080>>2]-+n[a+1032>>2];A=(P*k+Q*l+d*i)*k+C*k-(t*k+F*l+O*i)*k;E=(P*k+Q*l+d*i)*l+C*l-(t*k+F*l+O*i)*l;C=(P*k+Q*l+d*i)*i+C*i-(t*k+F*l+O*i)*i;B=P-(P*k+Q*l+d*i)*k+Z*A;v=Q-(P*k+Q*l+d*i)*l+Z*E;x=d-(P*k+Q*l+d*i)*i+Z*C;A=t-(t*k+F*l+O*i)*k-(1.0-Z)*A;E=F-(t*k+F*l+O*i)*l-(1.0-Z)*E;C=O-(t*k+F*l+O*i)*i-(1.0-Z)*C;h=Z*(t-(t*k+F*l+O*i)*k)+(1.0-Z)*(P-(P*k+Q*l+d*i)*k);e=Z*(F-(t*k+F*l+O*i)*l)+(1.0-Z)*(Q-(P*k+Q*l+d*i)*l);d=Z*(O-(t*k+F*l+O*i)*i)+(1.0-Z)*(d-(P*k+Q*l+d*i)*i);n[fa>>2]=e;if(d*d+(h*h+e*e)>1.1920928955078125e-07){Q=1.0/+L(+(d*d+(h*h+e*e)));g=(n[s>>2]=h*Q,f[s>>2]|0);n[fa>>2]=Q*e;j=(n[s>>2]=Q*d,f[s>>2]|0);t=Q*d;e=Q*e;d=h*Q}else{ga=f[a+828>>2]|0;g=f[a+844>>2]|0;j=f[a+860>>2]|0;f[fa>>2]=g;t=(f[s>>2]=j,+n[s>>2]);e=(f[s>>2]=g,+n[s>>2]);g=ga;d=(f[s>>2]=ga,+n[s>>2])}p=t*l-e*i;q=d*i-t*k;m=e*k-d*l;n[r+(S<<1<<2)>>2]=v*t-x*e;n[r+(S<<1<<2)+4>>2]=x*d-B*t;n[r+(S<<1<<2)+8>>2]=B*e-v*d;ga=f[c+20>>2]|0;n[ga+(S<<1<<2)>>2]=-(E*t-C*e);n[ga+((S<<1|1)<<2)>>2]=-(C*d-A*t);n[ga+((S<<1)+2<<2)>>2]=-(A*e-E*d);if(W<1.1920928955078125e-07|Y<1.1920928955078125e-07?(b[a+297>>0]|0)!=0:0){d=Z*(v*m-x*q);e=Z*(B*q-v*p);h=Z*(x*p-B*m);i=(1.0-Z)*(E*m-C*q);k=(1.0-Z)*(C*p-A*m);l=(1.0-Z)*(A*q-E*p)}else{d=v*m-x*q;e=B*q-v*p;h=x*p-B*m;i=E*m-C*q;k=C*p-A*m;l=A*q-E*p}ga=(f[c+12>>2]|0)+(S*3<<2)|0;n[ga>>2]=d;n[ga+4>>2]=h;n[ga+8>>2]=e;ga=f[c+20>>2]|0;n[ga+(S*3<<2)>>2]=-i;n[ga+((S*3|0)+1<<2)>>2]=-k;n[ga+((S*3|0)+2<<2)>>2]=-l;ga=f[c+8>>2]|0;f[ga+(S<<1<<2)>>2]=g;f[ga+((S<<1|1)<<2)>>2]=f[fa>>2];f[ga+((S<<1)+2<<2)>>2]=j;n[ga+(S*3<<2)>>2]=p;n[ga+((S*3|0)+1<<2)>>2]=q;n[ga+((S*3|0)+2<<2)>>2]=m;H=f[c+16>>2]|0;n[H+(S<<1<<2)>>2]=-(f[s>>2]=g,+n[s>>2]);Q=+n[fa>>2];n[H+((S<<1|1)<<2)>>2]=-Q;n[H+((S<<1)+2<<2)>>2]=-t;n[H+(S*3<<2)>>2]=-p;n[H+((S*3|0)+1<<2)>>2]=-q;l=-m;o=H+((S*3|0)+2<<2)|0;e=t;h=p;j=ga;P=v;O=x;F=B;v=0.0;k=0.0;i=0.0}n[o>>2]=l;G=f[a+300>>2]|0;d=+n[a+264>>2];if(!(G&32))d=d*+n[c+4>>2];D=d*+n[c>>2];I=f[c+28>>2]|0;n[I+(S<<1<<2)>>2]=D*(T*(f[s>>2]=g,+n[s>>2])+U*Q+V*e);n[I+(S*3<<2)>>2]=D*(T*h+U*q+V*m);if(G&16|0){ga=f[c+32>>2]|0;f[ga+(S<<1<<2)>>2]=f[a+276>>2];f[ga+(S*3<<2)>>2]=f[a+276>>2]}if(!(b[a+296>>0]|0)){m=0.0;y=0}else{V=ca*+n[a+1032>>2];m=V;y=V>0.0?2:1}r=b[a+1096>>0]|0;w=(y|0)!=0;if(y|r&255){z=f[c+24>>2]<<2;f[j+(z<<2)>>2]=$;f[j+((z|1)<<2)>>2]=aa;f[j+((z|2)<<2)>>2]=ba;p=(f[s>>2]=$,+n[s>>2]);n[H+(z<<2)>>2]=-p;q=(f[s>>2]=aa,+n[s>>2]);n[H+((z|1)<<2)>>2]=-q;t=(f[s>>2]=ba,+n[s>>2]);n[H+((z|2)<<2)>>2]=-t;if(b[a+49>>0]|0){if(!(W<1.1920928955078125e-07|Y<1.1920928955078125e-07)){g=f[c+12>>2]|0;n[g+(z<<2)>>2]=P*t-O*q;n[g+((z|1)<<2)>>2]=O*p-F*t;n[g+((z|2)<<2)>>2]=F*q-P*p;g=f[c+20>>2]|0;n[g+(z<<2)>>2]=-(E*t-C*q);n[g+((z|1)<<2)>>2]=-(C*p-A*t);d=-(A*q-E*p);_=31}}else{W=v*t-k*q;Y=k*p-i*t;d=i*q-v*p;g=f[c+12>>2]|0;n[g+(z<<2)>>2]=Z*W;n[g+((z|1)<<2)>>2]=Z*Y;n[g+((z|2)<<2)>>2]=Z*d;g=f[c+20>>2]|0;n[g+(z<<2)>>2]=(1.0-Z)*W;n[g+((z|1)<<2)>>2]=(1.0-Z)*Y;d=(1.0-Z)*d;_=31}if((_|0)==31)n[g+((z|2)<<2)>>2]=d;g=+n[a+184>>2]==+n[a+188>>2];n[I+(z<<2)>>2]=0.0;j=(f[c+36>>2]|0)+(z<<2)|0;n[j>>2]=0.0;o=(f[c+40>>2]|0)+(z<<2)|0;n[o>>2]=0.0;l=+n[(G&512|0?a+232|0:c+4|0)>>2];if(!(r<<24>>24==0|w&g)){if(G&1|0)f[(f[c+32>>2]|0)+(z<<2)>>2]=f[a+212>>2];k=+n[a+1100>>2];d=+n[a+1080>>2];e=+n[a+184>>2];h=+n[a+188>>2];i=l*+n[c>>2];do if(!(e>h))if(!(e==h)){if(k/i<0.0)if(d>=e?e-k/i>d:0){d=(e-d)/(k/i);break}else{d=d<e?0.0:1.0;break}if(k/i>0.0)if(d<=h?h-k/i<d:0){d=(h-d)/(k/i);break}else{d=d>h?0.0:1.0;break}else d=0.0}else d=0.0;else d=1.0;while(0);n[I+(z<<2)>>2]=+n[I+(z<<2)>>2]-ca*d*k;n[j>>2]=+n[j>>2]-+n[a+1104>>2]*+n[c>>2];n[o>>2]=+n[a+1104>>2]*+n[c>>2]+ +n[o>>2]}if(w){n[I+(z<<2)>>2]=+n[I+(z<<2)>>2]+m*l*+n[c>>2];if(G&256|0)f[(f[c+32>>2]|0)+(z<<2)>>2]=f[a+244>>2];if(g){d=-3402823466385288598117041.0e14;e=3402823466385288598117041.0e14}else{ga=(y|0)==1;d=ga?-3402823466385288598117041.0e14:0.0;e=ga?0.0:3402823466385288598117041.0e14}n[j>>2]=d;n[o>>2]=e;Z=1.0-+n[a+240>>2];e=+K(+Z);do if(!(Z!=Z|0.0!=0.0|Z==0.0)){d=ca*(+n[da+312>>2]*p+ +n[da+316>>2]*q+ +n[da+320>>2]*t-(+n[ea+312>>2]*p+ +n[ea+316>>2]*q+ +n[ea+320>>2]*t));if((y|0)==1){if(!(d<0.0))break;if(!(+n[I+(z<<2)>>2]<-(e*d)))break;n[I+(z<<2)>>2]=-(e*d);break}else{if(!(d>0.0))break;if(!(+n[I+(z<<2)>>2]>-(e*d)))break;n[I+(z<<2)>>2]=-(e*d);break}}while(0);n[I+(z<<2)>>2]=+n[a+232>>2]*+n[I+(z<<2)>>2];g=5}else g=5}else g=4;if(!(b[a+297>>0]|0)){v=0.0;y=0}else{ca=+n[a+1088>>2];v=ca;y=ca>0.0?1:2}j=b[a+1112>>0]|0;r=(y|0)!=0;if(!(y|j&255)){u=fa;return}w=X(f[c+24>>2]|0,g)|0;o=f[c+12>>2]|0;f[o+(w<<2)>>2]=$;f[o+(w+1<<2)>>2]=aa;f[o+(w+2<<2)>>2]=ba;x=(f[s>>2]=$,+n[s>>2]);o=f[c+20>>2]|0;n[o+(w<<2)>>2]=-x;t=(f[s>>2]=aa,+n[s>>2]);n[o+(w+1<<2)>>2]=-t;q=(f[s>>2]=ba,+n[s>>2]);n[o+(w+2<<2)>>2]=-q;l=+n[a+192>>2];m=+n[a+196>>2];o=f[a+300>>2]|0;p=+n[(o&2048|0?a+248|0:c+4|0)>>2];if(j<<24>>24==0|r&l==m)g=I;else{if(!(o&4)){h=m;i=l}else{f[(f[c+32>>2]|0)+(w<<2)>>2]=f[a+228>>2];h=+n[a+196>>2];i=+n[a+192>>2]}d=+n[a+1084>>2];k=+n[a+1116>>2];e=p*+n[c>>2];do if(!(i>h))if(!(i==h)){if(k/e<0.0)if(d>=i?i-k/e>d:0){d=(i-d)/(k/e);break}else{d=d<i?0.0:1.0;break}if(k/e>0.0)if(d<=h?h-k/e<d:0){d=(h-d)/(k/e);break}else{d=d>h?0.0:1.0;break}else d=0.0}else d=0.0;else d=1.0;while(0);g=f[c+28>>2]|0;n[g+(w<<2)>>2]=d*k;n[(f[c+36>>2]|0)+(w<<2)>>2]=-(+n[a+1120>>2]*+n[c>>2]);n[(f[c+40>>2]|0)+(w<<2)>>2]=+n[a+1120>>2]*+n[c>>2]}if(!r){u=fa;return}g=g+(w<<2)|0;n[g>>2]=+n[g>>2]+v*p*+n[c>>2];if(o&1024|0)f[(f[c+32>>2]|0)+(w<<2)>>2]=f[a+260>>2];if(l==m){n[(f[c+36>>2]|0)+(w<<2)>>2]=-3402823466385288598117041.0e14;d=3402823466385288598117041.0e14}else{ga=(y|0)==1;n[(f[c+36>>2]|0)+(w<<2)>>2]=ga?0.0:-3402823466385288598117041.0e14;d=ga?3402823466385288598117041.0e14:0.0}n[(f[c+40>>2]|0)+(w<<2)>>2]=d;ca=1.0-+n[a+256>>2];e=+K(+ca);do if(!(ca!=ca|0.0!=0.0|ca==0.0)){c=f[a+28>>2]|0;ga=f[a+32>>2]|0;d=+n[c+328>>2]*x+ +n[c+332>>2]*t+ +n[c+336>>2]*q-(+n[ga+328>>2]*x+ +n[ga+332>>2]*t+ +n[ga+336>>2]*q);if((y|0)==1){if(!(d<0.0))break;if(!(+n[g>>2]<-(e*d)))break;n[g>>2]=-(e*d);break}else{if(!(d>0.0))break;if(!(+n[g>>2]>-(e*d)))break;n[g>>2]=-(e*d);break}}while(0);n[g>>2]=+n[a+248>>2]*+n[g>>2];u=fa;return}function Bc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0.0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0;A=u;u=u+112|0;f[a+164>>2]=1065353216;f[a+168>>2]=1065353216;f[a+172>>2]=1065353216;n[a+176>>2]=0.0;f[a+180>>2]=0;n[a+184>>2]=999999984306749440.0;f[a+188>>2]=0;f[a+188+4>>2]=0;f[a+188+8>>2]=0;f[a+188+12>>2]=0;f[a+204>>2]=1;f[a+208>>2]=-1;f[a+212>>2]=-1;f[a+216>>2]=1;n[a+220>>2]=0.0;n[a+224>>2]=.5;n[a+228>>2]=0.0;n[a+232>>2]=0.0;f[a+236>>2]=1;f[a+240>>2]=0;n[a+244>>2]=1.0;f[a+248>>2]=0;f[a+248+4>>2]=0;f[a+248+8>>2]=0;f[a+248+12>>2]=0;f[a+4>>2]=1065353216;f[a+8>>2]=0;f[a+8+4>>2]=0;f[a+8+8>>2]=0;f[a+8+12>>2]=0;f[a+24>>2]=1065353216;f[a+28>>2]=0;f[a+28+4>>2]=0;f[a+28+8>>2]=0;f[a+28+12>>2]=0;f[a+44>>2]=1065353216;f[a+48>>2]=0;f[a+48+4>>2]=0;f[a+48+8>>2]=0;f[a+48+12>>2]=0;f[a+48+16>>2]=0;f[a>>2]=3324;b[a+280>>0]=1;f[a+276>>2]=0;f[a+268>>2]=0;f[a+272>>2]=0;f[a+284>>2]=0;b[a+408>>0]=1;f[a+404>>2]=0;f[a+396>>2]=0;f[a+400>>2]=0;b[a+428>>0]=1;f[a+424>>2]=0;f[a+416>>2]=0;f[a+420>>2]=0;b[a+448>>0]=1;f[a+444>>2]=0;f[a+436>>2]=0;f[a+440>>2]=0;b[a+496>>0]=1;f[a+492>>2]=0;f[a+484>>2]=0;f[a+488>>2]=0;b[a+516>>0]=1;f[a+512>>2]=0;f[a+504>>2]=0;f[a+508>>2]=0;f[a+684>>2]=c;b[a+704>>0]=1;f[a+700>>2]=0;f[a+692>>2]=0;f[a+696>>2]=0;b[a+724>>0]=1;f[a+720>>2]=0;f[a+712>>2]=0;f[a+716>>2]=0;b[a+744>>0]=1;f[a+740>>2]=0;f[a+732>>2]=0;f[a+736>>2]=0;b[a+764>>0]=1;f[a+760>>2]=0;f[a+752>>2]=0;f[a+756>>2]=0;b[a+784>>0]=1;f[a+780>>2]=0;f[a+772>>2]=0;f[a+776>>2]=0;b[a+804>>0]=1;f[a+800>>2]=0;f[a+792>>2]=0;f[a+796>>2]=0;b[a+824>>0]=1;f[a+820>>2]=0;f[a+812>>2]=0;f[a+816>>2]=0;b[a+844>>0]=1;f[a+840>>2]=0;f[a+832>>2]=0;f[a+836>>2]=0;b[a+864>>0]=1;f[a+860>>2]=0;f[a+852>>2]=0;f[a+856>>2]=0;b[a+884>>0]=1;f[a+880>>2]=0;f[a+872>>2]=0;f[a+876>>2]=0;b[a+964>>0]=1;f[a+960>>2]=0;f[a+952>>2]=0;f[a+956>>2]=0;b[a+984>>0]=1;f[a+980>>2]=0;f[a+972>>2]=0;f[a+976>>2]=0;f[a+928>>2]=0;f[a+932>>2]=0;f[a+936>>2]=-1;f[a+940>>2]=0;f[a+944>>2]=0;b[a+1024>>0]=1;f[a+1020>>2]=0;f[a+1012>>2]=0;f[a+1016>>2]=0;b[a+1044>>0]=1;f[a+1040>>2]=0;f[a+1032>>2]=0;f[a+1036>>2]=0;f[a+988>>2]=0;f[a+992>>2]=0;f[a+996>>2]=-1;f[a+1e3>>2]=0;f[a+1004>>2]=0;b[a+1084>>0]=1;f[a+1080>>2]=0;f[a+1072>>2]=0;f[a+1076>>2]=0;b[a+1104>>0]=1;f[a+1100>>2]=0;f[a+1092>>2]=0;f[a+1096>>2]=0;f[a+1048>>2]=0;f[a+1052>>2]=0;f[a+1056>>2]=-1;f[a+1060>>2]=0;f[a+1064>>2]=0;b[a+1124>>0]=1;f[a+1120>>2]=0;f[a+1112>>2]=0;f[a+1116>>2]=0;b[a+1144>>0]=1;f[a+1140>>2]=0;f[a+1132>>2]=0;f[a+1136>>2]=0;b[a+1248>>0]=1;f[a+1244>>2]=0;f[a+1236>>2]=0;f[a+1240>>2]=0;f[a+236>>2]=8;f[a+288>>2]=0;n[a+292>>2]=1.0;f[a+296>>2]=0;f[a+296+4>>2]=0;f[a+296+8>>2]=0;f[a+296+12>>2]=0;f[a+296+16>>2]=0;n[a+316>>2]=.20000000298023224;n[a+320>>2]=0.0;n[a+324>>2]=1.0;n[a+328>>2]=.10000000149011612;n[a+332>>2]=1.0;n[a+336>>2]=.699999988079071;n[a+340>>2]=.10000000149011612;n[a+344>>2]=1.0;n[a+348>>2]=.5;n[a+352>>2]=.5;n[a+356>>2]=.5;n[a+360>>2]=.5;n[a+364>>2]=1.0;n[a+368>>2]=1.0;f[a+372>>2]=0;f[a+376>>2]=1;f[a+380>>2]=0;f[a+384>>2]=4;f[a+388>>2]=1;b[a+472>>0]=0;b[a+473>>0]=0;n[a+476>>2]=0.0;f[a+520>>2]=0;f[a+520+4>>2]=0;f[a+520+8>>2]=0;f[a+520+12>>2]=0;f[a+536>>2]=1065353216;f[a+540>>2]=0;f[a+540+4>>2]=0;f[a+540+8>>2]=0;f[a+540+12>>2]=0;f[a+556>>2]=1065353216;f[a+560>>2]=0;f[a+560+4>>2]=0;f[a+560+8>>2]=0;f[a+560+12>>2]=0;f[a+576>>2]=1065353216;n[a+580>>2]=0.0;f[a+584>>2]=1065353216;f[a+588>>2]=0;f[a+588+4>>2]=0;f[a+588+8>>2]=0;f[a+588+12>>2]=0;f[a+604>>2]=1065353216;f[a+608>>2]=0;f[a+608+4>>2]=0;f[a+608+8>>2]=0;f[a+608+12>>2]=0;f[a+624>>2]=1065353216;n[a+628>>2]=0.0;f[a+680>>2]=0;n[a+888>>2]=0.0;b[a+924>>0]=1;f[a+892>>2]=0;f[a+892+4>>2]=0;f[a+892+8>>2]=0;f[a+892+12>>2]=0;f[a+892+16>>2]=0;f[a+892+20>>2]=0;f[a+892+24>>2]=0;f[a+892+28>>2]=0;f[a+4>>2]=1065353216;f[a+8>>2]=0;f[a+8+4>>2]=0;f[a+8+8>>2]=0;f[a+8+12>>2]=0;f[a+24>>2]=1065353216;f[a+28>>2]=0;f[a+28+4>>2]=0;f[a+28+8>>2]=0;f[a+28+12>>2]=0;f[a+44>>2]=1065353216;f[a+48>>2]=0;f[a+48+4>>2]=0;f[a+48+8>>2]=0;f[a+48+12>>2]=0;f[a+48+16>>2]=0;c=f[a+404>>2]|0;if(c|0){if(b[a+408>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+404>>2]=0}b[a+408>>0]=1;f[a+404>>2]=0;f[a+396>>2]=0;f[a+400>>2]=0;c=f[a+424>>2]|0;if(c|0){if(b[a+428>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+424>>2]=0}b[a+428>>0]=1;f[a+424>>2]=0;f[a+416>>2]=0;f[a+420>>2]=0;c=f[a+444>>2]|0;do if(c)if(b[a+448>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);c=f[a+416>>2]|0;h=f[a+420>>2]|0;f[a+444>>2]=0;b[a+448>>0]=1;f[a+444>>2]=0;f[a+436>>2]=0;f[a+440>>2]=0;if((c|0)==(h|0)){v=14;break}else break}else{f[a+444>>2]=0;v=13;break}else v=13;while(0);if((v|0)==13){b[a+448>>0]=1;f[a+444>>2]=0;f[a+436>>2]=0;f[a+440>>2]=0;h=0;v=14}if((v|0)==14){l=h|0?h<<1:1;if((h|0)<(l|0)){if(!l)c=0;else{f[6472]=(f[6472]|0)+1;c=sc((l<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=f[a+416>>2]|0}j=f[a+424>>2]|0;if((h|0)<=0){if(j)v=22}else{i=0;do{f[c+(i<<2)>>2]=f[j+(i<<2)>>2];i=i+1|0}while((i|0)!=(h|0));v=22}if((v|0)==22){if(b[a+428>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=f[a+416>>2]|0}f[a+424>>2]=0}b[a+428>>0]=1;f[a+424>>2]=c;f[a+420>>2]=l;c=h;h=l}else c=h}j=f[a+424>>2]|0;f[j+(c<<2)>>2]=1;c=c+1|0;f[a+416>>2]=c;if((c|0)==(h|0)){l=h|0?h<<1:1;if((h|0)<(l|0)){if(!l)c=0;else{f[6472]=(f[6472]|0)+1;c=sc((l<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=f[a+416>>2]|0;j=f[a+424>>2]|0}if((h|0)<=0){if(j)v=35}else{i=0;do{f[c+(i<<2)>>2]=f[j+(i<<2)>>2];i=i+1|0}while((i|0)!=(h|0));v=35}if((v|0)==35){if(b[a+428>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=f[a+416>>2]|0}f[a+424>>2]=0}b[a+428>>0]=1;f[a+424>>2]=c;f[a+420>>2]=l;j=c;c=h;h=l}else c=h}f[j+(c<<2)>>2]=2;c=c+1|0;f[a+416>>2]=c;if((c|0)==(h|0)){l=h|0?h<<1:1;if((h|0)<(l|0)){if(!l)c=0;else{f[6472]=(f[6472]|0)+1;c=sc((l<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=f[a+416>>2]|0;j=f[a+424>>2]|0}if((h|0)<=0){if(j)v=48}else{i=0;do{f[c+(i<<2)>>2]=f[j+(i<<2)>>2];i=i+1|0}while((i|0)!=(h|0));v=48}if((v|0)==48){if(b[a+428>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=f[a+416>>2]|0}f[a+424>>2]=0}b[a+428>>0]=1;f[a+424>>2]=c;f[a+420>>2]=l;j=c;c=h;i=l}else{c=h;i=h}}else i=h;f[j+(c<<2)>>2]=3;h=c+1|0;f[a+416>>2]=h;if((h|0)==(i|0)){l=i|0?i<<1:1;if((i|0)<(l|0)){if(!l){c=0;h=i}else{f[6472]=(f[6472]|0)+1;c=sc((l<<2|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=f[a+416>>2]|0;j=f[a+424>>2]|0}if((h|0)<=0){if(j)v=61}else{i=0;do{f[c+(i<<2)>>2]=f[j+(i<<2)>>2];i=i+1|0}while((i|0)!=(h|0));v=61}if((v|0)==61){if(b[a+428>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=f[a+416>>2]|0}f[a+424>>2]=0}b[a+428>>0]=1;f[a+424>>2]=c;f[a+420>>2]=l}else{h=i;c=j}}else c=j;f[c+(h<<2)>>2]=0;f[a+416>>2]=h+1;f[6472]=(f[6472]|0)+1;c=sc(39)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}f[c+8>>2]=0;f[c>>2]=3432;f[c+4>>2]=32;f[c+16>>2]=a;f[a+192>>2]=c;n[c+12>>2]=.25;f[a+1148>>2]=1065353216;f[a+1152>>2]=0;f[a+1152+4>>2]=0;f[a+1152+8>>2]=0;f[a+1152+12>>2]=0;f[a+1168>>2]=1065353216;f[a+1172>>2]=0;f[a+1172+4>>2]=0;f[a+1172+8>>2]=0;f[a+1172+12>>2]=0;f[a+1188>>2]=1065353216;w=a+1192|0;x=w+36|0;do{f[w>>2]=0;w=w+4|0}while((w|0)<(x|0));n[a+1228>>2]=1.0;y=hh(a)|0;n[y+4>>2]=1.0;n[y+8>>2]=1.0;n[y+12>>2]=1.0;f[y+16>>2]=1;w=f[a+192>>2]|0;z=+rb[f[(f[w>>2]|0)+48>>2]&15](w);w=A;x=w+100|0;do{f[w>>2]=0;w=w+4|0}while((w|0)<(x|0));l=f[a+712>>2]|0;if((l|0)<(d|0)){if((f[a+716>>2]|0)<(d|0)){if(!d){c=0;i=l}else{f[6472]=(f[6472]|0)+1;c=sc((d*104|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}i=f[a+712>>2]|0}if((i|0)>0){h=0;do{w=c+(h*104|0)|0;j=(f[a+720>>2]|0)+(h*104|0)|0;x=w+104|0;do{f[w>>2]=f[j>>2];w=w+4|0;j=j+4|0}while((w|0)<(x|0));h=h+1|0}while((h|0)!=(i|0))}h=f[a+720>>2]|0;if(h|0){if(b[a+724>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+720>>2]=0}b[a+724>>0]=1;f[a+720>>2]=c;f[a+716>>2]=d;c=l}else c=l;do{w=f[a+720>>2]|0;f[w+(c*104|0)>>2]=0;w=w+(c*104|0)+4|0;j=A;x=w+100|0;do{f[w>>2]=f[j>>2];w=w+4|0;j=j+4|0}while((w|0)<(x|0));c=c+1|0}while((c|0)!=(d|0))}f[a+712>>2]=d;if((d|0)>0){c=e;h=g;j=0;while(1){v=f[a+720>>2]|0;e=v+(j*104|0)|0;w=e;x=w+104|0;do{f[w>>2]=0;w=w+4|0}while((w|0)<(x|0));if(!c){l=0;k=0.0;m=0.0;o=0.0;p=0.0}else{l=c+16|0;k=+n[c+12>>2];m=+n[c>>2];o=+n[c+4>>2];p=+n[c+8>>2]}x=v+(j*104|0)+8|0;n[x>>2]=m;n[v+(j*104|0)+12>>2]=o;n[v+(j*104|0)+16>>2]=p;n[v+(j*104|0)+20>>2]=k;g=v+(j*104|0)+24|0;f[g>>2]=f[x>>2];f[g+4>>2]=f[x+4>>2];f[g+8>>2]=f[x+8>>2];f[g+12>>2]=f[x+12>>2];if(!h){i=0;k=1.0}else{i=h+4|0;k=+n[h>>2]}n[v+(j*104|0)+88>>2]=k>0.0?1.0/k:0.0;r=m-z;s=o-z;t=p-z;q=z+m;m=z+o;k=z+p;c=f[a+932>>2]|0;if(!c){f[6472]=(f[6472]|0)+1;c=sc(63)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}w=c;x=w+44|0;do{f[w>>2]=0;w=w+4|0}while((w|0)<(x|0))}else f[a+932>>2]=0;f[c+32>>2]=0;f[c+36>>2]=e;f[c+40>>2]=0;n[c>>2]=r;n[c+4>>2]=s;n[c+8>>2]=t;n[c+12>>2]=0.0;n[c+16>>2]=q;n[c+20>>2]=m;n[c+24>>2]=k;n[c+28>>2]=0.0;ff(a+928|0,f[a+928>>2]|0,c);f[a+940>>2]=(f[a+940>>2]|0)+1;f[v+(j*104|0)+96>>2]=c;f[v+(j*104|0)+4>>2]=y;j=j+1|0;if((j|0)==(d|0))break;else{c=l;h=i}}}c=f[a+928>>2]|0;if(!c){f[a+892>>2]=0;f[a+892+4>>2]=0;f[a+892+8>>2]=0;f[a+892+12>>2]=0;f[a+892+16>>2]=0;f[a+892+20>>2]=0;f[a+892+24>>2]=0;f[a+892+28>>2]=0;u=A;return}d=f[a+192>>2]|0;s=+rb[f[(f[d>>2]|0)+48>>2]&15](d);z=+n[c+4>>2]-s;t=+n[c+8>>2]-s;n[a+892>>2]=+n[c>>2]-s;n[a+896>>2]=z;n[a+900>>2]=t;n[a+904>>2]=0.0;t=s+ +n[c+20>>2];z=s+ +n[c+24>>2];n[a+908>>2]=s+ +n[c+16>>2];n[a+912>>2]=t;n[a+916>>2]=z;n[a+920>>2]=0.0;c=f[a+188>>2]|0;if(!c){u=A;return}d=f[a+684>>2]|0;g=f[d+32>>2]|0;ac[f[(f[g>>2]|0)+16>>2]&31](g,c,a+892|0,a+908|0,f[d+36>>2]|0);u=A;return}function Cc(a,c,e){a=a|0;c=c|0;e=+e;var g=0.0,h=0,i=0.0,j=0.0,k=0,l=0.0,m=0,o=0.0,p=0.0,q=0.0,r=0,s=0;r=u;u=u+528|0;if((b[a+171>>0]|0)==0?+n[a+172>>2]<=0.0:0){u=r;return}m=(Bb[f[(f[a>>2]|0)+48>>2]&127](a)|0)&1;b[a+168>>0]=m;g=+n[a+16>>2]-+n[a+44>>2]*e;n[a+16>>2]=g;if(g>0.0?(i=+n[a+28>>2],g>i):0){n[a+16>>2]=i;g=i}if(g<0.0?(p=+K(+g),j=+K(+(+n[a+24>>2])),p>j):0){n[a+16>>2]=-j;g=-j}n[a+20>>2]=g*e;m=f[a+8>>2]|0;f[r>>2]=f[m+4>>2];f[r+4>>2]=f[m+4+4>>2];f[r+8>>2]=f[m+4+8>>2];f[r+12>>2]=f[m+4+12>>2];f[r+16>>2]=f[m+20>>2];f[r+16+4>>2]=f[m+20+4>>2];f[r+16+8>>2]=f[m+20+8>>2];f[r+16+12>>2]=f[m+20+12>>2];f[r+32>>2]=f[m+36>>2];f[r+32+4>>2]=f[m+36+4>>2];f[r+32+8>>2]=f[m+36+8>>2];f[r+32+12>>2]=f[m+36+12>>2];f[r+48>>2]=f[m+52>>2];f[r+48+4>>2]=f[m+52+4>>2];f[r+48+8>>2]=f[m+52+8>>2];f[r+48+12>>2]=f[m+52+12>>2];if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}m=f[a+176>>2]|0;j=+n[a+20>>2];j=+n[a+52>>2]+(j>0.0?j:0.0);o=+n[24652+(m<<4)+4>>2]*j+ +n[a+96>>2];p=j*+n[24652+(m<<4)+8>>2]+ +n[a+100>>2];n[a+112>>2]=+n[a+92>>2]+ +n[24652+(m<<4)>>2]*j;n[a+116>>2]=o;n[a+120>>2]=p;n[a+124>>2]=0.0;f[r+456>>2]=1065353216;f[r+456+4>>2]=0;f[r+456+4+4>>2]=0;f[r+456+4+8>>2]=0;f[r+456+4+12>>2]=0;f[r+456+20>>2]=1065353216;f[r+456+24>>2]=0;f[r+456+24+4>>2]=0;f[r+456+24+8>>2]=0;f[r+456+24+12>>2]=0;f[r+456+40>>2]=1065353216;m=r+456+44|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[m+16>>2]=0;f[r+392>>2]=1065353216;f[r+392+4>>2]=0;f[r+392+4+4>>2]=0;f[r+392+4+8>>2]=0;f[r+392+4+12>>2]=0;f[r+392+20>>2]=1065353216;f[r+392+24>>2]=0;f[r+392+24+4>>2]=0;f[r+392+24+8>>2]=0;f[r+392+24+12>>2]=0;f[r+392+40>>2]=1065353216;m=r+392+44|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[m+16>>2]=0;if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}h=f[a+176>>2]|0;m=f[a+12>>2]|0;j=+rb[f[(f[m>>2]|0)+48>>2]&15](m);j=j+ +n[a+56>>2];o=j*+n[24652+(h<<4)+4>>2]+ +n[a+96>>2];p=j*+n[24652+(h<<4)+8>>2]+ +n[a+100>>2];n[r+456+48>>2]=+n[24652+(h<<4)>>2]*j+ +n[a+92>>2];n[r+456+52>>2]=o;n[r+456+56>>2]=p;n[r+456+60>>2]=0.0;f[r+392+48>>2]=f[a+112>>2];f[r+392+48+4>>2]=f[a+112+4>>2];f[r+392+48+8>>2]=f[a+112+8>>2];f[r+392+48+12>>2]=f[a+112+12>>2];h=f[a+8>>2]|0;if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}m=f[a+176>>2]|0;j=-+n[24652+(m<<4)>>2];o=-+n[24652+(m<<4)+4>>2];p=-+n[24652+(m<<4)+8>>2];n[r+288+4>>2]=1.0;m=r+288+12|0;f[r+288+76>>2]=0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[m+16>>2]=0;f[m+20>>2]=0;f[m+24>>2]=0;f[m+28>>2]=0;f[r+288>>2]=5132;f[r+288+80>>2]=h;n[r+288+84>>2]=j;n[r+288+88>>2]=o;n[r+288+92>>2]=p;n[r+288+96>>2]=0.0;n[r+288+100>>2]=.707099974155426;h=f[a+8>>2]|0;m=f[h+188>>2]|0;d[r+288+8>>1]=d[m+4>>1]|0;d[r+288+10>>1]=d[m+6>>1]|0;if(!(b[a+170>>0]|0))Ld(c,f[a+12>>2]|0,r+456|0,r+392|0,r+288|0,0.0);else sd(h,f[a+12>>2]|0,r+456|0,r+392|0,r+288|0,+n[c+56>>2]);if(+n[r+288+4>>2]<1.0){if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}m=f[a+176>>2]|0;do if(+n[r+288+44>>2]*+n[24652+(m<<4)>>2]+ +n[r+288+48>>2]*+n[24652+(m<<4)+4>>2]+ +n[r+288+52>>2]*+n[24652+(m<<4)+8>>2]>0.0){g=+n[r+288+4>>2];n[a+108>>2]=+n[a+52>>2]*g;if(!(b[a+180>>0]|0)){f[a+92>>2]=f[a+112>>2];f[a+92+4>>2]=f[a+112+4>>2];f[a+92+8>>2]=f[a+112+8>>2];f[a+92+12>>2]=f[a+112+12>>2];break}else{n[a+92>>2]=(1.0-g)*+n[a+92>>2]+g*+n[a+112>>2];n[a+96>>2]=(1.0-g)*+n[a+96>>2]+g*+n[a+116>>2];n[a+100>>2]=(1.0-g)*+n[a+100>>2]+g*+n[a+120>>2];break}}while(0);n[a+16>>2]=0.0;n[a+20>>2]=0.0}else{f[a+108>>2]=f[a+52>>2];f[a+92>>2]=f[a+112>>2];f[a+92+4>>2]=f[a+112+4>>2];f[a+92+8>>2]=f[a+112+8>>2];f[a+92+12>>2]=f[a+112+12>>2]}if(!(b[a+171>>0]|0)){o=+n[a+172>>2];p=o>e?e:o;n[a+172>>2]=o-e;ce(a,c,p*+n[a+60>>2],p*+n[a+64>>2],p*+n[a+68>>2])}else ce(a,c,+n[a+60>>2],+n[a+64>>2],+n[a+68>>2]);f[r+272>>2]=f[a+112>>2];f[r+272+4>>2]=f[a+112+4>>2];f[r+272+8>>2]=f[a+112+8>>2];f[r+272+12>>2]=f[a+112+12>>2];g=+n[a+16>>2];g=(g<0.0?-g:0.0)*e;do if(g>0.0?(l=+n[a+24>>2],g>l):0){if((b[a+168>>0]|0)==0?b[a+169>>0]|0:0)break;g=l}while(0);if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}h=f[a+176>>2]|0;p=g+ +n[a+108>>2];l=+n[24652+(h<<4)>>2]*p;o=p*+n[24652+(h<<4)+4>>2];p=p*+n[24652+(h<<4)+8>>2];n[a+112>>2]=+n[a+112>>2]-l;n[a+116>>2]=+n[a+116>>2]-o;n[a+120>>2]=+n[a+120>>2]-p;h=f[a+8>>2]|0;if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}k=24652+(f[a+176>>2]<<4)|0;m=f[a+40>>2]|0;n[r+168+4>>2]=1.0;s=r+168+12|0;f[r+168+76>>2]=0;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[s+16>>2]=0;f[s+20>>2]=0;f[s+24>>2]=0;f[s+28>>2]=0;f[r+168>>2]=5132;f[r+168+80>>2]=h;f[r+168+84>>2]=f[k>>2];f[r+168+84+4>>2]=f[k+4>>2];f[r+168+84+8>>2]=f[k+8>>2];f[r+168+84+12>>2]=f[k+12>>2];f[r+168+100>>2]=m;h=f[a+8>>2]|0;m=f[h+188>>2]|0;d[r+168+8>>1]=d[m+4>>1]|0;d[r+168+10>>1]=d[m+6>>1]|0;if((b[22768]|0)==0?fz(22768)|0:0){f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}m=24652+(f[a+176>>2]<<4)|0;s=f[a+40>>2]|0;n[r+64+4>>2]=1.0;k=r+64+12|0;f[r+64+76>>2]=0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[k+16>>2]=0;f[k+20>>2]=0;f[k+24>>2]=0;f[k+28>>2]=0;f[r+64>>2]=5132;f[r+64+80>>2]=h;f[r+64+84>>2]=f[m>>2];f[r+64+84+4>>2]=f[m+4>>2];f[r+64+84+8>>2]=f[m+8>>2];f[r+64+84+12>>2]=f[m+12>>2];f[r+64+100>>2]=s;h=f[(f[a+8>>2]|0)+188>>2]|0;d[r+64+8>>1]=d[h+4>>1]|0;d[r+64+10>>1]=d[h+6>>1]|0;h=0;g=+n[a+112>>2];i=+n[a+116>>2];j=+n[a+120>>2];while(1){f[r+456>>2]=1065353216;f[r+456+4>>2]=0;f[r+456+4+4>>2]=0;f[r+456+4+8>>2]=0;f[r+456+4+12>>2]=0;f[r+456+20>>2]=1065353216;f[r+456+24>>2]=0;f[r+456+24+4>>2]=0;f[r+456+24+8>>2]=0;f[r+456+24+12>>2]=0;f[r+456+40>>2]=1065353216;f[r+456+44>>2]=0;f[r+392>>2]=1065353216;f[r+392+4>>2]=0;f[r+392+4+4>>2]=0;f[r+392+4+8>>2]=0;f[r+392+4+12>>2]=0;f[r+392+20>>2]=1065353216;f[r+392+24>>2]=0;f[r+392+24+4>>2]=0;f[r+392+24+8>>2]=0;f[r+392+24+12>>2]=0;f[r+392+40>>2]=1065353216;f[r+392+44>>2]=0;f[r+288>>2]=1065353216;f[r+288+4>>2]=0;f[r+288+4+4>>2]=0;f[r+288+4+8>>2]=0;f[r+288+4+12>>2]=0;f[r+288+20>>2]=1065353216;f[r+288+24>>2]=0;f[r+288+24+4>>2]=0;f[r+288+24+8>>2]=0;f[r+288+24+12>>2]=0;f[r+288+40>>2]=1065353216;f[r+288+44>>2]=0;f[r+456+48>>2]=f[a+92>>2];f[r+456+48+4>>2]=f[a+92+4>>2];f[r+456+48+8>>2]=f[a+92+8>>2];f[r+456+48+12>>2]=f[a+92+12>>2];f[r+392+48>>2]=f[a+112>>2];f[r+392+48+4>>2]=f[a+112+4>>2];f[r+392+48+8>>2]=f[a+112+8>>2];f[r+392+48+12>>2]=f[a+112+12>>2];n[r+288+48>>2]=g-l;n[r+288+52>>2]=i-o;n[r+288+56>>2]=j-p;n[r+288+60>>2]=0.0;if(!(b[a+170>>0]|0)){Ld(c,f[a+12>>2]|0,r+456|0,r+392|0,r+168|0,+n[c+56>>2]);if(!(+n[r+168+4>>2]<1.0))Ld(c,f[a+12>>2]|0,r+456|0,r+288|0,r+64|0,+n[c+56>>2])}else{sd(f[a+8>>2]|0,f[a+12>>2]|0,r+456|0,r+392|0,r+168|0,+n[c+56>>2]);if(!(+n[r+168+4>>2]<1.0))sd(f[a+8>>2]|0,f[a+12>>2]|0,r+456|0,r+288|0,r+64|0,+n[c+56>>2])}j=+n[a+16>>2];j=(j<0.0?-j:0.0)*e;m=b[a+182>>0]|0;g=+n[r+168+4>>2];if(m<<24>>24!=0&g<1.0)k=1;else k=+n[r+64+4>>2]<1.0;if(!(j>0.0))break;i=+n[a+52>>2];if(h|(!(j<i)|k^1))break;if((b[a+168>>0]|0)==0?b[a+169>>0]|0:0){h=0;break}f[a+112>>2]=f[r+272>>2];f[a+112+4>>2]=f[r+272+4>>2];f[a+112+8>>2]=f[r+272+8>>2];f[a+112+12>>2]=f[r+272+12>>2];do if(!(b[22768]|0)){if(!(fz(22768)|0))break;f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}while(0);h=f[a+176>>2]|0;g=i+ +n[a+108>>2];i=g*+n[24652+(h<<4)+4>>2];j=g*+n[24652+(h<<4)+8>>2];g=+n[a+112>>2]-+n[24652+(h<<4)>>2]*g;n[a+112>>2]=g;i=+n[a+116>>2]-i;n[a+116>>2]=i;j=+n[a+120>>2]-j;n[a+120>>2]=j;h=1}if(h|g<1.0){i=+n[a+96>>2];if(!(m<<24>>24))h=a+181|0;else{h=a+181|0;g=(b[a+181>>0]|0)==0?(i-+n[r+168+64>>2])*.5:g}q=1.0-g;n[a+92>>2]=q*+n[a+92>>2]+g*+n[a+112>>2];n[a+96>>2]=q*i+g*+n[a+116>>2];n[a+100>>2]=q*+n[a+100>>2]+g*+n[a+120>>2];b[h>>0]=0;n[a+16>>2]=0.0;n[a+20>>2]=0.0;b[a+169>>0]=0}else{b[a+181>>0]=1;do if(m<<24>>24?(q=+n[a+24>>2],j>q):0){if((b[a+168>>0]|0)==0?b[a+169>>0]|0:0)break;n[a+112>>2]=l+ +n[a+112>>2];n[a+116>>2]=o+ +n[a+116>>2];n[a+120>>2]=p+ +n[a+120>>2];do if(!(b[22768]|0)){if(!(fz(22768)|0))break;f[6163]=1065353216;f[6164]=0;f[6165]=0;f[6166]=0;f[6167]=0;f[6168]=1065353216;f[6169]=0;f[6170]=0;f[6171]=0;f[6172]=0;f[6173]=1065353216;n[6174]=0.0}while(0);s=f[a+176>>2]|0;p=q+ +n[a+108>>2];e=p*+n[24652+(s<<4)+4>>2];q=p*+n[24652+(s<<4)+8>>2];n[a+112>>2]=+n[a+112>>2]-+n[24652+(s<<4)>>2]*p;n[a+116>>2]=+n[a+116>>2]-e;n[a+120>>2]=+n[a+120>>2]-q}while(0);f[a+92>>2]=f[a+112>>2];f[a+92+4>>2]=f[a+112+4>>2];f[a+92+8>>2]=f[a+112+8>>2];f[a+92+12>>2]=f[a+112+12>>2]}f[r+48>>2]=f[a+92>>2];f[r+48+4>>2]=f[a+92+4>>2];f[r+48+8>>2]=f[a+92+8>>2];f[r+48+12>>2]=f[a+92+12>>2];s=f[a+8>>2]|0;f[s+260>>2]=(f[s+260>>2]|0)+1;f[s+4>>2]=f[r>>2];f[s+4+4>>2]=f[r+4>>2];f[s+4+8>>2]=f[r+8>>2];f[s+4+12>>2]=f[r+12>>2];f[s+20>>2]=f[r+16>>2];f[s+20+4>>2]=f[r+16+4>>2];f[s+20+8>>2]=f[r+16+8>>2];f[s+20+12>>2]=f[r+16+12>>2];f[s+36>>2]=f[r+32>>2];f[s+36+4>>2]=f[r+32+4>>2];f[s+36+8>>2]=f[r+32+8>>2];f[s+36+12>>2]=f[r+32+12>>2];f[s+52>>2]=f[r+48>>2];f[s+52+4>>2]=f[r+48+4>>2];f[s+52+8>>2]=f[r+48+8>>2];f[s+52+12>>2]=f[r+48+12>>2];u=r;return}function Dc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0.0,k=0.0,l=0,m=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0;K=u;u=u+96|0;H=f[a+56>>2]|0;if((e-c|0)==1){if(!(b[a+60>>0]|0)){p=(f[a+96>>2]|0)+(H<<6)|0;q=(f[a+76>>2]|0)+(c<<6)|0;r=p+64|0;do{f[p>>2]=f[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{I=(f[a+116>>2]|0)+(c<<4)|0;J=(f[a+136>>2]|0)+(H<<4)|0;f[J>>2]=f[I>>2];f[J+4>>2]=f[I+4>>2];f[J+8>>2]=f[I+8>>2];f[J+12>>2]=f[I+12>>2]}f[a+56>>2]=(f[a+56>>2]|0)+1;u=K;return}if((e|0)>(c|0)){l=(b[a+60>>0]|0)==0;if(l){h=f[a+76>>2]|0;g=c;i=0.0;k=0.0;m=0.0;do{i=i+(+n[h+(g<<6)+16>>2]+ +n[h+(g<<6)>>2])*.5;k=k+(+n[h+(g<<6)+20>>2]+ +n[h+(g<<6)+4>>2])*.5;m=m+(+n[h+(g<<6)+24>>2]+ +n[h+(g<<6)+8>>2])*.5;g=g+1|0}while((g|0)!=(e|0))}else{h=f[a+116>>2]|0;o=+n[a+36>>2];s=+n[a+40>>2];t=+n[a+44>>2];x=+n[a+4>>2];y=+n[a+8>>2];z=+n[a+12>>2];g=c;i=0.0;k=0.0;m=0.0;do{i=i+(+(j[h+(g<<4)+6>>1]|0)/o+x+(+(j[h+(g<<4)>>1]|0)/o+x))*.5;k=k+(+(j[h+(g<<4)+8>>1]|0)/s+y+(+(j[h+(g<<4)+2>>1]|0)/s+y))*.5;m=m+(+(j[h+(g<<4)+10>>1]|0)/t+z+(+(j[h+(g<<4)+4>>1]|0)/t+z))*.5;g=g+1|0}while((g|0)!=(e|0))}C=1.0/+(e-c|0);E=C*i;D=C*k;C=C*m;if(l){h=f[a+76>>2]|0;g=c;i=0.0;m=0.0;o=0.0;do{x=(+n[h+(g<<6)+16>>2]+ +n[h+(g<<6)>>2])*.5-E;y=(+n[h+(g<<6)+20>>2]+ +n[h+(g<<6)+4>>2])*.5-D;z=(+n[h+(g<<6)+24>>2]+ +n[h+(g<<6)+8>>2])*.5-C;i=i+x*x;m=m+y*y;o=o+z*z;g=g+1|0}while((g|0)!=(e|0));k=+(e-c|0)}else{h=f[a+116>>2]|0;k=+n[a+36>>2];s=+n[a+40>>2];t=+n[a+44>>2];x=+n[a+4>>2];y=+n[a+8>>2];z=+n[a+12>>2];g=c;i=0.0;m=0.0;o=0.0;do{N=(+(j[h+(g<<4)+6>>1]|0)/k+x+(+(j[h+(g<<4)>>1]|0)/k+x))*.5-E;M=(+(j[h+(g<<4)+8>>1]|0)/s+y+(+(j[h+(g<<4)+2>>1]|0)/s+y))*.5-D;L=(+(j[h+(g<<4)+10>>1]|0)/t+z+(+(j[h+(g<<4)+4>>1]|0)/t+z))*.5-C;i=i+N*N;m=m+M*M;o=o+L*L;g=g+1|0}while((g|0)!=(e|0));k=+(e-c|0)}}else{o=0.0;m=0.0;i=0.0;k=+(e-c|0)}L=1.0/(k+-1.0);M=L*i;N=L*m;w=(M<N?N:M)<L*o?2:M<N&1;f[K+16>>2]=0;f[K+16+4>>2]=0;f[K+16+8>>2]=0;f[K+16+12>>2]=0;if((e|0)>(c|0)){if(!(b[a+60>>0]|0)){h=f[a+76>>2]|0;g=c;m=0.0;k=0.0;i=0.0;do{m=(+n[h+(g<<6)+16>>2]+ +n[h+(g<<6)>>2])*.5+m;k=(+n[h+(g<<6)+20>>2]+ +n[h+(g<<6)+4>>2])*.5+k;i=(+n[h+(g<<6)+24>>2]+ +n[h+(g<<6)+8>>2])*.5+i;g=g+1|0}while((g|0)!=(e|0))}else{h=f[a+116>>2]|0;o=+n[a+36>>2];s=+n[a+40>>2];t=+n[a+44>>2];x=+n[a+4>>2];y=+n[a+8>>2];z=+n[a+12>>2];g=c;m=0.0;k=0.0;i=0.0;do{m=(+(j[h+(g<<4)+6>>1]|0)/o+x+(+(j[h+(g<<4)>>1]|0)/o+x))*.5+m;k=(+(j[h+(g<<4)+8>>1]|0)/s+y+(+(j[h+(g<<4)+2>>1]|0)/s+y))*.5+k;i=(+(j[h+(g<<4)+10>>1]|0)/t+z+(+(j[h+(g<<4)+4>>1]|0)/t+z))*.5+i;g=g+1|0}while((g|0)!=(e|0))}n[K+16>>2]=m;n[K+16+4>>2]=k;n[K+16+8>>2]=i;g=K+16|0}else{g=K+16|0;m=0.0;k=0.0;i=0.0}n[g>>2]=1.0/+(e-c|0)*m;n[K+16+4>>2]=1.0/+(e-c|0)*k;n[K+16+8>>2]=1.0/+(e-c|0)*i;x=+n[K+16+(w<<2)>>2];if((e|0)>(c|0)){g=c;v=c;do{h=(b[a+60>>0]|0)==0;if(h){G=f[a+76>>2]|0;i=+n[G+(v<<6)>>2];k=+n[G+(v<<6)+16>>2];m=+n[G+(v<<6)+4>>2];o=+n[G+(v<<6)+20>>2];s=+n[G+(v<<6)+8>>2];t=+n[G+(v<<6)+24>>2]}else{G=f[a+116>>2]|0;m=+n[a+36>>2];s=+n[a+40>>2];N=+n[a+44>>2];k=+n[a+4>>2];o=+n[a+8>>2];t=+n[a+12>>2];i=+(j[G+(v<<4)>>1]|0)/m+k;k=+(j[G+(v<<4)+6>>1]|0)/m+k;m=+(j[G+(v<<4)+2>>1]|0)/s+o;o=+(j[G+(v<<4)+8>>1]|0)/s+o;s=+(j[G+(v<<4)+4>>1]|0)/N+t;t=+(j[G+(v<<4)+10>>1]|0)/N+t}n[K>>2]=(k+i)*.5;n[K+4>>2]=(o+m)*.5;n[K+8>>2]=(t+s)*.5;n[K+12>>2]=0.0;if(+n[K+(w<<2)>>2]>x){if(h){h=f[a+76>>2]|0;l=h+(v<<6)|0;p=K+32|0;q=l;r=p+64|0;do{f[p>>2]=f[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=l;q=h+(g<<6)|0;r=p+64|0;do{f[p>>2]=f[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=(f[a+76>>2]|0)+(g<<6)|0;q=K+32|0;r=p+64|0;do{f[p>>2]=f[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{F=f[a+116>>2]|0;G=F+(v<<4)|0;f[K+32>>2]=f[G>>2];f[K+32+4>>2]=f[G+4>>2];f[K+32+8>>2]=f[G+8>>2];f[K+32+12>>2]=f[G+12>>2];F=F+(g<<4)|0;f[G>>2]=f[F>>2];f[G+4>>2]=f[F+4>>2];f[G+8>>2]=f[F+8>>2];f[G+12>>2]=f[F+12>>2];G=(f[a+116>>2]|0)+(g<<4)|0;f[G>>2]=f[K+32>>2];f[G+4>>2]=f[K+32+4>>2];f[G+8>>2]=f[K+32+8>>2];f[G+12>>2]=f[K+32+12>>2]}g=g+1|0}v=v+1|0}while((v|0)!=(e|0))}else g=c;if(!((g|0)>(((e-c|0)/3|0)+c|0)?(g|0)<(e+-1-((e-c|0)/3|0)|0):0))g=(e-c>>1)+c|0;G=f[a+56>>2]|0;if(!(b[a+60>>0]|0)){F=(f[a+96>>2]|0)+(G<<6)|0;f[F>>2]=f[a+20>>2];f[F+4>>2]=f[a+20+4>>2];f[F+8>>2]=f[a+20+8>>2];f[F+12>>2]=f[a+20+12>>2]}else{F=f[a+136>>2]|0;M=(+n[a+24>>2]-+n[a+8>>2])*+n[a+40>>2];N=(+n[a+28>>2]-+n[a+12>>2])*+n[a+44>>2];d[F+(G<<4)>>1]=~~((+n[a+20>>2]-+n[a+4>>2])*+n[a+36>>2])&65535&-2;d[F+(G<<4)+2>>1]=~~M&65535&-2;d[F+(G<<4)+4>>1]=~~N&65535&-2}h=f[a+56>>2]|0;if(!(b[a+60>>0]|0)){F=(f[a+96>>2]|0)+(h<<6)+16|0;f[F>>2]=f[a+4>>2];f[F+4>>2]=f[a+4+4>>2];f[F+8>>2]=f[a+4+8>>2];f[F+12>>2]=f[a+4+12>>2]}else{F=f[a+136>>2]|0;L=+n[a+4>>2];M=+n[a+8>>2];N=+n[a+12>>2];M=(M-M)*+n[a+40>>2];N=(N-N)*+n[a+44>>2];d[F+(h<<4)+6>>1]=~~((L-L)*+n[a+36>>2]+1.0)&65535|1;d[F+(h<<4)+8>>1]=~~(M+1.0)&65535|1;d[F+(h<<4)+10>>1]=~~(N+1.0)&65535|1}F=f[a+56>>2]|0;if((e|0)>(c|0)){B=b[a+60>>0]|0;A=c;do{if(!(B<<24>>24)){h=f[a+76>>2]|0;k=+n[h+(A<<6)>>2];t=+n[h+(A<<6)+4>>2];y=+n[h+(A<<6)+8>>2];o=+n[h+(A<<6)+12>>2];i=+n[h+(A<<6)+16>>2];x=+n[h+(A<<6)+20>>2];m=+n[h+(A<<6)+24>>2];s=+n[h+(A<<6)+28>>2];h=f[a+96>>2]|0;if(k<+n[h+(F<<6)>>2])n[h+(F<<6)>>2]=k;if(t<+n[h+(F<<6)+4>>2])n[h+(F<<6)+4>>2]=t;if(y<+n[h+(F<<6)+8>>2])n[h+(F<<6)+8>>2]=y;if(o<+n[h+(F<<6)+12>>2])n[h+(F<<6)+12>>2]=o;if(+n[h+(F<<6)+16>>2]<i)n[h+(F<<6)+16>>2]=i;if(+n[h+(F<<6)+20>>2]<x)n[h+(F<<6)+20>>2]=x;if(+n[h+(F<<6)+24>>2]<m)n[h+(F<<6)+24>>2]=m;if(+n[h+(F<<6)+28>>2]<s)n[h+(F<<6)+28>>2]=s}else{v=f[a+116>>2]|0;o=+n[a+36>>2];y=+n[a+40>>2];E=+n[a+44>>2];s=+n[a+4>>2];z=+n[a+8>>2];L=+n[a+12>>2];t=+n[a+4>>2];C=+n[a+8>>2];M=+n[a+12>>2];x=+n[a+36>>2];D=+n[a+40>>2];N=+n[a+44>>2];h=~~((+(j[v+(A<<4)>>1]|0)/o+s-t)*x)&65535&-2;l=~~((+(j[v+(A<<4)+2>>1]|0)/y+z-C)*D)&65535&-2;p=~~((+(j[v+(A<<4)+4>>1]|0)/E+L-M)*N)&65535&-2;q=~~((+(j[v+(A<<4)+6>>1]|0)/o+s-t)*x+1.0)&65535|1;r=~~((+(j[v+(A<<4)+8>>1]|0)/y+z-C)*D+1.0)&65535|1;v=~~((+(j[v+(A<<4)+10>>1]|0)/E+L-M)*N+1.0)&65535|1;w=f[a+136>>2]|0;if((j[w+(F<<4)>>1]|0)>(h&65535))d[w+(F<<4)>>1]=h;if((j[w+(F<<4)+6>>1]|0)<(q&65535))d[w+(F<<4)+6>>1]=q;if((j[w+(F<<4)+2>>1]|0)>(l&65535))d[w+(F<<4)+2>>1]=l;if((j[w+(F<<4)+8>>1]|0)<(r&65535))d[w+(F<<4)+8>>1]=r;if((j[w+(F<<4)+4>>1]|0)>(p&65535))d[w+(F<<4)+4>>1]=p;if((j[w+(F<<4)+10>>1]|0)<(v&65535))d[w+(F<<4)+10>>1]=v}A=A+1|0}while((A|0)!=(e|0))}f[a+56>>2]=F+1;Dc(a,c,g);A=f[a+56>>2]|0;Dc(a,g,e);w=(f[a+56>>2]|0)-H|0;g=b[a+60>>0]|0;if(g<<24>>24!=0&(w|0)>128){r=f[a+136>>2]|0;p=f[r+(F+1<<4)+12>>2]|0;p=(p|0)>-1?1:0-p|0;v=f[r+(A<<4)+12>>2]|0;v=(v|0)>-1?1:0-v|0;if((p|0)<129){q=f[a+152>>2]|0;if((q|0)==(f[a+156>>2]|0)?(I=q|0?q<<1:1,(q|0)<(I|0)):0){if(!I){g=0;l=q}else{f[6472]=(f[6472]|0)+1;g=sc(I<<5|19)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=f[a+152>>2]|0}if((l|0)>0){h=0;do{H=g+(h<<5)|0;e=(f[a+160>>2]|0)+(h<<5)|0;f[H>>2]=f[e>>2];f[H+4>>2]=f[e+4>>2];f[H+8>>2]=f[e+8>>2];f[H+12>>2]=f[e+12>>2];f[H+16>>2]=f[e+16>>2];f[H+20>>2]=f[e+20>>2];f[H+24>>2]=f[e+24>>2];f[H+28>>2]=f[e+28>>2];h=h+1|0}while((h|0)!=(l|0))}h=f[a+160>>2]|0;if(h|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=g;f[a+156>>2]=I;g=f[a+152>>2]|0}else g=q;f[a+152>>2]=g+1;I=(f[a+160>>2]|0)+(q<<5)|0;f[I>>2]=f[K+32>>2];f[I+4>>2]=f[K+32+4>>2];f[I+8>>2]=f[K+32+8>>2];f[I+12>>2]=f[K+32+12>>2];f[I+16>>2]=f[K+32+16>>2];f[I+20>>2]=f[K+32+20>>2];f[I+24>>2]=f[K+32+24>>2];f[I+28>>2]=f[K+32+28>>2];I=f[a+160>>2]|0;d[I+(q<<5)>>1]=d[r+(F+1<<4)>>1]|0;d[I+(q<<5)+2>>1]=d[r+(F+1<<4)+2>>1]|0;d[I+(q<<5)+4>>1]=d[r+(F+1<<4)+4>>1]|0;d[I+(q<<5)+6>>1]=d[r+(F+1<<4)+6>>1]|0;d[I+(q<<5)+8>>1]=d[r+(F+1<<4)+8>>1]|0;d[I+(q<<5)+10>>1]=d[r+(F+1<<4)+10>>1]|0;f[I+(q<<5)+12>>2]=F+1;f[I+(q<<5)+16>>2]=p}if((v|0)<129){p=f[a+152>>2]|0;if((p|0)==(f[a+156>>2]|0)?(J=p|0?p<<1:1,(p|0)<(J|0)):0){if(!J){g=0;l=p}else{f[6472]=(f[6472]|0)+1;g=sc(J<<5|19)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=f[a+152>>2]|0}if((l|0)>0){h=0;do{I=g+(h<<5)|0;H=(f[a+160>>2]|0)+(h<<5)|0;f[I>>2]=f[H>>2];f[I+4>>2]=f[H+4>>2];f[I+8>>2]=f[H+8>>2];f[I+12>>2]=f[H+12>>2];f[I+16>>2]=f[H+16>>2];f[I+20>>2]=f[H+20>>2];f[I+24>>2]=f[H+24>>2];f[I+28>>2]=f[H+28>>2];h=h+1|0}while((h|0)!=(l|0))}h=f[a+160>>2]|0;if(h|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=g;f[a+156>>2]=J;g=f[a+152>>2]|0}else g=p;f[a+152>>2]=g+1;g=(f[a+160>>2]|0)+(p<<5)|0;f[g>>2]=f[K+32>>2];f[g+4>>2]=f[K+32+4>>2];f[g+8>>2]=f[K+32+8>>2];f[g+12>>2]=f[K+32+12>>2];f[g+16>>2]=f[K+32+16>>2];f[g+20>>2]=f[K+32+20>>2];f[g+24>>2]=f[K+32+24>>2];f[g+28>>2]=f[K+32+28>>2];g=f[a+160>>2]|0;d[g+(p<<5)>>1]=d[r+(A<<4)>>1]|0;d[g+(p<<5)+2>>1]=d[r+(A<<4)+2>>1]|0;d[g+(p<<5)+4>>1]=d[r+(A<<4)+4>>1]|0;d[g+(p<<5)+6>>1]=d[r+(A<<4)+6>>1]|0;d[g+(p<<5)+8>>1]=d[r+(A<<4)+8>>1]|0;d[g+(p<<5)+10>>1]=d[r+(A<<4)+10>>1]|0;f[g+(p<<5)+12>>2]=A;f[g+(p<<5)+16>>2]=v;g=a+152|0}else g=a+152|0;f[a+168>>2]=f[g>>2];g=b[a+60>>0]|0}if(!(g<<24>>24)){f[(f[a+96>>2]|0)+(G<<6)+32>>2]=w;u=K;return}else{f[(f[a+136>>2]|0)+(G<<4)+12>>2]=0-w;u=K;return}}function Ec(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0;ha=u;u=u+176|0;ea=f[c+4>>2]|0;fa=f[d+4>>2]|0;if((f[ea+68>>2]|0)==(f[a+40>>2]|0)?(f[fa+68>>2]|0)==(f[a+44>>2]|0):0)da=a+8|0;else{h=f[a+8>>2]|0;j=f[h+8>>2]|0;if((j|0)>0){i=0;do{k=f[(f[h+16>>2]|0)+(i*12|0)+8>>2]|0;if(k|0){Lb[f[f[k>>2]>>2]&511](k);da=f[a+4>>2]|0;Rb[f[(f[da>>2]|0)+60>>2]&127](da,k)}i=i+1|0}while((i|0)!=(j|0));h=f[a+8>>2]|0}Th(h);da=a+8|0}b[ha+128+16>>0]=1;o=ha+128+12|0;f[o>>2]=0;f[ha+128+4>>2]=0;f[ha+128+8>>2]=0;m=f[da>>2]|0;h=f[m+8>>2]|0;if((h|0)>0){l=0;do{i=f[(f[m+16>>2]|0)+(l*12|0)+8>>2]|0;if(i){Rb[f[(f[i>>2]|0)+16>>2]&127](i,ha+128|0);h=f[ha+128+4>>2]|0;if((h|0)>0){k=0;do{j=f[(f[o>>2]|0)+(k<<2)>>2]|0;if(f[j+748>>2]|0){f[g+4>>2]=j;h=f[j+740>>2]|0;i=f[(f[g+8>>2]|0)+8>>2]|0;if((h|0)==(i|0))df(j,h+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);else df(j,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,i+4|0);f[g+4>>2]=0;h=f[ha+128+4>>2]|0}k=k+1|0}while((k|0)<(h|0))}if((h|0)<0){if((f[ha+128+8>>2]|0)<0){i=f[o>>2]|0;if(i|0){if(b[ha+128+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[o>>2]=0}b[ha+128+16>>0]=1;f[o>>2]=0;f[ha+128+8>>2]=0}do{f[(f[o>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=0)}f[ha+128+4>>2]=0;h=f[m+8>>2]|0}l=l+1|0}while((l|0)<(h|0));h=f[o>>2]|0;if(h|0){if(b[ha+128+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[o>>2]=0}}i=f[ea+64>>2]|0;j=f[fa+64>>2]|0;s=f[a+4>>2]|0;t=f[da>>2]|0;v=f[a+32>>2]|0;f[ha+128>>2]=6448;f[ha+128+4>>2]=0;f[ha+128+8>>2]=c;f[ha+128+12>>2]=d;f[ha+128+16>>2]=s;f[ha+128+20>>2]=e;f[ha+128+24>>2]=g;f[ha+128+28>>2]=t;f[ha+128+32>>2]=v;v=f[c+12>>2]|0;F=+n[v>>2];G=+n[v+16>>2];H=+n[v+32>>2];I=+n[v+4>>2];J=+n[v+20>>2];L=+n[v+36>>2];M=+n[v+8>>2];N=+n[v+24>>2];O=+n[v+40>>2];P=-+n[v+48>>2];Q=-+n[v+52>>2];R=-+n[v+56>>2];v=f[d+12>>2]|0;S=+n[v>>2];T=+n[v+16>>2];U=+n[v+32>>2];V=+n[v+4>>2];W=+n[v+20>>2];X=+n[v+36>>2];Y=+n[v+8>>2];Z=+n[v+24>>2];_=+n[v+40>>2];$=+n[v+48>>2];aa=+n[v+52>>2];ba=+n[v+56>>2];i=f[i>>2]|0;j=f[j>>2]|0;if((i|0)!=0&(j|0)!=0){f[6472]=(f[6472]|0)+1;h=sc(1043)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}f[h>>2]=i;f[h+4>>2]=j;w=+K(+(F*S+G*T+H*U));x=+K(+(F*V+G*W+H*X));y=+K(+(F*Y+G*Z+H*_));z=+K(+(I*S+J*T+L*U));A=+K(+(I*V+J*W+L*X));B=+K(+(I*Y+J*Z+L*_));C=+K(+(M*S+N*T+O*U));D=+K(+(M*V+N*W+O*X));E=+K(+(M*Y+N*Z+O*_));p=1;m=124;o=128;r=h;l=128;e=h;k=h;j=h;while(1){v=p+-1|0;s=f[r+(v<<3)>>2]|0;t=f[r+(v<<3)+4>>2]|0;sa=+n[t+16>>2];ra=+n[t>>2];qa=+n[t+20>>2];pa=+n[t+4>>2];oa=+n[t+24>>2];ia=+n[t+8>>2];na=F*P+G*Q+H*R+(F*$+G*aa+H*ba)+((F*S+G*T+H*U)*(sa+ra)*.5+(F*V+G*W+H*X)*(qa+pa)*.5+(F*Y+G*Z+H*_)*(oa+ia)*.5);la=I*P+J*Q+L*R+(I*$+J*aa+L*ba)+((I*S+J*T+L*U)*(sa+ra)*.5+(I*V+J*W+L*X)*(qa+pa)*.5+(I*Y+J*Z+L*_)*(oa+ia)*.5);ja=M*P+N*Q+O*R+(M*$+N*aa+O*ba)+((M*S+N*T+O*U)*(sa+ra)*.5+(M*V+N*W+O*X)*(qa+pa)*.5+(M*Y+N*Z+O*_)*(oa+ia)*.5);ma=w*((sa-ra)*.5+0.0)+x*((qa-pa)*.5+0.0)+y*((oa-ia)*.5+0.0);ka=z*((sa-ra)*.5+0.0)+A*((qa-pa)*.5+0.0)+B*((oa-ia)*.5+0.0);ia=C*((sa-ra)*.5+0.0)+D*((qa-pa)*.5+0.0)+E*((oa-ia)*.5+0.0);do if(((((+n[s>>2]<=ma+na?+n[s+16>>2]>=na-ma:0)?+n[s+4>>2]<=ka+la:0)?+n[s+20>>2]>=la-ka:0)?+n[s+8>>2]<=ia+ja:0)?+n[s+24>>2]>=ja-ia:0){if((v|0)>(m|0)){q=l<<1;do if((l|0)<(q|0)&(o|0)<(q|0)){do if(!l){j=0;h=0;ca=52}else{f[6472]=(f[6472]|0)+1;h=sc((l<<4|3)+16|0)|0;if(!h)i=0;else{f[(h+4+15&-16)+-4>>2]=h;i=h+4+15&-16}if((l|0)>0)h=0;else{j=i;h=i;ca=52;break}do{m=r+(h<<3)|0;o=f[m+4>>2]|0;g=i+(h<<3)|0;f[g>>2]=f[m>>2];f[g+4>>2]=o;h=h+1|0}while((h|0)!=(l|0));j=i;h=i}while(0);if((ca|0)==52){ca=0;if(!r){l=q;k=j;m=j;i=j;break}}if(!e){l=q;k=j;m=j;i=j}else{f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);l=q;k=j;m=j;i=j}}else{l=o;h=r;m=j;i=e}while(0);g=q+-4|0;o=l;l=q;e=i}else{g=m;h=r;m=j}i=(f[t+40>>2]|0)!=0;if(!(f[s+40>>2]|0))if(i){j=f[t+36>>2]|0;f[h+(v<<3)>>2]=s;f[h+(v<<3)+4>>2]=j;j=f[t+40>>2]|0;f[h+(p<<3)>>2]=s;f[h+(p<<3)+4>>2]=j;p=p+1|0;j=m;i=e;break}else{Vb[f[(f[ha+128>>2]|0)+8>>2]&127](ha+128|0,s,t);p=v;j=m;i=e;break}else{j=f[s+36>>2]|0;if(i){i=f[t+36>>2]|0;f[h+(v<<3)>>2]=j;f[h+(v<<3)+4>>2]=i;v=f[t+36>>2]|0;i=p+1|0;f[h+(p<<3)>>2]=f[s+40>>2];f[h+(p<<3)+4>>2]=v;v=f[t+40>>2]|0;j=p+2|0;f[h+(i<<3)>>2]=f[s+36>>2];f[h+(i<<3)+4>>2]=v;i=f[t+40>>2]|0;f[h+(j<<3)>>2]=f[s+40>>2];f[h+(j<<3)+4>>2]=i;p=p+3|0;j=m;i=e;break}else{f[h+(v<<3)>>2]=j;f[h+(v<<3)+4>>2]=t;f[h+(p<<3)>>2]=f[s+40>>2];f[h+(p<<3)+4>>2]=t;p=p+1|0;j=m;i=e;break}}}else{p=v;g=m;h=r;i=e}while(0);if(!p)break;else{m=g;r=h;e=i}}if(!((h|0)==0|(k|0)==0)){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0)}}o=f[da>>2]|0;if((f[o+8>>2]|0)>0){m=0;do{h=f[o+16>>2]|0;i=f[h+(m*12|0)+8>>2]|0;do if(i|0){ca=f[h+(m*12|0)>>2]|0;v=f[ea+24>>2]|0;t=f[v+(ca*80|0)+64>>2]|0;s=f[c+12>>2]|0;sa=+n[s>>2];T=+n[s+4>>2];S=+n[s+8>>2];pa=+n[s+16>>2];na=+n[s+20>>2];la=+n[s+24>>2];oa=+n[s+32>>2];ka=+n[s+36>>2];Y=+n[s+40>>2];ja=+n[v+(ca*80|0)>>2];ia=+n[v+(ca*80|0)+16>>2];ba=+n[v+(ca*80|0)+32>>2];aa=+n[v+(ca*80|0)+4>>2];$=+n[v+(ca*80|0)+20>>2];_=+n[v+(ca*80|0)+36>>2];ma=+n[v+(ca*80|0)+8>>2];Z=+n[v+(ca*80|0)+24>>2];X=+n[v+(ca*80|0)+40>>2];ra=+n[v+(ca*80|0)+48>>2];qa=+n[v+(ca*80|0)+52>>2];U=+n[v+(ca*80|0)+56>>2];W=+n[s+48>>2]+(sa*ra+T*qa+S*U);V=+n[s+52>>2]+(pa*ra+na*qa+la*U);U=+n[s+56>>2]+(oa*ra+ka*qa+Y*U);n[ha>>2]=sa*ja+T*ia+S*ba;n[ha+4>>2]=sa*aa+T*$+S*_;n[ha+8>>2]=sa*ma+T*Z+S*X;n[ha+12>>2]=0.0;n[ha+16>>2]=pa*ja+na*ia+la*ba;n[ha+20>>2]=pa*aa+na*$+la*_;n[ha+24>>2]=pa*ma+na*Z+la*X;n[ha+28>>2]=0.0;n[ha+32>>2]=oa*ja+ka*ia+Y*ba;n[ha+36>>2]=oa*aa+ka*$+Y*_;n[ha+40>>2]=oa*ma+ka*Z+Y*X;n[ha+44>>2]=0.0;n[ha+48>>2]=W;n[ha+52>>2]=V;n[ha+56>>2]=U;n[ha+60>>2]=0.0;Yb[f[(f[t>>2]|0)+8>>2]&127](t,ha,ha+112|0,ha+96|0);t=f[(f[o+16>>2]|0)+(m*12|0)+4>>2]|0;s=f[fa+24>>2]|0;ca=f[s+(t*80|0)+64>>2]|0;v=f[d+12>>2]|0;U=+n[v>>2];V=+n[v+4>>2];W=+n[v+8>>2];X=+n[v+16>>2];Y=+n[v+20>>2];Z=+n[v+24>>2];ka=+n[v+32>>2];ma=+n[v+36>>2];oa=+n[v+40>>2];_=+n[s+(t*80|0)>>2];$=+n[s+(t*80|0)+16>>2];aa=+n[s+(t*80|0)+32>>2];ba=+n[s+(t*80|0)+4>>2];ia=+n[s+(t*80|0)+20>>2];ja=+n[s+(t*80|0)+36>>2];la=+n[s+(t*80|0)+8>>2];na=+n[s+(t*80|0)+24>>2];pa=+n[s+(t*80|0)+40>>2];S=+n[s+(t*80|0)+48>>2];T=+n[s+(t*80|0)+52>>2];sa=+n[s+(t*80|0)+56>>2];qa=+n[v+48>>2]+(U*S+V*T+W*sa);ra=+n[v+52>>2]+(X*S+Y*T+Z*sa);sa=+n[v+56>>2]+(ka*S+ma*T+oa*sa);n[ha>>2]=U*_+V*$+W*aa;n[ha+4>>2]=U*ba+V*ia+W*ja;n[ha+8>>2]=U*la+V*na+W*pa;n[ha+12>>2]=0.0;n[ha+16>>2]=X*_+Y*$+Z*aa;n[ha+20>>2]=X*ba+Y*ia+Z*ja;n[ha+24>>2]=X*la+Y*na+Z*pa;n[ha+28>>2]=0.0;n[ha+32>>2]=ka*_+ma*$+oa*aa;n[ha+36>>2]=ka*ba+ma*ia+oa*ja;n[ha+40>>2]=ka*la+ma*na+oa*pa;n[ha+44>>2]=0.0;n[ha+48>>2]=qa;n[ha+52>>2]=ra;n[ha+56>>2]=sa;n[ha+60>>2]=0.0;Yb[f[(f[ca>>2]|0)+8>>2]&127](ca,ha,ha+80|0,ha+64|0);if(!(+n[ha+112>>2]>+n[ha+64>>2])?!(+n[ha+96>>2]<+n[ha+80>>2]):0)h=1;else h=0;if(!(!(+n[ha+112+8>>2]>+n[ha+64+8>>2])?!(+n[ha+96+8>>2]<+n[ha+80+8>>2]):0))h=0;if(!(+n[ha+112+4>>2]>+n[ha+64+4>>2])?!(+n[ha+96+4>>2]<+n[ha+80+4>>2]|h^1):0)break;Lb[f[f[i>>2]>>2]&511](i);l=f[a+4>>2]|0;Rb[f[(f[l>>2]|0)+60>>2]&127](l,i);l=f[o+16>>2]|0;k=f[l+(m*12|0)>>2]|0;l=f[l+(m*12|0)+4>>2]|0;i=f[a+16>>2]|0;if((i|0)==(f[a+20>>2]|0)?(ga=i|0?i<<1:1,(i|0)<(ga|0)):0){if(!ga)h=0;else{f[6472]=(f[6472]|0)+1;h=sc((ga*12|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}i=f[a+16>>2]|0}if((i|0)>0){j=0;do{ca=h+(j*12|0)|0;v=(f[a+24>>2]|0)+(j*12|0)|0;f[ca>>2]=f[v>>2];f[ca+4>>2]=f[v+4>>2];f[ca+8>>2]=f[v+8>>2];j=j+1|0}while((j|0)!=(i|0))}i=f[a+24>>2]|0;if(i|0){if(b[a+28>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+24>>2]=0}b[a+28>>0]=1;f[a+24>>2]=h;f[a+20>>2]=ga;h=f[a+16>>2]|0}else h=i;ca=f[a+24>>2]|0;f[ca+(h*12|0)>>2]=k;f[ca+(h*12|0)+4>>2]=l;f[ca+(h*12|0)+8>>2]=0;f[a+16>>2]=(f[a+16>>2]|0)+1}while(0);m=m+1|0}while((m|0)<(f[o+8>>2]|0));i=a+24|0;j=a+16|0}else{i=a+24|0;j=a+16|0}if((f[j>>2]|0)>0){h=0;do{d=f[da>>2]|0;ga=f[i>>2]|0;Fb[f[(f[d>>2]|0)+8>>2]&63](d,f[ga+(h*12|0)>>2]|0,f[ga+(h*12|0)+4>>2]|0)|0;h=h+1|0}while((h|0)<(f[j>>2]|0))}h=f[i>>2]|0;if(!h){b[a+28>>0]=1;f[i>>2]=0;f[j>>2]=0;a=a+20|0;f[a>>2]=0;u=ha;return}if(b[a+28>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[i>>2]=0;b[a+28>>0]=1;f[i>>2]=0;f[j>>2]=0;a=a+20|0;f[a>>2]=0;u=ha;return}function Fc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0;s=u;u=u+208|0;e=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Sb[f[(f[e>>2]|0)+56>>2]&7](e,b,1.0);e=f[c+4>>2]|0;switch(e|0){case 31:{e=f[c+16>>2]|0;if((e|0)<=0){u=s;return}do{r=e;e=e+-1|0;q=f[c+24>>2]|0;E=+n[q+(e*80|0)>>2];B=+n[q+(e*80|0)+4>>2];y=+n[q+(e*80|0)+8>>2];D=+n[q+(e*80|0)+16>>2];A=+n[q+(e*80|0)+20>>2];w=+n[q+(e*80|0)+24>>2];C=+n[q+(e*80|0)+32>>2];z=+n[q+(e*80|0)+36>>2];t=+n[q+(e*80|0)+40>>2];M=+n[q+(e*80|0)+48>>2];L=+n[q+(e*80|0)+52>>2];j=+n[q+(e*80|0)+56>>2];q=f[q+(e*80|0)+64>>2]|0;p=f[(f[a>>2]|0)+28>>2]|0;K=+n[b>>2];J=+n[b+4>>2];I=+n[b+8>>2];H=+n[b+16>>2];G=+n[b+20>>2];F=+n[b+24>>2];x=+n[b+32>>2];v=+n[b+36>>2];g=+n[b+40>>2];h=M*K+L*J+j*I+ +n[b+48>>2];i=M*H+L*G+j*F+ +n[b+52>>2];j=M*x+L*v+j*g+ +n[b+56>>2];n[s+144>>2]=E*K+D*J+C*I;n[s+144+4>>2]=B*K+A*J+z*I;n[s+144+8>>2]=y*K+w*J+t*I;n[s+144+12>>2]=0.0;n[s+144+16>>2]=E*H+D*G+C*F;n[s+144+20>>2]=B*H+A*G+z*F;n[s+144+24>>2]=y*H+w*G+t*F;n[s+144+28>>2]=0.0;n[s+144+32>>2]=E*x+D*v+C*g;n[s+144+36>>2]=B*x+A*v+z*g;n[s+144+40>>2]=y*x+w*v+t*g;n[s+144+44>>2]=0.0;n[s+144+48>>2]=h;n[s+144+52>>2]=i;n[s+144+56>>2]=j;n[s+144+60>>2]=0.0;Yb[p&127](a,s+144|0,q,d)}while((r|0)>1);u=s;return}case 0:{f[s+144>>2]=f[c+28>>2];f[s+144+4>>2]=f[c+28+4>>2];f[s+144+8>>2]=f[c+28+8>>2];f[s+144+12>>2]=f[c+28+12>>2];K=+rb[f[(f[c>>2]|0)+48>>2]&15](c);L=+rb[f[(f[c>>2]|0)+48>>2]&15](c);M=+rb[f[(f[c>>2]|0)+48>>2]&15](c);K=K+ +n[s+144>>2];n[s+144>>2]=K;L=L+ +n[s+144+4>>2];n[s+144+4>>2]=L;M=M+ +n[s+144+8>>2];n[s+144+8>>2]=M;c=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;a=f[(f[c>>2]|0)+72>>2]|0;n[s+112>>2]=-K;n[s+112+4>>2]=-L;n[s+112+8>>2]=-M;n[s+112+12>>2]=0.0;ac[a&31](c,s+112|0,s+144|0,b,d);u=s;return}case 8:{M=+rb[f[(f[c>>2]|0)+48>>2]&15](c);c=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Qb[f[(f[c>>2]|0)+16>>2]&0](c,M,b,d);u=s;return}case 9:{e=f[c+92>>2]|0;if((e|0)<=0){u=s;return}do{r=e;e=e+-1|0;q=f[c+100>>2]|0;y=+n[q+(e<<4)>>2];z=+n[q+(e<<4)+4>>2];L=+n[q+(e<<4)+8>>2];q=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;p=f[(f[q>>2]|0)+16>>2]|0;M=+n[(f[c+120>>2]|0)+(e<<2)>>2];B=+n[b>>2];C=+n[b+4>>2];A=+n[b+8>>2];E=+n[b+16>>2];F=+n[b+20>>2];D=+n[b+24>>2];H=+n[b+32>>2];I=+n[b+36>>2];G=+n[b+40>>2];J=y*B+z*C+L*A+ +n[b+48>>2];K=y*E+z*F+L*D+ +n[b+52>>2];L=y*H+z*I+L*G+ +n[b+56>>2];n[s+144>>2]=B+C*0.0+A*0.0;n[s+144+4>>2]=B*0.0+C+A*0.0;n[s+144+8>>2]=A+(B*0.0+C*0.0);n[s+144+12>>2]=0.0;n[s+144+16>>2]=E+F*0.0+D*0.0;n[s+144+20>>2]=E*0.0+F+D*0.0;n[s+144+24>>2]=D+(E*0.0+F*0.0);n[s+144+28>>2]=0.0;n[s+144+32>>2]=H+I*0.0+G*0.0;n[s+144+36>>2]=H*0.0+I+G*0.0;n[s+144+40>>2]=G+(H*0.0+I*0.0);n[s+144+44>>2]=0.0;n[s+144+48>>2]=J;n[s+144+52>>2]=K;n[s+144+56>>2]=L;n[s+144+60>>2]=0.0;Qb[p&0](q,M,s+144|0,d)}while((r|0)>1);u=s;return}case 10:{r=f[c+52>>2]|0;L=+n[c+28+(((r+2|0)%3|0)<<2)>>2];M=+n[c+28+(r<<2)>>2];c=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Ob[f[(f[c>>2]|0)+76>>2]&0](c,L,M,r,b,d);u=s;return}case 11:{L=+n[c+56>>2];M=+n[c+60>>2];c=f[c+68>>2]|0;a=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Ob[f[(f[a>>2]|0)+84>>2]&0](a,L,M,c,b,d);u=s;return}case 13:{r=f[c+52>>2]|0;L=+rb[f[(f[c>>2]|0)+92>>2]&15](c);f[s+128>>2]=f[c+28>>2];f[s+128+4>>2]=f[c+28+4>>2];f[s+128+8>>2]=f[c+28+8>>2];f[s+128+12>>2]=f[c+28+12>>2];J=+rb[f[(f[c>>2]|0)+48>>2]&15](c);K=+rb[f[(f[c>>2]|0)+48>>2]&15](c);M=+rb[f[(f[c>>2]|0)+48>>2]&15](c);n[s+128>>2]=J+ +n[s+128>>2];n[s+128+4>>2]=K+ +n[s+128+4>>2];n[s+128+8>>2]=M+ +n[s+128+8>>2];M=+n[s+128+(r<<2)>>2];c=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Ob[f[(f[c>>2]|0)+80>>2]&0](c,L,M,r,b,d);u=s;return}case 28:{M=+n[c+64>>2];a=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Ub[f[(f[a>>2]|0)+88>>2]&0](a,c+48|0,M,b,d);u=s;return}default:{a:do if((e|0)<7){q=f[c+52>>2]|0;if(!q){if((Bb[f[(f[c>>2]|0)+100>>2]&127](c)|0)<=0)break;e=0;while(1){Yb[f[(f[c>>2]|0)+104>>2]&127](c,e,s+144|0,s+112|0);K=+n[s+144>>2];y=+n[b>>2];I=+n[s+144+4>>2];z=+n[b+4>>2];G=+n[s+144+8>>2];A=+n[b+8>>2];C=+n[b+16>>2];D=+n[b+20>>2];E=+n[b+24>>2];H=+n[b+32>>2];J=+n[b+36>>2];L=+n[b+40>>2];B=+n[b+48>>2];F=+n[b+52>>2];M=+n[b+56>>2];n[s+16>>2]=K*y+I*z+G*A+B;n[s+16+4>>2]=K*C+I*D+G*E+F;n[s+16+8>>2]=K*H+I*J+G*L+M;n[s+16+12>>2]=0.0;G=+n[s+112>>2];I=+n[s+112+4>>2];K=+n[s+112+8>>2];n[s>>2]=G*y+I*z+K*A+B;n[s+4>>2]=G*C+I*D+K*E+F;n[s+8>>2]=G*H+I*J+K*L+M;n[s+12>>2]=0.0;r=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;Yb[f[(f[r>>2]|0)+8>>2]&127](r,s+16|0,s,d);e=e+1|0;if((e|0)>=(Bb[f[(f[c>>2]|0)+100>>2]&127](c)|0))break a}}if((f[q+28>>2]|0)>0){p=0;do{e=f[q+36>>2]|0;o=f[e+(p*36|0)+4>>2]|0;b:do if((o|0)!=0?(r=f[e+(p*36|0)+12>>2]|0,(o|0)>0):0){e=0;l=f[r+(o+-1<<2)>>2]|0;k=r;g=0.0;h=0.0;j=0.0;while(1){m=f[k+(e<<2)>>2]|0;k=f[q+16>>2]|0;g=g+ +n[k+(m<<4)>>2];h=h+ +n[k+(m<<4)+4>>2];j=j+ +n[k+(m<<4)+8>>2];k=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;N=f[(f[k>>2]|0)+8>>2]|0;O=f[q+16>>2]|0;K=+n[O+(l<<4)>>2];y=+n[b>>2];I=+n[O+(l<<4)+4>>2];z=+n[b+4>>2];G=+n[O+(l<<4)+8>>2];A=+n[b+8>>2];C=+n[b+16>>2];D=+n[b+20>>2];E=+n[b+24>>2];H=+n[b+32>>2];J=+n[b+36>>2];L=+n[b+40>>2];B=+n[b+48>>2];F=+n[b+52>>2];M=+n[b+56>>2];n[s+144>>2]=K*y+I*z+G*A+B;n[s+144+4>>2]=K*C+I*D+G*E+F;n[s+144+8>>2]=K*H+I*J+G*L+M;n[s+144+12>>2]=0.0;G=+n[O+(m<<4)>>2];I=+n[O+(m<<4)+4>>2];K=+n[O+(m<<4)+8>>2];n[s+112>>2]=G*y+I*z+K*A+B;n[s+112+4>>2]=G*C+I*D+K*E+F;n[s+112+8>>2]=G*H+I*J+K*L+M;n[s+112+12>>2]=0.0;Yb[N&127](k,s+144|0,s+112|0,d);e=e+1|0;k=f[q+36>>2]|0;if((e|0)>=(f[k+(p*36|0)+4>>2]|0))break b;l=m;k=f[k+(p*36|0)+12>>2]|0}}else{g=0.0;h=0.0;j=0.0}while(0);i=1.0/+(o|0)*g;h=1.0/+(o|0)*h;g=1.0/+(o|0)*j;O=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;if((Bb[f[(f[O>>2]|0)+48>>2]&127](O)|0)&16384|0){f[s+144>>2]=1065353216;f[s+144+4>>2]=1065353216;f[s+144+8>>2]=0;n[s+144+12>>2]=0.0;O=f[q+36>>2]|0;G=+n[O+(p*36|0)+20>>2];I=+n[O+(p*36|0)+24>>2];K=+n[O+(p*36|0)+28>>2];O=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;N=f[(f[O>>2]|0)+8>>2]|0;y=+n[b>>2];z=+n[b+4>>2];A=+n[b+8>>2];C=+n[b+16>>2];D=+n[b+20>>2];E=+n[b+24>>2];H=+n[b+32>>2];J=+n[b+36>>2];L=+n[b+40>>2];B=+n[b+48>>2];F=+n[b+52>>2];M=+n[b+56>>2];n[s+112>>2]=i*y+h*z+g*A+B;n[s+112+4>>2]=i*C+h*D+g*E+F;n[s+112+8>>2]=i*H+h*J+g*L+M;n[s+112+12>>2]=0.0;n[s+16>>2]=(i+G)*y+(h+I)*z+(g+K)*A+B;n[s+16+4>>2]=(i+G)*C+(h+I)*D+(g+K)*E+F;n[s+16+8>>2]=(i+G)*H+(h+I)*J+(g+K)*L+M;n[s+16+12>>2]=0.0;Yb[N&127](O,s+112|0,s+16|0,s+144|0)}p=p+1|0}while((p|0)<(f[q+28>>2]|0))}}while(0);e=f[c+4>>2]|0;if((e+-21|0)>>>0<9){f[s+144>>2]=1566444395;f[s+144+4>>2]=1566444395;f[s+144+8>>2]=1566444395;n[s+144+12>>2]=0.0;f[s+112>>2]=-581039253;f[s+112+4>>2]=-581039253;f[s+112+8>>2]=-581039253;n[s+112+12>>2]=0.0;e=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;f[s+16>>2]=6012;f[s+16+4>>2]=6036;f[s+16+8>>2]=e;f[s+16+12>>2]=f[d>>2];f[s+16+12+4>>2]=f[d+4>>2];f[s+16+12+8>>2]=f[d+8>>2];f[s+16+12+12>>2]=f[d+12>>2];f[s+16+28>>2]=f[b>>2];f[s+16+28+4>>2]=f[b+4>>2];f[s+16+28+8>>2]=f[b+8>>2];f[s+16+28+12>>2]=f[b+12>>2];f[s+16+44>>2]=f[b+16>>2];f[s+16+44+4>>2]=f[b+16+4>>2];f[s+16+44+8>>2]=f[b+16+8>>2];f[s+16+44+12>>2]=f[b+16+12>>2];f[s+16+60>>2]=f[b+32>>2];f[s+16+60+4>>2]=f[b+32+4>>2];f[s+16+60+8>>2]=f[b+32+8>>2];f[s+16+60+12>>2]=f[b+32+12>>2];f[s+16+76>>2]=f[b+48>>2];f[s+16+76+4>>2]=f[b+48+4>>2];f[s+16+76+8>>2]=f[b+48+8>>2];f[s+16+76+12>>2]=f[b+48+12>>2];Yb[f[(f[c>>2]|0)+64>>2]&127](c,s+16|0,s+112|0,s+144|0);e=f[c+4>>2]|0}if((e|0)!=3){u=s;return}f[s+144>>2]=1566444395;f[s+144+4>>2]=1566444395;f[s+144+8>>2]=1566444395;n[s+144+12>>2]=0.0;f[s+112>>2]=-581039253;f[s+112+4>>2]=-581039253;f[s+112+8>>2]=-581039253;n[s+112+12>>2]=0.0;O=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;f[s+16>>2]=6012;f[s+16+4>>2]=6036;f[s+16+8>>2]=O;f[s+16+12>>2]=f[d>>2];f[s+16+12+4>>2]=f[d+4>>2];f[s+16+12+8>>2]=f[d+8>>2];f[s+16+12+12>>2]=f[d+12>>2];f[s+16+28>>2]=f[b>>2];f[s+16+28+4>>2]=f[b+4>>2];f[s+16+28+8>>2]=f[b+8>>2];f[s+16+28+12>>2]=f[b+12>>2];f[s+16+44>>2]=f[b+16>>2];f[s+16+44+4>>2]=f[b+16+4>>2];f[s+16+44+8>>2]=f[b+16+8>>2];f[s+16+44+12>>2]=f[b+16+12>>2];f[s+16+60>>2]=f[b+32>>2];f[s+16+60+4>>2]=f[b+32+4>>2];f[s+16+60+8>>2]=f[b+32+8>>2];f[s+16+60+12>>2]=f[b+32+12>>2];f[s+16+76>>2]=f[b+48>>2];f[s+16+76+4>>2]=f[b+48+4>>2];f[s+16+76+8>>2]=f[b+48+8>>2];f[s+16+76+12>>2]=f[b+48+12>>2];O=f[c+92>>2]|0;Yb[f[(f[O>>2]|0)+8>>2]&127](O,s+16+4|0,s+112|0,s+144|0);u=s;return}}}function Gc(a,c){a=a|0;c=+c;var d=0,e=0.0,g=0,h=0,i=0,j=0.0,k=0.0,l=0,m=0,o=0,p=0,q=0.0,r=0,s=0,t=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0;r=u;u=u+96|0;o=f[a+136>>2]|0;if(!o){u=r;return}d=f[a+8>>2]|0;if((d|0)<(o|0)){if((f[a+12>>2]|0)<(o|0)){f[6472]=(f[6472]|0)+1;g=sc((o<<4|3)+16|0)|0;if(!g)i=0;else{f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}h=f[a+8>>2]|0;if((h|0)>0){g=0;do{l=i+(g<<4)|0;s=(f[a+16>>2]|0)+(g<<4)|0;f[l>>2]=f[s>>2];f[l+4>>2]=f[s+4>>2];f[l+8>>2]=f[s+8>>2];f[l+12>>2]=f[s+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+16>>2]|0;if(g|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=i;f[a+12>>2]=o;g=a+16|0}else g=a+16|0;do{s=(f[g>>2]|0)+(d<<4)|0;f[s>>2]=f[r+48>>2];f[s+4>>2]=f[r+48+4>>2];f[s+8>>2]=f[r+48+8>>2];f[s+12>>2]=f[r+48+12>>2];d=d+1|0}while((d|0)!=(o|0))}f[a+8>>2]=o;d=f[a+28>>2]|0;if((d|0)<(o|0)){if((f[a+32>>2]|0)<(o|0)){f[6472]=(f[6472]|0)+1;g=sc((o<<4|3)+16|0)|0;if(!g)i=0;else{f[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}h=f[a+28>>2]|0;if((h|0)>0){g=0;do{s=i+(g<<4)|0;l=(f[a+36>>2]|0)+(g<<4)|0;f[s>>2]=f[l>>2];f[s+4>>2]=f[l+4>>2];f[s+8>>2]=f[l+8>>2];f[s+12>>2]=f[l+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+36>>2]|0;if(g|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=i;f[a+32>>2]=o;g=a+36|0}else g=a+36|0;do{s=(f[g>>2]|0)+(d<<4)|0;f[s>>2]=f[r+48>>2];f[s+4>>2]=f[r+48+4>>2];f[s+8>>2]=f[r+48+8>>2];f[s+12>>2]=f[r+48+12>>2];d=d+1|0}while((d|0)!=(o|0))}f[a+28>>2]=o;l=f[a+48>>2]|0;if((l|0)<(o|0)){if((f[a+52>>2]|0)<(o|0)){f[6472]=(f[6472]|0)+1;d=sc((o<<2|3)+16|0)|0;if(!d)i=0;else{f[(d+4+15&-16)+-4>>2]=d;i=d+4+15&-16}g=f[a+48>>2]|0;h=f[a+56>>2]|0;if((g|0)<=0)if(!h)d=a+60|0;else m=39;else{d=0;do{f[i+(d<<2)>>2]=f[h+(d<<2)>>2];d=d+1|0}while((d|0)!=(g|0));m=39}if((m|0)==39)if(!(b[a+60>>0]|0))d=a+60|0;else{f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);d=a+60|0}b[d>>0]=1;f[a+56>>2]=i;f[a+52>>2]=o;g=o<<2;d=i}else{g=o<<2;d=f[a+56>>2]|0}bl(d+(l<<2)|0,0,g-(l<<2)|0)|0}f[a+48>>2]=o;l=f[a+68>>2]|0;if((l|0)<(o|0)){if((f[a+72>>2]|0)<(o|0)){f[6472]=(f[6472]|0)+1;d=sc((o<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}h=f[a+68>>2]|0;i=f[a+76>>2]|0;if((h|0)<=0)if(!i)g=a+80|0;else m=52;else{g=0;do{f[d+(g<<2)>>2]=f[i+(g<<2)>>2];g=g+1|0}while((g|0)!=(h|0));m=52}if((m|0)==52)if(!(b[a+80>>0]|0))g=a+80|0;else{f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);g=a+80|0}b[g>>0]=1;f[a+76>>2]=d;f[a+72>>2]=o;g=o<<2}else{g=o<<2;d=f[a+76>>2]|0}bl(d+(l<<2)|0,0,g-(l<<2)|0)|0}f[a+68>>2]=o;d=f[a+136>>2]|0;if((d|0)<=0){u=r;return}h=f[a+76>>2]|0;i=f[a+56>>2]|0;g=0;do{n[h+(g<<2)>>2]=0.0;n[i+(g<<2)>>2]=0.0;g=g+1|0}while((g|0)!=(d|0));i=0;do{g=f[a+144>>2]|0;h=f[g+(i*284|0)+88>>2]|0;if(h){l=g+(i*284|0)+92|0;f[r+48>>2]=f[l>>2];f[r+48+4>>2]=f[l+4>>2];f[r+48+8>>2]=f[l+8>>2];f[r+48+12>>2]=f[l+12>>2];l=g+(i*284|0)+108|0;f[r+48+16>>2]=f[l>>2];f[r+48+16+4>>2]=f[l+4>>2];f[r+48+16+8>>2]=f[l+8>>2];f[r+48+16+12>>2]=f[l+12>>2];l=g+(i*284|0)+124|0;f[r+48+32>>2]=f[l>>2];f[r+48+32+4>>2]=f[l+4>>2];f[r+48+32+8>>2]=f[l+8>>2];f[r+48+32+12>>2]=f[l+12>>2];l=f[a+120>>2]|0;d=f[r+48+16+(l<<2)>>2]|0;y=f[r+48+32+(l<<2)>>2]|0;m=f[a+36>>2]|0;f[m+(i<<4)>>2]=f[r+48+(l<<2)>>2];f[m+(i<<4)+4>>2]=d;f[m+(i<<4)+8>>2]=y;n[m+(i<<4)+12>>2]=0.0;m=f[a+36>>2]|0;y=m+(i<<4)|0;z=+n[y>>2];d=g+(i*284|0)|0;e=+n[d>>2];l=m+(i<<4)+4|0;x=+n[l>>2];s=g+(i*284|0)+4|0;j=+n[s>>2];m=m+(i<<4)+8|0;t=+n[m>>2];o=g+(i*284|0)+8|0;w=+n[o>>2];k=z-e*(z*e+x*j+t*w);v=x-j*(z*e+x*j+t*w);w=t-w*(z*e+x*j+t*w);t=1.0/+L(+(k*k+v*v+w*w));n[y>>2]=k*t;n[l>>2]=v*t;n[m>>2]=w*t;j=+n[s>>2];x=+n[o>>2];e=+n[d>>2];d=f[a+16>>2]|0;n[d+(i<<4)>>2]=j*w*t-x*v*t;n[d+(i<<4)+4>>2]=x*k*t-w*t*e;n[d+(i<<4)+8>>2]=v*t*e-j*k*t;n[d+(i<<4)+12>>2]=0.0;d=f[a+16>>2]|0;o=d+(i<<4)|0;t=+n[o>>2];s=d+(i<<4)+4|0;k=+n[s>>2];d=d+(i<<4)+8|0;j=+n[d>>2];e=1.0/+L(+(t*t+k*k+j*j));n[o>>2]=t*e;n[s>>2]=k*e;n[d>>2]=j*e;d=f[a+116>>2]|0;s=f[a+36>>2]|0;e=+n[s+(i<<4)>>2];j=+n[s+(i<<4)+4>>2];k=+n[s+(i<<4)+8>>2];if(e*e+j*j+k*k>1.100000023841858)e=0.0;else{C=+n[g+(i*284|0)+16>>2];G=C-+n[d+52>>2];E=+n[g+(i*284|0)+20>>2];I=E-+n[d+56>>2];J=+n[g+(i*284|0)+24>>2];M=J-+n[d+60>>2];C=C-+n[h+52>>2];E=E-+n[h+56>>2];J=J-+n[h+60>>2];F=+n[d+332>>2];N=+n[d+336>>2];H=+n[d+328>>2];B=+n[h+332>>2];K=+n[h+336>>2];D=+n[h+328>>2];A=(k*I-j*M)*+n[d+4>>2]+(e*M-k*G)*+n[d+20>>2]+(j*G-e*I)*+n[d+36>>2];t=(k*I-j*M)*+n[d+8>>2]+(e*M-k*G)*+n[d+24>>2]+(j*G-e*I)*+n[d+40>>2];v=(k*I-j*M)*+n[d+12>>2]+(e*M-k*G)*+n[d+28>>2]+(j*G-e*I)*+n[d+44>>2];w=(E*-k-J*-j)*+n[h+4>>2]+(J*-e-C*-k)*+n[h+20>>2]+(C*-j-E*-e)*+n[h+36>>2];x=(E*-k-J*-j)*+n[h+8>>2]+(J*-e-C*-k)*+n[h+24>>2]+(C*-j-E*-e)*+n[h+40>>2];z=(E*-k-J*-j)*+n[h+12>>2]+(J*-e-C*-k)*+n[h+28>>2]+(C*-j-E*-e)*+n[h+44>>2];e=(e*(M*F-I*N+ +n[d+312>>2]-(J*B-E*K+ +n[h+312>>2]))+j*(+n[d+316>>2]+(G*N-M*H)-(+n[h+316>>2]+(C*K-J*D)))+k*(I*H-G*F+ +n[d+320>>2]-(E*D-C*B+ +n[h+320>>2])))*-.20000000298023224*(1.0/(+n[h+344>>2]+(+n[d+344>>2]+(A*A*+n[d+396>>2]+t*t*+n[d+400>>2]+v*v*+n[d+404>>2]))+(w*w*+n[h+396>>2]+x*x*+n[h+400>>2]+z*z*+n[h+404>>2])))}n[(f[a+76>>2]|0)+(i<<2)>>2]=e;d=f[a+136>>2]|0}i=i+1|0}while((i|0)<(d|0));if((d|0)<=0){u=r;return}h=0;m=0;g=f[a+144>>2]|0;while(1){d=f[g+(m*284|0)+88>>2]|0;if(d){e=+n[g+(m*284|0)+252>>2];if(e!=0.0){e=e*c;o=g}else{N=+n[g+(m*284|0)+256>>2];N=N==0.0?0.0:N;o=f[a+116>>2]|0;y=f[a+16>>2]|0;G=+n[g+(m*284|0)+16>>2];E=+n[g+(m*284|0)+20>>2];A=+n[g+(m*284|0)+24>>2];x=+n[y+(m<<4)>>2];D=+n[y+(m<<4)+4>>2];e=+n[y+(m<<4)+8>>2];P=G-+n[o+52>>2];Q=E-+n[o+56>>2];j=A-+n[o+60>>2];k=+n[o+264>>2]*(Q*e-j*D)+ +n[o+280>>2]*(j*x-P*e)+(P*D-Q*x)*+n[o+296>>2];R=(Q*e-j*D)*+n[o+268>>2]+(j*x-P*e)*+n[o+284>>2]+(P*D-Q*x)*+n[o+300>>2];O=(Q*e-j*D)*+n[o+272>>2]+(j*x-P*e)*+n[o+288>>2]+(P*D-Q*x)*+n[o+304>>2];K=G-+n[d+52>>2];I=E-+n[d+56>>2];C=A-+n[d+60>>2];w=(D*K-x*I)*+n[d+296>>2]+(+n[d+264>>2]*(e*I-D*C)+ +n[d+280>>2]*(x*C-e*K));t=(e*I-D*C)*+n[d+268>>2]+(x*C-e*K)*+n[d+284>>2]+(D*K-x*I)*+n[d+300>>2];v=(e*I-D*C)*+n[d+272>>2]+(x*C-e*K)*+n[d+288>>2]+(D*K-x*I)*+n[d+304>>2];G=G-+n[o+52>>2];E=E-+n[o+56>>2];A=A-+n[o+60>>2];H=+n[o+332>>2];z=+n[o+336>>2];F=+n[o+328>>2];M=+n[d+332>>2];B=+n[d+336>>2];J=+n[d+328>>2];e=-(1.0/(+n[o+344>>2]+(e*(Q*k-P*R)+(x*(j*R-Q*O)+D*(P*O-j*k)))+(+n[d+344>>2]+(e*(I*w-K*t)+(x*(C*t-I*v)+D*(K*v-C*w)))))*((A*H-E*z+ +n[o+312>>2]-(C*M-I*B+ +n[d+312>>2]))*x+(+n[o+316>>2]+(G*z-A*F)-(+n[d+316>>2]+(K*B-C*J)))*D+(E*F-G*H+ +n[o+320>>2]-(I*J-K*M+ +n[d+320>>2]))*e));e=N<e?N:e;e=e<-N?-N:e;o=f[a+144>>2]|0}l=f[a+56>>2]|0;y=l+(m<<2)|0;n[y>>2]=0.0;d=o+(m*284|0)+280|0;n[d>>2]=1.0;k=+n[g+(m*284|0)+276>>2]*c*+n[g+(m*284|0)+228>>2];n[y>>2]=e;e=e*.5;j=+n[(f[a+76>>2]|0)+(m<<2)>>2];if(e*e+j*j>k*k){R=k/+L(+(e*e+j*j));n[d>>2]=R*+n[d>>2];d=1}else d=h}else{l=f[a+56>>2]|0;n[l+(m<<2)>>2]=0.0;n[g+(m*284|0)+280>>2]=1.0;d=h;o=g}m=m+1|0;i=f[a+136>>2]|0;if((m|0)>=(i|0))break;else{h=d;g=o}}if(d){if((i|0)<=0){u=r;return}g=f[a+76>>2]|0;d=0;do{h=g+(d<<2)|0;if(+n[h>>2]!=0.0?(p=o+(d*284|0)+280|0,q=+n[p>>2],q<1.0):0){y=l+(d<<2)|0;n[y>>2]=q*+n[y>>2];n[h>>2]=+n[p>>2]*+n[h>>2]}d=d+1|0}while((d|0)!=(i|0))}if((i|0)<=0){u=r;return}d=0;g=l;while(1){h=f[a+116>>2]|0;i=o+(d*284|0)+16|0;j=+n[i>>2]-+n[h+52>>2];l=o+(d*284|0)+20|0;k=+n[l>>2]-+n[h+56>>2];m=o+(d*284|0)+24|0;c=+n[m>>2]-+n[h+60>>2];n[r+48>>2]=j;n[r+48+4>>2]=k;n[r+48+8>>2]=c;n[r+48+12>>2]=0.0;e=+n[g+(d<<2)>>2];if(e!=0.0){y=f[a+16>>2]|0;Q=e*+n[y+(d<<4)+4>>2];R=e*+n[y+(d<<4)+8>>2];n[r+32>>2]=+n[y+(d<<4)>>2]*e;n[r+32+4>>2]=Q;n[r+32+8>>2]=R;n[r+32+12>>2]=0.0;ll(h,r+32|0,r+48|0)}e=+n[(f[a+76>>2]|0)+(d<<2)>>2];if(e!=0.0){y=f[(f[a+144>>2]|0)+(d*284|0)+88>>2]|0;Q=+n[l>>2]-+n[y+56>>2];P=+n[m>>2]-+n[y+60>>2];n[r+32>>2]=+n[i>>2]-+n[y+52>>2];n[r+32+4>>2]=Q;n[r+32+8>>2]=P;n[r+32+12>>2]=0.0;s=f[a+36>>2]|0;P=+n[s+(d<<4)>>2]*e;Q=e*+n[s+(d<<4)+4>>2];R=e*+n[s+(d<<4)+8>>2];n[r+16>>2]=P;n[r+16+4>>2]=Q;n[r+16+8>>2]=R;n[r+16+12>>2]=0.0;s=f[a+116>>2]|0;p=f[a+124>>2]|0;K=+n[s+4+(p<<2)>>2];M=+n[s+20+(p<<2)>>2];N=+n[s+36+(p<<2)>>2];O=(K*j+M*k+N*c)*(1.0-+n[o+(d*284|0)+244>>2]);n[r+48>>2]=j-K*O;n[r+48+4>>2]=k-M*O;n[r+48+8>>2]=c-N*O;ll(s,r+16|0,r+48|0);n[r>>2]=-P;n[r+4>>2]=-Q;n[r+8>>2]=-R;n[r+12>>2]=0.0;ll(y,r,r+32|0)}d=d+1|0;if((d|0)>=(f[a+136>>2]|0))break;o=f[a+144>>2]|0;g=f[a+56>>2]|0}u=r;return}function Hc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0,p=0,q=0.0,r=0.0,s=0,t=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0.0;O=u;u=u+192|0;N=f[c+36>>2]|0;m=+n[(+n[N+88>>2]>0.0?a+16|0:a+20|0)>>2];if(b[N+100>>0]&1){u=O;return}J=f[a+8>>2]|0;t=f[J+4>>2]|0;K=f[J+12>>2]|0;H=f[(f[a+4>>2]|0)+684>>2]|0;A=+n[N+8>>2]-+n[K+48>>2];q=+n[N+12>>2]-+n[K+52>>2];B=+n[N+16>>2]-+n[K+56>>2];z=1.0/+n[H+76>>2];y=(A*+n[K>>2]+q*+n[K+16>>2]+B*+n[K+32>>2])*z/3.0;E=y<0.0?~~(1.0-y):0;I=~~((y+ +(E|0)-+(~~(y+ +(E|0))|0))*3.0);r=(y+ +(E|0)-+(~~(y+ +(E|0))|0))*3.0-+(I|0);E=~~(y+ +(E|0))-E|0;y=z*(A*+n[K+4>>2]+q*+n[K+20>>2]+B*+n[K+36>>2])/3.0;C=y<0.0?~~(1.0-y):0;F=~~((y+ +(C|0)-+(~~(y+ +(C|0))|0))*3.0);l=(y+ +(C|0)-+(~~(y+ +(C|0))|0))*3.0-+(F|0);C=~~(y+ +(C|0))-C|0;B=z*(A*+n[K+8>>2]+q*+n[K+24>>2]+B*+n[K+40>>2])/3.0;D=B<0.0?~~(1.0-B):0;G=~~((B+ +(D|0)-+(~~(B+ +(D|0))|0))*3.0);q=(B+ +(D|0)-+(~~(B+ +(D|0))|0))*3.0-+(G|0);D=~~(B+ +(D|0))-D|0;o=(E>>>16<<11^(E&65535)+16^(E&65535)+16<<16)+(C&65535)+((E>>>16<<11^(E&65535)+16^(E&65535)+16<<16)>>>11)|0;o=(o^C>>>16<<11^o<<16)+(D&65535)+((o^C>>>16<<11^o<<16)>>>11)|0;o=(o^D>>>16<<11^o<<16)+(t&65535)+((o^D>>>16<<11^o<<16)>>>11)|0;o=((o^t>>>16<<11^o<<16)>>>11)+(o^t>>>16<<11^o<<16)|0;o=((o<<3^o)>>>5)+(o<<3^o)<<4^((o<<3^o)>>>5)+(o<<3^o);o=(((o>>>17)+o<<25^(o>>>17)+o)>>>6)+((o>>>17)+o<<25^(o>>>17)+o)|0;p=f[H+60>>2]|0;s=f[H+68>>2]|0;c=f[s+(((o>>>0)%(p>>>0)|0)<<2)>>2]|0;f[H+96>>2]=(f[H+96>>2]|0)+1;d=(f[H+92>>2]|0)+1|0;f[H+92>>2]=d;a:do if(!c)e=9;else while(1){if(((((f[c+272>>2]|0)==(o|0)?(f[c+256>>2]|0)==(E|0):0)?(f[c+260>>2]|0)==(C|0):0)?(f[c+264>>2]|0)==(D|0):0)?(f[c+276>>2]|0)==(t|0):0)break a;c=f[c+280>>2]|0;d=d+1|0;f[H+92>>2]=d;if(!c){e=9;break}}while(0);b:do if((e|0)==9){e=f[H+84>>2]|0;f[H+84>>2]=e+1;if((e|0)>=(f[H+88>>2]|0)){f[5826]=(f[5826]|0)+1;c:do if((p|0)>0){c=0;d=s;while(1){e=d+(c<<2)|0;d=f[e>>2]|0;f[e>>2]=0;if(d|0)do{e=d;d=f[d+280>>2]|0;cI(e)}while((d|0)!=0);c=c+1|0;if((c|0)==(p|0))break c;d=f[H+68>>2]|0}}while(0);n[H+76>>2]=.25;f[H+80>>2]=0;f[H+84>>2]=0;f[H+92>>2]=1;f[H+96>>2]=1}c=gs(284)|0;bl(c|0,0,284)|0;f[c+280>>2]=f[s+(((o>>>0)%(p>>>0)|0)<<2)>>2];f[s+(((o>>>0)%(p>>>0)|0)<<2)>>2]=c;f[c+276>>2]=t;f[c+272>>2]=o;f[c+256>>2]=E;f[c+260>>2]=C;f[c+264>>2]=D;j=+n[H+76>>2];p=O+120+4|0;s=O+120+24|0;t=O+120+44|0;d=0;g=j;while(1){i=j*+(D|0)*3.0+g*+(d|0);e=0;while(1){h=j*+(C|0)*3.0+g*+(e|0);n[O+48>>2]=+(E|0)*3.0*j+g*0.0;n[O+48+4>>2]=h;n[O+48+8>>2]=i;n[O+48+12>>2]=0.0;o=f[c+276>>2]|0;f[O+120>>2]=1065353216;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[O+120+20>>2]=1065353216;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[O+120+40>>2]=1065353216;f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;f[t+16>>2]=0;if((f[o+4>>2]|0)<20)g=+xd(O+48|0,o,O+120|0,O+64|0);else g=0.0;n[c+(e<<4)+(d<<2)>>2]=g;n[O+48>>2]=+(E|0)*3.0*j+ +n[H+76>>2];n[O+48+4>>2]=h;n[O+48+8>>2]=i;n[O+48+12>>2]=0.0;o=f[c+276>>2]|0;f[O+120>>2]=1065353216;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[O+120+20>>2]=1065353216;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[O+120+40>>2]=1065353216;f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;f[t+16>>2]=0;if((f[o+4>>2]|0)<20)g=+xd(O+48|0,o,O+120|0,O+64|0);else g=0.0;n[c+64+(e<<4)+(d<<2)>>2]=g;n[O+48>>2]=+(E|0)*3.0*j+ +n[H+76>>2]*2.0;n[O+48+4>>2]=h;n[O+48+8>>2]=i;n[O+48+12>>2]=0.0;o=f[c+276>>2]|0;f[O+120>>2]=1065353216;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[O+120+20>>2]=1065353216;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[O+120+40>>2]=1065353216;f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;f[t+16>>2]=0;if((f[o+4>>2]|0)<20)g=+xd(O+48|0,o,O+120|0,O+64|0);else g=0.0;n[c+128+(e<<4)+(d<<2)>>2]=g;n[O+48>>2]=+(E|0)*3.0*j+ +n[H+76>>2]*3.0;n[O+48+4>>2]=h;n[O+48+8>>2]=i;n[O+48+12>>2]=0.0;o=f[c+276>>2]|0;f[O+120>>2]=1065353216;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[O+120+20>>2]=1065353216;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[O+120+40>>2]=1065353216;f[t>>2]=0;f[t+4>>2]=0;f[t+8>>2]=0;f[t+12>>2]=0;f[t+16>>2]=0;if((f[o+4>>2]|0)<20)g=+xd(O+48|0,o,O+120|0,O+64|0);else g=0.0;n[c+192+(e<<4)+(d<<2)>>2]=g;e=e+1|0;if((e|0)==4)break;g=+n[H+76>>2]}d=d+1|0;if((d|0)==4)break b;g=+n[H+76>>2]}}while(0);f[c+268>>2]=f[H+80>>2];g=+n[c+(I<<6)+(F<<4)+(G<<2)>>2];x=+n[c+(I+1<<6)+(F<<4)+(G<<2)>>2];v=+n[c+(I+1<<6)+(F+1<<4)+(G<<2)>>2];w=+n[c+(I<<6)+(F+1<<4)+(G<<2)>>2];B=+n[c+(I<<6)+(F<<4)+(G+1<<2)>>2];A=+n[c+(I+1<<6)+(F<<4)+(G+1<<2)>>2];y=+n[c+(I+1<<6)+(F+1<<4)+(G+1<<2)>>2];z=+n[c+(I<<6)+(F+1<<4)+(G+1<<2)>>2];h=x-g+l*(v-w-(x-g))+q*(A-B+l*(y-z-(A-B))-(x-g+l*(v-w-(x-g))));i=w-g+r*(v-x-(w-g))+q*(z-B+r*(y-A-(z-B))-(w-g+r*(v-x-(w-g))));j=B-g+r*(A-x-(B-g))+l*(z-w+r*(y-v-(z-w))-(B-g+r*(A-x-(B-g))));k=1.0/+L(+(h*h+i*i+j*j));g=g+r*(x-g)+l*(w+r*(v-w)-(g+r*(x-g)));g=g+q*(B+r*(A-B)+l*(z+r*(y-z)-(B+r*(A-B)))-g)-m;if(!(g<0.0)){u=O;return}s=f[J+8>>2]|0;A=+n[K>>2]*h*k+ +n[K+4>>2]*i*k+ +n[K+8>>2]*j*k;B=h*k*+n[K+16>>2]+i*k*+n[K+20>>2]+j*k*+n[K+24>>2];z=h*k*+n[K+32>>2]+i*k*+n[K+36>>2]+j*k*+n[K+40>>2];y=-(A*(+n[N+8>>2]-g*A)+B*(+n[N+12>>2]-g*B)+z*(+n[N+16>>2]-g*z));r=+n[N+88>>2];c=f[a+12>>2]|0;if(!c)q=0.0;else q=+n[c+344>>2];if(!(r+q>0.0)){u=O;return}if(!c)c=f[(f[a+8>>2]|0)+8>>2]|0;if((b[22736]|0)==0?fz(22736)|0:0){d=23308;e=d+48|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(e|0))}d=f[a+12>>2]|0;k=+n[N+8>>2];w=k-+n[c+52>>2];l=+n[N+12>>2];x=l-+n[c+56>>2];m=+n[N+16>>2];v=m-+n[c+60>>2];if(!d){K=f[a+4>>2]|0;g=0.0;h=0.0;i=0.0;c=K;j=+n[K+452>>2]}else{i=+n[d+332>>2];h=+n[d+336>>2];P=+n[d+328>>2];c=f[a+4>>2]|0;j=+n[c+452>>2];g=(i*v-h*x+ +n[d+312>>2])*j;h=(+n[d+316>>2]+(h*w-v*P))*j;i=(x*P-i*w+ +n[d+320>>2])*j}k=k-+n[N+24>>2]-g;l=l-+n[N+28>>2]-h;P=m-+n[N+32>>2]-i;h=+n[c+316>>2]*+n[(f[(f[a+8>>2]|0)+8>>2]|0)+224>>2];Pf(O+120|0,j,r,q,(d|0)==0?23308:d+264|0,w,x,v);f[O+32>>2]=f[O+120>>2];f[O+32+4>>2]=f[O+120+4>>2];f[O+32+8>>2]=f[O+120+8>>2];f[O+32+12>>2]=f[O+120+12>>2];f[O+16>>2]=f[O+120+16>>2];f[O+16+4>>2]=f[O+120+16+4>>2];f[O+16+8>>2]=f[O+120+16+8>>2];f[O+16+12>>2]=f[O+120+16+12>>2];f[O>>2]=f[O+120+32>>2];f[O+4>>2]=f[O+120+32+4>>2];f[O+8>>2]=f[O+120+32+8>>2];f[O+12>>2]=f[O+120+32+12>>2];p=f[a+4>>2]|0;g=r*+n[p+452>>2];h=(P-z*(k*A+l*B+P*z))*(P-z*(k*A+l*B+P*z))+((k-A*(k*A+l*B+P*z))*(k-A*(k*A+l*B+P*z))+(l-B*(k*A+l*B+P*z))*(l-B*(k*A+l*B+P*z)))<h*(k*A+l*B+P*z)*(k*A+l*B+P*z)*h?0.0:1.0-h;o=f[(f[(f[(f[a+8>>2]|0)+8>>2]|0)+204>>2]&3|0?p+328|0:p+324|0)>>2]|0;c=f[p+812>>2]|0;if((c|0)==(f[p+816>>2]|0)?(M=c|0?c<<1:1,(c|0)<(M|0)):0){if(!M)e=0;else{f[6472]=(f[6472]|0)+1;c=sc((M*104|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}e=c;c=f[p+812>>2]|0}if((c|0)>0){d=0;do{K=e+(d*104|0)|0;J=f[p+820>>2]|0;I=J+(d*104|0)|0;f[K>>2]=f[I>>2];f[K+4>>2]=f[I+4>>2];f[K+8>>2]=f[I+8>>2];f[K+12>>2]=f[I+12>>2];f[K+16>>2]=f[I+16>>2];f[K+20>>2]=f[I+20>>2];f[K+24>>2]=f[I+24>>2];K=e+(d*104|0)+28|0;I=J+(d*104|0)+28|0;f[K>>2]=f[I>>2];f[K+4>>2]=f[I+4>>2];f[K+8>>2]=f[I+8>>2];f[K+12>>2]=f[I+12>>2];K=J+(d*104|0)+44|0;I=e+(d*104|0)+44|0;f[I>>2]=f[K>>2];f[I+4>>2]=f[K+4>>2];f[I+8>>2]=f[K+8>>2];f[I+12>>2]=f[K+12>>2];I=J+(d*104|0)+60|0;K=e+(d*104|0)+60|0;f[K>>2]=f[I>>2];f[K+4>>2]=f[I+4>>2];f[K+8>>2]=f[I+8>>2];f[K+12>>2]=f[I+12>>2];K=e+(d*104|0)+76|0;J=J+(d*104|0)+76|0;f[K>>2]=f[J>>2];f[K+4>>2]=f[J+4>>2];f[K+8>>2]=f[J+8>>2];f[K+12>>2]=f[J+12>>2];f[K+16>>2]=f[J+16>>2];f[K+20>>2]=f[J+20>>2];f[K+24>>2]=f[J+24>>2];d=d+1|0}while((d|0)!=(c|0))}c=f[p+820>>2]|0;if(c|0){if(b[p+824>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[p+820>>2]=0}b[p+824>>0]=1;f[p+820>>2]=e;f[p+816>>2]=M;c=f[p+812>>2]|0}M=f[p+820>>2]|0;f[M+(c*104|0)>>2]=s;n[M+(c*104|0)+4>>2]=A;n[M+(c*104|0)+8>>2]=B;n[M+(c*104|0)+12>>2]=z;n[M+(c*104|0)+16>>2]=0.0;n[M+(c*104|0)+20>>2]=y;f[M+(c*104|0)+24>>2]=N;N=M+(c*104|0)+28|0;f[N>>2]=f[O+32>>2];f[N+4>>2]=f[O+32+4>>2];f[N+8>>2]=f[O+32+8>>2];f[N+12>>2]=f[O+32+12>>2];N=M+(c*104|0)+44|0;f[N>>2]=f[O+16>>2];f[N+4>>2]=f[O+16+4>>2];f[N+8>>2]=f[O+16+8>>2];f[N+12>>2]=f[O+16+12>>2];N=M+(c*104|0)+60|0;f[N>>2]=f[O>>2];f[N+4>>2]=f[O+4>>2];f[N+8>>2]=f[O+8>>2];f[N+12>>2]=f[O+12>>2];N=M+(c*104|0)+76|0;n[N>>2]=w;n[M+(c*104|0)+80>>2]=x;n[M+(c*104|0)+84>>2]=v;n[M+(c*104|0)+88>>2]=0.0;n[N+16>>2]=g;n[N+20>>2]=h;f[N+24>>2]=o;f[p+812>>2]=(f[p+812>>2]|0)+1;c=f[a+12>>2]|0;if(!c){u=O;return}if(f[c+204>>2]&3|0){u=O;return}if((f[c+216>>2]&-2|0)!=4)f[c+216>>2]=1;n[c+220>>2]=0.0;u=O;return}function Ic(a){a=a|0;var c=0.0,d=0.0,e=0.0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;t=u;u=u+176|0;if(!(b[a+738>>0]|0)){u=t;return}n[a+36>>2]=0.0;n[a+744>>2]=0.0;if(!(b[a+736>>0]|0)){g=f[a+28>>2]|0;i=+n[a+600>>2];j=+n[a+604>>2];p=+n[a+608>>2];r=i*+n[g+20>>2]+j*+n[g+24>>2]+p*+n[g+28>>2]+ +n[g+56>>2];h=f[a+32>>2]|0;k=+n[a+664>>2];l=+n[a+668>>2];q=+n[a+672>>2];s=k*+n[h+20>>2]+l*+n[h+24>>2]+q*+n[h+28>>2]+ +n[h+56>>2];m=k*+n[h+36>>2]+l*+n[h+40>>2]+q*+n[h+44>>2]+ +n[h+60>>2];o=i*+n[g+4>>2]+j*+n[g+8>>2]+p*+n[g+12>>2]+ +n[g+52>>2];p=i*+n[g+36>>2]+j*+n[g+40>>2]+p*+n[g+44>>2]+ +n[g+60>>2];q=k*+n[h+4>>2]+l*+n[h+8>>2]+q*+n[h+12>>2]+ +n[h+52>>2];if((q-o)*(q-o)+(s-r)*(s-r)+(m-p)*(m-p)>1.1920928955078125e-07){d=1.0/+L(+((q-o)*(q-o)+(s-r)*(s-r)+(m-p)*(m-p)));n[t+128>>2]=(q-o)*d;n[t+128+4>>2]=(s-r)*d;n[t+128+8>>2]=(m-p)*d;f[t+128+12>>2]=0;k=(m-p)*d;c=(s-r)*d;d=(q-o)*d}else{f[t+128>>2]=1065353216;f[t+128+4>>2]=0;f[t+128+8>>2]=0;n[t+128+12>>2]=0.0;k=0.0;c=0.0;d=1.0}if(+K(+k)>.7071067690849304){w=k*k+c*c;v=1.0/+L(+w);i=-(v*k);k=v*c;l=-(k*d);e=d*i;j=0.0;c=w*v;d=k}else{i=d*d+c*c;e=1.0/+L(+i);j=-(c*e);c=e*d;l=k*j;e=i*e;i=c;c=-(c*k);d=0.0}n[t+128+16>>2]=j;n[t+128+20>>2]=i;n[t+128+24>>2]=d;n[t+128+32>>2]=c;n[t+128+36>>2]=l;n[t+128+40>>2]=e;g=f[a+28>>2]|0;f[t+80>>2]=f[g+4>>2];f[t+80+4>>2]=f[g+20>>2];f[t+80+8>>2]=f[g+36>>2];n[t+80+12>>2]=0.0;f[t+80+16>>2]=f[g+8>>2];f[t+80+20>>2]=f[g+24>>2];f[t+80+24>>2]=f[g+40>>2];n[t+80+28>>2]=0.0;f[t+80+32>>2]=f[g+12>>2];f[t+80+36>>2]=f[g+28>>2];f[t+80+40>>2]=f[g+44>>2];n[t+80+44>>2]=0.0;h=f[a+32>>2]|0;f[t+32>>2]=f[h+4>>2];f[t+32+4>>2]=f[h+20>>2];f[t+32+8>>2]=f[h+36>>2];n[t+32+12>>2]=0.0;f[t+32+16>>2]=f[h+8>>2];f[t+32+20>>2]=f[h+24>>2];f[t+32+24>>2]=f[h+40>>2];n[t+32+28>>2]=0.0;f[t+32+32>>2]=f[h+12>>2];f[t+32+36>>2]=f[h+28>>2];f[t+32+40>>2]=f[h+44>>2];n[t+32+44>>2]=0.0;w=r-+n[g+56>>2];v=p-+n[g+60>>2];n[t+16>>2]=o-+n[g+52>>2];n[t+16+4>>2]=w;n[t+16+8>>2]=v;n[t+16+12>>2]=0.0;v=s-+n[h+56>>2];w=m-+n[h+60>>2];n[t>>2]=q-+n[h+52>>2];n[t+4>>2]=v;n[t+8>>2]=w;n[t+12>>2]=0.0;g=f[a+28>>2]|0;Qg(a+48|0,t+80|0,t+32|0,t+16|0,t,t+128|0,g+396|0,+n[g+344>>2],h+396|0,+n[h+344>>2]);h=f[a+28>>2]|0;f[t+80>>2]=f[h+4>>2];f[t+80+4>>2]=f[h+20>>2];f[t+80+8>>2]=f[h+36>>2];n[t+80+12>>2]=0.0;f[t+80+16>>2]=f[h+8>>2];f[t+80+20>>2]=f[h+24>>2];f[t+80+24>>2]=f[h+40>>2];n[t+80+28>>2]=0.0;f[t+80+32>>2]=f[h+12>>2];f[t+80+36>>2]=f[h+28>>2];f[t+80+40>>2]=f[h+44>>2];n[t+80+44>>2]=0.0;g=f[a+32>>2]|0;f[t+32>>2]=f[g+4>>2];f[t+32+4>>2]=f[g+20>>2];f[t+32+8>>2]=f[g+36>>2];n[t+32+12>>2]=0.0;f[t+32+16>>2]=f[g+8>>2];f[t+32+20>>2]=f[g+24>>2];f[t+32+24>>2]=f[g+40>>2];n[t+32+28>>2]=0.0;f[t+32+32>>2]=f[g+12>>2];f[t+32+36>>2]=f[g+28>>2];f[t+32+40>>2]=f[g+44>>2];n[t+32+44>>2]=0.0;w=r-+n[h+56>>2];v=p-+n[h+60>>2];n[t+16>>2]=o-+n[h+52>>2];n[t+16+4>>2]=w;n[t+16+8>>2]=v;n[t+16+12>>2]=0.0;v=s-+n[g+56>>2];w=m-+n[g+60>>2];n[t>>2]=q-+n[g+52>>2];n[t+4>>2]=v;n[t+8>>2]=w;n[t+12>>2]=0.0;h=f[a+28>>2]|0;Qg(a+132|0,t+80|0,t+32|0,t+16|0,t,t+128+16|0,h+396|0,+n[h+344>>2],g+396|0,+n[g+344>>2]);g=f[a+28>>2]|0;f[t+80>>2]=f[g+4>>2];f[t+80+4>>2]=f[g+20>>2];f[t+80+8>>2]=f[g+36>>2];n[t+80+12>>2]=0.0;f[t+80+16>>2]=f[g+8>>2];f[t+80+20>>2]=f[g+24>>2];f[t+80+24>>2]=f[g+40>>2];n[t+80+28>>2]=0.0;f[t+80+32>>2]=f[g+12>>2];f[t+80+36>>2]=f[g+28>>2];f[t+80+40>>2]=f[g+44>>2];n[t+80+44>>2]=0.0;h=f[a+32>>2]|0;f[t+32>>2]=f[h+4>>2];f[t+32+4>>2]=f[h+20>>2];f[t+32+8>>2]=f[h+36>>2];n[t+32+12>>2]=0.0;f[t+32+16>>2]=f[h+8>>2];f[t+32+20>>2]=f[h+24>>2];f[t+32+24>>2]=f[h+40>>2];n[t+32+28>>2]=0.0;f[t+32+32>>2]=f[h+12>>2];f[t+32+36>>2]=f[h+28>>2];f[t+32+40>>2]=f[h+44>>2];n[t+32+44>>2]=0.0;w=r-+n[g+56>>2];v=p-+n[g+60>>2];n[t+16>>2]=o-+n[g+52>>2];n[t+16+4>>2]=w;n[t+16+8>>2]=v;n[t+16+12>>2]=0.0;v=s-+n[h+56>>2];w=m-+n[h+60>>2];n[t>>2]=q-+n[h+52>>2];n[t+4>>2]=v;n[t+8>>2]=w;n[t+12>>2]=0.0;g=f[a+28>>2]|0;Qg(a+216|0,t+80|0,t+32|0,t+16|0,t,t+128+32|0,g+396|0,+n[g+344>>2],h+396|0,+n[h+344>>2])}l=+n[a+560>>2];m=+n[a+576>>2];o=+n[a+592>>2];if(+K(+o)>.7071067690849304){k=1.0/+L(+(o*o+m*m));c=l*-(o*k);d=(o*o+m*m)*k;e=0.0;i=k*m;j=-(k*m*l);k=-(o*k)}else{k=1.0/+L(+(l*l+m*m));c=(l*l+m*m)*k;d=-(o*k*l);e=-(k*m);i=0.0;j=o*-(k*m);k=k*l}h=f[a+28>>2]|0;H=+n[h+4>>2];G=+n[h+8>>2];r=+n[h+12>>2];Q=e*H+k*G+i*r;F=+n[h+20>>2];E=+n[h+24>>2];v=+n[h+28>>2];S=e*F+k*E+i*v;D=+n[h+36>>2];p=+n[h+40>>2];B=+n[h+44>>2];V=e*D+k*p+i*B;A=d*H+j*G+c*r;J=d*F+j*E+c*v;M=d*D+j*p+c*B;g=f[a+32>>2]|0;z=+n[g+4>>2];y=+n[g+20>>2];x=+n[g+36>>2];j=+n[g+8>>2];k=+n[g+24>>2];s=+n[g+40>>2];O=+n[g+12>>2];R=+n[g+28>>2];U=+n[g+44>>2];f[a+300>>2]=0;f[a+300+4>>2]=0;f[a+300+8>>2]=0;f[a+300+12>>2]=0;n[a+316>>2]=Q*H+S*F+V*D;n[a+320>>2]=Q*G+S*E+V*p;n[a+324>>2]=Q*r+S*v+V*B;n[a+328>>2]=0.0;n[a+332>>2]=z*-Q+y*-S+x*-V;n[a+336>>2]=j*-Q+k*-S+s*-V;n[a+340>>2]=O*-Q+R*-S+U*-V;n[a+344>>2]=0.0;C=(Q*H+S*F+V*D)*+n[h+396>>2];I=(Q*G+S*E+V*p)*+n[h+400>>2];c=(Q*r+S*v+V*B)*+n[h+404>>2];n[a+348>>2]=C;n[a+352>>2]=I;n[a+356>>2]=c;n[a+360>>2]=0.0;i=(z*-Q+y*-S+x*-V)*+n[g+396>>2];w=(j*-Q+k*-S+s*-V)*+n[g+400>>2];W=(O*-Q+R*-S+U*-V)*+n[g+404>>2];n[a+364>>2]=i;n[a+368>>2]=w;n[a+372>>2]=W;n[a+376>>2]=0.0;n[a+380>>2]=(Q*H+S*F+V*D)*C+(Q*G+S*E+V*p)*I+(Q*r+S*v+V*B)*c+((z*-Q+y*-S+x*-V)*i+(j*-Q+k*-S+s*-V)*w+(O*-Q+R*-S+U*-V)*W);g=f[a+28>>2]|0;W=+n[g+4>>2];V=+n[g+20>>2];U=+n[g+36>>2];S=+n[g+8>>2];R=+n[g+24>>2];Q=+n[g+40>>2];O=+n[g+12>>2];w=+n[g+28>>2];s=+n[g+44>>2];h=f[a+32>>2]|0;k=+n[h+4>>2];j=+n[h+20>>2];i=+n[h+36>>2];x=+n[h+8>>2];y=+n[h+24>>2];z=+n[h+40>>2];c=+n[h+12>>2];I=+n[h+28>>2];C=+n[h+44>>2];f[a+384>>2]=0;f[a+384+4>>2]=0;f[a+384+8>>2]=0;f[a+384+12>>2]=0;n[a+400>>2]=A*W+J*V+M*U;n[a+404>>2]=A*S+J*R+M*Q;n[a+408>>2]=A*O+J*w+M*s;n[a+412>>2]=0.0;n[a+416>>2]=k*-A+j*-J+i*-M;n[a+420>>2]=x*-A+y*-J+z*-M;n[a+424>>2]=c*-A+I*-J+C*-M;n[a+428>>2]=0.0;T=(A*W+J*V+M*U)*+n[g+396>>2];P=(A*S+J*R+M*Q)*+n[g+400>>2];q=(A*O+J*w+M*s)*+n[g+404>>2];n[a+432>>2]=T;n[a+436>>2]=P;n[a+440>>2]=q;n[a+444>>2]=0.0;d=(k*-A+j*-J+i*-M)*+n[h+396>>2];e=(x*-A+y*-J+z*-M)*+n[h+400>>2];N=(c*-A+I*-J+C*-M)*+n[h+404>>2];n[a+448>>2]=d;n[a+452>>2]=e;n[a+456>>2]=N;n[a+460>>2]=0.0;n[a+464>>2]=(A*W+J*V+M*U)*T+(A*S+J*R+M*Q)*P+(A*O+J*w+M*s)*q+((k*-A+j*-J+i*-M)*d+(x*-A+y*-J+z*-M)*e+(c*-A+I*-J+C*-M)*N);h=f[a+28>>2]|0;N=+n[h+4>>2];M=+n[h+20>>2];C=+n[h+36>>2];J=+n[h+8>>2];I=+n[h+24>>2];A=+n[h+40>>2];c=+n[h+12>>2];e=+n[h+28>>2];z=+n[h+44>>2];g=f[a+32>>2]|0;y=+n[g+4>>2];x=+n[g+20>>2];d=+n[g+36>>2];i=+n[g+8>>2];j=+n[g+24>>2];k=+n[g+40>>2];q=+n[g+12>>2];s=+n[g+28>>2];w=+n[g+44>>2];f[a+468>>2]=0;f[a+468+4>>2]=0;f[a+468+8>>2]=0;f[a+468+12>>2]=0;C=(H*l+G*m+r*o)*N+(F*l+E*m+v*o)*M+(D*l+p*m+B*o)*C;A=(H*l+G*m+r*o)*J+(F*l+E*m+v*o)*I+(D*l+p*m+B*o)*A;z=(H*l+G*m+r*o)*c+(F*l+E*m+v*o)*e+(D*l+p*m+B*o)*z;n[a+484>>2]=C;n[a+488>>2]=A;n[a+492>>2]=z;n[a+496>>2]=0.0;r=-(H*l+G*m+r*o);v=-(F*l+E*m+v*o);e=-(D*l+p*m+B*o);n[a+500>>2]=y*r+x*v+d*e;n[a+504>>2]=i*r+j*v+k*e;n[a+508>>2]=q*r+s*v+w*e;n[a+512>>2]=0.0;B=C*+n[h+396>>2];l=A*+n[h+400>>2];m=z*+n[h+404>>2];n[a+516>>2]=B;n[a+520>>2]=l;n[a+524>>2]=m;n[a+528>>2]=0.0;o=(y*r+x*v+d*e)*+n[g+396>>2];p=(i*r+j*v+k*e)*+n[g+400>>2];c=(q*r+s*v+w*e)*+n[g+404>>2];n[a+532>>2]=o;n[a+536>>2]=p;n[a+540>>2]=c;n[a+544>>2]=0.0;n[a+548>>2]=C*B+A*l+z*m+((y*r+x*v+d*e)*o+(i*r+j*v+k*e)*p+(q*r+s*v+w*e)*c);n[a+724>>2]=0.0;g=f[a+28>>2]|0;h=f[a+32>>2]|0;c=+ej(a,g+4|0,h+4|0);n[a+728>>2]=c;n[a+708>>2]=0.0;n[a+712>>2]=0.0;b[a+716>>0]=0;e=+n[a+692>>2];do if(e>=0.0){c=+lh(c-+n[a+688>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;if(c<-e){b[a+716>>0]=1;d=1.0;c=-(c+e)}else{if(!(c>e))break;b[a+716>>0]=1;d=-1.0;c=e-c}n[a+708>>2]=c;n[a+712>>2]=d}while(0);S=+n[a+560>>2];T=+n[a+576>>2];W=+n[a+592>>2];U=S*+n[g+4>>2]+T*+n[g+8>>2]+W*+n[g+12>>2];V=S*+n[g+20>>2]+T*+n[g+24>>2]+W*+n[g+28>>2];W=S*+n[g+36>>2]+T*+n[g+40>>2]+W*+n[g+44>>2];n[a+720>>2]=1.0/(U*(U*+n[g+264>>2]+V*+n[g+280>>2]+W*+n[g+296>>2])+V*(U*+n[g+268>>2]+V*+n[g+284>>2]+W*+n[g+300>>2])+W*(U*+n[g+272>>2]+V*+n[g+288>>2]+W*+n[g+304>>2])+(U*(U*+n[h+264>>2]+V*+n[h+280>>2]+W*+n[h+296>>2])+V*(U*+n[h+268>>2]+V*+n[h+284>>2]+W*+n[h+300>>2])+W*(U*+n[h+272>>2]+V*+n[h+288>>2]+W*+n[h+304>>2])));u=t;return}function Jc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0,o=0,p=0,q=0.0,r=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0.0,G=0,H=0.0,I=0.0,J=0,K=0,M=0;K=u;u=u+112|0;f[a+348>>2]=a+220;f[a+352>>2]=a+252;f[a+356>>2]=a+284;f[a+360>>2]=a+316;f[a+364>>2]=4;f[a+368>>2]=0;f[a+376>>2]=0;G=f[b+4>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=G;f[a+8>>2]=f[b+8>>2];f[a+8+4>>2]=f[b+8+4>>2];f[a+8+8>>2]=f[b+8+8>>2];f[a+8+12>>2]=f[b+8+12>>2];f[a+24>>2]=f[b+24>>2];f[a+24+4>>2]=f[b+24+4>>2];f[a+24+8>>2]=f[b+24+8>>2];f[a+24+12>>2]=f[b+24+12>>2];f[a+40>>2]=f[b+40>>2];f[a+40+4>>2]=f[b+40+4>>2];f[a+40+8>>2]=f[b+40+8>>2];f[a+40+12>>2]=f[b+40+12>>2];f[a+56>>2]=f[b+56>>2];f[a+56+4>>2]=f[b+56+4>>2];f[a+56+8>>2]=f[b+56+8>>2];f[a+56+12>>2]=f[b+56+12>>2];f[a+72>>2]=f[b+72>>2];f[a+72+4>>2]=f[b+72+4>>2];f[a+72+8>>2]=f[b+72+8>>2];f[a+72+12>>2]=f[b+72+12>>2];f[a+88>>2]=f[b+88>>2];f[a+88+4>>2]=f[b+88+4>>2];f[a+88+8>>2]=f[b+88+8>>2];f[a+88+12>>2]=f[b+88+12>>2];f[a+104>>2]=f[b+104>>2];f[a+104+4>>2]=f[b+104+4>>2];f[a+104+8>>2]=f[b+104+8>>2];f[a+104+12>>2]=f[b+104+12>>2];G=f[b+124>>2]|0;f[a+120>>2]=f[b+120>>2];f[a+124>>2]=G;n[a+144>>2]=0.0;f[a+180>>2]=0;f[a+128>>2]=f[c>>2];f[a+128+4>>2]=f[c+4>>2];f[a+128+8>>2]=f[c+8>>2];f[a+128+12>>2]=f[c+12>>2];d=+n[a+128>>2];e=+n[a+132>>2];g=+n[a+136>>2];if(d*d+e*e+g*g>0.0){n[a+164>>2]=0.0;f[a+364>>2]=3;f[a+148>>2]=a+316;f[a+180>>2]=1;Gh(a,-d,-e,-g,a+316|0);b=a+148|0;c=a+164|0}else{n[a+164>>2]=0.0;f[a+364>>2]=3;f[a+148>>2]=a+316;f[a+180>>2]=1;Gh(a,1.0,0.0,0.0,a+316|0);b=a+148|0;c=a+164|0}n[c>>2]=1.0;G=(f[b>>2]|0)+16|0;f[a+128>>2]=f[G>>2];f[a+128+4>>2]=f[G+4>>2];f[a+128+8>>2]=f[G+8>>2];f[a+128+12>>2]=f[G+12>>2];f[K+24+48>>2]=f[G>>2];f[K+24+48+4>>2]=f[G+4>>2];f[K+24+48+8>>2]=f[G+8>>2];f[K+24+48+12>>2]=f[G+12>>2];f[K+24+32>>2]=f[G>>2];f[K+24+32+4>>2]=f[G+4>>2];f[K+24+32+8>>2]=f[G+8>>2];f[K+24+32+12>>2]=f[G+12>>2];f[K+24+16>>2]=f[G>>2];f[K+24+16+4>>2]=f[G+4>>2];f[K+24+16+8>>2]=f[G+8>>2];f[K+24+16+12>>2]=f[G+12>>2];f[K+24>>2]=f[G>>2];f[K+24+4>>2]=f[G+4>>2];f[K+24+8>>2]=f[G+8>>2];f[K+24+12>>2]=f[G+12>>2];G=K+8+4|0;E=0;F=0.0;d=d*d+e*e+g*g;D=0;a:do{C=f[a+368>>2]|0;e=+n[a+128>>2];g=+n[a+132>>2];h=+n[a+136>>2];i=+L(+(e*e+g*g+h*h));if(i<9.999999747378752e-05){J=6;break}n[a+148+(C*36|0)+16+(f[a+148+(C*36|0)+32>>2]<<2)>>2]=0.0;b=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=b;f[a+148+(C*36|0)+(f[a+148+(C*36|0)+32>>2]<<2)>>2]=f[a+348+(b<<2)>>2];b=f[a+148+(C*36|0)+32>>2]|0;f[a+148+(C*36|0)+32>>2]=b+1;Gh(a,-e,-g,-h,f[a+148+(C*36|0)+(b<<2)>>2]|0);b=f[a+148+(C*36|0)+32>>2]|0;c=f[a+148+(C*36|0)+(b+-1<<2)>>2]|0;e=+n[c+16>>2];g=+n[c+20>>2];h=+n[c+24>>2];z=e-+n[K+24>>2];A=g-+n[K+24+4>>2];B=h-+n[K+24+8>>2];if(z*z+A*A+B*B<9.999999747378752e-05){J=9;break}z=e-+n[K+24+16>>2];A=g-+n[K+24+20>>2];B=h-+n[K+24+24>>2];if(z*z+A*A+B*B<9.999999747378752e-05){J=9;break}z=e-+n[K+24+32>>2];A=g-+n[K+24+36>>2];B=h-+n[K+24+40>>2];if(z*z+A*A+B*B<9.999999747378752e-05){J=9;break}z=e-+n[K+24+48>>2];A=g-+n[K+24+52>>2];B=h-+n[K+24+56>>2];if(z*z+A*A+B*B<9.999999747378752e-05){J=9;break}D=D+1&3;p=K+24+(D<<4)|0;f[p>>2]=f[c+16>>2];f[p+4>>2]=f[c+16+4>>2];f[p+8>>2]=f[c+16+8>>2];f[p+12>>2]=f[c+16+12>>2];B=(+n[a+128>>2]*e+ +n[a+132>>2]*g+ +n[a+136>>2]*h)/i;F=B>F?B:F;if(i-F-i*9.999999747378752e-05<=0.0){J=10;break}f[K>>2]=0;b:do switch(b|0){case 2:{p=f[a+148+(C*36|0)>>2]|0;o=f[a+148+(C*36|0)+4>>2]|0;d=+n[o+16>>2];e=+n[p+16>>2];g=+n[o+20>>2];h=+n[p+20>>2];i=+n[o+24>>2];j=+n[p+24>>2];if(!((d-e)*(d-e)+(g-h)*(g-h)+(i-j)*(i-j)>0.0)){J=45;break a}k=-(e*(d-e)+h*(g-h)+j*(i-j))/((d-e)*(d-e)+(g-h)*(g-h)+(i-j)*(i-j));if(k>=1.0){n[K+8>>2]=0.0;n[G>>2]=1.0;f[K>>2]=2;d=d*d+g*g+i*i;break b}if(!(k<=0.0)){n[G>>2]=k;n[K+8>>2]=1.0-k;f[K>>2]=3;d=((d-e)*k+e)*((d-e)*k+e)+((g-h)*k+h)*((g-h)*k+h)+((i-j)*k+j)*((i-j)*k+j);break b}else{n[K+8>>2]=1.0;n[G>>2]=0.0;f[K>>2]=1;d=e*e+h*h+j*j;break b}}case 3:{d=+de((f[a+148+(C*36|0)>>2]|0)+16|0,(f[a+148+(C*36|0)+4>>2]|0)+16|0,(f[a+148+(C*36|0)+8>>2]|0)+16|0,K+8|0,K);break}case 4:{b=f[a+148+(C*36|0)>>2]|0;c=f[a+148+(C*36|0)+4>>2]|0;l=f[a+148+(C*36|0)+8>>2]|0;m=f[a+148+(C*36|0)+12>>2]|0;q=+n[b+16>>2];r=+n[m+16>>2];t=+n[b+20>>2];v=+n[m+20>>2];w=+n[b+24>>2];x=+n[m+24>>2];e=+n[c+16>>2];g=+n[c+20>>2];h=+n[c+24>>2];y=+n[l+16>>2];z=+n[l+20>>2];A=+n[l+24>>2];B=(t-v)*(h-x)*(y-r)+(w-x)*(e-r)*(z-v)-(z-v)*(h-x)*(q-r)-(t-v)*(e-r)*(A-x)+(A-x)*(q-r)*(g-v)-(y-r)*(w-x)*(g-v);if(!(B==B&0.0==0.0&B!=0.0&B*(w*((e-y)*(t-g)-(g-z)*(q-e))+(q*((g-z)*(w-h)-(h-A)*(t-g))+t*((h-A)*(q-e)-(e-y)*(w-h))))<=0.0)){J=45;break a}f[K+92>>2]=0;f[K+92+4>>2]=0;f[K+92+8>>2]=0;f[K+88>>2]=0;if(B*(((t-v)*(h-x)-(w-x)*(g-v))*r+v*((w-x)*(e-r)-(h-x)*(q-r))+((q-r)*(g-v)-(t-v)*(e-r))*x)>0.0){d=+de(b+16|0,c+16|0,m+16|0,K+92|0,K+88|0);p=f[K+88>>2]|0;f[K>>2]=p&2|p<<1&8|p&1;f[K+8>>2]=f[K+92>>2];f[G>>2]=f[K+92+4>>2];n[K+8+8>>2]=0.0;f[K+8+12>>2]=f[K+92+8>>2];i=+n[m+16>>2];j=+n[m+20>>2];k=+n[m+24>>2]}else{d=-1.0;i=r;j=v;k=x}if(B*(((g-v)*(A-x)-(h-x)*(z-v))*i+j*((h-x)*(y-r)-(A-x)*(e-r))+((z-v)*(e-r)-(g-v)*(y-r))*k)>0.0?(H=+de(c+16|0,l+16|0,m+16|0,K+92|0,K+88|0),d<0.0|H<d):0){f[K>>2]=f[K+88>>2]<<1&14;f[G>>2]=f[K+92>>2];f[K+8+8>>2]=f[K+92+4>>2];n[K+8>>2]=0.0;f[K+8+12>>2]=f[K+92+8>>2];d=H}if(B*(((z-v)*(w-x)-(A-x)*(t-v))*+n[m+16>>2]+ +n[m+20>>2]*((A-x)*(q-r)-(w-x)*(y-r))+((t-v)*(y-r)-(z-v)*(q-r))*+n[m+24>>2])>0.0?(I=+de(l+16|0,b+16|0,m+16|0,K+92|0,K+88|0),d<0.0|I<d):0){p=f[K+88>>2]|0;f[K>>2]=p>>>1&1|p<<1&8|p<<2&4;f[K+8+8>>2]=f[K+92>>2];f[K+8>>2]=f[K+92+4>>2];n[G>>2]=0.0;f[K+8+12>>2]=f[K+92+8>>2];d=I}if(d<0.0){f[K>>2]=15;q=+n[l+20>>2];A=+n[c+24>>2];z=+n[m+16>>2];j=+n[l+24>>2];y=+n[c+16>>2];r=+n[m+20>>2];k=+n[l+16>>2];x=+n[m+24>>2];v=+n[c+20>>2];n[K+8>>2]=(q*A*z+j*y*r-r*A*k-q*y*x+x*k*v-z*j*v)/B;d=+n[b+20>>2];t=+n[b+24>>2];w=+n[b+16>>2];n[G>>2]=(d*j*z+t*k*r-r*j*w-d*k*x+x*w*q-z*t*q)/B;n[K+8+8>>2]=(v*t*z+A*w*r-r*t*y-v*w*x+x*y*d-z*A*d)/B;n[K+8+12>>2]=1.0-((q*A*z+j*y*r-r*A*k-q*y*x+x*k*v-z*j*v)/B+(d*j*z+t*k*r-r*j*w-d*k*x+x*w*q-z*t*q)/B+(v*t*z+A*w*r-r*t*y-v*w*x+x*y*d-z*A*d)/B);d=0.0}break}default:{}}while(0);if(!(d>=0.0)){J=45;break}m=a+148+((1-C|0)*36|0)+32|0;f[m>>2]=0;f[a+128>>2]=0;f[a+128+4>>2]=0;f[a+128+8>>2]=0;f[a+128+12>>2]=0;f[a+368>>2]=1-C;o=f[a+148+(C*36|0)+32>>2]|0;p=f[K>>2]|0;if(o|0){b=f[a+148+(C*36|0)>>2]|0;if(!(p&1)){l=f[a+364>>2]|0;f[a+364>>2]=l+1;f[a+348+(l<<2)>>2]=b}else{f[a+148+((1-C|0)*36|0)+(f[m>>2]<<2)>>2]=b;c=f[K+8>>2]|0;l=f[m>>2]|0;f[m>>2]=l+1;f[a+148+((1-C|0)*36|0)+16+(l<<2)>>2]=c;l=f[a+148+(C*36|0)>>2]|0;z=(f[s>>2]=c,+n[s>>2]);A=+n[l+20>>2]*z;B=+n[l+24>>2]*z;n[a+128>>2]=+n[l+16>>2]*z+ +n[a+128>>2];n[a+132>>2]=A+ +n[a+132>>2];n[a+136>>2]=B+ +n[a+136>>2]}if((o|0)!=1){b=1;do{c=a+148+(C*36|0)+(b<<2)|0;l=f[c>>2]|0;if(!(p&1<<b)){c=f[a+364>>2]|0;f[a+364>>2]=c+1;f[a+348+(c<<2)>>2]=l}else{f[a+148+((1-C|0)*36|0)+(f[m>>2]<<2)>>2]=l;M=f[K+8+(b<<2)>>2]|0;l=f[m>>2]|0;f[m>>2]=l+1;f[a+148+((1-C|0)*36|0)+16+(l<<2)>>2]=M;l=f[c>>2]|0;z=(f[s>>2]=M,+n[s>>2]);A=+n[l+20>>2]*z;B=+n[l+24>>2]*z;n[a+128>>2]=+n[l+16>>2]*z+ +n[a+128>>2];n[a+132>>2]=A+ +n[a+132>>2];n[a+136>>2]=B+ +n[a+136>>2]}b=b+1|0}while((b|0)!=(o|0))}}if((p|0)==15)f[a+376>>2]=1;E=E+1|0;if(E>>>0>=128){J=44;break}b=f[a+376>>2]|0}while(!(b|0));if((J|0)==6){f[a+376>>2]=1;J=47}else if((J|0)==9){M=f[a+368>>2]|0;G=(f[a+148+(M*36|0)+32>>2]|0)+-1|0;f[a+148+(M*36|0)+32>>2]=G;G=f[a+148+(M*36|0)+(G<<2)>>2]|0;M=f[a+364>>2]|0;f[a+364>>2]=M+1;f[a+348+(M<<2)>>2]=G;J=47}else if((J|0)==10){M=f[a+368>>2]|0;G=(f[a+148+(M*36|0)+32>>2]|0)+-1|0;f[a+148+(M*36|0)+32>>2]=G;G=f[a+148+(M*36|0)+(G<<2)>>2]|0;M=f[a+364>>2]|0;f[a+364>>2]=M+1;f[a+348+(M<<2)>>2]=G;J=47}else if((J|0)==44){f[a+376>>2]=2;f[a+372>>2]=a+148+((f[a+368>>2]|0)*36|0);M=2;u=K;return M|0}else if((J|0)==45){M=f[a+368>>2]|0;G=(f[a+148+(M*36|0)+32>>2]|0)+-1|0;f[a+148+(M*36|0)+32>>2]=G;G=f[a+148+(M*36|0)+(G<<2)>>2]|0;M=f[a+364>>2]|0;f[a+364>>2]=M+1;f[a+348+(M<<2)>>2]=G;J=47}if((J|0)==47)b=f[a+376>>2]|0;f[a+372>>2]=a+148+((f[a+368>>2]|0)*36|0);switch(b|0){case 0:{H=+n[a+128>>2];I=+n[a+132>>2];d=+n[a+136>>2];d=+L(+(H*H+I*I+d*d));break}case 1:{d=0.0;break}default:{M=b;u=K;return M|0}}n[a+144>>2]=d;M=b;u=K;return M|0}function Kc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;x=u;u=u+16|0;uj(12254);i=f[a+212>>2]|0;h=f[a+180>>2]|0;if((h|0)<(i|0)){if((f[a+184>>2]|0)<(i|0)){if(!i){d=0;g=h}else{f[6472]=(f[6472]|0)+1;d=sc((i<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}g=f[a+180>>2]|0}if((g|0)>0){e=0;do{f[d+(e<<2)>>2]=f[(f[a+188>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0))}e=f[a+188>>2]|0;if(e|0){if(b[a+192>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+188>>2]=0}b[a+192>>0]=1;f[a+188>>2]=d;f[a+184>>2]=i;e=a+188|0}else e=a+188|0;d=h;do{f[(f[e>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=(i|0))}else e=a+188|0;f[a+180>>2]=i;d=0;while(1){if((d|0)>=(Bb[f[(f[a>>2]|0)+104>>2]&127](a)|0))break;f[(f[e>>2]|0)+(d<<2)>>2]=f[(f[a+220>>2]|0)+(d<<2)>>2];d=d+1|0}d=f[a+180>>2]|0;if((d|0)>1)Mi(a+176|0,0,d+-1|0);if(!(Bb[f[(f[a>>2]|0)+104>>2]&127](a)|0))d=0;else d=f[e>>2]|0;g=f[a+196>>2]|0;s=f[a+180>>2]|0;t=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;f[g+4>>2]=c;f[g+12>>2]=d;f[g+16>>2]=s;f[g+20>>2]=t;d=f[g+32>>2]|0;if((d|0)<0){if((f[g+36>>2]|0)<0){e=f[g+40>>2]|0;if(e|0){if(b[g+44>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[g+40>>2]=0}b[g+44>>0]=1;f[g+40>>2]=0;f[g+36>>2]=0}do{f[(f[g+40>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[g+32>>2]=0;d=f[g+52>>2]|0;if((d|0)<0){if((f[g+56>>2]|0)<0){e=f[g+60>>2]|0;if(e|0){if(b[g+64>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[g+60>>2]=0}b[g+64>>0]=1;f[g+60>>2]=0;f[g+56>>2]=0}do{f[(f[g+60>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[g+52>>2]=0;d=f[g+72>>2]|0;if((d|0)<0){if((f[g+76>>2]|0)<0){e=f[g+80>>2]|0;if(e|0){if(b[g+84>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[g+80>>2]=0}b[g+84>>0]=1;f[g+80>>2]=0;f[g+76>>2]=0}do{f[(f[g+80>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[g+72>>2]=0;t=f[a+200>>2]|0;d=f[(f[t>>2]|0)+8>>2]|0;r=f[a+8>>2]|0;s=f[a+24>>2]|0;s=Bb[f[(f[s>>2]|0)+36>>2]&127](s)|0;Vb[d&127](t,r,s);s=f[a+204>>2]|0;r=f[a+24>>2]|0;t=f[a+196>>2]|0;uj(14086);d=f[s+28>>2]|0;if((d|0)<0){if((f[s+32>>2]|0)<0){e=f[s+36>>2]|0;if(e|0){if(b[s+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[s+36>>2]=0}b[s+40>>0]=1;f[s+36>>2]=0;f[s+32>>2]=0}do{f[(f[s+36>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[s+28>>2]=0;i=f[s+8>>2]|0;if((i|0)>0){j=f[s+16>>2]|0;h=0;do{k=j+(h<<3)|0;d=f[k>>2]|0;if((d|0)!=(h|0)){f[k>>2]=f[j+(d<<3)>>2];d=f[j+(d<<3)>>2]|0;e=f[j+(d<<3)>>2]|0;if((d|0)!=(e|0)){g=j+(d<<3)|0;do{d=j+(e<<3)|0;f[g>>2]=f[d>>2];d=f[d>>2]|0;g=j+(d<<3)|0;e=f[g>>2]|0}while((d|0)!=(e|0))}}else d=h;f[k>>2]=d;h=h+1|0}while((h|0)!=(i|0));if((i|0)>1){zj(s+4|0,0,i+-1|0);i=f[s+8>>2]|0}if((i|0)>0){m=f[s+16>>2]|0;d=0;while(1){o=f[m+(d<<3)>>2]|0;k=d;while(1){j=k+1|0;if((j|0)>=(i|0)){l=0;break}if((f[m+(j<<3)>>2]|0)==(o|0))k=j;else{l=1;break}}a:do if((d|0)<=(k|0)){p=f[a+16>>2]|0;e=1;h=d;while(1){g=f[p+(f[m+(h<<3)+4>>2]<<2)>>2]|0;if((f[g+208>>2]|0)==(o|0)){g=f[g+216>>2]|0;e=(g|0)!=4&(e&(g|0)!=1)}if((h|0)<(k|0))h=h+1|0;else break}if(e)while(1){e=f[p+(f[m+(d<<3)+4>>2]<<2)>>2]|0;if((f[e+208>>2]|0)==(o|0)?(f[e+216>>2]&-2|0)!=4:0)f[e+216>>2]=2;if((d|0)>=(k|0))break a;d=d+1|0}else while(1){e=f[p+(f[m+(d<<3)+4>>2]<<2)>>2]|0;if((f[e+208>>2]|0)==(o|0)?(f[e+216>>2]|0)==2:0){f[e+216>>2]=3;n[e+220>>2]=0.0}if((d|0)>=(k|0))break a;d=d+1|0}}while(0);if(l)d=j;else break}}}i=Bb[f[(f[r>>2]|0)+36>>2]&127](r)|0;if((i|0)>0){h=0;do{j=Db[f[(f[r>>2]|0)+40>>2]&31](r,h)|0;e=f[j+740>>2]|0;g=f[j+744>>2]|0;if((e|0)!=0?(f[e+216>>2]|0)!=2:0)d=94;else d=92;if(((d|0)==92?(d=0,g|0):0)?(f[g+216>>2]|0)!=2:0)d=94;if((d|0)==94){d=f[e+204>>2]|0;if((d&2|0?((d&4|0)==0?(f[e+216>>2]|0)!=2:0):0)?(f[g+204>>2]&3|0)==0:0){if((f[g+216>>2]&-2|0)!=4)f[g+216>>2]=1;n[g+220>>2]=0.0}p=f[g+204>>2]|0;if(p&2|0?((p&4|d&3|0)==0?(f[g+216>>2]|0)!=2:0):0){if((f[e+216>>2]&-2|0)!=4)f[e+216>>2]=1;n[e+220>>2]=0.0}if(b[s+64>>0]|0?Fb[f[(f[r>>2]|0)+28>>2]&63](r,e,g)|0:0){e=f[s+28>>2]|0;if((e|0)==(f[s+32>>2]|0)?(q=e|0?e<<1:1,(e|0)<(q|0)):0){if(!q)d=0;else{f[6472]=(f[6472]|0)+1;d=sc((q<<2|3)+16|0)|0;if(!d)d=0;else{f[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=f[s+28>>2]|0}if((e|0)>0){g=0;do{f[d+(g<<2)>>2]=f[(f[s+36>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}g=f[s+36>>2]|0;if(g){if(b[s+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);e=f[s+28>>2]|0}f[s+36>>2]=0}b[s+40>>0]=1;f[s+36>>2]=d;f[s+32>>2]=q;d=e}else d=e;f[(f[s+36>>2]|0)+(d<<2)>>2]=j;f[s+28>>2]=d+1}}h=h+1|0}while((h|0)<(i|0))}d=f[2405]|0;q=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=q;do if(!q){if(f[d+4>>2]|0){gb(x|0,0)|0;q=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[x+4>>2]|0)-(f[q+4>>2]|0)+(((f[x>>2]|0)-(f[q>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(f[d+16>>2]|0)break;d=f[2405]|0}f[2405]=f[d+20>>2]}while(0);q=f[s+8>>2]|0;uj(14114);if(b[s+64>>0]|0){p=f[s+28>>2]|0;if((p|0)>1)Ii(s+24|0,0,p+-1|0);if((q|0)>0){d=0;l=1;o=0;while(1){e=f[s+16>>2]|0;m=f[e+(d<<3)>>2]|0;b:do if((d|0)<(q|0)){h=1;i=f[s+48>>2]|0;g=f[s+52>>2]|0;while(1){k=f[(f[a+16>>2]|0)+(f[e+(d<<3)+4>>2]<<2)>>2]|0;do if((i|0)==(g|0)){j=g|0?g<<1:1;if((g|0)>=(j|0)){e=g;break}if(!j)e=0;else{f[6472]=(f[6472]|0)+1;e=sc((j<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=f[s+48>>2]|0}if((g|0)>0){i=0;do{f[e+(i<<2)>>2]=f[(f[s+56>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(g|0))}i=f[s+56>>2]|0;if(i){if(b[s+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0);g=f[s+48>>2]|0}f[s+56>>2]=0}b[s+60>>0]=1;f[s+56>>2]=e;f[s+52>>2]=j;e=g;g=j}else e=i;while(0);f[(f[s+56>>2]|0)+(e<<2)>>2]=k;i=e+1|0;f[s+48>>2]=i;r=f[k+216>>2]|0;h=h&((r|0)==5|(r|0)==2);d=d+1|0;if((d|0)>=(q|0)){j=d;e=h;break b}e=f[s+16>>2]|0;if((f[e+(d<<3)>>2]|0)!=(m|0)){j=d;e=h;break}}}else{j=d;e=1}while(0);if((o|0)<(p|0)?(v=f[s+36>>2]|0,w=v+(o<<2)|0,r=f[w>>2]|0,k=f[r+740>>2]|0,(f[((f[k+208>>2]|0)>-1?k:f[r+744>>2]|0)+208>>2]|0)==(m|0)):0){d=o;do{d=d+1|0;if((d|0)>=(p|0))break;r=f[v+(d<<2)>>2]|0;l=f[r+740>>2]|0}while((m|0)==(f[((f[l+208>>2]|0)>-1?l:f[r+744>>2]|0)+208>>2]|0));g=w;h=d-o|0;i=d}else{g=0;h=0;i=l}if(!e)cc[f[(f[t>>2]|0)+8>>2]&7](t,f[s+56>>2]|0,f[s+48>>2]|0,g,h,m);o=(h|0)==0?o:i;d=f[s+48>>2]|0;if((d|0)<0){if((f[s+52>>2]|0)<0){e=f[s+56>>2]|0;if(e|0){if(b[s+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[s+56>>2]=0}b[s+60>>0]=1;f[s+56>>2]=0;f[s+52>>2]=0}do{f[(f[s+56>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}f[s+48>>2]=0;if((j|0)>=(q|0))break;else{d=j;l=i}}}}else{v=Bb[f[(f[r>>2]|0)+44>>2]&127](r)|0;w=Bb[f[(f[r>>2]|0)+36>>2]&127](r)|0;cc[f[(f[t>>2]|0)+8>>2]&7](t,f[a+16>>2]|0,f[a+8>>2]|0,v,w,-1)}d=f[2405]|0;w=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=w;do if(!w){if(f[d+4>>2]|0){gb(x|0,0)|0;w=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[x+4>>2]|0)-(f[w+4>>2]|0)+(((f[x>>2]|0)-(f[w>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(f[d+16>>2]|0)break;d=f[2405]|0}f[2405]=f[d+20>>2]}while(0);gh(f[a+196>>2]|0);d=f[a+200>>2]|0;Vb[f[(f[d>>2]|0)+16>>2]&127](d,c,f[a+72>>2]|0);d=f[2405]|0;c=(f[d+16>>2]|0)+-1|0;f[d+16>>2]=c;if(c|0){u=x;return}do if(f[d+4>>2]|0){gb(x|0,0)|0;c=f[6471]|0;n[d+8>>2]=+n[d+8>>2]+ +(((f[x+4>>2]|0)-(f[c+4>>2]|0)+(((f[x>>2]|0)-(f[c>>2]|0)|0)*1e6|0)-(f[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[d+16>>2]|0)){d=f[2405]|0;break}else{u=x;return}}while(0);f[2405]=f[d+20>>2];u=x;return}function Lc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0;q=u;u=u+144|0;k=f[a+48>>2]|0;i=f[a+52>>2]|0;if((i|0?(j=f[i+20>>2]|0,j|0):0)?(Bb[f[(f[j>>2]|0)+48>>2]&127](j)|0)&1|0:0){f[q+48>>2]=1065353216;f[q+48+4>>2]=1065353216;f[q+48+8>>2]=0;n[q+48+12>>2]=0.0;j=f[a+8>>2]|0;o=f[(f[a+52>>2]|0)+20>>2]|0;m=f[(f[o>>2]|0)+8>>2]|0;x=+n[c>>2];D=+n[c+4>>2];A=+n[c+8>>2];v=+n[j+20>>2];r=+n[j+24>>2];w=+n[j+28>>2];s=+n[j+36>>2];z=+n[j+40>>2];B=+n[j+44>>2];t=+n[j+52>>2];C=+n[j+56>>2];y=+n[j+60>>2];n[q+24>>2]=x*+n[j+4>>2]+D*+n[j+8>>2]+A*+n[j+12>>2]+t;n[q+24+4>>2]=x*v+D*r+A*w+C;n[q+24+8>>2]=x*s+D*z+A*B+y;n[q+24+12>>2]=0.0;A=+n[c+16>>2];D=+n[c+20>>2];x=+n[c+24>>2];n[q>>2]=A*+n[j+4>>2]+D*+n[j+8>>2]+x*+n[j+12>>2]+t;n[q+4>>2]=A*v+D*r+x*w+C;n[q+8>>2]=A*s+D*z+x*B+y;n[q+12>>2]=0.0;Yb[m&127](o,q+24|0,q,q+48|0);o=f[(f[a+52>>2]|0)+20>>2]|0;m=f[(f[o>>2]|0)+8>>2]|0;y=+n[c+16>>2];B=+n[c+20>>2];x=+n[c+24>>2];z=+n[j+20>>2];D=+n[j+24>>2];s=+n[j+28>>2];A=+n[j+36>>2];C=+n[j+40>>2];w=+n[j+44>>2];r=+n[j+52>>2];v=+n[j+56>>2];t=+n[j+60>>2];n[q+24>>2]=y*+n[j+4>>2]+B*+n[j+8>>2]+x*+n[j+12>>2]+r;n[q+24+4>>2]=y*z+B*D+x*s+v;n[q+24+8>>2]=y*A+B*C+x*w+t;n[q+24+12>>2]=0.0;x=+n[c+32>>2];B=+n[c+36>>2];y=+n[c+40>>2];n[q>>2]=x*+n[j+4>>2]+B*+n[j+8>>2]+y*+n[j+12>>2]+r;n[q+4>>2]=x*z+B*D+y*s+v;n[q+8>>2]=x*A+B*C+y*w+t;n[q+12>>2]=0.0;Yb[m&127](o,q+24|0,q,q+48|0);o=f[(f[a+52>>2]|0)+20>>2]|0;m=f[(f[o>>2]|0)+8>>2]|0;t=+n[c+32>>2];w=+n[c+36>>2];y=+n[c+40>>2];C=+n[j+20>>2];B=+n[j+24>>2];A=+n[j+28>>2];x=+n[j+36>>2];v=+n[j+40>>2];s=+n[j+44>>2];D=+n[j+52>>2];z=+n[j+56>>2];r=+n[j+60>>2];n[q+24>>2]=t*+n[j+4>>2]+w*+n[j+8>>2]+y*+n[j+12>>2]+D;n[q+24+4>>2]=t*C+w*B+y*A+z;n[q+24+8>>2]=t*x+w*v+y*s+r;n[q+24+12>>2]=0.0;y=+n[c>>2];w=+n[c+4>>2];t=+n[c+8>>2];n[q>>2]=y*+n[j+4>>2]+w*+n[j+8>>2]+t*+n[j+12>>2]+D;n[q+4>>2]=y*C+w*B+t*A+z;n[q+8>>2]=y*x+w*v+t*s+r;n[q+12>>2]=0.0;Yb[m&127](o,q+24|0,q,q+48|0)}i=((d<<21|e)+~(e<<15)>>10^(d<<21|e)+~(e<<15))*9|0;i=(f[a+108>>2]|0)+-1&((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11));a:do if(i>>>0<(f[a+64>>2]|0)>>>0?(g=f[(f[a+72>>2]|0)+(i<<2)>>2]|0,(g|0)!=-1):0){i=f[a+132>>2]|0;while(1){if((d<<21|e|0)==(f[i+(g<<2)>>2]|0))break;g=f[(f[a+92>>2]|0)+(g<<2)>>2]|0;if((g|0)==-1)break a}i=f[a+112>>2]|0;if(i+(g<<3)|0){o=f[i+(g<<3)+4>>2]|0;p=f[a+8>>2]|0;f[o+8>>2]=f[(f[p+192>>2]|0)+8>>2];m=f[a+4>>2]|0;l=f[m+192>>2]|0;f[q+48>>2]=0;f[q+48+4>>2]=l;f[q+48+8>>2]=m;f[q+48+12>>2]=m+4;f[q+48+16>>2]=-1;f[q+48+20>>2]=-1;f[q+24>>2]=0;f[q+24+4>>2]=o;f[q+24+8>>2]=p;f[q+24+12>>2]=p+4;f[q+24+16>>2]=d;f[q+24+20>>2]=e;p=Gb[f[(f[k>>2]|0)+8>>2]&31](k,q+48|0,q+24|0,0)|0;ac[f[(f[p>>2]|0)+8>>2]&31](p,q+48|0,q+24|0,f[a+52>>2]|0,f[a+44>>2]|0);Lb[f[f[p>>2]>>2]&511](p);Rb[f[(f[k>>2]|0)+60>>2]&127](k,p);u=q;return}}while(0);t=+n[c+16>>2];E=+n[c>>2];v=+n[c+20>>2];r=+n[c+4>>2];w=+n[c+24>>2];s=+n[c+8>>2];x=+n[c+32>>2];z=+n[c+36>>2];B=+n[c+40>>2];y=(v-r)*(B-s)-(w-s)*(z-r);A=(w-s)*(x-E)-(t-E)*(B-s);D=(t-E)*(z-r)-(v-r)*(x-E);C=1.0/+L(+(D*D+(y*y+A*A)));n[q+48>>2]=E+C*y*.05999999865889549;n[q+48+4>>2]=r+C*A*.05999999865889549;n[q+48+8>>2]=C*D*.05999999865889549+s;n[q+48+12>>2]=0.0;n[q+48+16>>2]=C*y*.05999999865889549+t;n[q+48+20>>2]=C*A*.05999999865889549+v;n[q+48+24>>2]=C*D*.05999999865889549+w;n[q+48+28>>2]=0.0;n[q+48+32>>2]=C*y*.05999999865889549+x;n[q+48+36>>2]=C*A*.05999999865889549+z;n[q+48+40>>2]=C*D*.05999999865889549+B;n[q+48+44>>2]=0.0;n[q+48+48>>2]=E-C*y*.05999999865889549;n[q+48+52>>2]=r-C*A*.05999999865889549;n[q+48+56>>2]=s-C*D*.05999999865889549;n[q+48+60>>2]=0.0;n[q+48+64>>2]=t-C*y*.05999999865889549;n[q+48+68>>2]=v-C*A*.05999999865889549;n[q+48+72>>2]=w-C*D*.05999999865889549;n[q+48+76>>2]=0.0;n[q+48+80>>2]=x-C*y*.05999999865889549;n[q+48+84>>2]=z-C*A*.05999999865889549;n[q+48+88>>2]=B-C*D*.05999999865889549;n[q+48+92>>2]=0.0;f[6472]=(f[6472]|0)+1;g=sc(131)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}ng(g,q+48|0,6,16);o=f[a+8>>2]|0;f[g+8>>2]=f[(f[o+192>>2]|0)+8>>2];m=f[a+4>>2]|0;c=f[m+192>>2]|0;f[q+24>>2]=0;f[q+24+4>>2]=c;f[q+24+8>>2]=m;f[q+24+12>>2]=m+4;f[q+24+16>>2]=-1;f[q+24+20>>2]=-1;f[q>>2]=0;f[q+4>>2]=g;f[q+8>>2]=o;f[q+12>>2]=o+4;f[q+16>>2]=d;f[q+20>>2]=e;o=Gb[f[(f[k>>2]|0)+8>>2]&31](k,q+24|0,q,0)|0;ac[f[(f[o>>2]|0)+8>>2]&31](o,q+24|0,q,f[a+52>>2]|0,f[a+44>>2]|0);Lb[f[f[o>>2]>>2]&511](o);Rb[f[(f[k>>2]|0)+60>>2]&127](k,o);o=((d<<21|e)+~(e<<15)>>10^(d<<21|e)+~(e<<15))*9|0;o=(o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11);k=f[a+108>>2]|0;b:do if((o&k+-1)>>>0<(f[a+64>>2]|0)>>>0?(h=f[(f[a+72>>2]|0)+((o&k+-1)<<2)>>2]|0,(h|0)!=-1):0){i=f[a+132>>2]|0;while(1){if((d<<21|e|0)==(f[i+(h<<2)>>2]|0))break;h=f[(f[a+92>>2]|0)+(h<<2)>>2]|0;if((h|0)==-1){p=20;break b}}a=f[a+112>>2]|0;f[a+(h<<3)>>2]=d<<21|e;f[a+(h<<3)+4>>2]=g}else p=20;while(0);if((p|0)==20){m=f[a+104>>2]|0;if((m|0)==(k|0)){c=k|0?k<<1:1;if((k|0)<(c|0)){if(!c){h=0;j=k}else{f[6472]=(f[6472]|0)+1;h=sc((c<<3|3)+16|0)|0;if(!h)h=0;else{f[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=f[a+104>>2]|0}if((j|0)>0){i=0;do{H=(f[a+112>>2]|0)+(i<<3)|0;G=f[H+4>>2]|0;F=h+(i<<3)|0;f[F>>2]=f[H>>2];f[F+4>>2]=G;i=i+1|0}while((i|0)!=(j|0))}i=f[a+112>>2]|0;if(i|0){if(b[a+116>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+112>>2]=0}b[a+116>>0]=1;f[a+112>>2]=h;f[a+108>>2]=c;h=f[a+104>>2]|0}else h=k}else h=m;H=f[a+112>>2]|0;f[H+(h<<3)>>2]=d<<21|e;f[H+(h<<3)+4>>2]=g;f[a+104>>2]=(f[a+104>>2]|0)+1;g=f[a+124>>2]|0;if((g|0)==(f[a+128>>2]|0)?(l=g|0?g<<1:1,(g|0)<(l|0)):0){if(!l)j=0;else{f[6472]=(f[6472]|0)+1;g=sc((l<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}j=g;g=f[a+124>>2]|0}i=f[a+132>>2]|0;if((g|0)<=0)if(!i)h=a+136|0;else p=43;else{h=0;do{f[j+(h<<2)>>2]=f[i+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0));p=43}if((p|0)==43){if(b[a+136>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[a+132>>2]=0;h=a+136|0;g=f[a+124>>2]|0}b[h>>0]=1;f[a+132>>2]=j;f[a+128>>2]=l}f[(f[a+132>>2]|0)+(g<<2)>>2]=d<<21|e;f[a+124>>2]=(f[a+124>>2]|0)+1;l=f[a+108>>2]|0;if((k|0)<(l|0)){d=f[a+64>>2]|0;if((d|0)<(l|0)){if((f[a+68>>2]|0)<(l|0)){if(!l){g=0;i=d}else{f[6472]=(f[6472]|0)+1;g=sc((l<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=f[a+64>>2]|0}j=f[a+72>>2]|0;if((i|0)<=0)if(!j)h=a+76|0;else p=59;else{h=0;do{f[g+(h<<2)>>2]=f[j+(h<<2)>>2];h=h+1|0}while((h|0)!=(i|0));p=59}if((p|0)==59)if(!(b[a+76>>0]|0))h=a+76|0;else{f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=a+76|0}b[h>>0]=1;f[a+72>>2]=g;f[a+68>>2]=l;k=a+72|0}else{k=a+72|0;g=f[a+72>>2]|0}bl(g+(d<<2)|0,0,(l<<2)-(d<<2)|0)|0;f[a+64>>2]=l;c=f[a+84>>2]|0;if((c|0)<(l|0)){if((f[a+88>>2]|0)<(l|0)){if(!l){g=0;i=c}else{f[6472]=(f[6472]|0)+1;g=sc((l<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=f[a+84>>2]|0}j=f[a+92>>2]|0;if((i|0)<=0)if(!j)h=a+96|0;else p=73;else{h=0;do{f[g+(h<<2)>>2]=f[j+(h<<2)>>2];h=h+1|0}while((h|0)!=(i|0));p=73}if((p|0)==73)if(!(b[a+96>>0]|0))h=a+96|0;else{f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0);h=a+96|0}b[h>>0]=1;f[a+92>>2]=g;f[a+88>>2]=l}else g=f[a+92>>2]|0;bl(g+(c<<2)|0,0,(l<<2)-(c<<2)|0)|0}f[a+84>>2]=l;if((l|0)>0){bl(f[k>>2]|0,-1,l<<2|0)|0;bl(f[a+92>>2]|0,-1,l<<2|0)|0}if((d|0)>0){j=f[a+132>>2]|0;h=f[k>>2]|0;i=f[a+92>>2]|0;g=0;do{H=f[j+(g<<2)>>2]|0;H=(H+~(H<<15)>>10^H+~(H<<15))*9|0;H=h+((((H>>6^H)+~((H>>6^H)<<11)>>16^(H>>6^H)+~((H>>6^H)<<11))&(f[a+108>>2]|0)+-1)<<2)|0;f[i+(g<<2)>>2]=f[H>>2];f[H>>2]=g;g=g+1|0}while((g|0)!=(d|0))}}g=o&(f[a+108>>2]|0)+-1}else g=o&k+-1;H=(f[a+72>>2]|0)+(g<<2)|0;f[(f[a+92>>2]|0)+(m<<2)>>2]=f[H>>2];f[H>>2]=m}u=q;return}
function Mc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;t=u;u=u+48|0;A=1.0/+n[a+108>>2];B=1.0/+n[a+112>>2];C=1.0/+n[a+116>>2];v=+n[a+48>>2];w=A*+n[d>>2]+v;o=+n[a+52>>2];m=B*+n[d+4>>2]+o;q=+n[a+56>>2];p=C*+n[d+8>>2]+q;v=A*+n[e>>2]+v;o=B*+n[e+4>>2]+o;q=C*+n[e+8>>2]+q;C=+n[a+16>>2];w=w<C?C:w;B=+n[a+20>>2];m=m<B?B:m;A=+n[a+24>>2];p=p<A?A:p;z=+n[a+32>>2];w=z<w?z:w;y=+n[a+36>>2];m=y<m?y:m;x=+n[a+40>>2];p=x<p?x:p;v=v<C?C:v;o=o<B?B:o;q=q<A?A:q;v=z<v?z:v;o=y<o?y:o;q=x<q?x:q;k=~~((w<0.0?-.5:.5)+w)+-1|0;h=~~((v<0.0?-.5:.5)+v)+1|0;l=~~((m<0.0?-.5:.5)+m)+-1|0;i=~~((o<0.0?-.5:.5)+o)+1|0;g=~~((p<0.0?-.5:.5)+p)+-1|0;d=~~((q<0.0?-.5:.5)+q)+1|0;j=(f[a+64>>2]|0)+-1|0;e=(f[a+68>>2]|0)+-1|0;switch(f[a+104>>2]|0){case 0:{e=(d|0)<(e|0)?d:e;d=(g|0)>0?g:0;j=(i|0)<(j|0)?i:j;l=(l|0)>0?l:0;break}case 1:{e=(d|0)<(e|0)?d:e;d=(g|0)>0?g:0;j=(h|0)<(j|0)?h:j;l=(k|0)>0?k:0;break}case 2:{e=(i|0)<(e|0)?i:e;d=(l|0)>0?l:0;j=(h|0)<(j|0)?h:j;l=(k|0)>0?k:0;break}default:{d=0;l=0}}if((d|0)>=(e|0)){u=t;return}r=(l|0)<(j|0);do if(r){i=(d&1|0)==0;k=d+1|0;q=+(d|0);g=l;while(1){do if(!(b[a+100>>0]|0)){if(b[a+101>>0]|0?(g+d&1|0)==0:0){s=16;break}if(!(i&(b[a+102>>0]|0)!=0)){m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,g,d);switch(f[a+104>>2]|0){case 0:{p=+(g|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=q-+n[a+84>>2]*.5;s=52;break}case 1:{p=m-+n[a+52>>2];o=+(g|0)-+n[a+80>>2]*.5;m=q-+n[a+84>>2]*.5;s=52;break}case 2:{p=q-+n[a+84>>2]*.5;o=+(g|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=52;break}default:{o=+n[t>>2];p=+n[t+4>>2];m=+n[t+8>>2]}}if((s|0)==52){s=0;n[t>>2]=o;n[t+4>>2]=p;n[t+8>>2]=m;n[t+12>>2]=0.0}n[t>>2]=o*+n[a+108>>2];n[t+4>>2]=p*+n[a+112>>2];n[t+8>>2]=m*+n[a+116>>2];m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,g,k);switch(f[a+104>>2]|0){case 0:{p=+(g|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=+(k|0)-+n[a+84>>2]*.5;s=58;break}case 1:{p=m-+n[a+52>>2];o=+(g|0)-+n[a+80>>2]*.5;m=+(k|0)-+n[a+84>>2]*.5;s=58;break}case 2:{p=+(k|0)-+n[a+84>>2]*.5;o=+(g|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=58;break}default:{o=+n[t+16>>2];p=+n[t+20>>2];m=+n[t+24>>2]}}if((s|0)==58){s=0;n[t+16>>2]=o;n[t+20>>2]=p;n[t+24>>2]=m;n[t+28>>2]=0.0}n[t+16>>2]=o*+n[a+108>>2];n[t+20>>2]=p*+n[a+112>>2];n[t+24>>2]=m*+n[a+116>>2];h=g+1|0;m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,d);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=q-+n[a+84>>2]*.5;s=64;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=q-+n[a+84>>2]*.5;s=64;break}case 2:{p=q-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=64;break}default:{o=+n[t+32>>2];p=+n[t+36>>2];m=+n[t+40>>2]}}if((s|0)==64){s=0;n[t+32>>2]=o;n[t+36>>2]=p;n[t+40>>2]=m;n[t+44>>2]=0.0}n[t+32>>2]=o*+n[a+108>>2];n[t+36>>2]=p*+n[a+112>>2];n[t+40>>2]=m*+n[a+116>>2];Yb[f[(f[c>>2]|0)+8>>2]&127](c,t,g,d);m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,d);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=q-+n[a+84>>2]*.5;s=70;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=q-+n[a+84>>2]*.5;s=70;break}case 2:{p=q-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=70;break}default:{o=+n[t>>2];p=+n[t+4>>2];m=+n[t+8>>2]}}if((s|0)==70){s=0;n[t>>2]=o;n[t+4>>2]=p;n[t+8>>2]=m;n[t+12>>2]=0.0}n[t>>2]=o*+n[a+108>>2];n[t+4>>2]=p*+n[a+112>>2];n[t+8>>2]=m*+n[a+116>>2];m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,k);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=+(k|0)-+n[a+84>>2]*.5;s=76;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=+(k|0)-+n[a+84>>2]*.5;s=76;break}case 2:{p=+(k|0)-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=76;break}default:{o=+n[t+32>>2];p=+n[t+36>>2];m=+n[t+40>>2]}}if((s|0)==76){s=0;n[t+32>>2]=o;n[t+36>>2]=p;n[t+40>>2]=m;n[t+44>>2]=0.0}n[t+32>>2]=o*+n[a+108>>2];n[t+36>>2]=p*+n[a+112>>2];n[t+40>>2]=m*+n[a+116>>2];Yb[f[(f[c>>2]|0)+8>>2]&127](c,t,g,d);g=h}else s=16}else s=16;while(0);if((s|0)==16){s=0;m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,g,d);switch(f[a+104>>2]|0){case 0:{p=+(g|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=q-+n[a+84>>2]*.5;s=21;break}case 1:{p=m-+n[a+52>>2];o=+(g|0)-+n[a+80>>2]*.5;m=q-+n[a+84>>2]*.5;s=21;break}case 2:{p=q-+n[a+84>>2]*.5;o=+(g|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=21;break}default:{o=+n[t>>2];p=+n[t+4>>2];m=+n[t+8>>2]}}if((s|0)==21){s=0;n[t>>2]=o;n[t+4>>2]=p;n[t+8>>2]=m;n[t+12>>2]=0.0}n[t>>2]=o*+n[a+108>>2];n[t+4>>2]=p*+n[a+112>>2];n[t+8>>2]=m*+n[a+116>>2];h=g+1|0;m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,d);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=q-+n[a+84>>2]*.5;s=27;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=q-+n[a+84>>2]*.5;s=27;break}case 2:{p=q-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=27;break}default:{o=+n[t+16>>2];p=+n[t+20>>2];m=+n[t+24>>2]}}if((s|0)==27){s=0;n[t+16>>2]=o;n[t+20>>2]=p;n[t+24>>2]=m;n[t+28>>2]=0.0}n[t+16>>2]=o*+n[a+108>>2];n[t+20>>2]=p*+n[a+112>>2];n[t+24>>2]=m*+n[a+116>>2];m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,k);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=+(k|0)-+n[a+84>>2]*.5;s=33;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=+(k|0)-+n[a+84>>2]*.5;s=33;break}case 2:{p=+(k|0)-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=33;break}default:{o=+n[t+32>>2];p=+n[t+36>>2];m=+n[t+40>>2]}}if((s|0)==33){s=0;n[t+32>>2]=o;n[t+36>>2]=p;n[t+40>>2]=m;n[t+44>>2]=0.0}n[t+32>>2]=o*+n[a+108>>2];n[t+36>>2]=p*+n[a+112>>2];n[t+40>>2]=m*+n[a+116>>2];Yb[f[(f[c>>2]|0)+8>>2]&127](c,t,g,d);m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,h,k);switch(f[a+104>>2]|0){case 0:{p=+(h|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=+(k|0)-+n[a+84>>2]*.5;s=39;break}case 1:{p=m-+n[a+52>>2];o=+(h|0)-+n[a+80>>2]*.5;m=+(k|0)-+n[a+84>>2]*.5;s=39;break}case 2:{p=+(k|0)-+n[a+84>>2]*.5;o=+(h|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=39;break}default:{o=+n[t+16>>2];p=+n[t+20>>2];m=+n[t+24>>2]}}if((s|0)==39){s=0;n[t+16>>2]=o;n[t+20>>2]=p;n[t+24>>2]=m;n[t+28>>2]=0.0}n[t+16>>2]=o*+n[a+108>>2];n[t+20>>2]=p*+n[a+112>>2];n[t+24>>2]=m*+n[a+116>>2];m=+ub[f[(f[a>>2]|0)+68>>2]&15](a,g,k);switch(f[a+104>>2]|0){case 0:{p=+(g|0)-+n[a+80>>2]*.5;o=m-+n[a+48>>2];m=+(k|0)-+n[a+84>>2]*.5;s=45;break}case 1:{p=m-+n[a+52>>2];o=+(g|0)-+n[a+80>>2]*.5;m=+(k|0)-+n[a+84>>2]*.5;s=45;break}case 2:{p=+(k|0)-+n[a+84>>2]*.5;o=+(g|0)-+n[a+80>>2]*.5;m=m-+n[a+56>>2];s=45;break}default:{o=+n[t+32>>2];p=+n[t+36>>2];m=+n[t+40>>2]}}if((s|0)==45){s=0;n[t+32>>2]=o;n[t+36>>2]=p;n[t+40>>2]=m;n[t+44>>2]=0.0}n[t+32>>2]=o*+n[a+108>>2];n[t+36>>2]=p*+n[a+112>>2];n[t+40>>2]=m*+n[a+116>>2];Yb[f[(f[c>>2]|0)+8>>2]&127](c,t,g,d);g=h}if((g|0)==(j|0)){d=k;break}}}else d=d+1|0;while((d|0)!=(e|0));u=t;return}function Nc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0,Q=0.0,R=0.0,S=0.0,T=0;P=u;u=u+208|0;n[a+56>>2]=0.0;G=P+192+4|0;H=P+192+8|0;f[P+192>>2]=0;f[P+192+4>>2]=0;f[P+192+8>>2]=0;f[P+192+12>>2]=0;f[P+128>>2]=f[c>>2];f[P+128+4>>2]=f[c+4>>2];f[P+128+8>>2]=f[c+8>>2];f[P+128+12>>2]=f[c+12>>2];f[P+128+16>>2]=f[c+16>>2];f[P+128+16+4>>2]=f[c+16+4>>2];f[P+128+16+8>>2]=f[c+16+8>>2];f[P+128+16+12>>2]=f[c+16+12>>2];f[P+128+32>>2]=f[c+32>>2];f[P+128+32+4>>2]=f[c+32+4>>2];f[P+128+32+8>>2]=f[c+32+8>>2];f[P+128+32+12>>2]=f[c+32+12>>2];D=P+128+48|0;f[D>>2]=f[c+48>>2];f[D+4>>2]=f[c+48+4>>2];f[D+8>>2]=f[c+48+8>>2];f[D+12>>2]=f[c+48+12>>2];f[P+64>>2]=f[c+64>>2];f[P+64+4>>2]=f[c+64+4>>2];f[P+64+8>>2]=f[c+64+8>>2];f[P+64+12>>2]=f[c+64+12>>2];f[P+64+16>>2]=f[c+80>>2];f[P+64+16+4>>2]=f[c+80+4>>2];f[P+64+16+8>>2]=f[c+80+8>>2];f[P+64+16+12>>2]=f[c+80+12>>2];f[P+64+32>>2]=f[c+96>>2];f[P+64+32+4>>2]=f[c+96+4>>2];f[P+64+32+8>>2]=f[c+96+8>>2];f[P+64+32+12>>2]=f[c+96+12>>2];E=P+64+48|0;f[E>>2]=f[c+112>>2];f[E+4>>2]=f[c+112+4>>2];f[E+8>>2]=f[c+112+8>>2];f[E+12>>2]=f[c+112+12>>2];I=+n[D>>2];J=+n[E>>2];K=+n[P+128+52>>2];M=+n[P+64+52>>2];N=+n[P+128+56>>2];O=+n[P+64+56>>2];n[D>>2]=I-(I+J)*.5;n[P+128+52>>2]=K-(K+M)*.5;n[P+128+56>>2]=N-(N+O)*.5;n[E>>2]=J-(I+J)*.5;n[P+64+52>>2]=M-(K+M)*.5;n[P+64+56>>2]=O-(N+O)*.5;if(((f[(f[a+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)D=((f[(f[a+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else D=0;v=+n[a+44>>2];t=+n[a+48>>2];f[6457]=(f[6457]|0)+1;E=b[a+52>>0]|0;f[a+64>>2]=0;f[a+4>>2]=0;f[a+8>>2]=1065353216;f[a+12>>2]=0;n[a+16>>2]=0.0;f[a+68>>2]=0;f[a+60>>2]=-1;j=f[a+24>>2]|0;b[j+312>>0]=0;f[j>>2]=0;b[j+356>>0]=1;f[j+292>>2]=1566444395;f[j+296>>2]=1566444395;f[j+300>>2]=1566444395;n[j+304>>2]=0.0;f[j+336>>2]=0;f[j+336+4>>2]=0;f[j+336+8>>2]=0;f[j+336+12>>2]=0;b[j+336+16>>0]=0;b[j+332>>0]=b[j+332>>0]&-16;o=999999984306749440.0;j=0;do{p=+n[a+4>>2];m=+n[a+8>>2];i=+n[a+12>>2];k=+n[c+4>>2]*-p+ +n[c+20>>2]*-m+ +n[c+36>>2]*-i;l=+n[c+8>>2]*-p+ +n[c+24>>2]*-m+ +n[c+40>>2]*-i;n[P+48>>2]=+n[c>>2]*-p+ +n[c+16>>2]*-m+ +n[c+32>>2]*-i;n[P+48+4>>2]=k;n[P+48+8>>2]=l;n[P+48+12>>2]=0.0;l=p*+n[c+68>>2]+m*+n[c+84>>2]+i*+n[c+100>>2];k=p*+n[c+72>>2]+m*+n[c+88>>2]+i*+n[c+104>>2];n[P+32>>2]=+n[c+64>>2]*p+ +n[c+80>>2]*m+ +n[c+96>>2]*i;n[P+32+4>>2]=l;n[P+32+8>>2]=k;n[P+32+12>>2]=0.0;Gd(P+16|0,f[a+28>>2]|0,P+48|0);Gd(P,f[a+32>>2]|0,P+32|0);k=+n[P+16>>2];l=+n[P+16+4>>2];i=+n[P+16+8>>2];m=k*+n[P+128>>2]+l*+n[P+128+4>>2]+i*+n[P+128+8>>2]+ +n[P+128+48>>2];p=k*+n[P+128+16>>2]+l*+n[P+128+20>>2]+i*+n[P+128+24>>2]+ +n[P+128+52>>2];i=k*+n[P+128+32>>2]+l*+n[P+128+36>>2]+i*+n[P+128+40>>2]+ +n[P+128+56>>2];l=+n[P>>2];k=+n[P+4>>2];s=+n[P+8>>2];q=l*+n[P+64>>2]+k*+n[P+64+4>>2]+s*+n[P+64+8>>2]+ +n[P+64+48>>2];r=l*+n[P+64+16>>2]+k*+n[P+64+20>>2]+s*+n[P+64+24>>2]+ +n[P+64+52>>2];s=l*+n[P+64+32>>2]+k*+n[P+64+36>>2]+s*+n[P+64+40>>2]+ +n[P+64+56>>2];k=D?0.0:s;l=D?0.0:i;s=(D?0.0:i)-(D?0.0:s);i=+n[a+4>>2]*(m-q)+ +n[a+8>>2]*(p-r)+ +n[a+12>>2]*s;if(i>0.0?i*i>o*+n[c+128>>2]:0){f[a+68>>2]=10;g=0;j=1}else T=7;do if((T|0)==7){T=0;B=f[a+24>>2]|0;C=f[B>>2]|0;if((C|0)>0){h=+n[B+308>>2];z=0;g=0;do{x=m-q-+n[B+4+(z<<4)>>2];y=p-r-+n[B+4+(z<<4)+4>>2];A=s-+n[B+4+(z<<4)+8>>2];g=g|x*x+y*y+A*A<=h;z=z+1|0}while((z|0)!=(C|0))}else g=0;if((+n[B+304>>2]==0.0?s==+n[B+300>>2]:0)?p-r==+n[B+296>>2]:0){if(m-q==+n[B+292>>2]|g)T=15}else T=14;if((T|0)==14?(T=0,g):0)T=15;if((T|0)==15){T=0;f[a+68>>2]=1;g=0;j=1;break}h=o-i;if(h<=o*9.999999974752427e-07){f[a+68>>2]=h<=0.0?2:11;g=0;j=1;break}n[B+292>>2]=m-q;n[B+296>>2]=p-r;n[B+300>>2]=s;n[B+304>>2]=0.0;b[B+356>>0]=1;n[B+4+(C<<4)>>2]=m-q;n[B+4+(C<<4)+4>>2]=p-r;n[B+4+(C<<4)+8>>2]=s;n[B+4+(C<<4)+12>>2]=0.0;g=f[B>>2]|0;n[B+84+(g<<4)>>2]=m;n[B+84+(g<<4)+4>>2]=p;n[B+84+(g<<4)+8>>2]=l;n[B+84+(g<<4)+12>>2]=0.0;g=f[B>>2]|0;n[B+164+(g<<4)>>2]=q;n[B+164+(g<<4)+4>>2]=r;n[B+164+(g<<4)+8>>2]=k;n[B+164+(g<<4)+12>>2]=0.0;f[B>>2]=(f[B>>2]|0)+1;g=f[a+24>>2]|0;C=wc(g)|0;h=+n[g+276>>2];i=+n[g+280>>2];k=+n[g+284>>2];g=f[g+288>>2]|0;if(!C){f[a+68>>2]=3;g=0;j=1;break}if(h*h+i*i+k*k<9.999999974752427e-07){n[a+4>>2]=h;n[a+8>>2]=i;n[a+12>>2]=k;f[a+16>>2]=g;f[a+68>>2]=6;g=0;j=1;break}if(o-(h*h+i*i+k*k)<=o*1.1920928955078125e-07){f[a+68>>2]=12;o=h*h+i*i+k*k;g=0;j=1;break}n[a+4>>2]=h;n[a+8>>2]=i;n[a+12>>2]=k;f[a+16>>2]=g;C=f[a+64>>2]|0;f[a+64>>2]=C+1;if((C|0)<=1e3)if((f[f[a+24>>2]>>2]|0)==4){f[a+68>>2]=13;o=h*h+i*i+k*k;g=0}else{o=h*h+i*i+k*k;g=1}else{o=h*h+i*i+k*k;g=0}}while(0)}while(g);w=E<<24>>24==0?t:0.0;v=(E<<24>>24==0?v:0.0)+w;if(j){E=f[a+24>>2]|0;wc(E)|0;k=+n[E+260>>2];i=+n[E+264>>2];h=+n[E+268>>2];f[P+192>>2]=f[a+4>>2];f[P+192+4>>2]=f[a+4+4>>2];f[P+192+8>>2]=f[a+4+8>>2];f[P+192+12>>2]=f[a+4+12>>2];l=+n[a+4>>2];m=+n[a+8>>2];p=+n[a+12>>2];if(l*l+m*m+p*p<.0001)f[a+68>>2]=5;if(l*l+m*m+p*p>1.4210854715202004e-14){y=1.0/+L(+(l*l+m*m+p*p));n[P+192>>2]=y*+n[P+192>>2];n[G>>2]=y*+n[G>>2];n[H>>2]=y*+n[H>>2];A=w/+L(+o);o=1.0/y-v;j=1;g=1;k=A*l+k;i=A*m+i;h=A*p+h}else{o=0.0;j=0;g=2}f[a+60>>2]=g}else{o=0.0;j=0;k=0.0;i=0.0;h=0.0}if((f[a+72>>2]|0)!=0?(f[a+20>>2]|0)!=0:0)g=v+o<.01&(f[a+68>>2]|0)!=0;else g=0;z=j^1;do if(g|z?(F=f[a+20>>2]|0,(F|0)!=0):0){f[6456]=(f[6456]|0)+1;f[a+4>>2]=0;f[a+4+4>>2]=0;f[a+4+8>>2]=0;f[a+4+12>>2]=0;if(Jb[f[(f[F>>2]|0)+8>>2]&3](F,f[a+24>>2]|0,f[a+28>>2]|0,f[a+32>>2]|0,P+128|0,P+64|0,a+4|0,P+48|0,P+32|0,e)|0){x=+n[P+32>>2];m=+n[P+48>>2];y=+n[P+32+4>>2];p=+n[P+48+4>>2];A=+n[P+32+8>>2];q=+n[P+48+8>>2];if(!((x-m)*(x-m)+(y-p)*(y-p)+(A-q)*(A-q)<=1.4210854715202004e-14)){l=(x-m)*(x-m)+(y-p)*(y-p)+(A-q)*(A-q);s=x-m;t=A-q;v=0.0;w=y-p}else{s=+n[a+4>>2];w=+n[a+8>>2];t=+n[a+12>>2];l=s*s+w*w+t*t;v=+n[a+16>>2]}if(l>1.4210854715202004e-14){r=1.0/+L(+l);l=-+L(+((m-x)*(m-x)+(p-y)*(p-y)+(q-A)*(q-A)));if(o>l|z){n[P+192>>2]=s*r;n[G>>2]=w*r;n[H>>2]=t*r;n[P+192+12>>2]=v;f[a+60>>2]=3;k=x;i=y;h=A;break}else g=8}else g=9;f[a+60>>2]=g;if(j){l=o;break}u=P;return}else{m=+n[a+4>>2];q=+n[a+8>>2];s=+n[a+12>>2];if(!(m*m+q*q+s*s>0.0)){if(j){l=o;break}u=P;return}p=+n[P+32>>2];y=+n[P+48>>2]-p;r=+n[P+32+4>>2];A=+n[P+48+4>>2]-r;t=+n[P+32+8>>2];l=+n[P+48+8>>2]-t;l=+L(+(y*y+A*A+l*l))-v;if(l<o|z){f[P+192>>2]=f[a+4>>2];f[P+192+4>>2]=f[a+4+4>>2];f[P+192+8>>2]=f[a+4+8>>2];f[P+192+12>>2]=f[a+4+12>>2];A=+n[P+192>>2];h=+n[G>>2];i=+n[H>>2];k=1.0/+L(+(A*A+h*h+i*i));n[P+192>>2]=A*k;n[G>>2]=h*k;n[H>>2]=i*k;f[a+60>>2]=6;k=w*m+p;i=w*q+r;h=w*s+t;break}f[a+60>>2]=5;if(j){l=o;break}u=P;return}}else T=51;while(0);if((T|0)==51)if(j)l=o;else{u=P;return}if(!(l<0.0)?!(l*l<+n[c+128>>2]):0){u=P;return}if(f[a+76>>2]|0?(T=f[a+28>>2]|0,Yb[f[(f[T>>2]|0)+8>>2]&127](T,P+128|0,P+48|0,P+32|0),x=(+n[P+32>>2]+ +n[P+48>>2])*.5,y=(+n[P+32+4>>2]+ +n[P+48+4>>2])*.5,A=(+n[P+32+8>>2]+ +n[P+48+8>>2])*.5,T=f[a+32>>2]|0,Yb[f[(f[T>>2]|0)+8>>2]&127](T,P+64|0,P+48|0,P+32|0),Q=+n[P+192>>2],R=+n[G>>2],S=+n[H>>2],(x-(+n[P+48>>2]+ +n[P+32>>2])*.5)*Q+(y-(+n[P+48+4>>2]+ +n[P+32+4>>2])*.5)*R+(A-(+n[P+48+8>>2]+ +n[P+32+8>>2])*.5)*S<0.0):0){n[P+192>>2]=-Q;n[G>>2]=-R;n[H>>2]=-S}f[a+4>>2]=f[P+192>>2];f[a+4+4>>2]=f[P+192+4>>2];f[a+4+8>>2]=f[P+192+8>>2];f[a+4+12>>2]=f[P+192+12>>2];n[a+56>>2]=l;T=f[(f[d>>2]|0)+16>>2]|0;n[P+48>>2]=(I+J)*.5+k;n[P+48+4>>2]=(K+M)*.5+i;n[P+48+8>>2]=(N+O)*.5+h;n[P+48+12>>2]=0.0;Wb[T&15](d,P+192|0,P+48|0,l);u=P;return}function Oc(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=+g;h=+h;i=i|0;var j=0,k=0.0,l=0,m=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0.0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0.0,Y=0.0,Z=0.0,_=0,$=0;W=u;u=u+48|0;b[W+16+16>>0]=1;V=W+16+12|0;f[V>>2]=0;f[W+16+4>>2]=0;f[W+16+8>>2]=0;o=f[e+4>>2]|0;if((o|0)>0){f[6472]=(f[6472]|0)+1;j=sc((o<<4|3)+16|0)|0;if(!j)m=0;else{f[(j+4+15&-16)+-4>>2]=j;m=j+4+15&-16}l=f[W+16+4>>2]|0;if((l|0)>0){j=0;do{U=m+(j<<4)|0;T=(f[V>>2]|0)+(j<<4)|0;f[U>>2]=f[T>>2];f[U+4>>2]=f[T+4>>2];f[U+8>>2]=f[T+8>>2];f[U+12>>2]=f[T+12>>2];j=j+1|0}while((j|0)!=(l|0))}j=f[V>>2]|0;if(j|0){if(b[W+16+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0)}f[V>>2]=0}b[W+16+16>>0]=1;f[V>>2]=m;f[W+16+8>>2]=o}l=f[c+28>>2]|0;if((l|0)>0){U=f[c+36>>2]|0;E=+n[d>>2];F=+n[d+4>>2];G=+n[d+8>>2];H=+n[d+16>>2];t=+n[d+20>>2];r=+n[d+24>>2];q=+n[d+32>>2];p=+n[d+36>>2];k=+n[d+40>>2];v=+n[a>>2];w=+n[a+4>>2];x=+n[a+8>>2];T=-1;s=3402823466385288598117041.0e14;j=0;while(1){y=+n[U+(j*36|0)+20>>2];z=+n[U+(j*36|0)+24>>2];A=+n[U+(j*36|0)+28>>2];m=(y*E+z*F+A*G)*v+(y*H+z*t+A*r)*w+(y*q+z*p+A*k)*x<s;T=m?j:T;j=j+1|0;if((j|0)==(l|0))break;else s=m?(y*E+z*F+A*G)*v+(y*H+z*t+A*r)*w+(y*q+z*p+A*k)*x:s}if((T|0)>=0){M=f[U+(T*36|0)+4>>2]|0;if((M|0)>0){N=U+(T*36|0)+12|0;O=U+(T*36|0)+20|0;P=U+(T*36|0)+24|0;Q=U+(T*36|0)+28|0;L=0;o=W+16|0;w=E;x=F;s=G;v=H;while(1){J=f[N>>2]|0;j=f[J+(L<<2)>>2]|0;I=f[c+16>>2]|0;L=L+1|0;J=f[J+(((L|0)==(M|0)?0:L)<<2)>>2]|0;X=+n[I+(j<<4)>>2];Y=X-+n[I+(J<<4)>>2];y=+n[I+(j<<4)+4>>2];Z=y-+n[I+(J<<4)+4>>2];z=+n[I+(j<<4)+8>>2];F=z-+n[I+(J<<4)+8>>2];A=Y*w+Z*x+F*s;E=Y*v+Z*t+F*r;F=Y*q+Z*p+F*k;Z=+n[O>>2];Y=+n[P>>2];K=+n[Q>>2];G=w*Z+x*Y+s*K;H=v*Z+t*Y+r*K;K=q*Z+p*Y+k*K;z=(X*w+y*x+z*s+ +n[d+48>>2])*-(E*K-F*H)+(X*v+y*t+z*r+ +n[d+52>>2])*-(F*G-A*K)+(X*q+y*p+z*k+ +n[d+56>>2])*-(A*H-E*G);J=e;I=o;j=f[J+4>>2]|0;if((j|0)>=2){m=f[J+12>>2]|0;q=+n[m+(j+-1<<4)>>2];s=+n[m+(j+-1<<4)+4>>2];t=+n[m+(j+-1<<4)+8>>2];l=0;p=q*-(E*K-F*H)+s*-(F*G-A*K)+t*-(A*H-E*G)-z;while(1){w=+n[m+(l<<4)>>2];x=+n[m+(l<<4)+4>>2];y=+n[m+(l<<4)+8>>2];k=+n[m+(l<<4)+12>>2];v=w*-(E*K-F*H)+x*-(F*G-A*K)+y*-(A*H-E*G)-z;do if(p<0.0)if(v<0.0){B=f[I+4>>2]|0;if((B|0)!=(f[I+8>>2]|0)){r=w;q=x;p=y;C=75;break}D=B|0?B<<1:1;if((B|0)>=(D|0)){r=w;q=x;p=y;C=75;break}if(!D)m=0;else{f[6472]=(f[6472]|0)+1;m=sc((D<<4|3)+16|0)|0;if(!m)m=0;else{f[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}B=f[I+4>>2]|0}if((B|0)>0){C=0;do{_=m+(C<<4)|0;$=(f[I+12>>2]|0)+(C<<4)|0;f[_>>2]=f[$>>2];f[_+4>>2]=f[$+4>>2];f[_+8>>2]=f[$+8>>2];f[_+12>>2]=f[$+12>>2];C=C+1|0}while((C|0)!=(B|0))}B=f[I+12>>2]|0;if(B|0){if(b[I+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[B+-4>>2]|0)}f[I+12>>2]=0}b[I+16>>0]=1;f[I+12>>2]=m;f[I+8>>2]=D;B=f[I+4>>2]|0;r=w;q=x;p=y;C=75;break}else{p=p/(p-v);r=q+(w-q)*p;q=s+(x-s)*p;p=t+(y-t)*p;B=f[I+4>>2]|0;if((B|0)!=(f[I+8>>2]|0)){k=0.0;C=75;break}D=B|0?B<<1:1;if((B|0)>=(D|0)){k=0.0;C=75;break}if(!D)m=0;else{f[6472]=(f[6472]|0)+1;m=sc((D<<4|3)+16|0)|0;if(!m)m=0;else{f[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}B=f[I+4>>2]|0}if((B|0)>0){C=0;do{$=m+(C<<4)|0;_=(f[I+12>>2]|0)+(C<<4)|0;f[$>>2]=f[_>>2];f[$+4>>2]=f[_+4>>2];f[$+8>>2]=f[_+8>>2];f[$+12>>2]=f[_+12>>2];C=C+1|0}while((C|0)!=(B|0))}B=f[I+12>>2]|0;if(B|0){if(b[I+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[B+-4>>2]|0)}f[I+12>>2]=0}b[I+16>>0]=1;f[I+12>>2]=m;f[I+8>>2]=D;B=f[I+4>>2]|0;k=0.0;C=75;break}else if(v<0.0){p=p/(p-v);r=q+(w-q)*p;q=s+(x-s)*p;p=t+(y-t)*p;B=f[I+4>>2]|0;if((B|0)==(f[I+8>>2]|0)?(R=B|0?B<<1:1,(B|0)<(R|0)):0){if(!R)m=0;else{f[6472]=(f[6472]|0)+1;m=sc((R<<4|3)+16|0)|0;if(!m)m=0;else{f[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}B=f[I+4>>2]|0}if((B|0)>0){C=0;do{$=m+(C<<4)|0;_=(f[I+12>>2]|0)+(C<<4)|0;f[$>>2]=f[_>>2];f[$+4>>2]=f[_+4>>2];f[$+8>>2]=f[_+8>>2];f[$+12>>2]=f[_+12>>2];C=C+1|0}while((C|0)!=(B|0))}B=f[I+12>>2]|0;if(B|0){if(b[I+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[B+-4>>2]|0)}f[I+12>>2]=0}b[I+16>>0]=1;f[I+12>>2]=m;f[I+8>>2]=R;m=f[I+4>>2]|0}else m=B;B=f[I+12>>2]|0;n[B+(m<<4)>>2]=r;n[B+(m<<4)+4>>2]=q;n[B+(m<<4)+8>>2]=p;n[B+(m<<4)+12>>2]=0.0;B=(f[I+4>>2]|0)+1|0;f[I+4>>2]=B;if((B|0)==(f[I+8>>2]|0)?(S=B|0?B<<1:1,(B|0)<(S|0)):0){if(!S)m=0;else{f[6472]=(f[6472]|0)+1;m=sc((S<<4|3)+16|0)|0;if(!m)m=0;else{f[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}B=f[I+4>>2]|0}if((B|0)>0){C=0;do{$=m+(C<<4)|0;_=(f[I+12>>2]|0)+(C<<4)|0;f[$>>2]=f[_>>2];f[$+4>>2]=f[_+4>>2];f[$+8>>2]=f[_+8>>2];f[$+12>>2]=f[_+12>>2];C=C+1|0}while((C|0)!=(B|0))}B=f[I+12>>2]|0;if(B|0){if(b[I+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[B+-4>>2]|0)}f[I+12>>2]=0}b[I+16>>0]=1;f[I+12>>2]=m;f[I+8>>2]=S;B=f[I+4>>2]|0;r=w;q=x;p=y;C=75}else{r=w;q=x;p=y;C=75}}while(0);if((C|0)==75){C=0;$=f[I+12>>2]|0;n[$+(B<<4)>>2]=r;n[$+(B<<4)+4>>2]=q;n[$+(B<<4)+8>>2]=p;n[$+(B<<4)+12>>2]=k;f[I+4>>2]=(f[I+4>>2]|0)+1}l=l+1|0;if((l|0)==(j|0))break;p=v;q=w;t=y;s=x;m=f[J+12>>2]|0}j=f[J+4>>2]|0}if((j|0)<0){if((f[J+8>>2]|0)<0){l=f[J+12>>2]|0;if(l|0){if(b[J+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}f[J+12>>2]=0}b[J+16>>0]=1;f[J+12>>2]=0;f[J+8>>2]=0}do{$=(f[J+12>>2]|0)+(j<<4)|0;f[$>>2]=f[W>>2];f[$+4>>2]=f[W+4>>2];f[$+8>>2]=f[W+8>>2];f[$+12>>2]=f[W+12>>2];j=j+1|0}while((j|0)!=0)}f[J+4>>2]=0;w=+n[d>>2];x=+n[d+4>>2];s=+n[d+8>>2];v=+n[d+16>>2];t=+n[d+20>>2];r=+n[d+24>>2];q=+n[d+32>>2];p=+n[d+36>>2];k=+n[d+40>>2];if((L|0)>=(M|0)){m=O;l=P;j=Q;C=d+48|0;D=d+52|0;B=d+56|0;break}else{$=e;e=o;o=$}}}else{m=U+(T*36|0)+20|0;l=U+(T*36|0)+24|0;j=U+(T*36|0)+28|0;C=d+48|0;D=d+52|0;B=d+56|0;o=e;w=E;x=F;s=G;v=H}X=+n[m>>2];Y=+n[l>>2];Z=+n[j>>2];s=X*w+Y*x+Z*s;r=X*v+Y*t+Z*r;q=X*q+Y*p+Z*k;p=+n[U+(T*36|0)+32>>2]-(s*+n[C>>2]+r*+n[D>>2]+q*+n[B>>2]);j=f[o+4>>2]|0;if((j|0)>0){m=0;do{l=f[o+12>>2]|0;k=p+(s*+n[l+(m<<4)>>2]+r*+n[l+(m<<4)+4>>2]+q*+n[l+(m<<4)+8>>2]);k=k<=g?g:k;if(k<=h){j=l+(m<<4)|0;f[W>>2]=f[j>>2];f[W+4>>2]=f[j+4>>2];f[W+8>>2]=f[j+8>>2];f[W+12>>2]=f[j+12>>2];Wb[f[(f[i>>2]|0)+16>>2]&15](i,a,W,k);j=f[o+4>>2]|0}m=m+1|0}while((m|0)<(j|0))}}}j=f[V>>2]|0;if(!j){u=W;return}if(b[W+16+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0)}f[V>>2]=0;u=W;return}function Pc(a,c,d,e,g,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;j=j|0;var k=0.0,l=0.0,m=0.0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0;v=u;u=u+9824|0;Hf(a,c,d,e,i,v+9680|0,j);f[v+9296+364>>2]=0;f[v+9296+128>>2]=0;f[v+9296+128+4>>2]=0;f[v+9296+128+8>>2]=0;f[v+9296+128+12>>2]=0;f[v+9296+376>>2]=2;f[v+9296+368>>2]=0;n[v+9296+144>>2]=0.0;p=-+n[g+4>>2];q=-+n[g+8>>2];n[v+9808>>2]=-+n[g>>2];n[v+9808+4>>2]=p;n[v+9808+8>>2]=q;n[v+9808+12>>2]=0.0;switch(Jc(v+9296|0,v+9680|0,v+9808|0)|0){case 1:{f[v+9280>>2]=0;f[v+9280+4>>2]=0;f[v+9280+8>>2]=0;f[v+9280+12>>2]=0;f[v>>2]=9;f[v+9276>>2]=0;f[v+40>>2]=0;f[v+40+4>>2]=0;f[v+40+8>>2]=0;f[v+40+12>>2]=0;f[v+40+16>>2]=0;a=0;do{d=128-a+-1|0;f[v+2108+(d*56|0)+44>>2]=0;e=f[v+9288>>2]|0;f[v+2108+(d*56|0)+48>>2]=e;if(e|0)f[e+44>>2]=v+2108+(d*56|0);f[v+9288>>2]=v+2108+(d*56|0);f[v+9292>>2]=(f[v+9292>>2]|0)+1;a=a+1|0}while((a|0)!=128);m=+n[g>>2];p=+n[g+4>>2];l=+n[g+8>>2];s=f[v+9296+372>>2]|0;do if((f[s+32>>2]|0)>>>0>1?Zc(v+9296|0)|0:0){a=f[v+9280>>2]|0;if(a|0){g=f[v+9284>>2]|0;o=f[v+9292>>2]|0;do{d=a+44|0;j=a+48|0;e=f[j>>2]|0;if(e|0)f[e+44>>2]=f[d>>2];d=f[d>>2]|0;if(d|0)f[d+48>>2]=f[j>>2];if((f[v+9280>>2]|0)==(a|0))f[v+9280>>2]=f[j>>2];g=g+-1|0;f[a+44>>2]=0;f[j>>2]=f[v+9288>>2];d=f[v+9288>>2]|0;if(d|0)f[d+44>>2]=a;f[v+9288>>2]=a;o=o+1|0;a=f[v+9280>>2]|0}while((a|0)!=0);f[v+9284>>2]=g;f[v+9292>>2]=o}f[v>>2]=0;f[v+9276>>2]=0;a=f[s>>2]|0;d=f[s+12>>2]|0;q=+n[d+16>>2];C=+n[a+16>>2]-q;A=+n[d+20>>2];z=+n[a+20>>2]-A;x=+n[d+24>>2];w=+n[a+24>>2]-x;d=f[s+4>>2]|0;y=+n[d+16>>2]-q;k=+n[d+20>>2]-A;B=+n[d+24>>2]-x;e=f[s+8>>2]|0;q=+n[e+16>>2]-q;A=+n[e+20>>2]-A;x=+n[e+24>>2]-x;if(C*k*x+(z*B*q+w*y*A-C*B*A-z*y*x)-w*k*q<0.0){f[s>>2]=d;f[s+4>>2]=a;j=f[s+16>>2]|0;f[s+16>>2]=f[s+20>>2];f[s+20>>2]=j;j=d}else{j=a;a=d}j=of(v,j,a,e,1)|0;g=of(v,f[s+4>>2]|0,f[s>>2]|0,f[s+12>>2]|0,1)|0;o=of(v,f[s+8>>2]|0,f[s+4>>2]|0,f[s+12>>2]|0,1)|0;r=of(v,f[s>>2]|0,f[s+8>>2]|0,f[s+12>>2]|0,1)|0;if((f[v+9284>>2]|0)==4){d=f[v+9280>>2]|0;k=+n[d+16>>2];a=f[d+48>>2]|0;if(!a)a=d;else{l=k*k;while(1){k=+n[a+16>>2];e=k*k<l;d=e?a:d;a=f[a+48>>2]|0;if(!a)break;else l=e?k*k:l}a=d;k=+n[d+16>>2]}m=+n[a>>2];q=+n[a+4>>2];p=+n[a+8>>2];l=+n[a+12>>2];D=f[a+20>>2]|0;d=f[a+24>>2]|0;e=f[a+28>>2]|0;b[j+52>>0]=0;f[j+32>>2]=g;b[g+52>>0]=0;f[g+32>>2]=j;b[j+53>>0]=0;f[j+36>>2]=o;b[o+52>>0]=1;f[o+32>>2]=j;b[j+54>>0]=0;f[j+40>>2]=r;b[r+52>>0]=2;f[r+32>>2]=j;b[g+53>>0]=2;f[g+36>>2]=r;b[r+54>>0]=1;f[r+40>>2]=g;b[g+54>>0]=1;f[g+40>>2]=o;b[o+53>>0]=2;f[o+36>>2]=g;b[o+54>>0]=1;f[o+40>>2]=r;b[r+53>>0]=2;f[r+36>>2]=o;f[v>>2]=0;r=a;s=0;g=D;o=d;j=e;while(1){d=f[v+9276>>2]|0;if(d>>>0>=64){t=44;break}f[v+9808>>2]=0;f[v+9808+4>>2]=0;f[v+9808+8>>2]=0;f[v+9276>>2]=d+1;s=s+1|0;b[r+55>>0]=s;e=r+4|0;D=r+8|0;Gh(v+9296|0,+n[r>>2],+n[e>>2],+n[D>>2],v+60+(d<<5)|0);if(+n[r>>2]*+n[v+60+(d<<5)+16>>2]+ +n[e>>2]*+n[v+60+(d<<5)+20>>2]+ +n[D>>2]*+n[v+60+(d<<5)+24>>2]-+n[r+16>>2]>9.999999747378752e-05)a=0;else{a=7;t=43;break}do{e=ph(v,s,v+60+(d<<5)|0,f[r+32+(a<<2)>>2]|0,h[r+52+a>>0]|0,v+9808|0)|0;a=a+1|0}while(e&a>>>0<3);if(!(e&(f[v+9808+8>>2]|0)>>>0>2)){a=4;t=43;break}e=f[v+9808>>2]|0;a=f[v+9808+4>>2]|0;b[e+53>>0]=2;f[e+36>>2]=a;b[a+54>>0]=1;f[a+40>>2]=e;a=r+44|0;e=r+48|0;d=f[e>>2]|0;if(d|0)f[d+44>>2]=f[a>>2];a=f[a>>2]|0;if(a|0)f[a+48>>2]=f[e>>2];if((f[v+9280>>2]|0)==(r|0))f[v+9280>>2]=f[e>>2];f[v+9284>>2]=(f[v+9284>>2]|0)+-1;f[r+44>>2]=0;f[e>>2]=f[v+9288>>2];a=f[v+9288>>2]|0;if(a|0)f[a+44>>2]=r;f[v+9288>>2]=r;f[v+9292>>2]=(f[v+9292>>2]|0)+1;d=f[v+9280>>2]|0;k=+n[d+16>>2];a=f[d+48>>2]|0;if(a){l=k*k;e=d;while(1){k=+n[a+16>>2];d=k*k<l;e=d?a:e;a=f[a+48>>2]|0;if(!a)break;else l=d?k*k:l}d=e;k=+n[e+16>>2]}m=+n[d>>2];q=+n[d+4>>2];p=+n[d+8>>2];l=+n[d+12>>2];a=f[d+20>>2]|0;e=f[d+24>>2]|0;j=f[d+28>>2]|0;if(s>>>0>=255){d=j;break}else{r=d;g=a;o=e}}if((t|0)==43){f[v>>2]=a;a=g;e=o;d=j}else if((t|0)==44){f[v>>2]=6;a=g;e=o;d=j}y=m*k;w=q*k;A=p*k;n[v+40>>2]=m;n[v+44>>2]=q;n[v+48>>2]=p;n[v+52>>2]=l;n[v+56>>2]=k;f[v+36>>2]=3;f[v+4>>2]=a;f[v+8>>2]=e;f[v+12>>2]=d;D=e;B=+n[D+16>>2]-y;p=+n[D+20>>2]-w;m=+n[D+24>>2]-A;s=d;z=+n[s+16>>2]-y;q=+n[s+20>>2]-w;x=+n[s+24>>2]-A;B=+L(+((B*q-p*z)*(B*q-p*z)+((p*x-m*q)*(p*x-m*q)+(m*z-B*x)*(m*z-B*x))));n[v+20>>2]=B;z=+n[s+16>>2]-y;m=+n[s+20>>2]-w;s=a;q=+n[s+16>>2]-y;p=+n[s+20>>2]-w;C=+n[s+24>>2]-A;C=+L(+((z*p-m*q)*(z*p-m*q)+((m*C-x*p)*(m*C-x*p)+(x*q-z*C)*(x*q-z*C))));n[v+24>>2]=C;z=+n[s+16>>2]-y;q=+n[s+20>>2]-w;x=+n[s+24>>2]-A;y=+n[D+16>>2]-y;w=+n[D+20>>2]-w;A=+n[D+24>>2]-A;A=+L(+((z*w-q*y)*(z*w-q*y)+((q*A-x*w)*(q*A-x*w)+(x*y-z*A)*(x*y-z*A))));n[v+20>>2]=B/(A+(B+C));n[v+24>>2]=C/(A+(B+C));n[v+28>>2]=A/(A+(B+C));if((f[v>>2]|0)!=9)if(!(f[v+36>>2]|0)){m=0.0;l=0.0;k=0.0;break}else{o=v+36|0;t=53;break}f[i>>2]=3;D=0;u=v;return D|0}else t=47}else t=47;while(0);if((t|0)==47){f[v>>2]=8;n[v+40>>2]=m;n[v+44>>2]=p;n[v+48>>2]=l;n[v+52>>2]=0.0;k=+L(+(m*m+p*p+l*l));if(k>0.0){n[v+40>>2]=1.0/k*m;n[v+44>>2]=1.0/k*p;n[v+48>>2]=1.0/k*l}else{f[v+40>>2]=1065353216;f[v+44>>2]=0;f[v+48>>2]=0}n[v+52>>2]=0.0;n[v+56>>2]=0.0;f[v+36>>2]=1;f[v+4>>2]=f[s>>2];n[v+20>>2]=1.0;o=v+36|0;t=53}if((t|0)==53){e=f[v+9680+120>>2]|0;j=f[v+9680+124>>2]|0;g=(f[v+9680>>2]|0)+(j>>1)|0;d=0;k=0.0;l=0.0;m=0.0;do{if(!(j&1))a=e;else a=f[(f[g>>2]|0)+e>>2]|0;Vb[a&127](v+9808|0,g,f[v+4+(d<<2)>>2]|0);C=+n[v+20+(d<<2)>>2];k=k+ +n[v+9808>>2]*C;l=l+C*+n[v+9808+4>>2];m=m+C*+n[v+9808+8>>2];d=d+1|0}while(d>>>0<(f[o>>2]|0)>>>0)}f[i>>2]=1;C=k*+n[c+16>>2]+l*+n[c+20>>2]+m*+n[c+24>>2]+ +n[c+52>>2];z=k*+n[c+32>>2]+l*+n[c+36>>2]+m*+n[c+40>>2]+ +n[c+56>>2];n[i+4>>2]=k*+n[c>>2]+l*+n[c+4>>2]+m*+n[c+8>>2]+ +n[c+48>>2];n[i+8>>2]=C;n[i+12>>2]=z;n[i+16>>2]=0.0;z=+n[v+40>>2];C=+n[v+56>>2];A=+n[v+44>>2];B=+n[v+48>>2];p=k-z*C;q=l-C*A;w=m-C*B;x=p*+n[c+16>>2]+q*+n[c+20>>2]+w*+n[c+24>>2]+ +n[c+52>>2];y=p*+n[c+32>>2]+q*+n[c+36>>2]+w*+n[c+40>>2]+ +n[c+56>>2];n[i+20>>2]=p*+n[c>>2]+q*+n[c+4>>2]+w*+n[c+8>>2]+ +n[c+48>>2];n[i+24>>2]=x;n[i+28>>2]=y;n[i+32>>2]=0.0;n[i+36>>2]=-z;n[i+40>>2]=-A;n[i+44>>2]=-B;n[i+48>>2]=0.0;n[i+52>>2]=-C;D=1;u=v;return D|0}case 2:{f[i>>2]=2;D=0;u=v;return D|0}default:{D=0;u=v;return D|0}}return 0}function Qc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;f[a+168>>2]=f[a+152>>2];f[c>>2]=9204;f[c+52>>2]=282;b[c+60>>0]=0;b[c+80>>0]=1;f[c+76>>2]=0;f[c+68>>2]=0;f[c+72>>2]=0;b[c+100>>0]=1;f[c+96>>2]=0;f[c+88>>2]=0;f[c+92>>2]=0;b[c+120>>0]=1;f[c+116>>2]=0;f[c+108>>2]=0;f[c+112>>2]=0;b[c+140>>0]=1;f[c+136>>2]=0;f[c+128>>2]=0;f[c+132>>2]=0;f[c+144>>2]=0;b[c+164>>0]=1;f[c+160>>2]=0;f[c+152>>2]=0;f[c+156>>2]=0;f[c+168>>2]=0;f[c+4>>2]=-8388609;f[c+8>>2]=-8388609;f[c+12>>2]=-8388609;n[c+16>>2]=0.0;f[c+20>>2]=2139095039;f[c+24>>2]=2139095039;f[c+28>>2]=2139095039;n[c+32>>2]=0.0;e=f[a+56>>2]|0;if(g){e=XA(e|0)|0;f[c+56>>2]=e;b[c+4>>0]=b[a+4+3>>0]|0;b[c+5>>0]=b[a+4+2>>0]|0;b[c+6>>0]=b[a+4+1>>0]|0;b[c+7>>0]=b[a+4>>0]|0;b[c+8>>0]=b[a+8+3>>0]|0;b[c+9>>0]=b[a+8+2>>0]|0;b[c+10>>0]=b[a+8+1>>0]|0;b[c+11>>0]=b[a+8>>0]|0;b[c+12>>0]=b[a+12+3>>0]|0;b[c+13>>0]=b[a+12+2>>0]|0;b[c+14>>0]=b[a+12+1>>0]|0;b[c+15>>0]=b[a+12>>0]|0;b[c+16>>0]=b[a+16+3>>0]|0;b[c+17>>0]=b[a+16+2>>0]|0;b[c+18>>0]=b[a+16+1>>0]|0;b[c+19>>0]=b[a+16>>0]|0;b[c+20>>0]=b[a+20+3>>0]|0;b[c+21>>0]=b[a+20+2>>0]|0;b[c+22>>0]=b[a+20+1>>0]|0;b[c+23>>0]=b[a+20>>0]|0;b[c+24>>0]=b[a+24+3>>0]|0;b[c+25>>0]=b[a+24+2>>0]|0;b[c+26>>0]=b[a+24+1>>0]|0;b[c+27>>0]=b[a+24>>0]|0;b[c+28>>0]=b[a+28+3>>0]|0;b[c+29>>0]=b[a+28+2>>0]|0;b[c+30>>0]=b[a+28+1>>0]|0;b[c+31>>0]=b[a+28>>0]|0;b[c+32>>0]=b[a+32+3>>0]|0;b[c+33>>0]=b[a+32+2>>0]|0;b[c+34>>0]=b[a+32+1>>0]|0;b[c+35>>0]=b[a+32>>0]|0;b[c+36>>0]=b[a+36+3>>0]|0;b[c+37>>0]=b[a+36+2>>0]|0;b[c+38>>0]=b[a+36+1>>0]|0;b[c+39>>0]=b[a+36>>0]|0;b[c+40>>0]=b[a+40+3>>0]|0;b[c+41>>0]=b[a+40+2>>0]|0;b[c+42>>0]=b[a+40+1>>0]|0;b[c+43>>0]=b[a+40>>0]|0;b[c+44>>0]=b[a+44+3>>0]|0;b[c+45>>0]=b[a+44+2>>0]|0;b[c+46>>0]=b[a+44+1>>0]|0;b[c+47>>0]=b[a+44>>0]|0;b[c+48>>0]=b[a+48+3>>0]|0;b[c+49>>0]=b[a+48+2>>0]|0;b[c+50>>0]=b[a+48+1>>0]|0;b[c+51>>0]=b[a+48>>0]|0;e=XA(f[a+144>>2]|0)|0;f[c+144>>2]=e;e=XA(f[a+168>>2]|0)|0}else{f[c+56>>2]=e;f[c+4>>2]=f[a+4>>2];f[c+4+4>>2]=f[a+4+4>>2];f[c+4+8>>2]=f[a+4+8>>2];f[c+4+12>>2]=f[a+4+12>>2];f[c+20>>2]=f[a+20>>2];f[c+20+4>>2]=f[a+20+4>>2];f[c+20+8>>2]=f[a+20+8>>2];f[c+20+12>>2]=f[a+20+12>>2];f[c+36>>2]=f[a+36>>2];f[c+36+4>>2]=f[a+36+4>>2];f[c+36+8>>2]=f[a+36+8>>2];f[c+36+12>>2]=f[a+36+12>>2];f[c+144>>2]=f[a+144>>2];e=f[a+168>>2]|0}f[c+168>>2]=e;b[c+60>>0]=b[a+60>>0]|0;j=f[a+56>>2]|0;if(!(b[a+60>>0]|0)){e=f[c+96>>2]|0;if(e|0){if(b[c+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[c+96>>2]=0}b[c+100>>0]=0;f[c+96>>2]=c+172;f[c+88>>2]=j;f[c+92>>2]=j;if(g)if((j|0)>0){h=0;i=f[a+96>>2]|0;e=c+172|0;do{k=i+(h<<6)|0;m=e+(h<<6)|0;b[m>>0]=b[k+3>>0]|0;b[m+1>>0]=b[k+2>>0]|0;b[m+2>>0]=b[k+1>>0]|0;b[m+3>>0]=b[k>>0]|0;m=i+(h<<6)+4|0;k=e+(h<<6)+4|0;b[k>>0]=b[m+3>>0]|0;b[k+1>>0]=b[m+2>>0]|0;b[k+2>>0]=b[m+1>>0]|0;b[k+3>>0]=b[m>>0]|0;k=i+(h<<6)+8|0;m=e+(h<<6)+8|0;b[m>>0]=b[k+3>>0]|0;b[m+1>>0]=b[k+2>>0]|0;b[m+2>>0]=b[k+1>>0]|0;b[m+3>>0]=b[k>>0]|0;m=i+(h<<6)+12|0;e=e+(h<<6)+12|0;b[e>>0]=b[m+3>>0]|0;b[e+1>>0]=b[m+2>>0]|0;b[e+2>>0]=b[m+1>>0]|0;b[e+3>>0]=b[m>>0]|0;e=f[a+96>>2]|0;m=e+(h<<6)+16|0;k=f[c+96>>2]|0;l=k+(h<<6)+16|0;b[l>>0]=b[m+3>>0]|0;b[l+1>>0]=b[m+2>>0]|0;b[l+2>>0]=b[m+1>>0]|0;b[l+3>>0]=b[m>>0]|0;l=e+(h<<6)+20|0;m=k+(h<<6)+20|0;b[m>>0]=b[l+3>>0]|0;b[m+1>>0]=b[l+2>>0]|0;b[m+2>>0]=b[l+1>>0]|0;b[m+3>>0]=b[l>>0]|0;m=e+(h<<6)+24|0;l=k+(h<<6)+24|0;b[l>>0]=b[m+3>>0]|0;b[l+1>>0]=b[m+2>>0]|0;b[l+2>>0]=b[m+1>>0]|0;b[l+3>>0]=b[m>>0]|0;e=e+(h<<6)+28|0;k=k+(h<<6)+28|0;b[k>>0]=b[e+3>>0]|0;b[k+1>>0]=b[e+2>>0]|0;b[k+2>>0]=b[e+1>>0]|0;b[k+3>>0]=b[e>>0]|0;i=f[a+96>>2]|0;k=XA(f[i+(h<<6)+32>>2]|0)|0;e=f[c+96>>2]|0;f[e+(h<<6)+32>>2]=k;k=XA(f[i+(h<<6)+36>>2]|0)|0;f[e+(h<<6)+36>>2]=k;k=XA(f[i+(h<<6)+40>>2]|0)|0;f[e+(h<<6)+40>>2]=k;h=h+1|0}while((h|0)!=(j|0))}else e=c+172|0;else if((j|0)>0){h=0;i=f[a+96>>2]|0;e=c+172|0;do{l=i+(h<<6)|0;m=e+(h<<6)|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];m=(f[a+96>>2]|0)+(h<<6)+16|0;e=(f[c+96>>2]|0)+(h<<6)+16|0;f[e>>2]=f[m>>2];f[e+4>>2]=f[m+4>>2];f[e+8>>2]=f[m+8>>2];f[e+12>>2]=f[m+12>>2];i=f[a+96>>2]|0;e=f[c+96>>2]|0;f[e+(h<<6)+32>>2]=f[i+(h<<6)+32>>2];f[e+(h<<6)+36>>2]=f[i+(h<<6)+36>>2];f[e+(h<<6)+40>>2]=f[i+(h<<6)+40>>2];h=h+1|0}while((h|0)!=(j|0))}else e=c+172|0;if(!e){e=j<<6;h=c+92|0;i=c+88|0;j=c+96|0;k=c+100|0}else{if(b[c+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[c+96>>2]=0;e=j<<6;h=c+92|0;i=c+88|0;j=c+96|0;k=c+100|0}}else{e=f[c+136>>2]|0;if(e|0){if(b[c+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[c+136>>2]=0}b[c+140>>0]=0;f[c+136>>2]=c+172;f[c+128>>2]=j;f[c+132>>2]=j;if(g){if((j|0)>0){h=f[a+136>>2]|0;e=0;do{m=IG(d[h+(e<<4)>>1]|0)|0;d[c+172+(e<<4)>>1]=m;m=IG(d[h+(e<<4)+2>>1]|0)|0;d[c+172+(e<<4)+2>>1]=m;m=IG(d[h+(e<<4)+4>>1]|0)|0;d[c+172+(e<<4)+4>>1]=m;m=IG(d[h+(e<<4)+6>>1]|0)|0;d[c+172+(e<<4)+6>>1]=m;m=IG(d[h+(e<<4)+8>>1]|0)|0;d[c+172+(e<<4)+8>>1]=m;m=IG(d[h+(e<<4)+10>>1]|0)|0;d[c+172+(e<<4)+10>>1]=m;m=XA(f[h+(e<<4)+12>>2]|0)|0;f[c+172+(e<<4)+12>>2]=m;e=e+1|0}while((e|0)!=(j|0))}}else if((j|0)>0){h=f[a+136>>2]|0;e=0;do{d[c+172+(e<<4)>>1]=d[h+(e<<4)>>1]|0;d[c+172+(e<<4)+2>>1]=d[h+(e<<4)+2>>1]|0;d[c+172+(e<<4)+4>>1]=d[h+(e<<4)+4>>1]|0;d[c+172+(e<<4)+6>>1]=d[h+(e<<4)+6>>1]|0;d[c+172+(e<<4)+8>>1]=d[h+(e<<4)+8>>1]|0;d[c+172+(e<<4)+10>>1]=d[h+(e<<4)+10>>1]|0;f[c+172+(e<<4)+12>>2]=f[h+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(j|0))}e=f[c+136>>2]|0;if(!e){e=j<<4;h=c+132|0;i=c+128|0;j=c+136|0;k=c+140|0}else{if(b[c+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[c+136>>2]=0;e=j<<4;h=c+132|0;i=c+128|0;j=c+136|0;k=c+140|0}}b[k>>0]=0;f[j>>2]=0;f[i>>2]=0;f[h>>2]=0;j=c+172+e|0;e=f[a+168>>2]|0;h=f[c+160>>2]|0;if(h|0){if(b[c+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[c+160>>2]=0}b[c+164>>0]=0;f[c+160>>2]=j;f[c+152>>2]=e;f[c+156>>2]=e;i=f[a+168>>2]|0;if(g){if((i|0)>0){h=f[a+160>>2]|0;e=0;do{m=IG(d[h+(e<<5)>>1]|0)|0;d[j+(e<<5)>>1]=m;m=IG(d[h+(e<<5)+2>>1]|0)|0;d[j+(e<<5)+2>>1]=m;m=IG(d[h+(e<<5)+4>>1]|0)|0;d[j+(e<<5)+4>>1]=m;m=IG(d[h+(e<<5)+6>>1]|0)|0;d[j+(e<<5)+6>>1]=m;m=IG(d[h+(e<<5)+8>>1]|0)|0;d[j+(e<<5)+8>>1]=m;m=IG(d[h+(e<<5)+10>>1]|0)|0;d[j+(e<<5)+10>>1]=m;m=XA(f[h+(e<<5)+12>>2]|0)|0;f[j+(e<<5)+12>>2]=m;m=XA(f[h+(e<<5)+16>>2]|0)|0;f[j+(e<<5)+16>>2]=m;e=e+1|0}while((e|0)!=(i|0))}}else if((i|0)>0){h=f[a+160>>2]|0;e=0;do{d[j+(e<<5)>>1]=d[h+(e<<5)>>1]|0;d[j+(e<<5)+2>>1]=d[h+(e<<5)+2>>1]|0;d[j+(e<<5)+4>>1]=d[h+(e<<5)+4>>1]|0;d[j+(e<<5)+6>>1]=d[h+(e<<5)+6>>1]|0;d[j+(e<<5)+8>>1]=d[h+(e<<5)+8>>1]|0;d[j+(e<<5)+10>>1]=d[h+(e<<5)+10>>1]|0;f[j+(e<<5)+12>>2]=f[h+(e<<5)+12>>2];f[j+(e<<5)+16>>2]=f[h+(e<<5)+16>>2];f[j+(e<<5)+20>>2]=0;f[j+(e<<5)+24>>2]=0;f[j+(e<<5)+28>>2]=0;e=e+1|0}while((e|0)<(f[a+168>>2]|0))}e=f[c+160>>2]|0;if(!e){f[c>>2]=0;f[c+152>>2]=0;f[c+152+4>>2]=0;f[c+152+8>>2]=0;b[c+152+12>>0]=0;return 1}if(b[c+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[c+160>>2]=0;f[c>>2]=0;f[c+152>>2]=0;f[c+152+4>>2]=0;f[c+152+8>>2]=0;b[c+152+12>>0]=0;return 1}function Rc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,M=0,P=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0;I=u;u=u+64|0;if(!(f[a+12>>2]|0)){u=I;return}e=(b[a+16>>0]|0)!=0;P=e?d:c;e=e?c:d;h=f[P+4>>2]|0;H=f[e+4>>2]|0;P=f[P+12>>2]|0;aa=+n[P>>2];$=+n[P+16>>2];_=+n[P+32>>2];Z=+n[P+4>>2];Y=+n[P+20>>2];l=+n[P+36>>2];i=+n[P+8>>2];p=+n[P+24>>2];x=+n[P+40>>2];T=+n[P+48>>2];S=+n[P+52>>2];R=+n[P+56>>2];M=f[e+12>>2]|0;X=+n[M>>2];W=+n[M+16>>2];m=+n[M+32>>2];V=+n[M+4>>2];U=+n[M+20>>2];o=+n[M+36>>2];w=+n[M+8>>2];t=+n[M+24>>2];r=+n[M+40>>2];Q=-+n[M+48>>2];D=-+n[M+52>>2];E=-+n[M+56>>2];F=+n[P>>2];G=+n[P+16>>2];C=+n[P+32>>2];A=+n[P+4>>2];z=+n[P+20>>2];y=+n[P+36>>2];v=+n[P+8>>2];s=+n[P+24>>2];q=+n[P+40>>2];P=f[(f[h>>2]|0)+64>>2]|0;k=-+n[H+48>>2];j=-+n[H+52>>2];B=-+n[H+56>>2];n[I+48>>2]=(aa*X+$*W+_*m)*k+(aa*V+$*U+_*o)*j+(aa*w+$*t+_*r)*B;n[I+48+4>>2]=(Z*X+Y*W+l*m)*k+(Z*V+Y*U+l*o)*j+(Z*w+Y*t+l*r)*B;n[I+48+8>>2]=(i*X+p*W+x*m)*k+(i*V+p*U+x*o)*j+(i*w+p*t+x*r)*B;n[I+48+12>>2]=0.0;Vb[P&127](I,h,I+48|0);B=+n[I>>2];x=+n[I+4>>2];p=+n[I+8>>2];i=+n[H+48>>2];j=+n[H+52>>2];k=+n[H+56>>2];l=k*(T*w+S*t+R*r+(w*Q+t*D+r*E)+((w*F+t*G+r*C)*B+(w*A+t*z+r*y)*x+(w*v+t*s+r*q)*p))+(i*(T*X+S*W+R*m+(X*Q+W*D+m*E)+((X*F+W*G+m*C)*B+(X*A+W*z+m*y)*x+(X*v+W*s+m*q)*p))+j*(T*V+S*U+R*o+(V*Q+U*D+o*E)+((V*F+U*G+o*C)*B+(V*A+U*z+o*y)*x+(V*v+U*s+o*q)*p)))-+n[H+64>>2];m=T*X+S*W+R*m+(X*Q+W*D+m*E)+((X*F+W*G+m*C)*B+(X*A+W*z+m*y)*x+(X*v+W*s+m*q)*p)-i*l;o=T*V+S*U+R*o+(V*Q+U*D+o*E)+((V*F+U*G+o*C)*B+(V*A+U*z+o*y)*x+(V*v+U*s+o*q)*p)-j*l;p=T*w+S*t+R*r+(w*Q+t*D+r*E)+((w*F+t*G+r*C)*B+(w*A+t*z+r*y)*x+(w*v+t*s+r*q)*p)-k*l;P=f[e+12>>2]|0;q=+n[P>>2];r=+n[P+4>>2];s=+n[P+8>>2];t=+n[P+16>>2];v=+n[P+20>>2];w=+n[P+24>>2];x=+n[P+32>>2];y=+n[P+36>>2];z=+n[P+40>>2];A=+n[P+48>>2];B=+n[P+52>>2];C=+n[P+56>>2];P=f[a+12>>2]|0;M=l<+n[P+752>>2];f[g+4>>2]=P;if(M){P=f[e+12>>2]|0;$=i*+n[P+16>>2]+j*+n[P+20>>2]+k*+n[P+24>>2];aa=i*+n[P+32>>2]+j*+n[P+36>>2]+k*+n[P+40>>2];n[I+48>>2]=+n[P>>2]*i+ +n[P+4>>2]*j+ +n[P+8>>2]*k;n[I+48+4>>2]=$;n[I+48+8>>2]=aa;n[I+48+12>>2]=0.0;n[I+32>>2]=s*p+(q*m+r*o)+A;n[I+32+4>>2]=m*t+o*v+p*w+B;n[I+32+8>>2]=m*x+o*y+p*z+C;n[I+32+12>>2]=0.0;Wb[f[(f[g>>2]|0)+16>>2]&15](g,I+48|0,I+32|0,l)}if((f[h+4>>2]|0)<7?(f[(f[g+4>>2]|0)+748>>2]|0)<(f[a+24>>2]|0):0){i=+n[H+56>>2];if(+K(+i)>.7071067690849304){k=+n[H+52>>2];aa=1.0/+L(+(i*i+k*k));j=0.0;k=k*aa;i=-(i*aa)}else{aa=+n[H+48>>2];j=+n[H+52>>2];i=1.0/+L(+(aa*aa+j*j));j=-(j*i);k=0.0;i=aa*i}E=.019999999552965164/+rb[f[(f[h>>2]|0)+16>>2]&15](h);E=(E>.39269909262657166?.39269909262657166:E)*.5;D=+O(+E)/+L(+(j*j+i*i+k*k));G=j*D;F=i*D;D=k*D;E=+N(+E);e=f[a+20>>2]|0;if((e|0)>0){h=0;do{t=+n[H+48>>2];aa=+n[H+52>>2];A=+n[H+56>>2];y=6.2831854820251465/+(e|0)*+(h|0)*.5;$=+O(+y)/+L(+(t*t+aa*aa+A*A));y=+N(+y);z=D*-(aa*$)+(G*y+E*-(t*$))-F*-(A*$);w=G*-(A*$)+(F*y+E*-(aa*$))-D*-(t*$);da=F*-(t*$)+(D*y+E*-(A*$))-G*-(aa*$);C=E*y-G*-(t*$)-F*-(aa*$)-D*-(A*$);ia=A*$*w+(t*$*C+y*z)-aa*$*da;ha=t*$*da+(y*w+aa*$*C)-A*$*z;la=aa*$*z+(A*$*C+y*da)-t*$*w;da=y*C-t*$*z-aa*$*w-A*$*da;e=(b[a+16>>0]|0)!=0;ba=e?d:c;e=e?c:d;P=f[ba+4>>2]|0;M=f[e+4>>2]|0;ba=f[ba+12>>2]|0;$=+n[ba>>2];A=+n[ba+4>>2];w=+n[ba+8>>2];aa=+n[ba+16>>2];z=+n[ba+20>>2];t=+n[ba+24>>2];C=+n[ba+32>>2];y=+n[ba+36>>2];r=+n[ba+40>>2];V=+n[ba+48>>2];W=+n[ba+52>>2];X=+n[ba+56>>2];ba=f[e+12>>2]|0;R=+n[ba>>2];S=+n[ba+16>>2];m=+n[ba+32>>2];T=+n[ba+4>>2];U=+n[ba+20>>2];o=+n[ba+36>>2];v=+n[ba+8>>2];s=+n[ba+24>>2];q=+n[ba+40>>2];Y=-+n[ba+48>>2];Z=-+n[ba+52>>2];_=-+n[ba+56>>2];ga=ia*(2.0/(ia*ia+ha*ha+la*la+da*da));k=ha*(2.0/(ia*ia+ha*ha+la*la+da*da));ca=la*(2.0/(ia*ia+ha*ha+la*la+da*da));na=w*(ia*ca-da*k)+(A*(ia*k+da*ca)+$*(1.0-(ha*k+la*ca)));ka=w*(ha*ca+da*ga)+($*(ia*k-da*ca)+A*(1.0-(ia*ga+la*ca)));i=$*(ia*ca+da*k)+A*(ha*ca-da*ga)+w*(1.0-(ia*ga+ha*k));ma=t*(ia*ca-da*k)+(z*(ia*k+da*ca)+aa*(1.0-(ha*k+la*ca)));ja=t*(ha*ca+da*ga)+(aa*(ia*k-da*ca)+z*(1.0-(ia*ga+la*ca)));x=aa*(ia*ca+da*k)+z*(ha*ca-da*ga)+t*(1.0-(ia*ga+ha*k));oa=r*(ia*ca-da*k)+(y*(ia*k+da*ca)+C*(1.0-(ha*k+la*ca)));la=r*(ha*ca+da*ga)+(C*(ia*k-da*ca)+y*(1.0-(ia*ga+la*ca)));k=C*(ia*ca+da*k)+y*(ha*ca-da*ga)+r*(1.0-(ia*ga+ha*k));ha=+n[ba>>2];ga=+n[ba+16>>2];ia=+n[ba+32>>2];da=+n[ba+4>>2];ca=+n[ba+20>>2];ea=+n[ba+36>>2];j=+n[ba+8>>2];p=+n[ba+24>>2];l=+n[ba+40>>2];ba=f[(f[P>>2]|0)+64>>2]|0;fa=-+n[M+48>>2];Q=-+n[M+52>>2];B=-+n[M+56>>2];n[I+32>>2]=(ia*oa+(ha*na+ga*ma))*fa+(ea*oa+(da*na+ca*ma))*Q+(l*oa+(j*na+p*ma))*B;n[I+32+4>>2]=(ia*la+(ha*ka+ga*ja))*fa+(ea*la+(da*ka+ca*ja))*Q+(l*la+(j*ka+p*ja))*B;n[I+32+8>>2]=(ia*k+(ha*i+ga*x))*fa+(ea*k+(da*i+ca*x))*Q+(l*k+(j*i+p*x))*B;n[I+32+12>>2]=0.0;Vb[ba&127](I+48|0,P,I+32|0);B=+n[I+48>>2];x=+n[I+48+4>>2];p=+n[I+48+8>>2];i=+n[M+48>>2];j=+n[M+52>>2];k=+n[M+56>>2];l=k*(V*v+W*s+X*q+(v*Y+s*Z+q*_)+(($*v+aa*s+C*q)*B+(A*v+z*s+y*q)*x+(w*v+t*s+r*q)*p))+(i*(V*R+W*S+X*m+(R*Y+S*Z+m*_)+(($*R+aa*S+C*m)*B+(A*R+z*S+y*m)*x+(w*R+t*S+r*m)*p))+j*(V*T+W*U+X*o+(T*Y+U*Z+o*_)+(($*T+aa*U+C*o)*B+(A*T+z*U+y*o)*x+(w*T+t*U+r*o)*p)))-+n[M+64>>2];m=V*R+W*S+X*m+(R*Y+S*Z+m*_)+(($*R+aa*S+C*m)*B+(A*R+z*S+y*m)*x+(w*R+t*S+r*m)*p)-i*l;o=V*T+W*U+X*o+(T*Y+U*Z+o*_)+(($*T+aa*U+C*o)*B+(A*T+z*U+y*o)*x+(w*T+t*U+r*o)*p)-j*l;p=V*v+W*s+X*q+(v*Y+s*Z+q*_)+(($*v+aa*s+C*q)*B+(A*v+z*s+y*q)*x+(w*v+t*s+r*q)*p)-k*l;M=f[e+12>>2]|0;q=+n[M>>2];r=+n[M+4>>2];s=+n[M+8>>2];t=+n[M+16>>2];v=+n[M+20>>2];w=+n[M+24>>2];x=+n[M+32>>2];y=+n[M+36>>2];z=+n[M+40>>2];A=+n[M+48>>2];B=+n[M+52>>2];C=+n[M+56>>2];M=f[a+12>>2]|0;P=l<+n[M+752>>2];f[g+4>>2]=M;if(P){ba=f[e+12>>2]|0;na=i*+n[ba+16>>2]+j*+n[ba+20>>2]+k*+n[ba+24>>2];oa=i*+n[ba+32>>2]+j*+n[ba+36>>2]+k*+n[ba+40>>2];n[I+32>>2]=+n[ba>>2]*i+ +n[ba+4>>2]*j+ +n[ba+8>>2]*k;n[I+32+4>>2]=na;n[I+32+8>>2]=oa;n[I+32+12>>2]=0.0;n[I+16>>2]=s*p+(q*m+r*o)+A;n[I+16+4>>2]=m*t+o*v+p*w+B;n[I+16+8>>2]=m*x+o*y+p*z+C;n[I+16+12>>2]=0.0;Wb[f[(f[g>>2]|0)+16>>2]&15](g,I+32|0,I+16|0,l)}h=h+1|0;e=f[a+20>>2]|0}while((h|0)<(e|0))}}do if((b[a+8>>0]|0?f[(f[a+12>>2]|0)+748>>2]|0:0)?(J=f[g+4>>2]|0,f[J+748>>2]|0):0){e=f[J+740>>2]|0;h=f[(f[g+8>>2]|0)+8>>2]|0;if((e|0)==(h|0)){df(J,e+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);break}else{df(J,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,h+4|0);break}}while(0);u=I;return}function Sc(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;C=u;u=u+4224|0;if(((f[d+4>>2]|0)+-17|0)>>>0<2)A=((f[e+4>>2]|0)+-17|0)>>>0<2;else A=0;a=0;do{Te();v=+n[24820+(a<<4)>>2];w=+n[24820+(a<<4)+4>>2];x=+n[24820+(a<<4)+8>>2];z=+n[g+4>>2]*-v+ +n[g+20>>2]*-w+ +n[g+36>>2]*-x;y=+n[g+8>>2]*-v+ +n[g+24>>2]*-w+ +n[g+40>>2]*-x;n[C+1248+(a<<4)>>2]=+n[g>>2]*-v+ +n[g+16>>2]*-w+ +n[g+32>>2]*-x;n[C+1248+(a<<4)+4>>2]=z;n[C+1248+(a<<4)+8>>2]=y;n[C+1248+(a<<4)+12>>2]=0.0;y=v*+n[h+4>>2]+w*+n[h+20>>2]+x*+n[h+36>>2];z=v*+n[h+8>>2]+w*+n[h+24>>2]+x*+n[h+40>>2];n[C+256+(a<<4)>>2]=v*+n[h>>2]+w*+n[h+16>>2]+x*+n[h+32>>2];n[C+256+(a<<4)+4>>2]=y;n[C+256+(a<<4)+8>>2]=z;n[C+256+(a<<4)+12>>2]=0.0;a=a+1|0}while((a|0)!=42);p=Bb[f[(f[d>>2]|0)+84>>2]&127](d)|0;if((p|0)>0){a=0;o=42;while(1){Vb[f[(f[d>>2]|0)+88>>2]&127](d,a,C+176|0);y=+n[C+176>>2];z=+n[C+176+4>>2];x=+n[C+176+8>>2];w=y*+n[g+16>>2]+z*+n[g+20>>2]+x*+n[g+24>>2];v=y*+n[g+32>>2]+z*+n[g+36>>2]+x*+n[g+40>>2];n[C+176>>2]=+n[g>>2]*y+ +n[g+4>>2]*z+ +n[g+8>>2]*x;n[C+176+4>>2]=w;n[C+176+8>>2]=v;n[C+176+12>>2]=0.0;Te();q=24820+(o<<4)|0;f[q>>2]=f[C+176>>2];f[q+4>>2]=f[C+176+4>>2];f[q+8>>2]=f[C+176+8>>2];f[q+12>>2]=f[C+176+12>>2];v=+n[C+176>>2];w=+n[C+176+4>>2];x=+n[C+176+8>>2];z=+n[g+4>>2]*-v+ +n[g+20>>2]*-w+ +n[g+36>>2]*-x;y=+n[g+8>>2]*-v+ +n[g+24>>2]*-w+ +n[g+40>>2]*-x;n[C+1248+(o<<4)>>2]=+n[g>>2]*-v+ +n[g+16>>2]*-w+ +n[g+32>>2]*-x;n[C+1248+(o<<4)+4>>2]=z;n[C+1248+(o<<4)+8>>2]=y;n[C+1248+(o<<4)+12>>2]=0.0;y=v*+n[h+4>>2]+w*+n[h+20>>2]+x*+n[h+36>>2];z=v*+n[h+8>>2]+w*+n[h+24>>2]+x*+n[h+40>>2];n[C+256+(o<<4)>>2]=+n[h>>2]*v+ +n[h+16>>2]*w+ +n[h+32>>2]*x;n[C+256+(o<<4)+4>>2]=y;n[C+256+(o<<4)+8>>2]=z;n[C+256+(o<<4)+12>>2]=0.0;a=a+1|0;if((a|0)==(p|0))break;else o=o+1|0}o=p+42|0}else o=42;q=Bb[f[(f[e>>2]|0)+84>>2]&127](e)|0;if((q|0)>0){a=0;p=o;while(1){Vb[f[(f[e>>2]|0)+88>>2]&127](e,a,C+176|0);y=+n[C+176>>2];z=+n[C+176+4>>2];x=+n[C+176+8>>2];w=y*+n[h+16>>2]+z*+n[h+20>>2]+x*+n[h+24>>2];v=y*+n[h+32>>2]+z*+n[h+36>>2]+x*+n[h+40>>2];n[C+176>>2]=+n[h>>2]*y+ +n[h+4>>2]*z+ +n[h+8>>2]*x;n[C+176+4>>2]=w;n[C+176+8>>2]=v;n[C+176+12>>2]=0.0;Te();D=24820+(p<<4)|0;f[D>>2]=f[C+176>>2];f[D+4>>2]=f[C+176+4>>2];f[D+8>>2]=f[C+176+8>>2];f[D+12>>2]=f[C+176+12>>2];v=+n[C+176>>2];w=+n[C+176+4>>2];x=+n[C+176+8>>2];z=+n[g+4>>2]*-v+ +n[g+20>>2]*-w+ +n[g+36>>2]*-x;y=+n[g+8>>2]*-v+ +n[g+24>>2]*-w+ +n[g+40>>2]*-x;n[C+1248+(p<<4)>>2]=+n[g>>2]*-v+ +n[g+16>>2]*-w+ +n[g+32>>2]*-x;n[C+1248+(p<<4)+4>>2]=z;n[C+1248+(p<<4)+8>>2]=y;n[C+1248+(p<<4)+12>>2]=0.0;y=v*+n[h+4>>2]+w*+n[h+20>>2]+x*+n[h+36>>2];z=v*+n[h+8>>2]+w*+n[h+24>>2]+x*+n[h+40>>2];n[C+256+(p<<4)>>2]=+n[h>>2]*v+ +n[h+16>>2]*w+ +n[h+32>>2]*x;n[C+256+(p<<4)+4>>2]=y;n[C+256+(p<<4)+8>>2]=z;n[C+256+(p<<4)+12>>2]=0.0;a=a+1|0;if((a|0)==(q|0))break;else p=p+1|0}o=q+o|0}Yb[f[(f[d>>2]|0)+76>>2]&127](d,C+1248|0,C+3232|0,o);Yb[f[(f[e>>2]|0)+76>>2]&127](e,C+256|0,C+2240|0,o);if((o|0)>0){v=999999984306749440.0;a=0;y=0.0;z=0.0;x=0.0;r=0.0;while(1){Te();t=+n[24820+(a<<4)>>2];w=+n[24820+(a<<4)+4>>2];s=+n[24820+(a<<4)+12>>2];m=A?0.0:+n[24820+(a<<4)+8>>2];if(t*t+w*w+m*m>.01?(F=+n[C+3232+(a<<4)>>2],E=+n[C+3232+(a<<4)+4>>2],B=+n[C+3232+(a<<4)+8>>2],I=+n[C+2240+(a<<4)>>2],H=+n[C+2240+(a<<4)+4>>2],G=+n[C+2240+(a<<4)+8>>2],B=t*(I*+n[h>>2]+H*+n[h+4>>2]+G*+n[h+8>>2]+ +n[h+48>>2]-(F*+n[g>>2]+E*+n[g+4>>2]+B*+n[g+8>>2]+ +n[g+48>>2]))+w*(I*+n[h+16>>2]+H*+n[h+20>>2]+G*+n[h+24>>2]+ +n[h+52>>2]-(F*+n[g+16>>2]+E*+n[g+20>>2]+B*+n[g+24>>2]+ +n[g+52>>2]))+m*((A?0.0:I*+n[h+32>>2]+H*+n[h+36>>2]+G*+n[h+40>>2]+ +n[h+56>>2])-(A?0.0:F*+n[g+32>>2]+E*+n[g+36>>2]+B*+n[g+40>>2]+ +n[g+56>>2])),B<v):0)v=B;else{s=y;t=r;w=x;m=z}a=a+1|0;if((a|0)==(o|0)){x=m;break}else{y=s;z=m;x=w;r=t}}}else{v=999999984306749440.0;x=0.0;w=0.0;t=0.0;s=0.0}switch(f[d+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+rb[f[(f[d>>2]|0)+48>>2]&15](d)}switch(f[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+rb[f[(f[e>>2]|0)+48>>2]&15](e)}if(v<0.0){D=0;u=C;return D|0}switch(f[d+4>>2]|0){case 8:{m=+n[d+28>>2]*+n[d+12>>2];break}case 0:{m=+n[d+44>>2];break}case 1:{m=+n[d+44>>2];break}case 13:{m=+n[d+44>>2];break}case 11:{m=+n[d+44>>2];break}case 10:{m=+n[d+44>>2];break}case 4:case 5:{m=+n[d+44>>2];break}default:m=+rb[f[(f[d>>2]|0)+48>>2]&15](d)}a=f[e+4>>2]|0;switch(a|0){case 8:{r=+n[e+28>>2]*+n[e+12>>2];a=8;break}case 0:{r=+n[e+44>>2];a=0;break}case 1:{r=+n[e+44>>2];a=1;break}case 13:{r=+n[e+44>>2];a=13;break}case 11:{r=+n[e+44>>2];a=11;break}case 10:{r=+n[e+44>>2];a=10;break}case 4:case 5:{r=+n[e+44>>2];break}default:{r=+rb[f[(f[e>>2]|0)+48>>2]&15](e);a=f[e+4>>2]|0}}m=v+(m+r+.5);f[C+176>>2]=9400;f[C+176+4>>2]=0;f[C+176+8>>2]=1065353216;f[C+176+12>>2]=0;n[C+176+16>>2]=0.0;f[C+176+20>>2]=0;f[C+176+24>>2]=c;f[C+176+28>>2]=d;f[C+176+32>>2]=e;f[C+176+36>>2]=f[d+4>>2];f[C+176+40>>2]=a;G=+rb[f[(f[d>>2]|0)+48>>2]&15](d);n[C+176+44>>2]=G;G=+rb[f[(f[e>>2]|0)+48>>2]&15](e);n[C+176+48>>2]=G;b[C+176+52>>0]=0;f[C+176+60>>2]=-1;f[C+176+72>>2]=1;f[C+176+76>>2]=1;G=t*m+ +n[g+48>>2];H=w*m+ +n[g+52>>2];I=x*m+ +n[g+56>>2];f[C+44>>2]=f[g>>2];f[C+44+4>>2]=f[g+4>>2];f[C+44+8>>2]=f[g+8>>2];f[C+44+12>>2]=f[g+12>>2];f[C+44+16>>2]=f[g+16>>2];f[C+44+16+4>>2]=f[g+16+4>>2];f[C+44+16+8>>2]=f[g+16+8>>2];f[C+44+16+12>>2]=f[g+16+12>>2];f[C+44+32>>2]=f[g+32>>2];f[C+44+32+4>>2]=f[g+32+4>>2];f[C+44+32+8>>2]=f[g+32+8>>2];f[C+44+32+12>>2]=f[g+32+12>>2];n[C+44+48>>2]=G;n[C+44+52>>2]=H;n[C+44+56>>2]=I;n[C+44+60>>2]=0.0;f[C+44+64>>2]=f[h>>2];f[C+44+64+4>>2]=f[h+4>>2];f[C+44+64+8>>2]=f[h+8>>2];f[C+44+64+12>>2]=f[h+12>>2];f[C+44+80>>2]=f[h+16>>2];f[C+44+80+4>>2]=f[h+16+4>>2];f[C+44+80+8>>2]=f[h+16+8>>2];f[C+44+80+12>>2]=f[h+16+12>>2];f[C+44+96>>2]=f[h+32>>2];f[C+44+96+4>>2]=f[h+32+4>>2];f[C+44+96+8>>2]=f[h+32+8>>2];f[C+44+96+12>>2]=f[h+32+12>>2];f[C+44+112>>2]=f[h+48>>2];f[C+44+112+4>>2]=f[h+48+4>>2];f[C+44+112+8>>2]=f[h+48+8>>2];f[C+44+112+12>>2]=f[h+48+12>>2];n[C+44+128>>2]=999999984306749440.0;f[C>>2]=9284;b[C+40>>0]=0;n[C+176+4>>2]=-t;n[C+176+8>>2]=-w;n[C+176+12>>2]=-x;n[C+176+16>>2]=0.0;Nc(C+176|0,C+44|0,C,l,0);m=m-+n[C+36>>2];a=b[C+40>>0]|0;if(a<<24>>24){H=+n[C+24>>2]-w*m;I=+n[C+28>>2]-x*m;n[j>>2]=+n[C+20>>2]-t*m;n[j+4>>2]=H;n[j+8>>2]=I;n[j+12>>2]=0.0;f[k>>2]=f[C+20>>2];f[k+4>>2]=f[C+20+4>>2];f[k+8>>2]=f[C+20+8>>2];f[k+12>>2]=f[C+20+12>>2];n[i>>2]=t;n[i+4>>2]=w;n[i+8>>2]=x;n[i+12>>2]=s}D=a<<24>>24!=0;u=C;return D|0}function Tc(a,c){a=a|0;c=+c;var e=0,g=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;B=u;u=u+464|0;uj(12063);e=f[a+84>>2]|0;if(e|0)Mb[e&31](a,c);Mb[f[(f[a>>2]|0)+140>>2]&31](a,c);n[a+28>>2]=c;f[a+32>>2]=0;e=Bb[f[(f[a>>2]|0)+20>>2]&127](a)|0;f[a+48>>2]=e;uj(12106);uj(12131);e=f[a+316>>2]|0;if((f[a+308>>2]|0)>0){g=0;do{r=f[a+24>>2]|0;Rb[f[(f[r>>2]|0)+16>>2]&127](r,f[e+(g<<2)>>2]|0);g=g+1|0;e=f[a+316>>2]|0}while((g|0)<(f[a+308>>2]|0))}if(e|0){if(b[a+320>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+316>>2]=0}b[a+320>>0]=1;f[a+316>>2]=0;f[a+308>>2]=0;f[a+312>>2]=0;e=f[2405]|0;r=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=r;do if(!r){if(f[e+4>>2]|0){gb(B+368|0,0)|0;r=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[B+368+4>>2]|0)-(f[r+4>>2]|0)+(((f[B+368>>2]|0)-(f[r>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(f[e+16>>2]|0)break;e=f[2405]|0}f[2405]=f[e+20>>2]}while(0);a:do if((f[a+232>>2]|0)>0){r=B+304+48|0;q=B+368+44|0;p=0;while(1){i=f[(f[a+240>>2]|0)+(p<<2)>>2]|0;n[i+244>>2]=1.0;b:do switch(f[i+216>>2]|0){case 2:case 5:break;default:if(((f[i+204>>2]&3|0)==0?(Yg(i+4|0,+n[i+312>>2],+n[i+316>>2],+n[i+320>>2],i+328|0,c,B+304|0),s=+n[r>>2],t=s-+n[i+52>>2],v=+n[B+304+52>>2],w=v-+n[i+56>>2],x=+n[B+304+56>>2],y=x-+n[i+60>>2],b[a+44>>0]|0):0)?(m=+n[i+252>>2],m*m!=0.0?m*m<t*t+w*w+y*y:0):0){uj(12168);if((f[(f[i+192>>2]|0)+4>>2]|0)<20?(f[5853]=(f[5853]|0)+1,h=f[a+68>>2]|0,h=Bb[f[(f[h>>2]|0)+36>>2]&127](h)|0,o=f[a+24>>2]|0,n[B+368+4>>2]=1.0,f[B+368+12>>2]=f[i+52>>2],f[B+368+12+4>>2]=f[i+52+4>>2],f[B+368+12+8>>2]=f[i+52+8>>2],f[B+368+12+12>>2]=f[i+52+12>>2],f[B+368+28>>2]=f[r>>2],f[B+368+28+4>>2]=f[r+4>>2],f[B+368+28+8>>2]=f[r+8>>2],f[B+368+28+12>>2]=f[r+12>>2],f[B+368+76>>2]=0,f[B+368>>2]=4476,f[B+368+80>>2]=i,f[B+368+88>>2]=h,f[B+368+92>>2]=o,o=f[i+248>>2]|0,f[B+248+8>>2]=0,f[B+248+12>>2]=1065353216,f[B+248+16>>2]=1065353216,f[B+248+20>>2]=1065353216,n[B+248+24>>2]=0.0,f[B+248>>2]=6864,f[B+248+4>>2]=8,f[B+248+28>>2]=o,f[B+248+44>>2]=o,f[B+368+84>>2]=f[a+56>>2],o=f[i+188>>2]|0,d[B+368+8>>1]=d[o+4>>1]|0,d[B+368+10>>1]=d[o+6>>1]|0,f[B+184+48>>2]=f[r>>2],f[B+184+48+4>>2]=f[r+4>>2],f[B+184+48+8>>2]=f[r+8>>2],f[B+184+48+12>>2]=f[r+12>>2],f[B+184>>2]=f[i+4>>2],f[B+184+4>>2]=f[i+4+4>>2],f[B+184+8>>2]=f[i+4+8>>2],f[B+184+12>>2]=f[i+4+12>>2],f[B+184+16>>2]=f[i+20>>2],f[B+184+16+4>>2]=f[i+20+4>>2],f[B+184+16+8>>2]=f[i+20+8>>2],f[B+184+16+12>>2]=f[i+20+12>>2],f[B+184+32>>2]=f[i+36>>2],f[B+184+32+4>>2]=f[i+36+4>>2],f[B+184+32+8>>2]=f[i+36+8>>2],f[B+184+32+12>>2]=f[i+36+12>>2],Ld(a,B+248|0,i+4|0,B+184|0,B+368|0,0.0),z=+n[B+368+4>>2],z<1.0):0){j=z*(s-+n[i+52>>2]);k=z*(v-+n[i+56>>2]);l=z*(x-+n[i+60>>2]);m=-(k*+n[B+368+48>>2])-j*+n[q>>2]-l*+n[B+368+52>>2];o=f[a+24>>2]|0;o=Fb[f[(f[o>>2]|0)+12>>2]&63](o,i,f[B+368+76>>2]|0)|0;g=f[a+308>>2]|0;if((g|0)==(f[a+312>>2]|0)?(A=g|0?g<<1:1,(g|0)<(A|0)):0){if(!A)e=0;else{f[6472]=(f[6472]|0)+1;e=sc((A<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=f[a+308>>2]|0}if((g|0)>0){h=0;do{f[e+(h<<2)>>2]=f[(f[a+316>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=f[a+316>>2]|0;if(h){if(b[a+320>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);g=f[a+308>>2]|0}f[a+316>>2]=0}b[a+320>>0]=1;f[a+316>>2]=e;f[a+312>>2]=A;e=g}else e=g;f[(f[a+316>>2]|0)+(e<<2)>>2]=o;f[a+308>>2]=e+1;j=j+ +n[i+52>>2];k=k+ +n[i+56>>2];l=l+ +n[i+60>>2];h=f[B+368+76>>2]|0;N=+n[h+4>>2];M=+n[h+20>>2];L=+n[h+36>>2];K=+n[h+8>>2];J=+n[h+24>>2];I=+n[h+40>>2];H=+n[h+12>>2];F=+n[h+28>>2];D=+n[h+44>>2];G=-+n[h+52>>2];E=-+n[h+56>>2];C=-+n[h+60>>2];f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;f[B+12>>2]=0;n[B+16>>2]=j*N+k*M+l*L+(N*G+M*E+L*C);n[B+20>>2]=j*K+k*J+l*I+(K*G+J*E+I*C);n[B+24>>2]=j*H+k*F+l*D+(H*G+F*E+D*C);n[B+28>>2]=0.0;f[B+64>>2]=f[q>>2];f[B+64+4>>2]=f[q+4>>2];f[B+64+8>>2]=f[q+8>>2];f[B+64+12>>2]=f[q+12>>2];n[B+80>>2]=m;n[B+84>>2]=0.0;n[B+88>>2]=0.0;n[B+92>>2]=0.0;f[B+112>>2]=0;b[B+116>>0]=0;f[B+120>>2]=0;f[B+120+4>>2]=0;f[B+120+8>>2]=0;f[B+120+12>>2]=0;f[B+120+16>>2]=0;f[B+120+20>>2]=0;f[B+120+24>>2]=0;f[B+120+28>>2]=0;h=mf(o,B)|0;n[o+4+(h*184|0)+92>>2]=0.0;m=+n[i+224>>2]*+n[(f[B+368+76>>2]|0)+224>>2];m=m<-10.0?-10.0:m;n[o+4+(h*184|0)+84>>2]=m>10.0?10.0:m;f[o+4+(h*184|0)+48>>2]=f[i+52>>2];f[o+4+(h*184|0)+48+4>>2]=f[i+52+4>>2];f[o+4+(h*184|0)+48+8>>2]=f[i+52+8>>2];f[o+4+(h*184|0)+48+12>>2]=f[i+52+12>>2];n[o+4+(h*184|0)+32>>2]=j;n[o+4+(h*184|0)+36>>2]=k;n[o+4+(h*184|0)+40>>2]=l;n[o+4+(h*184|0)+44>>2]=0.0}e=f[2405]|0;o=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=o;if(!o){if(f[e+4>>2]|0){gb(B+368|0,0)|0;o=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[B+368+4>>2]|0)-(f[o+4>>2]|0)+(((f[B+368>>2]|0)-(f[o>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(f[e+16>>2]|0)break b;e=f[2405]|0}f[2405]=f[e+20>>2]}}}while(0);p=p+1|0;if((p|0)>=(f[a+232>>2]|0))break a}}while(0);e=f[2405]|0;A=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=A;do if(!A){if(f[e+4>>2]|0){gb(B+368|0,0)|0;A=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[B+368+4>>2]|0)-(f[A+4>>2]|0)+(((f[B+368>>2]|0)-(f[A>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(f[e+16>>2]|0)break;e=f[2405]|0}f[2405]=f[e+20>>2]}while(0);Lb[f[(f[a>>2]|0)+44>>2]&511](a);Lb[f[(f[a>>2]|0)+148>>2]&511](a);n[a+104>>2]=c;Rb[f[(f[a>>2]|0)+152>>2]&127](a,a+92|0);Mb[f[(f[a>>2]|0)+144>>2]&31](a,c);uj(12092);if((f[a+280>>2]|0)>0){e=0;do{A=f[(f[a+288>>2]|0)+(e<<2)>>2]|0;Sb[f[(f[A>>2]|0)+8>>2]&7](A,a,c);e=e+1|0}while((e|0)<(f[a+280>>2]|0))}e=f[2405]|0;A=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=A;do if(!A){if(f[e+4>>2]|0){gb(B+368|0,0)|0;A=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[B+368+4>>2]|0)-(f[A+4>>2]|0)+(((f[B+368>>2]|0)-(f[A>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(f[e+16>>2]|0)break;e=f[2405]|0}f[2405]=f[e+20>>2]}while(0);Mb[f[(f[a>>2]|0)+156>>2]&31](a,c);e=f[a+80>>2]|0;if(e|0)Mb[e&31](a,c);e=f[2405]|0;a=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=a;if(a|0){u=B;return}do if(f[e+4>>2]|0){gb(B+368|0,0)|0;a=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[B+368+4>>2]|0)-(f[a+4>>2]|0)+(((f[B+368>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[e+16>>2]|0)){e=f[2405]|0;break}else{u=B;return}}while(0);f[2405]=f[e+20>>2];u=B;return}function Uc(a){a=a|0;var c=0,d=0.0,e=0.0,g=0.0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;H=u;u=u+192|0;uj(11202);c=f[a+1112>>2]|0;if((c|0)>0){G=0;do{F=f[(f[a+1120>>2]|0)+(G<<2)>>2]|0;E=f[F+24>>2]|0;if(E){h=H+144+4|0;i=h+44|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));n[H+144>>2]=9.999999747378752e-05;n[H+144+20>>2]=1.9999999494757503e-04;n[H+144+40>>2]=2.9999998514540493e-04;if((E|0)>0){h=f[F+32>>2]|0;i=f[F+12>>2]|0;c=0;d=0.0;e=0.0;g=0.0;do{D=f[h+(c<<2)>>2]|0;C=+n[i+(c<<2)>>2];d=d+ +n[D+8>>2]*C;e=e+C*+n[D+12>>2];g=g+C*+n[D+16>>2];c=c+1|0}while((c|0)!=(E|0))}else{g=0.0;e=0.0;d=0.0}q=+n[F+128>>2];s=d*q;r=e*q;q=g*q;n[F+228>>2]=s;n[F+232>>2]=r;n[F+236>>2]=q;n[F+240>>2]=0.0;if((E|0)>0){h=f[F+32>>2]|0;i=f[F+52>>2]|0;c=0;d=9.999999747378752e-05;e=0.0;g=0.0;j=0.0;k=1.9999999494757503e-04;l=0.0;m=0.0;o=0.0;p=2.9999998514540493e-04;do{D=f[h+(c<<2)>>2]|0;x=+n[D+8>>2]-s;y=+n[D+12>>2]-r;B=+n[D+16>>2]-q;z=+n[i+(c<<4)>>2];A=+n[i+(c<<4)+4>>2];C=+n[i+(c<<4)+8>>2];d=x*z+d;e=x*A+e;g=x*C+g;j=y*z+j;k=y*A+k;l=y*C+l;m=B*z+m;o=B*A+o;p=B*C+p;c=c+1|0}while((c|0)!=(E|0));n[H+144>>2]=d;n[H+144+4>>2]=e;n[H+144+8>>2]=g;n[H+144+16>>2]=j;n[H+144+20>>2]=k;n[H+144+24>>2]=l;n[H+144+32>>2]=m;n[H+144+36>>2]=o;n[H+144+40>>2]=p}if((b[22728]|0)==0?fz(22728)|0:0){n[5824]=9.999999747378752e-05;f[5825]=16}id(H+144|0,H+96|0,H+48|0);f[F+108>>2]=f[F+228>>2];f[F+108+4>>2]=f[F+228+4>>2];f[F+108+8>>2]=f[F+228+8>>2];f[F+108+12>>2]=f[F+228+12>>2];f[F+60>>2]=f[H+96>>2];f[F+60+4>>2]=f[H+96+4>>2];f[F+60+8>>2]=f[H+96+8>>2];f[F+60+12>>2]=f[H+96+12>>2];f[F+76>>2]=f[H+96+16>>2];f[F+76+4>>2]=f[H+96+16+4>>2];f[F+76+8>>2]=f[H+96+16+8>>2];f[F+76+12>>2]=f[H+96+16+12>>2];f[F+92>>2]=f[H+96+32>>2];f[F+92+4>>2]=f[H+96+32+4>>2];f[F+92+8>>2]=f[H+96+32+8>>2];f[F+92+12>>2]=f[H+96+32+12>>2];k=+n[F+132>>2];K=+n[F+60>>2];l=+n[F+148>>2];J=+n[F+64>>2];m=+n[F+164>>2];A=+n[F+68>>2];o=+n[F+136>>2];p=+n[F+152>>2];q=+n[F+168>>2];r=+n[F+140>>2];s=+n[F+156>>2];C=+n[F+172>>2];I=+n[F+76>>2];d=+n[F+80>>2];B=+n[F+84>>2];j=+n[F+92>>2];g=+n[F+96>>2];e=+n[F+100>>2];t=(k*K+l*J+m*A)*K+(K*o+J*p+A*q)*J+(K*r+J*s+A*C)*A;v=(k*K+l*J+m*A)*I+(K*o+J*p+A*q)*d+(K*r+J*s+A*C)*B;w=(k*K+l*J+m*A)*j+(K*o+J*p+A*q)*g+(K*r+J*s+A*C)*e;x=(k*I+l*d+m*B)*K+(o*I+p*d+q*B)*J+(r*I+s*d+C*B)*A;y=(k*I+l*d+m*B)*I+(o*I+p*d+q*B)*d+(r*I+s*d+C*B)*B;z=(k*I+l*d+m*B)*j+(o*I+p*d+q*B)*g+(r*I+s*d+C*B)*e;A=K*(k*j+l*g+m*e)+(o*j+p*g+q*e)*J+(r*j+s*g+C*e)*A;B=I*(k*j+l*g+m*e)+(o*j+p*g+q*e)*d+(r*j+s*g+C*e)*B;C=(k*j+l*g+m*e)*j+(o*j+p*g+q*e)*g+(r*j+s*g+C*e)*e;n[F+180>>2]=t;n[F+184>>2]=v;n[F+188>>2]=w;n[F+192>>2]=0.0;n[F+196>>2]=x;n[F+200>>2]=y;n[F+204>>2]=z;n[F+208>>2]=0.0;n[F+212>>2]=A;n[F+216>>2]=B;n[F+220>>2]=C;n[F+224>>2]=0.0;f[F+316>>2]=0;f[F+316+4>>2]=0;f[F+316+8>>2]=0;f[F+316+12>>2]=0;f[F+316+16>>2]=0;f[F+316+20>>2]=0;f[F+316+24>>2]=0;f[F+316+28>>2]=0;if((E|0)>0){h=f[F+32>>2]|0;i=f[F+12>>2]|0;q=+n[F+228>>2];r=+n[F+232>>2];s=+n[F+236>>2];c=0;p=0.0;o=0.0;m=0.0;l=0.0;k=0.0;d=0.0;do{D=f[h+(c<<2)>>2]|0;M=+n[i+(c<<2)>>2];J=+n[D+40>>2]*M;L=M*+n[D+44>>2];M=M*+n[D+48>>2];p=J+p;n[F+316>>2]=p;o=L+o;n[F+320>>2]=o;m=M+m;n[F+324>>2]=m;I=+n[D+8>>2]-q;K=+n[D+12>>2]-r;N=+n[D+16>>2]-s;l=l+(M*K-L*N);n[F+332>>2]=l;k=J*N-M*I+k;n[F+336>>2]=k;d=L*I-J*K+d;n[F+340>>2]=d;c=c+1|0}while((c|0)!=(E|0));D=F+316|0;c=F+332|0}else{D=F+316|0;c=F+332|0;p=0.0;o=0.0;m=0.0;l=0.0;k=0.0;d=0.0}M=+n[F+128>>2];N=1.0-+n[F+356>>2];n[F+316>>2]=p*M*N;n[F+320>>2]=M*o*N;n[F+324>>2]=M*m*N;n[F+328>>2]=0.0;N=1.0-+n[F+360>>2];n[c>>2]=(t*l+v*k+w*d)*N;n[F+336>>2]=(l*x+k*y+d*z)*N;n[F+340>>2]=N*(l*A+k*B+d*C);n[F+344>>2]=0.0;h=F+244|0;i=h+72|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));d=+n[F+364>>2];a:do if(d>0.0?(f[F+24>>2]|0)>0:0){c=0;while(1){i=f[(f[F+32>>2]|0)+(c<<2)>>2]|0;h=f[F+52>>2]|0;I=+n[h+(c<<4)>>2];J=+n[h+(c<<4)+4>>2];K=+n[h+(c<<4)+8>>2];L=+n[i+8>>2];M=+n[i+12>>2];N=+n[i+16>>2];M=M+d*(I*+n[F+76>>2]+J*+n[F+80>>2]+K*+n[F+84>>2]+ +n[F+112>>2]-M);N=N+d*(I*j+J*g+K*e+ +n[F+116>>2]-N);n[i+8>>2]=L+d*(I*+n[F+60>>2]+J*+n[F+64>>2]+K*+n[F+68>>2]+ +n[F+108>>2]-L);n[i+12>>2]=M;n[i+16>>2]=N;n[i+20>>2]=0.0;c=c+1|0;if((c|0)>=(f[F+24>>2]|0))break a;j=+n[F+92>>2];g=+n[F+96>>2];e=+n[F+100>>2];d=+n[F+364>>2]}}while(0);if(b[F+377>>0]|0){h=f[F+32>>2]|0;i=f[h>>2]|0;d=+n[i+8>>2];p=+n[i+12>>2];q=+n[i+16>>2];e=+n[i+20>>2];if((E|0)>1){c=1;k=d;o=d;l=e;m=q;j=e;g=p;e=p;d=q;do{i=f[h+(c<<2)>>2]|0;K=+n[i+8>>2];o=K<o?K:o;L=+n[i+12>>2];e=L<e?L:e;M=+n[i+16>>2];m=M<m?M:m;N=+n[i+20>>2];j=N<j?N:j;k=k<K?K:k;g=g<L?L:g;d=d<M?M:d;l=l<N?N:l;c=c+1|0}while((c|0)!=(E|0))}else{k=d;o=d;l=e;m=q;j=e;g=p;e=p;d=q}n[H+16>>2]=o;n[H+16+4>>2]=e;n[H+16+8>>2]=m;n[H+16+12>>2]=j;n[H+16+16>>2]=k;n[H+16+20>>2]=g;n[H+16+24>>2]=d;n[H+16+28>>2]=l;c=f[F+348>>2]|0;if(!c){c=f[a+1052>>2]|0;if(!c){f[6472]=(f[6472]|0)+1;c=sc(63)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}h=c;i=h+44|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0))}else f[a+1052>>2]=0;f[c+32>>2]=0;f[c+36>>2]=F;f[c+40>>2]=0;f[c>>2]=f[H+16>>2];f[c+4>>2]=f[H+16+4>>2];f[c+8>>2]=f[H+16+8>>2];f[c+12>>2]=f[H+16+12>>2];f[c+16>>2]=f[H+16+16>>2];f[c+20>>2]=f[H+16+20>>2];f[c+24>>2]=f[H+16+24>>2];f[c+28>>2]=f[H+16+28>>2];ff(a+1048|0,f[a+1048>>2]|0,c);f[a+1060>>2]=(f[a+1060>>2]|0)+1;f[F+348>>2]=c}else{L=+n[a+452>>2];M=L*+n[F+320>>2]*3.0;N=L*+n[F+324>>2]*3.0;n[H>>2]=+n[D>>2]*L*3.0;n[H+4>>2]=M;n[H+8>>2]=N;n[H+12>>2]=0.0;uh(a+1048|0,c,H+16|0,H,+n[a+464>>2])|0}}c=f[a+1112>>2]|0}G=G+1|0}while((G|0)<(c|0))}c=f[2405]|0;a=(f[c+16>>2]|0)+-1|0;f[c+16>>2]=a;if(a|0){u=H;return}do if(f[c+4>>2]|0){gb(H+144|0,0)|0;a=f[6471]|0;n[c+8>>2]=+n[c+8>>2]+ +(((f[H+144+4>>2]|0)-(f[a+4>>2]|0)+(((f[H+144>>2]|0)-(f[a>>2]|0)|0)*1e6|0)-(f[c+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[c+16>>2]|0)){c=f[2405]|0;break}else{u=H;return}}while(0);f[2405]=f[c+20>>2];u=H;return}function Vc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0;E=u;u=u+784|0;f[E+168+8>>2]=0;f[E+168+12>>2]=1065353216;f[E+168+16>>2]=1065353216;f[E+168+20>>2]=1065353216;n[E+168+24>>2]=0.0;f[E+168>>2]=6864;f[E+168+4>>2]=8;n[E+168+28>>2]=0.0;n[E+168+44>>2]=0.0;C=f[d+4>>2]|0;D=f[d+12>>2]|0;g=f[C+4>>2]|0;if((g|0)<20){f[E+600>>2]=3832;f[E+600+168>>2]=0;n[E+600+172>>2]=0.0;f[E+600+164>>2]=f[e+4>>2];n[E+240+308>>2]=9.999999747378752e-05;b[E+240+332>>0]=0;f[E+224>>2]=5156;f[E+224+4>>2]=E+240;f[E+224+8>>2]=E+168;f[E+224+12>>2]=C;f[E+152>>2]=9332;f[E+152+4>>2]=E+240;f[E+152+8>>2]=E+168;f[E+152+12>>2]=C;C=(f[e+16>>2]&8|0)==0?E+224|0:E+152|0;if((Hb[f[(f[C>>2]|0)+8>>2]&3](C,a,c,D,D,E+600|0)|0?(h=E+600+132|0,i=+n[h>>2],j=+n[E+600+136>>2],k=+n[E+600+140>>2],i*i+j*j+k*k>9.999999747378752e-05):0)?(l=+n[E+600+164>>2],l<+n[e+4>>2]):0){B=1.0/+L(+(i*i+j*j+k*k));n[h>>2]=i*B;n[E+600+136>>2]=j*B;n[E+600+140>>2]=k*B;f[E+120>>2]=f[d+8>>2];f[E+120+4>>2]=0;f[E+120+8>>2]=f[h>>2];f[E+120+8+4>>2]=f[h+4>>2];f[E+120+8+8>>2]=f[h+8>>2];f[E+120+8+12>>2]=f[h+12>>2];n[E+120+24>>2]=l;+ub[f[(f[e>>2]|0)+12>>2]&15](e,E+120|0,1)}u=E;return}if((g+-21|0)>>>0>=9){if((g|0)!=31){u=E;return}g=f[C+64>>2]|0;d=f[d+8>>2]|0;f[E+600>>2]=5952;f[E+600+4>>2]=d;f[E+600+8>>2]=C;f[E+600+12>>2]=D;f[E+600+16>>2]=a;f[E+600+20>>2]=c;f[E+600+24>>2]=e;if(!g){h=f[C+16>>2]|0;if((h|0)>0){g=0;do{Uf(E+600|0,g);g=g+1|0}while((g|0)<(h|0))}}else{w=+n[D+48>>2];l=+n[a+48>>2]-w;y=+n[D+52>>2];m=+n[a+52>>2]-y;A=+n[D+56>>2];o=+n[a+56>>2]-A;p=+n[D>>2];q=+n[D+16>>2];r=+n[D+32>>2];s=+n[D+4>>2];t=+n[D+20>>2];v=+n[D+36>>2];x=+n[D+8>>2];z=+n[D+24>>2];B=+n[D+40>>2];n[E+240>>2]=l*p+m*q+o*r;n[E+240+4>>2]=l*s+m*t+o*v;n[E+240+8>>2]=l*x+m*z+o*B;n[E+240+12>>2]=0.0;w=+n[c+48>>2]-w;y=+n[c+52>>2]-y;A=+n[c+56>>2]-A;n[E+224>>2]=w*p+y*q+A*r;n[E+224+4>>2]=w*s+y*t+A*v;n[E+224+8>>2]=w*x+y*z+A*B;n[E+224+12>>2]=0.0;Ie(f[g>>2]|0,E+240|0,E+224|0,E+600|0)}u=E;return}m=+n[D>>2];o=+n[D+16>>2];i=+n[D+32>>2];j=+n[D+4>>2];v=+n[D+20>>2];w=+n[D+36>>2];k=+n[D+8>>2];y=+n[D+24>>2];z=+n[D+40>>2];A=-+n[D+48>>2];B=-+n[D+52>>2];x=-+n[D+56>>2];p=+n[a+48>>2];q=+n[a+52>>2];l=+n[a+56>>2];n[E+152>>2]=m*A+o*B+i*x+(m*p+o*q+i*l);n[E+152+4>>2]=j*A+v*B+w*x+(j*p+v*q+w*l);n[E+152+8>>2]=k*A+y*B+z*x+(k*p+y*q+z*l);n[E+152+12>>2]=0.0;s=+n[c+48>>2];t=+n[c+52>>2];r=+n[c+56>>2];i=m*A+o*B+i*x+(m*s+o*t+i*r);j=j*A+v*B+w*x+(j*s+v*t+w*r);k=k*A+y*B+z*x+(k*s+y*t+z*r);n[E+120>>2]=i;n[E+120+4>>2]=j;n[E+120+8>>2]=k;n[E+120+12>>2]=0.0;switch(f[C+4>>2]|0){case 21:{g=f[d+8>>2]|0;d=f[e+16>>2]|0;f[E+4>>2]=f[E+152>>2];f[E+4+4>>2]=f[E+152+4>>2];f[E+4+8>>2]=f[E+152+8>>2];f[E+4+12>>2]=f[E+152+12>>2];f[E+20>>2]=f[E+120>>2];f[E+20+4>>2]=f[E+120+4>>2];f[E+20+8>>2]=f[E+120+8>>2];f[E+20+12>>2]=f[E+120+12>>2];f[E+36>>2]=d;n[E+40>>2]=1.0;f[E>>2]=5904;f[E+44>>2]=e;f[E+48>>2]=g;f[E+52>>2]=C;f[E+56>>2]=f[D>>2];f[E+56+4>>2]=f[D+4>>2];f[E+56+8>>2]=f[D+8>>2];f[E+56+12>>2]=f[D+12>>2];f[E+72>>2]=f[D+16>>2];f[E+72+4>>2]=f[D+16+4>>2];f[E+72+8>>2]=f[D+16+8>>2];f[E+72+12>>2]=f[D+16+12>>2];f[E+88>>2]=f[D+32>>2];f[E+88+4>>2]=f[D+32+4>>2];f[E+88+8>>2]=f[D+32+8>>2];f[E+88+12>>2]=f[D+32+12>>2];f[E+104>>2]=f[D+48>>2];f[E+104+4>>2]=f[D+48+4>>2];f[E+104+8>>2]=f[D+48+8>>2];f[E+104+12>>2]=f[D+48+12>>2];f[E+40>>2]=f[e+4>>2];g=f[C+48>>2]|0;f[E+224>>2]=7076;f[E+224+4>>2]=g;f[E+224+8>>2]=E;g=f[C+52>>2]|0;f[E+600>>2]=0;f[E+600+4>>2]=0;f[E+600+8>>2]=0;f[E+600+12>>2]=0;f[E+240>>2]=0;f[E+240+4>>2]=0;f[E+240+8>>2]=0;f[E+240+12>>2]=0;if(!(b[g+60>>0]|0))Ue(g,E+224|0,E+152|0,i,j,k,E+600|0,E+240|0);else we(g,E+224|0,E+152|0,i,j,k,E+600|0,E+240|0,f[g+56>>2]|0);break}case 25:{d=f[d+8>>2]|0;c=f[e+16>>2]|0;f[E+600+4>>2]=f[E+152>>2];f[E+600+4+4>>2]=f[E+152+4>>2];f[E+600+4+8>>2]=f[E+152+8>>2];f[E+600+4+12>>2]=f[E+152+12>>2];f[E+600+20>>2]=f[E+120>>2];f[E+600+20+4>>2]=f[E+120+4>>2];f[E+600+20+8>>2]=f[E+120+8>>2];f[E+600+20+12>>2]=f[E+120+12>>2];f[E+600+36>>2]=c;n[E+600+40>>2]=1.0;f[E+600>>2]=5904;f[E+600+44>>2]=e;f[E+600+48>>2]=d;f[E+600+52>>2]=C;f[E+600+56>>2]=f[D>>2];f[E+600+56+4>>2]=f[D+4>>2];f[E+600+56+8>>2]=f[D+8>>2];f[E+600+56+12>>2]=f[D+12>>2];f[E+600+72>>2]=f[D+16>>2];f[E+600+72+4>>2]=f[D+16+4>>2];f[E+600+72+8>>2]=f[D+16+8>>2];f[E+600+72+12>>2]=f[D+16+12>>2];f[E+600+88>>2]=f[D+32>>2];f[E+600+88+4>>2]=f[D+32+4>>2];f[E+600+88+8>>2]=f[D+32+8>>2];f[E+600+88+12>>2]=f[D+32+12>>2];f[E+600+104>>2]=f[D+48>>2];f[E+600+104+4>>2]=f[D+48+4>>2];f[E+600+104+8>>2]=f[D+48+8>>2];f[E+600+104+12>>2]=f[D+48+12>>2];f[E+600+40>>2]=f[e+4>>2];Yb[f[(f[C>>2]|0)+144>>2]&127](C,E+600|0,E+152|0,E+120|0);break}default:{H=+n[D>>2];G=+n[D+16>>2];F=+n[D+32>>2];j=+n[D+4>>2];i=+n[D+8>>2];m=H*A+G*B+F*x+(H*p+G*q+F*l);o=j*A+v*B+w*x+(j*p+v*q+w*l);k=i*A+y*B+z*x+(i*p+y*q+z*l);l=H*A+G*B+F*x+(H*s+G*t+F*r);j=j*A+v*B+w*x+(j*s+v*t+w*r);i=i*A+y*B+z*x+(i*s+y*t+z*r);d=f[d+8>>2]|0;c=f[e+16>>2]|0;n[E+600+4>>2]=m;n[E+600+8>>2]=o;n[E+600+12>>2]=k;n[E+600+16>>2]=0.0;n[E+600+20>>2]=l;n[E+600+24>>2]=j;n[E+600+28>>2]=i;n[E+600+32>>2]=0.0;f[E+600+36>>2]=c;n[E+600+40>>2]=1.0;f[E+600>>2]=5928;f[E+600+44>>2]=e;f[E+600+48>>2]=d;f[E+600+52>>2]=C;f[E+600+56>>2]=f[D>>2];f[E+600+56+4>>2]=f[D+4>>2];f[E+600+56+8>>2]=f[D+8>>2];f[E+600+56+12>>2]=f[D+12>>2];f[E+600+72>>2]=f[D+16>>2];f[E+600+72+4>>2]=f[D+16+4>>2];f[E+600+72+8>>2]=f[D+16+8>>2];f[E+600+72+12>>2]=f[D+16+12>>2];f[E+600+88>>2]=f[D+32>>2];f[E+600+88+4>>2]=f[D+32+4>>2];f[E+600+88+8>>2]=f[D+32+8>>2];f[E+600+88+12>>2]=f[D+32+12>>2];f[E+600+104>>2]=f[D+48>>2];f[E+600+104+4>>2]=f[D+48+4>>2];f[E+600+104+8>>2]=f[D+48+8>>2];f[E+600+104+12>>2]=f[D+48+12>>2];f[E+600+40>>2]=f[e+4>>2];n[E+240>>2]=m;n[E+240+4>>2]=o;n[E+240+8>>2]=k;n[E+240+12>>2]=0.0;if(l<m)n[E+240>>2]=l;if(j<o)n[E+240+4>>2]=j;if(i<k)n[E+240+8>>2]=i;n[E+224>>2]=m;n[E+224+4>>2]=o;n[E+224+8>>2]=k;n[E+224+12>>2]=0.0;if(m<l)n[E+224>>2]=l;if(o<j)n[E+224+4>>2]=j;if(k<i)n[E+224+8>>2]=i;Yb[f[(f[C>>2]|0)+64>>2]&127](C,E+600|0,E+240|0,E+224|0)}}u=E;return}function Wc(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0;g=f[a+48>>2]|0;q=f[a+28>>2]|0;r=f[a+68>>2]|0;if(f[k+64>>2]&1|0){if((g|0)>0){h=f[a+136>>2]|0;e=0;p=f[a+192>>2]|0;do{l=h+(e<<2)|0;o=f[l>>2]|0;e=e+1|0;p=(X(p,1664525)|0)+1013904223|0;if(e>>>0<65537){d=p>>>16^p;if(e>>>0<257)if(e>>>0<17){d=(d>>>8^d)>>>4^(d>>>8^d);d=e>>>0<5?(e>>>0<3?(d>>>2^d)>>>1:0)^(d>>>2^d):d}else d=d>>>8^d}else d=p;d=h+(((d>>>0)%(e>>>0)|0)<<2)|0;f[l>>2]=f[d>>2];f[d>>2]=o}while((e|0)!=(g|0));f[a+192>>2]=p}if((f[k+20>>2]|0)>(c|0)){if((q|0)>0){g=f[a+116>>2]|0;e=0;o=f[a+192>>2]|0;do{h=g+(e<<2)|0;l=f[h>>2]|0;e=e+1|0;o=(X(o,1664525)|0)+1013904223|0;if(e>>>0<65537){d=o>>>16^o;if(e>>>0<257)if(e>>>0<17){d=(d>>>8^d)>>>4^(d>>>8^d);d=e>>>0<5?(e>>>0<3?(d>>>2^d)>>>1:0)^(d>>>2^d):d}else d=d>>>8^d}else d=o;p=g+(((d>>>0)%(e>>>0)|0)<<2)|0;f[h>>2]=f[p>>2];f[p>>2]=l}while((e|0)!=(q|0));f[a+192>>2]=o}if((r|0)>0){g=f[a+156>>2]|0;e=0;o=f[a+192>>2]|0;do{h=g+(e<<2)|0;l=f[h>>2]|0;e=e+1|0;o=(X(o,1664525)|0)+1013904223|0;if(e>>>0<65537){d=o>>>16^o;if(e>>>0<257)if(e>>>0<17){d=(d>>>8^d)>>>4^(d>>>8^d);d=e>>>0<5?(e>>>0<3?(d>>>2^d)>>>1:0)^(d>>>2^d):d}else d=d>>>8^d}else d=o;q=g+(((d>>>0)%(e>>>0)|0)<<2)|0;f[h>>2]=f[q>>2];f[q>>2]=l}while((e|0)!=(r|0));f[a+192>>2]=o}}}d=f[a+48>>2]|0;if(!(f[k+64>>2]&256)){if((d|0)>0){h=0;do{e=f[(f[a+136>>2]|0)+(h<<2)>>2]|0;g=f[a+56>>2]|0;if((f[g+(e*152|0)+136>>2]|0)>(c|0)){d=f[a+16>>2]|0;Gg(d+((f[g+(e*152|0)+144>>2]|0)*244|0)|0,d+((f[g+(e*152|0)+148>>2]|0)*244|0)|0,g+(e*152|0)|0);d=f[a+48>>2]|0}h=h+1|0}while((h|0)<(d|0))}if((f[k+20>>2]|0)<=(c|0))return 0.0;if((j|0)>0){d=0;do{e=i+(d<<2)|0;g=f[e>>2]|0;if(b[g+20>>0]|0){c=Vj(a,f[g+28>>2]|0,+n[k+12>>2])|0;t=Vj(a,f[(f[e>>2]|0)+32>>2]|0,+n[k+12>>2])|0;s=f[a+16>>2]|0;r=f[e>>2]|0;Wb[f[(f[r>>2]|0)+24>>2]&15](r,s+(c*244|0)|0,s+(t*244|0)|0,+n[k+12>>2])}d=d+1|0}while((d|0)!=(j|0))}e=f[a+28>>2]|0;if((e|0)>0){d=0;do{k=f[(f[a+116>>2]|0)+(d<<2)>>2]|0;j=f[a+36>>2]|0;i=f[a+16>>2]|0;Mg(i+((f[j+(k*152|0)+144>>2]|0)*244|0)|0,i+((f[j+(k*152|0)+148>>2]|0)*244|0)|0,j+(k*152|0)|0);d=d+1|0}while((d|0)!=(e|0))}e=f[a+68>>2]|0;if((e|0)>0){d=0;do{g=f[(f[a+156>>2]|0)+(d<<2)>>2]|0;h=f[a+76>>2]|0;m=+n[(f[a+36>>2]|0)+((f[h+(g*152|0)+140>>2]|0)*152|0)+100>>2];if(m>0.0){m=m*+n[h+(g*152|0)+104>>2];n[h+(g*152|0)+120>>2]=-m;n[h+(g*152|0)+124>>2]=m;k=f[a+16>>2]|0;Gg(k+((f[h+(g*152|0)+144>>2]|0)*244|0)|0,k+((f[h+(g*152|0)+148>>2]|0)*244|0)|0,h+(g*152|0)|0)}d=d+1|0}while((d|0)!=(e|0))}e=f[a+88>>2]|0;if((e|0)<=0)return 0.0;d=0;do{g=f[a+96>>2]|0;m=+n[(f[a+36>>2]|0)+((f[g+(d*152|0)+140>>2]|0)*152|0)+100>>2];if(m>0.0){u=+n[g+(d*152|0)+104>>2];m=m*u>u?u:m*u;n[g+(d*152|0)+120>>2]=-m;n[g+(d*152|0)+124>>2]=m;k=f[a+16>>2]|0;Gg(k+((f[g+(d*152|0)+144>>2]|0)*244|0)|0,k+((f[g+(d*152|0)+148>>2]|0)*244|0)|0,g+(d*152|0)|0)}d=d+1|0}while((d|0)!=(e|0));return 0.0}if((d|0)>0){h=0;do{e=f[(f[a+136>>2]|0)+(h<<2)>>2]|0;g=f[a+56>>2]|0;if((f[g+(e*152|0)+136>>2]|0)>(c|0)){d=f[a+16>>2]|0;Gg(d+((f[g+(e*152|0)+144>>2]|0)*244|0)|0,d+((f[g+(e*152|0)+148>>2]|0)*244|0)|0,g+(e*152|0)|0);d=f[a+48>>2]|0}h=h+1|0}while((h|0)<(d|0))}if((f[k+20>>2]|0)<=(c|0))return 0.0;if((j|0)>0){d=0;do{e=i+(d<<2)|0;g=f[e>>2]|0;if(b[g+20>>0]|0){q=Vj(a,f[g+28>>2]|0,+n[k+12>>2])|0;c=Vj(a,f[(f[e>>2]|0)+32>>2]|0,+n[k+12>>2])|0;r=f[a+16>>2]|0;p=f[e>>2]|0;Wb[f[(f[p>>2]|0)+24>>2]&15](p,r+(q*244|0)|0,r+(c*244|0)|0,+n[k+12>>2])}d=d+1|0}while((d|0)!=(j|0))}e=f[k+64>>2]|0;o=f[a+28>>2]|0;if(e&512|0){if((o|0)<=0)return 0.0;d=0;do{g=f[(f[a+116>>2]|0)+(d<<2)>>2]|0;h=f[a+36>>2]|0;l=f[a+16>>2]|0;Mg(l+((f[h+(g*152|0)+144>>2]|0)*244|0)|0,l+((f[h+(g*152|0)+148>>2]|0)*244|0)|0,h+(g*152|0)|0);m=+n[h+(g*152|0)+100>>2];g=X(d,(e>>>4&1)+1|0)|0;h=f[(f[a+156>>2]|0)+(g<<2)>>2]|0;l=f[a+76>>2]|0;if(m>0.0){u=m*+n[l+(h*152|0)+104>>2];n[l+(h*152|0)+120>>2]=-u;n[l+(h*152|0)+124>>2]=u;j=f[a+16>>2]|0;Gg(j+((f[l+(h*152|0)+144>>2]|0)*244|0)|0,j+((f[l+(h*152|0)+148>>2]|0)*244|0)|0,l+(h*152|0)|0)}if(f[k+64>>2]&16|0?(s=f[(f[a+156>>2]|0)+(g+1<<2)>>2]|0,t=f[a+76>>2]|0,m>0.0):0){u=m*+n[t+(s*152|0)+104>>2];n[t+(s*152|0)+120>>2]=-u;n[t+(s*152|0)+124>>2]=u;j=f[a+16>>2]|0;Gg(j+((f[t+(s*152|0)+144>>2]|0)*244|0)|0,j+((f[t+(s*152|0)+148>>2]|0)*244|0)|0,t+(s*152|0)|0)}d=d+1|0}while((d|0)!=(o|0));return 0.0}if((o|0)>0){d=0;do{k=f[(f[a+116>>2]|0)+(d<<2)>>2]|0;j=f[a+36>>2]|0;i=f[a+16>>2]|0;Mg(i+((f[j+(k*152|0)+144>>2]|0)*244|0)|0,i+((f[j+(k*152|0)+148>>2]|0)*244|0)|0,j+(k*152|0)|0);d=d+1|0}while((d|0)!=(o|0))}e=f[a+68>>2]|0;if((e|0)>0){d=0;do{g=f[(f[a+156>>2]|0)+(d<<2)>>2]|0;h=f[a+76>>2]|0;m=+n[(f[a+36>>2]|0)+((f[h+(g*152|0)+140>>2]|0)*152|0)+100>>2];if(m>0.0){u=m*+n[h+(g*152|0)+104>>2];n[h+(g*152|0)+120>>2]=-u;n[h+(g*152|0)+124>>2]=u;k=f[a+16>>2]|0;Gg(k+((f[h+(g*152|0)+144>>2]|0)*244|0)|0,k+((f[h+(g*152|0)+148>>2]|0)*244|0)|0,h+(g*152|0)|0)}d=d+1|0}while((d|0)!=(e|0))}e=f[a+88>>2]|0;if((e|0)<=0)return 0.0;d=0;do{g=f[a+96>>2]|0;m=+n[(f[a+36>>2]|0)+((f[g+(d*152|0)+140>>2]|0)*152|0)+100>>2];if(m>0.0){u=+n[g+(d*152|0)+104>>2];u=m*u>u?u:m*u;n[g+(d*152|0)+120>>2]=-u;n[g+(d*152|0)+124>>2]=u;k=f[a+16>>2]|0;Gg(k+((f[g+(d*152|0)+144>>2]|0)*244|0)|0,k+((f[g+(d*152|0)+148>>2]|0)*244|0)|0,g+(d*152|0)|0)}d=d+1|0}while((d|0)!=(e|0));return 0.0}function Xc(a,c,d,e,g,i){a=a|0;c=+c;d=d|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=u;u=u+560|0;B=C+524|0;f[C>>2]=0;A=C+512+12|0;cw(c)|0;if((I|0)<0){c=-c;y=1;x=20080}else{y=(g&2049|0)!=0&1;x=(g&2048|0)==0?((g&1|0)==0?20081:20086):20083}cw(c)|0;do if(0==0&(I&2146435072|0)==2146435072){j=y+3|0;dn(a,32,d,j,g&-65537);pz(a,x,y);pz(a,c!=c|0.0!=0.0?(i&32|0?20107:20111):i&32|0?20099:20103,3);dn(a,32,d,j,g^8192)}else{o=+dH(c,C)*2.0;if(o!=0.0)f[C>>2]=(f[C>>2]|0)+-1;if((i|32|0)==97){n=(i&32|0)==0?x:x+9|0;m=y|2;do if(!(e>>>0>11|(12-e|0)==0)){c=8.0;j=12-e|0;do{j=j+-1|0;c=c*16.0}while((j|0)!=0);if((b[n>>0]|0)==45){c=-(c+(-o-c));break}else{c=o+c-c;break}}else c=o;while(0);k=f[C>>2]|0;j=(k|0)<0?0-k|0:k;j=Fm(j,((j|0)<0)<<31>>31,A)|0;if((j|0)==(A|0)){b[C+512+11>>0]=48;j=C+512+11|0}b[j+-1>>0]=(k>>31&2)+43;l=j+-2|0;b[l>>0]=i+15;j=C+524|0;do{z=~~c;k=j+1|0;b[j>>0]=i&32|h[20115+z>>0];c=(c-+(z|0))*16.0;if((k-B|0)==1?!((g&8|0)==0&((e|0)<1&c==0.0)):0){b[k>>0]=46;j=j+2|0}else j=k}while(c!=0.0);if((e|0)!=0?(-2-B+j|0)<(e|0):0){k=j-B|0;j=e+2|0}else{k=j-B|0;j=j-B|0}B=A-l+m+j|0;dn(a,32,d,B,g);pz(a,n,m);dn(a,48,d,B,g^65536);pz(a,C+524|0,k);dn(a,48,j-k|0,0,0);pz(a,l,A-l|0);dn(a,32,d,B,g^8192);j=B;break}k=(e|0)<0?6:e;if(o!=0.0){m=(f[C>>2]|0)+-28|0;f[C>>2]=m;c=o*268435456.0}else{c=o;m=f[C>>2]|0}z=(m|0)<0?C+8|0:C+8+288|0;j=z;do{v=~~c>>>0;f[j>>2]=v;j=j+4|0;c=(c-+(v>>>0))*1.0e9}while(c!=0.0);if((m|0)>0){l=z;do{e=(m|0)<29?m:29;m=j+-4|0;if(m>>>0>=l>>>0){n=0;do{t=Xt(f[m>>2]|0,0,e|0)|0;t=iw(t|0,I|0,n|0,0)|0;v=I;s=cs(t|0,v|0,1e9,0)|0;f[m>>2]=s;n=FA(t|0,v|0,1e9,0)|0;m=m+-4|0}while(m>>>0>=l>>>0);if(n){l=l+-4|0;f[l>>2]=n}}while(1){if(j>>>0<=l>>>0)break;m=j+-4|0;if(!(f[m>>2]|0))j=m;else break}m=(f[C>>2]|0)-e|0;f[C>>2]=m}while((m|0)>0)}else l=z;if((m|0)<0)do{e=0-m|0;e=(e|0)<9?e:9;if(l>>>0<j>>>0){n=0;m=l;do{v=f[m>>2]|0;f[m>>2]=(v>>>e)+n;n=X(v&(1<<e)+-1,1e9>>>e)|0;m=m+4|0}while(m>>>0<j>>>0);l=(f[l>>2]|0)==0?l+4|0:l;if(n){f[j>>2]=n;j=j+4|0}}else l=(f[l>>2]|0)==0?l+4|0:l;m=(i|32|0)==102?z:l;j=(j-m>>2|0)>(((k+25|0)/9|0)+1|0)?m+(((k+25|0)/9|0)+1<<2)|0:j;m=(f[C>>2]|0)+e|0;f[C>>2]=m}while((m|0)<0);if(l>>>0<j>>>0){m=(z-l>>2)*9|0;e=f[l>>2]|0;if(e>>>0<10)r=m;else{n=10;do{n=n*10|0;m=m+1|0}while(e>>>0>=n>>>0);r=m}}else r=0;n=k-((i|32|0)!=102?r:0)+(((k|0)!=0&(i|32|0)==103)<<31>>31)|0;if((n|0)<(((j-z>>2)*9|0)+-9|0)){m=z+4+(((n+9216|0)/9|0)+-1024<<2)|0;if(((n+9216|0)%9|0|0)<8){e=(n+9216|0)%9|0;n=10;while(1){n=n*10|0;if((e|0)<7)e=e+1|0;else break}}else n=10;p=f[m>>2]|0;q=(p>>>0)%(n>>>0)|0;e=(m+4|0)==(j|0);if(!(e&(q|0)==0)){o=(((p>>>0)/(n>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;v=(n|0)/2|0;c=q>>>0<v>>>0?.5:e&(q|0)==(v|0)?1.0:1.5;if(y){v=(b[x>>0]|0)==45;c=v?-c:c;o=v?-o:o}f[m>>2]=p-q;if(o+c!=o){v=p-q+n|0;f[m>>2]=v;if(v>>>0>999999999)while(1){n=m+-4|0;f[m>>2]=0;if(n>>>0<l>>>0){l=l+-4|0;f[l>>2]=0}v=(f[n>>2]|0)+1|0;f[n>>2]=v;if(v>>>0>999999999)m=n;else{m=n;break}}n=(z-l>>2)*9|0;p=f[l>>2]|0;if(p>>>0>=10){e=10;do{e=e*10|0;n=n+1|0}while(p>>>0>=e>>>0)}}else n=r}else n=r;t=m+4|0;j=j>>>0>t>>>0?t:j;t=l}else{n=r;t=l}v=j;while(1){if(v>>>0<=t>>>0){s=0;break}j=v+-4|0;if(!(f[j>>2]|0))v=j;else{s=1;break}}p=0-n|0;do if((i|32|0)==103){if((n|0)>-5?(k+(((k|0)!=0^1)&1)|0)>(n|0):0){m=i+-1|0;k=k+(((k|0)!=0^1)&1)+-1-n|0}else{m=i+-2|0;k=k+(((k|0)!=0^1)&1)+-1|0}if(!(g&8)){if(s?(w=f[v+-4>>2]|0,(w|0)!=0):0)if(!((w>>>0)%10|0)){j=0;l=10;do{l=l*10|0;j=j+1|0}while(!((w>>>0)%(l>>>0)|0|0))}else j=0;else j=9;l=((v-z>>2)*9|0)+-9|0;if((m|32|0)==102){e=l-j|0;e=(e|0)>0?e:0;k=(k|0)<(e|0)?k:e;e=0;break}else{e=l+n-j|0;e=(e|0)>0?e:0;k=(k|0)<(e|0)?k:e;e=0;break}}else e=g&8}else{m=i;e=g&8}while(0);r=k|e;l=(m|32|0)==102;if(l){q=0;j=(n|0)>0?n:0}else{j=(n|0)<0?p:n;j=Fm(j,((j|0)<0)<<31>>31,A)|0;if((A-j|0)<2)do{j=j+-1|0;b[j>>0]=48}while((A-j|0)<2);b[j+-1>>0]=(n>>31&2)+43;j=j+-2|0;b[j>>0]=m;q=j;j=A-j|0}j=y+1+k+((r|0)!=0&1)+j|0;dn(a,32,d,j,g);pz(a,x,y);dn(a,48,d,j,g^65536);if(l){n=t>>>0>z>>>0?z:t;m=n;do{l=Fm(f[m>>2]|0,0,C+524+9|0)|0;if((m|0)==(n|0)){if((l|0)==(C+524+9|0)){b[C+524+8>>0]=48;l=C+524+8|0}}else if(l>>>0>(C+524|0)>>>0){bl(C+524|0,48,l-B|0)|0;do l=l+-1|0;while(l>>>0>(C+524|0)>>>0)}pz(a,l,C+524+9-l|0);m=m+4|0}while(m>>>0<=z>>>0);if(r|0)pz(a,20131,1);if(m>>>0<v>>>0&(k|0)>0)while(1){l=Fm(f[m>>2]|0,0,C+524+9|0)|0;if(l>>>0>(C+524|0)>>>0){bl(C+524|0,48,l-B|0)|0;do l=l+-1|0;while(l>>>0>(C+524|0)>>>0)}pz(a,l,(k|0)<9?k:9);m=m+4|0;l=k+-9|0;if(!(m>>>0<v>>>0&(k|0)>9)){k=l;break}else k=l}dn(a,48,k+9|0,9,0)}else{p=s?v:t+4|0;if((k|0)>-1){e=(e|0)==0;n=t;do{l=Fm(f[n>>2]|0,0,C+524+9|0)|0;if((l|0)==(C+524+9|0)){b[C+524+8>>0]=48;l=C+524+8|0}do if((n|0)==(t|0)){m=l+1|0;pz(a,l,1);if(e&(k|0)<1){l=m;break}pz(a,20131,1);l=m}else{if(l>>>0<=(C+524|0)>>>0)break;bl(C+524|0,48,l+(0-B)|0)|0;do l=l+-1|0;while(l>>>0>(C+524|0)>>>0)}while(0);z=C+524+9-l|0;pz(a,l,(k|0)>(z|0)?z:k);k=k-z|0;n=n+4|0}while(n>>>0<p>>>0&(k|0)>-1)}dn(a,48,k+18|0,18,0);pz(a,q,A-q|0)}dn(a,32,d,j,g^8192)}while(0);u=C;return ((j|0)<(d|0)?d:j)|0}function Yc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0,q=0.0,r=0.0;p=u;u=u+80|0;j=f[a+28>>2]|0;k=f[e+64>>2]|0;if((k&4|0)!=0&(j|0)>0){d=f[a+36>>2]|0;g=f[a+76>>2]|0;c=0;do{h=f[d+(c*152|0)+132>>2]|0;f[h+120>>2]=f[d+(c*152|0)+100>>2];i=f[d+(c*152|0)+140>>2]|0;f[h+124>>2]=f[g+(i*152|0)+100>>2];if(k&16|0)f[h+128>>2]=f[g+((i+1|0)*152|0)+100>>2];c=c+1|0}while((c|0)!=(j|0))}g=f[a+48>>2]|0;if((g|0)>0){c=0;do{h=f[a+56>>2]|0;i=f[h+(c*152|0)+132>>2]|0;j=f[i+44>>2]|0;d=h+(c*152|0)+100|0;if(j|0){o=+n[d>>2];k=f[i+28>>2]|0;m=1.0/+n[e+12>>2];l=o*+n[h+(c*152|0)+20>>2]*+n[k+352>>2]*m;q=o*+n[h+(c*152|0)+24>>2]*+n[k+356>>2]*m;n[j>>2]=+n[j>>2]+ +n[h+(c*152|0)+16>>2]*o*+n[k+348>>2]*m;n[j+4>>2]=l+ +n[j+4>>2];n[j+8>>2]=q+ +n[j+8>>2];q=+n[d>>2];k=f[i+32>>2]|0;l=1.0/+n[e+12>>2];m=q*+n[h+(c*152|0)+52>>2]*+n[k+352>>2]*l;o=q*+n[h+(c*152|0)+56>>2]*+n[k+356>>2]*l;n[j+32>>2]=+n[j+32>>2]+ +n[h+(c*152|0)+48>>2]*q*+n[k+348>>2]*l;n[j+36>>2]=m+ +n[j+36>>2];n[j+40>>2]=o+ +n[j+40>>2];k=f[i+28>>2]|0;o=+n[d>>2];m=1.0/+n[e+12>>2];l=+n[h+(c*152|0)+4>>2]*+n[k+548>>2]*o*m;q=o*+n[h+(c*152|0)+8>>2]*+n[k+552>>2]*m;n[j+16>>2]=+n[j+16>>2]+ +n[h+(c*152|0)>>2]*+n[k+544>>2]*o*m;n[j+20>>2]=l+ +n[j+20>>2];n[j+24>>2]=q+ +n[j+24>>2];k=f[i+32>>2]|0;q=+n[d>>2];l=1.0/+n[e+12>>2];m=+n[h+(c*152|0)+36>>2]*+n[k+548>>2]*q*l;o=q*+n[h+(c*152|0)+40>>2]*+n[k+552>>2]*l;n[j+48>>2]=+n[j+48>>2]+ +n[h+(c*152|0)+32>>2]*+n[k+544>>2]*q*l;n[j+52>>2]=m+ +n[j+52>>2];n[j+56>>2]=o+ +n[j+56>>2]}k=f[d>>2]|0;f[i+36>>2]=k;q=+K(+(f[s>>2]=k,+n[s>>2]));if(q>=+n[i+16>>2])b[i+20>>0]=0;c=c+1|0}while((c|0)!=(g|0))}c=f[a+8>>2]|0;if((c|0)>0){i=0;d=f[a+16>>2]|0;do{g=d+(i*244|0)|0;h=f[d+(i*244|0)+240>>2]|0;if(h){if(!(f[e+44>>2]|0)){g=d+(i*244|0)+176|0;m=+n[d+(i*244|0)+64>>2]+ +n[g>>2];n[g>>2]=m;g=d+(i*244|0)+180|0;o=+n[d+(i*244|0)+68>>2]+ +n[g>>2];n[g>>2]=o;g=d+(i*244|0)+184|0;l=+n[d+(i*244|0)+72>>2]+ +n[g>>2];n[g>>2]=l;g=d+(i*244|0)+192|0;n[g>>2]=+n[d+(i*244|0)+80>>2]+ +n[g>>2];g=d+(i*244|0)+196|0;n[g>>2]=+n[d+(i*244|0)+84>>2]+ +n[g>>2];g=d+(i*244|0)+200|0;n[g>>2]=+n[d+(i*244|0)+88>>2]+ +n[g>>2];g=d;c=h}else{l=+n[e+12>>2];m=+n[e+52>>2];c=d+(i*244|0)+176|0;n[c>>2]=+n[d+(i*244|0)+64>>2]+ +n[c>>2];c=d+(i*244|0)+180|0;n[c>>2]=+n[d+(i*244|0)+68>>2]+ +n[c>>2];c=d+(i*244|0)+184|0;n[c>>2]=+n[d+(i*244|0)+72>>2]+ +n[c>>2];c=d+(i*244|0)+192|0;n[c>>2]=+n[d+(i*244|0)+80>>2]+ +n[c>>2];c=d+(i*244|0)+196|0;n[c>>2]=+n[d+(i*244|0)+84>>2]+ +n[c>>2];c=d+(i*244|0)+200|0;n[c>>2]=+n[d+(i*244|0)+88>>2]+ +n[c>>2];o=+n[d+(i*244|0)+144>>2];c=d+(i*244|0)+148|0;if(((((!(o!=0.0)?!(+n[c>>2]!=0.0):0)?!(+n[d+(i*244|0)+152>>2]!=0.0):0)?!(+n[d+(i*244|0)+160>>2]!=0.0):0)?!(+n[d+(i*244|0)+164>>2]!=0.0):0)?!(+n[d+(i*244|0)+168>>2]!=0.0):0)c=h;else{r=+n[d+(i*244|0)+164>>2]*m;q=+n[d+(i*244|0)+168>>2]*m;n[p>>2]=+n[d+(i*244|0)+160>>2]*m;n[p+4>>2]=r;n[p+8>>2]=q;n[p+12>>2]=0.0;Yg(g,o,+n[c>>2],+n[d+(i*244|0)+152>>2],p,l,p+16|0);f[g>>2]=f[p+16>>2];f[g+4>>2]=f[p+16+4>>2];f[g+8>>2]=f[p+16+8>>2];f[g+12>>2]=f[p+16+12>>2];c=d+(i*244|0)+16|0;f[c>>2]=f[p+16+16>>2];f[c+4>>2]=f[p+16+16+4>>2];f[c+8>>2]=f[p+16+16+8>>2];f[c+12>>2]=f[p+16+16+12>>2];c=d+(i*244|0)+32|0;f[c>>2]=f[p+16+32>>2];f[c+4>>2]=f[p+16+32+4>>2];f[c+8>>2]=f[p+16+32+8>>2];f[c+12>>2]=f[p+16+32+12>>2];c=d+(i*244|0)+48|0;f[c>>2]=f[p+16+48>>2];f[c+4>>2]=f[p+16+48+4>>2];f[c+8>>2]=f[p+16+48+8>>2];f[c+12>>2]=f[p+16+48+12>>2];c=f[a+16>>2]|0;d=c;c=f[c+(i*244|0)+240>>2]|0}g=d;m=+n[d+(i*244|0)+176>>2];o=+n[d+(i*244|0)+180>>2];l=+n[d+(i*244|0)+184>>2]}r=m+ +n[g+(i*244|0)+208>>2];q=o+ +n[g+(i*244|0)+212>>2];o=l+ +n[g+(i*244|0)+216>>2];j=c+260|0;f[j>>2]=(f[j>>2]|0)+1;n[c+312>>2]=r;n[c+316>>2]=q;n[c+320>>2]=o;n[c+324>>2]=0.0;j=f[a+16>>2]|0;k=f[j+(i*244|0)+240>>2]|0;o=+n[j+(i*244|0)+192>>2]+ +n[j+(i*244|0)+224>>2];q=+n[j+(i*244|0)+196>>2]+ +n[j+(i*244|0)+228>>2];r=+n[j+(i*244|0)+200>>2]+ +n[j+(i*244|0)+232>>2];f[k+260>>2]=(f[k+260>>2]|0)+1;n[k+328>>2]=o;n[k+332>>2]=q;n[k+336>>2]=r;n[k+340>>2]=0.0;if(f[e+44>>2]|0){j=f[a+16>>2]|0;k=f[j+(i*244|0)+240>>2]|0;h=j+(i*244|0)|0;f[k+260>>2]=(f[k+260>>2]|0)+1;f[k+4>>2]=f[h>>2];f[k+4+4>>2]=f[h+4>>2];f[k+4+8>>2]=f[h+8>>2];f[k+4+12>>2]=f[h+12>>2];h=j+(i*244|0)+16|0;f[k+20>>2]=f[h>>2];f[k+20+4>>2]=f[h+4>>2];f[k+20+8>>2]=f[h+8>>2];f[k+20+12>>2]=f[h+12>>2];h=j+(i*244|0)+32|0;f[k+36>>2]=f[h>>2];f[k+36+4>>2]=f[h+4>>2];f[k+36+8>>2]=f[h+8>>2];f[k+36+12>>2]=f[h+12>>2];j=j+(i*244|0)+48|0;f[k+52>>2]=f[j>>2];f[k+52+4>>2]=f[j+4>>2];f[k+52+8>>2]=f[j+8>>2];f[k+52+12>>2]=f[j+12>>2]}d=f[a+16>>2]|0;f[(f[d+(i*244|0)+240>>2]|0)+212>>2]=-1;c=f[a+8>>2]|0}i=i+1|0}while((i|0)<(c|0))}if((f[a+28>>2]|0)<0?(f[a+32>>2]|0)<0:0){c=f[a+36>>2]|0;if(c|0){if(b[a+40>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+36>>2]=0}b[a+40>>0]=1;f[a+36>>2]=0;f[a+32>>2]=0}f[a+28>>2]=0;if((f[a+48>>2]|0)<0?(f[a+52>>2]|0)<0:0){c=f[a+56>>2]|0;if(c|0){if(b[a+60>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+56>>2]=0}b[a+60>>0]=1;f[a+56>>2]=0;f[a+52>>2]=0}f[a+48>>2]=0;if((f[a+68>>2]|0)<0?(f[a+72>>2]|0)<0:0){c=f[a+76>>2]|0;if(c|0){if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+76>>2]=0}b[a+80>>0]=1;f[a+76>>2]=0;f[a+72>>2]=0}f[a+68>>2]=0;if((f[a+88>>2]|0)<0?(f[a+92>>2]|0)<0:0){c=f[a+96>>2]|0;if(c|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=0;f[a+92>>2]=0}f[a+88>>2]=0;if((f[a+8>>2]|0)>=0){f[a+8>>2]=0;u=p;return 0.0}if((f[a+12>>2]|0)>=0){f[a+8>>2]=0;u=p;return 0.0}c=f[a+16>>2]|0;if(c|0){if(b[a+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+16>>2]=0}b[a+20>>0]=1;f[a+16>>2]=0;f[a+12>>2]=0;f[a+8>>2]=0;u=p;return 0.0}function Zc(a){a=a|0;var b=0,c=0.0,d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0.0,o=0.0,p=0.0;j=u;u=u+16|0;b=f[a+372>>2]|0;a:do switch(f[b+32>>2]|0){case 1:{n[b+20>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+4>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,1.0,0.0,0.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}b=f[a+372>>2]|0;k=(f[b+32>>2]|0)+-1|0;f[b+32>>2]=k;k=f[b+(k<<2)>>2]|0;b=f[a+364>>2]|0;f[a+364>>2]=b+1;f[a+348+(b<<2)>>2]=k;b=f[a+372>>2]|0;n[b+16+(f[b+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+(f[b+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,-1.0,-0.0,-0.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}b=f[a+372>>2]|0;k=(f[b+32>>2]|0)+-1|0;f[b+32>>2]=k;k=f[b+(k<<2)>>2]|0;b=f[a+364>>2]|0;f[a+364>>2]=b+1;f[a+348+(b<<2)>>2]=k;b=f[a+372>>2]|0;n[b+16+(f[b+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+(f[b+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,0.0,1.0,0.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}b=f[a+372>>2]|0;k=(f[b+32>>2]|0)+-1|0;f[b+32>>2]=k;k=f[b+(k<<2)>>2]|0;b=f[a+364>>2]|0;f[a+364>>2]=b+1;f[a+348+(b<<2)>>2]=k;b=f[a+372>>2]|0;n[b+16+(f[b+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+(f[b+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,-0.0,-1.0,-0.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}b=f[a+372>>2]|0;k=(f[b+32>>2]|0)+-1|0;f[b+32>>2]=k;k=f[b+(k<<2)>>2]|0;b=f[a+364>>2]|0;f[a+364>>2]=b+1;f[a+348+(b<<2)>>2]=k;b=f[a+372>>2]|0;n[b+16+(f[b+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+(f[b+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,0.0,0.0,1.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}b=f[a+372>>2]|0;k=(f[b+32>>2]|0)+-1|0;f[b+32>>2]=k;k=f[b+(k<<2)>>2]|0;b=f[a+364>>2]|0;f[a+364>>2]=b+1;f[a+348+(b<<2)>>2]=k;b=f[a+372>>2]|0;n[b+16+(f[b+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[b+(f[b+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[b+32>>2]|0;f[b+32>>2]=k+1;Gh(a,-0.0,-0.0,-1.0,f[b+(k<<2)>>2]|0);if(Zc(a)|0){k=1;u=j;return k|0}else{k=f[a+372>>2]|0;b=(f[k+32>>2]|0)+-1|0;f[k+32>>2]=b;b=f[k+(b<<2)>>2]|0;k=f[a+364>>2]|0;f[a+364>>2]=k+1;f[a+348+(k<<2)>>2]=b;break a}}case 2:{k=f[b+4>>2]|0;b=f[b>>2]|0;c=+n[k+16>>2]-+n[b+16>>2];d=+n[k+20>>2]-+n[b+20>>2];e=+n[k+24>>2]-+n[b+24>>2];b=0;while(1){f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;n[j+(b<<2)>>2]=1.0;g=+n[j+8>>2];h=+n[j+4>>2];i=+n[j>>2];if((d*g-e*h)*(d*g-e*h)+(e*i-c*g)*(e*i-c*g)+(c*h-d*i)*(c*h-d*i)>0.0){l=f[a+372>>2]|0;n[l+16+(f[l+32>>2]<<2)>>2]=0.0;k=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=k;f[l+(f[l+32>>2]<<2)>>2]=f[a+348+(k<<2)>>2];k=f[l+32>>2]|0;f[l+32>>2]=k+1;Gh(a,d*g-e*h,e*i-c*g,c*h-d*i,f[l+(k<<2)>>2]|0);if(Zc(a)|0)break;k=f[a+372>>2]|0;l=(f[k+32>>2]|0)+-1|0;f[k+32>>2]=l;l=f[k+(l<<2)>>2]|0;k=f[a+364>>2]|0;f[a+364>>2]=k+1;f[a+348+(k<<2)>>2]=l;k=f[a+372>>2]|0;n[k+16+(f[k+32>>2]<<2)>>2]=0.0;l=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=l;f[k+(f[k+32>>2]<<2)>>2]=f[a+348+(l<<2)>>2];l=f[k+32>>2]|0;f[k+32>>2]=l+1;Gh(a,-(d*g-e*h),-(e*i-c*g),-(c*h-d*i),f[k+(l<<2)>>2]|0);if(Zc(a)|0)break;l=f[a+372>>2]|0;k=(f[l+32>>2]|0)+-1|0;f[l+32>>2]=k;k=f[l+(k<<2)>>2]|0;l=f[a+364>>2]|0;f[a+364>>2]=l+1;f[a+348+(l<<2)>>2]=k}b=b+1|0;if(b>>>0>=3)break a}l=1;u=j;return l|0}case 3:{l=f[b+4>>2]|0;k=f[b>>2]|0;g=+n[k+16>>2];c=+n[l+16>>2]-g;h=+n[k+20>>2];d=+n[l+20>>2]-h;i=+n[k+24>>2];e=+n[l+24>>2]-i;l=f[b+8>>2]|0;g=+n[l+16>>2]-g;h=+n[l+20>>2]-h;i=+n[l+24>>2]-i;if((d*i-e*h)*(d*i-e*h)+(e*g-c*i)*(e*g-c*i)+(c*h-d*g)*(c*h-d*g)>0.0){n[b+28>>2]=0.0;l=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=l;f[b+12>>2]=f[a+348+(l<<2)>>2];l=f[b+32>>2]|0;f[b+32>>2]=l+1;Gh(a,d*i-e*h,e*g-c*i,c*h-d*g,f[b+(l<<2)>>2]|0);if(Zc(a)|0){l=1;u=j;return l|0}k=f[a+372>>2]|0;l=(f[k+32>>2]|0)+-1|0;f[k+32>>2]=l;l=f[k+(l<<2)>>2]|0;k=f[a+364>>2]|0;f[a+364>>2]=k+1;f[a+348+(k<<2)>>2]=l;k=f[a+372>>2]|0;n[k+16+(f[k+32>>2]<<2)>>2]=0.0;l=(f[a+364>>2]|0)+-1|0;f[a+364>>2]=l;f[k+(f[k+32>>2]<<2)>>2]=f[a+348+(l<<2)>>2];l=f[k+32>>2]|0;f[k+32>>2]=l+1;Gh(a,-(d*i-e*h),-(e*g-c*i),-(c*h-d*g),f[k+(l<<2)>>2]|0);if(Zc(a)|0){l=1;u=j;return l|0}else{l=f[a+372>>2]|0;k=(f[l+32>>2]|0)+-1|0;f[l+32>>2]=k;k=f[l+(k<<2)>>2]|0;l=f[a+364>>2]|0;f[a+364>>2]=l+1;f[a+348+(l<<2)>>2]=k;break a}}break}case 4:{l=f[b>>2]|0;k=f[b+12>>2]|0;i=+n[k+16>>2];p=+n[l+16>>2]-i;m=+n[k+20>>2];c=+n[l+20>>2]-m;e=+n[k+24>>2];g=+n[l+24>>2]-e;l=f[b+4>>2]|0;d=+n[l+16>>2]-i;h=+n[l+20>>2]-m;o=+n[l+24>>2]-e;l=f[b+8>>2]|0;i=+n[l+16>>2]-i;m=+n[l+20>>2]-m;e=+n[l+24>>2]-e;if(!((0.0!=0.0?1:p*h*e+(c*o*i+g*d*m-p*o*m-c*d*e)-g*h*i!=p*h*e+(c*o*i+g*d*m-p*o*m-c*d*e)-g*h*i)|p*h*e+(c*o*i+g*d*m-p*o*m-c*d*e)-g*h*i==0.0)){l=1;u=j;return l|0}break}default:{}}while(0);l=0;u=j;return l|0}function _c(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;w=u;u=u+64|0;f[w+16>>2]=c;v=w+24+40|0;i=0;c=0;m=0;a:while(1){do if((c|0)>-1)if((i|0)>(2147483647-c|0)){f[6614]=75;c=-1;break}else{c=i+c|0;break}while(0);q=f[w+16>>2]|0;i=b[q>>0]|0;if(!(i<<24>>24)){t=86;break}else j=q;b:while(1){switch(i<<24>>24){case 37:{i=j;t=9;break b}case 0:{i=j;break b}default:{}}s=j+1|0;f[w+16>>2]=s;i=b[s>>0]|0;j=s}c:do if((t|0)==9)while(1){t=0;if((b[j+1>>0]|0)!=37)break c;i=i+1|0;j=j+2|0;f[w+16>>2]=j;if((b[j>>0]|0)!=37)break;else t=9}while(0);i=i-q|0;if(a|0)pz(a,q,i);if(i|0)continue;j=f[w+16>>2]|0;i=b[j+1>>0]|0;if(!(pH(i)|0)){r=-1;i=1}else{s=(b[j+2>>0]|0)==36;r=s?i+-48|0:-1;m=s?1:m;i=s?3:1}k=j+i|0;f[w+16>>2]=k;i=b[k>>0]|0;if(((i<<24>>24)+-32|0)>>>0>31|(1<<(i<<24>>24)+-32&75913|0)==0)j=0;else{j=0;do{j=1<<(i<<24>>24)+-32|j;k=k+1|0;f[w+16>>2]=k;i=b[k>>0]|0}while(!(((i<<24>>24)+-32|0)>>>0>31|(1<<(i<<24>>24)+-32&75913|0)==0))}if(i<<24>>24==42){l=k+1|0;i=b[l>>0]|0;if((pH(i)|0)!=0?(b[k+2>>0]|0)==36:0){f[h+(i+-48<<2)>>2]=10;i=f[g+((b[l>>0]|0)+-48<<3)>>2]|0;m=1;l=k+3|0}else{if(m|0){c=-1;break}if(a|0){m=(f[e>>2]|0)+(4-1)&~(4-1);i=f[m>>2]|0;f[e>>2]=m+4;m=0}else{i=0;m=0}}f[w+16>>2]=l;o=(i|0)<0;s=o?0-i|0:i;j=o?j|8192:j}else{i=gp(w+16|0)|0;if((i|0)<0){c=-1;break}s=i;l=f[w+16>>2]|0}do if((b[l>>0]|0)==46){i=l+1|0;if((b[i>>0]|0)!=42){f[w+16>>2]=i;o=gp(w+16|0)|0;i=f[w+16>>2]|0;break}k=l+2|0;i=b[k>>0]|0;if(pH(i)|0?(b[l+3>>0]|0)==36:0){f[h+(i+-48<<2)>>2]=10;o=f[g+((b[k>>0]|0)+-48<<3)>>2]|0;i=l+4|0;f[w+16>>2]=i;break}if(m|0){c=-1;break a}if(a|0){o=(f[e>>2]|0)+(4-1)&~(4-1);i=f[o>>2]|0;f[e>>2]=o+4}else i=0;f[w+16>>2]=k;o=i;i=k}else{o=-1;i=l}while(0);n=0;while(1){if(((b[i>>0]|0)+-65|0)>>>0>57){c=-1;break a}k=i+1|0;f[w+16>>2]=k;l=b[(b[i>>0]|0)+-65+(19599+(n*58|0))>>0]|0;if(((l&255)+-1|0)>>>0<8){n=l&255;i=k}else break}if(!(l<<24>>24)){c=-1;break}k=(r|0)>-1;do if(l<<24>>24==19)if(k){c=-1;break a}else t=48;else{if(k){f[h+(r<<2)>>2]=l&255;r=g+(r<<3)|0;t=f[r+4>>2]|0;f[w>>2]=f[r>>2];f[w+4>>2]=t;t=48;break}if(!a){c=0;break a}Tg(w,l&255,e)}while(0);if((t|0)==48?(t=0,(a|0)==0):0){i=0;continue}k=b[i>>0]|0;k=(n|0)!=0&(k&15|0)==3?k&-33:k;i=j&-65537;r=(j&8192|0)==0?j:i;d:do switch(k|0){case 110:switch((n&255)<<24>>24){case 0:{f[f[w>>2]>>2]=c;i=0;continue a}case 1:{f[f[w>>2]>>2]=c;i=0;continue a}case 2:{i=f[w>>2]|0;f[i>>2]=c;f[i+4>>2]=((c|0)<0)<<31>>31;i=0;continue a}case 3:{d[f[w>>2]>>1]=c;i=0;continue a}case 4:{b[f[w>>2]>>0]=c;i=0;continue a}case 6:{f[f[w>>2]>>2]=c;i=0;continue a}case 7:{i=f[w>>2]|0;f[i>>2]=c;f[i+4>>2]=((c|0)<0)<<31>>31;i=0;continue a}default:{i=0;continue a}}case 112:{k=120;i=o>>>0>8?o:8;j=r|8;t=60;break}case 88:case 120:{i=o;j=r;t=60;break}case 111:{i=f[w>>2]|0;j=f[w+4>>2]|0;t=cr(i,j,v)|0;q=t;n=0;l=20063;o=(r&8|0)==0|(o|0)>(v-t|0)?o:v-t+1|0;t=66;break}case 105:case 100:{i=f[w>>2]|0;j=f[w+4>>2]|0;if((j|0)<0){i=Tv(0,0,i|0,j|0)|0;j=I;f[w>>2]=i;f[w+4>>2]=j;k=1;l=20063;t=65;break d}else{k=(r&2049|0)!=0&1;l=(r&2048|0)==0?((r&1|0)==0?20063:20065):20064;t=65;break d}}case 117:{k=0;l=20063;i=f[w>>2]|0;j=f[w+4>>2]|0;t=65;break}case 99:{b[w+24+39>>0]=f[w>>2];q=w+24+39|0;n=0;l=20063;k=v;j=1;break}case 109:{j=oH(f[6614]|0)|0;t=70;break}case 115:{j=f[w>>2]|0;j=j|0?j:20073;t=70;break}case 67:{f[w+8>>2]=f[w>>2];f[w+8+4>>2]=0;f[w>>2]=w+8;o=-1;k=w+8|0;t=74;break}case 83:{i=f[w>>2]|0;if(!o){dn(a,32,s,0,r);i=0;t=83}else{k=i;t=74}break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{i=Xc(a,+p[w>>3],s,o,r,k)|0;continue a}default:{n=0;l=20063;k=v;j=o;i=r}}while(0);e:do if((t|0)==60){y=f[w>>2]|0;x=f[w+4>>2]|0;q=$p(y,x,v,k&32)|0;l=(j&8|0)==0|(y|0)==0&(x|0)==0;n=l?0:2;l=l?20063:20063+(k>>4)|0;o=i;r=j;i=y;j=x;t=66}else if((t|0)==65){q=Fm(i,j,v)|0;n=k;t=66}else if((t|0)==70){t=0;y=Mj(j,o)|0;q=j;n=0;l=20063;k=(y|0)==0?j+o|0:y;j=(y|0)==0?o:y-j|0}else if((t|0)==74){t=0;n=k;i=0;j=0;while(1){l=f[n>>2]|0;if(!l)break;j=$z(w+20|0,l)|0;if((j|0)<0|j>>>0>(o-i|0)>>>0)break;i=j+i|0;if(o>>>0>i>>>0)n=n+4|0;else break}if((j|0)<0){c=-1;break a}dn(a,32,s,i,r);if(!i){i=0;t=83}else{l=0;while(1){j=f[k>>2]|0;if(!j){t=83;break e}j=$z(w+20|0,j)|0;l=j+l|0;if((l|0)>(i|0)){t=83;break e}pz(a,w+20|0,j);if(l>>>0>=i>>>0){t=83;break}else k=k+4|0}}}while(0);if((t|0)==66){t=0;j=(i|0)!=0|(j|0)!=0;i=(o|0)!=0|j;j=v-q+((j^1)&1)|0;q=i?q:v;k=v;j=i?((o|0)>(j|0)?o:j):o;i=(o|0)>-1?r&-65537:r}else if((t|0)==83){t=0;dn(a,32,s,i,r^8192);i=(s|0)>(i|0)?s:i;continue}r=k-q|0;o=(j|0)<(r|0)?r:j;x=o+n|0;y=(s|0)<(x|0)?x:s;dn(a,32,y,x,i);pz(a,l,n);dn(a,48,y,x,i^65536);dn(a,48,o,r,0);pz(a,q,r);dn(a,32,y,x,i^8192);i=y}f:do if((t|0)==86)if(!a)if(m){c=1;while(1){i=f[h+(c<<2)>>2]|0;if(!i)break;Tg(g+(c<<3)|0,i,e);i=c+1|0;if((c|0)<9)c=i;else{c=i;break}}if((c|0)<10)while(1){if(f[h+(c<<2)>>2]|0){c=-1;break f}if((c|0)<9)c=c+1|0;else{c=1;break}}else c=1}else c=0;while(0);u=w;return c|0}function $c(a,b){a=a|0;b=+b;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;m=u;u=u+48|0;c=f[a+24>>2]|0;if((c|0)<=0){u=m;return}l=0;a:while(1){k=f[(f[a+32>>2]|0)+(l<<2)>>2]|0;switch(f[k+216>>2]|0){case 2:case 5:break;default:{Td(k,0);d=f[k+732>>2]|0;if((d|0)>0){c=0;do{j=f[k+740>>2]|0;h=f[j+(c*52|0)+12>>2]|0;i=f[j+(c*52|0)+8>>2]|0;y=+n[h+24>>2]-+n[i+24>>2];x=+n[h+28>>2]-+n[i+28>>2];b=+n[h+32>>2]-+n[i+32>>2];n[j+(c*52|0)+36>>2]=y;n[j+(c*52|0)+40>>2]=x;n[j+(c*52|0)+44>>2]=b;n[j+(c*52|0)+48>>2]=0.0;n[j+(c*52|0)+32>>2]=1.0/(+n[j+(c*52|0)+24>>2]*(y*y+x*x+b*b));c=c+1|0}while((c|0)!=(d|0))}e=f[k+792>>2]|0;if((e|0)>0){c=0;b=+n[k+452>>2];do{j=f[k+800>>2]|0;d=j+(c*96|0)+20|0;h=f[d>>2]|0;B=+n[j+(c*96|0)+4>>2];A=+n[j+(c*96|0)+8>>2];y=+n[j+(c*96|0)+12>>2];z=+n[h+4>>2]*B+ +n[h+8>>2]*A+ +n[h+12>>2]*y;x=B*+n[h+20>>2]+A*+n[h+24>>2]+y*+n[h+28>>2];y=B*+n[h+36>>2]+A*+n[h+40>>2]+y*+n[h+44>>2];i=j+(c*96|0)|0;Pf(m,b,+n[(f[i>>2]|0)+88>>2],+n[h+344>>2],h+264|0,z,x,y);h=j+(c*96|0)+28|0;f[h>>2]=f[m>>2];f[h+4>>2]=f[m+4>>2];f[h+8>>2]=f[m+8>>2];f[h+12>>2]=f[m+12>>2];h=j+(c*96|0)+44|0;f[h>>2]=f[m+16>>2];f[h+4>>2]=f[m+16+4>>2];f[h+8>>2]=f[m+16+8>>2];f[h+12>>2]=f[m+16+12>>2];h=j+(c*96|0)+60|0;f[h>>2]=f[m+32>>2];f[h+4>>2]=f[m+32+4>>2];f[h+8>>2]=f[m+32+8>>2];f[h+12>>2]=f[m+32+12>>2];n[j+(c*96|0)+76>>2]=z;n[j+(c*96|0)+80>>2]=x;n[j+(c*96|0)+84>>2]=y;n[j+(c*96|0)+88>>2]=0.0;b=+n[k+452>>2];n[j+(c*96|0)+92>>2]=b*+n[(f[i>>2]|0)+88>>2];d=f[d>>2]|0;if(!(f[d+204>>2]&3)){if((f[d+216>>2]&-2|0)!=4)f[d+216>>2]=1;n[d+220>>2]=0.0}c=c+1|0}while((c|0)!=(e|0))}c=f[k+372>>2]|0;if((c|0)>0){e=0;d=f[k+396>>2]|0;do{if((d|0)>0){c=0;do{Mb[((f[(f[k+404>>2]|0)+(c<<2)>>2]|0)==0?23:0)&31](k,1.0);c=c+1|0;d=f[k+396>>2]|0}while((c|0)<(d|0));c=f[k+372>>2]|0}e=e+1|0}while((e|0)<(c|0));d=f[k+712>>2]|0;if((d|0)>0){c=0;do{j=f[k+720>>2]|0;z=+n[k+452>>2];A=z*+n[j+(c*104|0)+44>>2]+ +n[j+(c*104|0)+28>>2];B=z*+n[j+(c*104|0)+48>>2]+ +n[j+(c*104|0)+32>>2];n[j+(c*104|0)+8>>2]=+n[j+(c*104|0)+40>>2]*z+ +n[j+(c*104|0)+24>>2];n[j+(c*104|0)+12>>2]=A;n[j+(c*104|0)+16>>2]=B;n[j+(c*104|0)+20>>2]=0.0;c=c+1|0}while((c|0)!=(d|0))}}c=f[k+376>>2]|0;if((c|0)>0){g=0;d=f[k+416>>2]|0;do{b=+(g|0)/+(c|0);if((d|0)>0){e=0;do{switch(f[(f[k+424>>2]|0)+(e<<2)>>2]|0){case 1:{c=2;break}case 0:{c=3;break}case 2:{c=4;break}case 3:{c=5;break}default:{w=35;break a}}Nb[c&7](k,1.0,b);e=e+1|0;d=f[k+416>>2]|0}while((e|0)<(d|0));c=f[k+376>>2]|0}g=g+1|0}while((g|0)<(c|0));b=+n[k+456>>2]*(1.0-+n[k+296>>2]);d=f[k+712>>2]|0;if((d|0)>0){c=0;do{j=f[k+720>>2]|0;A=b*(+n[j+(c*104|0)+12>>2]-+n[j+(c*104|0)+28>>2]);B=b*(+n[j+(c*104|0)+16>>2]-+n[j+(c*104|0)+32>>2]);n[j+(c*104|0)+40>>2]=b*(+n[j+(c*104|0)+8>>2]-+n[j+(c*104|0)+24>>2]);n[j+(c*104|0)+44>>2]=A;n[j+(c*104|0)+48>>2]=B;j=j+(c*104|0)+52|0;c=c+1|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[j+16>>2]=0}while((c|0)!=(d|0))}}c=f[k+380>>2]|0;if((c|0)>0){b=+n[k+292>>2]*+n[k+456>>2];d=f[k+712>>2]|0;if((d|0)>0){c=0;do{j=f[k+720>>2]|0;i=j+(c*104|0)+8|0;j=j+(c*104|0)+24|0;f[j>>2]=f[i>>2];f[j+4>>2]=f[i+4>>2];f[j+8>>2]=f[i+8>>2];f[j+12>>2]=f[i+12>>2];c=c+1|0}while((c|0)!=(d|0));c=f[k+380>>2]|0;if((c|0)>0)w=42}else w=42;if((w|0)==42){w=0;g=0;d=f[k+436>>2]|0;do{if((d|0)>0){e=0;do{switch(f[(f[k+444>>2]|0)+(e<<2)>>2]|0){case 1:{c=2;break}case 0:{c=3;break}case 2:{c=4;break}case 3:{c=5;break}default:{w=53;break a}}Nb[c&7](k,1.0,0.0);e=e+1|0;d=f[k+436>>2]|0}while((e|0)<(d|0));c=f[k+380>>2]|0}g=g+1|0}while((g|0)<(c|0))}d=f[k+712>>2]|0;if((d|0)>0){e=f[k+720>>2]|0;c=0;do{A=b*(+n[e+(c*104|0)+12>>2]-+n[e+(c*104|0)+28>>2]);B=b*(+n[e+(c*104|0)+16>>2]-+n[e+(c*104|0)+32>>2]);j=e+(c*104|0)+40|0;n[j>>2]=b*(+n[e+(c*104|0)+8>>2]-+n[e+(c*104|0)+24>>2])+ +n[j>>2];j=e+(c*104|0)+44|0;n[j>>2]=A+ +n[j>>2];j=e+(c*104|0)+48|0;n[j>>2]=B+ +n[j>>2];c=c+1|0}while((c|0)!=(d|0))}}e=f[k+1112>>2]|0;if((e|0)>0){g=f[k+1120>>2]|0;d=0;do{h=f[g+(d<<2)>>2]|0;if(+n[h+352>>2]>0.0?(o=f[h+24>>2]|0,(o|0)>0):0){i=f[h+32>>2]|0;c=0;do{j=f[i+(c<<2)>>2]|0;if(+n[j+88>>2]>0.0?(s=+n[j+24>>2]-+n[h+228>>2],v=+n[j+28>>2]-+n[h+232>>2],q=+n[j+32>>2]-+n[h+236>>2],r=+n[h+336>>2],B=+n[h+340>>2],t=+n[h+332>>2],p=+n[h+316>>2]+(r*q-v*B),q=+n[h+320>>2]+(s*B-q*t),r=v*t-s*r+ +n[h+324>>2],s=+n[j+40>>2],t=+n[j+44>>2],v=+n[j+48>>2],p*p+q*q+r*r<=s*s+t*t+v*v):0){B=+n[h+352>>2];n[j+40>>2]=s+(p-s)*B;n[j+44>>2]=(q-t)*B+t;n[j+48>>2]=(r-v)*B+v}c=c+1|0}while((c|0)!=(o|0))}d=d+1|0}while((d|0)!=(e|0))}Td(k,1);c=f[a+24>>2]|0}}l=l+1|0;if((l|0)>=(c|0)){w=3;break}}if((w|0)==3){u=m;return}}function ad(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0;if((c|0)<=1){x=0;return x|0}w=f[a+712>>2]|0;x=X(w,w)|0;x=$H(x>>>0>1073741823?-1:x<<2)|0;if((w|0)>0){g=0;do{h=X(g,w)|0;e=0;do{p=x+((X(e,w)|0)+g<<2)|0;t=(e|0)==(g|0)?0:2147483647;f[p>>2]=t;f[x+(e+h<<2)>>2]=t;e=e+1|0}while((e|0)!=(w|0));g=g+1|0}while((g|0)!=(w|0))}g=f[a+732>>2]|0;if((g|0)>0){h=f[a+740>>2]|0;i=f[a+720>>2]|0;e=0;do{p=((f[h+(e*52|0)+8>>2]|0)-i|0)/104|0;t=((f[h+(e*52|0)+12>>2]|0)-i|0)/104|0;o=x+((X(t,w)|0)+p<<2)|0;f[o>>2]=1;t=x+((X(p,w)|0)+t<<2)|0;f[t>>2]=1;e=e+1|0}while((e|0)!=(g|0))}do if((c|0)!=2)if((w|0)>0){e=0;do{j=X(e,w)|0;g=0;do{h=g;g=g+1|0;if((g|0)<(w|0)){m=X(h,w)|0;k=x+(m+e<<2)|0;i=g;do{l=(f[k>>2]|0)+(f[x+(i+j<<2)>>2]|0)|0;o=x+(i+m<<2)|0;if((f[o>>2]|0)>>>0>l>>>0){v=x+((X(i,w)|0)+h<<2)|0;f[v>>2]=l;f[o>>2]=l}i=i+1|0}while((i|0)!=(w|0))}}while((g|0)!=(w|0));e=e+1|0}while((e|0)!=(w|0));q=79}else e=0;else{if((w|0)<0)jb();if((w|0)>0){f[6472]=(f[6472]|0)+1;e=sc((w*20|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=0;do{b[e+(g*20|0)+16>>0]=1;f[e+(g*20|0)+12>>2]=0;t=e+(g*20|0)+4|0;f[t>>2]=0;f[e+(g*20|0)+8>>2]=0;f[t>>2]=0;g=g+1|0}while((g|0)!=(w|0));t=e}else t=0;if((f[a+732>>2]|0)>0){m=0;do{l=f[a+740>>2]|0;p=f[a+720>>2]|0;o=((f[l+(m*52|0)+8>>2]|0)-p|0)/104|0;p=((f[l+(m*52|0)+12>>2]|0)-p|0)/104|0;l=t+(o*20|0)+4|0;e=f[l>>2]|0;a:do if((e|0)>0){h=f[t+(o*20|0)+12>>2]|0;g=0;while(1){if((f[h+(g<<2)>>2]|0)==(p|0))break;g=g+1|0;if((g|0)>=(e|0)){q=34;break a}}if((g|0)==(e|0))q=34}else q=34;while(0);if((q|0)==34){q=0;k=t+(o*20|0)+8|0;if((e|0)==(f[k>>2]|0)?(r=e|0?e<<1:1,(e|0)<(r|0)):0){if(!r)j=0;else{f[6472]=(f[6472]|0)+1;e=sc((r<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}j=e;e=f[l>>2]|0}i=t+(o*20|0)+12|0;h=f[i>>2]|0;if((e|0)<=0)if(!h)g=t+(o*20|0)+16|0;else q=44;else{g=0;do{f[j+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));q=44}if((q|0)==44){q=0;e=t+(o*20|0)+16|0;if(b[e>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[i>>2]=0;g=e;e=f[l>>2]|0}b[g>>0]=1;f[i>>2]=j;f[k>>2]=r}f[(f[t+(o*20|0)+12>>2]|0)+(e<<2)>>2]=p;f[l>>2]=(f[l>>2]|0)+1}l=t+(p*20|0)+4|0;e=f[l>>2]|0;b:do if((e|0)>0){h=f[t+(p*20|0)+12>>2]|0;g=0;while(1){if((f[h+(g<<2)>>2]|0)==(o|0))break;g=g+1|0;if((g|0)>=(e|0)){q=54;break b}}if((g|0)==(e|0))q=54}else q=54;while(0);if((q|0)==54){q=0;k=t+(p*20|0)+8|0;if((e|0)==(f[k>>2]|0)?(s=e|0?e<<1:1,(e|0)<(s|0)):0){if(!s)j=0;else{f[6472]=(f[6472]|0)+1;e=sc((s<<2|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}j=e;e=f[l>>2]|0}i=t+(p*20|0)+12|0;h=f[i>>2]|0;if((e|0)<=0)if(!h)g=t+(p*20|0)+16|0;else q=64;else{g=0;do{f[j+(g<<2)>>2]=f[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0));q=64}if((q|0)==64){q=0;e=t+(p*20|0)+16|0;if(b[e>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[i>>2]=0;g=e;e=f[l>>2]|0}b[g>>0]=1;f[i>>2]=j;f[k>>2]=s}f[(f[t+(p*20|0)+12>>2]|0)+(e<<2)>>2]=o;f[l>>2]=(f[l>>2]|0)+1}m=m+1|0}while((m|0)<(f[a+732>>2]|0))}if((w|0)<=0){if(!t){e=0;break}}else{o=0;do{q=t+(o*20|0)+4|0;e=f[q>>2]|0;if((e|0)>0){r=X(o,w)|0;p=f[t+(o*20|0)+12>>2]|0;m=0;do{k=f[p+(m<<2)>>2]|0;l=t+(k*20|0)+4|0;g=f[l>>2]|0;if((g|0)>0){j=x+((X(k,w)|0)+o<<2)|0;i=f[t+(k*20|0)+12>>2]|0;h=0;e=g;do{g=f[i+(h<<2)>>2]|0;if((o|0)!=(g|0)?(v=X(g,w)|0,u=(f[x+(v+k<<2)>>2]|0)+(f[j>>2]|0)|0,v=x+(v+o<<2)|0,(f[v>>2]|0)>>>0>u>>>0):0){f[x+(g+r<<2)>>2]=u;f[v>>2]=u;e=f[l>>2]|0}h=h+1|0}while((h|0)<(e|0));e=f[q>>2]|0}m=m+1|0}while((m|0)<(e|0))}o=o+1|0}while((o|0)!=(w|0));e=0;do{h=t+(e*20|0)+4|0;i=t+(e*20|0)+12|0;j=f[i>>2]|0;g=t+(e*20|0)+16|0;if(j|0){if(b[g>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[j+-4>>2]|0)}f[i>>2]=0}b[g>>0]=1;f[i>>2]=0;f[h>>2]=0;f[t+(e*20|0)+8>>2]=0;e=e+1|0}while((e|0)!=(w|0))}f[6473]=(f[6473]|0)+1;Cd(f[t+-4>>2]|0);q=79}while(0);if((q|0)==79)if((w|0)>0){e=0;j=0;do{h=j;j=j+1|0;if((j|0)<(w|0)){i=X(h,w)|0;g=j;do{if((f[x+(g+i<<2)>>2]|0)==(c|0)){t=f[a+720>>2]|0;_h(a,d);v=(f[a+732>>2]|0)+-1|0;u=f[a+740>>2]|0;f[u+(v*52|0)+8>>2]=t+(g*104|0);f[u+(v*52|0)+12>>2]=t+(h*104|0);A=+n[t+(g*104|0)+8>>2]-+n[t+(h*104|0)+8>>2];z=+n[t+(g*104|0)+12>>2]-+n[t+(h*104|0)+12>>2];y=+n[t+(g*104|0)+16>>2]-+n[t+(h*104|0)+16>>2];y=+L(+(A*A+z*z+y*y));n[u+(v*52|0)+16>>2]=y;b[a+924>>0]=1;v=(f[a+740>>2]|0)+(v*52|0)+20|0;b[v>>0]=b[v>>0]|1;e=e+1|0}g=g+1|0}while((g|0)!=(w|0))}}while((j|0)!=(w|0))}else e=0;aI(x);x=e;return x|0}function bd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;if((b[a+180>>0]|0)==0?(b[a+48>>0]|0)!=0:0){q=+n[a+116>>2];g=+n[d>>2];I=+n[a+132>>2];e=+n[d+4>>2];J=+n[a+148>>2];y=+n[d+8>>2];r=+n[a+120>>2];G=+n[a+136>>2];H=+n[a+152>>2];t=+n[a+124>>2];F=+n[a+140>>2];u=+n[a+156>>2];w=+n[d+16>>2];x=+n[d+20>>2];z=+n[d+24>>2];E=+n[d+32>>2];v=+n[d+36>>2];A=+n[d+40>>2];k=+n[a+164>>2];h=+n[a+168>>2];D=+n[a+172>>2];C=+n[d+48>>2]+(g*k+e*h+y*D);B=w*k+x*h+z*D+ +n[d+52>>2];D=E*k+v*h+A*D+ +n[d+56>>2];n[a+824>>2]=q*g+I*e+J*y;n[a+828>>2]=g*r+e*G+y*H;n[a+832>>2]=g*t+e*F+y*u;n[a+836>>2]=0.0;n[a+840>>2]=q*w+I*x+J*z;n[a+844>>2]=r*w+G*x+H*z;n[a+848>>2]=t*w+F*x+u*z;n[a+852>>2]=0.0;n[a+856>>2]=q*E+I*v+J*A;n[a+860>>2]=r*E+G*v+H*A;n[a+864>>2]=t*E+F*v+u*A;n[a+868>>2]=0.0;n[a+872>>2]=C;n[a+876>>2]=B;n[a+880>>2]=D;n[a+884>>2]=0.0;D=+n[a+52>>2];B=+n[c>>2];C=+n[a+68>>2];A=+n[c+4>>2];u=+n[a+84>>2];v=+n[c+8>>2];F=+n[a+56>>2];E=+n[a+72>>2];t=+n[a+88>>2];H=+n[a+60>>2];G=+n[a+76>>2];r=+n[a+92>>2];J=+n[c+16>>2];I=+n[c+20>>2];q=+n[c+24>>2];z=+n[c+32>>2];x=+n[c+36>>2];w=+n[c+40>>2];y=+n[a+100>>2];e=+n[a+104>>2];g=+n[a+108>>2];i=a+856|0;j=a+840|0;h=J*y+I*e+q*g;k=H*z+G*x+r*w;l=F*z+E*x+t*w;m=D*z+C*x+u*w;o=H*J+G*I+r*q;p=F*J+E*I+t*q;q=D*J+C*I+u*q;r=B*H+A*G+v*r;t=B*F+A*E+v*t;u=D*B+C*A+u*v;v=B*y+A*e+v*g;e=z*y+x*e;g=w*g}else{q=+n[a+52>>2];g=+n[c>>2];x=+n[a+68>>2];e=+n[c+4>>2];w=+n[a+84>>2];H=+n[c+8>>2];r=+n[a+56>>2];z=+n[a+72>>2];y=+n[a+88>>2];t=+n[a+60>>2];A=+n[a+76>>2];u=+n[a+92>>2];J=+n[c+16>>2];I=+n[c+20>>2];G=+n[c+24>>2];B=+n[c+32>>2];v=+n[c+36>>2];F=+n[c+40>>2];k=+n[a+100>>2];h=+n[a+104>>2];C=+n[a+108>>2];D=+n[c+48>>2]+(g*k+e*h+H*C);E=J*k+I*h+G*C+ +n[c+52>>2];C=B*k+v*h+F*C+ +n[c+56>>2];n[a+824>>2]=q*g+x*e+w*H;n[a+828>>2]=g*r+e*z+H*y;n[a+832>>2]=g*t+e*A+H*u;n[a+836>>2]=0.0;n[a+840>>2]=q*J+x*I+w*G;n[a+844>>2]=r*J+z*I+y*G;n[a+848>>2]=t*J+A*I+u*G;n[a+852>>2]=0.0;n[a+856>>2]=q*B+x*v+w*F;n[a+860>>2]=r*B+z*v+y*F;n[a+864>>2]=t*B+A*v+u*F;n[a+868>>2]=0.0;n[a+872>>2]=D;n[a+876>>2]=E;n[a+880>>2]=C;n[a+884>>2]=0.0;C=+n[a+116>>2];E=+n[d>>2];D=+n[a+132>>2];F=+n[d+4>>2];u=+n[a+148>>2];v=+n[d+8>>2];A=+n[a+120>>2];B=+n[a+136>>2];t=+n[a+152>>2];y=+n[a+124>>2];z=+n[a+140>>2];r=+n[a+156>>2];w=+n[d+16>>2];x=+n[d+20>>2];q=+n[d+24>>2];G=+n[d+32>>2];I=+n[d+36>>2];J=+n[d+40>>2];H=+n[a+164>>2];e=+n[a+168>>2];g=+n[a+172>>2];i=a+856|0;j=a+840|0;h=w*H+x*e+q*g;k=y*G+z*I+r*J;l=A*G+B*I+t*J;m=C*G+D*I+u*J;o=y*w+z*x+r*q;p=A*w+B*x+t*q;q=C*w+D*x+u*q;r=E*y+F*z+v*r;t=E*A+F*B+v*t;u=C*E+D*F+u*v;v=E*H+F*e+v*g;c=d;e=G*H+I*e;g=J*g}J=v+ +n[c+48>>2];h=h+ +n[c+52>>2];e=g+e+ +n[c+56>>2];n[a+888>>2]=u;n[a+892>>2]=t;n[a+896>>2]=r;n[a+900>>2]=0.0;n[a+904>>2]=q;n[a+908>>2]=p;n[a+912>>2]=o;n[a+916>>2]=0.0;n[a+920>>2]=m;n[a+924>>2]=l;n[a+928>>2]=k;n[a+932>>2]=0.0;n[a+936>>2]=J;n[a+940>>2]=h;n[a+944>>2]=e;n[a+948>>2]=0.0;f[a+968>>2]=f[a+872>>2];f[a+968+4>>2]=f[a+872+4>>2];f[a+968+8>>2]=f[a+872+8>>2];f[a+968+12>>2]=f[a+872+12>>2];f[a+984>>2]=f[a+936>>2];f[a+984+4>>2]=f[a+936+4>>2];f[a+984+8>>2]=f[a+936+8>>2];f[a+984+12>>2]=f[a+936+12>>2];c=f[a+824>>2]|0;d=f[j>>2]|0;j=f[i>>2]|0;f[a+952>>2]=c;f[a+956>>2]=d;f[a+960>>2]=j;n[a+964>>2]=0.0;e=(f[s>>2]=c,+n[s>>2]);g=(f[s>>2]=d,+n[s>>2]);h=(f[s>>2]=j,+n[s>>2]);if((b[a+180>>0]|0)==0?(b[a+48>>0]|0)==0:0){j=a+984|0;i=a+968|0;H=+n[i>>2];G=+n[j>>2];G=H-G;d=i+4|0;H=+n[d>>2];d=j+4|0;I=+n[d>>2];I=H-I;i=i+8|0;H=+n[i>>2];j=j+8|0;J=+n[j>>2];J=H-J;j=a+1016|0;n[j>>2]=G;j=a+1020|0;n[j>>2]=I;j=a+1024|0;n[j>>2]=J;j=a+1028|0;n[j>>2]=0.0;H=G*e;D=I*g;D=H+D;H=J*h;H=D+H;D=H*e;E=H*g;F=H*h;C=+n[a+968>>2];D=C+D;j=a+972|0;C=+n[j>>2];E=C+E;j=a+976|0;C=+n[j>>2];F=C+F;j=a+1e3|0;n[j>>2]=D;j=a+1004|0;n[j>>2]=E;j=a+1008|0;n[j>>2]=F;j=a+1012|0;n[j>>2]=0.0;j=a+1032|0;n[j>>2]=H;j=a+828|0;i=a+844|0;d=a+860|0;H=+n[j>>2];F=+n[i>>2];E=+n[d>>2];H=H*G;F=F*I;F=H+F;E=E*J;E=F+E;d=a+1036|0;n[d>>2]=E;d=a+832|0;i=a+848|0;j=a+864|0;E=+n[d>>2];F=+n[i>>2];H=+n[j>>2];G=E*G;I=F*I;I=G+I;J=H*J;J=I+J;a=a+1040|0;n[a>>2]=J;return}j=a+968|0;i=a+984|0;H=+n[i>>2];G=+n[j>>2];G=H-G;d=i+4|0;H=+n[d>>2];d=j+4|0;I=+n[d>>2];I=H-I;i=i+8|0;H=+n[i>>2];j=j+8|0;J=+n[j>>2];J=H-J;j=a+1016|0;n[j>>2]=G;j=a+1020|0;n[j>>2]=I;j=a+1024|0;n[j>>2]=J;j=a+1028|0;n[j>>2]=0.0;H=G*e;D=I*g;D=H+D;H=J*h;H=D+H;D=H*e;E=H*g;F=H*h;C=+n[a+968>>2];D=C+D;j=a+972|0;C=+n[j>>2];E=C+E;j=a+976|0;C=+n[j>>2];F=C+F;j=a+1e3|0;n[j>>2]=D;j=a+1004|0;n[j>>2]=E;j=a+1008|0;n[j>>2]=F;j=a+1012|0;n[j>>2]=0.0;j=a+1032|0;n[j>>2]=H;j=a+828|0;i=a+844|0;d=a+860|0;H=+n[j>>2];F=+n[i>>2];E=+n[d>>2];H=H*G;F=F*I;F=H+F;E=E*J;E=F+E;d=a+1036|0;n[d>>2]=E;d=a+832|0;i=a+848|0;j=a+864|0;E=+n[d>>2];F=+n[i>>2];H=+n[j>>2];G=E*G;I=F*I;I=G+I;J=H*J;J=I+J;a=a+1040|0;n[a>>2]=J;return}function cd(a,c){a=a|0;c=+c;var e=0,g=0.0,h=0,i=0.0,j=0.0,k=0,l=0,m=0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0;r=u;u=u+304|0;uj(12298);a:do if((f[a+232>>2]|0)>0){l=r+136+48|0;k=0;while(1){m=f[(f[a+240>>2]|0)+(k<<2)>>2]|0;n[m+244>>2]=1.0;b:do switch(f[m+216>>2]|0){case 2:case 5:break;default:if(!(f[m+204>>2]&3)){Yg(m+4|0,+n[m+312>>2],+n[m+316>>2],+n[m+320>>2],m+328|0,c,r+136|0);g=+n[l>>2]-+n[m+52>>2];i=+n[r+136+52>>2]-+n[m+56>>2];j=+n[r+136+56>>2]-+n[m+60>>2];if(b[a+44>>0]|0?(s=+n[m+252>>2],s*s!=0.0?s*s<g*g+i*i+j*j:0):0){uj(12318);if((f[(f[m+192>>2]|0)+4>>2]|0)<20){f[5853]=(f[5853]|0)+1;e=f[a+68>>2]|0;e=Bb[f[(f[e>>2]|0)+36>>2]&127](e)|0;h=f[a+24>>2]|0;n[r+200+4>>2]=1.0;f[r+200+12>>2]=f[m+52>>2];f[r+200+12+4>>2]=f[m+52+4>>2];f[r+200+12+8>>2]=f[m+52+8>>2];f[r+200+12+12>>2]=f[m+52+12>>2];f[r+200+28>>2]=f[l>>2];f[r+200+28+4>>2]=f[l+4>>2];f[r+200+28+8>>2]=f[l+8>>2];f[r+200+28+12>>2]=f[l+12>>2];f[r+200+76>>2]=0;f[r+200>>2]=4476;f[r+200+80>>2]=m;f[r+200+88>>2]=e;f[r+200+92>>2]=h;h=f[m+248>>2]|0;f[r+80+8>>2]=0;f[r+80+12>>2]=1065353216;f[r+80+16>>2]=1065353216;f[r+80+20>>2]=1065353216;n[r+80+24>>2]=0.0;f[r+80>>2]=6864;f[r+80+4>>2]=8;f[r+80+28>>2]=h;f[r+80+44>>2]=h;f[r+200+84>>2]=f[a+56>>2];h=f[m+188>>2]|0;d[r+200+8>>1]=d[h+4>>1]|0;d[r+200+10>>1]=d[h+6>>1]|0;f[r+16+48>>2]=f[l>>2];f[r+16+48+4>>2]=f[l+4>>2];f[r+16+48+8>>2]=f[l+8>>2];f[r+16+48+12>>2]=f[l+12>>2];f[r+16>>2]=f[m+4>>2];f[r+16+4>>2]=f[m+4+4>>2];f[r+16+8>>2]=f[m+4+8>>2];f[r+16+12>>2]=f[m+4+12>>2];f[r+16+16>>2]=f[m+20>>2];f[r+16+16+4>>2]=f[m+20+4>>2];f[r+16+16+8>>2]=f[m+20+8>>2];f[r+16+16+12>>2]=f[m+20+12>>2];f[r+16+32>>2]=f[m+36>>2];f[r+16+32+4>>2]=f[m+36+4>>2];f[r+16+32+8>>2]=f[m+36+8>>2];f[r+16+32+12>>2]=f[m+36+12>>2];Ld(a,r+80|0,m+4|0,r+16|0,r+200|0,0.0);g=+n[r+200+4>>2];if(g<1.0){n[m+244>>2]=g;Yg(m+4|0,+n[m+312>>2],+n[m+316>>2],+n[m+320>>2],m+328|0,g*c,r+136|0);n[m+244>>2]=0.0;Re(m,r+136|0);e=4}else e=0;if(!e)o=12}else o=12;if((o|0)==12){o=0;e=0}h=f[2405]|0;t=(f[h+16>>2]|0)+-1|0;f[h+16>>2]=t;do if(!t){if(f[h+4>>2]|0){gb(r+200|0,0)|0;t=f[6471]|0;n[h+8>>2]=+n[h+8>>2]+ +(((f[r+200+4>>2]|0)-(f[t+4>>2]|0)+(((f[r+200>>2]|0)-(f[t>>2]|0)|0)*1e6|0)-(f[h+12>>2]|0)|0)>>>0)/1.0e3;if(f[h+16>>2]|0)break;h=f[2405]|0}f[2405]=f[h+20>>2]}while(0);if(e|0)break b}Re(m,r+136|0)}}while(0);k=k+1|0;if((k|0)>=(f[a+232>>2]|0))break a}}while(0);do if(b[a+275>>0]|0){uj(12338);if((f[a+308>>2]|0)>0){m=0;do{o=f[(f[a+316>>2]|0)+(m<<2)>>2]|0;h=f[o+740>>2]|0;h=(f[h+236>>2]&2|0)==0?0:h;l=f[o+744>>2]|0;l=(f[l+236>>2]&2|0)==0?0:l;e=f[o+748>>2]|0;if((e|0)>0)if(!h){h=0;do{g=+n[57]*+n[l+228>>2];if(g>0.0?(p=+n[o+4+(h*184|0)+120>>2],p!=0.0):0){j=g*+n[o+4+(h*184|0)+64>>2]*p;c=g*+n[o+4+(h*184|0)+68>>2]*p;s=g*+n[o+4+(h*184|0)+72>>2]*p;g=+n[o+4+(h*184|0)+36>>2]-+n[l+56>>2];i=+n[o+4+(h*184|0)+40>>2]-+n[l+60>>2];n[r+16>>2]=+n[o+4+(h*184|0)+32>>2]-+n[l+52>>2];n[r+16+4>>2]=g;n[r+16+8>>2]=i;n[r+16+12>>2]=0.0;n[r>>2]=j;n[r+4>>2]=c;n[r+8>>2]=s;n[r+12>>2]=0.0;ll(l,r,r+16|0);e=f[o+748>>2]|0}h=h+1|0}while((h|0)<(e|0))}else{k=0;do{g=+n[h+228>>2]*+n[l+228>>2];if(g>0.0?(q=+n[o+4+(k*184|0)+120>>2],q!=0.0):0){j=g*+n[o+4+(k*184|0)+64>>2]*q;c=g*+n[o+4+(k*184|0)+68>>2]*q;s=g*+n[o+4+(k*184|0)+72>>2]*q;n[r+200>>2]=-j;n[r+200+4>>2]=-c;n[r+200+8>>2]=-s;n[r+200+12>>2]=0.0;i=+n[o+4+(k*184|0)+52>>2]-+n[h+56>>2];g=+n[o+4+(k*184|0)+56>>2]-+n[h+60>>2];n[r+80>>2]=+n[o+4+(k*184|0)+48>>2]-+n[h+52>>2];n[r+80+4>>2]=i;n[r+80+8>>2]=g;n[r+80+12>>2]=0.0;g=+n[o+4+(k*184|0)+36>>2]-+n[l+56>>2];i=+n[o+4+(k*184|0)+40>>2]-+n[l+60>>2];n[r+16>>2]=+n[o+4+(k*184|0)+32>>2]-+n[l+52>>2];n[r+16+4>>2]=g;n[r+16+8>>2]=i;n[r+16+12>>2]=0.0;ll(h,r+200|0,r+80|0);n[r>>2]=j;n[r+4>>2]=c;n[r+8>>2]=s;n[r+12>>2]=0.0;ll(l,r,r+16|0);e=f[o+748>>2]|0}k=k+1|0}while((k|0)<(e|0))}m=m+1|0}while((m|0)<(f[a+308>>2]|0))}e=f[2405]|0;t=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=t;if(!t){if(f[e+4>>2]|0){gb(r+200|0,0)|0;t=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[r+200+4>>2]|0)-(f[t+4>>2]|0)+(((f[r+200>>2]|0)-(f[t>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(f[e+16>>2]|0)break;e=f[2405]|0}f[2405]=f[e+20>>2]}}while(0);e=f[2405]|0;t=(f[e+16>>2]|0)+-1|0;f[e+16>>2]=t;if(t|0){u=r;return}do if(f[e+4>>2]|0){gb(r+200|0,0)|0;t=f[6471]|0;n[e+8>>2]=+n[e+8>>2]+ +(((f[r+200+4>>2]|0)-(f[t+4>>2]|0)+(((f[r+200>>2]|0)-(f[t>>2]|0)|0)*1e6|0)-(f[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(f[e+16>>2]|0)){e=f[2405]|0;break}else{u=r;return}}while(0);f[2405]=f[e+20>>2];u=r;return}function dd(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0.0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,o=0.0,p=0,q=0.0,r=0,t=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,K=0;I=u;u=u+96|0;d=f[a+216>>2]|0;if(+n[d+4>>2]==0.0){H=0;u=I;return H|0}H=f[c>>2]|0;if(!(Db[f[(f[d>>2]|0)+8>>2]&31](d,f[H+188>>2]|0)|0)){H=1;u=I;return H|0}c=f[H+192>>2]|0;G=f[a+216>>2]|0;if((f[c+4>>2]|0)!=32){f[I+32>>2]=0;f[I+32+4>>2]=c;f[I+32+8>>2]=H;f[I+32+12>>2]=H+4;f[I+32+16>>2]=-1;f[I+32+20>>2]=-1;Vc(a+68|0,a+132|0,I+32|0,G);H=1;u=I;return H|0}if((H|0)==0?1:(f[H+236>>2]|0)!=8){H=1;u=I;return H|0}c=f[H+752>>2]|0;if(c)if(!(f[H+988>>2]|0)){c=f[H+988+4>>2]|0;if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[H+988+4>>2]=0;f[H+988+8>>2]=-1;c=f[H+988+32>>2]|0;if(c|0){if(b[H+988+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[H+988+32>>2]=0}b[H+988+36>>0]=1;f[H+988+32>>2]=0;f[H+988+24>>2]=0;f[H+988+28>>2]=0;f[H+988+16>>2]=0;c=f[H+752>>2]|0;if((c|0)>0){r=0;do{k=f[H+760>>2]|0;p=k+(r*44|0)|0;t=f[k+(r*44|0)+8>>2]|0;C=f[k+(r*44|0)+12>>2]|0;c=f[k+(r*44|0)+16>>2]|0;m=+n[t+8>>2];o=+n[t+12>>2];q=+n[t+16>>2];j=+n[t+20>>2];B=+n[C+8>>2];e=B<m?B:m;F=+n[C+12>>2];l=F<o?F:o;E=+n[C+16>>2];g=E<q?E:q;D=+n[C+20>>2];h=D<j?D:j;m=m<B?B:m;o=o<F?F:o;q=q<E?E:q;j=j<D?D:j;D=+n[c+8>>2];e=D<e?D:e;E=+n[c+12>>2];l=E<l?E:l;F=+n[c+16>>2];g=F<g?F:g;B=+n[c+20>>2];h=B<h?B:h;j=j<B?B:j;m=(m<D?D:m)+0.0;o=(o<E?E:o)+0.0;q=(q<F?F:q)+0.0;c=f[H+988+4>>2]|0;if(!c){f[6472]=(f[6472]|0)+1;c=sc(63)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}d=c;i=d+44|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(i|0))}else f[H+988+4>>2]=0;f[c+32>>2]=0;f[c+36>>2]=p;f[c+40>>2]=0;n[c>>2]=e;n[c+4>>2]=l;n[c+8>>2]=g;n[c+12>>2]=h;n[c+16>>2]=m;n[c+20>>2]=o;n[c+24>>2]=q;n[c+28>>2]=j;ff(H+988|0,f[H+988>>2]|0,c);f[H+988+12>>2]=(f[H+988+12>>2]|0)+1;f[k+(r*44|0)+40>>2]=c;r=r+1|0;c=f[H+752>>2]|0}while((r|0)<(c|0));d=H+988|0}else d=H+988|0}else d=H+988|0;else{d=H+988|0;c=0}D=+n[a+180>>2]-+n[a+116>>2];E=+n[a+184>>2]-+n[a+120>>2];F=+n[a+188>>2]-+n[a+124>>2];d=f[d>>2]|0;if(!d)if((c|0)>0){t=f[H+760>>2]|0;r=0;d=0;p=-1;i=1065353216;k=0;g=1.0;e=1.0;do{K=f[t+(r*44|0)+8>>2]|0;J=f[t+(r*44|0)+12>>2]|0;C=f[t+(r*44|0)+16>>2]|0;h=+Ih(a+116|0,D,E,F,+n[K+8>>2],+n[K+12>>2],+n[K+16>>2],+n[J+8>>2],+n[J+12>>2],+n[J+16>>2],+n[C+8>>2],+n[C+12>>2],+n[C+16>>2],g);if(h>0.0){d=d+1|0;p=r;i=(n[s>>2]=h,f[s>>2]|0);k=3;e=h;g=h}r=r+1|0}while((r|0)!=(c|0));c=p}else{d=0;c=-1;i=1065353216;k=0;e=1.0}else{f[I+32>>2]=3364;f[I+32+4>>2]=f[a+116>>2];f[I+32+4+4>>2]=f[a+116+4>>2];f[I+32+4+8>>2]=f[a+116+8>>2];f[I+32+4+12>>2]=f[a+116+12>>2];n[I+32+36>>2]=D;n[I+32+40>>2]=E;n[I+32+44>>2]=F;n[I+32+48>>2]=0.0;f[I+32+20>>2]=f[a+180>>2];f[I+32+20+4>>2]=f[a+180+4>>2];f[I+32+20+8>>2]=f[a+180+8>>2];f[I+32+20+12>>2]=f[a+180+12>>2];f[I+32+52>>2]=1065353216;f[I+32+56>>2]=0;f[I+32+60>>2]=0;Ie(d,a+116|0,a+180|0,I+32|0);c=f[I+32+56>>2]|0;if(!c){d=0;c=-1;i=1065353216;k=0;e=1.0}else{K=f[I+32+52>>2]|0;d=1;c=(c-(f[H+760>>2]|0)|0)/44|0;i=K;k=3;e=(f[s>>2]=K,+n[s>>2])}}t=f[H+772>>2]|0;if((t|0)>0){C=f[H+780>>2]|0;r=0;do{K=f[C+(r*104|0)+8>>2]|0;x=+n[K+8>>2];z=+n[K+12>>2];B=+n[K+16>>2];K=f[C+(r*104|0)+12>>2]|0;l=+n[K+8>>2];o=+n[K+12>>2];v=+n[K+16>>2];K=f[C+(r*104|0)+16>>2]|0;w=+n[K+8>>2];y=+n[K+12>>2];A=+n[K+16>>2];g=(f[s>>2]=i,+n[s>>2]);h=+Ih(a+116|0,D,E,F,x,z,B,l,o,v,w,y,A,g);if(h>0.0){d=d+1|0;c=r;i=(n[s>>2]=h,f[s>>2]|0);k=4;g=h;e=h}K=f[C+(r*104|0)+20>>2]|0;j=+n[K+8>>2];m=+n[K+12>>2];q=+n[K+16>>2];h=+Ih(a+116|0,D,E,F,x,z,B,l,o,v,j,m,q,g);if(h>0.0){d=d+1|0;c=r;p=(n[s>>2]=h,f[s>>2]|0);k=4;g=h;e=h}else{p=i;g=(f[s>>2]=i,+n[s>>2])}h=+Ih(a+116|0,D,E,F,l,o,v,w,y,A,j,m,q,g);if(h>0.0){d=d+1|0;c=r;i=(n[s>>2]=h,f[s>>2]|0);k=4;g=h;e=h}else{i=p;g=(f[s>>2]=p,+n[s>>2])}g=+Ih(a+116|0,D,E,F,x,z,B,w,y,A,j,m,q,g);if(g>0.0){d=d+1|0;c=r;i=(n[s>>2]=g,f[s>>2]|0);k=4;e=g}r=r+1|0}while((r|0)!=(t|0));i=k;o=e}else{i=k;o=e}if(!d){K=1;u=I;return K|0}if(!(o<=+n[G+4>>2])){K=1;u=I;return K|0}f[I+32>>2]=0;f[I+32+4>>2]=c;j=+n[a+180>>2]-+n[a+116>>2];l=+n[a+184>>2]-+n[a+120>>2];m=+n[a+188>>2]-+n[a+124>>2];e=1.0/+L(+(j*j+l*l+m*m));if((i|0)==3){d=f[H+748+12>>2]|0;e=+n[d+(c*44|0)+20>>2];h=+n[d+(c*44|0)+24>>2];g=+n[d+(c*44|0)+28>>2];if(j*e+l*h+m*g>0.0){j=-e;h=-h;g=-g;e=0.0}else{j=e;e=+n[d+(c*44|0)+32>>2]}}else{j=-(j*e);h=-(l*e);g=-(m*e);e=0.0}f[I>>2]=H;f[I+4>>2]=I+32;n[I+8>>2]=j;n[I+12>>2]=h;n[I+16>>2]=g;n[I+20>>2]=e;n[I+24>>2]=o;+ub[f[(f[G>>2]|0)+12>>2]&15](G,I,1);K=1;u=I;return K|0}function ed(a,c,d){a=a|0;c=c|0;d=+d;var e=0,g=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0,o=0,p=0.0,q=0,r=0;r=u;u=u+112|0;i=f[a+716>>2]|0;if((i|0)==(f[a+712>>2]|0)){a:do if(i){h=f[a+720>>2]|0;if((i|0)>0){e=0;g=h;while(1){g=f[g+(e*104|0)+96>>2]|0;if(g|0)f[g+36>>2]=e;e=e+1|0;if((e|0)==(i|0)){j=h;break a}g=f[a+720>>2]|0}}else j=h}else j=0;while(0);g=f[a+732>>2]|0;if((g|0)>0){e=0;do{o=(f[a+740>>2]|0)+(e*52|0)+8|0;f[o>>2]=((f[o>>2]|0)-j|0)/104|0;o=(f[a+740>>2]|0)+(e*52|0)+12|0;f[o>>2]=((f[o>>2]|0)-j|0)/104|0;e=e+1|0}while((e|0)!=(g|0))}g=f[a+752>>2]|0;if((g|0)>0){e=0;do{h=(f[a+760>>2]|0)+(e*44|0)+8|0;f[h>>2]=((f[h>>2]|0)-j|0)/104|0;h=(f[a+760>>2]|0)+(e*44|0)+12|0;f[h>>2]=((f[h>>2]|0)-j|0)/104|0;h=(f[a+760>>2]|0)+(e*44|0)+16|0;f[h>>2]=((f[h>>2]|0)-j|0)/104|0;h=f[(f[a+760>>2]|0)+(e*44|0)+40>>2]|0;if(h|0)f[h+36>>2]=e;e=e+1|0}while((e|0)!=(g|0))}g=f[a+792>>2]|0;if((g|0)>0){h=f[a+800>>2]|0;e=0;do{o=h+(e*96|0)|0;f[o>>2]=((f[o>>2]|0)-j|0)/104|0;e=e+1|0}while((e|0)!=(g|0))}i=f[a+692>>2]|0;if((i|0)>0){h=0;e=f[a+700>>2]|0;do{if((f[e+(h*60|0)+24>>2]|0)>0){g=0;do{e=e+(h*60|0)+28+(g<<2)|0;f[e>>2]=((f[e>>2]|0)-j|0)/104|0;g=g+1|0;e=f[a+700>>2]|0}while((g|0)<(f[e+(h*60|0)+24>>2]|0))}h=h+1|0}while((h|0)!=(i|0))}i=f[a+712>>2]|0;if((f[a+716>>2]|0)<(i<<1|1|0)){f[6472]=(f[6472]|0)+1;e=sc(((i<<1|1)*104|3)+16|0)|0;if(!e)h=0;else{f[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}g=f[a+712>>2]|0;if((g|0)>0){e=0;do{m=h+(e*104|0)|0;j=(f[a+720>>2]|0)+(e*104|0)|0;o=m+104|0;do{f[m>>2]=f[j>>2];m=m+4|0;j=j+4|0}while((m|0)<(o|0));e=e+1|0}while((e|0)!=(g|0))}e=f[a+720>>2]|0;if(e|0){if(b[a+724>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+720>>2]=0}b[a+724>>0]=1;f[a+720>>2]=h;f[a+716>>2]=i<<1|1;i=f[a+712>>2]|0}b:do if(i){j=f[a+720>>2]|0;if((i|0)>0){e=0;g=j;while(1){h=f[g+(e*104|0)+96>>2]|0;if(h|0)f[h+36>>2]=g+(e*104|0);e=e+1|0;if((e|0)==(i|0))break b;g=f[a+720>>2]|0}}}else j=0;while(0);g=f[a+732>>2]|0;if((g|0)>0){e=0;do{o=(f[a+740>>2]|0)+(e*52|0)+8|0;f[o>>2]=j+((f[o>>2]|0)*104|0);o=(f[a+740>>2]|0)+(e*52|0)+12|0;f[o>>2]=j+((f[o>>2]|0)*104|0);e=e+1|0}while((e|0)!=(g|0))}g=f[a+752>>2]|0;if((g|0)>0){e=0;do{h=(f[a+760>>2]|0)+(e*44|0)+8|0;f[h>>2]=j+((f[h>>2]|0)*104|0);h=(f[a+760>>2]|0)+(e*44|0)+12|0;f[h>>2]=j+((f[h>>2]|0)*104|0);h=(f[a+760>>2]|0)+(e*44|0)+16|0;f[h>>2]=j+((f[h>>2]|0)*104|0);h=f[a+760>>2]|0;i=f[h+(e*44|0)+40>>2]|0;if(i|0)f[i+36>>2]=h+(e*44|0);e=e+1|0}while((e|0)!=(g|0))}h=f[a+792>>2]|0;if((h|0)>0){g=f[a+800>>2]|0;e=0;do{o=g+(e*96|0)|0;f[o>>2]=j+((f[o>>2]|0)*104|0);e=e+1|0}while((e|0)!=(h|0))}i=f[a+692>>2]|0;if((i|0)>0){h=0;e=f[a+700>>2]|0;do{if((f[e+(h*60|0)+24>>2]|0)>0){g=0;do{e=e+(h*60|0)+28+(g<<2)|0;f[e>>2]=j+((f[e>>2]|0)*104|0);g=g+1|0;e=f[a+700>>2]|0}while((g|0)<(f[e+(h*60|0)+24>>2]|0))}h=h+1|0}while((h|0)!=(i|0))}}m=f[a+192>>2]|0;p=+rb[f[(f[m>>2]|0)+48>>2]&15](m);m=r;o=m+100|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(o|0));e=f[a+712>>2]|0;if((e|0)==(f[a+716>>2]|0)?(q=e|0?e<<1:1,(e|0)<(q|0)):0){if(!q)h=0;else{f[6472]=(f[6472]|0)+1;e=sc((q*104|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=e;e=f[a+712>>2]|0}if((e|0)>0){g=0;do{m=h+(g*104|0)|0;j=(f[a+720>>2]|0)+(g*104|0)|0;o=m+104|0;do{f[m>>2]=f[j>>2];m=m+4|0;j=j+4|0}while((m|0)<(o|0));g=g+1|0}while((g|0)!=(e|0))}e=f[a+720>>2]|0;if(e|0){if(b[a+724>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+720>>2]=0}b[a+724>>0]=1;f[a+720>>2]=h;f[a+716>>2]=q;e=f[a+712>>2]|0}m=f[a+720>>2]|0;f[m+(e*104|0)>>2]=0;m=m+(e*104|0)+4|0;j=r;o=m+100|0;do{f[m>>2]=f[j>>2];m=m+4|0;j=j+4|0}while((m|0)<(o|0));g=f[a+712>>2]|0;f[a+712>>2]=g+1;h=f[a+720>>2]|0;m=h+(g*104|0)|0;o=m+104|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(o|0));f[h+(g*104|0)+8>>2]=f[c>>2];f[h+(g*104|0)+8+4>>2]=f[c+4>>2];f[h+(g*104|0)+8+8>>2]=f[c+8>>2];f[h+(g*104|0)+8+12>>2]=f[c+12>>2];Kp(h+(g*104|0)+24|0,c|0,16)|0;n[h+(g*104|0)+88>>2]=d>0.0?1.0/d:0.0;f[h+(g*104|0)+4>>2]=f[f[a+880>>2]>>2];d=+n[h+(g*104|0)+8>>2];k=+n[h+(g*104|0)+12>>2];l=+n[h+(g*104|0)+16>>2];e=f[a+932>>2]|0;if(e|0){f[a+932>>2]=0;c=e;q=c+32|0;f[q>>2]=0;q=c+36|0;f[q>>2]=h+(g*104|0);q=c+40|0;f[q>>2]=0;n[c>>2]=d-p;q=c+4|0;n[q>>2]=k-p;q=c+8|0;n[q>>2]=l-p;q=c+12|0;n[q>>2]=0.0;q=c+16|0;n[q>>2]=p+d;q=c+20|0;n[q>>2]=p+k;q=c+24|0;n[q>>2]=p+l;q=c+28|0;n[q>>2]=0.0;q=f[a+928>>2]|0;ff(a+928|0,q,c);a=a+940|0;q=f[a>>2]|0;q=q+1|0;f[a>>2]=q;a=h+(g*104|0)+96|0;f[a>>2]=c;u=r;return}f[6472]=(f[6472]|0)+1;e=sc(63)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}m=e;o=m+44|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(o|0));c=e;q=c+32|0;f[q>>2]=0;q=c+36|0;f[q>>2]=h+(g*104|0);q=c+40|0;f[q>>2]=0;n[c>>2]=d-p;q=c+4|0;n[q>>2]=k-p;q=c+8|0;n[q>>2]=l-p;q=c+12|0;n[q>>2]=0.0;q=c+16|0;n[q>>2]=p+d;q=c+20|0;n[q>>2]=p+k;q=c+24|0;n[q>>2]=p+l;q=c+28|0;n[q>>2]=0.0;q=f[a+928>>2]|0;ff(a+928|0,q,c);a=a+940|0;q=f[a>>2]|0;q=q+1|0;f[a>>2]=q;a=h+(g*104|0)+96|0;f[a>>2]=c;u=r;return}function fd(a,c,d,e,g,h,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;H=u;u=u+32|0;f[H+16>>2]=h;f[H+16+4>>2]=i;f[H+16+8>>2]=j;f[H>>2]=d;f[H+4>>2]=e;f[H+8>>2]=g;if(!(+n[c+52>>2]<+n[a+12>>2])){k=0;u=H;return k|0}w=+n[c+36>>2];y=+n[c+40>>2];x=+n[c+44>>2];j=f[c+48>>2]|0;z=1.0/+L(+(w*w+y*y+x*x));g=ti(H)|0;A=+n[c+4>>2]-+n[g+48>>2];B=+n[c+8>>2]-+n[g+52>>2];C=+n[c+12>>2]-+n[g+56>>2];g=ti(H+16|0)|0;D=+n[c+20>>2]-+n[g+48>>2];E=+n[c+24>>2]-+n[g+52>>2];F=+n[c+28>>2]-+n[g+56>>2];if(!e)if(!d){o=0.0;r=0.0;p=0.0;l=0.0;m=0.0;q=0.0}else{q=+n[d+336>>2];m=+n[d+340>>2];v=+n[d+332>>2];o=+n[d+316>>2];r=+n[d+320>>2];p=+n[d+324>>2];l=C*q-B*m;m=A*m-C*v;q=B*v-A*q}else{q=+n[e+332>>2];m=+n[e+336>>2];v=+n[e+328>>2];o=+n[e+312>>2];r=+n[e+316>>2];p=+n[e+320>>2];l=C*q-B*m;m=A*m-C*v;q=B*v-A*q}v=o+l;t=r+m;s=p+q;if(!i)if(!h){q=0.0;r=0.0;l=0.0;m=0.0;o=0.0;p=0.0}else{p=+n[h+336>>2];o=+n[h+340>>2];I=+n[h+332>>2];q=+n[h+316>>2];r=+n[h+320>>2];l=+n[h+324>>2];m=F*p-E*o;o=D*o-F*I;p=E*I-D*p}else{p=+n[i+332>>2];o=+n[i+336>>2];I=+n[i+328>>2];q=+n[i+312>>2];r=+n[i+316>>2];l=+n[i+320>>2];m=F*p-E*o;o=D*o-F*I;p=E*I-D*p}q=v-(q+m);t=t-(r+o);s=s-(l+p);v=x*z*s+(y*z*t+w*z*q);I=+n[c+52>>2]-+n[a+12>>2];f[k+4>>2]=f[H>>2];f[k+4+4>>2]=f[H+4>>2];f[k+4+8>>2]=f[H+8>>2];f[k+16>>2]=f[H+16>>2];f[k+16+4>>2]=f[H+16+4>>2];f[k+16+8>>2]=f[H+16+8>>2];c=ti(H)|0;r=A*+n[c+4>>2]+B*+n[c+20>>2]+C*+n[c+36>>2];p=A*+n[c+8>>2]+B*+n[c+24>>2]+C*+n[c+40>>2];n[k+28>>2]=A*+n[c>>2]+B*+n[c+16>>2]+C*+n[c+32>>2];n[k+32>>2]=r;n[k+36>>2]=p;n[k+40>>2]=0.0;c=ti(H+16|0)|0;p=D*+n[c+4>>2]+E*+n[c+20>>2]+F*+n[c+36>>2];r=D*+n[c+8>>2]+E*+n[c+24>>2]+F*+n[c+40>>2];n[k+44>>2]=D*+n[c>>2]+E*+n[c+16>>2]+F*+n[c+32>>2];n[k+48>>2]=p;n[k+52>>2]=r;n[k+56>>2]=0.0;n[k+164>>2]=A;n[k+168>>2]=B;n[k+172>>2]=C;n[k+176>>2]=0.0;n[k+180>>2]=D;n[k+184>>2]=E;n[k+188>>2]=F;n[k+192>>2]=0.0;n[k+60>>2]=1.0;n[k+64>>2]=1.0;f[k+156>>2]=0;f[k+160>>2]=0;n[k+68>>2]=1.0;n[k+72>>2]=w*z*I;n[k+76>>2]=y*z*I;n[k+80>>2]=x*z*I;n[k+84>>2]=0.0;n[k+196>>2]=w*z;n[k+200>>2]=y*z;n[k+204>>2]=x*z;f[k+208>>2]=j;b[k+152>>0]=0;I=+n[a+16>>2];n[k+212>>2]=(s-x*z*v)*(s-x*z*v)+((q-w*z*v)*(q-w*z*v)+(t-y*z*v)*(t-y*z*v))<I*v*v*I?1.0:I;j=f[H+4>>2]|0;if(!j){j=f[H>>2]|0;if(!j)m=0.0;else{j=j+128|0;G=14}}else{j=j+344|0;G=14}if((G|0)==14)m=+n[j>>2];if((b[22704]|0)==0?fz(22704)|0:0){j=23168;g=j+48|0;do{f[j>>2]=0;j=j+4|0}while((j|0)<(g|0))}j=f[H+4>>2]|0;if(!j){d=f[H>>2]|0;d=(d|0)==0?23168:d+180|0}else d=j+264|0;j=f[H+16+4>>2]|0;if(!j){j=f[H+16>>2]|0;if(!j)l=0.0;else{j=j+128|0;G=25}}else{j=j+344|0;G=25}if((G|0)==25)l=+n[j>>2];if((b[22704]|0)==0?fz(22704)|0:0){j=23168;g=j+48|0;do{f[j>>2]=0;j=j+4|0}while((j|0)<(g|0))}j=f[H+16+4>>2]|0;if(!j){j=f[H+16>>2]|0;j=(j|0)==0?23168:j+180|0}else j=j+264|0;W=+n[k+172>>2];O=+n[k+168>>2];N=+n[k+164>>2];V=+n[d>>2];U=+n[d+16>>2];T=+n[d+32>>2];S=+n[d+4>>2];R=+n[d+20>>2];Q=+n[d+36>>2];P=+n[d+8>>2];M=+n[d+24>>2];K=+n[d+40>>2];B=+n[k+188>>2];v=+n[k+184>>2];w=+n[k+180>>2];J=+n[j>>2];o=+n[j+16>>2];p=+n[j+32>>2];q=+n[j+4>>2];r=+n[j+20>>2];s=+n[j+36>>2];t=+n[j+8>>2];I=+n[j+24>>2];x=+n[j+40>>2];D=m-((V*0.0+U*-W+O*T)*0.0+W*(S*0.0+R*-W+O*Q)+(P*0.0+M*-W+O*K)*-O)+(l-((J*0.0+o*-B+v*p)*0.0+B*(q*0.0+r*-B+v*s)+(t*0.0+I*-B+v*x)*-v));F=0.0-((V*0.0+U*-W+O*T)*-W+(S*0.0+R*-W+O*Q)*0.0+N*(P*0.0+M*-W+O*K))+(0.0-((J*0.0+o*-B+v*p)*-B+(q*0.0+r*-B+v*s)*0.0+w*(t*0.0+I*-B+v*x)));y=0.0-(O*(V*0.0+U*-W+O*T)+(S*0.0+R*-W+O*Q)*-N+(P*0.0+M*-W+O*K)*0.0)+(0.0-(v*(J*0.0+o*-B+v*p)+(q*0.0+r*-B+v*s)*-w+(t*0.0+I*-B+v*x)*0.0));E=0.0-((W*V+U*0.0+T*-N)*0.0+W*(W*S+R*0.0+Q*-N)+(W*P+M*0.0+K*-N)*-O)+(0.0-((B*J+o*0.0+p*-w)*0.0+B*(B*q+r*0.0+s*-w)+(B*t+I*0.0+x*-w)*-v));C=m-((W*V+U*0.0+T*-N)*-W+(W*S+R*0.0+Q*-N)*0.0+N*(W*P+M*0.0+K*-N))+(l-((B*J+o*0.0+p*-w)*-B+(B*q+r*0.0+s*-w)*0.0+w*(B*t+I*0.0+x*-w)));z=0.0-(O*(W*V+U*0.0+T*-N)+(W*S+R*0.0+Q*-N)*-N+(W*P+M*0.0+K*-N)*0.0)+(0.0-(v*(B*J+o*0.0+p*-w)+(B*q+r*0.0+s*-w)*-w+(B*t+I*0.0+x*-w)*0.0));A=0.0-((V*-O+N*U+T*0.0)*0.0+W*(S*-O+N*R+Q*0.0)+(P*-O+N*M+K*0.0)*-O)+(0.0-((J*-v+w*o+p*0.0)*0.0+B*(q*-v+w*r+s*0.0)+(t*-v+w*I+x*0.0)*-v));B=0.0-((V*-O+N*U+T*0.0)*-W+(S*-O+N*R+Q*0.0)*0.0+N*(P*-O+N*M+K*0.0))+(0.0-((J*-v+w*o+p*0.0)*-B+(q*-v+w*r+s*0.0)*0.0+w*(t*-v+w*I+x*0.0)));x=m-(O*(V*-O+N*U+T*0.0)+(S*-O+N*R+Q*0.0)*-N+(P*-O+N*M+K*0.0)*0.0)+(l-(v*(J*-v+w*o+p*0.0)+(q*-v+w*r+s*0.0)*-w+(t*-v+w*I+x*0.0)*0.0));I=1.0/(y*(B*E-C*A)+(D*(C*x-z*B)+F*(z*A-x*E)));n[k+104>>2]=(C*x-z*B)*I;n[k+108>>2]=(B*y-x*F)*I;n[k+112>>2]=(z*F-C*y)*I;n[k+116>>2]=0.0;n[k+120>>2]=(z*A-x*E)*I;n[k+124>>2]=(x*D-A*y)*I;n[k+128>>2]=(E*y-z*D)*I;n[k+132>>2]=0.0;n[k+136>>2]=(B*E-C*A)*I;n[k+140>>2]=(A*F-B*D)*I;n[k+144>>2]=(C*D-E*F)*I;n[k+148>>2]=0.0;k=1;u=H;return k|0}function gd(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;q=u;u=u+224|0;o=(b[a+28>>0]|0)!=0;m=o?d:c;o=o?c:d;p=f[m+4>>2]|0;if((f[p+68>>2]|0)!=(f[a+40>>2]|0)){i=f[a+12>>2]|0;if((i|0)>0){h=0;do{j=f[(f[a+20>>2]|0)+(h<<2)>>2]|0;if(j|0){Lb[f[f[j>>2]>>2]&511](j);k=f[a+4>>2]|0;Rb[f[(f[k>>2]|0)+60>>2]&127](k,f[(f[a+20>>2]|0)+(h<<2)>>2]|0)}h=h+1|0}while((h|0)!=(i|0))}eh(a,c,d)}k=f[p+64>>2]|0;j=f[a+4>>2]|0;h=f[a+20>>2]|0;c=f[a+32>>2]|0;f[q+192>>2]=6384;f[q+192+4>>2]=m;f[q+192+8>>2]=o;f[q+192+12>>2]=j;f[q+192+16>>2]=e;f[q+192+20>>2]=g;f[q+192+24>>2]=h;f[q+192+28>>2]=c;b[q+128+16>>0]=1;e=q+128+12|0;f[e>>2]=0;f[q+128+4>>2]=0;f[q+128+8>>2]=0;c=f[a+12>>2]|0;if((c|0)>0){j=0;while(1){h=f[h+(j<<2)>>2]|0;if(h){Rb[f[(f[h>>2]|0)+16>>2]&127](h,q+128|0);h=f[q+128+4>>2]|0;if((h|0)>0){i=0;do{d=f[(f[e>>2]|0)+(i<<2)>>2]|0;if(f[d+748>>2]|0){f[g+4>>2]=d;h=f[d+740>>2]|0;c=f[(f[g+8>>2]|0)+8>>2]|0;if((h|0)==(c|0))df(d,h+4|0,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0);else df(d,(f[(f[g+12>>2]|0)+8>>2]|0)+4|0,c+4|0);f[g+4>>2]=0;h=f[q+128+4>>2]|0}i=i+1|0}while((i|0)<(h|0))}if((h|0)<0){if((f[q+128+8>>2]|0)<0){c=f[e>>2]|0;if(c|0){if(b[q+128+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[e>>2]=0}b[q+128+16>>0]=1;f[e>>2]=0;f[q+128+8>>2]=0}do{f[(f[e>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=0)}f[q+128+4>>2]=0;c=f[a+12>>2]|0}h=j+1|0;if((h|0)>=(c|0))break;j=h;h=f[a+20>>2]|0}h=f[e>>2]|0;if(h|0){if(b[q+128+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[e>>2]=0}}if(!k){c=f[a+12>>2]|0;if((c|0)>0){h=0;do{Se(q+192|0,f[(f[p+24>>2]|0)+(h*80|0)+64>>2]|0,h);h=h+1|0}while((h|0)<(c|0));l=38}}else{l=f[m+12>>2]|0;G=+n[l>>2];F=+n[l+16>>2];E=+n[l+32>>2];D=+n[l+4>>2];C=+n[l+20>>2];B=+n[l+36>>2];x=+n[l+8>>2];v=+n[l+24>>2];s=+n[l+40>>2];A=-+n[l+48>>2];z=-+n[l+52>>2];y=-+n[l+56>>2];l=f[o+12>>2]|0;P=+n[l>>2];O=+n[l+16>>2];N=+n[l+32>>2];M=+n[l+4>>2];L=+n[l+20>>2];K=+n[l+36>>2];J=+n[l+8>>2];I=+n[l+24>>2];H=+n[l+40>>2];w=+n[l+48>>2];t=+n[l+52>>2];r=+n[l+56>>2];n[q+48>>2]=G*P+F*O+E*N;n[q+48+4>>2]=G*M+F*L+E*K;n[q+48+8>>2]=G*J+F*I+E*H;n[q+48+12>>2]=0.0;n[q+48+16>>2]=D*P+C*O+B*N;n[q+48+20>>2]=D*M+C*L+B*K;n[q+48+24>>2]=D*J+C*I+B*H;n[q+48+28>>2]=0.0;n[q+48+32>>2]=x*P+v*O+s*N;n[q+48+36>>2]=x*M+v*L+s*K;n[q+48+40>>2]=x*J+v*I+s*H;n[q+48+44>>2]=0.0;n[q+48+48>>2]=G*A+F*z+E*y+(G*w+F*t+E*r);n[q+48+52>>2]=D*A+C*z+B*y+(D*w+C*t+B*r);n[q+48+56>>2]=x*A+v*z+s*y+(x*w+v*t+s*r);n[q+48+60>>2]=0.0;l=f[o+4>>2]|0;Yb[f[(f[l>>2]|0)+8>>2]&127](l,q+48|0,q+128|0,q+112|0);f[q+16>>2]=f[q+128>>2];f[q+16+4>>2]=f[q+128+4>>2];f[q+16+8>>2]=f[q+128+8>>2];f[q+16+12>>2]=f[q+128+12>>2];f[q+16+16>>2]=f[q+112>>2];f[q+16+16+4>>2]=f[q+112+4>>2];f[q+16+16+8>>2]=f[q+112+8>>2];f[q+16+16+12>>2]=f[q+112+12>>2];jf(f[k>>2]|0,q+16|0,q+192|0);l=38}if((l|0)==38)c=f[a+12>>2]|0;if((c|0)<=0){u=q;return}d=0;do{do if(f[(f[a+20>>2]|0)+(d<<2)>>2]|0){k=f[p+24>>2]|0;l=f[k+(d*80|0)+64>>2]|0;g=f[m+12>>2]|0;v=+n[g>>2];w=+n[g+4>>2];x=+n[g+8>>2];y=+n[g+16>>2];z=+n[g+20>>2];A=+n[g+24>>2];H=+n[g+32>>2];J=+n[g+36>>2];L=+n[g+40>>2];B=+n[k+(d*80|0)>>2];C=+n[k+(d*80|0)+16>>2];D=+n[k+(d*80|0)+32>>2];E=+n[k+(d*80|0)+4>>2];F=+n[k+(d*80|0)+20>>2];G=+n[k+(d*80|0)+36>>2];I=+n[k+(d*80|0)+8>>2];K=+n[k+(d*80|0)+24>>2];M=+n[k+(d*80|0)+40>>2];s=+n[k+(d*80|0)+48>>2];t=+n[k+(d*80|0)+52>>2];P=+n[k+(d*80|0)+56>>2];N=+n[g+48>>2]+(v*s+w*t+x*P);O=+n[g+52>>2]+(y*s+z*t+A*P);P=+n[g+56>>2]+(H*s+J*t+L*P);n[q+128>>2]=v*B+w*C+x*D;n[q+128+4>>2]=v*E+w*F+x*G;n[q+128+8>>2]=v*I+w*K+x*M;n[q+128+12>>2]=0.0;n[q+128+16>>2]=y*B+z*C+A*D;n[q+128+20>>2]=y*E+z*F+A*G;n[q+128+24>>2]=y*I+z*K+A*M;n[q+128+28>>2]=0.0;n[q+128+32>>2]=H*B+J*C+L*D;n[q+128+36>>2]=H*E+J*F+L*G;n[q+128+40>>2]=H*I+J*K+L*M;n[q+128+44>>2]=0.0;n[q+128+48>>2]=N;n[q+128+52>>2]=O;n[q+128+56>>2]=P;n[q+128+60>>2]=0.0;Yb[f[(f[l>>2]|0)+8>>2]&127](l,q+128|0,q+112|0,q+48|0);l=f[o+4>>2]|0;Yb[f[(f[l>>2]|0)+8>>2]&127](l,f[o+12>>2]|0,q+16|0,q);if(!(+n[q+112>>2]>+n[q>>2])?!(+n[q+48>>2]<+n[q+16>>2]):0)h=1;else h=0;if(!(!(+n[q+112+8>>2]>+n[q+8>>2])?!(+n[q+48+8>>2]<+n[q+16+8>>2]):0))h=0;if(!(+n[q+112+4>>2]>+n[q+4>>2])?!(+n[q+48+4>>2]<+n[q+16+4>>2]|h^1):0)break;l=f[(f[a+20>>2]|0)+(d<<2)>>2]|0;Lb[f[f[l>>2]>>2]&511](l);l=f[a+4>>2]|0;Rb[f[(f[l>>2]|0)+60>>2]&127](l,f[(f[a+20>>2]|0)+(d<<2)>>2]|0);f[(f[a+20>>2]|0)+(d<<2)>>2]=0}while(0);d=d+1|0}while((d|0)<(c|0));u=q;return}function hd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,i=0.0,k=0,l=0,m=0.0,o=0.0,q=0,r=0,s=0,t=0;l=u;u=u+80|0;k=Bb[f[(f[a>>2]|0)+28>>2]&127](a)|0;e=+n[a+4>>2];g=+n[a+8>>2];i=+n[a+12>>2];if((k|0)<=0){u=l;return}d=0;do{fc[f[(f[a>>2]|0)+16>>2]&3](a,l+76|0,l+52|0,l+64|0,l+56|0,l+72|0,l+68|0,l+48|0,l+60|0,d);a:do switch(f[l+64>>2]|0){case 0:{switch(f[l+60>>2]|0){case 2:{if((f[l+48>>2]|0)>0)c=0;else break a;do{q=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;s=f[l+76>>2]|0;r=f[l+56>>2]|0;t=s+(X(r,f[q>>2]|0)|0)|0;o=g*+n[t+4>>2];m=i*+n[t+8>>2];n[l>>2]=e*+n[t>>2];n[l+4>>2]=o;n[l+8>>2]=m;n[l+12>>2]=0.0;t=s+(X(r,f[q+4>>2]|0)|0)|0;m=g*+n[t+4>>2];o=i*+n[t+8>>2];n[l+16>>2]=e*+n[t>>2];n[l+20>>2]=m;n[l+24>>2]=o;n[l+28>>2]=0.0;q=s+(X(r,f[q+8>>2]|0)|0)|0;o=g*+n[q+4>>2];m=i*+n[q+8>>2];n[l+32>>2]=e*+n[q>>2];n[l+36>>2]=o;n[l+40>>2]=m;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}case 3:{if((f[l+48>>2]|0)>0)c=0;else break a;do{t=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;r=f[l+76>>2]|0;s=f[l+56>>2]|0;q=r+(X(s,j[t>>1]|0)|0)|0;m=g*+n[q+4>>2];o=i*+n[q+8>>2];n[l>>2]=e*+n[q>>2];n[l+4>>2]=m;n[l+8>>2]=o;n[l+12>>2]=0.0;q=r+(X(s,j[t+2>>1]|0)|0)|0;o=g*+n[q+4>>2];m=i*+n[q+8>>2];n[l+16>>2]=e*+n[q>>2];n[l+20>>2]=o;n[l+24>>2]=m;n[l+28>>2]=0.0;t=r+(X(s,j[t+4>>1]|0)|0)|0;m=g*+n[t+4>>2];o=i*+n[t+8>>2];n[l+32>>2]=e*+n[t>>2];n[l+36>>2]=m;n[l+40>>2]=o;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}case 5:{if((f[l+48>>2]|0)>0)c=0;else break a;do{t=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;r=f[l+76>>2]|0;s=f[l+56>>2]|0;q=r+(X(s,h[t>>0]|0)|0)|0;m=g*+n[q+4>>2];o=i*+n[q+8>>2];n[l>>2]=e*+n[q>>2];n[l+4>>2]=m;n[l+8>>2]=o;n[l+12>>2]=0.0;q=r+(X(s,h[t+1>>0]|0)|0)|0;o=g*+n[q+4>>2];m=i*+n[q+8>>2];n[l+16>>2]=e*+n[q>>2];n[l+20>>2]=o;n[l+24>>2]=m;n[l+28>>2]=0.0;t=r+(X(s,h[t+2>>0]|0)|0)|0;m=g*+n[t+4>>2];o=i*+n[t+8>>2];n[l+32>>2]=e*+n[t>>2];n[l+36>>2]=m;n[l+40>>2]=o;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}default:break a}break}case 1:{switch(f[l+60>>2]|0){case 2:{if((f[l+48>>2]|0)>0)c=0;else break a;do{t=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;r=f[l+76>>2]|0;s=f[l+56>>2]|0;q=r+(X(s,f[t>>2]|0)|0)|0;m=g*+p[q+8>>3];o=i*+p[q+16>>3];n[l>>2]=e*+p[q>>3];n[l+4>>2]=m;n[l+8>>2]=o;n[l+12>>2]=0.0;q=r+(X(s,f[t+4>>2]|0)|0)|0;o=g*+p[q+8>>3];m=i*+p[q+16>>3];n[l+16>>2]=e*+p[q>>3];n[l+20>>2]=o;n[l+24>>2]=m;n[l+28>>2]=0.0;t=r+(X(s,f[t+8>>2]|0)|0)|0;m=g*+p[t+8>>3];o=i*+p[t+16>>3];n[l+32>>2]=e*+p[t>>3];n[l+36>>2]=m;n[l+40>>2]=o;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}case 3:{if((f[l+48>>2]|0)>0)c=0;else break a;do{t=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;r=f[l+76>>2]|0;s=f[l+56>>2]|0;q=r+(X(s,j[t>>1]|0)|0)|0;m=g*+p[q+8>>3];o=i*+p[q+16>>3];n[l>>2]=e*+p[q>>3];n[l+4>>2]=m;n[l+8>>2]=o;n[l+12>>2]=0.0;q=r+(X(s,j[t+2>>1]|0)|0)|0;o=g*+p[q+8>>3];m=i*+p[q+16>>3];n[l+16>>2]=e*+p[q>>3];n[l+20>>2]=o;n[l+24>>2]=m;n[l+28>>2]=0.0;t=r+(X(s,j[t+4>>1]|0)|0)|0;m=g*+p[t+8>>3];o=i*+p[t+16>>3];n[l+32>>2]=e*+p[t>>3];n[l+36>>2]=m;n[l+40>>2]=o;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}case 5:{if((f[l+48>>2]|0)>0)c=0;else break a;do{t=(f[l+72>>2]|0)+(X(f[l+68>>2]|0,c)|0)|0;r=f[l+76>>2]|0;s=f[l+56>>2]|0;q=r+(X(s,h[t>>0]|0)|0)|0;m=g*+p[q+8>>3];o=i*+p[q+16>>3];n[l>>2]=e*+p[q>>3];n[l+4>>2]=m;n[l+8>>2]=o;n[l+12>>2]=0.0;q=r+(X(s,h[t+1>>0]|0)|0)|0;o=g*+p[q+8>>3];m=i*+p[q+16>>3];n[l+16>>2]=e*+p[q>>3];n[l+20>>2]=o;n[l+24>>2]=m;n[l+28>>2]=0.0;t=r+(X(s,h[t+2>>0]|0)|0)|0;m=g*+p[t+8>>3];o=i*+p[t+16>>3];n[l+32>>2]=e*+p[t>>3];n[l+36>>2]=m;n[l+40>>2]=o;n[l+44>>2]=0.0;Yb[f[(f[b>>2]|0)+8>>2]&127](b,l,d,c);c=c+1|0}while((c|0)<(f[l+48>>2]|0));break}default:break a}break}default:{}}while(0);Rb[f[(f[a>>2]|0)+24>>2]&127](a,d);d=d+1|0}while((d|0)!=(k|0));u=l;return}function id(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,L=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;f[b>>2]=f[a>>2];f[b+4>>2]=f[a+4>>2];f[b+8>>2]=f[a+8>>2];f[b+12>>2]=f[a+12>>2];f[b+16>>2]=f[a+16>>2];f[b+16+4>>2]=f[a+16+4>>2];f[b+16+8>>2]=f[a+16+8>>2];f[b+16+12>>2]=f[a+16+12>>2];f[b+32>>2]=f[a+32>>2];f[b+32+4>>2]=f[a+32+4>>2];f[b+32+8>>2]=f[a+32+8>>2];f[b+32+12>>2]=f[a+32+12>>2];q=+n[a+20>>2];l=+n[a+40>>2];r=+n[a+24>>2];m=+n[a+36>>2];o=+n[a+32>>2];s=+n[a+16>>2];t=+n[a>>2];p=+n[a+4>>2];u=+n[a+8>>2];v=1.0/((q*l-r*m)*t+p*(r*o-l*s)+(m*s-q*o)*u);n[c>>2]=(q*l-r*m)*v;n[c+4>>2]=(m*u-l*p)*v;n[c+8>>2]=(r*p-q*u)*v;n[c+12>>2]=0.0;n[c+16>>2]=(r*o-l*s)*v;n[c+20>>2]=(l*t-o*u)*v;n[c+24>>2]=(s*u-r*t)*v;n[c+28>>2]=0.0;n[c+32>>2]=(m*s-q*o)*v;n[c+36>>2]=(o*p-m*t)*v;n[c+40>>2]=(q*t-s*p)*v;n[c+44>>2]=0.0;a:do if(!(f[5825]|0)){d=b+20|0;e=b+36|0;g=b+8|0;h=b+24|0;i=b+40|0;j=b;k=b+4|0}else{d=0;C=(q*t-s*p)*v;D=(q*l-r*m)*v;E=(r*o-l*s)*v;F=(m*s-q*o)*v;G=(m*u-l*p)*v;B=(l*t-o*u)*v;A=(o*p-m*t)*v;z=(r*p-q*u)*v;y=(s*u-r*t)*v;while(1){o=+K(+D);m=+K(+E);N=+K(+F);W=+K(+G);O=+K(+B);L=+K(+A);Q=+K(+z);P=+K(+y);w=+K(+C);R=o+m+N>W+O+L?o+m+N:W+O+L;O=o+W+Q>m+O+P?o+W+Q:m+O+P;m=+n[b>>2];W=+K(+m);o=+n[b+16>>2];T=+K(+o);p=+n[b+32>>2];I=+K(+p);q=+n[b+4>>2];V=+K(+q);r=+n[b+20>>2];S=+K(+r);s=+n[b+36>>2];H=+K(+s);t=+n[b+8>>2];U=+K(+t);u=+n[b+24>>2];J=+K(+u);v=+n[b+40>>2];x=+K(+v);l=W+T+I>V+S+H?W+T+I:V+S+H;l=l>U+J+x?l:U+J+x;J=W+V+U>T+S+J?W+V+U:T+S+J;w=(R>Q+P+w?R:Q+P+w)*(O>N+L+w?O:N+L+w);x=l*(J>I+H+x?J:I+H+x);if(w<1.1920928955078125e-07|x<1.1920928955078125e-07){d=b+20|0;e=b+36|0;g=b+8|0;h=b+24|0;i=b+40|0;j=b;k=b+4|0;break a}W=+M(+(w/x),.25);O=(m*(W+-2.0)+1.0/W*D)*.5;Q=(q*(W+-2.0)+1.0/W*E)*.5;S=(t*(W+-2.0)+1.0/W*F)*.5;P=(o*(W+-2.0)+1.0/W*G)*.5;R=(r*(W+-2.0)+1.0/W*B)*.5;T=(u*(W+-2.0)+1.0/W*A)*.5;U=(p*(W+-2.0)+1.0/W*z)*.5;V=(s*(W+-2.0)+1.0/W*y)*.5;W=(v*(W+-2.0)+1.0/W*C)*.5;n[b>>2]=m+O;n[b+4>>2]=q+Q;n[b+8>>2]=t+S;n[b+12>>2]=0.0;n[b+16>>2]=o+P;n[b+20>>2]=r+R;n[b+24>>2]=u+T;n[b+28>>2]=0.0;n[b+32>>2]=p+U;n[b+36>>2]=s+V;n[b+40>>2]=v+W;n[b+44>>2]=0.0;N=1.0/(((v+W)*(r+R)-(u+T)*(s+V))*(m+O)+(q+Q)*((u+T)*(p+U)-(v+W)*(o+P))+((s+V)*(o+P)-(r+R)*(p+U))*(t+S));D=((v+W)*(r+R)-(u+T)*(s+V))*N;G=((s+V)*(t+S)-(v+W)*(q+Q))*N;z=((u+T)*(q+Q)-(r+R)*(t+S))*N;E=((u+T)*(p+U)-(v+W)*(o+P))*N;B=((v+W)*(m+O)-(p+U)*(t+S))*N;y=((o+P)*(t+S)-(u+T)*(m+O))*N;F=((s+V)*(o+P)-(r+R)*(p+U))*N;A=((p+U)*(q+Q)-(s+V)*(m+O))*N;C=((r+R)*(m+O)-(o+P)*(q+Q))*N;n[c>>2]=D;n[c+4>>2]=G;n[c+8>>2]=z;n[c+12>>2]=0.0;n[c+16>>2]=E;n[c+20>>2]=B;n[c+24>>2]=y;n[c+28>>2]=0.0;n[c+32>>2]=F;n[c+36>>2]=A;n[c+40>>2]=C;n[c+44>>2]=0.0;U=+K(+O)+ +K(+P)+ +K(+U);V=+K(+Q)+ +K(+R)+ +K(+V);W=+K(+S)+ +K(+T)+ +K(+W);V=U>V?U:V;if((V>W?V:W)<=l*+n[5824])break;d=d+1|0;if(d>>>0>=(f[5825]|0)>>>0){d=b+20|0;e=b+36|0;g=b+8|0;h=b+24|0;i=b+40|0;j=b;k=b+4|0;break a}}L=+n[b>>2];O=+n[b+16>>2];Q=+n[b+32>>2];F=+n[b+4>>2];H=+n[b+20>>2];J=+n[b+36>>2];A=+n[b+8>>2];C=+n[b+24>>2];E=+n[b+40>>2];N=+n[a>>2];P=+n[a+16>>2];R=+n[a+32>>2];G=+n[a+4>>2];I=+n[a+20>>2];T=+n[a+36>>2];B=+n[a+8>>2];D=+n[a+24>>2];W=+n[a+40>>2];V=A*G+C*I+E*T+(F*B+H*D+J*W);S=F*N+H*P+J*R+(L*G+O*I+Q*T);U=A*N+C*P+E*R+(L*B+O*D+Q*W);W=A*B+C*D+E*W+(A*B+C*D+E*W);T=F*G+H*I+J*T+(F*G+H*I+J*T);R=L*N+O*P+Q*R+(L*N+O*P+Q*R);S=S*.5;U=U*.5;V=V*.5;R=R*.5;n[c>>2]=R;n[c+4>>2]=S;n[c+8>>2]=U;n[c+12>>2]=0.0;n[c+16>>2]=S;T=T*.5;n[c+20>>2]=T;n[c+24>>2]=V;n[c+28>>2]=0.0;n[c+32>>2]=U;n[c+36>>2]=V;W=W*.5;n[c+40>>2]=W;n[c+44>>2]=0.0;return}while(0);L=+n[j>>2];O=+n[b+16>>2];Q=+n[b+32>>2];F=+n[k>>2];H=+n[d>>2];J=+n[e>>2];A=+n[g>>2];C=+n[h>>2];E=+n[i>>2];N=+n[a>>2];P=+n[a+16>>2];R=+n[a+32>>2];G=+n[a+4>>2];I=+n[a+20>>2];T=+n[a+36>>2];B=+n[a+8>>2];D=+n[a+24>>2];W=+n[a+40>>2];V=A*G+C*I+E*T+(F*B+H*D+J*W);S=F*N+H*P+J*R+(L*G+O*I+Q*T);U=A*N+C*P+E*R+(L*B+O*D+Q*W);W=A*B+C*D+E*W+(A*B+C*D+E*W);T=F*G+H*I+J*T+(F*G+H*I+J*T);R=L*N+O*P+Q*R+(L*N+O*P+Q*R);S=S*.5;U=U*.5;V=V*.5;R=R*.5;n[c>>2]=R;n[c+4>>2]=S;n[c+8>>2]=U;n[c+12>>2]=0.0;n[c+16>>2]=S;T=T*.5;n[c+20>>2]=T;n[c+24>>2]=V;n[c+28>>2]=0.0;n[c+32>>2]=U;n[c+36>>2]=V;W=W*.5;n[c+40>>2]=W;n[c+44>>2]=0.0;return}function jd(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0.0,j=0,k=0.0,l=0.0,m=0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,v=0.0,w=0.0,x=0;x=u;u=u+128|0;b[a+60>>0]=e&1;if(e){t=+n[g>>2]+-1.0;v=+n[g+4>>2]+-1.0;w=+n[g+8>>2]+-1.0;n[a+4>>2]=t;n[a+8>>2]=v;n[a+12>>2]=w;n[a+16>>2]=0.0;q=+n[h>>2]+1.0;k=+n[h+4>>2]+1.0;i=+n[h+8>>2]+1.0;n[a+20>>2]=q;n[a+24>>2]=k;n[a+28>>2]=i;n[a+32>>2]=0.0;n[a+36>>2]=65533.0/(q-t);n[a+40>>2]=65533.0/(k-v);n[a+44>>2]=65533.0/(i-w);n[a+48>>2]=0.0;b[a+60>>0]=1;l=t+ +(~~((t-t)*(65533.0/(q-t)))&65535&-2&65535)/(65533.0/(q-t))+-1.0;p=v+ +(~~((v-v)*(65533.0/(k-v)))&65535&-2&65535)/(65533.0/(k-v))+-1.0;s=w+ +(~~((w-w)*(65533.0/(i-w)))&65535&-2&65535)/(65533.0/(i-w))+-1.0;if(l<t)n[a+4>>2]=l;else l=t;if(p<v)n[a+8>>2]=p;else p=v;if(s<w)n[a+12>>2]=s;else s=w;t=l+ +((~~((q-l)*(65533.0/(q-t))+1.0)&65535|1)&65535)/(65533.0/(q-t))+1.0;v=p+ +((~~((k-p)*(65533.0/(k-v))+1.0)&65535|1)&65535)/(65533.0/(k-v))+1.0;w=s+ +((~~((i-s)*(65533.0/(i-w))+1.0)&65535|1)&65535)/(65533.0/(i-w))+1.0;if(q<t){n[a+20>>2]=t;q=t}if(k<v){n[a+24>>2]=v;k=v}if(i<w){n[a+28>>2]=w;i=w}n[a+36>>2]=65533.0/(q-l);n[a+40>>2]=65533.0/(k-p);n[a+44>>2]=65533.0/(i-s);n[a+48>>2]=0.0;f[x+96>>2]=8212;f[x+96+4>>2]=a+104;f[x+96+8>>2]=a;Yb[f[(f[c>>2]|0)+8>>2]&127](c,x+96|0,a+4|0,a+20|0);e=f[a+108>>2]|0;f[x+80>>2]=0;f[x+80+4>>2]=0;f[x+80+8>>2]=0;f[x+80+12>>2]=0;j=f[a+128>>2]|0;if((j|0)<(e<<1|0)){if((f[a+132>>2]|0)<(e<<1|0)){if(!e){g=0;c=j}else{f[6472]=(f[6472]|0)+1;g=sc(e<<5|19)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}c=f[a+128>>2]|0}if((c|0)>0){h=0;do{r=g+(h<<4)|0;o=(f[a+136>>2]|0)+(h<<4)|0;f[r>>2]=f[o>>2];f[r+4>>2]=f[o+4>>2];f[r+8>>2]=f[o+8>>2];f[r+12>>2]=f[o+12>>2];h=h+1|0}while((h|0)!=(c|0))}h=f[a+136>>2]|0;if(h|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=g;f[a+132>>2]=e<<1;h=a+136|0}else h=a+136|0;g=j;do{r=(f[h>>2]|0)+(g<<4)|0;f[r>>2]=f[x+80>>2];f[r+4>>2]=f[x+80+4>>2];f[r+8>>2]=f[x+80+8>>2];f[r+12>>2]=f[x+80+12>>2];g=g+1|0}while((g|0)!=(e<<1|0))}f[a+128>>2]=e<<1}else{f[x+96>>2]=8232;f[x+96+4>>2]=a+64;f[x+80>>2]=-581039253;f[x+80+4>>2]=-581039253;f[x+80+8>>2]=-581039253;n[x+80+12>>2]=0.0;f[x+64>>2]=1566444395;f[x+64+4>>2]=1566444395;f[x+64+8>>2]=1566444395;n[x+64+12>>2]=0.0;Yb[f[(f[c>>2]|0)+8>>2]&127](c,x+96|0,x+80|0,x+64|0);e=f[a+68>>2]|0;j=x;o=j+64|0;do{f[j>>2]=0;j=j+4|0}while((j|0)<(o|0));r=f[a+88>>2]|0;if((r|0)<(e<<1|0)){if((f[a+92>>2]|0)<(e<<1|0)){if(!e){g=0;c=r}else{f[6472]=(f[6472]|0)+1;g=sc(e<<7|19)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}c=f[a+88>>2]|0}if((c|0)>0){h=0;do{j=g+(h<<6)|0;m=(f[a+96>>2]|0)+(h<<6)|0;o=j+64|0;do{f[j>>2]=f[m>>2];j=j+4|0;m=m+4|0}while((j|0)<(o|0));h=h+1|0}while((h|0)!=(c|0))}h=f[a+96>>2]|0;if(h|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=g;f[a+92>>2]=e<<1;h=a+96|0}else h=a+96|0;g=r;do{j=(f[h>>2]|0)+(g<<6)|0;m=x;o=j+64|0;do{f[j>>2]=f[m>>2];j=j+4|0;m=m+4|0}while((j|0)<(o|0));g=g+1|0}while((g|0)!=(e<<1|0))}f[a+88>>2]=e<<1}f[a+56>>2]=0;Dc(a,0,e);if(b[a+60>>0]|0?(f[a+152>>2]|0)==0:0){if(!(f[a+156>>2]|0)){f[6472]=(f[6472]|0)+1;e=sc(51)|0;if(!e)c=0;else{f[(e+4+15&-16)+-4>>2]=e;c=e+4+15&-16}g=f[a+152>>2]|0;if((g|0)>0){e=0;do{r=c+(e<<5)|0;o=(f[a+160>>2]|0)+(e<<5)|0;f[r>>2]=f[o>>2];f[r+4>>2]=f[o+4>>2];f[r+8>>2]=f[o+8>>2];f[r+12>>2]=f[o+12>>2];f[r+16>>2]=f[o+16>>2];f[r+20>>2]=f[o+20>>2];f[r+24>>2]=f[o+24>>2];f[r+28>>2]=f[o+28>>2];e=e+1|0}while((e|0)!=(g|0))}e=f[a+160>>2]|0;if(e|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=c;f[a+156>>2]=1;g=a+160|0;h=(f[a+152>>2]|0)+1|0;e=c}else{g=a+160|0;h=1;e=f[a+160>>2]|0}f[a+152>>2]=h;f[e>>2]=f[x+96>>2];f[e+4>>2]=f[x+96+4>>2];f[e+8>>2]=f[x+96+8>>2];f[e+12>>2]=f[x+96+12>>2];f[e+16>>2]=f[x+96+16>>2];f[e+20>>2]=f[x+96+20>>2];f[e+24>>2]=f[x+96+24>>2];f[e+28>>2]=f[x+96+28>>2];r=f[g>>2]|0;o=f[a+136>>2]|0;d[r>>1]=d[o>>1]|0;d[r+2>>1]=d[o+2>>1]|0;d[r+4>>1]=d[o+4>>1]|0;d[r+6>>1]=d[o+6>>1]|0;d[r+8>>1]=d[o+8>>1]|0;d[r+10>>1]=d[o+10>>1]|0;f[r+12>>2]=0;o=f[o+12>>2]|0;f[r+16>>2]=(o|0)>-1?1:0-o|0}f[a+168>>2]=f[a+152>>2];e=f[a+116>>2]|0;if(e|0){if(b[a+120>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+116>>2]=0}b[a+120>>0]=1;f[a+116>>2]=0;f[a+108>>2]=0;f[a+112>>2]=0;e=f[a+76>>2]|0;if(!e){b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;a=a+72|0;f[a>>2]=0;u=x;return}if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[a+76>>2]=0;b[a+80>>0]=1;f[a+76>>2]=0;f[a+68>>2]=0;a=a+72|0;f[a>>2]=0;u=x;return}function kd(a,c,d,e,g,h,i,j,k,l,m){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0,G=0;if((i|0)<2|(j|0)<2){l=0;return l|0}y=X(j,i)|0;f[6472]=(f[6472]|0)+1;a=sc(y>>>0>268435455?18:(y<<4|3)+16|0)|0;if(!a)q=0;else{f[(a+4+15&-16)+-4>>2]=a;q=a+4+15&-16}s=$H(y>>>0>1073741823?-1:y<<2)|0;if((j|0)>0?(i|0)>0:0){a=0;do{D=+(a|0)/+(j+-1|0);r=+n[d>>2];r=r+D*(+n[g>>2]-r);t=+n[d+4>>2];t=t+D*(+n[g+4>>2]-t);u=+n[d+8>>2];u=u+D*(+n[g+8>>2]-u);v=+n[e>>2];w=+n[e+4>>2];x=+n[e+8>>2];v=v+D*(+n[h>>2]-v)-r;w=w+D*(+n[h+4>>2]-w)-t;x=x+D*(+n[h+8>>2]-x)-u;p=X(a,i)|0;o=0;do{D=+(o|0)/+(i+-1|0);C=o+p|0;n[q+(C<<4)>>2]=r+v*D;n[q+(C<<4)+4>>2]=t+w*D;n[q+(C<<4)+8>>2]=u+x*D;n[q+(C<<4)+12>>2]=0.0;n[s+(C<<2)>>2]=1.0;o=o+1|0}while((o|0)!=(i|0));a=a+1|0}while((a|0)!=(j|0))}f[6472]=(f[6472]|0)+1;a=sc(1271)|0;if(!a)a=0;else{f[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}Bc(a,c,y,q,s);if(k&1|0){n[(f[a+720>>2]|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&2|0){n[(f[a+720>>2]|0)+((i+-1|0)*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&4|0){C=X(j+-1|0,i)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&8|0){C=i+-1+(X(j+-1|0,i)|0)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&16|0){n[(f[a+720>>2]|0)+(((i+-1|0)/2|0)*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&32|0){C=X((j+-1|0)/2|0,i)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&64|0){C=i+-1+(X((j+-1|0)/2|0,i)|0)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&128|0){C=(X(j+-1|0,i)|0)+((i+-1|0)/2|0)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&256|0){C=(X((j+-1|0)/2|0,i)|0)+((i+-1|0)/2|0)|0;n[(f[a+720>>2]|0)+(C*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(q|0){f[6473]=(f[6473]|0)+1;Cd(f[q+-4>>2]|0)}aI(s);if((j|0)<=0){l=a;return l|0}c=a+720|0;k=a+732|0;z=a+740|0;A=a+924|0;o=0;y=0;B=i+-1|0;C=(i<<1)+-1|0;while(1){p=y;y=y+1|0;a:do if((i|0)>0){h=X(p,i)|0;g=X(y,i)|0;t=1.0/+(j+-1|0)*+(j+-1-p|0);r=1.0/+(j+-1|0)*+(j+-2-p|0);if((y|0)<(j|0)){p=0;q=o}else{p=0;while(1){q=p;p=p+1|0;if((p|0)<(i|0)){s=p+h|0;d=f[c>>2]|0;_h(a,0);g=(f[k>>2]|0)+-1|0;e=f[z>>2]|0;f[e+(g*52|0)+8>>2]=d+((q+h|0)*104|0);f[e+(g*52|0)+12>>2]=d+(s*104|0);w=+n[d+((q+h|0)*104|0)+8>>2]-+n[d+(s*104|0)+8>>2];x=+n[d+((q+h|0)*104|0)+12>>2]-+n[d+(s*104|0)+12>>2];D=+n[d+((q+h|0)*104|0)+16>>2]-+n[d+(s*104|0)+16>>2];D=+L(+(w*w+x*x+D*D));n[e+(g*52|0)+16>>2]=D;b[A>>0]=1}if((p|0)==(i|0))break a}}while(1){d=p+1|0;s=p+h|0;e=p+g|0;if((p|0)==(i+-1|0))break;F=f[c>>2]|0;_h(a,0);G=(f[k>>2]|0)+-1|0;E=f[z>>2]|0;f[E+(G*52|0)+8>>2]=F+(s*104|0);f[E+(G*52|0)+12>>2]=F+((d+h|0)*104|0);D=+n[F+(s*104|0)+8>>2]-+n[F+((d+h|0)*104|0)+8>>2];x=+n[F+(s*104|0)+12>>2]-+n[F+((d+h|0)*104|0)+12>>2];w=+n[F+(s*104|0)+16>>2]-+n[F+((d+h|0)*104|0)+16>>2];w=+L(+(D*D+x*x+w*w));n[E+(G*52|0)+16>>2]=w;b[A>>0]=1;G=f[c>>2]|0;_h(a,0);E=(f[k>>2]|0)+-1|0;F=f[z>>2]|0;f[F+(E*52|0)+8>>2]=G+(s*104|0);f[F+(E*52|0)+12>>2]=G+(e*104|0);w=+n[G+(s*104|0)+8>>2]-+n[G+(e*104|0)+8>>2];x=+n[G+(s*104|0)+12>>2]-+n[G+(e*104|0)+12>>2];D=+n[G+(s*104|0)+16>>2]-+n[G+(e*104|0)+16>>2];D=+L(+(w*w+x*x+D*D));n[F+(E*52|0)+16>>2]=D;b[A>>0]=1;$f(a,s,e,d+g|0,0);if(!m)$f(a,d+g|0,d+h|0,s,0);else{D=1.0/+(i+-1|0)*+(p|0);n[m+(q<<2)>>2]=D;n[m+(q+1<<2)>>2]=t;n[m+(q+2<<2)>>2]=D;n[m+(q+3<<2)>>2]=r;x=1.0/+(i+-1|0)*+(d|0);n[m+(q+4<<2)>>2]=x;n[m+(q+5<<2)>>2]=r;$f(a,d+g|0,d+h|0,s,0);n[m+(q+6<<2)>>2]=x;n[m+(q+7<<2)>>2]=r;n[m+(q+8<<2)>>2]=x;n[m+(q+9<<2)>>2]=t;n[m+(q+10<<2)>>2]=D;n[m+(q+11<<2)>>2]=t}if(l){E=f[c>>2]|0;_h(a,0);G=(f[k>>2]|0)+-1|0;F=f[z>>2]|0;f[F+(G*52|0)+8>>2]=E+(s*104|0);f[F+(G*52|0)+12>>2]=E+((d+g|0)*104|0);w=+n[E+(s*104|0)+8>>2]-+n[E+((d+g|0)*104|0)+8>>2];x=+n[E+(s*104|0)+12>>2]-+n[E+((d+g|0)*104|0)+12>>2];D=+n[E+(s*104|0)+16>>2]-+n[E+((d+g|0)*104|0)+16>>2];D=+L(+(w*w+x*x+D*D));n[F+(G*52|0)+16>>2]=D;b[A>>0]=1}p=d;q=q+12|0}E=f[c>>2]|0;_h(a,0);G=(f[k>>2]|0)+-1|0;F=f[z>>2]|0;f[F+(G*52|0)+8>>2]=E+(B*104|0);f[F+(G*52|0)+12>>2]=E+(C*104|0);w=+n[E+(B*104|0)+8>>2]-+n[E+(C*104|0)+8>>2];x=+n[E+(B*104|0)+12>>2]-+n[E+(C*104|0)+12>>2];D=+n[E+(B*104|0)+16>>2]-+n[E+(C*104|0)+16>>2];D=+L(+(w*w+x*x+D*D));n[F+(G*52|0)+16>>2]=D;b[A>>0]=1;o=(i*12|0)+-12+o|0}while(0);if((y|0)==(j|0))break;else{B=B+i|0;C=C+i|0}}return a|0}function ld(a,c,d,e,g,h,i,j,k,l,m){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=+k;l=+l;m=+m;var o=0,p=0,q=0,r=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0.0;N=f[a+68>>2]|0;if((N|0)==(f[a+72>>2]|0)?(t=N|0?N<<1:1,(N|0)<(t|0)):0){if(!t){o=0;q=N}else{f[6472]=(f[6472]|0)+1;o=sc((t*152|3)+16|0)|0;if(!o)o=0;else{f[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}q=f[a+68>>2]|0}if((q|0)>0){p=0;do{ki(o+(p*152|0)|0,(f[a+76>>2]|0)+(p*152|0)|0,152)|0;p=p+1|0}while((p|0)!=(q|0))}p=f[a+76>>2]|0;if(p|0){if(b[a+80>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[p+-4>>2]|0)}f[a+76>>2]=0}b[a+80>>0]=1;f[a+76>>2]=o;f[a+72>>2]=t;o=f[a+68>>2]|0}else o=N;f[a+68>>2]=o+1;M=f[a+76>>2]|0;f[M+(N*152|0)+140>>2]=g;q=f[a+16>>2]|0;o=f[q+(d*244|0)+240>>2]|0;t=f[q+(e*244|0)+240>>2]|0;f[M+(N*152|0)+144>>2]=d;f[M+(N*152|0)+148>>2]=e;p=f[h+84>>2]|0;f[M+(N*152|0)+104>>2]=p;f[M+(N*152|0)+132>>2]=0;n[M+(N*152|0)+100>>2]=0.0;n[M+(N*152|0)+96>>2]=0.0;L=(f[s>>2]=p,+n[s>>2]);if(o|0){f[M+(N*152|0)+16>>2]=f[c>>2];f[M+(N*152|0)+16+4>>2]=f[c+4>>2];f[M+(N*152|0)+16+8>>2]=f[c+8>>2];f[M+(N*152|0)+16+12>>2]=f[c+12>>2];K=+n[i+4>>2];D=+n[M+(N*152|0)+24>>2];H=+n[i+8>>2];I=+n[M+(N*152|0)+20>>2];E=+n[M+(N*152|0)+16>>2];J=+n[i>>2];n[M+(N*152|0)>>2]=K*D-H*I;n[M+(N*152|0)+4>>2]=H*E-D*J;n[M+(N*152|0)+8>>2]=I*J-K*E;n[M+(N*152|0)+12>>2]=0.0;v=((K*D-H*I)*+n[o+264>>2]+(H*E-D*J)*+n[o+268>>2]+(I*J-K*E)*+n[o+272>>2])*+n[o+544>>2];r=((K*D-H*I)*+n[o+280>>2]+(H*E-D*J)*+n[o+284>>2]+(I*J-K*E)*+n[o+288>>2])*+n[o+548>>2];u=((K*D-H*I)*+n[o+296>>2]+(H*E-D*J)*+n[o+300>>2]+(I*J-K*E)*+n[o+304>>2])*+n[o+552>>2];n[M+(N*152|0)+64>>2]=v;n[M+(N*152|0)+68>>2]=r;n[M+(N*152|0)+72>>2]=u;n[M+(N*152|0)+76>>2]=0.0;z=E;A=I;B=D;C=K*D-H*I;D=H*E-D*J;E=I*J-K*E}else{f[M+(N*152|0)+64>>2]=0;f[M+(N*152|0)+64+4>>2]=0;f[M+(N*152|0)+64+8>>2]=0;f[M+(N*152|0)+64+12>>2]=0;f[M+(N*152|0)>>2]=0;f[M+(N*152|0)+4>>2]=0;f[M+(N*152|0)+8>>2]=0;f[M+(N*152|0)+12>>2]=0;f[M+(N*152|0)+16>>2]=0;f[M+(N*152|0)+20>>2]=0;f[M+(N*152|0)+24>>2]=0;f[M+(N*152|0)+28>>2]=0;r=0.0;u=0.0;v=0.0;z=0.0;A=0.0;B=0.0;C=0.0;D=0.0;E=0.0}if(t|0){K=-+n[c>>2];P=-+n[c+4>>2];J=-+n[c+8>>2];n[M+(N*152|0)+48>>2]=K;n[M+(N*152|0)+52>>2]=P;n[M+(N*152|0)+56>>2]=J;n[M+(N*152|0)+60>>2]=0.0;O=+n[j+4>>2];R=+n[j+8>>2];Q=+n[j>>2];n[M+(N*152|0)+32>>2]=O*J-R*P;n[M+(N*152|0)+36>>2]=R*K-Q*J;n[M+(N*152|0)+40>>2]=Q*P-O*K;n[M+(N*152|0)+44>>2]=0.0;w=((O*J-R*P)*+n[t+264>>2]+(R*K-Q*J)*+n[t+268>>2]+(Q*P-O*K)*+n[t+272>>2])*+n[t+544>>2];x=((O*J-R*P)*+n[t+280>>2]+(R*K-Q*J)*+n[t+284>>2]+(Q*P-O*K)*+n[t+288>>2])*+n[t+548>>2];y=((O*J-R*P)*+n[t+296>>2]+(R*K-Q*J)*+n[t+300>>2]+(Q*P-O*K)*+n[t+304>>2])*+n[t+552>>2];n[M+(N*152|0)+80>>2]=w;n[M+(N*152|0)+84>>2]=x;n[M+(N*152|0)+88>>2]=y;n[M+(N*152|0)+92>>2]=0.0;F=K;G=P;H=J;I=O*J-R*P;J=R*K-Q*J;K=Q*P-O*K}else{f[M+(N*152|0)+80>>2]=0;f[M+(N*152|0)+80+4>>2]=0;f[M+(N*152|0)+80+8>>2]=0;f[M+(N*152|0)+80+12>>2]=0;f[M+(N*152|0)+32>>2]=0;f[M+(N*152|0)+32+4>>2]=0;f[M+(N*152|0)+32+8>>2]=0;f[M+(N*152|0)+32+12>>2]=0;f[M+(N*152|0)+32+16>>2]=0;f[M+(N*152|0)+32+20>>2]=0;f[M+(N*152|0)+32+24>>2]=0;f[M+(N*152|0)+32+28>>2]=0;w=0.0;x=0.0;y=0.0;F=0.0;G=0.0;H=0.0;I=0.0;J=0.0;K=0.0}if(o|0){P=+n[i+8>>2];Q=+n[i+4>>2];R=+n[i>>2];u=+n[o+344>>2]+((r*P-u*Q)*+n[c>>2]+(u*R-P*v)*+n[c+4>>2]+(Q*v-r*R)*+n[c+8>>2])}else u=0.0;if(t|0){Q=-w;r=-x;y=-y;O=+n[j+8>>2];P=+n[j+4>>2];R=+n[j>>2];r=+n[t+344>>2]+((O*r-P*y)*+n[c>>2]+(R*y-O*Q)*+n[c+4>>2]+(P*Q-R*r)*+n[c+8>>2])}else r=0.0;x=k/(u+r);n[M+(N*152|0)+108>>2]=x;if(o|0){u=+n[q+(d*244|0)+192>>2];v=+n[q+(d*244|0)+196>>2];w=+n[q+(d*244|0)+200>>2];r=(+n[q+(d*244|0)+176>>2]+ +n[q+(d*244|0)+208>>2])*z+(+n[q+(d*244|0)+180>>2]+ +n[q+(d*244|0)+212>>2])*A+(+n[q+(d*244|0)+184>>2]+ +n[q+(d*244|0)+216>>2])*B}else{u=0.0;v=0.0;w=0.0;r=z*0.0+A*0.0+B*0.0}r=r+(u*C+v*D+w*E);if(t|0){O=+n[q+(e*244|0)+192>>2];P=+n[q+(e*244|0)+196>>2];R=+n[q+(e*244|0)+200>>2];Q=(+n[q+(e*244|0)+176>>2]+ +n[q+(e*244|0)+208>>2])*F+(+n[q+(e*244|0)+180>>2]+ +n[q+(e*244|0)+212>>2])*G+(+n[q+(e*244|0)+184>>2]+ +n[q+(e*244|0)+216>>2])*H;O=O*I;P=P*J;P=O+P;R=R*K;R=P+R;R=Q+R;R=r+R;R=l-R;R=x*R;e=M+(N*152|0)+112|0;n[e>>2]=R;e=M+(N*152|0)+116|0;n[e>>2]=m;R=-L;e=M+(N*152|0)+120|0;n[e>>2]=R;e=M+(N*152|0)+124|0;f[e>>2]=p;return}else{O=0.0;P=0.0;R=0.0;Q=F*0.0+G*0.0+H*0.0;O=O*I;P=P*J;P=O+P;R=R*K;R=P+R;R=Q+R;R=r+R;R=l-R;R=x*R;e=M+(N*152|0)+112|0;n[e>>2]=R;e=M+(N*152|0)+116|0;n[e>>2]=m;R=-L;e=M+(N*152|0)+120|0;n[e>>2]=R;e=M+(N*152|0)+124|0;f[e>>2]=p;return}}function md(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,v=0,w=0.0,x=0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0.0;fa=u;u=u+32|0;J=f[a+4>>2]|0;b[J+312>>0]=0;f[J>>2]=0;b[J+356>>0]=1;f[J+292>>2]=1566444395;f[J+296>>2]=1566444395;f[J+300>>2]=1566444395;n[J+304>>2]=0.0;f[J+336>>2]=0;f[J+336+4>>2]=0;f[J+336+8>>2]=0;f[J+336+12>>2]=0;b[J+336+16>>0]=0;b[J+332>>0]=b[J+332>>0]&-16;o=+n[c+48>>2];q=+n[c+52>>2];t=+n[c+56>>2];m=+n[e+48>>2];p=+n[e+52>>2];s=+n[e+56>>2];M=+n[c>>2];Y=+n[c+4>>2];_=+n[c+8>>2];aa=+n[c+16>>2];O=+n[c+20>>2];Q=+n[c+24>>2];S=+n[c+32>>2];U=+n[c+36>>2];W=+n[c+40>>2];K=+n[e>>2];X=+n[e+4>>2];Z=+n[e+8>>2];$=+n[e+16>>2];N=+n[e+20>>2];P=+n[e+24>>2];R=+n[e+32>>2];T=+n[e+36>>2];V=+n[e+40>>2];ca=+n[d+48>>2]-o-(+n[g+48>>2]-m);da=+n[d+52>>2]-q-(+n[g+52>>2]-p);ea=+n[d+56>>2]-t-(+n[g+56>>2]-s);J=f[a+8>>2]|0;z=f[(f[J>>2]|0)+64>>2]|0;n[fa>>2]=M*-ca+aa*-da+S*-ea;n[fa+4>>2]=Y*-ca+O*-da+U*-ea;n[fa+8>>2]=_*-ca+Q*-da+W*-ea;n[fa+12>>2]=0.0;Vb[z&127](fa+16|0,J,fa);H=+n[fa+16>>2];I=+n[fa+16+4>>2];G=+n[fa+16+8>>2];k=H*+n[c>>2]+I*+n[c+4>>2]+G*+n[c+8>>2]+ +n[c+48>>2];w=H*+n[c+16>>2]+I*+n[c+20>>2]+G*+n[c+24>>2]+ +n[c+52>>2];G=H*+n[c+32>>2]+I*+n[c+36>>2]+G*+n[c+40>>2]+ +n[c+56>>2];J=f[a+12>>2]|0;z=f[(f[J>>2]|0)+64>>2]|0;I=ca*+n[e+4>>2]+da*+n[e+20>>2]+ea*+n[e+36>>2];H=ca*+n[e+8>>2]+da*+n[e+24>>2]+ea*+n[e+40>>2];n[fa>>2]=ca*+n[e>>2]+da*+n[e+16>>2]+ea*+n[e+32>>2];n[fa+4>>2]=I;n[fa+8>>2]=H;n[fa+12>>2]=0.0;Vb[z&127](fa+16|0,J,fa);H=+n[fa+16>>2];I=+n[fa+16+4>>2];l=+n[fa+16+8>>2];k=k-(H*+n[e>>2]+I*+n[e+4>>2]+l*+n[e+8>>2]+ +n[e+48>>2]);w=w-(H*+n[e+16>>2]+I*+n[e+20>>2]+l*+n[e+24>>2]+ +n[e+52>>2]);l=G-(H*+n[e+32>>2]+I*+n[e+36>>2]+l*+n[e+40>>2]+ +n[e+56>>2]);a:do if(k*k+w*w+l*l>9.999999747378752e-05){j=0.0;J=32;I=k;i=0;H=l;r=0;A=m;m=0.0;l=0.0;k=0.0;while(1){if(!J)break a;J=J+-1|0;z=f[a+8>>2]|0;x=f[(f[z>>2]|0)+64>>2]|0;D=-I;ga=-w;y=-H;n[fa>>2]=M*D+aa*ga+S*y;n[fa+4>>2]=Y*D+O*ga+U*y;n[fa+8>>2]=_*D+Q*ga+W*y;n[fa+12>>2]=0.0;Vb[x&127](fa+16|0,z,fa);y=+n[fa+16>>2];ga=+n[fa+16+4>>2];D=+n[fa+16+8>>2];B=o+(M*y+Y*ga+_*D);C=q+(aa*y+O*ga+Q*D);D=t+(S*y+U*ga+W*D);z=f[a+12>>2]|0;x=f[(f[z>>2]|0)+64>>2]|0;n[fa>>2]=K*I+$*w+R*H;n[fa+4>>2]=X*I+N*w+T*H;n[fa+8>>2]=Z*I+P*w+V*H;n[fa+12>>2]=0.0;Vb[x&127](fa+16|0,z,fa);ga=+n[fa+16>>2];y=+n[fa+16+4>>2];G=+n[fa+16+8>>2];E=A+(K*ga+X*y+Z*G);F=p+($*ga+N*y+P*G);G=s+(R*ga+T*y+V*G);y=I*(B-E)+w*(C-F)+H*(D-G);if(j>1.0){i=0;ba=24;break}if(y>0.0){k=ca*I+da*w+ea*H;if(k>=-1.4210854715202004e-14){i=0;ba=24;break}t=j-y/k;j=t;i=r;A=(1.0-t)*+n[e+48>>2]+t*+n[g+48>>2];o=(1.0-t)*+n[c+48>>2]+t*+n[d+48>>2];p=(1.0-t)*+n[e+52>>2]+t*+n[g+52>>2];q=(1.0-t)*+n[c+52>>2]+t*+n[d+52>>2];s=(1.0-t)*+n[e+56>>2]+t*+n[g+56>>2];t=(1.0-t)*+n[c+56>>2]+t*+n[d+56>>2];k=I;l=w;m=H}r=f[a+4>>2]|0;z=f[r>>2]|0;if((z|0)>0){w=+n[r+308>>2];x=0;v=0;do{H=B-E-+n[r+4+(x<<4)>>2];I=C-F-+n[r+4+(x<<4)+4>>2];ga=D-G-+n[r+4+(x<<4)+8>>2];v=v|H*H+I*I+ga*ga<=w;x=x+1|0}while((x|0)!=(z|0))}else v=0;if((+n[r+304>>2]==0.0?D-G==+n[r+300>>2]:0)?C-F==+n[r+296>>2]:0){if(!(B-E==+n[r+292>>2]|v))ba=16}else if(!v)ba=16;if((ba|0)==16){ba=0;n[r+292>>2]=B-E;n[r+296>>2]=C-F;n[r+300>>2]=D-G;n[r+304>>2]=0.0;b[r+356>>0]=1;n[r+4+(z<<4)>>2]=B-E;n[r+4+(z<<4)+4>>2]=C-F;n[r+4+(z<<4)+8>>2]=D-G;n[r+4+(z<<4)+12>>2]=0.0;z=f[r>>2]|0;n[r+84+(z<<4)>>2]=B;n[r+84+(z<<4)+4>>2]=C;n[r+84+(z<<4)+8>>2]=D;n[r+84+(z<<4)+12>>2]=0.0;z=f[r>>2]|0;n[r+164+(z<<4)>>2]=E;n[r+164+(z<<4)+4>>2]=F;n[r+164+(z<<4)+8>>2]=G;n[r+164+(z<<4)+12>>2]=0.0;f[r>>2]=(f[r>>2]|0)+1;r=f[a+4>>2]|0}z=wc(r)|0;I=+n[r+276>>2];w=+n[r+280>>2];H=+n[r+284>>2];if(!z)break a;if(!(I*I+w*w+H*H>9.999999747378752e-05))break a;else r=f[r+288>>2]|0}if((ba|0)==24){u=fa;return i|0}}else{j=0.0;m=0.0;l=0.0;k=0.0;i=0}while(0);n[h+164>>2]=j;j=k*k+l*l+m*m;if(!(j>=1.4210854715202004e-14)){f[h+132>>2]=0;f[h+132+4>>2]=0;f[h+132+8>>2]=0;f[h+132+12>>2]=0;j=0.0;k=0.0;l=0.0}else{ga=1.0/+L(+j);j=k*ga;k=l*ga;l=m*ga;n[h+132>>2]=j;n[h+136>>2]=k;n[h+140>>2]=l;f[h+144>>2]=i}if(ca*j+da*k+ea*l>=-+n[h+172>>2]){h=0;u=fa;return h|0}a=f[a+4>>2]|0;wc(a)|0;Kp(h+148|0,a+260|0,16)|0;h=1;u=fa;return h|0}function nd(a,b,c,e,g,h,i,k,l){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;var m=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0;x=+n[a+8>>2];z=+n[a+12>>2];B=+n[a+16>>2];y=+n[a+40>>2];t=(+n[b>>2]-x)*y;A=+n[a+44>>2];v=(+n[b+4>>2]-z)*A;C=+n[a+48>>2];w=(+n[b+8>>2]-B)*C;if(!(t<=0.0)){m=d[a+6>>1]|0;if(!(t>=+(m&65535))){o=d[a+4>>1]|0;m=~~t&65535}else{o=m;m=d[a+4>>1]|0}m=o&m&65535}else m=0;u=m&65535;if(!(v<=0.0)){m=d[a+6>>1]|0;if(!(v>=+(m&65535))){o=d[a+4>>1]|0;m=~~v&65535}else{o=m;m=d[a+4>>1]|0}m=o&m&65535}else m=0;s=m&65535;if(!(w<=0.0)){m=d[a+6>>1]|0;if(!(w>=+(m&65535))){o=d[a+4>>1]|0;m=~~w&65535}else{o=m;m=d[a+4>>1]|0}m=o&m&65535}else m=0;r=m&65535;t=(+n[c>>2]-x)*y;v=(+n[c+4>>2]-z)*A;w=(+n[c+8>>2]-B)*C;if(!(t<=0.0)){m=d[a+6>>1]|0;if(!(t>=+(m&65535))){o=d[a+4>>1]|0;m=~~t&65535}else{o=m;m=d[a+4>>1]|0}q=o&m|1}else q=1;if(!(v<=0.0)){m=d[a+6>>1]|0;if(!(v>=+(m&65535))){o=d[a+4>>1]|0;m=~~v&65535}else{o=m;m=d[a+4>>1]|0}p=o&m|1}else p=1;if(!(w<=0.0)){m=d[a+6>>1]|0;if(!(w>=+(m&65535))){o=d[a+4>>1]|0;m=~~w&65535}else{o=m;m=d[a+4>>1]|0}m=o&m|1}else m=1;E=d[a+64>>1]|0;D=f[a+60>>2]|0;d[a+64>>1]=d[D+((E&65535)<<6)+48>>1]|0;o=(d[a+56>>1]|0)+1<<16>>16;d[a+56>>1]=o;f[D+((E&65535)<<6)+12>>2]=E&65535;f[D+((E&65535)<<6)>>2]=g;d[D+((E&65535)<<6)+4>>1]=h;d[D+((E&65535)<<6)+6>>1]=i;f[D+((E&65535)<<6)+8>>2]=l;l=(o&65535)<<1&65534;d[D+54>>1]=(j[D+54>>1]|0)+2;F=f[a+68>>2]|0;G=j[F+(l+-1<<2)>>1]|j[F+(l+-1<<2)+2>>1]<<16;d[F+((l|1)<<2)>>1]=G;d[F+((l|1)<<2)+2>>1]=G>>>16;F=f[a+68>>2]|0;d[F+(l+-1<<2)>>1]=u;d[F+(l+-1<<2)+2>>1]=E;d[F+(l<<2)>>1]=q;d[F+(l<<2)+2>>1]=E;d[D+((E&65535)<<6)+48>>1]=l+-1;d[D+((E&65535)<<6)+54>>1]=(o&65535)<<1;q=(f[a+60>>2]|0)+56|0;d[q>>1]=(j[q>>1]|0)+2;q=f[a+72>>2]|0;u=j[q+(l+-1<<2)>>1]|j[q+(l+-1<<2)+2>>1]<<16;d[q+((l|1)<<2)>>1]=u;d[q+((l|1)<<2)+2>>1]=u>>>16;q=f[a+72>>2]|0;d[q+(l+-1<<2)>>1]=s;d[q+(l+-1<<2)+2>>1]=E;d[q+(l<<2)>>1]=p;d[q+(l<<2)+2>>1]=E;d[D+((E&65535)<<6)+50>>1]=l+-1;d[D+((E&65535)<<6)+56>>1]=(o&65535)<<1;p=(f[a+60>>2]|0)+58|0;d[p>>1]=(j[p>>1]|0)+2;p=f[a+76>>2]|0;s=j[p+(l+-1<<2)>>1]|j[p+(l+-1<<2)+2>>1]<<16;d[p+((l|1)<<2)>>1]=s;d[p+((l|1)<<2)+2>>1]=s>>>16;p=f[a+76>>2]|0;d[p+(l+-1<<2)>>1]=r;d[p+(l+-1<<2)+2>>1]=E;d[p+(l<<2)>>1]=m;d[p+(l<<2)+2>>1]=E;d[D+((E&65535)<<6)+52>>1]=l+-1;d[D+((E&65535)<<6)+58>>1]=(o&65535)<<1;o=f[a+68>>2]|0;p=j[D+((E&65535)<<6)+48>>1]|0;s=f[a+60>>2]|0;q=d[o+(p<<2)+-4>>1]|0;if((j[o+(p<<2)>>1]|0)<(q&65535)){u=s+((j[o+(p<<2)+2>>1]|0)<<6)+48|0;m=o+(p<<2)+-4|0;r=o+(p<<2)|0;p=q;o=s;while(1){G=j[r+-2>>1]|0;o=(p&1)==0?o+(G<<6)+48|0:o+(G<<6)+54|0;d[o>>1]=(d[o>>1]|0)+1<<16>>16;d[u>>1]=(d[u>>1]|0)+-1<<16>>16;o=j[r>>1]|j[r+2>>1]<<16;p=j[m>>1]|j[m+2>>1]<<16;d[r>>1]=p;d[r+2>>1]=p>>>16;d[m>>1]=o;d[m+2>>1]=o>>>16;o=r+-4|0;m=m+-4|0;p=d[m>>1]|0;if((j[o>>1]|0)>=(p&65535))break;r=o;o=f[a+60>>2]|0}o=f[a+68>>2]|0}m=j[D+((E&65535)<<6)+54>>1]|0;p=o+(m<<2)|0;r=d[p+-4>>1]|0;a:do if((j[p>>1]|0)<(r&65535)){G=f[a+60>>2]|0;s=G+((j[o+(m<<2)+2>>1]|0)<<6)+54|0;m=p+-4|0;q=p;o=r;p=G;while(1){G=j[q+-2>>1]|0;p=(o&1)==0?p+(G<<6)+48|0:p+(G<<6)+54|0;d[p>>1]=(d[p>>1]|0)+1<<16>>16;d[s>>1]=(d[s>>1]|0)+-1<<16>>16;p=j[q>>1]|j[q+2>>1]<<16;o=j[m>>1]|j[m+2>>1]<<16;d[q>>1]=o;d[q+2>>1]=o>>>16;d[m>>1]=p;d[m+2>>1]=p>>>16;p=q+-4|0;m=m+-4|0;o=d[m>>1]|0;if((j[p>>1]|0)>=(o&65535))break a;q=p;p=f[a+60>>2]|0}}while(0);o=f[a+72>>2]|0;p=j[D+((E&65535)<<6)+50>>1]|0;s=f[a+60>>2]|0;q=d[o+(p<<2)+-4>>1]|0;if((j[o+(p<<2)>>1]|0)<(q&65535)){u=s+((j[o+(p<<2)+2>>1]|0)<<6)+50|0;m=o+(p<<2)+-4|0;r=o+(p<<2)|0;p=q;o=s;while(1){G=j[r+-2>>1]|0;o=(p&1)==0?o+(G<<6)+50|0:o+(G<<6)+56|0;d[o>>1]=(d[o>>1]|0)+1<<16>>16;d[u>>1]=(d[u>>1]|0)+-1<<16>>16;o=j[r>>1]|j[r+2>>1]<<16;p=j[m>>1]|j[m+2>>1]<<16;d[r>>1]=p;d[r+2>>1]=p>>>16;d[m>>1]=o;d[m+2>>1]=o>>>16;o=r+-4|0;m=m+-4|0;p=d[m>>1]|0;if((j[o>>1]|0)>=(p&65535))break;r=o;o=f[a+60>>2]|0}o=f[a+72>>2]|0}m=j[D+((E&65535)<<6)+56>>1]|0;p=o+(m<<2)|0;r=d[p+-4>>1]|0;b:do if((j[p>>1]|0)<(r&65535)){G=f[a+60>>2]|0;s=G+((j[o+(m<<2)+2>>1]|0)<<6)+56|0;m=p+-4|0;q=p;o=r;p=G;while(1){G=j[q+-2>>1]|0;p=(o&1)==0?p+(G<<6)+50|0:p+(G<<6)+56|0;d[p>>1]=(d[p>>1]|0)+1<<16>>16;d[s>>1]=(d[s>>1]|0)+-1<<16>>16;p=j[q>>1]|j[q+2>>1]<<16;o=j[m>>1]|j[m+2>>1]<<16;d[q>>1]=o;d[q+2>>1]=o>>>16;d[m>>1]=p;d[m+2>>1]=p>>>16;p=q+-4|0;m=m+-4|0;o=d[m>>1]|0;if((j[p>>1]|0)>=(o&65535))break b;q=p;p=f[a+60>>2]|0}}while(0);yh(a,2,d[D+((E&65535)<<6)+52>>1]|0);rh(a,2,d[D+((E&65535)<<6)+58>>1]|0,k);o=f[a+60>>2]|0;m=f[a+108>>2]|0;if(!m){G=o+((E&65535)<<6)|0;return G|0}G=Ib[f[(f[m>>2]|0)+8>>2]&3](m,b,c,e,g,h,i,k,0)|0;f[o+((E&65535)<<6)+60>>2]=G;G=o+((E&65535)<<6)|0;return G|0}function od(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;A=+n[a+48>>2];h=+n[c>>2];B=+n[a+64>>2];i=+n[c+4>>2];G=+n[a+80>>2];p=+n[c+8>>2];s=+n[a+52>>2];r=+n[a+68>>2];q=+n[a+84>>2];w=+n[a+56>>2];F=+n[a+72>>2];x=+n[a+88>>2];v=+n[c+16>>2];u=+n[c+20>>2];t=+n[c+24>>2];E=+n[c+32>>2];C=+n[c+36>>2];D=+n[c+40>>2];j=+n[a+96>>2];g=+n[a+100>>2];z=+n[a+104>>2];y=+n[c+48>>2]+(h*j+i*g+p*z);e=v*j+u*g+t*z+ +n[c+52>>2];z=E*j+C*g+D*z+ +n[c+56>>2];n[a+1064>>2]=A*h+B*i+G*p;n[a+1068>>2]=h*s+i*r+p*q;n[a+1072>>2]=h*w+i*F+p*x;n[a+1076>>2]=0.0;n[a+1080>>2]=A*v+B*u+G*t;n[a+1084>>2]=s*v+r*u+q*t;n[a+1088>>2]=w*v+F*u+x*t;n[a+1092>>2]=0.0;n[a+1096>>2]=A*E+B*C+G*D;n[a+1100>>2]=s*E+r*C+q*D;n[a+1104>>2]=w*E+F*C+x*D;n[a+1108>>2]=0.0;n[a+1112>>2]=y;n[a+1116>>2]=e;n[a+1120>>2]=z;n[a+1124>>2]=0.0;z=+n[a+112>>2];e=+n[d>>2];y=+n[a+128>>2];D=+n[d+4>>2];x=+n[a+144>>2];C=+n[d+8>>2];F=+n[a+116>>2];E=+n[a+132>>2];w=+n[a+148>>2];q=+n[a+120>>2];r=+n[a+136>>2];s=+n[a+152>>2];G=+n[d+16>>2];B=+n[d+20>>2];A=+n[d+24>>2];t=+n[d+32>>2];u=+n[d+36>>2];v=+n[d+40>>2];p=+n[a+160>>2];i=+n[a+164>>2];h=+n[a+168>>2];g=+n[d+48>>2]+(e*p+D*i+C*h);j=G*p+B*i+A*h+ +n[d+52>>2];h=t*p+u*i+v*h+ +n[d+56>>2];n[a+1128>>2]=z*e+y*D+x*C;n[a+1132>>2]=e*F+D*E+C*w;n[a+1136>>2]=e*q+D*r+C*s;n[a+1140>>2]=0.0;n[a+1144>>2]=z*G+y*B+x*A;n[a+1148>>2]=F*G+E*B+w*A;n[a+1152>>2]=q*G+r*B+s*A;n[a+1156>>2]=0.0;n[a+1160>>2]=z*t+y*u+x*v;n[a+1164>>2]=F*t+E*u+w*v;n[a+1168>>2]=q*t+r*u+s*v;n[a+1172>>2]=0.0;n[a+1176>>2]=g;n[a+1180>>2]=j;n[a+1184>>2]=h;n[a+1188>>2]=0.0;g=g-+n[a+1112>>2];j=j-+n[a+1116>>2];h=h-+n[a+1120>>2];w=+n[a+1084>>2];E=+n[a+1104>>2];F=+n[a+1088>>2];x=+n[a+1100>>2];y=+n[a+1096>>2];z=+n[a+1080>>2];A=+n[a+1064>>2];B=+n[a+1068>>2];G=+n[a+1072>>2];C=1.0/((w*E-F*x)*A+B*(F*y-E*z)+(x*z-w*y)*G);D=(x*z-w*y)*C;e=h*(F*B-w*G)*C+(g*(w*E-F*x)*C+j*(x*G-E*B)*C);i=h*(z*G-F*A)*C+(g*(F*y-E*z)*C+j*(E*A-y*G)*C);j=h*(w*A-z*B)*C+(g*D+j*(y*B-x*A)*C);n[a+1256>>2]=e;n[a+1260>>2]=i;n[a+1264>>2]=j;n[a+1268>>2]=0.0;n[a+840>>2]=e;g=+n[a+680>>2];h=+n[a+696>>2];do if(!(g>h)){if(g>e){f[a+856>>2]=2;e=e-g;break}if(h<e){f[a+856>>2]=1;e=e-h;break}else{f[a+856>>2]=0;e=0.0;break}}else{f[a+856>>2]=0;e=0.0}while(0);n[a+824>>2]=e;n[a+844>>2]=i;e=+n[a+684>>2];g=+n[a+700>>2];do if(!(e>g)){if(e>i){f[a+860>>2]=2;e=i-e;break}if(g<i){f[a+860>>2]=1;e=i-g;break}else{f[a+860>>2]=0;e=0.0;break}}else{f[a+860>>2]=0;e=0.0}while(0);n[a+828>>2]=e;n[a+848>>2]=j;e=+n[a+688>>2];g=+n[a+704>>2];do if(!(e>g)){if(e>j){f[a+864>>2]=2;e=j-e;break}if(g<j){f[a+864>>2]=1;e=j-g;break}else{f[a+864>>2]=0;e=0.0;break}}else{f[a+864>>2]=0;e=0.0}while(0);n[a+832>>2]=e;m=+n[a+1128>>2];o=+n[a+1144>>2];p=+n[a+1160>>2];g=+n[a+1132>>2];h=+n[a+1148>>2];i=+n[a+1164>>2];j=(w*E-F*x)*C*g+(x*G-E*B)*C*h+(F*B-w*G)*C*i;k=g*(F*y-E*z)*C+(E*A-y*G)*C*h+(z*G-F*A)*C*i;l=p*(w*A-z*B)*C+(m*D+o*(y*B-x*A)*C);e=D*+n[a+1136>>2]+(y*B-x*A)*C*+n[a+1152>>2]+(w*A-z*B)*C*(q*t+r*u+s*v);do if(l<1.0)if(l>-1.0){e=+T(+-(g*D+(y*B-x*A)*C*h+(w*A-z*B)*C*i),+e);n[a+1192>>2]=e;e=l<-1.0?-1.0:l;e=+R(+(e>1.0?1.0:e));n[a+1196>>2]=e;e=+T(+-(p*(z*G-F*A)*C+(m*(F*y-E*z)*C+o*(E*A-y*G)*C)),+(p*(F*B-w*G)*C+(m*(w*E-F*x)*C+o*(x*G-E*B)*C)));break}else{e=-+T(+j,+k);n[a+1192>>2]=e;n[a+1196>>2]=-1.5707963705062866;e=0.0;break}else{e=+T(+j,+k);n[a+1192>>2]=e;n[a+1196>>2]=1.5707963705062866;e=0.0}while(0);n[a+1200>>2]=e;n[a+1236>>2]=0.0;x=E*(m*E-p*G)-F*(o*G-m*F);y=G*(o*G-m*F)-E*(p*F-o*E);z=F*(p*F-o*E)-G*(m*E-p*G);n[a+1220>>2]=0.0;B=o*(o*G-m*F)-p*(m*E-p*G);C=p*(p*F-o*E)-m*(o*G-m*F);D=m*(m*E-p*G)-o*(p*F-o*E);n[a+1252>>2]=0.0;A=1.0/+L(+(x*x+y*y+z*z));n[a+1208>>2]=x*A;n[a+1212>>2]=y*A;n[a+1216>>2]=z*A;A=1.0/+L(+((p*F-o*E)*(p*F-o*E)+(m*E-p*G)*(m*E-p*G)+(o*G-m*F)*(o*G-m*F)));n[a+1224>>2]=(p*F-o*E)*A;n[a+1228>>2]=(m*E-p*G)*A;n[a+1232>>2]=(o*G-m*F)*A;G=1.0/+L(+(B*B+C*C+D*D));n[a+1240>>2]=B*G;n[a+1244>>2]=C*G;n[a+1248>>2]=D*G;if(!(b[a+1301>>0]|0))return;F=+n[(f[a+28>>2]|0)+344>>2];G=+n[(f[a+32>>2]|0)+344>>2];b[a+1280>>0]=(F<1.1920928955078125e-07|G<1.1920928955078125e-07)&1;G=F+G>0.0?G/(F+G):.5;n[a+1272>>2]=G;n[a+1276>>2]=1.0-G;return}function pd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0.0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0;q=u;u=u+32|0;jg(a+4|0,((X(f[a+152>>2]|0,f[a+16>>2]|0)|0)/100|0)+1|0);if(f[a+164>>2]|0){o=((X(f[a+148>>2]|0,f[a+76>>2]|0)|0)/100|0)+1|0;jg(a+64|0,o);o=(f[a+164>>2]|0)-o|0;f[a+164>>2]=(o|0)>0?o:0}e=((f[a+144>>2]|0)+1|0)%2|0;f[a+144>>2]=e;e=f[a+124+(e<<2)>>2]|0;if(e|0){do{g=e+56|0;k=e;e=f[g>>2]|0;h=f[k+52>>2]|0;f[((h|0)==0?a+124+(f[k+60>>2]<<2)|0:h+56|0)>>2]=e;h=f[g>>2]|0;if(h|0)f[h+52>>2]=f[k+52>>2];f[k+52>>2]=0;f[g>>2]=f[a+132>>2];g=f[a+132>>2]|0;if(g|0)f[g+52>>2]=k;f[a+132>>2]=k;g=f[k+48>>2]|0;zg(a+4|0,g)|0;h=f[a+8>>2]|0;if(h|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}f[a+8>>2]=g;f[a+16>>2]=(f[a+16>>2]|0)+-1;f[q>>2]=f[k+16>>2];f[q+4>>2]=f[k+16+4>>2];f[q+8>>2]=f[k+16+8>>2];f[q+12>>2]=f[k+16+12>>2];f[q+16>>2]=f[k+32>>2];f[q+16+4>>2]=f[k+32+4>>2];f[q+16+8>>2]=f[k+32+8>>2];f[q+16+12>>2]=f[k+32+12>>2];g=f[a+68>>2]|0;if(!g){f[6472]=(f[6472]|0)+1;g=sc(63)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}h=g;j=h+44|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(j|0))}else f[a+68>>2]=0;f[g+32>>2]=0;f[g+36>>2]=k;f[g+40>>2]=0;f[g>>2]=f[q>>2];f[g+4>>2]=f[q+4>>2];f[g+8>>2]=f[q+8>>2];f[g+12>>2]=f[q+12>>2];f[g+16>>2]=f[q+16>>2];f[g+20>>2]=f[q+20>>2];f[g+24>>2]=f[q+24>>2];f[g+28>>2]=f[q+28>>2];ff(a+64|0,f[a+64>>2]|0,g);h=(f[a+76>>2]|0)+1|0;f[a+76>>2]=h;f[k+48>>2]=g;f[k+60>>2]=2}while((e|0)!=0);f[a+164>>2]=h;b[a+194>>0]=1}f[q>>2]=9096;f[q+4>>2]=a;if(b[a+193>>0]|0?(pe(a+4|0,f[a+4>>2]|0,f[a+64>>2]|0,q),b[a+193>>0]|0):0){o=f[a+4>>2]|0;pe(a+4|0,o,o,q)}if(b[a+194>>0]|0?(l=f[a+136>>2]|0,l=Bb[f[(f[l>>2]|0)+28>>2]&127](l)|0,d=f[l+4>>2]|0,(d|0)>0):0){e=(X(f[a+156>>2]|0,d)|0)/100|0;o=f[a+160>>2]|0;e=(o|0)>(e|0)?o:e;e=(d|0)<(e|0)?d:e;if((e|0)>0){g=0;do{j=((f[a+184>>2]|0)+g|0)%(d|0)|0;m=f[l+12>>2]|0;h=f[m+(j<<4)>>2]|0;j=f[m+(j<<4)+4>>2]|0;m=f[h+48>>2]|0;o=f[j+48>>2]|0;if(!(((((+n[m>>2]<=+n[o+16>>2]?+n[m+16>>2]>=+n[o>>2]:0)?+n[m+4>>2]<=+n[o+20>>2]:0)?+n[m+20>>2]>=+n[o+4>>2]:0)?+n[m+8>>2]<=+n[o+24>>2]:0)?+n[m+24>>2]>=+n[o+8>>2]:0)){d=f[a+136>>2]|0;Gb[f[(f[d>>2]|0)+12>>2]&31](d,h,j,c)|0;g=g+-1|0;e=e+-1|0;d=f[l+4>>2]|0}g=g+1|0}while((g|0)<(e|0));if((d|0)>0)p=34;else d=0}else p=34;if((p|0)==34)d=((f[a+184>>2]|0)+e|0)%(d|0)|0;f[a+184>>2]=d}f[a+180>>2]=(f[a+180>>2]|0)+1;f[a+160>>2]=1;b[a+194>>0]=0;e=f[a+168>>2]|0;if(!e){d=a+172|0;i=0.0;g=f[a+172>>2]|0}else{g=f[a+172>>2]|0;d=a+172|0;i=+(g>>>0)/+(e>>>0)}n[a+176>>2]=i;f[d>>2]=g>>>1;f[a+168>>2]=e>>>1;o=f[a+136>>2]|0;if(!(Bb[f[(f[o>>2]|0)+56>>2]&127](o)|0)){u=q;return}o=f[a+136>>2]|0;o=Bb[f[(f[o>>2]|0)+28>>2]&127](o)|0;d=f[o+4>>2]|0;if((d|0)>1){ue(o,0,d+-1|0);d=f[o+4>>2]|0}if((d|0)>0){l=0;k=0;m=0;e=0;while(1){h=f[o+12>>2]|0;g=h+(l<<4)|0;r=m;m=f[g>>2]|0;h=h+(l<<4)+4|0;j=f[h>>2]|0;if(!((m|0)==(r|0)&(j|0)==(e|0))){e=f[m+48>>2]|0;r=f[j+48>>2]|0;if(((((+n[e>>2]<=+n[r+16>>2]?+n[e+16>>2]>=+n[r>>2]:0)?+n[e+4>>2]<=+n[r+20>>2]:0)?+n[e+20>>2]>=+n[r+4>>2]:0)?+n[e+8>>2]<=+n[r+24>>2]:0)?+n[e+24>>2]>=+n[r+8>>2]:0){g=k;e=j}else{e=j;p=51}}else p=51;if((p|0)==51){p=0;d=f[a+136>>2]|0;Vb[f[(f[d>>2]|0)+32>>2]&127](d,g,c);f[g>>2]=0;f[h>>2]=0;g=k+1|0;d=f[o+4>>2]|0}l=l+1|0;if((l|0)>=(d|0))break;else k=g}if((d|0)>1){ue(o,0,d+-1|0);d=f[o+4>>2]|0}j=d-g|0;if((g|0)<0){if((f[o+8>>2]|0)<(j|0)){if(!j){e=0;h=d}else{f[6472]=(f[6472]|0)+1;e=sc((j<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[o+4>>2]|0}if((h|0)>0){g=0;do{r=f[o+12>>2]|0;f[e+(g<<4)>>2]=f[r+(g<<4)>>2];f[e+(g<<4)+4>>2]=f[r+(g<<4)+4>>2];f[e+(g<<4)+8>>2]=f[r+(g<<4)+8>>2];f[e+(g<<4)+12>>2]=f[r+(g<<4)+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[o+12>>2]|0;if(g|0){if(b[o+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[o+12>>2]=0}b[o+16>>0]=1;f[o+12>>2]=e;f[o+8>>2]=j}do{r=(f[o+12>>2]|0)+(d<<4)|0;d=d+1|0;f[r>>2]=0;f[r+4>>2]=0;f[r+8>>2]=0;f[r+12>>2]=0}while((d|0)!=(j|0));d=j}else d=j}f[o+4>>2]=d;u=q;return}function qd(a){a=a|0;var c=0,d=0.0,e=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,v=0.0,w=0.0,x=0;s=u;u=u+176|0;if(!(b[a+527>>0]|0)){u=s;return}n[a+36>>2]=0.0;n[a+520>>2]=0.0;n[a+516>>2]=0.0;f[a+576>>2]=0;f[a+576+4>>2]=0;f[a+576+8>>2]=0;f[a+576+12>>2]=0;if(!(b[a+524>>0]|0)){t=f[a+28>>2]|0;h=+n[a+348>>2];i=+n[a+352>>2];o=+n[a+356>>2];q=h*+n[t+20>>2]+i*+n[t+24>>2]+o*+n[t+28>>2]+ +n[t+56>>2];c=f[a+32>>2]|0;j=+n[a+412>>2];k=+n[a+416>>2];p=+n[a+420>>2];r=j*+n[c+20>>2]+k*+n[c+24>>2]+p*+n[c+28>>2]+ +n[c+56>>2];l=j*+n[c+36>>2]+k*+n[c+40>>2]+p*+n[c+44>>2]+ +n[c+60>>2];m=h*+n[t+4>>2]+i*+n[t+8>>2]+o*+n[t+12>>2]+ +n[t+52>>2];o=h*+n[t+36>>2]+i*+n[t+40>>2]+o*+n[t+44>>2]+ +n[t+60>>2];p=j*+n[c+4>>2]+k*+n[c+8>>2]+p*+n[c+12>>2]+ +n[c+52>>2];if((p-m)*(p-m)+(r-q)*(r-q)+(l-o)*(l-o)>1.1920928955078125e-07){e=1.0/+L(+((p-m)*(p-m)+(r-q)*(r-q)+(l-o)*(l-o)));n[s+128>>2]=(p-m)*e;n[s+128+4>>2]=(r-q)*e;n[s+128+8>>2]=(l-o)*e;f[s+128+12>>2]=0;j=(l-o)*e;d=(r-q)*e;e=(p-m)*e}else{f[s+128>>2]=1065353216;f[s+128+4>>2]=0;f[s+128+8>>2]=0;n[s+128+12>>2]=0.0;j=0.0;d=0.0;e=1.0}if(+K(+j)>.7071067690849304){w=j*j+d*d;v=1.0/+L(+w);h=-(v*j);j=v*d;k=-(j*e);g=e*h;i=0.0;d=w*v;e=j}else{h=e*e+d*d;g=1.0/+L(+h);i=-(d*g);d=g*e;k=j*i;g=h*g;h=d;d=-(d*j);e=0.0}n[s+128+16>>2]=i;n[s+128+20>>2]=h;n[s+128+24>>2]=e;n[s+128+32>>2]=d;n[s+128+36>>2]=k;n[s+128+40>>2]=g;t=f[a+28>>2]|0;f[s+80>>2]=f[t+4>>2];f[s+80+4>>2]=f[t+20>>2];f[s+80+8>>2]=f[t+36>>2];n[s+80+12>>2]=0.0;f[s+80+16>>2]=f[t+8>>2];f[s+80+20>>2]=f[t+24>>2];f[s+80+24>>2]=f[t+40>>2];n[s+80+28>>2]=0.0;f[s+80+32>>2]=f[t+12>>2];f[s+80+36>>2]=f[t+28>>2];f[s+80+40>>2]=f[t+44>>2];n[s+80+44>>2]=0.0;c=f[a+32>>2]|0;f[s+32>>2]=f[c+4>>2];f[s+32+4>>2]=f[c+20>>2];f[s+32+8>>2]=f[c+36>>2];n[s+32+12>>2]=0.0;f[s+32+16>>2]=f[c+8>>2];f[s+32+20>>2]=f[c+24>>2];f[s+32+24>>2]=f[c+40>>2];n[s+32+28>>2]=0.0;f[s+32+32>>2]=f[c+12>>2];f[s+32+36>>2]=f[c+28>>2];f[s+32+40>>2]=f[c+44>>2];n[s+32+44>>2]=0.0;w=q-+n[t+56>>2];v=o-+n[t+60>>2];n[s+16>>2]=m-+n[t+52>>2];n[s+16+4>>2]=w;n[s+16+8>>2]=v;n[s+16+12>>2]=0.0;v=r-+n[c+56>>2];w=l-+n[c+60>>2];n[s>>2]=p-+n[c+52>>2];n[s+4>>2]=v;n[s+8>>2]=w;n[s+12>>2]=0.0;t=f[a+28>>2]|0;Qg(a+48|0,s+80|0,s+32|0,s+16|0,s,s+128|0,t+396|0,+n[t+344>>2],c+396|0,+n[c+344>>2]);c=f[a+28>>2]|0;f[s+80>>2]=f[c+4>>2];f[s+80+4>>2]=f[c+20>>2];f[s+80+8>>2]=f[c+36>>2];n[s+80+12>>2]=0.0;f[s+80+16>>2]=f[c+8>>2];f[s+80+20>>2]=f[c+24>>2];f[s+80+24>>2]=f[c+40>>2];n[s+80+28>>2]=0.0;f[s+80+32>>2]=f[c+12>>2];f[s+80+36>>2]=f[c+28>>2];f[s+80+40>>2]=f[c+44>>2];n[s+80+44>>2]=0.0;t=f[a+32>>2]|0;f[s+32>>2]=f[t+4>>2];f[s+32+4>>2]=f[t+20>>2];f[s+32+8>>2]=f[t+36>>2];n[s+32+12>>2]=0.0;f[s+32+16>>2]=f[t+8>>2];f[s+32+20>>2]=f[t+24>>2];f[s+32+24>>2]=f[t+40>>2];n[s+32+28>>2]=0.0;f[s+32+32>>2]=f[t+12>>2];f[s+32+36>>2]=f[t+28>>2];f[s+32+40>>2]=f[t+44>>2];n[s+32+44>>2]=0.0;w=q-+n[c+56>>2];v=o-+n[c+60>>2];n[s+16>>2]=m-+n[c+52>>2];n[s+16+4>>2]=w;n[s+16+8>>2]=v;n[s+16+12>>2]=0.0;v=r-+n[t+56>>2];w=l-+n[t+60>>2];n[s>>2]=p-+n[t+52>>2];n[s+4>>2]=v;n[s+8>>2]=w;n[s+12>>2]=0.0;c=f[a+28>>2]|0;Qg(a+132|0,s+80|0,s+32|0,s+16|0,s,s+128+16|0,c+396|0,+n[c+344>>2],t+396|0,+n[t+344>>2]);t=f[a+28>>2]|0;f[s+80>>2]=f[t+4>>2];f[s+80+4>>2]=f[t+20>>2];f[s+80+8>>2]=f[t+36>>2];n[s+80+12>>2]=0.0;f[s+80+16>>2]=f[t+8>>2];f[s+80+20>>2]=f[t+24>>2];f[s+80+24>>2]=f[t+40>>2];n[s+80+28>>2]=0.0;f[s+80+32>>2]=f[t+12>>2];f[s+80+36>>2]=f[t+28>>2];f[s+80+40>>2]=f[t+44>>2];n[s+80+44>>2]=0.0;c=f[a+32>>2]|0;f[s+32>>2]=f[c+4>>2];f[s+32+4>>2]=f[c+20>>2];f[s+32+8>>2]=f[c+36>>2];n[s+32+12>>2]=0.0;f[s+32+16>>2]=f[c+8>>2];f[s+32+20>>2]=f[c+24>>2];f[s+32+24>>2]=f[c+40>>2];n[s+32+28>>2]=0.0;f[s+32+32>>2]=f[c+12>>2];f[s+32+36>>2]=f[c+28>>2];f[s+32+40>>2]=f[c+44>>2];n[s+32+44>>2]=0.0;w=q-+n[t+56>>2];v=o-+n[t+60>>2];n[s+16>>2]=m-+n[t+52>>2];n[s+16+4>>2]=w;n[s+16+8>>2]=v;n[s+16+12>>2]=0.0;v=r-+n[c+56>>2];w=l-+n[c+60>>2];n[s>>2]=p-+n[c+52>>2];n[s+4>>2]=v;n[s+8>>2]=w;n[s+12>>2]=0.0;t=f[a+28>>2]|0;Qg(a+216|0,s+80|0,s+32|0,s+16|0,s,s+128+32|0,t+396|0,+n[t+344>>2],c+396|0,+n[c+344>>2]);c=a+32|0}else c=a+32|0;x=f[a+28>>2]|0;t=f[c>>2]|0;xc(a,x+4|0,t+4|0,x+264|0,t+264|0);u=s;return}function rd(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0;if((i|0)<2|(j|0)<2){l=0;return l|0}r=X(j,i)|0;f[6472]=(f[6472]|0)+1;a=sc(r>>>0>268435455?18:(r<<4|3)+16|0)|0;if(!a)p=0;else{f[(a+4+15&-16)+-4>>2]=a;p=a+4+15&-16}q=$H(r>>>0>1073741823?-1:r<<2)|0;if((j|0)>0?(i|0)>0:0){a=0;do{A=+(a|0)/+(j+-1|0);u=+n[d>>2];u=u+A*(+n[g>>2]-u);v=+n[d+4>>2];v=v+A*(+n[g+4>>2]-v);w=+n[d+8>>2];w=w+A*(+n[g+8>>2]-w);x=+n[e>>2];y=+n[e+4>>2];z=+n[e+8>>2];x=x+A*(+n[h>>2]-x)-u;y=y+A*(+n[h+4>>2]-y)-v;z=z+A*(+n[h+8>>2]-z)-w;o=X(a,i)|0;m=0;do{A=+(m|0)/+(i+-1|0);t=m+o|0;n[p+(t<<4)>>2]=u+x*A;n[p+(t<<4)+4>>2]=v+y*A;n[p+(t<<4)+8>>2]=w+z*A;n[p+(t<<4)+12>>2]=0.0;n[q+(t<<2)>>2]=1.0;m=m+1|0}while((m|0)!=(i|0));a=a+1|0}while((a|0)!=(j|0))}f[6472]=(f[6472]|0)+1;a=sc(1271)|0;if(!a)a=0;else{f[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}Bc(a,c,r,p,q);if(k&1|0){n[(f[a+720>>2]|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&2|0){n[(f[a+720>>2]|0)+((i+-1|0)*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&4|0){t=X(j+-1|0,i)|0;n[(f[a+720>>2]|0)+(t*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(k&8|0){t=i+-1+(X(j+-1|0,i)|0)|0;n[(f[a+720>>2]|0)+(t*104|0)+88>>2]=0.0;b[a+924>>0]=1}if(p|0){f[6473]=(f[6473]|0)+1;Cd(f[p+-4>>2]|0)}aI(q);if((j|0)<=0){l=a;return l|0}c=a+720|0;k=a+732|0;s=a+740|0;t=a+924|0;m=0;do a:do if((i|0)>0){h=X(m,i)|0;r=m+1|0;d=X(r,i)|0;if((r|0)<(j|0))o=0;else{m=0;while(1){o=m;m=m+1|0;if((m|0)<(i|0)){q=m+h|0;d=f[c>>2]|0;_h(a,0);g=(f[k>>2]|0)+-1|0;e=f[s>>2]|0;f[e+(g*52|0)+8>>2]=d+((o+h|0)*104|0);f[e+(g*52|0)+12>>2]=d+(q*104|0);y=+n[d+((o+h|0)*104|0)+8>>2]-+n[d+(q*104|0)+8>>2];z=+n[d+((o+h|0)*104|0)+12>>2]-+n[d+(q*104|0)+12>>2];A=+n[d+((o+h|0)*104|0)+16>>2]-+n[d+(q*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[e+(g*52|0)+16>>2]=A;b[t>>0]=1}if((m|0)==(i|0)){m=r;break a}}}do{q=o+h|0;p=o;o=o+1|0;do if((o|0)<(i|0)){e=o+h|0;B=f[c>>2]|0;_h(a,0);C=(f[k>>2]|0)+-1|0;g=f[s>>2]|0;f[g+(C*52|0)+8>>2]=B+(q*104|0);f[g+(C*52|0)+12>>2]=B+(e*104|0);A=+n[B+(q*104|0)+8>>2]-+n[B+(e*104|0)+8>>2];z=+n[B+(q*104|0)+12>>2]-+n[B+(e*104|0)+12>>2];y=+n[B+(q*104|0)+16>>2]-+n[B+(e*104|0)+16>>2];y=+L(+(A*A+z*z+y*y));n[g+(C*52|0)+16>>2]=y;b[t>>0]=1;C=f[c>>2]|0;_h(a,0);g=(f[k>>2]|0)+-1|0;B=f[s>>2]|0;f[B+(g*52|0)+8>>2]=C+(q*104|0);f[B+(g*52|0)+12>>2]=C+((p+d|0)*104|0);y=+n[C+(q*104|0)+8>>2]-+n[C+((p+d|0)*104|0)+8>>2];z=+n[C+(q*104|0)+12>>2]-+n[C+((p+d|0)*104|0)+12>>2];A=+n[C+(q*104|0)+16>>2]-+n[C+((p+d|0)*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[B+(g*52|0)+16>>2]=A;b[t>>0]=1;if(!(p+m&1)){$f(a,p+d|0,q,e,0);$f(a,p+d|0,e,o+d|0,0);if(!l)break;g=f[c>>2]|0;_h(a,0);C=(f[k>>2]|0)+-1|0;B=f[s>>2]|0;f[B+(C*52|0)+8>>2]=g+(e*104|0);f[B+(C*52|0)+12>>2]=g+((p+d|0)*104|0);y=+n[g+(e*104|0)+8>>2]-+n[g+((p+d|0)*104|0)+8>>2];z=+n[g+(e*104|0)+12>>2]-+n[g+((p+d|0)*104|0)+12>>2];A=+n[g+(e*104|0)+16>>2]-+n[g+((p+d|0)*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[B+(C*52|0)+16>>2]=A;b[t>>0]=1;break}else{g=o+d|0;$f(a,q,e,g,0);$f(a,q,g,p+d|0,0);if(!l)break;e=f[c>>2]|0;_h(a,0);C=(f[k>>2]|0)+-1|0;B=f[s>>2]|0;f[B+(C*52|0)+8>>2]=e+(q*104|0);f[B+(C*52|0)+12>>2]=e+(g*104|0);y=+n[e+(q*104|0)+8>>2]-+n[e+(g*104|0)+8>>2];z=+n[e+(q*104|0)+12>>2]-+n[e+(g*104|0)+12>>2];A=+n[e+(q*104|0)+16>>2]-+n[e+(g*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[B+(C*52|0)+16>>2]=A;b[t>>0]=1;break}}else{g=f[c>>2]|0;_h(a,0);C=(f[k>>2]|0)+-1|0;B=f[s>>2]|0;f[B+(C*52|0)+8>>2]=g+(q*104|0);f[B+(C*52|0)+12>>2]=g+((p+d|0)*104|0);y=+n[g+(q*104|0)+8>>2]-+n[g+((p+d|0)*104|0)+8>>2];z=+n[g+(q*104|0)+12>>2]-+n[g+((p+d|0)*104|0)+12>>2];A=+n[g+(q*104|0)+16>>2]-+n[g+((p+d|0)*104|0)+16>>2];A=+L(+(y*y+z*z+A*A));n[B+(C*52|0)+16>>2]=A;b[t>>0]=1}while(0)}while((o|0)!=(i|0));m=r}else m=m+1|0;while(0);while((m|0)!=(j|0));return a|0}function sd(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=+g;var h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0;B=u;u=u+272|0;f[B+128>>2]=f[c>>2];f[B+128+4>>2]=f[c+4>>2];f[B+128+8>>2]=f[c+8>>2];f[B+128+12>>2]=f[c+12>>2];f[B+128+16>>2]=f[c+16>>2];f[B+128+16+4>>2]=f[c+16+4>>2];f[B+128+16+8>>2]=f[c+16+8>>2];f[B+128+16+12>>2]=f[c+16+12>>2];f[B+128+32>>2]=f[c+32>>2];f[B+128+32+4>>2]=f[c+32+4>>2];f[B+128+32+8>>2]=f[c+32+8>>2];f[B+128+32+12>>2]=f[c+32+12>>2];f[B+128+48>>2]=f[c+48>>2];f[B+128+48+4>>2]=f[c+48+4>>2];f[B+128+48+8>>2]=f[c+48+8>>2];f[B+128+48+12>>2]=f[c+48+12>>2];f[B+64>>2]=f[d>>2];f[B+64+4>>2]=f[d+4>>2];f[B+64+8>>2]=f[d+8>>2];f[B+64+12>>2]=f[d+12>>2];f[B+64+16>>2]=f[d+16>>2];f[B+64+16+4>>2]=f[d+16+4>>2];f[B+64+16+8>>2]=f[d+16+8>>2];f[B+64+16+12>>2]=f[d+16+12>>2];f[B+64+32>>2]=f[d+32>>2];f[B+64+32+4>>2]=f[d+32+4>>2];f[B+64+32+8>>2]=f[d+32+8>>2];f[B+64+32+12>>2]=f[d+32+12>>2];f[B+64+48>>2]=f[d+48>>2];f[B+64+48+4>>2]=f[d+48+4>>2];f[B+64+48+8>>2]=f[d+48+8>>2];f[B+64+48+12>>2]=f[d+48+12>>2];h=+n[B+64+52>>2]-+n[B+128+52>>2];G=+n[B+64+56>>2]-+n[B+128+56>>2];n[B+16>>2]=+n[B+64+48>>2]-+n[B+128+48>>2];n[B+16+4>>2]=h;n[B+16+8>>2]=G;n[B+16+12>>2]=0.0;Ef(B+128|0,B+64|0,B+208|0,B+192|0);G=+n[B+192>>2];h=G*+n[B+208+4>>2];D=G*+n[B+208+8>>2];n[B>>2]=+n[B+208>>2]*G;n[B+4>>2]=h;n[B+8>>2]=D;n[B+12>>2]=0.0;f[B+208+48>>2]=0;f[B+208+48+4>>2]=0;f[B+208+48+8>>2]=0;f[B+208+48+12>>2]=0;mh(B+128|0,B+192|0);D=+n[B+192>>2];h=+n[B+192+4>>2];G=+n[B+192+8>>2];E=+n[B+192+12>>2];C=D*(2.0/(D*D+h*h+G*G+E*E));i=h*(2.0/(D*D+h*h+G*G+E*E));F=G*(2.0/(D*D+h*h+G*G+E*E));n[B+208>>2]=1.0-(h*i+G*F);n[B+208+4>>2]=D*i-E*F;n[B+208+8>>2]=D*F+E*i;n[B+208+12>>2]=0.0;n[B+208+16>>2]=D*i+E*F;n[B+208+20>>2]=1.0-(D*C+G*F);n[B+208+24>>2]=h*F-E*C;n[B+208+28>>2]=0.0;n[B+208+32>>2]=D*F-E*i;n[B+208+36>>2]=h*F+E*C;n[B+208+40>>2]=1.0-(D*C+h*i);n[B+208+44>>2]=0.0;jh(b,B+208|0,B+16|0,B,B+48|0,B+32|0);if((f[a+268>>2]|0)<=0){u=B;return}j=0;do{k=f[(f[a+276>>2]|0)+(j<<2)>>2]|0;if(Db[f[(f[e>>2]|0)+8>>2]&31](e,f[k+188>>2]|0)|0?(z=f[k+192>>2]|0,Yb[f[(f[z>>2]|0)+8>>2]&127](z,k+4|0,B+192|0,B+16|0),l=+n[B+192>>2]+ +n[B+48>>2],m=+n[B+192+4>>2]+ +n[B+48+4>>2],o=+n[B+192+8>>2]+ +n[B+48+8>>2],n[B+192>>2]=l,n[B+192+4>>2]=m,n[B+192+8>>2]=o,n[B+192+12>>2]=0.0,p=+n[B+16>>2]+ +n[B+32>>2],q=+n[B+16+4>>2]+ +n[B+32+4>>2],r=+n[B+16+8>>2]+ +n[B+32+8>>2],n[B+16>>2]=p,n[B+16+4>>2]=q,n[B+16+8>>2]=r,n[B+16+12>>2]=0.0,s=+n[c+48>>2]-(p+l)*.5,t=+n[c+52>>2]-(q+m)*.5,v=+n[c+56>>2]-(r+o)*.5,w=+n[d+48>>2]-(p+l)*.5,x=+n[d+52>>2]-(q+m)*.5,y=+n[d+56>>2]-(r+o)*.5,z=(s>(p-l)*.5?8:0)|s<-((p-l)*.5)|(t<-((q-m)*.5)?2:0)|(t>(q-m)*.5?16:0)|(v<-((r-o)*.5)?4:0)|(v>(r-o)*.5?32:0),A=(w>(p-l)*.5?8:0)|w<-((p-l)*.5)|(x<-((q-m)*.5)?2:0)|(x>(q-m)*.5?16:0)|(y<-((r-o)*.5)?4:0)|(y>(r-o)*.5?32:0),(z&A|0)==0):0){if(s<-((p-l)*.5))if(!((-s-(p-l)*.5)/(w-s)>=0.0)){h=0.0;i=1.0}else{h=(-s-(p-l)*.5)/(w-s);i=1.0}else if(w<-((p-l)*.5)?(-s-(p-l)*.5)/(w-s)<1.0:0){h=0.0;i=(-s-(p-l)*.5)/(w-s)}else{h=0.0;i=1.0}if(t<-((q-m)*.5)){if(h<=(-t-(q-m)*.5)/(x-t))h=(-t-(q-m)*.5)/(x-t)}else if(x<-((q-m)*.5)?(-t-(q-m)*.5)/(x-t)<i:0)i=(-t-(q-m)*.5)/(x-t);if(v<-((r-o)*.5)){if(h<=(-v-(r-o)*.5)/(y-v))h=(-v-(r-o)*.5)/(y-v)}else if(y<-((r-o)*.5)?(-v-(r-o)*.5)/(y-v)<i:0)i=(-v-(r-o)*.5)/(y-v);if(s>(p-l)*.5){if(h<=((p-l)*.5-s)/(w-s))h=((p-l)*.5-s)/(w-s)}else if(w>(p-l)*.5?((p-l)*.5-s)/(w-s)<i:0)i=((p-l)*.5-s)/(w-s);if(t>(q-m)*.5){if(h<=((q-m)*.5-t)/(x-t))h=((q-m)*.5-t)/(x-t)}else if(x>(q-m)*.5?((q-m)*.5-t)/(x-t)<i:0)i=((q-m)*.5-t)/(x-t);if(!(z&32)){if((A&32|0)!=0?((r-o)*.5-v)/(y-v)<i:0)i=((r-o)*.5-v)/(y-v)}else if(h<=((r-o)*.5-v)/(y-v))h=((r-o)*.5-v)/(y-v);if(h<=i){H=f[k+192>>2]|0;f[B+208>>2]=0;f[B+208+4>>2]=H;f[B+208+8>>2]=k;f[B+208+12>>2]=k+4;f[B+208+16>>2]=-1;f[B+208+20>>2]=-1;zc(b,B+128|0,B+64|0,B+208|0,e,g)}}j=j+1|0}while((j|0)<(f[a+268>>2]|0));u=B;return}function td(a,c){a=a|0;c=c|0;var d=0.0,e=0.0,g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;q=f[a+28>>2]|0;j=f[a+32>>2]|0;xc(a,q+4|0,j+4|0,q+264|0,j+264|0);i=f[c+8>>2]|0;n[i>>2]=1.0;k=f[c+24>>2]|0;n[i+(k+1<<2)>>2]=1.0;n[i+((k<<1)+2<<2)>>2]=1.0;l=+n[a+348>>2];u=+n[a+352>>2];o=+n[a+356>>2];s=+n[q+4>>2]*l+ +n[q+8>>2]*u+ +n[q+12>>2]*o;m=l*+n[q+20>>2]+u*+n[q+24>>2]+o*+n[q+28>>2];o=l*+n[q+36>>2]+u*+n[q+40>>2]+o*+n[q+44>>2];i=f[c+12>>2]|0;f[i>>2]=0;n[i+4>>2]=o;n[i+8>>2]=-m;n[i+12>>2]=0.0;n[i+(k<<2)>>2]=-o;f[i+(k<<2)+4>>2]=0;n[i+(k<<2)+8>>2]=s;n[i+(k<<2)+12>>2]=0.0;n[i+(k<<1<<2)>>2]=m;n[i+(k<<1<<2)+4>>2]=-s;f[i+(k<<1<<2)+8>>2]=0;n[i+(k<<1<<2)+12>>2]=0.0;i=f[c+16>>2]|0;n[i>>2]=-1.0;n[i+(k+1<<2)>>2]=-1.0;n[i+((k<<1)+2<<2)>>2]=-1.0;u=+n[a+412>>2];l=+n[a+416>>2];e=+n[a+420>>2];t=+n[j+4>>2]*u+ +n[j+8>>2]*l+ +n[j+12>>2]*e;d=u*+n[j+20>>2]+l*+n[j+24>>2]+e*+n[j+28>>2];e=u*+n[j+36>>2]+l*+n[j+40>>2]+e*+n[j+44>>2];k=f[c+20>>2]|0;i=f[c+24>>2]|0;f[k>>2]=0;n[k+4>>2]=-e;n[k+8>>2]=d;n[k+12>>2]=0.0;n[k+(i<<2)>>2]=e;f[k+(i<<2)+4>>2]=0;n[k+(i<<2)+8>>2]=-t;n[k+(i<<2)+12>>2]=0.0;n[k+(i<<1<<2)>>2]=-d;n[k+(i<<1<<2)+4>>2]=t;f[k+(i<<1<<2)+8>>2]=0;n[k+(i<<1<<2)+12>>2]=0.0;p=f[a+592>>2]|0;l=+n[(p&2|0?a+600|0:c+4|0)>>2]*+n[c>>2];h=f[c+28>>2]|0;r=f[c+36>>2]|0;g=f[c+40>>2]|0;n[h>>2]=l*(t+ +n[j+52>>2]-s-+n[q+52>>2]);n[r>>2]=-3402823466385288598117041.0e14;n[g>>2]=3402823466385288598117041.0e14;if(!(p&1)){n[h+(i<<2)>>2]=l*(d+ +n[j+56>>2]-m-+n[q+56>>2]);n[r+(i<<2)>>2]=-3402823466385288598117041.0e14;n[g+(i<<2)>>2]=3402823466385288598117041.0e14;n[h+(i<<1<<2)>>2]=l*(e+ +n[j+60>>2]-o-+n[q+60>>2]);n[r+(i<<1<<2)>>2]=-3402823466385288598117041.0e14;n[g+(i<<1<<2)>>2]=3402823466385288598117041.0e14}else{v=f[c+32>>2]|0;f[v>>2]=f[a+596>>2];n[h+(i<<2)>>2]=l*(d+ +n[j+56>>2]-m-+n[q+56>>2]);n[r+(i<<2)>>2]=-3402823466385288598117041.0e14;n[g+(i<<2)>>2]=3402823466385288598117041.0e14;f[v+(i<<2)>>2]=f[a+596>>2];n[h+(i<<1<<2)>>2]=l*(e+ +n[j+60>>2]-o-+n[q+60>>2]);n[r+(i<<1<<2)>>2]=-3402823466385288598117041.0e14;n[g+(i<<1<<2)>>2]=3402823466385288598117041.0e14;f[v+(i<<1<<2)>>2]=f[a+596>>2]}if(!(b[a+526>>0]|0)){k=i*3|0;i=r}else{j=f[c+12>>2]|0;u=+n[a+456>>2];if(+n[a+444>>2]<u?+n[a+448>>2]<u:0){z=+n[q+4>>2];y=+n[q+8>>2];x=+n[q+12>>2];D=+n[a+304>>2];C=+n[a+320>>2];B=+n[a+336>>2];l=+n[a+308>>2];o=+n[a+324>>2];t=+n[a+340>>2];w=+n[q+20>>2];d=+n[q+24>>2];e=+n[q+28>>2];m=+n[q+36>>2];s=+n[q+40>>2];u=+n[q+44>>2];n[j+(i*3<<2)>>2]=z*D+y*C+x*B;n[j+((i*3|0)+1<<2)>>2]=D*w+C*d+B*e;n[j+((i*3|0)+2<<2)>>2]=D*m+C*s+B*u;n[j+(i<<2<<2)>>2]=z*l+y*o+x*t;n[j+((i<<2|1)<<2)>>2]=l*w+o*d+t*e;n[j+((i<<2|2)<<2)>>2]=l*m+o*s+t*u;n[k+(i*3<<2)>>2]=-(z*D+y*C+x*B);n[k+((i*3|0)+1<<2)>>2]=-(D*w+C*d+B*e);n[k+((i*3|0)+2<<2)>>2]=-(D*m+C*s+B*u);n[k+(i<<2<<2)>>2]=-(z*l+y*o+x*t);n[k+((i<<2|1)<<2)>>2]=-(l*w+o*d+t*e);n[k+((i<<2|2)<<2)>>2]=-(l*m+o*s+t*u);A=+n[c>>2]*+n[a+436>>2];h=f[c+28>>2]|0;n[h+(i*3<<2)>>2]=A*((z*D+y*C+x*B)*+n[a+460>>2]+(D*w+C*d+B*e)*+n[a+464>>2]+(D*m+C*s+B*u)*+n[a+468>>2]);n[h+(i<<2<<2)>>2]=A*((z*l+y*o+x*t)*+n[a+460>>2]+(l*w+o*d+t*e)*+n[a+464>>2]+(l*m+o*s+t*u)*+n[a+468>>2]);j=f[c+36>>2]|0;n[j+(i*3<<2)>>2]=-3402823466385288598117041.0e14;g=f[c+40>>2]|0;n[g+(i*3<<2)>>2]=3402823466385288598117041.0e14;n[j+(i<<2<<2)>>2]=-3402823466385288598117041.0e14;k=i<<2;i=f[c+24>>2]|0}else{D=+n[a+436>>2];B=D*+n[a+460>>2]*D;C=D*D*+n[a+464>>2];D=D*D*+n[a+468>>2];n[j+(i*3<<2)>>2]=B;n[j+((i*3|0)+1<<2)>>2]=C;n[j+((i*3|0)+2<<2)>>2]=D;n[k+(i*3<<2)>>2]=-B;n[k+((i*3|0)+1<<2)>>2]=-C;n[k+((i*3|0)+2<<2)>>2]=-D;n[h+(i*3<<2)>>2]=+n[c>>2]*+n[a+432>>2]*+n[a+504>>2];if(p&4|0)f[(f[c+32>>2]|0)+(i*3<<2)>>2]=f[a+604>>2];n[r+(i*3<<2)>>2]=0.0;k=i*3|0;j=r}n[g+(k<<2)>>2]=3402823466385288598117041.0e14;k=i+k|0;i=j}if(!(b[a+525>>0]|0))return;D=+n[a+436>>2];B=D*+n[a+476>>2]*D;C=D*D*+n[a+480>>2];D=D*D*+n[a+484>>2];p=f[c+12>>2]|0;r=f[c+20>>2]|0;n[p+(k<<2)>>2]=B;q=k+1|0;n[p+(q<<2)>>2]=C;v=k+2|0;n[p+(v<<2)>>2]=D;n[r+(k<<2)>>2]=-B;n[r+(q<<2)>>2]=-C;n[r+(v<<2)>>2]=-D;n[h+(k<<2)>>2]=+n[c>>2]*+n[a+432>>2]*+n[a+508>>2];if(f[a+592>>2]&4|0)f[(f[c+32>>2]|0)+(k<<2)>>2]=f[a+604>>2];if(+n[a+452>>2]>0.0){v=+n[a+508>>2]>0.0;d=v?0.0:-3402823466385288598117041.0e14;e=v?3402823466385288598117041.0e14:0.0}else{d=-3402823466385288598117041.0e14;e=3402823466385288598117041.0e14}n[i+(k<<2)>>2]=d;n[g+(k<<2)>>2]=e;return}function ud(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;c=f[a+8>>2]|0;if((c|0)<=0)return;e=0;do{d=f[(f[a+16>>2]|0)+(e<<2)>>2]|0;if((f[d+236>>2]|0)==1){Rb[f[(f[d>>2]|0)+24>>2]&127](d,b);c=f[a+8>>2]|0}e=e+1|0}while((e|0)<(c|0));h=c;if((h|0)<=0)return;z=0;m=0;r=0;q=0;g=0;e=0;p=0;w=0;v=0;d=0;o=0;n=0;c=0;k=0;x=0;while(1){y=f[(f[(f[a+16>>2]|0)+(z<<2)>>2]|0)+192>>2]|0;s=(~(y<<15)+y>>10^~(y<<15)+y)*9|0;s=(s>>6^s)+~((s>>6^s)<<11)>>16^(s>>6^s)+~((s>>6^s)<<11);i=s&n+-1;a:do if(i>>>0<p>>>0?(A=f[e+(i<<2)>>2]|0,(A|0)!=-1):0){i=A;while(1){if((f[g+(i<<3)>>2]|0)==(y|0))break;i=f[d+(i<<2)>>2]|0;if((i|0)==-1){F=13;break a}}if(c+(i<<2)|0){l=w;j=v;i=x}else F=13}else F=13;while(0);if((F|0)==13){F=0;l=s&n+-1;b:do if(l>>>0<p>>>0?(B=f[e+(l<<2)>>2]|0,(B|0)!=-1):0){h=B;while(1){if((f[g+(h<<3)>>2]|0)==(y|0))break;h=f[d+(h<<2)>>2]|0;if((h|0)==-1){F=18;break b}}f[c+(h<<2)>>2]=y;l=w;j=v;i=x}else F=18;while(0);if((F|0)==18){F=0;do if((o|0)==(n|0)){i=n|0?n<<1:1;if((n|0)<(i|0)){if((i|0)!=0?(f[6472]=(f[6472]|0)+1,E=sc((i<<2|3)+16|0)|0,(E|0)!=0):0){f[(E+4+15&-16)+-4>>2]=E;j=E+4+15&-16}else j=0;if((n|0)<=0){if(!c){u=i;c=j;h=n;break}}else{h=0;do{f[j+(h<<2)>>2]=f[c+(h<<2)>>2];h=h+1|0}while((h|0)!=(n|0))}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);u=i;c=j;h=n}else{u=n;h=n}}else{u=n;h=o}while(0);f[c+(h<<2)>>2]=y;t=h+1|0;do if((r|0)==(q|0)){i=r|0?r<<1:1;if((r|0)<(i|0)){if((i|0)!=0?(f[6472]=(f[6472]|0)+1,C=sc((i<<3|3)+16|0)|0,(C|0)!=0):0){f[(C+4+15&-16)+-4>>2]=C;j=C+4+15&-16}else j=0;if((r|0)<=0){if(!g){q=i;g=j;break}}else{h=0;do{H=g+(h<<3)|0;G=f[H+4>>2]|0;q=j+(h<<3)|0;f[q>>2]=f[H>>2];f[q+4>>2]=G;h=h+1|0}while((h|0)!=(r|0))}f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0);q=i;g=j}else q=r}while(0);H=g+(r<<3)|0;f[H>>2]=y;f[H+4>>2]=0;r=r+1|0;if((n|0)<(u|0)){if((p|0)<(u|0)){do if((m|0)<(u|0)){if((u|0)!=0?(f[6472]=(f[6472]|0)+1,D=sc((u<<2|3)+16|0)|0,(D|0)!=0):0){f[(D+4+15&-16)+-4>>2]=D;i=D+4+15&-16}else i=0;if((p|0)<=0){if(!e){m=u;e=i;n=i;break}}else{h=0;do{f[i+(h<<2)>>2]=f[e+(h<<2)>>2];h=h+1|0}while((h|0)!=(p|0))}f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);m=u;e=i;n=i}else n=x;while(0);l=u<<2;bl(e+(p<<2)|0,0,l-(p<<2)|0)|0;if((w|0)<(u|0)){do if((v|0)<(u|0)){do if(!u)i=0;else{f[6472]=(f[6472]|0)+1;h=sc((l|3)+16|0)|0;if(!h){i=0;break}f[(h+4+15&-16)+-4>>2]=h;i=h+4+15&-16}while(0);if((w|0)<=0){if(!d){j=u;d=i;h=i;break}}else{h=0;do{f[i+(h<<2)>>2]=f[d+(h<<2)>>2];h=h+1|0}while((h|0)!=(w|0))}f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);j=u;d=i;h=i}else{j=v;h=k}while(0);bl(d+(w<<2)|0,0,l-(w<<2)|0)|0;k=h}else j=v;if((u|0)>0){bl(n|0,-1,l|0)|0;bl(k|0,-1,l|0)|0}if((p|0)>0){i=u+-1|0;h=0;do{H=f[g+(h<<3)>>2]|0;H=(H+~(H<<15)>>10^H+~(H<<15))*9|0;H=e+((((H>>6^H)+~((H>>6^H)<<11)>>16^(H>>6^H)+~((H>>6^H)<<11))&i)<<2)|0;f[d+(h<<2)>>2]=f[H>>2];f[H>>2]=h;h=h+1|0}while((h|0)!=(p|0));i=u;l=u;h=n}else{i=u;l=u;h=n}}else{i=p;l=w;j=v;h=x}n=s&u+-1}else{n=l;i=p;l=w;j=v;h=x}p=e+(n<<2)|0;f[d+(o<<2)>>2]=f[p>>2];f[p>>2]=o;p=i;o=t;n=u;i=h}Rb[f[(f[y>>2]|0)+60>>2]&127](y,b);h=f[a+8>>2]|0}z=z+1|0;if((z|0)>=(h|0))break;else{w=l;v=j;x=i}}if(g|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}if(c|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}if(!e)return;f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0);return}function vd(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0;e=f[a+108>>2]|0;if(e|0)Vb[f[(f[e>>2]|0)+12>>2]&127](e,f[b+60>>2]|0,c);o=f[b+12>>2]|0;m=f[a+60>>2]|0;n=f[a+92>>2]|0;if(!(Bb[f[(f[n>>2]|0)+56>>2]&127](n)|0)){n=f[a+92>>2]|0;Vb[f[(f[n>>2]|0)+16>>2]&127](n,m+((o&65535)<<6)|0,c)}n=j[a+56>>1]|0;b=f[a+60>>2]|0;d[b+54>>1]=(j[b+54>>1]|0)+65534;d[b+56>>1]=(j[b+56>>1]|0)+65534;d[b+58>>1]=(j[b+58>>1]|0)+65534;l=f[a+68>>2]|0;e=d[a+6>>1]|0;c=j[m+((o&65535)<<6)+54>>1]|0;d[l+(c<<2)>>1]=e;g=d[l+(c<<2)+6>>1]|0;if(!(g<<16>>16))c=l;else{i=b+((j[l+(c<<2)+2>>1]|0)<<6)+54|0;h=l+(c<<2)|0;while(1){c=h;h=h+4|0;b=d[h>>1]|0;if((e&65535)<(b&65535))break;e=f[a+60>>2]|0;k=g&65535;b=(b&1)==0?e+(k<<6)+48|0:e+(k<<6)+54|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[i>>1]=(d[i>>1]|0)+1<<16>>16;b=j[c>>1]|j[c+2>>1]<<16;k=j[h>>1]|j[h+2>>1]<<16;d[c>>1]=k;d[c+2>>1]=k>>>16;d[h>>1]=b;d[h+2>>1]=b>>>16;g=d[c+10>>1]|0;if(!(g<<16>>16))break;else e=b&65535}e=d[a+6>>1]|0;c=f[a+68>>2]|0}b=j[m+((o&65535)<<6)+48>>1]|0;d[l+(b<<2)>>1]=e;h=c+(b<<2)|0;g=d[h+6>>1]|0;if(g<<16>>16){k=(f[a+60>>2]|0)+((j[c+(b<<2)+2>>1]|0)<<6)+48|0;i=h;c=d[h>>1]|0;while(1){e=i;i=i+4|0;b=d[i>>1]|0;if((c&65535)<(b&65535))break;c=f[a+60>>2]|0;h=g&65535;b=(b&1)==0?c+(h<<6)+48|0:c+(h<<6)+54|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[k>>1]=(d[k>>1]|0)+1<<16>>16;b=j[e>>1]|j[e+2>>1]<<16;h=j[i>>1]|j[i+2>>1]<<16;d[e>>1]=h;d[e+2>>1]=h>>>16;d[i>>1]=b;d[i+2>>1]=b>>>16;g=d[e+10>>1]|0;if(!(g<<16>>16))break;else c=b&65535}e=d[a+6>>1]|0}d[l+((n<<1)+-1<<2)+2>>1]=0;d[l+((n<<1)+-1<<2)>>1]=e;l=f[a+72>>2]|0;b=j[m+((o&65535)<<6)+56>>1]|0;d[l+(b<<2)>>1]=e;c=d[l+(b<<2)+6>>1]|0;if(!(c<<16>>16))c=l;else{i=(f[a+60>>2]|0)+((j[l+(b<<2)+2>>1]|0)<<6)+56|0;h=l+(b<<2)|0;while(1){g=h;h=h+4|0;b=d[h>>1]|0;if((e&65535)<(b&65535))break;e=f[a+60>>2]|0;k=c&65535;b=(b&1)==0?e+(k<<6)+50|0:e+(k<<6)+56|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[i>>1]=(d[i>>1]|0)+1<<16>>16;b=j[g>>1]|j[g+2>>1]<<16;k=j[h>>1]|j[h+2>>1]<<16;d[g>>1]=k;d[g+2>>1]=k>>>16;d[h>>1]=b;d[h+2>>1]=b>>>16;c=d[g+10>>1]|0;if(!(c<<16>>16))break;else e=b&65535}e=d[a+6>>1]|0;c=f[a+72>>2]|0}b=j[m+((o&65535)<<6)+50>>1]|0;d[l+(b<<2)>>1]=e;g=c+(b<<2)|0;h=d[g+6>>1]|0;if(h<<16>>16){k=(f[a+60>>2]|0)+((j[c+(b<<2)+2>>1]|0)<<6)+50|0;i=g;c=d[g>>1]|0;g=h;while(1){e=i;i=i+4|0;b=d[i>>1]|0;if((c&65535)<(b&65535))break;c=f[a+60>>2]|0;h=g&65535;b=(b&1)==0?c+(h<<6)+50|0:c+(h<<6)+56|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[k>>1]=(d[k>>1]|0)+1<<16>>16;b=j[e>>1]|j[e+2>>1]<<16;h=j[i>>1]|j[i+2>>1]<<16;d[e>>1]=h;d[e+2>>1]=h>>>16;d[i>>1]=b;d[i+2>>1]=b>>>16;g=d[e+10>>1]|0;if(!(g<<16>>16))break;else c=b&65535}e=d[a+6>>1]|0}d[l+((n<<1)+-1<<2)+2>>1]=0;d[l+((n<<1)+-1<<2)>>1]=e;l=f[a+76>>2]|0;b=j[m+((o&65535)<<6)+58>>1]|0;d[l+(b<<2)>>1]=e;c=d[l+(b<<2)+6>>1]|0;if(!(c<<16>>16))c=l;else{i=(f[a+60>>2]|0)+((j[l+(b<<2)+2>>1]|0)<<6)+58|0;h=l+(b<<2)|0;while(1){g=h;h=h+4|0;b=d[h>>1]|0;if((e&65535)<(b&65535))break;e=f[a+60>>2]|0;k=c&65535;b=(b&1)==0?e+(k<<6)+52|0:e+(k<<6)+58|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[i>>1]=(d[i>>1]|0)+1<<16>>16;b=j[g>>1]|j[g+2>>1]<<16;k=j[h>>1]|j[h+2>>1]<<16;d[g>>1]=k;d[g+2>>1]=k>>>16;d[h>>1]=b;d[h+2>>1]=b>>>16;c=d[g+10>>1]|0;if(!(c<<16>>16))break;else e=b&65535}e=d[a+6>>1]|0;c=f[a+76>>2]|0}b=j[m+((o&65535)<<6)+52>>1]|0;d[l+(b<<2)>>1]=e;g=c+(b<<2)|0;h=d[g+6>>1]|0;if(!(h<<16>>16)){k=e;m=l+((n<<1)+-1<<2)+2|0;d[m>>1]=0;m=l+((n<<1)+-1<<2)|0;d[m>>1]=k;m=f[a+60>>2]|0;n=a+64|0;l=d[n>>1]|0;m=m+((o&65535)<<6)+48|0;d[m>>1]=l;d[n>>1]=o;o=d[a+56>>1]|0;o=o+-1<<16>>16;d[a+56>>1]=o;return}k=(f[a+60>>2]|0)+((j[c+(b<<2)+2>>1]|0)<<6)+52|0;i=g;c=d[g>>1]|0;g=h;while(1){e=i;i=i+4|0;b=d[i>>1]|0;if((c&65535)<(b&65535))break;h=f[a+60>>2]|0;m=g&65535;b=(b&1)==0?h+(m<<6)+52|0:h+(m<<6)+58|0;d[b>>1]=(d[b>>1]|0)+-1<<16>>16;d[k>>1]=(d[k>>1]|0)+1<<16>>16;b=j[e>>1]|j[e+2>>1]<<16;m=j[i>>1]|j[i+2>>1]<<16;d[e>>1]=m;d[e+2>>1]=m>>>16;d[i>>1]=b;d[i+2>>1]=b>>>16;g=d[e+10>>1]|0;if(!(g<<16>>16))break;else c=b&65535}k=d[a+6>>1]|0;m=l+((n<<1)+-1<<2)+2|0;d[m>>1]=0;m=l+((n<<1)+-1<<2)|0;d[m>>1]=k;m=f[a+60>>2]|0;n=a+64|0;l=d[n>>1]|0;m=m+((o&65535)<<6)+48|0;d[m>>1]=l;d[n>>1]=o;o=d[a+56>>1]|0;o=o+-1<<16>>16;d[a+56>>1]=o;return}function wd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0,h=0,i=0,j=0.0,k=0,l=0.0,m=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0,Y=0,Z=0;Z=f[c+36>>2]|0;X=f[d+36>>2]|0;K=+n[Z+8>>2];N=+n[Z+12>>2];M=+n[Z+16>>2];g=f[X+8>>2]|0;R=+n[g+8>>2];S=+n[g+12>>2];T=+n[g+16>>2];c=f[X+12>>2]|0;O=+n[c+8>>2];P=+n[c+12>>2];Q=+n[c+16>>2];d=f[X+16>>2]|0;U=+n[d+8>>2];V=+n[d+12>>2];W=+n[d+16>>2];t=O-K-(R-K);A=P-N-(S-N);v=Q-M-(T-M);u=A*(W-M-(T-M))-v*(V-N-(S-N));B=v*(U-K-(R-K))-t*(W-M-(T-M));w=t*(V-N-(S-N))-A*(U-K-(R-K));do if(w*w+(u*u+B*B)>1.1920928955078125e-07?(D=1.0/+L(+(w*w+(u*u+B*B))),E=(T-M)*w*D+((R-K)*u*D+(S-N)*B*D),E*E<3402823466385288598117041.0e14):0){e=R-K-u*D*E;j=S-N-B*D*E;m=T-M-w*D*E;p=O-K-u*D*E;r=P-N-B*D*E;s=Q-M-w*D*E;if((w*(r*e-j*p)+(u*(j*s-m*r)+B*(m*p-s*e))>0.0?(x=U-K-u*D*E,y=V-N-B*D*E,z=W-M-w*D*E,w*(y*p-r*x)+(u*(r*z-s*y)+B*(s*x-z*p))>0.0):0)?w*(j*x-y*e)+(u*(y*m-z*j)+B*(z*e-m*x))>0.0:0){q=E*E;p=u*D*E;m=w*D*E;l=B*D*E;break}if(t*t+A*A+v*v>1.1920928955078125e-07?(C=-((R-K)*t+(S-N)*A+(T-M)*v)/(t*t+A*A+v*v),C=C<0.0?0.0:C>1.0?1.0:C,q=(T-M+v*C)*(T-M+v*C)+((R-K+t*C)*(R-K+t*C)+(S-N+A*C)*(S-N+A*C)),q<3402823466385288598117041.0e14):0){p=R-K+t*C;m=T-M+v*C;j=S-N+A*C}else{q=3402823466385288598117041.0e14;p=0.0;m=0.0;j=0.0}e=(U-K-(O-K))*(U-K-(O-K))+(V-N-(P-N))*(V-N-(P-N))+(W-M-(Q-M))*(W-M-(Q-M));if(e>1.1920928955078125e-07?(G=-((O-K)*(U-K-(O-K))+(P-N)*(V-N-(P-N))+(Q-M)*(W-M-(Q-M)))/e,G=G<0.0?0.0:G>1.0?1.0:G,F=O-K+(U-K-(O-K))*G,H=P-N+(V-N-(P-N))*G,G=Q-M+(W-M-(Q-M))*G,G*G+(F*F+H*H)<q):0){q=G*G+(F*F+H*H);p=F;m=G;j=H}e=(R-K-(U-K))*(R-K-(U-K))+(S-N-(V-N))*(S-N-(V-N))+(T-M-(W-M))*(T-M-(W-M));if(e>1.1920928955078125e-07?(J=-((U-K)*(R-K-(U-K))+(V-N)*(S-N-(V-N))+(W-M)*(T-M-(W-M)))/e,J=J<0.0?0.0:J>1.0?1.0:J,I=U-K+(R-K-(U-K))*J,l=V-N+(S-N-(V-N))*J,J=W-M+(T-M-(W-M))*J,J*J+(I*I+l*l)<q):0){q=J*J+(I*I+l*l);p=I;m=J}else l=j}else{q=3402823466385288598117041.0e14;p=0.0;m=0.0;l=0.0}while(0);I=K-+n[Z+24>>2];J=N-+n[Z+28>>2];u=M-+n[Z+32>>2];u=+n[a+12>>2]+ +L(+(I*I+J*J+u*u))*2.0;if(!(q<u*u))return;r=K+p;e=N+l;j=M+m;t=+L(+(((R-r)*(P-e)-(S-e)*(O-r))*((R-r)*(P-e)-(S-e)*(O-r))+(((S-e)*(Q-j)-(T-j)*(P-e))*((S-e)*(Q-j)-(T-j)*(P-e))+((T-j)*(O-r)-(R-r)*(Q-j))*((T-j)*(O-r)-(R-r)*(Q-j)))));s=+L(+(((O-r)*(V-e)-(P-e)*(U-r))*((O-r)*(V-e)-(P-e)*(U-r))+(((P-e)*(W-j)-(Q-j)*(V-e))*((P-e)*(W-j)-(Q-j)*(V-e))+((Q-j)*(U-r)-(O-r)*(W-j))*((Q-j)*(U-r)-(O-r)*(W-j)))));r=+L(+(((S-e)*(U-r)-(R-r)*(V-e))*((S-e)*(U-r)-(R-r)*(V-e))+(((T-j)*(V-e)-(S-e)*(W-j))*((T-j)*(V-e)-(S-e)*(W-j))+((R-r)*(W-j)-(T-j)*(U-r))*((R-r)*(W-j)-(T-j)*(U-r)))));j=+n[Z+88>>2];V=+n[g+88>>2];W=+n[c+88>>2];e=+n[d+88>>2];e=!(V<=0.0)&!(W<=0.0)&!(e<=0.0)?V*s*(1.0/(t+s+r))+W*r*(1.0/(t+s+r))+t*(1.0/(t+s+r))*e:0.0;if(!(j+e>0.0))return;W=1.0/-+L(+q);q=p*W;p=l*W;m=m*W;o=f[a+4>>2]|0;c=f[a+8>>2]|0;k=f[(+n[o+316>>2]>+n[c+316>>2]?o+316|0:c+316|0)>>2]|0;l=j/(j+e)*+n[o+332>>2];e=e/(j+e)*+n[c+332>>2];c=f[o+832>>2]|0;if((c|0)==(f[o+836>>2]|0)?(Y=c|0?c<<1:1,(c|0)<(Y|0)):0){if(!Y)i=0;else{f[6472]=(f[6472]|0)+1;c=sc((Y*56|3)+16|0)|0;if(!c)c=0;else{f[(c+4+15&-16)+-4>>2]=c;c=c+4+15&-16}i=c;c=f[o+832>>2]|0}if((c|0)>0){d=0;do{g=i+(d*56|0)|0;a=(f[o+840>>2]|0)+(d*56|0)|0;h=g+56|0;do{f[g>>2]=f[a>>2];g=g+4|0;a=a+4|0}while((g|0)<(h|0));d=d+1|0}while((d|0)!=(c|0))}c=f[o+840>>2]|0;if(c|0){if(b[o+844>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[o+840>>2]=0}b[o+844>>0]=1;f[o+840>>2]=i;f[o+836>>2]=Y;c=f[o+832>>2]|0}Y=f[o+840>>2]|0;f[Y+(c*56|0)>>2]=Z;f[Y+(c*56|0)+4>>2]=X;n[Y+(c*56|0)+8>>2]=s*(1.0/(t+s+r));n[Y+(c*56|0)+12>>2]=r*(1.0/(t+s+r));n[Y+(c*56|0)+16>>2]=t*(1.0/(t+s+r));n[Y+(c*56|0)+20>>2]=0.0;n[Y+(c*56|0)+24>>2]=q;n[Y+(c*56|0)+28>>2]=p;n[Y+(c*56|0)+32>>2]=m;n[Y+(c*56|0)+36>>2]=0.0;n[Y+(c*56|0)+40>>2]=u;f[Y+(c*56|0)+44>>2]=k;n[Y+(c*56|0)+48>>2]=l;n[Y+(c*56|0)+52>>2]=e;f[o+832>>2]=(f[o+832>>2]|0)+1;return}function xd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,v=0,w=0.0,x=0.0;t=u;u=u+672|0;f[t+448+8>>2]=0;f[t+448+12>>2]=1065353216;f[t+448+16>>2]=1065353216;f[t+448+20>>2]=1065353216;n[t+448+24>>2]=0.0;f[t+448>>2]=6864;f[t+448+4>>2]=8;n[t+448+28>>2]=0.0;n[t+448+44>>2]=0.0;n[t+384>>2]=1.0;f[t+384+4>>2]=0;f[t+384+4+4>>2]=0;f[t+384+4+8>>2]=0;f[t+384+4+12>>2]=0;n[t+384+20>>2]=1.0;f[t+384+24>>2]=0;f[t+384+24+4>>2]=0;f[t+384+24+8>>2]=0;f[t+384+24+12>>2]=0;n[t+384+40>>2]=1.0;n[t+384+44>>2]=0.0;f[t+384+48>>2]=f[a>>2];f[t+384+48+4>>2]=f[a+4>>2];f[t+384+48+8>>2]=f[a+8>>2];f[t+384+48+12>>2]=f[a+12>>2];Hf(b,c,t+448|0,t+384|0,d,t+504|0,0);f[t+364>>2]=0;f[t+128>>2]=0;f[t+128+4>>2]=0;f[t+128+8>>2]=0;f[t+128+12>>2]=0;f[t+376>>2]=2;f[t+368>>2]=0;n[t+144>>2]=0.0;f[t+648>>2]=1065353216;f[t+648+4>>2]=1065353216;f[t+648+8>>2]=1065353216;n[t+648+12>>2]=0.0;switch(Jc(t,t+504|0,t+648|0)|0){case 0:{a=f[t+372>>2]|0;if(!(f[a+32>>2]|0)){i=0.0;h=0.0;e=0.0;p=0.0;m=0.0;g=0.0}else{s=0;g=0.0;m=0.0;p=0.0;e=0.0;h=0.0;i=0.0;do{r=+n[a+16+(s<<2)>>2];j=f[t+504+120>>2]|0;v=f[t+504+124>>2]|0;o=(f[t+504>>2]|0)+(v>>1)|0;if(v&1)j=f[(f[o>>2]|0)+j>>2]|0;Vb[j&127](t+648|0,o,f[a+(s<<2)>>2]|0);e=e+r*+n[t+648>>2];h=h+r*+n[t+648+4>>2];i=i+r*+n[t+648+8>>2];a=f[(f[t+372>>2]|0)+(s<<2)>>2]|0;q=-+n[a>>2];k=-+n[a+4>>2];l=-+n[a+8>>2];a=f[t+504+120>>2]|0;v=f[t+504+124>>2]|0;j=(f[t+504+4>>2]|0)+(v>>1)|0;if(v&1)a=f[(f[j>>2]|0)+a>>2]|0;x=+n[t+504+24>>2]*q+ +n[t+504+28>>2]*k+ +n[t+504+32>>2]*l;w=+n[t+504+40>>2]*q+ +n[t+504+44>>2]*k+ +n[t+504+48>>2]*l;n[t+632>>2]=+n[t+504+8>>2]*q+ +n[t+504+12>>2]*k+ +n[t+504+16>>2]*l;n[t+632+4>>2]=x;n[t+632+8>>2]=w;n[t+632+12>>2]=0.0;Vb[a&127](t+648|0,j,t+632|0);k=+n[t+648>>2];l=+n[t+648+4>>2];q=+n[t+648+8>>2];g=g+r*(k*+n[t+504+56>>2]+l*+n[t+504+60>>2]+q*+n[t+504+64>>2]+ +n[t+504+104>>2]);m=m+r*(k*+n[t+504+72>>2]+l*+n[t+504+76>>2]+q*+n[t+504+80>>2]+ +n[t+504+108>>2]);p=p+r*(k*+n[t+504+88>>2]+l*+n[t+504+92>>2]+q*+n[t+504+96>>2]+ +n[t+504+112>>2]);s=s+1|0;a=f[t+372>>2]|0}while(s>>>0<(f[a+32>>2]|0)>>>0)}q=e*+n[c>>2]+h*+n[c+4>>2]+i*+n[c+8>>2]+ +n[c+48>>2];r=e*+n[c+16>>2]+h*+n[c+20>>2]+i*+n[c+24>>2]+ +n[c+52>>2];i=e*+n[c+32>>2]+h*+n[c+36>>2]+i*+n[c+40>>2]+ +n[c+56>>2];n[d+4>>2]=q;n[d+8>>2]=r;n[d+12>>2]=i;n[d+16>>2]=0.0;k=g*+n[c>>2]+m*+n[c+4>>2]+p*+n[c+8>>2]+ +n[c+48>>2];l=g*+n[c+16>>2]+m*+n[c+20>>2]+p*+n[c+24>>2]+ +n[c+52>>2];h=g*+n[c+32>>2]+m*+n[c+36>>2]+p*+n[c+40>>2]+ +n[c+56>>2];n[d+20>>2]=k;n[d+24>>2]=l;n[d+28>>2]=h;n[d+32>>2]=0.0;switch(f[b+4>>2]|0){case 8:{e=+n[b+28>>2]*+n[b+12>>2];break}case 0:{e=+n[b+44>>2];break}case 1:{e=+n[b+44>>2];break}case 13:{e=+n[b+44>>2];break}case 11:{e=+n[b+44>>2];break}case 10:{e=+n[b+44>>2];break}case 4:case 5:{e=+n[b+44>>2];break}default:e=+rb[f[(f[b>>2]|0)+48>>2]&15](b)}switch(f[t+448+4>>2]|0){case 8:{g=+n[t+448+28>>2]*+n[t+448+12>>2];break}case 0:{g=+n[t+448+44>>2];break}case 1:{g=+n[t+448+44>>2];break}case 13:{g=+n[t+448+44>>2];break}case 11:{g=+n[t+448+44>>2];break}case 10:{g=+n[t+448+44>>2];break}case 4:case 5:{g=+n[t+448+44>>2];break}default:g=+rb[f[(f[t+448>>2]|0)+48>>2]&15](t+448|0)}x=e+g;w=+L(+((k-q)*(k-q)+(l-r)*(l-r)+(h-i)*(h-i)));n[d+36>>2]=(k-q)*(1.0/w);n[d+40>>2]=(l-r)*(1.0/w);n[d+44>>2]=(h-i)*(1.0/w);n[d+48>>2]=0.0;n[d+4>>2]=x*(k-q)*(1.0/w)+ +n[d+4>>2];n[d+8>>2]=x*(l-r)*(1.0/w)+ +n[d+8>>2];n[d+12>>2]=x*(h-i)*(1.0/w)+ +n[d+12>>2];x=w-x;u=t;return +x}case 1:{if(!(Pc(b,c,t+448|0,t+384|0,t+128|0,d,1)|0)){x=3402823466385288598117041.0e14;u=t;return +x}e=+n[d+4>>2]-+n[d+20>>2];g=+n[d+8>>2]-+n[d+24>>2];h=+n[d+12>>2]-+n[d+28>>2];i=+L(+(e*e+g*g+h*h));if(i>=1.1920928955078125e-07){n[d+36>>2]=e*(1.0/i);n[d+40>>2]=g*(1.0/i);n[d+44>>2]=h*(1.0/i);n[d+48>>2]=0.0}x=-i;u=t;return +x}default:{x=3402823466385288598117041.0e14;u=t;return +x}}return 0.0}function yd(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0;o=u;u=u+64|0;n[a+20>>2]=+p[c+32>>3];n[a+24>>2]=+p[c+40>>3];n[a+28>>2]=+p[c+48>>3];n[a+32>>2]=+p[c+56>>3];n[a+4>>2]=+p[c>>3];n[a+8>>2]=+p[c+8>>3];n[a+12>>2]=+p[c+16>>3];n[a+16>>2]=+p[c+24>>3];n[a+36>>2]=+p[c+64>>3];n[a+40>>2]=+p[c+72>>3];n[a+44>>2]=+p[c+80>>3];n[a+48>>2]=+p[c+88>>3];f[a+56>>2]=f[c+96>>2];b[a+60>>0]=(f[c+100>>2]|0)!=0&1;m=f[c+104>>2]|0;i=o;k=i+64|0;do{f[i>>2]=0;i=i+4|0}while((i|0)<(k|0));l=f[a+88>>2]|0;if((l|0)<(m|0)){if((f[a+92>>2]|0)<(m|0)){if(!m){e=0;h=l}else{f[6472]=(f[6472]|0)+1;e=sc(m<<6|19)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+88>>2]|0}if((h|0)>0){g=0;do{i=e+(g<<6)|0;j=(f[a+96>>2]|0)+(g<<6)|0;k=i+64|0;do{f[i>>2]=f[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));g=g+1|0}while((g|0)!=(h|0))}g=f[a+96>>2]|0;if(g|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=e;f[a+92>>2]=m;g=a+96|0}else g=a+96|0;e=l;do{i=(f[g>>2]|0)+(e<<6)|0;j=o;k=i+64|0;do{f[i>>2]=f[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));e=e+1|0}while((e|0)!=(m|0))}f[a+88>>2]=m;if((m|0)>0){h=f[a+96>>2]|0;e=f[c+112>>2]|0;g=0;while(1){n[h+(g<<6)+16>>2]=+p[e+32>>3];n[h+(g<<6)+20>>2]=+p[e+40>>3];n[h+(g<<6)+24>>2]=+p[e+48>>3];n[h+(g<<6)+28>>2]=+p[e+56>>3];n[h+(g<<6)>>2]=+p[e>>3];n[h+(g<<6)+4>>2]=+p[e+8>>3];n[h+(g<<6)+8>>2]=+p[e+16>>3];n[h+(g<<6)+12>>2]=+p[e+24>>3];f[h+(g<<6)+32>>2]=f[e+64>>2];f[h+(g<<6)+36>>2]=f[e+68>>2];f[h+(g<<6)+40>>2]=f[e+72>>2];g=g+1|0;if((g|0)==(m|0))break;else e=e+80|0}}j=f[c+108>>2]|0;f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;f[o+12>>2]=0;i=f[a+128>>2]|0;if((i|0)<(j|0)){if((f[a+132>>2]|0)<(j|0)){if(!j){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc((j<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+128>>2]|0}if((h|0)>0){g=0;do{m=e+(g<<4)|0;l=(f[a+136>>2]|0)+(g<<4)|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+136>>2]|0;if(g|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=e;f[a+132>>2]=j;g=a+136|0}else g=a+136|0;e=i;do{m=(f[g>>2]|0)+(e<<4)|0;f[m>>2]=f[o>>2];f[m+4>>2]=f[o+4>>2];f[m+8>>2]=f[o+8>>2];f[m+12>>2]=f[o+12>>2];e=e+1|0}while((e|0)!=(j|0))}f[a+128>>2]=j;if((j|0)>0){h=f[a+136>>2]|0;e=0;g=f[c+116>>2]|0;while(1){f[h+(e<<4)+12>>2]=f[g+12>>2];d[h+(e<<4)+6>>1]=d[g+6>>1]|0;d[h+(e<<4)+8>>1]=d[g+8>>1]|0;d[h+(e<<4)+10>>1]=d[g+10>>1]|0;d[h+(e<<4)>>1]=d[g>>1]|0;d[h+(e<<4)+2>>1]=d[g+2>>1]|0;d[h+(e<<4)+4>>1]=d[g+4>>1]|0;e=e+1|0;if((e|0)==(j|0))break;else g=g+16|0}}f[a+144>>2]=f[c+120>>2];j=f[c+124>>2]|0;i=f[a+152>>2]|0;if((i|0)<(j|0)){if((f[a+156>>2]|0)<(j|0)){if(!j){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc(j<<5|19)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+152>>2]|0}if((h|0)>0){g=0;do{m=e+(g<<5)|0;l=(f[a+160>>2]|0)+(g<<5)|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];f[m+16>>2]=f[l+16>>2];f[m+20>>2]=f[l+20>>2];f[m+24>>2]=f[l+24>>2];f[m+28>>2]=f[l+28>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+160>>2]|0;if(g|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=e;f[a+156>>2]=j;g=a+160|0}else g=a+160|0;e=i;do{m=(f[g>>2]|0)+(e<<5)|0;f[m>>2]=f[o>>2];f[m+4>>2]=f[o+4>>2];f[m+8>>2]=f[o+8>>2];f[m+12>>2]=f[o+12>>2];f[m+16>>2]=f[o+16>>2];f[m+20>>2]=f[o+20>>2];f[m+24>>2]=f[o+24>>2];f[m+28>>2]=f[o+28>>2];e=e+1|0}while((e|0)!=(j|0))}f[a+152>>2]=j;if((j|0)<=0){u=o;return}h=f[a+160>>2]|0;g=0;e=f[c+128>>2]|0;while(1){d[h+(g<<5)+6>>1]=d[e+14>>1]|0;d[h+(g<<5)+8>>1]=d[e+16>>1]|0;d[h+(g<<5)+10>>1]=d[e+18>>1]|0;d[h+(g<<5)>>1]=d[e+8>>1]|0;d[h+(g<<5)+2>>1]=d[e+10>>1]|0;d[h+(g<<5)+4>>1]=d[e+12>>1]|0;f[h+(g<<5)+12>>2]=f[e>>2];f[h+(g<<5)+16>>2]=f[e+4>>2];g=g+1|0;if((g|0)==(j|0))break;else e=e+20|0}u=o;return}function zd(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=3324;c=f[a+192>>2]|0;if(c|0)Lb[f[(f[c>>2]|0)+4>>2]&511](c);a:do if((f[a+1112>>2]|0)>0)do{h=f[f[a+1120>>2]>>2]|0;c=f[h+348>>2]|0;if(c|0){zg(a+1048|0,c)|0;d=f[a+1052>>2]|0;if(d|0){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0)}f[a+1052>>2]=c;f[a+1060>>2]=(f[a+1060>>2]|0)+-1}c=f[h+52>>2]|0;if(c|0){if(b[h+56>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[h+52>>2]=0}b[h+56>>0]=1;f[h+52>>2]=0;f[h+44>>2]=0;f[h+48>>2]=0;c=f[h+32>>2]|0;if(c|0){if(b[h+36>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[h+32>>2]=0}b[h+36>>0]=1;f[h+32>>2]=0;f[h+24>>2]=0;f[h+28>>2]=0;c=f[h+12>>2]|0;if(c|0){if(b[h+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[h+12>>2]=0}b[h+16>>0]=1;f[h+12>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);c=f[a+1112>>2]|0;if((c|0)<=0)break a;g=f[a+1120>>2]|0;d=0;do{e=g+(d<<2)|0;if((f[e>>2]|0)==(h|0)){i=28;break}d=d+1|0}while((d|0)<(c|0));if((i|0)==28){i=0;if((d|0)<(c|0)){f[e>>2]=f[g+(c+-1<<2)>>2];f[(f[a+1120>>2]|0)+(c+-1<<2)>>2]=h;f[a+1112>>2]=c+-1;c=c+-1|0}}}while((c|0)>0);while(0);c=f[a+872>>2]|0;if((c|0)>0){e=0;do{d=f[(f[a+880>>2]|0)+(e<<2)>>2]|0;if(d){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+872>>2]|0}e=e+1|0}while((e|0)<(c|0))}c=f[a+852>>2]|0;if((c|0)>0){e=0;do{d=f[(f[a+860>>2]|0)+(e<<2)>>2]|0;if(d){f[6473]=(f[6473]|0)+1;Cd(f[d+-4>>2]|0);c=f[a+852>>2]|0}e=e+1|0}while((e|0)<(c|0))}c=f[a+1244>>2]|0;if(c|0){if(b[a+1248>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+1244>>2]=0}b[a+1248>>0]=1;f[a+1244>>2]=0;f[a+1236>>2]=0;f[a+1240>>2]=0;c=f[a+1140>>2]|0;if(c|0){if(b[a+1144>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+1140>>2]=0}b[a+1144>>0]=1;f[a+1140>>2]=0;f[a+1132>>2]=0;f[a+1136>>2]=0;c=f[a+1120>>2]|0;if(c|0){if(b[a+1124>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+1120>>2]=0}b[a+1124>>0]=1;f[a+1120>>2]=0;f[a+1112>>2]=0;f[a+1116>>2]=0;hi(a+1048|0);hi(a+988|0);hi(a+928|0);c=f[a+880>>2]|0;if(c|0){if(b[a+884>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+880>>2]=0}b[a+884>>0]=1;f[a+880>>2]=0;f[a+872>>2]=0;f[a+876>>2]=0;c=f[a+860>>2]|0;if(c|0){if(b[a+864>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+860>>2]=0}b[a+864>>0]=1;f[a+860>>2]=0;f[a+852>>2]=0;f[a+856>>2]=0;c=f[a+840>>2]|0;if(c|0){if(b[a+844>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+840>>2]=0}b[a+844>>0]=1;f[a+840>>2]=0;f[a+832>>2]=0;f[a+836>>2]=0;c=f[a+820>>2]|0;if(c|0){if(b[a+824>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+820>>2]=0}b[a+824>>0]=1;f[a+820>>2]=0;f[a+812>>2]=0;f[a+816>>2]=0;c=f[a+800>>2]|0;if(c|0){if(b[a+804>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+800>>2]=0}b[a+804>>0]=1;f[a+800>>2]=0;f[a+792>>2]=0;f[a+796>>2]=0;c=f[a+780>>2]|0;if(c|0){if(b[a+784>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+780>>2]=0}b[a+784>>0]=1;f[a+780>>2]=0;f[a+772>>2]=0;f[a+776>>2]=0;c=f[a+760>>2]|0;if(c|0){if(b[a+764>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+760>>2]=0}b[a+764>>0]=1;f[a+760>>2]=0;f[a+752>>2]=0;f[a+756>>2]=0;c=f[a+740>>2]|0;if(c|0){if(b[a+744>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+740>>2]=0}b[a+744>>0]=1;f[a+740>>2]=0;f[a+732>>2]=0;f[a+736>>2]=0;c=f[a+720>>2]|0;if(c|0){if(b[a+724>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+720>>2]=0}b[a+724>>0]=1;f[a+720>>2]=0;f[a+712>>2]=0;f[a+716>>2]=0;c=f[a+700>>2]|0;if(c|0){if(b[a+704>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+700>>2]=0}b[a+704>>0]=1;f[a+700>>2]=0;f[a+692>>2]=0;f[a+696>>2]=0;c=f[a+512>>2]|0;if(c|0){if(b[a+516>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+512>>2]=0}b[a+516>>0]=1;f[a+512>>2]=0;f[a+504>>2]=0;f[a+508>>2]=0;c=f[a+492>>2]|0;if(c|0){if(b[a+496>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+492>>2]=0}b[a+496>>0]=1;f[a+492>>2]=0;f[a+484>>2]=0;f[a+488>>2]=0;gu(a+288|0);c=f[a+276>>2]|0;if(!c){b[a+280>>0]=1;f[a+276>>2]=0;f[a+268>>2]=0;i=a+272|0;f[i>>2]=0;f[a>>2]=5200;return}if(b[a+280>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}f[a+276>>2]=0;b[a+280>>0]=1;f[a+276>>2]=0;f[a+268>>2]=0;i=a+272|0;f[i>>2]=0;f[a>>2]=5200;return}function Ad(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=u;u=u+64|0;f[a+20>>2]=f[c+16>>2];f[a+24>>2]=f[c+20>>2];f[a+28>>2]=f[c+24>>2];f[a+32>>2]=f[c+28>>2];f[a+4>>2]=f[c>>2];f[a+8>>2]=f[c+4>>2];f[a+12>>2]=f[c+8>>2];f[a+16>>2]=f[c+12>>2];f[a+36>>2]=f[c+32>>2];f[a+40>>2]=f[c+36>>2];f[a+44>>2]=f[c+40>>2];f[a+48>>2]=f[c+44>>2];f[a+56>>2]=f[c+48>>2];b[a+60>>0]=(f[c+52>>2]|0)!=0&1;m=f[c+56>>2]|0;i=n;k=i+64|0;do{f[i>>2]=0;i=i+4|0}while((i|0)<(k|0));l=f[a+88>>2]|0;if((l|0)<(m|0)){if((f[a+92>>2]|0)<(m|0)){if(!m){e=0;h=l}else{f[6472]=(f[6472]|0)+1;e=sc(m<<6|19)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+88>>2]|0}if((h|0)>0){g=0;do{i=e+(g<<6)|0;j=(f[a+96>>2]|0)+(g<<6)|0;k=i+64|0;do{f[i>>2]=f[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));g=g+1|0}while((g|0)!=(h|0))}g=f[a+96>>2]|0;if(g|0){if(b[a+100>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+96>>2]=0}b[a+100>>0]=1;f[a+96>>2]=e;f[a+92>>2]=m;g=a+96|0}else g=a+96|0;e=l;do{i=(f[g>>2]|0)+(e<<6)|0;j=n;k=i+64|0;do{f[i>>2]=f[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));e=e+1|0}while((e|0)!=(m|0))}f[a+88>>2]=m;if((m|0)>0){h=f[a+96>>2]|0;e=f[c+64>>2]|0;g=0;while(1){f[h+(g<<6)+16>>2]=f[e+16>>2];f[h+(g<<6)+20>>2]=f[e+20>>2];f[h+(g<<6)+24>>2]=f[e+24>>2];f[h+(g<<6)+28>>2]=f[e+28>>2];f[h+(g<<6)>>2]=f[e>>2];f[h+(g<<6)+4>>2]=f[e+4>>2];f[h+(g<<6)+8>>2]=f[e+8>>2];f[h+(g<<6)+12>>2]=f[e+12>>2];f[h+(g<<6)+32>>2]=f[e+32>>2];f[h+(g<<6)+36>>2]=f[e+36>>2];f[h+(g<<6)+40>>2]=f[e+40>>2];g=g+1|0;if((g|0)==(m|0))break;else e=e+48|0}}j=f[c+60>>2]|0;f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;f[n+12>>2]=0;i=f[a+128>>2]|0;if((i|0)<(j|0)){if((f[a+132>>2]|0)<(j|0)){if(!j){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc((j<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+128>>2]|0}if((h|0)>0){g=0;do{m=e+(g<<4)|0;l=(f[a+136>>2]|0)+(g<<4)|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+136>>2]|0;if(g|0){if(b[a+140>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+136>>2]=0}b[a+140>>0]=1;f[a+136>>2]=e;f[a+132>>2]=j;g=a+136|0}else g=a+136|0;e=i;do{m=(f[g>>2]|0)+(e<<4)|0;f[m>>2]=f[n>>2];f[m+4>>2]=f[n+4>>2];f[m+8>>2]=f[n+8>>2];f[m+12>>2]=f[n+12>>2];e=e+1|0}while((e|0)!=(j|0))}f[a+128>>2]=j;if((j|0)>0){h=f[a+136>>2]|0;e=0;g=f[c+68>>2]|0;while(1){f[h+(e<<4)+12>>2]=f[g+12>>2];d[h+(e<<4)+6>>1]=d[g+6>>1]|0;d[h+(e<<4)+8>>1]=d[g+8>>1]|0;d[h+(e<<4)+10>>1]=d[g+10>>1]|0;d[h+(e<<4)>>1]=d[g>>1]|0;d[h+(e<<4)+2>>1]=d[g+2>>1]|0;d[h+(e<<4)+4>>1]=d[g+4>>1]|0;e=e+1|0;if((e|0)==(j|0))break;else g=g+16|0}}f[a+144>>2]=f[c+76>>2];j=f[c+80>>2]|0;i=f[a+152>>2]|0;if((i|0)<(j|0)){if((f[a+156>>2]|0)<(j|0)){if(!j){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc(j<<5|19)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[a+152>>2]|0}if((h|0)>0){g=0;do{m=e+(g<<5)|0;l=(f[a+160>>2]|0)+(g<<5)|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];f[m+16>>2]=f[l+16>>2];f[m+20>>2]=f[l+20>>2];f[m+24>>2]=f[l+24>>2];f[m+28>>2]=f[l+28>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[a+160>>2]|0;if(g|0){if(b[a+164>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[a+160>>2]=0}b[a+164>>0]=1;f[a+160>>2]=e;f[a+156>>2]=j;g=a+160|0}else g=a+160|0;e=i;do{m=(f[g>>2]|0)+(e<<5)|0;f[m>>2]=f[n>>2];f[m+4>>2]=f[n+4>>2];f[m+8>>2]=f[n+8>>2];f[m+12>>2]=f[n+12>>2];f[m+16>>2]=f[n+16>>2];f[m+20>>2]=f[n+20>>2];f[m+24>>2]=f[n+24>>2];f[m+28>>2]=f[n+28>>2];e=e+1|0}while((e|0)!=(j|0))}f[a+152>>2]=j;if((j|0)<=0){u=n;return}h=f[a+160>>2]|0;g=0;e=f[c+72>>2]|0;while(1){d[h+(g<<5)+6>>1]=d[e+14>>1]|0;d[h+(g<<5)+8>>1]=d[e+16>>1]|0;d[h+(g<<5)+10>>1]=d[e+18>>1]|0;d[h+(g<<5)>>1]=d[e+8>>1]|0;d[h+(g<<5)+2>>1]=d[e+10>>1]|0;d[h+(g<<5)+4>>1]=d[e+12>>1]|0;f[h+(g<<5)+12>>2]=f[e>>2];f[h+(g<<5)+16>>2]=f[e+4>>2];g=g+1|0;if((g|0)==(j|0))break;else e=e+20|0}u=n;return}function Bd(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0.0,j=0,k=0.0,l=0,m=0,o=0,p=0.0,q=0.0,r=0.0,t=0,v=0.0,w=0.0;t=u;u=u+288|0;o=f[a+4>>2]|0;b[o+312>>0]=0;f[o>>2]=0;b[o+356>>0]=1;f[o+292>>2]=1566444395;f[o+296>>2]=1566444395;f[o+300>>2]=1566444395;n[o+304>>2]=0.0;f[o+336>>2]=0;f[o+336+4>>2]=0;f[o+336+8>>2]=0;f[o+336+12>>2]=0;b[o+336+16>>0]=0;b[o+332>>0]=b[o+332>>0]&-16;p=+n[d+48>>2]-+n[c+48>>2]-(+n[g+48>>2]-+n[e+48>>2]);q=+n[d+52>>2]-+n[c+52>>2]-(+n[g+52>>2]-+n[e+52>>2]);r=+n[d+56>>2]-+n[c+56>>2]-(+n[g+56>>2]-+n[e+56>>2]);f[t+216>>2]=9352;n[t+216+36>>2]=999999984306749440.0;b[t+216+40>>0]=0;o=f[a+8>>2]|0;m=f[a+12>>2]|0;l=f[a+4>>2]|0;f[t+136>>2]=9400;f[t+136+4>>2]=0;f[t+136+8>>2]=1065353216;f[t+136+12>>2]=0;n[t+136+16>>2]=0.0;f[t+136+20>>2]=0;f[t+136+24>>2]=l;f[t+136+28>>2]=o;f[t+136+32>>2]=m;f[t+136+36>>2]=f[o+4>>2];f[t+136+40>>2]=f[m+4>>2];k=+rb[f[(f[o>>2]|0)+48>>2]&15](o);n[t+136+44>>2]=k;k=+rb[f[(f[m>>2]|0)+48>>2]&15](m);n[t+136+48>>2]=k;b[t+136+52>>0]=0;f[t+136+60>>2]=-1;f[t+136+72>>2]=1;f[t+136+76>>2]=1;n[t+128>>2]=999999984306749440.0;f[t>>2]=f[c>>2];f[t+4>>2]=f[c+4>>2];f[t+8>>2]=f[c+8>>2];f[t+12>>2]=f[c+12>>2];f[t+16>>2]=f[c+16>>2];f[t+16+4>>2]=f[c+16+4>>2];f[t+16+8>>2]=f[c+16+8>>2];f[t+16+12>>2]=f[c+16+12>>2];f[t+32>>2]=f[c+32>>2];f[t+32+4>>2]=f[c+32+4>>2];f[t+32+8>>2]=f[c+32+8>>2];f[t+32+12>>2]=f[c+32+12>>2];f[t+48>>2]=f[c+48>>2];f[t+48+4>>2]=f[c+48+4>>2];f[t+48+8>>2]=f[c+48+8>>2];f[t+48+12>>2]=f[c+48+12>>2];f[t+64>>2]=f[e>>2];f[t+64+4>>2]=f[e+4>>2];f[t+64+8>>2]=f[e+8>>2];f[t+64+12>>2]=f[e+12>>2];f[t+80>>2]=f[e+16>>2];f[t+80+4>>2]=f[e+16+4>>2];f[t+80+8>>2]=f[e+16+8>>2];f[t+80+12>>2]=f[e+16+12>>2];f[t+96>>2]=f[e+32>>2];f[t+96+4>>2]=f[e+32+4>>2];f[t+96+8>>2]=f[e+32+8>>2];f[t+96+12>>2]=f[e+32+12>>2];f[t+112>>2]=f[e+48>>2];f[t+112+4>>2]=f[e+48+4>>2];f[t+112+8>>2]=f[e+48+8>>2];f[t+112+12>>2]=f[e+48+12>>2];Nc(t+136|0,t,t+216|0,0,0);m=(b[t+216+40>>0]|0)==0;o=t+216+20|0;f[t+264>>2]=f[o>>2];f[t+264+4>>2]=f[o+4>>2];f[t+264+8>>2]=f[o+8>>2];f[t+264+12>>2]=f[o+12>>2];if(m){h=0;u=t;return h|0}k=+n[t+216+36>>2];i=+n[t+216+16>>2];a=f[t+216+12>>2]|0;j=f[t+216+8>>2]|0;l=f[t+216+4>>2]|0;do if(k>1.0000000474974513e-03){m=0;i=0.0;while(1){if((m|0)>31){a=0;m=13;break}w=p*(f[s>>2]=l,+n[s>>2]);w=q*(f[s>>2]=j,+n[s>>2])+w;v=i;i=i-k/(r*(f[s>>2]=a,+n[s>>2])+w);if(!(!(i<=v)&(!(i<0.0)&!(i>1.0)))){a=0;m=13;break}Mb[f[f[h>>2]>>2]&31](h,i);w=1.0-i;n[t+48>>2]=w*+n[c+48>>2]+i*+n[d+48>>2];n[t+52>>2]=w*+n[c+52>>2]+i*+n[d+52>>2];n[t+56>>2]=w*+n[c+56>>2]+i*+n[d+56>>2];n[t+112>>2]=w*+n[e+48>>2]+i*+n[g+48>>2];n[t+116>>2]=w*+n[e+52>>2]+i*+n[g+52>>2];n[t+120>>2]=w*+n[e+56>>2]+i*+n[g+56>>2];Nc(t+136|0,t,t+216|0,0,0);if(!(b[t+216+40>>0]|0)){a=0;m=13;break}k=+n[t+216+36>>2];if(k<0.0){m=8;break}f[t+264>>2]=f[o>>2];f[t+264+4>>2]=f[o+4>>2];f[t+264+8>>2]=f[o+8>>2];f[t+264+12>>2]=f[o+12>>2];a=f[t+216+12>>2]|0;j=f[t+216+8>>2]|0;l=f[t+216+4>>2]|0;if(!(k>1.0000000474974513e-03)){m=10;break}else m=m+1|0}if((m|0)==8){n[h+164>>2]=i;d=f[t+216+8>>2]|0;e=f[t+216+12>>2]|0;g=f[t+216+16>>2]|0;f[h+132>>2]=f[t+216+4>>2];f[h+136>>2]=d;f[h+140>>2]=e;f[h+144>>2]=g;f[h+148>>2]=f[o>>2];f[h+148+4>>2]=f[o+4>>2];f[h+148+8>>2]=f[o+8>>2];f[h+148+12>>2]=f[o+12>>2];h=1;u=t;return h|0}else if((m|0)==10){k=i;i=+n[t+216+16>>2];break}else if((m|0)==13){u=t;return a|0}}else k=0.0;while(0);w=p*(f[s>>2]=l,+n[s>>2]);w=q*(f[s>>2]=j,+n[s>>2])+w;if(r*(f[s>>2]=a,+n[s>>2])+w>=-+n[h+172>>2]){h=0;u=t;return h|0}n[h+164>>2]=k;f[h+132>>2]=l;f[h+136>>2]=j;f[h+140>>2]=a;n[h+144>>2]=i;f[h+148>>2]=f[t+264>>2];f[h+148+4>>2]=f[t+264+4>>2];f[h+148+8>>2]=f[t+264+8>>2];f[h+148+12>>2]=f[t+264+12>>2];h=1;u=t;return h|0}function Cd(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0;if(!a)return;b=f[6478]|0;c=f[a+-4>>2]|0;j=a+-8+(c&-8)|0;do if(!(c&1)){d=f[a+-8>>2]|0;if(!(c&3))return;h=a+-8+(0-d)|0;g=d+(c&-8)|0;if(h>>>0<b>>>0)return;if((f[6479]|0)==(h|0)){b=f[j+4>>2]|0;if((b&3|0)!=3){i=h;b=g;break}f[6476]=g;f[j+4>>2]=b&-2;f[h+4>>2]=g|1;f[h+g>>2]=g;return}if(d>>>0<256){b=f[h+8>>2]|0;a=f[h+12>>2]|0;if((a|0)==(b|0)){f[6474]=f[6474]&~(1<<(d>>>3));i=h;b=g;break}else{f[b+12>>2]=a;f[a+8>>2]=b;i=h;b=g;break}}e=f[h+24>>2]|0;b=f[h+12>>2]|0;do if((b|0)==(h|0)){b=f[h+16+4>>2]|0;if(!b){b=f[h+16>>2]|0;if(!b){b=0;break}else d=h+16|0}else d=h+16+4|0;while(1){a=b+20|0;c=f[a>>2]|0;if(c|0){b=c;d=a;continue}a=b+16|0;c=f[a>>2]|0;if(!c)break;else{b=c;d=a}}f[d>>2]=0}else{i=f[h+8>>2]|0;f[i+12>>2]=b;f[b+8>>2]=i}while(0);if(e){a=f[h+28>>2]|0;if((f[26200+(a<<2)>>2]|0)==(h|0)){f[26200+(a<<2)>>2]=b;if(!b){f[6475]=f[6475]&~(1<<a);i=h;b=g;break}}else{f[e+16+(((f[e+16>>2]|0)!=(h|0)&1)<<2)>>2]=b;if(!b){i=h;b=g;break}}f[b+24>>2]=e;a=f[h+16>>2]|0;if(a|0){f[b+16>>2]=a;f[a+24>>2]=b}a=f[h+16+4>>2]|0;if(a){f[b+20>>2]=a;f[a+24>>2]=b;i=h;b=g}else{i=h;b=g}}else{i=h;b=g}}else{i=a+-8|0;b=c&-8;h=a+-8|0}while(0);if(h>>>0>=j>>>0)return;c=f[j+4>>2]|0;if(!(c&1))return;if(!(c&2)){if((f[6480]|0)==(j|0)){j=(f[6477]|0)+b|0;f[6477]=j;f[6480]=i;f[i+4>>2]=j|1;if((i|0)!=(f[6479]|0))return;f[6479]=0;f[6476]=0;return}if((f[6479]|0)==(j|0)){j=(f[6476]|0)+b|0;f[6476]=j;f[6479]=h;f[i+4>>2]=j|1;f[h+j>>2]=j;return}e=(c&-8)+b|0;do if(c>>>0<256){a=f[j+8>>2]|0;b=f[j+12>>2]|0;if((b|0)==(a|0)){f[6474]=f[6474]&~(1<<(c>>>3));break}else{f[a+12>>2]=b;f[b+8>>2]=a;break}}else{g=f[j+24>>2]|0;b=f[j+12>>2]|0;do if((b|0)==(j|0)){b=f[j+16+4>>2]|0;if(!b){b=f[j+16>>2]|0;if(!b){a=0;break}else d=j+16|0}else d=j+16+4|0;while(1){a=b+20|0;c=f[a>>2]|0;if(c|0){b=c;d=a;continue}a=b+16|0;c=f[a>>2]|0;if(!c)break;else{b=c;d=a}}f[d>>2]=0;a=b}else{a=f[j+8>>2]|0;f[a+12>>2]=b;f[b+8>>2]=a;a=b}while(0);if(g|0){b=f[j+28>>2]|0;if((f[26200+(b<<2)>>2]|0)==(j|0)){f[26200+(b<<2)>>2]=a;if(!a){f[6475]=f[6475]&~(1<<b);break}}else{f[g+16+(((f[g+16>>2]|0)!=(j|0)&1)<<2)>>2]=a;if(!a)break}f[a+24>>2]=g;b=f[j+16>>2]|0;if(b|0){f[a+16>>2]=b;f[b+24>>2]=a}b=f[j+16+4>>2]|0;if(b|0){f[a+20>>2]=b;f[b+24>>2]=a}}}while(0);f[i+4>>2]=e|1;f[h+e>>2]=e;if((i|0)==(f[6479]|0)){f[6476]=e;return}}else{f[j+4>>2]=c&-2;f[i+4>>2]=b|1;f[h+b>>2]=b;e=b}c=e>>>3;if(e>>>0<256){b=f[6474]|0;if(!(b&1<<c)){f[6474]=b|1<<c;b=25936+(c<<1<<2)|0;a=25936+(c<<1<<2)+8|0}else{b=f[25936+(c<<1<<2)+8>>2]|0;a=25936+(c<<1<<2)+8|0}f[a>>2]=i;f[b+12>>2]=i;f[i+8>>2]=b;f[i+12>>2]=25936+(c<<1<<2);return}b=e>>>8;if(b)if(e>>>0>16777215)b=31;else{j=b<<((b+1048320|0)>>>16&8)<<(((b<<((b+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((b<<((b+1048320|0)>>>16&8))+520192|0)>>>16&4|(b+1048320|0)>>>16&8|(j+245760|0)>>>16&2)+(j<<((j+245760|0)>>>16&2)>>>15)|0;b=e>>>(b+7|0)&1|b<<1}else b=0;d=26200+(b<<2)|0;f[i+28>>2]=b;f[i+20>>2]=0;f[i+16>>2]=0;a=f[6475]|0;c=1<<b;do if(a&c){a=e<<((b|0)==31?0:25-(b>>>1)|0);c=f[d>>2]|0;while(1){if((f[c+4>>2]&-8|0)==(e|0)){b=73;break}d=c+16+(a>>>31<<2)|0;b=f[d>>2]|0;if(!b){b=72;break}else{a=a<<1;c=b}}if((b|0)==72){f[d>>2]=i;f[i+24>>2]=c;f[i+12>>2]=i;f[i+8>>2]=i;break}else if((b|0)==73){h=c+8|0;j=f[h>>2]|0;f[j+12>>2]=i;f[h>>2]=i;f[i+8>>2]=j;f[i+12>>2]=c;f[i+24>>2]=0;break}}else{f[6475]=a|c;f[d>>2]=i;f[i+24>>2]=d;f[i+12>>2]=i;f[i+8>>2]=i}while(0);j=(f[6482]|0)+-1|0;f[6482]=j;if(!j)b=26352;else return;while(1){b=f[b>>2]|0;if(!b)break;else b=b+8|0}f[6482]=-1;return}function Dd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;k=u;u=u+240|0;f[a+4>>2]=(f[a+4>>2]|0)+1;i=f[b+36>>2]|0;h=f[c+36>>2]|0;e=f[a+8>>2]|0;K=f[(f[e+4>>2]|0)+24>>2]|0;c=f[K+(i*80|0)+64>>2]|0;b=(f[(f[a+12>>2]|0)+4>>2]|0)+24|0;d=f[(f[b>>2]|0)+(h*80|0)+64>>2]|0;e=f[e+12>>2]|0;l=+n[e>>2];I=+n[e+4>>2];J=+n[e+8>>2];p=+n[e+16>>2];r=+n[e+20>>2];t=+n[e+24>>2];q=+n[e+32>>2];v=+n[e+36>>2];D=+n[e+40>>2];w=+n[K+(i*80|0)>>2];x=+n[K+(i*80|0)+16>>2];y=+n[K+(i*80|0)+32>>2];z=+n[K+(i*80|0)+4>>2];A=+n[K+(i*80|0)+20>>2];B=+n[K+(i*80|0)+36>>2];s=+n[K+(i*80|0)+8>>2];C=+n[K+(i*80|0)+24>>2];E=+n[K+(i*80|0)+40>>2];m=+n[K+(i*80|0)+48>>2];o=+n[K+(i*80|0)+52>>2];H=+n[K+(i*80|0)+56>>2];F=+n[e+48>>2]+(l*m+I*o+J*H);G=+n[e+52>>2]+(p*m+r*o+t*H);H=+n[e+56>>2]+(q*m+v*o+D*H);n[k+176>>2]=l*w+I*x+J*y;n[k+176+4>>2]=l*z+I*A+J*B;n[k+176+8>>2]=l*s+I*C+J*E;n[k+176+12>>2]=0.0;n[k+176+16>>2]=p*w+r*x+t*y;n[k+176+20>>2]=p*z+r*A+t*B;n[k+176+24>>2]=p*s+r*C+t*E;n[k+176+28>>2]=0.0;n[k+176+32>>2]=q*w+v*x+D*y;n[k+176+36>>2]=q*z+v*A+D*B;n[k+176+40>>2]=q*s+v*C+D*E;n[k+176+44>>2]=0.0;n[k+176+48>>2]=F;n[k+176+52>>2]=G;n[k+176+56>>2]=H;n[k+176+60>>2]=0.0;e=f[(f[a+12>>2]|0)+12>>2]|0;H=+n[e>>2];G=+n[e+4>>2];F=+n[e+8>>2];E=+n[e+16>>2];D=+n[e+20>>2];C=+n[e+24>>2];v=+n[e+32>>2];s=+n[e+36>>2];q=+n[e+40>>2];b=f[b>>2]|0;B=+n[b+(h*80|0)>>2];A=+n[b+(h*80|0)+16>>2];z=+n[b+(h*80|0)+32>>2];y=+n[b+(h*80|0)+4>>2];x=+n[b+(h*80|0)+20>>2];w=+n[b+(h*80|0)+36>>2];t=+n[b+(h*80|0)+8>>2];r=+n[b+(h*80|0)+24>>2];p=+n[b+(h*80|0)+40>>2];J=+n[b+(h*80|0)+48>>2];I=+n[b+(h*80|0)+52>>2];l=+n[b+(h*80|0)+56>>2];o=+n[e+48>>2]+(H*J+G*I+F*l);m=+n[e+52>>2]+(E*J+D*I+C*l);l=+n[e+56>>2]+(v*J+s*I+q*l);n[k+112>>2]=H*B+G*A+F*z;n[k+112+4>>2]=H*y+G*x+F*w;n[k+112+8>>2]=H*t+G*r+F*p;n[k+112+12>>2]=0.0;n[k+112+16>>2]=E*B+D*A+C*z;n[k+112+20>>2]=E*y+D*x+C*w;n[k+112+24>>2]=E*t+D*r+C*p;n[k+112+28>>2]=0.0;n[k+112+32>>2]=v*B+s*A+q*z;n[k+112+36>>2]=v*y+s*x+q*w;n[k+112+40>>2]=v*t+s*r+q*p;n[k+112+44>>2]=0.0;n[k+112+48>>2]=o;n[k+112+52>>2]=m;n[k+112+56>>2]=l;n[k+112+60>>2]=0.0;Yb[f[(f[c>>2]|0)+8>>2]&127](c,k+176|0,k+96|0,k+80|0);Yb[f[(f[d>>2]|0)+8>>2]&127](d,k+112|0,k+64|0,k+48|0);if(!(+n[k+96>>2]>+n[k+48>>2])?!(+n[k+80>>2]<+n[k+64>>2]):0)b=1;else b=0;if(!(!(+n[k+96+8>>2]>+n[k+48+8>>2])?!(+n[k+80+8>>2]<+n[k+64+8>>2]):0))b=0;if(+n[k+96+4>>2]>+n[k+48+4>>2]){u=k;return}if(+n[k+80+4>>2]<+n[k+64+4>>2]|b^1){u=k;return}e=f[a+8>>2]|0;b=f[e+8>>2]|0;f[k+24>>2]=e;f[k+24+4>>2]=c;f[k+24+8>>2]=b;f[k+24+12>>2]=k+176;f[k+24+16>>2]=-1;f[k+24+20>>2]=i;b=f[a+12>>2]|0;e=f[b+8>>2]|0;f[k>>2]=b;f[k+4>>2]=d;f[k+8>>2]=e;f[k+12>>2]=k+112;f[k+16>>2]=-1;f[k+20>>2]=h;e=f[a+28>>2]|0;f[6460]=(f[6460]|0)+1;b=((h<<16|i)+~((h<<16|i)<<15)>>10^(h<<16|i)+~((h<<16|i)<<15))*9|0;b=(f[e+12>>2]|0)+-1&((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11));a:do if((b|0)<(f[e+32>>2]|0)?(g=f[(f[e+40>>2]|0)+(b<<2)>>2]|0,(g|0)!=-1):0){d=f[e+16>>2]|0;b=g;while(1){c=d+(b*12|0)|0;if((f[c>>2]|0)==(i|0)?(f[d+(b*12|0)+4>>2]|0)==(h|0):0)break;b=f[(f[e+60>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){j=16;break a}}if(c)b=f[d+(b*12|0)+8>>2]|0;else j=16}else j=16;while(0);if((j|0)==16){b=f[a+16>>2]|0;b=Gb[f[(f[b>>2]|0)+8>>2]&31](b,k+24|0,k,f[a+32>>2]|0)|0;K=f[a+28>>2]|0;K=(Fb[f[(f[K>>2]|0)+12>>2]&63](K,i,h)|0)+8|0;f[K>>2]=b}K=f[a+24>>2]|0;g=f[K+8>>2]|0;j=f[K+12>>2]|0;f[K+8>>2]=k+24;f[K+12>>2]=k;Vb[f[(f[K>>2]|0)+8>>2]&127](K,-1,i);K=f[a+24>>2]|0;Vb[f[(f[K>>2]|0)+12>>2]&127](K,-1,h);ac[f[(f[b>>2]|0)+8>>2]&31](b,k+24|0,k,f[a+20>>2]|0,f[a+24>>2]|0);K=f[a+24>>2]|0;f[K+8>>2]=g;f[K+12>>2]=j;u=k;return}function Ed(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;j=f[c+8>>2]|0;if(!j){h=0;return h|0}i=0;C=j;do{if((f[C+20>>2]|0)>(f[a+100>>2]|0)){A=f[C+12>>2]|0;w=f[A+88>>2]|0;x=w-(f[c+88>>2]|0)|0;y=f[A+92>>2]|0;z=y-(f[c+92>>2]|0)|0;A=f[A+96>>2]|0;B=A-(f[c+96>>2]|0)|0;k=Fs(f[g>>2]|0,f[g+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;p=I;j=Fs(f[g+8>>2]|0,f[g+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;p=iw(j|0,I|0,k|0,p|0)|0;k=I;j=Fs(f[g+16>>2]|0,f[g+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;j=iw(p|0,k|0,j|0,I|0)|0;k=I;p=Fs(f[e>>2]|0,f[e+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;v=I;o=Fs(f[e+8>>2]|0,f[e+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;v=iw(o|0,I|0,p|0,v|0)|0;p=I;o=Fs(f[e+16>>2]|0,f[e+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;o=iw(v|0,p|0,o|0,I|0)|0;p=I;if((k|0)>0|(k|0)==0&j>>>0>0){l=1;m=-1;v=j}else{v=Tv(0,0,j|0,k|0)|0;l=((j|0)!=0|(k|0)!=0)<<31>>31;m=((j|0)!=0|(k|0)!=0)&1;v=(j|0)!=0|(k|0)!=0?v:0;k=(j|0)!=0|(k|0)!=0?I:0}if(!((p|0)>0|(p|0)==0&o>>>0>0)){j=Tv(0,0,o|0,p|0)|0;j=(o|0)!=0|(p|0)!=0?j:0;n=(o|0)!=0|(p|0)!=0?I:0;if((j|0)!=0|(n|0)!=0|(((o|0)!=0|(p|0)!=0?m:l)|0)!=0){l=(o|0)!=0|(p|0)!=0?m:l;o=j;q=8}}else{n=p;q=8}a:do if((q|0)==8){q=0;if(!i){f[h>>2]=v;f[h+4>>2]=k;f[h+8>>2]=o;f[h+8+4>>2]=n;f[h+16>>2]=l;i=C;break}j=f[h+16>>2]|0;if((l|0)==(j|0)){if(l|0){p=f[h+8>>2]|0;s=f[h+8+4>>2]|0;m=Fs(p|0,0,v|0,0)|0;j=I;t=Fs(s|0,0,v|0,0)|0;r=I;p=Fs(p|0,0,k|0,0)|0;q=I;s=Fs(s|0,0,k|0,0)|0;F=I;p=iw(t|0,0,p|0,0)|0;t=I;F=iw(r|0,0,s|0,F|0)|0;q=iw(F|0,I|0,q|0,0)|0;t=iw(q|0,I|0,t|0,0)|0;q=I;j=iw(0,p|0,m|0,j|0)|0;m=I;p=iw(t|0,q|0,(m>>>0<p>>>0|(m|0)==(p|0)&j>>>0<0)&1|0,0)|0;q=I;t=f[h>>2]|0;F=f[h+4>>2]|0;s=Fs(t|0,0,o|0,0)|0;r=I;D=Fs(F|0,0,o|0,0)|0;G=I;t=Fs(t|0,0,n|0,0)|0;u=I;F=Fs(F|0,0,n|0,0)|0;E=I;t=iw(D|0,0,t|0,0)|0;D=I;E=iw(G|0,0,F|0,E|0)|0;u=iw(E|0,I|0,u|0,0)|0;D=iw(u|0,I|0,D|0,0)|0;u=I;r=iw(0,t|0,s|0,r|0)|0;s=I;t=iw(D|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&r>>>0<0)&1|0,0)|0;u=I;if(!(q>>>0<u>>>0|(q|0)==(u|0)&p>>>0<t>>>0))if(q>>>0>u>>>0|(q|0)==(u|0)&p>>>0>t>>>0)j=1;else j=m>>>0<s>>>0|(m|0)==(s|0)&j>>>0<r>>>0?-1:(m>>>0>s>>>0|(m|0)==(s|0)&j>>>0>r>>>0)&1;else j=-1;j=X(j,l)|0;q=17}}else{j=l-j|0;q=17}do if((q|0)==17){q=0;if((j|0)>=0)if(!j)break;else break a;else{f[h>>2]=v;f[h+4>>2]=k;f[h+8>>2]=o;f[h+8+4>>2]=n;f[h+16>>2]=l;i=C;break a}}while(0);j=(f[i+4>>2]|0)==(C|0);if((f[i>>2]|0)==(C|0))if(j){G=f[d+8>>2]|0;D=X(G,z)|0;u=f[d+4>>2]|0;D=D-(X(u,B)|0)|0;F=f[d>>2]|0;G=(X(F,B)|0)-(X(G,x)|0)|0;F=(X(u,x)|0)-(X(F,z)|0)|0;u=f[i+12>>2]|0;j=f[(f[C+8>>2]|0)+12>>2]|0;z=f[j+88>>2]|0;x=(f[u+88>>2]|0)-z|0;v=f[j+92>>2]|0;B=(f[u+92>>2]|0)-v|0;j=f[j+96>>2]|0;u=(f[u+96>>2]|0)-j|0;E=(X(A-j|0,B)|0)-(X(y-v|0,u)|0)|0;j=(X(w-z|0,u)|0)-(X(A-j|0,x)|0)|0;B=(X(y-v|0,x)|0)-(X(w-z|0,B)|0)|0;D=Fs(E|0,((E|0)<0)<<31>>31|0,D|0,((D|0)<0)<<31>>31|0)|0;E=I;G=Fs(j|0,((j|0)<0)<<31>>31|0,G|0,((G|0)<0)<<31>>31|0)|0;j=I;F=Fs(B|0,((B|0)<0)<<31>>31|0,F|0,((F|0)<0)<<31>>31|0)|0;F=iw(D|0,E|0,F|0,I|0)|0;j=iw(F|0,I|0,G|0,j|0)|0;G=I;j=(G|0)>0|(G|0)==0&j>>>0>0?2:1}else j=2;else j=j&1;i=(j|0)==2^b?i:C}while(0);j=f[c+8>>2]|0}C=f[C>>2]|0}while((C|0)!=(j|0));return i|0}
function gc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0,H=0,I=0.0,J=0.0,M=0.0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0;ja=u;u=u+192|0;g=f[a+52>>2]|0;if(g|0?(Lb[f[f[g>>2]>>2]&511](g),e=f[a+52>>2]|0,e|0):0){f[6473]=(f[6473]|0)+1;Cd(f[e+-4>>2]|0)}f[6472]=(f[6472]|0)+1;e=sc(151)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f[e>>2]=9544;b[e+20>>0]=1;f[e+16>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;b[e+40>>0]=1;f[e+36>>2]=0;f[e+28>>2]=0;f[e+32>>2]=0;b[e+60>>0]=1;f[e+56>>2]=0;f[e+48>>2]=0;f[e+52>>2]=0;f[a+52>>2]=e;k=0;l=0;ia=0;H=0;e=0;while(1){if((k|0)>=(Bb[f[(f[a>>2]|0)+96>>2]&127](a)|0))break;do if((H|0)==(l|0)){g=l|0?l<<1:1;if((l|0)<(g|0)){if((g|0)!=0?(f[6472]=(f[6472]|0)+1,m=sc((g<<4|3)+16|0)|0,(m|0)!=0):0){f[(m+4+15&-16)+-4>>2]=m;h=m+4+15&-16}else h=0;if((l|0)<=0){if(!ia){i=h;e=h;h=l;break}}else{e=0;do{ha=h+(e<<4)|0;ga=ia+(e<<4)|0;f[ha>>2]=f[ga>>2];f[ha+4>>2]=f[ga+4>>2];f[ha+8>>2]=f[ga+8>>2];f[ha+12>>2]=f[ga+12>>2];e=e+1|0}while((e|0)!=(l|0))}f[6473]=(f[6473]|0)+1;Cd(f[ia+-4>>2]|0);i=h;e=h;h=l}else{g=l;i=ia;h=l}}else{g=l;i=ia;h=H}while(0);l=i+(H<<4)|0;f[l>>2]=f[ja+136>>2];f[l+4>>2]=f[ja+136+4>>2];f[l+8>>2]=f[ja+136+8>>2];f[l+12>>2]=f[ja+136+12>>2];Vb[f[(f[a>>2]|0)+108>>2]&127](a,k,l);k=k+1|0;l=g;ia=i;H=h+1|0}b[ja+76+16>>0]=1;ha=ja+76+12|0;f[ha>>2]=0;f[ja+76+4>>2]=0;f[ja+76+8>>2]=0;b[ja+76+36>>0]=1;ga=ja+76+32|0;f[ga>>2]=0;f[ja+76+24>>2]=0;f[ja+76+28>>2]=0;b[ja+76+56>>0]=1;fa=ja+76+52|0;f[fa>>2]=0;f[ja+76+44>>2]=0;f[ja+76+48>>2]=0;if(c){if((H|0)>0){G=0;g=0;h=0;i=0;while(1){e=G;G=G+1|0;if((G|0)<(H|0)){A=ia+(e<<4)|0;E=ia+(e<<4)+4|0;z=ia+(e<<4)+8|0;y=G;e=i;do{i=y;y=y+1|0;if((y|0)<(H|0)){w=ia+(i<<4)|0;x=ia+(i<<4)+4|0;c=ia+(i<<4)+8|0;m=y;do{o=+n[A>>2];F=+n[w>>2]-o;p=+n[E>>2];I=+n[x>>2]-p;q=+n[z>>2];C=+n[c>>2]-q;J=+n[ia+(m<<4)>>2]-o;M=+n[ia+(m<<4)+4>>2]-p;D=+n[ia+(m<<4)+8>>2]-q;B=(F*M-I*J)*(F*M-I*J)+((I*D-C*M)*(I*D-C*M)+(C*J-F*D)*(C*J-F*D));a:do if(B>9.999999747378752e-05){v=1.0/+L(+B);r=(I*D-C*M)*v;t=(C*J-F*D)*v;v=(F*M-I*J)*v;b:do if((e|0)>0){i=0;while(1){if(r*+n[h+(i<<4)>>2]+t*+n[h+(i<<4)+4>>2]+v*+n[h+(i<<4)+8>>2]>.9990000128746033)break b;i=i+1|0;if((i|0)>=(e|0)){da=30;break}}}else da=30;while(0);c:do if((da|0)==30){da=0;i=0;do{if(r*+n[ia+(i<<4)>>2]+t*+n[ia+(i<<4)+4>>2]+v*+n[ia+(i<<4)+8>>2]-(r*o+t*p+v*q)+-.009999999776482582>0.0)break c;i=i+1|0}while((i|0)<(H|0));do if((e|0)==(g|0)){l=g|0?g<<1:1;if((g|0)<(l|0)){do if(!l)k=0;else{f[6472]=(f[6472]|0)+1;i=sc((l<<4|3)+16|0)|0;if(!i){k=0;break}f[(i+4+15&-16)+-4>>2]=i;k=i+4+15&-16}while(0);if((g|0)<=0){if(!h){i=l;h=k;break}}else{i=0;do{ca=k+(i<<4)|0;ba=h+(i<<4)|0;f[ca>>2]=f[ba>>2];f[ca+4>>2]=f[ba+4>>2];f[ca+8>>2]=f[ba+8>>2];f[ca+12>>2]=f[ba+12>>2];i=i+1|0}while((i|0)!=(g|0))}f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);i=l;h=k}else i=g}else{i=g;g=e}while(0);n[h+(g<<4)>>2]=r;n[h+(g<<4)+4>>2]=t;n[h+(g<<4)+8>>2]=v;n[h+(g<<4)+12>>2]=-(r*o+t*p+v*q);g=i;e=e+1|0}while(0);if(B>9.999999747378752e-05){p=1.0/+L(+B);r=-((I*D-C*M)*p);q=-((C*J-F*D)*p);p=-((F*M-I*J)*p);if((e|0)>0){i=0;do{if(+n[h+(i<<4)>>2]*r+ +n[h+(i<<4)+4>>2]*q+ +n[h+(i<<4)+8>>2]*p>.9990000128746033)break a;i=i+1|0}while((i|0)<(e|0))}o=+n[A>>2]*r+ +n[E>>2]*q+ +n[z>>2]*p;i=0;do{if(+n[ia+(i<<4)>>2]*r+ +n[ia+(i<<4)+4>>2]*q+ +n[ia+(i<<4)+8>>2]*p-o+-.009999999776482582>0.0)break a;i=i+1|0}while((i|0)<(H|0));do if((e|0)==(g|0)){l=g|0?g<<1:1;if((g|0)>=(l|0)){i=g;break}do if(!l)k=0;else{f[6472]=(f[6472]|0)+1;i=sc((l<<4|3)+16|0)|0;if(!i){k=0;break}f[(i+4+15&-16)+-4>>2]=i;k=i+4+15&-16}while(0);if((g|0)<=0){if(!h){i=l;h=k;break}}else{i=0;do{ca=k+(i<<4)|0;ba=h+(i<<4)|0;f[ca>>2]=f[ba>>2];f[ca+4>>2]=f[ba+4>>2];f[ca+8>>2]=f[ba+8>>2];f[ca+12>>2]=f[ba+12>>2];i=i+1|0}while((i|0)!=(g|0))}f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0);i=l;h=k}else{i=g;g=e}while(0);n[h+(g<<4)>>2]=r;n[h+(g<<4)+4>>2]=q;n[h+(g<<4)+8>>2]=p;n[h+(g<<4)+12>>2]=-o;g=i;e=e+1|0}}while(0);m=m+1|0}while((m|0)!=(H|0))}}while((y|0)!=(H|0))}else e=i;if((G|0)==(H|0)){c=e;break}else i=e}if((c|0)>0){e=0;l=0;m=0;while(1){ca=h+(m<<4)|0;f[ja+136>>2]=f[ca>>2];f[ja+136+4>>2]=f[ca+4>>2];f[ja+136+8>>2]=f[ca+8>>2];o=+n[h+(m<<4)+12>>2];o=o-+rb[f[(f[a>>2]|0)+48>>2]&15](a);do if((m|0)==(e|0)){k=e|0?e<<1:1;if((e|0)<(k|0)){if((k|0)!=0?(f[6472]=(f[6472]|0)+1,N=sc((k<<4|3)+16|0)|0,(N|0)!=0):0){f[(N+4+15&-16)+-4>>2]=N;i=N+4+15&-16}else i=0;if((e|0)<=0){if(!l)break}else{g=0;do{ca=i+(g<<4)|0;ba=l+(g<<4)|0;f[ca>>2]=f[ba>>2];f[ca+4>>2]=f[ba+4>>2];f[ca+8>>2]=f[ba+8>>2];f[ca+12>>2]=f[ba+12>>2];g=g+1|0}while((g|0)!=(e|0))}f[6473]=(f[6473]|0)+1;Cd(f[l+-4>>2]|0)}else{k=e;i=l}}else{k=e;i=l;e=m}while(0);ca=i+(e<<4)|0;f[ca>>2]=f[ja+136>>2];f[ca+4>>2]=f[ja+136+4>>2];f[ca+8>>2]=f[ja+136+8>>2];n[i+(e<<4)+12>>2]=o;m=m+1|0;if((m|0)<(c|0)){e=k;l=i}else break}if((m|0)>0){E=0;l=0;k=0;g=0;e=0;do{z=E;E=E+1|0;if((E|0)<(m|0)){A=E;do{y=A;A=A+1|0;if((A|0)<(m|0)){x=A;do{r=+n[i+(y<<4)+4>>2];o=+n[i+(x<<4)+8>>2];p=+n[i+(y<<4)+8>>2];t=+n[i+(x<<4)+4>>2];v=+n[i+(x<<4)>>2];B=+n[i+(y<<4)>>2];q=+n[i+(z<<4)+8>>2];C=+n[i+(z<<4)+4>>2];D=+n[i+(z<<4)>>2];d:do if((((t*B-r*v)*(t*B-r*v)+((r*o-p*t)*(r*o-p*t)+(p*v-o*B)*(p*v-o*B))>9.999999747378752e-05?(v*C-t*D)*(v*C-t*D)+((t*q-o*C)*(t*q-o*C)+(o*D-v*q)*(o*D-v*q))>9.999999747378752e-05:0)?(r*D-B*C)*(r*D-B*C)+((p*C-r*q)*(p*C-r*q)+(B*q-p*D)*(B*q-p*D))>9.999999747378752e-05:0)?(Y=q*(t*B-r*v)+(C*(p*v-o*B)+(r*o-p*t)*D),+K(+Y)>9.999999974752427e-07):0){J=+n[i+(z<<4)+12>>2];M=+n[i+(y<<4)+12>>2];I=+n[i+(x<<4)+12>>2];F=-1.0/Y*((p*C-r*q)*I+((r*o-p*t)*J+(t*q-o*C)*M));p=-1.0/Y*((B*q-p*D)*I+((p*v-o*B)*J+(o*D-v*q)*M));o=-1.0/Y*((r*D-B*C)*I+((t*B-r*v)*J+(v*C-t*D)*M));c=0;do{if(+n[i+(c<<4)+12>>2]+(F*+n[i+(c<<4)>>2]+p*+n[i+(c<<4)+4>>2]+o*+n[i+(c<<4)+8>>2])+-.009999999776482582>0.0)break d;c=c+1|0}while((c|0)<(m|0));do if((g|0)==(l|0)){w=l|0?l<<1:1;if((l|0)>=(w|0)){w=l;break}do if(!w)c=0;else{f[6472]=(f[6472]|0)+1;e=sc((w<<4|3)+16|0)|0;if(!e){c=0;break}f[(e+4+15&-16)+-4>>2]=e;c=e+4+15&-16}while(0);if((l|0)<=0){if(!k){k=c;e=c;break}}else{e=0;do{ca=c+(e<<4)|0;ba=k+(e<<4)|0;f[ca>>2]=f[ba>>2];f[ca+4>>2]=f[ba+4>>2];f[ca+8>>2]=f[ba+8>>2];f[ca+12>>2]=f[ba+12>>2];e=e+1|0}while((e|0)!=(l|0))}f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);k=c;e=c}else{w=l;l=g}while(0);n[k+(l<<4)>>2]=F;n[k+(l<<4)+4>>2]=p;n[k+(l<<4)+8>>2]=o;n[k+(l<<4)+12>>2]=0.0;l=w;g=g+1|0}while(0);x=x+1|0}while((x|0)!=(m|0))}}while((A|0)!=(m|0))}}while((E|0)!=(m|0))}else{k=0;g=0;e=0}}else{k=0;i=0;g=0;e=0}}else{k=0;i=0;h=0;g=0;e=0}uc(ja+76|0,e,g);if(k|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0)}if(i|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}if(h|0){f[6473]=(f[6473]|0)+1;Cd(f[h+-4>>2]|0)}}else uc(ja+76|0,e,H);G=f[ja+76+44>>2]|0;if((G|0)>0){f[6472]=(f[6472]|0)+1;e=sc((G<<4|3)+16|0)|0;if(!e)g=0;else{f[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}e=0;do{ca=g+(e<<4)|0;f[ca>>2]=f[ja+136>>2];f[ca+4>>2]=f[ja+136+4>>2];f[ca+8>>2]=f[ja+136+8>>2];f[ca+12>>2]=f[ja+136+12>>2];e=e+1|0}while((e|0)!=(G|0));ca=g;aa=g}else{ca=0;aa=0}b[ja+56+16>>0]=1;ba=ja+56+12|0;f[ba>>2]=0;$=ja+56+4|0;f[$>>2]=0;f[ja+56+8>>2]=0;h=ja+136|0;k=h+19|0;do{b[h>>0]=0;h=h+1|0}while((h|0)<(k|0));if((G|0)<0)jb();if(G|0){Kf(ja+56|0,G);g=f[ba>>2]|0;e=0;do{b[g+(e*36|0)+16>>0]=1;h=g+(e*36|0)+4|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;h=g+(e*36|0)+20|0;i=ja+136+3|0;k=h+16|0;do{b[h>>0]=b[i>>0]|0;h=h+1|0;i=i+1|0}while((h|0)<(k|0));e=e+1|0}while((e|0)!=(G|0))}f[$>>2]=G;l=f[ja+76+4>>2]|0;k=f[a+52>>2]|0;i=f[k+8>>2]|0;if((i|0)<(l|0)){if((f[k+12>>2]|0)<(l|0)){if(!l){e=0;h=i}else{f[6472]=(f[6472]|0)+1;e=sc((l<<4|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=f[k+8>>2]|0}if((h|0)>0){g=0;do{_=e+(g<<4)|0;Z=(f[k+16>>2]|0)+(g<<4)|0;f[_>>2]=f[Z>>2];f[_+4>>2]=f[Z+4>>2];f[_+8>>2]=f[Z+8>>2];f[_+12>>2]=f[Z+12>>2];g=g+1|0}while((g|0)!=(h|0))}g=f[k+16>>2]|0;if(g|0){if(b[k+20>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[g+-4>>2]|0)}f[k+16>>2]=0}b[k+20>>0]=1;f[k+16>>2]=e;f[k+12>>2]=l;g=k+16|0}else g=k+16|0;e=i;do{_=(f[g>>2]|0)+(e<<4)|0;f[_>>2]=f[ja+136>>2];f[_+4>>2]=f[ja+136+4>>2];f[_+8>>2]=f[ja+136+8>>2];f[_+12>>2]=f[ja+136+12>>2];e=e+1|0}while((e|0)!=(l|0))}f[k+8>>2]=l;if((l|0)>0){e=0;do{Z=(f[ha>>2]|0)+(e<<4)|0;_=(f[(f[a+52>>2]|0)+16>>2]|0)+(e<<4)|0;f[_>>2]=f[Z>>2];f[_+4>>2]=f[Z+4>>2];f[_+8>>2]=f[Z+8>>2];f[_+12>>2]=f[Z+12>>2];e=e+1|0}while((e|0)!=(l|0))}if((G|0)>0){E=0;do{z=(f[ga>>2]|0)+((f[(f[fa>>2]|0)+(E<<2)>>2]|0)*12|0)|0;y=z;e=0;do{A=y+4|0;x=f[y+((f[A>>2]|0)*12|0)+8>>2]|0;c=f[ba>>2]|0;w=c+(E*36|0)+4|0;g=f[w>>2]|0;m=c+(E*36|0)+8|0;if((g|0)==(f[m>>2]|0)?(O=g|0?g<<1:1,(g|0)<(O|0)):0){if(!O)l=0;else{f[6472]=(f[6472]|0)+1;g=sc((O<<2|3)+16|0)|0;if(!g)g=0;else{f[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=g;g=f[w>>2]|0}k=c+(E*36|0)+12|0;i=f[k>>2]|0;if((g|0)<=0)if(!i)h=c+(E*36|0)+16|0;else da=147;else{h=0;do{f[l+(h<<2)>>2]=f[i+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0));da=147}if((da|0)==147){da=0;g=c+(E*36|0)+16|0;if(b[g>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[i+-4>>2]|0)}f[k>>2]=0;h=g;g=f[w>>2]|0}b[h>>0]=1;f[k>>2]=l;f[m>>2]=O}f[(f[c+(E*36|0)+12>>2]|0)+(g<<2)>>2]=x;f[w>>2]=(f[w>>2]|0)+1;Z=f[y+8>>2]|0;_=f[ha>>2]|0;q=+n[_+(Z<<4)>>2]-+n[_+(x<<4)>>2];r=+n[_+(Z<<4)+4>>2]-+n[_+(x<<4)+4>>2];o=+n[_+(Z<<4)+8>>2]-+n[_+(x<<4)+8>>2];p=1.0/+L(+(q*q+r*r+o*o));if((e|0)<2){n[ja+136+(e<<4)>>2]=q*p;n[ja+136+(e<<4)+4>>2]=r*p;n[ja+136+(e<<4)+8>>2]=o*p;n[ja+136+(e<<4)+12>>2]=0.0;e=e+1|0}_=y+((f[A>>2]|0)*12|0)|0;y=_+((f[_>>2]|0)*12|0)|0}while((y|0)!=(z|0));if((e|0)==2){F=+n[ja+136+4>>2];I=+n[ja+136+24>>2];J=+n[ja+136+8>>2];M=+n[ja+136+20>>2];D=+n[ja+136+16>>2];C=+n[ja+136>>2];Z=ca+(E<<4)+4|0;_=ca+(E<<4)+8|0;n[ca+(E<<4)+12>>2]=0.0;Y=1.0/+L(+((F*I-J*M)*(F*I-J*M)+(J*D-I*C)*(J*D-I*C)+(M*C-F*D)*(M*C-F*D)));n[ca+(E<<4)>>2]=(F*I-J*M)*Y;n[Z>>2]=(J*D-I*C)*Y;n[_>>2]=(M*C-F*D)*Y;k=f[ba>>2]|0;n[k+(E*36|0)+20>>2]=(F*I-J*M)*Y;f[k+(E*36|0)+24>>2]=f[Z>>2];f[k+(E*36|0)+28>>2]=f[_>>2];n[k+(E*36|0)+32>>2]=1000000015047466219876688.0e6}else{k=ca+(E<<4)|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;k=f[ba>>2]|0}g=f[k+(E*36|0)+4>>2]|0;if((g|0)>0){h=f[(f[a+52>>2]|0)+16>>2]|0;p=+n[ca+(E<<4)>>2];q=+n[ca+(E<<4)+4>>2];r=+n[ca+(E<<4)+8>>2];i=f[k+(E*36|0)+12>>2]|0;_=f[i>>2]|0;o=+n[h+(_<<4)>>2]*p+ +n[h+(_<<4)+4>>2]*q+ +n[h+(_<<4)+8>>2]*r;o=o<1000000015047466219876688.0e6?o:1000000015047466219876688.0e6;if((g|0)!=1){e=1;do{_=f[i+(e<<2)>>2]|0;Y=+n[h+(_<<4)>>2]*p+ +n[h+(_<<4)+4>>2]*q+ +n[h+(_<<4)+8>>2]*r;o=o>Y?Y:o;e=e+1|0}while((e|0)<(g|0))}}else o=1000000015047466219876688.0e6;n[k+(E*36|0)+32>>2]=-o;E=E+1|0}while((E|0)!=(G|0))}if((f[$>>2]|0)>0){g=0;i=0;h=0;k=0;l=0;while(1){do if((l|0)==(g|0)){g=l|0?l<<1:1;if((l|0)<(g|0)){if((g|0)!=0?(f[6472]=(f[6472]|0)+1,P=sc((g<<2|3)+16|0)|0,(P|0)!=0):0){f[(P+4+15&-16)+-4>>2]=P;h=P+4+15&-16}else h=0;if((l|0)>0){e=0;do{f[h+(e<<2)>>2]=f[i+(e<<2)>>2];e=e+1|0}while((e|0)!=(l|0));if(!k){i=h;_=h;e=h;break}}else if((i|0)==0|(k|0)==0){i=h;_=h;e=h;break}f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);i=h;_=h;e=h}else{g=l;_=h;e=k}}else{_=h;e=k}while(0);f[i+(l<<2)>>2]=l;l=l+1|0;if((l|0)>=(f[$>>2]|0))break;else{h=_;k=e}}O=ja+36+12|0;P=ja+36+4|0;Q=ja+136+12|0;h=l;while(1){w=h+-1|0;g=f[i+(w<<2)>>2]|0;f[6472]=(f[6472]|0)+1;e=sc(23)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f[e>>2]=g;Z=f[ba>>2]|0;p=+n[Z+(g*36|0)+20>>2];q=+n[Z+(g*36|0)+24>>2];o=+n[Z+(g*36|0)+28>>2];e:do if((h|0)>1){l=w;g=e;c=e;k=1;m=e;e=1;y=w;while(1){h=k;z=e;f:while(1){e=f[ba>>2]|0;do{Z=l;l=l+-1|0;if((Z|0)<=0){N=g;H=m;G=z;h=y;break e}w=f[i+(l<<2)>>2]|0}while(!(p*+n[e+(w*36|0)+20>>2]+q*+n[e+(w*36|0)+24>>2]+o*+n[e+(w*36|0)+28>>2]>.9990000128746033));do if((z|0)==(h|0)){h=z|0?z<<1:1;if((z|0)<(h|0)){do if(!h)k=0;else{f[6472]=(f[6472]|0)+1;e=sc((h<<2|3)+16|0)|0;if(!e){k=0;break}f[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}while(0);if((z|0)>0){e=0;do{f[k+(e<<2)>>2]=f[m+(e<<2)>>2];e=e+1|0}while((e|0)!=(z|0));if(!c){x=h;m=k;g=k;c=k;break}}else if((m|0)==0|(c|0)==0){x=h;m=k;g=k;c=k;break}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);x=h;m=k;g=k;c=k}else x=z}else x=h;while(0);f[m+(z<<2)>>2]=w;z=z+1|0;e=0;while(1){k=i+(e<<2)|0;if((f[k>>2]|0)==(w|0))break;e=e+1|0;if((e|0)>=(y|0)){h=x;continue f}}if((e|0)<(y|0))break;else h=x}h=y+-1|0;Z=i+(h<<2)|0;f[k>>2]=f[Z>>2];f[Z>>2]=w;if((y|0)>1){k=x;e=z;y=h}else{k=x;e=z;da=177;break}}}else{l=w;g=e;c=e;k=1;m=e;e=1;h=w;da=177}while(0);g:do if((da|0)==177){da=0;y=e;while(1){e=f[ba>>2]|0;w=l;do{Z=w;w=w+-1|0;if((Z|0)<=0){N=g;H=m;G=y;break g}x=f[i+(w<<2)>>2]|0}while(!(p*+n[e+(x*36|0)+20>>2]+q*+n[e+(x*36|0)+24>>2]+o*+n[e+(x*36|0)+28>>2]>.9990000128746033));do if((y|0)==(k|0)){k=y|0?y<<1:1;if((y|0)<(k|0)){do if(!k)l=0;else{f[6472]=(f[6472]|0)+1;e=sc((k<<2|3)+16|0)|0;if(!e){l=0;break}f[(e+4+15&-16)+-4>>2]=e;l=e+4+15&-16}while(0);if((y|0)>0){e=0;do{f[l+(e<<2)>>2]=f[m+(e<<2)>>2];e=e+1|0}while((e|0)!=(y|0));if(!c){m=l;g=l;e=l;break}}else if((m|0)==0|(c|0)==0){m=l;g=l;e=l;break}f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0);m=l;g=l;e=l}else{k=y;e=c}}else e=c;while(0);f[m+(y<<2)>>2]=x;l=w;c=e;y=y+1|0}}while(0);if((G|0)>1){b[ja+36+16>>0]=1;f[O>>2]=0;f[P>>2]=0;f[ja+36+8>>2]=0;z=0;o=0.0;p=0.0;q=0.0;k=0;do{g=f[H+(z<<2)>>2]|0;o=+n[e+(g*36|0)+20>>2]+o;p=+n[e+(g*36|0)+24>>2]+p;q=+n[e+(g*36|0)+28>>2]+q;y=e+(g*36|0)+4|0;if((f[y>>2]|0)>0){x=e+(g*36|0)+12|0;w=0;e=k;while(1){c=f[(f[x>>2]|0)+(w<<2)>>2]|0;Z=(f[(f[a+52>>2]|0)+16>>2]|0)+(c<<4)|0;f[ja+136>>2]=f[Z>>2];f[ja+136+4>>2]=f[Z+4>>2];f[ja+136+8>>2]=f[Z+8>>2];f[ja+136+12>>2]=f[Z+12>>2];h:do if((e|0)>0){k=f[O>>2]|0;g=0;while(1){if((f[k+(g*24|0)+20>>2]|0)==(c|0))break h;g=g+1|0;if((g|0)>=(e|0)){da=264;break}}}else da=264;while(0);if((da|0)==264){da=0;f[ja>>2]=f[ja+136>>2];f[ja+4>>2]=f[ja+136+4>>2];f[ja+8>>2]=f[ja+136+8>>2];f[ja+12>>2]=f[ja+136+12>>2];do if((e|0)==(f[ja+36+8>>2]|0)){m=e|0?e<<1:1;if((e|0)>=(m|0))break;if(!m)l=0;else{f[6472]=(f[6472]|0)+1;e=sc((m*24|3)+16|0)|0;if(!e)e=0;else{f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}l=e;e=f[P>>2]|0}k=f[O>>2]|0;if((e|0)<=0){if(k)da=273}else{g=0;do{da=l+(g*24|0)|0;Z=k+(g*24|0)|0;f[da>>2]=f[Z>>2];f[da+4>>2]=f[Z+4>>2];f[da+8>>2]=f[Z+8>>2];f[da+12>>2]=f[Z+12>>2];f[da+16>>2]=f[Z+16>>2];f[da+20>>2]=f[Z+20>>2];g=g+1|0}while((g|0)!=(e|0));da=273}if((da|0)==273){da=0;if(b[ja+36+16>>0]|0){f[6473]=(f[6473]|0)+1;Cd(f[k+-4>>2]|0);e=f[P>>2]|0}f[O>>2]=0}b[ja+36+16>>0]=1;f[O>>2]=l;f[ja+36+8>>2]=m}while(0);Z=f[O>>2]|0;X=Z+(e*24|0)|0;f[X>>2]=f[ja>>2];f[X+4>>2]=f[ja+4>>2];f[X+8>>2]=f[ja+8>>2];f[X+12>>2]=f[ja+12>>2];f[X+16>>2]=f[ja+16>>2];f[Z+(e*24|0)+20>>2]=c;e=(f[P>>2]|0)+1|0;f[P>>2]=e}w=w+1|0;if((w|0)>=(f[y>>2]|0)){k=e;break}}}z=z+1|0;e=f[ba>>2]|0}while((z|0)!=(G|0));b[ja+16>>0]=1;f[ja+12>>2]=0;f[ja+4>>2]=0;f[ja+8>>2]=0;Z=f[H>>2]|0;f[ja+20>>2]=f[e+(Z*36|0)+20>>2];f[ja+24>>2]=f[e+(Z*36|0)+24>>2];f[ja+28>>2]=f[e+(Z*36|0)+28>>2];f[ja+32>>2]=f[e+(Z*36|0)+32>>2];t=1.0/+L(+(o*o+p*p+q*q));B=o*t;v=p*t;t=q*t;if(+K(+t)>.7071067690849304){r=1.0/+L(+(t*t+v*v));p=0.0;q=v*r;r=-(t*r)}else{r=1.0/+L(+(B*B+v*v));p=-(v*r);q=0.0;r=B*r}if((k|0)<2)if((k|0)==1){k=0;l=0;c=0;g=1;while(1){w=f[O>>2]|0;do if((k|0)==(l|0)){m=l|0?l<<1:1;if((l|0)>=(m|0)){m=l;e=c;break}do if(!m)e=0;else{f[6472]=(f[6472]|0)+1;e=sc((m*24|3)+16|0)|0;if(!e){e=0;l=k;break}f[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16;l=k}while(0);if((l|0)<=0){if(c|0)da=227}else{g=0;do{da=e+(g*24|0)|0;Z=c+(g*24|0)|0;f[da>>2]=f[Z>>2];f[da+4>>2]=f[Z+4>>2];f[da+8>>2]=f[Z+8>>2];f[da+12>>2]=f[Z+12>>2];f[da+16>>2]=f[Z+16>>2];f[da+20>>2]=f[Z+20>>2];g=g+1|0}while((g|0)!=(l|0));da=227}if((da|0)==227){da=0;f[6473]=(f[6473]|0)+1;Cd(f[c+-4>>2]|0)}l=k;g=f[P>>2]|0}else{m=l;e=c;l=k}while(0);Z=e+(l*24|0)|0;f[Z>>2]=f[w>>2];f[Z+4>>2]=f[w+4>>2];f[Z+8>>2]=f[w+8>>2];f[Z+12>>2]=f[w+12>>2];f[Z+16>>2]=f[w+16